# PyMieScatt

In addition to over twenty functions for Mie theory calculations, it contains an implementation of a highly visual method for solving the inverse Mie problem for the complex refractive index, given known or assumed size parameter and optical measurements.

## Dependencies

  * numpy
  * scipy
  * matplotlib
  * shapely

## Documentation

http://pymiescatt.readthedocs.io/en/latest

## Installation

	pip install PyMieScatt

Or clone from source and run

	python setup.py install

## Publications

  * [Sumlin B.J., Heinson W.R., and Chakrabarty R.K. (2018) Retrieving the Aerosol Complex Refractive Index using PyMieScatt: A Mie Computational Package with Visualization Capabilities. Journal of Quantitative Spectroscopy and Radiative Transfer](https://doi.org/10.1016/j.jqsrt.2017.10.012)
  
  * [Sumlin B.J., Pandey A., Walker M.J., Pattison R.S., Williams B.J., and Chakrabarty R.K. (2017) Atmospheric Photooxidation Diminishes Light Absorption by Primary Brown Carbon Aerosol from Biomass Burning, Environmental Science & Technology Letters](https://doi.org/10.1021/acs.estlett.7b00393)

  * [Sumlin B.J., Heinson, Y.W., Shetty N., Pandey A., Pattison, R.S., Baker S., Hao W.M, Chakrabarty R.K. (2018) UV–Vis–IR spectral complex refractive indices and optical properties of brown carbon aerosol from biomass burning, Journal of Quantitative Spectroscopy and Radiative Transfer](https://doi.org/10.1016/j.jqsrt.2017.12.009)
