from typing import Any as _py_Any
from typing import List as _py_List
from typing import TypeVar as _py_TypeVar
from typing import Type as _py_Type
from typing import ClassVar as _py_ClassVar
from typing import Generic as _py_Generic
from typing import overload
import java
import java.lang
import java.util
import java.util.concurrent
import java.util.function


class AbstractSpinedBuffer:
    MIN_CHUNK_POWER: _py_ClassVar[int] = ...
    MIN_CHUNK_SIZE: _py_ClassVar[int] = ...
    MAX_CHUNK_POWER: _py_ClassVar[int] = ...
    MIN_SPINE_SIZE: _py_ClassVar[int] = ...
    def clear(self) -> None: ...
    def count(self) -> int: ...
    def isEmpty(self) -> bool: ...

_AbstractTask__P_IN = _py_TypeVar('_AbstractTask__P_IN')  # <P_IN>
_AbstractTask__P_OUT = _py_TypeVar('_AbstractTask__P_OUT')  # <P_OUT>
_AbstractTask__R = _py_TypeVar('_AbstractTask__R')  # <R>
_AbstractTask__K = _py_TypeVar('_AbstractTask__K', bound='AbstractTask')  # <K>
class AbstractTask(java.util.concurrent.CountedCompleter[_AbstractTask__R], _py_Generic[_AbstractTask__P_IN, _AbstractTask__P_OUT, _AbstractTask__R, _AbstractTask__K]):
    def compute(self) -> None: ...
    def getRawResult(self) -> _AbstractTask__R: ...
    def onCompletion(self, countedCompleter: java.util.concurrent.CountedCompleter[_py_Any]) -> None: ...
    @classmethod
    def suggestTargetSize(cls, long: int) -> int: ...

_BaseStream__T = _py_TypeVar('_BaseStream__T')  # <T>
_BaseStream__S = _py_TypeVar('_BaseStream__S', bound='BaseStream')  # <S>
class BaseStream(java.lang.AutoCloseable, _py_Generic[_BaseStream__T, _BaseStream__S]):
    def close(self) -> None: ...
    def isParallel(self) -> bool: ...
    def iterator(self) -> java.util.Iterator[_BaseStream__T]: ...
    def onClose(self, runnable: java.lang.Runnable) -> _BaseStream__S: ...
    def parallel(self) -> _BaseStream__S: ...
    def sequential(self) -> _BaseStream__S: ...
    def spliterator(self) -> java.util.Spliterator[_BaseStream__T]: ...
    def unordered(self) -> _BaseStream__S: ...

_Collector__T = _py_TypeVar('_Collector__T')  # <T>
_Collector__A = _py_TypeVar('_Collector__A')  # <A>
_Collector__R = _py_TypeVar('_Collector__R')  # <R>
class Collector(_py_Generic[_Collector__T, _Collector__A, _Collector__R]):
    def accumulator(self) -> java.util.function.BiConsumer[_Collector__A, _Collector__T]: ...
    def characteristics(self) -> java.util.Set['Collector.Characteristics']: ...
    def combiner(self) -> java.util.function.BinaryOperator[_Collector__A]: ...
    def finisher(self) -> java.util.function.Function[_Collector__A, _Collector__R]: ...
    _of_0__T = _py_TypeVar('_of_0__T')  # <T>
    _of_0__A = _py_TypeVar('_of_0__A')  # <A>
    _of_0__R = _py_TypeVar('_of_0__R')  # <R>
    @classmethod
    @overload
    def of(cls, supplier: java.util.function.Supplier[_of_0__A], biConsumer: java.util.function.BiConsumer[_of_0__A, _of_0__T], binaryOperator: java.util.function.BinaryOperator[_of_0__A], function: java.util.function.Function[_of_0__A, _of_0__R], characteristicsArray: _py_List['Collector.Characteristics']) -> 'Collector'[_of_0__T, _of_0__A, _of_0__R]: ...
    _of_1__T = _py_TypeVar('_of_1__T')  # <T>
    _of_1__R = _py_TypeVar('_of_1__R')  # <R>
    @classmethod
    @overload
    def of(cls, supplier: java.util.function.Supplier[_of_1__R], biConsumer: java.util.function.BiConsumer[_of_1__R, _of_1__T], binaryOperator: java.util.function.BinaryOperator[_of_1__R], characteristicsArray: _py_List['Collector.Characteristics']) -> 'Collector'[_of_1__T, _of_1__R, _of_1__R]: ...
    def supplier(self) -> java.util.function.Supplier[_Collector__A]: ...
    class Characteristics(java.lang.Enum['Collector.Characteristics']):
        CONCURRENT: _py_ClassVar['Collector.Characteristics'] = ...
        UNORDERED: _py_ClassVar['Collector.Characteristics'] = ...
        IDENTITY_FINISH: _py_ClassVar['Collector.Characteristics'] = ...
        _valueOf_0__T = _py_TypeVar('_valueOf_0__T', bound=java.lang.Enum)  # <T>
        @classmethod
        @overload
        def valueOf(cls, class_: _py_Type[_valueOf_0__T], string: str) -> _valueOf_0__T: ...
        @classmethod
        @overload
        def valueOf(cls, string: str) -> 'Collector.Characteristics': ...
        @classmethod
        def values(cls) -> _py_List['Collector.Characteristics']: ...

class Collectors:
    _averagingDouble__T = _py_TypeVar('_averagingDouble__T')  # <T>
    @classmethod
    def averagingDouble(cls, toDoubleFunction: java.util.function.ToDoubleFunction[_averagingDouble__T]) -> Collector[_averagingDouble__T, _py_Any, float]: ...
    _averagingInt__T = _py_TypeVar('_averagingInt__T')  # <T>
    @classmethod
    def averagingInt(cls, toIntFunction: java.util.function.ToIntFunction[_averagingInt__T]) -> Collector[_averagingInt__T, _py_Any, float]: ...
    _averagingLong__T = _py_TypeVar('_averagingLong__T')  # <T>
    @classmethod
    def averagingLong(cls, toLongFunction: java.util.function.ToLongFunction[_averagingLong__T]) -> Collector[_averagingLong__T, _py_Any, float]: ...
    _collectingAndThen__T = _py_TypeVar('_collectingAndThen__T')  # <T>
    _collectingAndThen__A = _py_TypeVar('_collectingAndThen__A')  # <A>
    _collectingAndThen__R = _py_TypeVar('_collectingAndThen__R')  # <R>
    _collectingAndThen__RR = _py_TypeVar('_collectingAndThen__RR')  # <RR>
    @classmethod
    def collectingAndThen(cls, collector: Collector[_collectingAndThen__T, _collectingAndThen__A, _collectingAndThen__R], function: java.util.function.Function[_collectingAndThen__R, _collectingAndThen__RR]) -> Collector[_collectingAndThen__T, _collectingAndThen__A, _collectingAndThen__RR]: ...
    _counting__T = _py_TypeVar('_counting__T')  # <T>
    @classmethod
    def counting(cls) -> Collector[_counting__T, _py_Any, int]: ...
    _groupingBy_0__T = _py_TypeVar('_groupingBy_0__T')  # <T>
    _groupingBy_0__K = _py_TypeVar('_groupingBy_0__K')  # <K>
    @classmethod
    @overload
    def groupingBy(cls, function: java.util.function.Function[_groupingBy_0__T, _groupingBy_0__K]) -> Collector[_groupingBy_0__T, _py_Any, java.util.Map[_groupingBy_0__K, java.util.List[_groupingBy_0__T]]]: ...
    _groupingBy_1__T = _py_TypeVar('_groupingBy_1__T')  # <T>
    _groupingBy_1__K = _py_TypeVar('_groupingBy_1__K')  # <K>
    _groupingBy_1__D = _py_TypeVar('_groupingBy_1__D')  # <D>
    _groupingBy_1__A = _py_TypeVar('_groupingBy_1__A')  # <A>
    _groupingBy_1__M = _py_TypeVar('_groupingBy_1__M', bound=java.util.Map)  # <M>
    @classmethod
    @overload
    def groupingBy(cls, function: java.util.function.Function[_groupingBy_1__T, _groupingBy_1__K], supplier: java.util.function.Supplier[_groupingBy_1__M], collector: Collector[_groupingBy_1__T, _groupingBy_1__A, _groupingBy_1__D]) -> Collector[_groupingBy_1__T, _py_Any, _groupingBy_1__M]: ...
    _groupingBy_2__T = _py_TypeVar('_groupingBy_2__T')  # <T>
    _groupingBy_2__K = _py_TypeVar('_groupingBy_2__K')  # <K>
    _groupingBy_2__A = _py_TypeVar('_groupingBy_2__A')  # <A>
    _groupingBy_2__D = _py_TypeVar('_groupingBy_2__D')  # <D>
    @classmethod
    @overload
    def groupingBy(cls, function: java.util.function.Function[_groupingBy_2__T, _groupingBy_2__K], collector: Collector[_groupingBy_2__T, _groupingBy_2__A, _groupingBy_2__D]) -> Collector[_groupingBy_2__T, _py_Any, java.util.Map[_groupingBy_2__K, _groupingBy_2__D]]: ...
    _groupingByConcurrent_0__T = _py_TypeVar('_groupingByConcurrent_0__T')  # <T>
    _groupingByConcurrent_0__K = _py_TypeVar('_groupingByConcurrent_0__K')  # <K>
    @classmethod
    @overload
    def groupingByConcurrent(cls, function: java.util.function.Function[_groupingByConcurrent_0__T, _groupingByConcurrent_0__K]) -> Collector[_groupingByConcurrent_0__T, _py_Any, java.util.concurrent.ConcurrentMap[_groupingByConcurrent_0__K, java.util.List[_groupingByConcurrent_0__T]]]: ...
    _groupingByConcurrent_1__T = _py_TypeVar('_groupingByConcurrent_1__T')  # <T>
    _groupingByConcurrent_1__K = _py_TypeVar('_groupingByConcurrent_1__K')  # <K>
    _groupingByConcurrent_1__A = _py_TypeVar('_groupingByConcurrent_1__A')  # <A>
    _groupingByConcurrent_1__D = _py_TypeVar('_groupingByConcurrent_1__D')  # <D>
    _groupingByConcurrent_1__M = _py_TypeVar('_groupingByConcurrent_1__M', bound=java.util.concurrent.ConcurrentMap)  # <M>
    @classmethod
    @overload
    def groupingByConcurrent(cls, function: java.util.function.Function[_groupingByConcurrent_1__T, _groupingByConcurrent_1__K], supplier: java.util.function.Supplier[_groupingByConcurrent_1__M], collector: Collector[_groupingByConcurrent_1__T, _groupingByConcurrent_1__A, _groupingByConcurrent_1__D]) -> Collector[_groupingByConcurrent_1__T, _py_Any, _groupingByConcurrent_1__M]: ...
    _groupingByConcurrent_2__T = _py_TypeVar('_groupingByConcurrent_2__T')  # <T>
    _groupingByConcurrent_2__K = _py_TypeVar('_groupingByConcurrent_2__K')  # <K>
    _groupingByConcurrent_2__A = _py_TypeVar('_groupingByConcurrent_2__A')  # <A>
    _groupingByConcurrent_2__D = _py_TypeVar('_groupingByConcurrent_2__D')  # <D>
    @classmethod
    @overload
    def groupingByConcurrent(cls, function: java.util.function.Function[_groupingByConcurrent_2__T, _groupingByConcurrent_2__K], collector: Collector[_groupingByConcurrent_2__T, _groupingByConcurrent_2__A, _groupingByConcurrent_2__D]) -> Collector[_groupingByConcurrent_2__T, _py_Any, java.util.concurrent.ConcurrentMap[_groupingByConcurrent_2__K, _groupingByConcurrent_2__D]]: ...
    @classmethod
    @overload
    def joining(cls) -> Collector[java.lang.CharSequence, _py_Any, str]: ...
    @classmethod
    @overload
    def joining(cls, charSequence: java.lang.CharSequence) -> Collector[java.lang.CharSequence, _py_Any, str]: ...
    @classmethod
    @overload
    def joining(cls, charSequence: java.lang.CharSequence, charSequence2: java.lang.CharSequence, charSequence3: java.lang.CharSequence) -> Collector[java.lang.CharSequence, _py_Any, str]: ...
    _mapping__T = _py_TypeVar('_mapping__T')  # <T>
    _mapping__U = _py_TypeVar('_mapping__U')  # <U>
    _mapping__A = _py_TypeVar('_mapping__A')  # <A>
    _mapping__R = _py_TypeVar('_mapping__R')  # <R>
    @classmethod
    def mapping(cls, function: java.util.function.Function[_mapping__T, _mapping__U], collector: Collector[_mapping__U, _mapping__A, _mapping__R]) -> Collector[_mapping__T, _py_Any, _mapping__R]: ...
    _maxBy__T = _py_TypeVar('_maxBy__T')  # <T>
    @classmethod
    def maxBy(cls, comparator: java.util.Comparator[_maxBy__T]) -> Collector[_maxBy__T, _py_Any, java.util.Optional[_maxBy__T]]: ...
    _minBy__T = _py_TypeVar('_minBy__T')  # <T>
    @classmethod
    def minBy(cls, comparator: java.util.Comparator[_minBy__T]) -> Collector[_minBy__T, _py_Any, java.util.Optional[_minBy__T]]: ...
    _partitioningBy_0__T = _py_TypeVar('_partitioningBy_0__T')  # <T>
    @classmethod
    @overload
    def partitioningBy(cls, predicate: java.util.function.Predicate[_partitioningBy_0__T]) -> Collector[_partitioningBy_0__T, _py_Any, java.util.Map[bool, java.util.List[_partitioningBy_0__T]]]: ...
    _partitioningBy_1__T = _py_TypeVar('_partitioningBy_1__T')  # <T>
    _partitioningBy_1__D = _py_TypeVar('_partitioningBy_1__D')  # <D>
    _partitioningBy_1__A = _py_TypeVar('_partitioningBy_1__A')  # <A>
    @classmethod
    @overload
    def partitioningBy(cls, predicate: java.util.function.Predicate[_partitioningBy_1__T], collector: Collector[_partitioningBy_1__T, _partitioningBy_1__A, _partitioningBy_1__D]) -> Collector[_partitioningBy_1__T, _py_Any, java.util.Map[bool, _partitioningBy_1__D]]: ...
    _reducing_0__T = _py_TypeVar('_reducing_0__T')  # <T>
    @classmethod
    @overload
    def reducing(cls, t: _reducing_0__T, binaryOperator: java.util.function.BinaryOperator[_reducing_0__T]) -> Collector[_reducing_0__T, _py_Any, _reducing_0__T]: ...
    _reducing_1__T = _py_TypeVar('_reducing_1__T')  # <T>
    _reducing_1__U = _py_TypeVar('_reducing_1__U')  # <U>
    @classmethod
    @overload
    def reducing(cls, u: _reducing_1__U, function: java.util.function.Function[_reducing_1__T, _reducing_1__U], binaryOperator: java.util.function.BinaryOperator[_reducing_1__U]) -> Collector[_reducing_1__T, _py_Any, _reducing_1__U]: ...
    _reducing_2__T = _py_TypeVar('_reducing_2__T')  # <T>
    @classmethod
    @overload
    def reducing(cls, binaryOperator: java.util.function.BinaryOperator[_reducing_2__T]) -> Collector[_reducing_2__T, _py_Any, java.util.Optional[_reducing_2__T]]: ...
    _summarizingDouble__T = _py_TypeVar('_summarizingDouble__T')  # <T>
    @classmethod
    def summarizingDouble(cls, toDoubleFunction: java.util.function.ToDoubleFunction[_summarizingDouble__T]) -> Collector[_summarizingDouble__T, _py_Any, java.util.DoubleSummaryStatistics]: ...
    _summarizingInt__T = _py_TypeVar('_summarizingInt__T')  # <T>
    @classmethod
    def summarizingInt(cls, toIntFunction: java.util.function.ToIntFunction[_summarizingInt__T]) -> Collector[_summarizingInt__T, _py_Any, java.util.IntSummaryStatistics]: ...
    _summarizingLong__T = _py_TypeVar('_summarizingLong__T')  # <T>
    @classmethod
    def summarizingLong(cls, toLongFunction: java.util.function.ToLongFunction[_summarizingLong__T]) -> Collector[_summarizingLong__T, _py_Any, java.util.LongSummaryStatistics]: ...
    _summingDouble__T = _py_TypeVar('_summingDouble__T')  # <T>
    @classmethod
    def summingDouble(cls, toDoubleFunction: java.util.function.ToDoubleFunction[_summingDouble__T]) -> Collector[_summingDouble__T, _py_Any, float]: ...
    _summingInt__T = _py_TypeVar('_summingInt__T')  # <T>
    @classmethod
    def summingInt(cls, toIntFunction: java.util.function.ToIntFunction[_summingInt__T]) -> Collector[_summingInt__T, _py_Any, int]: ...
    _summingLong__T = _py_TypeVar('_summingLong__T')  # <T>
    @classmethod
    def summingLong(cls, toLongFunction: java.util.function.ToLongFunction[_summingLong__T]) -> Collector[_summingLong__T, _py_Any, int]: ...
    _toCollection__T = _py_TypeVar('_toCollection__T')  # <T>
    _toCollection__C = _py_TypeVar('_toCollection__C', bound=java.util.Collection)  # <C>
    @classmethod
    def toCollection(cls, supplier: java.util.function.Supplier[_toCollection__C]) -> Collector[_toCollection__T, _py_Any, _toCollection__C]: ...
    _toConcurrentMap_0__T = _py_TypeVar('_toConcurrentMap_0__T')  # <T>
    _toConcurrentMap_0__K = _py_TypeVar('_toConcurrentMap_0__K')  # <K>
    _toConcurrentMap_0__U = _py_TypeVar('_toConcurrentMap_0__U')  # <U>
    @classmethod
    @overload
    def toConcurrentMap(cls, function: java.util.function.Function[_toConcurrentMap_0__T, _toConcurrentMap_0__K], function2: java.util.function.Function[_toConcurrentMap_0__T, _toConcurrentMap_0__U]) -> Collector[_toConcurrentMap_0__T, _py_Any, java.util.concurrent.ConcurrentMap[_toConcurrentMap_0__K, _toConcurrentMap_0__U]]: ...
    _toConcurrentMap_1__T = _py_TypeVar('_toConcurrentMap_1__T')  # <T>
    _toConcurrentMap_1__K = _py_TypeVar('_toConcurrentMap_1__K')  # <K>
    _toConcurrentMap_1__U = _py_TypeVar('_toConcurrentMap_1__U')  # <U>
    @classmethod
    @overload
    def toConcurrentMap(cls, function: java.util.function.Function[_toConcurrentMap_1__T, _toConcurrentMap_1__K], function2: java.util.function.Function[_toConcurrentMap_1__T, _toConcurrentMap_1__U], binaryOperator: java.util.function.BinaryOperator[_toConcurrentMap_1__U]) -> Collector[_toConcurrentMap_1__T, _py_Any, java.util.concurrent.ConcurrentMap[_toConcurrentMap_1__K, _toConcurrentMap_1__U]]: ...
    _toConcurrentMap_2__T = _py_TypeVar('_toConcurrentMap_2__T')  # <T>
    _toConcurrentMap_2__K = _py_TypeVar('_toConcurrentMap_2__K')  # <K>
    _toConcurrentMap_2__U = _py_TypeVar('_toConcurrentMap_2__U')  # <U>
    _toConcurrentMap_2__M = _py_TypeVar('_toConcurrentMap_2__M', bound=java.util.concurrent.ConcurrentMap)  # <M>
    @classmethod
    @overload
    def toConcurrentMap(cls, function: java.util.function.Function[_toConcurrentMap_2__T, _toConcurrentMap_2__K], function2: java.util.function.Function[_toConcurrentMap_2__T, _toConcurrentMap_2__U], binaryOperator: java.util.function.BinaryOperator[_toConcurrentMap_2__U], supplier: java.util.function.Supplier[_toConcurrentMap_2__M]) -> Collector[_toConcurrentMap_2__T, _py_Any, _toConcurrentMap_2__M]: ...
    _toList__T = _py_TypeVar('_toList__T')  # <T>
    @classmethod
    def toList(cls) -> Collector[_toList__T, _py_Any, java.util.List[_toList__T]]: ...
    _toMap_0__T = _py_TypeVar('_toMap_0__T')  # <T>
    _toMap_0__K = _py_TypeVar('_toMap_0__K')  # <K>
    _toMap_0__U = _py_TypeVar('_toMap_0__U')  # <U>
    @classmethod
    @overload
    def toMap(cls, function: java.util.function.Function[_toMap_0__T, _toMap_0__K], function2: java.util.function.Function[_toMap_0__T, _toMap_0__U]) -> Collector[_toMap_0__T, _py_Any, java.util.Map[_toMap_0__K, _toMap_0__U]]: ...
    _toMap_1__T = _py_TypeVar('_toMap_1__T')  # <T>
    _toMap_1__K = _py_TypeVar('_toMap_1__K')  # <K>
    _toMap_1__U = _py_TypeVar('_toMap_1__U')  # <U>
    @classmethod
    @overload
    def toMap(cls, function: java.util.function.Function[_toMap_1__T, _toMap_1__K], function2: java.util.function.Function[_toMap_1__T, _toMap_1__U], binaryOperator: java.util.function.BinaryOperator[_toMap_1__U]) -> Collector[_toMap_1__T, _py_Any, java.util.Map[_toMap_1__K, _toMap_1__U]]: ...
    _toMap_2__T = _py_TypeVar('_toMap_2__T')  # <T>
    _toMap_2__K = _py_TypeVar('_toMap_2__K')  # <K>
    _toMap_2__U = _py_TypeVar('_toMap_2__U')  # <U>
    _toMap_2__M = _py_TypeVar('_toMap_2__M', bound=java.util.Map)  # <M>
    @classmethod
    @overload
    def toMap(cls, function: java.util.function.Function[_toMap_2__T, _toMap_2__K], function2: java.util.function.Function[_toMap_2__T, _toMap_2__U], binaryOperator: java.util.function.BinaryOperator[_toMap_2__U], supplier: java.util.function.Supplier[_toMap_2__M]) -> Collector[_toMap_2__T, _py_Any, _toMap_2__M]: ...
    _toSet__T = _py_TypeVar('_toSet__T')  # <T>
    @classmethod
    def toSet(cls) -> Collector[_toSet__T, _py_Any, java.util.Set[_toSet__T]]: ...

class DistinctOps: ...

class FindOps:
    @classmethod
    def makeDouble(cls, boolean: bool) -> 'TerminalOp'[float, java.util.OptionalDouble]: ...
    @classmethod
    def makeInt(cls, boolean: bool) -> 'TerminalOp'[int, java.util.OptionalInt]: ...
    @classmethod
    def makeLong(cls, boolean: bool) -> 'TerminalOp'[int, java.util.OptionalLong]: ...
    _makeRef__T = _py_TypeVar('_makeRef__T')  # <T>
    @classmethod
    def makeRef(cls, boolean: bool) -> 'TerminalOp'[_makeRef__T, java.util.Optional[_makeRef__T]]: ...

class ForEachOps:
    @classmethod
    def makeDouble(cls, doubleConsumer: java.util.function.DoubleConsumer, boolean: bool) -> 'TerminalOp'[float, java.lang.Void]: ...
    @classmethod
    def makeInt(cls, intConsumer: java.util.function.IntConsumer, boolean: bool) -> 'TerminalOp'[int, java.lang.Void]: ...
    @classmethod
    def makeLong(cls, longConsumer: java.util.function.LongConsumer, boolean: bool) -> 'TerminalOp'[int, java.lang.Void]: ...
    _makeRef__T = _py_TypeVar('_makeRef__T')  # <T>
    @classmethod
    def makeRef(cls, consumer: java.util.function.Consumer[_makeRef__T], boolean: bool) -> 'TerminalOp'[_makeRef__T, java.lang.Void]: ...

class MatchOps:
    @classmethod
    def makeDouble(cls, doublePredicate: java.util.function.DoublePredicate, matchKind: 'MatchOps.MatchKind') -> 'TerminalOp'[float, bool]: ...
    @classmethod
    def makeInt(cls, intPredicate: java.util.function.IntPredicate, matchKind: 'MatchOps.MatchKind') -> 'TerminalOp'[int, bool]: ...
    @classmethod
    def makeLong(cls, longPredicate: java.util.function.LongPredicate, matchKind: 'MatchOps.MatchKind') -> 'TerminalOp'[int, bool]: ...
    _makeRef__T = _py_TypeVar('_makeRef__T')  # <T>
    @classmethod
    def makeRef(cls, predicate: java.util.function.Predicate[_makeRef__T], matchKind: 'MatchOps.MatchKind') -> 'TerminalOp'[_makeRef__T, bool]: ...
    class MatchKind(java.lang.Enum['MatchOps.MatchKind']):
        ANY: _py_ClassVar['MatchOps.MatchKind'] = ...
        ALL: _py_ClassVar['MatchOps.MatchKind'] = ...
        NONE: _py_ClassVar['MatchOps.MatchKind'] = ...
        _valueOf_0__T = _py_TypeVar('_valueOf_0__T', bound=java.lang.Enum)  # <T>
        @classmethod
        @overload
        def valueOf(cls, class_: _py_Type[_valueOf_0__T], string: str) -> _valueOf_0__T: ...
        @classmethod
        @overload
        def valueOf(cls, string: str) -> 'MatchOps.MatchKind': ...
        @classmethod
        def values(cls) -> _py_List['MatchOps.MatchKind']: ...

class Nodes:
    _collect__P_IN = _py_TypeVar('_collect__P_IN')  # <P_IN>
    _collect__P_OUT = _py_TypeVar('_collect__P_OUT')  # <P_OUT>
    @classmethod
    def collect(cls, pipelineHelper: 'PipelineHelper'[_collect__P_OUT], spliterator: java.util.Spliterator[_collect__P_IN], boolean: bool, intFunction: java.util.function.IntFunction[_py_List[_collect__P_OUT]]) -> 'Node'[_collect__P_OUT]: ...
    _collectDouble__P_IN = _py_TypeVar('_collectDouble__P_IN')  # <P_IN>
    @classmethod
    def collectDouble(cls, pipelineHelper: 'PipelineHelper'[float], spliterator: java.util.Spliterator[_collectDouble__P_IN], boolean: bool) -> 'Node.OfDouble': ...
    _collectInt__P_IN = _py_TypeVar('_collectInt__P_IN')  # <P_IN>
    @classmethod
    def collectInt(cls, pipelineHelper: 'PipelineHelper'[int], spliterator: java.util.Spliterator[_collectInt__P_IN], boolean: bool) -> 'Node.OfInt': ...
    _collectLong__P_IN = _py_TypeVar('_collectLong__P_IN')  # <P_IN>
    @classmethod
    def collectLong(cls, pipelineHelper: 'PipelineHelper'[int], spliterator: java.util.Spliterator[_collectLong__P_IN], boolean: bool) -> 'Node.OfLong': ...
    _flatten__T = _py_TypeVar('_flatten__T')  # <T>
    @classmethod
    def flatten(cls, node: 'Node'[_flatten__T], intFunction: java.util.function.IntFunction[_py_List[_flatten__T]]) -> 'Node'[_flatten__T]: ...
    @classmethod
    def flattenDouble(cls, ofDouble: 'Node.OfDouble') -> 'Node.OfDouble': ...
    @classmethod
    def flattenInt(cls, ofInt: 'Node.OfInt') -> 'Node.OfInt': ...
    @classmethod
    def flattenLong(cls, ofLong: 'Node.OfLong') -> 'Node.OfLong': ...

_PipelineHelper__P_OUT = _py_TypeVar('_PipelineHelper__P_OUT')  # <P_OUT>
class PipelineHelper(_py_Generic[_PipelineHelper__P_OUT]): ...

class ReduceOps:
    @classmethod
    @overload
    def makeDouble(cls, double: float, doubleBinaryOperator: java.util.function.DoubleBinaryOperator) -> 'TerminalOp'[float, float]: ...
    @classmethod
    @overload
    def makeDouble(cls, doubleBinaryOperator: java.util.function.DoubleBinaryOperator) -> 'TerminalOp'[float, java.util.OptionalDouble]: ...
    _makeDouble_2__R = _py_TypeVar('_makeDouble_2__R')  # <R>
    @classmethod
    @overload
    def makeDouble(cls, supplier: java.util.function.Supplier[_makeDouble_2__R], objDoubleConsumer: java.util.function.ObjDoubleConsumer[_makeDouble_2__R], binaryOperator: java.util.function.BinaryOperator[_makeDouble_2__R]) -> 'TerminalOp'[float, _makeDouble_2__R]: ...
    @classmethod
    @overload
    def makeInt(cls, int: int, intBinaryOperator: java.util.function.IntBinaryOperator) -> 'TerminalOp'[int, int]: ...
    @classmethod
    @overload
    def makeInt(cls, intBinaryOperator: java.util.function.IntBinaryOperator) -> 'TerminalOp'[int, java.util.OptionalInt]: ...
    _makeInt_2__R = _py_TypeVar('_makeInt_2__R')  # <R>
    @classmethod
    @overload
    def makeInt(cls, supplier: java.util.function.Supplier[_makeInt_2__R], objIntConsumer: java.util.function.ObjIntConsumer[_makeInt_2__R], binaryOperator: java.util.function.BinaryOperator[_makeInt_2__R]) -> 'TerminalOp'[int, _makeInt_2__R]: ...
    @classmethod
    @overload
    def makeLong(cls, longBinaryOperator: java.util.function.LongBinaryOperator) -> 'TerminalOp'[int, java.util.OptionalLong]: ...
    _makeLong_1__R = _py_TypeVar('_makeLong_1__R')  # <R>
    @classmethod
    @overload
    def makeLong(cls, supplier: java.util.function.Supplier[_makeLong_1__R], objLongConsumer: java.util.function.ObjLongConsumer[_makeLong_1__R], binaryOperator: java.util.function.BinaryOperator[_makeLong_1__R]) -> 'TerminalOp'[int, _makeLong_1__R]: ...
    @classmethod
    @overload
    def makeLong(cls, long: int, longBinaryOperator: java.util.function.LongBinaryOperator) -> 'TerminalOp'[int, int]: ...
    _makeRef_0__T = _py_TypeVar('_makeRef_0__T')  # <T>
    _makeRef_0__U = _py_TypeVar('_makeRef_0__U')  # <U>
    @classmethod
    @overload
    def makeRef(cls, u: _makeRef_0__U, biFunction: java.util.function.BiFunction[_makeRef_0__U, _makeRef_0__T, _makeRef_0__U], binaryOperator: java.util.function.BinaryOperator[_makeRef_0__U]) -> 'TerminalOp'[_makeRef_0__T, _makeRef_0__U]: ...
    _makeRef_1__T = _py_TypeVar('_makeRef_1__T')  # <T>
    @classmethod
    @overload
    def makeRef(cls, binaryOperator: java.util.function.BinaryOperator[_makeRef_1__T]) -> 'TerminalOp'[_makeRef_1__T, java.util.Optional[_makeRef_1__T]]: ...
    _makeRef_2__T = _py_TypeVar('_makeRef_2__T')  # <T>
    _makeRef_2__R = _py_TypeVar('_makeRef_2__R')  # <R>
    @classmethod
    @overload
    def makeRef(cls, supplier: java.util.function.Supplier[_makeRef_2__R], biConsumer: java.util.function.BiConsumer[_makeRef_2__R, _makeRef_2__T], biConsumer2: java.util.function.BiConsumer[_makeRef_2__R, _makeRef_2__R]) -> 'TerminalOp'[_makeRef_2__T, _makeRef_2__R]: ...
    _makeRef_3__T = _py_TypeVar('_makeRef_3__T')  # <T>
    _makeRef_3__I = _py_TypeVar('_makeRef_3__I')  # <I>
    @classmethod
    @overload
    def makeRef(cls, collector: Collector[_makeRef_3__T, _makeRef_3__I, _py_Any]) -> 'TerminalOp'[_makeRef_3__T, _makeRef_3__I]: ...

class SliceOps:
    @classmethod
    def makeDouble(cls, abstractPipeline: 'AbstractPipeline'[_py_Any, float, _py_Any], long: int, long2: int) -> 'DoubleStream': ...
    @classmethod
    def makeInt(cls, abstractPipeline: 'AbstractPipeline'[_py_Any, int, _py_Any], long: int, long2: int) -> 'IntStream': ...
    @classmethod
    def makeLong(cls, abstractPipeline: 'AbstractPipeline'[_py_Any, int, _py_Any], long: int, long2: int) -> 'LongStream': ...
    _makeRef__T = _py_TypeVar('_makeRef__T')  # <T>
    @classmethod
    def makeRef(cls, abstractPipeline: 'AbstractPipeline'[_py_Any, _makeRef__T, _py_Any], long: int, long2: int) -> 'Stream'[_makeRef__T]: ...

class SortedOps: ...

class StreamOpFlag(java.lang.Enum['StreamOpFlag']):
    DISTINCT: _py_ClassVar['StreamOpFlag'] = ...
    SORTED: _py_ClassVar['StreamOpFlag'] = ...
    ORDERED: _py_ClassVar['StreamOpFlag'] = ...
    SIZED: _py_ClassVar['StreamOpFlag'] = ...
    SHORT_CIRCUIT: _py_ClassVar['StreamOpFlag'] = ...
    _valueOf_0__T = _py_TypeVar('_valueOf_0__T', bound=java.lang.Enum)  # <T>
    @classmethod
    @overload
    def valueOf(cls, class_: _py_Type[_valueOf_0__T], string: str) -> _valueOf_0__T: ...
    @classmethod
    @overload
    def valueOf(cls, string: str) -> 'StreamOpFlag': ...
    @classmethod
    def values(cls) -> _py_List['StreamOpFlag']: ...

class StreamShape(java.lang.Enum['StreamShape']):
    REFERENCE: _py_ClassVar['StreamShape'] = ...
    INT_VALUE: _py_ClassVar['StreamShape'] = ...
    LONG_VALUE: _py_ClassVar['StreamShape'] = ...
    DOUBLE_VALUE: _py_ClassVar['StreamShape'] = ...
    _valueOf_0__T = _py_TypeVar('_valueOf_0__T', bound=java.lang.Enum)  # <T>
    @classmethod
    @overload
    def valueOf(cls, class_: _py_Type[_valueOf_0__T], string: str) -> _valueOf_0__T: ...
    @classmethod
    @overload
    def valueOf(cls, string: str) -> 'StreamShape': ...
    @classmethod
    def values(cls) -> _py_List['StreamShape']: ...

class StreamSpliterators: ...

class StreamSupport:
    @classmethod
    @overload
    def doubleStream(cls, ofDouble: java.util.Spliterator.OfDouble, boolean: bool) -> 'DoubleStream': ...
    @classmethod
    @overload
    def doubleStream(cls, supplier: java.util.function.Supplier[java.util.Spliterator.OfDouble], int: int, boolean: bool) -> 'DoubleStream': ...
    @classmethod
    @overload
    def intStream(cls, ofInt: java.util.Spliterator.OfInt, boolean: bool) -> 'IntStream': ...
    @classmethod
    @overload
    def intStream(cls, supplier: java.util.function.Supplier[java.util.Spliterator.OfInt], int: int, boolean: bool) -> 'IntStream': ...
    @classmethod
    @overload
    def longStream(cls, ofLong: java.util.Spliterator.OfLong, boolean: bool) -> 'LongStream': ...
    @classmethod
    @overload
    def longStream(cls, supplier: java.util.function.Supplier[java.util.Spliterator.OfLong], int: int, boolean: bool) -> 'LongStream': ...
    _stream_0__T = _py_TypeVar('_stream_0__T')  # <T>
    @classmethod
    @overload
    def stream(cls, spliterator: java.util.Spliterator[_stream_0__T], boolean: bool) -> 'Stream'[_stream_0__T]: ...
    _stream_1__T = _py_TypeVar('_stream_1__T')  # <T>
    @classmethod
    @overload
    def stream(cls, supplier: java.util.function.Supplier[java.util.Spliterator[_stream_1__T]], int: int, boolean: bool) -> 'Stream'[_stream_1__T]: ...

class Streams: ...

_TerminalOp__E_IN = _py_TypeVar('_TerminalOp__E_IN')  # <E_IN>
_TerminalOp__R = _py_TypeVar('_TerminalOp__R')  # <R>
class TerminalOp(_py_Generic[_TerminalOp__E_IN, _TerminalOp__R]):
    _evaluateParallel__P_IN = _py_TypeVar('_evaluateParallel__P_IN')  # <P_IN>
    def evaluateParallel(self, pipelineHelper: PipelineHelper[_TerminalOp__E_IN], spliterator: java.util.Spliterator[_evaluateParallel__P_IN]) -> _TerminalOp__R: ...
    _evaluateSequential__P_IN = _py_TypeVar('_evaluateSequential__P_IN')  # <P_IN>
    def evaluateSequential(self, pipelineHelper: PipelineHelper[_TerminalOp__E_IN], spliterator: java.util.Spliterator[_evaluateSequential__P_IN]) -> _TerminalOp__R: ...
    def getOpFlags(self) -> int: ...
    def inputShape(self) -> StreamShape: ...

class Tripwire: ...

_AbstractPipeline__E_IN = _py_TypeVar('_AbstractPipeline__E_IN')  # <E_IN>
_AbstractPipeline__E_OUT = _py_TypeVar('_AbstractPipeline__E_OUT')  # <E_OUT>
_AbstractPipeline__S = _py_TypeVar('_AbstractPipeline__S', bound=BaseStream)  # <S>
class AbstractPipeline(PipelineHelper[_AbstractPipeline__E_OUT], BaseStream[_AbstractPipeline__E_OUT, _AbstractPipeline__S], _py_Generic[_AbstractPipeline__E_IN, _AbstractPipeline__E_OUT, _AbstractPipeline__S]):
    def close(self) -> None: ...
    def isParallel(self) -> bool: ...
    def onClose(self, runnable: java.lang.Runnable) -> _AbstractPipeline__S: ...
    def parallel(self) -> _AbstractPipeline__S: ...
    def sequential(self) -> _AbstractPipeline__S: ...
    def spliterator(self) -> java.util.Spliterator[_AbstractPipeline__E_OUT]: ...

_AbstractShortCircuitTask__P_IN = _py_TypeVar('_AbstractShortCircuitTask__P_IN')  # <P_IN>
_AbstractShortCircuitTask__P_OUT = _py_TypeVar('_AbstractShortCircuitTask__P_OUT')  # <P_OUT>
_AbstractShortCircuitTask__R = _py_TypeVar('_AbstractShortCircuitTask__R')  # <R>
_AbstractShortCircuitTask__K = _py_TypeVar('_AbstractShortCircuitTask__K', bound='AbstractShortCircuitTask')  # <K>
class AbstractShortCircuitTask(AbstractTask[_AbstractShortCircuitTask__P_IN, _AbstractShortCircuitTask__P_OUT, _AbstractShortCircuitTask__R, _AbstractShortCircuitTask__K], _py_Generic[_AbstractShortCircuitTask__P_IN, _AbstractShortCircuitTask__P_OUT, _AbstractShortCircuitTask__R, _AbstractShortCircuitTask__K]):
    def compute(self) -> None: ...
    def getLocalResult(self) -> _AbstractShortCircuitTask__R: ...
    def getRawResult(self) -> _AbstractShortCircuitTask__R: ...

class DoubleStream(BaseStream[float, 'DoubleStream']):
    def allMatch(self, doublePredicate: java.util.function.DoublePredicate) -> bool: ...
    def anyMatch(self, doublePredicate: java.util.function.DoublePredicate) -> bool: ...
    def average(self) -> java.util.OptionalDouble: ...
    def boxed(self) -> 'Stream'[float]: ...
    @classmethod
    def builder(cls) -> 'DoubleStream.Builder': ...
    _collect__R = _py_TypeVar('_collect__R')  # <R>
    def collect(self, supplier: java.util.function.Supplier[_collect__R], objDoubleConsumer: java.util.function.ObjDoubleConsumer[_collect__R], biConsumer: java.util.function.BiConsumer[_collect__R, _collect__R]) -> _collect__R: ...
    @classmethod
    def concat(cls, doubleStream: 'DoubleStream', doubleStream2: 'DoubleStream') -> 'DoubleStream': ...
    def count(self) -> int: ...
    def distinct(self) -> 'DoubleStream': ...
    @classmethod
    def empty(cls) -> 'DoubleStream': ...
    def filter(self, doublePredicate: java.util.function.DoublePredicate) -> 'DoubleStream': ...
    def findAny(self) -> java.util.OptionalDouble: ...
    def findFirst(self) -> java.util.OptionalDouble: ...
    def flatMap(self, doubleFunction: java.util.function.DoubleFunction['DoubleStream']) -> 'DoubleStream': ...
    def forEach(self, doubleConsumer: java.util.function.DoubleConsumer) -> None: ...
    def forEachOrdered(self, doubleConsumer: java.util.function.DoubleConsumer) -> None: ...
    @classmethod
    def generate(cls, doubleSupplier: java.util.function.DoubleSupplier) -> 'DoubleStream': ...
    @classmethod
    def iterate(cls, double: float, doubleUnaryOperator: java.util.function.DoubleUnaryOperator) -> 'DoubleStream': ...
    @overload
    def iterator(self) -> java.util.PrimitiveIterator.OfDouble: ...
    @overload
    def iterator(self) -> java.util.Iterator: ...
    def limit(self, long: int) -> 'DoubleStream': ...
    def map(self, doubleUnaryOperator: java.util.function.DoubleUnaryOperator) -> 'DoubleStream': ...
    def mapToInt(self, doubleToIntFunction: java.util.function.DoubleToIntFunction) -> 'IntStream': ...
    def mapToLong(self, doubleToLongFunction: java.util.function.DoubleToLongFunction) -> 'LongStream': ...
    _mapToObj__U = _py_TypeVar('_mapToObj__U')  # <U>
    def mapToObj(self, doubleFunction: java.util.function.DoubleFunction[_mapToObj__U]) -> 'Stream'[_mapToObj__U]: ...
    def max(self) -> java.util.OptionalDouble: ...
    def min(self) -> java.util.OptionalDouble: ...
    def noneMatch(self, doublePredicate: java.util.function.DoublePredicate) -> bool: ...
    @classmethod
    @overload
    def of(cls, double: float) -> 'DoubleStream': ...
    @classmethod
    @overload
    def of(cls, doubleArray: _py_List[float]) -> 'DoubleStream': ...
    @overload
    def parallel(self) -> 'DoubleStream': ...
    @overload
    def parallel(self) -> BaseStream: ...
    def peek(self, doubleConsumer: java.util.function.DoubleConsumer) -> 'DoubleStream': ...
    @overload
    def reduce(self, double: float, doubleBinaryOperator: java.util.function.DoubleBinaryOperator) -> float: ...
    @overload
    def reduce(self, doubleBinaryOperator: java.util.function.DoubleBinaryOperator) -> java.util.OptionalDouble: ...
    @overload
    def sequential(self) -> 'DoubleStream': ...
    @overload
    def sequential(self) -> BaseStream: ...
    def skip(self, long: int) -> 'DoubleStream': ...
    def sorted(self) -> 'DoubleStream': ...
    @overload
    def spliterator(self) -> java.util.Spliterator.OfDouble: ...
    @overload
    def spliterator(self) -> java.util.Spliterator: ...
    def sum(self) -> float: ...
    def summaryStatistics(self) -> java.util.DoubleSummaryStatistics: ...
    def toArray(self) -> _py_List[float]: ...
    class Builder(java.util.function.DoubleConsumer):
        def accept(self, double: float) -> None: ...
        def add(self, double: float) -> 'DoubleStream.Builder': ...
        def build(self) -> 'DoubleStream': ...

class IntStream(BaseStream[int, 'IntStream']):
    def allMatch(self, intPredicate: java.util.function.IntPredicate) -> bool: ...
    def anyMatch(self, intPredicate: java.util.function.IntPredicate) -> bool: ...
    def asDoubleStream(self) -> DoubleStream: ...
    def asLongStream(self) -> 'LongStream': ...
    def average(self) -> java.util.OptionalDouble: ...
    def boxed(self) -> 'Stream'[int]: ...
    @classmethod
    def builder(cls) -> 'IntStream.Builder': ...
    _collect__R = _py_TypeVar('_collect__R')  # <R>
    def collect(self, supplier: java.util.function.Supplier[_collect__R], objIntConsumer: java.util.function.ObjIntConsumer[_collect__R], biConsumer: java.util.function.BiConsumer[_collect__R, _collect__R]) -> _collect__R: ...
    @classmethod
    def concat(cls, intStream: 'IntStream', intStream2: 'IntStream') -> 'IntStream': ...
    def count(self) -> int: ...
    def distinct(self) -> 'IntStream': ...
    @classmethod
    def empty(cls) -> 'IntStream': ...
    def filter(self, intPredicate: java.util.function.IntPredicate) -> 'IntStream': ...
    def findAny(self) -> java.util.OptionalInt: ...
    def findFirst(self) -> java.util.OptionalInt: ...
    def flatMap(self, intFunction: java.util.function.IntFunction['IntStream']) -> 'IntStream': ...
    def forEach(self, intConsumer: java.util.function.IntConsumer) -> None: ...
    def forEachOrdered(self, intConsumer: java.util.function.IntConsumer) -> None: ...
    @classmethod
    def generate(cls, intSupplier: java.util.function.IntSupplier) -> 'IntStream': ...
    @classmethod
    def iterate(cls, int: int, intUnaryOperator: java.util.function.IntUnaryOperator) -> 'IntStream': ...
    @overload
    def iterator(self) -> java.util.PrimitiveIterator.OfInt: ...
    @overload
    def iterator(self) -> java.util.Iterator: ...
    def limit(self, long: int) -> 'IntStream': ...
    def map(self, intUnaryOperator: java.util.function.IntUnaryOperator) -> 'IntStream': ...
    def mapToDouble(self, intToDoubleFunction: java.util.function.IntToDoubleFunction) -> DoubleStream: ...
    def mapToLong(self, intToLongFunction: java.util.function.IntToLongFunction) -> 'LongStream': ...
    _mapToObj__U = _py_TypeVar('_mapToObj__U')  # <U>
    def mapToObj(self, intFunction: java.util.function.IntFunction[_mapToObj__U]) -> 'Stream'[_mapToObj__U]: ...
    def max(self) -> java.util.OptionalInt: ...
    def min(self) -> java.util.OptionalInt: ...
    def noneMatch(self, intPredicate: java.util.function.IntPredicate) -> bool: ...
    @classmethod
    @overload
    def of(cls, int: int) -> 'IntStream': ...
    @classmethod
    @overload
    def of(cls, intArray: _py_List[int]) -> 'IntStream': ...
    @overload
    def parallel(self) -> 'IntStream': ...
    @overload
    def parallel(self) -> BaseStream: ...
    def peek(self, intConsumer: java.util.function.IntConsumer) -> 'IntStream': ...
    @classmethod
    def range(cls, int: int, int2: int) -> 'IntStream': ...
    @classmethod
    def rangeClosed(cls, int: int, int2: int) -> 'IntStream': ...
    @overload
    def reduce(self, int: int, intBinaryOperator: java.util.function.IntBinaryOperator) -> int: ...
    @overload
    def reduce(self, intBinaryOperator: java.util.function.IntBinaryOperator) -> java.util.OptionalInt: ...
    @overload
    def sequential(self) -> 'IntStream': ...
    @overload
    def sequential(self) -> BaseStream: ...
    def skip(self, long: int) -> 'IntStream': ...
    def sorted(self) -> 'IntStream': ...
    @overload
    def spliterator(self) -> java.util.Spliterator.OfInt: ...
    @overload
    def spliterator(self) -> java.util.Spliterator: ...
    def sum(self) -> int: ...
    def summaryStatistics(self) -> java.util.IntSummaryStatistics: ...
    def toArray(self) -> _py_List[int]: ...
    class Builder(java.util.function.IntConsumer):
        def accept(self, int: int) -> None: ...
        def add(self, int: int) -> 'IntStream.Builder': ...
        def build(self) -> 'IntStream': ...

class LongStream(BaseStream[int, 'LongStream']):
    def allMatch(self, longPredicate: java.util.function.LongPredicate) -> bool: ...
    def anyMatch(self, longPredicate: java.util.function.LongPredicate) -> bool: ...
    def asDoubleStream(self) -> DoubleStream: ...
    def average(self) -> java.util.OptionalDouble: ...
    def boxed(self) -> 'Stream'[int]: ...
    @classmethod
    def builder(cls) -> 'LongStream.Builder': ...
    _collect__R = _py_TypeVar('_collect__R')  # <R>
    def collect(self, supplier: java.util.function.Supplier[_collect__R], objLongConsumer: java.util.function.ObjLongConsumer[_collect__R], biConsumer: java.util.function.BiConsumer[_collect__R, _collect__R]) -> _collect__R: ...
    @classmethod
    def concat(cls, longStream: 'LongStream', longStream2: 'LongStream') -> 'LongStream': ...
    def count(self) -> int: ...
    def distinct(self) -> 'LongStream': ...
    @classmethod
    def empty(cls) -> 'LongStream': ...
    def filter(self, longPredicate: java.util.function.LongPredicate) -> 'LongStream': ...
    def findAny(self) -> java.util.OptionalLong: ...
    def findFirst(self) -> java.util.OptionalLong: ...
    def flatMap(self, longFunction: java.util.function.LongFunction['LongStream']) -> 'LongStream': ...
    def forEach(self, longConsumer: java.util.function.LongConsumer) -> None: ...
    def forEachOrdered(self, longConsumer: java.util.function.LongConsumer) -> None: ...
    @classmethod
    def generate(cls, longSupplier: java.util.function.LongSupplier) -> 'LongStream': ...
    @classmethod
    def iterate(cls, long: int, longUnaryOperator: java.util.function.LongUnaryOperator) -> 'LongStream': ...
    @overload
    def iterator(self) -> java.util.PrimitiveIterator.OfLong: ...
    @overload
    def iterator(self) -> java.util.Iterator: ...
    def limit(self, long: int) -> 'LongStream': ...
    def map(self, longUnaryOperator: java.util.function.LongUnaryOperator) -> 'LongStream': ...
    def mapToDouble(self, longToDoubleFunction: java.util.function.LongToDoubleFunction) -> DoubleStream: ...
    def mapToInt(self, longToIntFunction: java.util.function.LongToIntFunction) -> IntStream: ...
    _mapToObj__U = _py_TypeVar('_mapToObj__U')  # <U>
    def mapToObj(self, longFunction: java.util.function.LongFunction[_mapToObj__U]) -> 'Stream'[_mapToObj__U]: ...
    def max(self) -> java.util.OptionalLong: ...
    def min(self) -> java.util.OptionalLong: ...
    def noneMatch(self, longPredicate: java.util.function.LongPredicate) -> bool: ...
    @classmethod
    @overload
    def of(cls, long: int) -> 'LongStream': ...
    @classmethod
    @overload
    def of(cls, longArray: _py_List[int]) -> 'LongStream': ...
    @overload
    def parallel(self) -> 'LongStream': ...
    @overload
    def parallel(self) -> BaseStream: ...
    def peek(self, longConsumer: java.util.function.LongConsumer) -> 'LongStream': ...
    @classmethod
    def range(cls, long: int, long2: int) -> 'LongStream': ...
    @classmethod
    def rangeClosed(cls, long: int, long2: int) -> 'LongStream': ...
    @overload
    def reduce(self, longBinaryOperator: java.util.function.LongBinaryOperator) -> java.util.OptionalLong: ...
    @overload
    def reduce(self, long: int, longBinaryOperator: java.util.function.LongBinaryOperator) -> int: ...
    @overload
    def sequential(self) -> 'LongStream': ...
    @overload
    def sequential(self) -> BaseStream: ...
    def skip(self, long: int) -> 'LongStream': ...
    def sorted(self) -> 'LongStream': ...
    @overload
    def spliterator(self) -> java.util.Spliterator.OfLong: ...
    @overload
    def spliterator(self) -> java.util.Spliterator: ...
    def sum(self) -> int: ...
    def summaryStatistics(self) -> java.util.LongSummaryStatistics: ...
    def toArray(self) -> _py_List[int]: ...
    class Builder(java.util.function.LongConsumer):
        def accept(self, long: int) -> None: ...
        def add(self, long: int) -> 'LongStream.Builder': ...
        def build(self) -> 'LongStream': ...

_SpinedBuffer__E = _py_TypeVar('_SpinedBuffer__E')  # <E>
class SpinedBuffer(AbstractSpinedBuffer, java.util.function.Consumer[_SpinedBuffer__E], java.lang.Iterable[_SpinedBuffer__E], _py_Generic[_SpinedBuffer__E]):
    def accept(self, e: _SpinedBuffer__E) -> None: ...
    def asArray(self, intFunction: java.util.function.IntFunction[_py_List[_SpinedBuffer__E]]) -> _py_List[_SpinedBuffer__E]: ...
    def clear(self) -> None: ...
    def copyInto(self, eArray: _py_List[_SpinedBuffer__E], int: int) -> None: ...
    def forEach(self, consumer: java.util.function.Consumer[_SpinedBuffer__E]) -> None: ...
    def get(self, long: int) -> _SpinedBuffer__E: ...
    def iterator(self) -> java.util.Iterator[_SpinedBuffer__E]: ...
    def spliterator(self) -> java.util.Spliterator[_SpinedBuffer__E]: ...
    def toString(self) -> str: ...

_Stream__Builder__T = _py_TypeVar('_Stream__Builder__T')  # <T>
_Stream__T = _py_TypeVar('_Stream__T')  # <T>
class Stream(BaseStream[_Stream__T, 'Stream'[_Stream__T]], _py_Generic[_Stream__T]):
    def allMatch(self, predicate: java.util.function.Predicate[_Stream__T]) -> bool: ...
    def anyMatch(self, predicate: java.util.function.Predicate[_Stream__T]) -> bool: ...
    _builder__T = _py_TypeVar('_builder__T')  # <T>
    @classmethod
    def builder(cls) -> 'Stream.Builder'[_builder__T]: ...
    _collect_0__R = _py_TypeVar('_collect_0__R')  # <R>
    @overload
    def collect(self, supplier: java.util.function.Supplier[_collect_0__R], biConsumer: java.util.function.BiConsumer[_collect_0__R, _Stream__T], biConsumer2: java.util.function.BiConsumer[_collect_0__R, _collect_0__R]) -> _collect_0__R: ...
    _collect_1__R = _py_TypeVar('_collect_1__R')  # <R>
    _collect_1__A = _py_TypeVar('_collect_1__A')  # <A>
    @overload
    def collect(self, collector: Collector[_Stream__T, _collect_1__A, _collect_1__R]) -> _collect_1__R: ...
    _concat__T = _py_TypeVar('_concat__T')  # <T>
    @classmethod
    def concat(cls, stream: 'Stream'[_concat__T], stream2: 'Stream'[_concat__T]) -> 'Stream'[_concat__T]: ...
    def count(self) -> int: ...
    def distinct(self) -> 'Stream'[_Stream__T]: ...
    _empty__T = _py_TypeVar('_empty__T')  # <T>
    @classmethod
    def empty(cls) -> 'Stream'[_empty__T]: ...
    def filter(self, predicate: java.util.function.Predicate[_Stream__T]) -> 'Stream'[_Stream__T]: ...
    def findAny(self) -> java.util.Optional[_Stream__T]: ...
    def findFirst(self) -> java.util.Optional[_Stream__T]: ...
    _flatMap__R = _py_TypeVar('_flatMap__R')  # <R>
    def flatMap(self, function: java.util.function.Function[_Stream__T, 'Stream'[_flatMap__R]]) -> 'Stream'[_flatMap__R]: ...
    def flatMapToDouble(self, function: java.util.function.Function[_Stream__T, DoubleStream]) -> DoubleStream: ...
    def flatMapToInt(self, function: java.util.function.Function[_Stream__T, IntStream]) -> IntStream: ...
    def flatMapToLong(self, function: java.util.function.Function[_Stream__T, LongStream]) -> LongStream: ...
    def forEach(self, consumer: java.util.function.Consumer[_Stream__T]) -> None: ...
    def forEachOrdered(self, consumer: java.util.function.Consumer[_Stream__T]) -> None: ...
    _generate__T = _py_TypeVar('_generate__T')  # <T>
    @classmethod
    def generate(cls, supplier: java.util.function.Supplier[_generate__T]) -> 'Stream'[_generate__T]: ...
    _iterate__T = _py_TypeVar('_iterate__T')  # <T>
    @classmethod
    def iterate(cls, t: _iterate__T, unaryOperator: java.util.function.UnaryOperator[_iterate__T]) -> 'Stream'[_iterate__T]: ...
    def limit(self, long: int) -> 'Stream'[_Stream__T]: ...
    _map__R = _py_TypeVar('_map__R')  # <R>
    def map(self, function: java.util.function.Function[_Stream__T, _map__R]) -> 'Stream'[_map__R]: ...
    def mapToDouble(self, toDoubleFunction: java.util.function.ToDoubleFunction[_Stream__T]) -> DoubleStream: ...
    def mapToInt(self, toIntFunction: java.util.function.ToIntFunction[_Stream__T]) -> IntStream: ...
    def mapToLong(self, toLongFunction: java.util.function.ToLongFunction[_Stream__T]) -> LongStream: ...
    def max(self, comparator: java.util.Comparator[_Stream__T]) -> java.util.Optional[_Stream__T]: ...
    def min(self, comparator: java.util.Comparator[_Stream__T]) -> java.util.Optional[_Stream__T]: ...
    def noneMatch(self, predicate: java.util.function.Predicate[_Stream__T]) -> bool: ...
    _of_0__T = _py_TypeVar('_of_0__T')  # <T>
    @classmethod
    @overload
    def of(cls, t: _of_0__T) -> 'Stream'[_of_0__T]: ...
    _of_1__T = _py_TypeVar('_of_1__T')  # <T>
    @classmethod
    @overload
    def of(cls, tArray: _py_List[_of_1__T]) -> 'Stream'[_of_1__T]: ...
    def peek(self, consumer: java.util.function.Consumer[_Stream__T]) -> 'Stream'[_Stream__T]: ...
    _reduce_0__U = _py_TypeVar('_reduce_0__U')  # <U>
    @overload
    def reduce(self, u: _reduce_0__U, biFunction: java.util.function.BiFunction[_reduce_0__U, _Stream__T, _reduce_0__U], binaryOperator: java.util.function.BinaryOperator[_reduce_0__U]) -> _reduce_0__U: ...
    @overload
    def reduce(self, t: _Stream__T, binaryOperator: java.util.function.BinaryOperator[_Stream__T]) -> _Stream__T: ...
    @overload
    def reduce(self, binaryOperator: java.util.function.BinaryOperator[_Stream__T]) -> java.util.Optional[_Stream__T]: ...
    def skip(self, long: int) -> 'Stream'[_Stream__T]: ...
    @overload
    def sorted(self) -> 'Stream'[_Stream__T]: ...
    @overload
    def sorted(self, comparator: java.util.Comparator[_Stream__T]) -> 'Stream'[_Stream__T]: ...
    @overload
    def toArray(self) -> _py_List[_py_Any]: ...
    _toArray_1__A = _py_TypeVar('_toArray_1__A')  # <A>
    @overload
    def toArray(self, intFunction: java.util.function.IntFunction[_py_List[_toArray_1__A]]) -> _py_List[_toArray_1__A]: ...
    class Builder(java.util.function.Consumer[_Stream__Builder__T], _py_Generic[_Stream__Builder__T]):
        def accept(self, t: _Stream__Builder__T) -> None: ...
        def add(self, t: _Stream__Builder__T) -> 'Stream.Builder'[_Stream__Builder__T]: ...
        def build(self) -> 'Stream'[_Stream__Builder__T]: ...

_DoublePipeline__E_IN = _py_TypeVar('_DoublePipeline__E_IN')  # <E_IN>
class DoublePipeline(AbstractPipeline[_DoublePipeline__E_IN, float, DoubleStream], DoubleStream, _py_Generic[_DoublePipeline__E_IN]):
    def allMatch(self, doublePredicate: java.util.function.DoublePredicate) -> bool: ...
    def anyMatch(self, doublePredicate: java.util.function.DoublePredicate) -> bool: ...
    def average(self) -> java.util.OptionalDouble: ...
    def boxed(self) -> Stream[float]: ...
    _collect__R = _py_TypeVar('_collect__R')  # <R>
    def collect(self, supplier: java.util.function.Supplier[_collect__R], objDoubleConsumer: java.util.function.ObjDoubleConsumer[_collect__R], biConsumer: java.util.function.BiConsumer[_collect__R, _collect__R]) -> _collect__R: ...
    def count(self) -> int: ...
    def distinct(self) -> DoubleStream: ...
    def filter(self, doublePredicate: java.util.function.DoublePredicate) -> DoubleStream: ...
    def findAny(self) -> java.util.OptionalDouble: ...
    def findFirst(self) -> java.util.OptionalDouble: ...
    def flatMap(self, doubleFunction: java.util.function.DoubleFunction[DoubleStream]) -> DoubleStream: ...
    def forEach(self, doubleConsumer: java.util.function.DoubleConsumer) -> None: ...
    def forEachOrdered(self, doubleConsumer: java.util.function.DoubleConsumer) -> None: ...
    @overload
    def iterator(self) -> java.util.PrimitiveIterator.OfDouble: ...
    @overload
    def iterator(self) -> java.util.Iterator: ...
    def limit(self, long: int) -> DoubleStream: ...
    def map(self, doubleUnaryOperator: java.util.function.DoubleUnaryOperator) -> DoubleStream: ...
    def mapToInt(self, doubleToIntFunction: java.util.function.DoubleToIntFunction) -> IntStream: ...
    def mapToLong(self, doubleToLongFunction: java.util.function.DoubleToLongFunction) -> LongStream: ...
    _mapToObj__U = _py_TypeVar('_mapToObj__U')  # <U>
    def mapToObj(self, doubleFunction: java.util.function.DoubleFunction[_mapToObj__U]) -> Stream[_mapToObj__U]: ...
    def max(self) -> java.util.OptionalDouble: ...
    def min(self) -> java.util.OptionalDouble: ...
    def noneMatch(self, doublePredicate: java.util.function.DoublePredicate) -> bool: ...
    @overload
    def parallel(self) -> BaseStream: ...
    @overload
    def parallel(self) -> DoubleStream: ...
    def peek(self, doubleConsumer: java.util.function.DoubleConsumer) -> DoubleStream: ...
    @overload
    def reduce(self, double: float, doubleBinaryOperator: java.util.function.DoubleBinaryOperator) -> float: ...
    @overload
    def reduce(self, doubleBinaryOperator: java.util.function.DoubleBinaryOperator) -> java.util.OptionalDouble: ...
    @overload
    def sequential(self) -> BaseStream: ...
    @overload
    def sequential(self) -> DoubleStream: ...
    def skip(self, long: int) -> DoubleStream: ...
    def sorted(self) -> DoubleStream: ...
    @overload
    def spliterator(self) -> java.util.Spliterator.OfDouble: ...
    @overload
    def spliterator(self) -> java.util.Spliterator: ...
    def sum(self) -> float: ...
    def summaryStatistics(self) -> java.util.DoubleSummaryStatistics: ...
    def toArray(self) -> _py_List[float]: ...
    @overload
    def unordered(self) -> BaseStream: ...
    @overload
    def unordered(self) -> DoubleStream: ...

_IntPipeline__E_IN = _py_TypeVar('_IntPipeline__E_IN')  # <E_IN>
class IntPipeline(AbstractPipeline[_IntPipeline__E_IN, int, IntStream], IntStream, _py_Generic[_IntPipeline__E_IN]):
    def allMatch(self, intPredicate: java.util.function.IntPredicate) -> bool: ...
    def anyMatch(self, intPredicate: java.util.function.IntPredicate) -> bool: ...
    def asDoubleStream(self) -> DoubleStream: ...
    def asLongStream(self) -> LongStream: ...
    def average(self) -> java.util.OptionalDouble: ...
    def boxed(self) -> Stream[int]: ...
    _collect__R = _py_TypeVar('_collect__R')  # <R>
    def collect(self, supplier: java.util.function.Supplier[_collect__R], objIntConsumer: java.util.function.ObjIntConsumer[_collect__R], biConsumer: java.util.function.BiConsumer[_collect__R, _collect__R]) -> _collect__R: ...
    def count(self) -> int: ...
    def distinct(self) -> IntStream: ...
    def filter(self, intPredicate: java.util.function.IntPredicate) -> IntStream: ...
    def findAny(self) -> java.util.OptionalInt: ...
    def findFirst(self) -> java.util.OptionalInt: ...
    def flatMap(self, intFunction: java.util.function.IntFunction[IntStream]) -> IntStream: ...
    def forEach(self, intConsumer: java.util.function.IntConsumer) -> None: ...
    def forEachOrdered(self, intConsumer: java.util.function.IntConsumer) -> None: ...
    @overload
    def iterator(self) -> java.util.PrimitiveIterator.OfInt: ...
    @overload
    def iterator(self) -> java.util.Iterator: ...
    def limit(self, long: int) -> IntStream: ...
    def map(self, intUnaryOperator: java.util.function.IntUnaryOperator) -> IntStream: ...
    def mapToDouble(self, intToDoubleFunction: java.util.function.IntToDoubleFunction) -> DoubleStream: ...
    def mapToLong(self, intToLongFunction: java.util.function.IntToLongFunction) -> LongStream: ...
    _mapToObj__U = _py_TypeVar('_mapToObj__U')  # <U>
    def mapToObj(self, intFunction: java.util.function.IntFunction[_mapToObj__U]) -> Stream[_mapToObj__U]: ...
    def max(self) -> java.util.OptionalInt: ...
    def min(self) -> java.util.OptionalInt: ...
    def noneMatch(self, intPredicate: java.util.function.IntPredicate) -> bool: ...
    @overload
    def parallel(self) -> BaseStream: ...
    @overload
    def parallel(self) -> IntStream: ...
    def peek(self, intConsumer: java.util.function.IntConsumer) -> IntStream: ...
    @overload
    def reduce(self, int: int, intBinaryOperator: java.util.function.IntBinaryOperator) -> int: ...
    @overload
    def reduce(self, intBinaryOperator: java.util.function.IntBinaryOperator) -> java.util.OptionalInt: ...
    @overload
    def sequential(self) -> BaseStream: ...
    @overload
    def sequential(self) -> IntStream: ...
    def skip(self, long: int) -> IntStream: ...
    def sorted(self) -> IntStream: ...
    @overload
    def spliterator(self) -> java.util.Spliterator.OfInt: ...
    @overload
    def spliterator(self) -> java.util.Spliterator: ...
    def sum(self) -> int: ...
    def summaryStatistics(self) -> java.util.IntSummaryStatistics: ...
    def toArray(self) -> _py_List[int]: ...
    @overload
    def unordered(self) -> BaseStream: ...
    @overload
    def unordered(self) -> IntStream: ...

_LongPipeline__E_IN = _py_TypeVar('_LongPipeline__E_IN')  # <E_IN>
class LongPipeline(AbstractPipeline[_LongPipeline__E_IN, int, LongStream], LongStream, _py_Generic[_LongPipeline__E_IN]):
    def allMatch(self, longPredicate: java.util.function.LongPredicate) -> bool: ...
    def anyMatch(self, longPredicate: java.util.function.LongPredicate) -> bool: ...
    def asDoubleStream(self) -> DoubleStream: ...
    def average(self) -> java.util.OptionalDouble: ...
    def boxed(self) -> Stream[int]: ...
    _collect__R = _py_TypeVar('_collect__R')  # <R>
    def collect(self, supplier: java.util.function.Supplier[_collect__R], objLongConsumer: java.util.function.ObjLongConsumer[_collect__R], biConsumer: java.util.function.BiConsumer[_collect__R, _collect__R]) -> _collect__R: ...
    def count(self) -> int: ...
    def distinct(self) -> LongStream: ...
    def filter(self, longPredicate: java.util.function.LongPredicate) -> LongStream: ...
    def findAny(self) -> java.util.OptionalLong: ...
    def findFirst(self) -> java.util.OptionalLong: ...
    def flatMap(self, longFunction: java.util.function.LongFunction[LongStream]) -> LongStream: ...
    def forEach(self, longConsumer: java.util.function.LongConsumer) -> None: ...
    def forEachOrdered(self, longConsumer: java.util.function.LongConsumer) -> None: ...
    @overload
    def iterator(self) -> java.util.PrimitiveIterator.OfLong: ...
    @overload
    def iterator(self) -> java.util.Iterator: ...
    def limit(self, long: int) -> LongStream: ...
    def map(self, longUnaryOperator: java.util.function.LongUnaryOperator) -> LongStream: ...
    def mapToDouble(self, longToDoubleFunction: java.util.function.LongToDoubleFunction) -> DoubleStream: ...
    def mapToInt(self, longToIntFunction: java.util.function.LongToIntFunction) -> IntStream: ...
    _mapToObj__U = _py_TypeVar('_mapToObj__U')  # <U>
    def mapToObj(self, longFunction: java.util.function.LongFunction[_mapToObj__U]) -> Stream[_mapToObj__U]: ...
    def max(self) -> java.util.OptionalLong: ...
    def min(self) -> java.util.OptionalLong: ...
    def noneMatch(self, longPredicate: java.util.function.LongPredicate) -> bool: ...
    @overload
    def parallel(self) -> BaseStream: ...
    @overload
    def parallel(self) -> LongStream: ...
    def peek(self, longConsumer: java.util.function.LongConsumer) -> LongStream: ...
    @overload
    def reduce(self, longBinaryOperator: java.util.function.LongBinaryOperator) -> java.util.OptionalLong: ...
    @overload
    def reduce(self, long: int, longBinaryOperator: java.util.function.LongBinaryOperator) -> int: ...
    @overload
    def sequential(self) -> BaseStream: ...
    @overload
    def sequential(self) -> LongStream: ...
    def skip(self, long: int) -> LongStream: ...
    def sorted(self) -> LongStream: ...
    @overload
    def spliterator(self) -> java.util.Spliterator.OfLong: ...
    @overload
    def spliterator(self) -> java.util.Spliterator: ...
    def sum(self) -> int: ...
    def summaryStatistics(self) -> java.util.LongSummaryStatistics: ...
    def toArray(self) -> _py_List[int]: ...
    @overload
    def unordered(self) -> BaseStream: ...
    @overload
    def unordered(self) -> LongStream: ...

_ReferencePipeline__P_IN = _py_TypeVar('_ReferencePipeline__P_IN')  # <P_IN>
_ReferencePipeline__P_OUT = _py_TypeVar('_ReferencePipeline__P_OUT')  # <P_OUT>
class ReferencePipeline(AbstractPipeline[_ReferencePipeline__P_IN, _ReferencePipeline__P_OUT, Stream[_ReferencePipeline__P_OUT]], Stream[_ReferencePipeline__P_OUT], _py_Generic[_ReferencePipeline__P_IN, _ReferencePipeline__P_OUT]):
    def allMatch(self, predicate: java.util.function.Predicate[_ReferencePipeline__P_OUT]) -> bool: ...
    def anyMatch(self, predicate: java.util.function.Predicate[_ReferencePipeline__P_OUT]) -> bool: ...
    _collect_0__R = _py_TypeVar('_collect_0__R')  # <R>
    @overload
    def collect(self, supplier: java.util.function.Supplier[_collect_0__R], biConsumer: java.util.function.BiConsumer[_collect_0__R, _ReferencePipeline__P_OUT], biConsumer2: java.util.function.BiConsumer[_collect_0__R, _collect_0__R]) -> _collect_0__R: ...
    _collect_1__R = _py_TypeVar('_collect_1__R')  # <R>
    _collect_1__A = _py_TypeVar('_collect_1__A')  # <A>
    @overload
    def collect(self, collector: Collector[_ReferencePipeline__P_OUT, _collect_1__A, _collect_1__R]) -> _collect_1__R: ...
    def count(self) -> int: ...
    def distinct(self) -> Stream[_ReferencePipeline__P_OUT]: ...
    def filter(self, predicate: java.util.function.Predicate[_ReferencePipeline__P_OUT]) -> Stream[_ReferencePipeline__P_OUT]: ...
    def findAny(self) -> java.util.Optional[_ReferencePipeline__P_OUT]: ...
    def findFirst(self) -> java.util.Optional[_ReferencePipeline__P_OUT]: ...
    _flatMap__R = _py_TypeVar('_flatMap__R')  # <R>
    def flatMap(self, function: java.util.function.Function[_ReferencePipeline__P_OUT, Stream[_flatMap__R]]) -> Stream[_flatMap__R]: ...
    def flatMapToDouble(self, function: java.util.function.Function[_ReferencePipeline__P_OUT, DoubleStream]) -> DoubleStream: ...
    def flatMapToInt(self, function: java.util.function.Function[_ReferencePipeline__P_OUT, IntStream]) -> IntStream: ...
    def flatMapToLong(self, function: java.util.function.Function[_ReferencePipeline__P_OUT, LongStream]) -> LongStream: ...
    def forEach(self, consumer: java.util.function.Consumer[_ReferencePipeline__P_OUT]) -> None: ...
    def forEachOrdered(self, consumer: java.util.function.Consumer[_ReferencePipeline__P_OUT]) -> None: ...
    def iterator(self) -> java.util.Iterator[_ReferencePipeline__P_OUT]: ...
    def limit(self, long: int) -> Stream[_ReferencePipeline__P_OUT]: ...
    _map__R = _py_TypeVar('_map__R')  # <R>
    def map(self, function: java.util.function.Function[_ReferencePipeline__P_OUT, _map__R]) -> Stream[_map__R]: ...
    def mapToDouble(self, toDoubleFunction: java.util.function.ToDoubleFunction[_ReferencePipeline__P_OUT]) -> DoubleStream: ...
    def mapToInt(self, toIntFunction: java.util.function.ToIntFunction[_ReferencePipeline__P_OUT]) -> IntStream: ...
    def mapToLong(self, toLongFunction: java.util.function.ToLongFunction[_ReferencePipeline__P_OUT]) -> LongStream: ...
    def max(self, comparator: java.util.Comparator[_ReferencePipeline__P_OUT]) -> java.util.Optional[_ReferencePipeline__P_OUT]: ...
    def min(self, comparator: java.util.Comparator[_ReferencePipeline__P_OUT]) -> java.util.Optional[_ReferencePipeline__P_OUT]: ...
    def noneMatch(self, predicate: java.util.function.Predicate[_ReferencePipeline__P_OUT]) -> bool: ...
    def peek(self, consumer: java.util.function.Consumer[_ReferencePipeline__P_OUT]) -> Stream[_ReferencePipeline__P_OUT]: ...
    _reduce_0__R = _py_TypeVar('_reduce_0__R')  # <R>
    @overload
    def reduce(self, r: _reduce_0__R, biFunction: java.util.function.BiFunction[_reduce_0__R, _ReferencePipeline__P_OUT, _reduce_0__R], binaryOperator: java.util.function.BinaryOperator[_reduce_0__R]) -> _reduce_0__R: ...
    @overload
    def reduce(self, p_OUT: _ReferencePipeline__P_OUT, binaryOperator: java.util.function.BinaryOperator[_ReferencePipeline__P_OUT]) -> _ReferencePipeline__P_OUT: ...
    @overload
    def reduce(self, binaryOperator: java.util.function.BinaryOperator[_ReferencePipeline__P_OUT]) -> java.util.Optional[_ReferencePipeline__P_OUT]: ...
    def skip(self, long: int) -> Stream[_ReferencePipeline__P_OUT]: ...
    @overload
    def sorted(self) -> Stream[_ReferencePipeline__P_OUT]: ...
    @overload
    def sorted(self, comparator: java.util.Comparator[_ReferencePipeline__P_OUT]) -> Stream[_ReferencePipeline__P_OUT]: ...
    @overload
    def toArray(self) -> _py_List[_py_Any]: ...
    _toArray_1__A = _py_TypeVar('_toArray_1__A')  # <A>
    @overload
    def toArray(self, intFunction: java.util.function.IntFunction[_py_List[_toArray_1__A]]) -> _py_List[_toArray_1__A]: ...
    @overload
    def unordered(self) -> BaseStream: ...
    @overload
    def unordered(self) -> Stream[_ReferencePipeline__P_OUT]: ...

_Node__Builder__T = _py_TypeVar('_Node__Builder__T')  # <T>
_Node__OfPrimitive__T = _py_TypeVar('_Node__OfPrimitive__T')  # <T>
_Node__OfPrimitive__T_CONS = _py_TypeVar('_Node__OfPrimitive__T_CONS')  # <T_CONS>
_Node__OfPrimitive__T_ARR = _py_TypeVar('_Node__OfPrimitive__T_ARR')  # <T_ARR>
_Node__OfPrimitive__T_SPLITR = _py_TypeVar('_Node__OfPrimitive__T_SPLITR', bound=java.util.Spliterator.OfPrimitive)  # <T_SPLITR>
_Node__OfPrimitive__T_NODE = _py_TypeVar('_Node__OfPrimitive__T_NODE', bound='Node.OfPrimitive')  # <T_NODE>
_Node__T = _py_TypeVar('_Node__T')  # <T>
class Node(_py_Generic[_Node__T]):
    def asArray(self, intFunction: java.util.function.IntFunction[_py_List[_Node__T]]) -> _py_List[_Node__T]: ...
    def copyInto(self, tArray: _py_List[_Node__T], int: int) -> None: ...
    def count(self) -> int: ...
    def forEach(self, consumer: java.util.function.Consumer[_Node__T]) -> None: ...
    def getChild(self, int: int) -> 'Node'[_Node__T]: ...
    def getChildCount(self) -> int: ...
    def getShape(self) -> StreamShape: ...
    def spliterator(self) -> java.util.Spliterator[_Node__T]: ...
    def truncate(self, long: int, long2: int, intFunction: java.util.function.IntFunction[_py_List[_Node__T]]) -> 'Node'[_Node__T]: ...
    class Builder(java.util.stream.Sink[_Node__Builder__T], _py_Generic[_Node__Builder__T]):
        def build(self) -> 'Node'[_Node__Builder__T]: ...
        class OfDouble(java.util.stream.Node.Builder[float], java.util.stream.Sink.OfDouble):
            @overload
            def build(self) -> 'Node.OfDouble': ...
            @overload
            def build(self) -> 'Node': ...
        class OfInt(java.util.stream.Node.Builder[int], java.util.stream.Sink.OfInt):
            @overload
            def build(self) -> 'Node.OfInt': ...
            @overload
            def build(self) -> 'Node': ...
        class OfLong(java.util.stream.Node.Builder[int], java.util.stream.Sink.OfLong):
            @overload
            def build(self) -> 'Node.OfLong': ...
            @overload
            def build(self) -> 'Node': ...
    class OfDouble(java.util.stream.Node.OfPrimitive[float, java.util.function.DoubleConsumer, _py_List[float], java.util.Spliterator.OfDouble, 'Node.OfDouble']):
        @overload
        def copyInto(self, t_ARR: _py_Any, int: int) -> None: ...
        @overload
        def copyInto(self, doubleArray: _py_List[float], int: int) -> None: ...
        @overload
        def copyInto(self, objectArray: _py_List[_py_Any], int: int) -> None: ...
        @overload
        def forEach(self, t_CONS: _py_Any) -> None: ...
        @overload
        def forEach(self, consumer: java.util.function.Consumer[float]) -> None: ...
        def getShape(self) -> StreamShape: ...
        @overload
        def newArray(self, int: int) -> _py_List[float]: ...
        @overload
        def newArray(self, int: int) -> _py_Any: ...
        @overload
        def truncate(self, long: int, long2: int, intFunction: java.util.function.IntFunction) -> 'Node': ...
        @overload
        def truncate(self, long: int, long2: int, intFunction: java.util.function.IntFunction[_py_List[float]]) -> 'Node.OfDouble': ...
        @overload
        def truncate(self, long: int, long2: int, intFunction: java.util.function.IntFunction) -> 'Node.OfPrimitive': ...
    class OfInt(java.util.stream.Node.OfPrimitive[int, java.util.function.IntConsumer, _py_List[int], java.util.Spliterator.OfInt, 'Node.OfInt']):
        @overload
        def copyInto(self, t_ARR: _py_Any, int: int) -> None: ...
        @overload
        def copyInto(self, integerArray: _py_List[int], int2: int) -> None: ...
        @overload
        def copyInto(self, objectArray: _py_List[_py_Any], int: int) -> None: ...
        @overload
        def forEach(self, t_CONS: _py_Any) -> None: ...
        @overload
        def forEach(self, consumer: java.util.function.Consumer[int]) -> None: ...
        def getShape(self) -> StreamShape: ...
        @overload
        def newArray(self, int: int) -> _py_List[int]: ...
        @overload
        def newArray(self, int: int) -> _py_Any: ...
        @overload
        def truncate(self, long: int, long2: int, intFunction: java.util.function.IntFunction) -> 'Node': ...
        @overload
        def truncate(self, long: int, long2: int, intFunction: java.util.function.IntFunction[_py_List[int]]) -> 'Node.OfInt': ...
        @overload
        def truncate(self, long: int, long2: int, intFunction: java.util.function.IntFunction) -> 'Node.OfPrimitive': ...
    class OfLong(java.util.stream.Node.OfPrimitive[int, java.util.function.LongConsumer, _py_List[int], java.util.Spliterator.OfLong, 'Node.OfLong']):
        @overload
        def copyInto(self, t_ARR: _py_Any, int: int) -> None: ...
        @overload
        def copyInto(self, longArray: _py_List[int], int: int) -> None: ...
        @overload
        def copyInto(self, objectArray: _py_List[_py_Any], int: int) -> None: ...
        @overload
        def forEach(self, t_CONS: _py_Any) -> None: ...
        @overload
        def forEach(self, consumer: java.util.function.Consumer[int]) -> None: ...
        def getShape(self) -> StreamShape: ...
        @overload
        def newArray(self, int: int) -> _py_Any: ...
        @overload
        def newArray(self, int: int) -> _py_List[int]: ...
        @overload
        def truncate(self, long: int, long2: int, intFunction: java.util.function.IntFunction) -> 'Node': ...
        @overload
        def truncate(self, long: int, long2: int, intFunction: java.util.function.IntFunction[_py_List[int]]) -> 'Node.OfLong': ...
        @overload
        def truncate(self, long: int, long2: int, intFunction: java.util.function.IntFunction) -> 'Node.OfPrimitive': ...
    class OfPrimitive(java.util.stream.Node[_Node__OfPrimitive__T], _py_Generic[_Node__OfPrimitive__T, _Node__OfPrimitive__T_CONS, _Node__OfPrimitive__T_ARR, _Node__OfPrimitive__T_SPLITR, _Node__OfPrimitive__T_NODE]):
        def asArray(self, intFunction: java.util.function.IntFunction[_py_List[_Node__OfPrimitive__T]]) -> _py_List[_Node__OfPrimitive__T]: ...
        def asPrimitiveArray(self) -> _Node__OfPrimitive__T_ARR: ...
        @overload
        def copyInto(self, t_ARR: _Node__OfPrimitive__T_ARR, int: int) -> None: ...
        @overload
        def copyInto(self, tArray: _py_List[_Node__OfPrimitive__T], int: int) -> None: ...
        @overload
        def forEach(self, t_CONS: _Node__OfPrimitive__T_CONS) -> None: ...
        @overload
        def forEach(self, consumer: java.util.function.Consumer[_Node__OfPrimitive__T]) -> None: ...
        @overload
        def getChild(self, int: int) -> 'Node': ...
        @overload
        def getChild(self, int: int) -> _Node__OfPrimitive__T_NODE: ...
        def newArray(self, int: int) -> _Node__OfPrimitive__T_ARR: ...
        @overload
        def spliterator(self) -> _Node__OfPrimitive__T_SPLITR: ...
        @overload
        def spliterator(self) -> java.util.Spliterator: ...
        @overload
        def truncate(self, long: int, long2: int, intFunction: java.util.function.IntFunction[_py_List[_Node__OfPrimitive__T]]) -> _Node__OfPrimitive__T_NODE: ...
        @overload
        def truncate(self, long: int, long2: int, intFunction: java.util.function.IntFunction) -> 'Node': ...

_Sink__ChainedDouble__E_OUT = _py_TypeVar('_Sink__ChainedDouble__E_OUT')  # <E_OUT>
_Sink__ChainedInt__E_OUT = _py_TypeVar('_Sink__ChainedInt__E_OUT')  # <E_OUT>
_Sink__ChainedLong__E_OUT = _py_TypeVar('_Sink__ChainedLong__E_OUT')  # <E_OUT>
_Sink__ChainedReference__T = _py_TypeVar('_Sink__ChainedReference__T')  # <T>
_Sink__ChainedReference__E_OUT = _py_TypeVar('_Sink__ChainedReference__E_OUT')  # <E_OUT>
_Sink__T = _py_TypeVar('_Sink__T')  # <T>
class Sink(java.util.function.Consumer[_Sink__T], _py_Generic[_Sink__T]):
    @overload
    def accept(self, t: _Sink__T) -> None: ...
    @overload
    def accept(self, double: float) -> None: ...
    @overload
    def accept(self, int: int) -> None: ...
    @overload
    def accept(self, long: int) -> None: ...
    def begin(self, long: int) -> None: ...
    def cancellationRequested(self) -> bool: ...
    def end(self) -> None: ...
    class ChainedDouble(java.util.stream.Sink.OfDouble, _py_Generic[_Sink__ChainedDouble__E_OUT]):
        def __init__(self, sink: 'Sink'[_Sink__ChainedDouble__E_OUT]): ...
        def begin(self, long: int) -> None: ...
        def cancellationRequested(self) -> bool: ...
        def end(self) -> None: ...
    class ChainedInt(java.util.stream.Sink.OfInt, _py_Generic[_Sink__ChainedInt__E_OUT]):
        def __init__(self, sink: 'Sink'[_Sink__ChainedInt__E_OUT]): ...
        def begin(self, long: int) -> None: ...
        def cancellationRequested(self) -> bool: ...
        def end(self) -> None: ...
    class ChainedLong(java.util.stream.Sink.OfLong, _py_Generic[_Sink__ChainedLong__E_OUT]):
        def __init__(self, sink: 'Sink'[_Sink__ChainedLong__E_OUT]): ...
        def begin(self, long: int) -> None: ...
        def cancellationRequested(self) -> bool: ...
        def end(self) -> None: ...
    class ChainedReference(java.util.stream.Sink[_Sink__ChainedReference__T], _py_Generic[_Sink__ChainedReference__T, _Sink__ChainedReference__E_OUT]):
        def __init__(self, sink: 'Sink'[_Sink__ChainedReference__E_OUT]): ...
        def begin(self, long: int) -> None: ...
        def cancellationRequested(self) -> bool: ...
        def end(self) -> None: ...
    class OfDouble(java.util.stream.Sink[float], java.util.function.DoubleConsumer):
        @overload
        def accept(self, double: float) -> None: ...
        @overload
        def accept(self, double: float) -> None: ...
        @overload
        def accept(self, object: _py_Any) -> None: ...
        @overload
        def accept(self, int: int) -> None: ...
        @overload
        def accept(self, long: int) -> None: ...
    class OfInt(java.util.stream.Sink[int], java.util.function.IntConsumer):
        @overload
        def accept(self, int: int) -> None: ...
        @overload
        def accept(self, integer: int) -> None: ...
        @overload
        def accept(self, object: _py_Any) -> None: ...
        @overload
        def accept(self, double: float) -> None: ...
        @overload
        def accept(self, long: int) -> None: ...
    class OfLong(java.util.stream.Sink[int], java.util.function.LongConsumer):
        @overload
        def accept(self, long: int) -> None: ...
        @overload
        def accept(self, long: int) -> None: ...
        @overload
        def accept(self, object: _py_Any) -> None: ...
        @overload
        def accept(self, double: float) -> None: ...
        @overload
        def accept(self, int: int) -> None: ...

_TerminalSink__T = _py_TypeVar('_TerminalSink__T')  # <T>
_TerminalSink__R = _py_TypeVar('_TerminalSink__R')  # <R>
class TerminalSink(Sink[_TerminalSink__T], java.util.function.Supplier[_TerminalSink__R], _py_Generic[_TerminalSink__T, _TerminalSink__R]): ...
