from typing import Any as _py_Any
from typing import List as _py_List
from typing import TypeVar as _py_TypeVar
from typing import Type as _py_Type
from typing import ClassVar as _py_ClassVar
from typing import Generic as _py_Generic
from typing import overload
import java
import java.io
import java.lang
import java.security
import java.util
import java.util.function
import java.util.stream


_BlockingQueue__E = _py_TypeVar('_BlockingQueue__E')  # <E>
class BlockingQueue(java.util.Queue[_BlockingQueue__E], _py_Generic[_BlockingQueue__E]):
    def add(self, e: _BlockingQueue__E) -> bool: ...
    def contains(self, object: _py_Any) -> bool: ...
    @overload
    def drainTo(self, collection: java.util.Collection[_BlockingQueue__E]) -> int: ...
    @overload
    def drainTo(self, collection: java.util.Collection[_BlockingQueue__E], int: int) -> int: ...
    def equals(self, object: _py_Any) -> bool: ...
    def hashCode(self) -> int: ...
    @overload
    def offer(self, e: _BlockingQueue__E) -> bool: ...
    @overload
    def offer(self, e: _BlockingQueue__E, long: int, timeUnit: 'TimeUnit') -> bool: ...
    @overload
    def poll(self) -> _BlockingQueue__E: ...
    @overload
    def poll(self, long: int, timeUnit: 'TimeUnit') -> _BlockingQueue__E: ...
    def put(self, e: _BlockingQueue__E) -> None: ...
    def remainingCapacity(self) -> int: ...
    @overload
    def remove(self, object: _py_Any) -> bool: ...
    @overload
    def remove(self) -> _BlockingQueue__E: ...
    def take(self) -> _BlockingQueue__E: ...

class BrokenBarrierException(java.lang.Exception):
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, string: str): ...

_Callable__V = _py_TypeVar('_Callable__V')  # <V>
class Callable(_py_Generic[_Callable__V]):
    def call(self) -> _Callable__V: ...

class CancellationException(java.lang.IllegalStateException):
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, string: str): ...

class CompletionException(java.lang.RuntimeException):
    @overload
    def __init__(self, string: str, throwable: java.lang.Throwable): ...
    @overload
    def __init__(self, throwable: java.lang.Throwable): ...

_CompletionService__V = _py_TypeVar('_CompletionService__V')  # <V>
class CompletionService(_py_Generic[_CompletionService__V]):
    @overload
    def poll(self) -> 'Future'[_CompletionService__V]: ...
    @overload
    def poll(self, long: int, timeUnit: 'TimeUnit') -> 'Future'[_CompletionService__V]: ...
    @overload
    def submit(self, runnable: java.lang.Runnable, v: _CompletionService__V) -> 'Future'[_CompletionService__V]: ...
    @overload
    def submit(self, callable: Callable[_CompletionService__V]) -> 'Future'[_CompletionService__V]: ...
    def take(self) -> 'Future'[_CompletionService__V]: ...

_CompletionStage__T = _py_TypeVar('_CompletionStage__T')  # <T>
class CompletionStage(_py_Generic[_CompletionStage__T]):
    def acceptEither(self, completionStage: 'CompletionStage'[_CompletionStage__T], consumer: java.util.function.Consumer[_CompletionStage__T]) -> 'CompletionStage'[java.lang.Void]: ...
    @overload
    def acceptEitherAsync(self, completionStage: 'CompletionStage'[_CompletionStage__T], consumer: java.util.function.Consumer[_CompletionStage__T]) -> 'CompletionStage'[java.lang.Void]: ...
    @overload
    def acceptEitherAsync(self, completionStage: 'CompletionStage'[_CompletionStage__T], consumer: java.util.function.Consumer[_CompletionStage__T], executor: 'Executor') -> 'CompletionStage'[java.lang.Void]: ...
    _applyToEither__U = _py_TypeVar('_applyToEither__U')  # <U>
    def applyToEither(self, completionStage: 'CompletionStage'[_CompletionStage__T], function: java.util.function.Function[_CompletionStage__T, _applyToEither__U]) -> 'CompletionStage'[_applyToEither__U]: ...
    _applyToEitherAsync_0__U = _py_TypeVar('_applyToEitherAsync_0__U')  # <U>
    @overload
    def applyToEitherAsync(self, completionStage: 'CompletionStage'[_CompletionStage__T], function: java.util.function.Function[_CompletionStage__T, _applyToEitherAsync_0__U]) -> 'CompletionStage'[_applyToEitherAsync_0__U]: ...
    _applyToEitherAsync_1__U = _py_TypeVar('_applyToEitherAsync_1__U')  # <U>
    @overload
    def applyToEitherAsync(self, completionStage: 'CompletionStage'[_CompletionStage__T], function: java.util.function.Function[_CompletionStage__T, _applyToEitherAsync_1__U], executor: 'Executor') -> 'CompletionStage'[_applyToEitherAsync_1__U]: ...
    def exceptionally(self, function: java.util.function.Function[java.lang.Throwable, _CompletionStage__T]) -> 'CompletionStage'[_CompletionStage__T]: ...
    _handle__U = _py_TypeVar('_handle__U')  # <U>
    def handle(self, biFunction: java.util.function.BiFunction[_CompletionStage__T, java.lang.Throwable, _handle__U]) -> 'CompletionStage'[_handle__U]: ...
    _handleAsync_0__U = _py_TypeVar('_handleAsync_0__U')  # <U>
    @overload
    def handleAsync(self, biFunction: java.util.function.BiFunction[_CompletionStage__T, java.lang.Throwable, _handleAsync_0__U]) -> 'CompletionStage'[_handleAsync_0__U]: ...
    _handleAsync_1__U = _py_TypeVar('_handleAsync_1__U')  # <U>
    @overload
    def handleAsync(self, biFunction: java.util.function.BiFunction[_CompletionStage__T, java.lang.Throwable, _handleAsync_1__U], executor: 'Executor') -> 'CompletionStage'[_handleAsync_1__U]: ...
    def runAfterBoth(self, completionStage: 'CompletionStage'[_py_Any], runnable: java.lang.Runnable) -> 'CompletionStage'[java.lang.Void]: ...
    @overload
    def runAfterBothAsync(self, completionStage: 'CompletionStage'[_py_Any], runnable: java.lang.Runnable) -> 'CompletionStage'[java.lang.Void]: ...
    @overload
    def runAfterBothAsync(self, completionStage: 'CompletionStage'[_py_Any], runnable: java.lang.Runnable, executor: 'Executor') -> 'CompletionStage'[java.lang.Void]: ...
    def runAfterEither(self, completionStage: 'CompletionStage'[_py_Any], runnable: java.lang.Runnable) -> 'CompletionStage'[java.lang.Void]: ...
    @overload
    def runAfterEitherAsync(self, completionStage: 'CompletionStage'[_py_Any], runnable: java.lang.Runnable) -> 'CompletionStage'[java.lang.Void]: ...
    @overload
    def runAfterEitherAsync(self, completionStage: 'CompletionStage'[_py_Any], runnable: java.lang.Runnable, executor: 'Executor') -> 'CompletionStage'[java.lang.Void]: ...
    def thenAccept(self, consumer: java.util.function.Consumer[_CompletionStage__T]) -> 'CompletionStage'[java.lang.Void]: ...
    @overload
    def thenAcceptAsync(self, consumer: java.util.function.Consumer[_CompletionStage__T]) -> 'CompletionStage'[java.lang.Void]: ...
    @overload
    def thenAcceptAsync(self, consumer: java.util.function.Consumer[_CompletionStage__T], executor: 'Executor') -> 'CompletionStage'[java.lang.Void]: ...
    _thenAcceptBoth__U = _py_TypeVar('_thenAcceptBoth__U')  # <U>
    def thenAcceptBoth(self, completionStage: 'CompletionStage'[_thenAcceptBoth__U], biConsumer: java.util.function.BiConsumer[_CompletionStage__T, _thenAcceptBoth__U]) -> 'CompletionStage'[java.lang.Void]: ...
    _thenAcceptBothAsync_0__U = _py_TypeVar('_thenAcceptBothAsync_0__U')  # <U>
    @overload
    def thenAcceptBothAsync(self, completionStage: 'CompletionStage'[_thenAcceptBothAsync_0__U], biConsumer: java.util.function.BiConsumer[_CompletionStage__T, _thenAcceptBothAsync_0__U]) -> 'CompletionStage'[java.lang.Void]: ...
    _thenAcceptBothAsync_1__U = _py_TypeVar('_thenAcceptBothAsync_1__U')  # <U>
    @overload
    def thenAcceptBothAsync(self, completionStage: 'CompletionStage'[_thenAcceptBothAsync_1__U], biConsumer: java.util.function.BiConsumer[_CompletionStage__T, _thenAcceptBothAsync_1__U], executor: 'Executor') -> 'CompletionStage'[java.lang.Void]: ...
    _thenApply__U = _py_TypeVar('_thenApply__U')  # <U>
    def thenApply(self, function: java.util.function.Function[_CompletionStage__T, _thenApply__U]) -> 'CompletionStage'[_thenApply__U]: ...
    _thenApplyAsync_0__U = _py_TypeVar('_thenApplyAsync_0__U')  # <U>
    @overload
    def thenApplyAsync(self, function: java.util.function.Function[_CompletionStage__T, _thenApplyAsync_0__U]) -> 'CompletionStage'[_thenApplyAsync_0__U]: ...
    _thenApplyAsync_1__U = _py_TypeVar('_thenApplyAsync_1__U')  # <U>
    @overload
    def thenApplyAsync(self, function: java.util.function.Function[_CompletionStage__T, _thenApplyAsync_1__U], executor: 'Executor') -> 'CompletionStage'[_thenApplyAsync_1__U]: ...
    _thenCombine__U = _py_TypeVar('_thenCombine__U')  # <U>
    _thenCombine__V = _py_TypeVar('_thenCombine__V')  # <V>
    def thenCombine(self, completionStage: 'CompletionStage'[_thenCombine__U], biFunction: java.util.function.BiFunction[_CompletionStage__T, _thenCombine__U, _thenCombine__V]) -> 'CompletionStage'[_thenCombine__V]: ...
    _thenCombineAsync_0__U = _py_TypeVar('_thenCombineAsync_0__U')  # <U>
    _thenCombineAsync_0__V = _py_TypeVar('_thenCombineAsync_0__V')  # <V>
    @overload
    def thenCombineAsync(self, completionStage: 'CompletionStage'[_thenCombineAsync_0__U], biFunction: java.util.function.BiFunction[_CompletionStage__T, _thenCombineAsync_0__U, _thenCombineAsync_0__V]) -> 'CompletionStage'[_thenCombineAsync_0__V]: ...
    _thenCombineAsync_1__U = _py_TypeVar('_thenCombineAsync_1__U')  # <U>
    _thenCombineAsync_1__V = _py_TypeVar('_thenCombineAsync_1__V')  # <V>
    @overload
    def thenCombineAsync(self, completionStage: 'CompletionStage'[_thenCombineAsync_1__U], biFunction: java.util.function.BiFunction[_CompletionStage__T, _thenCombineAsync_1__U, _thenCombineAsync_1__V], executor: 'Executor') -> 'CompletionStage'[_thenCombineAsync_1__V]: ...
    _thenCompose__U = _py_TypeVar('_thenCompose__U')  # <U>
    def thenCompose(self, function: java.util.function.Function[_CompletionStage__T, 'CompletionStage'[_thenCompose__U]]) -> 'CompletionStage'[_thenCompose__U]: ...
    _thenComposeAsync_0__U = _py_TypeVar('_thenComposeAsync_0__U')  # <U>
    @overload
    def thenComposeAsync(self, function: java.util.function.Function[_CompletionStage__T, 'CompletionStage'[_thenComposeAsync_0__U]]) -> 'CompletionStage'[_thenComposeAsync_0__U]: ...
    _thenComposeAsync_1__U = _py_TypeVar('_thenComposeAsync_1__U')  # <U>
    @overload
    def thenComposeAsync(self, function: java.util.function.Function[_CompletionStage__T, 'CompletionStage'[_thenComposeAsync_1__U]], executor: 'Executor') -> 'CompletionStage'[_thenComposeAsync_1__U]: ...
    def thenRun(self, runnable: java.lang.Runnable) -> 'CompletionStage'[java.lang.Void]: ...
    @overload
    def thenRunAsync(self, runnable: java.lang.Runnable) -> 'CompletionStage'[java.lang.Void]: ...
    @overload
    def thenRunAsync(self, runnable: java.lang.Runnable, executor: 'Executor') -> 'CompletionStage'[java.lang.Void]: ...
    def toCompletableFuture(self) -> 'CompletableFuture'[_CompletionStage__T]: ...
    def whenComplete(self, biConsumer: java.util.function.BiConsumer[_CompletionStage__T, java.lang.Throwable]) -> 'CompletionStage'[_CompletionStage__T]: ...
    @overload
    def whenCompleteAsync(self, biConsumer: java.util.function.BiConsumer[_CompletionStage__T, java.lang.Throwable]) -> 'CompletionStage'[_CompletionStage__T]: ...
    @overload
    def whenCompleteAsync(self, biConsumer: java.util.function.BiConsumer[_CompletionStage__T, java.lang.Throwable], executor: 'Executor') -> 'CompletionStage'[_CompletionStage__T]: ...

_ConcurrentLinkedDeque__E = _py_TypeVar('_ConcurrentLinkedDeque__E')  # <E>
class ConcurrentLinkedDeque(java.util.AbstractCollection[_ConcurrentLinkedDeque__E], java.util.Deque[_ConcurrentLinkedDeque__E], java.io.Serializable, _py_Generic[_ConcurrentLinkedDeque__E]):
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, collection: java.util.Collection[_ConcurrentLinkedDeque__E]): ...
    def add(self, e: _ConcurrentLinkedDeque__E) -> bool: ...
    def addAll(self, collection: java.util.Collection[_ConcurrentLinkedDeque__E]) -> bool: ...
    def addFirst(self, e: _ConcurrentLinkedDeque__E) -> None: ...
    def addLast(self, e: _ConcurrentLinkedDeque__E) -> None: ...
    def clear(self) -> None: ...
    def contains(self, object: _py_Any) -> bool: ...
    def descendingIterator(self) -> java.util.Iterator[_ConcurrentLinkedDeque__E]: ...
    def element(self) -> _ConcurrentLinkedDeque__E: ...
    def getFirst(self) -> _ConcurrentLinkedDeque__E: ...
    def getLast(self) -> _ConcurrentLinkedDeque__E: ...
    def isEmpty(self) -> bool: ...
    def iterator(self) -> java.util.Iterator[_ConcurrentLinkedDeque__E]: ...
    def offer(self, e: _ConcurrentLinkedDeque__E) -> bool: ...
    def offerFirst(self, e: _ConcurrentLinkedDeque__E) -> bool: ...
    def offerLast(self, e: _ConcurrentLinkedDeque__E) -> bool: ...
    def peek(self) -> _ConcurrentLinkedDeque__E: ...
    def peekFirst(self) -> _ConcurrentLinkedDeque__E: ...
    def peekLast(self) -> _ConcurrentLinkedDeque__E: ...
    def poll(self) -> _ConcurrentLinkedDeque__E: ...
    def pollFirst(self) -> _ConcurrentLinkedDeque__E: ...
    def pollLast(self) -> _ConcurrentLinkedDeque__E: ...
    def pop(self) -> _ConcurrentLinkedDeque__E: ...
    def push(self, e: _ConcurrentLinkedDeque__E) -> None: ...
    @overload
    def remove(self, object: _py_Any) -> bool: ...
    @overload
    def remove(self) -> _ConcurrentLinkedDeque__E: ...
    def removeFirst(self) -> _ConcurrentLinkedDeque__E: ...
    def removeFirstOccurrence(self, object: _py_Any) -> bool: ...
    def removeLast(self) -> _ConcurrentLinkedDeque__E: ...
    def removeLastOccurrence(self, object: _py_Any) -> bool: ...
    def size(self) -> int: ...
    def spliterator(self) -> java.util.Spliterator[_ConcurrentLinkedDeque__E]: ...
    @overload
    def toArray(self) -> _py_List[_py_Any]: ...
    _toArray_1__T = _py_TypeVar('_toArray_1__T')  # <T>
    @overload
    def toArray(self, tArray: _py_List[_toArray_1__T]) -> _py_List[_toArray_1__T]: ...

_ConcurrentLinkedQueue__E = _py_TypeVar('_ConcurrentLinkedQueue__E')  # <E>
class ConcurrentLinkedQueue(java.util.AbstractQueue[_ConcurrentLinkedQueue__E], java.util.Queue[_ConcurrentLinkedQueue__E], java.io.Serializable, _py_Generic[_ConcurrentLinkedQueue__E]):
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, collection: java.util.Collection[_ConcurrentLinkedQueue__E]): ...
    def add(self, e: _ConcurrentLinkedQueue__E) -> bool: ...
    def addAll(self, collection: java.util.Collection[_ConcurrentLinkedQueue__E]) -> bool: ...
    def contains(self, object: _py_Any) -> bool: ...
    def isEmpty(self) -> bool: ...
    def iterator(self) -> java.util.Iterator[_ConcurrentLinkedQueue__E]: ...
    def offer(self, e: _ConcurrentLinkedQueue__E) -> bool: ...
    def peek(self) -> _ConcurrentLinkedQueue__E: ...
    def poll(self) -> _ConcurrentLinkedQueue__E: ...
    @overload
    def remove(self, object: _py_Any) -> bool: ...
    @overload
    def remove(self) -> _ConcurrentLinkedQueue__E: ...
    def size(self) -> int: ...
    def spliterator(self) -> java.util.Spliterator[_ConcurrentLinkedQueue__E]: ...
    @overload
    def toArray(self) -> _py_List[_py_Any]: ...
    _toArray_1__T = _py_TypeVar('_toArray_1__T')  # <T>
    @overload
    def toArray(self, tArray: _py_List[_toArray_1__T]) -> _py_List[_toArray_1__T]: ...

_ConcurrentMap__K = _py_TypeVar('_ConcurrentMap__K')  # <K>
_ConcurrentMap__V = _py_TypeVar('_ConcurrentMap__V')  # <V>
class ConcurrentMap(java.util.Map[_ConcurrentMap__K, _ConcurrentMap__V], _py_Generic[_ConcurrentMap__K, _ConcurrentMap__V]):
    def compute(self, k: _ConcurrentMap__K, biFunction: java.util.function.BiFunction[_ConcurrentMap__K, _ConcurrentMap__V, _ConcurrentMap__V]) -> _ConcurrentMap__V: ...
    def computeIfAbsent(self, k: _ConcurrentMap__K, function: java.util.function.Function[_ConcurrentMap__K, _ConcurrentMap__V]) -> _ConcurrentMap__V: ...
    def computeIfPresent(self, k: _ConcurrentMap__K, biFunction: java.util.function.BiFunction[_ConcurrentMap__K, _ConcurrentMap__V, _ConcurrentMap__V]) -> _ConcurrentMap__V: ...
    def equals(self, object: _py_Any) -> bool: ...
    def forEach(self, biConsumer: java.util.function.BiConsumer[_ConcurrentMap__K, _ConcurrentMap__V]) -> None: ...
    def getOrDefault(self, object: _py_Any, v: _ConcurrentMap__V) -> _ConcurrentMap__V: ...
    def hashCode(self) -> int: ...
    def merge(self, k: _ConcurrentMap__K, v: _ConcurrentMap__V, biFunction: java.util.function.BiFunction[_ConcurrentMap__V, _ConcurrentMap__V, _ConcurrentMap__V]) -> _ConcurrentMap__V: ...
    def putIfAbsent(self, k: _ConcurrentMap__K, v: _ConcurrentMap__V) -> _ConcurrentMap__V: ...
    @overload
    def remove(self, object: _py_Any, object2: _py_Any) -> bool: ...
    @overload
    def remove(self, object: _py_Any) -> _ConcurrentMap__V: ...
    @overload
    def replace(self, k: _ConcurrentMap__K, v: _ConcurrentMap__V, v2: _ConcurrentMap__V) -> bool: ...
    @overload
    def replace(self, k: _ConcurrentMap__K, v: _ConcurrentMap__V) -> _ConcurrentMap__V: ...
    def replaceAll(self, biFunction: java.util.function.BiFunction[_ConcurrentMap__K, _ConcurrentMap__V, _ConcurrentMap__V]) -> None: ...

_ConcurrentSkipListSet__E = _py_TypeVar('_ConcurrentSkipListSet__E')  # <E>
class ConcurrentSkipListSet(java.util.AbstractSet[_ConcurrentSkipListSet__E], java.util.NavigableSet[_ConcurrentSkipListSet__E], java.lang.Cloneable, java.io.Serializable, _py_Generic[_ConcurrentSkipListSet__E]):
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, collection: java.util.Collection[_ConcurrentSkipListSet__E]): ...
    @overload
    def __init__(self, comparator: java.util.Comparator[_ConcurrentSkipListSet__E]): ...
    @overload
    def __init__(self, sortedSet: java.util.SortedSet[_ConcurrentSkipListSet__E]): ...
    def add(self, e: _ConcurrentSkipListSet__E) -> bool: ...
    def ceiling(self, e: _ConcurrentSkipListSet__E) -> _ConcurrentSkipListSet__E: ...
    def clear(self) -> None: ...
    @overload
    def clone(self) -> _py_Any: ...
    @overload
    def clone(self) -> 'ConcurrentSkipListSet'[_ConcurrentSkipListSet__E]: ...
    def comparator(self) -> java.util.Comparator[_ConcurrentSkipListSet__E]: ...
    def contains(self, object: _py_Any) -> bool: ...
    def descendingIterator(self) -> java.util.Iterator[_ConcurrentSkipListSet__E]: ...
    def descendingSet(self) -> java.util.NavigableSet[_ConcurrentSkipListSet__E]: ...
    def equals(self, object: _py_Any) -> bool: ...
    def first(self) -> _ConcurrentSkipListSet__E: ...
    def floor(self, e: _ConcurrentSkipListSet__E) -> _ConcurrentSkipListSet__E: ...
    @overload
    def headSet(self, e: _ConcurrentSkipListSet__E) -> java.util.NavigableSet[_ConcurrentSkipListSet__E]: ...
    @overload
    def headSet(self, e: _ConcurrentSkipListSet__E, boolean: bool) -> java.util.NavigableSet[_ConcurrentSkipListSet__E]: ...
    @overload
    def headSet(self, object: _py_Any) -> java.util.SortedSet: ...
    def higher(self, e: _ConcurrentSkipListSet__E) -> _ConcurrentSkipListSet__E: ...
    def isEmpty(self) -> bool: ...
    def iterator(self) -> java.util.Iterator[_ConcurrentSkipListSet__E]: ...
    def last(self) -> _ConcurrentSkipListSet__E: ...
    def lower(self, e: _ConcurrentSkipListSet__E) -> _ConcurrentSkipListSet__E: ...
    def pollFirst(self) -> _ConcurrentSkipListSet__E: ...
    def pollLast(self) -> _ConcurrentSkipListSet__E: ...
    def remove(self, object: _py_Any) -> bool: ...
    def removeAll(self, collection: java.util.Collection[_py_Any]) -> bool: ...
    def size(self) -> int: ...
    def spliterator(self) -> java.util.Spliterator[_ConcurrentSkipListSet__E]: ...
    @overload
    def subSet(self, e: _ConcurrentSkipListSet__E, boolean: bool, e2: _ConcurrentSkipListSet__E, boolean2: bool) -> java.util.NavigableSet[_ConcurrentSkipListSet__E]: ...
    @overload
    def subSet(self, e: _ConcurrentSkipListSet__E, e2: _ConcurrentSkipListSet__E) -> java.util.NavigableSet[_ConcurrentSkipListSet__E]: ...
    @overload
    def subSet(self, object: _py_Any, object2: _py_Any) -> java.util.SortedSet: ...
    @overload
    def tailSet(self, e: _ConcurrentSkipListSet__E) -> java.util.NavigableSet[_ConcurrentSkipListSet__E]: ...
    @overload
    def tailSet(self, e: _ConcurrentSkipListSet__E, boolean: bool) -> java.util.NavigableSet[_ConcurrentSkipListSet__E]: ...
    @overload
    def tailSet(self, object: _py_Any) -> java.util.SortedSet: ...

_CopyOnWriteArrayList__E = _py_TypeVar('_CopyOnWriteArrayList__E')  # <E>
class CopyOnWriteArrayList(java.util.List[_CopyOnWriteArrayList__E], java.util.RandomAccess, java.lang.Cloneable, java.io.Serializable, _py_Generic[_CopyOnWriteArrayList__E]):
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, eArray: _py_List[_CopyOnWriteArrayList__E]): ...
    @overload
    def __init__(self, collection: java.util.Collection[_CopyOnWriteArrayList__E]): ...
    @overload
    def add(self, e: _CopyOnWriteArrayList__E) -> bool: ...
    @overload
    def add(self, int: int, e: _CopyOnWriteArrayList__E) -> None: ...
    @overload
    def addAll(self, int: int, collection: java.util.Collection[_CopyOnWriteArrayList__E]) -> bool: ...
    @overload
    def addAll(self, collection: java.util.Collection[_CopyOnWriteArrayList__E]) -> bool: ...
    def addAllAbsent(self, collection: java.util.Collection[_CopyOnWriteArrayList__E]) -> int: ...
    def addIfAbsent(self, e: _CopyOnWriteArrayList__E) -> bool: ...
    def clear(self) -> None: ...
    def clone(self) -> _py_Any: ...
    def contains(self, object: _py_Any) -> bool: ...
    def containsAll(self, collection: java.util.Collection[_py_Any]) -> bool: ...
    def equals(self, object: _py_Any) -> bool: ...
    def forEach(self, consumer: java.util.function.Consumer[_CopyOnWriteArrayList__E]) -> None: ...
    def get(self, int: int) -> _CopyOnWriteArrayList__E: ...
    def hashCode(self) -> int: ...
    @overload
    def indexOf(self, object: _py_Any) -> int: ...
    @overload
    def indexOf(self, e: _CopyOnWriteArrayList__E, int: int) -> int: ...
    def isEmpty(self) -> bool: ...
    def iterator(self) -> java.util.Iterator[_CopyOnWriteArrayList__E]: ...
    @overload
    def lastIndexOf(self, object: _py_Any) -> int: ...
    @overload
    def lastIndexOf(self, e: _CopyOnWriteArrayList__E, int: int) -> int: ...
    @overload
    def listIterator(self) -> java.util.ListIterator[_CopyOnWriteArrayList__E]: ...
    @overload
    def listIterator(self, int: int) -> java.util.ListIterator[_CopyOnWriteArrayList__E]: ...
    @overload
    def remove(self, object: _py_Any) -> bool: ...
    @overload
    def remove(self, int: int) -> _CopyOnWriteArrayList__E: ...
    def removeAll(self, collection: java.util.Collection[_py_Any]) -> bool: ...
    def removeIf(self, predicate: java.util.function.Predicate[_CopyOnWriteArrayList__E]) -> bool: ...
    def replaceAll(self, unaryOperator: java.util.function.UnaryOperator[_CopyOnWriteArrayList__E]) -> None: ...
    def retainAll(self, collection: java.util.Collection[_py_Any]) -> bool: ...
    def set(self, int: int, e: _CopyOnWriteArrayList__E) -> _CopyOnWriteArrayList__E: ...
    def size(self) -> int: ...
    def sort(self, comparator: java.util.Comparator[_CopyOnWriteArrayList__E]) -> None: ...
    def spliterator(self) -> java.util.Spliterator[_CopyOnWriteArrayList__E]: ...
    def subList(self, int: int, int2: int) -> java.util.List[_CopyOnWriteArrayList__E]: ...
    @overload
    def toArray(self) -> _py_List[_py_Any]: ...
    _toArray_1__T = _py_TypeVar('_toArray_1__T')  # <T>
    @overload
    def toArray(self, tArray: _py_List[_toArray_1__T]) -> _py_List[_toArray_1__T]: ...
    def toString(self) -> str: ...

_CopyOnWriteArraySet__E = _py_TypeVar('_CopyOnWriteArraySet__E')  # <E>
class CopyOnWriteArraySet(java.util.AbstractSet[_CopyOnWriteArraySet__E], java.io.Serializable, _py_Generic[_CopyOnWriteArraySet__E]):
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, collection: java.util.Collection[_CopyOnWriteArraySet__E]): ...
    def add(self, e: _CopyOnWriteArraySet__E) -> bool: ...
    def addAll(self, collection: java.util.Collection[_CopyOnWriteArraySet__E]) -> bool: ...
    def clear(self) -> None: ...
    def contains(self, object: _py_Any) -> bool: ...
    def containsAll(self, collection: java.util.Collection[_py_Any]) -> bool: ...
    def equals(self, object: _py_Any) -> bool: ...
    def forEach(self, consumer: java.util.function.Consumer[_CopyOnWriteArraySet__E]) -> None: ...
    def isEmpty(self) -> bool: ...
    def iterator(self) -> java.util.Iterator[_CopyOnWriteArraySet__E]: ...
    def remove(self, object: _py_Any) -> bool: ...
    def removeAll(self, collection: java.util.Collection[_py_Any]) -> bool: ...
    def removeIf(self, predicate: java.util.function.Predicate[_CopyOnWriteArraySet__E]) -> bool: ...
    def retainAll(self, collection: java.util.Collection[_py_Any]) -> bool: ...
    def size(self) -> int: ...
    def spliterator(self) -> java.util.Spliterator[_CopyOnWriteArraySet__E]: ...
    @overload
    def toArray(self) -> _py_List[_py_Any]: ...
    _toArray_1__T = _py_TypeVar('_toArray_1__T')  # <T>
    @overload
    def toArray(self, tArray: _py_List[_toArray_1__T]) -> _py_List[_toArray_1__T]: ...

class CountDownLatch:
    def __init__(self, int: int): ...
    def countDown(self) -> None: ...
    def getCount(self) -> int: ...
    def toString(self) -> str: ...

class CyclicBarrier:
    @overload
    def __init__(self, int: int): ...
    @overload
    def __init__(self, int: int, runnable: java.lang.Runnable): ...
    def getNumberWaiting(self) -> int: ...
    def getParties(self) -> int: ...
    def isBroken(self) -> bool: ...
    def reset(self) -> None: ...

class Delayed(java.lang.Comparable['Delayed']):
    def getDelay(self, timeUnit: 'TimeUnit') -> int: ...

_Exchanger__V = _py_TypeVar('_Exchanger__V')  # <V>
class Exchanger(_py_Generic[_Exchanger__V]):
    def __init__(self): ...
    @overload
    def exchange(self, v: _Exchanger__V) -> _Exchanger__V: ...
    @overload
    def exchange(self, v: _Exchanger__V, long: int, timeUnit: 'TimeUnit') -> _Exchanger__V: ...

class ExecutionException(java.lang.Exception):
    @overload
    def __init__(self, string: str, throwable: java.lang.Throwable): ...
    @overload
    def __init__(self, throwable: java.lang.Throwable): ...

class Executor:
    def execute(self, runnable: java.lang.Runnable) -> None: ...

class Executors:
    @classmethod
    @overload
    def callable(cls, runnable: java.lang.Runnable) -> Callable[_py_Any]: ...
    _callable_1__T = _py_TypeVar('_callable_1__T')  # <T>
    @classmethod
    @overload
    def callable(cls, runnable: java.lang.Runnable, t: _callable_1__T) -> Callable[_callable_1__T]: ...
    @classmethod
    @overload
    def callable(cls, privilegedAction: java.security.PrivilegedAction[_py_Any]) -> Callable[_py_Any]: ...
    @classmethod
    @overload
    def callable(cls, privilegedExceptionAction: java.security.PrivilegedExceptionAction[_py_Any]) -> Callable[_py_Any]: ...
    @classmethod
    def defaultThreadFactory(cls) -> 'ThreadFactory': ...
    @classmethod
    @overload
    def newCachedThreadPool(cls) -> 'ExecutorService': ...
    @classmethod
    @overload
    def newCachedThreadPool(cls, threadFactory: 'ThreadFactory') -> 'ExecutorService': ...
    @classmethod
    @overload
    def newFixedThreadPool(cls, int: int) -> 'ExecutorService': ...
    @classmethod
    @overload
    def newFixedThreadPool(cls, int: int, threadFactory: 'ThreadFactory') -> 'ExecutorService': ...
    @classmethod
    @overload
    def newScheduledThreadPool(cls, int: int) -> 'ScheduledExecutorService': ...
    @classmethod
    @overload
    def newScheduledThreadPool(cls, int: int, threadFactory: 'ThreadFactory') -> 'ScheduledExecutorService': ...
    @classmethod
    @overload
    def newSingleThreadExecutor(cls) -> 'ExecutorService': ...
    @classmethod
    @overload
    def newSingleThreadExecutor(cls, threadFactory: 'ThreadFactory') -> 'ExecutorService': ...
    @classmethod
    @overload
    def newSingleThreadScheduledExecutor(cls) -> 'ScheduledExecutorService': ...
    @classmethod
    @overload
    def newSingleThreadScheduledExecutor(cls, threadFactory: 'ThreadFactory') -> 'ScheduledExecutorService': ...
    @classmethod
    @overload
    def newWorkStealingPool(cls) -> 'ExecutorService': ...
    @classmethod
    @overload
    def newWorkStealingPool(cls, int: int) -> 'ExecutorService': ...
    _privilegedCallable__T = _py_TypeVar('_privilegedCallable__T')  # <T>
    @classmethod
    def privilegedCallable(cls, callable: Callable[_privilegedCallable__T]) -> Callable[_privilegedCallable__T]: ...
    _privilegedCallableUsingCurrentClassLoader__T = _py_TypeVar('_privilegedCallableUsingCurrentClassLoader__T')  # <T>
    @classmethod
    def privilegedCallableUsingCurrentClassLoader(cls, callable: Callable[_privilegedCallableUsingCurrentClassLoader__T]) -> Callable[_privilegedCallableUsingCurrentClassLoader__T]: ...
    @classmethod
    def privilegedThreadFactory(cls) -> 'ThreadFactory': ...
    @classmethod
    def unconfigurableExecutorService(cls, executorService: 'ExecutorService') -> 'ExecutorService': ...
    @classmethod
    def unconfigurableScheduledExecutorService(cls, scheduledExecutorService: 'ScheduledExecutorService') -> 'ScheduledExecutorService': ...

class ForkJoinWorkerThread(java.lang.Thread):
    def getPool(self) -> 'ForkJoinPool': ...
    def getPoolIndex(self) -> int: ...
    def run(self) -> None: ...

_Future__V = _py_TypeVar('_Future__V')  # <V>
class Future(_py_Generic[_Future__V]):
    def cancel(self, boolean: bool) -> bool: ...
    @overload
    def get(self) -> _Future__V: ...
    @overload
    def get(self, long: int, timeUnit: 'TimeUnit') -> _Future__V: ...
    def isCancelled(self) -> bool: ...
    def isDone(self) -> bool: ...

class Phaser:
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, int: int): ...
    @overload
    def __init__(self, phaser: 'Phaser'): ...
    @overload
    def __init__(self, phaser: 'Phaser', int: int): ...
    def arrive(self) -> int: ...
    def arriveAndAwaitAdvance(self) -> int: ...
    def arriveAndDeregister(self) -> int: ...
    def awaitAdvance(self, int: int) -> int: ...
    @overload
    def awaitAdvanceInterruptibly(self, int: int) -> int: ...
    @overload
    def awaitAdvanceInterruptibly(self, int: int, long: int, timeUnit: 'TimeUnit') -> int: ...
    def bulkRegister(self, int: int) -> int: ...
    def forceTermination(self) -> None: ...
    def getArrivedParties(self) -> int: ...
    def getParent(self) -> 'Phaser': ...
    def getPhase(self) -> int: ...
    def getRegisteredParties(self) -> int: ...
    def getRoot(self) -> 'Phaser': ...
    def getUnarrivedParties(self) -> int: ...
    def isTerminated(self) -> bool: ...
    def register(self) -> int: ...
    def toString(self) -> str: ...

class RejectedExecutionException(java.lang.RuntimeException):
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, string: str): ...
    @overload
    def __init__(self, string: str, throwable: java.lang.Throwable): ...
    @overload
    def __init__(self, throwable: java.lang.Throwable): ...

class RejectedExecutionHandler:
    def rejectedExecution(self, runnable: java.lang.Runnable, threadPoolExecutor: 'ThreadPoolExecutor') -> None: ...

class Semaphore(java.io.Serializable):
    @overload
    def __init__(self, int: int): ...
    @overload
    def __init__(self, int: int, boolean: bool): ...
    @overload
    def acquire(self) -> None: ...
    @overload
    def acquire(self, int: int) -> None: ...
    @overload
    def acquireUninterruptibly(self) -> None: ...
    @overload
    def acquireUninterruptibly(self, int: int) -> None: ...
    def availablePermits(self) -> int: ...
    def drainPermits(self) -> int: ...
    def getQueueLength(self) -> int: ...
    def hasQueuedThreads(self) -> bool: ...
    def isFair(self) -> bool: ...
    @overload
    def release(self) -> None: ...
    @overload
    def release(self, int: int) -> None: ...
    def toString(self) -> str: ...
    @overload
    def tryAcquire(self) -> bool: ...
    @overload
    def tryAcquire(self, int: int) -> bool: ...
    @overload
    def tryAcquire(self, int: int, long: int, timeUnit: 'TimeUnit') -> bool: ...
    @overload
    def tryAcquire(self, long: int, timeUnit: 'TimeUnit') -> bool: ...

class ThreadFactory:
    def newThread(self, runnable: java.lang.Runnable) -> java.lang.Thread: ...

class ThreadLocalRandom(java.util.Random):
    @classmethod
    def current(cls) -> 'ThreadLocalRandom': ...
    @overload
    def doubles(self) -> java.util.stream.DoubleStream: ...
    @overload
    def doubles(self, double: float, double2: float) -> java.util.stream.DoubleStream: ...
    @overload
    def doubles(self, long: int) -> java.util.stream.DoubleStream: ...
    @overload
    def doubles(self, long: int, double: float, double2: float) -> java.util.stream.DoubleStream: ...
    @overload
    def ints(self) -> java.util.stream.IntStream: ...
    @overload
    def ints(self, int: int, int2: int) -> java.util.stream.IntStream: ...
    @overload
    def ints(self, long: int) -> java.util.stream.IntStream: ...
    @overload
    def ints(self, long: int, int: int, int2: int) -> java.util.stream.IntStream: ...
    @overload
    def longs(self) -> java.util.stream.LongStream: ...
    @overload
    def longs(self, long: int) -> java.util.stream.LongStream: ...
    @overload
    def longs(self, long: int, long2: int) -> java.util.stream.LongStream: ...
    @overload
    def longs(self, long: int, long2: int, long3: int) -> java.util.stream.LongStream: ...
    def nextBoolean(self) -> bool: ...
    @overload
    def nextDouble(self) -> float: ...
    @overload
    def nextDouble(self, double: float) -> float: ...
    @overload
    def nextDouble(self, double: float, double2: float) -> float: ...
    def nextFloat(self) -> float: ...
    def nextGaussian(self) -> float: ...
    @overload
    def nextInt(self) -> int: ...
    @overload
    def nextInt(self, int: int) -> int: ...
    @overload
    def nextInt(self, int: int, int2: int) -> int: ...
    @overload
    def nextLong(self) -> int: ...
    @overload
    def nextLong(self, long: int) -> int: ...
    @overload
    def nextLong(self, long: int, long2: int) -> int: ...
    def setSeed(self, long: int) -> None: ...

class TimeUnit(java.lang.Enum['TimeUnit']):
    NANOSECONDS: _py_ClassVar['TimeUnit'] = ...
    MICROSECONDS: _py_ClassVar['TimeUnit'] = ...
    MILLISECONDS: _py_ClassVar['TimeUnit'] = ...
    SECONDS: _py_ClassVar['TimeUnit'] = ...
    MINUTES: _py_ClassVar['TimeUnit'] = ...
    HOURS: _py_ClassVar['TimeUnit'] = ...
    DAYS: _py_ClassVar['TimeUnit'] = ...
    def convert(self, long: int, timeUnit: 'TimeUnit') -> int: ...
    def sleep(self, long: int) -> None: ...
    def timedJoin(self, thread: java.lang.Thread, long: int) -> None: ...
    def timedWait(self, object: _py_Any, long: int) -> None: ...
    def toDays(self, long: int) -> int: ...
    def toHours(self, long: int) -> int: ...
    def toMicros(self, long: int) -> int: ...
    def toMillis(self, long: int) -> int: ...
    def toMinutes(self, long: int) -> int: ...
    def toNanos(self, long: int) -> int: ...
    def toSeconds(self, long: int) -> int: ...
    _valueOf_0__T = _py_TypeVar('_valueOf_0__T', bound=java.lang.Enum)  # <T>
    @classmethod
    @overload
    def valueOf(cls, class_: _py_Type[_valueOf_0__T], string: str) -> _valueOf_0__T: ...
    @classmethod
    @overload
    def valueOf(cls, string: str) -> 'TimeUnit': ...
    @classmethod
    def values(cls) -> _py_List['TimeUnit']: ...

class TimeoutException(java.lang.Exception):
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, string: str): ...

_ArrayBlockingQueue__E = _py_TypeVar('_ArrayBlockingQueue__E')  # <E>
class ArrayBlockingQueue(java.util.AbstractQueue[_ArrayBlockingQueue__E], BlockingQueue[_ArrayBlockingQueue__E], java.io.Serializable, _py_Generic[_ArrayBlockingQueue__E]):
    @overload
    def __init__(self, int: int): ...
    @overload
    def __init__(self, int: int, boolean: bool): ...
    @overload
    def __init__(self, int: int, boolean: bool, collection: java.util.Collection[_ArrayBlockingQueue__E]): ...
    def add(self, e: _ArrayBlockingQueue__E) -> bool: ...
    def clear(self) -> None: ...
    def contains(self, object: _py_Any) -> bool: ...
    @overload
    def drainTo(self, collection: java.util.Collection[_ArrayBlockingQueue__E]) -> int: ...
    @overload
    def drainTo(self, collection: java.util.Collection[_ArrayBlockingQueue__E], int: int) -> int: ...
    def iterator(self) -> java.util.Iterator[_ArrayBlockingQueue__E]: ...
    @overload
    def offer(self, e: _ArrayBlockingQueue__E) -> bool: ...
    @overload
    def offer(self, e: _ArrayBlockingQueue__E, long: int, timeUnit: TimeUnit) -> bool: ...
    def peek(self) -> _ArrayBlockingQueue__E: ...
    @overload
    def poll(self) -> _ArrayBlockingQueue__E: ...
    @overload
    def poll(self, long: int, timeUnit: TimeUnit) -> _ArrayBlockingQueue__E: ...
    def put(self, e: _ArrayBlockingQueue__E) -> None: ...
    def remainingCapacity(self) -> int: ...
    @overload
    def remove(self, object: _py_Any) -> bool: ...
    @overload
    def remove(self) -> _ArrayBlockingQueue__E: ...
    def size(self) -> int: ...
    def spliterator(self) -> java.util.Spliterator[_ArrayBlockingQueue__E]: ...
    def take(self) -> _ArrayBlockingQueue__E: ...
    @overload
    def toArray(self) -> _py_List[_py_Any]: ...
    _toArray_1__T = _py_TypeVar('_toArray_1__T')  # <T>
    @overload
    def toArray(self, tArray: _py_List[_toArray_1__T]) -> _py_List[_toArray_1__T]: ...
    def toString(self) -> str: ...

_BlockingDeque__E = _py_TypeVar('_BlockingDeque__E')  # <E>
class BlockingDeque(BlockingQueue[_BlockingDeque__E], java.util.Deque[_BlockingDeque__E], _py_Generic[_BlockingDeque__E]):
    def add(self, e: _BlockingDeque__E) -> bool: ...
    def addFirst(self, e: _BlockingDeque__E) -> None: ...
    def addLast(self, e: _BlockingDeque__E) -> None: ...
    def contains(self, object: _py_Any) -> bool: ...
    def element(self) -> _BlockingDeque__E: ...
    def equals(self, object: _py_Any) -> bool: ...
    def hashCode(self) -> int: ...
    def iterator(self) -> java.util.Iterator[_BlockingDeque__E]: ...
    @overload
    def offer(self, e: _BlockingDeque__E) -> bool: ...
    @overload
    def offer(self, e: _BlockingDeque__E, long: int, timeUnit: TimeUnit) -> bool: ...
    @overload
    def offerFirst(self, e: _BlockingDeque__E) -> bool: ...
    @overload
    def offerFirst(self, e: _BlockingDeque__E, long: int, timeUnit: TimeUnit) -> bool: ...
    @overload
    def offerLast(self, e: _BlockingDeque__E) -> bool: ...
    @overload
    def offerLast(self, e: _BlockingDeque__E, long: int, timeUnit: TimeUnit) -> bool: ...
    def peek(self) -> _BlockingDeque__E: ...
    @overload
    def poll(self) -> _BlockingDeque__E: ...
    @overload
    def poll(self, long: int, timeUnit: TimeUnit) -> _BlockingDeque__E: ...
    @overload
    def pollFirst(self) -> _BlockingDeque__E: ...
    @overload
    def pollFirst(self, long: int, timeUnit: TimeUnit) -> _BlockingDeque__E: ...
    @overload
    def pollLast(self) -> _BlockingDeque__E: ...
    @overload
    def pollLast(self, long: int, timeUnit: TimeUnit) -> _BlockingDeque__E: ...
    def push(self, e: _BlockingDeque__E) -> None: ...
    def put(self, e: _BlockingDeque__E) -> None: ...
    def putFirst(self, e: _BlockingDeque__E) -> None: ...
    def putLast(self, e: _BlockingDeque__E) -> None: ...
    @overload
    def remove(self, object: _py_Any) -> bool: ...
    @overload
    def remove(self) -> _BlockingDeque__E: ...
    def removeFirstOccurrence(self, object: _py_Any) -> bool: ...
    def removeLastOccurrence(self, object: _py_Any) -> bool: ...
    def size(self) -> int: ...
    def take(self) -> _BlockingDeque__E: ...
    def takeFirst(self) -> _BlockingDeque__E: ...
    def takeLast(self) -> _BlockingDeque__E: ...

_CompletableFuture__T = _py_TypeVar('_CompletableFuture__T')  # <T>
class CompletableFuture(Future[_CompletableFuture__T], CompletionStage[_CompletableFuture__T], _py_Generic[_CompletableFuture__T]):
    def __init__(self): ...
    @overload
    def acceptEither(self, completionStage: CompletionStage[_CompletableFuture__T], consumer: java.util.function.Consumer[_CompletableFuture__T]) -> 'CompletableFuture'[java.lang.Void]: ...
    @overload
    def acceptEither(self, completionStage: CompletionStage, consumer: java.util.function.Consumer) -> CompletionStage: ...
    @overload
    def acceptEitherAsync(self, completionStage: CompletionStage[_CompletableFuture__T], consumer: java.util.function.Consumer[_CompletableFuture__T]) -> 'CompletableFuture'[java.lang.Void]: ...
    @overload
    def acceptEitherAsync(self, completionStage: CompletionStage[_CompletableFuture__T], consumer: java.util.function.Consumer[_CompletableFuture__T], executor: Executor) -> 'CompletableFuture'[java.lang.Void]: ...
    @overload
    def acceptEitherAsync(self, completionStage: CompletionStage, consumer: java.util.function.Consumer) -> CompletionStage: ...
    @overload
    def acceptEitherAsync(self, completionStage: CompletionStage, consumer: java.util.function.Consumer, executor: Executor) -> CompletionStage: ...
    @classmethod
    def allOf(cls, completableFutureArray: _py_List['CompletableFuture'[_py_Any]]) -> 'CompletableFuture'[java.lang.Void]: ...
    @classmethod
    def anyOf(cls, completableFutureArray: _py_List['CompletableFuture'[_py_Any]]) -> 'CompletableFuture'[_py_Any]: ...
    _applyToEither_0__U = _py_TypeVar('_applyToEither_0__U')  # <U>
    @overload
    def applyToEither(self, completionStage: CompletionStage[_CompletableFuture__T], function: java.util.function.Function[_CompletableFuture__T, _applyToEither_0__U]) -> 'CompletableFuture'[_applyToEither_0__U]: ...
    @overload
    def applyToEither(self, completionStage: CompletionStage, function: java.util.function.Function) -> CompletionStage: ...
    _applyToEitherAsync_0__U = _py_TypeVar('_applyToEitherAsync_0__U')  # <U>
    @overload
    def applyToEitherAsync(self, completionStage: CompletionStage[_CompletableFuture__T], function: java.util.function.Function[_CompletableFuture__T, _applyToEitherAsync_0__U]) -> 'CompletableFuture'[_applyToEitherAsync_0__U]: ...
    _applyToEitherAsync_1__U = _py_TypeVar('_applyToEitherAsync_1__U')  # <U>
    @overload
    def applyToEitherAsync(self, completionStage: CompletionStage[_CompletableFuture__T], function: java.util.function.Function[_CompletableFuture__T, _applyToEitherAsync_1__U], executor: Executor) -> 'CompletableFuture'[_applyToEitherAsync_1__U]: ...
    @overload
    def applyToEitherAsync(self, completionStage: CompletionStage, function: java.util.function.Function) -> CompletionStage: ...
    @overload
    def applyToEitherAsync(self, completionStage: CompletionStage, function: java.util.function.Function, executor: Executor) -> CompletionStage: ...
    def cancel(self, boolean: bool) -> bool: ...
    def complete(self, t: _CompletableFuture__T) -> bool: ...
    def completeExceptionally(self, throwable: java.lang.Throwable) -> bool: ...
    _completedFuture__U = _py_TypeVar('_completedFuture__U')  # <U>
    @classmethod
    def completedFuture(cls, u: _completedFuture__U) -> 'CompletableFuture'[_completedFuture__U]: ...
    @overload
    def exceptionally(self, function: java.util.function.Function[java.lang.Throwable, _CompletableFuture__T]) -> 'CompletableFuture'[_CompletableFuture__T]: ...
    @overload
    def exceptionally(self, function: java.util.function.Function) -> CompletionStage: ...
    @overload
    def get(self) -> _CompletableFuture__T: ...
    @overload
    def get(self, long: int, timeUnit: TimeUnit) -> _CompletableFuture__T: ...
    def getNow(self, t: _CompletableFuture__T) -> _CompletableFuture__T: ...
    def getNumberOfDependents(self) -> int: ...
    _handle_0__U = _py_TypeVar('_handle_0__U')  # <U>
    @overload
    def handle(self, biFunction: java.util.function.BiFunction[_CompletableFuture__T, java.lang.Throwable, _handle_0__U]) -> 'CompletableFuture'[_handle_0__U]: ...
    @overload
    def handle(self, biFunction: java.util.function.BiFunction) -> CompletionStage: ...
    _handleAsync_0__U = _py_TypeVar('_handleAsync_0__U')  # <U>
    @overload
    def handleAsync(self, biFunction: java.util.function.BiFunction[_CompletableFuture__T, java.lang.Throwable, _handleAsync_0__U]) -> 'CompletableFuture'[_handleAsync_0__U]: ...
    _handleAsync_1__U = _py_TypeVar('_handleAsync_1__U')  # <U>
    @overload
    def handleAsync(self, biFunction: java.util.function.BiFunction[_CompletableFuture__T, java.lang.Throwable, _handleAsync_1__U], executor: Executor) -> 'CompletableFuture'[_handleAsync_1__U]: ...
    @overload
    def handleAsync(self, biFunction: java.util.function.BiFunction) -> CompletionStage: ...
    @overload
    def handleAsync(self, biFunction: java.util.function.BiFunction, executor: Executor) -> CompletionStage: ...
    def isCancelled(self) -> bool: ...
    def isCompletedExceptionally(self) -> bool: ...
    def isDone(self) -> bool: ...
    def join(self) -> _CompletableFuture__T: ...
    def obtrudeException(self, throwable: java.lang.Throwable) -> None: ...
    def obtrudeValue(self, t: _CompletableFuture__T) -> None: ...
    @overload
    def runAfterBoth(self, completionStage: CompletionStage[_py_Any], runnable: java.lang.Runnable) -> 'CompletableFuture'[java.lang.Void]: ...
    @overload
    def runAfterBoth(self, completionStage: CompletionStage, runnable: java.lang.Runnable) -> CompletionStage: ...
    @overload
    def runAfterBothAsync(self, completionStage: CompletionStage[_py_Any], runnable: java.lang.Runnable) -> 'CompletableFuture'[java.lang.Void]: ...
    @overload
    def runAfterBothAsync(self, completionStage: CompletionStage[_py_Any], runnable: java.lang.Runnable, executor: Executor) -> 'CompletableFuture'[java.lang.Void]: ...
    @overload
    def runAfterBothAsync(self, completionStage: CompletionStage, runnable: java.lang.Runnable) -> CompletionStage: ...
    @overload
    def runAfterBothAsync(self, completionStage: CompletionStage, runnable: java.lang.Runnable, executor: Executor) -> CompletionStage: ...
    @overload
    def runAfterEither(self, completionStage: CompletionStage[_py_Any], runnable: java.lang.Runnable) -> 'CompletableFuture'[java.lang.Void]: ...
    @overload
    def runAfterEither(self, completionStage: CompletionStage, runnable: java.lang.Runnable) -> CompletionStage: ...
    @overload
    def runAfterEitherAsync(self, completionStage: CompletionStage[_py_Any], runnable: java.lang.Runnable) -> 'CompletableFuture'[java.lang.Void]: ...
    @overload
    def runAfterEitherAsync(self, completionStage: CompletionStage[_py_Any], runnable: java.lang.Runnable, executor: Executor) -> 'CompletableFuture'[java.lang.Void]: ...
    @overload
    def runAfterEitherAsync(self, completionStage: CompletionStage, runnable: java.lang.Runnable) -> CompletionStage: ...
    @overload
    def runAfterEitherAsync(self, completionStage: CompletionStage, runnable: java.lang.Runnable, executor: Executor) -> CompletionStage: ...
    @classmethod
    @overload
    def runAsync(cls, runnable: java.lang.Runnable) -> 'CompletableFuture'[java.lang.Void]: ...
    @classmethod
    @overload
    def runAsync(cls, runnable: java.lang.Runnable, executor: Executor) -> 'CompletableFuture'[java.lang.Void]: ...
    _supplyAsync_0__U = _py_TypeVar('_supplyAsync_0__U')  # <U>
    @classmethod
    @overload
    def supplyAsync(cls, supplier: java.util.function.Supplier[_supplyAsync_0__U]) -> 'CompletableFuture'[_supplyAsync_0__U]: ...
    _supplyAsync_1__U = _py_TypeVar('_supplyAsync_1__U')  # <U>
    @classmethod
    @overload
    def supplyAsync(cls, supplier: java.util.function.Supplier[_supplyAsync_1__U], executor: Executor) -> 'CompletableFuture'[_supplyAsync_1__U]: ...
    @overload
    def thenAccept(self, consumer: java.util.function.Consumer[_CompletableFuture__T]) -> 'CompletableFuture'[java.lang.Void]: ...
    @overload
    def thenAccept(self, consumer: java.util.function.Consumer) -> CompletionStage: ...
    @overload
    def thenAcceptAsync(self, consumer: java.util.function.Consumer[_CompletableFuture__T]) -> 'CompletableFuture'[java.lang.Void]: ...
    @overload
    def thenAcceptAsync(self, consumer: java.util.function.Consumer[_CompletableFuture__T], executor: Executor) -> 'CompletableFuture'[java.lang.Void]: ...
    @overload
    def thenAcceptAsync(self, consumer: java.util.function.Consumer) -> CompletionStage: ...
    @overload
    def thenAcceptAsync(self, consumer: java.util.function.Consumer, executor: Executor) -> CompletionStage: ...
    _thenAcceptBoth_0__U = _py_TypeVar('_thenAcceptBoth_0__U')  # <U>
    @overload
    def thenAcceptBoth(self, completionStage: CompletionStage[_thenAcceptBoth_0__U], biConsumer: java.util.function.BiConsumer[_CompletableFuture__T, _thenAcceptBoth_0__U]) -> 'CompletableFuture'[java.lang.Void]: ...
    @overload
    def thenAcceptBoth(self, completionStage: CompletionStage, biConsumer: java.util.function.BiConsumer) -> CompletionStage: ...
    _thenAcceptBothAsync_0__U = _py_TypeVar('_thenAcceptBothAsync_0__U')  # <U>
    @overload
    def thenAcceptBothAsync(self, completionStage: CompletionStage[_thenAcceptBothAsync_0__U], biConsumer: java.util.function.BiConsumer[_CompletableFuture__T, _thenAcceptBothAsync_0__U]) -> 'CompletableFuture'[java.lang.Void]: ...
    _thenAcceptBothAsync_1__U = _py_TypeVar('_thenAcceptBothAsync_1__U')  # <U>
    @overload
    def thenAcceptBothAsync(self, completionStage: CompletionStage[_thenAcceptBothAsync_1__U], biConsumer: java.util.function.BiConsumer[_CompletableFuture__T, _thenAcceptBothAsync_1__U], executor: Executor) -> 'CompletableFuture'[java.lang.Void]: ...
    @overload
    def thenAcceptBothAsync(self, completionStage: CompletionStage, biConsumer: java.util.function.BiConsumer) -> CompletionStage: ...
    @overload
    def thenAcceptBothAsync(self, completionStage: CompletionStage, biConsumer: java.util.function.BiConsumer, executor: Executor) -> CompletionStage: ...
    _thenApply_0__U = _py_TypeVar('_thenApply_0__U')  # <U>
    @overload
    def thenApply(self, function: java.util.function.Function[_CompletableFuture__T, _thenApply_0__U]) -> 'CompletableFuture'[_thenApply_0__U]: ...
    @overload
    def thenApply(self, function: java.util.function.Function) -> CompletionStage: ...
    _thenApplyAsync_0__U = _py_TypeVar('_thenApplyAsync_0__U')  # <U>
    @overload
    def thenApplyAsync(self, function: java.util.function.Function[_CompletableFuture__T, _thenApplyAsync_0__U]) -> 'CompletableFuture'[_thenApplyAsync_0__U]: ...
    _thenApplyAsync_1__U = _py_TypeVar('_thenApplyAsync_1__U')  # <U>
    @overload
    def thenApplyAsync(self, function: java.util.function.Function[_CompletableFuture__T, _thenApplyAsync_1__U], executor: Executor) -> 'CompletableFuture'[_thenApplyAsync_1__U]: ...
    @overload
    def thenApplyAsync(self, function: java.util.function.Function) -> CompletionStage: ...
    @overload
    def thenApplyAsync(self, function: java.util.function.Function, executor: Executor) -> CompletionStage: ...
    _thenCombine_0__U = _py_TypeVar('_thenCombine_0__U')  # <U>
    _thenCombine_0__V = _py_TypeVar('_thenCombine_0__V')  # <V>
    @overload
    def thenCombine(self, completionStage: CompletionStage[_thenCombine_0__U], biFunction: java.util.function.BiFunction[_CompletableFuture__T, _thenCombine_0__U, _thenCombine_0__V]) -> 'CompletableFuture'[_thenCombine_0__V]: ...
    @overload
    def thenCombine(self, completionStage: CompletionStage, biFunction: java.util.function.BiFunction) -> CompletionStage: ...
    _thenCombineAsync_0__U = _py_TypeVar('_thenCombineAsync_0__U')  # <U>
    _thenCombineAsync_0__V = _py_TypeVar('_thenCombineAsync_0__V')  # <V>
    @overload
    def thenCombineAsync(self, completionStage: CompletionStage[_thenCombineAsync_0__U], biFunction: java.util.function.BiFunction[_CompletableFuture__T, _thenCombineAsync_0__U, _thenCombineAsync_0__V]) -> 'CompletableFuture'[_thenCombineAsync_0__V]: ...
    _thenCombineAsync_1__U = _py_TypeVar('_thenCombineAsync_1__U')  # <U>
    _thenCombineAsync_1__V = _py_TypeVar('_thenCombineAsync_1__V')  # <V>
    @overload
    def thenCombineAsync(self, completionStage: CompletionStage[_thenCombineAsync_1__U], biFunction: java.util.function.BiFunction[_CompletableFuture__T, _thenCombineAsync_1__U, _thenCombineAsync_1__V], executor: Executor) -> 'CompletableFuture'[_thenCombineAsync_1__V]: ...
    @overload
    def thenCombineAsync(self, completionStage: CompletionStage, biFunction: java.util.function.BiFunction) -> CompletionStage: ...
    @overload
    def thenCombineAsync(self, completionStage: CompletionStage, biFunction: java.util.function.BiFunction, executor: Executor) -> CompletionStage: ...
    _thenCompose_0__U = _py_TypeVar('_thenCompose_0__U')  # <U>
    @overload
    def thenCompose(self, function: java.util.function.Function[_CompletableFuture__T, CompletionStage[_thenCompose_0__U]]) -> 'CompletableFuture'[_thenCompose_0__U]: ...
    @overload
    def thenCompose(self, function: java.util.function.Function) -> CompletionStage: ...
    _thenComposeAsync_0__U = _py_TypeVar('_thenComposeAsync_0__U')  # <U>
    @overload
    def thenComposeAsync(self, function: java.util.function.Function[_CompletableFuture__T, CompletionStage[_thenComposeAsync_0__U]]) -> 'CompletableFuture'[_thenComposeAsync_0__U]: ...
    _thenComposeAsync_1__U = _py_TypeVar('_thenComposeAsync_1__U')  # <U>
    @overload
    def thenComposeAsync(self, function: java.util.function.Function[_CompletableFuture__T, CompletionStage[_thenComposeAsync_1__U]], executor: Executor) -> 'CompletableFuture'[_thenComposeAsync_1__U]: ...
    @overload
    def thenComposeAsync(self, function: java.util.function.Function) -> CompletionStage: ...
    @overload
    def thenComposeAsync(self, function: java.util.function.Function, executor: Executor) -> CompletionStage: ...
    @overload
    def thenRun(self, runnable: java.lang.Runnable) -> 'CompletableFuture'[java.lang.Void]: ...
    @overload
    def thenRun(self, runnable: java.lang.Runnable) -> CompletionStage: ...
    @overload
    def thenRunAsync(self, runnable: java.lang.Runnable) -> 'CompletableFuture'[java.lang.Void]: ...
    @overload
    def thenRunAsync(self, runnable: java.lang.Runnable, executor: Executor) -> 'CompletableFuture'[java.lang.Void]: ...
    @overload
    def thenRunAsync(self, runnable: java.lang.Runnable) -> CompletionStage: ...
    @overload
    def thenRunAsync(self, runnable: java.lang.Runnable, executor: Executor) -> CompletionStage: ...
    def toCompletableFuture(self) -> 'CompletableFuture'[_CompletableFuture__T]: ...
    def toString(self) -> str: ...
    @overload
    def whenComplete(self, biConsumer: java.util.function.BiConsumer[_CompletableFuture__T, java.lang.Throwable]) -> 'CompletableFuture'[_CompletableFuture__T]: ...
    @overload
    def whenComplete(self, biConsumer: java.util.function.BiConsumer) -> CompletionStage: ...
    @overload
    def whenCompleteAsync(self, biConsumer: java.util.function.BiConsumer[_CompletableFuture__T, java.lang.Throwable]) -> 'CompletableFuture'[_CompletableFuture__T]: ...
    @overload
    def whenCompleteAsync(self, biConsumer: java.util.function.BiConsumer[_CompletableFuture__T, java.lang.Throwable], executor: Executor) -> 'CompletableFuture'[_CompletableFuture__T]: ...
    @overload
    def whenCompleteAsync(self, biConsumer: java.util.function.BiConsumer) -> CompletionStage: ...
    @overload
    def whenCompleteAsync(self, biConsumer: java.util.function.BiConsumer, executor: Executor) -> CompletionStage: ...
    class AsynchronousCompletionTask: ...

_ConcurrentNavigableMap__K = _py_TypeVar('_ConcurrentNavigableMap__K')  # <K>
_ConcurrentNavigableMap__V = _py_TypeVar('_ConcurrentNavigableMap__V')  # <V>
class ConcurrentNavigableMap(ConcurrentMap[_ConcurrentNavigableMap__K, _ConcurrentNavigableMap__V], java.util.NavigableMap[_ConcurrentNavigableMap__K, _ConcurrentNavigableMap__V], _py_Generic[_ConcurrentNavigableMap__K, _ConcurrentNavigableMap__V]):
    def descendingKeySet(self) -> java.util.NavigableSet[_ConcurrentNavigableMap__K]: ...
    @overload
    def descendingMap(self) -> 'ConcurrentNavigableMap'[_ConcurrentNavigableMap__K, _ConcurrentNavigableMap__V]: ...
    @overload
    def descendingMap(self) -> java.util.NavigableMap: ...
    def equals(self, object: _py_Any) -> bool: ...
    def hashCode(self) -> int: ...
    @overload
    def headMap(self, k: _ConcurrentNavigableMap__K) -> 'ConcurrentNavigableMap'[_ConcurrentNavigableMap__K, _ConcurrentNavigableMap__V]: ...
    @overload
    def headMap(self, k: _ConcurrentNavigableMap__K, boolean: bool) -> 'ConcurrentNavigableMap'[_ConcurrentNavigableMap__K, _ConcurrentNavigableMap__V]: ...
    @overload
    def headMap(self, object: _py_Any, boolean: bool) -> java.util.NavigableMap: ...
    @overload
    def headMap(self, object: _py_Any) -> java.util.SortedMap: ...
    @overload
    def keySet(self) -> java.util.NavigableSet[_ConcurrentNavigableMap__K]: ...
    @overload
    def keySet(self) -> java.util.Set: ...
    def navigableKeySet(self) -> java.util.NavigableSet[_ConcurrentNavigableMap__K]: ...
    @overload
    def subMap(self, k: _ConcurrentNavigableMap__K, boolean: bool, k2: _ConcurrentNavigableMap__K, boolean2: bool) -> 'ConcurrentNavigableMap'[_ConcurrentNavigableMap__K, _ConcurrentNavigableMap__V]: ...
    @overload
    def subMap(self, k: _ConcurrentNavigableMap__K, k2: _ConcurrentNavigableMap__K) -> 'ConcurrentNavigableMap'[_ConcurrentNavigableMap__K, _ConcurrentNavigableMap__V]: ...
    @overload
    def subMap(self, object: _py_Any, boolean: bool, object2: _py_Any, boolean2: bool) -> java.util.NavigableMap: ...
    @overload
    def subMap(self, object: _py_Any, object2: _py_Any) -> java.util.SortedMap: ...
    @overload
    def tailMap(self, k: _ConcurrentNavigableMap__K) -> 'ConcurrentNavigableMap'[_ConcurrentNavigableMap__K, _ConcurrentNavigableMap__V]: ...
    @overload
    def tailMap(self, k: _ConcurrentNavigableMap__K, boolean: bool) -> 'ConcurrentNavigableMap'[_ConcurrentNavigableMap__K, _ConcurrentNavigableMap__V]: ...
    @overload
    def tailMap(self, object: _py_Any, boolean: bool) -> java.util.NavigableMap: ...
    @overload
    def tailMap(self, object: _py_Any) -> java.util.SortedMap: ...

_DelayQueue__E = _py_TypeVar('_DelayQueue__E', bound=Delayed)  # <E>
class DelayQueue(java.util.AbstractQueue[_DelayQueue__E], BlockingQueue[_DelayQueue__E], _py_Generic[_DelayQueue__E]):
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, collection: java.util.Collection[_DelayQueue__E]): ...
    @overload
    def add(self, object: _py_Any) -> bool: ...
    @overload
    def add(self, e: _DelayQueue__E) -> bool: ...
    def clear(self) -> None: ...
    @overload
    def drainTo(self, collection: java.util.Collection[_DelayQueue__E]) -> int: ...
    @overload
    def drainTo(self, collection: java.util.Collection[_DelayQueue__E], int: int) -> int: ...
    def iterator(self) -> java.util.Iterator[_DelayQueue__E]: ...
    @overload
    def offer(self, object: _py_Any) -> bool: ...
    @overload
    def offer(self, object: _py_Any, long: int, timeUnit: TimeUnit) -> bool: ...
    @overload
    def offer(self, e: _DelayQueue__E) -> bool: ...
    @overload
    def offer(self, e: _DelayQueue__E, long: int, timeUnit: TimeUnit) -> bool: ...
    @overload
    def peek(self) -> _py_Any: ...
    @overload
    def peek(self) -> _DelayQueue__E: ...
    @overload
    def poll(self) -> _py_Any: ...
    @overload
    def poll(self, long: int, timeUnit: TimeUnit) -> _py_Any: ...
    @overload
    def poll(self) -> _DelayQueue__E: ...
    @overload
    def poll(self, long: int, timeUnit: TimeUnit) -> _DelayQueue__E: ...
    @overload
    def put(self, object: _py_Any) -> None: ...
    @overload
    def put(self, e: _DelayQueue__E) -> None: ...
    def remainingCapacity(self) -> int: ...
    @overload
    def remove(self, object: _py_Any) -> bool: ...
    @overload
    def remove(self) -> _DelayQueue__E: ...
    def size(self) -> int: ...
    @overload
    def take(self) -> _py_Any: ...
    @overload
    def take(self) -> _DelayQueue__E: ...
    @overload
    def toArray(self) -> _py_List[_py_Any]: ...
    _toArray_1__T = _py_TypeVar('_toArray_1__T')  # <T>
    @overload
    def toArray(self, tArray: _py_List[_toArray_1__T]) -> _py_List[_toArray_1__T]: ...

_ExecutorCompletionService__V = _py_TypeVar('_ExecutorCompletionService__V')  # <V>
class ExecutorCompletionService(CompletionService[_ExecutorCompletionService__V], _py_Generic[_ExecutorCompletionService__V]):
    @overload
    def __init__(self, executor: Executor): ...
    @overload
    def __init__(self, executor: Executor, blockingQueue: BlockingQueue[Future[_ExecutorCompletionService__V]]): ...
    @overload
    def poll(self) -> Future[_ExecutorCompletionService__V]: ...
    @overload
    def poll(self, long: int, timeUnit: TimeUnit) -> Future[_ExecutorCompletionService__V]: ...
    @overload
    def submit(self, runnable: java.lang.Runnable, v: _ExecutorCompletionService__V) -> Future[_ExecutorCompletionService__V]: ...
    @overload
    def submit(self, callable: Callable[_ExecutorCompletionService__V]) -> Future[_ExecutorCompletionService__V]: ...
    def take(self) -> Future[_ExecutorCompletionService__V]: ...

class ExecutorService(Executor):
    def awaitTermination(self, long: int, timeUnit: TimeUnit) -> bool: ...
    _invokeAll_0__T = _py_TypeVar('_invokeAll_0__T')  # <T>
    @overload
    def invokeAll(self, collection: java.util.Collection[Callable[_invokeAll_0__T]]) -> java.util.List[Future[_invokeAll_0__T]]: ...
    _invokeAll_1__T = _py_TypeVar('_invokeAll_1__T')  # <T>
    @overload
    def invokeAll(self, collection: java.util.Collection[Callable[_invokeAll_1__T]], long: int, timeUnit: TimeUnit) -> java.util.List[Future[_invokeAll_1__T]]: ...
    _invokeAny_0__T = _py_TypeVar('_invokeAny_0__T')  # <T>
    @overload
    def invokeAny(self, collection: java.util.Collection[Callable[_invokeAny_0__T]]) -> _invokeAny_0__T: ...
    _invokeAny_1__T = _py_TypeVar('_invokeAny_1__T')  # <T>
    @overload
    def invokeAny(self, collection: java.util.Collection[Callable[_invokeAny_1__T]], long: int, timeUnit: TimeUnit) -> _invokeAny_1__T: ...
    def isShutdown(self) -> bool: ...
    def isTerminated(self) -> bool: ...
    def shutdown(self) -> None: ...
    def shutdownNow(self) -> java.util.List[java.lang.Runnable]: ...
    @overload
    def submit(self, runnable: java.lang.Runnable) -> Future[_py_Any]: ...
    _submit_1__T = _py_TypeVar('_submit_1__T')  # <T>
    @overload
    def submit(self, runnable: java.lang.Runnable, t: _submit_1__T) -> Future[_submit_1__T]: ...
    _submit_2__T = _py_TypeVar('_submit_2__T')  # <T>
    @overload
    def submit(self, callable: Callable[_submit_2__T]) -> Future[_submit_2__T]: ...

_ForkJoinTask__V = _py_TypeVar('_ForkJoinTask__V')  # <V>
class ForkJoinTask(Future[_ForkJoinTask__V], java.io.Serializable, _py_Generic[_ForkJoinTask__V]):
    def __init__(self): ...
    @classmethod
    @overload
    def adapt(cls, runnable: java.lang.Runnable) -> 'ForkJoinTask'[_py_Any]: ...
    _adapt_1__T = _py_TypeVar('_adapt_1__T')  # <T>
    @classmethod
    @overload
    def adapt(cls, runnable: java.lang.Runnable, t: _adapt_1__T) -> 'ForkJoinTask'[_adapt_1__T]: ...
    _adapt_2__T = _py_TypeVar('_adapt_2__T')  # <T>
    @classmethod
    @overload
    def adapt(cls, callable: Callable[_adapt_2__T]) -> 'ForkJoinTask'[_adapt_2__T]: ...
    def cancel(self, boolean: bool) -> bool: ...
    def compareAndSetForkJoinTaskTag(self, short: int, short2: int) -> bool: ...
    def complete(self, v: _ForkJoinTask__V) -> None: ...
    def completeExceptionally(self, throwable: java.lang.Throwable) -> None: ...
    def fork(self) -> 'ForkJoinTask'[_ForkJoinTask__V]: ...
    @overload
    def get(self) -> _ForkJoinTask__V: ...
    @overload
    def get(self, long: int, timeUnit: TimeUnit) -> _ForkJoinTask__V: ...
    def getException(self) -> java.lang.Throwable: ...
    def getForkJoinTaskTag(self) -> int: ...
    @classmethod
    def getPool(cls) -> 'ForkJoinPool': ...
    @classmethod
    def getQueuedTaskCount(cls) -> int: ...
    def getRawResult(self) -> _ForkJoinTask__V: ...
    @classmethod
    def getSurplusQueuedTaskCount(cls) -> int: ...
    @classmethod
    def helpQuiesce(cls) -> None: ...
    @classmethod
    def inForkJoinPool(cls) -> bool: ...
    def invoke(self) -> _ForkJoinTask__V: ...
    _invokeAll_0__T = _py_TypeVar('_invokeAll_0__T', bound='ForkJoinTask')  # <T>
    @classmethod
    @overload
    def invokeAll(cls, collection: java.util.Collection[_invokeAll_0__T]) -> java.util.Collection[_invokeAll_0__T]: ...
    @classmethod
    @overload
    def invokeAll(cls, forkJoinTask: 'ForkJoinTask'[_py_Any], forkJoinTask2: 'ForkJoinTask'[_py_Any]) -> None: ...
    @classmethod
    @overload
    def invokeAll(cls, forkJoinTaskArray: _py_List['ForkJoinTask'[_py_Any]]) -> None: ...
    def isCancelled(self) -> bool: ...
    def isCompletedAbnormally(self) -> bool: ...
    def isCompletedNormally(self) -> bool: ...
    def isDone(self) -> bool: ...
    def join(self) -> _ForkJoinTask__V: ...
    def quietlyComplete(self) -> None: ...
    def quietlyInvoke(self) -> None: ...
    def quietlyJoin(self) -> None: ...
    def reinitialize(self) -> None: ...
    def setForkJoinTaskTag(self, short: int) -> int: ...
    def tryUnfork(self) -> bool: ...

_LinkedBlockingQueue__E = _py_TypeVar('_LinkedBlockingQueue__E')  # <E>
class LinkedBlockingQueue(java.util.AbstractQueue[_LinkedBlockingQueue__E], BlockingQueue[_LinkedBlockingQueue__E], java.io.Serializable, _py_Generic[_LinkedBlockingQueue__E]):
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, int: int): ...
    @overload
    def __init__(self, collection: java.util.Collection[_LinkedBlockingQueue__E]): ...
    def clear(self) -> None: ...
    def contains(self, object: _py_Any) -> bool: ...
    @overload
    def drainTo(self, collection: java.util.Collection[_LinkedBlockingQueue__E]) -> int: ...
    @overload
    def drainTo(self, collection: java.util.Collection[_LinkedBlockingQueue__E], int: int) -> int: ...
    def iterator(self) -> java.util.Iterator[_LinkedBlockingQueue__E]: ...
    @overload
    def offer(self, e: _LinkedBlockingQueue__E) -> bool: ...
    @overload
    def offer(self, e: _LinkedBlockingQueue__E, long: int, timeUnit: TimeUnit) -> bool: ...
    def peek(self) -> _LinkedBlockingQueue__E: ...
    @overload
    def poll(self) -> _LinkedBlockingQueue__E: ...
    @overload
    def poll(self, long: int, timeUnit: TimeUnit) -> _LinkedBlockingQueue__E: ...
    def put(self, e: _LinkedBlockingQueue__E) -> None: ...
    def remainingCapacity(self) -> int: ...
    @overload
    def remove(self, object: _py_Any) -> bool: ...
    @overload
    def remove(self) -> _LinkedBlockingQueue__E: ...
    def size(self) -> int: ...
    def spliterator(self) -> java.util.Spliterator[_LinkedBlockingQueue__E]: ...
    def take(self) -> _LinkedBlockingQueue__E: ...
    @overload
    def toArray(self) -> _py_List[_py_Any]: ...
    _toArray_1__T = _py_TypeVar('_toArray_1__T')  # <T>
    @overload
    def toArray(self, tArray: _py_List[_toArray_1__T]) -> _py_List[_toArray_1__T]: ...
    def toString(self) -> str: ...

_PriorityBlockingQueue__E = _py_TypeVar('_PriorityBlockingQueue__E')  # <E>
class PriorityBlockingQueue(java.util.AbstractQueue[_PriorityBlockingQueue__E], BlockingQueue[_PriorityBlockingQueue__E], java.io.Serializable, _py_Generic[_PriorityBlockingQueue__E]):
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, int: int): ...
    @overload
    def __init__(self, int: int, comparator: java.util.Comparator[_PriorityBlockingQueue__E]): ...
    @overload
    def __init__(self, collection: java.util.Collection[_PriorityBlockingQueue__E]): ...
    def add(self, e: _PriorityBlockingQueue__E) -> bool: ...
    def clear(self) -> None: ...
    def comparator(self) -> java.util.Comparator[_PriorityBlockingQueue__E]: ...
    def contains(self, object: _py_Any) -> bool: ...
    @overload
    def drainTo(self, collection: java.util.Collection[_PriorityBlockingQueue__E]) -> int: ...
    @overload
    def drainTo(self, collection: java.util.Collection[_PriorityBlockingQueue__E], int: int) -> int: ...
    def iterator(self) -> java.util.Iterator[_PriorityBlockingQueue__E]: ...
    @overload
    def offer(self, e: _PriorityBlockingQueue__E) -> bool: ...
    @overload
    def offer(self, e: _PriorityBlockingQueue__E, long: int, timeUnit: TimeUnit) -> bool: ...
    def peek(self) -> _PriorityBlockingQueue__E: ...
    @overload
    def poll(self) -> _PriorityBlockingQueue__E: ...
    @overload
    def poll(self, long: int, timeUnit: TimeUnit) -> _PriorityBlockingQueue__E: ...
    def put(self, e: _PriorityBlockingQueue__E) -> None: ...
    def remainingCapacity(self) -> int: ...
    @overload
    def remove(self, object: _py_Any) -> bool: ...
    @overload
    def remove(self) -> _PriorityBlockingQueue__E: ...
    def size(self) -> int: ...
    def spliterator(self) -> java.util.Spliterator[_PriorityBlockingQueue__E]: ...
    def take(self) -> _PriorityBlockingQueue__E: ...
    @overload
    def toArray(self) -> _py_List[_py_Any]: ...
    _toArray_1__T = _py_TypeVar('_toArray_1__T')  # <T>
    @overload
    def toArray(self, tArray: _py_List[_toArray_1__T]) -> _py_List[_toArray_1__T]: ...
    def toString(self) -> str: ...

_RunnableFuture__V = _py_TypeVar('_RunnableFuture__V')  # <V>
class RunnableFuture(java.lang.Runnable, Future[_RunnableFuture__V], _py_Generic[_RunnableFuture__V]):
    def run(self) -> None: ...

_ScheduledFuture__V = _py_TypeVar('_ScheduledFuture__V')  # <V>
class ScheduledFuture(Delayed, Future[_ScheduledFuture__V], _py_Generic[_ScheduledFuture__V]): ...

_SynchronousQueue__E = _py_TypeVar('_SynchronousQueue__E')  # <E>
class SynchronousQueue(java.util.AbstractQueue[_SynchronousQueue__E], BlockingQueue[_SynchronousQueue__E], java.io.Serializable, _py_Generic[_SynchronousQueue__E]):
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, boolean: bool): ...
    def clear(self) -> None: ...
    def contains(self, object: _py_Any) -> bool: ...
    def containsAll(self, collection: java.util.Collection[_py_Any]) -> bool: ...
    @overload
    def drainTo(self, collection: java.util.Collection[_SynchronousQueue__E]) -> int: ...
    @overload
    def drainTo(self, collection: java.util.Collection[_SynchronousQueue__E], int: int) -> int: ...
    def isEmpty(self) -> bool: ...
    def iterator(self) -> java.util.Iterator[_SynchronousQueue__E]: ...
    @overload
    def offer(self, e: _SynchronousQueue__E) -> bool: ...
    @overload
    def offer(self, e: _SynchronousQueue__E, long: int, timeUnit: TimeUnit) -> bool: ...
    def peek(self) -> _SynchronousQueue__E: ...
    @overload
    def poll(self) -> _SynchronousQueue__E: ...
    @overload
    def poll(self, long: int, timeUnit: TimeUnit) -> _SynchronousQueue__E: ...
    def put(self, e: _SynchronousQueue__E) -> None: ...
    def remainingCapacity(self) -> int: ...
    @overload
    def remove(self, object: _py_Any) -> bool: ...
    @overload
    def remove(self) -> _SynchronousQueue__E: ...
    def removeAll(self, collection: java.util.Collection[_py_Any]) -> bool: ...
    def retainAll(self, collection: java.util.Collection[_py_Any]) -> bool: ...
    def size(self) -> int: ...
    def spliterator(self) -> java.util.Spliterator[_SynchronousQueue__E]: ...
    def take(self) -> _SynchronousQueue__E: ...
    @overload
    def toArray(self) -> _py_List[_py_Any]: ...
    _toArray_1__T = _py_TypeVar('_toArray_1__T')  # <T>
    @overload
    def toArray(self, tArray: _py_List[_toArray_1__T]) -> _py_List[_toArray_1__T]: ...

_TransferQueue__E = _py_TypeVar('_TransferQueue__E')  # <E>
class TransferQueue(BlockingQueue[_TransferQueue__E], _py_Generic[_TransferQueue__E]):
    def equals(self, object: _py_Any) -> bool: ...
    def getWaitingConsumerCount(self) -> int: ...
    def hasWaitingConsumer(self) -> bool: ...
    def hashCode(self) -> int: ...
    def transfer(self, e: _TransferQueue__E) -> None: ...
    @overload
    def tryTransfer(self, e: _TransferQueue__E) -> bool: ...
    @overload
    def tryTransfer(self, e: _TransferQueue__E, long: int, timeUnit: TimeUnit) -> bool: ...

class AbstractExecutorService(ExecutorService):
    def __init__(self): ...
    _invokeAll_0__T = _py_TypeVar('_invokeAll_0__T')  # <T>
    @overload
    def invokeAll(self, collection: java.util.Collection[Callable[_invokeAll_0__T]]) -> java.util.List[Future[_invokeAll_0__T]]: ...
    _invokeAll_1__T = _py_TypeVar('_invokeAll_1__T')  # <T>
    @overload
    def invokeAll(self, collection: java.util.Collection[Callable[_invokeAll_1__T]], long: int, timeUnit: TimeUnit) -> java.util.List[Future[_invokeAll_1__T]]: ...
    _invokeAny_0__T = _py_TypeVar('_invokeAny_0__T')  # <T>
    @overload
    def invokeAny(self, collection: java.util.Collection[Callable[_invokeAny_0__T]]) -> _invokeAny_0__T: ...
    _invokeAny_1__T = _py_TypeVar('_invokeAny_1__T')  # <T>
    @overload
    def invokeAny(self, collection: java.util.Collection[Callable[_invokeAny_1__T]], long: int, timeUnit: TimeUnit) -> _invokeAny_1__T: ...
    @overload
    def submit(self, runnable: java.lang.Runnable) -> Future[_py_Any]: ...
    _submit_1__T = _py_TypeVar('_submit_1__T')  # <T>
    @overload
    def submit(self, runnable: java.lang.Runnable, t: _submit_1__T) -> Future[_submit_1__T]: ...
    _submit_2__T = _py_TypeVar('_submit_2__T')  # <T>
    @overload
    def submit(self, callable: Callable[_submit_2__T]) -> Future[_submit_2__T]: ...

_ConcurrentSkipListMap__K = _py_TypeVar('_ConcurrentSkipListMap__K')  # <K>
_ConcurrentSkipListMap__V = _py_TypeVar('_ConcurrentSkipListMap__V')  # <V>
class ConcurrentSkipListMap(java.util.AbstractMap[_ConcurrentSkipListMap__K, _ConcurrentSkipListMap__V], ConcurrentNavigableMap[_ConcurrentSkipListMap__K, _ConcurrentSkipListMap__V], java.lang.Cloneable, java.io.Serializable, _py_Generic[_ConcurrentSkipListMap__K, _ConcurrentSkipListMap__V]):
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, comparator: java.util.Comparator[_ConcurrentSkipListMap__K]): ...
    @overload
    def __init__(self, map: java.util.Map[_ConcurrentSkipListMap__K, _ConcurrentSkipListMap__V]): ...
    @overload
    def __init__(self, sortedMap: java.util.SortedMap[_ConcurrentSkipListMap__K, _ConcurrentSkipListMap__V]): ...
    def ceilingEntry(self, k: _ConcurrentSkipListMap__K) -> java.util.Map.Entry[_ConcurrentSkipListMap__K, _ConcurrentSkipListMap__V]: ...
    def ceilingKey(self, k: _ConcurrentSkipListMap__K) -> _ConcurrentSkipListMap__K: ...
    def clear(self) -> None: ...
    @overload
    def clone(self) -> _py_Any: ...
    @overload
    def clone(self) -> 'ConcurrentSkipListMap'[_ConcurrentSkipListMap__K, _ConcurrentSkipListMap__V]: ...
    def comparator(self) -> java.util.Comparator[_ConcurrentSkipListMap__K]: ...
    def compute(self, k: _ConcurrentSkipListMap__K, biFunction: java.util.function.BiFunction[_ConcurrentSkipListMap__K, _ConcurrentSkipListMap__V, _ConcurrentSkipListMap__V]) -> _ConcurrentSkipListMap__V: ...
    def computeIfAbsent(self, k: _ConcurrentSkipListMap__K, function: java.util.function.Function[_ConcurrentSkipListMap__K, _ConcurrentSkipListMap__V]) -> _ConcurrentSkipListMap__V: ...
    def computeIfPresent(self, k: _ConcurrentSkipListMap__K, biFunction: java.util.function.BiFunction[_ConcurrentSkipListMap__K, _ConcurrentSkipListMap__V, _ConcurrentSkipListMap__V]) -> _ConcurrentSkipListMap__V: ...
    def containsKey(self, object: _py_Any) -> bool: ...
    def containsValue(self, object: _py_Any) -> bool: ...
    def descendingKeySet(self) -> java.util.NavigableSet[_ConcurrentSkipListMap__K]: ...
    @overload
    def descendingMap(self) -> java.util.NavigableMap: ...
    @overload
    def descendingMap(self) -> ConcurrentNavigableMap[_ConcurrentSkipListMap__K, _ConcurrentSkipListMap__V]: ...
    def entrySet(self) -> java.util.Set[java.util.Map.Entry[_ConcurrentSkipListMap__K, _ConcurrentSkipListMap__V]]: ...
    def equals(self, object: _py_Any) -> bool: ...
    def firstEntry(self) -> java.util.Map.Entry[_ConcurrentSkipListMap__K, _ConcurrentSkipListMap__V]: ...
    def firstKey(self) -> _ConcurrentSkipListMap__K: ...
    def floorEntry(self, k: _ConcurrentSkipListMap__K) -> java.util.Map.Entry[_ConcurrentSkipListMap__K, _ConcurrentSkipListMap__V]: ...
    def floorKey(self, k: _ConcurrentSkipListMap__K) -> _ConcurrentSkipListMap__K: ...
    def forEach(self, biConsumer: java.util.function.BiConsumer[_ConcurrentSkipListMap__K, _ConcurrentSkipListMap__V]) -> None: ...
    def get(self, object: _py_Any) -> _ConcurrentSkipListMap__V: ...
    def getOrDefault(self, object: _py_Any, v: _ConcurrentSkipListMap__V) -> _ConcurrentSkipListMap__V: ...
    @overload
    def headMap(self, object: _py_Any, boolean: bool) -> java.util.NavigableMap: ...
    @overload
    def headMap(self, object: _py_Any) -> java.util.SortedMap: ...
    @overload
    def headMap(self, k: _ConcurrentSkipListMap__K) -> ConcurrentNavigableMap[_ConcurrentSkipListMap__K, _ConcurrentSkipListMap__V]: ...
    @overload
    def headMap(self, k: _ConcurrentSkipListMap__K, boolean: bool) -> ConcurrentNavigableMap[_ConcurrentSkipListMap__K, _ConcurrentSkipListMap__V]: ...
    def higherEntry(self, k: _ConcurrentSkipListMap__K) -> java.util.Map.Entry[_ConcurrentSkipListMap__K, _ConcurrentSkipListMap__V]: ...
    def higherKey(self, k: _ConcurrentSkipListMap__K) -> _ConcurrentSkipListMap__K: ...
    def isEmpty(self) -> bool: ...
    @overload
    def keySet(self) -> java.util.NavigableSet[_ConcurrentSkipListMap__K]: ...
    @overload
    def keySet(self) -> java.util.Set: ...
    def lastEntry(self) -> java.util.Map.Entry[_ConcurrentSkipListMap__K, _ConcurrentSkipListMap__V]: ...
    def lastKey(self) -> _ConcurrentSkipListMap__K: ...
    def lowerEntry(self, k: _ConcurrentSkipListMap__K) -> java.util.Map.Entry[_ConcurrentSkipListMap__K, _ConcurrentSkipListMap__V]: ...
    def lowerKey(self, k: _ConcurrentSkipListMap__K) -> _ConcurrentSkipListMap__K: ...
    def merge(self, k: _ConcurrentSkipListMap__K, v: _ConcurrentSkipListMap__V, biFunction: java.util.function.BiFunction[_ConcurrentSkipListMap__V, _ConcurrentSkipListMap__V, _ConcurrentSkipListMap__V]) -> _ConcurrentSkipListMap__V: ...
    def navigableKeySet(self) -> java.util.NavigableSet[_ConcurrentSkipListMap__K]: ...
    def pollFirstEntry(self) -> java.util.Map.Entry[_ConcurrentSkipListMap__K, _ConcurrentSkipListMap__V]: ...
    def pollLastEntry(self) -> java.util.Map.Entry[_ConcurrentSkipListMap__K, _ConcurrentSkipListMap__V]: ...
    def put(self, k: _ConcurrentSkipListMap__K, v: _ConcurrentSkipListMap__V) -> _ConcurrentSkipListMap__V: ...
    def putIfAbsent(self, k: _ConcurrentSkipListMap__K, v: _ConcurrentSkipListMap__V) -> _ConcurrentSkipListMap__V: ...
    @overload
    def remove(self, object: _py_Any, object2: _py_Any) -> bool: ...
    @overload
    def remove(self, object: _py_Any) -> _ConcurrentSkipListMap__V: ...
    @overload
    def replace(self, k: _ConcurrentSkipListMap__K, v: _ConcurrentSkipListMap__V, v2: _ConcurrentSkipListMap__V) -> bool: ...
    @overload
    def replace(self, k: _ConcurrentSkipListMap__K, v: _ConcurrentSkipListMap__V) -> _ConcurrentSkipListMap__V: ...
    def replaceAll(self, biFunction: java.util.function.BiFunction[_ConcurrentSkipListMap__K, _ConcurrentSkipListMap__V, _ConcurrentSkipListMap__V]) -> None: ...
    def size(self) -> int: ...
    @overload
    def subMap(self, object: _py_Any, boolean: bool, object2: _py_Any, boolean2: bool) -> java.util.NavigableMap: ...
    @overload
    def subMap(self, object: _py_Any, object2: _py_Any) -> java.util.SortedMap: ...
    @overload
    def subMap(self, k: _ConcurrentSkipListMap__K, boolean: bool, k2: _ConcurrentSkipListMap__K, boolean2: bool) -> ConcurrentNavigableMap[_ConcurrentSkipListMap__K, _ConcurrentSkipListMap__V]: ...
    @overload
    def subMap(self, k: _ConcurrentSkipListMap__K, k2: _ConcurrentSkipListMap__K) -> ConcurrentNavigableMap[_ConcurrentSkipListMap__K, _ConcurrentSkipListMap__V]: ...
    @overload
    def tailMap(self, object: _py_Any, boolean: bool) -> java.util.NavigableMap: ...
    @overload
    def tailMap(self, object: _py_Any) -> java.util.SortedMap: ...
    @overload
    def tailMap(self, k: _ConcurrentSkipListMap__K) -> ConcurrentNavigableMap[_ConcurrentSkipListMap__K, _ConcurrentSkipListMap__V]: ...
    @overload
    def tailMap(self, k: _ConcurrentSkipListMap__K, boolean: bool) -> ConcurrentNavigableMap[_ConcurrentSkipListMap__K, _ConcurrentSkipListMap__V]: ...
    def values(self) -> java.util.Collection[_ConcurrentSkipListMap__V]: ...

_CountedCompleter__T = _py_TypeVar('_CountedCompleter__T')  # <T>
class CountedCompleter(ForkJoinTask[_CountedCompleter__T], _py_Generic[_CountedCompleter__T]):
    def addToPendingCount(self, int: int) -> None: ...
    def compareAndSetPendingCount(self, int: int, int2: int) -> bool: ...
    def complete(self, t: _CountedCompleter__T) -> None: ...
    def compute(self) -> None: ...
    def decrementPendingCountUnlessZero(self) -> int: ...
    def firstComplete(self) -> 'CountedCompleter'[_py_Any]: ...
    def getCompleter(self) -> 'CountedCompleter'[_py_Any]: ...
    def getPendingCount(self) -> int: ...
    def getRawResult(self) -> _CountedCompleter__T: ...
    def getRoot(self) -> 'CountedCompleter'[_py_Any]: ...
    def helpComplete(self, int: int) -> None: ...
    def nextComplete(self) -> 'CountedCompleter'[_py_Any]: ...
    def onCompletion(self, countedCompleter: 'CountedCompleter'[_py_Any]) -> None: ...
    def onExceptionalCompletion(self, throwable: java.lang.Throwable, countedCompleter: 'CountedCompleter'[_py_Any]) -> bool: ...
    def propagateCompletion(self) -> None: ...
    def quietlyCompleteRoot(self) -> None: ...
    def setPendingCount(self, int: int) -> None: ...
    def tryComplete(self) -> None: ...

_FutureTask__V = _py_TypeVar('_FutureTask__V')  # <V>
class FutureTask(RunnableFuture[_FutureTask__V], _py_Generic[_FutureTask__V]):
    @overload
    def __init__(self, runnable: java.lang.Runnable, v: _FutureTask__V): ...
    @overload
    def __init__(self, callable: Callable[_FutureTask__V]): ...
    def cancel(self, boolean: bool) -> bool: ...
    @overload
    def get(self) -> _FutureTask__V: ...
    @overload
    def get(self, long: int, timeUnit: TimeUnit) -> _FutureTask__V: ...
    def isCancelled(self) -> bool: ...
    def isDone(self) -> bool: ...
    def run(self) -> None: ...

_LinkedBlockingDeque__E = _py_TypeVar('_LinkedBlockingDeque__E')  # <E>
class LinkedBlockingDeque(java.util.AbstractQueue[_LinkedBlockingDeque__E], BlockingDeque[_LinkedBlockingDeque__E], java.io.Serializable, _py_Generic[_LinkedBlockingDeque__E]):
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, int: int): ...
    @overload
    def __init__(self, collection: java.util.Collection[_LinkedBlockingDeque__E]): ...
    def add(self, e: _LinkedBlockingDeque__E) -> bool: ...
    def addFirst(self, e: _LinkedBlockingDeque__E) -> None: ...
    def addLast(self, e: _LinkedBlockingDeque__E) -> None: ...
    def clear(self) -> None: ...
    def contains(self, object: _py_Any) -> bool: ...
    def descendingIterator(self) -> java.util.Iterator[_LinkedBlockingDeque__E]: ...
    @overload
    def drainTo(self, collection: java.util.Collection[_LinkedBlockingDeque__E]) -> int: ...
    @overload
    def drainTo(self, collection: java.util.Collection[_LinkedBlockingDeque__E], int: int) -> int: ...
    def element(self) -> _LinkedBlockingDeque__E: ...
    def getFirst(self) -> _LinkedBlockingDeque__E: ...
    def getLast(self) -> _LinkedBlockingDeque__E: ...
    def iterator(self) -> java.util.Iterator[_LinkedBlockingDeque__E]: ...
    @overload
    def offer(self, e: _LinkedBlockingDeque__E) -> bool: ...
    @overload
    def offer(self, e: _LinkedBlockingDeque__E, long: int, timeUnit: TimeUnit) -> bool: ...
    @overload
    def offerFirst(self, e: _LinkedBlockingDeque__E) -> bool: ...
    @overload
    def offerFirst(self, e: _LinkedBlockingDeque__E, long: int, timeUnit: TimeUnit) -> bool: ...
    @overload
    def offerLast(self, e: _LinkedBlockingDeque__E) -> bool: ...
    @overload
    def offerLast(self, e: _LinkedBlockingDeque__E, long: int, timeUnit: TimeUnit) -> bool: ...
    def peek(self) -> _LinkedBlockingDeque__E: ...
    def peekFirst(self) -> _LinkedBlockingDeque__E: ...
    def peekLast(self) -> _LinkedBlockingDeque__E: ...
    @overload
    def poll(self) -> _LinkedBlockingDeque__E: ...
    @overload
    def poll(self, long: int, timeUnit: TimeUnit) -> _LinkedBlockingDeque__E: ...
    @overload
    def pollFirst(self) -> _LinkedBlockingDeque__E: ...
    @overload
    def pollFirst(self, long: int, timeUnit: TimeUnit) -> _LinkedBlockingDeque__E: ...
    @overload
    def pollLast(self) -> _LinkedBlockingDeque__E: ...
    @overload
    def pollLast(self, long: int, timeUnit: TimeUnit) -> _LinkedBlockingDeque__E: ...
    def pop(self) -> _LinkedBlockingDeque__E: ...
    def push(self, e: _LinkedBlockingDeque__E) -> None: ...
    def put(self, e: _LinkedBlockingDeque__E) -> None: ...
    def putFirst(self, e: _LinkedBlockingDeque__E) -> None: ...
    def putLast(self, e: _LinkedBlockingDeque__E) -> None: ...
    def remainingCapacity(self) -> int: ...
    @overload
    def remove(self, object: _py_Any) -> bool: ...
    @overload
    def remove(self) -> _LinkedBlockingDeque__E: ...
    def removeFirst(self) -> _LinkedBlockingDeque__E: ...
    def removeFirstOccurrence(self, object: _py_Any) -> bool: ...
    def removeLast(self) -> _LinkedBlockingDeque__E: ...
    def removeLastOccurrence(self, object: _py_Any) -> bool: ...
    def size(self) -> int: ...
    def spliterator(self) -> java.util.Spliterator[_LinkedBlockingDeque__E]: ...
    def take(self) -> _LinkedBlockingDeque__E: ...
    def takeFirst(self) -> _LinkedBlockingDeque__E: ...
    def takeLast(self) -> _LinkedBlockingDeque__E: ...
    @overload
    def toArray(self) -> _py_List[_py_Any]: ...
    _toArray_1__T = _py_TypeVar('_toArray_1__T')  # <T>
    @overload
    def toArray(self, tArray: _py_List[_toArray_1__T]) -> _py_List[_toArray_1__T]: ...
    def toString(self) -> str: ...

_LinkedTransferQueue__E = _py_TypeVar('_LinkedTransferQueue__E')  # <E>
class LinkedTransferQueue(java.util.AbstractQueue[_LinkedTransferQueue__E], TransferQueue[_LinkedTransferQueue__E], java.io.Serializable, _py_Generic[_LinkedTransferQueue__E]):
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, collection: java.util.Collection[_LinkedTransferQueue__E]): ...
    def add(self, e: _LinkedTransferQueue__E) -> bool: ...
    def contains(self, object: _py_Any) -> bool: ...
    @overload
    def drainTo(self, collection: java.util.Collection[_LinkedTransferQueue__E]) -> int: ...
    @overload
    def drainTo(self, collection: java.util.Collection[_LinkedTransferQueue__E], int: int) -> int: ...
    def getWaitingConsumerCount(self) -> int: ...
    def hasWaitingConsumer(self) -> bool: ...
    def isEmpty(self) -> bool: ...
    def iterator(self) -> java.util.Iterator[_LinkedTransferQueue__E]: ...
    @overload
    def offer(self, e: _LinkedTransferQueue__E) -> bool: ...
    @overload
    def offer(self, e: _LinkedTransferQueue__E, long: int, timeUnit: TimeUnit) -> bool: ...
    def peek(self) -> _LinkedTransferQueue__E: ...
    @overload
    def poll(self) -> _LinkedTransferQueue__E: ...
    @overload
    def poll(self, long: int, timeUnit: TimeUnit) -> _LinkedTransferQueue__E: ...
    def put(self, e: _LinkedTransferQueue__E) -> None: ...
    def remainingCapacity(self) -> int: ...
    @overload
    def remove(self, object: _py_Any) -> bool: ...
    @overload
    def remove(self) -> _LinkedTransferQueue__E: ...
    def size(self) -> int: ...
    def spliterator(self) -> java.util.Spliterator[_LinkedTransferQueue__E]: ...
    def take(self) -> _LinkedTransferQueue__E: ...
    def transfer(self, e: _LinkedTransferQueue__E) -> None: ...
    @overload
    def tryTransfer(self, e: _LinkedTransferQueue__E) -> bool: ...
    @overload
    def tryTransfer(self, e: _LinkedTransferQueue__E, long: int, timeUnit: TimeUnit) -> bool: ...

class RecursiveAction(ForkJoinTask[java.lang.Void]):
    def __init__(self): ...
    @overload
    def getRawResult(self) -> java.lang.Void: ...
    @overload
    def getRawResult(self) -> _py_Any: ...

_RecursiveTask__V = _py_TypeVar('_RecursiveTask__V')  # <V>
class RecursiveTask(ForkJoinTask[_RecursiveTask__V], _py_Generic[_RecursiveTask__V]):
    def __init__(self): ...
    def getRawResult(self) -> _RecursiveTask__V: ...

_RunnableScheduledFuture__V = _py_TypeVar('_RunnableScheduledFuture__V')  # <V>
class RunnableScheduledFuture(RunnableFuture[_RunnableScheduledFuture__V], ScheduledFuture[_RunnableScheduledFuture__V], _py_Generic[_RunnableScheduledFuture__V]):
    def isPeriodic(self) -> bool: ...

class ScheduledExecutorService(ExecutorService):
    @overload
    def schedule(self, runnable: java.lang.Runnable, long: int, timeUnit: TimeUnit) -> ScheduledFuture[_py_Any]: ...
    _schedule_1__V = _py_TypeVar('_schedule_1__V')  # <V>
    @overload
    def schedule(self, callable: Callable[_schedule_1__V], long: int, timeUnit: TimeUnit) -> ScheduledFuture[_schedule_1__V]: ...
    def scheduleAtFixedRate(self, runnable: java.lang.Runnable, long: int, long2: int, timeUnit: TimeUnit) -> ScheduledFuture[_py_Any]: ...
    def scheduleWithFixedDelay(self, runnable: java.lang.Runnable, long: int, long2: int, timeUnit: TimeUnit) -> ScheduledFuture[_py_Any]: ...

class ForkJoinPool(AbstractExecutorService):
    defaultForkJoinWorkerThreadFactory: _py_ClassVar['ForkJoinPool.ForkJoinWorkerThreadFactory'] = ...
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, int: int): ...
    @overload
    def __init__(self, int: int, forkJoinWorkerThreadFactory: 'ForkJoinPool.ForkJoinWorkerThreadFactory', uncaughtExceptionHandler: java.lang.Thread.UncaughtExceptionHandler, boolean: bool): ...
    def awaitQuiescence(self, long: int, timeUnit: TimeUnit) -> bool: ...
    def awaitTermination(self, long: int, timeUnit: TimeUnit) -> bool: ...
    @classmethod
    def commonPool(cls) -> 'ForkJoinPool': ...
    @overload
    def execute(self, runnable: java.lang.Runnable) -> None: ...
    @overload
    def execute(self, forkJoinTask: ForkJoinTask[_py_Any]) -> None: ...
    def getActiveThreadCount(self) -> int: ...
    def getAsyncMode(self) -> bool: ...
    @classmethod
    def getCommonPoolParallelism(cls) -> int: ...
    def getFactory(self) -> 'ForkJoinPool.ForkJoinWorkerThreadFactory': ...
    def getParallelism(self) -> int: ...
    def getPoolSize(self) -> int: ...
    def getQueuedSubmissionCount(self) -> int: ...
    def getQueuedTaskCount(self) -> int: ...
    def getRunningThreadCount(self) -> int: ...
    def getStealCount(self) -> int: ...
    def getUncaughtExceptionHandler(self) -> java.lang.Thread.UncaughtExceptionHandler: ...
    def hasQueuedSubmissions(self) -> bool: ...
    _invoke__T = _py_TypeVar('_invoke__T')  # <T>
    def invoke(self, forkJoinTask: ForkJoinTask[_invoke__T]) -> _invoke__T: ...
    _invokeAll_0__T = _py_TypeVar('_invokeAll_0__T')  # <T>
    @overload
    def invokeAll(self, collection: java.util.Collection[Callable[_invokeAll_0__T]], long: int, timeUnit: TimeUnit) -> java.util.List[Future[_invokeAll_0__T]]: ...
    _invokeAll_1__T = _py_TypeVar('_invokeAll_1__T')  # <T>
    @overload
    def invokeAll(self, collection: java.util.Collection[Callable[_invokeAll_1__T]]) -> java.util.List[Future[_invokeAll_1__T]]: ...
    def isQuiescent(self) -> bool: ...
    def isShutdown(self) -> bool: ...
    def isTerminated(self) -> bool: ...
    def isTerminating(self) -> bool: ...
    @classmethod
    def managedBlock(cls, managedBlocker: 'ForkJoinPool.ManagedBlocker') -> None: ...
    def shutdown(self) -> None: ...
    def shutdownNow(self) -> java.util.List[java.lang.Runnable]: ...
    @overload
    def submit(self, runnable: java.lang.Runnable) -> ForkJoinTask[_py_Any]: ...
    _submit_1__T = _py_TypeVar('_submit_1__T')  # <T>
    @overload
    def submit(self, runnable: java.lang.Runnable, t: _submit_1__T) -> ForkJoinTask[_submit_1__T]: ...
    _submit_2__T = _py_TypeVar('_submit_2__T')  # <T>
    @overload
    def submit(self, callable: Callable[_submit_2__T]) -> ForkJoinTask[_submit_2__T]: ...
    _submit_3__T = _py_TypeVar('_submit_3__T')  # <T>
    @overload
    def submit(self, forkJoinTask: ForkJoinTask[_submit_3__T]) -> ForkJoinTask[_submit_3__T]: ...
    @overload
    def submit(self, runnable: java.lang.Runnable) -> Future: ...
    @overload
    def submit(self, runnable: java.lang.Runnable, object: _py_Any) -> Future: ...
    @overload
    def submit(self, callable: Callable) -> Future: ...
    def toString(self) -> str: ...
    class ForkJoinWorkerThreadFactory:
        def newThread(self, forkJoinPool: 'ForkJoinPool') -> ForkJoinWorkerThread: ...
    class ManagedBlocker:
        def block(self) -> bool: ...
        def isReleasable(self) -> bool: ...

class ThreadPoolExecutor(AbstractExecutorService):
    @overload
    def __init__(self, int: int, int2: int, long: int, timeUnit: TimeUnit, blockingQueue: BlockingQueue[java.lang.Runnable]): ...
    @overload
    def __init__(self, int: int, int2: int, long: int, timeUnit: TimeUnit, blockingQueue: BlockingQueue[java.lang.Runnable], rejectedExecutionHandler: RejectedExecutionHandler): ...
    @overload
    def __init__(self, int: int, int2: int, long: int, timeUnit: TimeUnit, blockingQueue: BlockingQueue[java.lang.Runnable], threadFactory: ThreadFactory): ...
    @overload
    def __init__(self, int: int, int2: int, long: int, timeUnit: TimeUnit, blockingQueue: BlockingQueue[java.lang.Runnable], threadFactory: ThreadFactory, rejectedExecutionHandler: RejectedExecutionHandler): ...
    def allowCoreThreadTimeOut(self, boolean: bool) -> None: ...
    def allowsCoreThreadTimeOut(self) -> bool: ...
    def awaitTermination(self, long: int, timeUnit: TimeUnit) -> bool: ...
    def execute(self, runnable: java.lang.Runnable) -> None: ...
    def getActiveCount(self) -> int: ...
    def getCompletedTaskCount(self) -> int: ...
    def getCorePoolSize(self) -> int: ...
    def getKeepAliveTime(self, timeUnit: TimeUnit) -> int: ...
    def getLargestPoolSize(self) -> int: ...
    def getMaximumPoolSize(self) -> int: ...
    def getPoolSize(self) -> int: ...
    def getQueue(self) -> BlockingQueue[java.lang.Runnable]: ...
    def getRejectedExecutionHandler(self) -> RejectedExecutionHandler: ...
    def getTaskCount(self) -> int: ...
    def getThreadFactory(self) -> ThreadFactory: ...
    def isShutdown(self) -> bool: ...
    def isTerminated(self) -> bool: ...
    def isTerminating(self) -> bool: ...
    def prestartAllCoreThreads(self) -> int: ...
    def prestartCoreThread(self) -> bool: ...
    def purge(self) -> None: ...
    def remove(self, runnable: java.lang.Runnable) -> bool: ...
    def setCorePoolSize(self, int: int) -> None: ...
    def setKeepAliveTime(self, long: int, timeUnit: TimeUnit) -> None: ...
    def setMaximumPoolSize(self, int: int) -> None: ...
    def setRejectedExecutionHandler(self, rejectedExecutionHandler: RejectedExecutionHandler) -> None: ...
    def setThreadFactory(self, threadFactory: ThreadFactory) -> None: ...
    def shutdown(self) -> None: ...
    def shutdownNow(self) -> java.util.List[java.lang.Runnable]: ...
    def toString(self) -> str: ...
    class AbortPolicy(RejectedExecutionHandler):
        def __init__(self): ...
        def rejectedExecution(self, runnable: java.lang.Runnable, threadPoolExecutor: 'ThreadPoolExecutor') -> None: ...
    class CallerRunsPolicy(RejectedExecutionHandler):
        def __init__(self): ...
        def rejectedExecution(self, runnable: java.lang.Runnable, threadPoolExecutor: 'ThreadPoolExecutor') -> None: ...
    class DiscardOldestPolicy(RejectedExecutionHandler):
        def __init__(self): ...
        def rejectedExecution(self, runnable: java.lang.Runnable, threadPoolExecutor: 'ThreadPoolExecutor') -> None: ...
    class DiscardPolicy(RejectedExecutionHandler):
        def __init__(self): ...
        def rejectedExecution(self, runnable: java.lang.Runnable, threadPoolExecutor: 'ThreadPoolExecutor') -> None: ...

class ScheduledThreadPoolExecutor(ThreadPoolExecutor, ScheduledExecutorService):
    @overload
    def __init__(self, int: int): ...
    @overload
    def __init__(self, int: int, rejectedExecutionHandler: RejectedExecutionHandler): ...
    @overload
    def __init__(self, int: int, threadFactory: ThreadFactory): ...
    @overload
    def __init__(self, int: int, threadFactory: ThreadFactory, rejectedExecutionHandler: RejectedExecutionHandler): ...
    def execute(self, runnable: java.lang.Runnable) -> None: ...
    def getContinueExistingPeriodicTasksAfterShutdownPolicy(self) -> bool: ...
    def getExecuteExistingDelayedTasksAfterShutdownPolicy(self) -> bool: ...
    def getQueue(self) -> BlockingQueue[java.lang.Runnable]: ...
    def getRemoveOnCancelPolicy(self) -> bool: ...
    @overload
    def schedule(self, runnable: java.lang.Runnable, long: int, timeUnit: TimeUnit) -> ScheduledFuture[_py_Any]: ...
    _schedule_1__V = _py_TypeVar('_schedule_1__V')  # <V>
    @overload
    def schedule(self, callable: Callable[_schedule_1__V], long: int, timeUnit: TimeUnit) -> ScheduledFuture[_schedule_1__V]: ...
    def scheduleAtFixedRate(self, runnable: java.lang.Runnable, long: int, long2: int, timeUnit: TimeUnit) -> ScheduledFuture[_py_Any]: ...
    def scheduleWithFixedDelay(self, runnable: java.lang.Runnable, long: int, long2: int, timeUnit: TimeUnit) -> ScheduledFuture[_py_Any]: ...
    def setContinueExistingPeriodicTasksAfterShutdownPolicy(self, boolean: bool) -> None: ...
    def setExecuteExistingDelayedTasksAfterShutdownPolicy(self, boolean: bool) -> None: ...
    def setRemoveOnCancelPolicy(self, boolean: bool) -> None: ...
    def shutdown(self) -> None: ...
    def shutdownNow(self) -> java.util.List[java.lang.Runnable]: ...
    @overload
    def submit(self, runnable: java.lang.Runnable) -> Future[_py_Any]: ...
    _submit_1__T = _py_TypeVar('_submit_1__T')  # <T>
    @overload
    def submit(self, runnable: java.lang.Runnable, t: _submit_1__T) -> Future[_submit_1__T]: ...
    _submit_2__T = _py_TypeVar('_submit_2__T')  # <T>
    @overload
    def submit(self, callable: Callable[_submit_2__T]) -> Future[_submit_2__T]: ...

_ConcurrentHashMap__KeySetView__K = _py_TypeVar('_ConcurrentHashMap__KeySetView__K')  # <K>
_ConcurrentHashMap__KeySetView__V = _py_TypeVar('_ConcurrentHashMap__KeySetView__V')  # <V>
_ConcurrentHashMap__CollectionView__K = _py_TypeVar('_ConcurrentHashMap__CollectionView__K')  # <K>
_ConcurrentHashMap__CollectionView__V = _py_TypeVar('_ConcurrentHashMap__CollectionView__V')  # <V>
_ConcurrentHashMap__CollectionView__E = _py_TypeVar('_ConcurrentHashMap__CollectionView__E')  # <E>
_ConcurrentHashMap__K = _py_TypeVar('_ConcurrentHashMap__K')  # <K>
_ConcurrentHashMap__V = _py_TypeVar('_ConcurrentHashMap__V')  # <V>
class ConcurrentHashMap(java.util.AbstractMap[_ConcurrentHashMap__K, _ConcurrentHashMap__V], ConcurrentMap[_ConcurrentHashMap__K, _ConcurrentHashMap__V], java.io.Serializable, _py_Generic[_ConcurrentHashMap__K, _ConcurrentHashMap__V]):
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, int: int): ...
    @overload
    def __init__(self, int: int, float: float): ...
    @overload
    def __init__(self, int: int, float: float, int2: int): ...
    @overload
    def __init__(self, map: java.util.Map[_ConcurrentHashMap__K, _ConcurrentHashMap__V]): ...
    def clear(self) -> None: ...
    def compute(self, k: _ConcurrentHashMap__K, biFunction: java.util.function.BiFunction[_ConcurrentHashMap__K, _ConcurrentHashMap__V, _ConcurrentHashMap__V]) -> _ConcurrentHashMap__V: ...
    def computeIfAbsent(self, k: _ConcurrentHashMap__K, function: java.util.function.Function[_ConcurrentHashMap__K, _ConcurrentHashMap__V]) -> _ConcurrentHashMap__V: ...
    def computeIfPresent(self, k: _ConcurrentHashMap__K, biFunction: java.util.function.BiFunction[_ConcurrentHashMap__K, _ConcurrentHashMap__V, _ConcurrentHashMap__V]) -> _ConcurrentHashMap__V: ...
    def contains(self, object: _py_Any) -> bool: ...
    def containsKey(self, object: _py_Any) -> bool: ...
    def containsValue(self, object: _py_Any) -> bool: ...
    def elements(self) -> java.util.Enumeration[_ConcurrentHashMap__V]: ...
    def entrySet(self) -> java.util.Set[java.util.Map.Entry[_ConcurrentHashMap__K, _ConcurrentHashMap__V]]: ...
    def equals(self, object: _py_Any) -> bool: ...
    @overload
    def forEach(self, biConsumer: java.util.function.BiConsumer[_ConcurrentHashMap__K, _ConcurrentHashMap__V]) -> None: ...
    @overload
    def forEach(self, long: int, biConsumer: java.util.function.BiConsumer[_ConcurrentHashMap__K, _ConcurrentHashMap__V]) -> None: ...
    _forEach_2__U = _py_TypeVar('_forEach_2__U')  # <U>
    @overload
    def forEach(self, long: int, biFunction: java.util.function.BiFunction[_ConcurrentHashMap__K, _ConcurrentHashMap__V, _forEach_2__U], consumer: java.util.function.Consumer[_forEach_2__U]) -> None: ...
    @overload
    def forEachEntry(self, long: int, consumer: java.util.function.Consumer[java.util.Map.Entry[_ConcurrentHashMap__K, _ConcurrentHashMap__V]]) -> None: ...
    _forEachEntry_1__U = _py_TypeVar('_forEachEntry_1__U')  # <U>
    @overload
    def forEachEntry(self, long: int, function: java.util.function.Function[java.util.Map.Entry[_ConcurrentHashMap__K, _ConcurrentHashMap__V], _forEachEntry_1__U], consumer: java.util.function.Consumer[_forEachEntry_1__U]) -> None: ...
    @overload
    def forEachKey(self, long: int, consumer: java.util.function.Consumer[_ConcurrentHashMap__K]) -> None: ...
    _forEachKey_1__U = _py_TypeVar('_forEachKey_1__U')  # <U>
    @overload
    def forEachKey(self, long: int, function: java.util.function.Function[_ConcurrentHashMap__K, _forEachKey_1__U], consumer: java.util.function.Consumer[_forEachKey_1__U]) -> None: ...
    @overload
    def forEachValue(self, long: int, consumer: java.util.function.Consumer[_ConcurrentHashMap__V]) -> None: ...
    _forEachValue_1__U = _py_TypeVar('_forEachValue_1__U')  # <U>
    @overload
    def forEachValue(self, long: int, function: java.util.function.Function[_ConcurrentHashMap__V, _forEachValue_1__U], consumer: java.util.function.Consumer[_forEachValue_1__U]) -> None: ...
    def get(self, object: _py_Any) -> _ConcurrentHashMap__V: ...
    def getOrDefault(self, object: _py_Any, v: _ConcurrentHashMap__V) -> _ConcurrentHashMap__V: ...
    def hashCode(self) -> int: ...
    def isEmpty(self) -> bool: ...
    @overload
    def keySet(self) -> java.util.Set: ...
    @overload
    def keySet(self) -> 'ConcurrentHashMap.KeySetView'[_ConcurrentHashMap__K, _ConcurrentHashMap__V]: ...
    @overload
    def keySet(self, v: _ConcurrentHashMap__V) -> 'ConcurrentHashMap.KeySetView'[_ConcurrentHashMap__K, _ConcurrentHashMap__V]: ...
    def keys(self) -> java.util.Enumeration[_ConcurrentHashMap__K]: ...
    def mappingCount(self) -> int: ...
    def merge(self, k: _ConcurrentHashMap__K, v: _ConcurrentHashMap__V, biFunction: java.util.function.BiFunction[_ConcurrentHashMap__V, _ConcurrentHashMap__V, _ConcurrentHashMap__V]) -> _ConcurrentHashMap__V: ...
    _newKeySet_0__K = _py_TypeVar('_newKeySet_0__K')  # <K>
    @classmethod
    @overload
    def newKeySet(cls) -> 'ConcurrentHashMap.KeySetView'[_newKeySet_0__K, bool]: ...
    _newKeySet_1__K = _py_TypeVar('_newKeySet_1__K')  # <K>
    @classmethod
    @overload
    def newKeySet(cls, int: int) -> 'ConcurrentHashMap.KeySetView'[_newKeySet_1__K, bool]: ...
    def put(self, k: _ConcurrentHashMap__K, v: _ConcurrentHashMap__V) -> _ConcurrentHashMap__V: ...
    def putAll(self, map: java.util.Map[_ConcurrentHashMap__K, _ConcurrentHashMap__V]) -> None: ...
    def putIfAbsent(self, k: _ConcurrentHashMap__K, v: _ConcurrentHashMap__V) -> _ConcurrentHashMap__V: ...
    _reduce__U = _py_TypeVar('_reduce__U')  # <U>
    def reduce(self, long: int, biFunction: java.util.function.BiFunction[_ConcurrentHashMap__K, _ConcurrentHashMap__V, _reduce__U], biFunction2: java.util.function.BiFunction[_reduce__U, _reduce__U, _reduce__U]) -> _reduce__U: ...
    _reduceEntries_0__U = _py_TypeVar('_reduceEntries_0__U')  # <U>
    @overload
    def reduceEntries(self, long: int, function: java.util.function.Function[java.util.Map.Entry[_ConcurrentHashMap__K, _ConcurrentHashMap__V], _reduceEntries_0__U], biFunction: java.util.function.BiFunction[_reduceEntries_0__U, _reduceEntries_0__U, _reduceEntries_0__U]) -> _reduceEntries_0__U: ...
    @overload
    def reduceEntries(self, long: int, biFunction: java.util.function.BiFunction[java.util.Map.Entry[_ConcurrentHashMap__K, _ConcurrentHashMap__V], java.util.Map.Entry[_ConcurrentHashMap__K, _ConcurrentHashMap__V], java.util.Map.Entry[_ConcurrentHashMap__K, _ConcurrentHashMap__V]]) -> java.util.Map.Entry[_ConcurrentHashMap__K, _ConcurrentHashMap__V]: ...
    def reduceEntriesToDouble(self, long: int, toDoubleFunction: java.util.function.ToDoubleFunction[java.util.Map.Entry[_ConcurrentHashMap__K, _ConcurrentHashMap__V]], double: float, doubleBinaryOperator: java.util.function.DoubleBinaryOperator) -> float: ...
    def reduceEntriesToInt(self, long: int, toIntFunction: java.util.function.ToIntFunction[java.util.Map.Entry[_ConcurrentHashMap__K, _ConcurrentHashMap__V]], int: int, intBinaryOperator: java.util.function.IntBinaryOperator) -> int: ...
    def reduceEntriesToLong(self, long: int, toLongFunction: java.util.function.ToLongFunction[java.util.Map.Entry[_ConcurrentHashMap__K, _ConcurrentHashMap__V]], long2: int, longBinaryOperator: java.util.function.LongBinaryOperator) -> int: ...
    @overload
    def reduceKeys(self, long: int, biFunction: java.util.function.BiFunction[_ConcurrentHashMap__K, _ConcurrentHashMap__K, _ConcurrentHashMap__K]) -> _ConcurrentHashMap__K: ...
    _reduceKeys_1__U = _py_TypeVar('_reduceKeys_1__U')  # <U>
    @overload
    def reduceKeys(self, long: int, function: java.util.function.Function[_ConcurrentHashMap__K, _reduceKeys_1__U], biFunction: java.util.function.BiFunction[_reduceKeys_1__U, _reduceKeys_1__U, _reduceKeys_1__U]) -> _reduceKeys_1__U: ...
    def reduceKeysToDouble(self, long: int, toDoubleFunction: java.util.function.ToDoubleFunction[_ConcurrentHashMap__K], double: float, doubleBinaryOperator: java.util.function.DoubleBinaryOperator) -> float: ...
    def reduceKeysToInt(self, long: int, toIntFunction: java.util.function.ToIntFunction[_ConcurrentHashMap__K], int: int, intBinaryOperator: java.util.function.IntBinaryOperator) -> int: ...
    def reduceKeysToLong(self, long: int, toLongFunction: java.util.function.ToLongFunction[_ConcurrentHashMap__K], long2: int, longBinaryOperator: java.util.function.LongBinaryOperator) -> int: ...
    def reduceToDouble(self, long: int, toDoubleBiFunction: java.util.function.ToDoubleBiFunction[_ConcurrentHashMap__K, _ConcurrentHashMap__V], double: float, doubleBinaryOperator: java.util.function.DoubleBinaryOperator) -> float: ...
    def reduceToInt(self, long: int, toIntBiFunction: java.util.function.ToIntBiFunction[_ConcurrentHashMap__K, _ConcurrentHashMap__V], int: int, intBinaryOperator: java.util.function.IntBinaryOperator) -> int: ...
    def reduceToLong(self, long: int, toLongBiFunction: java.util.function.ToLongBiFunction[_ConcurrentHashMap__K, _ConcurrentHashMap__V], long2: int, longBinaryOperator: java.util.function.LongBinaryOperator) -> int: ...
    @overload
    def reduceValues(self, long: int, biFunction: java.util.function.BiFunction[_ConcurrentHashMap__V, _ConcurrentHashMap__V, _ConcurrentHashMap__V]) -> _ConcurrentHashMap__V: ...
    _reduceValues_1__U = _py_TypeVar('_reduceValues_1__U')  # <U>
    @overload
    def reduceValues(self, long: int, function: java.util.function.Function[_ConcurrentHashMap__V, _reduceValues_1__U], biFunction: java.util.function.BiFunction[_reduceValues_1__U, _reduceValues_1__U, _reduceValues_1__U]) -> _reduceValues_1__U: ...
    def reduceValuesToDouble(self, long: int, toDoubleFunction: java.util.function.ToDoubleFunction[_ConcurrentHashMap__V], double: float, doubleBinaryOperator: java.util.function.DoubleBinaryOperator) -> float: ...
    def reduceValuesToInt(self, long: int, toIntFunction: java.util.function.ToIntFunction[_ConcurrentHashMap__V], int: int, intBinaryOperator: java.util.function.IntBinaryOperator) -> int: ...
    def reduceValuesToLong(self, long: int, toLongFunction: java.util.function.ToLongFunction[_ConcurrentHashMap__V], long2: int, longBinaryOperator: java.util.function.LongBinaryOperator) -> int: ...
    @overload
    def remove(self, object: _py_Any, object2: _py_Any) -> bool: ...
    @overload
    def remove(self, object: _py_Any) -> _ConcurrentHashMap__V: ...
    @overload
    def replace(self, k: _ConcurrentHashMap__K, v: _ConcurrentHashMap__V, v2: _ConcurrentHashMap__V) -> bool: ...
    @overload
    def replace(self, k: _ConcurrentHashMap__K, v: _ConcurrentHashMap__V) -> _ConcurrentHashMap__V: ...
    def replaceAll(self, biFunction: java.util.function.BiFunction[_ConcurrentHashMap__K, _ConcurrentHashMap__V, _ConcurrentHashMap__V]) -> None: ...
    _search__U = _py_TypeVar('_search__U')  # <U>
    def search(self, long: int, biFunction: java.util.function.BiFunction[_ConcurrentHashMap__K, _ConcurrentHashMap__V, _search__U]) -> _search__U: ...
    _searchEntries__U = _py_TypeVar('_searchEntries__U')  # <U>
    def searchEntries(self, long: int, function: java.util.function.Function[java.util.Map.Entry[_ConcurrentHashMap__K, _ConcurrentHashMap__V], _searchEntries__U]) -> _searchEntries__U: ...
    _searchKeys__U = _py_TypeVar('_searchKeys__U')  # <U>
    def searchKeys(self, long: int, function: java.util.function.Function[_ConcurrentHashMap__K, _searchKeys__U]) -> _searchKeys__U: ...
    _searchValues__U = _py_TypeVar('_searchValues__U')  # <U>
    def searchValues(self, long: int, function: java.util.function.Function[_ConcurrentHashMap__V, _searchValues__U]) -> _searchValues__U: ...
    def size(self) -> int: ...
    def toString(self) -> str: ...
    def values(self) -> java.util.Collection[_ConcurrentHashMap__V]: ...
    class KeySetView(java.util.concurrent.ConcurrentHashMap.CollectionView[_ConcurrentHashMap__KeySetView__K, _ConcurrentHashMap__KeySetView__V, _ConcurrentHashMap__KeySetView__K], java.util.Set[_ConcurrentHashMap__KeySetView__K], java.io.Serializable, _py_Generic[_ConcurrentHashMap__KeySetView__K, _ConcurrentHashMap__KeySetView__V]):
        def add(self, k: _ConcurrentHashMap__KeySetView__K) -> bool: ...
        def addAll(self, collection: java.util.Collection[_ConcurrentHashMap__KeySetView__K]) -> bool: ...
        def contains(self, object: _py_Any) -> bool: ...
        def equals(self, object: _py_Any) -> bool: ...
        def forEach(self, consumer: java.util.function.Consumer[_ConcurrentHashMap__KeySetView__K]) -> None: ...
        def getMap(self) -> 'ConcurrentHashMap': ...
        def getMappedValue(self) -> _ConcurrentHashMap__KeySetView__V: ...
        def hashCode(self) -> int: ...
        def iterator(self) -> java.util.Iterator[_ConcurrentHashMap__KeySetView__K]: ...
        def remove(self, object: _py_Any) -> bool: ...
        def spliterator(self) -> java.util.Spliterator[_ConcurrentHashMap__KeySetView__K]: ...
    class CollectionView(java.util.Collection[_ConcurrentHashMap__CollectionView__E], java.io.Serializable, _py_Generic[_ConcurrentHashMap__CollectionView__K, _ConcurrentHashMap__CollectionView__V, _ConcurrentHashMap__CollectionView__E]):
        def clear(self) -> None: ...
        def contains(self, object: _py_Any) -> bool: ...
        def containsAll(self, collection: java.util.Collection[_py_Any]) -> bool: ...
        def getMap(self) -> 'ConcurrentHashMap'[_ConcurrentHashMap__CollectionView__K, _ConcurrentHashMap__CollectionView__V]: ...
        def isEmpty(self) -> bool: ...
        def iterator(self) -> java.util.Iterator[_ConcurrentHashMap__CollectionView__E]: ...
        def remove(self, object: _py_Any) -> bool: ...
        def removeAll(self, collection: java.util.Collection[_py_Any]) -> bool: ...
        def retainAll(self, collection: java.util.Collection[_py_Any]) -> bool: ...
        def size(self) -> int: ...
        @overload
        def toArray(self) -> _py_List[_py_Any]: ...
        _toArray_1__T = _py_TypeVar('_toArray_1__T')  # <T>
        @overload
        def toArray(self, tArray: _py_List[_toArray_1__T]) -> _py_List[_toArray_1__T]: ...
        def toString(self) -> str: ...
