from typing import Any as _py_Any
from typing import List as _py_List
from typing import TypeVar as _py_TypeVar
from typing import Type as _py_Type
from typing import ClassVar as _py_ClassVar
from typing import overload
import java.io
import java.lang
import java.time.chrono
import java.time.format
import java.time.temporal
import java.time.zone
import java.util


class Clock:
    def equals(self, object: _py_Any) -> bool: ...
    @classmethod
    def fixed(cls, instant: 'Instant', zoneId: 'ZoneId') -> 'Clock': ...
    def getZone(self) -> 'ZoneId': ...
    def hashCode(self) -> int: ...
    def instant(self) -> 'Instant': ...
    def millis(self) -> int: ...
    @classmethod
    def offset(cls, clock: 'Clock', duration: 'Duration') -> 'Clock': ...
    @classmethod
    def system(cls, zoneId: 'ZoneId') -> 'Clock': ...
    @classmethod
    def systemDefaultZone(cls) -> 'Clock': ...
    @classmethod
    def systemUTC(cls) -> 'Clock': ...
    @classmethod
    def tick(cls, clock: 'Clock', duration: 'Duration') -> 'Clock': ...
    @classmethod
    def tickMinutes(cls, zoneId: 'ZoneId') -> 'Clock': ...
    @classmethod
    def tickSeconds(cls, zoneId: 'ZoneId') -> 'Clock': ...
    def withZone(self, zoneId: 'ZoneId') -> 'Clock': ...

class DateTimeException(java.lang.RuntimeException):
    @overload
    def __init__(self, string: str): ...
    @overload
    def __init__(self, string: str, throwable: java.lang.Throwable): ...

class DayOfWeek(java.lang.Enum['DayOfWeek'], java.time.temporal.TemporalAccessor, java.time.temporal.TemporalAdjuster):
    MONDAY: _py_ClassVar['DayOfWeek'] = ...
    TUESDAY: _py_ClassVar['DayOfWeek'] = ...
    WEDNESDAY: _py_ClassVar['DayOfWeek'] = ...
    THURSDAY: _py_ClassVar['DayOfWeek'] = ...
    FRIDAY: _py_ClassVar['DayOfWeek'] = ...
    SATURDAY: _py_ClassVar['DayOfWeek'] = ...
    SUNDAY: _py_ClassVar['DayOfWeek'] = ...
    def adjustInto(self, temporal: java.time.temporal.Temporal) -> java.time.temporal.Temporal: ...
    def get(self, temporalField: java.time.temporal.TemporalField) -> int: ...
    def getDisplayName(self, textStyle: java.time.format.TextStyle, locale: java.util.Locale) -> str: ...
    def getLong(self, temporalField: java.time.temporal.TemporalField) -> int: ...
    def getValue(self) -> int: ...
    def isSupported(self, temporalField: java.time.temporal.TemporalField) -> bool: ...
    def minus(self, long: int) -> 'DayOfWeek': ...
    @classmethod
    def of(cls, int: int) -> 'DayOfWeek': ...
    def plus(self, long: int) -> 'DayOfWeek': ...
    _query__R = _py_TypeVar('_query__R')  # <R>
    def query(self, temporalQuery: java.time.temporal.TemporalQuery[_query__R]) -> _query__R: ...
    def range(self, temporalField: java.time.temporal.TemporalField) -> java.time.temporal.ValueRange: ...
    _valueOf_0__T = _py_TypeVar('_valueOf_0__T', bound=java.lang.Enum)  # <T>
    @classmethod
    @overload
    def valueOf(cls, class_: _py_Type[_valueOf_0__T], string: str) -> _valueOf_0__T: ...
    @classmethod
    @overload
    def valueOf(cls, string: str) -> 'DayOfWeek': ...
    @classmethod
    def values(cls) -> _py_List['DayOfWeek']: ...

class Duration(java.time.temporal.TemporalAmount, java.lang.Comparable['Duration'], java.io.Serializable):
    ZERO: _py_ClassVar['Duration'] = ...
    def abs(self) -> 'Duration': ...
    def addTo(self, temporal: java.time.temporal.Temporal) -> java.time.temporal.Temporal: ...
    @classmethod
    def between(cls, temporal: java.time.temporal.Temporal, temporal2: java.time.temporal.Temporal) -> 'Duration': ...
    @overload
    def compareTo(self, object: _py_Any) -> int: ...
    @overload
    def compareTo(self, duration: 'Duration') -> int: ...
    def dividedBy(self, long: int) -> 'Duration': ...
    def equals(self, object: _py_Any) -> bool: ...
    def get(self, temporalUnit: java.time.temporal.TemporalUnit) -> int: ...
    def getNano(self) -> int: ...
    def getSeconds(self) -> int: ...
    def getUnits(self) -> java.util.List[java.time.temporal.TemporalUnit]: ...
    def hashCode(self) -> int: ...
    def isNegative(self) -> bool: ...
    def isZero(self) -> bool: ...
    @overload
    def minus(self, duration: 'Duration') -> 'Duration': ...
    @overload
    def minus(self, long: int, temporalUnit: java.time.temporal.TemporalUnit) -> 'Duration': ...
    def minusDays(self, long: int) -> 'Duration': ...
    def minusHours(self, long: int) -> 'Duration': ...
    def minusMillis(self, long: int) -> 'Duration': ...
    def minusMinutes(self, long: int) -> 'Duration': ...
    def minusNanos(self, long: int) -> 'Duration': ...
    def minusSeconds(self, long: int) -> 'Duration': ...
    def multipliedBy(self, long: int) -> 'Duration': ...
    def negated(self) -> 'Duration': ...
    @classmethod
    def of(cls, long: int, temporalUnit: java.time.temporal.TemporalUnit) -> 'Duration': ...
    @classmethod
    def ofDays(cls, long: int) -> 'Duration': ...
    @classmethod
    def ofHours(cls, long: int) -> 'Duration': ...
    @classmethod
    def ofMillis(cls, long: int) -> 'Duration': ...
    @classmethod
    def ofMinutes(cls, long: int) -> 'Duration': ...
    @classmethod
    def ofNanos(cls, long: int) -> 'Duration': ...
    @classmethod
    @overload
    def ofSeconds(cls, long: int) -> 'Duration': ...
    @classmethod
    @overload
    def ofSeconds(cls, long: int, long2: int) -> 'Duration': ...
    @classmethod
    def parse(cls, charSequence: java.lang.CharSequence) -> 'Duration': ...
    @overload
    def plus(self, duration: 'Duration') -> 'Duration': ...
    @overload
    def plus(self, long: int, temporalUnit: java.time.temporal.TemporalUnit) -> 'Duration': ...
    def plusDays(self, long: int) -> 'Duration': ...
    def plusHours(self, long: int) -> 'Duration': ...
    def plusMillis(self, long: int) -> 'Duration': ...
    def plusMinutes(self, long: int) -> 'Duration': ...
    def plusNanos(self, long: int) -> 'Duration': ...
    def plusSeconds(self, long: int) -> 'Duration': ...
    def subtractFrom(self, temporal: java.time.temporal.Temporal) -> java.time.temporal.Temporal: ...
    def toDays(self) -> int: ...
    def toHours(self) -> int: ...
    def toMillis(self) -> int: ...
    def toMinutes(self) -> int: ...
    def toNanos(self) -> int: ...
    def toString(self) -> str: ...
    def withNanos(self, int: int) -> 'Duration': ...
    def withSeconds(self, long: int) -> 'Duration': ...

class Instant(java.time.temporal.Temporal, java.time.temporal.TemporalAdjuster, java.lang.Comparable['Instant'], java.io.Serializable):
    EPOCH: _py_ClassVar['Instant'] = ...
    MIN: _py_ClassVar['Instant'] = ...
    MAX: _py_ClassVar['Instant'] = ...
    def adjustInto(self, temporal: java.time.temporal.Temporal) -> java.time.temporal.Temporal: ...
    def atOffset(self, zoneOffset: 'ZoneOffset') -> 'OffsetDateTime': ...
    def atZone(self, zoneId: 'ZoneId') -> 'ZonedDateTime': ...
    @overload
    def compareTo(self, object: _py_Any) -> int: ...
    @overload
    def compareTo(self, instant: 'Instant') -> int: ...
    def equals(self, object: _py_Any) -> bool: ...
    def get(self, temporalField: java.time.temporal.TemporalField) -> int: ...
    def getEpochSecond(self) -> int: ...
    def getLong(self, temporalField: java.time.temporal.TemporalField) -> int: ...
    def getNano(self) -> int: ...
    def hashCode(self) -> int: ...
    def isAfter(self, instant: 'Instant') -> bool: ...
    def isBefore(self, instant: 'Instant') -> bool: ...
    @overload
    def isSupported(self, temporalField: java.time.temporal.TemporalField) -> bool: ...
    @overload
    def isSupported(self, temporalUnit: java.time.temporal.TemporalUnit) -> bool: ...
    @overload
    def minus(self, temporalAmount: java.time.temporal.TemporalAmount) -> 'Instant': ...
    @overload
    def minus(self, long: int, temporalUnit: java.time.temporal.TemporalUnit) -> 'Instant': ...
    @overload
    def minus(self, temporalAmount: java.time.temporal.TemporalAmount) -> java.time.temporal.Temporal: ...
    @overload
    def minus(self, long: int, temporalUnit: java.time.temporal.TemporalUnit) -> java.time.temporal.Temporal: ...
    def minusMillis(self, long: int) -> 'Instant': ...
    def minusNanos(self, long: int) -> 'Instant': ...
    def minusSeconds(self, long: int) -> 'Instant': ...
    @classmethod
    @overload
    def now(cls) -> 'Instant': ...
    @classmethod
    @overload
    def now(cls, clock: Clock) -> 'Instant': ...
    @classmethod
    def ofEpochMilli(cls, long: int) -> 'Instant': ...
    @classmethod
    @overload
    def ofEpochSecond(cls, long: int) -> 'Instant': ...
    @classmethod
    @overload
    def ofEpochSecond(cls, long: int, long2: int) -> 'Instant': ...
    @classmethod
    def parse(cls, charSequence: java.lang.CharSequence) -> 'Instant': ...
    @overload
    def plus(self, temporalAmount: java.time.temporal.TemporalAmount) -> 'Instant': ...
    @overload
    def plus(self, long: int, temporalUnit: java.time.temporal.TemporalUnit) -> 'Instant': ...
    @overload
    def plus(self, temporalAmount: java.time.temporal.TemporalAmount) -> java.time.temporal.Temporal: ...
    @overload
    def plus(self, long: int, temporalUnit: java.time.temporal.TemporalUnit) -> java.time.temporal.Temporal: ...
    def plusMillis(self, long: int) -> 'Instant': ...
    def plusNanos(self, long: int) -> 'Instant': ...
    def plusSeconds(self, long: int) -> 'Instant': ...
    _query__R = _py_TypeVar('_query__R')  # <R>
    def query(self, temporalQuery: java.time.temporal.TemporalQuery[_query__R]) -> _query__R: ...
    def range(self, temporalField: java.time.temporal.TemporalField) -> java.time.temporal.ValueRange: ...
    def toEpochMilli(self) -> int: ...
    def toString(self) -> str: ...
    def truncatedTo(self, temporalUnit: java.time.temporal.TemporalUnit) -> 'Instant': ...
    def until(self, temporal: java.time.temporal.Temporal, temporalUnit: java.time.temporal.TemporalUnit) -> int: ...

class LocalDate(java.time.temporal.Temporal, java.time.temporal.TemporalAdjuster, java.time.chrono.ChronoLocalDate, java.io.Serializable):
    MIN: _py_ClassVar['LocalDate'] = ...
    MAX: _py_ClassVar['LocalDate'] = ...
    def adjustInto(self, temporal: java.time.temporal.Temporal) -> java.time.temporal.Temporal: ...
    @overload
    def atStartOfDay(self) -> 'LocalDateTime': ...
    @overload
    def atStartOfDay(self, zoneId: 'ZoneId') -> 'ZonedDateTime': ...
    @overload
    def atTime(self, int: int, int2: int) -> 'LocalDateTime': ...
    @overload
    def atTime(self, int: int, int2: int, int3: int) -> 'LocalDateTime': ...
    @overload
    def atTime(self, int: int, int2: int, int3: int, int4: int) -> 'LocalDateTime': ...
    @overload
    def atTime(self, localTime: 'LocalTime') -> 'LocalDateTime': ...
    @overload
    def atTime(self, offsetTime: 'OffsetTime') -> 'OffsetDateTime': ...
    @overload
    def atTime(self, localTime: 'LocalTime') -> java.time.chrono.ChronoLocalDateTime: ...
    @overload
    def compareTo(self, object: _py_Any) -> int: ...
    @overload
    def compareTo(self, chronoLocalDate: java.time.chrono.ChronoLocalDate) -> int: ...
    def equals(self, object: _py_Any) -> bool: ...
    def format(self, dateTimeFormatter: java.time.format.DateTimeFormatter) -> str: ...
    def get(self, temporalField: java.time.temporal.TemporalField) -> int: ...
    @overload
    def getChronology(self) -> java.time.chrono.Chronology: ...
    @overload
    def getChronology(self) -> java.time.chrono.IsoChronology: ...
    def getDayOfMonth(self) -> int: ...
    def getDayOfWeek(self) -> DayOfWeek: ...
    def getDayOfYear(self) -> int: ...
    def getEra(self) -> java.time.chrono.Era: ...
    def getLong(self, temporalField: java.time.temporal.TemporalField) -> int: ...
    def getMonth(self) -> 'Month': ...
    def getMonthValue(self) -> int: ...
    def getYear(self) -> int: ...
    def hashCode(self) -> int: ...
    def isAfter(self, chronoLocalDate: java.time.chrono.ChronoLocalDate) -> bool: ...
    def isBefore(self, chronoLocalDate: java.time.chrono.ChronoLocalDate) -> bool: ...
    def isEqual(self, chronoLocalDate: java.time.chrono.ChronoLocalDate) -> bool: ...
    def isLeapYear(self) -> bool: ...
    @overload
    def isSupported(self, temporalField: java.time.temporal.TemporalField) -> bool: ...
    @overload
    def isSupported(self, temporalUnit: java.time.temporal.TemporalUnit) -> bool: ...
    def lengthOfMonth(self) -> int: ...
    def lengthOfYear(self) -> int: ...
    @overload
    def minus(self, temporalAmount: java.time.temporal.TemporalAmount) -> 'LocalDate': ...
    @overload
    def minus(self, long: int, temporalUnit: java.time.temporal.TemporalUnit) -> 'LocalDate': ...
    @overload
    def minus(self, temporalAmount: java.time.temporal.TemporalAmount) -> java.time.chrono.ChronoLocalDate: ...
    @overload
    def minus(self, long: int, temporalUnit: java.time.temporal.TemporalUnit) -> java.time.chrono.ChronoLocalDate: ...
    @overload
    def minus(self, temporalAmount: java.time.temporal.TemporalAmount) -> java.time.temporal.Temporal: ...
    @overload
    def minus(self, long: int, temporalUnit: java.time.temporal.TemporalUnit) -> java.time.temporal.Temporal: ...
    def minusDays(self, long: int) -> 'LocalDate': ...
    def minusMonths(self, long: int) -> 'LocalDate': ...
    def minusWeeks(self, long: int) -> 'LocalDate': ...
    def minusYears(self, long: int) -> 'LocalDate': ...
    @classmethod
    @overload
    def now(cls) -> 'LocalDate': ...
    @classmethod
    @overload
    def now(cls, clock: Clock) -> 'LocalDate': ...
    @classmethod
    @overload
    def now(cls, zoneId: 'ZoneId') -> 'LocalDate': ...
    @classmethod
    @overload
    def of(cls, int: int, int2: int, int3: int) -> 'LocalDate': ...
    @classmethod
    @overload
    def of(cls, int: int, month: 'Month', int2: int) -> 'LocalDate': ...
    @classmethod
    def ofEpochDay(cls, long: int) -> 'LocalDate': ...
    @classmethod
    def ofYearDay(cls, int: int, int2: int) -> 'LocalDate': ...
    @classmethod
    @overload
    def parse(cls, charSequence: java.lang.CharSequence) -> 'LocalDate': ...
    @classmethod
    @overload
    def parse(cls, charSequence: java.lang.CharSequence, dateTimeFormatter: java.time.format.DateTimeFormatter) -> 'LocalDate': ...
    @overload
    def plus(self, temporalAmount: java.time.temporal.TemporalAmount) -> 'LocalDate': ...
    @overload
    def plus(self, long: int, temporalUnit: java.time.temporal.TemporalUnit) -> 'LocalDate': ...
    @overload
    def plus(self, temporalAmount: java.time.temporal.TemporalAmount) -> java.time.chrono.ChronoLocalDate: ...
    @overload
    def plus(self, long: int, temporalUnit: java.time.temporal.TemporalUnit) -> java.time.chrono.ChronoLocalDate: ...
    @overload
    def plus(self, temporalAmount: java.time.temporal.TemporalAmount) -> java.time.temporal.Temporal: ...
    @overload
    def plus(self, long: int, temporalUnit: java.time.temporal.TemporalUnit) -> java.time.temporal.Temporal: ...
    def plusDays(self, long: int) -> 'LocalDate': ...
    def plusMonths(self, long: int) -> 'LocalDate': ...
    def plusWeeks(self, long: int) -> 'LocalDate': ...
    def plusYears(self, long: int) -> 'LocalDate': ...
    _query__R = _py_TypeVar('_query__R')  # <R>
    def query(self, temporalQuery: java.time.temporal.TemporalQuery[_query__R]) -> _query__R: ...
    def range(self, temporalField: java.time.temporal.TemporalField) -> java.time.temporal.ValueRange: ...
    def toEpochDay(self) -> int: ...
    def toString(self) -> str: ...
    @overload
    def until(self, chronoLocalDate: java.time.chrono.ChronoLocalDate) -> 'Period': ...
    @overload
    def until(self, chronoLocalDate: java.time.chrono.ChronoLocalDate) -> java.time.chrono.ChronoPeriod: ...
    @overload
    def until(self, temporal: java.time.temporal.Temporal, temporalUnit: java.time.temporal.TemporalUnit) -> int: ...
    def withDayOfMonth(self, int: int) -> 'LocalDate': ...
    def withDayOfYear(self, int: int) -> 'LocalDate': ...
    def withMonth(self, int: int) -> 'LocalDate': ...
    def withYear(self, int: int) -> 'LocalDate': ...

class LocalDateTime(java.time.temporal.Temporal, java.time.temporal.TemporalAdjuster, java.time.chrono.ChronoLocalDateTime[LocalDate], java.io.Serializable):
    MIN: _py_ClassVar['LocalDateTime'] = ...
    MAX: _py_ClassVar['LocalDateTime'] = ...
    def adjustInto(self, temporal: java.time.temporal.Temporal) -> java.time.temporal.Temporal: ...
    def atOffset(self, zoneOffset: 'ZoneOffset') -> 'OffsetDateTime': ...
    @overload
    def atZone(self, zoneId: 'ZoneId') -> 'ZonedDateTime': ...
    @overload
    def atZone(self, zoneId: 'ZoneId') -> java.time.chrono.ChronoZonedDateTime: ...
    @overload
    def compareTo(self, object: _py_Any) -> int: ...
    @overload
    def compareTo(self, chronoLocalDateTime: java.time.chrono.ChronoLocalDateTime[_py_Any]) -> int: ...
    def equals(self, object: _py_Any) -> bool: ...
    def format(self, dateTimeFormatter: java.time.format.DateTimeFormatter) -> str: ...
    def get(self, temporalField: java.time.temporal.TemporalField) -> int: ...
    def getDayOfMonth(self) -> int: ...
    def getDayOfWeek(self) -> DayOfWeek: ...
    def getDayOfYear(self) -> int: ...
    def getHour(self) -> int: ...
    def getLong(self, temporalField: java.time.temporal.TemporalField) -> int: ...
    def getMinute(self) -> int: ...
    def getMonth(self) -> 'Month': ...
    def getMonthValue(self) -> int: ...
    def getNano(self) -> int: ...
    def getSecond(self) -> int: ...
    def getYear(self) -> int: ...
    def hashCode(self) -> int: ...
    def isAfter(self, chronoLocalDateTime: java.time.chrono.ChronoLocalDateTime[_py_Any]) -> bool: ...
    def isBefore(self, chronoLocalDateTime: java.time.chrono.ChronoLocalDateTime[_py_Any]) -> bool: ...
    def isEqual(self, chronoLocalDateTime: java.time.chrono.ChronoLocalDateTime[_py_Any]) -> bool: ...
    @overload
    def isSupported(self, temporalField: java.time.temporal.TemporalField) -> bool: ...
    @overload
    def isSupported(self, temporalUnit: java.time.temporal.TemporalUnit) -> bool: ...
    @overload
    def minus(self, temporalAmount: java.time.temporal.TemporalAmount) -> 'LocalDateTime': ...
    @overload
    def minus(self, long: int, temporalUnit: java.time.temporal.TemporalUnit) -> 'LocalDateTime': ...
    @overload
    def minus(self, temporalAmount: java.time.temporal.TemporalAmount) -> java.time.chrono.ChronoLocalDateTime: ...
    @overload
    def minus(self, long: int, temporalUnit: java.time.temporal.TemporalUnit) -> java.time.chrono.ChronoLocalDateTime: ...
    @overload
    def minus(self, temporalAmount: java.time.temporal.TemporalAmount) -> java.time.temporal.Temporal: ...
    @overload
    def minus(self, long: int, temporalUnit: java.time.temporal.TemporalUnit) -> java.time.temporal.Temporal: ...
    def minusDays(self, long: int) -> 'LocalDateTime': ...
    def minusHours(self, long: int) -> 'LocalDateTime': ...
    def minusMinutes(self, long: int) -> 'LocalDateTime': ...
    def minusMonths(self, long: int) -> 'LocalDateTime': ...
    def minusNanos(self, long: int) -> 'LocalDateTime': ...
    def minusSeconds(self, long: int) -> 'LocalDateTime': ...
    def minusWeeks(self, long: int) -> 'LocalDateTime': ...
    def minusYears(self, long: int) -> 'LocalDateTime': ...
    @classmethod
    @overload
    def now(cls) -> 'LocalDateTime': ...
    @classmethod
    @overload
    def now(cls, clock: Clock) -> 'LocalDateTime': ...
    @classmethod
    @overload
    def now(cls, zoneId: 'ZoneId') -> 'LocalDateTime': ...
    @classmethod
    @overload
    def of(cls, int: int, int2: int, int3: int, int4: int, int5: int) -> 'LocalDateTime': ...
    @classmethod
    @overload
    def of(cls, int: int, int2: int, int3: int, int4: int, int5: int, int6: int) -> 'LocalDateTime': ...
    @classmethod
    @overload
    def of(cls, int: int, int2: int, int3: int, int4: int, int5: int, int6: int, int7: int) -> 'LocalDateTime': ...
    @classmethod
    @overload
    def of(cls, int: int, month: 'Month', int2: int, int3: int, int4: int) -> 'LocalDateTime': ...
    @classmethod
    @overload
    def of(cls, int: int, month: 'Month', int2: int, int3: int, int4: int, int5: int) -> 'LocalDateTime': ...
    @classmethod
    @overload
    def of(cls, int: int, month: 'Month', int2: int, int3: int, int4: int, int5: int, int6: int) -> 'LocalDateTime': ...
    @classmethod
    @overload
    def of(cls, localDate: LocalDate, localTime: 'LocalTime') -> 'LocalDateTime': ...
    @classmethod
    def ofEpochSecond(cls, long: int, int: int, zoneOffset: 'ZoneOffset') -> 'LocalDateTime': ...
    @classmethod
    def ofInstant(cls, instant: Instant, zoneId: 'ZoneId') -> 'LocalDateTime': ...
    @classmethod
    @overload
    def parse(cls, charSequence: java.lang.CharSequence) -> 'LocalDateTime': ...
    @classmethod
    @overload
    def parse(cls, charSequence: java.lang.CharSequence, dateTimeFormatter: java.time.format.DateTimeFormatter) -> 'LocalDateTime': ...
    @overload
    def plus(self, temporalAmount: java.time.temporal.TemporalAmount) -> 'LocalDateTime': ...
    @overload
    def plus(self, long: int, temporalUnit: java.time.temporal.TemporalUnit) -> 'LocalDateTime': ...
    @overload
    def plus(self, temporalAmount: java.time.temporal.TemporalAmount) -> java.time.chrono.ChronoLocalDateTime: ...
    @overload
    def plus(self, long: int, temporalUnit: java.time.temporal.TemporalUnit) -> java.time.chrono.ChronoLocalDateTime: ...
    @overload
    def plus(self, temporalAmount: java.time.temporal.TemporalAmount) -> java.time.temporal.Temporal: ...
    @overload
    def plus(self, long: int, temporalUnit: java.time.temporal.TemporalUnit) -> java.time.temporal.Temporal: ...
    def plusDays(self, long: int) -> 'LocalDateTime': ...
    def plusHours(self, long: int) -> 'LocalDateTime': ...
    def plusMinutes(self, long: int) -> 'LocalDateTime': ...
    def plusMonths(self, long: int) -> 'LocalDateTime': ...
    def plusNanos(self, long: int) -> 'LocalDateTime': ...
    def plusSeconds(self, long: int) -> 'LocalDateTime': ...
    def plusWeeks(self, long: int) -> 'LocalDateTime': ...
    def plusYears(self, long: int) -> 'LocalDateTime': ...
    _query__R = _py_TypeVar('_query__R')  # <R>
    def query(self, temporalQuery: java.time.temporal.TemporalQuery[_query__R]) -> _query__R: ...
    def range(self, temporalField: java.time.temporal.TemporalField) -> java.time.temporal.ValueRange: ...
    @overload
    def toLocalDate(self) -> LocalDate: ...
    @overload
    def toLocalDate(self) -> java.time.chrono.ChronoLocalDate: ...
    def toLocalTime(self) -> 'LocalTime': ...
    def toString(self) -> str: ...
    def truncatedTo(self, temporalUnit: java.time.temporal.TemporalUnit) -> 'LocalDateTime': ...
    def until(self, temporal: java.time.temporal.Temporal, temporalUnit: java.time.temporal.TemporalUnit) -> int: ...
    def withDayOfMonth(self, int: int) -> 'LocalDateTime': ...
    def withDayOfYear(self, int: int) -> 'LocalDateTime': ...
    def withHour(self, int: int) -> 'LocalDateTime': ...
    def withMinute(self, int: int) -> 'LocalDateTime': ...
    def withMonth(self, int: int) -> 'LocalDateTime': ...
    def withNano(self, int: int) -> 'LocalDateTime': ...
    def withSecond(self, int: int) -> 'LocalDateTime': ...
    def withYear(self, int: int) -> 'LocalDateTime': ...

class LocalTime(java.time.temporal.Temporal, java.time.temporal.TemporalAdjuster, java.lang.Comparable['LocalTime'], java.io.Serializable):
    MIN: _py_ClassVar['LocalTime'] = ...
    MAX: _py_ClassVar['LocalTime'] = ...
    MIDNIGHT: _py_ClassVar['LocalTime'] = ...
    NOON: _py_ClassVar['LocalTime'] = ...
    def adjustInto(self, temporal: java.time.temporal.Temporal) -> java.time.temporal.Temporal: ...
    def atDate(self, localDate: LocalDate) -> LocalDateTime: ...
    def atOffset(self, zoneOffset: 'ZoneOffset') -> 'OffsetTime': ...
    @overload
    def compareTo(self, object: _py_Any) -> int: ...
    @overload
    def compareTo(self, localTime: 'LocalTime') -> int: ...
    def equals(self, object: _py_Any) -> bool: ...
    def format(self, dateTimeFormatter: java.time.format.DateTimeFormatter) -> str: ...
    def get(self, temporalField: java.time.temporal.TemporalField) -> int: ...
    def getHour(self) -> int: ...
    def getLong(self, temporalField: java.time.temporal.TemporalField) -> int: ...
    def getMinute(self) -> int: ...
    def getNano(self) -> int: ...
    def getSecond(self) -> int: ...
    def hashCode(self) -> int: ...
    def isAfter(self, localTime: 'LocalTime') -> bool: ...
    def isBefore(self, localTime: 'LocalTime') -> bool: ...
    @overload
    def isSupported(self, temporalField: java.time.temporal.TemporalField) -> bool: ...
    @overload
    def isSupported(self, temporalUnit: java.time.temporal.TemporalUnit) -> bool: ...
    @overload
    def minus(self, temporalAmount: java.time.temporal.TemporalAmount) -> 'LocalTime': ...
    @overload
    def minus(self, long: int, temporalUnit: java.time.temporal.TemporalUnit) -> 'LocalTime': ...
    @overload
    def minus(self, temporalAmount: java.time.temporal.TemporalAmount) -> java.time.temporal.Temporal: ...
    @overload
    def minus(self, long: int, temporalUnit: java.time.temporal.TemporalUnit) -> java.time.temporal.Temporal: ...
    def minusHours(self, long: int) -> 'LocalTime': ...
    def minusMinutes(self, long: int) -> 'LocalTime': ...
    def minusNanos(self, long: int) -> 'LocalTime': ...
    def minusSeconds(self, long: int) -> 'LocalTime': ...
    @classmethod
    @overload
    def now(cls) -> 'LocalTime': ...
    @classmethod
    @overload
    def now(cls, clock: Clock) -> 'LocalTime': ...
    @classmethod
    @overload
    def now(cls, zoneId: 'ZoneId') -> 'LocalTime': ...
    @classmethod
    @overload
    def of(cls, int: int, int2: int) -> 'LocalTime': ...
    @classmethod
    @overload
    def of(cls, int: int, int2: int, int3: int) -> 'LocalTime': ...
    @classmethod
    @overload
    def of(cls, int: int, int2: int, int3: int, int4: int) -> 'LocalTime': ...
    @classmethod
    def ofNanoOfDay(cls, long: int) -> 'LocalTime': ...
    @classmethod
    def ofSecondOfDay(cls, long: int) -> 'LocalTime': ...
    @classmethod
    @overload
    def parse(cls, charSequence: java.lang.CharSequence) -> 'LocalTime': ...
    @classmethod
    @overload
    def parse(cls, charSequence: java.lang.CharSequence, dateTimeFormatter: java.time.format.DateTimeFormatter) -> 'LocalTime': ...
    @overload
    def plus(self, temporalAmount: java.time.temporal.TemporalAmount) -> 'LocalTime': ...
    @overload
    def plus(self, long: int, temporalUnit: java.time.temporal.TemporalUnit) -> 'LocalTime': ...
    @overload
    def plus(self, temporalAmount: java.time.temporal.TemporalAmount) -> java.time.temporal.Temporal: ...
    @overload
    def plus(self, long: int, temporalUnit: java.time.temporal.TemporalUnit) -> java.time.temporal.Temporal: ...
    def plusHours(self, long: int) -> 'LocalTime': ...
    def plusMinutes(self, long: int) -> 'LocalTime': ...
    def plusNanos(self, long: int) -> 'LocalTime': ...
    def plusSeconds(self, long: int) -> 'LocalTime': ...
    _query__R = _py_TypeVar('_query__R')  # <R>
    def query(self, temporalQuery: java.time.temporal.TemporalQuery[_query__R]) -> _query__R: ...
    def range(self, temporalField: java.time.temporal.TemporalField) -> java.time.temporal.ValueRange: ...
    def toNanoOfDay(self) -> int: ...
    def toSecondOfDay(self) -> int: ...
    def toString(self) -> str: ...
    def truncatedTo(self, temporalUnit: java.time.temporal.TemporalUnit) -> 'LocalTime': ...
    def until(self, temporal: java.time.temporal.Temporal, temporalUnit: java.time.temporal.TemporalUnit) -> int: ...
    def withHour(self, int: int) -> 'LocalTime': ...
    def withMinute(self, int: int) -> 'LocalTime': ...
    def withNano(self, int: int) -> 'LocalTime': ...
    def withSecond(self, int: int) -> 'LocalTime': ...

class Month(java.lang.Enum['Month'], java.time.temporal.TemporalAccessor, java.time.temporal.TemporalAdjuster):
    JANUARY: _py_ClassVar['Month'] = ...
    FEBRUARY: _py_ClassVar['Month'] = ...
    MARCH: _py_ClassVar['Month'] = ...
    APRIL: _py_ClassVar['Month'] = ...
    MAY: _py_ClassVar['Month'] = ...
    JUNE: _py_ClassVar['Month'] = ...
    JULY: _py_ClassVar['Month'] = ...
    AUGUST: _py_ClassVar['Month'] = ...
    SEPTEMBER: _py_ClassVar['Month'] = ...
    OCTOBER: _py_ClassVar['Month'] = ...
    NOVEMBER: _py_ClassVar['Month'] = ...
    DECEMBER: _py_ClassVar['Month'] = ...
    def adjustInto(self, temporal: java.time.temporal.Temporal) -> java.time.temporal.Temporal: ...
    def firstDayOfYear(self, boolean: bool) -> int: ...
    def firstMonthOfQuarter(self) -> 'Month': ...
    def get(self, temporalField: java.time.temporal.TemporalField) -> int: ...
    def getDisplayName(self, textStyle: java.time.format.TextStyle, locale: java.util.Locale) -> str: ...
    def getLong(self, temporalField: java.time.temporal.TemporalField) -> int: ...
    def getValue(self) -> int: ...
    def isSupported(self, temporalField: java.time.temporal.TemporalField) -> bool: ...
    def length(self, boolean: bool) -> int: ...
    def maxLength(self) -> int: ...
    def minLength(self) -> int: ...
    def minus(self, long: int) -> 'Month': ...
    @classmethod
    def of(cls, int: int) -> 'Month': ...
    def plus(self, long: int) -> 'Month': ...
    _query__R = _py_TypeVar('_query__R')  # <R>
    def query(self, temporalQuery: java.time.temporal.TemporalQuery[_query__R]) -> _query__R: ...
    def range(self, temporalField: java.time.temporal.TemporalField) -> java.time.temporal.ValueRange: ...
    _valueOf_0__T = _py_TypeVar('_valueOf_0__T', bound=java.lang.Enum)  # <T>
    @classmethod
    @overload
    def valueOf(cls, class_: _py_Type[_valueOf_0__T], string: str) -> _valueOf_0__T: ...
    @classmethod
    @overload
    def valueOf(cls, string: str) -> 'Month': ...
    @classmethod
    def values(cls) -> _py_List['Month']: ...

class MonthDay(java.time.temporal.TemporalAccessor, java.time.temporal.TemporalAdjuster, java.lang.Comparable['MonthDay'], java.io.Serializable):
    def adjustInto(self, temporal: java.time.temporal.Temporal) -> java.time.temporal.Temporal: ...
    def atYear(self, int: int) -> LocalDate: ...
    @overload
    def compareTo(self, object: _py_Any) -> int: ...
    @overload
    def compareTo(self, monthDay: 'MonthDay') -> int: ...
    def equals(self, object: _py_Any) -> bool: ...
    def format(self, dateTimeFormatter: java.time.format.DateTimeFormatter) -> str: ...
    def get(self, temporalField: java.time.temporal.TemporalField) -> int: ...
    def getDayOfMonth(self) -> int: ...
    def getLong(self, temporalField: java.time.temporal.TemporalField) -> int: ...
    def getMonth(self) -> Month: ...
    def getMonthValue(self) -> int: ...
    def hashCode(self) -> int: ...
    def isAfter(self, monthDay: 'MonthDay') -> bool: ...
    def isBefore(self, monthDay: 'MonthDay') -> bool: ...
    def isSupported(self, temporalField: java.time.temporal.TemporalField) -> bool: ...
    def isValidYear(self, int: int) -> bool: ...
    @classmethod
    @overload
    def now(cls) -> 'MonthDay': ...
    @classmethod
    @overload
    def now(cls, clock: Clock) -> 'MonthDay': ...
    @classmethod
    @overload
    def now(cls, zoneId: 'ZoneId') -> 'MonthDay': ...
    @classmethod
    @overload
    def of(cls, int: int, int2: int) -> 'MonthDay': ...
    @classmethod
    @overload
    def of(cls, month: Month, int: int) -> 'MonthDay': ...
    @classmethod
    @overload
    def parse(cls, charSequence: java.lang.CharSequence) -> 'MonthDay': ...
    @classmethod
    @overload
    def parse(cls, charSequence: java.lang.CharSequence, dateTimeFormatter: java.time.format.DateTimeFormatter) -> 'MonthDay': ...
    _query__R = _py_TypeVar('_query__R')  # <R>
    def query(self, temporalQuery: java.time.temporal.TemporalQuery[_query__R]) -> _query__R: ...
    def range(self, temporalField: java.time.temporal.TemporalField) -> java.time.temporal.ValueRange: ...
    def toString(self) -> str: ...
    def withDayOfMonth(self, int: int) -> 'MonthDay': ...
    def withMonth(self, int: int) -> 'MonthDay': ...

class OffsetDateTime(java.time.temporal.Temporal, java.time.temporal.TemporalAdjuster, java.lang.Comparable['OffsetDateTime'], java.io.Serializable):
    MIN: _py_ClassVar['OffsetDateTime'] = ...
    MAX: _py_ClassVar['OffsetDateTime'] = ...
    def adjustInto(self, temporal: java.time.temporal.Temporal) -> java.time.temporal.Temporal: ...
    def atZoneSameInstant(self, zoneId: 'ZoneId') -> 'ZonedDateTime': ...
    def atZoneSimilarLocal(self, zoneId: 'ZoneId') -> 'ZonedDateTime': ...
    @overload
    def compareTo(self, object: _py_Any) -> int: ...
    @overload
    def compareTo(self, offsetDateTime: 'OffsetDateTime') -> int: ...
    def equals(self, object: _py_Any) -> bool: ...
    def format(self, dateTimeFormatter: java.time.format.DateTimeFormatter) -> str: ...
    def get(self, temporalField: java.time.temporal.TemporalField) -> int: ...
    def getDayOfMonth(self) -> int: ...
    def getDayOfWeek(self) -> DayOfWeek: ...
    def getDayOfYear(self) -> int: ...
    def getHour(self) -> int: ...
    def getLong(self, temporalField: java.time.temporal.TemporalField) -> int: ...
    def getMinute(self) -> int: ...
    def getMonth(self) -> Month: ...
    def getMonthValue(self) -> int: ...
    def getNano(self) -> int: ...
    def getOffset(self) -> 'ZoneOffset': ...
    def getSecond(self) -> int: ...
    def getYear(self) -> int: ...
    def hashCode(self) -> int: ...
    def isAfter(self, offsetDateTime: 'OffsetDateTime') -> bool: ...
    def isBefore(self, offsetDateTime: 'OffsetDateTime') -> bool: ...
    def isEqual(self, offsetDateTime: 'OffsetDateTime') -> bool: ...
    @overload
    def isSupported(self, temporalField: java.time.temporal.TemporalField) -> bool: ...
    @overload
    def isSupported(self, temporalUnit: java.time.temporal.TemporalUnit) -> bool: ...
    @overload
    def minus(self, temporalAmount: java.time.temporal.TemporalAmount) -> 'OffsetDateTime': ...
    @overload
    def minus(self, long: int, temporalUnit: java.time.temporal.TemporalUnit) -> 'OffsetDateTime': ...
    @overload
    def minus(self, temporalAmount: java.time.temporal.TemporalAmount) -> java.time.temporal.Temporal: ...
    @overload
    def minus(self, long: int, temporalUnit: java.time.temporal.TemporalUnit) -> java.time.temporal.Temporal: ...
    def minusDays(self, long: int) -> 'OffsetDateTime': ...
    def minusHours(self, long: int) -> 'OffsetDateTime': ...
    def minusMinutes(self, long: int) -> 'OffsetDateTime': ...
    def minusMonths(self, long: int) -> 'OffsetDateTime': ...
    def minusNanos(self, long: int) -> 'OffsetDateTime': ...
    def minusSeconds(self, long: int) -> 'OffsetDateTime': ...
    def minusWeeks(self, long: int) -> 'OffsetDateTime': ...
    def minusYears(self, long: int) -> 'OffsetDateTime': ...
    @classmethod
    @overload
    def now(cls) -> 'OffsetDateTime': ...
    @classmethod
    @overload
    def now(cls, clock: Clock) -> 'OffsetDateTime': ...
    @classmethod
    @overload
    def now(cls, zoneId: 'ZoneId') -> 'OffsetDateTime': ...
    @classmethod
    @overload
    def of(cls, int: int, int2: int, int3: int, int4: int, int5: int, int6: int, int7: int, zoneOffset: 'ZoneOffset') -> 'OffsetDateTime': ...
    @classmethod
    @overload
    def of(cls, localDate: LocalDate, localTime: LocalTime, zoneOffset: 'ZoneOffset') -> 'OffsetDateTime': ...
    @classmethod
    @overload
    def of(cls, localDateTime: LocalDateTime, zoneOffset: 'ZoneOffset') -> 'OffsetDateTime': ...
    @classmethod
    def ofInstant(cls, instant: Instant, zoneId: 'ZoneId') -> 'OffsetDateTime': ...
    @classmethod
    @overload
    def parse(cls, charSequence: java.lang.CharSequence) -> 'OffsetDateTime': ...
    @classmethod
    @overload
    def parse(cls, charSequence: java.lang.CharSequence, dateTimeFormatter: java.time.format.DateTimeFormatter) -> 'OffsetDateTime': ...
    @overload
    def plus(self, temporalAmount: java.time.temporal.TemporalAmount) -> 'OffsetDateTime': ...
    @overload
    def plus(self, long: int, temporalUnit: java.time.temporal.TemporalUnit) -> 'OffsetDateTime': ...
    @overload
    def plus(self, temporalAmount: java.time.temporal.TemporalAmount) -> java.time.temporal.Temporal: ...
    @overload
    def plus(self, long: int, temporalUnit: java.time.temporal.TemporalUnit) -> java.time.temporal.Temporal: ...
    def plusDays(self, long: int) -> 'OffsetDateTime': ...
    def plusHours(self, long: int) -> 'OffsetDateTime': ...
    def plusMinutes(self, long: int) -> 'OffsetDateTime': ...
    def plusMonths(self, long: int) -> 'OffsetDateTime': ...
    def plusNanos(self, long: int) -> 'OffsetDateTime': ...
    def plusSeconds(self, long: int) -> 'OffsetDateTime': ...
    def plusWeeks(self, long: int) -> 'OffsetDateTime': ...
    def plusYears(self, long: int) -> 'OffsetDateTime': ...
    _query__R = _py_TypeVar('_query__R')  # <R>
    def query(self, temporalQuery: java.time.temporal.TemporalQuery[_query__R]) -> _query__R: ...
    def range(self, temporalField: java.time.temporal.TemporalField) -> java.time.temporal.ValueRange: ...
    @classmethod
    def timeLineOrder(cls) -> java.util.Comparator['OffsetDateTime']: ...
    def toEpochSecond(self) -> int: ...
    def toInstant(self) -> Instant: ...
    def toLocalDate(self) -> LocalDate: ...
    def toLocalDateTime(self) -> LocalDateTime: ...
    def toLocalTime(self) -> LocalTime: ...
    def toOffsetTime(self) -> 'OffsetTime': ...
    def toString(self) -> str: ...
    def toZonedDateTime(self) -> 'ZonedDateTime': ...
    def truncatedTo(self, temporalUnit: java.time.temporal.TemporalUnit) -> 'OffsetDateTime': ...
    def until(self, temporal: java.time.temporal.Temporal, temporalUnit: java.time.temporal.TemporalUnit) -> int: ...
    def withDayOfMonth(self, int: int) -> 'OffsetDateTime': ...
    def withDayOfYear(self, int: int) -> 'OffsetDateTime': ...
    def withHour(self, int: int) -> 'OffsetDateTime': ...
    def withMinute(self, int: int) -> 'OffsetDateTime': ...
    def withMonth(self, int: int) -> 'OffsetDateTime': ...
    def withNano(self, int: int) -> 'OffsetDateTime': ...
    def withOffsetSameInstant(self, zoneOffset: 'ZoneOffset') -> 'OffsetDateTime': ...
    def withOffsetSameLocal(self, zoneOffset: 'ZoneOffset') -> 'OffsetDateTime': ...
    def withSecond(self, int: int) -> 'OffsetDateTime': ...
    def withYear(self, int: int) -> 'OffsetDateTime': ...

class OffsetTime(java.time.temporal.Temporal, java.time.temporal.TemporalAdjuster, java.lang.Comparable['OffsetTime'], java.io.Serializable):
    MIN: _py_ClassVar['OffsetTime'] = ...
    MAX: _py_ClassVar['OffsetTime'] = ...
    def adjustInto(self, temporal: java.time.temporal.Temporal) -> java.time.temporal.Temporal: ...
    def atDate(self, localDate: LocalDate) -> OffsetDateTime: ...
    @overload
    def compareTo(self, object: _py_Any) -> int: ...
    @overload
    def compareTo(self, offsetTime: 'OffsetTime') -> int: ...
    def equals(self, object: _py_Any) -> bool: ...
    def format(self, dateTimeFormatter: java.time.format.DateTimeFormatter) -> str: ...
    def get(self, temporalField: java.time.temporal.TemporalField) -> int: ...
    def getHour(self) -> int: ...
    def getLong(self, temporalField: java.time.temporal.TemporalField) -> int: ...
    def getMinute(self) -> int: ...
    def getNano(self) -> int: ...
    def getOffset(self) -> 'ZoneOffset': ...
    def getSecond(self) -> int: ...
    def hashCode(self) -> int: ...
    def isAfter(self, offsetTime: 'OffsetTime') -> bool: ...
    def isBefore(self, offsetTime: 'OffsetTime') -> bool: ...
    def isEqual(self, offsetTime: 'OffsetTime') -> bool: ...
    @overload
    def isSupported(self, temporalField: java.time.temporal.TemporalField) -> bool: ...
    @overload
    def isSupported(self, temporalUnit: java.time.temporal.TemporalUnit) -> bool: ...
    @overload
    def minus(self, temporalAmount: java.time.temporal.TemporalAmount) -> 'OffsetTime': ...
    @overload
    def minus(self, long: int, temporalUnit: java.time.temporal.TemporalUnit) -> 'OffsetTime': ...
    @overload
    def minus(self, temporalAmount: java.time.temporal.TemporalAmount) -> java.time.temporal.Temporal: ...
    @overload
    def minus(self, long: int, temporalUnit: java.time.temporal.TemporalUnit) -> java.time.temporal.Temporal: ...
    def minusHours(self, long: int) -> 'OffsetTime': ...
    def minusMinutes(self, long: int) -> 'OffsetTime': ...
    def minusNanos(self, long: int) -> 'OffsetTime': ...
    def minusSeconds(self, long: int) -> 'OffsetTime': ...
    @classmethod
    @overload
    def now(cls) -> 'OffsetTime': ...
    @classmethod
    @overload
    def now(cls, clock: Clock) -> 'OffsetTime': ...
    @classmethod
    @overload
    def now(cls, zoneId: 'ZoneId') -> 'OffsetTime': ...
    @classmethod
    @overload
    def of(cls, int: int, int2: int, int3: int, int4: int, zoneOffset: 'ZoneOffset') -> 'OffsetTime': ...
    @classmethod
    @overload
    def of(cls, localTime: LocalTime, zoneOffset: 'ZoneOffset') -> 'OffsetTime': ...
    @classmethod
    def ofInstant(cls, instant: Instant, zoneId: 'ZoneId') -> 'OffsetTime': ...
    @classmethod
    @overload
    def parse(cls, charSequence: java.lang.CharSequence) -> 'OffsetTime': ...
    @classmethod
    @overload
    def parse(cls, charSequence: java.lang.CharSequence, dateTimeFormatter: java.time.format.DateTimeFormatter) -> 'OffsetTime': ...
    @overload
    def plus(self, temporalAmount: java.time.temporal.TemporalAmount) -> 'OffsetTime': ...
    @overload
    def plus(self, long: int, temporalUnit: java.time.temporal.TemporalUnit) -> 'OffsetTime': ...
    @overload
    def plus(self, temporalAmount: java.time.temporal.TemporalAmount) -> java.time.temporal.Temporal: ...
    @overload
    def plus(self, long: int, temporalUnit: java.time.temporal.TemporalUnit) -> java.time.temporal.Temporal: ...
    def plusHours(self, long: int) -> 'OffsetTime': ...
    def plusMinutes(self, long: int) -> 'OffsetTime': ...
    def plusNanos(self, long: int) -> 'OffsetTime': ...
    def plusSeconds(self, long: int) -> 'OffsetTime': ...
    _query__R = _py_TypeVar('_query__R')  # <R>
    def query(self, temporalQuery: java.time.temporal.TemporalQuery[_query__R]) -> _query__R: ...
    def range(self, temporalField: java.time.temporal.TemporalField) -> java.time.temporal.ValueRange: ...
    def toLocalTime(self) -> LocalTime: ...
    def toString(self) -> str: ...
    def truncatedTo(self, temporalUnit: java.time.temporal.TemporalUnit) -> 'OffsetTime': ...
    def until(self, temporal: java.time.temporal.Temporal, temporalUnit: java.time.temporal.TemporalUnit) -> int: ...
    def withHour(self, int: int) -> 'OffsetTime': ...
    def withMinute(self, int: int) -> 'OffsetTime': ...
    def withNano(self, int: int) -> 'OffsetTime': ...
    def withOffsetSameInstant(self, zoneOffset: 'ZoneOffset') -> 'OffsetTime': ...
    def withOffsetSameLocal(self, zoneOffset: 'ZoneOffset') -> 'OffsetTime': ...
    def withSecond(self, int: int) -> 'OffsetTime': ...

class Period(java.time.chrono.ChronoPeriod, java.io.Serializable):
    ZERO: _py_ClassVar['Period'] = ...
    def addTo(self, temporal: java.time.temporal.Temporal) -> java.time.temporal.Temporal: ...
    @classmethod
    def between(cls, localDate: LocalDate, localDate2: LocalDate) -> 'Period': ...
    def equals(self, object: _py_Any) -> bool: ...
    def get(self, temporalUnit: java.time.temporal.TemporalUnit) -> int: ...
    @overload
    def getChronology(self) -> java.time.chrono.Chronology: ...
    @overload
    def getChronology(self) -> java.time.chrono.IsoChronology: ...
    def getDays(self) -> int: ...
    def getMonths(self) -> int: ...
    def getUnits(self) -> java.util.List[java.time.temporal.TemporalUnit]: ...
    def getYears(self) -> int: ...
    def hashCode(self) -> int: ...
    def isNegative(self) -> bool: ...
    def isZero(self) -> bool: ...
    @overload
    def minus(self, temporalAmount: java.time.temporal.TemporalAmount) -> 'Period': ...
    @overload
    def minus(self, temporalAmount: java.time.temporal.TemporalAmount) -> java.time.chrono.ChronoPeriod: ...
    def minusDays(self, long: int) -> 'Period': ...
    def minusMonths(self, long: int) -> 'Period': ...
    def minusYears(self, long: int) -> 'Period': ...
    @overload
    def multipliedBy(self, int: int) -> 'Period': ...
    @overload
    def multipliedBy(self, int: int) -> java.time.chrono.ChronoPeriod: ...
    @overload
    def negated(self) -> 'Period': ...
    @overload
    def negated(self) -> java.time.chrono.ChronoPeriod: ...
    @overload
    def normalized(self) -> 'Period': ...
    @overload
    def normalized(self) -> java.time.chrono.ChronoPeriod: ...
    @classmethod
    def of(cls, int: int, int2: int, int3: int) -> 'Period': ...
    @classmethod
    def ofDays(cls, int: int) -> 'Period': ...
    @classmethod
    def ofMonths(cls, int: int) -> 'Period': ...
    @classmethod
    def ofWeeks(cls, int: int) -> 'Period': ...
    @classmethod
    def ofYears(cls, int: int) -> 'Period': ...
    @classmethod
    def parse(cls, charSequence: java.lang.CharSequence) -> 'Period': ...
    @overload
    def plus(self, temporalAmount: java.time.temporal.TemporalAmount) -> 'Period': ...
    @overload
    def plus(self, temporalAmount: java.time.temporal.TemporalAmount) -> java.time.chrono.ChronoPeriod: ...
    def plusDays(self, long: int) -> 'Period': ...
    def plusMonths(self, long: int) -> 'Period': ...
    def plusYears(self, long: int) -> 'Period': ...
    def subtractFrom(self, temporal: java.time.temporal.Temporal) -> java.time.temporal.Temporal: ...
    def toString(self) -> str: ...
    def toTotalMonths(self) -> int: ...
    def withDays(self, int: int) -> 'Period': ...
    def withMonths(self, int: int) -> 'Period': ...
    def withYears(self, int: int) -> 'Period': ...

class Ser(java.io.Externalizable):
    def __init__(self): ...
    def readExternal(self, objectInput: java.io.ObjectInput) -> None: ...
    def writeExternal(self, objectOutput: java.io.ObjectOutput) -> None: ...

class Year(java.time.temporal.Temporal, java.time.temporal.TemporalAdjuster, java.lang.Comparable['Year'], java.io.Serializable):
    MIN_VALUE: _py_ClassVar[int] = ...
    MAX_VALUE: _py_ClassVar[int] = ...
    def adjustInto(self, temporal: java.time.temporal.Temporal) -> java.time.temporal.Temporal: ...
    def atDay(self, int: int) -> LocalDate: ...
    @overload
    def atMonth(self, int: int) -> 'YearMonth': ...
    @overload
    def atMonth(self, month: Month) -> 'YearMonth': ...
    def atMonthDay(self, monthDay: MonthDay) -> LocalDate: ...
    @overload
    def compareTo(self, object: _py_Any) -> int: ...
    @overload
    def compareTo(self, year: 'Year') -> int: ...
    def equals(self, object: _py_Any) -> bool: ...
    def format(self, dateTimeFormatter: java.time.format.DateTimeFormatter) -> str: ...
    def get(self, temporalField: java.time.temporal.TemporalField) -> int: ...
    def getLong(self, temporalField: java.time.temporal.TemporalField) -> int: ...
    def getValue(self) -> int: ...
    def hashCode(self) -> int: ...
    def isAfter(self, year: 'Year') -> bool: ...
    def isBefore(self, year: 'Year') -> bool: ...
    @overload
    def isLeap(self) -> bool: ...
    @classmethod
    @overload
    def isLeap(cls, long: int) -> bool: ...
    @overload
    def isSupported(self, temporalField: java.time.temporal.TemporalField) -> bool: ...
    @overload
    def isSupported(self, temporalUnit: java.time.temporal.TemporalUnit) -> bool: ...
    def isValidMonthDay(self, monthDay: MonthDay) -> bool: ...
    def length(self) -> int: ...
    @overload
    def minus(self, temporalAmount: java.time.temporal.TemporalAmount) -> 'Year': ...
    @overload
    def minus(self, long: int, temporalUnit: java.time.temporal.TemporalUnit) -> 'Year': ...
    @overload
    def minus(self, temporalAmount: java.time.temporal.TemporalAmount) -> java.time.temporal.Temporal: ...
    @overload
    def minus(self, long: int, temporalUnit: java.time.temporal.TemporalUnit) -> java.time.temporal.Temporal: ...
    def minusYears(self, long: int) -> 'Year': ...
    @classmethod
    @overload
    def now(cls) -> 'Year': ...
    @classmethod
    @overload
    def now(cls, clock: Clock) -> 'Year': ...
    @classmethod
    @overload
    def now(cls, zoneId: 'ZoneId') -> 'Year': ...
    @classmethod
    def of(cls, int: int) -> 'Year': ...
    @classmethod
    @overload
    def parse(cls, charSequence: java.lang.CharSequence) -> 'Year': ...
    @classmethod
    @overload
    def parse(cls, charSequence: java.lang.CharSequence, dateTimeFormatter: java.time.format.DateTimeFormatter) -> 'Year': ...
    @overload
    def plus(self, temporalAmount: java.time.temporal.TemporalAmount) -> 'Year': ...
    @overload
    def plus(self, long: int, temporalUnit: java.time.temporal.TemporalUnit) -> 'Year': ...
    @overload
    def plus(self, temporalAmount: java.time.temporal.TemporalAmount) -> java.time.temporal.Temporal: ...
    @overload
    def plus(self, long: int, temporalUnit: java.time.temporal.TemporalUnit) -> java.time.temporal.Temporal: ...
    def plusYears(self, long: int) -> 'Year': ...
    _query__R = _py_TypeVar('_query__R')  # <R>
    def query(self, temporalQuery: java.time.temporal.TemporalQuery[_query__R]) -> _query__R: ...
    def range(self, temporalField: java.time.temporal.TemporalField) -> java.time.temporal.ValueRange: ...
    def toString(self) -> str: ...
    def until(self, temporal: java.time.temporal.Temporal, temporalUnit: java.time.temporal.TemporalUnit) -> int: ...

class YearMonth(java.time.temporal.Temporal, java.time.temporal.TemporalAdjuster, java.lang.Comparable['YearMonth'], java.io.Serializable):
    def adjustInto(self, temporal: java.time.temporal.Temporal) -> java.time.temporal.Temporal: ...
    def atDay(self, int: int) -> LocalDate: ...
    def atEndOfMonth(self) -> LocalDate: ...
    @overload
    def compareTo(self, object: _py_Any) -> int: ...
    @overload
    def compareTo(self, yearMonth: 'YearMonth') -> int: ...
    def equals(self, object: _py_Any) -> bool: ...
    def format(self, dateTimeFormatter: java.time.format.DateTimeFormatter) -> str: ...
    def get(self, temporalField: java.time.temporal.TemporalField) -> int: ...
    def getLong(self, temporalField: java.time.temporal.TemporalField) -> int: ...
    def getMonth(self) -> Month: ...
    def getMonthValue(self) -> int: ...
    def getYear(self) -> int: ...
    def hashCode(self) -> int: ...
    def isAfter(self, yearMonth: 'YearMonth') -> bool: ...
    def isBefore(self, yearMonth: 'YearMonth') -> bool: ...
    def isLeapYear(self) -> bool: ...
    @overload
    def isSupported(self, temporalField: java.time.temporal.TemporalField) -> bool: ...
    @overload
    def isSupported(self, temporalUnit: java.time.temporal.TemporalUnit) -> bool: ...
    def isValidDay(self, int: int) -> bool: ...
    def lengthOfMonth(self) -> int: ...
    def lengthOfYear(self) -> int: ...
    @overload
    def minus(self, temporalAmount: java.time.temporal.TemporalAmount) -> 'YearMonth': ...
    @overload
    def minus(self, long: int, temporalUnit: java.time.temporal.TemporalUnit) -> 'YearMonth': ...
    @overload
    def minus(self, temporalAmount: java.time.temporal.TemporalAmount) -> java.time.temporal.Temporal: ...
    @overload
    def minus(self, long: int, temporalUnit: java.time.temporal.TemporalUnit) -> java.time.temporal.Temporal: ...
    def minusMonths(self, long: int) -> 'YearMonth': ...
    def minusYears(self, long: int) -> 'YearMonth': ...
    @classmethod
    @overload
    def now(cls) -> 'YearMonth': ...
    @classmethod
    @overload
    def now(cls, clock: Clock) -> 'YearMonth': ...
    @classmethod
    @overload
    def now(cls, zoneId: 'ZoneId') -> 'YearMonth': ...
    @classmethod
    @overload
    def of(cls, int: int, int2: int) -> 'YearMonth': ...
    @classmethod
    @overload
    def of(cls, int: int, month: Month) -> 'YearMonth': ...
    @classmethod
    @overload
    def parse(cls, charSequence: java.lang.CharSequence) -> 'YearMonth': ...
    @classmethod
    @overload
    def parse(cls, charSequence: java.lang.CharSequence, dateTimeFormatter: java.time.format.DateTimeFormatter) -> 'YearMonth': ...
    @overload
    def plus(self, temporalAmount: java.time.temporal.TemporalAmount) -> 'YearMonth': ...
    @overload
    def plus(self, long: int, temporalUnit: java.time.temporal.TemporalUnit) -> 'YearMonth': ...
    @overload
    def plus(self, temporalAmount: java.time.temporal.TemporalAmount) -> java.time.temporal.Temporal: ...
    @overload
    def plus(self, long: int, temporalUnit: java.time.temporal.TemporalUnit) -> java.time.temporal.Temporal: ...
    def plusMonths(self, long: int) -> 'YearMonth': ...
    def plusYears(self, long: int) -> 'YearMonth': ...
    _query__R = _py_TypeVar('_query__R')  # <R>
    def query(self, temporalQuery: java.time.temporal.TemporalQuery[_query__R]) -> _query__R: ...
    def range(self, temporalField: java.time.temporal.TemporalField) -> java.time.temporal.ValueRange: ...
    def toString(self) -> str: ...
    def until(self, temporal: java.time.temporal.Temporal, temporalUnit: java.time.temporal.TemporalUnit) -> int: ...
    def withMonth(self, int: int) -> 'YearMonth': ...
    def withYear(self, int: int) -> 'YearMonth': ...

class ZoneId(java.io.Serializable):
    SHORT_IDS: _py_ClassVar[java.util.Map] = ...
    def equals(self, object: _py_Any) -> bool: ...
    @classmethod
    def getAvailableZoneIds(cls) -> java.util.Set[str]: ...
    def getDisplayName(self, textStyle: java.time.format.TextStyle, locale: java.util.Locale) -> str: ...
    def getId(self) -> str: ...
    def getRules(self) -> java.time.zone.ZoneRules: ...
    def hashCode(self) -> int: ...
    def normalized(self) -> 'ZoneId': ...
    @classmethod
    @overload
    def of(cls, string: str) -> 'ZoneId': ...
    @classmethod
    @overload
    def of(cls, string: str, map: java.util.Map[str, str]) -> 'ZoneId': ...
    @classmethod
    def ofOffset(cls, string: str, zoneOffset: 'ZoneOffset') -> 'ZoneId': ...
    @classmethod
    def systemDefault(cls) -> 'ZoneId': ...
    def toString(self) -> str: ...

class ZonedDateTime(java.time.temporal.Temporal, java.time.chrono.ChronoZonedDateTime[LocalDate], java.io.Serializable):
    def equals(self, object: _py_Any) -> bool: ...
    def format(self, dateTimeFormatter: java.time.format.DateTimeFormatter) -> str: ...
    def get(self, temporalField: java.time.temporal.TemporalField) -> int: ...
    def getDayOfMonth(self) -> int: ...
    def getDayOfWeek(self) -> DayOfWeek: ...
    def getDayOfYear(self) -> int: ...
    def getHour(self) -> int: ...
    def getLong(self, temporalField: java.time.temporal.TemporalField) -> int: ...
    def getMinute(self) -> int: ...
    def getMonth(self) -> Month: ...
    def getMonthValue(self) -> int: ...
    def getNano(self) -> int: ...
    def getOffset(self) -> 'ZoneOffset': ...
    def getSecond(self) -> int: ...
    def getYear(self) -> int: ...
    def getZone(self) -> ZoneId: ...
    def hashCode(self) -> int: ...
    @overload
    def isSupported(self, temporalField: java.time.temporal.TemporalField) -> bool: ...
    @overload
    def isSupported(self, temporalUnit: java.time.temporal.TemporalUnit) -> bool: ...
    @overload
    def minus(self, temporalAmount: java.time.temporal.TemporalAmount) -> 'ZonedDateTime': ...
    @overload
    def minus(self, long: int, temporalUnit: java.time.temporal.TemporalUnit) -> 'ZonedDateTime': ...
    @overload
    def minus(self, temporalAmount: java.time.temporal.TemporalAmount) -> java.time.chrono.ChronoZonedDateTime: ...
    @overload
    def minus(self, long: int, temporalUnit: java.time.temporal.TemporalUnit) -> java.time.chrono.ChronoZonedDateTime: ...
    @overload
    def minus(self, temporalAmount: java.time.temporal.TemporalAmount) -> java.time.temporal.Temporal: ...
    @overload
    def minus(self, long: int, temporalUnit: java.time.temporal.TemporalUnit) -> java.time.temporal.Temporal: ...
    def minusDays(self, long: int) -> 'ZonedDateTime': ...
    def minusHours(self, long: int) -> 'ZonedDateTime': ...
    def minusMinutes(self, long: int) -> 'ZonedDateTime': ...
    def minusMonths(self, long: int) -> 'ZonedDateTime': ...
    def minusNanos(self, long: int) -> 'ZonedDateTime': ...
    def minusSeconds(self, long: int) -> 'ZonedDateTime': ...
    def minusWeeks(self, long: int) -> 'ZonedDateTime': ...
    def minusYears(self, long: int) -> 'ZonedDateTime': ...
    @classmethod
    @overload
    def now(cls) -> 'ZonedDateTime': ...
    @classmethod
    @overload
    def now(cls, clock: Clock) -> 'ZonedDateTime': ...
    @classmethod
    @overload
    def now(cls, zoneId: ZoneId) -> 'ZonedDateTime': ...
    @classmethod
    @overload
    def of(cls, int: int, int2: int, int3: int, int4: int, int5: int, int6: int, int7: int, zoneId: ZoneId) -> 'ZonedDateTime': ...
    @classmethod
    @overload
    def of(cls, localDate: LocalDate, localTime: LocalTime, zoneId: ZoneId) -> 'ZonedDateTime': ...
    @classmethod
    @overload
    def of(cls, localDateTime: LocalDateTime, zoneId: ZoneId) -> 'ZonedDateTime': ...
    @classmethod
    @overload
    def ofInstant(cls, instant: Instant, zoneId: ZoneId) -> 'ZonedDateTime': ...
    @classmethod
    @overload
    def ofInstant(cls, localDateTime: LocalDateTime, zoneOffset: 'ZoneOffset', zoneId: ZoneId) -> 'ZonedDateTime': ...
    @classmethod
    def ofLocal(cls, localDateTime: LocalDateTime, zoneId: ZoneId, zoneOffset: 'ZoneOffset') -> 'ZonedDateTime': ...
    @classmethod
    def ofStrict(cls, localDateTime: LocalDateTime, zoneOffset: 'ZoneOffset', zoneId: ZoneId) -> 'ZonedDateTime': ...
    @classmethod
    @overload
    def parse(cls, charSequence: java.lang.CharSequence) -> 'ZonedDateTime': ...
    @classmethod
    @overload
    def parse(cls, charSequence: java.lang.CharSequence, dateTimeFormatter: java.time.format.DateTimeFormatter) -> 'ZonedDateTime': ...
    @overload
    def plus(self, temporalAmount: java.time.temporal.TemporalAmount) -> 'ZonedDateTime': ...
    @overload
    def plus(self, long: int, temporalUnit: java.time.temporal.TemporalUnit) -> 'ZonedDateTime': ...
    @overload
    def plus(self, temporalAmount: java.time.temporal.TemporalAmount) -> java.time.chrono.ChronoZonedDateTime: ...
    @overload
    def plus(self, long: int, temporalUnit: java.time.temporal.TemporalUnit) -> java.time.chrono.ChronoZonedDateTime: ...
    @overload
    def plus(self, temporalAmount: java.time.temporal.TemporalAmount) -> java.time.temporal.Temporal: ...
    @overload
    def plus(self, long: int, temporalUnit: java.time.temporal.TemporalUnit) -> java.time.temporal.Temporal: ...
    def plusDays(self, long: int) -> 'ZonedDateTime': ...
    def plusHours(self, long: int) -> 'ZonedDateTime': ...
    def plusMinutes(self, long: int) -> 'ZonedDateTime': ...
    def plusMonths(self, long: int) -> 'ZonedDateTime': ...
    def plusNanos(self, long: int) -> 'ZonedDateTime': ...
    def plusSeconds(self, long: int) -> 'ZonedDateTime': ...
    def plusWeeks(self, long: int) -> 'ZonedDateTime': ...
    def plusYears(self, long: int) -> 'ZonedDateTime': ...
    _query__R = _py_TypeVar('_query__R')  # <R>
    def query(self, temporalQuery: java.time.temporal.TemporalQuery[_query__R]) -> _query__R: ...
    def range(self, temporalField: java.time.temporal.TemporalField) -> java.time.temporal.ValueRange: ...
    @overload
    def toLocalDate(self) -> LocalDate: ...
    @overload
    def toLocalDate(self) -> java.time.chrono.ChronoLocalDate: ...
    @overload
    def toLocalDateTime(self) -> LocalDateTime: ...
    @overload
    def toLocalDateTime(self) -> java.time.chrono.ChronoLocalDateTime: ...
    def toLocalTime(self) -> LocalTime: ...
    def toOffsetDateTime(self) -> OffsetDateTime: ...
    def toString(self) -> str: ...
    def truncatedTo(self, temporalUnit: java.time.temporal.TemporalUnit) -> 'ZonedDateTime': ...
    def until(self, temporal: java.time.temporal.Temporal, temporalUnit: java.time.temporal.TemporalUnit) -> int: ...
    def withDayOfMonth(self, int: int) -> 'ZonedDateTime': ...
    def withDayOfYear(self, int: int) -> 'ZonedDateTime': ...
    @overload
    def withEarlierOffsetAtOverlap(self) -> 'ZonedDateTime': ...
    @overload
    def withEarlierOffsetAtOverlap(self) -> java.time.chrono.ChronoZonedDateTime: ...
    def withFixedOffsetZone(self) -> 'ZonedDateTime': ...
    def withHour(self, int: int) -> 'ZonedDateTime': ...
    @overload
    def withLaterOffsetAtOverlap(self) -> 'ZonedDateTime': ...
    @overload
    def withLaterOffsetAtOverlap(self) -> java.time.chrono.ChronoZonedDateTime: ...
    def withMinute(self, int: int) -> 'ZonedDateTime': ...
    def withMonth(self, int: int) -> 'ZonedDateTime': ...
    def withNano(self, int: int) -> 'ZonedDateTime': ...
    def withSecond(self, int: int) -> 'ZonedDateTime': ...
    def withYear(self, int: int) -> 'ZonedDateTime': ...
    @overload
    def withZoneSameInstant(self, zoneId: ZoneId) -> 'ZonedDateTime': ...
    @overload
    def withZoneSameInstant(self, zoneId: ZoneId) -> java.time.chrono.ChronoZonedDateTime: ...
    @overload
    def withZoneSameLocal(self, zoneId: ZoneId) -> 'ZonedDateTime': ...
    @overload
    def withZoneSameLocal(self, zoneId: ZoneId) -> java.time.chrono.ChronoZonedDateTime: ...

class ZoneOffset(ZoneId, java.time.temporal.TemporalAccessor, java.time.temporal.TemporalAdjuster, java.lang.Comparable['ZoneOffset'], java.io.Serializable):
    UTC: _py_ClassVar['ZoneOffset'] = ...
    MIN: _py_ClassVar['ZoneOffset'] = ...
    MAX: _py_ClassVar['ZoneOffset'] = ...
    def adjustInto(self, temporal: java.time.temporal.Temporal) -> java.time.temporal.Temporal: ...
    @overload
    def compareTo(self, object: _py_Any) -> int: ...
    @overload
    def compareTo(self, zoneOffset: 'ZoneOffset') -> int: ...
    def equals(self, object: _py_Any) -> bool: ...
    def get(self, temporalField: java.time.temporal.TemporalField) -> int: ...
    def getId(self) -> str: ...
    def getLong(self, temporalField: java.time.temporal.TemporalField) -> int: ...
    def getRules(self) -> java.time.zone.ZoneRules: ...
    def getTotalSeconds(self) -> int: ...
    def hashCode(self) -> int: ...
    def isSupported(self, temporalField: java.time.temporal.TemporalField) -> bool: ...
    @classmethod
    @overload
    def of(cls, string: str) -> ZoneId: ...
    @classmethod
    @overload
    def of(cls, string: str, map: java.util.Map[str, str]) -> ZoneId: ...
    @classmethod
    @overload
    def of(cls, string: str) -> 'ZoneOffset': ...
    @classmethod
    def ofHours(cls, int: int) -> 'ZoneOffset': ...
    @classmethod
    def ofHoursMinutes(cls, int: int, int2: int) -> 'ZoneOffset': ...
    @classmethod
    def ofHoursMinutesSeconds(cls, int: int, int2: int, int3: int) -> 'ZoneOffset': ...
    @classmethod
    def ofTotalSeconds(cls, int: int) -> 'ZoneOffset': ...
    _query__R = _py_TypeVar('_query__R')  # <R>
    def query(self, temporalQuery: java.time.temporal.TemporalQuery[_query__R]) -> _query__R: ...
    def range(self, temporalField: java.time.temporal.TemporalField) -> java.time.temporal.ValueRange: ...
    def toString(self) -> str: ...

class ZoneRegion(ZoneId, java.io.Serializable):
    def getId(self) -> str: ...
    def getRules(self) -> java.time.zone.ZoneRules: ...
