from typing import Any as _py_Any
from typing import List as _py_List
from typing import TypeVar as _py_TypeVar
from typing import Type as _py_Type
from typing import ClassVar as _py_ClassVar
from typing import overload
import java
import java.io
import java.lang
import java.math
import java.net
import java.security
import java.util
import javax.security.auth.x500
import sun.security.provider.certpath


class CRL:
    def getType(self) -> str: ...
    def isRevoked(self, certificate: 'Certificate') -> bool: ...
    def toString(self) -> str: ...

class CRLException(java.security.GeneralSecurityException):
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, string: str): ...
    @overload
    def __init__(self, string: str, throwable: java.lang.Throwable): ...
    @overload
    def __init__(self, throwable: java.lang.Throwable): ...

class CRLReason(java.lang.Enum['CRLReason']):
    UNSPECIFIED: _py_ClassVar['CRLReason'] = ...
    KEY_COMPROMISE: _py_ClassVar['CRLReason'] = ...
    CA_COMPROMISE: _py_ClassVar['CRLReason'] = ...
    AFFILIATION_CHANGED: _py_ClassVar['CRLReason'] = ...
    SUPERSEDED: _py_ClassVar['CRLReason'] = ...
    CESSATION_OF_OPERATION: _py_ClassVar['CRLReason'] = ...
    CERTIFICATE_HOLD: _py_ClassVar['CRLReason'] = ...
    UNUSED: _py_ClassVar['CRLReason'] = ...
    REMOVE_FROM_CRL: _py_ClassVar['CRLReason'] = ...
    PRIVILEGE_WITHDRAWN: _py_ClassVar['CRLReason'] = ...
    AA_COMPROMISE: _py_ClassVar['CRLReason'] = ...
    _valueOf_0__T = _py_TypeVar('_valueOf_0__T', bound=java.lang.Enum)  # <T>
    @classmethod
    @overload
    def valueOf(cls, class_: _py_Type[_valueOf_0__T], string: str) -> _valueOf_0__T: ...
    @classmethod
    @overload
    def valueOf(cls, string: str) -> 'CRLReason': ...
    @classmethod
    def values(cls) -> _py_List['CRLReason']: ...

class CRLSelector(java.lang.Cloneable):
    def clone(self) -> _py_Any: ...
    def match(self, cRL: CRL) -> bool: ...

class CertPath(java.io.Serializable):
    def equals(self, object: _py_Any) -> bool: ...
    def getCertificates(self) -> java.util.List['Certificate']: ...
    @overload
    def getEncoded(self) -> _py_List[int]: ...
    @overload
    def getEncoded(self, string: str) -> _py_List[int]: ...
    def getEncodings(self) -> java.util.Iterator[str]: ...
    def getType(self) -> str: ...
    def hashCode(self) -> int: ...
    def toString(self) -> str: ...

class CertPathBuilder:
    def build(self, certPathParameters: 'CertPathParameters') -> 'CertPathBuilderResult': ...
    def getAlgorithm(self) -> str: ...
    @classmethod
    def getDefaultType(cls) -> str: ...
    @classmethod
    @overload
    def getInstance(cls, string: str) -> 'CertPathBuilder': ...
    @classmethod
    @overload
    def getInstance(cls, string: str, string2: str) -> 'CertPathBuilder': ...
    @classmethod
    @overload
    def getInstance(cls, string: str, provider: java.security.Provider) -> 'CertPathBuilder': ...
    def getProvider(self) -> java.security.Provider: ...
    def getRevocationChecker(self) -> 'CertPathChecker': ...

class CertPathBuilderException(java.security.GeneralSecurityException):
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, string: str): ...
    @overload
    def __init__(self, string: str, throwable: java.lang.Throwable): ...
    @overload
    def __init__(self, throwable: java.lang.Throwable): ...

class CertPathBuilderResult(java.lang.Cloneable):
    def clone(self) -> _py_Any: ...
    def getCertPath(self) -> CertPath: ...

class CertPathBuilderSpi:
    def __init__(self): ...
    def engineBuild(self, certPathParameters: 'CertPathParameters') -> CertPathBuilderResult: ...
    def engineGetRevocationChecker(self) -> 'CertPathChecker': ...

class CertPathChecker:
    def check(self, certificate: 'Certificate') -> None: ...
    def init(self, boolean: bool) -> None: ...
    def isForwardCheckingSupported(self) -> bool: ...

class CertPathHelperImpl(sun.security.provider.certpath.CertPathHelper): ...

class CertPathParameters(java.lang.Cloneable):
    def clone(self) -> _py_Any: ...

class CertPathValidator:
    def getAlgorithm(self) -> str: ...
    @classmethod
    def getDefaultType(cls) -> str: ...
    @classmethod
    @overload
    def getInstance(cls, string: str) -> 'CertPathValidator': ...
    @classmethod
    @overload
    def getInstance(cls, string: str, string2: str) -> 'CertPathValidator': ...
    @classmethod
    @overload
    def getInstance(cls, string: str, provider: java.security.Provider) -> 'CertPathValidator': ...
    def getProvider(self) -> java.security.Provider: ...
    def getRevocationChecker(self) -> CertPathChecker: ...
    def validate(self, certPath: CertPath, certPathParameters: CertPathParameters) -> 'CertPathValidatorResult': ...

class CertPathValidatorResult(java.lang.Cloneable):
    def clone(self) -> _py_Any: ...

class CertPathValidatorSpi:
    def __init__(self): ...
    def engineGetRevocationChecker(self) -> CertPathChecker: ...
    def engineValidate(self, certPath: CertPath, certPathParameters: CertPathParameters) -> CertPathValidatorResult: ...

class CertSelector(java.lang.Cloneable):
    def clone(self) -> _py_Any: ...
    def match(self, certificate: 'Certificate') -> bool: ...

class CertStore:
    def getCRLs(self, cRLSelector: CRLSelector) -> java.util.Collection[CRL]: ...
    def getCertStoreParameters(self) -> 'CertStoreParameters': ...
    def getCertificates(self, certSelector: CertSelector) -> java.util.Collection['Certificate']: ...
    @classmethod
    def getDefaultType(cls) -> str: ...
    @classmethod
    @overload
    def getInstance(cls, string: str, certStoreParameters: 'CertStoreParameters') -> 'CertStore': ...
    @classmethod
    @overload
    def getInstance(cls, string: str, certStoreParameters: 'CertStoreParameters', string2: str) -> 'CertStore': ...
    @classmethod
    @overload
    def getInstance(cls, string: str, certStoreParameters: 'CertStoreParameters', provider: java.security.Provider) -> 'CertStore': ...
    def getProvider(self) -> java.security.Provider: ...
    def getType(self) -> str: ...

class CertStoreException(java.security.GeneralSecurityException):
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, string: str): ...
    @overload
    def __init__(self, string: str, throwable: java.lang.Throwable): ...
    @overload
    def __init__(self, throwable: java.lang.Throwable): ...

class CertStoreParameters(java.lang.Cloneable):
    def clone(self) -> _py_Any: ...

class CertStoreSpi:
    def __init__(self, certStoreParameters: CertStoreParameters): ...
    def engineGetCRLs(self, cRLSelector: CRLSelector) -> java.util.Collection[CRL]: ...
    def engineGetCertificates(self, certSelector: CertSelector) -> java.util.Collection['Certificate']: ...

class Certificate(java.io.Serializable):
    def equals(self, object: _py_Any) -> bool: ...
    def getEncoded(self) -> _py_List[int]: ...
    def getPublicKey(self) -> java.security.PublicKey: ...
    def getType(self) -> str: ...
    def hashCode(self) -> int: ...
    def toString(self) -> str: ...
    @overload
    def verify(self, publicKey: java.security.PublicKey) -> None: ...
    @overload
    def verify(self, publicKey: java.security.PublicKey, string: str) -> None: ...
    @overload
    def verify(self, publicKey: java.security.PublicKey, provider: java.security.Provider) -> None: ...

class CertificateException(java.security.GeneralSecurityException):
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, string: str): ...
    @overload
    def __init__(self, string: str, throwable: java.lang.Throwable): ...
    @overload
    def __init__(self, throwable: java.lang.Throwable): ...

class CertificateFactory:
    def generateCRL(self, inputStream: java.io.InputStream) -> CRL: ...
    def generateCRLs(self, inputStream: java.io.InputStream) -> java.util.Collection[CRL]: ...
    @overload
    def generateCertPath(self, inputStream: java.io.InputStream) -> CertPath: ...
    @overload
    def generateCertPath(self, inputStream: java.io.InputStream, string: str) -> CertPath: ...
    @overload
    def generateCertPath(self, list: java.util.List[Certificate]) -> CertPath: ...
    def generateCertificate(self, inputStream: java.io.InputStream) -> Certificate: ...
    def generateCertificates(self, inputStream: java.io.InputStream) -> java.util.Collection[Certificate]: ...
    def getCertPathEncodings(self) -> java.util.Iterator[str]: ...
    @classmethod
    @overload
    def getInstance(cls, string: str) -> 'CertificateFactory': ...
    @classmethod
    @overload
    def getInstance(cls, string: str, string2: str) -> 'CertificateFactory': ...
    @classmethod
    @overload
    def getInstance(cls, string: str, provider: java.security.Provider) -> 'CertificateFactory': ...
    def getProvider(self) -> java.security.Provider: ...
    def getType(self) -> str: ...

class CertificateFactorySpi:
    def __init__(self): ...
    def engineGenerateCRL(self, inputStream: java.io.InputStream) -> CRL: ...
    def engineGenerateCRLs(self, inputStream: java.io.InputStream) -> java.util.Collection[CRL]: ...
    @overload
    def engineGenerateCertPath(self, inputStream: java.io.InputStream) -> CertPath: ...
    @overload
    def engineGenerateCertPath(self, inputStream: java.io.InputStream, string: str) -> CertPath: ...
    @overload
    def engineGenerateCertPath(self, list: java.util.List[Certificate]) -> CertPath: ...
    def engineGenerateCertificate(self, inputStream: java.io.InputStream) -> Certificate: ...
    def engineGenerateCertificates(self, inputStream: java.io.InputStream) -> java.util.Collection[Certificate]: ...
    def engineGetCertPathEncodings(self) -> java.util.Iterator[str]: ...

class Extension:
    def encode(self, outputStream: java.io.OutputStream) -> None: ...
    def getId(self) -> str: ...
    def getValue(self) -> _py_List[int]: ...
    def isCritical(self) -> bool: ...

class PolicyNode:
    def getChildren(self) -> java.util.Iterator['PolicyNode']: ...
    def getDepth(self) -> int: ...
    def getExpectedPolicies(self) -> java.util.Set[str]: ...
    def getParent(self) -> 'PolicyNode': ...
    def getPolicyQualifiers(self) -> java.util.Set['PolicyQualifierInfo']: ...
    def getValidPolicy(self) -> str: ...
    def isCritical(self) -> bool: ...

class PolicyQualifierInfo:
    def __init__(self, byteArray: _py_List[int]): ...
    def getEncoded(self) -> _py_List[int]: ...
    def getPolicyQualifier(self) -> _py_List[int]: ...
    def getPolicyQualifierId(self) -> str: ...
    def toString(self) -> str: ...

class TrustAnchor:
    @overload
    def __init__(self, string: str, publicKey: java.security.PublicKey, byteArray: _py_List[int]): ...
    @overload
    def __init__(self, x509Certificate: 'X509Certificate', byteArray: _py_List[int]): ...
    @overload
    def __init__(self, x500Principal: javax.security.auth.x500.X500Principal, publicKey: java.security.PublicKey, byteArray: _py_List[int]): ...
    def getCA(self) -> javax.security.auth.x500.X500Principal: ...
    def getCAName(self) -> str: ...
    def getCAPublicKey(self) -> java.security.PublicKey: ...
    def getNameConstraints(self) -> _py_List[int]: ...
    def getTrustedCert(self) -> 'X509Certificate': ...
    def toString(self) -> str: ...

class X509Extension:
    def getCriticalExtensionOIDs(self) -> java.util.Set[str]: ...
    def getExtensionValue(self, string: str) -> _py_List[int]: ...
    def getNonCriticalExtensionOIDs(self) -> java.util.Set[str]: ...
    def hasUnsupportedCriticalExtension(self) -> bool: ...

class CertificateEncodingException(CertificateException):
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, string: str): ...
    @overload
    def __init__(self, string: str, throwable: java.lang.Throwable): ...
    @overload
    def __init__(self, throwable: java.lang.Throwable): ...

class CertificateExpiredException(CertificateException):
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, string: str): ...

class CertificateNotYetValidException(CertificateException):
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, string: str): ...

class CertificateParsingException(CertificateException):
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, string: str): ...
    @overload
    def __init__(self, string: str, throwable: java.lang.Throwable): ...
    @overload
    def __init__(self, throwable: java.lang.Throwable): ...

class CertificateRevokedException(CertificateException):
    def __init__(self, date: java.util.Date, cRLReason: CRLReason, x500Principal: javax.security.auth.x500.X500Principal, map: java.util.Map[str, Extension]): ...
    def getAuthorityName(self) -> javax.security.auth.x500.X500Principal: ...
    def getExtensions(self) -> java.util.Map[str, Extension]: ...
    def getInvalidityDate(self) -> java.util.Date: ...
    def getMessage(self) -> str: ...
    def getRevocationDate(self) -> java.util.Date: ...
    def getRevocationReason(self) -> CRLReason: ...

class CollectionCertStoreParameters(CertStoreParameters):
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, collection: java.util.Collection[_py_Any]): ...
    def clone(self) -> _py_Any: ...
    def getCollection(self) -> java.util.Collection[_py_Any]: ...
    def toString(self) -> str: ...

class LDAPCertStoreParameters(CertStoreParameters):
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, string: str): ...
    @overload
    def __init__(self, string: str, int: int): ...
    def clone(self) -> _py_Any: ...
    def getPort(self) -> int: ...
    def getServerName(self) -> str: ...
    def toString(self) -> str: ...

class PKIXCertPathChecker(CertPathChecker, java.lang.Cloneable):
    @overload
    def check(self, certificate: Certificate, collection: java.util.Collection[str]) -> None: ...
    @overload
    def check(self, certificate: Certificate) -> None: ...
    def clone(self) -> _py_Any: ...
    def getSupportedExtensions(self) -> java.util.Set[str]: ...
    def init(self, boolean: bool) -> None: ...
    def isForwardCheckingSupported(self) -> bool: ...

class PKIXCertPathValidatorResult(CertPathValidatorResult):
    def __init__(self, trustAnchor: TrustAnchor, policyNode: PolicyNode, publicKey: java.security.PublicKey): ...
    def clone(self) -> _py_Any: ...
    def getPolicyTree(self) -> PolicyNode: ...
    def getPublicKey(self) -> java.security.PublicKey: ...
    def getTrustAnchor(self) -> TrustAnchor: ...
    def toString(self) -> str: ...

class PKIXParameters(CertPathParameters):
    @overload
    def __init__(self, keyStore: java.security.KeyStore): ...
    @overload
    def __init__(self, set: java.util.Set[TrustAnchor]): ...
    def addCertPathChecker(self, pKIXCertPathChecker: PKIXCertPathChecker) -> None: ...
    def addCertStore(self, certStore: CertStore) -> None: ...
    def clone(self) -> _py_Any: ...
    def getCertPathCheckers(self) -> java.util.List[PKIXCertPathChecker]: ...
    def getCertStores(self) -> java.util.List[CertStore]: ...
    def getDate(self) -> java.util.Date: ...
    def getInitialPolicies(self) -> java.util.Set[str]: ...
    def getPolicyQualifiersRejected(self) -> bool: ...
    def getSigProvider(self) -> str: ...
    def getTargetCertConstraints(self) -> CertSelector: ...
    def getTrustAnchors(self) -> java.util.Set[TrustAnchor]: ...
    def isAnyPolicyInhibited(self) -> bool: ...
    def isExplicitPolicyRequired(self) -> bool: ...
    def isPolicyMappingInhibited(self) -> bool: ...
    def isRevocationEnabled(self) -> bool: ...
    def setAnyPolicyInhibited(self, boolean: bool) -> None: ...
    def setCertPathCheckers(self, list: java.util.List[PKIXCertPathChecker]) -> None: ...
    def setCertStores(self, list: java.util.List[CertStore]) -> None: ...
    def setDate(self, date: java.util.Date) -> None: ...
    def setExplicitPolicyRequired(self, boolean: bool) -> None: ...
    def setInitialPolicies(self, set: java.util.Set[str]) -> None: ...
    def setPolicyMappingInhibited(self, boolean: bool) -> None: ...
    def setPolicyQualifiersRejected(self, boolean: bool) -> None: ...
    def setRevocationEnabled(self, boolean: bool) -> None: ...
    def setSigProvider(self, string: str) -> None: ...
    def setTargetCertConstraints(self, certSelector: CertSelector) -> None: ...
    def setTrustAnchors(self, set: java.util.Set[TrustAnchor]) -> None: ...
    def toString(self) -> str: ...

class X509CRL(CRL, X509Extension):
    def equals(self, object: _py_Any) -> bool: ...
    def getEncoded(self) -> _py_List[int]: ...
    def getIssuerDN(self) -> java.security.Principal: ...
    def getIssuerX500Principal(self) -> javax.security.auth.x500.X500Principal: ...
    def getNextUpdate(self) -> java.util.Date: ...
    @overload
    def getRevokedCertificate(self, bigInteger: java.math.BigInteger) -> 'X509CRLEntry': ...
    @overload
    def getRevokedCertificate(self, x509Certificate: 'X509Certificate') -> 'X509CRLEntry': ...
    def getRevokedCertificates(self) -> java.util.Set['X509CRLEntry']: ...
    def getSigAlgName(self) -> str: ...
    def getSigAlgOID(self) -> str: ...
    def getSigAlgParams(self) -> _py_List[int]: ...
    def getSignature(self) -> _py_List[int]: ...
    def getTBSCertList(self) -> _py_List[int]: ...
    def getThisUpdate(self) -> java.util.Date: ...
    def getVersion(self) -> int: ...
    def hashCode(self) -> int: ...
    @overload
    def verify(self, publicKey: java.security.PublicKey) -> None: ...
    @overload
    def verify(self, publicKey: java.security.PublicKey, string: str) -> None: ...
    @overload
    def verify(self, publicKey: java.security.PublicKey, provider: java.security.Provider) -> None: ...

class X509CRLEntry(X509Extension):
    def __init__(self): ...
    def equals(self, object: _py_Any) -> bool: ...
    def getCertificateIssuer(self) -> javax.security.auth.x500.X500Principal: ...
    def getEncoded(self) -> _py_List[int]: ...
    def getRevocationDate(self) -> java.util.Date: ...
    def getRevocationReason(self) -> CRLReason: ...
    def getSerialNumber(self) -> java.math.BigInteger: ...
    def hasExtensions(self) -> bool: ...
    def hashCode(self) -> int: ...
    def toString(self) -> str: ...

class X509CRLSelector(CRLSelector):
    def __init__(self): ...
    def addIssuer(self, x500Principal: javax.security.auth.x500.X500Principal) -> None: ...
    @overload
    def addIssuerName(self, byteArray: _py_List[int]) -> None: ...
    @overload
    def addIssuerName(self, string: str) -> None: ...
    def clone(self) -> _py_Any: ...
    def getCertificateChecking(self) -> 'X509Certificate': ...
    def getDateAndTime(self) -> java.util.Date: ...
    def getIssuerNames(self) -> java.util.Collection[_py_Any]: ...
    def getIssuers(self) -> java.util.Collection[javax.security.auth.x500.X500Principal]: ...
    def getMaxCRL(self) -> java.math.BigInteger: ...
    def getMinCRL(self) -> java.math.BigInteger: ...
    def match(self, cRL: CRL) -> bool: ...
    def setCertificateChecking(self, x509Certificate: 'X509Certificate') -> None: ...
    def setDateAndTime(self, date: java.util.Date) -> None: ...
    def setIssuerNames(self, collection: java.util.Collection[_py_Any]) -> None: ...
    def setIssuers(self, collection: java.util.Collection[javax.security.auth.x500.X500Principal]) -> None: ...
    def setMaxCRLNumber(self, bigInteger: java.math.BigInteger) -> None: ...
    def setMinCRLNumber(self, bigInteger: java.math.BigInteger) -> None: ...
    def toString(self) -> str: ...

class X509CertSelector(CertSelector):
    def __init__(self): ...
    @overload
    def addPathToName(self, int: int, byteArray: _py_List[int]) -> None: ...
    @overload
    def addPathToName(self, int: int, string: str) -> None: ...
    @overload
    def addSubjectAlternativeName(self, int: int, byteArray: _py_List[int]) -> None: ...
    @overload
    def addSubjectAlternativeName(self, int: int, string: str) -> None: ...
    def clone(self) -> _py_Any: ...
    def getAuthorityKeyIdentifier(self) -> _py_List[int]: ...
    def getBasicConstraints(self) -> int: ...
    def getCertificate(self) -> 'X509Certificate': ...
    def getCertificateValid(self) -> java.util.Date: ...
    def getExtendedKeyUsage(self) -> java.util.Set[str]: ...
    def getIssuer(self) -> javax.security.auth.x500.X500Principal: ...
    def getIssuerAsBytes(self) -> _py_List[int]: ...
    def getIssuerAsString(self) -> str: ...
    def getKeyUsage(self) -> _py_List[bool]: ...
    def getMatchAllSubjectAltNames(self) -> bool: ...
    def getNameConstraints(self) -> _py_List[int]: ...
    def getPathToNames(self) -> java.util.Collection[java.util.List[_py_Any]]: ...
    def getPolicy(self) -> java.util.Set[str]: ...
    def getPrivateKeyValid(self) -> java.util.Date: ...
    def getSerialNumber(self) -> java.math.BigInteger: ...
    def getSubject(self) -> javax.security.auth.x500.X500Principal: ...
    def getSubjectAlternativeNames(self) -> java.util.Collection[java.util.List[_py_Any]]: ...
    def getSubjectAsBytes(self) -> _py_List[int]: ...
    def getSubjectAsString(self) -> str: ...
    def getSubjectKeyIdentifier(self) -> _py_List[int]: ...
    def getSubjectPublicKey(self) -> java.security.PublicKey: ...
    def getSubjectPublicKeyAlgID(self) -> str: ...
    def match(self, certificate: Certificate) -> bool: ...
    def setAuthorityKeyIdentifier(self, byteArray: _py_List[int]) -> None: ...
    def setBasicConstraints(self, int: int) -> None: ...
    def setCertificate(self, x509Certificate: 'X509Certificate') -> None: ...
    def setCertificateValid(self, date: java.util.Date) -> None: ...
    def setExtendedKeyUsage(self, set: java.util.Set[str]) -> None: ...
    @overload
    def setIssuer(self, byteArray: _py_List[int]) -> None: ...
    @overload
    def setIssuer(self, string: str) -> None: ...
    @overload
    def setIssuer(self, x500Principal: javax.security.auth.x500.X500Principal) -> None: ...
    def setKeyUsage(self, booleanArray: _py_List[bool]) -> None: ...
    def setMatchAllSubjectAltNames(self, boolean: bool) -> None: ...
    def setNameConstraints(self, byteArray: _py_List[int]) -> None: ...
    def setPathToNames(self, collection: java.util.Collection[java.util.List[_py_Any]]) -> None: ...
    def setPolicy(self, set: java.util.Set[str]) -> None: ...
    def setPrivateKeyValid(self, date: java.util.Date) -> None: ...
    def setSerialNumber(self, bigInteger: java.math.BigInteger) -> None: ...
    @overload
    def setSubject(self, byteArray: _py_List[int]) -> None: ...
    @overload
    def setSubject(self, string: str) -> None: ...
    @overload
    def setSubject(self, x500Principal: javax.security.auth.x500.X500Principal) -> None: ...
    def setSubjectAlternativeNames(self, collection: java.util.Collection[java.util.List[_py_Any]]) -> None: ...
    def setSubjectKeyIdentifier(self, byteArray: _py_List[int]) -> None: ...
    @overload
    def setSubjectPublicKey(self, byteArray: _py_List[int]) -> None: ...
    @overload
    def setSubjectPublicKey(self, publicKey: java.security.PublicKey) -> None: ...
    def setSubjectPublicKeyAlgID(self, string: str) -> None: ...
    def toString(self) -> str: ...

class X509Certificate(Certificate, X509Extension):
    @overload
    def checkValidity(self) -> None: ...
    @overload
    def checkValidity(self, date: java.util.Date) -> None: ...
    def getBasicConstraints(self) -> int: ...
    def getExtendedKeyUsage(self) -> java.util.List[str]: ...
    def getIssuerAlternativeNames(self) -> java.util.Collection[java.util.List[_py_Any]]: ...
    def getIssuerDN(self) -> java.security.Principal: ...
    def getIssuerUniqueID(self) -> _py_List[bool]: ...
    def getIssuerX500Principal(self) -> javax.security.auth.x500.X500Principal: ...
    def getKeyUsage(self) -> _py_List[bool]: ...
    def getNotAfter(self) -> java.util.Date: ...
    def getNotBefore(self) -> java.util.Date: ...
    def getSerialNumber(self) -> java.math.BigInteger: ...
    def getSigAlgName(self) -> str: ...
    def getSigAlgOID(self) -> str: ...
    def getSigAlgParams(self) -> _py_List[int]: ...
    def getSignature(self) -> _py_List[int]: ...
    def getSubjectAlternativeNames(self) -> java.util.Collection[java.util.List[_py_Any]]: ...
    def getSubjectDN(self) -> java.security.Principal: ...
    def getSubjectUniqueID(self) -> _py_List[bool]: ...
    def getSubjectX500Principal(self) -> javax.security.auth.x500.X500Principal: ...
    def getTBSCertificate(self) -> _py_List[int]: ...
    def getVersion(self) -> int: ...
    @overload
    def verify(self, publicKey: java.security.PublicKey) -> None: ...
    @overload
    def verify(self, publicKey: java.security.PublicKey, string: str) -> None: ...
    @overload
    def verify(self, publicKey: java.security.PublicKey, provider: java.security.Provider) -> None: ...

class PKIXBuilderParameters(PKIXParameters):
    @overload
    def __init__(self, keyStore: java.security.KeyStore, certSelector: CertSelector): ...
    @overload
    def __init__(self, set: java.util.Set[TrustAnchor], certSelector: CertSelector): ...
    def getMaxPathLength(self) -> int: ...
    def setMaxPathLength(self, int: int) -> None: ...
    def toString(self) -> str: ...

class PKIXCertPathBuilderResult(PKIXCertPathValidatorResult, CertPathBuilderResult):
    def __init__(self, certPath: CertPath, trustAnchor: TrustAnchor, policyNode: PolicyNode, publicKey: java.security.PublicKey): ...
    def getCertPath(self) -> CertPath: ...
    def toString(self) -> str: ...

class PKIXRevocationChecker(PKIXCertPathChecker):
    @overload
    def clone(self) -> _py_Any: ...
    @overload
    def clone(self) -> 'PKIXRevocationChecker': ...
    def getOcspExtensions(self) -> java.util.List[Extension]: ...
    def getOcspResponder(self) -> java.net.URI: ...
    def getOcspResponderCert(self) -> X509Certificate: ...
    def getOcspResponses(self) -> java.util.Map[X509Certificate, _py_List[int]]: ...
    def getOptions(self) -> java.util.Set['PKIXRevocationChecker.Option']: ...
    def getSoftFailExceptions(self) -> java.util.List['CertPathValidatorException']: ...
    def setOcspExtensions(self, list: java.util.List[Extension]) -> None: ...
    def setOcspResponder(self, uRI: java.net.URI) -> None: ...
    def setOcspResponderCert(self, x509Certificate: X509Certificate) -> None: ...
    def setOcspResponses(self, map: java.util.Map[X509Certificate, _py_List[int]]) -> None: ...
    def setOptions(self, set: java.util.Set['PKIXRevocationChecker.Option']) -> None: ...
    class Option(java.lang.Enum['PKIXRevocationChecker.Option']):
        ONLY_END_ENTITY: _py_ClassVar['PKIXRevocationChecker.Option'] = ...
        PREFER_CRLS: _py_ClassVar['PKIXRevocationChecker.Option'] = ...
        NO_FALLBACK: _py_ClassVar['PKIXRevocationChecker.Option'] = ...
        SOFT_FAIL: _py_ClassVar['PKIXRevocationChecker.Option'] = ...
        _valueOf_0__T = _py_TypeVar('_valueOf_0__T', bound=java.lang.Enum)  # <T>
        @classmethod
        @overload
        def valueOf(cls, class_: _py_Type[_valueOf_0__T], string: str) -> _valueOf_0__T: ...
        @classmethod
        @overload
        def valueOf(cls, string: str) -> 'PKIXRevocationChecker.Option': ...
        @classmethod
        def values(cls) -> _py_List['PKIXRevocationChecker.Option']: ...

class CertPathValidatorException(java.security.GeneralSecurityException):
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, string: str): ...
    @overload
    def __init__(self, string: str, throwable: java.lang.Throwable): ...
    @overload
    def __init__(self, string: str, throwable: java.lang.Throwable, certPath: CertPath, int: int): ...
    @overload
    def __init__(self, string: str, throwable: java.lang.Throwable, certPath: CertPath, int: int, reason: 'CertPathValidatorException.Reason'): ...
    @overload
    def __init__(self, throwable: java.lang.Throwable): ...
    def getCertPath(self) -> CertPath: ...
    def getIndex(self) -> int: ...
    def getReason(self) -> 'CertPathValidatorException.Reason': ...
    class BasicReason(java.lang.Enum['CertPathValidatorException.BasicReason'], java.security.cert.CertPathValidatorException.Reason):
        UNSPECIFIED: _py_ClassVar['CertPathValidatorException.BasicReason'] = ...
        EXPIRED: _py_ClassVar['CertPathValidatorException.BasicReason'] = ...
        NOT_YET_VALID: _py_ClassVar['CertPathValidatorException.BasicReason'] = ...
        REVOKED: _py_ClassVar['CertPathValidatorException.BasicReason'] = ...
        UNDETERMINED_REVOCATION_STATUS: _py_ClassVar['CertPathValidatorException.BasicReason'] = ...
        INVALID_SIGNATURE: _py_ClassVar['CertPathValidatorException.BasicReason'] = ...
        ALGORITHM_CONSTRAINED: _py_ClassVar['CertPathValidatorException.BasicReason'] = ...
        _valueOf_0__T = _py_TypeVar('_valueOf_0__T', bound=java.lang.Enum)  # <T>
        @classmethod
        @overload
        def valueOf(cls, class_: _py_Type[_valueOf_0__T], string: str) -> _valueOf_0__T: ...
        @classmethod
        @overload
        def valueOf(cls, string: str) -> 'CertPathValidatorException.BasicReason': ...
        @classmethod
        def values(cls) -> _py_List['CertPathValidatorException.BasicReason']: ...
    class Reason(java.io.Serializable): ...

class PKIXReason(java.lang.Enum['PKIXReason'], CertPathValidatorException.Reason):
    NAME_CHAINING: _py_ClassVar['PKIXReason'] = ...
    INVALID_KEY_USAGE: _py_ClassVar['PKIXReason'] = ...
    INVALID_POLICY: _py_ClassVar['PKIXReason'] = ...
    NO_TRUST_ANCHOR: _py_ClassVar['PKIXReason'] = ...
    UNRECOGNIZED_CRIT_EXT: _py_ClassVar['PKIXReason'] = ...
    NOT_CA_CERT: _py_ClassVar['PKIXReason'] = ...
    PATH_TOO_LONG: _py_ClassVar['PKIXReason'] = ...
    INVALID_NAME: _py_ClassVar['PKIXReason'] = ...
    _valueOf_0__T = _py_TypeVar('_valueOf_0__T', bound=java.lang.Enum)  # <T>
    @classmethod
    @overload
    def valueOf(cls, class_: _py_Type[_valueOf_0__T], string: str) -> _valueOf_0__T: ...
    @classmethod
    @overload
    def valueOf(cls, string: str) -> 'PKIXReason': ...
    @classmethod
    def values(cls) -> _py_List['PKIXReason']: ...
