from typing import Any as _py_Any
from typing import List as _py_List
from typing import TypeVar as _py_TypeVar
from typing import ClassVar as _py_ClassVar
from typing import Generic as _py_Generic
from typing import overload
import java.io
import java.lang
import java.net
import java.nio
import java.nio.channels.spi
import java.nio.charset
import java.nio.file
import java.nio.file.attribute
import java.util
import java.util.concurrent


class AcceptPendingException(java.lang.IllegalStateException):
    def __init__(self): ...

class AlreadyBoundException(java.lang.IllegalStateException):
    def __init__(self): ...

class AlreadyConnectedException(java.lang.IllegalStateException):
    def __init__(self): ...

class AsynchronousChannelGroup:
    def awaitTermination(self, long: int, timeUnit: java.util.concurrent.TimeUnit) -> bool: ...
    def isShutdown(self) -> bool: ...
    def isTerminated(self) -> bool: ...
    def provider(self) -> java.nio.channels.spi.AsynchronousChannelProvider: ...
    def shutdown(self) -> None: ...
    def shutdownNow(self) -> None: ...
    @classmethod
    def withCachedThreadPool(cls, executorService: java.util.concurrent.ExecutorService, int: int) -> 'AsynchronousChannelGroup': ...
    @classmethod
    def withFixedThreadPool(cls, int: int, threadFactory: java.util.concurrent.ThreadFactory) -> 'AsynchronousChannelGroup': ...
    @classmethod
    def withThreadPool(cls, executorService: java.util.concurrent.ExecutorService) -> 'AsynchronousChannelGroup': ...

class CancelledKeyException(java.lang.IllegalStateException):
    def __init__(self): ...

class Channel(java.io.Closeable):
    def close(self) -> None: ...
    def isOpen(self) -> bool: ...

class Channels:
    @classmethod
    @overload
    def newChannel(cls, inputStream: java.io.InputStream) -> 'ReadableByteChannel': ...
    @classmethod
    @overload
    def newChannel(cls, outputStream: java.io.OutputStream) -> 'WritableByteChannel': ...
    @classmethod
    @overload
    def newInputStream(cls, asynchronousByteChannel: 'AsynchronousByteChannel') -> java.io.InputStream: ...
    @classmethod
    @overload
    def newInputStream(cls, readableByteChannel: 'ReadableByteChannel') -> java.io.InputStream: ...
    @classmethod
    @overload
    def newOutputStream(cls, asynchronousByteChannel: 'AsynchronousByteChannel') -> java.io.OutputStream: ...
    @classmethod
    @overload
    def newOutputStream(cls, writableByteChannel: 'WritableByteChannel') -> java.io.OutputStream: ...
    @classmethod
    @overload
    def newReader(cls, readableByteChannel: 'ReadableByteChannel', string: str) -> java.io.Reader: ...
    @classmethod
    @overload
    def newReader(cls, readableByteChannel: 'ReadableByteChannel', charsetDecoder: java.nio.charset.CharsetDecoder, int: int) -> java.io.Reader: ...
    @classmethod
    @overload
    def newWriter(cls, writableByteChannel: 'WritableByteChannel', string: str) -> java.io.Writer: ...
    @classmethod
    @overload
    def newWriter(cls, writableByteChannel: 'WritableByteChannel', charsetEncoder: java.nio.charset.CharsetEncoder, int: int) -> java.io.Writer: ...

class ClosedChannelException(java.io.IOException):
    def __init__(self): ...

class ClosedSelectorException(java.lang.IllegalStateException):
    def __init__(self): ...

_CompletionHandler__V = _py_TypeVar('_CompletionHandler__V')  # <V>
_CompletionHandler__A = _py_TypeVar('_CompletionHandler__A')  # <A>
class CompletionHandler(_py_Generic[_CompletionHandler__V, _CompletionHandler__A]):
    def completed(self, v: _CompletionHandler__V, a: _CompletionHandler__A) -> None: ...
    def failed(self, throwable: java.lang.Throwable, a: _CompletionHandler__A) -> None: ...

class ConnectionPendingException(java.lang.IllegalStateException):
    def __init__(self): ...

class FileLock(java.lang.AutoCloseable):
    def acquiredBy(self) -> Channel: ...
    def channel(self) -> 'FileChannel': ...
    def close(self) -> None: ...
    def isShared(self) -> bool: ...
    def isValid(self) -> bool: ...
    def overlaps(self, long: int, long2: int) -> bool: ...
    def position(self) -> int: ...
    def release(self) -> None: ...
    def size(self) -> int: ...
    def toString(self) -> str: ...

class FileLockInterruptionException(java.io.IOException):
    def __init__(self): ...

class IllegalBlockingModeException(java.lang.IllegalStateException):
    def __init__(self): ...

class IllegalChannelGroupException(java.lang.IllegalArgumentException):
    def __init__(self): ...

class IllegalSelectorException(java.lang.IllegalArgumentException):
    def __init__(self): ...

class InterruptedByTimeoutException(java.io.IOException):
    def __init__(self): ...

class MembershipKey:
    def block(self, inetAddress: java.net.InetAddress) -> 'MembershipKey': ...
    def channel(self) -> 'MulticastChannel': ...
    def drop(self) -> None: ...
    def group(self) -> java.net.InetAddress: ...
    def isValid(self) -> bool: ...
    def networkInterface(self) -> java.net.NetworkInterface: ...
    def sourceAddress(self) -> java.net.InetAddress: ...
    def unblock(self, inetAddress: java.net.InetAddress) -> 'MembershipKey': ...

class NoConnectionPendingException(java.lang.IllegalStateException):
    def __init__(self): ...

class NonReadableChannelException(java.lang.IllegalStateException):
    def __init__(self): ...

class NonWritableChannelException(java.lang.IllegalStateException):
    def __init__(self): ...

class NotYetBoundException(java.lang.IllegalStateException):
    def __init__(self): ...

class NotYetConnectedException(java.lang.IllegalStateException):
    def __init__(self): ...

class OverlappingFileLockException(java.lang.IllegalStateException):
    def __init__(self): ...

class ReadPendingException(java.lang.IllegalStateException):
    def __init__(self): ...

class SelectionKey:
    OP_READ: _py_ClassVar[int] = ...
    OP_WRITE: _py_ClassVar[int] = ...
    OP_CONNECT: _py_ClassVar[int] = ...
    OP_ACCEPT: _py_ClassVar[int] = ...
    def attach(self, object: _py_Any) -> _py_Any: ...
    def attachment(self) -> _py_Any: ...
    def cancel(self) -> None: ...
    def channel(self) -> 'SelectableChannel': ...
    @overload
    def interestOps(self) -> int: ...
    @overload
    def interestOps(self, int: int) -> 'SelectionKey': ...
    def isAcceptable(self) -> bool: ...
    def isConnectable(self) -> bool: ...
    def isReadable(self) -> bool: ...
    def isValid(self) -> bool: ...
    def isWritable(self) -> bool: ...
    def readyOps(self) -> int: ...
    def selector(self) -> 'Selector': ...

class Selector(java.io.Closeable):
    def close(self) -> None: ...
    def isOpen(self) -> bool: ...
    def keys(self) -> java.util.Set[SelectionKey]: ...
    @classmethod
    def open(cls) -> 'Selector': ...
    def provider(self) -> java.nio.channels.spi.SelectorProvider: ...
    @overload
    def select(self) -> int: ...
    @overload
    def select(self, long: int) -> int: ...
    def selectNow(self) -> int: ...
    def selectedKeys(self) -> java.util.Set[SelectionKey]: ...
    def wakeup(self) -> 'Selector': ...

class ShutdownChannelGroupException(java.lang.IllegalStateException):
    def __init__(self): ...

class UnresolvedAddressException(java.lang.IllegalArgumentException):
    def __init__(self): ...

class UnsupportedAddressTypeException(java.lang.IllegalArgumentException):
    def __init__(self): ...

class WritePendingException(java.lang.IllegalStateException):
    def __init__(self): ...

class AsynchronousChannel(Channel):
    def close(self) -> None: ...

class AsynchronousCloseException(ClosedChannelException):
    def __init__(self): ...

class InterruptibleChannel(Channel):
    def close(self) -> None: ...

class NetworkChannel(Channel):
    def bind(self, socketAddress: java.net.SocketAddress) -> 'NetworkChannel': ...
    def getLocalAddress(self) -> java.net.SocketAddress: ...
    _getOption__T = _py_TypeVar('_getOption__T')  # <T>
    def getOption(self, socketOption: java.net.SocketOption[_getOption__T]) -> _getOption__T: ...
    _setOption__T = _py_TypeVar('_setOption__T')  # <T>
    def setOption(self, socketOption: java.net.SocketOption[_setOption__T], t: _setOption__T) -> 'NetworkChannel': ...
    def supportedOptions(self) -> java.util.Set[java.net.SocketOption[_py_Any]]: ...

class ReadableByteChannel(Channel):
    def read(self, byteBuffer: java.nio.ByteBuffer) -> int: ...

class SelectableChannel(java.nio.channels.spi.AbstractInterruptibleChannel, Channel):
    def blockingLock(self) -> _py_Any: ...
    def configureBlocking(self, boolean: bool) -> 'SelectableChannel': ...
    def isBlocking(self) -> bool: ...
    def isRegistered(self) -> bool: ...
    def keyFor(self, selector: Selector) -> SelectionKey: ...
    def provider(self) -> java.nio.channels.spi.SelectorProvider: ...
    @overload
    def register(self, selector: Selector, int: int, object: _py_Any) -> SelectionKey: ...
    @overload
    def register(self, selector: Selector, int: int) -> SelectionKey: ...
    def validOps(self) -> int: ...

class WritableByteChannel(Channel):
    def write(self, byteBuffer: java.nio.ByteBuffer) -> int: ...

class AsynchronousByteChannel(AsynchronousChannel):
    @overload
    def read(self, byteBuffer: java.nio.ByteBuffer) -> java.util.concurrent.Future[int]: ...
    _read_1__A = _py_TypeVar('_read_1__A')  # <A>
    @overload
    def read(self, byteBuffer: java.nio.ByteBuffer, a: _read_1__A, completionHandler: CompletionHandler[int, _read_1__A]) -> None: ...
    @overload
    def write(self, byteBuffer: java.nio.ByteBuffer) -> java.util.concurrent.Future[int]: ...
    _write_1__A = _py_TypeVar('_write_1__A')  # <A>
    @overload
    def write(self, byteBuffer: java.nio.ByteBuffer, a: _write_1__A, completionHandler: CompletionHandler[int, _write_1__A]) -> None: ...

class AsynchronousFileChannel(AsynchronousChannel):
    def force(self, boolean: bool) -> None: ...
    @overload
    def lock(self, long: int, long2: int, boolean: bool) -> java.util.concurrent.Future[FileLock]: ...
    _lock_1__A = _py_TypeVar('_lock_1__A')  # <A>
    @overload
    def lock(self, long: int, long2: int, boolean: bool, a: _lock_1__A, completionHandler: CompletionHandler[FileLock, _lock_1__A]) -> None: ...
    @overload
    def lock(self) -> java.util.concurrent.Future[FileLock]: ...
    _lock_3__A = _py_TypeVar('_lock_3__A')  # <A>
    @overload
    def lock(self, a: _lock_3__A, completionHandler: CompletionHandler[FileLock, _lock_3__A]) -> None: ...
    @classmethod
    @overload
    def open(cls, path: java.nio.file.Path, openOptionArray: _py_List[java.nio.file.OpenOption]) -> 'AsynchronousFileChannel': ...
    @classmethod
    @overload
    def open(cls, path: java.nio.file.Path, set: java.util.Set[java.nio.file.OpenOption], executorService: java.util.concurrent.ExecutorService, fileAttributeArray: _py_List[java.nio.file.attribute.FileAttribute[_py_Any]]) -> 'AsynchronousFileChannel': ...
    @overload
    def read(self, byteBuffer: java.nio.ByteBuffer, long: int) -> java.util.concurrent.Future[int]: ...
    _read_1__A = _py_TypeVar('_read_1__A')  # <A>
    @overload
    def read(self, byteBuffer: java.nio.ByteBuffer, long: int, a: _read_1__A, completionHandler: CompletionHandler[int, _read_1__A]) -> None: ...
    def size(self) -> int: ...
    def truncate(self, long: int) -> 'AsynchronousFileChannel': ...
    @overload
    def tryLock(self, long: int, long2: int, boolean: bool) -> FileLock: ...
    @overload
    def tryLock(self) -> FileLock: ...
    @overload
    def write(self, byteBuffer: java.nio.ByteBuffer, long: int) -> java.util.concurrent.Future[int]: ...
    _write_1__A = _py_TypeVar('_write_1__A')  # <A>
    @overload
    def write(self, byteBuffer: java.nio.ByteBuffer, long: int, a: _write_1__A, completionHandler: CompletionHandler[int, _write_1__A]) -> None: ...

class AsynchronousServerSocketChannel(AsynchronousChannel, NetworkChannel):
    @overload
    def accept(self) -> java.util.concurrent.Future['AsynchronousSocketChannel']: ...
    _accept_1__A = _py_TypeVar('_accept_1__A')  # <A>
    @overload
    def accept(self, a: _accept_1__A, completionHandler: CompletionHandler['AsynchronousSocketChannel', _accept_1__A]) -> None: ...
    @overload
    def bind(self, socketAddress: java.net.SocketAddress, int: int) -> 'AsynchronousServerSocketChannel': ...
    @overload
    def bind(self, socketAddress: java.net.SocketAddress) -> 'AsynchronousServerSocketChannel': ...
    @overload
    def bind(self, socketAddress: java.net.SocketAddress) -> NetworkChannel: ...
    def getLocalAddress(self) -> java.net.SocketAddress: ...
    @classmethod
    @overload
    def open(cls) -> 'AsynchronousServerSocketChannel': ...
    @classmethod
    @overload
    def open(cls, asynchronousChannelGroup: AsynchronousChannelGroup) -> 'AsynchronousServerSocketChannel': ...
    def provider(self) -> java.nio.channels.spi.AsynchronousChannelProvider: ...
    _setOption_0__T = _py_TypeVar('_setOption_0__T')  # <T>
    @overload
    def setOption(self, socketOption: java.net.SocketOption[_setOption_0__T], t: _setOption_0__T) -> 'AsynchronousServerSocketChannel': ...
    @overload
    def setOption(self, socketOption: java.net.SocketOption, object: _py_Any) -> NetworkChannel: ...

class ByteChannel(ReadableByteChannel, WritableByteChannel): ...

class ClosedByInterruptException(AsynchronousCloseException):
    def __init__(self): ...

class GatheringByteChannel(WritableByteChannel):
    @overload
    def write(self, byteBuffer: java.nio.ByteBuffer) -> int: ...
    @overload
    def write(self, byteBufferArray: _py_List[java.nio.ByteBuffer]) -> int: ...
    @overload
    def write(self, byteBufferArray: _py_List[java.nio.ByteBuffer], int: int, int2: int) -> int: ...

class MulticastChannel(NetworkChannel):
    def close(self) -> None: ...
    @overload
    def join(self, inetAddress: java.net.InetAddress, networkInterface: java.net.NetworkInterface) -> MembershipKey: ...
    @overload
    def join(self, inetAddress: java.net.InetAddress, networkInterface: java.net.NetworkInterface, inetAddress2: java.net.InetAddress) -> MembershipKey: ...

class ScatteringByteChannel(ReadableByteChannel):
    @overload
    def read(self, byteBuffer: java.nio.ByteBuffer) -> int: ...
    @overload
    def read(self, byteBufferArray: _py_List[java.nio.ByteBuffer]) -> int: ...
    @overload
    def read(self, byteBufferArray: _py_List[java.nio.ByteBuffer], int: int, int2: int) -> int: ...

class ServerSocketChannel(java.nio.channels.spi.AbstractSelectableChannel, NetworkChannel):
    def accept(self) -> 'SocketChannel': ...
    @overload
    def bind(self, socketAddress: java.net.SocketAddress, int: int) -> 'ServerSocketChannel': ...
    @overload
    def bind(self, socketAddress: java.net.SocketAddress) -> 'ServerSocketChannel': ...
    @overload
    def bind(self, socketAddress: java.net.SocketAddress) -> NetworkChannel: ...
    def getLocalAddress(self) -> java.net.SocketAddress: ...
    @classmethod
    def open(cls) -> 'ServerSocketChannel': ...
    _setOption_0__T = _py_TypeVar('_setOption_0__T')  # <T>
    @overload
    def setOption(self, socketOption: java.net.SocketOption[_setOption_0__T], t: _setOption_0__T) -> 'ServerSocketChannel': ...
    @overload
    def setOption(self, socketOption: java.net.SocketOption, object: _py_Any) -> NetworkChannel: ...
    def socket(self) -> java.net.ServerSocket: ...
    def validOps(self) -> int: ...

class AsynchronousSocketChannel(AsynchronousByteChannel, NetworkChannel):
    @overload
    def bind(self, socketAddress: java.net.SocketAddress) -> 'AsynchronousSocketChannel': ...
    @overload
    def bind(self, socketAddress: java.net.SocketAddress) -> NetworkChannel: ...
    @overload
    def connect(self, socketAddress: java.net.SocketAddress) -> java.util.concurrent.Future[java.lang.Void]: ...
    _connect_1__A = _py_TypeVar('_connect_1__A')  # <A>
    @overload
    def connect(self, socketAddress: java.net.SocketAddress, a: _connect_1__A, completionHandler: CompletionHandler[java.lang.Void, _connect_1__A]) -> None: ...
    def getLocalAddress(self) -> java.net.SocketAddress: ...
    def getRemoteAddress(self) -> java.net.SocketAddress: ...
    @classmethod
    @overload
    def open(cls) -> 'AsynchronousSocketChannel': ...
    @classmethod
    @overload
    def open(cls, asynchronousChannelGroup: AsynchronousChannelGroup) -> 'AsynchronousSocketChannel': ...
    def provider(self) -> java.nio.channels.spi.AsynchronousChannelProvider: ...
    @overload
    def read(self, byteBuffer: java.nio.ByteBuffer) -> java.util.concurrent.Future[int]: ...
    _read_1__A = _py_TypeVar('_read_1__A')  # <A>
    @overload
    def read(self, byteBuffer: java.nio.ByteBuffer, long: int, timeUnit: java.util.concurrent.TimeUnit, a: _read_1__A, completionHandler: CompletionHandler[int, _read_1__A]) -> None: ...
    _read_2__A = _py_TypeVar('_read_2__A')  # <A>
    @overload
    def read(self, byteBufferArray: _py_List[java.nio.ByteBuffer], int: int, int2: int, long: int, timeUnit: java.util.concurrent.TimeUnit, a: _read_2__A, completionHandler: CompletionHandler[int, _read_2__A]) -> None: ...
    _read_3__A = _py_TypeVar('_read_3__A')  # <A>
    @overload
    def read(self, byteBuffer: java.nio.ByteBuffer, a: _read_3__A, completionHandler: CompletionHandler[int, _read_3__A]) -> None: ...
    _setOption_0__T = _py_TypeVar('_setOption_0__T')  # <T>
    @overload
    def setOption(self, socketOption: java.net.SocketOption[_setOption_0__T], t: _setOption_0__T) -> 'AsynchronousSocketChannel': ...
    @overload
    def setOption(self, socketOption: java.net.SocketOption, object: _py_Any) -> NetworkChannel: ...
    def shutdownInput(self) -> 'AsynchronousSocketChannel': ...
    def shutdownOutput(self) -> 'AsynchronousSocketChannel': ...
    @overload
    def write(self, byteBuffer: java.nio.ByteBuffer) -> java.util.concurrent.Future[int]: ...
    _write_1__A = _py_TypeVar('_write_1__A')  # <A>
    @overload
    def write(self, byteBuffer: java.nio.ByteBuffer, long: int, timeUnit: java.util.concurrent.TimeUnit, a: _write_1__A, completionHandler: CompletionHandler[int, _write_1__A]) -> None: ...
    _write_2__A = _py_TypeVar('_write_2__A')  # <A>
    @overload
    def write(self, byteBufferArray: _py_List[java.nio.ByteBuffer], int: int, int2: int, long: int, timeUnit: java.util.concurrent.TimeUnit, a: _write_2__A, completionHandler: CompletionHandler[int, _write_2__A]) -> None: ...
    _write_3__A = _py_TypeVar('_write_3__A')  # <A>
    @overload
    def write(self, byteBuffer: java.nio.ByteBuffer, a: _write_3__A, completionHandler: CompletionHandler[int, _write_3__A]) -> None: ...

class DatagramChannel(java.nio.channels.spi.AbstractSelectableChannel, ByteChannel, ScatteringByteChannel, GatheringByteChannel, MulticastChannel):
    @overload
    def bind(self, socketAddress: java.net.SocketAddress) -> 'DatagramChannel': ...
    @overload
    def bind(self, socketAddress: java.net.SocketAddress) -> NetworkChannel: ...
    def connect(self, socketAddress: java.net.SocketAddress) -> 'DatagramChannel': ...
    def disconnect(self) -> 'DatagramChannel': ...
    def getLocalAddress(self) -> java.net.SocketAddress: ...
    def getRemoteAddress(self) -> java.net.SocketAddress: ...
    def isConnected(self) -> bool: ...
    @classmethod
    @overload
    def open(cls) -> 'DatagramChannel': ...
    @classmethod
    @overload
    def open(cls, protocolFamily: java.net.ProtocolFamily) -> 'DatagramChannel': ...
    @overload
    def read(self, byteBuffer: java.nio.ByteBuffer) -> int: ...
    @overload
    def read(self, byteBufferArray: _py_List[java.nio.ByteBuffer], int: int, int2: int) -> int: ...
    @overload
    def read(self, byteBufferArray: _py_List[java.nio.ByteBuffer]) -> int: ...
    def receive(self, byteBuffer: java.nio.ByteBuffer) -> java.net.SocketAddress: ...
    def send(self, byteBuffer: java.nio.ByteBuffer, socketAddress: java.net.SocketAddress) -> int: ...
    _setOption_0__T = _py_TypeVar('_setOption_0__T')  # <T>
    @overload
    def setOption(self, socketOption: java.net.SocketOption[_setOption_0__T], t: _setOption_0__T) -> 'DatagramChannel': ...
    @overload
    def setOption(self, socketOption: java.net.SocketOption, object: _py_Any) -> NetworkChannel: ...
    def socket(self) -> java.net.DatagramSocket: ...
    def validOps(self) -> int: ...
    @overload
    def write(self, byteBuffer: java.nio.ByteBuffer) -> int: ...
    @overload
    def write(self, byteBufferArray: _py_List[java.nio.ByteBuffer], int: int, int2: int) -> int: ...
    @overload
    def write(self, byteBufferArray: _py_List[java.nio.ByteBuffer]) -> int: ...

class Pipe:
    @classmethod
    def open(cls) -> 'Pipe': ...
    def sink(self) -> 'Pipe.SinkChannel': ...
    def source(self) -> 'Pipe.SourceChannel': ...
    class SinkChannel(java.nio.channels.spi.AbstractSelectableChannel, WritableByteChannel, GatheringByteChannel):
        def validOps(self) -> int: ...
    class SourceChannel(java.nio.channels.spi.AbstractSelectableChannel, ReadableByteChannel, ScatteringByteChannel):
        def validOps(self) -> int: ...

class SeekableByteChannel(ByteChannel):
    @overload
    def position(self, long: int) -> 'SeekableByteChannel': ...
    @overload
    def position(self) -> int: ...
    def read(self, byteBuffer: java.nio.ByteBuffer) -> int: ...
    def size(self) -> int: ...
    def truncate(self, long: int) -> 'SeekableByteChannel': ...
    def write(self, byteBuffer: java.nio.ByteBuffer) -> int: ...

class SocketChannel(java.nio.channels.spi.AbstractSelectableChannel, ByteChannel, ScatteringByteChannel, GatheringByteChannel, NetworkChannel):
    @overload
    def bind(self, socketAddress: java.net.SocketAddress) -> 'SocketChannel': ...
    @overload
    def bind(self, socketAddress: java.net.SocketAddress) -> NetworkChannel: ...
    def connect(self, socketAddress: java.net.SocketAddress) -> bool: ...
    def finishConnect(self) -> bool: ...
    def getLocalAddress(self) -> java.net.SocketAddress: ...
    def getRemoteAddress(self) -> java.net.SocketAddress: ...
    def isConnected(self) -> bool: ...
    def isConnectionPending(self) -> bool: ...
    @classmethod
    @overload
    def open(cls) -> 'SocketChannel': ...
    @classmethod
    @overload
    def open(cls, socketAddress: java.net.SocketAddress) -> 'SocketChannel': ...
    @overload
    def read(self, byteBuffer: java.nio.ByteBuffer) -> int: ...
    @overload
    def read(self, byteBufferArray: _py_List[java.nio.ByteBuffer], int: int, int2: int) -> int: ...
    @overload
    def read(self, byteBufferArray: _py_List[java.nio.ByteBuffer]) -> int: ...
    _setOption_0__T = _py_TypeVar('_setOption_0__T')  # <T>
    @overload
    def setOption(self, socketOption: java.net.SocketOption[_setOption_0__T], t: _setOption_0__T) -> 'SocketChannel': ...
    @overload
    def setOption(self, socketOption: java.net.SocketOption, object: _py_Any) -> NetworkChannel: ...
    def shutdownInput(self) -> 'SocketChannel': ...
    def shutdownOutput(self) -> 'SocketChannel': ...
    def socket(self) -> java.net.Socket: ...
    def validOps(self) -> int: ...
    @overload
    def write(self, byteBuffer: java.nio.ByteBuffer) -> int: ...
    @overload
    def write(self, byteBufferArray: _py_List[java.nio.ByteBuffer], int: int, int2: int) -> int: ...
    @overload
    def write(self, byteBufferArray: _py_List[java.nio.ByteBuffer]) -> int: ...

class FileChannel(java.nio.channels.spi.AbstractInterruptibleChannel, SeekableByteChannel, GatheringByteChannel, ScatteringByteChannel):
    def force(self, boolean: bool) -> None: ...
    @overload
    def lock(self, long: int, long2: int, boolean: bool) -> FileLock: ...
    @overload
    def lock(self) -> FileLock: ...
    def map(self, mapMode: 'FileChannel.MapMode', long: int, long2: int) -> java.nio.MappedByteBuffer: ...
    @classmethod
    @overload
    def open(cls, path: java.nio.file.Path, openOptionArray: _py_List[java.nio.file.OpenOption]) -> 'FileChannel': ...
    @classmethod
    @overload
    def open(cls, path: java.nio.file.Path, set: java.util.Set[java.nio.file.OpenOption], fileAttributeArray: _py_List[java.nio.file.attribute.FileAttribute[_py_Any]]) -> 'FileChannel': ...
    @overload
    def position(self, long: int) -> 'FileChannel': ...
    @overload
    def position(self) -> int: ...
    @overload
    def position(self, long: int) -> SeekableByteChannel: ...
    @overload
    def read(self, byteBuffer: java.nio.ByteBuffer) -> int: ...
    @overload
    def read(self, byteBuffer: java.nio.ByteBuffer, long: int) -> int: ...
    @overload
    def read(self, byteBufferArray: _py_List[java.nio.ByteBuffer], int: int, int2: int) -> int: ...
    @overload
    def read(self, byteBufferArray: _py_List[java.nio.ByteBuffer]) -> int: ...
    def size(self) -> int: ...
    def transferFrom(self, readableByteChannel: ReadableByteChannel, long: int, long2: int) -> int: ...
    def transferTo(self, long: int, long2: int, writableByteChannel: WritableByteChannel) -> int: ...
    @overload
    def truncate(self, long: int) -> 'FileChannel': ...
    @overload
    def truncate(self, long: int) -> SeekableByteChannel: ...
    @overload
    def tryLock(self, long: int, long2: int, boolean: bool) -> FileLock: ...
    @overload
    def tryLock(self) -> FileLock: ...
    @overload
    def write(self, byteBuffer: java.nio.ByteBuffer) -> int: ...
    @overload
    def write(self, byteBuffer: java.nio.ByteBuffer, long: int) -> int: ...
    @overload
    def write(self, byteBufferArray: _py_List[java.nio.ByteBuffer], int: int, int2: int) -> int: ...
    @overload
    def write(self, byteBufferArray: _py_List[java.nio.ByteBuffer]) -> int: ...
    class MapMode:
        READ_ONLY: _py_ClassVar['FileChannel.MapMode'] = ...
        READ_WRITE: _py_ClassVar['FileChannel.MapMode'] = ...
        PRIVATE: _py_ClassVar['FileChannel.MapMode'] = ...
        def toString(self) -> str: ...
