from typing import Any as _py_Any
from typing import List as _py_List
from typing import TypeVar as _py_TypeVar
from typing import Type as _py_Type
from typing import ClassVar as _py_ClassVar
from typing import Generic as _py_Generic
from typing import overload
import com
import com.google.common.base
import java.io
import java.lang
import java.lang.annotation
import java.math
import java.time
import java.util
import java.util.concurrent
import java.util.concurrent.atomic
import java.util.function
import java.util.stream


_AbstractMapEntry__K = _py_TypeVar('_AbstractMapEntry__K')  # <K>
_AbstractMapEntry__V = _py_TypeVar('_AbstractMapEntry__V')  # <V>
class AbstractMapEntry(java.util.Map.Entry[_AbstractMapEntry__K, _AbstractMapEntry__V], _py_Generic[_AbstractMapEntry__K, _AbstractMapEntry__V]):
    def equals(self, object: _py_Any) -> bool: ...
    def getKey(self) -> _AbstractMapEntry__K: ...
    def getValue(self) -> _AbstractMapEntry__V: ...
    def hashCode(self) -> int: ...
    def setValue(self, v: _AbstractMapEntry__V) -> _AbstractMapEntry__V: ...
    def toString(self) -> str: ...

_BiMap__K = _py_TypeVar('_BiMap__K')  # <K>
_BiMap__V = _py_TypeVar('_BiMap__V')  # <V>
class BiMap(java.util.Map[_BiMap__K, _BiMap__V], _py_Generic[_BiMap__K, _BiMap__V]):
    def equals(self, object: _py_Any) -> bool: ...
    def forcePut(self, k: _BiMap__K, v: _BiMap__V) -> _BiMap__V: ...
    def hashCode(self) -> int: ...
    def inverse(self) -> 'BiMap'[_BiMap__V, _BiMap__K]: ...
    def put(self, k: _BiMap__K, v: _BiMap__V) -> _BiMap__V: ...
    def putAll(self, map: java.util.Map[_BiMap__K, _BiMap__V]) -> None: ...
    @overload
    def values(self) -> java.util.Set[_BiMap__V]: ...
    @overload
    def values(self) -> java.util.Collection: ...

class BoundType(java.lang.Enum['BoundType']):
    OPEN: _py_ClassVar['BoundType'] = ...
    CLOSED: _py_ClassVar['BoundType'] = ...
    @classmethod
    @overload
    def valueOf(cls, string: str) -> 'BoundType': ...
    _valueOf_1__T = _py_TypeVar('_valueOf_1__T', bound=java.lang.Enum)  # <T>
    @classmethod
    @overload
    def valueOf(cls, class_: _py_Type[_valueOf_1__T], string: str) -> _valueOf_1__T: ...
    @classmethod
    def values(cls) -> _py_List['BoundType']: ...

_CartesianList__E = _py_TypeVar('_CartesianList__E')  # <E>
class CartesianList(java.util.AbstractList[java.util.List[_CartesianList__E]], java.util.RandomAccess, _py_Generic[_CartesianList__E]):
    def contains(self, object: _py_Any) -> bool: ...
    @overload
    def get(self, int: int) -> 'ImmutableList'[_CartesianList__E]: ...
    @overload
    def get(self, int: int) -> _py_Any: ...
    def indexOf(self, object: _py_Any) -> int: ...
    def size(self) -> int: ...

_ClassToInstanceMap__B = _py_TypeVar('_ClassToInstanceMap__B')  # <B>
class ClassToInstanceMap(java.util.Map[_py_Type[_ClassToInstanceMap__B], _ClassToInstanceMap__B], _py_Generic[_ClassToInstanceMap__B]):
    def equals(self, object: _py_Any) -> bool: ...
    _getInstance__T = _py_TypeVar('_getInstance__T')  # <T>
    def getInstance(self, class_: _py_Type[_getInstance__T]) -> _getInstance__T: ...
    def hashCode(self) -> int: ...
    _putInstance__T = _py_TypeVar('_putInstance__T')  # <T>
    def putInstance(self, class_: _py_Type[_putInstance__T], t: _putInstance__T) -> _putInstance__T: ...

class CollectCollectors: ...

class CollectPreconditions: ...

class CollectSpliterators: ...

class Collections2:
    _filter__E = _py_TypeVar('_filter__E')  # <E>
    @classmethod
    def filter(cls, collection: java.util.Collection[_filter__E], predicate: com.google.common.base.Predicate[_filter__E]) -> java.util.Collection[_filter__E]: ...
    _orderedPermutations_0__E = _py_TypeVar('_orderedPermutations_0__E', bound=java.lang.Comparable)  # <E>
    @classmethod
    @overload
    def orderedPermutations(cls, iterable: java.lang.Iterable[_orderedPermutations_0__E]) -> java.util.Collection[java.util.List[_orderedPermutations_0__E]]: ...
    _orderedPermutations_1__E = _py_TypeVar('_orderedPermutations_1__E')  # <E>
    @classmethod
    @overload
    def orderedPermutations(cls, iterable: java.lang.Iterable[_orderedPermutations_1__E], comparator: java.util.Comparator[_orderedPermutations_1__E]) -> java.util.Collection[java.util.List[_orderedPermutations_1__E]]: ...
    _permutations__E = _py_TypeVar('_permutations__E')  # <E>
    @classmethod
    def permutations(cls, collection: java.util.Collection[_permutations__E]) -> java.util.Collection[java.util.List[_permutations__E]]: ...
    _transform__F = _py_TypeVar('_transform__F')  # <F>
    _transform__T = _py_TypeVar('_transform__T')  # <T>
    @classmethod
    def transform(cls, collection: java.util.Collection[_transform__F], function: com.google.common.base.Function[_transform__F, _transform__T]) -> java.util.Collection[_transform__T]: ...

_CompactHashMap__K = _py_TypeVar('_CompactHashMap__K')  # <K>
_CompactHashMap__V = _py_TypeVar('_CompactHashMap__V')  # <V>
class CompactHashMap(java.util.AbstractMap[_CompactHashMap__K, _CompactHashMap__V], java.io.Serializable, _py_Generic[_CompactHashMap__K, _CompactHashMap__V]):
    def clear(self) -> None: ...
    def containsKey(self, object: _py_Any) -> bool: ...
    def containsValue(self, object: _py_Any) -> bool: ...
    _create__K = _py_TypeVar('_create__K')  # <K>
    _create__V = _py_TypeVar('_create__V')  # <V>
    @classmethod
    def create(cls) -> 'CompactHashMap'[_create__K, _create__V]: ...
    _createWithExpectedSize__K = _py_TypeVar('_createWithExpectedSize__K')  # <K>
    _createWithExpectedSize__V = _py_TypeVar('_createWithExpectedSize__V')  # <V>
    @classmethod
    def createWithExpectedSize(cls, int: int) -> 'CompactHashMap'[_createWithExpectedSize__K, _createWithExpectedSize__V]: ...
    def entrySet(self) -> java.util.Set[java.util.Map.Entry[_CompactHashMap__K, _CompactHashMap__V]]: ...
    def forEach(self, biConsumer: java.util.function.BiConsumer[_CompactHashMap__K, _CompactHashMap__V]) -> None: ...
    def get(self, object: _py_Any) -> _CompactHashMap__V: ...
    def isEmpty(self) -> bool: ...
    def keySet(self) -> java.util.Set[_CompactHashMap__K]: ...
    def put(self, k: _CompactHashMap__K, v: _CompactHashMap__V) -> _CompactHashMap__V: ...
    @overload
    def remove(self, object: _py_Any, object2: _py_Any) -> bool: ...
    @overload
    def remove(self, object: _py_Any) -> _CompactHashMap__V: ...
    def replaceAll(self, biFunction: java.util.function.BiFunction[_CompactHashMap__K, _CompactHashMap__V, _CompactHashMap__V]) -> None: ...
    def size(self) -> int: ...
    def trimToSize(self) -> None: ...
    def values(self) -> java.util.Collection[_CompactHashMap__V]: ...

_CompactHashSet__E = _py_TypeVar('_CompactHashSet__E')  # <E>
class CompactHashSet(java.util.AbstractSet[_CompactHashSet__E], java.io.Serializable, _py_Generic[_CompactHashSet__E]):
    def add(self, e: _CompactHashSet__E) -> bool: ...
    def clear(self) -> None: ...
    def contains(self, object: _py_Any) -> bool: ...
    _create_0__E = _py_TypeVar('_create_0__E')  # <E>
    @classmethod
    @overload
    def create(cls) -> 'CompactHashSet'[_create_0__E]: ...
    _create_1__E = _py_TypeVar('_create_1__E')  # <E>
    @classmethod
    @overload
    def create(cls, eArray: _py_List[_create_1__E]) -> 'CompactHashSet'[_create_1__E]: ...
    _create_2__E = _py_TypeVar('_create_2__E')  # <E>
    @classmethod
    @overload
    def create(cls, collection: java.util.Collection[_create_2__E]) -> 'CompactHashSet'[_create_2__E]: ...
    _createWithExpectedSize__E = _py_TypeVar('_createWithExpectedSize__E')  # <E>
    @classmethod
    def createWithExpectedSize(cls, int: int) -> 'CompactHashSet'[_createWithExpectedSize__E]: ...
    def forEach(self, consumer: java.util.function.Consumer[_CompactHashSet__E]) -> None: ...
    def isEmpty(self) -> bool: ...
    def iterator(self) -> java.util.Iterator[_CompactHashSet__E]: ...
    def remove(self, object: _py_Any) -> bool: ...
    def size(self) -> int: ...
    def spliterator(self) -> java.util.Spliterator[_CompactHashSet__E]: ...
    @overload
    def toArray(self) -> _py_List[_py_Any]: ...
    _toArray_1__T = _py_TypeVar('_toArray_1__T')  # <T>
    @overload
    def toArray(self, tArray: _py_List[_toArray_1__T]) -> _py_List[_toArray_1__T]: ...
    def trimToSize(self) -> None: ...

class Comparators:
    _emptiesFirst__T = _py_TypeVar('_emptiesFirst__T')  # <T>
    @classmethod
    def emptiesFirst(cls, comparator: java.util.Comparator[_emptiesFirst__T]) -> java.util.Comparator[java.util.Optional[_emptiesFirst__T]]: ...
    _emptiesLast__T = _py_TypeVar('_emptiesLast__T')  # <T>
    @classmethod
    def emptiesLast(cls, comparator: java.util.Comparator[_emptiesLast__T]) -> java.util.Comparator[java.util.Optional[_emptiesLast__T]]: ...
    _greatest__T = _py_TypeVar('_greatest__T')  # <T>
    @classmethod
    def greatest(cls, int: int, comparator: java.util.Comparator[_greatest__T]) -> java.util.stream.Collector[_greatest__T, _py_Any, java.util.List[_greatest__T]]: ...
    _isInOrder__T = _py_TypeVar('_isInOrder__T')  # <T>
    @classmethod
    def isInOrder(cls, iterable: java.lang.Iterable[_isInOrder__T], comparator: java.util.Comparator[_isInOrder__T]) -> bool: ...
    _isInStrictOrder__T = _py_TypeVar('_isInStrictOrder__T')  # <T>
    @classmethod
    def isInStrictOrder(cls, iterable: java.lang.Iterable[_isInStrictOrder__T], comparator: java.util.Comparator[_isInStrictOrder__T]) -> bool: ...
    _least__T = _py_TypeVar('_least__T')  # <T>
    @classmethod
    def least(cls, int: int, comparator: java.util.Comparator[_least__T]) -> java.util.stream.Collector[_least__T, _py_Any, java.util.List[_least__T]]: ...
    _lexicographical__T = _py_TypeVar('_lexicographical__T')  # <T>
    _lexicographical__S = _py_TypeVar('_lexicographical__S')  # <S>
    @classmethod
    def lexicographical(cls, comparator: java.util.Comparator[_lexicographical__T]) -> java.util.Comparator[java.lang.Iterable[_lexicographical__S]]: ...

class ComparisonChain:
    @overload
    def compare(self, double: float, double2: float) -> 'ComparisonChain': ...
    @overload
    def compare(self, float: float, float2: float) -> 'ComparisonChain': ...
    @overload
    def compare(self, int: int, int2: int) -> 'ComparisonChain': ...
    @overload
    def compare(self, comparable: java.lang.Comparable[_py_Any], comparable2: java.lang.Comparable[_py_Any]) -> 'ComparisonChain': ...
    _compare_4__T = _py_TypeVar('_compare_4__T')  # <T>
    @overload
    def compare(self, t: _compare_4__T, t2: _compare_4__T, comparator: java.util.Comparator[_compare_4__T]) -> 'ComparisonChain': ...
    @overload
    def compare(self, long: int, long2: int) -> 'ComparisonChain': ...
    @overload
    def compare(self, boolean: bool, boolean2: bool) -> 'ComparisonChain': ...
    def compareFalseFirst(self, boolean: bool, boolean2: bool) -> 'ComparisonChain': ...
    def compareTrueFirst(self, boolean: bool, boolean2: bool) -> 'ComparisonChain': ...
    def result(self) -> int: ...
    @classmethod
    def start(cls) -> 'ComparisonChain': ...

class ComputationException(java.lang.RuntimeException):
    def __init__(self, throwable: java.lang.Throwable): ...

class Count(java.io.Serializable):
    def add(self, int: int) -> None: ...
    def addAndGet(self, int: int) -> int: ...
    def equals(self, object: _py_Any) -> bool: ...
    def get(self) -> int: ...
    def getAndSet(self, int: int) -> int: ...
    def hashCode(self) -> int: ...
    def set(self, int: int) -> None: ...
    def toString(self) -> str: ...

_Cut__C = _py_TypeVar('_Cut__C', bound=java.lang.Comparable)  # <C>
class Cut(java.lang.Comparable['Cut'[_Cut__C]], java.io.Serializable, _py_Generic[_Cut__C]):
    @overload
    def compareTo(self, cut: 'Cut'[_Cut__C]) -> int: ...
    @overload
    def compareTo(self, object: _py_Any) -> int: ...
    def equals(self, object: _py_Any) -> bool: ...
    def hashCode(self) -> int: ...

_DiscreteDomain__C = _py_TypeVar('_DiscreteDomain__C', bound=java.lang.Comparable)  # <C>
class DiscreteDomain(_py_Generic[_DiscreteDomain__C]):
    @classmethod
    def bigIntegers(cls) -> 'DiscreteDomain'[java.math.BigInteger]: ...
    def distance(self, c: _DiscreteDomain__C, c2: _DiscreteDomain__C) -> int: ...
    @classmethod
    def integers(cls) -> 'DiscreteDomain'[int]: ...
    @classmethod
    def longs(cls) -> 'DiscreteDomain'[int]: ...
    def maxValue(self) -> _DiscreteDomain__C: ...
    def minValue(self) -> _DiscreteDomain__C: ...
    def next(self, c: _DiscreteDomain__C) -> _DiscreteDomain__C: ...
    def previous(self, c: _DiscreteDomain__C) -> _DiscreteDomain__C: ...

_FilteredMultimapValues__K = _py_TypeVar('_FilteredMultimapValues__K')  # <K>
_FilteredMultimapValues__V = _py_TypeVar('_FilteredMultimapValues__V')  # <V>
class FilteredMultimapValues(java.util.AbstractCollection[_FilteredMultimapValues__V], _py_Generic[_FilteredMultimapValues__K, _FilteredMultimapValues__V]):
    def clear(self) -> None: ...
    def contains(self, object: _py_Any) -> bool: ...
    def iterator(self) -> java.util.Iterator[_FilteredMultimapValues__V]: ...
    def remove(self, object: _py_Any) -> bool: ...
    def removeAll(self, collection: java.util.Collection[_py_Any]) -> bool: ...
    def retainAll(self, collection: java.util.Collection[_py_Any]) -> bool: ...
    def size(self) -> int: ...

_FluentIterable__E = _py_TypeVar('_FluentIterable__E')  # <E>
class FluentIterable(java.lang.Iterable[_FluentIterable__E], _py_Generic[_FluentIterable__E]):
    def allMatch(self, predicate: com.google.common.base.Predicate[_FluentIterable__E]) -> bool: ...
    def anyMatch(self, predicate: com.google.common.base.Predicate[_FluentIterable__E]) -> bool: ...
    @overload
    def append(self, iterable: java.lang.Iterable[_FluentIterable__E]) -> 'FluentIterable'[_FluentIterable__E]: ...
    @overload
    def append(self, eArray: _py_List[_FluentIterable__E]) -> 'FluentIterable'[_FluentIterable__E]: ...
    _concat_0__T = _py_TypeVar('_concat_0__T')  # <T>
    @classmethod
    @overload
    def concat(cls, iterable: java.lang.Iterable[java.lang.Iterable[_concat_0__T]]) -> 'FluentIterable'[_concat_0__T]: ...
    _concat_1__T = _py_TypeVar('_concat_1__T')  # <T>
    @classmethod
    @overload
    def concat(cls, iterable: java.lang.Iterable[_concat_1__T], iterable2: java.lang.Iterable[_concat_1__T]) -> 'FluentIterable'[_concat_1__T]: ...
    _concat_2__T = _py_TypeVar('_concat_2__T')  # <T>
    @classmethod
    @overload
    def concat(cls, iterable: java.lang.Iterable[_concat_2__T], iterable2: java.lang.Iterable[_concat_2__T], iterable3: java.lang.Iterable[_concat_2__T]) -> 'FluentIterable'[_concat_2__T]: ...
    _concat_3__T = _py_TypeVar('_concat_3__T')  # <T>
    @classmethod
    @overload
    def concat(cls, iterable: java.lang.Iterable[_concat_3__T], iterable2: java.lang.Iterable[_concat_3__T], iterable3: java.lang.Iterable[_concat_3__T], iterable4: java.lang.Iterable[_concat_3__T]) -> 'FluentIterable'[_concat_3__T]: ...
    _concat_4__T = _py_TypeVar('_concat_4__T')  # <T>
    @classmethod
    @overload
    def concat(cls, iterableArray: _py_List[java.lang.Iterable[_concat_4__T]]) -> 'FluentIterable'[_concat_4__T]: ...
    def contains(self, object: _py_Any) -> bool: ...
    _copyInto__C = _py_TypeVar('_copyInto__C', bound=java.util.Collection)  # <C>
    def copyInto(self, c: _copyInto__C) -> _copyInto__C: ...
    def cycle(self) -> 'FluentIterable'[_FluentIterable__E]: ...
    @overload
    def filter(self, predicate: com.google.common.base.Predicate[_FluentIterable__E]) -> 'FluentIterable'[_FluentIterable__E]: ...
    _filter_1__T = _py_TypeVar('_filter_1__T')  # <T>
    @overload
    def filter(self, class_: _py_Type[_filter_1__T]) -> 'FluentIterable'[_filter_1__T]: ...
    def first(self) -> com.google.common.base.Optional[_FluentIterable__E]: ...
    def firstMatch(self, predicate: com.google.common.base.Predicate[_FluentIterable__E]) -> com.google.common.base.Optional[_FluentIterable__E]: ...
    def get(self, int: int) -> _FluentIterable__E: ...
    _index__K = _py_TypeVar('_index__K')  # <K>
    def index(self, function: com.google.common.base.Function[_FluentIterable__E, _index__K]) -> 'ImmutableListMultimap'[_index__K, _FluentIterable__E]: ...
    def isEmpty(self) -> bool: ...
    def join(self, joiner: com.google.common.base.Joiner) -> str: ...
    def last(self) -> com.google.common.base.Optional[_FluentIterable__E]: ...
    def limit(self, int: int) -> 'FluentIterable'[_FluentIterable__E]: ...
    _of_0__E = _py_TypeVar('_of_0__E')  # <E>
    @classmethod
    @overload
    def of(cls) -> 'FluentIterable'[_of_0__E]: ...
    _of_1__E = _py_TypeVar('_of_1__E')  # <E>
    @classmethod
    @overload
    def of(cls, e: _of_1__E, eArray: _py_List[_of_1__E]) -> 'FluentIterable'[_of_1__E]: ...
    def size(self) -> int: ...
    def skip(self, int: int) -> 'FluentIterable'[_FluentIterable__E]: ...
    def stream(self) -> java.util.stream.Stream[_FluentIterable__E]: ...
    def toArray(self, class_: _py_Type[_FluentIterable__E]) -> _py_List[_FluentIterable__E]: ...
    def toList(self) -> 'ImmutableList'[_FluentIterable__E]: ...
    _toMap__V = _py_TypeVar('_toMap__V')  # <V>
    def toMap(self, function: com.google.common.base.Function[_FluentIterable__E, _toMap__V]) -> 'ImmutableMap'[_FluentIterable__E, _toMap__V]: ...
    def toMultiset(self) -> 'ImmutableMultiset'[_FluentIterable__E]: ...
    def toSet(self) -> 'ImmutableSet'[_FluentIterable__E]: ...
    def toSortedList(self, comparator: java.util.Comparator[_FluentIterable__E]) -> 'ImmutableList'[_FluentIterable__E]: ...
    def toSortedSet(self, comparator: java.util.Comparator[_FluentIterable__E]) -> 'ImmutableSortedSet'[_FluentIterable__E]: ...
    def toString(self) -> str: ...
    _transform__T = _py_TypeVar('_transform__T')  # <T>
    def transform(self, function: com.google.common.base.Function[_FluentIterable__E, _transform__T]) -> 'FluentIterable'[_transform__T]: ...
    _transformAndConcat__T = _py_TypeVar('_transformAndConcat__T')  # <T>
    def transformAndConcat(self, function: com.google.common.base.Function[_FluentIterable__E, java.lang.Iterable[_transformAndConcat__T]]) -> 'FluentIterable'[_transformAndConcat__T]: ...
    _uniqueIndex__K = _py_TypeVar('_uniqueIndex__K')  # <K>
    def uniqueIndex(self, function: com.google.common.base.Function[_FluentIterable__E, _uniqueIndex__K]) -> 'ImmutableMap'[_uniqueIndex__K, _FluentIterable__E]: ...

class ForwardingImmutableCollection: ...

_ForwardingImmutableList__E = _py_TypeVar('_ForwardingImmutableList__E')  # <E>
class ForwardingImmutableList(_py_Generic[_ForwardingImmutableList__E]): ...

_ForwardingImmutableMap__K = _py_TypeVar('_ForwardingImmutableMap__K')  # <K>
_ForwardingImmutableMap__V = _py_TypeVar('_ForwardingImmutableMap__V')  # <V>
class ForwardingImmutableMap(_py_Generic[_ForwardingImmutableMap__K, _ForwardingImmutableMap__V]): ...

_ForwardingImmutableSet__E = _py_TypeVar('_ForwardingImmutableSet__E')  # <E>
class ForwardingImmutableSet(_py_Generic[_ForwardingImmutableSet__E]): ...

class ForwardingObject:
    def toString(self) -> str: ...

_GeneralRange__T = _py_TypeVar('_GeneralRange__T')  # <T>
class GeneralRange(java.io.Serializable, _py_Generic[_GeneralRange__T]):
    def equals(self, object: _py_Any) -> bool: ...
    def hashCode(self) -> int: ...
    def toString(self) -> str: ...

class GwtTransient(java.lang.annotation.Annotation):
    def equals(self, object: _py_Any) -> bool: ...
    def hashCode(self) -> int: ...
    def toString(self) -> str: ...

class Hashing: ...

_ImmutableCollection__Builder__E = _py_TypeVar('_ImmutableCollection__Builder__E')  # <E>
_ImmutableCollection__E = _py_TypeVar('_ImmutableCollection__E')  # <E>
class ImmutableCollection(java.util.AbstractCollection[_ImmutableCollection__E], java.io.Serializable, _py_Generic[_ImmutableCollection__E]):
    def add(self, e: _ImmutableCollection__E) -> bool: ...
    def addAll(self, collection: java.util.Collection[_ImmutableCollection__E]) -> bool: ...
    def asList(self) -> 'ImmutableList'[_ImmutableCollection__E]: ...
    def clear(self) -> None: ...
    def contains(self, object: _py_Any) -> bool: ...
    @overload
    def iterator(self) -> 'UnmodifiableIterator'[_ImmutableCollection__E]: ...
    @overload
    def iterator(self) -> java.util.Iterator: ...
    def remove(self, object: _py_Any) -> bool: ...
    def removeAll(self, collection: java.util.Collection[_py_Any]) -> bool: ...
    def removeIf(self, predicate: java.util.function.Predicate[_ImmutableCollection__E]) -> bool: ...
    def retainAll(self, collection: java.util.Collection[_py_Any]) -> bool: ...
    def spliterator(self) -> java.util.Spliterator[_ImmutableCollection__E]: ...
    @overload
    def toArray(self) -> _py_List[_py_Any]: ...
    _toArray_1__T = _py_TypeVar('_toArray_1__T')  # <T>
    @overload
    def toArray(self, tArray: _py_List[_toArray_1__T]) -> _py_List[_toArray_1__T]: ...
    class Builder(_py_Generic[_ImmutableCollection__Builder__E]):
        @overload
        def add(self, e: _ImmutableCollection__Builder__E) -> 'ImmutableCollection.Builder'[_ImmutableCollection__Builder__E]: ...
        @overload
        def add(self, eArray: _py_List[_ImmutableCollection__Builder__E]) -> 'ImmutableCollection.Builder'[_ImmutableCollection__Builder__E]: ...
        @overload
        def addAll(self, iterable: java.lang.Iterable[_ImmutableCollection__Builder__E]) -> 'ImmutableCollection.Builder'[_ImmutableCollection__Builder__E]: ...
        @overload
        def addAll(self, iterator: java.util.Iterator[_ImmutableCollection__Builder__E]) -> 'ImmutableCollection.Builder'[_ImmutableCollection__Builder__E]: ...
        def build(self) -> 'ImmutableCollection'[_ImmutableCollection__Builder__E]: ...

_ImmutableMap__Builder__K = _py_TypeVar('_ImmutableMap__Builder__K')  # <K>
_ImmutableMap__Builder__V = _py_TypeVar('_ImmutableMap__Builder__V')  # <V>
_ImmutableMap__K = _py_TypeVar('_ImmutableMap__K')  # <K>
_ImmutableMap__V = _py_TypeVar('_ImmutableMap__V')  # <V>
class ImmutableMap(java.util.Map[_ImmutableMap__K, _ImmutableMap__V], java.io.Serializable, _py_Generic[_ImmutableMap__K, _ImmutableMap__V]):
    def asMultimap(self) -> 'ImmutableSetMultimap'[_ImmutableMap__K, _ImmutableMap__V]: ...
    _builder__K = _py_TypeVar('_builder__K')  # <K>
    _builder__V = _py_TypeVar('_builder__V')  # <V>
    @classmethod
    def builder(cls) -> 'ImmutableMap.Builder'[_builder__K, _builder__V]: ...
    _builderWithExpectedSize__K = _py_TypeVar('_builderWithExpectedSize__K')  # <K>
    _builderWithExpectedSize__V = _py_TypeVar('_builderWithExpectedSize__V')  # <V>
    @classmethod
    def builderWithExpectedSize(cls, int: int) -> 'ImmutableMap.Builder'[_builderWithExpectedSize__K, _builderWithExpectedSize__V]: ...
    def clear(self) -> None: ...
    def compute(self, k: _ImmutableMap__K, biFunction: java.util.function.BiFunction[_ImmutableMap__K, _ImmutableMap__V, _ImmutableMap__V]) -> _ImmutableMap__V: ...
    def computeIfAbsent(self, k: _ImmutableMap__K, function: java.util.function.Function[_ImmutableMap__K, _ImmutableMap__V]) -> _ImmutableMap__V: ...
    def computeIfPresent(self, k: _ImmutableMap__K, biFunction: java.util.function.BiFunction[_ImmutableMap__K, _ImmutableMap__V, _ImmutableMap__V]) -> _ImmutableMap__V: ...
    def containsKey(self, object: _py_Any) -> bool: ...
    def containsValue(self, object: _py_Any) -> bool: ...
    _copyOf_0__K = _py_TypeVar('_copyOf_0__K')  # <K>
    _copyOf_0__V = _py_TypeVar('_copyOf_0__V')  # <V>
    @classmethod
    @overload
    def copyOf(cls, iterable: java.lang.Iterable[java.util.Map.Entry[_copyOf_0__K, _copyOf_0__V]]) -> 'ImmutableMap'[_copyOf_0__K, _copyOf_0__V]: ...
    _copyOf_1__K = _py_TypeVar('_copyOf_1__K')  # <K>
    _copyOf_1__V = _py_TypeVar('_copyOf_1__V')  # <V>
    @classmethod
    @overload
    def copyOf(cls, map: java.util.Map[_copyOf_1__K, _copyOf_1__V]) -> 'ImmutableMap'[_copyOf_1__K, _copyOf_1__V]: ...
    @overload
    def entrySet(self) -> 'ImmutableSet'[java.util.Map.Entry[_ImmutableMap__K, _ImmutableMap__V]]: ...
    @overload
    def entrySet(self) -> java.util.Set: ...
    def equals(self, object: _py_Any) -> bool: ...
    def get(self, object: _py_Any) -> _ImmutableMap__V: ...
    def getOrDefault(self, object: _py_Any, v: _ImmutableMap__V) -> _ImmutableMap__V: ...
    def hashCode(self) -> int: ...
    def isEmpty(self) -> bool: ...
    @overload
    def keySet(self) -> 'ImmutableSet'[_ImmutableMap__K]: ...
    @overload
    def keySet(self) -> java.util.Set: ...
    def merge(self, k: _ImmutableMap__K, v: _ImmutableMap__V, biFunction: java.util.function.BiFunction[_ImmutableMap__V, _ImmutableMap__V, _ImmutableMap__V]) -> _ImmutableMap__V: ...
    _of_0__K = _py_TypeVar('_of_0__K')  # <K>
    _of_0__V = _py_TypeVar('_of_0__V')  # <V>
    @classmethod
    @overload
    def of(cls) -> 'ImmutableMap'[_of_0__K, _of_0__V]: ...
    _of_1__K = _py_TypeVar('_of_1__K')  # <K>
    _of_1__V = _py_TypeVar('_of_1__V')  # <V>
    @classmethod
    @overload
    def of(cls, k: _of_1__K, v: _of_1__V) -> 'ImmutableMap'[_of_1__K, _of_1__V]: ...
    _of_2__K = _py_TypeVar('_of_2__K')  # <K>
    _of_2__V = _py_TypeVar('_of_2__V')  # <V>
    @classmethod
    @overload
    def of(cls, k: _of_2__K, v: _of_2__V, k2: _of_2__K, v2: _of_2__V) -> 'ImmutableMap'[_of_2__K, _of_2__V]: ...
    _of_3__K = _py_TypeVar('_of_3__K')  # <K>
    _of_3__V = _py_TypeVar('_of_3__V')  # <V>
    @classmethod
    @overload
    def of(cls, k: _of_3__K, v: _of_3__V, k2: _of_3__K, v2: _of_3__V, k3: _of_3__K, v3: _of_3__V) -> 'ImmutableMap'[_of_3__K, _of_3__V]: ...
    _of_4__K = _py_TypeVar('_of_4__K')  # <K>
    _of_4__V = _py_TypeVar('_of_4__V')  # <V>
    @classmethod
    @overload
    def of(cls, k: _of_4__K, v: _of_4__V, k2: _of_4__K, v2: _of_4__V, k3: _of_4__K, v3: _of_4__V, k4: _of_4__K, v4: _of_4__V) -> 'ImmutableMap'[_of_4__K, _of_4__V]: ...
    _of_5__K = _py_TypeVar('_of_5__K')  # <K>
    _of_5__V = _py_TypeVar('_of_5__V')  # <V>
    @classmethod
    @overload
    def of(cls, k: _of_5__K, v: _of_5__V, k2: _of_5__K, v2: _of_5__V, k3: _of_5__K, v3: _of_5__V, k4: _of_5__K, v4: _of_5__V, k5: _of_5__K, v5: _of_5__V) -> 'ImmutableMap'[_of_5__K, _of_5__V]: ...
    def put(self, k: _ImmutableMap__K, v: _ImmutableMap__V) -> _ImmutableMap__V: ...
    def putAll(self, map: java.util.Map[_ImmutableMap__K, _ImmutableMap__V]) -> None: ...
    def putIfAbsent(self, k: _ImmutableMap__K, v: _ImmutableMap__V) -> _ImmutableMap__V: ...
    @overload
    def remove(self, object: _py_Any, object2: _py_Any) -> bool: ...
    @overload
    def remove(self, object: _py_Any) -> _ImmutableMap__V: ...
    @overload
    def replace(self, k: _ImmutableMap__K, v: _ImmutableMap__V, v2: _ImmutableMap__V) -> bool: ...
    @overload
    def replace(self, k: _ImmutableMap__K, v: _ImmutableMap__V) -> _ImmutableMap__V: ...
    def replaceAll(self, biFunction: java.util.function.BiFunction[_ImmutableMap__K, _ImmutableMap__V, _ImmutableMap__V]) -> None: ...
    _toImmutableMap_0__T = _py_TypeVar('_toImmutableMap_0__T')  # <T>
    _toImmutableMap_0__K = _py_TypeVar('_toImmutableMap_0__K')  # <K>
    _toImmutableMap_0__V = _py_TypeVar('_toImmutableMap_0__V')  # <V>
    @classmethod
    @overload
    def toImmutableMap(cls, function: java.util.function.Function[_toImmutableMap_0__T, _toImmutableMap_0__K], function2: java.util.function.Function[_toImmutableMap_0__T, _toImmutableMap_0__V]) -> java.util.stream.Collector[_toImmutableMap_0__T, _py_Any, 'ImmutableMap'[_toImmutableMap_0__K, _toImmutableMap_0__V]]: ...
    _toImmutableMap_1__T = _py_TypeVar('_toImmutableMap_1__T')  # <T>
    _toImmutableMap_1__K = _py_TypeVar('_toImmutableMap_1__K')  # <K>
    _toImmutableMap_1__V = _py_TypeVar('_toImmutableMap_1__V')  # <V>
    @classmethod
    @overload
    def toImmutableMap(cls, function: java.util.function.Function[_toImmutableMap_1__T, _toImmutableMap_1__K], function2: java.util.function.Function[_toImmutableMap_1__T, _toImmutableMap_1__V], binaryOperator: java.util.function.BinaryOperator[_toImmutableMap_1__V]) -> java.util.stream.Collector[_toImmutableMap_1__T, _py_Any, 'ImmutableMap'[_toImmutableMap_1__K, _toImmutableMap_1__V]]: ...
    def toString(self) -> str: ...
    @overload
    def values(self) -> ImmutableCollection[_ImmutableMap__V]: ...
    @overload
    def values(self) -> java.util.Collection: ...
    class Builder(_py_Generic[_ImmutableMap__Builder__K, _ImmutableMap__Builder__V]):
        def __init__(self): ...
        def build(self) -> 'ImmutableMap'[_ImmutableMap__Builder__K, _ImmutableMap__Builder__V]: ...
        def orderEntriesByValue(self, comparator: java.util.Comparator[_ImmutableMap__Builder__V]) -> 'ImmutableMap.Builder'[_ImmutableMap__Builder__K, _ImmutableMap__Builder__V]: ...
        @overload
        def put(self, k: _ImmutableMap__Builder__K, v: _ImmutableMap__Builder__V) -> 'ImmutableMap.Builder'[_ImmutableMap__Builder__K, _ImmutableMap__Builder__V]: ...
        @overload
        def put(self, entry: java.util.Map.Entry[_ImmutableMap__Builder__K, _ImmutableMap__Builder__V]) -> 'ImmutableMap.Builder'[_ImmutableMap__Builder__K, _ImmutableMap__Builder__V]: ...
        @overload
        def putAll(self, iterable: java.lang.Iterable[java.util.Map.Entry[_ImmutableMap__Builder__K, _ImmutableMap__Builder__V]]) -> 'ImmutableMap.Builder'[_ImmutableMap__Builder__K, _ImmutableMap__Builder__V]: ...
        @overload
        def putAll(self, map: java.util.Map[_ImmutableMap__Builder__K, _ImmutableMap__Builder__V]) -> 'ImmutableMap.Builder'[_ImmutableMap__Builder__K, _ImmutableMap__Builder__V]: ...

_Interner__E = _py_TypeVar('_Interner__E')  # <E>
class Interner(_py_Generic[_Interner__E]):
    def intern(self, e: _Interner__E) -> _Interner__E: ...

class Interners:
    _asFunction__E = _py_TypeVar('_asFunction__E')  # <E>
    @classmethod
    def asFunction(cls, interner: Interner[_asFunction__E]) -> com.google.common.base.Function[_asFunction__E, _asFunction__E]: ...
    @classmethod
    def newBuilder(cls) -> 'Interners.InternerBuilder': ...
    _newStrongInterner__E = _py_TypeVar('_newStrongInterner__E')  # <E>
    @classmethod
    def newStrongInterner(cls) -> Interner[_newStrongInterner__E]: ...
    _newWeakInterner__E = _py_TypeVar('_newWeakInterner__E')  # <E>
    @classmethod
    def newWeakInterner(cls) -> Interner[_newWeakInterner__E]: ...
    class InternerBuilder:
        _build__E = _py_TypeVar('_build__E')  # <E>
        def build(self) -> Interner[_build__E]: ...
        def concurrencyLevel(self, int: int) -> 'Interners.InternerBuilder': ...
        def strong(self) -> 'Interners.InternerBuilder': ...
        def weak(self) -> 'Interners.InternerBuilder': ...

class Iterables:
    _addAll__T = _py_TypeVar('_addAll__T')  # <T>
    @classmethod
    def addAll(cls, collection: java.util.Collection[_addAll__T], iterable: java.lang.Iterable[_addAll__T]) -> bool: ...
    _all__T = _py_TypeVar('_all__T')  # <T>
    @classmethod
    def all(cls, iterable: java.lang.Iterable[_all__T], predicate: com.google.common.base.Predicate[_all__T]) -> bool: ...
    _any__T = _py_TypeVar('_any__T')  # <T>
    @classmethod
    def any(cls, iterable: java.lang.Iterable[_any__T], predicate: com.google.common.base.Predicate[_any__T]) -> bool: ...
    _concat_0__T = _py_TypeVar('_concat_0__T')  # <T>
    @classmethod
    @overload
    def concat(cls, iterable: java.lang.Iterable[java.lang.Iterable[_concat_0__T]]) -> java.lang.Iterable[_concat_0__T]: ...
    _concat_1__T = _py_TypeVar('_concat_1__T')  # <T>
    @classmethod
    @overload
    def concat(cls, iterable: java.lang.Iterable[_concat_1__T], iterable2: java.lang.Iterable[_concat_1__T]) -> java.lang.Iterable[_concat_1__T]: ...
    _concat_2__T = _py_TypeVar('_concat_2__T')  # <T>
    @classmethod
    @overload
    def concat(cls, iterable: java.lang.Iterable[_concat_2__T], iterable2: java.lang.Iterable[_concat_2__T], iterable3: java.lang.Iterable[_concat_2__T]) -> java.lang.Iterable[_concat_2__T]: ...
    _concat_3__T = _py_TypeVar('_concat_3__T')  # <T>
    @classmethod
    @overload
    def concat(cls, iterable: java.lang.Iterable[_concat_3__T], iterable2: java.lang.Iterable[_concat_3__T], iterable3: java.lang.Iterable[_concat_3__T], iterable4: java.lang.Iterable[_concat_3__T]) -> java.lang.Iterable[_concat_3__T]: ...
    _concat_4__T = _py_TypeVar('_concat_4__T')  # <T>
    @classmethod
    @overload
    def concat(cls, iterableArray: _py_List[java.lang.Iterable[_concat_4__T]]) -> java.lang.Iterable[_concat_4__T]: ...
    _consumingIterable__T = _py_TypeVar('_consumingIterable__T')  # <T>
    @classmethod
    def consumingIterable(cls, iterable: java.lang.Iterable[_consumingIterable__T]) -> java.lang.Iterable[_consumingIterable__T]: ...
    @classmethod
    def contains(cls, iterable: java.lang.Iterable[_py_Any], object: _py_Any) -> bool: ...
    _cycle_0__T = _py_TypeVar('_cycle_0__T')  # <T>
    @classmethod
    @overload
    def cycle(cls, iterable: java.lang.Iterable[_cycle_0__T]) -> java.lang.Iterable[_cycle_0__T]: ...
    _cycle_1__T = _py_TypeVar('_cycle_1__T')  # <T>
    @classmethod
    @overload
    def cycle(cls, tArray: _py_List[_cycle_1__T]) -> java.lang.Iterable[_cycle_1__T]: ...
    @classmethod
    def elementsEqual(cls, iterable: java.lang.Iterable[_py_Any], iterable2: java.lang.Iterable[_py_Any]) -> bool: ...
    _filter_0__T = _py_TypeVar('_filter_0__T')  # <T>
    @classmethod
    @overload
    def filter(cls, iterable: java.lang.Iterable[_filter_0__T], predicate: com.google.common.base.Predicate[_filter_0__T]) -> java.lang.Iterable[_filter_0__T]: ...
    _filter_1__T = _py_TypeVar('_filter_1__T')  # <T>
    @classmethod
    @overload
    def filter(cls, iterable: java.lang.Iterable[_py_Any], class_: _py_Type[_filter_1__T]) -> java.lang.Iterable[_filter_1__T]: ...
    _find_0__T = _py_TypeVar('_find_0__T')  # <T>
    @classmethod
    @overload
    def find(cls, iterable: java.lang.Iterable[_find_0__T], predicate: com.google.common.base.Predicate[_find_0__T]) -> _find_0__T: ...
    _find_1__T = _py_TypeVar('_find_1__T')  # <T>
    @classmethod
    @overload
    def find(cls, iterable: java.lang.Iterable[_find_1__T], predicate: com.google.common.base.Predicate[_find_1__T], t: _find_1__T) -> _find_1__T: ...
    @classmethod
    def frequency(cls, iterable: java.lang.Iterable[_py_Any], object: _py_Any) -> int: ...
    _get_0__T = _py_TypeVar('_get_0__T')  # <T>
    @classmethod
    @overload
    def get(cls, iterable: java.lang.Iterable[_get_0__T], int: int) -> _get_0__T: ...
    _get_1__T = _py_TypeVar('_get_1__T')  # <T>
    @classmethod
    @overload
    def get(cls, iterable: java.lang.Iterable[_get_1__T], int: int, t: _get_1__T) -> _get_1__T: ...
    _getFirst__T = _py_TypeVar('_getFirst__T')  # <T>
    @classmethod
    def getFirst(cls, iterable: java.lang.Iterable[_getFirst__T], t: _getFirst__T) -> _getFirst__T: ...
    _getLast_0__T = _py_TypeVar('_getLast_0__T')  # <T>
    @classmethod
    @overload
    def getLast(cls, iterable: java.lang.Iterable[_getLast_0__T]) -> _getLast_0__T: ...
    _getLast_1__T = _py_TypeVar('_getLast_1__T')  # <T>
    @classmethod
    @overload
    def getLast(cls, iterable: java.lang.Iterable[_getLast_1__T], t: _getLast_1__T) -> _getLast_1__T: ...
    _getOnlyElement_0__T = _py_TypeVar('_getOnlyElement_0__T')  # <T>
    @classmethod
    @overload
    def getOnlyElement(cls, iterable: java.lang.Iterable[_getOnlyElement_0__T]) -> _getOnlyElement_0__T: ...
    _getOnlyElement_1__T = _py_TypeVar('_getOnlyElement_1__T')  # <T>
    @classmethod
    @overload
    def getOnlyElement(cls, iterable: java.lang.Iterable[_getOnlyElement_1__T], t: _getOnlyElement_1__T) -> _getOnlyElement_1__T: ...
    _indexOf__T = _py_TypeVar('_indexOf__T')  # <T>
    @classmethod
    def indexOf(cls, iterable: java.lang.Iterable[_indexOf__T], predicate: com.google.common.base.Predicate[_indexOf__T]) -> int: ...
    @classmethod
    def isEmpty(cls, iterable: java.lang.Iterable[_py_Any]) -> bool: ...
    _limit__T = _py_TypeVar('_limit__T')  # <T>
    @classmethod
    def limit(cls, iterable: java.lang.Iterable[_limit__T], int: int) -> java.lang.Iterable[_limit__T]: ...
    _mergeSorted__T = _py_TypeVar('_mergeSorted__T')  # <T>
    @classmethod
    def mergeSorted(cls, iterable: java.lang.Iterable[java.lang.Iterable[_mergeSorted__T]], comparator: java.util.Comparator[_mergeSorted__T]) -> java.lang.Iterable[_mergeSorted__T]: ...
    _paddedPartition__T = _py_TypeVar('_paddedPartition__T')  # <T>
    @classmethod
    def paddedPartition(cls, iterable: java.lang.Iterable[_paddedPartition__T], int: int) -> java.lang.Iterable[java.util.List[_paddedPartition__T]]: ...
    _partition__T = _py_TypeVar('_partition__T')  # <T>
    @classmethod
    def partition(cls, iterable: java.lang.Iterable[_partition__T], int: int) -> java.lang.Iterable[java.util.List[_partition__T]]: ...
    @classmethod
    def removeAll(cls, iterable: java.lang.Iterable[_py_Any], collection: java.util.Collection[_py_Any]) -> bool: ...
    _removeIf__T = _py_TypeVar('_removeIf__T')  # <T>
    @classmethod
    def removeIf(cls, iterable: java.lang.Iterable[_removeIf__T], predicate: com.google.common.base.Predicate[_removeIf__T]) -> bool: ...
    @classmethod
    def retainAll(cls, iterable: java.lang.Iterable[_py_Any], collection: java.util.Collection[_py_Any]) -> bool: ...
    @classmethod
    def size(cls, iterable: java.lang.Iterable[_py_Any]) -> int: ...
    _skip__T = _py_TypeVar('_skip__T')  # <T>
    @classmethod
    def skip(cls, iterable: java.lang.Iterable[_skip__T], int: int) -> java.lang.Iterable[_skip__T]: ...
    _toArray__T = _py_TypeVar('_toArray__T')  # <T>
    @classmethod
    def toArray(cls, iterable: java.lang.Iterable[_toArray__T], class_: _py_Type[_toArray__T]) -> _py_List[_toArray__T]: ...
    @overload
    def toString(self) -> str: ...
    @classmethod
    @overload
    def toString(cls, iterable: java.lang.Iterable[_py_Any]) -> str: ...
    _transform__F = _py_TypeVar('_transform__F')  # <F>
    _transform__T = _py_TypeVar('_transform__T')  # <T>
    @classmethod
    def transform(cls, iterable: java.lang.Iterable[_transform__F], function: com.google.common.base.Function[_transform__F, _transform__T]) -> java.lang.Iterable[_transform__T]: ...
    _tryFind__T = _py_TypeVar('_tryFind__T')  # <T>
    @classmethod
    def tryFind(cls, iterable: java.lang.Iterable[_tryFind__T], predicate: com.google.common.base.Predicate[_tryFind__T]) -> com.google.common.base.Optional[_tryFind__T]: ...
    _unmodifiableIterable_0__E = _py_TypeVar('_unmodifiableIterable_0__E')  # <E>
    @classmethod
    @overload
    def unmodifiableIterable(cls, immutableCollection: ImmutableCollection[_unmodifiableIterable_0__E]) -> java.lang.Iterable[_unmodifiableIterable_0__E]: ...
    _unmodifiableIterable_1__T = _py_TypeVar('_unmodifiableIterable_1__T')  # <T>
    @classmethod
    @overload
    def unmodifiableIterable(cls, iterable: java.lang.Iterable[_unmodifiableIterable_1__T]) -> java.lang.Iterable[_unmodifiableIterable_1__T]: ...

class Iterators:
    _addAll__T = _py_TypeVar('_addAll__T')  # <T>
    @classmethod
    def addAll(cls, collection: java.util.Collection[_addAll__T], iterator: java.util.Iterator[_addAll__T]) -> bool: ...
    @classmethod
    def advance(cls, iterator: java.util.Iterator[_py_Any], int: int) -> int: ...
    _all__T = _py_TypeVar('_all__T')  # <T>
    @classmethod
    def all(cls, iterator: java.util.Iterator[_all__T], predicate: com.google.common.base.Predicate[_all__T]) -> bool: ...
    _any__T = _py_TypeVar('_any__T')  # <T>
    @classmethod
    def any(cls, iterator: java.util.Iterator[_any__T], predicate: com.google.common.base.Predicate[_any__T]) -> bool: ...
    _asEnumeration__T = _py_TypeVar('_asEnumeration__T')  # <T>
    @classmethod
    def asEnumeration(cls, iterator: java.util.Iterator[_asEnumeration__T]) -> java.util.Enumeration[_asEnumeration__T]: ...
    _concat_0__T = _py_TypeVar('_concat_0__T')  # <T>
    @classmethod
    @overload
    def concat(cls, iterator: java.util.Iterator[java.util.Iterator[_concat_0__T]]) -> java.util.Iterator[_concat_0__T]: ...
    _concat_1__T = _py_TypeVar('_concat_1__T')  # <T>
    @classmethod
    @overload
    def concat(cls, iterator: java.util.Iterator[_concat_1__T], iterator2: java.util.Iterator[_concat_1__T]) -> java.util.Iterator[_concat_1__T]: ...
    _concat_2__T = _py_TypeVar('_concat_2__T')  # <T>
    @classmethod
    @overload
    def concat(cls, iterator: java.util.Iterator[_concat_2__T], iterator2: java.util.Iterator[_concat_2__T], iterator3: java.util.Iterator[_concat_2__T]) -> java.util.Iterator[_concat_2__T]: ...
    _concat_3__T = _py_TypeVar('_concat_3__T')  # <T>
    @classmethod
    @overload
    def concat(cls, iterator: java.util.Iterator[_concat_3__T], iterator2: java.util.Iterator[_concat_3__T], iterator3: java.util.Iterator[_concat_3__T], iterator4: java.util.Iterator[_concat_3__T]) -> java.util.Iterator[_concat_3__T]: ...
    _concat_4__T = _py_TypeVar('_concat_4__T')  # <T>
    @classmethod
    @overload
    def concat(cls, iteratorArray: _py_List[java.util.Iterator[_concat_4__T]]) -> java.util.Iterator[_concat_4__T]: ...
    _consumingIterator__T = _py_TypeVar('_consumingIterator__T')  # <T>
    @classmethod
    def consumingIterator(cls, iterator: java.util.Iterator[_consumingIterator__T]) -> java.util.Iterator[_consumingIterator__T]: ...
    @classmethod
    def contains(cls, iterator: java.util.Iterator[_py_Any], object: _py_Any) -> bool: ...
    _cycle_0__T = _py_TypeVar('_cycle_0__T')  # <T>
    @classmethod
    @overload
    def cycle(cls, iterable: java.lang.Iterable[_cycle_0__T]) -> java.util.Iterator[_cycle_0__T]: ...
    _cycle_1__T = _py_TypeVar('_cycle_1__T')  # <T>
    @classmethod
    @overload
    def cycle(cls, tArray: _py_List[_cycle_1__T]) -> java.util.Iterator[_cycle_1__T]: ...
    @classmethod
    def elementsEqual(cls, iterator: java.util.Iterator[_py_Any], iterator2: java.util.Iterator[_py_Any]) -> bool: ...
    _filter_0__T = _py_TypeVar('_filter_0__T')  # <T>
    @classmethod
    @overload
    def filter(cls, iterator: java.util.Iterator[_filter_0__T], predicate: com.google.common.base.Predicate[_filter_0__T]) -> 'UnmodifiableIterator'[_filter_0__T]: ...
    _filter_1__T = _py_TypeVar('_filter_1__T')  # <T>
    @classmethod
    @overload
    def filter(cls, iterator: java.util.Iterator[_py_Any], class_: _py_Type[_filter_1__T]) -> 'UnmodifiableIterator'[_filter_1__T]: ...
    _find_0__T = _py_TypeVar('_find_0__T')  # <T>
    @classmethod
    @overload
    def find(cls, iterator: java.util.Iterator[_find_0__T], predicate: com.google.common.base.Predicate[_find_0__T]) -> _find_0__T: ...
    _find_1__T = _py_TypeVar('_find_1__T')  # <T>
    @classmethod
    @overload
    def find(cls, iterator: java.util.Iterator[_find_1__T], predicate: com.google.common.base.Predicate[_find_1__T], t: _find_1__T) -> _find_1__T: ...
    _forArray__T = _py_TypeVar('_forArray__T')  # <T>
    @classmethod
    def forArray(cls, tArray: _py_List[_forArray__T]) -> 'UnmodifiableIterator'[_forArray__T]: ...
    _forEnumeration__T = _py_TypeVar('_forEnumeration__T')  # <T>
    @classmethod
    def forEnumeration(cls, enumeration: java.util.Enumeration[_forEnumeration__T]) -> 'UnmodifiableIterator'[_forEnumeration__T]: ...
    @classmethod
    def frequency(cls, iterator: java.util.Iterator[_py_Any], object: _py_Any) -> int: ...
    _get_0__T = _py_TypeVar('_get_0__T')  # <T>
    @classmethod
    @overload
    def get(cls, iterator: java.util.Iterator[_get_0__T], int: int) -> _get_0__T: ...
    _get_1__T = _py_TypeVar('_get_1__T')  # <T>
    @classmethod
    @overload
    def get(cls, iterator: java.util.Iterator[_get_1__T], int: int, t: _get_1__T) -> _get_1__T: ...
    _getLast_0__T = _py_TypeVar('_getLast_0__T')  # <T>
    @classmethod
    @overload
    def getLast(cls, iterator: java.util.Iterator[_getLast_0__T]) -> _getLast_0__T: ...
    _getLast_1__T = _py_TypeVar('_getLast_1__T')  # <T>
    @classmethod
    @overload
    def getLast(cls, iterator: java.util.Iterator[_getLast_1__T], t: _getLast_1__T) -> _getLast_1__T: ...
    _getNext__T = _py_TypeVar('_getNext__T')  # <T>
    @classmethod
    def getNext(cls, iterator: java.util.Iterator[_getNext__T], t: _getNext__T) -> _getNext__T: ...
    _getOnlyElement_0__T = _py_TypeVar('_getOnlyElement_0__T')  # <T>
    @classmethod
    @overload
    def getOnlyElement(cls, iterator: java.util.Iterator[_getOnlyElement_0__T]) -> _getOnlyElement_0__T: ...
    _getOnlyElement_1__T = _py_TypeVar('_getOnlyElement_1__T')  # <T>
    @classmethod
    @overload
    def getOnlyElement(cls, iterator: java.util.Iterator[_getOnlyElement_1__T], t: _getOnlyElement_1__T) -> _getOnlyElement_1__T: ...
    _indexOf__T = _py_TypeVar('_indexOf__T')  # <T>
    @classmethod
    def indexOf(cls, iterator: java.util.Iterator[_indexOf__T], predicate: com.google.common.base.Predicate[_indexOf__T]) -> int: ...
    _limit__T = _py_TypeVar('_limit__T')  # <T>
    @classmethod
    def limit(cls, iterator: java.util.Iterator[_limit__T], int: int) -> java.util.Iterator[_limit__T]: ...
    _mergeSorted__T = _py_TypeVar('_mergeSorted__T')  # <T>
    @classmethod
    def mergeSorted(cls, iterable: java.lang.Iterable[java.util.Iterator[_mergeSorted__T]], comparator: java.util.Comparator[_mergeSorted__T]) -> 'UnmodifiableIterator'[_mergeSorted__T]: ...
    _paddedPartition__T = _py_TypeVar('_paddedPartition__T')  # <T>
    @classmethod
    def paddedPartition(cls, iterator: java.util.Iterator[_paddedPartition__T], int: int) -> 'UnmodifiableIterator'[java.util.List[_paddedPartition__T]]: ...
    _partition__T = _py_TypeVar('_partition__T')  # <T>
    @classmethod
    def partition(cls, iterator: java.util.Iterator[_partition__T], int: int) -> 'UnmodifiableIterator'[java.util.List[_partition__T]]: ...
    _peekingIterator_0__T = _py_TypeVar('_peekingIterator_0__T')  # <T>
    @classmethod
    @overload
    def peekingIterator(cls, peekingIterator: 'PeekingIterator'[_peekingIterator_0__T]) -> 'PeekingIterator'[_peekingIterator_0__T]: ...
    _peekingIterator_1__T = _py_TypeVar('_peekingIterator_1__T')  # <T>
    @classmethod
    @overload
    def peekingIterator(cls, iterator: java.util.Iterator[_peekingIterator_1__T]) -> 'PeekingIterator'[_peekingIterator_1__T]: ...
    @classmethod
    def removeAll(cls, iterator: java.util.Iterator[_py_Any], collection: java.util.Collection[_py_Any]) -> bool: ...
    _removeIf__T = _py_TypeVar('_removeIf__T')  # <T>
    @classmethod
    def removeIf(cls, iterator: java.util.Iterator[_removeIf__T], predicate: com.google.common.base.Predicate[_removeIf__T]) -> bool: ...
    @classmethod
    def retainAll(cls, iterator: java.util.Iterator[_py_Any], collection: java.util.Collection[_py_Any]) -> bool: ...
    _singletonIterator__T = _py_TypeVar('_singletonIterator__T')  # <T>
    @classmethod
    def singletonIterator(cls, t: _singletonIterator__T) -> 'UnmodifiableIterator'[_singletonIterator__T]: ...
    @classmethod
    def size(cls, iterator: java.util.Iterator[_py_Any]) -> int: ...
    _toArray__T = _py_TypeVar('_toArray__T')  # <T>
    @classmethod
    def toArray(cls, iterator: java.util.Iterator[_toArray__T], class_: _py_Type[_toArray__T]) -> _py_List[_toArray__T]: ...
    @overload
    def toString(self) -> str: ...
    @classmethod
    @overload
    def toString(cls, iterator: java.util.Iterator[_py_Any]) -> str: ...
    _transform__F = _py_TypeVar('_transform__F')  # <F>
    _transform__T = _py_TypeVar('_transform__T')  # <T>
    @classmethod
    def transform(cls, iterator: java.util.Iterator[_transform__F], function: com.google.common.base.Function[_transform__F, _transform__T]) -> java.util.Iterator[_transform__T]: ...
    _tryFind__T = _py_TypeVar('_tryFind__T')  # <T>
    @classmethod
    def tryFind(cls, iterator: java.util.Iterator[_tryFind__T], predicate: com.google.common.base.Predicate[_tryFind__T]) -> com.google.common.base.Optional[_tryFind__T]: ...
    _unmodifiableIterator_0__T = _py_TypeVar('_unmodifiableIterator_0__T')  # <T>
    @classmethod
    @overload
    def unmodifiableIterator(cls, unmodifiableIterator: 'UnmodifiableIterator'[_unmodifiableIterator_0__T]) -> 'UnmodifiableIterator'[_unmodifiableIterator_0__T]: ...
    _unmodifiableIterator_1__T = _py_TypeVar('_unmodifiableIterator_1__T')  # <T>
    @classmethod
    @overload
    def unmodifiableIterator(cls, iterator: java.util.Iterator[_unmodifiableIterator_1__T]) -> 'UnmodifiableIterator'[_unmodifiableIterator_1__T]: ...

class Lists:
    _asList_0__E = _py_TypeVar('_asList_0__E')  # <E>
    @classmethod
    @overload
    def asList(cls, e: _asList_0__E, e2: _asList_0__E, eArray: _py_List[_asList_0__E]) -> java.util.List[_asList_0__E]: ...
    _asList_1__E = _py_TypeVar('_asList_1__E')  # <E>
    @classmethod
    @overload
    def asList(cls, e: _asList_1__E, eArray: _py_List[_asList_1__E]) -> java.util.List[_asList_1__E]: ...
    _cartesianProduct_0__B = _py_TypeVar('_cartesianProduct_0__B')  # <B>
    @classmethod
    @overload
    def cartesianProduct(cls, list: java.util.List[java.util.List[_cartesianProduct_0__B]]) -> java.util.List[java.util.List[_cartesianProduct_0__B]]: ...
    _cartesianProduct_1__B = _py_TypeVar('_cartesianProduct_1__B')  # <B>
    @classmethod
    @overload
    def cartesianProduct(cls, listArray: _py_List[java.util.List[_cartesianProduct_1__B]]) -> java.util.List[java.util.List[_cartesianProduct_1__B]]: ...
    @classmethod
    @overload
    def charactersOf(cls, string: str) -> 'ImmutableList'[str]: ...
    @classmethod
    @overload
    def charactersOf(cls, charSequence: java.lang.CharSequence) -> java.util.List[str]: ...
    _newArrayList_0__E = _py_TypeVar('_newArrayList_0__E')  # <E>
    @classmethod
    @overload
    def newArrayList(cls) -> java.util.ArrayList[_newArrayList_0__E]: ...
    _newArrayList_1__E = _py_TypeVar('_newArrayList_1__E')  # <E>
    @classmethod
    @overload
    def newArrayList(cls, iterable: java.lang.Iterable[_newArrayList_1__E]) -> java.util.ArrayList[_newArrayList_1__E]: ...
    _newArrayList_2__E = _py_TypeVar('_newArrayList_2__E')  # <E>
    @classmethod
    @overload
    def newArrayList(cls, eArray: _py_List[_newArrayList_2__E]) -> java.util.ArrayList[_newArrayList_2__E]: ...
    _newArrayList_3__E = _py_TypeVar('_newArrayList_3__E')  # <E>
    @classmethod
    @overload
    def newArrayList(cls, iterator: java.util.Iterator[_newArrayList_3__E]) -> java.util.ArrayList[_newArrayList_3__E]: ...
    _newArrayListWithCapacity__E = _py_TypeVar('_newArrayListWithCapacity__E')  # <E>
    @classmethod
    def newArrayListWithCapacity(cls, int: int) -> java.util.ArrayList[_newArrayListWithCapacity__E]: ...
    _newArrayListWithExpectedSize__E = _py_TypeVar('_newArrayListWithExpectedSize__E')  # <E>
    @classmethod
    def newArrayListWithExpectedSize(cls, int: int) -> java.util.ArrayList[_newArrayListWithExpectedSize__E]: ...
    _newCopyOnWriteArrayList_0__E = _py_TypeVar('_newCopyOnWriteArrayList_0__E')  # <E>
    @classmethod
    @overload
    def newCopyOnWriteArrayList(cls) -> java.util.concurrent.CopyOnWriteArrayList[_newCopyOnWriteArrayList_0__E]: ...
    _newCopyOnWriteArrayList_1__E = _py_TypeVar('_newCopyOnWriteArrayList_1__E')  # <E>
    @classmethod
    @overload
    def newCopyOnWriteArrayList(cls, iterable: java.lang.Iterable[_newCopyOnWriteArrayList_1__E]) -> java.util.concurrent.CopyOnWriteArrayList[_newCopyOnWriteArrayList_1__E]: ...
    _newLinkedList_0__E = _py_TypeVar('_newLinkedList_0__E')  # <E>
    @classmethod
    @overload
    def newLinkedList(cls) -> java.util.LinkedList[_newLinkedList_0__E]: ...
    _newLinkedList_1__E = _py_TypeVar('_newLinkedList_1__E')  # <E>
    @classmethod
    @overload
    def newLinkedList(cls, iterable: java.lang.Iterable[_newLinkedList_1__E]) -> java.util.LinkedList[_newLinkedList_1__E]: ...
    _partition__T = _py_TypeVar('_partition__T')  # <T>
    @classmethod
    def partition(cls, list: java.util.List[_partition__T], int: int) -> java.util.List[java.util.List[_partition__T]]: ...
    _reverse__T = _py_TypeVar('_reverse__T')  # <T>
    @classmethod
    def reverse(cls, list: java.util.List[_reverse__T]) -> java.util.List[_reverse__T]: ...
    _transform__F = _py_TypeVar('_transform__F')  # <F>
    _transform__T = _py_TypeVar('_transform__T')  # <T>
    @classmethod
    def transform(cls, list: java.util.List[_transform__F], function: com.google.common.base.Function[_transform__F, _transform__T]) -> java.util.List[_transform__T]: ...

_MapDifference__ValueDifference__V = _py_TypeVar('_MapDifference__ValueDifference__V')  # <V>
_MapDifference__K = _py_TypeVar('_MapDifference__K')  # <K>
_MapDifference__V = _py_TypeVar('_MapDifference__V')  # <V>
class MapDifference(_py_Generic[_MapDifference__K, _MapDifference__V]):
    def areEqual(self) -> bool: ...
    def entriesDiffering(self) -> java.util.Map[_MapDifference__K, 'MapDifference.ValueDifference'[_MapDifference__V]]: ...
    def entriesInCommon(self) -> java.util.Map[_MapDifference__K, _MapDifference__V]: ...
    def entriesOnlyOnLeft(self) -> java.util.Map[_MapDifference__K, _MapDifference__V]: ...
    def entriesOnlyOnRight(self) -> java.util.Map[_MapDifference__K, _MapDifference__V]: ...
    def equals(self, object: _py_Any) -> bool: ...
    def hashCode(self) -> int: ...
    class ValueDifference(_py_Generic[_MapDifference__ValueDifference__V]):
        def equals(self, object: _py_Any) -> bool: ...
        def hashCode(self) -> int: ...
        def leftValue(self) -> _MapDifference__ValueDifference__V: ...
        def rightValue(self) -> _MapDifference__ValueDifference__V: ...

class MapMaker:
    def __init__(self): ...
    def concurrencyLevel(self, int: int) -> 'MapMaker': ...
    def initialCapacity(self, int: int) -> 'MapMaker': ...
    _makeMap__K = _py_TypeVar('_makeMap__K')  # <K>
    _makeMap__V = _py_TypeVar('_makeMap__V')  # <V>
    def makeMap(self) -> java.util.concurrent.ConcurrentMap[_makeMap__K, _makeMap__V]: ...
    def toString(self) -> str: ...
    def weakKeys(self) -> 'MapMaker': ...
    def weakValues(self) -> 'MapMaker': ...

_MapMakerInternalMap__K = _py_TypeVar('_MapMakerInternalMap__K')  # <K>
_MapMakerInternalMap__V = _py_TypeVar('_MapMakerInternalMap__V')  # <V>
_MapMakerInternalMap__E = _py_TypeVar('_MapMakerInternalMap__E', bound='MapMakerInternalMap.InternalEntry')  # <E>
_MapMakerInternalMap__S = _py_TypeVar('_MapMakerInternalMap__S', bound='MapMakerInternalMap.Segment')  # <S>
class MapMakerInternalMap(java.util.AbstractMap[_MapMakerInternalMap__K, _MapMakerInternalMap__V], java.util.concurrent.ConcurrentMap[_MapMakerInternalMap__K, _MapMakerInternalMap__V], java.io.Serializable, _py_Generic[_MapMakerInternalMap__K, _MapMakerInternalMap__V, _MapMakerInternalMap__E, _MapMakerInternalMap__S]):
    def clear(self) -> None: ...
    def containsKey(self, object: _py_Any) -> bool: ...
    def containsValue(self, object: _py_Any) -> bool: ...
    def entrySet(self) -> java.util.Set[java.util.Map.Entry[_MapMakerInternalMap__K, _MapMakerInternalMap__V]]: ...
    def get(self, object: _py_Any) -> _MapMakerInternalMap__V: ...
    def isEmpty(self) -> bool: ...
    def keySet(self) -> java.util.Set[_MapMakerInternalMap__K]: ...
    def put(self, k: _MapMakerInternalMap__K, v: _MapMakerInternalMap__V) -> _MapMakerInternalMap__V: ...
    def putAll(self, map: java.util.Map[_MapMakerInternalMap__K, _MapMakerInternalMap__V]) -> None: ...
    def putIfAbsent(self, k: _MapMakerInternalMap__K, v: _MapMakerInternalMap__V) -> _MapMakerInternalMap__V: ...
    @overload
    def remove(self, object: _py_Any, object2: _py_Any) -> bool: ...
    @overload
    def remove(self, object: _py_Any) -> _MapMakerInternalMap__V: ...
    @overload
    def replace(self, k: _MapMakerInternalMap__K, v: _MapMakerInternalMap__V, v2: _MapMakerInternalMap__V) -> bool: ...
    @overload
    def replace(self, k: _MapMakerInternalMap__K, v: _MapMakerInternalMap__V) -> _MapMakerInternalMap__V: ...
    def size(self) -> int: ...
    def values(self) -> java.util.Collection[_MapMakerInternalMap__V]: ...

_Maps__EntryTransformer__K = _py_TypeVar('_Maps__EntryTransformer__K')  # <K>
_Maps__EntryTransformer__V1 = _py_TypeVar('_Maps__EntryTransformer__V1')  # <V1>
_Maps__EntryTransformer__V2 = _py_TypeVar('_Maps__EntryTransformer__V2')  # <V2>
class Maps:
    _asConverter__A = _py_TypeVar('_asConverter__A')  # <A>
    _asConverter__B = _py_TypeVar('_asConverter__B')  # <B>
    @classmethod
    def asConverter(cls, biMap: BiMap[_asConverter__A, _asConverter__B]) -> com.google.common.base.Converter[_asConverter__A, _asConverter__B]: ...
    _asMap_0__K = _py_TypeVar('_asMap_0__K')  # <K>
    _asMap_0__V = _py_TypeVar('_asMap_0__V')  # <V>
    @classmethod
    @overload
    def asMap(cls, set: java.util.Set[_asMap_0__K], function: com.google.common.base.Function[_asMap_0__K, _asMap_0__V]) -> java.util.Map[_asMap_0__K, _asMap_0__V]: ...
    _asMap_1__K = _py_TypeVar('_asMap_1__K')  # <K>
    _asMap_1__V = _py_TypeVar('_asMap_1__V')  # <V>
    @classmethod
    @overload
    def asMap(cls, navigableSet: java.util.NavigableSet[_asMap_1__K], function: com.google.common.base.Function[_asMap_1__K, _asMap_1__V]) -> java.util.NavigableMap[_asMap_1__K, _asMap_1__V]: ...
    _asMap_2__K = _py_TypeVar('_asMap_2__K')  # <K>
    _asMap_2__V = _py_TypeVar('_asMap_2__V')  # <V>
    @classmethod
    @overload
    def asMap(cls, sortedSet: java.util.SortedSet[_asMap_2__K], function: com.google.common.base.Function[_asMap_2__K, _asMap_2__V]) -> java.util.SortedMap[_asMap_2__K, _asMap_2__V]: ...
    _difference_0__K = _py_TypeVar('_difference_0__K')  # <K>
    _difference_0__V = _py_TypeVar('_difference_0__V')  # <V>
    @classmethod
    @overload
    def difference(cls, map: java.util.Map[_difference_0__K, _difference_0__V], map2: java.util.Map[_difference_0__K, _difference_0__V]) -> MapDifference[_difference_0__K, _difference_0__V]: ...
    _difference_1__K = _py_TypeVar('_difference_1__K')  # <K>
    _difference_1__V = _py_TypeVar('_difference_1__V')  # <V>
    @classmethod
    @overload
    def difference(cls, map: java.util.Map[_difference_1__K, _difference_1__V], map2: java.util.Map[_difference_1__K, _difference_1__V], equivalence: com.google.common.base.Equivalence[_difference_1__V]) -> MapDifference[_difference_1__K, _difference_1__V]: ...
    _difference_2__K = _py_TypeVar('_difference_2__K')  # <K>
    _difference_2__V = _py_TypeVar('_difference_2__V')  # <V>
    @classmethod
    @overload
    def difference(cls, sortedMap: java.util.SortedMap[_difference_2__K, _difference_2__V], map: java.util.Map[_difference_2__K, _difference_2__V]) -> 'SortedMapDifference'[_difference_2__K, _difference_2__V]: ...
    _filterEntries_0__K = _py_TypeVar('_filterEntries_0__K')  # <K>
    _filterEntries_0__V = _py_TypeVar('_filterEntries_0__V')  # <V>
    @classmethod
    @overload
    def filterEntries(cls, biMap: BiMap[_filterEntries_0__K, _filterEntries_0__V], predicate: com.google.common.base.Predicate[java.util.Map.Entry[_filterEntries_0__K, _filterEntries_0__V]]) -> BiMap[_filterEntries_0__K, _filterEntries_0__V]: ...
    _filterEntries_1__K = _py_TypeVar('_filterEntries_1__K')  # <K>
    _filterEntries_1__V = _py_TypeVar('_filterEntries_1__V')  # <V>
    @classmethod
    @overload
    def filterEntries(cls, map: java.util.Map[_filterEntries_1__K, _filterEntries_1__V], predicate: com.google.common.base.Predicate[java.util.Map.Entry[_filterEntries_1__K, _filterEntries_1__V]]) -> java.util.Map[_filterEntries_1__K, _filterEntries_1__V]: ...
    _filterEntries_2__K = _py_TypeVar('_filterEntries_2__K')  # <K>
    _filterEntries_2__V = _py_TypeVar('_filterEntries_2__V')  # <V>
    @classmethod
    @overload
    def filterEntries(cls, navigableMap: java.util.NavigableMap[_filterEntries_2__K, _filterEntries_2__V], predicate: com.google.common.base.Predicate[java.util.Map.Entry[_filterEntries_2__K, _filterEntries_2__V]]) -> java.util.NavigableMap[_filterEntries_2__K, _filterEntries_2__V]: ...
    _filterEntries_3__K = _py_TypeVar('_filterEntries_3__K')  # <K>
    _filterEntries_3__V = _py_TypeVar('_filterEntries_3__V')  # <V>
    @classmethod
    @overload
    def filterEntries(cls, sortedMap: java.util.SortedMap[_filterEntries_3__K, _filterEntries_3__V], predicate: com.google.common.base.Predicate[java.util.Map.Entry[_filterEntries_3__K, _filterEntries_3__V]]) -> java.util.SortedMap[_filterEntries_3__K, _filterEntries_3__V]: ...
    _filterKeys_0__K = _py_TypeVar('_filterKeys_0__K')  # <K>
    _filterKeys_0__V = _py_TypeVar('_filterKeys_0__V')  # <V>
    @classmethod
    @overload
    def filterKeys(cls, biMap: BiMap[_filterKeys_0__K, _filterKeys_0__V], predicate: com.google.common.base.Predicate[_filterKeys_0__K]) -> BiMap[_filterKeys_0__K, _filterKeys_0__V]: ...
    _filterKeys_1__K = _py_TypeVar('_filterKeys_1__K')  # <K>
    _filterKeys_1__V = _py_TypeVar('_filterKeys_1__V')  # <V>
    @classmethod
    @overload
    def filterKeys(cls, map: java.util.Map[_filterKeys_1__K, _filterKeys_1__V], predicate: com.google.common.base.Predicate[_filterKeys_1__K]) -> java.util.Map[_filterKeys_1__K, _filterKeys_1__V]: ...
    _filterKeys_2__K = _py_TypeVar('_filterKeys_2__K')  # <K>
    _filterKeys_2__V = _py_TypeVar('_filterKeys_2__V')  # <V>
    @classmethod
    @overload
    def filterKeys(cls, navigableMap: java.util.NavigableMap[_filterKeys_2__K, _filterKeys_2__V], predicate: com.google.common.base.Predicate[_filterKeys_2__K]) -> java.util.NavigableMap[_filterKeys_2__K, _filterKeys_2__V]: ...
    _filterKeys_3__K = _py_TypeVar('_filterKeys_3__K')  # <K>
    _filterKeys_3__V = _py_TypeVar('_filterKeys_3__V')  # <V>
    @classmethod
    @overload
    def filterKeys(cls, sortedMap: java.util.SortedMap[_filterKeys_3__K, _filterKeys_3__V], predicate: com.google.common.base.Predicate[_filterKeys_3__K]) -> java.util.SortedMap[_filterKeys_3__K, _filterKeys_3__V]: ...
    _filterValues_0__K = _py_TypeVar('_filterValues_0__K')  # <K>
    _filterValues_0__V = _py_TypeVar('_filterValues_0__V')  # <V>
    @classmethod
    @overload
    def filterValues(cls, biMap: BiMap[_filterValues_0__K, _filterValues_0__V], predicate: com.google.common.base.Predicate[_filterValues_0__V]) -> BiMap[_filterValues_0__K, _filterValues_0__V]: ...
    _filterValues_1__K = _py_TypeVar('_filterValues_1__K')  # <K>
    _filterValues_1__V = _py_TypeVar('_filterValues_1__V')  # <V>
    @classmethod
    @overload
    def filterValues(cls, map: java.util.Map[_filterValues_1__K, _filterValues_1__V], predicate: com.google.common.base.Predicate[_filterValues_1__V]) -> java.util.Map[_filterValues_1__K, _filterValues_1__V]: ...
    _filterValues_2__K = _py_TypeVar('_filterValues_2__K')  # <K>
    _filterValues_2__V = _py_TypeVar('_filterValues_2__V')  # <V>
    @classmethod
    @overload
    def filterValues(cls, navigableMap: java.util.NavigableMap[_filterValues_2__K, _filterValues_2__V], predicate: com.google.common.base.Predicate[_filterValues_2__V]) -> java.util.NavigableMap[_filterValues_2__K, _filterValues_2__V]: ...
    _filterValues_3__K = _py_TypeVar('_filterValues_3__K')  # <K>
    _filterValues_3__V = _py_TypeVar('_filterValues_3__V')  # <V>
    @classmethod
    @overload
    def filterValues(cls, sortedMap: java.util.SortedMap[_filterValues_3__K, _filterValues_3__V], predicate: com.google.common.base.Predicate[_filterValues_3__V]) -> java.util.SortedMap[_filterValues_3__K, _filterValues_3__V]: ...
    @classmethod
    def fromProperties(cls, properties: java.util.Properties) -> ImmutableMap[str, str]: ...
    _immutableEntry__K = _py_TypeVar('_immutableEntry__K')  # <K>
    _immutableEntry__V = _py_TypeVar('_immutableEntry__V')  # <V>
    @classmethod
    def immutableEntry(cls, k: _immutableEntry__K, v: _immutableEntry__V) -> java.util.Map.Entry[_immutableEntry__K, _immutableEntry__V]: ...
    _immutableEnumMap__K = _py_TypeVar('_immutableEnumMap__K', bound=java.lang.Enum)  # <K>
    _immutableEnumMap__V = _py_TypeVar('_immutableEnumMap__V')  # <V>
    @classmethod
    def immutableEnumMap(cls, map: java.util.Map[_immutableEnumMap__K, _immutableEnumMap__V]) -> ImmutableMap[_immutableEnumMap__K, _immutableEnumMap__V]: ...
    _newConcurrentMap__K = _py_TypeVar('_newConcurrentMap__K')  # <K>
    _newConcurrentMap__V = _py_TypeVar('_newConcurrentMap__V')  # <V>
    @classmethod
    def newConcurrentMap(cls) -> java.util.concurrent.ConcurrentMap[_newConcurrentMap__K, _newConcurrentMap__V]: ...
    _newEnumMap_0__K = _py_TypeVar('_newEnumMap_0__K', bound=java.lang.Enum)  # <K>
    _newEnumMap_0__V = _py_TypeVar('_newEnumMap_0__V')  # <V>
    @classmethod
    @overload
    def newEnumMap(cls, class_: _py_Type[_newEnumMap_0__K]) -> java.util.EnumMap[_newEnumMap_0__K, _newEnumMap_0__V]: ...
    _newEnumMap_1__K = _py_TypeVar('_newEnumMap_1__K', bound=java.lang.Enum)  # <K>
    _newEnumMap_1__V = _py_TypeVar('_newEnumMap_1__V')  # <V>
    @classmethod
    @overload
    def newEnumMap(cls, map: java.util.Map[_newEnumMap_1__K, _newEnumMap_1__V]) -> java.util.EnumMap[_newEnumMap_1__K, _newEnumMap_1__V]: ...
    _newHashMap_0__K = _py_TypeVar('_newHashMap_0__K')  # <K>
    _newHashMap_0__V = _py_TypeVar('_newHashMap_0__V')  # <V>
    @classmethod
    @overload
    def newHashMap(cls) -> java.util.HashMap[_newHashMap_0__K, _newHashMap_0__V]: ...
    _newHashMap_1__K = _py_TypeVar('_newHashMap_1__K')  # <K>
    _newHashMap_1__V = _py_TypeVar('_newHashMap_1__V')  # <V>
    @classmethod
    @overload
    def newHashMap(cls, map: java.util.Map[_newHashMap_1__K, _newHashMap_1__V]) -> java.util.HashMap[_newHashMap_1__K, _newHashMap_1__V]: ...
    _newHashMapWithExpectedSize__K = _py_TypeVar('_newHashMapWithExpectedSize__K')  # <K>
    _newHashMapWithExpectedSize__V = _py_TypeVar('_newHashMapWithExpectedSize__V')  # <V>
    @classmethod
    def newHashMapWithExpectedSize(cls, int: int) -> java.util.HashMap[_newHashMapWithExpectedSize__K, _newHashMapWithExpectedSize__V]: ...
    _newIdentityHashMap__K = _py_TypeVar('_newIdentityHashMap__K')  # <K>
    _newIdentityHashMap__V = _py_TypeVar('_newIdentityHashMap__V')  # <V>
    @classmethod
    def newIdentityHashMap(cls) -> java.util.IdentityHashMap[_newIdentityHashMap__K, _newIdentityHashMap__V]: ...
    _newLinkedHashMap_0__K = _py_TypeVar('_newLinkedHashMap_0__K')  # <K>
    _newLinkedHashMap_0__V = _py_TypeVar('_newLinkedHashMap_0__V')  # <V>
    @classmethod
    @overload
    def newLinkedHashMap(cls) -> java.util.LinkedHashMap[_newLinkedHashMap_0__K, _newLinkedHashMap_0__V]: ...
    _newLinkedHashMap_1__K = _py_TypeVar('_newLinkedHashMap_1__K')  # <K>
    _newLinkedHashMap_1__V = _py_TypeVar('_newLinkedHashMap_1__V')  # <V>
    @classmethod
    @overload
    def newLinkedHashMap(cls, map: java.util.Map[_newLinkedHashMap_1__K, _newLinkedHashMap_1__V]) -> java.util.LinkedHashMap[_newLinkedHashMap_1__K, _newLinkedHashMap_1__V]: ...
    _newLinkedHashMapWithExpectedSize__K = _py_TypeVar('_newLinkedHashMapWithExpectedSize__K')  # <K>
    _newLinkedHashMapWithExpectedSize__V = _py_TypeVar('_newLinkedHashMapWithExpectedSize__V')  # <V>
    @classmethod
    def newLinkedHashMapWithExpectedSize(cls, int: int) -> java.util.LinkedHashMap[_newLinkedHashMapWithExpectedSize__K, _newLinkedHashMapWithExpectedSize__V]: ...
    _newTreeMap_0__K = _py_TypeVar('_newTreeMap_0__K', bound=java.lang.Comparable)  # <K>
    _newTreeMap_0__V = _py_TypeVar('_newTreeMap_0__V')  # <V>
    @classmethod
    @overload
    def newTreeMap(cls) -> java.util.TreeMap[_newTreeMap_0__K, _newTreeMap_0__V]: ...
    _newTreeMap_1__C = _py_TypeVar('_newTreeMap_1__C')  # <C>
    _newTreeMap_1__K = _py_TypeVar('_newTreeMap_1__K')  # <K>
    _newTreeMap_1__V = _py_TypeVar('_newTreeMap_1__V')  # <V>
    @classmethod
    @overload
    def newTreeMap(cls, comparator: java.util.Comparator[_newTreeMap_1__C]) -> java.util.TreeMap[_newTreeMap_1__K, _newTreeMap_1__V]: ...
    _newTreeMap_2__K = _py_TypeVar('_newTreeMap_2__K')  # <K>
    _newTreeMap_2__V = _py_TypeVar('_newTreeMap_2__V')  # <V>
    @classmethod
    @overload
    def newTreeMap(cls, sortedMap: java.util.SortedMap[_newTreeMap_2__K, _newTreeMap_2__V]) -> java.util.TreeMap[_newTreeMap_2__K, _newTreeMap_2__V]: ...
    _subMap__K = _py_TypeVar('_subMap__K', bound=java.lang.Comparable)  # <K>
    _subMap__V = _py_TypeVar('_subMap__V')  # <V>
    @classmethod
    def subMap(cls, navigableMap: java.util.NavigableMap[_subMap__K, _subMap__V], range: 'Range'[_subMap__K]) -> java.util.NavigableMap[_subMap__K, _subMap__V]: ...
    _synchronizedBiMap__K = _py_TypeVar('_synchronizedBiMap__K')  # <K>
    _synchronizedBiMap__V = _py_TypeVar('_synchronizedBiMap__V')  # <V>
    @classmethod
    def synchronizedBiMap(cls, biMap: BiMap[_synchronizedBiMap__K, _synchronizedBiMap__V]) -> BiMap[_synchronizedBiMap__K, _synchronizedBiMap__V]: ...
    _synchronizedNavigableMap__K = _py_TypeVar('_synchronizedNavigableMap__K')  # <K>
    _synchronizedNavigableMap__V = _py_TypeVar('_synchronizedNavigableMap__V')  # <V>
    @classmethod
    def synchronizedNavigableMap(cls, navigableMap: java.util.NavigableMap[_synchronizedNavigableMap__K, _synchronizedNavigableMap__V]) -> java.util.NavigableMap[_synchronizedNavigableMap__K, _synchronizedNavigableMap__V]: ...
    _toImmutableEnumMap_0__T = _py_TypeVar('_toImmutableEnumMap_0__T')  # <T>
    _toImmutableEnumMap_0__K = _py_TypeVar('_toImmutableEnumMap_0__K', bound=java.lang.Enum)  # <K>
    _toImmutableEnumMap_0__V = _py_TypeVar('_toImmutableEnumMap_0__V')  # <V>
    @classmethod
    @overload
    def toImmutableEnumMap(cls, function: java.util.function.Function[_toImmutableEnumMap_0__T, _toImmutableEnumMap_0__K], function2: java.util.function.Function[_toImmutableEnumMap_0__T, _toImmutableEnumMap_0__V]) -> java.util.stream.Collector[_toImmutableEnumMap_0__T, _py_Any, ImmutableMap[_toImmutableEnumMap_0__K, _toImmutableEnumMap_0__V]]: ...
    _toImmutableEnumMap_1__T = _py_TypeVar('_toImmutableEnumMap_1__T')  # <T>
    _toImmutableEnumMap_1__K = _py_TypeVar('_toImmutableEnumMap_1__K', bound=java.lang.Enum)  # <K>
    _toImmutableEnumMap_1__V = _py_TypeVar('_toImmutableEnumMap_1__V')  # <V>
    @classmethod
    @overload
    def toImmutableEnumMap(cls, function: java.util.function.Function[_toImmutableEnumMap_1__T, _toImmutableEnumMap_1__K], function2: java.util.function.Function[_toImmutableEnumMap_1__T, _toImmutableEnumMap_1__V], binaryOperator: java.util.function.BinaryOperator[_toImmutableEnumMap_1__V]) -> java.util.stream.Collector[_toImmutableEnumMap_1__T, _py_Any, ImmutableMap[_toImmutableEnumMap_1__K, _toImmutableEnumMap_1__V]]: ...
    _toMap_0__K = _py_TypeVar('_toMap_0__K')  # <K>
    _toMap_0__V = _py_TypeVar('_toMap_0__V')  # <V>
    @classmethod
    @overload
    def toMap(cls, iterable: java.lang.Iterable[_toMap_0__K], function: com.google.common.base.Function[_toMap_0__K, _toMap_0__V]) -> ImmutableMap[_toMap_0__K, _toMap_0__V]: ...
    _toMap_1__K = _py_TypeVar('_toMap_1__K')  # <K>
    _toMap_1__V = _py_TypeVar('_toMap_1__V')  # <V>
    @classmethod
    @overload
    def toMap(cls, iterator: java.util.Iterator[_toMap_1__K], function: com.google.common.base.Function[_toMap_1__K, _toMap_1__V]) -> ImmutableMap[_toMap_1__K, _toMap_1__V]: ...
    _transformEntries_0__K = _py_TypeVar('_transformEntries_0__K')  # <K>
    _transformEntries_0__V1 = _py_TypeVar('_transformEntries_0__V1')  # <V1>
    _transformEntries_0__V2 = _py_TypeVar('_transformEntries_0__V2')  # <V2>
    @classmethod
    @overload
    def transformEntries(cls, map: java.util.Map[_transformEntries_0__K, _transformEntries_0__V1], entryTransformer: 'Maps.EntryTransformer'[_transformEntries_0__K, _transformEntries_0__V1, _transformEntries_0__V2]) -> java.util.Map[_transformEntries_0__K, _transformEntries_0__V2]: ...
    _transformEntries_1__K = _py_TypeVar('_transformEntries_1__K')  # <K>
    _transformEntries_1__V1 = _py_TypeVar('_transformEntries_1__V1')  # <V1>
    _transformEntries_1__V2 = _py_TypeVar('_transformEntries_1__V2')  # <V2>
    @classmethod
    @overload
    def transformEntries(cls, navigableMap: java.util.NavigableMap[_transformEntries_1__K, _transformEntries_1__V1], entryTransformer: 'Maps.EntryTransformer'[_transformEntries_1__K, _transformEntries_1__V1, _transformEntries_1__V2]) -> java.util.NavigableMap[_transformEntries_1__K, _transformEntries_1__V2]: ...
    _transformEntries_2__K = _py_TypeVar('_transformEntries_2__K')  # <K>
    _transformEntries_2__V1 = _py_TypeVar('_transformEntries_2__V1')  # <V1>
    _transformEntries_2__V2 = _py_TypeVar('_transformEntries_2__V2')  # <V2>
    @classmethod
    @overload
    def transformEntries(cls, sortedMap: java.util.SortedMap[_transformEntries_2__K, _transformEntries_2__V1], entryTransformer: 'Maps.EntryTransformer'[_transformEntries_2__K, _transformEntries_2__V1, _transformEntries_2__V2]) -> java.util.SortedMap[_transformEntries_2__K, _transformEntries_2__V2]: ...
    _transformValues_0__K = _py_TypeVar('_transformValues_0__K')  # <K>
    _transformValues_0__V1 = _py_TypeVar('_transformValues_0__V1')  # <V1>
    _transformValues_0__V2 = _py_TypeVar('_transformValues_0__V2')  # <V2>
    @classmethod
    @overload
    def transformValues(cls, map: java.util.Map[_transformValues_0__K, _transformValues_0__V1], function: com.google.common.base.Function[_transformValues_0__V1, _transformValues_0__V2]) -> java.util.Map[_transformValues_0__K, _transformValues_0__V2]: ...
    _transformValues_1__K = _py_TypeVar('_transformValues_1__K')  # <K>
    _transformValues_1__V1 = _py_TypeVar('_transformValues_1__V1')  # <V1>
    _transformValues_1__V2 = _py_TypeVar('_transformValues_1__V2')  # <V2>
    @classmethod
    @overload
    def transformValues(cls, navigableMap: java.util.NavigableMap[_transformValues_1__K, _transformValues_1__V1], function: com.google.common.base.Function[_transformValues_1__V1, _transformValues_1__V2]) -> java.util.NavigableMap[_transformValues_1__K, _transformValues_1__V2]: ...
    _transformValues_2__K = _py_TypeVar('_transformValues_2__K')  # <K>
    _transformValues_2__V1 = _py_TypeVar('_transformValues_2__V1')  # <V1>
    _transformValues_2__V2 = _py_TypeVar('_transformValues_2__V2')  # <V2>
    @classmethod
    @overload
    def transformValues(cls, sortedMap: java.util.SortedMap[_transformValues_2__K, _transformValues_2__V1], function: com.google.common.base.Function[_transformValues_2__V1, _transformValues_2__V2]) -> java.util.SortedMap[_transformValues_2__K, _transformValues_2__V2]: ...
    _uniqueIndex_0__K = _py_TypeVar('_uniqueIndex_0__K')  # <K>
    _uniqueIndex_0__V = _py_TypeVar('_uniqueIndex_0__V')  # <V>
    @classmethod
    @overload
    def uniqueIndex(cls, iterable: java.lang.Iterable[_uniqueIndex_0__V], function: com.google.common.base.Function[_uniqueIndex_0__V, _uniqueIndex_0__K]) -> ImmutableMap[_uniqueIndex_0__K, _uniqueIndex_0__V]: ...
    _uniqueIndex_1__K = _py_TypeVar('_uniqueIndex_1__K')  # <K>
    _uniqueIndex_1__V = _py_TypeVar('_uniqueIndex_1__V')  # <V>
    @classmethod
    @overload
    def uniqueIndex(cls, iterator: java.util.Iterator[_uniqueIndex_1__V], function: com.google.common.base.Function[_uniqueIndex_1__V, _uniqueIndex_1__K]) -> ImmutableMap[_uniqueIndex_1__K, _uniqueIndex_1__V]: ...
    _unmodifiableBiMap__K = _py_TypeVar('_unmodifiableBiMap__K')  # <K>
    _unmodifiableBiMap__V = _py_TypeVar('_unmodifiableBiMap__V')  # <V>
    @classmethod
    def unmodifiableBiMap(cls, biMap: BiMap[_unmodifiableBiMap__K, _unmodifiableBiMap__V]) -> BiMap[_unmodifiableBiMap__K, _unmodifiableBiMap__V]: ...
    _unmodifiableNavigableMap__K = _py_TypeVar('_unmodifiableNavigableMap__K')  # <K>
    _unmodifiableNavigableMap__V = _py_TypeVar('_unmodifiableNavigableMap__V')  # <V>
    @classmethod
    def unmodifiableNavigableMap(cls, navigableMap: java.util.NavigableMap[_unmodifiableNavigableMap__K, _unmodifiableNavigableMap__V]) -> java.util.NavigableMap[_unmodifiableNavigableMap__K, _unmodifiableNavigableMap__V]: ...
    class EntryTransformer(_py_Generic[_Maps__EntryTransformer__K, _Maps__EntryTransformer__V1, _Maps__EntryTransformer__V2]):
        def transformEntry(self, k: _Maps__EntryTransformer__K, v1: _Maps__EntryTransformer__V1) -> _Maps__EntryTransformer__V2: ...

_MinMaxPriorityQueue__Builder__B = _py_TypeVar('_MinMaxPriorityQueue__Builder__B')  # <B>
_MinMaxPriorityQueue__E = _py_TypeVar('_MinMaxPriorityQueue__E')  # <E>
class MinMaxPriorityQueue(java.util.AbstractQueue[_MinMaxPriorityQueue__E], _py_Generic[_MinMaxPriorityQueue__E]):
    def add(self, e: _MinMaxPriorityQueue__E) -> bool: ...
    def addAll(self, collection: java.util.Collection[_MinMaxPriorityQueue__E]) -> bool: ...
    def clear(self) -> None: ...
    def comparator(self) -> java.util.Comparator[_MinMaxPriorityQueue__E]: ...
    _create_0__E = _py_TypeVar('_create_0__E', bound=java.lang.Comparable)  # <E>
    @classmethod
    @overload
    def create(cls) -> 'MinMaxPriorityQueue'[_create_0__E]: ...
    _create_1__E = _py_TypeVar('_create_1__E', bound=java.lang.Comparable)  # <E>
    @classmethod
    @overload
    def create(cls, iterable: java.lang.Iterable[_create_1__E]) -> 'MinMaxPriorityQueue'[_create_1__E]: ...
    @classmethod
    def expectedSize(cls, int: int) -> 'MinMaxPriorityQueue.Builder'[java.lang.Comparable]: ...
    def iterator(self) -> java.util.Iterator[_MinMaxPriorityQueue__E]: ...
    @classmethod
    def maximumSize(cls, int: int) -> 'MinMaxPriorityQueue.Builder'[java.lang.Comparable]: ...
    def offer(self, e: _MinMaxPriorityQueue__E) -> bool: ...
    _orderedBy__B = _py_TypeVar('_orderedBy__B')  # <B>
    @classmethod
    def orderedBy(cls, comparator: java.util.Comparator[_orderedBy__B]) -> 'MinMaxPriorityQueue.Builder'[_orderedBy__B]: ...
    def peek(self) -> _MinMaxPriorityQueue__E: ...
    def peekFirst(self) -> _MinMaxPriorityQueue__E: ...
    def peekLast(self) -> _MinMaxPriorityQueue__E: ...
    def poll(self) -> _MinMaxPriorityQueue__E: ...
    def pollFirst(self) -> _MinMaxPriorityQueue__E: ...
    def pollLast(self) -> _MinMaxPriorityQueue__E: ...
    def removeFirst(self) -> _MinMaxPriorityQueue__E: ...
    def removeLast(self) -> _MinMaxPriorityQueue__E: ...
    def size(self) -> int: ...
    @overload
    def toArray(self) -> _py_List[_py_Any]: ...
    _toArray_1__T = _py_TypeVar('_toArray_1__T')  # <T>
    @overload
    def toArray(self, tArray: _py_List[_toArray_1__T]) -> _py_List[_toArray_1__T]: ...
    class Builder(_py_Generic[_MinMaxPriorityQueue__Builder__B]):
        _create_0__T = _py_TypeVar('_create_0__T')  # <T>
        @overload
        def create(self) -> 'MinMaxPriorityQueue'[_create_0__T]: ...
        _create_1__T = _py_TypeVar('_create_1__T')  # <T>
        @overload
        def create(self, iterable: java.lang.Iterable[_create_1__T]) -> 'MinMaxPriorityQueue'[_create_1__T]: ...
        def expectedSize(self, int: int) -> 'MinMaxPriorityQueue.Builder'[_MinMaxPriorityQueue__Builder__B]: ...
        def maximumSize(self, int: int) -> 'MinMaxPriorityQueue.Builder'[_MinMaxPriorityQueue__Builder__B]: ...

class MoreCollectors:
    _onlyElement__T = _py_TypeVar('_onlyElement__T')  # <T>
    @classmethod
    def onlyElement(cls) -> java.util.stream.Collector[_onlyElement__T, _py_Any, _onlyElement__T]: ...
    _toOptional__T = _py_TypeVar('_toOptional__T')  # <T>
    @classmethod
    def toOptional(cls) -> java.util.stream.Collector[_toOptional__T, _py_Any, java.util.Optional[_toOptional__T]]: ...

_Multimap__K = _py_TypeVar('_Multimap__K')  # <K>
_Multimap__V = _py_TypeVar('_Multimap__V')  # <V>
class Multimap(_py_Generic[_Multimap__K, _Multimap__V]):
    def asMap(self) -> java.util.Map[_Multimap__K, java.util.Collection[_Multimap__V]]: ...
    def clear(self) -> None: ...
    def containsEntry(self, object: _py_Any, object2: _py_Any) -> bool: ...
    def containsKey(self, object: _py_Any) -> bool: ...
    def containsValue(self, object: _py_Any) -> bool: ...
    def entries(self) -> java.util.Collection[java.util.Map.Entry[_Multimap__K, _Multimap__V]]: ...
    def equals(self, object: _py_Any) -> bool: ...
    def forEach(self, biConsumer: java.util.function.BiConsumer[_Multimap__K, _Multimap__V]) -> None: ...
    def get(self, k: _Multimap__K) -> java.util.Collection[_Multimap__V]: ...
    def hashCode(self) -> int: ...
    def isEmpty(self) -> bool: ...
    def keySet(self) -> java.util.Set[_Multimap__K]: ...
    def keys(self) -> 'Multiset'[_Multimap__K]: ...
    def put(self, k: _Multimap__K, v: _Multimap__V) -> bool: ...
    @overload
    def putAll(self, multimap: 'Multimap'[_Multimap__K, _Multimap__V]) -> bool: ...
    @overload
    def putAll(self, k: _Multimap__K, iterable: java.lang.Iterable[_Multimap__V]) -> bool: ...
    def remove(self, object: _py_Any, object2: _py_Any) -> bool: ...
    def removeAll(self, object: _py_Any) -> java.util.Collection[_Multimap__V]: ...
    def replaceValues(self, k: _Multimap__K, iterable: java.lang.Iterable[_Multimap__V]) -> java.util.Collection[_Multimap__V]: ...
    def size(self) -> int: ...
    def values(self) -> java.util.Collection[_Multimap__V]: ...

class Multimaps:
    _asMap_0__K = _py_TypeVar('_asMap_0__K')  # <K>
    _asMap_0__V = _py_TypeVar('_asMap_0__V')  # <V>
    @classmethod
    @overload
    def asMap(cls, listMultimap: 'ListMultimap'[_asMap_0__K, _asMap_0__V]) -> java.util.Map[_asMap_0__K, java.util.List[_asMap_0__V]]: ...
    _asMap_1__K = _py_TypeVar('_asMap_1__K')  # <K>
    _asMap_1__V = _py_TypeVar('_asMap_1__V')  # <V>
    @classmethod
    @overload
    def asMap(cls, multimap: Multimap[_asMap_1__K, _asMap_1__V]) -> java.util.Map[_asMap_1__K, java.util.Collection[_asMap_1__V]]: ...
    _asMap_2__K = _py_TypeVar('_asMap_2__K')  # <K>
    _asMap_2__V = _py_TypeVar('_asMap_2__V')  # <V>
    @classmethod
    @overload
    def asMap(cls, setMultimap: 'SetMultimap'[_asMap_2__K, _asMap_2__V]) -> java.util.Map[_asMap_2__K, java.util.Set[_asMap_2__V]]: ...
    _asMap_3__K = _py_TypeVar('_asMap_3__K')  # <K>
    _asMap_3__V = _py_TypeVar('_asMap_3__V')  # <V>
    @classmethod
    @overload
    def asMap(cls, sortedSetMultimap: 'SortedSetMultimap'[_asMap_3__K, _asMap_3__V]) -> java.util.Map[_asMap_3__K, java.util.SortedSet[_asMap_3__V]]: ...
    _filterEntries_0__K = _py_TypeVar('_filterEntries_0__K')  # <K>
    _filterEntries_0__V = _py_TypeVar('_filterEntries_0__V')  # <V>
    @classmethod
    @overload
    def filterEntries(cls, multimap: Multimap[_filterEntries_0__K, _filterEntries_0__V], predicate: com.google.common.base.Predicate[java.util.Map.Entry[_filterEntries_0__K, _filterEntries_0__V]]) -> Multimap[_filterEntries_0__K, _filterEntries_0__V]: ...
    _filterEntries_1__K = _py_TypeVar('_filterEntries_1__K')  # <K>
    _filterEntries_1__V = _py_TypeVar('_filterEntries_1__V')  # <V>
    @classmethod
    @overload
    def filterEntries(cls, setMultimap: 'SetMultimap'[_filterEntries_1__K, _filterEntries_1__V], predicate: com.google.common.base.Predicate[java.util.Map.Entry[_filterEntries_1__K, _filterEntries_1__V]]) -> 'SetMultimap'[_filterEntries_1__K, _filterEntries_1__V]: ...
    _filterKeys_0__K = _py_TypeVar('_filterKeys_0__K')  # <K>
    _filterKeys_0__V = _py_TypeVar('_filterKeys_0__V')  # <V>
    @classmethod
    @overload
    def filterKeys(cls, listMultimap: 'ListMultimap'[_filterKeys_0__K, _filterKeys_0__V], predicate: com.google.common.base.Predicate[_filterKeys_0__K]) -> 'ListMultimap'[_filterKeys_0__K, _filterKeys_0__V]: ...
    _filterKeys_1__K = _py_TypeVar('_filterKeys_1__K')  # <K>
    _filterKeys_1__V = _py_TypeVar('_filterKeys_1__V')  # <V>
    @classmethod
    @overload
    def filterKeys(cls, multimap: Multimap[_filterKeys_1__K, _filterKeys_1__V], predicate: com.google.common.base.Predicate[_filterKeys_1__K]) -> Multimap[_filterKeys_1__K, _filterKeys_1__V]: ...
    _filterKeys_2__K = _py_TypeVar('_filterKeys_2__K')  # <K>
    _filterKeys_2__V = _py_TypeVar('_filterKeys_2__V')  # <V>
    @classmethod
    @overload
    def filterKeys(cls, setMultimap: 'SetMultimap'[_filterKeys_2__K, _filterKeys_2__V], predicate: com.google.common.base.Predicate[_filterKeys_2__K]) -> 'SetMultimap'[_filterKeys_2__K, _filterKeys_2__V]: ...
    _filterValues_0__K = _py_TypeVar('_filterValues_0__K')  # <K>
    _filterValues_0__V = _py_TypeVar('_filterValues_0__V')  # <V>
    @classmethod
    @overload
    def filterValues(cls, multimap: Multimap[_filterValues_0__K, _filterValues_0__V], predicate: com.google.common.base.Predicate[_filterValues_0__V]) -> Multimap[_filterValues_0__K, _filterValues_0__V]: ...
    _filterValues_1__K = _py_TypeVar('_filterValues_1__K')  # <K>
    _filterValues_1__V = _py_TypeVar('_filterValues_1__V')  # <V>
    @classmethod
    @overload
    def filterValues(cls, setMultimap: 'SetMultimap'[_filterValues_1__K, _filterValues_1__V], predicate: com.google.common.base.Predicate[_filterValues_1__V]) -> 'SetMultimap'[_filterValues_1__K, _filterValues_1__V]: ...
    _flatteningToMultimap__T = _py_TypeVar('_flatteningToMultimap__T')  # <T>
    _flatteningToMultimap__K = _py_TypeVar('_flatteningToMultimap__K')  # <K>
    _flatteningToMultimap__V = _py_TypeVar('_flatteningToMultimap__V')  # <V>
    _flatteningToMultimap__M = _py_TypeVar('_flatteningToMultimap__M', bound=Multimap)  # <M>
    @classmethod
    def flatteningToMultimap(cls, function: java.util.function.Function[_flatteningToMultimap__T, _flatteningToMultimap__K], function2: java.util.function.Function[_flatteningToMultimap__T, java.util.stream.Stream[_flatteningToMultimap__V]], supplier: java.util.function.Supplier[_flatteningToMultimap__M]) -> java.util.stream.Collector[_flatteningToMultimap__T, _py_Any, _flatteningToMultimap__M]: ...
    _forMap__K = _py_TypeVar('_forMap__K')  # <K>
    _forMap__V = _py_TypeVar('_forMap__V')  # <V>
    @classmethod
    def forMap(cls, map: java.util.Map[_forMap__K, _forMap__V]) -> 'SetMultimap'[_forMap__K, _forMap__V]: ...
    _index_0__K = _py_TypeVar('_index_0__K')  # <K>
    _index_0__V = _py_TypeVar('_index_0__V')  # <V>
    @classmethod
    @overload
    def index(cls, iterable: java.lang.Iterable[_index_0__V], function: com.google.common.base.Function[_index_0__V, _index_0__K]) -> 'ImmutableListMultimap'[_index_0__K, _index_0__V]: ...
    _index_1__K = _py_TypeVar('_index_1__K')  # <K>
    _index_1__V = _py_TypeVar('_index_1__V')  # <V>
    @classmethod
    @overload
    def index(cls, iterator: java.util.Iterator[_index_1__V], function: com.google.common.base.Function[_index_1__V, _index_1__K]) -> 'ImmutableListMultimap'[_index_1__K, _index_1__V]: ...
    _invertFrom__K = _py_TypeVar('_invertFrom__K')  # <K>
    _invertFrom__V = _py_TypeVar('_invertFrom__V')  # <V>
    _invertFrom__M = _py_TypeVar('_invertFrom__M', bound=Multimap)  # <M>
    @classmethod
    def invertFrom(cls, multimap: Multimap[_invertFrom__V, _invertFrom__K], m2: _invertFrom__M) -> _invertFrom__M: ...
    _newListMultimap__K = _py_TypeVar('_newListMultimap__K')  # <K>
    _newListMultimap__V = _py_TypeVar('_newListMultimap__V')  # <V>
    @classmethod
    def newListMultimap(cls, map: java.util.Map[_newListMultimap__K, java.util.Collection[_newListMultimap__V]], supplier: com.google.common.base.Supplier[java.util.List[_newListMultimap__V]]) -> 'ListMultimap'[_newListMultimap__K, _newListMultimap__V]: ...
    _newMultimap__K = _py_TypeVar('_newMultimap__K')  # <K>
    _newMultimap__V = _py_TypeVar('_newMultimap__V')  # <V>
    @classmethod
    def newMultimap(cls, map: java.util.Map[_newMultimap__K, java.util.Collection[_newMultimap__V]], supplier: com.google.common.base.Supplier[java.util.Collection[_newMultimap__V]]) -> Multimap[_newMultimap__K, _newMultimap__V]: ...
    _newSetMultimap__K = _py_TypeVar('_newSetMultimap__K')  # <K>
    _newSetMultimap__V = _py_TypeVar('_newSetMultimap__V')  # <V>
    @classmethod
    def newSetMultimap(cls, map: java.util.Map[_newSetMultimap__K, java.util.Collection[_newSetMultimap__V]], supplier: com.google.common.base.Supplier[java.util.Set[_newSetMultimap__V]]) -> 'SetMultimap'[_newSetMultimap__K, _newSetMultimap__V]: ...
    _newSortedSetMultimap__K = _py_TypeVar('_newSortedSetMultimap__K')  # <K>
    _newSortedSetMultimap__V = _py_TypeVar('_newSortedSetMultimap__V')  # <V>
    @classmethod
    def newSortedSetMultimap(cls, map: java.util.Map[_newSortedSetMultimap__K, java.util.Collection[_newSortedSetMultimap__V]], supplier: com.google.common.base.Supplier[java.util.SortedSet[_newSortedSetMultimap__V]]) -> 'SortedSetMultimap'[_newSortedSetMultimap__K, _newSortedSetMultimap__V]: ...
    _synchronizedListMultimap__K = _py_TypeVar('_synchronizedListMultimap__K')  # <K>
    _synchronizedListMultimap__V = _py_TypeVar('_synchronizedListMultimap__V')  # <V>
    @classmethod
    def synchronizedListMultimap(cls, listMultimap: 'ListMultimap'[_synchronizedListMultimap__K, _synchronizedListMultimap__V]) -> 'ListMultimap'[_synchronizedListMultimap__K, _synchronizedListMultimap__V]: ...
    _synchronizedMultimap__K = _py_TypeVar('_synchronizedMultimap__K')  # <K>
    _synchronizedMultimap__V = _py_TypeVar('_synchronizedMultimap__V')  # <V>
    @classmethod
    def synchronizedMultimap(cls, multimap: Multimap[_synchronizedMultimap__K, _synchronizedMultimap__V]) -> Multimap[_synchronizedMultimap__K, _synchronizedMultimap__V]: ...
    _synchronizedSetMultimap__K = _py_TypeVar('_synchronizedSetMultimap__K')  # <K>
    _synchronizedSetMultimap__V = _py_TypeVar('_synchronizedSetMultimap__V')  # <V>
    @classmethod
    def synchronizedSetMultimap(cls, setMultimap: 'SetMultimap'[_synchronizedSetMultimap__K, _synchronizedSetMultimap__V]) -> 'SetMultimap'[_synchronizedSetMultimap__K, _synchronizedSetMultimap__V]: ...
    _synchronizedSortedSetMultimap__K = _py_TypeVar('_synchronizedSortedSetMultimap__K')  # <K>
    _synchronizedSortedSetMultimap__V = _py_TypeVar('_synchronizedSortedSetMultimap__V')  # <V>
    @classmethod
    def synchronizedSortedSetMultimap(cls, sortedSetMultimap: 'SortedSetMultimap'[_synchronizedSortedSetMultimap__K, _synchronizedSortedSetMultimap__V]) -> 'SortedSetMultimap'[_synchronizedSortedSetMultimap__K, _synchronizedSortedSetMultimap__V]: ...
    _toMultimap__T = _py_TypeVar('_toMultimap__T')  # <T>
    _toMultimap__K = _py_TypeVar('_toMultimap__K')  # <K>
    _toMultimap__V = _py_TypeVar('_toMultimap__V')  # <V>
    _toMultimap__M = _py_TypeVar('_toMultimap__M', bound=Multimap)  # <M>
    @classmethod
    def toMultimap(cls, function: java.util.function.Function[_toMultimap__T, _toMultimap__K], function2: java.util.function.Function[_toMultimap__T, _toMultimap__V], supplier: java.util.function.Supplier[_toMultimap__M]) -> java.util.stream.Collector[_toMultimap__T, _py_Any, _toMultimap__M]: ...
    _transformEntries_0__K = _py_TypeVar('_transformEntries_0__K')  # <K>
    _transformEntries_0__V1 = _py_TypeVar('_transformEntries_0__V1')  # <V1>
    _transformEntries_0__V2 = _py_TypeVar('_transformEntries_0__V2')  # <V2>
    @classmethod
    @overload
    def transformEntries(cls, listMultimap: 'ListMultimap'[_transformEntries_0__K, _transformEntries_0__V1], entryTransformer: Maps.EntryTransformer[_transformEntries_0__K, _transformEntries_0__V1, _transformEntries_0__V2]) -> 'ListMultimap'[_transformEntries_0__K, _transformEntries_0__V2]: ...
    _transformEntries_1__K = _py_TypeVar('_transformEntries_1__K')  # <K>
    _transformEntries_1__V1 = _py_TypeVar('_transformEntries_1__V1')  # <V1>
    _transformEntries_1__V2 = _py_TypeVar('_transformEntries_1__V2')  # <V2>
    @classmethod
    @overload
    def transformEntries(cls, multimap: Multimap[_transformEntries_1__K, _transformEntries_1__V1], entryTransformer: Maps.EntryTransformer[_transformEntries_1__K, _transformEntries_1__V1, _transformEntries_1__V2]) -> Multimap[_transformEntries_1__K, _transformEntries_1__V2]: ...
    _transformValues_0__K = _py_TypeVar('_transformValues_0__K')  # <K>
    _transformValues_0__V1 = _py_TypeVar('_transformValues_0__V1')  # <V1>
    _transformValues_0__V2 = _py_TypeVar('_transformValues_0__V2')  # <V2>
    @classmethod
    @overload
    def transformValues(cls, listMultimap: 'ListMultimap'[_transformValues_0__K, _transformValues_0__V1], function: com.google.common.base.Function[_transformValues_0__V1, _transformValues_0__V2]) -> 'ListMultimap'[_transformValues_0__K, _transformValues_0__V2]: ...
    _transformValues_1__K = _py_TypeVar('_transformValues_1__K')  # <K>
    _transformValues_1__V1 = _py_TypeVar('_transformValues_1__V1')  # <V1>
    _transformValues_1__V2 = _py_TypeVar('_transformValues_1__V2')  # <V2>
    @classmethod
    @overload
    def transformValues(cls, multimap: Multimap[_transformValues_1__K, _transformValues_1__V1], function: com.google.common.base.Function[_transformValues_1__V1, _transformValues_1__V2]) -> Multimap[_transformValues_1__K, _transformValues_1__V2]: ...
    _unmodifiableListMultimap_0__K = _py_TypeVar('_unmodifiableListMultimap_0__K')  # <K>
    _unmodifiableListMultimap_0__V = _py_TypeVar('_unmodifiableListMultimap_0__V')  # <V>
    @classmethod
    @overload
    def unmodifiableListMultimap(cls, immutableListMultimap: 'ImmutableListMultimap'[_unmodifiableListMultimap_0__K, _unmodifiableListMultimap_0__V]) -> 'ListMultimap'[_unmodifiableListMultimap_0__K, _unmodifiableListMultimap_0__V]: ...
    _unmodifiableListMultimap_1__K = _py_TypeVar('_unmodifiableListMultimap_1__K')  # <K>
    _unmodifiableListMultimap_1__V = _py_TypeVar('_unmodifiableListMultimap_1__V')  # <V>
    @classmethod
    @overload
    def unmodifiableListMultimap(cls, listMultimap: 'ListMultimap'[_unmodifiableListMultimap_1__K, _unmodifiableListMultimap_1__V]) -> 'ListMultimap'[_unmodifiableListMultimap_1__K, _unmodifiableListMultimap_1__V]: ...
    _unmodifiableMultimap_0__K = _py_TypeVar('_unmodifiableMultimap_0__K')  # <K>
    _unmodifiableMultimap_0__V = _py_TypeVar('_unmodifiableMultimap_0__V')  # <V>
    @classmethod
    @overload
    def unmodifiableMultimap(cls, immutableMultimap: 'ImmutableMultimap'[_unmodifiableMultimap_0__K, _unmodifiableMultimap_0__V]) -> Multimap[_unmodifiableMultimap_0__K, _unmodifiableMultimap_0__V]: ...
    _unmodifiableMultimap_1__K = _py_TypeVar('_unmodifiableMultimap_1__K')  # <K>
    _unmodifiableMultimap_1__V = _py_TypeVar('_unmodifiableMultimap_1__V')  # <V>
    @classmethod
    @overload
    def unmodifiableMultimap(cls, multimap: Multimap[_unmodifiableMultimap_1__K, _unmodifiableMultimap_1__V]) -> Multimap[_unmodifiableMultimap_1__K, _unmodifiableMultimap_1__V]: ...
    _unmodifiableSetMultimap_0__K = _py_TypeVar('_unmodifiableSetMultimap_0__K')  # <K>
    _unmodifiableSetMultimap_0__V = _py_TypeVar('_unmodifiableSetMultimap_0__V')  # <V>
    @classmethod
    @overload
    def unmodifiableSetMultimap(cls, immutableSetMultimap: 'ImmutableSetMultimap'[_unmodifiableSetMultimap_0__K, _unmodifiableSetMultimap_0__V]) -> 'SetMultimap'[_unmodifiableSetMultimap_0__K, _unmodifiableSetMultimap_0__V]: ...
    _unmodifiableSetMultimap_1__K = _py_TypeVar('_unmodifiableSetMultimap_1__K')  # <K>
    _unmodifiableSetMultimap_1__V = _py_TypeVar('_unmodifiableSetMultimap_1__V')  # <V>
    @classmethod
    @overload
    def unmodifiableSetMultimap(cls, setMultimap: 'SetMultimap'[_unmodifiableSetMultimap_1__K, _unmodifiableSetMultimap_1__V]) -> 'SetMultimap'[_unmodifiableSetMultimap_1__K, _unmodifiableSetMultimap_1__V]: ...
    _unmodifiableSortedSetMultimap__K = _py_TypeVar('_unmodifiableSortedSetMultimap__K')  # <K>
    _unmodifiableSortedSetMultimap__V = _py_TypeVar('_unmodifiableSortedSetMultimap__V')  # <V>
    @classmethod
    def unmodifiableSortedSetMultimap(cls, sortedSetMultimap: 'SortedSetMultimap'[_unmodifiableSortedSetMultimap__K, _unmodifiableSortedSetMultimap__V]) -> 'SortedSetMultimap'[_unmodifiableSortedSetMultimap__K, _unmodifiableSortedSetMultimap__V]: ...

_Multiset__Entry__E = _py_TypeVar('_Multiset__Entry__E')  # <E>
_Multiset__E = _py_TypeVar('_Multiset__E')  # <E>
class Multiset(java.util.Collection[_Multiset__E], _py_Generic[_Multiset__E]):
    @overload
    def add(self, e: _Multiset__E) -> bool: ...
    @overload
    def add(self, e: _Multiset__E, int: int) -> int: ...
    def contains(self, object: _py_Any) -> bool: ...
    def containsAll(self, collection: java.util.Collection[_py_Any]) -> bool: ...
    def count(self, object: _py_Any) -> int: ...
    def elementSet(self) -> java.util.Set[_Multiset__E]: ...
    def entrySet(self) -> java.util.Set['Multiset.Entry'[_Multiset__E]]: ...
    def equals(self, object: _py_Any) -> bool: ...
    def forEach(self, consumer: java.util.function.Consumer[_Multiset__E]) -> None: ...
    def forEachEntry(self, objIntConsumer: java.util.function.ObjIntConsumer[_Multiset__E]) -> None: ...
    def hashCode(self) -> int: ...
    def iterator(self) -> java.util.Iterator[_Multiset__E]: ...
    @overload
    def remove(self, object: _py_Any) -> bool: ...
    @overload
    def remove(self, object: _py_Any, int: int) -> int: ...
    def removeAll(self, collection: java.util.Collection[_py_Any]) -> bool: ...
    def retainAll(self, collection: java.util.Collection[_py_Any]) -> bool: ...
    @overload
    def setCount(self, e: _Multiset__E, int: int, int2: int) -> bool: ...
    @overload
    def setCount(self, e: _Multiset__E, int: int) -> int: ...
    def size(self) -> int: ...
    def spliterator(self) -> java.util.Spliterator[_Multiset__E]: ...
    def toString(self) -> str: ...
    class Entry(_py_Generic[_Multiset__Entry__E]):
        def equals(self, object: _py_Any) -> bool: ...
        def getCount(self) -> int: ...
        def getElement(self) -> _Multiset__Entry__E: ...
        def hashCode(self) -> int: ...
        def toString(self) -> str: ...

class Multisets:
    @classmethod
    def containsOccurrences(cls, multiset: Multiset[_py_Any], multiset2: Multiset[_py_Any]) -> bool: ...
    _copyHighestCountFirst__E = _py_TypeVar('_copyHighestCountFirst__E')  # <E>
    @classmethod
    def copyHighestCountFirst(cls, multiset: Multiset[_copyHighestCountFirst__E]) -> 'ImmutableMultiset'[_copyHighestCountFirst__E]: ...
    _difference__E = _py_TypeVar('_difference__E')  # <E>
    @classmethod
    def difference(cls, multiset: Multiset[_difference__E], multiset2: Multiset[_py_Any]) -> Multiset[_difference__E]: ...
    _filter__E = _py_TypeVar('_filter__E')  # <E>
    @classmethod
    def filter(cls, multiset: Multiset[_filter__E], predicate: com.google.common.base.Predicate[_filter__E]) -> Multiset[_filter__E]: ...
    _immutableEntry__E = _py_TypeVar('_immutableEntry__E')  # <E>
    @classmethod
    def immutableEntry(cls, e: _immutableEntry__E, int: int) -> Multiset.Entry[_immutableEntry__E]: ...
    _intersection__E = _py_TypeVar('_intersection__E')  # <E>
    @classmethod
    def intersection(cls, multiset: Multiset[_intersection__E], multiset2: Multiset[_py_Any]) -> Multiset[_intersection__E]: ...
    @classmethod
    @overload
    def removeOccurrences(cls, multiset: Multiset[_py_Any], multiset2: Multiset[_py_Any]) -> bool: ...
    @classmethod
    @overload
    def removeOccurrences(cls, multiset: Multiset[_py_Any], iterable: java.lang.Iterable[_py_Any]) -> bool: ...
    @classmethod
    def retainOccurrences(cls, multiset: Multiset[_py_Any], multiset2: Multiset[_py_Any]) -> bool: ...
    _sum__E = _py_TypeVar('_sum__E')  # <E>
    @classmethod
    def sum(cls, multiset: Multiset[_sum__E], multiset2: Multiset[_sum__E]) -> Multiset[_sum__E]: ...
    _toMultiset__T = _py_TypeVar('_toMultiset__T')  # <T>
    _toMultiset__E = _py_TypeVar('_toMultiset__E')  # <E>
    _toMultiset__M = _py_TypeVar('_toMultiset__M', bound=Multiset)  # <M>
    @classmethod
    def toMultiset(cls, function: java.util.function.Function[_toMultiset__T, _toMultiset__E], toIntFunction: java.util.function.ToIntFunction[_toMultiset__T], supplier: java.util.function.Supplier[_toMultiset__M]) -> java.util.stream.Collector[_toMultiset__T, _py_Any, _toMultiset__M]: ...
    _union__E = _py_TypeVar('_union__E')  # <E>
    @classmethod
    def union(cls, multiset: Multiset[_union__E], multiset2: Multiset[_union__E]) -> Multiset[_union__E]: ...
    _unmodifiableMultiset_0__E = _py_TypeVar('_unmodifiableMultiset_0__E')  # <E>
    @classmethod
    @overload
    def unmodifiableMultiset(cls, immutableMultiset: 'ImmutableMultiset'[_unmodifiableMultiset_0__E]) -> Multiset[_unmodifiableMultiset_0__E]: ...
    _unmodifiableMultiset_1__E = _py_TypeVar('_unmodifiableMultiset_1__E')  # <E>
    @classmethod
    @overload
    def unmodifiableMultiset(cls, multiset: Multiset[_unmodifiableMultiset_1__E]) -> Multiset[_unmodifiableMultiset_1__E]: ...
    _unmodifiableSortedMultiset__E = _py_TypeVar('_unmodifiableSortedMultiset__E')  # <E>
    @classmethod
    def unmodifiableSortedMultiset(cls, sortedMultiset: 'SortedMultiset'[_unmodifiableSortedMultiset__E]) -> 'SortedMultiset'[_unmodifiableSortedMultiset__E]: ...

class ObjectArrays:
    _concat_0__T = _py_TypeVar('_concat_0__T')  # <T>
    @classmethod
    @overload
    def concat(cls, t: _concat_0__T, tArray: _py_List[_concat_0__T]) -> _py_List[_concat_0__T]: ...
    _concat_1__T = _py_TypeVar('_concat_1__T')  # <T>
    @classmethod
    @overload
    def concat(cls, tArray: _py_List[_concat_1__T], t2: _concat_1__T) -> _py_List[_concat_1__T]: ...
    _concat_2__T = _py_TypeVar('_concat_2__T')  # <T>
    @classmethod
    @overload
    def concat(cls, tArray: _py_List[_concat_2__T], tArray2: _py_List[_concat_2__T], class_: _py_Type[_concat_2__T]) -> _py_List[_concat_2__T]: ...
    _newArray_0__T = _py_TypeVar('_newArray_0__T')  # <T>
    @classmethod
    @overload
    def newArray(cls, class_: _py_Type[_newArray_0__T], int: int) -> _py_List[_newArray_0__T]: ...
    _newArray_1__T = _py_TypeVar('_newArray_1__T')  # <T>
    @classmethod
    @overload
    def newArray(cls, tArray: _py_List[_newArray_1__T], int: int) -> _py_List[_newArray_1__T]: ...

_Ordering__T = _py_TypeVar('_Ordering__T')  # <T>
class Ordering(java.util.Comparator[_Ordering__T], _py_Generic[_Ordering__T]):
    @classmethod
    def allEqual(cls) -> 'Ordering'[_py_Any]: ...
    @classmethod
    def arbitrary(cls) -> 'Ordering'[_py_Any]: ...
    def binarySearch(self, list: java.util.List[_Ordering__T], t: _Ordering__T) -> int: ...
    def compare(self, t: _Ordering__T, t2: _Ordering__T) -> int: ...
    _compound_0__U = _py_TypeVar('_compound_0__U')  # <U>
    @overload
    def compound(self, comparator: java.util.Comparator[_compound_0__U]) -> 'Ordering'[_compound_0__U]: ...
    _compound_1__T = _py_TypeVar('_compound_1__T')  # <T>
    @classmethod
    @overload
    def compound(cls, iterable: java.lang.Iterable[java.util.Comparator[_compound_1__T]]) -> 'Ordering'[_compound_1__T]: ...
    _explicit_0__T = _py_TypeVar('_explicit_0__T')  # <T>
    @classmethod
    @overload
    def explicit(cls, t: _explicit_0__T, tArray: _py_List[_explicit_0__T]) -> 'Ordering'[_explicit_0__T]: ...
    _explicit_1__T = _py_TypeVar('_explicit_1__T')  # <T>
    @classmethod
    @overload
    def explicit(cls, list: java.util.List[_explicit_1__T]) -> 'Ordering'[_explicit_1__T]: ...
    _greatestOf_0__E = _py_TypeVar('_greatestOf_0__E')  # <E>
    @overload
    def greatestOf(self, iterable: java.lang.Iterable[_greatestOf_0__E], int: int) -> java.util.List[_greatestOf_0__E]: ...
    _greatestOf_1__E = _py_TypeVar('_greatestOf_1__E')  # <E>
    @overload
    def greatestOf(self, iterator: java.util.Iterator[_greatestOf_1__E], int: int) -> java.util.List[_greatestOf_1__E]: ...
    _immutableSortedCopy__E = _py_TypeVar('_immutableSortedCopy__E')  # <E>
    def immutableSortedCopy(self, iterable: java.lang.Iterable[_immutableSortedCopy__E]) -> 'ImmutableList'[_immutableSortedCopy__E]: ...
    def isOrdered(self, iterable: java.lang.Iterable[_Ordering__T]) -> bool: ...
    def isStrictlyOrdered(self, iterable: java.lang.Iterable[_Ordering__T]) -> bool: ...
    _leastOf_0__E = _py_TypeVar('_leastOf_0__E')  # <E>
    @overload
    def leastOf(self, iterable: java.lang.Iterable[_leastOf_0__E], int: int) -> java.util.List[_leastOf_0__E]: ...
    _leastOf_1__E = _py_TypeVar('_leastOf_1__E')  # <E>
    @overload
    def leastOf(self, iterator: java.util.Iterator[_leastOf_1__E], int: int) -> java.util.List[_leastOf_1__E]: ...
    _lexicographical__S = _py_TypeVar('_lexicographical__S')  # <S>
    def lexicographical(self) -> 'Ordering'[java.lang.Iterable[_lexicographical__S]]: ...
    _max_0__E = _py_TypeVar('_max_0__E')  # <E>
    @overload
    def max(self, iterable: java.lang.Iterable[_max_0__E]) -> _max_0__E: ...
    _max_1__E = _py_TypeVar('_max_1__E')  # <E>
    @overload
    def max(self, e: _max_1__E, e2: _max_1__E) -> _max_1__E: ...
    _max_2__E = _py_TypeVar('_max_2__E')  # <E>
    @overload
    def max(self, e: _max_2__E, e2: _max_2__E, e3: _max_2__E, eArray: _py_List[_max_2__E]) -> _max_2__E: ...
    _max_3__E = _py_TypeVar('_max_3__E')  # <E>
    @overload
    def max(self, iterator: java.util.Iterator[_max_3__E]) -> _max_3__E: ...
    _min_0__E = _py_TypeVar('_min_0__E')  # <E>
    @overload
    def min(self, iterable: java.lang.Iterable[_min_0__E]) -> _min_0__E: ...
    _min_1__E = _py_TypeVar('_min_1__E')  # <E>
    @overload
    def min(self, e: _min_1__E, e2: _min_1__E) -> _min_1__E: ...
    _min_2__E = _py_TypeVar('_min_2__E')  # <E>
    @overload
    def min(self, e: _min_2__E, e2: _min_2__E, e3: _min_2__E, eArray: _py_List[_min_2__E]) -> _min_2__E: ...
    _min_3__E = _py_TypeVar('_min_3__E')  # <E>
    @overload
    def min(self, iterator: java.util.Iterator[_min_3__E]) -> _min_3__E: ...
    _natural__C = _py_TypeVar('_natural__C', bound=java.lang.Comparable)  # <C>
    @classmethod
    def natural(cls) -> 'Ordering'[_natural__C]: ...
    _nullsFirst__S = _py_TypeVar('_nullsFirst__S')  # <S>
    def nullsFirst(self) -> 'Ordering'[_nullsFirst__S]: ...
    _nullsLast__S = _py_TypeVar('_nullsLast__S')  # <S>
    def nullsLast(self) -> 'Ordering'[_nullsLast__S]: ...
    _onResultOf__F = _py_TypeVar('_onResultOf__F')  # <F>
    def onResultOf(self, function: com.google.common.base.Function[_onResultOf__F, _Ordering__T]) -> 'Ordering'[_onResultOf__F]: ...
    _reverse__S = _py_TypeVar('_reverse__S')  # <S>
    def reverse(self) -> 'Ordering'[_reverse__S]: ...
    _sortedCopy__E = _py_TypeVar('_sortedCopy__E')  # <E>
    def sortedCopy(self, iterable: java.lang.Iterable[_sortedCopy__E]) -> java.util.List[_sortedCopy__E]: ...
    @classmethod
    def usingToString(cls) -> 'Ordering'[_py_Any]: ...

_PeekingIterator__E = _py_TypeVar('_PeekingIterator__E')  # <E>
class PeekingIterator(java.util.Iterator[_PeekingIterator__E], _py_Generic[_PeekingIterator__E]):
    def next(self) -> _PeekingIterator__E: ...
    def peek(self) -> _PeekingIterator__E: ...
    def remove(self) -> None: ...

class Platform: ...

class Queues:
    _drain_0__E = _py_TypeVar('_drain_0__E')  # <E>
    @classmethod
    @overload
    def drain(cls, blockingQueue: java.util.concurrent.BlockingQueue[_drain_0__E], collection: java.util.Collection[_drain_0__E], int: int, duration: java.time.Duration) -> int: ...
    _drain_1__E = _py_TypeVar('_drain_1__E')  # <E>
    @classmethod
    @overload
    def drain(cls, blockingQueue: java.util.concurrent.BlockingQueue[_drain_1__E], collection: java.util.Collection[_drain_1__E], int: int, long: int, timeUnit: java.util.concurrent.TimeUnit) -> int: ...
    _drainUninterruptibly_0__E = _py_TypeVar('_drainUninterruptibly_0__E')  # <E>
    @classmethod
    @overload
    def drainUninterruptibly(cls, blockingQueue: java.util.concurrent.BlockingQueue[_drainUninterruptibly_0__E], collection: java.util.Collection[_drainUninterruptibly_0__E], int: int, duration: java.time.Duration) -> int: ...
    _drainUninterruptibly_1__E = _py_TypeVar('_drainUninterruptibly_1__E')  # <E>
    @classmethod
    @overload
    def drainUninterruptibly(cls, blockingQueue: java.util.concurrent.BlockingQueue[_drainUninterruptibly_1__E], collection: java.util.Collection[_drainUninterruptibly_1__E], int: int, long: int, timeUnit: java.util.concurrent.TimeUnit) -> int: ...
    _newArrayBlockingQueue__E = _py_TypeVar('_newArrayBlockingQueue__E')  # <E>
    @classmethod
    def newArrayBlockingQueue(cls, int: int) -> java.util.concurrent.ArrayBlockingQueue[_newArrayBlockingQueue__E]: ...
    _newArrayDeque_0__E = _py_TypeVar('_newArrayDeque_0__E')  # <E>
    @classmethod
    @overload
    def newArrayDeque(cls) -> java.util.ArrayDeque[_newArrayDeque_0__E]: ...
    _newArrayDeque_1__E = _py_TypeVar('_newArrayDeque_1__E')  # <E>
    @classmethod
    @overload
    def newArrayDeque(cls, iterable: java.lang.Iterable[_newArrayDeque_1__E]) -> java.util.ArrayDeque[_newArrayDeque_1__E]: ...
    _newConcurrentLinkedQueue_0__E = _py_TypeVar('_newConcurrentLinkedQueue_0__E')  # <E>
    @classmethod
    @overload
    def newConcurrentLinkedQueue(cls) -> java.util.concurrent.ConcurrentLinkedQueue[_newConcurrentLinkedQueue_0__E]: ...
    _newConcurrentLinkedQueue_1__E = _py_TypeVar('_newConcurrentLinkedQueue_1__E')  # <E>
    @classmethod
    @overload
    def newConcurrentLinkedQueue(cls, iterable: java.lang.Iterable[_newConcurrentLinkedQueue_1__E]) -> java.util.concurrent.ConcurrentLinkedQueue[_newConcurrentLinkedQueue_1__E]: ...
    _newLinkedBlockingDeque_0__E = _py_TypeVar('_newLinkedBlockingDeque_0__E')  # <E>
    @classmethod
    @overload
    def newLinkedBlockingDeque(cls) -> java.util.concurrent.LinkedBlockingDeque[_newLinkedBlockingDeque_0__E]: ...
    _newLinkedBlockingDeque_1__E = _py_TypeVar('_newLinkedBlockingDeque_1__E')  # <E>
    @classmethod
    @overload
    def newLinkedBlockingDeque(cls, int: int) -> java.util.concurrent.LinkedBlockingDeque[_newLinkedBlockingDeque_1__E]: ...
    _newLinkedBlockingDeque_2__E = _py_TypeVar('_newLinkedBlockingDeque_2__E')  # <E>
    @classmethod
    @overload
    def newLinkedBlockingDeque(cls, iterable: java.lang.Iterable[_newLinkedBlockingDeque_2__E]) -> java.util.concurrent.LinkedBlockingDeque[_newLinkedBlockingDeque_2__E]: ...
    _newLinkedBlockingQueue_0__E = _py_TypeVar('_newLinkedBlockingQueue_0__E')  # <E>
    @classmethod
    @overload
    def newLinkedBlockingQueue(cls) -> java.util.concurrent.LinkedBlockingQueue[_newLinkedBlockingQueue_0__E]: ...
    _newLinkedBlockingQueue_1__E = _py_TypeVar('_newLinkedBlockingQueue_1__E')  # <E>
    @classmethod
    @overload
    def newLinkedBlockingQueue(cls, int: int) -> java.util.concurrent.LinkedBlockingQueue[_newLinkedBlockingQueue_1__E]: ...
    _newLinkedBlockingQueue_2__E = _py_TypeVar('_newLinkedBlockingQueue_2__E')  # <E>
    @classmethod
    @overload
    def newLinkedBlockingQueue(cls, iterable: java.lang.Iterable[_newLinkedBlockingQueue_2__E]) -> java.util.concurrent.LinkedBlockingQueue[_newLinkedBlockingQueue_2__E]: ...
    _newPriorityBlockingQueue_0__E = _py_TypeVar('_newPriorityBlockingQueue_0__E', bound=java.lang.Comparable)  # <E>
    @classmethod
    @overload
    def newPriorityBlockingQueue(cls) -> java.util.concurrent.PriorityBlockingQueue[_newPriorityBlockingQueue_0__E]: ...
    _newPriorityBlockingQueue_1__E = _py_TypeVar('_newPriorityBlockingQueue_1__E', bound=java.lang.Comparable)  # <E>
    @classmethod
    @overload
    def newPriorityBlockingQueue(cls, iterable: java.lang.Iterable[_newPriorityBlockingQueue_1__E]) -> java.util.concurrent.PriorityBlockingQueue[_newPriorityBlockingQueue_1__E]: ...
    _newPriorityQueue_0__E = _py_TypeVar('_newPriorityQueue_0__E', bound=java.lang.Comparable)  # <E>
    @classmethod
    @overload
    def newPriorityQueue(cls) -> java.util.PriorityQueue[_newPriorityQueue_0__E]: ...
    _newPriorityQueue_1__E = _py_TypeVar('_newPriorityQueue_1__E', bound=java.lang.Comparable)  # <E>
    @classmethod
    @overload
    def newPriorityQueue(cls, iterable: java.lang.Iterable[_newPriorityQueue_1__E]) -> java.util.PriorityQueue[_newPriorityQueue_1__E]: ...
    _newSynchronousQueue__E = _py_TypeVar('_newSynchronousQueue__E')  # <E>
    @classmethod
    def newSynchronousQueue(cls) -> java.util.concurrent.SynchronousQueue[_newSynchronousQueue__E]: ...
    _synchronizedDeque__E = _py_TypeVar('_synchronizedDeque__E')  # <E>
    @classmethod
    def synchronizedDeque(cls, deque: java.util.Deque[_synchronizedDeque__E]) -> java.util.Deque[_synchronizedDeque__E]: ...
    _synchronizedQueue__E = _py_TypeVar('_synchronizedQueue__E')  # <E>
    @classmethod
    def synchronizedQueue(cls, queue: java.util.Queue[_synchronizedQueue__E]) -> java.util.Queue[_synchronizedQueue__E]: ...

_RangeGwtSerializationDependencies__C = _py_TypeVar('_RangeGwtSerializationDependencies__C', bound=java.lang.Comparable)  # <C>
class RangeGwtSerializationDependencies(java.io.Serializable, _py_Generic[_RangeGwtSerializationDependencies__C]): ...

_RangeMap__K = _py_TypeVar('_RangeMap__K', bound=java.lang.Comparable)  # <K>
_RangeMap__V = _py_TypeVar('_RangeMap__V')  # <V>
class RangeMap(_py_Generic[_RangeMap__K, _RangeMap__V]):
    def asDescendingMapOfRanges(self) -> java.util.Map['Range'[_RangeMap__K], _RangeMap__V]: ...
    def asMapOfRanges(self) -> java.util.Map['Range'[_RangeMap__K], _RangeMap__V]: ...
    def clear(self) -> None: ...
    def equals(self, object: _py_Any) -> bool: ...
    def get(self, k: _RangeMap__K) -> _RangeMap__V: ...
    def getEntry(self, k: _RangeMap__K) -> java.util.Map.Entry['Range'[_RangeMap__K], _RangeMap__V]: ...
    def hashCode(self) -> int: ...
    def merge(self, range: 'Range'[_RangeMap__K], v: _RangeMap__V, biFunction: java.util.function.BiFunction[_RangeMap__V, _RangeMap__V, _RangeMap__V]) -> None: ...
    def put(self, range: 'Range'[_RangeMap__K], v: _RangeMap__V) -> None: ...
    def putAll(self, rangeMap: 'RangeMap'[_RangeMap__K, _RangeMap__V]) -> None: ...
    def putCoalescing(self, range: 'Range'[_RangeMap__K], v: _RangeMap__V) -> None: ...
    def remove(self, range: 'Range'[_RangeMap__K]) -> None: ...
    def span(self) -> 'Range'[_RangeMap__K]: ...
    def subRangeMap(self, range: 'Range'[_RangeMap__K]) -> 'RangeMap'[_RangeMap__K, _RangeMap__V]: ...
    def toString(self) -> str: ...

_RangeSet__C = _py_TypeVar('_RangeSet__C', bound=java.lang.Comparable)  # <C>
class RangeSet(_py_Generic[_RangeSet__C]):
    def add(self, range: 'Range'[_RangeSet__C]) -> None: ...
    @overload
    def addAll(self, rangeSet: 'RangeSet'[_RangeSet__C]) -> None: ...
    @overload
    def addAll(self, iterable: java.lang.Iterable['Range'[_RangeSet__C]]) -> None: ...
    def asDescendingSetOfRanges(self) -> java.util.Set['Range'[_RangeSet__C]]: ...
    def asRanges(self) -> java.util.Set['Range'[_RangeSet__C]]: ...
    def clear(self) -> None: ...
    def complement(self) -> 'RangeSet'[_RangeSet__C]: ...
    def contains(self, c: _RangeSet__C) -> bool: ...
    def encloses(self, range: 'Range'[_RangeSet__C]) -> bool: ...
    @overload
    def enclosesAll(self, rangeSet: 'RangeSet'[_RangeSet__C]) -> bool: ...
    @overload
    def enclosesAll(self, iterable: java.lang.Iterable['Range'[_RangeSet__C]]) -> bool: ...
    def equals(self, object: _py_Any) -> bool: ...
    def hashCode(self) -> int: ...
    def intersects(self, range: 'Range'[_RangeSet__C]) -> bool: ...
    def isEmpty(self) -> bool: ...
    def rangeContaining(self, c: _RangeSet__C) -> 'Range'[_RangeSet__C]: ...
    def remove(self, range: 'Range'[_RangeSet__C]) -> None: ...
    @overload
    def removeAll(self, rangeSet: 'RangeSet'[_RangeSet__C]) -> None: ...
    @overload
    def removeAll(self, iterable: java.lang.Iterable['Range'[_RangeSet__C]]) -> None: ...
    def span(self) -> 'Range'[_RangeSet__C]: ...
    def subRangeSet(self, range: 'Range'[_RangeSet__C]) -> 'RangeSet'[_RangeSet__C]: ...
    def toString(self) -> str: ...

class Serialization: ...

_Sets__SetView__E = _py_TypeVar('_Sets__SetView__E')  # <E>
class Sets:
    _cartesianProduct_0__B = _py_TypeVar('_cartesianProduct_0__B')  # <B>
    @classmethod
    @overload
    def cartesianProduct(cls, list: java.util.List[java.util.Set[_cartesianProduct_0__B]]) -> java.util.Set[java.util.List[_cartesianProduct_0__B]]: ...
    _cartesianProduct_1__B = _py_TypeVar('_cartesianProduct_1__B')  # <B>
    @classmethod
    @overload
    def cartesianProduct(cls, setArray: _py_List[java.util.Set[_cartesianProduct_1__B]]) -> java.util.Set[java.util.List[_cartesianProduct_1__B]]: ...
    _combinations__E = _py_TypeVar('_combinations__E')  # <E>
    @classmethod
    def combinations(cls, set: java.util.Set[_combinations__E], int: int) -> java.util.Set[java.util.Set[_combinations__E]]: ...
    _complementOf_0__E = _py_TypeVar('_complementOf_0__E', bound=java.lang.Enum)  # <E>
    @classmethod
    @overload
    def complementOf(cls, collection: java.util.Collection[_complementOf_0__E]) -> java.util.EnumSet[_complementOf_0__E]: ...
    _complementOf_1__E = _py_TypeVar('_complementOf_1__E', bound=java.lang.Enum)  # <E>
    @classmethod
    @overload
    def complementOf(cls, collection: java.util.Collection[_complementOf_1__E], class_: _py_Type[_complementOf_1__E]) -> java.util.EnumSet[_complementOf_1__E]: ...
    _difference__E = _py_TypeVar('_difference__E')  # <E>
    @classmethod
    def difference(cls, set: java.util.Set[_difference__E], set2: java.util.Set[_py_Any]) -> 'Sets.SetView'[_difference__E]: ...
    _filter_0__E = _py_TypeVar('_filter_0__E')  # <E>
    @classmethod
    @overload
    def filter(cls, navigableSet: java.util.NavigableSet[_filter_0__E], predicate: com.google.common.base.Predicate[_filter_0__E]) -> java.util.NavigableSet[_filter_0__E]: ...
    _filter_1__E = _py_TypeVar('_filter_1__E')  # <E>
    @classmethod
    @overload
    def filter(cls, set: java.util.Set[_filter_1__E], predicate: com.google.common.base.Predicate[_filter_1__E]) -> java.util.Set[_filter_1__E]: ...
    _filter_2__E = _py_TypeVar('_filter_2__E')  # <E>
    @classmethod
    @overload
    def filter(cls, sortedSet: java.util.SortedSet[_filter_2__E], predicate: com.google.common.base.Predicate[_filter_2__E]) -> java.util.SortedSet[_filter_2__E]: ...
    _immutableEnumSet_0__E = _py_TypeVar('_immutableEnumSet_0__E', bound=java.lang.Enum)  # <E>
    @classmethod
    @overload
    def immutableEnumSet(cls, e: _immutableEnumSet_0__E, eArray: _py_List[_immutableEnumSet_0__E]) -> 'ImmutableSet'[_immutableEnumSet_0__E]: ...
    _immutableEnumSet_1__E = _py_TypeVar('_immutableEnumSet_1__E', bound=java.lang.Enum)  # <E>
    @classmethod
    @overload
    def immutableEnumSet(cls, iterable: java.lang.Iterable[_immutableEnumSet_1__E]) -> 'ImmutableSet'[_immutableEnumSet_1__E]: ...
    _intersection__E = _py_TypeVar('_intersection__E')  # <E>
    @classmethod
    def intersection(cls, set: java.util.Set[_intersection__E], set2: java.util.Set[_py_Any]) -> 'Sets.SetView'[_intersection__E]: ...
    _newConcurrentHashSet_0__E = _py_TypeVar('_newConcurrentHashSet_0__E')  # <E>
    @classmethod
    @overload
    def newConcurrentHashSet(cls) -> java.util.Set[_newConcurrentHashSet_0__E]: ...
    _newConcurrentHashSet_1__E = _py_TypeVar('_newConcurrentHashSet_1__E')  # <E>
    @classmethod
    @overload
    def newConcurrentHashSet(cls, iterable: java.lang.Iterable[_newConcurrentHashSet_1__E]) -> java.util.Set[_newConcurrentHashSet_1__E]: ...
    _newCopyOnWriteArraySet_0__E = _py_TypeVar('_newCopyOnWriteArraySet_0__E')  # <E>
    @classmethod
    @overload
    def newCopyOnWriteArraySet(cls) -> java.util.concurrent.CopyOnWriteArraySet[_newCopyOnWriteArraySet_0__E]: ...
    _newCopyOnWriteArraySet_1__E = _py_TypeVar('_newCopyOnWriteArraySet_1__E')  # <E>
    @classmethod
    @overload
    def newCopyOnWriteArraySet(cls, iterable: java.lang.Iterable[_newCopyOnWriteArraySet_1__E]) -> java.util.concurrent.CopyOnWriteArraySet[_newCopyOnWriteArraySet_1__E]: ...
    _newEnumSet__E = _py_TypeVar('_newEnumSet__E', bound=java.lang.Enum)  # <E>
    @classmethod
    def newEnumSet(cls, iterable: java.lang.Iterable[_newEnumSet__E], class_: _py_Type[_newEnumSet__E]) -> java.util.EnumSet[_newEnumSet__E]: ...
    _newHashSet_0__E = _py_TypeVar('_newHashSet_0__E')  # <E>
    @classmethod
    @overload
    def newHashSet(cls) -> java.util.HashSet[_newHashSet_0__E]: ...
    _newHashSet_1__E = _py_TypeVar('_newHashSet_1__E')  # <E>
    @classmethod
    @overload
    def newHashSet(cls, iterable: java.lang.Iterable[_newHashSet_1__E]) -> java.util.HashSet[_newHashSet_1__E]: ...
    _newHashSet_2__E = _py_TypeVar('_newHashSet_2__E')  # <E>
    @classmethod
    @overload
    def newHashSet(cls, eArray: _py_List[_newHashSet_2__E]) -> java.util.HashSet[_newHashSet_2__E]: ...
    _newHashSet_3__E = _py_TypeVar('_newHashSet_3__E')  # <E>
    @classmethod
    @overload
    def newHashSet(cls, iterator: java.util.Iterator[_newHashSet_3__E]) -> java.util.HashSet[_newHashSet_3__E]: ...
    _newHashSetWithExpectedSize__E = _py_TypeVar('_newHashSetWithExpectedSize__E')  # <E>
    @classmethod
    def newHashSetWithExpectedSize(cls, int: int) -> java.util.HashSet[_newHashSetWithExpectedSize__E]: ...
    _newIdentityHashSet__E = _py_TypeVar('_newIdentityHashSet__E')  # <E>
    @classmethod
    def newIdentityHashSet(cls) -> java.util.Set[_newIdentityHashSet__E]: ...
    _newLinkedHashSet_0__E = _py_TypeVar('_newLinkedHashSet_0__E')  # <E>
    @classmethod
    @overload
    def newLinkedHashSet(cls) -> java.util.LinkedHashSet[_newLinkedHashSet_0__E]: ...
    _newLinkedHashSet_1__E = _py_TypeVar('_newLinkedHashSet_1__E')  # <E>
    @classmethod
    @overload
    def newLinkedHashSet(cls, iterable: java.lang.Iterable[_newLinkedHashSet_1__E]) -> java.util.LinkedHashSet[_newLinkedHashSet_1__E]: ...
    _newLinkedHashSetWithExpectedSize__E = _py_TypeVar('_newLinkedHashSetWithExpectedSize__E')  # <E>
    @classmethod
    def newLinkedHashSetWithExpectedSize(cls, int: int) -> java.util.LinkedHashSet[_newLinkedHashSetWithExpectedSize__E]: ...
    _newSetFromMap__E = _py_TypeVar('_newSetFromMap__E')  # <E>
    @classmethod
    def newSetFromMap(cls, map: java.util.Map[_newSetFromMap__E, bool]) -> java.util.Set[_newSetFromMap__E]: ...
    _newTreeSet_0__E = _py_TypeVar('_newTreeSet_0__E', bound=java.lang.Comparable)  # <E>
    @classmethod
    @overload
    def newTreeSet(cls) -> java.util.TreeSet[_newTreeSet_0__E]: ...
    _newTreeSet_1__E = _py_TypeVar('_newTreeSet_1__E', bound=java.lang.Comparable)  # <E>
    @classmethod
    @overload
    def newTreeSet(cls, iterable: java.lang.Iterable[_newTreeSet_1__E]) -> java.util.TreeSet[_newTreeSet_1__E]: ...
    _newTreeSet_2__E = _py_TypeVar('_newTreeSet_2__E')  # <E>
    @classmethod
    @overload
    def newTreeSet(cls, comparator: java.util.Comparator[_newTreeSet_2__E]) -> java.util.TreeSet[_newTreeSet_2__E]: ...
    _powerSet__E = _py_TypeVar('_powerSet__E')  # <E>
    @classmethod
    def powerSet(cls, set: java.util.Set[_powerSet__E]) -> java.util.Set[java.util.Set[_powerSet__E]]: ...
    _subSet__K = _py_TypeVar('_subSet__K', bound=java.lang.Comparable)  # <K>
    @classmethod
    def subSet(cls, navigableSet: java.util.NavigableSet[_subSet__K], range: 'Range'[_subSet__K]) -> java.util.NavigableSet[_subSet__K]: ...
    _symmetricDifference__E = _py_TypeVar('_symmetricDifference__E')  # <E>
    @classmethod
    def symmetricDifference(cls, set: java.util.Set[_symmetricDifference__E], set2: java.util.Set[_symmetricDifference__E]) -> 'Sets.SetView'[_symmetricDifference__E]: ...
    _synchronizedNavigableSet__E = _py_TypeVar('_synchronizedNavigableSet__E')  # <E>
    @classmethod
    def synchronizedNavigableSet(cls, navigableSet: java.util.NavigableSet[_synchronizedNavigableSet__E]) -> java.util.NavigableSet[_synchronizedNavigableSet__E]: ...
    _toImmutableEnumSet__E = _py_TypeVar('_toImmutableEnumSet__E', bound=java.lang.Enum)  # <E>
    @classmethod
    def toImmutableEnumSet(cls) -> java.util.stream.Collector[_toImmutableEnumSet__E, _py_Any, 'ImmutableSet'[_toImmutableEnumSet__E]]: ...
    _union__E = _py_TypeVar('_union__E')  # <E>
    @classmethod
    def union(cls, set: java.util.Set[_union__E], set2: java.util.Set[_union__E]) -> 'Sets.SetView'[_union__E]: ...
    _unmodifiableNavigableSet__E = _py_TypeVar('_unmodifiableNavigableSet__E')  # <E>
    @classmethod
    def unmodifiableNavigableSet(cls, navigableSet: java.util.NavigableSet[_unmodifiableNavigableSet__E]) -> java.util.NavigableSet[_unmodifiableNavigableSet__E]: ...
    class SetView(java.util.AbstractSet[_Sets__SetView__E], _py_Generic[_Sets__SetView__E]):
        def add(self, e: _Sets__SetView__E) -> bool: ...
        def addAll(self, collection: java.util.Collection[_Sets__SetView__E]) -> bool: ...
        def clear(self) -> None: ...
        _copyInto__S = _py_TypeVar('_copyInto__S', bound=java.util.Set)  # <S>
        def copyInto(self, s2: _copyInto__S) -> _copyInto__S: ...
        def immutableCopy(self) -> 'ImmutableSet'[_Sets__SetView__E]: ...
        @overload
        def iterator(self) -> 'UnmodifiableIterator'[_Sets__SetView__E]: ...
        @overload
        def iterator(self) -> java.util.Iterator: ...
        def remove(self, object: _py_Any) -> bool: ...
        def removeAll(self, collection: java.util.Collection[_py_Any]) -> bool: ...
        def removeIf(self, predicate: java.util.function.Predicate[_Sets__SetView__E]) -> bool: ...
        def retainAll(self, collection: java.util.Collection[_py_Any]) -> bool: ...

_SortedIterable__T = _py_TypeVar('_SortedIterable__T')  # <T>
class SortedIterable(java.lang.Iterable[_SortedIterable__T], _py_Generic[_SortedIterable__T]):
    def comparator(self) -> java.util.Comparator[_SortedIterable__T]: ...
    def iterator(self) -> java.util.Iterator[_SortedIterable__T]: ...

class SortedIterables:
    _comparator__E = _py_TypeVar('_comparator__E')  # <E>
    @classmethod
    def comparator(cls, sortedSet: java.util.SortedSet[_comparator__E]) -> java.util.Comparator[_comparator__E]: ...
    @classmethod
    def hasSameComparator(cls, comparator: java.util.Comparator[_py_Any], iterable: java.lang.Iterable[_py_Any]) -> bool: ...

class SortedLists:
    _binarySearch_0__E = _py_TypeVar('_binarySearch_0__E')  # <E>
    _binarySearch_0__K = _py_TypeVar('_binarySearch_0__K', bound=java.lang.Comparable)  # <K>
    @classmethod
    @overload
    def binarySearch(cls, list: java.util.List[_binarySearch_0__E], function: com.google.common.base.Function[_binarySearch_0__E, _binarySearch_0__K], k: _binarySearch_0__K, keyPresentBehavior: 'SortedLists.KeyPresentBehavior', keyAbsentBehavior: 'SortedLists.KeyAbsentBehavior') -> int: ...
    _binarySearch_1__E = _py_TypeVar('_binarySearch_1__E')  # <E>
    _binarySearch_1__K = _py_TypeVar('_binarySearch_1__K')  # <K>
    @classmethod
    @overload
    def binarySearch(cls, list: java.util.List[_binarySearch_1__E], function: com.google.common.base.Function[_binarySearch_1__E, _binarySearch_1__K], k: _binarySearch_1__K, comparator: java.util.Comparator[_binarySearch_1__K], keyPresentBehavior: 'SortedLists.KeyPresentBehavior', keyAbsentBehavior: 'SortedLists.KeyAbsentBehavior') -> int: ...
    _binarySearch_2__E = _py_TypeVar('_binarySearch_2__E', bound=java.lang.Comparable)  # <E>
    @classmethod
    @overload
    def binarySearch(cls, list: java.util.List[_binarySearch_2__E], e: _binarySearch_2__E, keyPresentBehavior: 'SortedLists.KeyPresentBehavior', keyAbsentBehavior: 'SortedLists.KeyAbsentBehavior') -> int: ...
    _binarySearch_3__E = _py_TypeVar('_binarySearch_3__E')  # <E>
    @classmethod
    @overload
    def binarySearch(cls, list: java.util.List[_binarySearch_3__E], e: _binarySearch_3__E, comparator: java.util.Comparator[_binarySearch_3__E], keyPresentBehavior: 'SortedLists.KeyPresentBehavior', keyAbsentBehavior: 'SortedLists.KeyAbsentBehavior') -> int: ...
    class KeyPresentBehavior(java.lang.Enum['SortedLists.KeyPresentBehavior']):
        ANY_PRESENT: _py_ClassVar['SortedLists.KeyPresentBehavior'] = ...
        LAST_PRESENT: _py_ClassVar['SortedLists.KeyPresentBehavior'] = ...
        FIRST_PRESENT: _py_ClassVar['SortedLists.KeyPresentBehavior'] = ...
        FIRST_AFTER: _py_ClassVar['SortedLists.KeyPresentBehavior'] = ...
        LAST_BEFORE: _py_ClassVar['SortedLists.KeyPresentBehavior'] = ...
        @classmethod
        @overload
        def valueOf(cls, string: str) -> 'SortedLists.KeyPresentBehavior': ...
        _valueOf_1__T = _py_TypeVar('_valueOf_1__T', bound=java.lang.Enum)  # <T>
        @classmethod
        @overload
        def valueOf(cls, class_: _py_Type[_valueOf_1__T], string: str) -> _valueOf_1__T: ...
        @classmethod
        def values(cls) -> _py_List['SortedLists.KeyPresentBehavior']: ...
    class KeyAbsentBehavior(java.lang.Enum['SortedLists.KeyAbsentBehavior']):
        NEXT_LOWER: _py_ClassVar['SortedLists.KeyAbsentBehavior'] = ...
        NEXT_HIGHER: _py_ClassVar['SortedLists.KeyAbsentBehavior'] = ...
        INVERTED_INSERTION_INDEX: _py_ClassVar['SortedLists.KeyAbsentBehavior'] = ...
        @classmethod
        @overload
        def valueOf(cls, string: str) -> 'SortedLists.KeyAbsentBehavior': ...
        _valueOf_1__T = _py_TypeVar('_valueOf_1__T', bound=java.lang.Enum)  # <T>
        @classmethod
        @overload
        def valueOf(cls, class_: _py_Type[_valueOf_1__T], string: str) -> _valueOf_1__T: ...
        @classmethod
        def values(cls) -> _py_List['SortedLists.KeyAbsentBehavior']: ...

class SortedMultisets: ...

_Streams__DoubleFunctionWithIndex__R = _py_TypeVar('_Streams__DoubleFunctionWithIndex__R')  # <R>
_Streams__FunctionWithIndex__T = _py_TypeVar('_Streams__FunctionWithIndex__T')  # <T>
_Streams__FunctionWithIndex__R = _py_TypeVar('_Streams__FunctionWithIndex__R')  # <R>
_Streams__IntFunctionWithIndex__R = _py_TypeVar('_Streams__IntFunctionWithIndex__R')  # <R>
_Streams__LongFunctionWithIndex__R = _py_TypeVar('_Streams__LongFunctionWithIndex__R')  # <R>
class Streams:
    @classmethod
    @overload
    def concat(cls, doubleStreamArray: _py_List[java.util.stream.DoubleStream]) -> java.util.stream.DoubleStream: ...
    @classmethod
    @overload
    def concat(cls, intStreamArray: _py_List[java.util.stream.IntStream]) -> java.util.stream.IntStream: ...
    @classmethod
    @overload
    def concat(cls, longStreamArray: _py_List[java.util.stream.LongStream]) -> java.util.stream.LongStream: ...
    _concat_3__T = _py_TypeVar('_concat_3__T')  # <T>
    @classmethod
    @overload
    def concat(cls, streamArray: _py_List[java.util.stream.Stream[_concat_3__T]]) -> java.util.stream.Stream[_concat_3__T]: ...
    _findLast_0__T = _py_TypeVar('_findLast_0__T')  # <T>
    @classmethod
    @overload
    def findLast(cls, stream: java.util.stream.Stream[_findLast_0__T]) -> java.util.Optional[_findLast_0__T]: ...
    @classmethod
    @overload
    def findLast(cls, doubleStream: java.util.stream.DoubleStream) -> java.util.OptionalDouble: ...
    @classmethod
    @overload
    def findLast(cls, intStream: java.util.stream.IntStream) -> java.util.OptionalInt: ...
    @classmethod
    @overload
    def findLast(cls, longStream: java.util.stream.LongStream) -> java.util.OptionalLong: ...
    _forEachPair__A = _py_TypeVar('_forEachPair__A')  # <A>
    _forEachPair__B = _py_TypeVar('_forEachPair__B')  # <B>
    @classmethod
    def forEachPair(cls, stream: java.util.stream.Stream[_forEachPair__A], stream2: java.util.stream.Stream[_forEachPair__B], biConsumer: java.util.function.BiConsumer[_forEachPair__A, _forEachPair__B]) -> None: ...
    _mapWithIndex_0__R = _py_TypeVar('_mapWithIndex_0__R')  # <R>
    @classmethod
    @overload
    def mapWithIndex(cls, doubleStream: java.util.stream.DoubleStream, doubleFunctionWithIndex: 'Streams.DoubleFunctionWithIndex'[_mapWithIndex_0__R]) -> java.util.stream.Stream[_mapWithIndex_0__R]: ...
    _mapWithIndex_1__R = _py_TypeVar('_mapWithIndex_1__R')  # <R>
    @classmethod
    @overload
    def mapWithIndex(cls, intStream: java.util.stream.IntStream, intFunctionWithIndex: 'Streams.IntFunctionWithIndex'[_mapWithIndex_1__R]) -> java.util.stream.Stream[_mapWithIndex_1__R]: ...
    _mapWithIndex_2__R = _py_TypeVar('_mapWithIndex_2__R')  # <R>
    @classmethod
    @overload
    def mapWithIndex(cls, longStream: java.util.stream.LongStream, longFunctionWithIndex: 'Streams.LongFunctionWithIndex'[_mapWithIndex_2__R]) -> java.util.stream.Stream[_mapWithIndex_2__R]: ...
    _mapWithIndex_3__T = _py_TypeVar('_mapWithIndex_3__T')  # <T>
    _mapWithIndex_3__R = _py_TypeVar('_mapWithIndex_3__R')  # <R>
    @classmethod
    @overload
    def mapWithIndex(cls, stream: java.util.stream.Stream[_mapWithIndex_3__T], functionWithIndex: 'Streams.FunctionWithIndex'[_mapWithIndex_3__T, _mapWithIndex_3__R]) -> java.util.stream.Stream[_mapWithIndex_3__R]: ...
    @classmethod
    @overload
    def stream(cls, optionalDouble: java.util.OptionalDouble) -> java.util.stream.DoubleStream: ...
    @classmethod
    @overload
    def stream(cls, optionalInt: java.util.OptionalInt) -> java.util.stream.IntStream: ...
    @classmethod
    @overload
    def stream(cls, optionalLong: java.util.OptionalLong) -> java.util.stream.LongStream: ...
    _stream_3__T = _py_TypeVar('_stream_3__T')  # <T>
    @classmethod
    @overload
    def stream(cls, optional: com.google.common.base.Optional[_stream_3__T]) -> java.util.stream.Stream[_stream_3__T]: ...
    _stream_4__T = _py_TypeVar('_stream_4__T')  # <T>
    @classmethod
    @overload
    def stream(cls, iterable: java.lang.Iterable[_stream_4__T]) -> java.util.stream.Stream[_stream_4__T]: ...
    _stream_5__T = _py_TypeVar('_stream_5__T')  # <T>
    @classmethod
    @overload
    def stream(cls, collection: java.util.Collection[_stream_5__T]) -> java.util.stream.Stream[_stream_5__T]: ...
    _stream_6__T = _py_TypeVar('_stream_6__T')  # <T>
    @classmethod
    @overload
    def stream(cls, iterator: java.util.Iterator[_stream_6__T]) -> java.util.stream.Stream[_stream_6__T]: ...
    _stream_7__T = _py_TypeVar('_stream_7__T')  # <T>
    @classmethod
    @overload
    def stream(cls, optional: java.util.Optional[_stream_7__T]) -> java.util.stream.Stream[_stream_7__T]: ...
    _zip__A = _py_TypeVar('_zip__A')  # <A>
    _zip__B = _py_TypeVar('_zip__B')  # <B>
    _zip__R = _py_TypeVar('_zip__R')  # <R>
    @classmethod
    def zip(cls, stream: java.util.stream.Stream[_zip__A], stream2: java.util.stream.Stream[_zip__B], biFunction: java.util.function.BiFunction[_zip__A, _zip__B, _zip__R]) -> java.util.stream.Stream[_zip__R]: ...
    class DoubleFunctionWithIndex(_py_Generic[_Streams__DoubleFunctionWithIndex__R]):
        def apply(self, double: float, long: int) -> _Streams__DoubleFunctionWithIndex__R: ...
    class FunctionWithIndex(_py_Generic[_Streams__FunctionWithIndex__T, _Streams__FunctionWithIndex__R]):
        def apply(self, t: _Streams__FunctionWithIndex__T, long: int) -> _Streams__FunctionWithIndex__R: ...
    class IntFunctionWithIndex(_py_Generic[_Streams__IntFunctionWithIndex__R]):
        def apply(self, int: int, long: int) -> _Streams__IntFunctionWithIndex__R: ...
    class LongFunctionWithIndex(_py_Generic[_Streams__LongFunctionWithIndex__R]):
        def apply(self, long: int, long2: int) -> _Streams__LongFunctionWithIndex__R: ...

class Synchronized: ...

_Table__Cell__R = _py_TypeVar('_Table__Cell__R')  # <R>
_Table__Cell__C = _py_TypeVar('_Table__Cell__C')  # <C>
_Table__Cell__V = _py_TypeVar('_Table__Cell__V')  # <V>
_Table__R = _py_TypeVar('_Table__R')  # <R>
_Table__C = _py_TypeVar('_Table__C')  # <C>
_Table__V = _py_TypeVar('_Table__V')  # <V>
class Table(_py_Generic[_Table__R, _Table__C, _Table__V]):
    def cellSet(self) -> java.util.Set['Table.Cell'[_Table__R, _Table__C, _Table__V]]: ...
    def clear(self) -> None: ...
    def column(self, c: _Table__C) -> java.util.Map[_Table__R, _Table__V]: ...
    def columnKeySet(self) -> java.util.Set[_Table__C]: ...
    def columnMap(self) -> java.util.Map[_Table__C, java.util.Map[_Table__R, _Table__V]]: ...
    def contains(self, object: _py_Any, object2: _py_Any) -> bool: ...
    def containsColumn(self, object: _py_Any) -> bool: ...
    def containsRow(self, object: _py_Any) -> bool: ...
    def containsValue(self, object: _py_Any) -> bool: ...
    def equals(self, object: _py_Any) -> bool: ...
    def get(self, object: _py_Any, object2: _py_Any) -> _Table__V: ...
    def hashCode(self) -> int: ...
    def isEmpty(self) -> bool: ...
    def put(self, r: _Table__R, c: _Table__C, v: _Table__V) -> _Table__V: ...
    def putAll(self, table: 'Table'[_Table__R, _Table__C, _Table__V]) -> None: ...
    def remove(self, object: _py_Any, object2: _py_Any) -> _Table__V: ...
    def row(self, r: _Table__R) -> java.util.Map[_Table__C, _Table__V]: ...
    def rowKeySet(self) -> java.util.Set[_Table__R]: ...
    def rowMap(self) -> java.util.Map[_Table__R, java.util.Map[_Table__C, _Table__V]]: ...
    def size(self) -> int: ...
    def values(self) -> java.util.Collection[_Table__V]: ...
    class Cell(_py_Generic[_Table__Cell__R, _Table__Cell__C, _Table__Cell__V]):
        def equals(self, object: _py_Any) -> bool: ...
        def getColumnKey(self) -> _Table__Cell__C: ...
        def getRowKey(self) -> _Table__Cell__R: ...
        def getValue(self) -> _Table__Cell__V: ...
        def hashCode(self) -> int: ...

class Tables:
    _immutableCell__R = _py_TypeVar('_immutableCell__R')  # <R>
    _immutableCell__C = _py_TypeVar('_immutableCell__C')  # <C>
    _immutableCell__V = _py_TypeVar('_immutableCell__V')  # <V>
    @classmethod
    def immutableCell(cls, r: _immutableCell__R, c2: _immutableCell__C, v: _immutableCell__V) -> Table.Cell[_immutableCell__R, _immutableCell__C, _immutableCell__V]: ...
    _newCustomTable__R = _py_TypeVar('_newCustomTable__R')  # <R>
    _newCustomTable__C = _py_TypeVar('_newCustomTable__C')  # <C>
    _newCustomTable__V = _py_TypeVar('_newCustomTable__V')  # <V>
    @classmethod
    def newCustomTable(cls, map: java.util.Map[_newCustomTable__R, java.util.Map[_newCustomTable__C, _newCustomTable__V]], supplier: com.google.common.base.Supplier[java.util.Map[_newCustomTable__C, _newCustomTable__V]]) -> Table[_newCustomTable__R, _newCustomTable__C, _newCustomTable__V]: ...
    _synchronizedTable__R = _py_TypeVar('_synchronizedTable__R')  # <R>
    _synchronizedTable__C = _py_TypeVar('_synchronizedTable__C')  # <C>
    _synchronizedTable__V = _py_TypeVar('_synchronizedTable__V')  # <V>
    @classmethod
    def synchronizedTable(cls, table: Table[_synchronizedTable__R, _synchronizedTable__C, _synchronizedTable__V]) -> Table[_synchronizedTable__R, _synchronizedTable__C, _synchronizedTable__V]: ...
    _toTable_0__T = _py_TypeVar('_toTable_0__T')  # <T>
    _toTable_0__R = _py_TypeVar('_toTable_0__R')  # <R>
    _toTable_0__C = _py_TypeVar('_toTable_0__C')  # <C>
    _toTable_0__V = _py_TypeVar('_toTable_0__V')  # <V>
    _toTable_0__I = _py_TypeVar('_toTable_0__I', bound=Table)  # <I>
    @classmethod
    @overload
    def toTable(cls, function: java.util.function.Function[_toTable_0__T, _toTable_0__R], function2: java.util.function.Function[_toTable_0__T, _toTable_0__C], function3: java.util.function.Function[_toTable_0__T, _toTable_0__V], binaryOperator: java.util.function.BinaryOperator[_toTable_0__V], supplier: java.util.function.Supplier[_toTable_0__I]) -> java.util.stream.Collector[_toTable_0__T, _py_Any, _toTable_0__I]: ...
    _toTable_1__T = _py_TypeVar('_toTable_1__T')  # <T>
    _toTable_1__R = _py_TypeVar('_toTable_1__R')  # <R>
    _toTable_1__C = _py_TypeVar('_toTable_1__C')  # <C>
    _toTable_1__V = _py_TypeVar('_toTable_1__V')  # <V>
    _toTable_1__I = _py_TypeVar('_toTable_1__I', bound=Table)  # <I>
    @classmethod
    @overload
    def toTable(cls, function: java.util.function.Function[_toTable_1__T, _toTable_1__R], function2: java.util.function.Function[_toTable_1__T, _toTable_1__C], function3: java.util.function.Function[_toTable_1__T, _toTable_1__V], supplier: java.util.function.Supplier[_toTable_1__I]) -> java.util.stream.Collector[_toTable_1__T, _py_Any, _toTable_1__I]: ...
    _transformValues__R = _py_TypeVar('_transformValues__R')  # <R>
    _transformValues__C = _py_TypeVar('_transformValues__C')  # <C>
    _transformValues__V1 = _py_TypeVar('_transformValues__V1')  # <V1>
    _transformValues__V2 = _py_TypeVar('_transformValues__V2')  # <V2>
    @classmethod
    def transformValues(cls, table: Table[_transformValues__R, _transformValues__C, _transformValues__V1], function: com.google.common.base.Function[_transformValues__V1, _transformValues__V2]) -> Table[_transformValues__R, _transformValues__C, _transformValues__V2]: ...
    _transpose__R = _py_TypeVar('_transpose__R')  # <R>
    _transpose__C = _py_TypeVar('_transpose__C')  # <C>
    _transpose__V = _py_TypeVar('_transpose__V')  # <V>
    @classmethod
    def transpose(cls, table: Table[_transpose__R, _transpose__C, _transpose__V]) -> Table[_transpose__C, _transpose__R, _transpose__V]: ...
    _unmodifiableRowSortedTable__R = _py_TypeVar('_unmodifiableRowSortedTable__R')  # <R>
    _unmodifiableRowSortedTable__C = _py_TypeVar('_unmodifiableRowSortedTable__C')  # <C>
    _unmodifiableRowSortedTable__V = _py_TypeVar('_unmodifiableRowSortedTable__V')  # <V>
    @classmethod
    def unmodifiableRowSortedTable(cls, rowSortedTable: 'RowSortedTable'[_unmodifiableRowSortedTable__R, _unmodifiableRowSortedTable__C, _unmodifiableRowSortedTable__V]) -> 'RowSortedTable'[_unmodifiableRowSortedTable__R, _unmodifiableRowSortedTable__C, _unmodifiableRowSortedTable__V]: ...
    _unmodifiableTable__R = _py_TypeVar('_unmodifiableTable__R')  # <R>
    _unmodifiableTable__C = _py_TypeVar('_unmodifiableTable__C')  # <C>
    _unmodifiableTable__V = _py_TypeVar('_unmodifiableTable__V')  # <V>
    @classmethod
    def unmodifiableTable(cls, table: Table[_unmodifiableTable__R, _unmodifiableTable__C, _unmodifiableTable__V]) -> Table[_unmodifiableTable__R, _unmodifiableTable__C, _unmodifiableTable__V]: ...

_TopKSelector__T = _py_TypeVar('_TopKSelector__T')  # <T>
class TopKSelector(_py_Generic[_TopKSelector__T]):
    _greatest_0__T = _py_TypeVar('_greatest_0__T', bound=java.lang.Comparable)  # <T>
    @classmethod
    @overload
    def greatest(cls, int: int) -> 'TopKSelector'[_greatest_0__T]: ...
    _greatest_1__T = _py_TypeVar('_greatest_1__T')  # <T>
    @classmethod
    @overload
    def greatest(cls, int: int, comparator: java.util.Comparator[_greatest_1__T]) -> 'TopKSelector'[_greatest_1__T]: ...
    _least_0__T = _py_TypeVar('_least_0__T', bound=java.lang.Comparable)  # <T>
    @classmethod
    @overload
    def least(cls, int: int) -> 'TopKSelector'[_least_0__T]: ...
    _least_1__T = _py_TypeVar('_least_1__T')  # <T>
    @classmethod
    @overload
    def least(cls, int: int, comparator: java.util.Comparator[_least_1__T]) -> 'TopKSelector'[_least_1__T]: ...
    def offer(self, t: _TopKSelector__T) -> None: ...
    @overload
    def offerAll(self, iterable: java.lang.Iterable[_TopKSelector__T]) -> None: ...
    @overload
    def offerAll(self, iterator: java.util.Iterator[_TopKSelector__T]) -> None: ...
    def topK(self) -> java.util.List[_TopKSelector__T]: ...

_TransformedIterator__F = _py_TypeVar('_TransformedIterator__F')  # <F>
_TransformedIterator__T = _py_TypeVar('_TransformedIterator__T')  # <T>
class TransformedIterator(java.util.Iterator[_TransformedIterator__T], _py_Generic[_TransformedIterator__F, _TransformedIterator__T]):
    def hasNext(self) -> bool: ...
    def next(self) -> _TransformedIterator__T: ...
    def remove(self) -> None: ...

_TreeTraverser__T = _py_TypeVar('_TreeTraverser__T')  # <T>
class TreeTraverser(_py_Generic[_TreeTraverser__T]):
    def __init__(self): ...
    def breadthFirstTraversal(self, t: _TreeTraverser__T) -> FluentIterable[_TreeTraverser__T]: ...
    def children(self, t: _TreeTraverser__T) -> java.lang.Iterable[_TreeTraverser__T]: ...
    def postOrderTraversal(self, t: _TreeTraverser__T) -> FluentIterable[_TreeTraverser__T]: ...
    def preOrderTraversal(self, t: _TreeTraverser__T) -> FluentIterable[_TreeTraverser__T]: ...
    _using__T = _py_TypeVar('_using__T')  # <T>
    @classmethod
    def using(cls, function: com.google.common.base.Function[_using__T, java.lang.Iterable[_using__T]]) -> 'TreeTraverser'[_using__T]: ...

_UnmodifiableIterator__E = _py_TypeVar('_UnmodifiableIterator__E')  # <E>
class UnmodifiableIterator(java.util.Iterator[_UnmodifiableIterator__E], _py_Generic[_UnmodifiableIterator__E]):
    def remove(self) -> None: ...

_AbstractIterator__T = _py_TypeVar('_AbstractIterator__T')  # <T>
class AbstractIterator(UnmodifiableIterator[_AbstractIterator__T], _py_Generic[_AbstractIterator__T]):
    def hasNext(self) -> bool: ...
    def next(self) -> _AbstractIterator__T: ...
    def peek(self) -> _AbstractIterator__T: ...

_AbstractMultimap__K = _py_TypeVar('_AbstractMultimap__K')  # <K>
_AbstractMultimap__V = _py_TypeVar('_AbstractMultimap__V')  # <V>
class AbstractMultimap(Multimap[_AbstractMultimap__K, _AbstractMultimap__V], _py_Generic[_AbstractMultimap__K, _AbstractMultimap__V]):
    def asMap(self) -> java.util.Map[_AbstractMultimap__K, java.util.Collection[_AbstractMultimap__V]]: ...
    def containsEntry(self, object: _py_Any, object2: _py_Any) -> bool: ...
    def containsValue(self, object: _py_Any) -> bool: ...
    def entries(self) -> java.util.Collection[java.util.Map.Entry[_AbstractMultimap__K, _AbstractMultimap__V]]: ...
    def equals(self, object: _py_Any) -> bool: ...
    def hashCode(self) -> int: ...
    def isEmpty(self) -> bool: ...
    def keySet(self) -> java.util.Set[_AbstractMultimap__K]: ...
    def keys(self) -> Multiset[_AbstractMultimap__K]: ...
    def put(self, k: _AbstractMultimap__K, v: _AbstractMultimap__V) -> bool: ...
    @overload
    def putAll(self, multimap: Multimap[_AbstractMultimap__K, _AbstractMultimap__V]) -> bool: ...
    @overload
    def putAll(self, k: _AbstractMultimap__K, iterable: java.lang.Iterable[_AbstractMultimap__V]) -> bool: ...
    def remove(self, object: _py_Any, object2: _py_Any) -> bool: ...
    def replaceValues(self, k: _AbstractMultimap__K, iterable: java.lang.Iterable[_AbstractMultimap__V]) -> java.util.Collection[_AbstractMultimap__V]: ...
    def toString(self) -> str: ...
    def values(self) -> java.util.Collection[_AbstractMultimap__V]: ...

_AbstractMultiset__E = _py_TypeVar('_AbstractMultiset__E')  # <E>
class AbstractMultiset(java.util.AbstractCollection[_AbstractMultiset__E], Multiset[_AbstractMultiset__E], _py_Generic[_AbstractMultiset__E]):
    @overload
    def add(self, e: _AbstractMultiset__E) -> bool: ...
    @overload
    def add(self, e: _AbstractMultiset__E, int: int) -> int: ...
    def addAll(self, collection: java.util.Collection[_AbstractMultiset__E]) -> bool: ...
    def clear(self) -> None: ...
    def contains(self, object: _py_Any) -> bool: ...
    def elementSet(self) -> java.util.Set[_AbstractMultiset__E]: ...
    def entrySet(self) -> java.util.Set[Multiset.Entry[_AbstractMultiset__E]]: ...
    def equals(self, object: _py_Any) -> bool: ...
    def hashCode(self) -> int: ...
    def isEmpty(self) -> bool: ...
    @overload
    def remove(self, object: _py_Any) -> bool: ...
    @overload
    def remove(self, object: _py_Any, int: int) -> int: ...
    def removeAll(self, collection: java.util.Collection[_py_Any]) -> bool: ...
    def retainAll(self, collection: java.util.Collection[_py_Any]) -> bool: ...
    @overload
    def setCount(self, e: _AbstractMultiset__E, int: int, int2: int) -> bool: ...
    @overload
    def setCount(self, e: _AbstractMultiset__E, int: int) -> int: ...
    def toString(self) -> str: ...

_AbstractRangeSet__C = _py_TypeVar('_AbstractRangeSet__C', bound=java.lang.Comparable)  # <C>
class AbstractRangeSet(RangeSet[_AbstractRangeSet__C], _py_Generic[_AbstractRangeSet__C]):
    def add(self, range: 'Range'[_AbstractRangeSet__C]) -> None: ...
    @overload
    def addAll(self, iterable: java.lang.Iterable['Range'[_AbstractRangeSet__C]]) -> None: ...
    @overload
    def addAll(self, rangeSet: RangeSet[_AbstractRangeSet__C]) -> None: ...
    def clear(self) -> None: ...
    def contains(self, c: _AbstractRangeSet__C) -> bool: ...
    def encloses(self, range: 'Range'[_AbstractRangeSet__C]) -> bool: ...
    @overload
    def enclosesAll(self, rangeSet: RangeSet[_AbstractRangeSet__C]) -> bool: ...
    @overload
    def enclosesAll(self, iterable: java.lang.Iterable['Range'[_AbstractRangeSet__C]]) -> bool: ...
    def equals(self, object: _py_Any) -> bool: ...
    def hashCode(self) -> int: ...
    def intersects(self, range: 'Range'[_AbstractRangeSet__C]) -> bool: ...
    def isEmpty(self) -> bool: ...
    def rangeContaining(self, c: _AbstractRangeSet__C) -> 'Range'[_AbstractRangeSet__C]: ...
    def remove(self, range: 'Range'[_AbstractRangeSet__C]) -> None: ...
    @overload
    def removeAll(self, iterable: java.lang.Iterable['Range'[_AbstractRangeSet__C]]) -> None: ...
    @overload
    def removeAll(self, rangeSet: RangeSet[_AbstractRangeSet__C]) -> None: ...
    def toString(self) -> str: ...

_AbstractSequentialIterator__T = _py_TypeVar('_AbstractSequentialIterator__T')  # <T>
class AbstractSequentialIterator(UnmodifiableIterator[_AbstractSequentialIterator__T], _py_Generic[_AbstractSequentialIterator__T]):
    def hasNext(self) -> bool: ...
    def next(self) -> _AbstractSequentialIterator__T: ...

_AbstractTable__R = _py_TypeVar('_AbstractTable__R')  # <R>
_AbstractTable__C = _py_TypeVar('_AbstractTable__C')  # <C>
_AbstractTable__V = _py_TypeVar('_AbstractTable__V')  # <V>
class AbstractTable(Table[_AbstractTable__R, _AbstractTable__C, _AbstractTable__V], _py_Generic[_AbstractTable__R, _AbstractTable__C, _AbstractTable__V]):
    def cellSet(self) -> java.util.Set[Table.Cell[_AbstractTable__R, _AbstractTable__C, _AbstractTable__V]]: ...
    def clear(self) -> None: ...
    def columnKeySet(self) -> java.util.Set[_AbstractTable__C]: ...
    def contains(self, object: _py_Any, object2: _py_Any) -> bool: ...
    def containsColumn(self, object: _py_Any) -> bool: ...
    def containsRow(self, object: _py_Any) -> bool: ...
    def containsValue(self, object: _py_Any) -> bool: ...
    def equals(self, object: _py_Any) -> bool: ...
    def get(self, object: _py_Any, object2: _py_Any) -> _AbstractTable__V: ...
    def hashCode(self) -> int: ...
    def isEmpty(self) -> bool: ...
    def put(self, r: _AbstractTable__R, c: _AbstractTable__C, v: _AbstractTable__V) -> _AbstractTable__V: ...
    def putAll(self, table: Table[_AbstractTable__R, _AbstractTable__C, _AbstractTable__V]) -> None: ...
    def remove(self, object: _py_Any, object2: _py_Any) -> _AbstractTable__V: ...
    def rowKeySet(self) -> java.util.Set[_AbstractTable__R]: ...
    def toString(self) -> str: ...
    def values(self) -> java.util.Collection[_AbstractTable__V]: ...

class AllEqualOrdering(Ordering[_py_Any], java.io.Serializable):
    def compare(self, object: _py_Any, object2: _py_Any) -> int: ...
    _immutableSortedCopy__E = _py_TypeVar('_immutableSortedCopy__E')  # <E>
    def immutableSortedCopy(self, iterable: java.lang.Iterable[_immutableSortedCopy__E]) -> 'ImmutableList'[_immutableSortedCopy__E]: ...
    _reverse__S = _py_TypeVar('_reverse__S')  # <S>
    def reverse(self) -> Ordering[_reverse__S]: ...
    _sortedCopy__E = _py_TypeVar('_sortedCopy__E')  # <E>
    def sortedCopy(self, iterable: java.lang.Iterable[_sortedCopy__E]) -> java.util.List[_sortedCopy__E]: ...
    def toString(self) -> str: ...

_ByFunctionOrdering__F = _py_TypeVar('_ByFunctionOrdering__F')  # <F>
_ByFunctionOrdering__T = _py_TypeVar('_ByFunctionOrdering__T')  # <T>
class ByFunctionOrdering(Ordering[_ByFunctionOrdering__F], java.io.Serializable, _py_Generic[_ByFunctionOrdering__F, _ByFunctionOrdering__T]):
    def compare(self, f: _ByFunctionOrdering__F, f2: _ByFunctionOrdering__F) -> int: ...
    def equals(self, object: _py_Any) -> bool: ...
    def hashCode(self) -> int: ...
    def toString(self) -> str: ...

_CompactLinkedHashMap__K = _py_TypeVar('_CompactLinkedHashMap__K')  # <K>
_CompactLinkedHashMap__V = _py_TypeVar('_CompactLinkedHashMap__V')  # <V>
class CompactLinkedHashMap(CompactHashMap[_CompactLinkedHashMap__K, _CompactLinkedHashMap__V], _py_Generic[_CompactLinkedHashMap__K, _CompactLinkedHashMap__V]):
    def clear(self) -> None: ...
    _create_0__K = _py_TypeVar('_create_0__K')  # <K>
    _create_0__V = _py_TypeVar('_create_0__V')  # <V>
    @classmethod
    @overload
    def create(cls) -> CompactHashMap[_create_0__K, _create_0__V]: ...
    _create_1__K = _py_TypeVar('_create_1__K')  # <K>
    _create_1__V = _py_TypeVar('_create_1__V')  # <V>
    @classmethod
    @overload
    def create(cls) -> 'CompactLinkedHashMap'[_create_1__K, _create_1__V]: ...
    _createWithExpectedSize_0__K = _py_TypeVar('_createWithExpectedSize_0__K')  # <K>
    _createWithExpectedSize_0__V = _py_TypeVar('_createWithExpectedSize_0__V')  # <V>
    @classmethod
    @overload
    def createWithExpectedSize(cls, int: int) -> CompactHashMap[_createWithExpectedSize_0__K, _createWithExpectedSize_0__V]: ...
    _createWithExpectedSize_1__K = _py_TypeVar('_createWithExpectedSize_1__K')  # <K>
    _createWithExpectedSize_1__V = _py_TypeVar('_createWithExpectedSize_1__V')  # <V>
    @classmethod
    @overload
    def createWithExpectedSize(cls, int: int) -> 'CompactLinkedHashMap'[_createWithExpectedSize_1__K, _createWithExpectedSize_1__V]: ...

_CompactLinkedHashSet__E = _py_TypeVar('_CompactLinkedHashSet__E')  # <E>
class CompactLinkedHashSet(CompactHashSet[_CompactLinkedHashSet__E], _py_Generic[_CompactLinkedHashSet__E]):
    def clear(self) -> None: ...
    _create_0__E = _py_TypeVar('_create_0__E')  # <E>
    @classmethod
    @overload
    def create(cls) -> CompactHashSet[_create_0__E]: ...
    _create_1__E = _py_TypeVar('_create_1__E')  # <E>
    @classmethod
    @overload
    def create(cls, eArray: _py_List[_create_1__E]) -> CompactHashSet[_create_1__E]: ...
    _create_2__E = _py_TypeVar('_create_2__E')  # <E>
    @classmethod
    @overload
    def create(cls, collection: java.util.Collection[_create_2__E]) -> CompactHashSet[_create_2__E]: ...
    _create_3__E = _py_TypeVar('_create_3__E')  # <E>
    @classmethod
    @overload
    def create(cls) -> 'CompactLinkedHashSet'[_create_3__E]: ...
    _create_4__E = _py_TypeVar('_create_4__E')  # <E>
    @classmethod
    @overload
    def create(cls, eArray: _py_List[_create_4__E]) -> 'CompactLinkedHashSet'[_create_4__E]: ...
    _create_5__E = _py_TypeVar('_create_5__E')  # <E>
    @classmethod
    @overload
    def create(cls, collection: java.util.Collection[_create_5__E]) -> 'CompactLinkedHashSet'[_create_5__E]: ...
    _createWithExpectedSize_0__E = _py_TypeVar('_createWithExpectedSize_0__E')  # <E>
    @classmethod
    @overload
    def createWithExpectedSize(cls, int: int) -> CompactHashSet[_createWithExpectedSize_0__E]: ...
    _createWithExpectedSize_1__E = _py_TypeVar('_createWithExpectedSize_1__E')  # <E>
    @classmethod
    @overload
    def createWithExpectedSize(cls, int: int) -> 'CompactLinkedHashSet'[_createWithExpectedSize_1__E]: ...
    def spliterator(self) -> java.util.Spliterator[_CompactLinkedHashSet__E]: ...
    @overload
    def toArray(self) -> _py_List[_py_Any]: ...
    _toArray_1__T = _py_TypeVar('_toArray_1__T')  # <T>
    @overload
    def toArray(self, tArray: _py_List[_toArray_1__T]) -> _py_List[_toArray_1__T]: ...

_ComparatorOrdering__T = _py_TypeVar('_ComparatorOrdering__T')  # <T>
class ComparatorOrdering(Ordering[_ComparatorOrdering__T], java.io.Serializable, _py_Generic[_ComparatorOrdering__T]):
    def compare(self, t: _ComparatorOrdering__T, t2: _ComparatorOrdering__T) -> int: ...
    def equals(self, object: _py_Any) -> bool: ...
    def hashCode(self) -> int: ...
    def toString(self) -> str: ...

_CompoundOrdering__T = _py_TypeVar('_CompoundOrdering__T')  # <T>
class CompoundOrdering(Ordering[_CompoundOrdering__T], java.io.Serializable, _py_Generic[_CompoundOrdering__T]):
    def compare(self, t: _CompoundOrdering__T, t2: _CompoundOrdering__T) -> int: ...
    def equals(self, object: _py_Any) -> bool: ...
    def hashCode(self) -> int: ...
    def toString(self) -> str: ...

_ExplicitOrdering__T = _py_TypeVar('_ExplicitOrdering__T')  # <T>
class ExplicitOrdering(Ordering[_ExplicitOrdering__T], java.io.Serializable, _py_Generic[_ExplicitOrdering__T]):
    def compare(self, t: _ExplicitOrdering__T, t2: _ExplicitOrdering__T) -> int: ...
    def equals(self, object: _py_Any) -> bool: ...
    def hashCode(self) -> int: ...
    def toString(self) -> str: ...

_FilteredMultimap__K = _py_TypeVar('_FilteredMultimap__K')  # <K>
_FilteredMultimap__V = _py_TypeVar('_FilteredMultimap__V')  # <V>
class FilteredMultimap(Multimap[_FilteredMultimap__K, _FilteredMultimap__V], _py_Generic[_FilteredMultimap__K, _FilteredMultimap__V]):
    def entryPredicate(self) -> com.google.common.base.Predicate[java.util.Map.Entry[_FilteredMultimap__K, _FilteredMultimap__V]]: ...
    def equals(self, object: _py_Any) -> bool: ...
    def hashCode(self) -> int: ...
    def unfiltered(self) -> Multimap[_FilteredMultimap__K, _FilteredMultimap__V]: ...

_ForwardingCollection__E = _py_TypeVar('_ForwardingCollection__E')  # <E>
class ForwardingCollection(ForwardingObject, java.util.Collection[_ForwardingCollection__E], _py_Generic[_ForwardingCollection__E]):
    def add(self, e: _ForwardingCollection__E) -> bool: ...
    def addAll(self, collection: java.util.Collection[_ForwardingCollection__E]) -> bool: ...
    def clear(self) -> None: ...
    def contains(self, object: _py_Any) -> bool: ...
    def containsAll(self, collection: java.util.Collection[_py_Any]) -> bool: ...
    def isEmpty(self) -> bool: ...
    def iterator(self) -> java.util.Iterator[_ForwardingCollection__E]: ...
    def remove(self, object: _py_Any) -> bool: ...
    def removeAll(self, collection: java.util.Collection[_py_Any]) -> bool: ...
    def retainAll(self, collection: java.util.Collection[_py_Any]) -> bool: ...
    def size(self) -> int: ...
    @overload
    def toArray(self) -> _py_List[_py_Any]: ...
    _toArray_1__T = _py_TypeVar('_toArray_1__T')  # <T>
    @overload
    def toArray(self, tArray: _py_List[_toArray_1__T]) -> _py_List[_toArray_1__T]: ...

_ForwardingIterator__T = _py_TypeVar('_ForwardingIterator__T')  # <T>
class ForwardingIterator(ForwardingObject, java.util.Iterator[_ForwardingIterator__T], _py_Generic[_ForwardingIterator__T]):
    def hasNext(self) -> bool: ...
    def next(self) -> _ForwardingIterator__T: ...
    def remove(self) -> None: ...

_ForwardingMap__K = _py_TypeVar('_ForwardingMap__K')  # <K>
_ForwardingMap__V = _py_TypeVar('_ForwardingMap__V')  # <V>
class ForwardingMap(ForwardingObject, java.util.Map[_ForwardingMap__K, _ForwardingMap__V], _py_Generic[_ForwardingMap__K, _ForwardingMap__V]):
    def clear(self) -> None: ...
    def containsKey(self, object: _py_Any) -> bool: ...
    def containsValue(self, object: _py_Any) -> bool: ...
    def entrySet(self) -> java.util.Set[java.util.Map.Entry[_ForwardingMap__K, _ForwardingMap__V]]: ...
    def equals(self, object: _py_Any) -> bool: ...
    def get(self, object: _py_Any) -> _ForwardingMap__V: ...
    def hashCode(self) -> int: ...
    def isEmpty(self) -> bool: ...
    def keySet(self) -> java.util.Set[_ForwardingMap__K]: ...
    def put(self, k: _ForwardingMap__K, v: _ForwardingMap__V) -> _ForwardingMap__V: ...
    def putAll(self, map: java.util.Map[_ForwardingMap__K, _ForwardingMap__V]) -> None: ...
    @overload
    def remove(self, object: _py_Any, object2: _py_Any) -> bool: ...
    @overload
    def remove(self, object: _py_Any) -> _ForwardingMap__V: ...
    def size(self) -> int: ...
    def values(self) -> java.util.Collection[_ForwardingMap__V]: ...

_ForwardingMapEntry__K = _py_TypeVar('_ForwardingMapEntry__K')  # <K>
_ForwardingMapEntry__V = _py_TypeVar('_ForwardingMapEntry__V')  # <V>
class ForwardingMapEntry(ForwardingObject, java.util.Map.Entry[_ForwardingMapEntry__K, _ForwardingMapEntry__V], _py_Generic[_ForwardingMapEntry__K, _ForwardingMapEntry__V]):
    def equals(self, object: _py_Any) -> bool: ...
    def getKey(self) -> _ForwardingMapEntry__K: ...
    def getValue(self) -> _ForwardingMapEntry__V: ...
    def hashCode(self) -> int: ...
    def setValue(self, v: _ForwardingMapEntry__V) -> _ForwardingMapEntry__V: ...

_ForwardingMultimap__K = _py_TypeVar('_ForwardingMultimap__K')  # <K>
_ForwardingMultimap__V = _py_TypeVar('_ForwardingMultimap__V')  # <V>
class ForwardingMultimap(ForwardingObject, Multimap[_ForwardingMultimap__K, _ForwardingMultimap__V], _py_Generic[_ForwardingMultimap__K, _ForwardingMultimap__V]):
    def asMap(self) -> java.util.Map[_ForwardingMultimap__K, java.util.Collection[_ForwardingMultimap__V]]: ...
    def clear(self) -> None: ...
    def containsEntry(self, object: _py_Any, object2: _py_Any) -> bool: ...
    def containsKey(self, object: _py_Any) -> bool: ...
    def containsValue(self, object: _py_Any) -> bool: ...
    def entries(self) -> java.util.Collection[java.util.Map.Entry[_ForwardingMultimap__K, _ForwardingMultimap__V]]: ...
    def equals(self, object: _py_Any) -> bool: ...
    def get(self, k: _ForwardingMultimap__K) -> java.util.Collection[_ForwardingMultimap__V]: ...
    def hashCode(self) -> int: ...
    def isEmpty(self) -> bool: ...
    def keySet(self) -> java.util.Set[_ForwardingMultimap__K]: ...
    def keys(self) -> Multiset[_ForwardingMultimap__K]: ...
    def put(self, k: _ForwardingMultimap__K, v: _ForwardingMultimap__V) -> bool: ...
    @overload
    def putAll(self, multimap: Multimap[_ForwardingMultimap__K, _ForwardingMultimap__V]) -> bool: ...
    @overload
    def putAll(self, k: _ForwardingMultimap__K, iterable: java.lang.Iterable[_ForwardingMultimap__V]) -> bool: ...
    def remove(self, object: _py_Any, object2: _py_Any) -> bool: ...
    def removeAll(self, object: _py_Any) -> java.util.Collection[_ForwardingMultimap__V]: ...
    def replaceValues(self, k: _ForwardingMultimap__K, iterable: java.lang.Iterable[_ForwardingMultimap__V]) -> java.util.Collection[_ForwardingMultimap__V]: ...
    def size(self) -> int: ...
    def values(self) -> java.util.Collection[_ForwardingMultimap__V]: ...

_ForwardingTable__R = _py_TypeVar('_ForwardingTable__R')  # <R>
_ForwardingTable__C = _py_TypeVar('_ForwardingTable__C')  # <C>
_ForwardingTable__V = _py_TypeVar('_ForwardingTable__V')  # <V>
class ForwardingTable(ForwardingObject, Table[_ForwardingTable__R, _ForwardingTable__C, _ForwardingTable__V], _py_Generic[_ForwardingTable__R, _ForwardingTable__C, _ForwardingTable__V]):
    def cellSet(self) -> java.util.Set[Table.Cell[_ForwardingTable__R, _ForwardingTable__C, _ForwardingTable__V]]: ...
    def clear(self) -> None: ...
    def column(self, c: _ForwardingTable__C) -> java.util.Map[_ForwardingTable__R, _ForwardingTable__V]: ...
    def columnKeySet(self) -> java.util.Set[_ForwardingTable__C]: ...
    def columnMap(self) -> java.util.Map[_ForwardingTable__C, java.util.Map[_ForwardingTable__R, _ForwardingTable__V]]: ...
    def contains(self, object: _py_Any, object2: _py_Any) -> bool: ...
    def containsColumn(self, object: _py_Any) -> bool: ...
    def containsRow(self, object: _py_Any) -> bool: ...
    def containsValue(self, object: _py_Any) -> bool: ...
    def equals(self, object: _py_Any) -> bool: ...
    def get(self, object: _py_Any, object2: _py_Any) -> _ForwardingTable__V: ...
    def hashCode(self) -> int: ...
    def isEmpty(self) -> bool: ...
    def put(self, r: _ForwardingTable__R, c: _ForwardingTable__C, v: _ForwardingTable__V) -> _ForwardingTable__V: ...
    def putAll(self, table: Table[_ForwardingTable__R, _ForwardingTable__C, _ForwardingTable__V]) -> None: ...
    def remove(self, object: _py_Any, object2: _py_Any) -> _ForwardingTable__V: ...
    def row(self, r: _ForwardingTable__R) -> java.util.Map[_ForwardingTable__C, _ForwardingTable__V]: ...
    def rowKeySet(self) -> java.util.Set[_ForwardingTable__R]: ...
    def rowMap(self) -> java.util.Map[_ForwardingTable__R, java.util.Map[_ForwardingTable__C, _ForwardingTable__V]]: ...
    def size(self) -> int: ...
    def values(self) -> java.util.Collection[_ForwardingTable__V]: ...

_ImmutableBiMapFauxverideShim__K = _py_TypeVar('_ImmutableBiMapFauxverideShim__K')  # <K>
_ImmutableBiMapFauxverideShim__V = _py_TypeVar('_ImmutableBiMapFauxverideShim__V')  # <V>
class ImmutableBiMapFauxverideShim(ImmutableMap[_ImmutableBiMapFauxverideShim__K, _ImmutableBiMapFauxverideShim__V], _py_Generic[_ImmutableBiMapFauxverideShim__K, _ImmutableBiMapFauxverideShim__V]):
    _toImmutableMap_0__T = _py_TypeVar('_toImmutableMap_0__T')  # <T>
    _toImmutableMap_0__K = _py_TypeVar('_toImmutableMap_0__K')  # <K>
    _toImmutableMap_0__V = _py_TypeVar('_toImmutableMap_0__V')  # <V>
    @classmethod
    @overload
    def toImmutableMap(cls, function: java.util.function.Function[_toImmutableMap_0__T, _toImmutableMap_0__K], function2: java.util.function.Function[_toImmutableMap_0__T, _toImmutableMap_0__V]) -> java.util.stream.Collector[_toImmutableMap_0__T, _py_Any, ImmutableMap[_toImmutableMap_0__K, _toImmutableMap_0__V]]: ...
    _toImmutableMap_1__T = _py_TypeVar('_toImmutableMap_1__T')  # <T>
    _toImmutableMap_1__K = _py_TypeVar('_toImmutableMap_1__K')  # <K>
    _toImmutableMap_1__V = _py_TypeVar('_toImmutableMap_1__V')  # <V>
    @classmethod
    @overload
    def toImmutableMap(cls, function: java.util.function.Function[_toImmutableMap_1__T, _toImmutableMap_1__K], function2: java.util.function.Function[_toImmutableMap_1__T, _toImmutableMap_1__V], binaryOperator: java.util.function.BinaryOperator[_toImmutableMap_1__V]) -> java.util.stream.Collector[_toImmutableMap_1__T, _py_Any, ImmutableMap[_toImmutableMap_1__K, _toImmutableMap_1__V]]: ...

_ImmutableEntry__K = _py_TypeVar('_ImmutableEntry__K')  # <K>
_ImmutableEntry__V = _py_TypeVar('_ImmutableEntry__V')  # <V>
class ImmutableEntry(AbstractMapEntry[_ImmutableEntry__K, _ImmutableEntry__V], java.io.Serializable, _py_Generic[_ImmutableEntry__K, _ImmutableEntry__V]):
    def getKey(self) -> _ImmutableEntry__K: ...
    def getValue(self) -> _ImmutableEntry__V: ...
    def setValue(self, v: _ImmutableEntry__V) -> _ImmutableEntry__V: ...

_ImmutableMapValues__K = _py_TypeVar('_ImmutableMapValues__K')  # <K>
_ImmutableMapValues__V = _py_TypeVar('_ImmutableMapValues__V')  # <V>
class ImmutableMapValues(ImmutableCollection[_ImmutableMapValues__V], _py_Generic[_ImmutableMapValues__K, _ImmutableMapValues__V]):
    def asList(self) -> 'ImmutableList'[_ImmutableMapValues__V]: ...
    def contains(self, object: _py_Any) -> bool: ...
    def forEach(self, consumer: java.util.function.Consumer[_ImmutableMapValues__V]) -> None: ...
    @overload
    def iterator(self) -> UnmodifiableIterator[_ImmutableMapValues__V]: ...
    @overload
    def iterator(self) -> java.util.Iterator: ...
    def size(self) -> int: ...
    def spliterator(self) -> java.util.Spliterator[_ImmutableMapValues__V]: ...

_ImmutableMultisetGwtSerializationDependencies__E = _py_TypeVar('_ImmutableMultisetGwtSerializationDependencies__E')  # <E>
class ImmutableMultisetGwtSerializationDependencies(ImmutableCollection[_ImmutableMultisetGwtSerializationDependencies__E], _py_Generic[_ImmutableMultisetGwtSerializationDependencies__E]): ...

_ImmutableRangeMap__Builder__K = _py_TypeVar('_ImmutableRangeMap__Builder__K', bound=java.lang.Comparable)  # <K>
_ImmutableRangeMap__Builder__V = _py_TypeVar('_ImmutableRangeMap__Builder__V')  # <V>
_ImmutableRangeMap__K = _py_TypeVar('_ImmutableRangeMap__K', bound=java.lang.Comparable)  # <K>
_ImmutableRangeMap__V = _py_TypeVar('_ImmutableRangeMap__V')  # <V>
class ImmutableRangeMap(RangeMap[_ImmutableRangeMap__K, _ImmutableRangeMap__V], java.io.Serializable, _py_Generic[_ImmutableRangeMap__K, _ImmutableRangeMap__V]):
    @overload
    def asDescendingMapOfRanges(self) -> ImmutableMap['Range'[_ImmutableRangeMap__K], _ImmutableRangeMap__V]: ...
    @overload
    def asDescendingMapOfRanges(self) -> java.util.Map: ...
    @overload
    def asMapOfRanges(self) -> ImmutableMap['Range'[_ImmutableRangeMap__K], _ImmutableRangeMap__V]: ...
    @overload
    def asMapOfRanges(self) -> java.util.Map: ...
    _builder__K = _py_TypeVar('_builder__K', bound=java.lang.Comparable)  # <K>
    _builder__V = _py_TypeVar('_builder__V')  # <V>
    @classmethod
    def builder(cls) -> 'ImmutableRangeMap.Builder'[_builder__K, _builder__V]: ...
    def clear(self) -> None: ...
    _copyOf__K = _py_TypeVar('_copyOf__K', bound=java.lang.Comparable)  # <K>
    _copyOf__V = _py_TypeVar('_copyOf__V')  # <V>
    @classmethod
    def copyOf(cls, rangeMap: RangeMap[_copyOf__K, _copyOf__V]) -> 'ImmutableRangeMap'[_copyOf__K, _copyOf__V]: ...
    def equals(self, object: _py_Any) -> bool: ...
    def get(self, k: _ImmutableRangeMap__K) -> _ImmutableRangeMap__V: ...
    def getEntry(self, k: _ImmutableRangeMap__K) -> java.util.Map.Entry['Range'[_ImmutableRangeMap__K], _ImmutableRangeMap__V]: ...
    def hashCode(self) -> int: ...
    def merge(self, range: 'Range'[_ImmutableRangeMap__K], v: _ImmutableRangeMap__V, biFunction: java.util.function.BiFunction[_ImmutableRangeMap__V, _ImmutableRangeMap__V, _ImmutableRangeMap__V]) -> None: ...
    _of_0__K = _py_TypeVar('_of_0__K', bound=java.lang.Comparable)  # <K>
    _of_0__V = _py_TypeVar('_of_0__V')  # <V>
    @classmethod
    @overload
    def of(cls) -> 'ImmutableRangeMap'[_of_0__K, _of_0__V]: ...
    _of_1__K = _py_TypeVar('_of_1__K', bound=java.lang.Comparable)  # <K>
    _of_1__V = _py_TypeVar('_of_1__V')  # <V>
    @classmethod
    @overload
    def of(cls, range: 'Range'[_of_1__K], v: _of_1__V) -> 'ImmutableRangeMap'[_of_1__K, _of_1__V]: ...
    def put(self, range: 'Range'[_ImmutableRangeMap__K], v: _ImmutableRangeMap__V) -> None: ...
    def putAll(self, rangeMap: RangeMap[_ImmutableRangeMap__K, _ImmutableRangeMap__V]) -> None: ...
    def putCoalescing(self, range: 'Range'[_ImmutableRangeMap__K], v: _ImmutableRangeMap__V) -> None: ...
    def remove(self, range: 'Range'[_ImmutableRangeMap__K]) -> None: ...
    def span(self) -> 'Range'[_ImmutableRangeMap__K]: ...
    @overload
    def subRangeMap(self, range: 'Range'[_ImmutableRangeMap__K]) -> 'ImmutableRangeMap'[_ImmutableRangeMap__K, _ImmutableRangeMap__V]: ...
    @overload
    def subRangeMap(self, range: 'Range') -> RangeMap: ...
    _toImmutableRangeMap__T = _py_TypeVar('_toImmutableRangeMap__T')  # <T>
    _toImmutableRangeMap__K = _py_TypeVar('_toImmutableRangeMap__K', bound=java.lang.Comparable)  # <K>
    _toImmutableRangeMap__V = _py_TypeVar('_toImmutableRangeMap__V')  # <V>
    @classmethod
    def toImmutableRangeMap(cls, function: java.util.function.Function[_toImmutableRangeMap__T, 'Range'[_toImmutableRangeMap__K]], function2: java.util.function.Function[_toImmutableRangeMap__T, _toImmutableRangeMap__V]) -> java.util.stream.Collector[_toImmutableRangeMap__T, _py_Any, 'ImmutableRangeMap'[_toImmutableRangeMap__K, _toImmutableRangeMap__V]]: ...
    def toString(self) -> str: ...
    class Builder(_py_Generic[_ImmutableRangeMap__Builder__K, _ImmutableRangeMap__Builder__V]):
        def __init__(self): ...
        def build(self) -> 'ImmutableRangeMap'[_ImmutableRangeMap__Builder__K, _ImmutableRangeMap__Builder__V]: ...
        def put(self, range: 'Range'[_ImmutableRangeMap__Builder__K], v: _ImmutableRangeMap__Builder__V) -> 'ImmutableRangeMap.Builder'[_ImmutableRangeMap__Builder__K, _ImmutableRangeMap__Builder__V]: ...
        def putAll(self, rangeMap: RangeMap[_ImmutableRangeMap__Builder__K, _ImmutableRangeMap__Builder__V]) -> 'ImmutableRangeMap.Builder'[_ImmutableRangeMap__Builder__K, _ImmutableRangeMap__Builder__V]: ...

_ImmutableSortedMapFauxverideShim__K = _py_TypeVar('_ImmutableSortedMapFauxverideShim__K')  # <K>
_ImmutableSortedMapFauxverideShim__V = _py_TypeVar('_ImmutableSortedMapFauxverideShim__V')  # <V>
class ImmutableSortedMapFauxverideShim(ImmutableMap[_ImmutableSortedMapFauxverideShim__K, _ImmutableSortedMapFauxverideShim__V], _py_Generic[_ImmutableSortedMapFauxverideShim__K, _ImmutableSortedMapFauxverideShim__V]):
    _builder_0__K = _py_TypeVar('_builder_0__K')  # <K>
    _builder_0__V = _py_TypeVar('_builder_0__V')  # <V>
    @classmethod
    @overload
    def builder(cls) -> ImmutableMap.Builder[_builder_0__K, _builder_0__V]: ...
    _builder_1__K = _py_TypeVar('_builder_1__K')  # <K>
    _builder_1__V = _py_TypeVar('_builder_1__V')  # <V>
    @classmethod
    @overload
    def builder(cls) -> 'ImmutableSortedMap.Builder'[_builder_1__K, _builder_1__V]: ...
    _builderWithExpectedSize_0__K = _py_TypeVar('_builderWithExpectedSize_0__K')  # <K>
    _builderWithExpectedSize_0__V = _py_TypeVar('_builderWithExpectedSize_0__V')  # <V>
    @classmethod
    @overload
    def builderWithExpectedSize(cls, int: int) -> ImmutableMap.Builder[_builderWithExpectedSize_0__K, _builderWithExpectedSize_0__V]: ...
    _builderWithExpectedSize_1__K = _py_TypeVar('_builderWithExpectedSize_1__K')  # <K>
    _builderWithExpectedSize_1__V = _py_TypeVar('_builderWithExpectedSize_1__V')  # <V>
    @classmethod
    @overload
    def builderWithExpectedSize(cls, int: int) -> 'ImmutableSortedMap.Builder'[_builderWithExpectedSize_1__K, _builderWithExpectedSize_1__V]: ...
    _of_0__K = _py_TypeVar('_of_0__K')  # <K>
    _of_0__V = _py_TypeVar('_of_0__V')  # <V>
    @classmethod
    @overload
    def of(cls) -> ImmutableMap[_of_0__K, _of_0__V]: ...
    _of_1__K = _py_TypeVar('_of_1__K')  # <K>
    _of_1__V = _py_TypeVar('_of_1__V')  # <V>
    @classmethod
    @overload
    def of(cls, k: _of_1__K, v: _of_1__V) -> ImmutableMap[_of_1__K, _of_1__V]: ...
    _of_2__K = _py_TypeVar('_of_2__K')  # <K>
    _of_2__V = _py_TypeVar('_of_2__V')  # <V>
    @classmethod
    @overload
    def of(cls, k: _of_2__K, v: _of_2__V, k2: _of_2__K, v2: _of_2__V) -> ImmutableMap[_of_2__K, _of_2__V]: ...
    _of_3__K = _py_TypeVar('_of_3__K')  # <K>
    _of_3__V = _py_TypeVar('_of_3__V')  # <V>
    @classmethod
    @overload
    def of(cls, k: _of_3__K, v: _of_3__V, k2: _of_3__K, v2: _of_3__V, k3: _of_3__K, v3: _of_3__V) -> ImmutableMap[_of_3__K, _of_3__V]: ...
    _of_4__K = _py_TypeVar('_of_4__K')  # <K>
    _of_4__V = _py_TypeVar('_of_4__V')  # <V>
    @classmethod
    @overload
    def of(cls, k: _of_4__K, v: _of_4__V, k2: _of_4__K, v2: _of_4__V, k3: _of_4__K, v3: _of_4__V, k4: _of_4__K, v4: _of_4__V) -> ImmutableMap[_of_4__K, _of_4__V]: ...
    _of_5__K = _py_TypeVar('_of_5__K')  # <K>
    _of_5__V = _py_TypeVar('_of_5__V')  # <V>
    @classmethod
    @overload
    def of(cls, k: _of_5__K, v: _of_5__V, k2: _of_5__K, v2: _of_5__V, k3: _of_5__K, v3: _of_5__V, k4: _of_5__K, v4: _of_5__V, k5: _of_5__K, v5: _of_5__V) -> ImmutableMap[_of_5__K, _of_5__V]: ...
    _of_6__K = _py_TypeVar('_of_6__K')  # <K>
    _of_6__V = _py_TypeVar('_of_6__V')  # <V>
    @classmethod
    @overload
    def of(cls, k: _of_6__K, v: _of_6__V) -> 'ImmutableSortedMap'[_of_6__K, _of_6__V]: ...
    _of_7__K = _py_TypeVar('_of_7__K')  # <K>
    _of_7__V = _py_TypeVar('_of_7__V')  # <V>
    @classmethod
    @overload
    def of(cls, k: _of_7__K, v: _of_7__V, k2: _of_7__K, v2: _of_7__V) -> 'ImmutableSortedMap'[_of_7__K, _of_7__V]: ...
    _of_8__K = _py_TypeVar('_of_8__K')  # <K>
    _of_8__V = _py_TypeVar('_of_8__V')  # <V>
    @classmethod
    @overload
    def of(cls, k: _of_8__K, v: _of_8__V, k2: _of_8__K, v2: _of_8__V, k3: _of_8__K, v3: _of_8__V) -> 'ImmutableSortedMap'[_of_8__K, _of_8__V]: ...
    _of_9__K = _py_TypeVar('_of_9__K')  # <K>
    _of_9__V = _py_TypeVar('_of_9__V')  # <V>
    @classmethod
    @overload
    def of(cls, k: _of_9__K, v: _of_9__V, k2: _of_9__K, v2: _of_9__V, k3: _of_9__K, v3: _of_9__V, k4: _of_9__K, v4: _of_9__V) -> 'ImmutableSortedMap'[_of_9__K, _of_9__V]: ...
    _of_10__K = _py_TypeVar('_of_10__K')  # <K>
    _of_10__V = _py_TypeVar('_of_10__V')  # <V>
    @classmethod
    @overload
    def of(cls, k: _of_10__K, v: _of_10__V, k2: _of_10__K, v2: _of_10__V, k3: _of_10__K, v3: _of_10__V, k4: _of_10__K, v4: _of_10__V, k5: _of_10__K, v5: _of_10__V) -> 'ImmutableSortedMap'[_of_10__K, _of_10__V]: ...
    _toImmutableMap_0__T = _py_TypeVar('_toImmutableMap_0__T')  # <T>
    _toImmutableMap_0__K = _py_TypeVar('_toImmutableMap_0__K')  # <K>
    _toImmutableMap_0__V = _py_TypeVar('_toImmutableMap_0__V')  # <V>
    @classmethod
    @overload
    def toImmutableMap(cls, function: java.util.function.Function[_toImmutableMap_0__T, _toImmutableMap_0__K], function2: java.util.function.Function[_toImmutableMap_0__T, _toImmutableMap_0__V]) -> java.util.stream.Collector[_toImmutableMap_0__T, _py_Any, ImmutableMap[_toImmutableMap_0__K, _toImmutableMap_0__V]]: ...
    _toImmutableMap_1__T = _py_TypeVar('_toImmutableMap_1__T')  # <T>
    _toImmutableMap_1__K = _py_TypeVar('_toImmutableMap_1__K')  # <K>
    _toImmutableMap_1__V = _py_TypeVar('_toImmutableMap_1__V')  # <V>
    @classmethod
    @overload
    def toImmutableMap(cls, function: java.util.function.Function[_toImmutableMap_1__T, _toImmutableMap_1__K], function2: java.util.function.Function[_toImmutableMap_1__T, _toImmutableMap_1__V], binaryOperator: java.util.function.BinaryOperator[_toImmutableMap_1__V]) -> java.util.stream.Collector[_toImmutableMap_1__T, _py_Any, ImmutableMap[_toImmutableMap_1__K, _toImmutableMap_1__V]]: ...

_JdkBackedImmutableMap__K = _py_TypeVar('_JdkBackedImmutableMap__K')  # <K>
_JdkBackedImmutableMap__V = _py_TypeVar('_JdkBackedImmutableMap__V')  # <V>
class JdkBackedImmutableMap(ImmutableMap[_JdkBackedImmutableMap__K, _JdkBackedImmutableMap__V], _py_Generic[_JdkBackedImmutableMap__K, _JdkBackedImmutableMap__V]):
    def forEach(self, biConsumer: java.util.function.BiConsumer[_JdkBackedImmutableMap__K, _JdkBackedImmutableMap__V]) -> None: ...
    def get(self, object: _py_Any) -> _JdkBackedImmutableMap__V: ...
    def size(self) -> int: ...

_LexicographicalOrdering__T = _py_TypeVar('_LexicographicalOrdering__T')  # <T>
class LexicographicalOrdering(Ordering[java.lang.Iterable[_LexicographicalOrdering__T]], java.io.Serializable, _py_Generic[_LexicographicalOrdering__T]):
    @overload
    def compare(self, iterable: java.lang.Iterable[_LexicographicalOrdering__T], iterable2: java.lang.Iterable[_LexicographicalOrdering__T]) -> int: ...
    @overload
    def compare(self, object: _py_Any, object2: _py_Any) -> int: ...
    def equals(self, object: _py_Any) -> bool: ...
    def hashCode(self) -> int: ...
    def toString(self) -> str: ...

_ListMultimap__K = _py_TypeVar('_ListMultimap__K')  # <K>
_ListMultimap__V = _py_TypeVar('_ListMultimap__V')  # <V>
class ListMultimap(Multimap[_ListMultimap__K, _ListMultimap__V], _py_Generic[_ListMultimap__K, _ListMultimap__V]):
    def asMap(self) -> java.util.Map[_ListMultimap__K, java.util.Collection[_ListMultimap__V]]: ...
    def equals(self, object: _py_Any) -> bool: ...
    @overload
    def get(self, k: _ListMultimap__K) -> java.util.List[_ListMultimap__V]: ...
    @overload
    def get(self, object: _py_Any) -> java.util.Collection: ...
    def hashCode(self) -> int: ...
    @overload
    def removeAll(self, object: _py_Any) -> java.util.List[_ListMultimap__V]: ...
    @overload
    def removeAll(self, object: _py_Any) -> java.util.Collection: ...
    @overload
    def replaceValues(self, k: _ListMultimap__K, iterable: java.lang.Iterable[_ListMultimap__V]) -> java.util.List[_ListMultimap__V]: ...
    @overload
    def replaceValues(self, object: _py_Any, iterable: java.lang.Iterable) -> java.util.Collection: ...

class NaturalOrdering(Ordering[java.lang.Comparable], java.io.Serializable):
    @overload
    def compare(self, comparable: java.lang.Comparable, comparable2: java.lang.Comparable) -> int: ...
    @overload
    def compare(self, object: _py_Any, object2: _py_Any) -> int: ...
    _nullsFirst__S = _py_TypeVar('_nullsFirst__S', bound=java.lang.Comparable)  # <S>
    def nullsFirst(self) -> Ordering[_nullsFirst__S]: ...
    _nullsLast__S = _py_TypeVar('_nullsLast__S', bound=java.lang.Comparable)  # <S>
    def nullsLast(self) -> Ordering[_nullsLast__S]: ...
    _reverse__S = _py_TypeVar('_reverse__S', bound=java.lang.Comparable)  # <S>
    def reverse(self) -> Ordering[_reverse__S]: ...
    def toString(self) -> str: ...

_NullsFirstOrdering__T = _py_TypeVar('_NullsFirstOrdering__T')  # <T>
class NullsFirstOrdering(Ordering[_NullsFirstOrdering__T], java.io.Serializable, _py_Generic[_NullsFirstOrdering__T]):
    def compare(self, t: _NullsFirstOrdering__T, t2: _NullsFirstOrdering__T) -> int: ...
    def equals(self, object: _py_Any) -> bool: ...
    def hashCode(self) -> int: ...
    _nullsFirst__S = _py_TypeVar('_nullsFirst__S')  # <S>
    def nullsFirst(self) -> Ordering[_nullsFirst__S]: ...
    _nullsLast__S = _py_TypeVar('_nullsLast__S')  # <S>
    def nullsLast(self) -> Ordering[_nullsLast__S]: ...
    _reverse__S = _py_TypeVar('_reverse__S')  # <S>
    def reverse(self) -> Ordering[_reverse__S]: ...
    def toString(self) -> str: ...

_NullsLastOrdering__T = _py_TypeVar('_NullsLastOrdering__T')  # <T>
class NullsLastOrdering(Ordering[_NullsLastOrdering__T], java.io.Serializable, _py_Generic[_NullsLastOrdering__T]):
    def compare(self, t: _NullsLastOrdering__T, t2: _NullsLastOrdering__T) -> int: ...
    def equals(self, object: _py_Any) -> bool: ...
    def hashCode(self) -> int: ...
    _nullsFirst__S = _py_TypeVar('_nullsFirst__S')  # <S>
    def nullsFirst(self) -> Ordering[_nullsFirst__S]: ...
    _nullsLast__S = _py_TypeVar('_nullsLast__S')  # <S>
    def nullsLast(self) -> Ordering[_nullsLast__S]: ...
    _reverse__S = _py_TypeVar('_reverse__S')  # <S>
    def reverse(self) -> Ordering[_reverse__S]: ...
    def toString(self) -> str: ...

_Range__C = _py_TypeVar('_Range__C', bound=java.lang.Comparable)  # <C>
class Range(RangeGwtSerializationDependencies, com.google.common.base.Predicate[_Range__C], java.io.Serializable, _py_Generic[_Range__C]):
    _all__C = _py_TypeVar('_all__C', bound=java.lang.Comparable)  # <C>
    @classmethod
    def all(cls) -> 'Range'[_all__C]: ...
    @overload
    def apply(self, c: _Range__C) -> bool: ...
    @overload
    def apply(self, object: _py_Any) -> bool: ...
    _atLeast__C = _py_TypeVar('_atLeast__C', bound=java.lang.Comparable)  # <C>
    @classmethod
    def atLeast(cls, c2: _atLeast__C) -> 'Range'[_atLeast__C]: ...
    _atMost__C = _py_TypeVar('_atMost__C', bound=java.lang.Comparable)  # <C>
    @classmethod
    def atMost(cls, c2: _atMost__C) -> 'Range'[_atMost__C]: ...
    def canonical(self, discreteDomain: DiscreteDomain[_Range__C]) -> 'Range'[_Range__C]: ...
    _closed__C = _py_TypeVar('_closed__C', bound=java.lang.Comparable)  # <C>
    @classmethod
    def closed(cls, c2: _closed__C, c3: _closed__C) -> 'Range'[_closed__C]: ...
    _closedOpen__C = _py_TypeVar('_closedOpen__C', bound=java.lang.Comparable)  # <C>
    @classmethod
    def closedOpen(cls, c2: _closedOpen__C, c3: _closedOpen__C) -> 'Range'[_closedOpen__C]: ...
    def contains(self, c: _Range__C) -> bool: ...
    def containsAll(self, iterable: java.lang.Iterable[_Range__C]) -> bool: ...
    _downTo__C = _py_TypeVar('_downTo__C', bound=java.lang.Comparable)  # <C>
    @classmethod
    def downTo(cls, c2: _downTo__C, boundType: BoundType) -> 'Range'[_downTo__C]: ...
    _encloseAll__C = _py_TypeVar('_encloseAll__C', bound=java.lang.Comparable)  # <C>
    @classmethod
    def encloseAll(cls, iterable: java.lang.Iterable[_encloseAll__C]) -> 'Range'[_encloseAll__C]: ...
    def encloses(self, range: 'Range'[_Range__C]) -> bool: ...
    def equals(self, object: _py_Any) -> bool: ...
    def gap(self, range: 'Range'[_Range__C]) -> 'Range'[_Range__C]: ...
    _greaterThan__C = _py_TypeVar('_greaterThan__C', bound=java.lang.Comparable)  # <C>
    @classmethod
    def greaterThan(cls, c2: _greaterThan__C) -> 'Range'[_greaterThan__C]: ...
    def hasLowerBound(self) -> bool: ...
    def hasUpperBound(self) -> bool: ...
    def hashCode(self) -> int: ...
    def intersection(self, range: 'Range'[_Range__C]) -> 'Range'[_Range__C]: ...
    def isConnected(self, range: 'Range'[_Range__C]) -> bool: ...
    def isEmpty(self) -> bool: ...
    _lessThan__C = _py_TypeVar('_lessThan__C', bound=java.lang.Comparable)  # <C>
    @classmethod
    def lessThan(cls, c2: _lessThan__C) -> 'Range'[_lessThan__C]: ...
    def lowerBoundType(self) -> BoundType: ...
    def lowerEndpoint(self) -> _Range__C: ...
    _open__C = _py_TypeVar('_open__C', bound=java.lang.Comparable)  # <C>
    @classmethod
    def open(cls, c2: _open__C, c3: _open__C) -> 'Range'[_open__C]: ...
    _openClosed__C = _py_TypeVar('_openClosed__C', bound=java.lang.Comparable)  # <C>
    @classmethod
    def openClosed(cls, c2: _openClosed__C, c3: _openClosed__C) -> 'Range'[_openClosed__C]: ...
    _range__C = _py_TypeVar('_range__C', bound=java.lang.Comparable)  # <C>
    @classmethod
    def range(cls, c2: _range__C, boundType: BoundType, c3: _range__C, boundType2: BoundType) -> 'Range'[_range__C]: ...
    _singleton__C = _py_TypeVar('_singleton__C', bound=java.lang.Comparable)  # <C>
    @classmethod
    def singleton(cls, c2: _singleton__C) -> 'Range'[_singleton__C]: ...
    def span(self, range: 'Range'[_Range__C]) -> 'Range'[_Range__C]: ...
    def toString(self) -> str: ...
    _upTo__C = _py_TypeVar('_upTo__C', bound=java.lang.Comparable)  # <C>
    @classmethod
    def upTo(cls, c2: _upTo__C, boundType: BoundType) -> 'Range'[_upTo__C]: ...
    def upperBoundType(self) -> BoundType: ...
    def upperEndpoint(self) -> _Range__C: ...

_RegularImmutableMap__K = _py_TypeVar('_RegularImmutableMap__K')  # <K>
_RegularImmutableMap__V = _py_TypeVar('_RegularImmutableMap__V')  # <V>
class RegularImmutableMap(ImmutableMap[_RegularImmutableMap__K, _RegularImmutableMap__V], _py_Generic[_RegularImmutableMap__K, _RegularImmutableMap__V]):
    def forEach(self, biConsumer: java.util.function.BiConsumer[_RegularImmutableMap__K, _RegularImmutableMap__V]) -> None: ...
    def get(self, object: _py_Any) -> _RegularImmutableMap__V: ...
    def size(self) -> int: ...

class ReverseNaturalOrdering(Ordering[java.lang.Comparable], java.io.Serializable):
    @overload
    def compare(self, comparable: java.lang.Comparable, comparable2: java.lang.Comparable) -> int: ...
    @overload
    def compare(self, object: _py_Any, object2: _py_Any) -> int: ...
    _max_0__E = _py_TypeVar('_max_0__E', bound=java.lang.Comparable)  # <E>
    @overload
    def max(self, e: _max_0__E, e2: _max_0__E) -> _max_0__E: ...
    _max_1__E = _py_TypeVar('_max_1__E', bound=java.lang.Comparable)  # <E>
    @overload
    def max(self, e: _max_1__E, e2: _max_1__E, e3: _max_1__E, eArray: _py_List[_max_1__E]) -> _max_1__E: ...
    _max_2__E = _py_TypeVar('_max_2__E', bound=java.lang.Comparable)  # <E>
    @overload
    def max(self, iterable: java.lang.Iterable[_max_2__E]) -> _max_2__E: ...
    _max_3__E = _py_TypeVar('_max_3__E', bound=java.lang.Comparable)  # <E>
    @overload
    def max(self, iterator: java.util.Iterator[_max_3__E]) -> _max_3__E: ...
    @overload
    def max(self, iterable: java.lang.Iterable) -> _py_Any: ...
    @overload
    def max(self, object: _py_Any, object2: _py_Any) -> _py_Any: ...
    @overload
    def max(self, object: _py_Any, object2: _py_Any, object3: _py_Any, objectArray: _py_List[_py_Any]) -> _py_Any: ...
    @overload
    def max(self, iterator: java.util.Iterator) -> _py_Any: ...
    _min_0__E = _py_TypeVar('_min_0__E', bound=java.lang.Comparable)  # <E>
    @overload
    def min(self, e: _min_0__E, e2: _min_0__E) -> _min_0__E: ...
    _min_1__E = _py_TypeVar('_min_1__E', bound=java.lang.Comparable)  # <E>
    @overload
    def min(self, e: _min_1__E, e2: _min_1__E, e3: _min_1__E, eArray: _py_List[_min_1__E]) -> _min_1__E: ...
    _min_2__E = _py_TypeVar('_min_2__E', bound=java.lang.Comparable)  # <E>
    @overload
    def min(self, iterable: java.lang.Iterable[_min_2__E]) -> _min_2__E: ...
    _min_3__E = _py_TypeVar('_min_3__E', bound=java.lang.Comparable)  # <E>
    @overload
    def min(self, iterator: java.util.Iterator[_min_3__E]) -> _min_3__E: ...
    @overload
    def min(self, iterable: java.lang.Iterable) -> _py_Any: ...
    @overload
    def min(self, object: _py_Any, object2: _py_Any) -> _py_Any: ...
    @overload
    def min(self, object: _py_Any, object2: _py_Any, object3: _py_Any, objectArray: _py_List[_py_Any]) -> _py_Any: ...
    @overload
    def min(self, iterator: java.util.Iterator) -> _py_Any: ...
    _reverse__S = _py_TypeVar('_reverse__S', bound=java.lang.Comparable)  # <S>
    def reverse(self) -> Ordering[_reverse__S]: ...
    def toString(self) -> str: ...

_ReverseOrdering__T = _py_TypeVar('_ReverseOrdering__T')  # <T>
class ReverseOrdering(Ordering[_ReverseOrdering__T], java.io.Serializable, _py_Generic[_ReverseOrdering__T]):
    def compare(self, t: _ReverseOrdering__T, t2: _ReverseOrdering__T) -> int: ...
    def equals(self, object: _py_Any) -> bool: ...
    def hashCode(self) -> int: ...
    _max_0__E = _py_TypeVar('_max_0__E')  # <E>
    @overload
    def max(self, iterable: java.lang.Iterable[_max_0__E]) -> _max_0__E: ...
    _max_1__E = _py_TypeVar('_max_1__E')  # <E>
    @overload
    def max(self, e: _max_1__E, e2: _max_1__E) -> _max_1__E: ...
    _max_2__E = _py_TypeVar('_max_2__E')  # <E>
    @overload
    def max(self, e: _max_2__E, e2: _max_2__E, e3: _max_2__E, eArray: _py_List[_max_2__E]) -> _max_2__E: ...
    _max_3__E = _py_TypeVar('_max_3__E')  # <E>
    @overload
    def max(self, iterator: java.util.Iterator[_max_3__E]) -> _max_3__E: ...
    _min_0__E = _py_TypeVar('_min_0__E')  # <E>
    @overload
    def min(self, iterable: java.lang.Iterable[_min_0__E]) -> _min_0__E: ...
    _min_1__E = _py_TypeVar('_min_1__E')  # <E>
    @overload
    def min(self, e: _min_1__E, e2: _min_1__E) -> _min_1__E: ...
    _min_2__E = _py_TypeVar('_min_2__E')  # <E>
    @overload
    def min(self, e: _min_2__E, e2: _min_2__E, e3: _min_2__E, eArray: _py_List[_min_2__E]) -> _min_2__E: ...
    _min_3__E = _py_TypeVar('_min_3__E')  # <E>
    @overload
    def min(self, iterator: java.util.Iterator[_min_3__E]) -> _min_3__E: ...
    _reverse__S = _py_TypeVar('_reverse__S')  # <S>
    def reverse(self) -> Ordering[_reverse__S]: ...
    def toString(self) -> str: ...

_RowSortedTable__R = _py_TypeVar('_RowSortedTable__R')  # <R>
_RowSortedTable__C = _py_TypeVar('_RowSortedTable__C')  # <C>
_RowSortedTable__V = _py_TypeVar('_RowSortedTable__V')  # <V>
class RowSortedTable(Table[_RowSortedTable__R, _RowSortedTable__C, _RowSortedTable__V], _py_Generic[_RowSortedTable__R, _RowSortedTable__C, _RowSortedTable__V]):
    def equals(self, object: _py_Any) -> bool: ...
    def hashCode(self) -> int: ...
    @overload
    def rowKeySet(self) -> java.util.SortedSet[_RowSortedTable__R]: ...
    @overload
    def rowKeySet(self) -> java.util.Set: ...
    @overload
    def rowMap(self) -> java.util.SortedMap[_RowSortedTable__R, java.util.Map[_RowSortedTable__C, _RowSortedTable__V]]: ...
    @overload
    def rowMap(self) -> java.util.Map: ...

_SetMultimap__K = _py_TypeVar('_SetMultimap__K')  # <K>
_SetMultimap__V = _py_TypeVar('_SetMultimap__V')  # <V>
class SetMultimap(Multimap[_SetMultimap__K, _SetMultimap__V], _py_Generic[_SetMultimap__K, _SetMultimap__V]):
    def asMap(self) -> java.util.Map[_SetMultimap__K, java.util.Collection[_SetMultimap__V]]: ...
    @overload
    def entries(self) -> java.util.Set[java.util.Map.Entry[_SetMultimap__K, _SetMultimap__V]]: ...
    @overload
    def entries(self) -> java.util.Collection: ...
    def equals(self, object: _py_Any) -> bool: ...
    @overload
    def get(self, k: _SetMultimap__K) -> java.util.Set[_SetMultimap__V]: ...
    @overload
    def get(self, object: _py_Any) -> java.util.Collection: ...
    def hashCode(self) -> int: ...
    @overload
    def removeAll(self, object: _py_Any) -> java.util.Set[_SetMultimap__V]: ...
    @overload
    def removeAll(self, object: _py_Any) -> java.util.Collection: ...
    @overload
    def replaceValues(self, k: _SetMultimap__K, iterable: java.lang.Iterable[_SetMultimap__V]) -> java.util.Set[_SetMultimap__V]: ...
    @overload
    def replaceValues(self, object: _py_Any, iterable: java.lang.Iterable) -> java.util.Collection: ...

_SortedMapDifference__K = _py_TypeVar('_SortedMapDifference__K')  # <K>
_SortedMapDifference__V = _py_TypeVar('_SortedMapDifference__V')  # <V>
class SortedMapDifference(MapDifference[_SortedMapDifference__K, _SortedMapDifference__V], _py_Generic[_SortedMapDifference__K, _SortedMapDifference__V]):
    @overload
    def entriesDiffering(self) -> java.util.SortedMap[_SortedMapDifference__K, MapDifference.ValueDifference[_SortedMapDifference__V]]: ...
    @overload
    def entriesDiffering(self) -> java.util.Map: ...
    @overload
    def entriesInCommon(self) -> java.util.SortedMap[_SortedMapDifference__K, _SortedMapDifference__V]: ...
    @overload
    def entriesInCommon(self) -> java.util.Map: ...
    @overload
    def entriesOnlyOnLeft(self) -> java.util.SortedMap[_SortedMapDifference__K, _SortedMapDifference__V]: ...
    @overload
    def entriesOnlyOnLeft(self) -> java.util.Map: ...
    @overload
    def entriesOnlyOnRight(self) -> java.util.SortedMap[_SortedMapDifference__K, _SortedMapDifference__V]: ...
    @overload
    def entriesOnlyOnRight(self) -> java.util.Map: ...
    def equals(self, object: _py_Any) -> bool: ...
    def hashCode(self) -> int: ...

_SortedMultisetBridge__E = _py_TypeVar('_SortedMultisetBridge__E')  # <E>
class SortedMultisetBridge(Multiset[_SortedMultisetBridge__E], _py_Generic[_SortedMultisetBridge__E]):
    @overload
    def elementSet(self) -> java.util.SortedSet[_SortedMultisetBridge__E]: ...
    @overload
    def elementSet(self) -> java.util.Set: ...
    def equals(self, object: _py_Any) -> bool: ...
    def hashCode(self) -> int: ...
    def toString(self) -> str: ...

_TransformedListIterator__F = _py_TypeVar('_TransformedListIterator__F')  # <F>
_TransformedListIterator__T = _py_TypeVar('_TransformedListIterator__T')  # <T>
class TransformedListIterator(TransformedIterator[_TransformedListIterator__F, _TransformedListIterator__T], java.util.ListIterator[_TransformedListIterator__T], _py_Generic[_TransformedListIterator__F, _TransformedListIterator__T]):
    def add(self, t: _TransformedListIterator__T) -> None: ...
    def hasPrevious(self) -> bool: ...
    def nextIndex(self) -> int: ...
    def previous(self) -> _TransformedListIterator__T: ...
    def previousIndex(self) -> int: ...
    def set(self, t: _TransformedListIterator__T) -> None: ...

_TreeRangeMap__K = _py_TypeVar('_TreeRangeMap__K', bound=java.lang.Comparable)  # <K>
_TreeRangeMap__V = _py_TypeVar('_TreeRangeMap__V')  # <V>
class TreeRangeMap(RangeMap[_TreeRangeMap__K, _TreeRangeMap__V], _py_Generic[_TreeRangeMap__K, _TreeRangeMap__V]):
    def asDescendingMapOfRanges(self) -> java.util.Map[Range[_TreeRangeMap__K], _TreeRangeMap__V]: ...
    def asMapOfRanges(self) -> java.util.Map[Range[_TreeRangeMap__K], _TreeRangeMap__V]: ...
    def clear(self) -> None: ...
    _create__K = _py_TypeVar('_create__K', bound=java.lang.Comparable)  # <K>
    _create__V = _py_TypeVar('_create__V')  # <V>
    @classmethod
    def create(cls) -> 'TreeRangeMap'[_create__K, _create__V]: ...
    def equals(self, object: _py_Any) -> bool: ...
    def get(self, k: _TreeRangeMap__K) -> _TreeRangeMap__V: ...
    def getEntry(self, k: _TreeRangeMap__K) -> java.util.Map.Entry[Range[_TreeRangeMap__K], _TreeRangeMap__V]: ...
    def hashCode(self) -> int: ...
    def merge(self, range: Range[_TreeRangeMap__K], v: _TreeRangeMap__V, biFunction: java.util.function.BiFunction[_TreeRangeMap__V, _TreeRangeMap__V, _TreeRangeMap__V]) -> None: ...
    def put(self, range: Range[_TreeRangeMap__K], v: _TreeRangeMap__V) -> None: ...
    def putAll(self, rangeMap: RangeMap[_TreeRangeMap__K, _TreeRangeMap__V]) -> None: ...
    def putCoalescing(self, range: Range[_TreeRangeMap__K], v: _TreeRangeMap__V) -> None: ...
    def remove(self, range: Range[_TreeRangeMap__K]) -> None: ...
    def span(self) -> Range[_TreeRangeMap__K]: ...
    def subRangeMap(self, range: Range[_TreeRangeMap__K]) -> RangeMap[_TreeRangeMap__K, _TreeRangeMap__V]: ...
    def toString(self) -> str: ...

_UnmodifiableListIterator__E = _py_TypeVar('_UnmodifiableListIterator__E')  # <E>
class UnmodifiableListIterator(UnmodifiableIterator[_UnmodifiableListIterator__E], java.util.ListIterator[_UnmodifiableListIterator__E], _py_Generic[_UnmodifiableListIterator__E]):
    def add(self, e: _UnmodifiableListIterator__E) -> None: ...
    def set(self, e: _UnmodifiableListIterator__E) -> None: ...

class UsingToStringOrdering(Ordering[_py_Any], java.io.Serializable):
    def compare(self, object: _py_Any, object2: _py_Any) -> int: ...
    def toString(self) -> str: ...

_AbstractBiMap__K = _py_TypeVar('_AbstractBiMap__K')  # <K>
_AbstractBiMap__V = _py_TypeVar('_AbstractBiMap__V')  # <V>
class AbstractBiMap(ForwardingMap[_AbstractBiMap__K, _AbstractBiMap__V], BiMap[_AbstractBiMap__K, _AbstractBiMap__V], java.io.Serializable, _py_Generic[_AbstractBiMap__K, _AbstractBiMap__V]):
    def clear(self) -> None: ...
    def containsValue(self, object: _py_Any) -> bool: ...
    def entrySet(self) -> java.util.Set[java.util.Map.Entry[_AbstractBiMap__K, _AbstractBiMap__V]]: ...
    def forcePut(self, k: _AbstractBiMap__K, v: _AbstractBiMap__V) -> _AbstractBiMap__V: ...
    def inverse(self) -> BiMap[_AbstractBiMap__V, _AbstractBiMap__K]: ...
    def keySet(self) -> java.util.Set[_AbstractBiMap__K]: ...
    def put(self, k: _AbstractBiMap__K, v: _AbstractBiMap__V) -> _AbstractBiMap__V: ...
    def putAll(self, map: java.util.Map[_AbstractBiMap__K, _AbstractBiMap__V]) -> None: ...
    @overload
    def remove(self, object: _py_Any, object2: _py_Any) -> bool: ...
    @overload
    def remove(self, object: _py_Any) -> _AbstractBiMap__V: ...
    def replaceAll(self, biFunction: java.util.function.BiFunction[_AbstractBiMap__K, _AbstractBiMap__V, _AbstractBiMap__V]) -> None: ...
    @overload
    def values(self) -> java.util.Collection: ...
    @overload
    def values(self) -> java.util.Set[_AbstractBiMap__V]: ...

_AbstractIndexedListIterator__E = _py_TypeVar('_AbstractIndexedListIterator__E')  # <E>
class AbstractIndexedListIterator(UnmodifiableListIterator[_AbstractIndexedListIterator__E], _py_Generic[_AbstractIndexedListIterator__E]):
    def hasNext(self) -> bool: ...
    def hasPrevious(self) -> bool: ...
    def next(self) -> _AbstractIndexedListIterator__E: ...
    def nextIndex(self) -> int: ...
    def previous(self) -> _AbstractIndexedListIterator__E: ...
    def previousIndex(self) -> int: ...

_AbstractMapBasedMultimap__K = _py_TypeVar('_AbstractMapBasedMultimap__K')  # <K>
_AbstractMapBasedMultimap__V = _py_TypeVar('_AbstractMapBasedMultimap__V')  # <V>
class AbstractMapBasedMultimap(AbstractMultimap[_AbstractMapBasedMultimap__K, _AbstractMapBasedMultimap__V], java.io.Serializable, _py_Generic[_AbstractMapBasedMultimap__K, _AbstractMapBasedMultimap__V]):
    def clear(self) -> None: ...
    def containsKey(self, object: _py_Any) -> bool: ...
    def entries(self) -> java.util.Collection[java.util.Map.Entry[_AbstractMapBasedMultimap__K, _AbstractMapBasedMultimap__V]]: ...
    def forEach(self, biConsumer: java.util.function.BiConsumer[_AbstractMapBasedMultimap__K, _AbstractMapBasedMultimap__V]) -> None: ...
    def get(self, k: _AbstractMapBasedMultimap__K) -> java.util.Collection[_AbstractMapBasedMultimap__V]: ...
    def put(self, k: _AbstractMapBasedMultimap__K, v: _AbstractMapBasedMultimap__V) -> bool: ...
    def removeAll(self, object: _py_Any) -> java.util.Collection[_AbstractMapBasedMultimap__V]: ...
    def replaceValues(self, k: _AbstractMapBasedMultimap__K, iterable: java.lang.Iterable[_AbstractMapBasedMultimap__V]) -> java.util.Collection[_AbstractMapBasedMultimap__V]: ...
    def size(self) -> int: ...
    def values(self) -> java.util.Collection[_AbstractMapBasedMultimap__V]: ...

_AbstractMapBasedMultiset__E = _py_TypeVar('_AbstractMapBasedMultiset__E')  # <E>
class AbstractMapBasedMultiset(AbstractMultiset[_AbstractMapBasedMultiset__E], java.io.Serializable, _py_Generic[_AbstractMapBasedMultiset__E]):
    @overload
    def add(self, e: _AbstractMapBasedMultiset__E) -> bool: ...
    @overload
    def add(self, e: _AbstractMapBasedMultiset__E, int: int) -> int: ...
    def clear(self) -> None: ...
    def count(self, object: _py_Any) -> int: ...
    def entrySet(self) -> java.util.Set[Multiset.Entry[_AbstractMapBasedMultiset__E]]: ...
    def forEachEntry(self, objIntConsumer: java.util.function.ObjIntConsumer[_AbstractMapBasedMultiset__E]) -> None: ...
    def iterator(self) -> java.util.Iterator[_AbstractMapBasedMultiset__E]: ...
    @overload
    def remove(self, object: _py_Any) -> bool: ...
    @overload
    def remove(self, object: _py_Any, int: int) -> int: ...
    @overload
    def setCount(self, e: _AbstractMapBasedMultiset__E, int: int, int2: int) -> bool: ...
    @overload
    def setCount(self, e: _AbstractMapBasedMultiset__E, int: int) -> int: ...
    def size(self) -> int: ...

_ArrayTable__R = _py_TypeVar('_ArrayTable__R')  # <R>
_ArrayTable__C = _py_TypeVar('_ArrayTable__C')  # <C>
_ArrayTable__V = _py_TypeVar('_ArrayTable__V')  # <V>
class ArrayTable(AbstractTable[_ArrayTable__R, _ArrayTable__C, _ArrayTable__V], java.io.Serializable, _py_Generic[_ArrayTable__R, _ArrayTable__C, _ArrayTable__V]):
    def at(self, int: int, int2: int) -> _ArrayTable__V: ...
    def cellSet(self) -> java.util.Set[Table.Cell[_ArrayTable__R, _ArrayTable__C, _ArrayTable__V]]: ...
    def clear(self) -> None: ...
    def column(self, c: _ArrayTable__C) -> java.util.Map[_ArrayTable__R, _ArrayTable__V]: ...
    def columnKeyList(self) -> 'ImmutableList'[_ArrayTable__C]: ...
    @overload
    def columnKeySet(self) -> 'ImmutableSet'[_ArrayTable__C]: ...
    @overload
    def columnKeySet(self) -> java.util.Set: ...
    def columnMap(self) -> java.util.Map[_ArrayTable__C, java.util.Map[_ArrayTable__R, _ArrayTable__V]]: ...
    def contains(self, object: _py_Any, object2: _py_Any) -> bool: ...
    def containsColumn(self, object: _py_Any) -> bool: ...
    def containsRow(self, object: _py_Any) -> bool: ...
    def containsValue(self, object: _py_Any) -> bool: ...
    _create_0__R = _py_TypeVar('_create_0__R')  # <R>
    _create_0__C = _py_TypeVar('_create_0__C')  # <C>
    _create_0__V = _py_TypeVar('_create_0__V')  # <V>
    @classmethod
    @overload
    def create(cls, table: Table[_create_0__R, _create_0__C, _create_0__V]) -> 'ArrayTable'[_create_0__R, _create_0__C, _create_0__V]: ...
    _create_1__R = _py_TypeVar('_create_1__R')  # <R>
    _create_1__C = _py_TypeVar('_create_1__C')  # <C>
    _create_1__V = _py_TypeVar('_create_1__V')  # <V>
    @classmethod
    @overload
    def create(cls, iterable: java.lang.Iterable[_create_1__R], iterable2: java.lang.Iterable[_create_1__C]) -> 'ArrayTable'[_create_1__R, _create_1__C, _create_1__V]: ...
    def equals(self, object: _py_Any) -> bool: ...
    def erase(self, object: _py_Any, object2: _py_Any) -> _ArrayTable__V: ...
    def eraseAll(self) -> None: ...
    def get(self, object: _py_Any, object2: _py_Any) -> _ArrayTable__V: ...
    def hashCode(self) -> int: ...
    def isEmpty(self) -> bool: ...
    def put(self, r: _ArrayTable__R, c: _ArrayTable__C, v: _ArrayTable__V) -> _ArrayTable__V: ...
    def putAll(self, table: Table[_ArrayTable__R, _ArrayTable__C, _ArrayTable__V]) -> None: ...
    def remove(self, object: _py_Any, object2: _py_Any) -> _ArrayTable__V: ...
    def row(self, r: _ArrayTable__R) -> java.util.Map[_ArrayTable__C, _ArrayTable__V]: ...
    def rowKeyList(self) -> 'ImmutableList'[_ArrayTable__R]: ...
    @overload
    def rowKeySet(self) -> 'ImmutableSet'[_ArrayTable__R]: ...
    @overload
    def rowKeySet(self) -> java.util.Set: ...
    def rowMap(self) -> java.util.Map[_ArrayTable__R, java.util.Map[_ArrayTable__C, _ArrayTable__V]]: ...
    def set(self, int: int, int2: int, v: _ArrayTable__V) -> _ArrayTable__V: ...
    def size(self) -> int: ...
    def toArray(self, class_: _py_Type[_ArrayTable__V]) -> _py_List[_py_List[_ArrayTable__V]]: ...
    def toString(self) -> str: ...
    def values(self) -> java.util.Collection[_ArrayTable__V]: ...

_BaseImmutableMultimap__K = _py_TypeVar('_BaseImmutableMultimap__K')  # <K>
_BaseImmutableMultimap__V = _py_TypeVar('_BaseImmutableMultimap__V')  # <V>
class BaseImmutableMultimap(AbstractMultimap[_BaseImmutableMultimap__K, _BaseImmutableMultimap__V], _py_Generic[_BaseImmutableMultimap__K, _BaseImmutableMultimap__V]): ...

_ConcurrentHashMultiset__E = _py_TypeVar('_ConcurrentHashMultiset__E')  # <E>
class ConcurrentHashMultiset(AbstractMultiset[_ConcurrentHashMultiset__E], java.io.Serializable, _py_Generic[_ConcurrentHashMultiset__E]):
    @overload
    def add(self, e: _ConcurrentHashMultiset__E) -> bool: ...
    @overload
    def add(self, e: _ConcurrentHashMultiset__E, int: int) -> int: ...
    def clear(self) -> None: ...
    def contains(self, object: _py_Any) -> bool: ...
    def count(self, object: _py_Any) -> int: ...
    _create_0__E = _py_TypeVar('_create_0__E')  # <E>
    @classmethod
    @overload
    def create(cls) -> 'ConcurrentHashMultiset'[_create_0__E]: ...
    _create_1__E = _py_TypeVar('_create_1__E')  # <E>
    @classmethod
    @overload
    def create(cls, iterable: java.lang.Iterable[_create_1__E]) -> 'ConcurrentHashMultiset'[_create_1__E]: ...
    _create_2__E = _py_TypeVar('_create_2__E')  # <E>
    @classmethod
    @overload
    def create(cls, concurrentMap: java.util.concurrent.ConcurrentMap[_create_2__E, java.util.concurrent.atomic.AtomicInteger]) -> 'ConcurrentHashMultiset'[_create_2__E]: ...
    def createEntrySet(self) -> java.util.Set[Multiset.Entry[_ConcurrentHashMultiset__E]]: ...
    def elementSet(self) -> java.util.Set: ...
    def entrySet(self) -> java.util.Set: ...
    def isEmpty(self) -> bool: ...
    def iterator(self) -> java.util.Iterator[_ConcurrentHashMultiset__E]: ...
    @overload
    def remove(self, object: _py_Any) -> bool: ...
    @overload
    def remove(self, object: _py_Any, int: int) -> int: ...
    def removeExactly(self, object: _py_Any, int: int) -> bool: ...
    @overload
    def setCount(self, e: _ConcurrentHashMultiset__E, int: int, int2: int) -> bool: ...
    @overload
    def setCount(self, e: _ConcurrentHashMultiset__E, int: int) -> int: ...
    def size(self) -> int: ...
    @overload
    def toArray(self) -> _py_List[_py_Any]: ...
    _toArray_1__T = _py_TypeVar('_toArray_1__T')  # <T>
    @overload
    def toArray(self, tArray: _py_List[_toArray_1__T]) -> _py_List[_toArray_1__T]: ...

_ConsumingQueueIterator__T = _py_TypeVar('_ConsumingQueueIterator__T')  # <T>
class ConsumingQueueIterator(AbstractIterator[_ConsumingQueueIterator__T], _py_Generic[_ConsumingQueueIterator__T]):
    def computeNext(self) -> _ConsumingQueueIterator__T: ...

_EnumMultiset__E = _py_TypeVar('_EnumMultiset__E', bound=java.lang.Enum)  # <E>
class EnumMultiset(AbstractMultiset[_EnumMultiset__E], java.io.Serializable, _py_Generic[_EnumMultiset__E]):
    @overload
    def add(self, e: _EnumMultiset__E) -> bool: ...
    @overload
    def add(self, e: _EnumMultiset__E, int: int) -> int: ...
    @overload
    def add(self, object: _py_Any, int: int) -> int: ...
    def clear(self) -> None: ...
    def contains(self, object: _py_Any) -> bool: ...
    def count(self, object: _py_Any) -> int: ...
    _create_0__E = _py_TypeVar('_create_0__E', bound=java.lang.Enum)  # <E>
    @classmethod
    @overload
    def create(cls, class_: _py_Type[_create_0__E]) -> 'EnumMultiset'[_create_0__E]: ...
    _create_1__E = _py_TypeVar('_create_1__E', bound=java.lang.Enum)  # <E>
    @classmethod
    @overload
    def create(cls, iterable: java.lang.Iterable[_create_1__E]) -> 'EnumMultiset'[_create_1__E]: ...
    _create_2__E = _py_TypeVar('_create_2__E', bound=java.lang.Enum)  # <E>
    @classmethod
    @overload
    def create(cls, iterable: java.lang.Iterable[_create_2__E], class_: _py_Type[_create_2__E]) -> 'EnumMultiset'[_create_2__E]: ...
    def elementSet(self) -> java.util.Set: ...
    def entrySet(self) -> java.util.Set: ...
    def forEachEntry(self, objIntConsumer: java.util.function.ObjIntConsumer[_EnumMultiset__E]) -> None: ...
    def isEmpty(self) -> bool: ...
    def iterator(self) -> java.util.Iterator[_EnumMultiset__E]: ...
    @overload
    def remove(self, object: _py_Any) -> bool: ...
    @overload
    def remove(self, object: _py_Any, int: int) -> int: ...
    @overload
    def setCount(self, e: _EnumMultiset__E, int: int, int2: int) -> bool: ...
    @overload
    def setCount(self, e: _EnumMultiset__E, int: int) -> int: ...
    @overload
    def setCount(self, object: _py_Any, int: int) -> int: ...
    def size(self) -> int: ...

_FilteredEntryMultimap__K = _py_TypeVar('_FilteredEntryMultimap__K')  # <K>
_FilteredEntryMultimap__V = _py_TypeVar('_FilteredEntryMultimap__V')  # <V>
class FilteredEntryMultimap(AbstractMultimap[_FilteredEntryMultimap__K, _FilteredEntryMultimap__V], FilteredMultimap[_FilteredEntryMultimap__K, _FilteredEntryMultimap__V], _py_Generic[_FilteredEntryMultimap__K, _FilteredEntryMultimap__V]):
    def clear(self) -> None: ...
    def containsKey(self, object: _py_Any) -> bool: ...
    def entryPredicate(self) -> com.google.common.base.Predicate[java.util.Map.Entry[_FilteredEntryMultimap__K, _FilteredEntryMultimap__V]]: ...
    def get(self, k: _FilteredEntryMultimap__K) -> java.util.Collection[_FilteredEntryMultimap__V]: ...
    def removeAll(self, object: _py_Any) -> java.util.Collection[_FilteredEntryMultimap__V]: ...
    def size(self) -> int: ...
    def unfiltered(self) -> Multimap[_FilteredEntryMultimap__K, _FilteredEntryMultimap__V]: ...

_FilteredKeyMultimap__K = _py_TypeVar('_FilteredKeyMultimap__K')  # <K>
_FilteredKeyMultimap__V = _py_TypeVar('_FilteredKeyMultimap__V')  # <V>
class FilteredKeyMultimap(AbstractMultimap[_FilteredKeyMultimap__K, _FilteredKeyMultimap__V], FilteredMultimap[_FilteredKeyMultimap__K, _FilteredKeyMultimap__V], _py_Generic[_FilteredKeyMultimap__K, _FilteredKeyMultimap__V]):
    def clear(self) -> None: ...
    def containsKey(self, object: _py_Any) -> bool: ...
    def entryPredicate(self) -> com.google.common.base.Predicate[java.util.Map.Entry[_FilteredKeyMultimap__K, _FilteredKeyMultimap__V]]: ...
    def get(self, k: _FilteredKeyMultimap__K) -> java.util.Collection[_FilteredKeyMultimap__V]: ...
    def removeAll(self, object: _py_Any) -> java.util.Collection[_FilteredKeyMultimap__V]: ...
    def size(self) -> int: ...
    def unfiltered(self) -> Multimap[_FilteredKeyMultimap__K, _FilteredKeyMultimap__V]: ...

_FilteredSetMultimap__K = _py_TypeVar('_FilteredSetMultimap__K')  # <K>
_FilteredSetMultimap__V = _py_TypeVar('_FilteredSetMultimap__V')  # <V>
class FilteredSetMultimap(FilteredMultimap[_FilteredSetMultimap__K, _FilteredSetMultimap__V], SetMultimap[_FilteredSetMultimap__K, _FilteredSetMultimap__V], _py_Generic[_FilteredSetMultimap__K, _FilteredSetMultimap__V]):
    @overload
    def equals(self, object: _py_Any) -> bool: ...
    @overload
    def equals(self, object: _py_Any) -> bool: ...
    def hashCode(self) -> int: ...
    @overload
    def unfiltered(self) -> SetMultimap[_FilteredSetMultimap__K, _FilteredSetMultimap__V]: ...
    @overload
    def unfiltered(self) -> Multimap: ...

_ForwardingConcurrentMap__K = _py_TypeVar('_ForwardingConcurrentMap__K')  # <K>
_ForwardingConcurrentMap__V = _py_TypeVar('_ForwardingConcurrentMap__V')  # <V>
class ForwardingConcurrentMap(ForwardingMap[_ForwardingConcurrentMap__K, _ForwardingConcurrentMap__V], java.util.concurrent.ConcurrentMap[_ForwardingConcurrentMap__K, _ForwardingConcurrentMap__V], _py_Generic[_ForwardingConcurrentMap__K, _ForwardingConcurrentMap__V]):
    def putIfAbsent(self, k: _ForwardingConcurrentMap__K, v: _ForwardingConcurrentMap__V) -> _ForwardingConcurrentMap__V: ...
    @overload
    def remove(self, object: _py_Any, object2: _py_Any) -> bool: ...
    @overload
    def remove(self, object: _py_Any) -> _ForwardingConcurrentMap__V: ...
    @overload
    def replace(self, k: _ForwardingConcurrentMap__K, v: _ForwardingConcurrentMap__V, v2: _ForwardingConcurrentMap__V) -> bool: ...
    @overload
    def replace(self, k: _ForwardingConcurrentMap__K, v: _ForwardingConcurrentMap__V) -> _ForwardingConcurrentMap__V: ...

_ForwardingList__E = _py_TypeVar('_ForwardingList__E')  # <E>
class ForwardingList(ForwardingCollection[_ForwardingList__E], java.util.List[_ForwardingList__E], _py_Generic[_ForwardingList__E]):
    @overload
    def add(self, e: _ForwardingList__E) -> bool: ...
    @overload
    def add(self, int: int, e: _ForwardingList__E) -> None: ...
    @overload
    def addAll(self, collection: java.util.Collection[_ForwardingList__E]) -> bool: ...
    @overload
    def addAll(self, int: int, collection: java.util.Collection[_ForwardingList__E]) -> bool: ...
    def equals(self, object: _py_Any) -> bool: ...
    def get(self, int: int) -> _ForwardingList__E: ...
    def hashCode(self) -> int: ...
    def indexOf(self, object: _py_Any) -> int: ...
    def lastIndexOf(self, object: _py_Any) -> int: ...
    @overload
    def listIterator(self) -> java.util.ListIterator[_ForwardingList__E]: ...
    @overload
    def listIterator(self, int: int) -> java.util.ListIterator[_ForwardingList__E]: ...
    @overload
    def remove(self, object: _py_Any) -> bool: ...
    @overload
    def remove(self, int: int) -> _ForwardingList__E: ...
    def set(self, int: int, e: _ForwardingList__E) -> _ForwardingList__E: ...
    def subList(self, int: int, int2: int) -> java.util.List[_ForwardingList__E]: ...

_ForwardingListIterator__E = _py_TypeVar('_ForwardingListIterator__E')  # <E>
class ForwardingListIterator(ForwardingIterator[_ForwardingListIterator__E], java.util.ListIterator[_ForwardingListIterator__E], _py_Generic[_ForwardingListIterator__E]):
    def add(self, e: _ForwardingListIterator__E) -> None: ...
    def hasPrevious(self) -> bool: ...
    def nextIndex(self) -> int: ...
    def previous(self) -> _ForwardingListIterator__E: ...
    def previousIndex(self) -> int: ...
    def set(self, e: _ForwardingListIterator__E) -> None: ...

_ForwardingListMultimap__K = _py_TypeVar('_ForwardingListMultimap__K')  # <K>
_ForwardingListMultimap__V = _py_TypeVar('_ForwardingListMultimap__V')  # <V>
class ForwardingListMultimap(ForwardingMultimap[_ForwardingListMultimap__K, _ForwardingListMultimap__V], ListMultimap[_ForwardingListMultimap__K, _ForwardingListMultimap__V], _py_Generic[_ForwardingListMultimap__K, _ForwardingListMultimap__V]):
    @overload
    def get(self, object: _py_Any) -> java.util.Collection: ...
    @overload
    def get(self, k: _ForwardingListMultimap__K) -> java.util.List[_ForwardingListMultimap__V]: ...
    @overload
    def removeAll(self, object: _py_Any) -> java.util.Collection: ...
    @overload
    def removeAll(self, object: _py_Any) -> java.util.List[_ForwardingListMultimap__V]: ...
    @overload
    def replaceValues(self, object: _py_Any, iterable: java.lang.Iterable) -> java.util.Collection: ...
    @overload
    def replaceValues(self, k: _ForwardingListMultimap__K, iterable: java.lang.Iterable[_ForwardingListMultimap__V]) -> java.util.List[_ForwardingListMultimap__V]: ...

_ForwardingMultiset__E = _py_TypeVar('_ForwardingMultiset__E')  # <E>
class ForwardingMultiset(ForwardingCollection[_ForwardingMultiset__E], Multiset[_ForwardingMultiset__E], _py_Generic[_ForwardingMultiset__E]):
    @overload
    def add(self, e: _ForwardingMultiset__E) -> bool: ...
    @overload
    def add(self, e: _ForwardingMultiset__E, int: int) -> int: ...
    def count(self, object: _py_Any) -> int: ...
    def elementSet(self) -> java.util.Set[_ForwardingMultiset__E]: ...
    def entrySet(self) -> java.util.Set[Multiset.Entry[_ForwardingMultiset__E]]: ...
    def equals(self, object: _py_Any) -> bool: ...
    def hashCode(self) -> int: ...
    @overload
    def remove(self, object: _py_Any) -> bool: ...
    @overload
    def remove(self, object: _py_Any, int: int) -> int: ...
    @overload
    def setCount(self, e: _ForwardingMultiset__E, int: int, int2: int) -> bool: ...
    @overload
    def setCount(self, e: _ForwardingMultiset__E, int: int) -> int: ...

_ForwardingQueue__E = _py_TypeVar('_ForwardingQueue__E')  # <E>
class ForwardingQueue(ForwardingCollection[_ForwardingQueue__E], java.util.Queue[_ForwardingQueue__E], _py_Generic[_ForwardingQueue__E]):
    def element(self) -> _ForwardingQueue__E: ...
    def offer(self, e: _ForwardingQueue__E) -> bool: ...
    def peek(self) -> _ForwardingQueue__E: ...
    def poll(self) -> _ForwardingQueue__E: ...
    @overload
    def remove(self, object: _py_Any) -> bool: ...
    @overload
    def remove(self) -> _ForwardingQueue__E: ...

_ForwardingSet__E = _py_TypeVar('_ForwardingSet__E')  # <E>
class ForwardingSet(ForwardingCollection[_ForwardingSet__E], java.util.Set[_ForwardingSet__E], _py_Generic[_ForwardingSet__E]):
    def equals(self, object: _py_Any) -> bool: ...
    def hashCode(self) -> int: ...

_ForwardingSetMultimap__K = _py_TypeVar('_ForwardingSetMultimap__K')  # <K>
_ForwardingSetMultimap__V = _py_TypeVar('_ForwardingSetMultimap__V')  # <V>
class ForwardingSetMultimap(ForwardingMultimap[_ForwardingSetMultimap__K, _ForwardingSetMultimap__V], SetMultimap[_ForwardingSetMultimap__K, _ForwardingSetMultimap__V], _py_Generic[_ForwardingSetMultimap__K, _ForwardingSetMultimap__V]):
    def __init__(self): ...
    @overload
    def entries(self) -> java.util.Collection: ...
    @overload
    def entries(self) -> java.util.Set[java.util.Map.Entry[_ForwardingSetMultimap__K, _ForwardingSetMultimap__V]]: ...
    @overload
    def get(self, object: _py_Any) -> java.util.Collection: ...
    @overload
    def get(self, k: _ForwardingSetMultimap__K) -> java.util.Set[_ForwardingSetMultimap__V]: ...
    @overload
    def removeAll(self, object: _py_Any) -> java.util.Collection: ...
    @overload
    def removeAll(self, object: _py_Any) -> java.util.Set[_ForwardingSetMultimap__V]: ...
    @overload
    def replaceValues(self, object: _py_Any, iterable: java.lang.Iterable) -> java.util.Collection: ...
    @overload
    def replaceValues(self, k: _ForwardingSetMultimap__K, iterable: java.lang.Iterable[_ForwardingSetMultimap__V]) -> java.util.Set[_ForwardingSetMultimap__V]: ...

_ForwardingSortedMap__K = _py_TypeVar('_ForwardingSortedMap__K')  # <K>
_ForwardingSortedMap__V = _py_TypeVar('_ForwardingSortedMap__V')  # <V>
class ForwardingSortedMap(ForwardingMap[_ForwardingSortedMap__K, _ForwardingSortedMap__V], java.util.SortedMap[_ForwardingSortedMap__K, _ForwardingSortedMap__V], _py_Generic[_ForwardingSortedMap__K, _ForwardingSortedMap__V]):
    def comparator(self) -> java.util.Comparator[_ForwardingSortedMap__K]: ...
    def firstKey(self) -> _ForwardingSortedMap__K: ...
    def headMap(self, k: _ForwardingSortedMap__K) -> java.util.SortedMap[_ForwardingSortedMap__K, _ForwardingSortedMap__V]: ...
    def lastKey(self) -> _ForwardingSortedMap__K: ...
    def subMap(self, k: _ForwardingSortedMap__K, k2: _ForwardingSortedMap__K) -> java.util.SortedMap[_ForwardingSortedMap__K, _ForwardingSortedMap__V]: ...
    def tailMap(self, k: _ForwardingSortedMap__K) -> java.util.SortedMap[_ForwardingSortedMap__K, _ForwardingSortedMap__V]: ...

_ImmutableClassToInstanceMap__Builder__B = _py_TypeVar('_ImmutableClassToInstanceMap__Builder__B')  # <B>
_ImmutableClassToInstanceMap__B = _py_TypeVar('_ImmutableClassToInstanceMap__B')  # <B>
class ImmutableClassToInstanceMap(ForwardingMap[_py_Type[_ImmutableClassToInstanceMap__B], _ImmutableClassToInstanceMap__B], ClassToInstanceMap[_ImmutableClassToInstanceMap__B], java.io.Serializable, _py_Generic[_ImmutableClassToInstanceMap__B]):
    _builder__B = _py_TypeVar('_builder__B')  # <B>
    @classmethod
    def builder(cls) -> 'ImmutableClassToInstanceMap.Builder'[_builder__B]: ...
    _copyOf__B = _py_TypeVar('_copyOf__B')  # <B>
    _copyOf__S = _py_TypeVar('_copyOf__S')  # <S>
    @classmethod
    def copyOf(cls, map: java.util.Map[_py_Type[_copyOf__S], _copyOf__S]) -> 'ImmutableClassToInstanceMap'[_copyOf__B]: ...
    _getInstance__T = _py_TypeVar('_getInstance__T')  # <T>
    def getInstance(self, class_: _py_Type[_getInstance__T]) -> _getInstance__T: ...
    _of_0__B = _py_TypeVar('_of_0__B')  # <B>
    @classmethod
    @overload
    def of(cls) -> 'ImmutableClassToInstanceMap'[_of_0__B]: ...
    _of_1__B = _py_TypeVar('_of_1__B')  # <B>
    _of_1__T = _py_TypeVar('_of_1__T')  # <T>
    @classmethod
    @overload
    def of(cls, class_: _py_Type[_of_1__T], t: _of_1__T) -> 'ImmutableClassToInstanceMap'[_of_1__B]: ...
    _putInstance__T = _py_TypeVar('_putInstance__T')  # <T>
    def putInstance(self, class_: _py_Type[_putInstance__T], t: _putInstance__T) -> _putInstance__T: ...
    class Builder(_py_Generic[_ImmutableClassToInstanceMap__Builder__B]):
        def __init__(self): ...
        def build(self) -> 'ImmutableClassToInstanceMap'[_ImmutableClassToInstanceMap__Builder__B]: ...
        _put__T = _py_TypeVar('_put__T')  # <T>
        def put(self, class_: _py_Type[_put__T], t: _put__T) -> 'ImmutableClassToInstanceMap.Builder'[_ImmutableClassToInstanceMap__Builder__B]: ...
        _putAll__T = _py_TypeVar('_putAll__T')  # <T>
        def putAll(self, map: java.util.Map[_py_Type[_putAll__T], _putAll__T]) -> 'ImmutableClassToInstanceMap.Builder'[_ImmutableClassToInstanceMap__Builder__B]: ...

_ImmutableMapEntry__K = _py_TypeVar('_ImmutableMapEntry__K')  # <K>
_ImmutableMapEntry__V = _py_TypeVar('_ImmutableMapEntry__V')  # <V>
class ImmutableMapEntry(ImmutableEntry[_ImmutableMapEntry__K, _ImmutableMapEntry__V], _py_Generic[_ImmutableMapEntry__K, _ImmutableMapEntry__V]): ...

_ImmutableRangeSet__Builder__C = _py_TypeVar('_ImmutableRangeSet__Builder__C', bound=java.lang.Comparable)  # <C>
_ImmutableRangeSet__C = _py_TypeVar('_ImmutableRangeSet__C', bound=java.lang.Comparable)  # <C>
class ImmutableRangeSet(AbstractRangeSet[_ImmutableRangeSet__C], java.io.Serializable, _py_Generic[_ImmutableRangeSet__C]):
    def add(self, range: Range[_ImmutableRangeSet__C]) -> None: ...
    @overload
    def addAll(self, rangeSet: RangeSet[_ImmutableRangeSet__C]) -> None: ...
    @overload
    def addAll(self, iterable: java.lang.Iterable[Range[_ImmutableRangeSet__C]]) -> None: ...
    @overload
    def asDescendingSetOfRanges(self) -> 'ImmutableSet'[Range[_ImmutableRangeSet__C]]: ...
    @overload
    def asDescendingSetOfRanges(self) -> java.util.Set: ...
    @overload
    def asRanges(self) -> 'ImmutableSet'[Range[_ImmutableRangeSet__C]]: ...
    @overload
    def asRanges(self) -> java.util.Set: ...
    def asSet(self, discreteDomain: DiscreteDomain[_ImmutableRangeSet__C]) -> 'ImmutableSortedSet'[_ImmutableRangeSet__C]: ...
    _builder__C = _py_TypeVar('_builder__C', bound=java.lang.Comparable)  # <C>
    @classmethod
    def builder(cls) -> 'ImmutableRangeSet.Builder'[_builder__C]: ...
    def clear(self) -> None: ...
    @overload
    def complement(self) -> 'ImmutableRangeSet'[_ImmutableRangeSet__C]: ...
    @overload
    def complement(self) -> RangeSet: ...
    def contains(self, comparable: java.lang.Comparable) -> bool: ...
    _copyOf_0__C = _py_TypeVar('_copyOf_0__C', bound=java.lang.Comparable)  # <C>
    @classmethod
    @overload
    def copyOf(cls, rangeSet: RangeSet[_copyOf_0__C]) -> 'ImmutableRangeSet'[_copyOf_0__C]: ...
    _copyOf_1__C = _py_TypeVar('_copyOf_1__C', bound=java.lang.Comparable)  # <C>
    @classmethod
    @overload
    def copyOf(cls, iterable: java.lang.Iterable[Range[_copyOf_1__C]]) -> 'ImmutableRangeSet'[_copyOf_1__C]: ...
    def difference(self, rangeSet: RangeSet[_ImmutableRangeSet__C]) -> 'ImmutableRangeSet'[_ImmutableRangeSet__C]: ...
    def encloses(self, range: Range[_ImmutableRangeSet__C]) -> bool: ...
    @overload
    def enclosesAll(self, rangeSet: RangeSet) -> bool: ...
    @overload
    def enclosesAll(self, iterable: java.lang.Iterable[Range[_ImmutableRangeSet__C]]) -> bool: ...
    def equals(self, object: _py_Any) -> bool: ...
    def intersection(self, rangeSet: RangeSet[_ImmutableRangeSet__C]) -> 'ImmutableRangeSet'[_ImmutableRangeSet__C]: ...
    def intersects(self, range: Range[_ImmutableRangeSet__C]) -> bool: ...
    def isEmpty(self) -> bool: ...
    _of_0__C = _py_TypeVar('_of_0__C', bound=java.lang.Comparable)  # <C>
    @classmethod
    @overload
    def of(cls) -> 'ImmutableRangeSet'[_of_0__C]: ...
    _of_1__C = _py_TypeVar('_of_1__C', bound=java.lang.Comparable)  # <C>
    @classmethod
    @overload
    def of(cls, range: Range[_of_1__C]) -> 'ImmutableRangeSet'[_of_1__C]: ...
    def rangeContaining(self, c: _ImmutableRangeSet__C) -> Range[_ImmutableRangeSet__C]: ...
    def remove(self, range: Range[_ImmutableRangeSet__C]) -> None: ...
    @overload
    def removeAll(self, rangeSet: RangeSet[_ImmutableRangeSet__C]) -> None: ...
    @overload
    def removeAll(self, iterable: java.lang.Iterable[Range[_ImmutableRangeSet__C]]) -> None: ...
    def span(self) -> Range[_ImmutableRangeSet__C]: ...
    @overload
    def subRangeSet(self, range: Range[_ImmutableRangeSet__C]) -> 'ImmutableRangeSet'[_ImmutableRangeSet__C]: ...
    @overload
    def subRangeSet(self, range: Range) -> RangeSet: ...
    _toImmutableRangeSet__E = _py_TypeVar('_toImmutableRangeSet__E', bound=java.lang.Comparable)  # <E>
    @classmethod
    def toImmutableRangeSet(cls) -> java.util.stream.Collector[Range[_toImmutableRangeSet__E], _py_Any, 'ImmutableRangeSet'[_toImmutableRangeSet__E]]: ...
    def union(self, rangeSet: RangeSet[_ImmutableRangeSet__C]) -> 'ImmutableRangeSet'[_ImmutableRangeSet__C]: ...
    _unionOf__C = _py_TypeVar('_unionOf__C', bound=java.lang.Comparable)  # <C>
    @classmethod
    def unionOf(cls, iterable: java.lang.Iterable[Range[_unionOf__C]]) -> 'ImmutableRangeSet'[_unionOf__C]: ...
    class Builder(_py_Generic[_ImmutableRangeSet__Builder__C]):
        def __init__(self): ...
        def add(self, range: Range[_ImmutableRangeSet__Builder__C]) -> 'ImmutableRangeSet.Builder'[_ImmutableRangeSet__Builder__C]: ...
        @overload
        def addAll(self, rangeSet: RangeSet[_ImmutableRangeSet__Builder__C]) -> 'ImmutableRangeSet.Builder'[_ImmutableRangeSet__Builder__C]: ...
        @overload
        def addAll(self, iterable: java.lang.Iterable[Range[_ImmutableRangeSet__Builder__C]]) -> 'ImmutableRangeSet.Builder'[_ImmutableRangeSet__Builder__C]: ...
        def build(self) -> 'ImmutableRangeSet'[_ImmutableRangeSet__Builder__C]: ...

_ImmutableTable__Builder__R = _py_TypeVar('_ImmutableTable__Builder__R')  # <R>
_ImmutableTable__Builder__C = _py_TypeVar('_ImmutableTable__Builder__C')  # <C>
_ImmutableTable__Builder__V = _py_TypeVar('_ImmutableTable__Builder__V')  # <V>
_ImmutableTable__R = _py_TypeVar('_ImmutableTable__R')  # <R>
_ImmutableTable__C = _py_TypeVar('_ImmutableTable__C')  # <C>
_ImmutableTable__V = _py_TypeVar('_ImmutableTable__V')  # <V>
class ImmutableTable(AbstractTable[_ImmutableTable__R, _ImmutableTable__C, _ImmutableTable__V], java.io.Serializable, _py_Generic[_ImmutableTable__R, _ImmutableTable__C, _ImmutableTable__V]):
    _builder__R = _py_TypeVar('_builder__R')  # <R>
    _builder__C = _py_TypeVar('_builder__C')  # <C>
    _builder__V = _py_TypeVar('_builder__V')  # <V>
    @classmethod
    def builder(cls) -> 'ImmutableTable.Builder'[_builder__R, _builder__C, _builder__V]: ...
    @overload
    def cellSet(self) -> 'ImmutableSet'[Table.Cell[_ImmutableTable__R, _ImmutableTable__C, _ImmutableTable__V]]: ...
    @overload
    def cellSet(self) -> java.util.Set: ...
    def clear(self) -> None: ...
    @overload
    def column(self, c: _ImmutableTable__C) -> ImmutableMap[_ImmutableTable__R, _ImmutableTable__V]: ...
    @overload
    def column(self, object: _py_Any) -> java.util.Map: ...
    @overload
    def columnKeySet(self) -> 'ImmutableSet'[_ImmutableTable__C]: ...
    @overload
    def columnKeySet(self) -> java.util.Set: ...
    @overload
    def columnMap(self) -> ImmutableMap[_ImmutableTable__C, java.util.Map[_ImmutableTable__R, _ImmutableTable__V]]: ...
    @overload
    def columnMap(self) -> java.util.Map: ...
    def contains(self, object: _py_Any, object2: _py_Any) -> bool: ...
    def containsColumn(self, object: _py_Any) -> bool: ...
    def containsRow(self, object: _py_Any) -> bool: ...
    def containsValue(self, object: _py_Any) -> bool: ...
    _copyOf__R = _py_TypeVar('_copyOf__R')  # <R>
    _copyOf__C = _py_TypeVar('_copyOf__C')  # <C>
    _copyOf__V = _py_TypeVar('_copyOf__V')  # <V>
    @classmethod
    def copyOf(cls, table: Table[_copyOf__R, _copyOf__C, _copyOf__V]) -> 'ImmutableTable'[_copyOf__R, _copyOf__C, _copyOf__V]: ...
    def equals(self, object: _py_Any) -> bool: ...
    def get(self, object: _py_Any, object2: _py_Any) -> _py_Any: ...
    def hashCode(self) -> int: ...
    def isEmpty(self) -> bool: ...
    _of_0__R = _py_TypeVar('_of_0__R')  # <R>
    _of_0__C = _py_TypeVar('_of_0__C')  # <C>
    _of_0__V = _py_TypeVar('_of_0__V')  # <V>
    @classmethod
    @overload
    def of(cls) -> 'ImmutableTable'[_of_0__R, _of_0__C, _of_0__V]: ...
    _of_1__R = _py_TypeVar('_of_1__R')  # <R>
    _of_1__C = _py_TypeVar('_of_1__C')  # <C>
    _of_1__V = _py_TypeVar('_of_1__V')  # <V>
    @classmethod
    @overload
    def of(cls, r: _of_1__R, c2: _of_1__C, v: _of_1__V) -> 'ImmutableTable'[_of_1__R, _of_1__C, _of_1__V]: ...
    def put(self, r: _ImmutableTable__R, c: _ImmutableTable__C, v: _ImmutableTable__V) -> _ImmutableTable__V: ...
    def putAll(self, table: Table[_ImmutableTable__R, _ImmutableTable__C, _ImmutableTable__V]) -> None: ...
    def remove(self, object: _py_Any, object2: _py_Any) -> _ImmutableTable__V: ...
    @overload
    def row(self, r: _ImmutableTable__R) -> ImmutableMap[_ImmutableTable__C, _ImmutableTable__V]: ...
    @overload
    def row(self, object: _py_Any) -> java.util.Map: ...
    @overload
    def rowKeySet(self) -> 'ImmutableSet'[_ImmutableTable__R]: ...
    @overload
    def rowKeySet(self) -> java.util.Set: ...
    @overload
    def rowMap(self) -> ImmutableMap[_ImmutableTable__R, java.util.Map[_ImmutableTable__C, _ImmutableTable__V]]: ...
    @overload
    def rowMap(self) -> java.util.Map: ...
    _toImmutableTable_0__T = _py_TypeVar('_toImmutableTable_0__T')  # <T>
    _toImmutableTable_0__R = _py_TypeVar('_toImmutableTable_0__R')  # <R>
    _toImmutableTable_0__C = _py_TypeVar('_toImmutableTable_0__C')  # <C>
    _toImmutableTable_0__V = _py_TypeVar('_toImmutableTable_0__V')  # <V>
    @classmethod
    @overload
    def toImmutableTable(cls, function: java.util.function.Function[_toImmutableTable_0__T, _toImmutableTable_0__R], function2: java.util.function.Function[_toImmutableTable_0__T, _toImmutableTable_0__C], function3: java.util.function.Function[_toImmutableTable_0__T, _toImmutableTable_0__V]) -> java.util.stream.Collector[_toImmutableTable_0__T, _py_Any, 'ImmutableTable'[_toImmutableTable_0__R, _toImmutableTable_0__C, _toImmutableTable_0__V]]: ...
    _toImmutableTable_1__T = _py_TypeVar('_toImmutableTable_1__T')  # <T>
    _toImmutableTable_1__R = _py_TypeVar('_toImmutableTable_1__R')  # <R>
    _toImmutableTable_1__C = _py_TypeVar('_toImmutableTable_1__C')  # <C>
    _toImmutableTable_1__V = _py_TypeVar('_toImmutableTable_1__V')  # <V>
    @classmethod
    @overload
    def toImmutableTable(cls, function: java.util.function.Function[_toImmutableTable_1__T, _toImmutableTable_1__R], function2: java.util.function.Function[_toImmutableTable_1__T, _toImmutableTable_1__C], function3: java.util.function.Function[_toImmutableTable_1__T, _toImmutableTable_1__V], binaryOperator: java.util.function.BinaryOperator[_toImmutableTable_1__V]) -> java.util.stream.Collector[_toImmutableTable_1__T, _py_Any, 'ImmutableTable'[_toImmutableTable_1__R, _toImmutableTable_1__C, _toImmutableTable_1__V]]: ...
    def toString(self) -> str: ...
    @overload
    def values(self) -> ImmutableCollection[_ImmutableTable__V]: ...
    @overload
    def values(self) -> java.util.Collection: ...
    class Builder(_py_Generic[_ImmutableTable__Builder__R, _ImmutableTable__Builder__C, _ImmutableTable__Builder__V]):
        def __init__(self): ...
        def build(self) -> 'ImmutableTable'[_ImmutableTable__Builder__R, _ImmutableTable__Builder__C, _ImmutableTable__Builder__V]: ...
        def orderColumnsBy(self, comparator: java.util.Comparator[_ImmutableTable__Builder__C]) -> 'ImmutableTable.Builder'[_ImmutableTable__Builder__R, _ImmutableTable__Builder__C, _ImmutableTable__Builder__V]: ...
        def orderRowsBy(self, comparator: java.util.Comparator[_ImmutableTable__Builder__R]) -> 'ImmutableTable.Builder'[_ImmutableTable__Builder__R, _ImmutableTable__Builder__C, _ImmutableTable__Builder__V]: ...
        @overload
        def put(self, cell: Table.Cell[_ImmutableTable__Builder__R, _ImmutableTable__Builder__C, _ImmutableTable__Builder__V]) -> 'ImmutableTable.Builder'[_ImmutableTable__Builder__R, _ImmutableTable__Builder__C, _ImmutableTable__Builder__V]: ...
        @overload
        def put(self, r: _ImmutableTable__Builder__R, c: _ImmutableTable__Builder__C, v: _ImmutableTable__Builder__V) -> 'ImmutableTable.Builder'[_ImmutableTable__Builder__R, _ImmutableTable__Builder__C, _ImmutableTable__Builder__V]: ...
        def putAll(self, table: Table[_ImmutableTable__Builder__R, _ImmutableTable__Builder__C, _ImmutableTable__Builder__V]) -> 'ImmutableTable.Builder'[_ImmutableTable__Builder__R, _ImmutableTable__Builder__C, _ImmutableTable__Builder__V]: ...

_LinkedListMultimap__K = _py_TypeVar('_LinkedListMultimap__K')  # <K>
_LinkedListMultimap__V = _py_TypeVar('_LinkedListMultimap__V')  # <V>
class LinkedListMultimap(AbstractMultimap[_LinkedListMultimap__K, _LinkedListMultimap__V], ListMultimap[_LinkedListMultimap__K, _LinkedListMultimap__V], java.io.Serializable, _py_Generic[_LinkedListMultimap__K, _LinkedListMultimap__V]):
    def asMap(self) -> java.util.Map: ...
    def clear(self) -> None: ...
    def containsEntry(self, object: _py_Any, object2: _py_Any) -> bool: ...
    def containsKey(self, object: _py_Any) -> bool: ...
    def containsValue(self, object: _py_Any) -> bool: ...
    _create_0__K = _py_TypeVar('_create_0__K')  # <K>
    _create_0__V = _py_TypeVar('_create_0__V')  # <V>
    @classmethod
    @overload
    def create(cls) -> 'LinkedListMultimap'[_create_0__K, _create_0__V]: ...
    _create_1__K = _py_TypeVar('_create_1__K')  # <K>
    _create_1__V = _py_TypeVar('_create_1__V')  # <V>
    @classmethod
    @overload
    def create(cls, multimap: Multimap[_create_1__K, _create_1__V]) -> 'LinkedListMultimap'[_create_1__K, _create_1__V]: ...
    _create_2__K = _py_TypeVar('_create_2__K')  # <K>
    _create_2__V = _py_TypeVar('_create_2__V')  # <V>
    @classmethod
    @overload
    def create(cls, int: int) -> 'LinkedListMultimap'[_create_2__K, _create_2__V]: ...
    @overload
    def entries(self) -> java.util.Collection: ...
    @overload
    def entries(self) -> java.util.List[java.util.Map.Entry[_LinkedListMultimap__K, _LinkedListMultimap__V]]: ...
    def equals(self, object: _py_Any) -> bool: ...
    @overload
    def get(self, object: _py_Any) -> java.util.Collection: ...
    @overload
    def get(self, k: _LinkedListMultimap__K) -> java.util.List[_LinkedListMultimap__V]: ...
    def hashCode(self) -> int: ...
    def isEmpty(self) -> bool: ...
    def keySet(self) -> java.util.Set: ...
    def keys(self) -> Multiset: ...
    def put(self, k: _LinkedListMultimap__K, v: _LinkedListMultimap__V) -> bool: ...
    @overload
    def putAll(self, multimap: Multimap) -> bool: ...
    @overload
    def putAll(self, object: _py_Any, iterable: java.lang.Iterable) -> bool: ...
    def remove(self, object: _py_Any, object2: _py_Any) -> bool: ...
    @overload
    def removeAll(self, object: _py_Any) -> java.util.Collection: ...
    @overload
    def removeAll(self, object: _py_Any) -> java.util.List[_LinkedListMultimap__V]: ...
    @overload
    def replaceValues(self, object: _py_Any, iterable: java.lang.Iterable) -> java.util.Collection: ...
    @overload
    def replaceValues(self, k: _LinkedListMultimap__K, iterable: java.lang.Iterable[_LinkedListMultimap__V]) -> java.util.List[_LinkedListMultimap__V]: ...
    def size(self) -> int: ...
    def toString(self) -> str: ...
    @overload
    def values(self) -> java.util.Collection: ...
    @overload
    def values(self) -> java.util.List[_LinkedListMultimap__V]: ...

_MutableClassToInstanceMap__B = _py_TypeVar('_MutableClassToInstanceMap__B')  # <B>
class MutableClassToInstanceMap(ForwardingMap[_py_Type[_MutableClassToInstanceMap__B], _MutableClassToInstanceMap__B], ClassToInstanceMap[_MutableClassToInstanceMap__B], java.io.Serializable, _py_Generic[_MutableClassToInstanceMap__B]):
    _create_0__B = _py_TypeVar('_create_0__B')  # <B>
    @classmethod
    @overload
    def create(cls) -> 'MutableClassToInstanceMap'[_create_0__B]: ...
    _create_1__B = _py_TypeVar('_create_1__B')  # <B>
    @classmethod
    @overload
    def create(cls, map: java.util.Map[_py_Type[_create_1__B], _create_1__B]) -> 'MutableClassToInstanceMap'[_create_1__B]: ...
    def entrySet(self) -> java.util.Set[java.util.Map.Entry[_py_Type[_MutableClassToInstanceMap__B], _MutableClassToInstanceMap__B]]: ...
    _getInstance__T = _py_TypeVar('_getInstance__T')  # <T>
    def getInstance(self, class_: _py_Type[_getInstance__T]) -> _getInstance__T: ...
    @overload
    def put(self, class_: _py_Type[_MutableClassToInstanceMap__B], b: _MutableClassToInstanceMap__B) -> _MutableClassToInstanceMap__B: ...
    @overload
    def put(self, object: _py_Any, object2: _py_Any) -> _py_Any: ...
    def putAll(self, map: java.util.Map[_py_Type[_MutableClassToInstanceMap__B], _MutableClassToInstanceMap__B]) -> None: ...
    _putInstance__T = _py_TypeVar('_putInstance__T')  # <T>
    def putInstance(self, class_: _py_Type[_putInstance__T], t: _putInstance__T) -> _putInstance__T: ...

_SortedMultiset__E = _py_TypeVar('_SortedMultiset__E')  # <E>
class SortedMultiset(SortedMultisetBridge[_SortedMultiset__E], SortedIterable[_SortedMultiset__E], _py_Generic[_SortedMultiset__E]):
    def comparator(self) -> java.util.Comparator[_SortedMultiset__E]: ...
    def descendingMultiset(self) -> 'SortedMultiset'[_SortedMultiset__E]: ...
    @overload
    def elementSet(self) -> java.util.NavigableSet[_SortedMultiset__E]: ...
    @overload
    def elementSet(self) -> java.util.Set: ...
    @overload
    def elementSet(self) -> java.util.SortedSet: ...
    def entrySet(self) -> java.util.Set[Multiset.Entry[_SortedMultiset__E]]: ...
    def equals(self, object: _py_Any) -> bool: ...
    def firstEntry(self) -> Multiset.Entry[_SortedMultiset__E]: ...
    def hashCode(self) -> int: ...
    def headMultiset(self, e: _SortedMultiset__E, boundType: BoundType) -> 'SortedMultiset'[_SortedMultiset__E]: ...
    def iterator(self) -> java.util.Iterator[_SortedMultiset__E]: ...
    def lastEntry(self) -> Multiset.Entry[_SortedMultiset__E]: ...
    def pollFirstEntry(self) -> Multiset.Entry[_SortedMultiset__E]: ...
    def pollLastEntry(self) -> Multiset.Entry[_SortedMultiset__E]: ...
    def subMultiset(self, e: _SortedMultiset__E, boundType: BoundType, e2: _SortedMultiset__E, boundType2: BoundType) -> 'SortedMultiset'[_SortedMultiset__E]: ...
    def tailMultiset(self, e: _SortedMultiset__E, boundType: BoundType) -> 'SortedMultiset'[_SortedMultiset__E]: ...
    def toString(self) -> str: ...

_SortedSetMultimap__K = _py_TypeVar('_SortedSetMultimap__K')  # <K>
_SortedSetMultimap__V = _py_TypeVar('_SortedSetMultimap__V')  # <V>
class SortedSetMultimap(SetMultimap[_SortedSetMultimap__K, _SortedSetMultimap__V], _py_Generic[_SortedSetMultimap__K, _SortedSetMultimap__V]):
    def asMap(self) -> java.util.Map[_SortedSetMultimap__K, java.util.Collection[_SortedSetMultimap__V]]: ...
    def equals(self, object: _py_Any) -> bool: ...
    @overload
    def get(self, k: _SortedSetMultimap__K) -> java.util.SortedSet[_SortedSetMultimap__V]: ...
    @overload
    def get(self, object: _py_Any) -> java.util.Collection: ...
    @overload
    def get(self, object: _py_Any) -> java.util.Set: ...
    def hashCode(self) -> int: ...
    @overload
    def removeAll(self, object: _py_Any) -> java.util.SortedSet[_SortedSetMultimap__V]: ...
    @overload
    def removeAll(self, object: _py_Any) -> java.util.Collection: ...
    @overload
    def removeAll(self, object: _py_Any) -> java.util.Set: ...
    @overload
    def replaceValues(self, k: _SortedSetMultimap__K, iterable: java.lang.Iterable[_SortedSetMultimap__V]) -> java.util.SortedSet[_SortedSetMultimap__V]: ...
    @overload
    def replaceValues(self, object: _py_Any, iterable: java.lang.Iterable) -> java.util.Collection: ...
    @overload
    def replaceValues(self, object: _py_Any, iterable: java.lang.Iterable) -> java.util.Set: ...
    def valueComparator(self) -> java.util.Comparator[_SortedSetMultimap__V]: ...

_StandardTable__R = _py_TypeVar('_StandardTable__R')  # <R>
_StandardTable__C = _py_TypeVar('_StandardTable__C')  # <C>
_StandardTable__V = _py_TypeVar('_StandardTable__V')  # <V>
class StandardTable(AbstractTable[_StandardTable__R, _StandardTable__C, _StandardTable__V], java.io.Serializable, _py_Generic[_StandardTable__R, _StandardTable__C, _StandardTable__V]):
    def cellSet(self) -> java.util.Set[Table.Cell[_StandardTable__R, _StandardTable__C, _StandardTable__V]]: ...
    def clear(self) -> None: ...
    def column(self, c: _StandardTable__C) -> java.util.Map[_StandardTable__R, _StandardTable__V]: ...
    def columnKeySet(self) -> java.util.Set[_StandardTable__C]: ...
    def columnMap(self) -> java.util.Map[_StandardTable__C, java.util.Map[_StandardTable__R, _StandardTable__V]]: ...
    def contains(self, object: _py_Any, object2: _py_Any) -> bool: ...
    def containsColumn(self, object: _py_Any) -> bool: ...
    def containsRow(self, object: _py_Any) -> bool: ...
    def containsValue(self, object: _py_Any) -> bool: ...
    def get(self, object: _py_Any, object2: _py_Any) -> _StandardTable__V: ...
    def isEmpty(self) -> bool: ...
    def put(self, r: _StandardTable__R, c: _StandardTable__C, v: _StandardTable__V) -> _StandardTable__V: ...
    def remove(self, object: _py_Any, object2: _py_Any) -> _StandardTable__V: ...
    def row(self, r: _StandardTable__R) -> java.util.Map[_StandardTable__C, _StandardTable__V]: ...
    def rowKeySet(self) -> java.util.Set[_StandardTable__R]: ...
    def rowMap(self) -> java.util.Map[_StandardTable__R, java.util.Map[_StandardTable__C, _StandardTable__V]]: ...
    def size(self) -> int: ...
    def values(self) -> java.util.Collection[_StandardTable__V]: ...

_TreeRangeSet__C = _py_TypeVar('_TreeRangeSet__C', bound=java.lang.Comparable)  # <C>
class TreeRangeSet(AbstractRangeSet[_TreeRangeSet__C], java.io.Serializable, _py_Generic[_TreeRangeSet__C]):
    def add(self, range: Range[_TreeRangeSet__C]) -> None: ...
    @overload
    def addAll(self, iterable: java.lang.Iterable[Range[_TreeRangeSet__C]]) -> None: ...
    @overload
    def addAll(self, rangeSet: RangeSet) -> None: ...
    def asDescendingSetOfRanges(self) -> java.util.Set[Range[_TreeRangeSet__C]]: ...
    def asRanges(self) -> java.util.Set[Range[_TreeRangeSet__C]]: ...
    def clear(self) -> None: ...
    def complement(self) -> RangeSet[_TreeRangeSet__C]: ...
    def contains(self, comparable: java.lang.Comparable) -> bool: ...
    _create_0__C = _py_TypeVar('_create_0__C', bound=java.lang.Comparable)  # <C>
    @classmethod
    @overload
    def create(cls) -> 'TreeRangeSet'[_create_0__C]: ...
    _create_1__C = _py_TypeVar('_create_1__C', bound=java.lang.Comparable)  # <C>
    @classmethod
    @overload
    def create(cls, rangeSet: RangeSet[_create_1__C]) -> 'TreeRangeSet'[_create_1__C]: ...
    _create_2__C = _py_TypeVar('_create_2__C', bound=java.lang.Comparable)  # <C>
    @classmethod
    @overload
    def create(cls, iterable: java.lang.Iterable[Range[_create_2__C]]) -> 'TreeRangeSet'[_create_2__C]: ...
    def encloses(self, range: Range[_TreeRangeSet__C]) -> bool: ...
    @overload
    def enclosesAll(self, rangeSet: RangeSet) -> bool: ...
    @overload
    def enclosesAll(self, iterable: java.lang.Iterable[Range[_TreeRangeSet__C]]) -> bool: ...
    def equals(self, object: _py_Any) -> bool: ...
    def intersects(self, range: Range[_TreeRangeSet__C]) -> bool: ...
    def isEmpty(self) -> bool: ...
    def rangeContaining(self, c: _TreeRangeSet__C) -> Range[_TreeRangeSet__C]: ...
    def remove(self, range: Range[_TreeRangeSet__C]) -> None: ...
    @overload
    def removeAll(self, iterable: java.lang.Iterable[Range[_TreeRangeSet__C]]) -> None: ...
    @overload
    def removeAll(self, rangeSet: RangeSet) -> None: ...
    def span(self) -> Range[_TreeRangeSet__C]: ...
    def subRangeSet(self, range: Range[_TreeRangeSet__C]) -> RangeSet[_TreeRangeSet__C]: ...

_AbstractListMultimap__K = _py_TypeVar('_AbstractListMultimap__K')  # <K>
_AbstractListMultimap__V = _py_TypeVar('_AbstractListMultimap__V')  # <V>
class AbstractListMultimap(AbstractMapBasedMultimap[_AbstractListMultimap__K, _AbstractListMultimap__V], ListMultimap[_AbstractListMultimap__K, _AbstractListMultimap__V], _py_Generic[_AbstractListMultimap__K, _AbstractListMultimap__V]):
    def asMap(self) -> java.util.Map[_AbstractListMultimap__K, java.util.Collection[_AbstractListMultimap__V]]: ...
    def equals(self, object: _py_Any) -> bool: ...
    @overload
    def get(self, object: _py_Any) -> java.util.Collection: ...
    @overload
    def get(self, k: _AbstractListMultimap__K) -> java.util.List[_AbstractListMultimap__V]: ...
    def put(self, k: _AbstractListMultimap__K, v: _AbstractListMultimap__V) -> bool: ...
    @overload
    def removeAll(self, object: _py_Any) -> java.util.Collection: ...
    @overload
    def removeAll(self, object: _py_Any) -> java.util.List[_AbstractListMultimap__V]: ...
    @overload
    def replaceValues(self, object: _py_Any, iterable: java.lang.Iterable) -> java.util.Collection: ...
    @overload
    def replaceValues(self, k: _AbstractListMultimap__K, iterable: java.lang.Iterable[_AbstractListMultimap__V]) -> java.util.List[_AbstractListMultimap__V]: ...

_AbstractSetMultimap__K = _py_TypeVar('_AbstractSetMultimap__K')  # <K>
_AbstractSetMultimap__V = _py_TypeVar('_AbstractSetMultimap__V')  # <V>
class AbstractSetMultimap(AbstractMapBasedMultimap[_AbstractSetMultimap__K, _AbstractSetMultimap__V], SetMultimap[_AbstractSetMultimap__K, _AbstractSetMultimap__V], _py_Generic[_AbstractSetMultimap__K, _AbstractSetMultimap__V]):
    def asMap(self) -> java.util.Map[_AbstractSetMultimap__K, java.util.Collection[_AbstractSetMultimap__V]]: ...
    @overload
    def entries(self) -> java.util.Collection: ...
    @overload
    def entries(self) -> java.util.Set[java.util.Map.Entry[_AbstractSetMultimap__K, _AbstractSetMultimap__V]]: ...
    def equals(self, object: _py_Any) -> bool: ...
    @overload
    def get(self, object: _py_Any) -> java.util.Collection: ...
    @overload
    def get(self, k: _AbstractSetMultimap__K) -> java.util.Set[_AbstractSetMultimap__V]: ...
    def put(self, k: _AbstractSetMultimap__K, v: _AbstractSetMultimap__V) -> bool: ...
    @overload
    def removeAll(self, object: _py_Any) -> java.util.Collection: ...
    @overload
    def removeAll(self, object: _py_Any) -> java.util.Set[_AbstractSetMultimap__V]: ...
    @overload
    def replaceValues(self, object: _py_Any, iterable: java.lang.Iterable) -> java.util.Collection: ...
    @overload
    def replaceValues(self, k: _AbstractSetMultimap__K, iterable: java.lang.Iterable[_AbstractSetMultimap__V]) -> java.util.Set[_AbstractSetMultimap__V]: ...

_AbstractSortedMultiset__E = _py_TypeVar('_AbstractSortedMultiset__E')  # <E>
class AbstractSortedMultiset(AbstractMultiset[_AbstractSortedMultiset__E], SortedMultiset[_AbstractSortedMultiset__E], _py_Generic[_AbstractSortedMultiset__E]):
    def comparator(self) -> java.util.Comparator[_AbstractSortedMultiset__E]: ...
    def descendingMultiset(self) -> SortedMultiset[_AbstractSortedMultiset__E]: ...
    @overload
    def elementSet(self) -> java.util.NavigableSet[_AbstractSortedMultiset__E]: ...
    @overload
    def elementSet(self) -> java.util.Set: ...
    @overload
    def elementSet(self) -> java.util.SortedSet: ...
    def firstEntry(self) -> Multiset.Entry[_AbstractSortedMultiset__E]: ...
    def lastEntry(self) -> Multiset.Entry[_AbstractSortedMultiset__E]: ...
    def pollFirstEntry(self) -> Multiset.Entry[_AbstractSortedMultiset__E]: ...
    def pollLastEntry(self) -> Multiset.Entry[_AbstractSortedMultiset__E]: ...
    def subMultiset(self, e: _AbstractSortedMultiset__E, boundType: BoundType, e2: _AbstractSortedMultiset__E, boundType2: BoundType) -> SortedMultiset[_AbstractSortedMultiset__E]: ...

_DescendingMultiset__E = _py_TypeVar('_DescendingMultiset__E')  # <E>
class DescendingMultiset(ForwardingMultiset[_DescendingMultiset__E], SortedMultiset[_DescendingMultiset__E], _py_Generic[_DescendingMultiset__E]):
    def comparator(self) -> java.util.Comparator[_DescendingMultiset__E]: ...
    def descendingMultiset(self) -> SortedMultiset[_DescendingMultiset__E]: ...
    @overload
    def elementSet(self) -> java.util.NavigableSet[_DescendingMultiset__E]: ...
    @overload
    def elementSet(self) -> java.util.Set: ...
    @overload
    def elementSet(self) -> java.util.SortedSet: ...
    def entrySet(self) -> java.util.Set[Multiset.Entry[_DescendingMultiset__E]]: ...
    def firstEntry(self) -> Multiset.Entry[_DescendingMultiset__E]: ...
    def headMultiset(self, e: _DescendingMultiset__E, boundType: BoundType) -> SortedMultiset[_DescendingMultiset__E]: ...
    def iterator(self) -> java.util.Iterator[_DescendingMultiset__E]: ...
    def lastEntry(self) -> Multiset.Entry[_DescendingMultiset__E]: ...
    def pollFirstEntry(self) -> Multiset.Entry[_DescendingMultiset__E]: ...
    def pollLastEntry(self) -> Multiset.Entry[_DescendingMultiset__E]: ...
    def subMultiset(self, e: _DescendingMultiset__E, boundType: BoundType, e2: _DescendingMultiset__E, boundType2: BoundType) -> SortedMultiset[_DescendingMultiset__E]: ...
    def tailMultiset(self, e: _DescendingMultiset__E, boundType: BoundType) -> SortedMultiset[_DescendingMultiset__E]: ...
    @overload
    def toArray(self) -> _py_List[_py_Any]: ...
    _toArray_1__T = _py_TypeVar('_toArray_1__T')  # <T>
    @overload
    def toArray(self, tArray: _py_List[_toArray_1__T]) -> _py_List[_toArray_1__T]: ...
    def toString(self) -> str: ...

_EnumBiMap__K = _py_TypeVar('_EnumBiMap__K', bound=java.lang.Enum)  # <K>
_EnumBiMap__V = _py_TypeVar('_EnumBiMap__V', bound=java.lang.Enum)  # <V>
class EnumBiMap(AbstractBiMap[_EnumBiMap__K, _EnumBiMap__V], _py_Generic[_EnumBiMap__K, _EnumBiMap__V]):
    def clear(self) -> None: ...
    def containsValue(self, object: _py_Any) -> bool: ...
    _create_0__K = _py_TypeVar('_create_0__K', bound=java.lang.Enum)  # <K>
    _create_0__V = _py_TypeVar('_create_0__V', bound=java.lang.Enum)  # <V>
    @classmethod
    @overload
    def create(cls, class_: _py_Type[_create_0__K], class2: _py_Type[_create_0__V]) -> 'EnumBiMap'[_create_0__K, _create_0__V]: ...
    _create_1__K = _py_TypeVar('_create_1__K', bound=java.lang.Enum)  # <K>
    _create_1__V = _py_TypeVar('_create_1__V', bound=java.lang.Enum)  # <V>
    @classmethod
    @overload
    def create(cls, map: java.util.Map[_create_1__K, _create_1__V]) -> 'EnumBiMap'[_create_1__K, _create_1__V]: ...
    def entrySet(self) -> java.util.Set: ...
    def inverse(self) -> BiMap: ...
    def keySet(self) -> java.util.Set: ...
    def keyType(self) -> _py_Type[_EnumBiMap__K]: ...
    def putAll(self, map: java.util.Map) -> None: ...
    def replaceAll(self, biFunction: java.util.function.BiFunction) -> None: ...
    def valueType(self) -> _py_Type[_EnumBiMap__V]: ...
    @overload
    def values(self) -> java.util.Collection: ...
    @overload
    def values(self) -> java.util.Set: ...

_EnumHashBiMap__K = _py_TypeVar('_EnumHashBiMap__K', bound=java.lang.Enum)  # <K>
_EnumHashBiMap__V = _py_TypeVar('_EnumHashBiMap__V')  # <V>
class EnumHashBiMap(AbstractBiMap[_EnumHashBiMap__K, _EnumHashBiMap__V], _py_Generic[_EnumHashBiMap__K, _EnumHashBiMap__V]):
    def clear(self) -> None: ...
    def containsValue(self, object: _py_Any) -> bool: ...
    _create_0__K = _py_TypeVar('_create_0__K', bound=java.lang.Enum)  # <K>
    _create_0__V = _py_TypeVar('_create_0__V')  # <V>
    @classmethod
    @overload
    def create(cls, class_: _py_Type[_create_0__K]) -> 'EnumHashBiMap'[_create_0__K, _create_0__V]: ...
    _create_1__K = _py_TypeVar('_create_1__K', bound=java.lang.Enum)  # <K>
    _create_1__V = _py_TypeVar('_create_1__V')  # <V>
    @classmethod
    @overload
    def create(cls, map: java.util.Map[_create_1__K, _create_1__V]) -> 'EnumHashBiMap'[_create_1__K, _create_1__V]: ...
    def entrySet(self) -> java.util.Set: ...
    @overload
    def forcePut(self, k: _EnumHashBiMap__K, v: _EnumHashBiMap__V) -> _EnumHashBiMap__V: ...
    @overload
    def forcePut(self, object: _py_Any, object2: _py_Any) -> _py_Any: ...
    def inverse(self) -> BiMap: ...
    def keySet(self) -> java.util.Set: ...
    def keyType(self) -> _py_Type[_EnumHashBiMap__K]: ...
    @overload
    def put(self, k: _EnumHashBiMap__K, v: _EnumHashBiMap__V) -> _EnumHashBiMap__V: ...
    @overload
    def put(self, object: _py_Any, object2: _py_Any) -> _py_Any: ...
    def putAll(self, map: java.util.Map) -> None: ...
    @overload
    def remove(self, object: _py_Any, object2: _py_Any) -> bool: ...
    @overload
    def remove(self, object: _py_Any) -> _py_Any: ...
    def replaceAll(self, biFunction: java.util.function.BiFunction) -> None: ...
    @overload
    def values(self) -> java.util.Collection: ...
    @overload
    def values(self) -> java.util.Set: ...

_EvictingQueue__E = _py_TypeVar('_EvictingQueue__E')  # <E>
class EvictingQueue(ForwardingQueue[_EvictingQueue__E], java.io.Serializable, _py_Generic[_EvictingQueue__E]):
    def add(self, e: _EvictingQueue__E) -> bool: ...
    def addAll(self, collection: java.util.Collection[_EvictingQueue__E]) -> bool: ...
    def contains(self, object: _py_Any) -> bool: ...
    _create__E = _py_TypeVar('_create__E')  # <E>
    @classmethod
    def create(cls, int: int) -> 'EvictingQueue'[_create__E]: ...
    def offer(self, e: _EvictingQueue__E) -> bool: ...
    def remainingCapacity(self) -> int: ...
    @overload
    def remove(self, object: _py_Any) -> bool: ...
    @overload
    def remove(self) -> _EvictingQueue__E: ...

_FilteredEntrySetMultimap__K = _py_TypeVar('_FilteredEntrySetMultimap__K')  # <K>
_FilteredEntrySetMultimap__V = _py_TypeVar('_FilteredEntrySetMultimap__V')  # <V>
class FilteredEntrySetMultimap(FilteredEntryMultimap[_FilteredEntrySetMultimap__K, _FilteredEntrySetMultimap__V], FilteredSetMultimap[_FilteredEntrySetMultimap__K, _FilteredEntrySetMultimap__V], _py_Generic[_FilteredEntrySetMultimap__K, _FilteredEntrySetMultimap__V]):
    @overload
    def entries(self) -> java.util.Collection: ...
    @overload
    def entries(self) -> java.util.Set[java.util.Map.Entry[_FilteredEntrySetMultimap__K, _FilteredEntrySetMultimap__V]]: ...
    @overload
    def get(self, object: _py_Any) -> java.util.Collection: ...
    @overload
    def get(self, k: _FilteredEntrySetMultimap__K) -> java.util.Set[_FilteredEntrySetMultimap__V]: ...
    @overload
    def removeAll(self, object: _py_Any) -> java.util.Collection: ...
    @overload
    def removeAll(self, object: _py_Any) -> java.util.Set[_FilteredEntrySetMultimap__V]: ...
    @overload
    def replaceValues(self, object: _py_Any, iterable: java.lang.Iterable) -> java.util.Collection: ...
    @overload
    def replaceValues(self, k: _FilteredEntrySetMultimap__K, iterable: java.lang.Iterable[_FilteredEntrySetMultimap__V]) -> java.util.Set[_FilteredEntrySetMultimap__V]: ...
    @overload
    def unfiltered(self) -> Multimap: ...
    @overload
    def unfiltered(self) -> SetMultimap[_FilteredEntrySetMultimap__K, _FilteredEntrySetMultimap__V]: ...

_FilteredKeyListMultimap__K = _py_TypeVar('_FilteredKeyListMultimap__K')  # <K>
_FilteredKeyListMultimap__V = _py_TypeVar('_FilteredKeyListMultimap__V')  # <V>
class FilteredKeyListMultimap(FilteredKeyMultimap[_FilteredKeyListMultimap__K, _FilteredKeyListMultimap__V], ListMultimap[_FilteredKeyListMultimap__K, _FilteredKeyListMultimap__V], _py_Generic[_FilteredKeyListMultimap__K, _FilteredKeyListMultimap__V]):
    @overload
    def get(self, object: _py_Any) -> java.util.Collection: ...
    @overload
    def get(self, k: _FilteredKeyListMultimap__K) -> java.util.List[_FilteredKeyListMultimap__V]: ...
    @overload
    def removeAll(self, object: _py_Any) -> java.util.Collection: ...
    @overload
    def removeAll(self, object: _py_Any) -> java.util.List[_FilteredKeyListMultimap__V]: ...
    @overload
    def replaceValues(self, object: _py_Any, iterable: java.lang.Iterable) -> java.util.Collection: ...
    @overload
    def replaceValues(self, k: _FilteredKeyListMultimap__K, iterable: java.lang.Iterable[_FilteredKeyListMultimap__V]) -> java.util.List[_FilteredKeyListMultimap__V]: ...
    @overload
    def unfiltered(self) -> ListMultimap[_FilteredKeyListMultimap__K, _FilteredKeyListMultimap__V]: ...
    @overload
    def unfiltered(self) -> Multimap: ...

_FilteredKeySetMultimap__K = _py_TypeVar('_FilteredKeySetMultimap__K')  # <K>
_FilteredKeySetMultimap__V = _py_TypeVar('_FilteredKeySetMultimap__V')  # <V>
class FilteredKeySetMultimap(FilteredKeyMultimap[_FilteredKeySetMultimap__K, _FilteredKeySetMultimap__V], FilteredSetMultimap[_FilteredKeySetMultimap__K, _FilteredKeySetMultimap__V], _py_Generic[_FilteredKeySetMultimap__K, _FilteredKeySetMultimap__V]):
    @overload
    def entries(self) -> java.util.Collection: ...
    @overload
    def entries(self) -> java.util.Set[java.util.Map.Entry[_FilteredKeySetMultimap__K, _FilteredKeySetMultimap__V]]: ...
    @overload
    def get(self, object: _py_Any) -> java.util.Collection: ...
    @overload
    def get(self, k: _FilteredKeySetMultimap__K) -> java.util.Set[_FilteredKeySetMultimap__V]: ...
    @overload
    def removeAll(self, object: _py_Any) -> java.util.Collection: ...
    @overload
    def removeAll(self, object: _py_Any) -> java.util.Set[_FilteredKeySetMultimap__V]: ...
    @overload
    def replaceValues(self, object: _py_Any, iterable: java.lang.Iterable) -> java.util.Collection: ...
    @overload
    def replaceValues(self, k: _FilteredKeySetMultimap__K, iterable: java.lang.Iterable[_FilteredKeySetMultimap__V]) -> java.util.Set[_FilteredKeySetMultimap__V]: ...
    @overload
    def unfiltered(self) -> Multimap: ...
    @overload
    def unfiltered(self) -> SetMultimap[_FilteredKeySetMultimap__K, _FilteredKeySetMultimap__V]: ...

_ForwardingDeque__E = _py_TypeVar('_ForwardingDeque__E')  # <E>
class ForwardingDeque(ForwardingQueue[_ForwardingDeque__E], java.util.Deque[_ForwardingDeque__E], _py_Generic[_ForwardingDeque__E]):
    def addFirst(self, e: _ForwardingDeque__E) -> None: ...
    def addLast(self, e: _ForwardingDeque__E) -> None: ...
    def descendingIterator(self) -> java.util.Iterator[_ForwardingDeque__E]: ...
    def getFirst(self) -> _ForwardingDeque__E: ...
    def getLast(self) -> _ForwardingDeque__E: ...
    def offerFirst(self, e: _ForwardingDeque__E) -> bool: ...
    def offerLast(self, e: _ForwardingDeque__E) -> bool: ...
    def peekFirst(self) -> _ForwardingDeque__E: ...
    def peekLast(self) -> _ForwardingDeque__E: ...
    def pollFirst(self) -> _ForwardingDeque__E: ...
    def pollLast(self) -> _ForwardingDeque__E: ...
    def pop(self) -> _ForwardingDeque__E: ...
    def push(self, e: _ForwardingDeque__E) -> None: ...
    def removeFirst(self) -> _ForwardingDeque__E: ...
    def removeFirstOccurrence(self, object: _py_Any) -> bool: ...
    def removeLast(self) -> _ForwardingDeque__E: ...
    def removeLastOccurrence(self, object: _py_Any) -> bool: ...

_ForwardingNavigableMap__K = _py_TypeVar('_ForwardingNavigableMap__K')  # <K>
_ForwardingNavigableMap__V = _py_TypeVar('_ForwardingNavigableMap__V')  # <V>
class ForwardingNavigableMap(ForwardingSortedMap[_ForwardingNavigableMap__K, _ForwardingNavigableMap__V], java.util.NavigableMap[_ForwardingNavigableMap__K, _ForwardingNavigableMap__V], _py_Generic[_ForwardingNavigableMap__K, _ForwardingNavigableMap__V]):
    def ceilingEntry(self, k: _ForwardingNavigableMap__K) -> java.util.Map.Entry[_ForwardingNavigableMap__K, _ForwardingNavigableMap__V]: ...
    def ceilingKey(self, k: _ForwardingNavigableMap__K) -> _ForwardingNavigableMap__K: ...
    def descendingKeySet(self) -> java.util.NavigableSet[_ForwardingNavigableMap__K]: ...
    def descendingMap(self) -> java.util.NavigableMap[_ForwardingNavigableMap__K, _ForwardingNavigableMap__V]: ...
    def firstEntry(self) -> java.util.Map.Entry[_ForwardingNavigableMap__K, _ForwardingNavigableMap__V]: ...
    def floorEntry(self, k: _ForwardingNavigableMap__K) -> java.util.Map.Entry[_ForwardingNavigableMap__K, _ForwardingNavigableMap__V]: ...
    def floorKey(self, k: _ForwardingNavigableMap__K) -> _ForwardingNavigableMap__K: ...
    @overload
    def headMap(self, k: _ForwardingNavigableMap__K, boolean: bool) -> java.util.NavigableMap[_ForwardingNavigableMap__K, _ForwardingNavigableMap__V]: ...
    @overload
    def headMap(self, k: _ForwardingNavigableMap__K) -> java.util.SortedMap[_ForwardingNavigableMap__K, _ForwardingNavigableMap__V]: ...
    def higherEntry(self, k: _ForwardingNavigableMap__K) -> java.util.Map.Entry[_ForwardingNavigableMap__K, _ForwardingNavigableMap__V]: ...
    def higherKey(self, k: _ForwardingNavigableMap__K) -> _ForwardingNavigableMap__K: ...
    def lastEntry(self) -> java.util.Map.Entry[_ForwardingNavigableMap__K, _ForwardingNavigableMap__V]: ...
    def lowerEntry(self, k: _ForwardingNavigableMap__K) -> java.util.Map.Entry[_ForwardingNavigableMap__K, _ForwardingNavigableMap__V]: ...
    def lowerKey(self, k: _ForwardingNavigableMap__K) -> _ForwardingNavigableMap__K: ...
    def navigableKeySet(self) -> java.util.NavigableSet[_ForwardingNavigableMap__K]: ...
    def pollFirstEntry(self) -> java.util.Map.Entry[_ForwardingNavigableMap__K, _ForwardingNavigableMap__V]: ...
    def pollLastEntry(self) -> java.util.Map.Entry[_ForwardingNavigableMap__K, _ForwardingNavigableMap__V]: ...
    @overload
    def subMap(self, k: _ForwardingNavigableMap__K, boolean: bool, k2: _ForwardingNavigableMap__K, boolean2: bool) -> java.util.NavigableMap[_ForwardingNavigableMap__K, _ForwardingNavigableMap__V]: ...
    @overload
    def subMap(self, k: _ForwardingNavigableMap__K, k2: _ForwardingNavigableMap__K) -> java.util.SortedMap[_ForwardingNavigableMap__K, _ForwardingNavigableMap__V]: ...
    @overload
    def tailMap(self, k: _ForwardingNavigableMap__K, boolean: bool) -> java.util.NavigableMap[_ForwardingNavigableMap__K, _ForwardingNavigableMap__V]: ...
    @overload
    def tailMap(self, k: _ForwardingNavigableMap__K) -> java.util.SortedMap[_ForwardingNavigableMap__K, _ForwardingNavigableMap__V]: ...

_ForwardingSortedMultiset__E = _py_TypeVar('_ForwardingSortedMultiset__E')  # <E>
class ForwardingSortedMultiset(ForwardingMultiset[_ForwardingSortedMultiset__E], SortedMultiset[_ForwardingSortedMultiset__E], _py_Generic[_ForwardingSortedMultiset__E]):
    def comparator(self) -> java.util.Comparator[_ForwardingSortedMultiset__E]: ...
    def descendingMultiset(self) -> SortedMultiset[_ForwardingSortedMultiset__E]: ...
    @overload
    def elementSet(self) -> java.util.NavigableSet[_ForwardingSortedMultiset__E]: ...
    @overload
    def elementSet(self) -> java.util.Set: ...
    @overload
    def elementSet(self) -> java.util.SortedSet: ...
    def firstEntry(self) -> Multiset.Entry[_ForwardingSortedMultiset__E]: ...
    def headMultiset(self, e: _ForwardingSortedMultiset__E, boundType: BoundType) -> SortedMultiset[_ForwardingSortedMultiset__E]: ...
    def lastEntry(self) -> Multiset.Entry[_ForwardingSortedMultiset__E]: ...
    def pollFirstEntry(self) -> Multiset.Entry[_ForwardingSortedMultiset__E]: ...
    def pollLastEntry(self) -> Multiset.Entry[_ForwardingSortedMultiset__E]: ...
    def subMultiset(self, e: _ForwardingSortedMultiset__E, boundType: BoundType, e2: _ForwardingSortedMultiset__E, boundType2: BoundType) -> SortedMultiset[_ForwardingSortedMultiset__E]: ...
    def tailMultiset(self, e: _ForwardingSortedMultiset__E, boundType: BoundType) -> SortedMultiset[_ForwardingSortedMultiset__E]: ...

_ForwardingSortedSet__E = _py_TypeVar('_ForwardingSortedSet__E')  # <E>
class ForwardingSortedSet(ForwardingSet[_ForwardingSortedSet__E], java.util.SortedSet[_ForwardingSortedSet__E], _py_Generic[_ForwardingSortedSet__E]):
    def comparator(self) -> java.util.Comparator[_ForwardingSortedSet__E]: ...
    def first(self) -> _ForwardingSortedSet__E: ...
    def headSet(self, e: _ForwardingSortedSet__E) -> java.util.SortedSet[_ForwardingSortedSet__E]: ...
    def last(self) -> _ForwardingSortedSet__E: ...
    def subSet(self, e: _ForwardingSortedSet__E, e2: _ForwardingSortedSet__E) -> java.util.SortedSet[_ForwardingSortedSet__E]: ...
    def tailSet(self, e: _ForwardingSortedSet__E) -> java.util.SortedSet[_ForwardingSortedSet__E]: ...

_ForwardingSortedSetMultimap__K = _py_TypeVar('_ForwardingSortedSetMultimap__K')  # <K>
_ForwardingSortedSetMultimap__V = _py_TypeVar('_ForwardingSortedSetMultimap__V')  # <V>
class ForwardingSortedSetMultimap(ForwardingSetMultimap[_ForwardingSortedSetMultimap__K, _ForwardingSortedSetMultimap__V], SortedSetMultimap[_ForwardingSortedSetMultimap__K, _ForwardingSortedSetMultimap__V], _py_Generic[_ForwardingSortedSetMultimap__K, _ForwardingSortedSetMultimap__V]):
    @overload
    def get(self, object: _py_Any) -> java.util.Collection: ...
    @overload
    def get(self, object: _py_Any) -> java.util.Set: ...
    @overload
    def get(self, k: _ForwardingSortedSetMultimap__K) -> java.util.SortedSet[_ForwardingSortedSetMultimap__V]: ...
    @overload
    def removeAll(self, object: _py_Any) -> java.util.Collection: ...
    @overload
    def removeAll(self, object: _py_Any) -> java.util.Set: ...
    @overload
    def removeAll(self, object: _py_Any) -> java.util.SortedSet[_ForwardingSortedSetMultimap__V]: ...
    @overload
    def replaceValues(self, object: _py_Any, iterable: java.lang.Iterable) -> java.util.Collection: ...
    @overload
    def replaceValues(self, object: _py_Any, iterable: java.lang.Iterable) -> java.util.Set: ...
    @overload
    def replaceValues(self, k: _ForwardingSortedSetMultimap__K, iterable: java.lang.Iterable[_ForwardingSortedSetMultimap__V]) -> java.util.SortedSet[_ForwardingSortedSetMultimap__V]: ...
    def valueComparator(self) -> java.util.Comparator[_ForwardingSortedSetMultimap__V]: ...

_HashBasedTable__R = _py_TypeVar('_HashBasedTable__R')  # <R>
_HashBasedTable__C = _py_TypeVar('_HashBasedTable__C')  # <C>
_HashBasedTable__V = _py_TypeVar('_HashBasedTable__V')  # <V>
class HashBasedTable(StandardTable[_HashBasedTable__R, _HashBasedTable__C, _HashBasedTable__V], _py_Generic[_HashBasedTable__R, _HashBasedTable__C, _HashBasedTable__V]):
    def cellSet(self) -> java.util.Set: ...
    def clear(self) -> None: ...
    def column(self, object: _py_Any) -> java.util.Map: ...
    def columnKeySet(self) -> java.util.Set: ...
    def columnMap(self) -> java.util.Map: ...
    def contains(self, object: _py_Any, object2: _py_Any) -> bool: ...
    def containsColumn(self, object: _py_Any) -> bool: ...
    def containsRow(self, object: _py_Any) -> bool: ...
    def containsValue(self, object: _py_Any) -> bool: ...
    _create_0__R = _py_TypeVar('_create_0__R')  # <R>
    _create_0__C = _py_TypeVar('_create_0__C')  # <C>
    _create_0__V = _py_TypeVar('_create_0__V')  # <V>
    @classmethod
    @overload
    def create(cls) -> 'HashBasedTable'[_create_0__R, _create_0__C, _create_0__V]: ...
    _create_1__R = _py_TypeVar('_create_1__R')  # <R>
    _create_1__C = _py_TypeVar('_create_1__C')  # <C>
    _create_1__V = _py_TypeVar('_create_1__V')  # <V>
    @classmethod
    @overload
    def create(cls, table: Table[_create_1__R, _create_1__C, _create_1__V]) -> 'HashBasedTable'[_create_1__R, _create_1__C, _create_1__V]: ...
    _create_2__R = _py_TypeVar('_create_2__R')  # <R>
    _create_2__C = _py_TypeVar('_create_2__C')  # <C>
    _create_2__V = _py_TypeVar('_create_2__V')  # <V>
    @classmethod
    @overload
    def create(cls, int: int, int2: int) -> 'HashBasedTable'[_create_2__R, _create_2__C, _create_2__V]: ...
    def equals(self, object: _py_Any) -> bool: ...
    def get(self, object: _py_Any, object2: _py_Any) -> _HashBasedTable__V: ...
    def hashCode(self) -> int: ...
    def isEmpty(self) -> bool: ...
    def put(self, object: _py_Any, object2: _py_Any, object3: _py_Any) -> _py_Any: ...
    def putAll(self, table: Table) -> None: ...
    def remove(self, object: _py_Any, object2: _py_Any) -> _HashBasedTable__V: ...
    def row(self, object: _py_Any) -> java.util.Map: ...
    def rowKeySet(self) -> java.util.Set: ...
    def rowMap(self) -> java.util.Map: ...
    def size(self) -> int: ...
    def toString(self) -> str: ...
    def values(self) -> java.util.Collection: ...

_HashMultiset__E = _py_TypeVar('_HashMultiset__E')  # <E>
class HashMultiset(AbstractMapBasedMultiset[_HashMultiset__E], _py_Generic[_HashMultiset__E]):
    @overload
    def add(self, e: _HashMultiset__E) -> bool: ...
    @overload
    def add(self, object: _py_Any, int: int) -> int: ...
    def clear(self) -> None: ...
    def contains(self, object: _py_Any) -> bool: ...
    def count(self, object: _py_Any) -> int: ...
    _create_0__E = _py_TypeVar('_create_0__E')  # <E>
    @classmethod
    @overload
    def create(cls) -> 'HashMultiset'[_create_0__E]: ...
    _create_1__E = _py_TypeVar('_create_1__E')  # <E>
    @classmethod
    @overload
    def create(cls, int: int) -> 'HashMultiset'[_create_1__E]: ...
    _create_2__E = _py_TypeVar('_create_2__E')  # <E>
    @classmethod
    @overload
    def create(cls, iterable: java.lang.Iterable[_create_2__E]) -> 'HashMultiset'[_create_2__E]: ...
    def elementSet(self) -> java.util.Set: ...
    def entrySet(self) -> java.util.Set: ...
    def forEachEntry(self, objIntConsumer: java.util.function.ObjIntConsumer) -> None: ...
    def isEmpty(self) -> bool: ...
    def iterator(self) -> java.util.Iterator: ...
    @overload
    def remove(self, object: _py_Any) -> bool: ...
    @overload
    def remove(self, object: _py_Any, int: int) -> int: ...
    @overload
    def setCount(self, object: _py_Any, int: int, int2: int) -> bool: ...
    @overload
    def setCount(self, object: _py_Any, int: int) -> int: ...
    def size(self) -> int: ...

_ImmutableMultimap__Builder__K = _py_TypeVar('_ImmutableMultimap__Builder__K')  # <K>
_ImmutableMultimap__Builder__V = _py_TypeVar('_ImmutableMultimap__Builder__V')  # <V>
_ImmutableMultimap__K = _py_TypeVar('_ImmutableMultimap__K')  # <K>
_ImmutableMultimap__V = _py_TypeVar('_ImmutableMultimap__V')  # <V>
class ImmutableMultimap(BaseImmutableMultimap[_ImmutableMultimap__K, _ImmutableMultimap__V], java.io.Serializable, _py_Generic[_ImmutableMultimap__K, _ImmutableMultimap__V]):
    @overload
    def asMap(self) -> ImmutableMap[_ImmutableMultimap__K, java.util.Collection[_ImmutableMultimap__V]]: ...
    @overload
    def asMap(self) -> java.util.Map: ...
    _builder__K = _py_TypeVar('_builder__K')  # <K>
    _builder__V = _py_TypeVar('_builder__V')  # <V>
    @classmethod
    def builder(cls) -> 'ImmutableMultimap.Builder'[_builder__K, _builder__V]: ...
    def clear(self) -> None: ...
    def containsEntry(self, object: _py_Any, object2: _py_Any) -> bool: ...
    def containsKey(self, object: _py_Any) -> bool: ...
    def containsValue(self, object: _py_Any) -> bool: ...
    _copyOf_0__K = _py_TypeVar('_copyOf_0__K')  # <K>
    _copyOf_0__V = _py_TypeVar('_copyOf_0__V')  # <V>
    @classmethod
    @overload
    def copyOf(cls, multimap: Multimap[_copyOf_0__K, _copyOf_0__V]) -> 'ImmutableMultimap'[_copyOf_0__K, _copyOf_0__V]: ...
    _copyOf_1__K = _py_TypeVar('_copyOf_1__K')  # <K>
    _copyOf_1__V = _py_TypeVar('_copyOf_1__V')  # <V>
    @classmethod
    @overload
    def copyOf(cls, iterable: java.lang.Iterable[java.util.Map.Entry[_copyOf_1__K, _copyOf_1__V]]) -> 'ImmutableMultimap'[_copyOf_1__K, _copyOf_1__V]: ...
    @overload
    def entries(self) -> ImmutableCollection[java.util.Map.Entry[_ImmutableMultimap__K, _ImmutableMultimap__V]]: ...
    @overload
    def entries(self) -> java.util.Collection: ...
    def equals(self, object: _py_Any) -> bool: ...
    def forEach(self, biConsumer: java.util.function.BiConsumer[_ImmutableMultimap__K, _ImmutableMultimap__V]) -> None: ...
    @overload
    def get(self, k: _ImmutableMultimap__K) -> ImmutableCollection[_ImmutableMultimap__V]: ...
    @overload
    def get(self, object: _py_Any) -> java.util.Collection: ...
    def hashCode(self) -> int: ...
    def inverse(self) -> 'ImmutableMultimap'[_ImmutableMultimap__V, _ImmutableMultimap__K]: ...
    def isEmpty(self) -> bool: ...
    @overload
    def keySet(self) -> 'ImmutableSet'[_ImmutableMultimap__K]: ...
    @overload
    def keySet(self) -> java.util.Set: ...
    @overload
    def keys(self) -> 'ImmutableMultiset'[_ImmutableMultimap__K]: ...
    @overload
    def keys(self) -> Multiset: ...
    _of_0__K = _py_TypeVar('_of_0__K')  # <K>
    _of_0__V = _py_TypeVar('_of_0__V')  # <V>
    @classmethod
    @overload
    def of(cls) -> 'ImmutableMultimap'[_of_0__K, _of_0__V]: ...
    _of_1__K = _py_TypeVar('_of_1__K')  # <K>
    _of_1__V = _py_TypeVar('_of_1__V')  # <V>
    @classmethod
    @overload
    def of(cls, k: _of_1__K, v: _of_1__V) -> 'ImmutableMultimap'[_of_1__K, _of_1__V]: ...
    _of_2__K = _py_TypeVar('_of_2__K')  # <K>
    _of_2__V = _py_TypeVar('_of_2__V')  # <V>
    @classmethod
    @overload
    def of(cls, k: _of_2__K, v: _of_2__V, k2: _of_2__K, v2: _of_2__V) -> 'ImmutableMultimap'[_of_2__K, _of_2__V]: ...
    _of_3__K = _py_TypeVar('_of_3__K')  # <K>
    _of_3__V = _py_TypeVar('_of_3__V')  # <V>
    @classmethod
    @overload
    def of(cls, k: _of_3__K, v: _of_3__V, k2: _of_3__K, v2: _of_3__V, k3: _of_3__K, v3: _of_3__V) -> 'ImmutableMultimap'[_of_3__K, _of_3__V]: ...
    _of_4__K = _py_TypeVar('_of_4__K')  # <K>
    _of_4__V = _py_TypeVar('_of_4__V')  # <V>
    @classmethod
    @overload
    def of(cls, k: _of_4__K, v: _of_4__V, k2: _of_4__K, v2: _of_4__V, k3: _of_4__K, v3: _of_4__V, k4: _of_4__K, v4: _of_4__V) -> 'ImmutableMultimap'[_of_4__K, _of_4__V]: ...
    _of_5__K = _py_TypeVar('_of_5__K')  # <K>
    _of_5__V = _py_TypeVar('_of_5__V')  # <V>
    @classmethod
    @overload
    def of(cls, k: _of_5__K, v: _of_5__V, k2: _of_5__K, v2: _of_5__V, k3: _of_5__K, v3: _of_5__V, k4: _of_5__K, v4: _of_5__V, k5: _of_5__K, v5: _of_5__V) -> 'ImmutableMultimap'[_of_5__K, _of_5__V]: ...
    def put(self, k: _ImmutableMultimap__K, v: _ImmutableMultimap__V) -> bool: ...
    @overload
    def putAll(self, multimap: Multimap[_ImmutableMultimap__K, _ImmutableMultimap__V]) -> bool: ...
    @overload
    def putAll(self, k: _ImmutableMultimap__K, iterable: java.lang.Iterable[_ImmutableMultimap__V]) -> bool: ...
    def remove(self, object: _py_Any, object2: _py_Any) -> bool: ...
    @overload
    def removeAll(self, object: _py_Any) -> ImmutableCollection[_ImmutableMultimap__V]: ...
    @overload
    def removeAll(self, object: _py_Any) -> java.util.Collection: ...
    @overload
    def replaceValues(self, k: _ImmutableMultimap__K, iterable: java.lang.Iterable[_ImmutableMultimap__V]) -> ImmutableCollection[_ImmutableMultimap__V]: ...
    @overload
    def replaceValues(self, object: _py_Any, iterable: java.lang.Iterable) -> java.util.Collection: ...
    def size(self) -> int: ...
    def toString(self) -> str: ...
    @overload
    def values(self) -> ImmutableCollection[_ImmutableMultimap__V]: ...
    @overload
    def values(self) -> java.util.Collection: ...
    class Builder(_py_Generic[_ImmutableMultimap__Builder__K, _ImmutableMultimap__Builder__V]):
        def __init__(self): ...
        def build(self) -> 'ImmutableMultimap'[_ImmutableMultimap__Builder__K, _ImmutableMultimap__Builder__V]: ...
        def orderKeysBy(self, comparator: java.util.Comparator[_ImmutableMultimap__Builder__K]) -> 'ImmutableMultimap.Builder'[_ImmutableMultimap__Builder__K, _ImmutableMultimap__Builder__V]: ...
        def orderValuesBy(self, comparator: java.util.Comparator[_ImmutableMultimap__Builder__V]) -> 'ImmutableMultimap.Builder'[_ImmutableMultimap__Builder__K, _ImmutableMultimap__Builder__V]: ...
        @overload
        def put(self, k: _ImmutableMultimap__Builder__K, v: _ImmutableMultimap__Builder__V) -> 'ImmutableMultimap.Builder'[_ImmutableMultimap__Builder__K, _ImmutableMultimap__Builder__V]: ...
        @overload
        def put(self, entry: java.util.Map.Entry[_ImmutableMultimap__Builder__K, _ImmutableMultimap__Builder__V]) -> 'ImmutableMultimap.Builder'[_ImmutableMultimap__Builder__K, _ImmutableMultimap__Builder__V]: ...
        @overload
        def putAll(self, multimap: Multimap[_ImmutableMultimap__Builder__K, _ImmutableMultimap__Builder__V]) -> 'ImmutableMultimap.Builder'[_ImmutableMultimap__Builder__K, _ImmutableMultimap__Builder__V]: ...
        @overload
        def putAll(self, iterable: java.lang.Iterable[java.util.Map.Entry[_ImmutableMultimap__Builder__K, _ImmutableMultimap__Builder__V]]) -> 'ImmutableMultimap.Builder'[_ImmutableMultimap__Builder__K, _ImmutableMultimap__Builder__V]: ...
        @overload
        def putAll(self, k: _ImmutableMultimap__Builder__K, iterable: java.lang.Iterable[_ImmutableMultimap__Builder__V]) -> 'ImmutableMultimap.Builder'[_ImmutableMultimap__Builder__K, _ImmutableMultimap__Builder__V]: ...
        @overload
        def putAll(self, k: _ImmutableMultimap__Builder__K, vArray: _py_List[_ImmutableMultimap__Builder__V]) -> 'ImmutableMultimap.Builder'[_ImmutableMultimap__Builder__K, _ImmutableMultimap__Builder__V]: ...

_LinkedHashMultiset__E = _py_TypeVar('_LinkedHashMultiset__E')  # <E>
class LinkedHashMultiset(AbstractMapBasedMultiset[_LinkedHashMultiset__E], _py_Generic[_LinkedHashMultiset__E]):
    @overload
    def add(self, e: _LinkedHashMultiset__E) -> bool: ...
    @overload
    def add(self, object: _py_Any, int: int) -> int: ...
    def clear(self) -> None: ...
    def contains(self, object: _py_Any) -> bool: ...
    def count(self, object: _py_Any) -> int: ...
    _create_0__E = _py_TypeVar('_create_0__E')  # <E>
    @classmethod
    @overload
    def create(cls) -> 'LinkedHashMultiset'[_create_0__E]: ...
    _create_1__E = _py_TypeVar('_create_1__E')  # <E>
    @classmethod
    @overload
    def create(cls, int: int) -> 'LinkedHashMultiset'[_create_1__E]: ...
    _create_2__E = _py_TypeVar('_create_2__E')  # <E>
    @classmethod
    @overload
    def create(cls, iterable: java.lang.Iterable[_create_2__E]) -> 'LinkedHashMultiset'[_create_2__E]: ...
    def elementSet(self) -> java.util.Set: ...
    def entrySet(self) -> java.util.Set: ...
    def forEachEntry(self, objIntConsumer: java.util.function.ObjIntConsumer) -> None: ...
    def isEmpty(self) -> bool: ...
    def iterator(self) -> java.util.Iterator: ...
    @overload
    def remove(self, object: _py_Any) -> bool: ...
    @overload
    def remove(self, object: _py_Any, int: int) -> int: ...
    @overload
    def setCount(self, object: _py_Any, int: int, int2: int) -> bool: ...
    @overload
    def setCount(self, object: _py_Any, int: int) -> int: ...
    def size(self) -> int: ...

_RegularImmutableTable__R = _py_TypeVar('_RegularImmutableTable__R')  # <R>
_RegularImmutableTable__C = _py_TypeVar('_RegularImmutableTable__C')  # <C>
_RegularImmutableTable__V = _py_TypeVar('_RegularImmutableTable__V')  # <V>
class RegularImmutableTable(ImmutableTable[_RegularImmutableTable__R, _RegularImmutableTable__C, _RegularImmutableTable__V], _py_Generic[_RegularImmutableTable__R, _RegularImmutableTable__C, _RegularImmutableTable__V]): ...

_SingletonImmutableTable__R = _py_TypeVar('_SingletonImmutableTable__R')  # <R>
_SingletonImmutableTable__C = _py_TypeVar('_SingletonImmutableTable__C')  # <C>
_SingletonImmutableTable__V = _py_TypeVar('_SingletonImmutableTable__V')  # <V>
class SingletonImmutableTable(ImmutableTable[_SingletonImmutableTable__R, _SingletonImmutableTable__C, _SingletonImmutableTable__V], _py_Generic[_SingletonImmutableTable__R, _SingletonImmutableTable__C, _SingletonImmutableTable__V]):
    @overload
    def column(self, c: _SingletonImmutableTable__C) -> ImmutableMap[_SingletonImmutableTable__R, _SingletonImmutableTable__V]: ...
    @overload
    def column(self, object: _py_Any) -> java.util.Map: ...
    @overload
    def columnMap(self) -> ImmutableMap[_SingletonImmutableTable__C, java.util.Map[_SingletonImmutableTable__R, _SingletonImmutableTable__V]]: ...
    @overload
    def columnMap(self) -> java.util.Map: ...
    @overload
    def rowMap(self) -> ImmutableMap[_SingletonImmutableTable__R, java.util.Map[_SingletonImmutableTable__C, _SingletonImmutableTable__V]]: ...
    @overload
    def rowMap(self) -> java.util.Map: ...
    def size(self) -> int: ...

_StandardRowSortedTable__R = _py_TypeVar('_StandardRowSortedTable__R')  # <R>
_StandardRowSortedTable__C = _py_TypeVar('_StandardRowSortedTable__C')  # <C>
_StandardRowSortedTable__V = _py_TypeVar('_StandardRowSortedTable__V')  # <V>
class StandardRowSortedTable(StandardTable[_StandardRowSortedTable__R, _StandardRowSortedTable__C, _StandardRowSortedTable__V], RowSortedTable[_StandardRowSortedTable__R, _StandardRowSortedTable__C, _StandardRowSortedTable__V], _py_Generic[_StandardRowSortedTable__R, _StandardRowSortedTable__C, _StandardRowSortedTable__V]):
    @overload
    def rowKeySet(self) -> java.util.Set: ...
    @overload
    def rowKeySet(self) -> java.util.SortedSet[_StandardRowSortedTable__R]: ...
    @overload
    def rowMap(self) -> java.util.Map: ...
    @overload
    def rowMap(self) -> java.util.SortedMap[_StandardRowSortedTable__R, java.util.Map[_StandardRowSortedTable__C, _StandardRowSortedTable__V]]: ...

_AbstractSortedSetMultimap__K = _py_TypeVar('_AbstractSortedSetMultimap__K')  # <K>
_AbstractSortedSetMultimap__V = _py_TypeVar('_AbstractSortedSetMultimap__V')  # <V>
class AbstractSortedSetMultimap(AbstractSetMultimap[_AbstractSortedSetMultimap__K, _AbstractSortedSetMultimap__V], SortedSetMultimap[_AbstractSortedSetMultimap__K, _AbstractSortedSetMultimap__V], _py_Generic[_AbstractSortedSetMultimap__K, _AbstractSortedSetMultimap__V]):
    def asMap(self) -> java.util.Map[_AbstractSortedSetMultimap__K, java.util.Collection[_AbstractSortedSetMultimap__V]]: ...
    @overload
    def get(self, object: _py_Any) -> java.util.Collection: ...
    @overload
    def get(self, object: _py_Any) -> java.util.Set: ...
    @overload
    def get(self, k: _AbstractSortedSetMultimap__K) -> java.util.SortedSet[_AbstractSortedSetMultimap__V]: ...
    @overload
    def removeAll(self, object: _py_Any) -> java.util.Collection: ...
    @overload
    def removeAll(self, object: _py_Any) -> java.util.Set: ...
    @overload
    def removeAll(self, object: _py_Any) -> java.util.SortedSet[_AbstractSortedSetMultimap__V]: ...
    @overload
    def replaceValues(self, object: _py_Any, iterable: java.lang.Iterable) -> java.util.Collection: ...
    @overload
    def replaceValues(self, object: _py_Any, iterable: java.lang.Iterable) -> java.util.Set: ...
    @overload
    def replaceValues(self, k: _AbstractSortedSetMultimap__K, iterable: java.lang.Iterable[_AbstractSortedSetMultimap__V]) -> java.util.SortedSet[_AbstractSortedSetMultimap__V]: ...
    def values(self) -> java.util.Collection[_AbstractSortedSetMultimap__V]: ...

_ArrayListMultimapGwtSerializationDependencies__K = _py_TypeVar('_ArrayListMultimapGwtSerializationDependencies__K')  # <K>
_ArrayListMultimapGwtSerializationDependencies__V = _py_TypeVar('_ArrayListMultimapGwtSerializationDependencies__V')  # <V>
class ArrayListMultimapGwtSerializationDependencies(AbstractListMultimap[_ArrayListMultimapGwtSerializationDependencies__K, _ArrayListMultimapGwtSerializationDependencies__V], _py_Generic[_ArrayListMultimapGwtSerializationDependencies__K, _ArrayListMultimapGwtSerializationDependencies__V]): ...

_DenseImmutableTable__R = _py_TypeVar('_DenseImmutableTable__R')  # <R>
_DenseImmutableTable__C = _py_TypeVar('_DenseImmutableTable__C')  # <C>
_DenseImmutableTable__V = _py_TypeVar('_DenseImmutableTable__V')  # <V>
class DenseImmutableTable(RegularImmutableTable[_DenseImmutableTable__R, _DenseImmutableTable__C, _DenseImmutableTable__V], _py_Generic[_DenseImmutableTable__R, _DenseImmutableTable__C, _DenseImmutableTable__V]):
    @overload
    def columnMap(self) -> ImmutableMap[_DenseImmutableTable__C, java.util.Map[_DenseImmutableTable__R, _DenseImmutableTable__V]]: ...
    @overload
    def columnMap(self) -> java.util.Map: ...
    def get(self, object: _py_Any, object2: _py_Any) -> _DenseImmutableTable__V: ...
    @overload
    def rowMap(self) -> ImmutableMap[_DenseImmutableTable__R, java.util.Map[_DenseImmutableTable__C, _DenseImmutableTable__V]]: ...
    @overload
    def rowMap(self) -> java.util.Map: ...
    def size(self) -> int: ...

_ForwardingBlockingDeque__E = _py_TypeVar('_ForwardingBlockingDeque__E')  # <E>
class ForwardingBlockingDeque(ForwardingDeque[_ForwardingBlockingDeque__E], java.util.concurrent.BlockingDeque[_ForwardingBlockingDeque__E], _py_Generic[_ForwardingBlockingDeque__E]):
    @overload
    def drainTo(self, collection: java.util.Collection[_ForwardingBlockingDeque__E]) -> int: ...
    @overload
    def drainTo(self, collection: java.util.Collection[_ForwardingBlockingDeque__E], int: int) -> int: ...
    @overload
    def offer(self, e: _ForwardingBlockingDeque__E, long: int, timeUnit: java.util.concurrent.TimeUnit) -> bool: ...
    @overload
    def offer(self, e: _ForwardingBlockingDeque__E) -> bool: ...
    @overload
    def offerFirst(self, e: _ForwardingBlockingDeque__E, long: int, timeUnit: java.util.concurrent.TimeUnit) -> bool: ...
    @overload
    def offerFirst(self, e: _ForwardingBlockingDeque__E) -> bool: ...
    @overload
    def offerLast(self, e: _ForwardingBlockingDeque__E, long: int, timeUnit: java.util.concurrent.TimeUnit) -> bool: ...
    @overload
    def offerLast(self, e: _ForwardingBlockingDeque__E) -> bool: ...
    @overload
    def poll(self, long: int, timeUnit: java.util.concurrent.TimeUnit) -> _ForwardingBlockingDeque__E: ...
    @overload
    def poll(self) -> _ForwardingBlockingDeque__E: ...
    @overload
    def pollFirst(self, long: int, timeUnit: java.util.concurrent.TimeUnit) -> _ForwardingBlockingDeque__E: ...
    @overload
    def pollFirst(self) -> _ForwardingBlockingDeque__E: ...
    @overload
    def pollLast(self, long: int, timeUnit: java.util.concurrent.TimeUnit) -> _ForwardingBlockingDeque__E: ...
    @overload
    def pollLast(self) -> _ForwardingBlockingDeque__E: ...
    def put(self, e: _ForwardingBlockingDeque__E) -> None: ...
    def putFirst(self, e: _ForwardingBlockingDeque__E) -> None: ...
    def putLast(self, e: _ForwardingBlockingDeque__E) -> None: ...
    def remainingCapacity(self) -> int: ...
    def take(self) -> _ForwardingBlockingDeque__E: ...
    def takeFirst(self) -> _ForwardingBlockingDeque__E: ...
    def takeLast(self) -> _ForwardingBlockingDeque__E: ...

_ForwardingNavigableSet__E = _py_TypeVar('_ForwardingNavigableSet__E')  # <E>
class ForwardingNavigableSet(ForwardingSortedSet[_ForwardingNavigableSet__E], java.util.NavigableSet[_ForwardingNavigableSet__E], _py_Generic[_ForwardingNavigableSet__E]):
    def ceiling(self, e: _ForwardingNavigableSet__E) -> _ForwardingNavigableSet__E: ...
    def descendingIterator(self) -> java.util.Iterator[_ForwardingNavigableSet__E]: ...
    def descendingSet(self) -> java.util.NavigableSet[_ForwardingNavigableSet__E]: ...
    def floor(self, e: _ForwardingNavigableSet__E) -> _ForwardingNavigableSet__E: ...
    @overload
    def headSet(self, e: _ForwardingNavigableSet__E, boolean: bool) -> java.util.NavigableSet[_ForwardingNavigableSet__E]: ...
    @overload
    def headSet(self, e: _ForwardingNavigableSet__E) -> java.util.SortedSet[_ForwardingNavigableSet__E]: ...
    def higher(self, e: _ForwardingNavigableSet__E) -> _ForwardingNavigableSet__E: ...
    def lower(self, e: _ForwardingNavigableSet__E) -> _ForwardingNavigableSet__E: ...
    def pollFirst(self) -> _ForwardingNavigableSet__E: ...
    def pollLast(self) -> _ForwardingNavigableSet__E: ...
    @overload
    def subSet(self, e: _ForwardingNavigableSet__E, boolean: bool, e2: _ForwardingNavigableSet__E, boolean2: bool) -> java.util.NavigableSet[_ForwardingNavigableSet__E]: ...
    @overload
    def subSet(self, e: _ForwardingNavigableSet__E, e2: _ForwardingNavigableSet__E) -> java.util.SortedSet[_ForwardingNavigableSet__E]: ...
    @overload
    def tailSet(self, e: _ForwardingNavigableSet__E, boolean: bool) -> java.util.NavigableSet[_ForwardingNavigableSet__E]: ...
    @overload
    def tailSet(self, e: _ForwardingNavigableSet__E) -> java.util.SortedSet[_ForwardingNavigableSet__E]: ...

_HashMultimapGwtSerializationDependencies__K = _py_TypeVar('_HashMultimapGwtSerializationDependencies__K')  # <K>
_HashMultimapGwtSerializationDependencies__V = _py_TypeVar('_HashMultimapGwtSerializationDependencies__V')  # <V>
class HashMultimapGwtSerializationDependencies(AbstractSetMultimap[_HashMultimapGwtSerializationDependencies__K, _HashMultimapGwtSerializationDependencies__V], _py_Generic[_HashMultimapGwtSerializationDependencies__K, _HashMultimapGwtSerializationDependencies__V]): ...

_LinkedHashMultimapGwtSerializationDependencies__K = _py_TypeVar('_LinkedHashMultimapGwtSerializationDependencies__K')  # <K>
_LinkedHashMultimapGwtSerializationDependencies__V = _py_TypeVar('_LinkedHashMultimapGwtSerializationDependencies__V')  # <V>
class LinkedHashMultimapGwtSerializationDependencies(AbstractSetMultimap[_LinkedHashMultimapGwtSerializationDependencies__K, _LinkedHashMultimapGwtSerializationDependencies__V], _py_Generic[_LinkedHashMultimapGwtSerializationDependencies__K, _LinkedHashMultimapGwtSerializationDependencies__V]): ...

_SparseImmutableTable__R = _py_TypeVar('_SparseImmutableTable__R')  # <R>
_SparseImmutableTable__C = _py_TypeVar('_SparseImmutableTable__C')  # <C>
_SparseImmutableTable__V = _py_TypeVar('_SparseImmutableTable__V')  # <V>
class SparseImmutableTable(RegularImmutableTable[_SparseImmutableTable__R, _SparseImmutableTable__C, _SparseImmutableTable__V], _py_Generic[_SparseImmutableTable__R, _SparseImmutableTable__C, _SparseImmutableTable__V]):
    @overload
    def columnMap(self) -> ImmutableMap[_SparseImmutableTable__C, java.util.Map[_SparseImmutableTable__R, _SparseImmutableTable__V]]: ...
    @overload
    def columnMap(self) -> java.util.Map: ...
    @overload
    def rowMap(self) -> ImmutableMap[_SparseImmutableTable__R, java.util.Map[_SparseImmutableTable__C, _SparseImmutableTable__V]]: ...
    @overload
    def rowMap(self) -> java.util.Map: ...
    def size(self) -> int: ...

_TreeBasedTable__R = _py_TypeVar('_TreeBasedTable__R')  # <R>
_TreeBasedTable__C = _py_TypeVar('_TreeBasedTable__C')  # <C>
_TreeBasedTable__V = _py_TypeVar('_TreeBasedTable__V')  # <V>
class TreeBasedTable(StandardRowSortedTable[_TreeBasedTable__R, _TreeBasedTable__C, _TreeBasedTable__V], _py_Generic[_TreeBasedTable__R, _TreeBasedTable__C, _TreeBasedTable__V]):
    def cellSet(self) -> java.util.Set: ...
    def clear(self) -> None: ...
    def column(self, object: _py_Any) -> java.util.Map: ...
    def columnComparator(self) -> java.util.Comparator[_TreeBasedTable__C]: ...
    def columnKeySet(self) -> java.util.Set: ...
    def columnMap(self) -> java.util.Map: ...
    def contains(self, object: _py_Any, object2: _py_Any) -> bool: ...
    def containsColumn(self, object: _py_Any) -> bool: ...
    def containsRow(self, object: _py_Any) -> bool: ...
    def containsValue(self, object: _py_Any) -> bool: ...
    _create_0__R = _py_TypeVar('_create_0__R', bound=java.lang.Comparable)  # <R>
    _create_0__C = _py_TypeVar('_create_0__C', bound=java.lang.Comparable)  # <C>
    _create_0__V = _py_TypeVar('_create_0__V')  # <V>
    @classmethod
    @overload
    def create(cls) -> 'TreeBasedTable'[_create_0__R, _create_0__C, _create_0__V]: ...
    _create_1__R = _py_TypeVar('_create_1__R')  # <R>
    _create_1__C = _py_TypeVar('_create_1__C')  # <C>
    _create_1__V = _py_TypeVar('_create_1__V')  # <V>
    @classmethod
    @overload
    def create(cls, treeBasedTable: 'TreeBasedTable'[_create_1__R, _create_1__C, _create_1__V]) -> 'TreeBasedTable'[_create_1__R, _create_1__C, _create_1__V]: ...
    _create_2__R = _py_TypeVar('_create_2__R')  # <R>
    _create_2__C = _py_TypeVar('_create_2__C')  # <C>
    _create_2__V = _py_TypeVar('_create_2__V')  # <V>
    @classmethod
    @overload
    def create(cls, comparator: java.util.Comparator[_create_2__R], comparator2: java.util.Comparator[_create_2__C]) -> 'TreeBasedTable'[_create_2__R, _create_2__C, _create_2__V]: ...
    def equals(self, object: _py_Any) -> bool: ...
    def get(self, object: _py_Any, object2: _py_Any) -> _py_Any: ...
    def hashCode(self) -> int: ...
    def isEmpty(self) -> bool: ...
    def put(self, object: _py_Any, object2: _py_Any, object3: _py_Any) -> _py_Any: ...
    def putAll(self, table: Table) -> None: ...
    def remove(self, object: _py_Any, object2: _py_Any) -> _py_Any: ...
    @overload
    def row(self, object: _py_Any) -> java.util.Map: ...
    @overload
    def row(self, r: _TreeBasedTable__R) -> java.util.SortedMap[_TreeBasedTable__C, _TreeBasedTable__V]: ...
    def rowComparator(self) -> java.util.Comparator[_TreeBasedTable__R]: ...
    @overload
    def rowKeySet(self) -> java.util.Set: ...
    @overload
    def rowKeySet(self) -> java.util.SortedSet[_TreeBasedTable__R]: ...
    @overload
    def rowMap(self) -> java.util.Map: ...
    @overload
    def rowMap(self) -> java.util.SortedMap[_TreeBasedTable__R, java.util.Map[_TreeBasedTable__C, _TreeBasedTable__V]]: ...
    def size(self) -> int: ...
    def toString(self) -> str: ...
    def values(self) -> java.util.Collection: ...

_TreeMultiset__E = _py_TypeVar('_TreeMultiset__E')  # <E>
class TreeMultiset(AbstractSortedMultiset[_TreeMultiset__E], java.io.Serializable, _py_Generic[_TreeMultiset__E]):
    @overload
    def add(self, e: _TreeMultiset__E) -> bool: ...
    @overload
    def add(self, e: _TreeMultiset__E, int: int) -> int: ...
    def clear(self) -> None: ...
    def comparator(self) -> java.util.Comparator: ...
    def contains(self, object: _py_Any) -> bool: ...
    def count(self, object: _py_Any) -> int: ...
    _create_0__E = _py_TypeVar('_create_0__E', bound=java.lang.Comparable)  # <E>
    @classmethod
    @overload
    def create(cls) -> 'TreeMultiset'[_create_0__E]: ...
    _create_1__E = _py_TypeVar('_create_1__E', bound=java.lang.Comparable)  # <E>
    @classmethod
    @overload
    def create(cls, iterable: java.lang.Iterable[_create_1__E]) -> 'TreeMultiset'[_create_1__E]: ...
    _create_2__E = _py_TypeVar('_create_2__E')  # <E>
    @classmethod
    @overload
    def create(cls, comparator: java.util.Comparator[_create_2__E]) -> 'TreeMultiset'[_create_2__E]: ...
    def descendingMultiset(self) -> SortedMultiset: ...
    @overload
    def elementSet(self) -> java.util.NavigableSet: ...
    @overload
    def elementSet(self) -> java.util.Set: ...
    @overload
    def elementSet(self) -> java.util.SortedSet: ...
    def entrySet(self) -> java.util.Set: ...
    def firstEntry(self) -> Multiset.Entry: ...
    def forEachEntry(self, objIntConsumer: java.util.function.ObjIntConsumer[_TreeMultiset__E]) -> None: ...
    def headMultiset(self, e: _TreeMultiset__E, boundType: BoundType) -> SortedMultiset[_TreeMultiset__E]: ...
    def isEmpty(self) -> bool: ...
    def iterator(self) -> java.util.Iterator[_TreeMultiset__E]: ...
    def lastEntry(self) -> Multiset.Entry: ...
    def pollFirstEntry(self) -> Multiset.Entry: ...
    def pollLastEntry(self) -> Multiset.Entry: ...
    @overload
    def remove(self, object: _py_Any) -> bool: ...
    @overload
    def remove(self, object: _py_Any, int: int) -> int: ...
    @overload
    def setCount(self, e: _TreeMultiset__E, int: int, int2: int) -> bool: ...
    @overload
    def setCount(self, e: _TreeMultiset__E, int: int) -> int: ...
    def size(self) -> int: ...
    def subMultiset(self, object: _py_Any, boundType: BoundType, object2: _py_Any, boundType2: BoundType) -> SortedMultiset: ...
    def tailMultiset(self, e: _TreeMultiset__E, boundType: BoundType) -> SortedMultiset[_TreeMultiset__E]: ...

_AbstractSortedKeySortedSetMultimap__K = _py_TypeVar('_AbstractSortedKeySortedSetMultimap__K')  # <K>
_AbstractSortedKeySortedSetMultimap__V = _py_TypeVar('_AbstractSortedKeySortedSetMultimap__V')  # <V>
class AbstractSortedKeySortedSetMultimap(AbstractSortedSetMultimap[_AbstractSortedKeySortedSetMultimap__K, _AbstractSortedKeySortedSetMultimap__V], _py_Generic[_AbstractSortedKeySortedSetMultimap__K, _AbstractSortedKeySortedSetMultimap__V]):
    @overload
    def asMap(self) -> java.util.Map: ...
    @overload
    def asMap(self) -> java.util.SortedMap[_AbstractSortedKeySortedSetMultimap__K, java.util.Collection[_AbstractSortedKeySortedSetMultimap__V]]: ...
    @overload
    def keySet(self) -> java.util.Set: ...
    @overload
    def keySet(self) -> java.util.SortedSet[_AbstractSortedKeySortedSetMultimap__K]: ...

_ArrayListMultimap__K = _py_TypeVar('_ArrayListMultimap__K')  # <K>
_ArrayListMultimap__V = _py_TypeVar('_ArrayListMultimap__V')  # <V>
class ArrayListMultimap(ArrayListMultimapGwtSerializationDependencies[_ArrayListMultimap__K, _ArrayListMultimap__V], _py_Generic[_ArrayListMultimap__K, _ArrayListMultimap__V]):
    def asMap(self) -> java.util.Map: ...
    def clear(self) -> None: ...
    def containsEntry(self, object: _py_Any, object2: _py_Any) -> bool: ...
    def containsKey(self, object: _py_Any) -> bool: ...
    def containsValue(self, object: _py_Any) -> bool: ...
    _create_0__K = _py_TypeVar('_create_0__K')  # <K>
    _create_0__V = _py_TypeVar('_create_0__V')  # <V>
    @classmethod
    @overload
    def create(cls) -> 'ArrayListMultimap'[_create_0__K, _create_0__V]: ...
    _create_1__K = _py_TypeVar('_create_1__K')  # <K>
    _create_1__V = _py_TypeVar('_create_1__V')  # <V>
    @classmethod
    @overload
    def create(cls, multimap: Multimap[_create_1__K, _create_1__V]) -> 'ArrayListMultimap'[_create_1__K, _create_1__V]: ...
    _create_2__K = _py_TypeVar('_create_2__K')  # <K>
    _create_2__V = _py_TypeVar('_create_2__V')  # <V>
    @classmethod
    @overload
    def create(cls, int: int, int2: int) -> 'ArrayListMultimap'[_create_2__K, _create_2__V]: ...
    def entries(self) -> java.util.Collection: ...
    def equals(self, object: _py_Any) -> bool: ...
    def forEach(self, biConsumer: java.util.function.BiConsumer) -> None: ...
    @overload
    def get(self, object: _py_Any) -> java.util.Collection: ...
    @overload
    def get(self, object: _py_Any) -> java.util.List: ...
    def hashCode(self) -> int: ...
    def isEmpty(self) -> bool: ...
    def keySet(self) -> java.util.Set: ...
    def keys(self) -> Multiset: ...
    def put(self, object: _py_Any, object2: _py_Any) -> bool: ...
    @overload
    def putAll(self, multimap: Multimap) -> bool: ...
    @overload
    def putAll(self, object: _py_Any, iterable: java.lang.Iterable) -> bool: ...
    def remove(self, object: _py_Any, object2: _py_Any) -> bool: ...
    @overload
    def removeAll(self, object: _py_Any) -> java.util.Collection: ...
    @overload
    def removeAll(self, object: _py_Any) -> java.util.List: ...
    @overload
    def replaceValues(self, object: _py_Any, iterable: java.lang.Iterable) -> java.util.Collection: ...
    @overload
    def replaceValues(self, object: _py_Any, iterable: java.lang.Iterable) -> java.util.List: ...
    def size(self) -> int: ...
    def toString(self) -> str: ...
    def trimToSize(self) -> None: ...
    def values(self) -> java.util.Collection: ...

_HashMultimap__K = _py_TypeVar('_HashMultimap__K')  # <K>
_HashMultimap__V = _py_TypeVar('_HashMultimap__V')  # <V>
class HashMultimap(HashMultimapGwtSerializationDependencies[_HashMultimap__K, _HashMultimap__V], _py_Generic[_HashMultimap__K, _HashMultimap__V]):
    def asMap(self) -> java.util.Map: ...
    def clear(self) -> None: ...
    def containsEntry(self, object: _py_Any, object2: _py_Any) -> bool: ...
    def containsKey(self, object: _py_Any) -> bool: ...
    def containsValue(self, object: _py_Any) -> bool: ...
    _create_0__K = _py_TypeVar('_create_0__K')  # <K>
    _create_0__V = _py_TypeVar('_create_0__V')  # <V>
    @classmethod
    @overload
    def create(cls) -> 'HashMultimap'[_create_0__K, _create_0__V]: ...
    _create_1__K = _py_TypeVar('_create_1__K')  # <K>
    _create_1__V = _py_TypeVar('_create_1__V')  # <V>
    @classmethod
    @overload
    def create(cls, multimap: Multimap[_create_1__K, _create_1__V]) -> 'HashMultimap'[_create_1__K, _create_1__V]: ...
    _create_2__K = _py_TypeVar('_create_2__K')  # <K>
    _create_2__V = _py_TypeVar('_create_2__V')  # <V>
    @classmethod
    @overload
    def create(cls, int: int, int2: int) -> 'HashMultimap'[_create_2__K, _create_2__V]: ...
    @overload
    def entries(self) -> java.util.Collection: ...
    @overload
    def entries(self) -> java.util.Set: ...
    def equals(self, object: _py_Any) -> bool: ...
    def forEach(self, biConsumer: java.util.function.BiConsumer) -> None: ...
    @overload
    def get(self, object: _py_Any) -> java.util.Collection: ...
    @overload
    def get(self, object: _py_Any) -> java.util.Set: ...
    def hashCode(self) -> int: ...
    def isEmpty(self) -> bool: ...
    def keySet(self) -> java.util.Set: ...
    def keys(self) -> Multiset: ...
    def put(self, object: _py_Any, object2: _py_Any) -> bool: ...
    @overload
    def putAll(self, multimap: Multimap) -> bool: ...
    @overload
    def putAll(self, object: _py_Any, iterable: java.lang.Iterable) -> bool: ...
    def remove(self, object: _py_Any, object2: _py_Any) -> bool: ...
    @overload
    def removeAll(self, object: _py_Any) -> java.util.Collection: ...
    @overload
    def removeAll(self, object: _py_Any) -> java.util.Set: ...
    @overload
    def replaceValues(self, object: _py_Any, iterable: java.lang.Iterable) -> java.util.Collection: ...
    @overload
    def replaceValues(self, object: _py_Any, iterable: java.lang.Iterable) -> java.util.Set: ...
    def size(self) -> int: ...
    def toString(self) -> str: ...
    def values(self) -> java.util.Collection: ...

_LinkedHashMultimap__K = _py_TypeVar('_LinkedHashMultimap__K')  # <K>
_LinkedHashMultimap__V = _py_TypeVar('_LinkedHashMultimap__V')  # <V>
class LinkedHashMultimap(LinkedHashMultimapGwtSerializationDependencies[_LinkedHashMultimap__K, _LinkedHashMultimap__V], _py_Generic[_LinkedHashMultimap__K, _LinkedHashMultimap__V]):
    def asMap(self) -> java.util.Map: ...
    def clear(self) -> None: ...
    def containsEntry(self, object: _py_Any, object2: _py_Any) -> bool: ...
    def containsKey(self, object: _py_Any) -> bool: ...
    def containsValue(self, object: _py_Any) -> bool: ...
    _create_0__K = _py_TypeVar('_create_0__K')  # <K>
    _create_0__V = _py_TypeVar('_create_0__V')  # <V>
    @classmethod
    @overload
    def create(cls) -> 'LinkedHashMultimap'[_create_0__K, _create_0__V]: ...
    _create_1__K = _py_TypeVar('_create_1__K')  # <K>
    _create_1__V = _py_TypeVar('_create_1__V')  # <V>
    @classmethod
    @overload
    def create(cls, multimap: Multimap[_create_1__K, _create_1__V]) -> 'LinkedHashMultimap'[_create_1__K, _create_1__V]: ...
    _create_2__K = _py_TypeVar('_create_2__K')  # <K>
    _create_2__V = _py_TypeVar('_create_2__V')  # <V>
    @classmethod
    @overload
    def create(cls, int: int, int2: int) -> 'LinkedHashMultimap'[_create_2__K, _create_2__V]: ...
    @overload
    def entries(self) -> java.util.Collection: ...
    @overload
    def entries(self) -> java.util.Set[java.util.Map.Entry[_LinkedHashMultimap__K, _LinkedHashMultimap__V]]: ...
    def equals(self, object: _py_Any) -> bool: ...
    def forEach(self, biConsumer: java.util.function.BiConsumer) -> None: ...
    @overload
    def get(self, object: _py_Any) -> java.util.Collection: ...
    @overload
    def get(self, object: _py_Any) -> java.util.Set: ...
    def hashCode(self) -> int: ...
    def isEmpty(self) -> bool: ...
    def keySet(self) -> java.util.Set[_LinkedHashMultimap__K]: ...
    def keys(self) -> Multiset: ...
    def put(self, object: _py_Any, object2: _py_Any) -> bool: ...
    @overload
    def putAll(self, multimap: Multimap) -> bool: ...
    @overload
    def putAll(self, object: _py_Any, iterable: java.lang.Iterable) -> bool: ...
    def remove(self, object: _py_Any, object2: _py_Any) -> bool: ...
    @overload
    def removeAll(self, object: _py_Any) -> java.util.Collection: ...
    @overload
    def removeAll(self, object: _py_Any) -> java.util.Set: ...
    @overload
    def replaceValues(self, object: _py_Any, iterable: java.lang.Iterable) -> java.util.Collection: ...
    @overload
    def replaceValues(self, k: _LinkedHashMultimap__K, iterable: java.lang.Iterable[_LinkedHashMultimap__V]) -> java.util.Set[_LinkedHashMultimap__V]: ...
    def size(self) -> int: ...
    def toString(self) -> str: ...
    def values(self) -> java.util.Collection[_LinkedHashMultimap__V]: ...

_TreeMultimap__K = _py_TypeVar('_TreeMultimap__K')  # <K>
_TreeMultimap__V = _py_TypeVar('_TreeMultimap__V')  # <V>
class TreeMultimap(AbstractSortedKeySortedSetMultimap[_TreeMultimap__K, _TreeMultimap__V], _py_Generic[_TreeMultimap__K, _TreeMultimap__V]):
    @overload
    def asMap(self) -> java.util.Map: ...
    @overload
    def asMap(self) -> java.util.NavigableMap[_TreeMultimap__K, java.util.Collection[_TreeMultimap__V]]: ...
    @overload
    def asMap(self) -> java.util.SortedMap: ...
    def clear(self) -> None: ...
    def containsEntry(self, object: _py_Any, object2: _py_Any) -> bool: ...
    def containsKey(self, object: _py_Any) -> bool: ...
    def containsValue(self, object: _py_Any) -> bool: ...
    _create_0__K = _py_TypeVar('_create_0__K', bound=java.lang.Comparable)  # <K>
    _create_0__V = _py_TypeVar('_create_0__V', bound=java.lang.Comparable)  # <V>
    @classmethod
    @overload
    def create(cls) -> 'TreeMultimap'[_create_0__K, _create_0__V]: ...
    _create_1__K = _py_TypeVar('_create_1__K', bound=java.lang.Comparable)  # <K>
    _create_1__V = _py_TypeVar('_create_1__V', bound=java.lang.Comparable)  # <V>
    @classmethod
    @overload
    def create(cls, multimap: Multimap[_create_1__K, _create_1__V]) -> 'TreeMultimap'[_create_1__K, _create_1__V]: ...
    _create_2__K = _py_TypeVar('_create_2__K')  # <K>
    _create_2__V = _py_TypeVar('_create_2__V')  # <V>
    @classmethod
    @overload
    def create(cls, comparator: java.util.Comparator[_create_2__K], comparator2: java.util.Comparator[_create_2__V]) -> 'TreeMultimap'[_create_2__K, _create_2__V]: ...
    @overload
    def entries(self) -> java.util.Collection: ...
    @overload
    def entries(self) -> java.util.Set: ...
    def equals(self, object: _py_Any) -> bool: ...
    def forEach(self, biConsumer: java.util.function.BiConsumer) -> None: ...
    @overload
    def get(self, object: _py_Any) -> java.util.Collection: ...
    @overload
    def get(self, k: _TreeMultimap__K) -> java.util.NavigableSet[_TreeMultimap__V]: ...
    @overload
    def get(self, object: _py_Any) -> java.util.Set: ...
    @overload
    def get(self, object: _py_Any) -> java.util.SortedSet: ...
    def hashCode(self) -> int: ...
    def isEmpty(self) -> bool: ...
    def keyComparator(self) -> java.util.Comparator[_TreeMultimap__K]: ...
    @overload
    def keySet(self) -> java.util.NavigableSet[_TreeMultimap__K]: ...
    @overload
    def keySet(self) -> java.util.Set: ...
    @overload
    def keySet(self) -> java.util.SortedSet: ...
    def keys(self) -> Multiset: ...
    def put(self, object: _py_Any, object2: _py_Any) -> bool: ...
    @overload
    def putAll(self, multimap: Multimap) -> bool: ...
    @overload
    def putAll(self, object: _py_Any, iterable: java.lang.Iterable) -> bool: ...
    def remove(self, object: _py_Any, object2: _py_Any) -> bool: ...
    @overload
    def removeAll(self, object: _py_Any) -> java.util.Collection: ...
    @overload
    def removeAll(self, object: _py_Any) -> java.util.Set: ...
    @overload
    def removeAll(self, object: _py_Any) -> java.util.SortedSet: ...
    @overload
    def replaceValues(self, object: _py_Any, iterable: java.lang.Iterable) -> java.util.Collection: ...
    @overload
    def replaceValues(self, object: _py_Any, iterable: java.lang.Iterable) -> java.util.Set: ...
    @overload
    def replaceValues(self, object: _py_Any, iterable: java.lang.Iterable) -> java.util.SortedSet: ...
    def size(self) -> int: ...
    def toString(self) -> str: ...
    def valueComparator(self) -> java.util.Comparator[_TreeMultimap__V]: ...
    def values(self) -> java.util.Collection: ...

_AbstractNavigableMap__K = _py_TypeVar('_AbstractNavigableMap__K')  # <K>
_AbstractNavigableMap__V = _py_TypeVar('_AbstractNavigableMap__V')  # <V>
class AbstractNavigableMap(com.google.common.collect.Maps.IteratorBasedAbstractMap[_AbstractNavigableMap__K, _AbstractNavigableMap__V], java.util.NavigableMap[_AbstractNavigableMap__K, _AbstractNavigableMap__V], _py_Generic[_AbstractNavigableMap__K, _AbstractNavigableMap__V]):
    def ceilingEntry(self, k: _AbstractNavigableMap__K) -> java.util.Map.Entry[_AbstractNavigableMap__K, _AbstractNavigableMap__V]: ...
    def ceilingKey(self, k: _AbstractNavigableMap__K) -> _AbstractNavigableMap__K: ...
    def descendingKeySet(self) -> java.util.NavigableSet[_AbstractNavigableMap__K]: ...
    def descendingMap(self) -> java.util.NavigableMap[_AbstractNavigableMap__K, _AbstractNavigableMap__V]: ...
    def firstEntry(self) -> java.util.Map.Entry[_AbstractNavigableMap__K, _AbstractNavigableMap__V]: ...
    def firstKey(self) -> _AbstractNavigableMap__K: ...
    def floorEntry(self, k: _AbstractNavigableMap__K) -> java.util.Map.Entry[_AbstractNavigableMap__K, _AbstractNavigableMap__V]: ...
    def floorKey(self, k: _AbstractNavigableMap__K) -> _AbstractNavigableMap__K: ...
    def get(self, object: _py_Any) -> _AbstractNavigableMap__V: ...
    @overload
    def headMap(self, k: _AbstractNavigableMap__K, boolean: bool) -> java.util.NavigableMap[_AbstractNavigableMap__K, _AbstractNavigableMap__V]: ...
    @overload
    def headMap(self, k: _AbstractNavigableMap__K) -> java.util.SortedMap[_AbstractNavigableMap__K, _AbstractNavigableMap__V]: ...
    def higherEntry(self, k: _AbstractNavigableMap__K) -> java.util.Map.Entry[_AbstractNavigableMap__K, _AbstractNavigableMap__V]: ...
    def higherKey(self, k: _AbstractNavigableMap__K) -> _AbstractNavigableMap__K: ...
    def keySet(self) -> java.util.Set[_AbstractNavigableMap__K]: ...
    def lastEntry(self) -> java.util.Map.Entry[_AbstractNavigableMap__K, _AbstractNavigableMap__V]: ...
    def lastKey(self) -> _AbstractNavigableMap__K: ...
    def lowerEntry(self, k: _AbstractNavigableMap__K) -> java.util.Map.Entry[_AbstractNavigableMap__K, _AbstractNavigableMap__V]: ...
    def lowerKey(self, k: _AbstractNavigableMap__K) -> _AbstractNavigableMap__K: ...
    def navigableKeySet(self) -> java.util.NavigableSet[_AbstractNavigableMap__K]: ...
    def pollFirstEntry(self) -> java.util.Map.Entry[_AbstractNavigableMap__K, _AbstractNavigableMap__V]: ...
    def pollLastEntry(self) -> java.util.Map.Entry[_AbstractNavigableMap__K, _AbstractNavigableMap__V]: ...
    @overload
    def subMap(self, k: _AbstractNavigableMap__K, boolean: bool, k2: _AbstractNavigableMap__K, boolean2: bool) -> java.util.NavigableMap[_AbstractNavigableMap__K, _AbstractNavigableMap__V]: ...
    @overload
    def subMap(self, k: _AbstractNavigableMap__K, k2: _AbstractNavigableMap__K) -> java.util.SortedMap[_AbstractNavigableMap__K, _AbstractNavigableMap__V]: ...
    @overload
    def tailMap(self, k: _AbstractNavigableMap__K, boolean: bool) -> java.util.NavigableMap[_AbstractNavigableMap__K, _AbstractNavigableMap__V]: ...
    @overload
    def tailMap(self, k: _AbstractNavigableMap__K) -> java.util.SortedMap[_AbstractNavigableMap__K, _AbstractNavigableMap__V]: ...

_ContiguousSet__C = _py_TypeVar('_ContiguousSet__C', bound=java.lang.Comparable)  # <C>
class ContiguousSet(com.google.common.collect.ImmutableSortedSet[_ContiguousSet__C], _py_Generic[_ContiguousSet__C]):
    _builder_0__E = _py_TypeVar('_builder_0__E')  # <E>
    @classmethod
    @overload
    def builder(cls) -> 'ImmutableSet.Builder'[_builder_0__E]: ...
    _builder_1__E = _py_TypeVar('_builder_1__E')  # <E>
    @classmethod
    @overload
    def builder(cls) -> 'ImmutableSortedSet.Builder'[_builder_1__E]: ...
    @classmethod
    @overload
    def closed(cls, int: int, int2: int) -> 'ContiguousSet'[int]: ...
    @classmethod
    @overload
    def closed(cls, long: int, long2: int) -> 'ContiguousSet'[int]: ...
    @classmethod
    @overload
    def closedOpen(cls, int: int, int2: int) -> 'ContiguousSet'[int]: ...
    @classmethod
    @overload
    def closedOpen(cls, long: int, long2: int) -> 'ContiguousSet'[int]: ...
    _create__C = _py_TypeVar('_create__C', bound=java.lang.Comparable)  # <C>
    @classmethod
    def create(cls, range: Range[_create__C], discreteDomain: DiscreteDomain[_create__C]) -> 'ContiguousSet'[_create__C]: ...
    @overload
    def headSet(self, c: _ContiguousSet__C) -> 'ContiguousSet'[_ContiguousSet__C]: ...
    @overload
    def headSet(self, c: _ContiguousSet__C, boolean: bool) -> 'ContiguousSet'[_ContiguousSet__C]: ...
    @overload
    def headSet(self, object: _py_Any) -> 'ImmutableSortedSet': ...
    @overload
    def headSet(self, object: _py_Any, boolean: bool) -> 'ImmutableSortedSet': ...
    @overload
    def headSet(self, object: _py_Any, boolean: bool) -> java.util.NavigableSet: ...
    @overload
    def headSet(self, object: _py_Any) -> java.util.SortedSet: ...
    def intersection(self, contiguousSet: 'ContiguousSet'[_ContiguousSet__C]) -> 'ContiguousSet'[_ContiguousSet__C]: ...
    @overload
    def range(self) -> Range[_ContiguousSet__C]: ...
    @overload
    def range(self, boundType: BoundType, boundType2: BoundType) -> Range[_ContiguousSet__C]: ...
    @overload
    def subSet(self, c: _ContiguousSet__C, boolean: bool, c2: _ContiguousSet__C, boolean2: bool) -> 'ContiguousSet'[_ContiguousSet__C]: ...
    @overload
    def subSet(self, c: _ContiguousSet__C, c2: _ContiguousSet__C) -> 'ContiguousSet'[_ContiguousSet__C]: ...
    @overload
    def subSet(self, object: _py_Any, boolean: bool, object2: _py_Any, boolean2: bool) -> 'ImmutableSortedSet': ...
    @overload
    def subSet(self, object: _py_Any, object2: _py_Any) -> 'ImmutableSortedSet': ...
    @overload
    def subSet(self, object: _py_Any, boolean: bool, object2: _py_Any, boolean2: bool) -> java.util.NavigableSet: ...
    @overload
    def subSet(self, object: _py_Any, object2: _py_Any) -> java.util.SortedSet: ...
    @overload
    def tailSet(self, c: _ContiguousSet__C) -> 'ContiguousSet'[_ContiguousSet__C]: ...
    @overload
    def tailSet(self, c: _ContiguousSet__C, boolean: bool) -> 'ContiguousSet'[_ContiguousSet__C]: ...
    @overload
    def tailSet(self, object: _py_Any) -> 'ImmutableSortedSet': ...
    @overload
    def tailSet(self, object: _py_Any, boolean: bool) -> 'ImmutableSortedSet': ...
    @overload
    def tailSet(self, object: _py_Any, boolean: bool) -> java.util.NavigableSet: ...
    @overload
    def tailSet(self, object: _py_Any) -> java.util.SortedSet: ...
    def toString(self) -> str: ...

_DescendingImmutableSortedMultiset__E = _py_TypeVar('_DescendingImmutableSortedMultiset__E')  # <E>
class DescendingImmutableSortedMultiset(com.google.common.collect.ImmutableSortedMultiset[_DescendingImmutableSortedMultiset__E], _py_Generic[_DescendingImmutableSortedMultiset__E]):
    def count(self, object: _py_Any) -> int: ...
    @overload
    def descendingMultiset(self) -> 'ImmutableSortedMultiset'[_DescendingImmutableSortedMultiset__E]: ...
    @overload
    def descendingMultiset(self) -> SortedMultiset: ...
    @overload
    def elementSet(self) -> 'ImmutableSet': ...
    @overload
    def elementSet(self) -> 'ImmutableSortedSet'[_DescendingImmutableSortedMultiset__E]: ...
    @overload
    def elementSet(self) -> java.util.NavigableSet: ...
    @overload
    def elementSet(self) -> java.util.Set: ...
    @overload
    def elementSet(self) -> java.util.SortedSet: ...
    def firstEntry(self) -> Multiset.Entry[_DescendingImmutableSortedMultiset__E]: ...
    @overload
    def headMultiset(self, e: _DescendingImmutableSortedMultiset__E, boundType: BoundType) -> 'ImmutableSortedMultiset'[_DescendingImmutableSortedMultiset__E]: ...
    @overload
    def headMultiset(self, object: _py_Any, boundType: BoundType) -> SortedMultiset: ...
    def lastEntry(self) -> Multiset.Entry[_DescendingImmutableSortedMultiset__E]: ...
    def size(self) -> int: ...
    @overload
    def tailMultiset(self, e: _DescendingImmutableSortedMultiset__E, boundType: BoundType) -> 'ImmutableSortedMultiset'[_DescendingImmutableSortedMultiset__E]: ...
    @overload
    def tailMultiset(self, object: _py_Any, boundType: BoundType) -> SortedMultiset: ...

_DescendingImmutableSortedSet__E = _py_TypeVar('_DescendingImmutableSortedSet__E')  # <E>
class DescendingImmutableSortedSet(com.google.common.collect.ImmutableSortedSet[_DescendingImmutableSortedSet__E], _py_Generic[_DescendingImmutableSortedSet__E]):
    def ceiling(self, e: _DescendingImmutableSortedSet__E) -> _DescendingImmutableSortedSet__E: ...
    def contains(self, object: _py_Any) -> bool: ...
    @overload
    def descendingIterator(self) -> UnmodifiableIterator[_DescendingImmutableSortedSet__E]: ...
    @overload
    def descendingIterator(self) -> java.util.Iterator: ...
    @overload
    def descendingSet(self) -> 'ImmutableSortedSet'[_DescendingImmutableSortedSet__E]: ...
    @overload
    def descendingSet(self) -> java.util.NavigableSet: ...
    def floor(self, e: _DescendingImmutableSortedSet__E) -> _DescendingImmutableSortedSet__E: ...
    def higher(self, e: _DescendingImmutableSortedSet__E) -> _DescendingImmutableSortedSet__E: ...
    @overload
    def iterator(self) -> UnmodifiableIterator[_DescendingImmutableSortedSet__E]: ...
    @overload
    def iterator(self) -> java.util.Iterator: ...
    def lower(self, e: _DescendingImmutableSortedSet__E) -> _DescendingImmutableSortedSet__E: ...
    def size(self) -> int: ...

_EmptyContiguousSet__C = _py_TypeVar('_EmptyContiguousSet__C', bound=java.lang.Comparable)  # <C>
class EmptyContiguousSet(ContiguousSet[_EmptyContiguousSet__C], _py_Generic[_EmptyContiguousSet__C]):
    def asList(self) -> 'ImmutableList'[_EmptyContiguousSet__C]: ...
    def contains(self, object: _py_Any) -> bool: ...
    @overload
    def descendingIterator(self) -> UnmodifiableIterator[_EmptyContiguousSet__C]: ...
    @overload
    def descendingIterator(self) -> java.util.Iterator: ...
    def equals(self, object: _py_Any) -> bool: ...
    @overload
    def first(self) -> _EmptyContiguousSet__C: ...
    @overload
    def first(self) -> _py_Any: ...
    def hashCode(self) -> int: ...
    def intersection(self, contiguousSet: ContiguousSet[_EmptyContiguousSet__C]) -> ContiguousSet[_EmptyContiguousSet__C]: ...
    def isEmpty(self) -> bool: ...
    @overload
    def iterator(self) -> UnmodifiableIterator[_EmptyContiguousSet__C]: ...
    @overload
    def iterator(self) -> java.util.Iterator: ...
    @overload
    def last(self) -> _EmptyContiguousSet__C: ...
    @overload
    def last(self) -> _py_Any: ...
    @overload
    def range(self) -> Range[_EmptyContiguousSet__C]: ...
    @overload
    def range(self, boundType: BoundType, boundType2: BoundType) -> Range[_EmptyContiguousSet__C]: ...
    def size(self) -> int: ...
    def toString(self) -> str: ...

class EmptyImmutableListMultimap(com.google.common.collect.ImmutableListMultimap[_py_Any, _py_Any]): ...

class EmptyImmutableSetMultimap(com.google.common.collect.ImmutableSetMultimap[_py_Any, _py_Any]): ...

_HashBiMap__K = _py_TypeVar('_HashBiMap__K')  # <K>
_HashBiMap__V = _py_TypeVar('_HashBiMap__V')  # <V>
class HashBiMap(com.google.common.collect.Maps.IteratorBasedAbstractMap[_HashBiMap__K, _HashBiMap__V], BiMap[_HashBiMap__K, _HashBiMap__V], java.io.Serializable, _py_Generic[_HashBiMap__K, _HashBiMap__V]):
    def clear(self) -> None: ...
    def containsKey(self, object: _py_Any) -> bool: ...
    def containsValue(self, object: _py_Any) -> bool: ...
    _create_0__K = _py_TypeVar('_create_0__K')  # <K>
    _create_0__V = _py_TypeVar('_create_0__V')  # <V>
    @classmethod
    @overload
    def create(cls) -> 'HashBiMap'[_create_0__K, _create_0__V]: ...
    _create_1__K = _py_TypeVar('_create_1__K')  # <K>
    _create_1__V = _py_TypeVar('_create_1__V')  # <V>
    @classmethod
    @overload
    def create(cls, int: int) -> 'HashBiMap'[_create_1__K, _create_1__V]: ...
    _create_2__K = _py_TypeVar('_create_2__K')  # <K>
    _create_2__V = _py_TypeVar('_create_2__V')  # <V>
    @classmethod
    @overload
    def create(cls, map: java.util.Map[_create_2__K, _create_2__V]) -> 'HashBiMap'[_create_2__K, _create_2__V]: ...
    def entrySet(self) -> java.util.Set: ...
    def forEach(self, biConsumer: java.util.function.BiConsumer[_HashBiMap__K, _HashBiMap__V]) -> None: ...
    def forcePut(self, k: _HashBiMap__K, v: _HashBiMap__V) -> _HashBiMap__V: ...
    def get(self, object: _py_Any) -> _HashBiMap__V: ...
    def inverse(self) -> BiMap[_HashBiMap__V, _HashBiMap__K]: ...
    def keySet(self) -> java.util.Set[_HashBiMap__K]: ...
    def put(self, k: _HashBiMap__K, v: _HashBiMap__V) -> _HashBiMap__V: ...
    @overload
    def remove(self, object: _py_Any, object2: _py_Any) -> bool: ...
    @overload
    def remove(self, object: _py_Any) -> _HashBiMap__V: ...
    def replaceAll(self, biFunction: java.util.function.BiFunction[_HashBiMap__K, _HashBiMap__V, _HashBiMap__V]) -> None: ...
    def size(self) -> int: ...
    @overload
    def values(self) -> java.util.Collection: ...
    @overload
    def values(self) -> java.util.Set[_HashBiMap__V]: ...

_ImmutableAsList__E = _py_TypeVar('_ImmutableAsList__E')  # <E>
class ImmutableAsList(com.google.common.collect.ImmutableList[_ImmutableAsList__E], _py_Generic[_ImmutableAsList__E]):
    def contains(self, object: _py_Any) -> bool: ...
    def isEmpty(self) -> bool: ...
    def size(self) -> int: ...

_ImmutableBiMap__Builder__K = _py_TypeVar('_ImmutableBiMap__Builder__K')  # <K>
_ImmutableBiMap__Builder__V = _py_TypeVar('_ImmutableBiMap__Builder__V')  # <V>
_ImmutableBiMap__K = _py_TypeVar('_ImmutableBiMap__K')  # <K>
_ImmutableBiMap__V = _py_TypeVar('_ImmutableBiMap__V')  # <V>
class ImmutableBiMap(ImmutableBiMapFauxverideShim[_ImmutableBiMap__K, _ImmutableBiMap__V], BiMap[_ImmutableBiMap__K, _ImmutableBiMap__V], _py_Generic[_ImmutableBiMap__K, _ImmutableBiMap__V]):
    _builder_0__K = _py_TypeVar('_builder_0__K')  # <K>
    _builder_0__V = _py_TypeVar('_builder_0__V')  # <V>
    @classmethod
    @overload
    def builder(cls) -> 'ImmutableBiMap.Builder'[_builder_0__K, _builder_0__V]: ...
    _builder_1__K = _py_TypeVar('_builder_1__K')  # <K>
    _builder_1__V = _py_TypeVar('_builder_1__V')  # <V>
    @classmethod
    @overload
    def builder(cls) -> ImmutableMap.Builder[_builder_1__K, _builder_1__V]: ...
    _builderWithExpectedSize_0__K = _py_TypeVar('_builderWithExpectedSize_0__K')  # <K>
    _builderWithExpectedSize_0__V = _py_TypeVar('_builderWithExpectedSize_0__V')  # <V>
    @classmethod
    @overload
    def builderWithExpectedSize(cls, int: int) -> 'ImmutableBiMap.Builder'[_builderWithExpectedSize_0__K, _builderWithExpectedSize_0__V]: ...
    _builderWithExpectedSize_1__K = _py_TypeVar('_builderWithExpectedSize_1__K')  # <K>
    _builderWithExpectedSize_1__V = _py_TypeVar('_builderWithExpectedSize_1__V')  # <V>
    @classmethod
    @overload
    def builderWithExpectedSize(cls, int: int) -> ImmutableMap.Builder[_builderWithExpectedSize_1__K, _builderWithExpectedSize_1__V]: ...
    _copyOf_0__K = _py_TypeVar('_copyOf_0__K')  # <K>
    _copyOf_0__V = _py_TypeVar('_copyOf_0__V')  # <V>
    @classmethod
    @overload
    def copyOf(cls, iterable: java.lang.Iterable[java.util.Map.Entry[_copyOf_0__K, _copyOf_0__V]]) -> 'ImmutableBiMap'[_copyOf_0__K, _copyOf_0__V]: ...
    _copyOf_1__K = _py_TypeVar('_copyOf_1__K')  # <K>
    _copyOf_1__V = _py_TypeVar('_copyOf_1__V')  # <V>
    @classmethod
    @overload
    def copyOf(cls, map: java.util.Map[_copyOf_1__K, _copyOf_1__V]) -> 'ImmutableBiMap'[_copyOf_1__K, _copyOf_1__V]: ...
    _copyOf_2__K = _py_TypeVar('_copyOf_2__K')  # <K>
    _copyOf_2__V = _py_TypeVar('_copyOf_2__V')  # <V>
    @classmethod
    @overload
    def copyOf(cls, iterable: java.lang.Iterable[java.util.Map.Entry[_copyOf_2__K, _copyOf_2__V]]) -> ImmutableMap[_copyOf_2__K, _copyOf_2__V]: ...
    _copyOf_3__K = _py_TypeVar('_copyOf_3__K')  # <K>
    _copyOf_3__V = _py_TypeVar('_copyOf_3__V')  # <V>
    @classmethod
    @overload
    def copyOf(cls, map: java.util.Map[_copyOf_3__K, _copyOf_3__V]) -> ImmutableMap[_copyOf_3__K, _copyOf_3__V]: ...
    def forcePut(self, k: _ImmutableBiMap__K, v: _ImmutableBiMap__V) -> _ImmutableBiMap__V: ...
    @overload
    def inverse(self) -> 'ImmutableBiMap'[_ImmutableBiMap__V, _ImmutableBiMap__K]: ...
    @overload
    def inverse(self) -> BiMap: ...
    _of_0__K = _py_TypeVar('_of_0__K')  # <K>
    _of_0__V = _py_TypeVar('_of_0__V')  # <V>
    @classmethod
    @overload
    def of(cls) -> 'ImmutableBiMap'[_of_0__K, _of_0__V]: ...
    _of_1__K = _py_TypeVar('_of_1__K')  # <K>
    _of_1__V = _py_TypeVar('_of_1__V')  # <V>
    @classmethod
    @overload
    def of(cls, k: _of_1__K, v: _of_1__V) -> 'ImmutableBiMap'[_of_1__K, _of_1__V]: ...
    _of_2__K = _py_TypeVar('_of_2__K')  # <K>
    _of_2__V = _py_TypeVar('_of_2__V')  # <V>
    @classmethod
    @overload
    def of(cls, k: _of_2__K, v: _of_2__V, k2: _of_2__K, v2: _of_2__V) -> 'ImmutableBiMap'[_of_2__K, _of_2__V]: ...
    _of_3__K = _py_TypeVar('_of_3__K')  # <K>
    _of_3__V = _py_TypeVar('_of_3__V')  # <V>
    @classmethod
    @overload
    def of(cls, k: _of_3__K, v: _of_3__V, k2: _of_3__K, v2: _of_3__V, k3: _of_3__K, v3: _of_3__V) -> 'ImmutableBiMap'[_of_3__K, _of_3__V]: ...
    _of_4__K = _py_TypeVar('_of_4__K')  # <K>
    _of_4__V = _py_TypeVar('_of_4__V')  # <V>
    @classmethod
    @overload
    def of(cls, k: _of_4__K, v: _of_4__V, k2: _of_4__K, v2: _of_4__V, k3: _of_4__K, v3: _of_4__V, k4: _of_4__K, v4: _of_4__V) -> 'ImmutableBiMap'[_of_4__K, _of_4__V]: ...
    _of_5__K = _py_TypeVar('_of_5__K')  # <K>
    _of_5__V = _py_TypeVar('_of_5__V')  # <V>
    @classmethod
    @overload
    def of(cls, k: _of_5__K, v: _of_5__V, k2: _of_5__K, v2: _of_5__V, k3: _of_5__K, v3: _of_5__V, k4: _of_5__K, v4: _of_5__V, k5: _of_5__K, v5: _of_5__V) -> 'ImmutableBiMap'[_of_5__K, _of_5__V]: ...
    _of_6__K = _py_TypeVar('_of_6__K')  # <K>
    _of_6__V = _py_TypeVar('_of_6__V')  # <V>
    @classmethod
    @overload
    def of(cls) -> ImmutableMap[_of_6__K, _of_6__V]: ...
    _of_7__K = _py_TypeVar('_of_7__K')  # <K>
    _of_7__V = _py_TypeVar('_of_7__V')  # <V>
    @classmethod
    @overload
    def of(cls, k: _of_7__K, v: _of_7__V) -> ImmutableMap[_of_7__K, _of_7__V]: ...
    _of_8__K = _py_TypeVar('_of_8__K')  # <K>
    _of_8__V = _py_TypeVar('_of_8__V')  # <V>
    @classmethod
    @overload
    def of(cls, k: _of_8__K, v: _of_8__V, k2: _of_8__K, v2: _of_8__V) -> ImmutableMap[_of_8__K, _of_8__V]: ...
    _of_9__K = _py_TypeVar('_of_9__K')  # <K>
    _of_9__V = _py_TypeVar('_of_9__V')  # <V>
    @classmethod
    @overload
    def of(cls, k: _of_9__K, v: _of_9__V, k2: _of_9__K, v2: _of_9__V, k3: _of_9__K, v3: _of_9__V) -> ImmutableMap[_of_9__K, _of_9__V]: ...
    _of_10__K = _py_TypeVar('_of_10__K')  # <K>
    _of_10__V = _py_TypeVar('_of_10__V')  # <V>
    @classmethod
    @overload
    def of(cls, k: _of_10__K, v: _of_10__V, k2: _of_10__K, v2: _of_10__V, k3: _of_10__K, v3: _of_10__V, k4: _of_10__K, v4: _of_10__V) -> ImmutableMap[_of_10__K, _of_10__V]: ...
    _of_11__K = _py_TypeVar('_of_11__K')  # <K>
    _of_11__V = _py_TypeVar('_of_11__V')  # <V>
    @classmethod
    @overload
    def of(cls, k: _of_11__K, v: _of_11__V, k2: _of_11__K, v2: _of_11__V, k3: _of_11__K, v3: _of_11__V, k4: _of_11__K, v4: _of_11__V, k5: _of_11__K, v5: _of_11__V) -> ImmutableMap[_of_11__K, _of_11__V]: ...
    _toImmutableBiMap__T = _py_TypeVar('_toImmutableBiMap__T')  # <T>
    _toImmutableBiMap__K = _py_TypeVar('_toImmutableBiMap__K')  # <K>
    _toImmutableBiMap__V = _py_TypeVar('_toImmutableBiMap__V')  # <V>
    @classmethod
    def toImmutableBiMap(cls, function: java.util.function.Function[_toImmutableBiMap__T, _toImmutableBiMap__K], function2: java.util.function.Function[_toImmutableBiMap__T, _toImmutableBiMap__V]) -> java.util.stream.Collector[_toImmutableBiMap__T, _py_Any, 'ImmutableBiMap'[_toImmutableBiMap__K, _toImmutableBiMap__V]]: ...
    @overload
    def values(self) -> ImmutableCollection: ...
    @overload
    def values(self) -> 'ImmutableSet'[_ImmutableBiMap__V]: ...
    @overload
    def values(self) -> java.util.Collection: ...
    @overload
    def values(self) -> java.util.Set: ...
    class Builder(ImmutableMap.Builder[_ImmutableBiMap__Builder__K, _ImmutableBiMap__Builder__V], _py_Generic[_ImmutableBiMap__Builder__K, _ImmutableBiMap__Builder__V]):
        def __init__(self): ...
        @overload
        def build(self) -> 'ImmutableBiMap'[_ImmutableBiMap__Builder__K, _ImmutableBiMap__Builder__V]: ...
        @overload
        def build(self) -> ImmutableMap: ...
        @overload
        def orderEntriesByValue(self, comparator: java.util.Comparator[_ImmutableBiMap__Builder__V]) -> 'ImmutableBiMap.Builder'[_ImmutableBiMap__Builder__K, _ImmutableBiMap__Builder__V]: ...
        @overload
        def orderEntriesByValue(self, comparator: java.util.Comparator) -> ImmutableMap.Builder: ...
        @overload
        def put(self, k: _ImmutableBiMap__Builder__K, v: _ImmutableBiMap__Builder__V) -> 'ImmutableBiMap.Builder'[_ImmutableBiMap__Builder__K, _ImmutableBiMap__Builder__V]: ...
        @overload
        def put(self, entry: java.util.Map.Entry[_ImmutableBiMap__Builder__K, _ImmutableBiMap__Builder__V]) -> 'ImmutableBiMap.Builder'[_ImmutableBiMap__Builder__K, _ImmutableBiMap__Builder__V]: ...
        @overload
        def put(self, object: _py_Any, object2: _py_Any) -> ImmutableMap.Builder: ...
        @overload
        def put(self, entry: java.util.Map.Entry) -> ImmutableMap.Builder: ...
        @overload
        def putAll(self, iterable: java.lang.Iterable[java.util.Map.Entry[_ImmutableBiMap__Builder__K, _ImmutableBiMap__Builder__V]]) -> 'ImmutableBiMap.Builder'[_ImmutableBiMap__Builder__K, _ImmutableBiMap__Builder__V]: ...
        @overload
        def putAll(self, map: java.util.Map[_ImmutableBiMap__Builder__K, _ImmutableBiMap__Builder__V]) -> 'ImmutableBiMap.Builder'[_ImmutableBiMap__Builder__K, _ImmutableBiMap__Builder__V]: ...
        @overload
        def putAll(self, iterable: java.lang.Iterable) -> ImmutableMap.Builder: ...
        @overload
        def putAll(self, map: java.util.Map) -> ImmutableMap.Builder: ...

_ImmutableEnumMap__K = _py_TypeVar('_ImmutableEnumMap__K', bound=java.lang.Enum)  # <K>
_ImmutableEnumMap__V = _py_TypeVar('_ImmutableEnumMap__V')  # <V>
class ImmutableEnumMap(com.google.common.collect.ImmutableMap.IteratorBasedImmutableMap[_ImmutableEnumMap__K, _ImmutableEnumMap__V], _py_Generic[_ImmutableEnumMap__K, _ImmutableEnumMap__V]):
    def containsKey(self, object: _py_Any) -> bool: ...
    def equals(self, object: _py_Any) -> bool: ...
    def forEach(self, biConsumer: java.util.function.BiConsumer[_ImmutableEnumMap__K, _ImmutableEnumMap__V]) -> None: ...
    def get(self, object: _py_Any) -> _ImmutableEnumMap__V: ...
    def size(self) -> int: ...

_ImmutableEnumSet__E = _py_TypeVar('_ImmutableEnumSet__E', bound=java.lang.Enum)  # <E>
class ImmutableEnumSet(com.google.common.collect.ImmutableSet[_ImmutableEnumSet__E], _py_Generic[_ImmutableEnumSet__E]):
    def contains(self, object: _py_Any) -> bool: ...
    def containsAll(self, collection: java.util.Collection[_py_Any]) -> bool: ...
    def equals(self, object: _py_Any) -> bool: ...
    def forEach(self, consumer: java.util.function.Consumer[_ImmutableEnumSet__E]) -> None: ...
    def hashCode(self) -> int: ...
    def isEmpty(self) -> bool: ...
    @overload
    def iterator(self) -> UnmodifiableIterator[_ImmutableEnumSet__E]: ...
    @overload
    def iterator(self) -> java.util.Iterator: ...
    def size(self) -> int: ...
    def spliterator(self) -> java.util.Spliterator[_ImmutableEnumSet__E]: ...
    def toString(self) -> str: ...

_ImmutableList__Builder__E = _py_TypeVar('_ImmutableList__Builder__E')  # <E>
_ImmutableList__E = _py_TypeVar('_ImmutableList__E')  # <E>
class ImmutableList(ImmutableCollection[_ImmutableList__E], java.util.List[_ImmutableList__E], java.util.RandomAccess, _py_Generic[_ImmutableList__E]):
    @overload
    def add(self, e: _ImmutableList__E) -> bool: ...
    @overload
    def add(self, int: int, e: _ImmutableList__E) -> None: ...
    @overload
    def addAll(self, collection: java.util.Collection[_ImmutableList__E]) -> bool: ...
    @overload
    def addAll(self, int: int, collection: java.util.Collection[_ImmutableList__E]) -> bool: ...
    def asList(self) -> 'ImmutableList'[_ImmutableList__E]: ...
    _builder__E = _py_TypeVar('_builder__E')  # <E>
    @classmethod
    def builder(cls) -> 'ImmutableList.Builder'[_builder__E]: ...
    _builderWithExpectedSize__E = _py_TypeVar('_builderWithExpectedSize__E')  # <E>
    @classmethod
    def builderWithExpectedSize(cls, int: int) -> 'ImmutableList.Builder'[_builderWithExpectedSize__E]: ...
    def contains(self, object: _py_Any) -> bool: ...
    _copyOf_0__E = _py_TypeVar('_copyOf_0__E')  # <E>
    @classmethod
    @overload
    def copyOf(cls, iterable: java.lang.Iterable[_copyOf_0__E]) -> 'ImmutableList'[_copyOf_0__E]: ...
    _copyOf_1__E = _py_TypeVar('_copyOf_1__E')  # <E>
    @classmethod
    @overload
    def copyOf(cls, eArray: _py_List[_copyOf_1__E]) -> 'ImmutableList'[_copyOf_1__E]: ...
    _copyOf_2__E = _py_TypeVar('_copyOf_2__E')  # <E>
    @classmethod
    @overload
    def copyOf(cls, collection: java.util.Collection[_copyOf_2__E]) -> 'ImmutableList'[_copyOf_2__E]: ...
    _copyOf_3__E = _py_TypeVar('_copyOf_3__E')  # <E>
    @classmethod
    @overload
    def copyOf(cls, iterator: java.util.Iterator[_copyOf_3__E]) -> 'ImmutableList'[_copyOf_3__E]: ...
    def equals(self, object: _py_Any) -> bool: ...
    def forEach(self, consumer: java.util.function.Consumer[_ImmutableList__E]) -> None: ...
    def hashCode(self) -> int: ...
    def indexOf(self, object: _py_Any) -> int: ...
    @overload
    def iterator(self) -> UnmodifiableIterator[_ImmutableList__E]: ...
    @overload
    def iterator(self) -> java.util.Iterator: ...
    def lastIndexOf(self, object: _py_Any) -> int: ...
    @overload
    def listIterator(self) -> UnmodifiableListIterator[_ImmutableList__E]: ...
    @overload
    def listIterator(self, int: int) -> UnmodifiableListIterator[_ImmutableList__E]: ...
    @overload
    def listIterator(self) -> java.util.ListIterator: ...
    @overload
    def listIterator(self, int: int) -> java.util.ListIterator: ...
    _of_0__E = _py_TypeVar('_of_0__E')  # <E>
    @classmethod
    @overload
    def of(cls) -> 'ImmutableList'[_of_0__E]: ...
    _of_1__E = _py_TypeVar('_of_1__E')  # <E>
    @classmethod
    @overload
    def of(cls, e: _of_1__E) -> 'ImmutableList'[_of_1__E]: ...
    _of_2__E = _py_TypeVar('_of_2__E')  # <E>
    @classmethod
    @overload
    def of(cls, e: _of_2__E, e2: _of_2__E) -> 'ImmutableList'[_of_2__E]: ...
    _of_3__E = _py_TypeVar('_of_3__E')  # <E>
    @classmethod
    @overload
    def of(cls, e: _of_3__E, e2: _of_3__E, e3: _of_3__E) -> 'ImmutableList'[_of_3__E]: ...
    _of_4__E = _py_TypeVar('_of_4__E')  # <E>
    @classmethod
    @overload
    def of(cls, e: _of_4__E, e2: _of_4__E, e3: _of_4__E, e4: _of_4__E) -> 'ImmutableList'[_of_4__E]: ...
    _of_5__E = _py_TypeVar('_of_5__E')  # <E>
    @classmethod
    @overload
    def of(cls, e: _of_5__E, e2: _of_5__E, e3: _of_5__E, e4: _of_5__E, e5: _of_5__E) -> 'ImmutableList'[_of_5__E]: ...
    _of_6__E = _py_TypeVar('_of_6__E')  # <E>
    @classmethod
    @overload
    def of(cls, e: _of_6__E, e2: _of_6__E, e3: _of_6__E, e4: _of_6__E, e5: _of_6__E, e6: _of_6__E) -> 'ImmutableList'[_of_6__E]: ...
    _of_7__E = _py_TypeVar('_of_7__E')  # <E>
    @classmethod
    @overload
    def of(cls, e: _of_7__E, e2: _of_7__E, e3: _of_7__E, e4: _of_7__E, e5: _of_7__E, e6: _of_7__E, e7: _of_7__E) -> 'ImmutableList'[_of_7__E]: ...
    _of_8__E = _py_TypeVar('_of_8__E')  # <E>
    @classmethod
    @overload
    def of(cls, e: _of_8__E, e2: _of_8__E, e3: _of_8__E, e4: _of_8__E, e5: _of_8__E, e6: _of_8__E, e7: _of_8__E, e8: _of_8__E) -> 'ImmutableList'[_of_8__E]: ...
    _of_9__E = _py_TypeVar('_of_9__E')  # <E>
    @classmethod
    @overload
    def of(cls, e: _of_9__E, e2: _of_9__E, e3: _of_9__E, e4: _of_9__E, e5: _of_9__E, e6: _of_9__E, e7: _of_9__E, e8: _of_9__E, e9: _of_9__E) -> 'ImmutableList'[_of_9__E]: ...
    _of_10__E = _py_TypeVar('_of_10__E')  # <E>
    @classmethod
    @overload
    def of(cls, e: _of_10__E, e2: _of_10__E, e3: _of_10__E, e4: _of_10__E, e5: _of_10__E, e6: _of_10__E, e7: _of_10__E, e8: _of_10__E, e9: _of_10__E, e10: _of_10__E) -> 'ImmutableList'[_of_10__E]: ...
    _of_11__E = _py_TypeVar('_of_11__E')  # <E>
    @classmethod
    @overload
    def of(cls, e: _of_11__E, e2: _of_11__E, e3: _of_11__E, e4: _of_11__E, e5: _of_11__E, e6: _of_11__E, e7: _of_11__E, e8: _of_11__E, e9: _of_11__E, e10: _of_11__E, e11: _of_11__E) -> 'ImmutableList'[_of_11__E]: ...
    _of_12__E = _py_TypeVar('_of_12__E')  # <E>
    @classmethod
    @overload
    def of(cls, e: _of_12__E, e2: _of_12__E, e3: _of_12__E, e4: _of_12__E, e5: _of_12__E, e6: _of_12__E, e7: _of_12__E, e8: _of_12__E, e9: _of_12__E, e10: _of_12__E, e11: _of_12__E, e12: _of_12__E, eArray: _py_List[_of_12__E]) -> 'ImmutableList'[_of_12__E]: ...
    @overload
    def remove(self, object: _py_Any) -> bool: ...
    @overload
    def remove(self, int: int) -> _ImmutableList__E: ...
    def replaceAll(self, unaryOperator: java.util.function.UnaryOperator[_ImmutableList__E]) -> None: ...
    def reverse(self) -> 'ImmutableList'[_ImmutableList__E]: ...
    def set(self, int: int, e: _ImmutableList__E) -> _ImmutableList__E: ...
    def sort(self, comparator: java.util.Comparator[_ImmutableList__E]) -> None: ...
    _sortedCopyOf_0__E = _py_TypeVar('_sortedCopyOf_0__E', bound=java.lang.Comparable)  # <E>
    @classmethod
    @overload
    def sortedCopyOf(cls, iterable: java.lang.Iterable[_sortedCopyOf_0__E]) -> 'ImmutableList'[_sortedCopyOf_0__E]: ...
    _sortedCopyOf_1__E = _py_TypeVar('_sortedCopyOf_1__E')  # <E>
    @classmethod
    @overload
    def sortedCopyOf(cls, comparator: java.util.Comparator[_sortedCopyOf_1__E], iterable: java.lang.Iterable[_sortedCopyOf_1__E]) -> 'ImmutableList'[_sortedCopyOf_1__E]: ...
    def spliterator(self) -> java.util.Spliterator[_ImmutableList__E]: ...
    @overload
    def subList(self, int: int, int2: int) -> 'ImmutableList'[_ImmutableList__E]: ...
    @overload
    def subList(self, int: int, int2: int) -> java.util.List: ...
    _toImmutableList__E = _py_TypeVar('_toImmutableList__E')  # <E>
    @classmethod
    def toImmutableList(cls) -> java.util.stream.Collector[_toImmutableList__E, _py_Any, 'ImmutableList'[_toImmutableList__E]]: ...
    class Builder(ImmutableCollection.Builder[_ImmutableList__Builder__E], _py_Generic[_ImmutableList__Builder__E]):
        def __init__(self): ...
        @overload
        def add(self, object: _py_Any) -> ImmutableCollection.Builder: ...
        @overload
        def add(self, objectArray: _py_List[_py_Any]) -> ImmutableCollection.Builder: ...
        @overload
        def add(self, e: _ImmutableList__Builder__E) -> 'ImmutableList.Builder'[_ImmutableList__Builder__E]: ...
        @overload
        def add(self, eArray: _py_List[_ImmutableList__Builder__E]) -> 'ImmutableList.Builder'[_ImmutableList__Builder__E]: ...
        @overload
        def addAll(self, iterable: java.lang.Iterable) -> ImmutableCollection.Builder: ...
        @overload
        def addAll(self, iterator: java.util.Iterator) -> ImmutableCollection.Builder: ...
        @overload
        def addAll(self, iterable: java.lang.Iterable[_ImmutableList__Builder__E]) -> 'ImmutableList.Builder'[_ImmutableList__Builder__E]: ...
        @overload
        def addAll(self, iterator: java.util.Iterator[_ImmutableList__Builder__E]) -> 'ImmutableList.Builder'[_ImmutableList__Builder__E]: ...
        @overload
        def build(self) -> ImmutableCollection: ...
        @overload
        def build(self) -> 'ImmutableList'[_ImmutableList__Builder__E]: ...

_ImmutableListMultimap__Builder__K = _py_TypeVar('_ImmutableListMultimap__Builder__K')  # <K>
_ImmutableListMultimap__Builder__V = _py_TypeVar('_ImmutableListMultimap__Builder__V')  # <V>
_ImmutableListMultimap__K = _py_TypeVar('_ImmutableListMultimap__K')  # <K>
_ImmutableListMultimap__V = _py_TypeVar('_ImmutableListMultimap__V')  # <V>
class ImmutableListMultimap(ImmutableMultimap[_ImmutableListMultimap__K, _ImmutableListMultimap__V], ListMultimap[_ImmutableListMultimap__K, _ImmutableListMultimap__V], _py_Generic[_ImmutableListMultimap__K, _ImmutableListMultimap__V]):
    _builder_0__K = _py_TypeVar('_builder_0__K')  # <K>
    _builder_0__V = _py_TypeVar('_builder_0__V')  # <V>
    @classmethod
    @overload
    def builder(cls) -> 'ImmutableListMultimap.Builder'[_builder_0__K, _builder_0__V]: ...
    _builder_1__K = _py_TypeVar('_builder_1__K')  # <K>
    _builder_1__V = _py_TypeVar('_builder_1__V')  # <V>
    @classmethod
    @overload
    def builder(cls) -> ImmutableMultimap.Builder[_builder_1__K, _builder_1__V]: ...
    _copyOf_0__K = _py_TypeVar('_copyOf_0__K')  # <K>
    _copyOf_0__V = _py_TypeVar('_copyOf_0__V')  # <V>
    @classmethod
    @overload
    def copyOf(cls, multimap: Multimap[_copyOf_0__K, _copyOf_0__V]) -> 'ImmutableListMultimap'[_copyOf_0__K, _copyOf_0__V]: ...
    _copyOf_1__K = _py_TypeVar('_copyOf_1__K')  # <K>
    _copyOf_1__V = _py_TypeVar('_copyOf_1__V')  # <V>
    @classmethod
    @overload
    def copyOf(cls, iterable: java.lang.Iterable[java.util.Map.Entry[_copyOf_1__K, _copyOf_1__V]]) -> 'ImmutableListMultimap'[_copyOf_1__K, _copyOf_1__V]: ...
    _copyOf_2__K = _py_TypeVar('_copyOf_2__K')  # <K>
    _copyOf_2__V = _py_TypeVar('_copyOf_2__V')  # <V>
    @classmethod
    @overload
    def copyOf(cls, multimap: Multimap[_copyOf_2__K, _copyOf_2__V]) -> ImmutableMultimap[_copyOf_2__K, _copyOf_2__V]: ...
    _copyOf_3__K = _py_TypeVar('_copyOf_3__K')  # <K>
    _copyOf_3__V = _py_TypeVar('_copyOf_3__V')  # <V>
    @classmethod
    @overload
    def copyOf(cls, iterable: java.lang.Iterable[java.util.Map.Entry[_copyOf_3__K, _copyOf_3__V]]) -> ImmutableMultimap[_copyOf_3__K, _copyOf_3__V]: ...
    _flatteningToImmutableListMultimap__T = _py_TypeVar('_flatteningToImmutableListMultimap__T')  # <T>
    _flatteningToImmutableListMultimap__K = _py_TypeVar('_flatteningToImmutableListMultimap__K')  # <K>
    _flatteningToImmutableListMultimap__V = _py_TypeVar('_flatteningToImmutableListMultimap__V')  # <V>
    @classmethod
    def flatteningToImmutableListMultimap(cls, function: java.util.function.Function[_flatteningToImmutableListMultimap__T, _flatteningToImmutableListMultimap__K], function2: java.util.function.Function[_flatteningToImmutableListMultimap__T, java.util.stream.Stream[_flatteningToImmutableListMultimap__V]]) -> java.util.stream.Collector[_flatteningToImmutableListMultimap__T, _py_Any, 'ImmutableListMultimap'[_flatteningToImmutableListMultimap__K, _flatteningToImmutableListMultimap__V]]: ...
    @overload
    def get(self, object: _py_Any) -> ImmutableCollection: ...
    @overload
    def get(self, k: _ImmutableListMultimap__K) -> ImmutableList[_ImmutableListMultimap__V]: ...
    @overload
    def get(self, object: _py_Any) -> java.util.Collection: ...
    @overload
    def get(self, object: _py_Any) -> java.util.List: ...
    @overload
    def inverse(self) -> 'ImmutableListMultimap'[_ImmutableListMultimap__V, _ImmutableListMultimap__K]: ...
    @overload
    def inverse(self) -> ImmutableMultimap: ...
    _of_0__K = _py_TypeVar('_of_0__K')  # <K>
    _of_0__V = _py_TypeVar('_of_0__V')  # <V>
    @classmethod
    @overload
    def of(cls) -> 'ImmutableListMultimap'[_of_0__K, _of_0__V]: ...
    _of_1__K = _py_TypeVar('_of_1__K')  # <K>
    _of_1__V = _py_TypeVar('_of_1__V')  # <V>
    @classmethod
    @overload
    def of(cls, k: _of_1__K, v: _of_1__V) -> 'ImmutableListMultimap'[_of_1__K, _of_1__V]: ...
    _of_2__K = _py_TypeVar('_of_2__K')  # <K>
    _of_2__V = _py_TypeVar('_of_2__V')  # <V>
    @classmethod
    @overload
    def of(cls, k: _of_2__K, v: _of_2__V, k2: _of_2__K, v2: _of_2__V) -> 'ImmutableListMultimap'[_of_2__K, _of_2__V]: ...
    _of_3__K = _py_TypeVar('_of_3__K')  # <K>
    _of_3__V = _py_TypeVar('_of_3__V')  # <V>
    @classmethod
    @overload
    def of(cls, k: _of_3__K, v: _of_3__V, k2: _of_3__K, v2: _of_3__V, k3: _of_3__K, v3: _of_3__V) -> 'ImmutableListMultimap'[_of_3__K, _of_3__V]: ...
    _of_4__K = _py_TypeVar('_of_4__K')  # <K>
    _of_4__V = _py_TypeVar('_of_4__V')  # <V>
    @classmethod
    @overload
    def of(cls, k: _of_4__K, v: _of_4__V, k2: _of_4__K, v2: _of_4__V, k3: _of_4__K, v3: _of_4__V, k4: _of_4__K, v4: _of_4__V) -> 'ImmutableListMultimap'[_of_4__K, _of_4__V]: ...
    _of_5__K = _py_TypeVar('_of_5__K')  # <K>
    _of_5__V = _py_TypeVar('_of_5__V')  # <V>
    @classmethod
    @overload
    def of(cls, k: _of_5__K, v: _of_5__V, k2: _of_5__K, v2: _of_5__V, k3: _of_5__K, v3: _of_5__V, k4: _of_5__K, v4: _of_5__V, k5: _of_5__K, v5: _of_5__V) -> 'ImmutableListMultimap'[_of_5__K, _of_5__V]: ...
    _of_6__K = _py_TypeVar('_of_6__K')  # <K>
    _of_6__V = _py_TypeVar('_of_6__V')  # <V>
    @classmethod
    @overload
    def of(cls) -> ImmutableMultimap[_of_6__K, _of_6__V]: ...
    _of_7__K = _py_TypeVar('_of_7__K')  # <K>
    _of_7__V = _py_TypeVar('_of_7__V')  # <V>
    @classmethod
    @overload
    def of(cls, k: _of_7__K, v: _of_7__V) -> ImmutableMultimap[_of_7__K, _of_7__V]: ...
    _of_8__K = _py_TypeVar('_of_8__K')  # <K>
    _of_8__V = _py_TypeVar('_of_8__V')  # <V>
    @classmethod
    @overload
    def of(cls, k: _of_8__K, v: _of_8__V, k2: _of_8__K, v2: _of_8__V) -> ImmutableMultimap[_of_8__K, _of_8__V]: ...
    _of_9__K = _py_TypeVar('_of_9__K')  # <K>
    _of_9__V = _py_TypeVar('_of_9__V')  # <V>
    @classmethod
    @overload
    def of(cls, k: _of_9__K, v: _of_9__V, k2: _of_9__K, v2: _of_9__V, k3: _of_9__K, v3: _of_9__V) -> ImmutableMultimap[_of_9__K, _of_9__V]: ...
    _of_10__K = _py_TypeVar('_of_10__K')  # <K>
    _of_10__V = _py_TypeVar('_of_10__V')  # <V>
    @classmethod
    @overload
    def of(cls, k: _of_10__K, v: _of_10__V, k2: _of_10__K, v2: _of_10__V, k3: _of_10__K, v3: _of_10__V, k4: _of_10__K, v4: _of_10__V) -> ImmutableMultimap[_of_10__K, _of_10__V]: ...
    _of_11__K = _py_TypeVar('_of_11__K')  # <K>
    _of_11__V = _py_TypeVar('_of_11__V')  # <V>
    @classmethod
    @overload
    def of(cls, k: _of_11__K, v: _of_11__V, k2: _of_11__K, v2: _of_11__V, k3: _of_11__K, v3: _of_11__V, k4: _of_11__K, v4: _of_11__V, k5: _of_11__K, v5: _of_11__V) -> ImmutableMultimap[_of_11__K, _of_11__V]: ...
    @overload
    def removeAll(self, object: _py_Any) -> ImmutableCollection: ...
    @overload
    def removeAll(self, object: _py_Any) -> ImmutableList[_ImmutableListMultimap__V]: ...
    @overload
    def removeAll(self, object: _py_Any) -> java.util.Collection: ...
    @overload
    def removeAll(self, object: _py_Any) -> java.util.List: ...
    @overload
    def replaceValues(self, object: _py_Any, iterable: java.lang.Iterable) -> ImmutableCollection: ...
    @overload
    def replaceValues(self, k: _ImmutableListMultimap__K, iterable: java.lang.Iterable[_ImmutableListMultimap__V]) -> ImmutableList[_ImmutableListMultimap__V]: ...
    @overload
    def replaceValues(self, object: _py_Any, iterable: java.lang.Iterable) -> java.util.Collection: ...
    @overload
    def replaceValues(self, object: _py_Any, iterable: java.lang.Iterable) -> java.util.List: ...
    _toImmutableListMultimap__T = _py_TypeVar('_toImmutableListMultimap__T')  # <T>
    _toImmutableListMultimap__K = _py_TypeVar('_toImmutableListMultimap__K')  # <K>
    _toImmutableListMultimap__V = _py_TypeVar('_toImmutableListMultimap__V')  # <V>
    @classmethod
    def toImmutableListMultimap(cls, function: java.util.function.Function[_toImmutableListMultimap__T, _toImmutableListMultimap__K], function2: java.util.function.Function[_toImmutableListMultimap__T, _toImmutableListMultimap__V]) -> java.util.stream.Collector[_toImmutableListMultimap__T, _py_Any, 'ImmutableListMultimap'[_toImmutableListMultimap__K, _toImmutableListMultimap__V]]: ...
    class Builder(ImmutableMultimap.Builder[_ImmutableListMultimap__Builder__K, _ImmutableListMultimap__Builder__V], _py_Generic[_ImmutableListMultimap__Builder__K, _ImmutableListMultimap__Builder__V]):
        def __init__(self): ...
        @overload
        def build(self) -> 'ImmutableListMultimap'[_ImmutableListMultimap__Builder__K, _ImmutableListMultimap__Builder__V]: ...
        @overload
        def build(self) -> ImmutableMultimap: ...
        @overload
        def orderKeysBy(self, comparator: java.util.Comparator[_ImmutableListMultimap__Builder__K]) -> 'ImmutableListMultimap.Builder'[_ImmutableListMultimap__Builder__K, _ImmutableListMultimap__Builder__V]: ...
        @overload
        def orderKeysBy(self, comparator: java.util.Comparator) -> ImmutableMultimap.Builder: ...
        @overload
        def orderValuesBy(self, comparator: java.util.Comparator[_ImmutableListMultimap__Builder__V]) -> 'ImmutableListMultimap.Builder'[_ImmutableListMultimap__Builder__K, _ImmutableListMultimap__Builder__V]: ...
        @overload
        def orderValuesBy(self, comparator: java.util.Comparator) -> ImmutableMultimap.Builder: ...
        @overload
        def put(self, k: _ImmutableListMultimap__Builder__K, v: _ImmutableListMultimap__Builder__V) -> 'ImmutableListMultimap.Builder'[_ImmutableListMultimap__Builder__K, _ImmutableListMultimap__Builder__V]: ...
        @overload
        def put(self, entry: java.util.Map.Entry[_ImmutableListMultimap__Builder__K, _ImmutableListMultimap__Builder__V]) -> 'ImmutableListMultimap.Builder'[_ImmutableListMultimap__Builder__K, _ImmutableListMultimap__Builder__V]: ...
        @overload
        def put(self, object: _py_Any, object2: _py_Any) -> ImmutableMultimap.Builder: ...
        @overload
        def put(self, entry: java.util.Map.Entry) -> ImmutableMultimap.Builder: ...
        @overload
        def putAll(self, multimap: Multimap[_ImmutableListMultimap__Builder__K, _ImmutableListMultimap__Builder__V]) -> 'ImmutableListMultimap.Builder'[_ImmutableListMultimap__Builder__K, _ImmutableListMultimap__Builder__V]: ...
        @overload
        def putAll(self, iterable: java.lang.Iterable[java.util.Map.Entry[_ImmutableListMultimap__Builder__K, _ImmutableListMultimap__Builder__V]]) -> 'ImmutableListMultimap.Builder'[_ImmutableListMultimap__Builder__K, _ImmutableListMultimap__Builder__V]: ...
        @overload
        def putAll(self, k: _ImmutableListMultimap__Builder__K, iterable: java.lang.Iterable[_ImmutableListMultimap__Builder__V]) -> 'ImmutableListMultimap.Builder'[_ImmutableListMultimap__Builder__K, _ImmutableListMultimap__Builder__V]: ...
        @overload
        def putAll(self, k: _ImmutableListMultimap__Builder__K, vArray: _py_List[_ImmutableListMultimap__Builder__V]) -> 'ImmutableListMultimap.Builder'[_ImmutableListMultimap__Builder__K, _ImmutableListMultimap__Builder__V]: ...
        @overload
        def putAll(self, multimap: Multimap) -> ImmutableMultimap.Builder: ...
        @overload
        def putAll(self, iterable: java.lang.Iterable) -> ImmutableMultimap.Builder: ...
        @overload
        def putAll(self, object: _py_Any, iterable: java.lang.Iterable) -> ImmutableMultimap.Builder: ...
        @overload
        def putAll(self, object: _py_Any, objectArray: _py_List[_py_Any]) -> ImmutableMultimap.Builder: ...

_ImmutableMapEntrySet__K = _py_TypeVar('_ImmutableMapEntrySet__K')  # <K>
_ImmutableMapEntrySet__V = _py_TypeVar('_ImmutableMapEntrySet__V')  # <V>
class ImmutableMapEntrySet(com.google.common.collect.ImmutableSet[java.util.Map.Entry[_ImmutableMapEntrySet__K, _ImmutableMapEntrySet__V]], _py_Generic[_ImmutableMapEntrySet__K, _ImmutableMapEntrySet__V]):
    def contains(self, object: _py_Any) -> bool: ...
    def hashCode(self) -> int: ...
    def size(self) -> int: ...

_ImmutableMapKeySet__K = _py_TypeVar('_ImmutableMapKeySet__K')  # <K>
_ImmutableMapKeySet__V = _py_TypeVar('_ImmutableMapKeySet__V')  # <V>
class ImmutableMapKeySet(com.google.common.collect.IndexedImmutableSet[_ImmutableMapKeySet__K], _py_Generic[_ImmutableMapKeySet__K, _ImmutableMapKeySet__V]):
    def contains(self, object: _py_Any) -> bool: ...
    def forEach(self, consumer: java.util.function.Consumer[_ImmutableMapKeySet__K]) -> None: ...
    @overload
    def iterator(self) -> UnmodifiableIterator[_ImmutableMapKeySet__K]: ...
    @overload
    def iterator(self) -> java.util.Iterator: ...
    def size(self) -> int: ...
    def spliterator(self) -> java.util.Spliterator[_ImmutableMapKeySet__K]: ...

_ImmutableMultiset__Builder__E = _py_TypeVar('_ImmutableMultiset__Builder__E')  # <E>
_ImmutableMultiset__E = _py_TypeVar('_ImmutableMultiset__E')  # <E>
class ImmutableMultiset(ImmutableMultisetGwtSerializationDependencies[_ImmutableMultiset__E], Multiset[_ImmutableMultiset__E], _py_Generic[_ImmutableMultiset__E]):
    @overload
    def add(self, e: _ImmutableMultiset__E) -> bool: ...
    @overload
    def add(self, e: _ImmutableMultiset__E, int: int) -> int: ...
    def asList(self) -> ImmutableList[_ImmutableMultiset__E]: ...
    _builder__E = _py_TypeVar('_builder__E')  # <E>
    @classmethod
    def builder(cls) -> 'ImmutableMultiset.Builder'[_builder__E]: ...
    def contains(self, object: _py_Any) -> bool: ...
    _copyOf_0__E = _py_TypeVar('_copyOf_0__E')  # <E>
    @classmethod
    @overload
    def copyOf(cls, iterable: java.lang.Iterable[_copyOf_0__E]) -> 'ImmutableMultiset'[_copyOf_0__E]: ...
    _copyOf_1__E = _py_TypeVar('_copyOf_1__E')  # <E>
    @classmethod
    @overload
    def copyOf(cls, eArray: _py_List[_copyOf_1__E]) -> 'ImmutableMultiset'[_copyOf_1__E]: ...
    _copyOf_2__E = _py_TypeVar('_copyOf_2__E')  # <E>
    @classmethod
    @overload
    def copyOf(cls, iterator: java.util.Iterator[_copyOf_2__E]) -> 'ImmutableMultiset'[_copyOf_2__E]: ...
    @overload
    def elementSet(self) -> 'ImmutableSet'[_ImmutableMultiset__E]: ...
    @overload
    def elementSet(self) -> java.util.Set: ...
    @overload
    def entrySet(self) -> 'ImmutableSet'[Multiset.Entry[_ImmutableMultiset__E]]: ...
    @overload
    def entrySet(self) -> java.util.Set: ...
    def equals(self, object: _py_Any) -> bool: ...
    def hashCode(self) -> int: ...
    @overload
    def iterator(self) -> UnmodifiableIterator[_ImmutableMultiset__E]: ...
    @overload
    def iterator(self) -> java.util.Iterator: ...
    _of_0__E = _py_TypeVar('_of_0__E')  # <E>
    @classmethod
    @overload
    def of(cls) -> 'ImmutableMultiset'[_of_0__E]: ...
    _of_1__E = _py_TypeVar('_of_1__E')  # <E>
    @classmethod
    @overload
    def of(cls, e: _of_1__E) -> 'ImmutableMultiset'[_of_1__E]: ...
    _of_2__E = _py_TypeVar('_of_2__E')  # <E>
    @classmethod
    @overload
    def of(cls, e: _of_2__E, e2: _of_2__E) -> 'ImmutableMultiset'[_of_2__E]: ...
    _of_3__E = _py_TypeVar('_of_3__E')  # <E>
    @classmethod
    @overload
    def of(cls, e: _of_3__E, e2: _of_3__E, e3: _of_3__E) -> 'ImmutableMultiset'[_of_3__E]: ...
    _of_4__E = _py_TypeVar('_of_4__E')  # <E>
    @classmethod
    @overload
    def of(cls, e: _of_4__E, e2: _of_4__E, e3: _of_4__E, e4: _of_4__E) -> 'ImmutableMultiset'[_of_4__E]: ...
    _of_5__E = _py_TypeVar('_of_5__E')  # <E>
    @classmethod
    @overload
    def of(cls, e: _of_5__E, e2: _of_5__E, e3: _of_5__E, e4: _of_5__E, e5: _of_5__E) -> 'ImmutableMultiset'[_of_5__E]: ...
    _of_6__E = _py_TypeVar('_of_6__E')  # <E>
    @classmethod
    @overload
    def of(cls, e: _of_6__E, e2: _of_6__E, e3: _of_6__E, e4: _of_6__E, e5: _of_6__E, e6: _of_6__E, eArray: _py_List[_of_6__E]) -> 'ImmutableMultiset'[_of_6__E]: ...
    @overload
    def remove(self, object: _py_Any) -> bool: ...
    @overload
    def remove(self, object: _py_Any, int: int) -> int: ...
    @overload
    def setCount(self, e: _ImmutableMultiset__E, int: int, int2: int) -> bool: ...
    @overload
    def setCount(self, e: _ImmutableMultiset__E, int: int) -> int: ...
    _toImmutableMultiset_0__E = _py_TypeVar('_toImmutableMultiset_0__E')  # <E>
    @classmethod
    @overload
    def toImmutableMultiset(cls) -> java.util.stream.Collector[_toImmutableMultiset_0__E, _py_Any, 'ImmutableMultiset'[_toImmutableMultiset_0__E]]: ...
    _toImmutableMultiset_1__T = _py_TypeVar('_toImmutableMultiset_1__T')  # <T>
    _toImmutableMultiset_1__E = _py_TypeVar('_toImmutableMultiset_1__E')  # <E>
    @classmethod
    @overload
    def toImmutableMultiset(cls, function: java.util.function.Function[_toImmutableMultiset_1__T, _toImmutableMultiset_1__E], toIntFunction: java.util.function.ToIntFunction[_toImmutableMultiset_1__T]) -> java.util.stream.Collector[_toImmutableMultiset_1__T, _py_Any, 'ImmutableMultiset'[_toImmutableMultiset_1__E]]: ...
    def toString(self) -> str: ...
    class Builder(ImmutableCollection.Builder[_ImmutableMultiset__Builder__E], _py_Generic[_ImmutableMultiset__Builder__E]):
        def __init__(self): ...
        @overload
        def add(self, object: _py_Any) -> ImmutableCollection.Builder: ...
        @overload
        def add(self, objectArray: _py_List[_py_Any]) -> ImmutableCollection.Builder: ...
        @overload
        def add(self, e: _ImmutableMultiset__Builder__E) -> 'ImmutableMultiset.Builder'[_ImmutableMultiset__Builder__E]: ...
        @overload
        def add(self, eArray: _py_List[_ImmutableMultiset__Builder__E]) -> 'ImmutableMultiset.Builder'[_ImmutableMultiset__Builder__E]: ...
        @overload
        def addAll(self, iterable: java.lang.Iterable) -> ImmutableCollection.Builder: ...
        @overload
        def addAll(self, iterator: java.util.Iterator) -> ImmutableCollection.Builder: ...
        @overload
        def addAll(self, iterable: java.lang.Iterable[_ImmutableMultiset__Builder__E]) -> 'ImmutableMultiset.Builder'[_ImmutableMultiset__Builder__E]: ...
        @overload
        def addAll(self, iterator: java.util.Iterator[_ImmutableMultiset__Builder__E]) -> 'ImmutableMultiset.Builder'[_ImmutableMultiset__Builder__E]: ...
        def addCopies(self, e: _ImmutableMultiset__Builder__E, int: int) -> 'ImmutableMultiset.Builder'[_ImmutableMultiset__Builder__E]: ...
        @overload
        def build(self) -> ImmutableCollection: ...
        @overload
        def build(self) -> 'ImmutableMultiset'[_ImmutableMultiset__Builder__E]: ...
        def setCount(self, e: _ImmutableMultiset__Builder__E, int: int) -> 'ImmutableMultiset.Builder'[_ImmutableMultiset__Builder__E]: ...

_ImmutableSet__Builder__E = _py_TypeVar('_ImmutableSet__Builder__E')  # <E>
_ImmutableSet__E = _py_TypeVar('_ImmutableSet__E')  # <E>
class ImmutableSet(ImmutableCollection[_ImmutableSet__E], java.util.Set[_ImmutableSet__E], _py_Generic[_ImmutableSet__E]):
    def asList(self) -> ImmutableList[_ImmutableSet__E]: ...
    _builder__E = _py_TypeVar('_builder__E')  # <E>
    @classmethod
    def builder(cls) -> 'ImmutableSet.Builder'[_builder__E]: ...
    _builderWithExpectedSize__E = _py_TypeVar('_builderWithExpectedSize__E')  # <E>
    @classmethod
    def builderWithExpectedSize(cls, int: int) -> 'ImmutableSet.Builder'[_builderWithExpectedSize__E]: ...
    _copyOf_0__E = _py_TypeVar('_copyOf_0__E')  # <E>
    @classmethod
    @overload
    def copyOf(cls, iterable: java.lang.Iterable[_copyOf_0__E]) -> 'ImmutableSet'[_copyOf_0__E]: ...
    _copyOf_1__E = _py_TypeVar('_copyOf_1__E')  # <E>
    @classmethod
    @overload
    def copyOf(cls, eArray: _py_List[_copyOf_1__E]) -> 'ImmutableSet'[_copyOf_1__E]: ...
    _copyOf_2__E = _py_TypeVar('_copyOf_2__E')  # <E>
    @classmethod
    @overload
    def copyOf(cls, collection: java.util.Collection[_copyOf_2__E]) -> 'ImmutableSet'[_copyOf_2__E]: ...
    _copyOf_3__E = _py_TypeVar('_copyOf_3__E')  # <E>
    @classmethod
    @overload
    def copyOf(cls, iterator: java.util.Iterator[_copyOf_3__E]) -> 'ImmutableSet'[_copyOf_3__E]: ...
    def equals(self, object: _py_Any) -> bool: ...
    def hashCode(self) -> int: ...
    @overload
    def iterator(self) -> UnmodifiableIterator[_ImmutableSet__E]: ...
    @overload
    def iterator(self) -> java.util.Iterator: ...
    _of_0__E = _py_TypeVar('_of_0__E')  # <E>
    @classmethod
    @overload
    def of(cls) -> 'ImmutableSet'[_of_0__E]: ...
    _of_1__E = _py_TypeVar('_of_1__E')  # <E>
    @classmethod
    @overload
    def of(cls, e: _of_1__E) -> 'ImmutableSet'[_of_1__E]: ...
    _of_2__E = _py_TypeVar('_of_2__E')  # <E>
    @classmethod
    @overload
    def of(cls, e: _of_2__E, e2: _of_2__E) -> 'ImmutableSet'[_of_2__E]: ...
    _of_3__E = _py_TypeVar('_of_3__E')  # <E>
    @classmethod
    @overload
    def of(cls, e: _of_3__E, e2: _of_3__E, e3: _of_3__E) -> 'ImmutableSet'[_of_3__E]: ...
    _of_4__E = _py_TypeVar('_of_4__E')  # <E>
    @classmethod
    @overload
    def of(cls, e: _of_4__E, e2: _of_4__E, e3: _of_4__E, e4: _of_4__E) -> 'ImmutableSet'[_of_4__E]: ...
    _of_5__E = _py_TypeVar('_of_5__E')  # <E>
    @classmethod
    @overload
    def of(cls, e: _of_5__E, e2: _of_5__E, e3: _of_5__E, e4: _of_5__E, e5: _of_5__E) -> 'ImmutableSet'[_of_5__E]: ...
    _of_6__E = _py_TypeVar('_of_6__E')  # <E>
    @classmethod
    @overload
    def of(cls, e: _of_6__E, e2: _of_6__E, e3: _of_6__E, e4: _of_6__E, e5: _of_6__E, e6: _of_6__E, eArray: _py_List[_of_6__E]) -> 'ImmutableSet'[_of_6__E]: ...
    _toImmutableSet__E = _py_TypeVar('_toImmutableSet__E')  # <E>
    @classmethod
    def toImmutableSet(cls) -> java.util.stream.Collector[_toImmutableSet__E, _py_Any, 'ImmutableSet'[_toImmutableSet__E]]: ...
    class Builder(ImmutableCollection.Builder[_ImmutableSet__Builder__E], _py_Generic[_ImmutableSet__Builder__E]):
        def __init__(self): ...
        @overload
        def add(self, object: _py_Any) -> ImmutableCollection.Builder: ...
        @overload
        def add(self, objectArray: _py_List[_py_Any]) -> ImmutableCollection.Builder: ...
        @overload
        def add(self, e: _ImmutableSet__Builder__E) -> 'ImmutableSet.Builder'[_ImmutableSet__Builder__E]: ...
        @overload
        def add(self, eArray: _py_List[_ImmutableSet__Builder__E]) -> 'ImmutableSet.Builder'[_ImmutableSet__Builder__E]: ...
        @overload
        def addAll(self, iterable: java.lang.Iterable) -> ImmutableCollection.Builder: ...
        @overload
        def addAll(self, iterator: java.util.Iterator) -> ImmutableCollection.Builder: ...
        @overload
        def addAll(self, iterable: java.lang.Iterable[_ImmutableSet__Builder__E]) -> 'ImmutableSet.Builder'[_ImmutableSet__Builder__E]: ...
        @overload
        def addAll(self, iterator: java.util.Iterator[_ImmutableSet__Builder__E]) -> 'ImmutableSet.Builder'[_ImmutableSet__Builder__E]: ...
        @overload
        def build(self) -> ImmutableCollection: ...
        @overload
        def build(self) -> 'ImmutableSet'[_ImmutableSet__Builder__E]: ...

_ImmutableSetMultimap__Builder__K = _py_TypeVar('_ImmutableSetMultimap__Builder__K')  # <K>
_ImmutableSetMultimap__Builder__V = _py_TypeVar('_ImmutableSetMultimap__Builder__V')  # <V>
_ImmutableSetMultimap__K = _py_TypeVar('_ImmutableSetMultimap__K')  # <K>
_ImmutableSetMultimap__V = _py_TypeVar('_ImmutableSetMultimap__V')  # <V>
class ImmutableSetMultimap(ImmutableMultimap[_ImmutableSetMultimap__K, _ImmutableSetMultimap__V], SetMultimap[_ImmutableSetMultimap__K, _ImmutableSetMultimap__V], _py_Generic[_ImmutableSetMultimap__K, _ImmutableSetMultimap__V]):
    _builder_0__K = _py_TypeVar('_builder_0__K')  # <K>
    _builder_0__V = _py_TypeVar('_builder_0__V')  # <V>
    @classmethod
    @overload
    def builder(cls) -> ImmutableMultimap.Builder[_builder_0__K, _builder_0__V]: ...
    _builder_1__K = _py_TypeVar('_builder_1__K')  # <K>
    _builder_1__V = _py_TypeVar('_builder_1__V')  # <V>
    @classmethod
    @overload
    def builder(cls) -> 'ImmutableSetMultimap.Builder'[_builder_1__K, _builder_1__V]: ...
    _copyOf_0__K = _py_TypeVar('_copyOf_0__K')  # <K>
    _copyOf_0__V = _py_TypeVar('_copyOf_0__V')  # <V>
    @classmethod
    @overload
    def copyOf(cls, multimap: Multimap[_copyOf_0__K, _copyOf_0__V]) -> ImmutableMultimap[_copyOf_0__K, _copyOf_0__V]: ...
    _copyOf_1__K = _py_TypeVar('_copyOf_1__K')  # <K>
    _copyOf_1__V = _py_TypeVar('_copyOf_1__V')  # <V>
    @classmethod
    @overload
    def copyOf(cls, iterable: java.lang.Iterable[java.util.Map.Entry[_copyOf_1__K, _copyOf_1__V]]) -> ImmutableMultimap[_copyOf_1__K, _copyOf_1__V]: ...
    _copyOf_2__K = _py_TypeVar('_copyOf_2__K')  # <K>
    _copyOf_2__V = _py_TypeVar('_copyOf_2__V')  # <V>
    @classmethod
    @overload
    def copyOf(cls, multimap: Multimap[_copyOf_2__K, _copyOf_2__V]) -> 'ImmutableSetMultimap'[_copyOf_2__K, _copyOf_2__V]: ...
    _copyOf_3__K = _py_TypeVar('_copyOf_3__K')  # <K>
    _copyOf_3__V = _py_TypeVar('_copyOf_3__V')  # <V>
    @classmethod
    @overload
    def copyOf(cls, iterable: java.lang.Iterable[java.util.Map.Entry[_copyOf_3__K, _copyOf_3__V]]) -> 'ImmutableSetMultimap'[_copyOf_3__K, _copyOf_3__V]: ...
    @overload
    def entries(self) -> ImmutableCollection: ...
    @overload
    def entries(self) -> ImmutableSet[java.util.Map.Entry[_ImmutableSetMultimap__K, _ImmutableSetMultimap__V]]: ...
    @overload
    def entries(self) -> java.util.Collection: ...
    @overload
    def entries(self) -> java.util.Set: ...
    _flatteningToImmutableSetMultimap__T = _py_TypeVar('_flatteningToImmutableSetMultimap__T')  # <T>
    _flatteningToImmutableSetMultimap__K = _py_TypeVar('_flatteningToImmutableSetMultimap__K')  # <K>
    _flatteningToImmutableSetMultimap__V = _py_TypeVar('_flatteningToImmutableSetMultimap__V')  # <V>
    @classmethod
    def flatteningToImmutableSetMultimap(cls, function: java.util.function.Function[_flatteningToImmutableSetMultimap__T, _flatteningToImmutableSetMultimap__K], function2: java.util.function.Function[_flatteningToImmutableSetMultimap__T, java.util.stream.Stream[_flatteningToImmutableSetMultimap__V]]) -> java.util.stream.Collector[_flatteningToImmutableSetMultimap__T, _py_Any, 'ImmutableSetMultimap'[_flatteningToImmutableSetMultimap__K, _flatteningToImmutableSetMultimap__V]]: ...
    @overload
    def get(self, object: _py_Any) -> ImmutableCollection: ...
    @overload
    def get(self, k: _ImmutableSetMultimap__K) -> ImmutableSet[_ImmutableSetMultimap__V]: ...
    @overload
    def get(self, object: _py_Any) -> java.util.Collection: ...
    @overload
    def get(self, object: _py_Any) -> java.util.Set: ...
    @overload
    def inverse(self) -> ImmutableMultimap: ...
    @overload
    def inverse(self) -> 'ImmutableSetMultimap'[_ImmutableSetMultimap__V, _ImmutableSetMultimap__K]: ...
    _of_0__K = _py_TypeVar('_of_0__K')  # <K>
    _of_0__V = _py_TypeVar('_of_0__V')  # <V>
    @classmethod
    @overload
    def of(cls) -> ImmutableMultimap[_of_0__K, _of_0__V]: ...
    _of_1__K = _py_TypeVar('_of_1__K')  # <K>
    _of_1__V = _py_TypeVar('_of_1__V')  # <V>
    @classmethod
    @overload
    def of(cls, k: _of_1__K, v: _of_1__V) -> ImmutableMultimap[_of_1__K, _of_1__V]: ...
    _of_2__K = _py_TypeVar('_of_2__K')  # <K>
    _of_2__V = _py_TypeVar('_of_2__V')  # <V>
    @classmethod
    @overload
    def of(cls, k: _of_2__K, v: _of_2__V, k2: _of_2__K, v2: _of_2__V) -> ImmutableMultimap[_of_2__K, _of_2__V]: ...
    _of_3__K = _py_TypeVar('_of_3__K')  # <K>
    _of_3__V = _py_TypeVar('_of_3__V')  # <V>
    @classmethod
    @overload
    def of(cls, k: _of_3__K, v: _of_3__V, k2: _of_3__K, v2: _of_3__V, k3: _of_3__K, v3: _of_3__V) -> ImmutableMultimap[_of_3__K, _of_3__V]: ...
    _of_4__K = _py_TypeVar('_of_4__K')  # <K>
    _of_4__V = _py_TypeVar('_of_4__V')  # <V>
    @classmethod
    @overload
    def of(cls, k: _of_4__K, v: _of_4__V, k2: _of_4__K, v2: _of_4__V, k3: _of_4__K, v3: _of_4__V, k4: _of_4__K, v4: _of_4__V) -> ImmutableMultimap[_of_4__K, _of_4__V]: ...
    _of_5__K = _py_TypeVar('_of_5__K')  # <K>
    _of_5__V = _py_TypeVar('_of_5__V')  # <V>
    @classmethod
    @overload
    def of(cls, k: _of_5__K, v: _of_5__V, k2: _of_5__K, v2: _of_5__V, k3: _of_5__K, v3: _of_5__V, k4: _of_5__K, v4: _of_5__V, k5: _of_5__K, v5: _of_5__V) -> ImmutableMultimap[_of_5__K, _of_5__V]: ...
    _of_6__K = _py_TypeVar('_of_6__K')  # <K>
    _of_6__V = _py_TypeVar('_of_6__V')  # <V>
    @classmethod
    @overload
    def of(cls) -> 'ImmutableSetMultimap'[_of_6__K, _of_6__V]: ...
    _of_7__K = _py_TypeVar('_of_7__K')  # <K>
    _of_7__V = _py_TypeVar('_of_7__V')  # <V>
    @classmethod
    @overload
    def of(cls, k: _of_7__K, v: _of_7__V) -> 'ImmutableSetMultimap'[_of_7__K, _of_7__V]: ...
    _of_8__K = _py_TypeVar('_of_8__K')  # <K>
    _of_8__V = _py_TypeVar('_of_8__V')  # <V>
    @classmethod
    @overload
    def of(cls, k: _of_8__K, v: _of_8__V, k2: _of_8__K, v2: _of_8__V) -> 'ImmutableSetMultimap'[_of_8__K, _of_8__V]: ...
    _of_9__K = _py_TypeVar('_of_9__K')  # <K>
    _of_9__V = _py_TypeVar('_of_9__V')  # <V>
    @classmethod
    @overload
    def of(cls, k: _of_9__K, v: _of_9__V, k2: _of_9__K, v2: _of_9__V, k3: _of_9__K, v3: _of_9__V) -> 'ImmutableSetMultimap'[_of_9__K, _of_9__V]: ...
    _of_10__K = _py_TypeVar('_of_10__K')  # <K>
    _of_10__V = _py_TypeVar('_of_10__V')  # <V>
    @classmethod
    @overload
    def of(cls, k: _of_10__K, v: _of_10__V, k2: _of_10__K, v2: _of_10__V, k3: _of_10__K, v3: _of_10__V, k4: _of_10__K, v4: _of_10__V) -> 'ImmutableSetMultimap'[_of_10__K, _of_10__V]: ...
    _of_11__K = _py_TypeVar('_of_11__K')  # <K>
    _of_11__V = _py_TypeVar('_of_11__V')  # <V>
    @classmethod
    @overload
    def of(cls, k: _of_11__K, v: _of_11__V, k2: _of_11__K, v2: _of_11__V, k3: _of_11__K, v3: _of_11__V, k4: _of_11__K, v4: _of_11__V, k5: _of_11__K, v5: _of_11__V) -> 'ImmutableSetMultimap'[_of_11__K, _of_11__V]: ...
    @overload
    def removeAll(self, object: _py_Any) -> ImmutableCollection: ...
    @overload
    def removeAll(self, object: _py_Any) -> ImmutableSet[_ImmutableSetMultimap__V]: ...
    @overload
    def removeAll(self, object: _py_Any) -> java.util.Collection: ...
    @overload
    def removeAll(self, object: _py_Any) -> java.util.Set: ...
    @overload
    def replaceValues(self, object: _py_Any, iterable: java.lang.Iterable) -> ImmutableCollection: ...
    @overload
    def replaceValues(self, k: _ImmutableSetMultimap__K, iterable: java.lang.Iterable[_ImmutableSetMultimap__V]) -> ImmutableSet[_ImmutableSetMultimap__V]: ...
    @overload
    def replaceValues(self, object: _py_Any, iterable: java.lang.Iterable) -> java.util.Collection: ...
    @overload
    def replaceValues(self, object: _py_Any, iterable: java.lang.Iterable) -> java.util.Set: ...
    _toImmutableSetMultimap__T = _py_TypeVar('_toImmutableSetMultimap__T')  # <T>
    _toImmutableSetMultimap__K = _py_TypeVar('_toImmutableSetMultimap__K')  # <K>
    _toImmutableSetMultimap__V = _py_TypeVar('_toImmutableSetMultimap__V')  # <V>
    @classmethod
    def toImmutableSetMultimap(cls, function: java.util.function.Function[_toImmutableSetMultimap__T, _toImmutableSetMultimap__K], function2: java.util.function.Function[_toImmutableSetMultimap__T, _toImmutableSetMultimap__V]) -> java.util.stream.Collector[_toImmutableSetMultimap__T, _py_Any, 'ImmutableSetMultimap'[_toImmutableSetMultimap__K, _toImmutableSetMultimap__V]]: ...
    class Builder(ImmutableMultimap.Builder[_ImmutableSetMultimap__Builder__K, _ImmutableSetMultimap__Builder__V], _py_Generic[_ImmutableSetMultimap__Builder__K, _ImmutableSetMultimap__Builder__V]):
        def __init__(self): ...
        @overload
        def build(self) -> ImmutableMultimap: ...
        @overload
        def build(self) -> 'ImmutableSetMultimap'[_ImmutableSetMultimap__Builder__K, _ImmutableSetMultimap__Builder__V]: ...
        @overload
        def orderKeysBy(self, comparator: java.util.Comparator) -> ImmutableMultimap.Builder: ...
        @overload
        def orderKeysBy(self, comparator: java.util.Comparator[_ImmutableSetMultimap__Builder__K]) -> 'ImmutableSetMultimap.Builder'[_ImmutableSetMultimap__Builder__K, _ImmutableSetMultimap__Builder__V]: ...
        @overload
        def orderValuesBy(self, comparator: java.util.Comparator) -> ImmutableMultimap.Builder: ...
        @overload
        def orderValuesBy(self, comparator: java.util.Comparator[_ImmutableSetMultimap__Builder__V]) -> 'ImmutableSetMultimap.Builder'[_ImmutableSetMultimap__Builder__K, _ImmutableSetMultimap__Builder__V]: ...
        @overload
        def put(self, object: _py_Any, object2: _py_Any) -> ImmutableMultimap.Builder: ...
        @overload
        def put(self, entry: java.util.Map.Entry) -> ImmutableMultimap.Builder: ...
        @overload
        def put(self, k: _ImmutableSetMultimap__Builder__K, v: _ImmutableSetMultimap__Builder__V) -> 'ImmutableSetMultimap.Builder'[_ImmutableSetMultimap__Builder__K, _ImmutableSetMultimap__Builder__V]: ...
        @overload
        def put(self, entry: java.util.Map.Entry[_ImmutableSetMultimap__Builder__K, _ImmutableSetMultimap__Builder__V]) -> 'ImmutableSetMultimap.Builder'[_ImmutableSetMultimap__Builder__K, _ImmutableSetMultimap__Builder__V]: ...
        @overload
        def putAll(self, multimap: Multimap) -> ImmutableMultimap.Builder: ...
        @overload
        def putAll(self, iterable: java.lang.Iterable) -> ImmutableMultimap.Builder: ...
        @overload
        def putAll(self, object: _py_Any, iterable: java.lang.Iterable) -> ImmutableMultimap.Builder: ...
        @overload
        def putAll(self, object: _py_Any, objectArray: _py_List[_py_Any]) -> ImmutableMultimap.Builder: ...
        @overload
        def putAll(self, multimap: Multimap[_ImmutableSetMultimap__Builder__K, _ImmutableSetMultimap__Builder__V]) -> 'ImmutableSetMultimap.Builder'[_ImmutableSetMultimap__Builder__K, _ImmutableSetMultimap__Builder__V]: ...
        @overload
        def putAll(self, iterable: java.lang.Iterable[java.util.Map.Entry[_ImmutableSetMultimap__Builder__K, _ImmutableSetMultimap__Builder__V]]) -> 'ImmutableSetMultimap.Builder'[_ImmutableSetMultimap__Builder__K, _ImmutableSetMultimap__Builder__V]: ...
        @overload
        def putAll(self, k: _ImmutableSetMultimap__Builder__K, iterable: java.lang.Iterable[_ImmutableSetMultimap__Builder__V]) -> 'ImmutableSetMultimap.Builder'[_ImmutableSetMultimap__Builder__K, _ImmutableSetMultimap__Builder__V]: ...
        @overload
        def putAll(self, k: _ImmutableSetMultimap__Builder__K, vArray: _py_List[_ImmutableSetMultimap__Builder__V]) -> 'ImmutableSetMultimap.Builder'[_ImmutableSetMultimap__Builder__K, _ImmutableSetMultimap__Builder__V]: ...

_ImmutableSortedAsList__E = _py_TypeVar('_ImmutableSortedAsList__E')  # <E>
class ImmutableSortedAsList(com.google.common.collect.RegularImmutableAsList[_ImmutableSortedAsList__E], SortedIterable[_ImmutableSortedAsList__E], _py_Generic[_ImmutableSortedAsList__E]):
    def comparator(self) -> java.util.Comparator[_ImmutableSortedAsList__E]: ...
    def contains(self, object: _py_Any) -> bool: ...
    def indexOf(self, object: _py_Any) -> int: ...
    def lastIndexOf(self, object: _py_Any) -> int: ...
    def spliterator(self) -> java.util.Spliterator[_ImmutableSortedAsList__E]: ...

_ImmutableSortedMap__Builder__K = _py_TypeVar('_ImmutableSortedMap__Builder__K')  # <K>
_ImmutableSortedMap__Builder__V = _py_TypeVar('_ImmutableSortedMap__Builder__V')  # <V>
_ImmutableSortedMap__K = _py_TypeVar('_ImmutableSortedMap__K')  # <K>
_ImmutableSortedMap__V = _py_TypeVar('_ImmutableSortedMap__V')  # <V>
class ImmutableSortedMap(ImmutableSortedMapFauxverideShim[_ImmutableSortedMap__K, _ImmutableSortedMap__V], java.util.NavigableMap[_ImmutableSortedMap__K, _ImmutableSortedMap__V], _py_Generic[_ImmutableSortedMap__K, _ImmutableSortedMap__V]):
    def ceilingEntry(self, k: _ImmutableSortedMap__K) -> java.util.Map.Entry[_ImmutableSortedMap__K, _ImmutableSortedMap__V]: ...
    def ceilingKey(self, k: _ImmutableSortedMap__K) -> _ImmutableSortedMap__K: ...
    def comparator(self) -> java.util.Comparator[_ImmutableSortedMap__K]: ...
    _copyOf_0__K = _py_TypeVar('_copyOf_0__K')  # <K>
    _copyOf_0__V = _py_TypeVar('_copyOf_0__V')  # <V>
    @classmethod
    @overload
    def copyOf(cls, iterable: java.lang.Iterable[java.util.Map.Entry[_copyOf_0__K, _copyOf_0__V]]) -> ImmutableMap[_copyOf_0__K, _copyOf_0__V]: ...
    _copyOf_1__K = _py_TypeVar('_copyOf_1__K')  # <K>
    _copyOf_1__V = _py_TypeVar('_copyOf_1__V')  # <V>
    @classmethod
    @overload
    def copyOf(cls, map: java.util.Map[_copyOf_1__K, _copyOf_1__V]) -> ImmutableMap[_copyOf_1__K, _copyOf_1__V]: ...
    _copyOf_2__K = _py_TypeVar('_copyOf_2__K')  # <K>
    _copyOf_2__V = _py_TypeVar('_copyOf_2__V')  # <V>
    @classmethod
    @overload
    def copyOf(cls, iterable: java.lang.Iterable[java.util.Map.Entry[_copyOf_2__K, _copyOf_2__V]]) -> 'ImmutableSortedMap'[_copyOf_2__K, _copyOf_2__V]: ...
    _copyOf_3__K = _py_TypeVar('_copyOf_3__K')  # <K>
    _copyOf_3__V = _py_TypeVar('_copyOf_3__V')  # <V>
    @classmethod
    @overload
    def copyOf(cls, iterable: java.lang.Iterable[java.util.Map.Entry[_copyOf_3__K, _copyOf_3__V]], comparator: java.util.Comparator[_copyOf_3__K]) -> 'ImmutableSortedMap'[_copyOf_3__K, _copyOf_3__V]: ...
    _copyOf_4__K = _py_TypeVar('_copyOf_4__K')  # <K>
    _copyOf_4__V = _py_TypeVar('_copyOf_4__V')  # <V>
    @classmethod
    @overload
    def copyOf(cls, map: java.util.Map[_copyOf_4__K, _copyOf_4__V]) -> 'ImmutableSortedMap'[_copyOf_4__K, _copyOf_4__V]: ...
    _copyOf_5__K = _py_TypeVar('_copyOf_5__K')  # <K>
    _copyOf_5__V = _py_TypeVar('_copyOf_5__V')  # <V>
    @classmethod
    @overload
    def copyOf(cls, map: java.util.Map[_copyOf_5__K, _copyOf_5__V], comparator: java.util.Comparator[_copyOf_5__K]) -> 'ImmutableSortedMap'[_copyOf_5__K, _copyOf_5__V]: ...
    _copyOfSorted__K = _py_TypeVar('_copyOfSorted__K')  # <K>
    _copyOfSorted__V = _py_TypeVar('_copyOfSorted__V')  # <V>
    @classmethod
    def copyOfSorted(cls, sortedMap: java.util.SortedMap[_copyOfSorted__K, _copyOfSorted__V]) -> 'ImmutableSortedMap'[_copyOfSorted__K, _copyOfSorted__V]: ...
    @overload
    def descendingKeySet(self) -> 'ImmutableSortedSet'[_ImmutableSortedMap__K]: ...
    @overload
    def descendingKeySet(self) -> java.util.NavigableSet: ...
    @overload
    def descendingMap(self) -> 'ImmutableSortedMap'[_ImmutableSortedMap__K, _ImmutableSortedMap__V]: ...
    @overload
    def descendingMap(self) -> java.util.NavigableMap: ...
    @overload
    def entrySet(self) -> ImmutableSet[java.util.Map.Entry[_ImmutableSortedMap__K, _ImmutableSortedMap__V]]: ...
    @overload
    def entrySet(self) -> java.util.Set: ...
    def firstEntry(self) -> java.util.Map.Entry[_ImmutableSortedMap__K, _ImmutableSortedMap__V]: ...
    def firstKey(self) -> _ImmutableSortedMap__K: ...
    def floorEntry(self, k: _ImmutableSortedMap__K) -> java.util.Map.Entry[_ImmutableSortedMap__K, _ImmutableSortedMap__V]: ...
    def floorKey(self, k: _ImmutableSortedMap__K) -> _ImmutableSortedMap__K: ...
    def forEach(self, biConsumer: java.util.function.BiConsumer[_ImmutableSortedMap__K, _ImmutableSortedMap__V]) -> None: ...
    def get(self, object: _py_Any) -> _ImmutableSortedMap__V: ...
    @overload
    def headMap(self, k: _ImmutableSortedMap__K) -> 'ImmutableSortedMap'[_ImmutableSortedMap__K, _ImmutableSortedMap__V]: ...
    @overload
    def headMap(self, k: _ImmutableSortedMap__K, boolean: bool) -> 'ImmutableSortedMap'[_ImmutableSortedMap__K, _ImmutableSortedMap__V]: ...
    @overload
    def headMap(self, object: _py_Any, boolean: bool) -> java.util.NavigableMap: ...
    @overload
    def headMap(self, object: _py_Any) -> java.util.SortedMap: ...
    def higherEntry(self, k: _ImmutableSortedMap__K) -> java.util.Map.Entry[_ImmutableSortedMap__K, _ImmutableSortedMap__V]: ...
    def higherKey(self, k: _ImmutableSortedMap__K) -> _ImmutableSortedMap__K: ...
    @overload
    def keySet(self) -> ImmutableSet: ...
    @overload
    def keySet(self) -> 'ImmutableSortedSet'[_ImmutableSortedMap__K]: ...
    @overload
    def keySet(self) -> java.util.Set: ...
    def lastEntry(self) -> java.util.Map.Entry[_ImmutableSortedMap__K, _ImmutableSortedMap__V]: ...
    def lastKey(self) -> _ImmutableSortedMap__K: ...
    def lowerEntry(self, k: _ImmutableSortedMap__K) -> java.util.Map.Entry[_ImmutableSortedMap__K, _ImmutableSortedMap__V]: ...
    def lowerKey(self, k: _ImmutableSortedMap__K) -> _ImmutableSortedMap__K: ...
    _naturalOrder__K = _py_TypeVar('_naturalOrder__K', bound=java.lang.Comparable)  # <K>
    _naturalOrder__V = _py_TypeVar('_naturalOrder__V')  # <V>
    @classmethod
    def naturalOrder(cls) -> 'ImmutableSortedMap.Builder'[_naturalOrder__K, _naturalOrder__V]: ...
    @overload
    def navigableKeySet(self) -> 'ImmutableSortedSet'[_ImmutableSortedMap__K]: ...
    @overload
    def navigableKeySet(self) -> java.util.NavigableSet: ...
    _of_0__K = _py_TypeVar('_of_0__K')  # <K>
    _of_0__V = _py_TypeVar('_of_0__V')  # <V>
    @classmethod
    @overload
    def of(cls) -> ImmutableMap[_of_0__K, _of_0__V]: ...
    _of_1__K = _py_TypeVar('_of_1__K')  # <K>
    _of_1__V = _py_TypeVar('_of_1__V')  # <V>
    @classmethod
    @overload
    def of(cls, k: _of_1__K, v: _of_1__V) -> ImmutableMap[_of_1__K, _of_1__V]: ...
    _of_2__K = _py_TypeVar('_of_2__K')  # <K>
    _of_2__V = _py_TypeVar('_of_2__V')  # <V>
    @classmethod
    @overload
    def of(cls, k: _of_2__K, v: _of_2__V, k2: _of_2__K, v2: _of_2__V) -> ImmutableMap[_of_2__K, _of_2__V]: ...
    _of_3__K = _py_TypeVar('_of_3__K')  # <K>
    _of_3__V = _py_TypeVar('_of_3__V')  # <V>
    @classmethod
    @overload
    def of(cls, k: _of_3__K, v: _of_3__V, k2: _of_3__K, v2: _of_3__V, k3: _of_3__K, v3: _of_3__V) -> ImmutableMap[_of_3__K, _of_3__V]: ...
    _of_4__K = _py_TypeVar('_of_4__K')  # <K>
    _of_4__V = _py_TypeVar('_of_4__V')  # <V>
    @classmethod
    @overload
    def of(cls, k: _of_4__K, v: _of_4__V, k2: _of_4__K, v2: _of_4__V, k3: _of_4__K, v3: _of_4__V, k4: _of_4__K, v4: _of_4__V) -> ImmutableMap[_of_4__K, _of_4__V]: ...
    _of_5__K = _py_TypeVar('_of_5__K')  # <K>
    _of_5__V = _py_TypeVar('_of_5__V')  # <V>
    @classmethod
    @overload
    def of(cls, k: _of_5__K, v: _of_5__V, k2: _of_5__K, v2: _of_5__V, k3: _of_5__K, v3: _of_5__V, k4: _of_5__K, v4: _of_5__V, k5: _of_5__K, v5: _of_5__V) -> ImmutableMap[_of_5__K, _of_5__V]: ...
    _of_6__K = _py_TypeVar('_of_6__K')  # <K>
    _of_6__V = _py_TypeVar('_of_6__V')  # <V>
    @classmethod
    @overload
    def of(cls) -> 'ImmutableSortedMap'[_of_6__K, _of_6__V]: ...
    _of_7__K = _py_TypeVar('_of_7__K', bound=java.lang.Comparable)  # <K>
    _of_7__V = _py_TypeVar('_of_7__V')  # <V>
    @classmethod
    @overload
    def of(cls, k: _of_7__K, v: _of_7__V) -> 'ImmutableSortedMap'[_of_7__K, _of_7__V]: ...
    _of_8__K = _py_TypeVar('_of_8__K', bound=java.lang.Comparable)  # <K>
    _of_8__V = _py_TypeVar('_of_8__V')  # <V>
    @classmethod
    @overload
    def of(cls, k: _of_8__K, v: _of_8__V, k2: _of_8__K, v2: _of_8__V) -> 'ImmutableSortedMap'[_of_8__K, _of_8__V]: ...
    _of_9__K = _py_TypeVar('_of_9__K', bound=java.lang.Comparable)  # <K>
    _of_9__V = _py_TypeVar('_of_9__V')  # <V>
    @classmethod
    @overload
    def of(cls, k: _of_9__K, v: _of_9__V, k2: _of_9__K, v2: _of_9__V, k3: _of_9__K, v3: _of_9__V) -> 'ImmutableSortedMap'[_of_9__K, _of_9__V]: ...
    _of_10__K = _py_TypeVar('_of_10__K', bound=java.lang.Comparable)  # <K>
    _of_10__V = _py_TypeVar('_of_10__V')  # <V>
    @classmethod
    @overload
    def of(cls, k: _of_10__K, v: _of_10__V, k2: _of_10__K, v2: _of_10__V, k3: _of_10__K, v3: _of_10__V, k4: _of_10__K, v4: _of_10__V) -> 'ImmutableSortedMap'[_of_10__K, _of_10__V]: ...
    _of_11__K = _py_TypeVar('_of_11__K', bound=java.lang.Comparable)  # <K>
    _of_11__V = _py_TypeVar('_of_11__V')  # <V>
    @classmethod
    @overload
    def of(cls, k: _of_11__K, v: _of_11__V, k2: _of_11__K, v2: _of_11__V, k3: _of_11__K, v3: _of_11__V, k4: _of_11__K, v4: _of_11__V, k5: _of_11__K, v5: _of_11__V) -> 'ImmutableSortedMap'[_of_11__K, _of_11__V]: ...
    _of_12__K = _py_TypeVar('_of_12__K')  # <K>
    _of_12__V = _py_TypeVar('_of_12__V')  # <V>
    @classmethod
    @overload
    def of(cls, k: _of_12__K, v: _of_12__V) -> 'ImmutableSortedMap'[_of_12__K, _of_12__V]: ...
    _of_13__K = _py_TypeVar('_of_13__K')  # <K>
    _of_13__V = _py_TypeVar('_of_13__V')  # <V>
    @classmethod
    @overload
    def of(cls, k: _of_13__K, v: _of_13__V, k2: _of_13__K, v2: _of_13__V) -> 'ImmutableSortedMap'[_of_13__K, _of_13__V]: ...
    _of_14__K = _py_TypeVar('_of_14__K')  # <K>
    _of_14__V = _py_TypeVar('_of_14__V')  # <V>
    @classmethod
    @overload
    def of(cls, k: _of_14__K, v: _of_14__V, k2: _of_14__K, v2: _of_14__V, k3: _of_14__K, v3: _of_14__V) -> 'ImmutableSortedMap'[_of_14__K, _of_14__V]: ...
    _of_15__K = _py_TypeVar('_of_15__K')  # <K>
    _of_15__V = _py_TypeVar('_of_15__V')  # <V>
    @classmethod
    @overload
    def of(cls, k: _of_15__K, v: _of_15__V, k2: _of_15__K, v2: _of_15__V, k3: _of_15__K, v3: _of_15__V, k4: _of_15__K, v4: _of_15__V) -> 'ImmutableSortedMap'[_of_15__K, _of_15__V]: ...
    _of_16__K = _py_TypeVar('_of_16__K')  # <K>
    _of_16__V = _py_TypeVar('_of_16__V')  # <V>
    @classmethod
    @overload
    def of(cls, k: _of_16__K, v: _of_16__V, k2: _of_16__K, v2: _of_16__V, k3: _of_16__K, v3: _of_16__V, k4: _of_16__K, v4: _of_16__V, k5: _of_16__K, v5: _of_16__V) -> 'ImmutableSortedMap'[_of_16__K, _of_16__V]: ...
    _orderedBy__K = _py_TypeVar('_orderedBy__K')  # <K>
    _orderedBy__V = _py_TypeVar('_orderedBy__V')  # <V>
    @classmethod
    def orderedBy(cls, comparator: java.util.Comparator[_orderedBy__K]) -> 'ImmutableSortedMap.Builder'[_orderedBy__K, _orderedBy__V]: ...
    def pollFirstEntry(self) -> java.util.Map.Entry[_ImmutableSortedMap__K, _ImmutableSortedMap__V]: ...
    def pollLastEntry(self) -> java.util.Map.Entry[_ImmutableSortedMap__K, _ImmutableSortedMap__V]: ...
    _reverseOrder__K = _py_TypeVar('_reverseOrder__K', bound=java.lang.Comparable)  # <K>
    _reverseOrder__V = _py_TypeVar('_reverseOrder__V')  # <V>
    @classmethod
    def reverseOrder(cls) -> 'ImmutableSortedMap.Builder'[_reverseOrder__K, _reverseOrder__V]: ...
    def size(self) -> int: ...
    @overload
    def subMap(self, k: _ImmutableSortedMap__K, boolean: bool, k2: _ImmutableSortedMap__K, boolean2: bool) -> 'ImmutableSortedMap'[_ImmutableSortedMap__K, _ImmutableSortedMap__V]: ...
    @overload
    def subMap(self, k: _ImmutableSortedMap__K, k2: _ImmutableSortedMap__K) -> 'ImmutableSortedMap'[_ImmutableSortedMap__K, _ImmutableSortedMap__V]: ...
    @overload
    def subMap(self, object: _py_Any, boolean: bool, object2: _py_Any, boolean2: bool) -> java.util.NavigableMap: ...
    @overload
    def subMap(self, object: _py_Any, object2: _py_Any) -> java.util.SortedMap: ...
    @overload
    def tailMap(self, k: _ImmutableSortedMap__K) -> 'ImmutableSortedMap'[_ImmutableSortedMap__K, _ImmutableSortedMap__V]: ...
    @overload
    def tailMap(self, k: _ImmutableSortedMap__K, boolean: bool) -> 'ImmutableSortedMap'[_ImmutableSortedMap__K, _ImmutableSortedMap__V]: ...
    @overload
    def tailMap(self, object: _py_Any, boolean: bool) -> java.util.NavigableMap: ...
    @overload
    def tailMap(self, object: _py_Any) -> java.util.SortedMap: ...
    _toImmutableSortedMap_0__T = _py_TypeVar('_toImmutableSortedMap_0__T')  # <T>
    _toImmutableSortedMap_0__K = _py_TypeVar('_toImmutableSortedMap_0__K')  # <K>
    _toImmutableSortedMap_0__V = _py_TypeVar('_toImmutableSortedMap_0__V')  # <V>
    @classmethod
    @overload
    def toImmutableSortedMap(cls, comparator: java.util.Comparator[_toImmutableSortedMap_0__K], function: java.util.function.Function[_toImmutableSortedMap_0__T, _toImmutableSortedMap_0__K], function2: java.util.function.Function[_toImmutableSortedMap_0__T, _toImmutableSortedMap_0__V]) -> java.util.stream.Collector[_toImmutableSortedMap_0__T, _py_Any, 'ImmutableSortedMap'[_toImmutableSortedMap_0__K, _toImmutableSortedMap_0__V]]: ...
    _toImmutableSortedMap_1__T = _py_TypeVar('_toImmutableSortedMap_1__T')  # <T>
    _toImmutableSortedMap_1__K = _py_TypeVar('_toImmutableSortedMap_1__K')  # <K>
    _toImmutableSortedMap_1__V = _py_TypeVar('_toImmutableSortedMap_1__V')  # <V>
    @classmethod
    @overload
    def toImmutableSortedMap(cls, comparator: java.util.Comparator[_toImmutableSortedMap_1__K], function: java.util.function.Function[_toImmutableSortedMap_1__T, _toImmutableSortedMap_1__K], function2: java.util.function.Function[_toImmutableSortedMap_1__T, _toImmutableSortedMap_1__V], binaryOperator: java.util.function.BinaryOperator[_toImmutableSortedMap_1__V]) -> java.util.stream.Collector[_toImmutableSortedMap_1__T, _py_Any, 'ImmutableSortedMap'[_toImmutableSortedMap_1__K, _toImmutableSortedMap_1__V]]: ...
    @overload
    def values(self) -> ImmutableCollection[_ImmutableSortedMap__V]: ...
    @overload
    def values(self) -> java.util.Collection: ...
    class Builder(ImmutableMap.Builder[_ImmutableSortedMap__Builder__K, _ImmutableSortedMap__Builder__V], _py_Generic[_ImmutableSortedMap__Builder__K, _ImmutableSortedMap__Builder__V]):
        def __init__(self, comparator: java.util.Comparator[_ImmutableSortedMap__Builder__K]): ...
        @overload
        def build(self) -> ImmutableMap: ...
        @overload
        def build(self) -> 'ImmutableSortedMap'[_ImmutableSortedMap__Builder__K, _ImmutableSortedMap__Builder__V]: ...
        @overload
        def orderEntriesByValue(self, comparator: java.util.Comparator) -> ImmutableMap.Builder: ...
        @overload
        def orderEntriesByValue(self, comparator: java.util.Comparator[_ImmutableSortedMap__Builder__V]) -> 'ImmutableSortedMap.Builder'[_ImmutableSortedMap__Builder__K, _ImmutableSortedMap__Builder__V]: ...
        @overload
        def put(self, object: _py_Any, object2: _py_Any) -> ImmutableMap.Builder: ...
        @overload
        def put(self, entry: java.util.Map.Entry) -> ImmutableMap.Builder: ...
        @overload
        def put(self, k: _ImmutableSortedMap__Builder__K, v: _ImmutableSortedMap__Builder__V) -> 'ImmutableSortedMap.Builder'[_ImmutableSortedMap__Builder__K, _ImmutableSortedMap__Builder__V]: ...
        @overload
        def put(self, entry: java.util.Map.Entry[_ImmutableSortedMap__Builder__K, _ImmutableSortedMap__Builder__V]) -> 'ImmutableSortedMap.Builder'[_ImmutableSortedMap__Builder__K, _ImmutableSortedMap__Builder__V]: ...
        @overload
        def putAll(self, iterable: java.lang.Iterable) -> ImmutableMap.Builder: ...
        @overload
        def putAll(self, map: java.util.Map) -> ImmutableMap.Builder: ...
        @overload
        def putAll(self, iterable: java.lang.Iterable[java.util.Map.Entry[_ImmutableSortedMap__Builder__K, _ImmutableSortedMap__Builder__V]]) -> 'ImmutableSortedMap.Builder'[_ImmutableSortedMap__Builder__K, _ImmutableSortedMap__Builder__V]: ...
        @overload
        def putAll(self, map: java.util.Map[_ImmutableSortedMap__Builder__K, _ImmutableSortedMap__Builder__V]) -> 'ImmutableSortedMap.Builder'[_ImmutableSortedMap__Builder__K, _ImmutableSortedMap__Builder__V]: ...

_ImmutableSortedMultiset__Builder__E = _py_TypeVar('_ImmutableSortedMultiset__Builder__E')  # <E>
_ImmutableSortedMultiset__E = _py_TypeVar('_ImmutableSortedMultiset__E')  # <E>
class ImmutableSortedMultiset(com.google.common.collect.ImmutableSortedMultisetFauxverideShim[_ImmutableSortedMultiset__E], SortedMultiset[_ImmutableSortedMultiset__E], _py_Generic[_ImmutableSortedMultiset__E]):
    def comparator(self) -> java.util.Comparator[_ImmutableSortedMultiset__E]: ...
    _copyOf_0__E = _py_TypeVar('_copyOf_0__E')  # <E>
    @classmethod
    @overload
    def copyOf(cls, iterable: java.lang.Iterable[_copyOf_0__E]) -> ImmutableMultiset[_copyOf_0__E]: ...
    _copyOf_1__E = _py_TypeVar('_copyOf_1__E')  # <E>
    @classmethod
    @overload
    def copyOf(cls, eArray: _py_List[_copyOf_1__E]) -> ImmutableMultiset[_copyOf_1__E]: ...
    _copyOf_2__E = _py_TypeVar('_copyOf_2__E')  # <E>
    @classmethod
    @overload
    def copyOf(cls, iterator: java.util.Iterator[_copyOf_2__E]) -> ImmutableMultiset[_copyOf_2__E]: ...
    _copyOf_3__E = _py_TypeVar('_copyOf_3__E', bound=java.lang.Comparable)  # <E>
    @classmethod
    @overload
    def copyOf(cls, eArray: _py_List[_copyOf_3__E]) -> 'ImmutableSortedMultiset'[_copyOf_3__E]: ...
    _copyOf_4__E = _py_TypeVar('_copyOf_4__E')  # <E>
    @classmethod
    @overload
    def copyOf(cls, iterable: java.lang.Iterable[_copyOf_4__E]) -> 'ImmutableSortedMultiset'[_copyOf_4__E]: ...
    _copyOf_5__E = _py_TypeVar('_copyOf_5__E')  # <E>
    @classmethod
    @overload
    def copyOf(cls, comparator: java.util.Comparator[_copyOf_5__E], iterable: java.lang.Iterable[_copyOf_5__E]) -> 'ImmutableSortedMultiset'[_copyOf_5__E]: ...
    _copyOf_6__E = _py_TypeVar('_copyOf_6__E')  # <E>
    @classmethod
    @overload
    def copyOf(cls, comparator: java.util.Comparator[_copyOf_6__E], iterator: java.util.Iterator[_copyOf_6__E]) -> 'ImmutableSortedMultiset'[_copyOf_6__E]: ...
    _copyOf_7__E = _py_TypeVar('_copyOf_7__E')  # <E>
    @classmethod
    @overload
    def copyOf(cls, iterator: java.util.Iterator[_copyOf_7__E]) -> 'ImmutableSortedMultiset'[_copyOf_7__E]: ...
    _copyOf_8__E = _py_TypeVar('_copyOf_8__E')  # <E>
    @classmethod
    @overload
    def copyOf(cls, eArray: _py_List[_copyOf_8__E]) -> 'ImmutableSortedMultiset'[_copyOf_8__E]: ...
    _copyOfSorted__E = _py_TypeVar('_copyOfSorted__E')  # <E>
    @classmethod
    def copyOfSorted(cls, sortedMultiset: SortedMultiset[_copyOfSorted__E]) -> 'ImmutableSortedMultiset'[_copyOfSorted__E]: ...
    @overload
    def descendingMultiset(self) -> 'ImmutableSortedMultiset'[_ImmutableSortedMultiset__E]: ...
    @overload
    def descendingMultiset(self) -> SortedMultiset: ...
    @overload
    def elementSet(self) -> 'ImmutableSortedSet'[_ImmutableSortedMultiset__E]: ...
    @overload
    def elementSet(self) -> ImmutableSet: ...
    @overload
    def elementSet(self) -> java.util.NavigableSet: ...
    @overload
    def elementSet(self) -> java.util.Set: ...
    @overload
    def elementSet(self) -> java.util.SortedSet: ...
    @overload
    def headMultiset(self, e: _ImmutableSortedMultiset__E, boundType: BoundType) -> 'ImmutableSortedMultiset'[_ImmutableSortedMultiset__E]: ...
    @overload
    def headMultiset(self, object: _py_Any, boundType: BoundType) -> SortedMultiset: ...
    _naturalOrder__E = _py_TypeVar('_naturalOrder__E', bound=java.lang.Comparable)  # <E>
    @classmethod
    def naturalOrder(cls) -> 'ImmutableSortedMultiset.Builder'[_naturalOrder__E]: ...
    _of_0__E = _py_TypeVar('_of_0__E')  # <E>
    @classmethod
    @overload
    def of(cls) -> ImmutableMultiset[_of_0__E]: ...
    _of_1__E = _py_TypeVar('_of_1__E')  # <E>
    @classmethod
    @overload
    def of(cls, e: _of_1__E) -> ImmutableMultiset[_of_1__E]: ...
    _of_2__E = _py_TypeVar('_of_2__E')  # <E>
    @classmethod
    @overload
    def of(cls, e: _of_2__E, e2: _of_2__E) -> ImmutableMultiset[_of_2__E]: ...
    _of_3__E = _py_TypeVar('_of_3__E')  # <E>
    @classmethod
    @overload
    def of(cls, e: _of_3__E, e2: _of_3__E, e3: _of_3__E) -> ImmutableMultiset[_of_3__E]: ...
    _of_4__E = _py_TypeVar('_of_4__E')  # <E>
    @classmethod
    @overload
    def of(cls, e: _of_4__E, e2: _of_4__E, e3: _of_4__E, e4: _of_4__E) -> ImmutableMultiset[_of_4__E]: ...
    _of_5__E = _py_TypeVar('_of_5__E')  # <E>
    @classmethod
    @overload
    def of(cls, e: _of_5__E, e2: _of_5__E, e3: _of_5__E, e4: _of_5__E, e5: _of_5__E) -> ImmutableMultiset[_of_5__E]: ...
    _of_6__E = _py_TypeVar('_of_6__E')  # <E>
    @classmethod
    @overload
    def of(cls, e: _of_6__E, e2: _of_6__E, e3: _of_6__E, e4: _of_6__E, e5: _of_6__E, e6: _of_6__E, eArray: _py_List[_of_6__E]) -> ImmutableMultiset[_of_6__E]: ...
    _of_7__E = _py_TypeVar('_of_7__E')  # <E>
    @classmethod
    @overload
    def of(cls) -> 'ImmutableSortedMultiset'[_of_7__E]: ...
    _of_8__E = _py_TypeVar('_of_8__E', bound=java.lang.Comparable)  # <E>
    @classmethod
    @overload
    def of(cls, e: _of_8__E) -> 'ImmutableSortedMultiset'[_of_8__E]: ...
    _of_9__E = _py_TypeVar('_of_9__E', bound=java.lang.Comparable)  # <E>
    @classmethod
    @overload
    def of(cls, e: _of_9__E, e2: _of_9__E) -> 'ImmutableSortedMultiset'[_of_9__E]: ...
    _of_10__E = _py_TypeVar('_of_10__E', bound=java.lang.Comparable)  # <E>
    @classmethod
    @overload
    def of(cls, e: _of_10__E, e2: _of_10__E, e3: _of_10__E) -> 'ImmutableSortedMultiset'[_of_10__E]: ...
    _of_11__E = _py_TypeVar('_of_11__E', bound=java.lang.Comparable)  # <E>
    @classmethod
    @overload
    def of(cls, e: _of_11__E, e2: _of_11__E, e3: _of_11__E, e4: _of_11__E) -> 'ImmutableSortedMultiset'[_of_11__E]: ...
    _of_12__E = _py_TypeVar('_of_12__E', bound=java.lang.Comparable)  # <E>
    @classmethod
    @overload
    def of(cls, e: _of_12__E, e2: _of_12__E, e3: _of_12__E, e4: _of_12__E, e5: _of_12__E) -> 'ImmutableSortedMultiset'[_of_12__E]: ...
    _of_13__E = _py_TypeVar('_of_13__E', bound=java.lang.Comparable)  # <E>
    @classmethod
    @overload
    def of(cls, e: _of_13__E, e2: _of_13__E, e3: _of_13__E, e4: _of_13__E, e5: _of_13__E, e6: _of_13__E, eArray: _py_List[_of_13__E]) -> 'ImmutableSortedMultiset'[_of_13__E]: ...
    _of_14__E = _py_TypeVar('_of_14__E')  # <E>
    @classmethod
    @overload
    def of(cls, e: _of_14__E) -> 'ImmutableSortedMultiset'[_of_14__E]: ...
    _of_15__E = _py_TypeVar('_of_15__E')  # <E>
    @classmethod
    @overload
    def of(cls, e: _of_15__E, e2: _of_15__E) -> 'ImmutableSortedMultiset'[_of_15__E]: ...
    _of_16__E = _py_TypeVar('_of_16__E')  # <E>
    @classmethod
    @overload
    def of(cls, e: _of_16__E, e2: _of_16__E, e3: _of_16__E) -> 'ImmutableSortedMultiset'[_of_16__E]: ...
    _of_17__E = _py_TypeVar('_of_17__E')  # <E>
    @classmethod
    @overload
    def of(cls, e: _of_17__E, e2: _of_17__E, e3: _of_17__E, e4: _of_17__E) -> 'ImmutableSortedMultiset'[_of_17__E]: ...
    _of_18__E = _py_TypeVar('_of_18__E')  # <E>
    @classmethod
    @overload
    def of(cls, e: _of_18__E, e2: _of_18__E, e3: _of_18__E, e4: _of_18__E, e5: _of_18__E) -> 'ImmutableSortedMultiset'[_of_18__E]: ...
    _of_19__E = _py_TypeVar('_of_19__E')  # <E>
    @classmethod
    @overload
    def of(cls, e: _of_19__E, e2: _of_19__E, e3: _of_19__E, e4: _of_19__E, e5: _of_19__E, e6: _of_19__E, eArray: _py_List[_of_19__E]) -> 'ImmutableSortedMultiset'[_of_19__E]: ...
    _orderedBy__E = _py_TypeVar('_orderedBy__E')  # <E>
    @classmethod
    def orderedBy(cls, comparator: java.util.Comparator[_orderedBy__E]) -> 'ImmutableSortedMultiset.Builder'[_orderedBy__E]: ...
    def pollFirstEntry(self) -> Multiset.Entry[_ImmutableSortedMultiset__E]: ...
    def pollLastEntry(self) -> Multiset.Entry[_ImmutableSortedMultiset__E]: ...
    _reverseOrder__E = _py_TypeVar('_reverseOrder__E', bound=java.lang.Comparable)  # <E>
    @classmethod
    def reverseOrder(cls) -> 'ImmutableSortedMultiset.Builder'[_reverseOrder__E]: ...
    @overload
    def subMultiset(self, e: _ImmutableSortedMultiset__E, boundType: BoundType, e2: _ImmutableSortedMultiset__E, boundType2: BoundType) -> 'ImmutableSortedMultiset'[_ImmutableSortedMultiset__E]: ...
    @overload
    def subMultiset(self, object: _py_Any, boundType: BoundType, object2: _py_Any, boundType2: BoundType) -> SortedMultiset: ...
    @overload
    def tailMultiset(self, e: _ImmutableSortedMultiset__E, boundType: BoundType) -> 'ImmutableSortedMultiset'[_ImmutableSortedMultiset__E]: ...
    @overload
    def tailMultiset(self, object: _py_Any, boundType: BoundType) -> SortedMultiset: ...
    _toImmutableSortedMultiset_0__E = _py_TypeVar('_toImmutableSortedMultiset_0__E')  # <E>
    @classmethod
    @overload
    def toImmutableSortedMultiset(cls, comparator: java.util.Comparator[_toImmutableSortedMultiset_0__E]) -> java.util.stream.Collector[_toImmutableSortedMultiset_0__E, _py_Any, 'ImmutableSortedMultiset'[_toImmutableSortedMultiset_0__E]]: ...
    _toImmutableSortedMultiset_1__T = _py_TypeVar('_toImmutableSortedMultiset_1__T')  # <T>
    _toImmutableSortedMultiset_1__E = _py_TypeVar('_toImmutableSortedMultiset_1__E')  # <E>
    @classmethod
    @overload
    def toImmutableSortedMultiset(cls, comparator: java.util.Comparator[_toImmutableSortedMultiset_1__E], function: java.util.function.Function[_toImmutableSortedMultiset_1__T, _toImmutableSortedMultiset_1__E], toIntFunction: java.util.function.ToIntFunction[_toImmutableSortedMultiset_1__T]) -> java.util.stream.Collector[_toImmutableSortedMultiset_1__T, _py_Any, 'ImmutableSortedMultiset'[_toImmutableSortedMultiset_1__E]]: ...
    class Builder(ImmutableMultiset.Builder[_ImmutableSortedMultiset__Builder__E], _py_Generic[_ImmutableSortedMultiset__Builder__E]):
        def __init__(self, comparator: java.util.Comparator[_ImmutableSortedMultiset__Builder__E]): ...
        @overload
        def add(self, object: _py_Any) -> ImmutableCollection.Builder: ...
        @overload
        def add(self, objectArray: _py_List[_py_Any]) -> ImmutableCollection.Builder: ...
        @overload
        def add(self, object: _py_Any) -> ImmutableMultiset.Builder: ...
        @overload
        def add(self, objectArray: _py_List[_py_Any]) -> ImmutableMultiset.Builder: ...
        @overload
        def add(self, e: _ImmutableSortedMultiset__Builder__E) -> 'ImmutableSortedMultiset.Builder'[_ImmutableSortedMultiset__Builder__E]: ...
        @overload
        def add(self, eArray: _py_List[_ImmutableSortedMultiset__Builder__E]) -> 'ImmutableSortedMultiset.Builder'[_ImmutableSortedMultiset__Builder__E]: ...
        @overload
        def addAll(self, iterable: java.lang.Iterable) -> ImmutableCollection.Builder: ...
        @overload
        def addAll(self, iterator: java.util.Iterator) -> ImmutableCollection.Builder: ...
        @overload
        def addAll(self, iterable: java.lang.Iterable) -> ImmutableMultiset.Builder: ...
        @overload
        def addAll(self, iterator: java.util.Iterator) -> ImmutableMultiset.Builder: ...
        @overload
        def addAll(self, iterable: java.lang.Iterable[_ImmutableSortedMultiset__Builder__E]) -> 'ImmutableSortedMultiset.Builder'[_ImmutableSortedMultiset__Builder__E]: ...
        @overload
        def addAll(self, iterator: java.util.Iterator[_ImmutableSortedMultiset__Builder__E]) -> 'ImmutableSortedMultiset.Builder'[_ImmutableSortedMultiset__Builder__E]: ...
        @overload
        def addCopies(self, object: _py_Any, int: int) -> ImmutableMultiset.Builder: ...
        @overload
        def addCopies(self, e: _ImmutableSortedMultiset__Builder__E, int: int) -> 'ImmutableSortedMultiset.Builder'[_ImmutableSortedMultiset__Builder__E]: ...
        @overload
        def build(self) -> ImmutableCollection: ...
        @overload
        def build(self) -> ImmutableMultiset: ...
        @overload
        def build(self) -> 'ImmutableSortedMultiset'[_ImmutableSortedMultiset__Builder__E]: ...
        @overload
        def setCount(self, object: _py_Any, int: int) -> ImmutableMultiset.Builder: ...
        @overload
        def setCount(self, e: _ImmutableSortedMultiset__Builder__E, int: int) -> 'ImmutableSortedMultiset.Builder'[_ImmutableSortedMultiset__Builder__E]: ...

_ImmutableSortedMultisetFauxverideShim__E = _py_TypeVar('_ImmutableSortedMultisetFauxverideShim__E')  # <E>
class ImmutableSortedMultisetFauxverideShim(ImmutableMultiset[_ImmutableSortedMultisetFauxverideShim__E], _py_Generic[_ImmutableSortedMultisetFauxverideShim__E]):
    _builder_0__E = _py_TypeVar('_builder_0__E')  # <E>
    @classmethod
    @overload
    def builder(cls) -> ImmutableMultiset.Builder[_builder_0__E]: ...
    _builder_1__E = _py_TypeVar('_builder_1__E')  # <E>
    @classmethod
    @overload
    def builder(cls) -> ImmutableSortedMultiset.Builder[_builder_1__E]: ...
    _copyOf_0__E = _py_TypeVar('_copyOf_0__E')  # <E>
    @classmethod
    @overload
    def copyOf(cls, iterable: java.lang.Iterable[_copyOf_0__E]) -> ImmutableMultiset[_copyOf_0__E]: ...
    _copyOf_1__E = _py_TypeVar('_copyOf_1__E')  # <E>
    @classmethod
    @overload
    def copyOf(cls, eArray: _py_List[_copyOf_1__E]) -> ImmutableMultiset[_copyOf_1__E]: ...
    _copyOf_2__E = _py_TypeVar('_copyOf_2__E')  # <E>
    @classmethod
    @overload
    def copyOf(cls, iterator: java.util.Iterator[_copyOf_2__E]) -> ImmutableMultiset[_copyOf_2__E]: ...
    _copyOf_3__E = _py_TypeVar('_copyOf_3__E')  # <E>
    @classmethod
    @overload
    def copyOf(cls, eArray: _py_List[_copyOf_3__E]) -> ImmutableSortedMultiset[_copyOf_3__E]: ...
    _of_0__E = _py_TypeVar('_of_0__E')  # <E>
    @classmethod
    @overload
    def of(cls) -> ImmutableMultiset[_of_0__E]: ...
    _of_1__E = _py_TypeVar('_of_1__E')  # <E>
    @classmethod
    @overload
    def of(cls, e: _of_1__E) -> ImmutableMultiset[_of_1__E]: ...
    _of_2__E = _py_TypeVar('_of_2__E')  # <E>
    @classmethod
    @overload
    def of(cls, e: _of_2__E, e2: _of_2__E) -> ImmutableMultiset[_of_2__E]: ...
    _of_3__E = _py_TypeVar('_of_3__E')  # <E>
    @classmethod
    @overload
    def of(cls, e: _of_3__E, e2: _of_3__E, e3: _of_3__E) -> ImmutableMultiset[_of_3__E]: ...
    _of_4__E = _py_TypeVar('_of_4__E')  # <E>
    @classmethod
    @overload
    def of(cls, e: _of_4__E, e2: _of_4__E, e3: _of_4__E, e4: _of_4__E) -> ImmutableMultiset[_of_4__E]: ...
    _of_5__E = _py_TypeVar('_of_5__E')  # <E>
    @classmethod
    @overload
    def of(cls, e: _of_5__E, e2: _of_5__E, e3: _of_5__E, e4: _of_5__E, e5: _of_5__E) -> ImmutableMultiset[_of_5__E]: ...
    _of_6__E = _py_TypeVar('_of_6__E')  # <E>
    @classmethod
    @overload
    def of(cls, e: _of_6__E, e2: _of_6__E, e3: _of_6__E, e4: _of_6__E, e5: _of_6__E, e6: _of_6__E, eArray: _py_List[_of_6__E]) -> ImmutableMultiset[_of_6__E]: ...
    _of_7__E = _py_TypeVar('_of_7__E')  # <E>
    @classmethod
    @overload
    def of(cls, e: _of_7__E) -> ImmutableSortedMultiset[_of_7__E]: ...
    _of_8__E = _py_TypeVar('_of_8__E')  # <E>
    @classmethod
    @overload
    def of(cls, e: _of_8__E, e2: _of_8__E) -> ImmutableSortedMultiset[_of_8__E]: ...
    _of_9__E = _py_TypeVar('_of_9__E')  # <E>
    @classmethod
    @overload
    def of(cls, e: _of_9__E, e2: _of_9__E, e3: _of_9__E) -> ImmutableSortedMultiset[_of_9__E]: ...
    _of_10__E = _py_TypeVar('_of_10__E')  # <E>
    @classmethod
    @overload
    def of(cls, e: _of_10__E, e2: _of_10__E, e3: _of_10__E, e4: _of_10__E) -> ImmutableSortedMultiset[_of_10__E]: ...
    _of_11__E = _py_TypeVar('_of_11__E')  # <E>
    @classmethod
    @overload
    def of(cls, e: _of_11__E, e2: _of_11__E, e3: _of_11__E, e4: _of_11__E, e5: _of_11__E) -> ImmutableSortedMultiset[_of_11__E]: ...
    _of_12__E = _py_TypeVar('_of_12__E')  # <E>
    @classmethod
    @overload
    def of(cls, e: _of_12__E, e2: _of_12__E, e3: _of_12__E, e4: _of_12__E, e5: _of_12__E, e6: _of_12__E, eArray: _py_List[_of_12__E]) -> ImmutableSortedMultiset[_of_12__E]: ...
    _toImmutableMultiset_0__E = _py_TypeVar('_toImmutableMultiset_0__E')  # <E>
    @classmethod
    @overload
    def toImmutableMultiset(cls) -> java.util.stream.Collector[_toImmutableMultiset_0__E, _py_Any, ImmutableMultiset[_toImmutableMultiset_0__E]]: ...
    _toImmutableMultiset_1__T = _py_TypeVar('_toImmutableMultiset_1__T')  # <T>
    _toImmutableMultiset_1__E = _py_TypeVar('_toImmutableMultiset_1__E')  # <E>
    @classmethod
    @overload
    def toImmutableMultiset(cls, function: java.util.function.Function[_toImmutableMultiset_1__T, _toImmutableMultiset_1__E], toIntFunction: java.util.function.ToIntFunction[_toImmutableMultiset_1__T]) -> java.util.stream.Collector[_toImmutableMultiset_1__T, _py_Any, ImmutableMultiset[_toImmutableMultiset_1__E]]: ...

_ImmutableSortedSet__Builder__E = _py_TypeVar('_ImmutableSortedSet__Builder__E')  # <E>
_ImmutableSortedSet__E = _py_TypeVar('_ImmutableSortedSet__E')  # <E>
class ImmutableSortedSet(com.google.common.collect.ImmutableSortedSetFauxverideShim[_ImmutableSortedSet__E], java.util.NavigableSet[_ImmutableSortedSet__E], SortedIterable[_ImmutableSortedSet__E], _py_Generic[_ImmutableSortedSet__E]):
    def ceiling(self, e: _ImmutableSortedSet__E) -> _ImmutableSortedSet__E: ...
    def comparator(self) -> java.util.Comparator[_ImmutableSortedSet__E]: ...
    _copyOf_0__E = _py_TypeVar('_copyOf_0__E')  # <E>
    @classmethod
    @overload
    def copyOf(cls, iterable: java.lang.Iterable[_copyOf_0__E]) -> ImmutableSet[_copyOf_0__E]: ...
    _copyOf_1__E = _py_TypeVar('_copyOf_1__E')  # <E>
    @classmethod
    @overload
    def copyOf(cls, eArray: _py_List[_copyOf_1__E]) -> ImmutableSet[_copyOf_1__E]: ...
    _copyOf_2__E = _py_TypeVar('_copyOf_2__E')  # <E>
    @classmethod
    @overload
    def copyOf(cls, collection: java.util.Collection[_copyOf_2__E]) -> ImmutableSet[_copyOf_2__E]: ...
    _copyOf_3__E = _py_TypeVar('_copyOf_3__E')  # <E>
    @classmethod
    @overload
    def copyOf(cls, iterator: java.util.Iterator[_copyOf_3__E]) -> ImmutableSet[_copyOf_3__E]: ...
    _copyOf_4__E = _py_TypeVar('_copyOf_4__E', bound=java.lang.Comparable)  # <E>
    @classmethod
    @overload
    def copyOf(cls, eArray: _py_List[_copyOf_4__E]) -> 'ImmutableSortedSet'[_copyOf_4__E]: ...
    _copyOf_5__E = _py_TypeVar('_copyOf_5__E')  # <E>
    @classmethod
    @overload
    def copyOf(cls, iterable: java.lang.Iterable[_copyOf_5__E]) -> 'ImmutableSortedSet'[_copyOf_5__E]: ...
    _copyOf_6__E = _py_TypeVar('_copyOf_6__E')  # <E>
    @classmethod
    @overload
    def copyOf(cls, collection: java.util.Collection[_copyOf_6__E]) -> 'ImmutableSortedSet'[_copyOf_6__E]: ...
    _copyOf_7__E = _py_TypeVar('_copyOf_7__E')  # <E>
    @classmethod
    @overload
    def copyOf(cls, comparator: java.util.Comparator[_copyOf_7__E], iterable: java.lang.Iterable[_copyOf_7__E]) -> 'ImmutableSortedSet'[_copyOf_7__E]: ...
    _copyOf_8__E = _py_TypeVar('_copyOf_8__E')  # <E>
    @classmethod
    @overload
    def copyOf(cls, comparator: java.util.Comparator[_copyOf_8__E], collection: java.util.Collection[_copyOf_8__E]) -> 'ImmutableSortedSet'[_copyOf_8__E]: ...
    _copyOf_9__E = _py_TypeVar('_copyOf_9__E')  # <E>
    @classmethod
    @overload
    def copyOf(cls, comparator: java.util.Comparator[_copyOf_9__E], iterator: java.util.Iterator[_copyOf_9__E]) -> 'ImmutableSortedSet'[_copyOf_9__E]: ...
    _copyOf_10__E = _py_TypeVar('_copyOf_10__E')  # <E>
    @classmethod
    @overload
    def copyOf(cls, iterator: java.util.Iterator[_copyOf_10__E]) -> 'ImmutableSortedSet'[_copyOf_10__E]: ...
    _copyOf_11__E = _py_TypeVar('_copyOf_11__E')  # <E>
    @classmethod
    @overload
    def copyOf(cls, eArray: _py_List[_copyOf_11__E]) -> 'ImmutableSortedSet'[_copyOf_11__E]: ...
    _copyOfSorted__E = _py_TypeVar('_copyOfSorted__E')  # <E>
    @classmethod
    def copyOfSorted(cls, sortedSet: java.util.SortedSet[_copyOfSorted__E]) -> 'ImmutableSortedSet'[_copyOfSorted__E]: ...
    @overload
    def descendingIterator(self) -> UnmodifiableIterator[_ImmutableSortedSet__E]: ...
    @overload
    def descendingIterator(self) -> java.util.Iterator: ...
    @overload
    def descendingSet(self) -> 'ImmutableSortedSet'[_ImmutableSortedSet__E]: ...
    @overload
    def descendingSet(self) -> java.util.NavigableSet: ...
    def first(self) -> _ImmutableSortedSet__E: ...
    def floor(self, e: _ImmutableSortedSet__E) -> _ImmutableSortedSet__E: ...
    @overload
    def headSet(self, e: _ImmutableSortedSet__E) -> 'ImmutableSortedSet'[_ImmutableSortedSet__E]: ...
    @overload
    def headSet(self, e: _ImmutableSortedSet__E, boolean: bool) -> 'ImmutableSortedSet'[_ImmutableSortedSet__E]: ...
    @overload
    def headSet(self, object: _py_Any, boolean: bool) -> java.util.NavigableSet: ...
    @overload
    def headSet(self, object: _py_Any) -> java.util.SortedSet: ...
    def higher(self, e: _ImmutableSortedSet__E) -> _ImmutableSortedSet__E: ...
    @overload
    def iterator(self) -> UnmodifiableIterator[_ImmutableSortedSet__E]: ...
    @overload
    def iterator(self) -> java.util.Iterator: ...
    def last(self) -> _ImmutableSortedSet__E: ...
    def lower(self, e: _ImmutableSortedSet__E) -> _ImmutableSortedSet__E: ...
    _naturalOrder__E = _py_TypeVar('_naturalOrder__E', bound=java.lang.Comparable)  # <E>
    @classmethod
    def naturalOrder(cls) -> 'ImmutableSortedSet.Builder'[_naturalOrder__E]: ...
    _of_0__E = _py_TypeVar('_of_0__E')  # <E>
    @classmethod
    @overload
    def of(cls) -> ImmutableSet[_of_0__E]: ...
    _of_1__E = _py_TypeVar('_of_1__E')  # <E>
    @classmethod
    @overload
    def of(cls, e: _of_1__E) -> ImmutableSet[_of_1__E]: ...
    _of_2__E = _py_TypeVar('_of_2__E')  # <E>
    @classmethod
    @overload
    def of(cls, e: _of_2__E, e2: _of_2__E) -> ImmutableSet[_of_2__E]: ...
    _of_3__E = _py_TypeVar('_of_3__E')  # <E>
    @classmethod
    @overload
    def of(cls, e: _of_3__E, e2: _of_3__E, e3: _of_3__E) -> ImmutableSet[_of_3__E]: ...
    _of_4__E = _py_TypeVar('_of_4__E')  # <E>
    @classmethod
    @overload
    def of(cls, e: _of_4__E, e2: _of_4__E, e3: _of_4__E, e4: _of_4__E) -> ImmutableSet[_of_4__E]: ...
    _of_5__E = _py_TypeVar('_of_5__E')  # <E>
    @classmethod
    @overload
    def of(cls, e: _of_5__E, e2: _of_5__E, e3: _of_5__E, e4: _of_5__E, e5: _of_5__E) -> ImmutableSet[_of_5__E]: ...
    _of_6__E = _py_TypeVar('_of_6__E')  # <E>
    @classmethod
    @overload
    def of(cls, e: _of_6__E, e2: _of_6__E, e3: _of_6__E, e4: _of_6__E, e5: _of_6__E, e6: _of_6__E, eArray: _py_List[_of_6__E]) -> ImmutableSet[_of_6__E]: ...
    _of_7__E = _py_TypeVar('_of_7__E')  # <E>
    @classmethod
    @overload
    def of(cls) -> 'ImmutableSortedSet'[_of_7__E]: ...
    _of_8__E = _py_TypeVar('_of_8__E', bound=java.lang.Comparable)  # <E>
    @classmethod
    @overload
    def of(cls, e: _of_8__E) -> 'ImmutableSortedSet'[_of_8__E]: ...
    _of_9__E = _py_TypeVar('_of_9__E', bound=java.lang.Comparable)  # <E>
    @classmethod
    @overload
    def of(cls, e: _of_9__E, e2: _of_9__E) -> 'ImmutableSortedSet'[_of_9__E]: ...
    _of_10__E = _py_TypeVar('_of_10__E', bound=java.lang.Comparable)  # <E>
    @classmethod
    @overload
    def of(cls, e: _of_10__E, e2: _of_10__E, e3: _of_10__E) -> 'ImmutableSortedSet'[_of_10__E]: ...
    _of_11__E = _py_TypeVar('_of_11__E', bound=java.lang.Comparable)  # <E>
    @classmethod
    @overload
    def of(cls, e: _of_11__E, e2: _of_11__E, e3: _of_11__E, e4: _of_11__E) -> 'ImmutableSortedSet'[_of_11__E]: ...
    _of_12__E = _py_TypeVar('_of_12__E', bound=java.lang.Comparable)  # <E>
    @classmethod
    @overload
    def of(cls, e: _of_12__E, e2: _of_12__E, e3: _of_12__E, e4: _of_12__E, e5: _of_12__E) -> 'ImmutableSortedSet'[_of_12__E]: ...
    _of_13__E = _py_TypeVar('_of_13__E', bound=java.lang.Comparable)  # <E>
    @classmethod
    @overload
    def of(cls, e: _of_13__E, e2: _of_13__E, e3: _of_13__E, e4: _of_13__E, e5: _of_13__E, e6: _of_13__E, eArray: _py_List[_of_13__E]) -> 'ImmutableSortedSet'[_of_13__E]: ...
    _of_14__E = _py_TypeVar('_of_14__E')  # <E>
    @classmethod
    @overload
    def of(cls, e: _of_14__E) -> 'ImmutableSortedSet'[_of_14__E]: ...
    _of_15__E = _py_TypeVar('_of_15__E')  # <E>
    @classmethod
    @overload
    def of(cls, e: _of_15__E, e2: _of_15__E) -> 'ImmutableSortedSet'[_of_15__E]: ...
    _of_16__E = _py_TypeVar('_of_16__E')  # <E>
    @classmethod
    @overload
    def of(cls, e: _of_16__E, e2: _of_16__E, e3: _of_16__E) -> 'ImmutableSortedSet'[_of_16__E]: ...
    _of_17__E = _py_TypeVar('_of_17__E')  # <E>
    @classmethod
    @overload
    def of(cls, e: _of_17__E, e2: _of_17__E, e3: _of_17__E, e4: _of_17__E) -> 'ImmutableSortedSet'[_of_17__E]: ...
    _of_18__E = _py_TypeVar('_of_18__E')  # <E>
    @classmethod
    @overload
    def of(cls, e: _of_18__E, e2: _of_18__E, e3: _of_18__E, e4: _of_18__E, e5: _of_18__E) -> 'ImmutableSortedSet'[_of_18__E]: ...
    _of_19__E = _py_TypeVar('_of_19__E')  # <E>
    @classmethod
    @overload
    def of(cls, e: _of_19__E, e2: _of_19__E, e3: _of_19__E, e4: _of_19__E, e5: _of_19__E, e6: _of_19__E, eArray: _py_List[_of_19__E]) -> 'ImmutableSortedSet'[_of_19__E]: ...
    _orderedBy__E = _py_TypeVar('_orderedBy__E')  # <E>
    @classmethod
    def orderedBy(cls, comparator: java.util.Comparator[_orderedBy__E]) -> 'ImmutableSortedSet.Builder'[_orderedBy__E]: ...
    def pollFirst(self) -> _ImmutableSortedSet__E: ...
    def pollLast(self) -> _ImmutableSortedSet__E: ...
    _reverseOrder__E = _py_TypeVar('_reverseOrder__E', bound=java.lang.Comparable)  # <E>
    @classmethod
    def reverseOrder(cls) -> 'ImmutableSortedSet.Builder'[_reverseOrder__E]: ...
    def spliterator(self) -> java.util.Spliterator[_ImmutableSortedSet__E]: ...
    @overload
    def subSet(self, e: _ImmutableSortedSet__E, boolean: bool, e2: _ImmutableSortedSet__E, boolean2: bool) -> 'ImmutableSortedSet'[_ImmutableSortedSet__E]: ...
    @overload
    def subSet(self, e: _ImmutableSortedSet__E, e2: _ImmutableSortedSet__E) -> 'ImmutableSortedSet'[_ImmutableSortedSet__E]: ...
    @overload
    def subSet(self, object: _py_Any, boolean: bool, object2: _py_Any, boolean2: bool) -> java.util.NavigableSet: ...
    @overload
    def subSet(self, object: _py_Any, object2: _py_Any) -> java.util.SortedSet: ...
    @overload
    def tailSet(self, e: _ImmutableSortedSet__E) -> 'ImmutableSortedSet'[_ImmutableSortedSet__E]: ...
    @overload
    def tailSet(self, e: _ImmutableSortedSet__E, boolean: bool) -> 'ImmutableSortedSet'[_ImmutableSortedSet__E]: ...
    @overload
    def tailSet(self, object: _py_Any, boolean: bool) -> java.util.NavigableSet: ...
    @overload
    def tailSet(self, object: _py_Any) -> java.util.SortedSet: ...
    _toImmutableSortedSet__E = _py_TypeVar('_toImmutableSortedSet__E')  # <E>
    @classmethod
    def toImmutableSortedSet(cls, comparator: java.util.Comparator[_toImmutableSortedSet__E]) -> java.util.stream.Collector[_toImmutableSortedSet__E, _py_Any, 'ImmutableSortedSet'[_toImmutableSortedSet__E]]: ...
    class Builder(ImmutableSet.Builder[_ImmutableSortedSet__Builder__E], _py_Generic[_ImmutableSortedSet__Builder__E]):
        def __init__(self, comparator: java.util.Comparator[_ImmutableSortedSet__Builder__E]): ...
        @overload
        def add(self, object: _py_Any) -> ImmutableCollection.Builder: ...
        @overload
        def add(self, objectArray: _py_List[_py_Any]) -> ImmutableCollection.Builder: ...
        @overload
        def add(self, object: _py_Any) -> ImmutableSet.Builder: ...
        @overload
        def add(self, objectArray: _py_List[_py_Any]) -> ImmutableSet.Builder: ...
        @overload
        def add(self, e: _ImmutableSortedSet__Builder__E) -> 'ImmutableSortedSet.Builder'[_ImmutableSortedSet__Builder__E]: ...
        @overload
        def add(self, eArray: _py_List[_ImmutableSortedSet__Builder__E]) -> 'ImmutableSortedSet.Builder'[_ImmutableSortedSet__Builder__E]: ...
        @overload
        def addAll(self, iterable: java.lang.Iterable) -> ImmutableCollection.Builder: ...
        @overload
        def addAll(self, iterator: java.util.Iterator) -> ImmutableCollection.Builder: ...
        @overload
        def addAll(self, iterable: java.lang.Iterable) -> ImmutableSet.Builder: ...
        @overload
        def addAll(self, iterator: java.util.Iterator) -> ImmutableSet.Builder: ...
        @overload
        def addAll(self, iterable: java.lang.Iterable[_ImmutableSortedSet__Builder__E]) -> 'ImmutableSortedSet.Builder'[_ImmutableSortedSet__Builder__E]: ...
        @overload
        def addAll(self, iterator: java.util.Iterator[_ImmutableSortedSet__Builder__E]) -> 'ImmutableSortedSet.Builder'[_ImmutableSortedSet__Builder__E]: ...
        @overload
        def build(self) -> ImmutableCollection: ...
        @overload
        def build(self) -> ImmutableSet: ...
        @overload
        def build(self) -> 'ImmutableSortedSet'[_ImmutableSortedSet__Builder__E]: ...

_ImmutableSortedSetFauxverideShim__E = _py_TypeVar('_ImmutableSortedSetFauxverideShim__E')  # <E>
class ImmutableSortedSetFauxverideShim(ImmutableSet[_ImmutableSortedSetFauxverideShim__E], _py_Generic[_ImmutableSortedSetFauxverideShim__E]):
    _builder_0__E = _py_TypeVar('_builder_0__E')  # <E>
    @classmethod
    @overload
    def builder(cls) -> ImmutableSet.Builder[_builder_0__E]: ...
    _builder_1__E = _py_TypeVar('_builder_1__E')  # <E>
    @classmethod
    @overload
    def builder(cls) -> ImmutableSortedSet.Builder[_builder_1__E]: ...
    _builderWithExpectedSize_0__E = _py_TypeVar('_builderWithExpectedSize_0__E')  # <E>
    @classmethod
    @overload
    def builderWithExpectedSize(cls, int: int) -> ImmutableSet.Builder[_builderWithExpectedSize_0__E]: ...
    _builderWithExpectedSize_1__E = _py_TypeVar('_builderWithExpectedSize_1__E')  # <E>
    @classmethod
    @overload
    def builderWithExpectedSize(cls, int: int) -> ImmutableSortedSet.Builder[_builderWithExpectedSize_1__E]: ...
    _copyOf_0__E = _py_TypeVar('_copyOf_0__E')  # <E>
    @classmethod
    @overload
    def copyOf(cls, iterable: java.lang.Iterable[_copyOf_0__E]) -> ImmutableSet[_copyOf_0__E]: ...
    _copyOf_1__E = _py_TypeVar('_copyOf_1__E')  # <E>
    @classmethod
    @overload
    def copyOf(cls, eArray: _py_List[_copyOf_1__E]) -> ImmutableSet[_copyOf_1__E]: ...
    _copyOf_2__E = _py_TypeVar('_copyOf_2__E')  # <E>
    @classmethod
    @overload
    def copyOf(cls, collection: java.util.Collection[_copyOf_2__E]) -> ImmutableSet[_copyOf_2__E]: ...
    _copyOf_3__E = _py_TypeVar('_copyOf_3__E')  # <E>
    @classmethod
    @overload
    def copyOf(cls, iterator: java.util.Iterator[_copyOf_3__E]) -> ImmutableSet[_copyOf_3__E]: ...
    _copyOf_4__E = _py_TypeVar('_copyOf_4__E')  # <E>
    @classmethod
    @overload
    def copyOf(cls, eArray: _py_List[_copyOf_4__E]) -> ImmutableSortedSet[_copyOf_4__E]: ...
    _of_0__E = _py_TypeVar('_of_0__E')  # <E>
    @classmethod
    @overload
    def of(cls) -> ImmutableSet[_of_0__E]: ...
    _of_1__E = _py_TypeVar('_of_1__E')  # <E>
    @classmethod
    @overload
    def of(cls, e: _of_1__E) -> ImmutableSet[_of_1__E]: ...
    _of_2__E = _py_TypeVar('_of_2__E')  # <E>
    @classmethod
    @overload
    def of(cls, e: _of_2__E, e2: _of_2__E) -> ImmutableSet[_of_2__E]: ...
    _of_3__E = _py_TypeVar('_of_3__E')  # <E>
    @classmethod
    @overload
    def of(cls, e: _of_3__E, e2: _of_3__E, e3: _of_3__E) -> ImmutableSet[_of_3__E]: ...
    _of_4__E = _py_TypeVar('_of_4__E')  # <E>
    @classmethod
    @overload
    def of(cls, e: _of_4__E, e2: _of_4__E, e3: _of_4__E, e4: _of_4__E) -> ImmutableSet[_of_4__E]: ...
    _of_5__E = _py_TypeVar('_of_5__E')  # <E>
    @classmethod
    @overload
    def of(cls, e: _of_5__E, e2: _of_5__E, e3: _of_5__E, e4: _of_5__E, e5: _of_5__E) -> ImmutableSet[_of_5__E]: ...
    _of_6__E = _py_TypeVar('_of_6__E')  # <E>
    @classmethod
    @overload
    def of(cls, e: _of_6__E, e2: _of_6__E, e3: _of_6__E, e4: _of_6__E, e5: _of_6__E, e6: _of_6__E, eArray: _py_List[_of_6__E]) -> ImmutableSet[_of_6__E]: ...
    _of_7__E = _py_TypeVar('_of_7__E')  # <E>
    @classmethod
    @overload
    def of(cls, e: _of_7__E) -> ImmutableSortedSet[_of_7__E]: ...
    _of_8__E = _py_TypeVar('_of_8__E')  # <E>
    @classmethod
    @overload
    def of(cls, e: _of_8__E, e2: _of_8__E) -> ImmutableSortedSet[_of_8__E]: ...
    _of_9__E = _py_TypeVar('_of_9__E')  # <E>
    @classmethod
    @overload
    def of(cls, e: _of_9__E, e2: _of_9__E, e3: _of_9__E) -> ImmutableSortedSet[_of_9__E]: ...
    _of_10__E = _py_TypeVar('_of_10__E')  # <E>
    @classmethod
    @overload
    def of(cls, e: _of_10__E, e2: _of_10__E, e3: _of_10__E, e4: _of_10__E) -> ImmutableSortedSet[_of_10__E]: ...
    _of_11__E = _py_TypeVar('_of_11__E')  # <E>
    @classmethod
    @overload
    def of(cls, e: _of_11__E, e2: _of_11__E, e3: _of_11__E, e4: _of_11__E, e5: _of_11__E) -> ImmutableSortedSet[_of_11__E]: ...
    _of_12__E = _py_TypeVar('_of_12__E')  # <E>
    @classmethod
    @overload
    def of(cls, e: _of_12__E, e2: _of_12__E, e3: _of_12__E, e4: _of_12__E, e5: _of_12__E, e6: _of_12__E, eArray: _py_List[_of_12__E]) -> ImmutableSortedSet[_of_12__E]: ...
    _toImmutableSet__E = _py_TypeVar('_toImmutableSet__E')  # <E>
    @classmethod
    def toImmutableSet(cls) -> java.util.stream.Collector[_toImmutableSet__E, _py_Any, ImmutableSet[_toImmutableSet__E]]: ...

_IndexedImmutableSet__E = _py_TypeVar('_IndexedImmutableSet__E')  # <E>
class IndexedImmutableSet(ImmutableSet[_IndexedImmutableSet__E], _py_Generic[_IndexedImmutableSet__E]):
    def forEach(self, consumer: java.util.function.Consumer[_IndexedImmutableSet__E]) -> None: ...
    @overload
    def iterator(self) -> UnmodifiableIterator[_IndexedImmutableSet__E]: ...
    @overload
    def iterator(self) -> java.util.Iterator: ...
    def spliterator(self) -> java.util.Spliterator[_IndexedImmutableSet__E]: ...

_JdkBackedImmutableBiMap__K = _py_TypeVar('_JdkBackedImmutableBiMap__K')  # <K>
_JdkBackedImmutableBiMap__V = _py_TypeVar('_JdkBackedImmutableBiMap__V')  # <V>
class JdkBackedImmutableBiMap(ImmutableBiMap[_JdkBackedImmutableBiMap__K, _JdkBackedImmutableBiMap__V], _py_Generic[_JdkBackedImmutableBiMap__K, _JdkBackedImmutableBiMap__V]):
    def get(self, object: _py_Any) -> _JdkBackedImmutableBiMap__V: ...
    @overload
    def inverse(self) -> BiMap: ...
    @overload
    def inverse(self) -> ImmutableBiMap[_JdkBackedImmutableBiMap__V, _JdkBackedImmutableBiMap__K]: ...
    def size(self) -> int: ...

_JdkBackedImmutableMultiset__E = _py_TypeVar('_JdkBackedImmutableMultiset__E')  # <E>
class JdkBackedImmutableMultiset(ImmutableMultiset[_JdkBackedImmutableMultiset__E], _py_Generic[_JdkBackedImmutableMultiset__E]):
    def count(self, object: _py_Any) -> int: ...
    @overload
    def elementSet(self) -> ImmutableSet[_JdkBackedImmutableMultiset__E]: ...
    @overload
    def elementSet(self) -> java.util.Set: ...
    def size(self) -> int: ...

_JdkBackedImmutableSet__E = _py_TypeVar('_JdkBackedImmutableSet__E')  # <E>
class JdkBackedImmutableSet(IndexedImmutableSet[_JdkBackedImmutableSet__E], _py_Generic[_JdkBackedImmutableSet__E]):
    def contains(self, object: _py_Any) -> bool: ...
    def size(self) -> int: ...

_MultimapBuilder__ListMultimapBuilder__K0 = _py_TypeVar('_MultimapBuilder__ListMultimapBuilder__K0')  # <K0>
_MultimapBuilder__ListMultimapBuilder__V0 = _py_TypeVar('_MultimapBuilder__ListMultimapBuilder__V0')  # <V0>
_MultimapBuilder__MultimapBuilderWithKeys__K0 = _py_TypeVar('_MultimapBuilder__MultimapBuilderWithKeys__K0')  # <K0>
_MultimapBuilder__SetMultimapBuilder__K0 = _py_TypeVar('_MultimapBuilder__SetMultimapBuilder__K0')  # <K0>
_MultimapBuilder__SetMultimapBuilder__V0 = _py_TypeVar('_MultimapBuilder__SetMultimapBuilder__V0')  # <V0>
_MultimapBuilder__SortedSetMultimapBuilder__K0 = _py_TypeVar('_MultimapBuilder__SortedSetMultimapBuilder__K0')  # <K0>
_MultimapBuilder__SortedSetMultimapBuilder__V0 = _py_TypeVar('_MultimapBuilder__SortedSetMultimapBuilder__V0')  # <V0>
_MultimapBuilder__K0 = _py_TypeVar('_MultimapBuilder__K0')  # <K0>
_MultimapBuilder__V0 = _py_TypeVar('_MultimapBuilder__V0')  # <V0>
class MultimapBuilder(_py_Generic[_MultimapBuilder__K0, _MultimapBuilder__V0]):
    _build_0__K = _py_TypeVar('_build_0__K')  # <K>
    _build_0__V = _py_TypeVar('_build_0__V')  # <V>
    @overload
    def build(self) -> Multimap[_build_0__K, _build_0__V]: ...
    _build_1__K = _py_TypeVar('_build_1__K')  # <K>
    _build_1__V = _py_TypeVar('_build_1__V')  # <V>
    @overload
    def build(self, multimap: Multimap[_build_1__K, _build_1__V]) -> Multimap[_build_1__K, _build_1__V]: ...
    _enumKeys__K0 = _py_TypeVar('_enumKeys__K0', bound=java.lang.Enum)  # <K0>
    @classmethod
    def enumKeys(cls, class_: _py_Type[_enumKeys__K0]) -> 'MultimapBuilder.MultimapBuilderWithKeys'[_enumKeys__K0]: ...
    @classmethod
    @overload
    def hashKeys(cls) -> 'MultimapBuilder.MultimapBuilderWithKeys'[_py_Any]: ...
    @classmethod
    @overload
    def hashKeys(cls, int: int) -> 'MultimapBuilder.MultimapBuilderWithKeys'[_py_Any]: ...
    @classmethod
    @overload
    def linkedHashKeys(cls) -> 'MultimapBuilder.MultimapBuilderWithKeys'[_py_Any]: ...
    @classmethod
    @overload
    def linkedHashKeys(cls, int: int) -> 'MultimapBuilder.MultimapBuilderWithKeys'[_py_Any]: ...
    @classmethod
    @overload
    def treeKeys(cls) -> 'MultimapBuilder.MultimapBuilderWithKeys'[java.lang.Comparable]: ...
    _treeKeys_1__K0 = _py_TypeVar('_treeKeys_1__K0')  # <K0>
    @classmethod
    @overload
    def treeKeys(cls, comparator: java.util.Comparator[_treeKeys_1__K0]) -> 'MultimapBuilder.MultimapBuilderWithKeys'[_treeKeys_1__K0]: ...
    class ListMultimapBuilder(com.google.common.collect.MultimapBuilder[_MultimapBuilder__ListMultimapBuilder__K0, _MultimapBuilder__ListMultimapBuilder__V0], _py_Generic[_MultimapBuilder__ListMultimapBuilder__K0, _MultimapBuilder__ListMultimapBuilder__V0]):
        _build_0__K = _py_TypeVar('_build_0__K')  # <K>
        _build_0__V = _py_TypeVar('_build_0__V')  # <V>
        @overload
        def build(self) -> ListMultimap[_build_0__K, _build_0__V]: ...
        _build_1__K = _py_TypeVar('_build_1__K')  # <K>
        _build_1__V = _py_TypeVar('_build_1__V')  # <V>
        @overload
        def build(self, multimap: Multimap[_build_1__K, _build_1__V]) -> ListMultimap[_build_1__K, _build_1__V]: ...
        @overload
        def build(self) -> Multimap: ...
        @overload
        def build(self, multimap: Multimap) -> Multimap: ...
    class MultimapBuilderWithKeys(_py_Generic[_MultimapBuilder__MultimapBuilderWithKeys__K0]):
        @overload
        def arrayListValues(self) -> 'MultimapBuilder.ListMultimapBuilder'[_MultimapBuilder__MultimapBuilderWithKeys__K0, _py_Any]: ...
        @overload
        def arrayListValues(self, int: int) -> 'MultimapBuilder.ListMultimapBuilder'[_MultimapBuilder__MultimapBuilderWithKeys__K0, _py_Any]: ...
        _enumSetValues__V0 = _py_TypeVar('_enumSetValues__V0', bound=java.lang.Enum)  # <V0>
        def enumSetValues(self, class_: _py_Type[_enumSetValues__V0]) -> 'MultimapBuilder.SetMultimapBuilder'[_MultimapBuilder__MultimapBuilderWithKeys__K0, _enumSetValues__V0]: ...
        @overload
        def hashSetValues(self) -> 'MultimapBuilder.SetMultimapBuilder'[_MultimapBuilder__MultimapBuilderWithKeys__K0, _py_Any]: ...
        @overload
        def hashSetValues(self, int: int) -> 'MultimapBuilder.SetMultimapBuilder'[_MultimapBuilder__MultimapBuilderWithKeys__K0, _py_Any]: ...
        @overload
        def linkedHashSetValues(self) -> 'MultimapBuilder.SetMultimapBuilder'[_MultimapBuilder__MultimapBuilderWithKeys__K0, _py_Any]: ...
        @overload
        def linkedHashSetValues(self, int: int) -> 'MultimapBuilder.SetMultimapBuilder'[_MultimapBuilder__MultimapBuilderWithKeys__K0, _py_Any]: ...
        def linkedListValues(self) -> 'MultimapBuilder.ListMultimapBuilder'[_MultimapBuilder__MultimapBuilderWithKeys__K0, _py_Any]: ...
        @overload
        def treeSetValues(self) -> 'MultimapBuilder.SortedSetMultimapBuilder'[_MultimapBuilder__MultimapBuilderWithKeys__K0, java.lang.Comparable]: ...
        _treeSetValues_1__V0 = _py_TypeVar('_treeSetValues_1__V0')  # <V0>
        @overload
        def treeSetValues(self, comparator: java.util.Comparator[_treeSetValues_1__V0]) -> 'MultimapBuilder.SortedSetMultimapBuilder'[_MultimapBuilder__MultimapBuilderWithKeys__K0, _treeSetValues_1__V0]: ...
    class SetMultimapBuilder(com.google.common.collect.MultimapBuilder[_MultimapBuilder__SetMultimapBuilder__K0, _MultimapBuilder__SetMultimapBuilder__V0], _py_Generic[_MultimapBuilder__SetMultimapBuilder__K0, _MultimapBuilder__SetMultimapBuilder__V0]):
        _build_0__K = _py_TypeVar('_build_0__K')  # <K>
        _build_0__V = _py_TypeVar('_build_0__V')  # <V>
        @overload
        def build(self) -> SetMultimap[_build_0__K, _build_0__V]: ...
        @overload
        def build(self) -> Multimap: ...
        @overload
        def build(self, multimap: Multimap) -> Multimap: ...
        _build_3__K = _py_TypeVar('_build_3__K')  # <K>
        _build_3__V = _py_TypeVar('_build_3__V')  # <V>
        @overload
        def build(self, multimap: Multimap[_build_3__K, _build_3__V]) -> SetMultimap[_build_3__K, _build_3__V]: ...
    class SortedSetMultimapBuilder(com.google.common.collect.MultimapBuilder.SetMultimapBuilder[_MultimapBuilder__SortedSetMultimapBuilder__K0, _MultimapBuilder__SortedSetMultimapBuilder__V0], _py_Generic[_MultimapBuilder__SortedSetMultimapBuilder__K0, _MultimapBuilder__SortedSetMultimapBuilder__V0]):
        _build_0__K = _py_TypeVar('_build_0__K')  # <K>
        _build_0__V = _py_TypeVar('_build_0__V')  # <V>
        @overload
        def build(self) -> SortedSetMultimap[_build_0__K, _build_0__V]: ...
        @overload
        def build(self) -> Multimap: ...
        @overload
        def build(self, multimap: Multimap) -> Multimap: ...
        @overload
        def build(self) -> SetMultimap: ...
        @overload
        def build(self, multimap: Multimap) -> SetMultimap: ...
        _build_5__K = _py_TypeVar('_build_5__K')  # <K>
        _build_5__V = _py_TypeVar('_build_5__V')  # <V>
        @overload
        def build(self, multimap: Multimap[_build_5__K, _build_5__V]) -> SortedSetMultimap[_build_5__K, _build_5__V]: ...

_RegularContiguousSet__C = _py_TypeVar('_RegularContiguousSet__C', bound=java.lang.Comparable)  # <C>
class RegularContiguousSet(ContiguousSet[_RegularContiguousSet__C], _py_Generic[_RegularContiguousSet__C]):
    def contains(self, object: _py_Any) -> bool: ...
    def containsAll(self, collection: java.util.Collection[_py_Any]) -> bool: ...
    @overload
    def descendingIterator(self) -> UnmodifiableIterator[_RegularContiguousSet__C]: ...
    @overload
    def descendingIterator(self) -> java.util.Iterator: ...
    def equals(self, object: _py_Any) -> bool: ...
    @overload
    def first(self) -> _RegularContiguousSet__C: ...
    @overload
    def first(self) -> _py_Any: ...
    def hashCode(self) -> int: ...
    def intersection(self, contiguousSet: ContiguousSet[_RegularContiguousSet__C]) -> ContiguousSet[_RegularContiguousSet__C]: ...
    def isEmpty(self) -> bool: ...
    @overload
    def iterator(self) -> UnmodifiableIterator[_RegularContiguousSet__C]: ...
    @overload
    def iterator(self) -> java.util.Iterator: ...
    @overload
    def last(self) -> _RegularContiguousSet__C: ...
    @overload
    def last(self) -> _py_Any: ...
    @overload
    def range(self) -> Range[_RegularContiguousSet__C]: ...
    @overload
    def range(self, boundType: BoundType, boundType2: BoundType) -> Range[_RegularContiguousSet__C]: ...
    def size(self) -> int: ...

_RegularImmutableAsList__E = _py_TypeVar('_RegularImmutableAsList__E')  # <E>
class RegularImmutableAsList(ImmutableAsList[_RegularImmutableAsList__E], _py_Generic[_RegularImmutableAsList__E]):
    def forEach(self, consumer: java.util.function.Consumer[_RegularImmutableAsList__E]) -> None: ...
    def get(self, int: int) -> _RegularImmutableAsList__E: ...
    @overload
    def listIterator(self) -> UnmodifiableListIterator[_RegularImmutableAsList__E]: ...
    @overload
    def listIterator(self, int: int) -> UnmodifiableListIterator[_RegularImmutableAsList__E]: ...
    @overload
    def listIterator(self) -> java.util.ListIterator: ...
    @overload
    def listIterator(self, int: int) -> java.util.ListIterator: ...

_RegularImmutableBiMap__K = _py_TypeVar('_RegularImmutableBiMap__K')  # <K>
_RegularImmutableBiMap__V = _py_TypeVar('_RegularImmutableBiMap__V')  # <V>
class RegularImmutableBiMap(ImmutableBiMap[_RegularImmutableBiMap__K, _RegularImmutableBiMap__V], _py_Generic[_RegularImmutableBiMap__K, _RegularImmutableBiMap__V]):
    def forEach(self, biConsumer: java.util.function.BiConsumer[_RegularImmutableBiMap__K, _RegularImmutableBiMap__V]) -> None: ...
    def get(self, object: _py_Any) -> _RegularImmutableBiMap__V: ...
    def hashCode(self) -> int: ...
    @overload
    def inverse(self) -> BiMap: ...
    @overload
    def inverse(self) -> ImmutableBiMap[_RegularImmutableBiMap__V, _RegularImmutableBiMap__K]: ...
    def size(self) -> int: ...

_RegularImmutableList__E = _py_TypeVar('_RegularImmutableList__E')  # <E>
class RegularImmutableList(ImmutableList[_RegularImmutableList__E], _py_Generic[_RegularImmutableList__E]):
    def get(self, int: int) -> _RegularImmutableList__E: ...
    @overload
    def listIterator(self) -> UnmodifiableListIterator[_RegularImmutableList__E]: ...
    @overload
    def listIterator(self, int: int) -> UnmodifiableListIterator[_RegularImmutableList__E]: ...
    @overload
    def listIterator(self) -> java.util.ListIterator: ...
    @overload
    def listIterator(self, int: int) -> java.util.ListIterator: ...
    def size(self) -> int: ...
    def spliterator(self) -> java.util.Spliterator[_RegularImmutableList__E]: ...

_RegularImmutableMultiset__E = _py_TypeVar('_RegularImmutableMultiset__E')  # <E>
class RegularImmutableMultiset(ImmutableMultiset[_RegularImmutableMultiset__E], _py_Generic[_RegularImmutableMultiset__E]):
    def count(self, object: _py_Any) -> int: ...
    @overload
    def elementSet(self) -> ImmutableSet[_RegularImmutableMultiset__E]: ...
    @overload
    def elementSet(self) -> java.util.Set: ...
    def hashCode(self) -> int: ...
    def size(self) -> int: ...

_RegularImmutableSet__E = _py_TypeVar('_RegularImmutableSet__E')  # <E>
class RegularImmutableSet(ImmutableSet[_RegularImmutableSet__E], _py_Generic[_RegularImmutableSet__E]):
    def contains(self, object: _py_Any) -> bool: ...
    def hashCode(self) -> int: ...
    @overload
    def iterator(self) -> UnmodifiableIterator[_RegularImmutableSet__E]: ...
    @overload
    def iterator(self) -> java.util.Iterator: ...
    def size(self) -> int: ...
    def spliterator(self) -> java.util.Spliterator[_RegularImmutableSet__E]: ...

_RegularImmutableSortedMultiset__E = _py_TypeVar('_RegularImmutableSortedMultiset__E')  # <E>
class RegularImmutableSortedMultiset(ImmutableSortedMultiset[_RegularImmutableSortedMultiset__E], _py_Generic[_RegularImmutableSortedMultiset__E]):
    def count(self, object: _py_Any) -> int: ...
    @overload
    def elementSet(self) -> ImmutableSet: ...
    @overload
    def elementSet(self) -> ImmutableSortedSet[_RegularImmutableSortedMultiset__E]: ...
    @overload
    def elementSet(self) -> java.util.NavigableSet: ...
    @overload
    def elementSet(self) -> java.util.Set: ...
    @overload
    def elementSet(self) -> java.util.SortedSet: ...
    def firstEntry(self) -> Multiset.Entry[_RegularImmutableSortedMultiset__E]: ...
    def forEachEntry(self, objIntConsumer: java.util.function.ObjIntConsumer[_RegularImmutableSortedMultiset__E]) -> None: ...
    @overload
    def headMultiset(self, e: _RegularImmutableSortedMultiset__E, boundType: BoundType) -> ImmutableSortedMultiset[_RegularImmutableSortedMultiset__E]: ...
    @overload
    def headMultiset(self, object: _py_Any, boundType: BoundType) -> SortedMultiset: ...
    def lastEntry(self) -> Multiset.Entry[_RegularImmutableSortedMultiset__E]: ...
    def size(self) -> int: ...
    @overload
    def tailMultiset(self, e: _RegularImmutableSortedMultiset__E, boundType: BoundType) -> ImmutableSortedMultiset[_RegularImmutableSortedMultiset__E]: ...
    @overload
    def tailMultiset(self, object: _py_Any, boundType: BoundType) -> SortedMultiset: ...

_RegularImmutableSortedSet__E = _py_TypeVar('_RegularImmutableSortedSet__E')  # <E>
class RegularImmutableSortedSet(ImmutableSortedSet[_RegularImmutableSortedSet__E], _py_Generic[_RegularImmutableSortedSet__E]):
    def ceiling(self, e: _RegularImmutableSortedSet__E) -> _RegularImmutableSortedSet__E: ...
    def contains(self, object: _py_Any) -> bool: ...
    def containsAll(self, collection: java.util.Collection[_py_Any]) -> bool: ...
    @overload
    def descendingIterator(self) -> UnmodifiableIterator[_RegularImmutableSortedSet__E]: ...
    @overload
    def descendingIterator(self) -> java.util.Iterator: ...
    def equals(self, object: _py_Any) -> bool: ...
    def first(self) -> _RegularImmutableSortedSet__E: ...
    def floor(self, e: _RegularImmutableSortedSet__E) -> _RegularImmutableSortedSet__E: ...
    def forEach(self, consumer: java.util.function.Consumer[_RegularImmutableSortedSet__E]) -> None: ...
    def higher(self, e: _RegularImmutableSortedSet__E) -> _RegularImmutableSortedSet__E: ...
    @overload
    def iterator(self) -> UnmodifiableIterator[_RegularImmutableSortedSet__E]: ...
    @overload
    def iterator(self) -> java.util.Iterator: ...
    def last(self) -> _RegularImmutableSortedSet__E: ...
    def lower(self, e: _RegularImmutableSortedSet__E) -> _RegularImmutableSortedSet__E: ...
    def size(self) -> int: ...
    def spliterator(self) -> java.util.Spliterator[_RegularImmutableSortedSet__E]: ...

_SingletonImmutableBiMap__K = _py_TypeVar('_SingletonImmutableBiMap__K')  # <K>
_SingletonImmutableBiMap__V = _py_TypeVar('_SingletonImmutableBiMap__V')  # <V>
class SingletonImmutableBiMap(ImmutableBiMap[_SingletonImmutableBiMap__K, _SingletonImmutableBiMap__V], _py_Generic[_SingletonImmutableBiMap__K, _SingletonImmutableBiMap__V]):
    def containsKey(self, object: _py_Any) -> bool: ...
    def containsValue(self, object: _py_Any) -> bool: ...
    def forEach(self, biConsumer: java.util.function.BiConsumer[_SingletonImmutableBiMap__K, _SingletonImmutableBiMap__V]) -> None: ...
    def get(self, object: _py_Any) -> _SingletonImmutableBiMap__V: ...
    @overload
    def inverse(self) -> BiMap: ...
    @overload
    def inverse(self) -> ImmutableBiMap[_SingletonImmutableBiMap__V, _SingletonImmutableBiMap__K]: ...
    def size(self) -> int: ...

_SingletonImmutableList__E = _py_TypeVar('_SingletonImmutableList__E')  # <E>
class SingletonImmutableList(ImmutableList[_SingletonImmutableList__E], _py_Generic[_SingletonImmutableList__E]):
    def get(self, int: int) -> _SingletonImmutableList__E: ...
    @overload
    def iterator(self) -> UnmodifiableIterator[_SingletonImmutableList__E]: ...
    @overload
    def iterator(self) -> java.util.Iterator: ...
    def size(self) -> int: ...
    def spliterator(self) -> java.util.Spliterator[_SingletonImmutableList__E]: ...
    @overload
    def subList(self, int: int, int2: int) -> ImmutableList[_SingletonImmutableList__E]: ...
    @overload
    def subList(self, int: int, int2: int) -> java.util.List: ...
    def toString(self) -> str: ...

_SingletonImmutableSet__E = _py_TypeVar('_SingletonImmutableSet__E')  # <E>
class SingletonImmutableSet(ImmutableSet[_SingletonImmutableSet__E], _py_Generic[_SingletonImmutableSet__E]):
    def contains(self, object: _py_Any) -> bool: ...
    def hashCode(self) -> int: ...
    @overload
    def iterator(self) -> UnmodifiableIterator[_SingletonImmutableSet__E]: ...
    @overload
    def iterator(self) -> java.util.Iterator: ...
    def size(self) -> int: ...
    def toString(self) -> str: ...

_UnmodifiableSortedMultiset__E = _py_TypeVar('_UnmodifiableSortedMultiset__E')  # <E>
class UnmodifiableSortedMultiset(com.google.common.collect.Multisets.UnmodifiableMultiset[_UnmodifiableSortedMultiset__E], SortedMultiset[_UnmodifiableSortedMultiset__E], _py_Generic[_UnmodifiableSortedMultiset__E]):
    def comparator(self) -> java.util.Comparator[_UnmodifiableSortedMultiset__E]: ...
    def descendingMultiset(self) -> SortedMultiset[_UnmodifiableSortedMultiset__E]: ...
    @overload
    def elementSet(self) -> java.util.NavigableSet[_UnmodifiableSortedMultiset__E]: ...
    @overload
    def elementSet(self) -> java.util.Set: ...
    @overload
    def elementSet(self) -> java.util.SortedSet: ...
    def firstEntry(self) -> Multiset.Entry[_UnmodifiableSortedMultiset__E]: ...
    def headMultiset(self, e: _UnmodifiableSortedMultiset__E, boundType: BoundType) -> SortedMultiset[_UnmodifiableSortedMultiset__E]: ...
    def lastEntry(self) -> Multiset.Entry[_UnmodifiableSortedMultiset__E]: ...
    def pollFirstEntry(self) -> Multiset.Entry[_UnmodifiableSortedMultiset__E]: ...
    def pollLastEntry(self) -> Multiset.Entry[_UnmodifiableSortedMultiset__E]: ...
    def subMultiset(self, e: _UnmodifiableSortedMultiset__E, boundType: BoundType, e2: _UnmodifiableSortedMultiset__E, boundType2: BoundType) -> SortedMultiset[_UnmodifiableSortedMultiset__E]: ...
    def tailMultiset(self, e: _UnmodifiableSortedMultiset__E, boundType: BoundType) -> SortedMultiset[_UnmodifiableSortedMultiset__E]: ...
