from typing import Any as _py_Any
from typing import List as _py_List
from typing import TypeVar as _py_TypeVar
from typing import Type as _py_Type
from typing import ClassVar as _py_ClassVar
from typing import overload
import cern.accsoft.commons.domain
import cern.accsoft.commons.domain.particletransfers
import cern.accsoft.commons.domain.zones
import cern.accsoft.commons.util
import cern.accsoft.commons.util.value
import cern.accsoft.commons.value
import cern.lsa.domain
import cern.lsa.domain.commons
import cern.lsa.domain.devices
import cern.lsa.domain.devices.type
import cern.lsa.domain.exploitation
import cern.lsa.domain.optics
import cern.lsa.domain.settings.factory
import cern.lsa.domain.settings.spi
import cern.lsa.domain.settings.type
import com.google.common.collect
import java.io
import java.lang
import java.time
import java.util


class AcceleratorUser(cern.lsa.domain.commons.IdentifiedEntity, cern.accsoft.commons.util.Named):
    @classmethod
    def builder(cls) -> 'DefaultAcceleratorUser.Builder': ...
    def getAccelerator(self) -> cern.accsoft.commons.domain.Accelerator: ...
    def getAcceleratorUserGroup(self) -> 'AcceleratorUserGroup': ...
    def isMultiplexed(self) -> bool: ...

class AcceleratorUserGroup(cern.lsa.domain.commons.IdentifiedEntity, cern.accsoft.commons.util.Named):
    @classmethod
    def builder(cls) -> 'DefaultAcceleratorUserGroup.Builder': ...
    def getDescription(self) -> str: ...

class AcceleratorUsersRequest:
    @classmethod
    def builder(cls) -> 'DefaultAcceleratorUsersRequest.Builder': ...
    @classmethod
    def byAccelerator(cls, accelerator: cern.accsoft.commons.domain.Accelerator) -> 'AcceleratorUsersRequest': ...
    @classmethod
    def byAcceleratorAndUserName(cls, accelerator: cern.accsoft.commons.domain.Accelerator, string: str) -> 'AcceleratorUsersRequest': ...
    @classmethod
    def byUserName(cls, string: str) -> 'AcceleratorUsersRequest': ...
    @classmethod
    def byUserNames(cls, iterable: java.lang.Iterable[str]) -> 'AcceleratorUsersRequest': ...
    def getAccelerator(self) -> cern.accsoft.commons.domain.Accelerator: ...
    def getAcceleratorUserGroupName(self) -> str: ...
    def getAcceleratorUserNames(self) -> java.util.Set[str]: ...
    def getIds(self) -> java.util.Set[int]: ...
    def isMultiplexed(self) -> bool: ...

class ActualBeamProcessInfo:
    def getSourceBeamProcess(self) -> 'BeamProcess': ...
    def getSourcePoint(self) -> int: ...

class Archive(cern.lsa.domain.commons.IdentifiedEntity, cern.accsoft.commons.util.Named, java.lang.Comparable['Archive']):
    def getLatestVersion(self) -> 'ArchiveVersion': ...
    def getStandAloneContext(self) -> 'StandAloneContext': ...
    def getVersion(self, double: float) -> 'ArchiveVersion': ...
    def getVersions(self) -> java.util.SortedSet['ArchiveVersion']: ...

class ArchiveVersion(java.lang.Comparable['ArchiveVersion']):
    def getArchive(self) -> Archive: ...
    def getCreationDate(self) -> java.util.Date: ...
    def getDescription(self) -> str: ...
    def getSettingCount(self) -> int: ...
    def getVersion(self) -> float: ...

class BaseStandAloneContextsRequest:
    def getAccelerator(self) -> cern.accsoft.commons.domain.Accelerator: ...
    def getIds(self) -> java.util.Set[int]: ...
    def isMultiplexed(self) -> bool: ...
    def isResident(self) -> bool: ...

class BeamProcessIncorporationRequest:
    def getDescription(self) -> str: ...
    def getDestBeamProcess(self) -> 'BeamProcess': ...
    def getDestPointInTime(self) -> float: ...
    def getParameters(self) -> java.util.Set['Parameter']: ...
    def getSettingPart(self) -> 'SettingPartEnum': ...
    def getSettingsSource(self) -> 'SettingsSource': ...
    def getSourceBeamProcess(self) -> 'BeamProcess': ...
    def getSourcePointInTime(self) -> float: ...
    def shouldDrive(self) -> bool: ...
    def shouldIncorporateAllParameters(self) -> bool: ...

class BeamProcessIntersection:
    def getBeamProcess(self) -> 'BeamProcess': ...
    def getIntersectionCoordinate(self) -> float: ...

class CompositeContextSettings:
    def getContextSettings(self) -> 'ContextSettings': ...
    def getNonMultiplexedSettings(self) -> 'ContextSettings': ...
    def getParameters(self) -> java.util.Set['Parameter']: ...
    def getValue(self, drivableContext: 'DrivableContext', string: str) -> cern.accsoft.commons.value.ImmutableValue: ...

class Context(cern.lsa.domain.commons.IdentifiedEntity, cern.accsoft.commons.util.Named, java.lang.Comparable['Context']):
    def getAccelerator(self) -> cern.accsoft.commons.domain.Accelerator: ...
    def getContextFamily(self) -> 'ContextFamily': ...
    def getCreationDate(self) -> java.util.Date: ...
    def getCreatorName(self) -> str: ...
    def getDescription(self) -> str: ...
    def getLength(self) -> int: ...
    def getModificationDate(self) -> java.util.Date: ...
    def getModifierName(self) -> str: ...
    def getParent(self) -> 'Context': ...
    def getTypeName(self) -> str: ...
    def isMultiplexed(self) -> bool: ...
    def isStandAlone(self) -> bool: ...

class ContextCategory(cern.accsoft.commons.util.Named):
    def isArchived(self) -> bool: ...

class ContextFamily(java.lang.Enum['ContextFamily']):
    CYCLE: _py_ClassVar['ContextFamily'] = ...
    BEAMPROCESS: _py_ClassVar['ContextFamily'] = ...
    BEAM_PRODUCTION_CHAIN: _py_ClassVar['ContextFamily'] = ...
    PATTERN: _py_ClassVar['ContextFamily'] = ...
    @classmethod
    def getContextFamily(cls, string: str) -> 'ContextFamily': ...
    def getDisplayName(self) -> str: ...
    def getShortName(self) -> str: ...
    @classmethod
    @overload
    def valueOf(cls, string: str) -> 'ContextFamily': ...
    _valueOf_1__T = _py_TypeVar('_valueOf_1__T', bound=java.lang.Enum)  # <T>
    @classmethod
    @overload
    def valueOf(cls, class_: _py_Type[_valueOf_1__T], string: str) -> _valueOf_1__T: ...
    @classmethod
    def values(cls) -> _py_List['ContextFamily']: ...

class ContextIntersections:
    def getCycleBeamProcessIntersections(self) -> java.util.SortedSet['CycleBeamProcessIntersection']: ...

class ContextOptics:
    def __init__(self, standAloneContext: 'StandAloneContext', collection: java.util.Collection[cern.lsa.domain.optics.OpticsTable]): ...
    def getActiveOpticName(self, particleTransfer: cern.accsoft.commons.domain.particletransfers.ParticleTransfer, int: int) -> str: ...
    def getBeamProcessOpticsTable(self, beamProcess: 'BeamProcess') -> cern.lsa.domain.optics.OpticsTable: ...
    def getContext(self) -> 'StandAloneContext': ...
    def getContextName(self) -> str: ...

class ContextSettings:
    def addAll(self, contextSettings: 'ContextSettings') -> None: ...
    def getContext(self) -> 'StandAloneContext': ...
    def getCurrentBeamProcesses(self) -> java.util.Set['BeamProcess']: ...
    @overload
    def getCurrentSetting(self, beamProcess: 'BeamProcess', parameter: 'Parameter') -> 'Setting': ...
    @overload
    def getCurrentSetting(self, beamProcess: 'BeamProcess', string: str) -> 'Setting': ...
    def getCurrentSettings(self) -> java.util.Set['Setting']: ...
    @overload
    def getParameterSettings(self, parameter: 'Parameter') -> 'ParameterSettings': ...
    @overload
    def getParameterSettings(self, string: str) -> 'ParameterSettings': ...
    def getParameters(self) -> java.util.Set['Parameter']: ...
    @overload
    def getSetting(self, beamProcess: 'BeamProcess', parameter: 'Parameter') -> 'Setting': ...
    @overload
    def getSetting(self, beamProcess: 'BeamProcess', string: str) -> 'Setting': ...
    def getSettings(self) -> java.util.Set['Setting']: ...
    def getUpdatedBeamProcesses(self) -> java.util.Set['BeamProcess']: ...
    def getUpdatedParameters(self) -> java.util.Set['Parameter']: ...
    @overload
    def getUpdatedSetting(self, beamProcess: 'BeamProcess', parameter: 'Parameter') -> 'Setting': ...
    @overload
    def getUpdatedSetting(self, beamProcess: 'BeamProcess', string: str) -> 'Setting': ...
    def getUpdatedSettings(self) -> java.util.Set['Setting']: ...
    def isEmpty(self) -> bool: ...
    @overload
    def isUpdated(self, beamProcess: 'BeamProcess', parameter: 'Parameter') -> bool: ...
    @overload
    def isUpdated(self, beamProcess: 'BeamProcess', string: str) -> bool: ...
    @overload
    def isUpdated(self, parameter: 'Parameter') -> bool: ...
    @overload
    def isUpdated(self, string: str) -> bool: ...
    def round(self) -> None: ...
    def size(self) -> int: ...
    @overload
    def updateSetting(self, beamProcess: 'BeamProcess', parameter: 'Parameter', immutableValue: cern.accsoft.commons.value.ImmutableValue, settingPartEnum: 'SettingPartEnum') -> None: ...
    @overload
    def updateSetting(self, beamProcess: 'BeamProcess', string: str, immutableValue: cern.accsoft.commons.value.ImmutableValue, settingPartEnum: 'SettingPartEnum') -> None: ...

class ContextSettingsRequest(java.io.Serializable):
    @classmethod
    def builder(cls) -> 'ContextSettingsRequestBuilder': ...
    @classmethod
    def byStandAloneContext(cls, standAloneContext: 'StandAloneContext') -> 'ContextSettingsRequest': ...
    @classmethod
    def byStandAloneContextAndAtInstant(cls, standAloneContext: 'StandAloneContext', instant: java.time.Instant) -> 'ContextSettingsRequest': ...
    @classmethod
    def byStandAloneContextAndParameters(cls, standAloneContext: 'StandAloneContext', collection: java.util.Collection['Parameter']) -> 'ContextSettingsRequest': ...
    def getAtTimestamp(self) -> java.time.Instant: ...
    def getContext(self) -> 'StandAloneContext': ...
    def getParameters(self) -> java.util.Collection['Parameter']: ...

class ContextSettingsRequestBuilder:
    def __init__(self): ...
    def at(self, instant: java.time.Instant) -> 'ContextSettingsRequestBuilder': ...
    def build(self) -> ContextSettingsRequest: ...
    @classmethod
    def byStandAloneContext(cls, standAloneContext: 'StandAloneContext') -> ContextSettingsRequest: ...
    @classmethod
    def byStandAloneContextAndAtInstant(cls, standAloneContext: 'StandAloneContext', instant: java.time.Instant) -> ContextSettingsRequest: ...
    @classmethod
    def byStandAloneContextAndParameters(cls, standAloneContext: 'StandAloneContext', collection: java.util.Collection['Parameter']) -> ContextSettingsRequest: ...
    def parameters(self, collection: java.util.Collection['Parameter']) -> 'ContextSettingsRequestBuilder': ...
    def standAloneContext(self, standAloneContext: 'StandAloneContext') -> 'ContextSettingsRequestBuilder': ...

class ContextTypeFilter(cern.accsoft.commons.util.Filters.Filter[cern.lsa.domain.settings.type.ContextType]):
    def __init__(self): ...
    @overload
    def accepts(self, contextType: cern.lsa.domain.settings.type.ContextType) -> bool: ...
    @overload
    def accepts(self, object: _py_Any) -> bool: ...
    @classmethod
    def categoryIn(cls, collection: java.util.Collection[ContextCategory]) -> 'ContextTypeFilter': ...
    def setCategories(self, collection: java.util.Collection[ContextCategory]) -> 'ContextTypeFilter': ...

class ContextTypes:
    CATEGORIES: _py_ClassVar[cern.accsoft.commons.util.Mappers.Mapper] = ...
    def __init__(self): ...
    _getCategories__T = _py_TypeVar('_getCategories__T', bound=cern.lsa.domain.settings.type.ContextType)  # <T>
    @classmethod
    def getCategories(cls, collection: java.util.Collection[_getCategories__T]) -> java.util.Set[ContextCategory]: ...

class Contexts:
    PARTICLE_TRANSFERS: _py_ClassVar[cern.accsoft.commons.util.Mappers.Mapper] = ...
    CATEGORIES: _py_ClassVar[cern.accsoft.commons.util.Mappers.Mapper] = ...
    SUBCONTEXT_START_TIME_COMPARATOR: _py_ClassVar[java.util.Comparator] = ...
    @classmethod
    def areResident(cls, collection: java.util.Collection['DrivableContext']) -> bool: ...
    @classmethod
    def assertContextIsNonArchived(cls, standAloneContext: 'StandAloneContext') -> None: ...
    @classmethod
    def assertContextsAreNonArchived(cls, collection: java.util.Collection['StandAloneContext']) -> None: ...
    @classmethod
    def assertContextsBelongToSameStandAloneContext(cls, collection: java.util.Collection[Context]) -> None: ...
    @classmethod
    def belongSameStandAloneContext(cls, collection: java.util.Collection[Context]) -> bool: ...
    @classmethod
    def canBecomeResident(cls, standAloneBeamProcess: 'StandAloneBeamProcess', hyperCycle: 'HyperCycle') -> bool: ...
    @classmethod
    def cloneStandAloneContext(cls, standAloneContext: 'StandAloneContext') -> 'StandAloneContext': ...
    @classmethod
    def contains(cls, context: Context, int: int) -> bool: ...
    @classmethod
    def containsSegmentWithName(cls, beamProcessType: cern.lsa.domain.settings.type.BeamProcessType, string: str) -> bool: ...
    @classmethod
    def createActualBeamProcessName(cls, beamProcess: 'BeamProcess', int: int) -> str: ...
    @classmethod
    @overload
    def filterBeamProcesses(cls, standAloneContext: 'StandAloneContext', particleTransfer: cern.accsoft.commons.domain.particletransfers.ParticleTransfer, beamProcessTypeCategoryArray: _py_List[cern.lsa.domain.settings.type.BeamProcessTypeCategory]) -> java.util.List['BeamProcess']: ...
    @classmethod
    @overload
    def filterBeamProcesses(cls, standAloneContext: 'StandAloneContext', particleTransfer: cern.accsoft.commons.domain.particletransfers.ParticleTransfer, collection: java.util.Collection[cern.lsa.domain.settings.type.BeamProcessTypeCategory]) -> java.util.List['BeamProcess']: ...
    _filterBeamProcesses_2__T = _py_TypeVar('_filterBeamProcesses_2__T', bound='BeamProcess')  # <T>
    @classmethod
    @overload
    def filterBeamProcesses(cls, collection: java.util.Collection[_filterBeamProcesses_2__T], particleTransfer: cern.accsoft.commons.domain.particletransfers.ParticleTransfer, beamProcessTypeCategoryArray: _py_List[cern.lsa.domain.settings.type.BeamProcessTypeCategory]) -> java.util.List[_filterBeamProcesses_2__T]: ...
    _filterBeamProcesses_3__T = _py_TypeVar('_filterBeamProcesses_3__T', bound='BeamProcess')  # <T>
    @classmethod
    @overload
    def filterBeamProcesses(cls, collection: java.util.Collection[_filterBeamProcesses_3__T], particleTransfer: cern.accsoft.commons.domain.particletransfers.ParticleTransfer, collection2: java.util.Collection[cern.lsa.domain.settings.type.BeamProcessTypeCategory]) -> java.util.List[_filterBeamProcesses_3__T]: ...
    _filterBeamProcessesByParticleTransfers__T = _py_TypeVar('_filterBeamProcessesByParticleTransfers__T', bound='BeamProcess')  # <T>
    @classmethod
    def filterBeamProcessesByParticleTransfers(cls, collection: java.util.Collection[_filterBeamProcessesByParticleTransfers__T], collection2: java.util.Collection[cern.accsoft.commons.domain.particletransfers.ParticleTransfer]) -> java.util.List[_filterBeamProcessesByParticleTransfers__T]: ...
    _filterByCategories__T = _py_TypeVar('_filterByCategories__T', bound='StandAloneContext')  # <T>
    @classmethod
    def filterByCategories(cls, collection: java.util.Collection[_filterByCategories__T], contextCategoryArray: _py_List[ContextCategory]) -> java.util.List[_filterByCategories__T]: ...
    _filterByMultiplexingCriteria__T = _py_TypeVar('_filterByMultiplexingCriteria__T', bound='StandAloneContext')  # <T>
    @classmethod
    def filterByMultiplexingCriteria(cls, collection: java.util.Collection[_filterByMultiplexingCriteria__T], boolean: bool) -> java.util.List[_filterByMultiplexingCriteria__T]: ...
    _filterCompatibleBeamProcesses__T = _py_TypeVar('_filterCompatibleBeamProcesses__T', bound='BeamProcess')  # <T>
    @classmethod
    def filterCompatibleBeamProcesses(cls, collection: java.util.Collection[_filterCompatibleBeamProcesses__T], parameter: 'Parameter') -> java.util.List[_filterCompatibleBeamProcesses__T]: ...
    _filterDrivableContextsByUsers__T = _py_TypeVar('_filterDrivableContextsByUsers__T', bound='DrivableContext')  # <T>
    @classmethod
    def filterDrivableContextsByUsers(cls, collection: java.util.Collection[_filterDrivableContextsByUsers__T], collection2: java.util.Collection[str]) -> java.util.Set[_filterDrivableContextsByUsers__T]: ...
    @classmethod
    def filterFunctionBeamProcesses(cls, standAloneContext: 'StandAloneContext', particleTransfer: cern.accsoft.commons.domain.particletransfers.ParticleTransfer) -> java.util.List['BeamProcess']: ...
    _filterResidentContexts__T = _py_TypeVar('_filterResidentContexts__T', bound='StandAloneContext')  # <T>
    @classmethod
    def filterResidentContexts(cls, collection: java.util.Collection[_filterResidentContexts__T], boolean: bool) -> java.util.List[_filterResidentContexts__T]: ...
    _filterStandAloneContextsByClass__T = _py_TypeVar('_filterStandAloneContextsByClass__T', bound='StandAloneContext')  # <T>
    @classmethod
    def filterStandAloneContextsByClass(cls, collection: java.util.Collection['StandAloneContext'], class_: _py_Type[_filterStandAloneContextsByClass__T]) -> java.util.Set['StandAloneContext']: ...
    @classmethod
    def getBeamProcessTypeCategories(cls, collection: java.util.Collection['BeamProcess']) -> java.util.Set[cern.lsa.domain.settings.type.BeamProcessTypeCategory]: ...
    @classmethod
    @overload
    def getBeamProcesses(cls, standAloneContext: 'StandAloneContext', collection: java.util.Collection['SubContext']) -> java.util.List['BeamProcess']: ...
    @classmethod
    @overload
    def getBeamProcesses(cls, collection: java.util.Collection['DrivableContext']) -> java.util.List['BeamProcess']: ...
    @classmethod
    def getBeamProcessesAt(cls, standAloneContext: 'StandAloneContext', collection: java.util.Collection[cern.accsoft.commons.domain.particletransfers.ParticleTransfer], double: float) -> java.util.List['BeamProcess']: ...
    _getCategories__T = _py_TypeVar('_getCategories__T', bound='StandAloneContext')  # <T>
    @classmethod
    def getCategories(cls, collection: java.util.Collection[_getCategories__T]) -> java.util.Set[ContextCategory]: ...
    @classmethod
    def getCompatibleBeamProcess(cls, standAloneContext: 'StandAloneContext', parameter: 'Parameter') -> 'BeamProcess': ...
    @classmethod
    def getCompatibleBeamProcesses(cls, standAloneContext: 'StandAloneContext', parameter: 'Parameter') -> java.util.Set['BeamProcess']: ...
    @classmethod
    def getCorrespondingBeamProcess(cls, beamProcess: 'BeamProcess', parameter: 'Parameter') -> 'BeamProcess': ...
    @classmethod
    def getCorrespondingBeamProcesses(cls, beamProcess: 'BeamProcess', parameter: 'Parameter') -> java.util.List['BeamProcess']: ...
    @classmethod
    def getCycle(cls, beamProcess: 'BeamProcess') -> 'Cycle': ...
    @classmethod
    def getDrivableContext(cls, context: Context) -> 'DrivableContext': ...
    @classmethod
    @overload
    def getDrivableContextByUser(cls, standAloneContext: 'StandAloneContext', string: str) -> 'DrivableContext': ...
    @classmethod
    @overload
    def getDrivableContextByUser(cls, collection: java.util.Collection['StandAloneContext'], string: str) -> 'DrivableContext': ...
    @classmethod
    @overload
    def getDrivableContexts(cls, context: Context) -> java.util.Set['DrivableContext']: ...
    @classmethod
    @overload
    def getDrivableContexts(cls, collection: java.util.Collection[Context]) -> java.util.Set['DrivableContext']: ...
    @classmethod
    def getDrivableContextsByUsers(cls, collection: java.util.Collection['StandAloneContext'], collection2: java.util.Collection[str]) -> java.util.Set['DrivableContext']: ...
    @classmethod
    def getFollowingBeamProcess(cls, beamProcess: 'BeamProcess') -> 'BeamProcess': ...
    @classmethod
    def getFunctionBeamProcessAt(cls, standAloneContext: 'StandAloneContext', particleTransfer: cern.accsoft.commons.domain.particletransfers.ParticleTransfer, double: float) -> 'BeamProcess': ...
    @classmethod
    @overload
    def getIntersectedBeamProcesses(cls, beamProcess: 'BeamProcess', collection: java.util.Collection[cern.accsoft.commons.domain.particletransfers.ParticleTransfer], beamProcessTypeCategoryArray: _py_List[cern.lsa.domain.settings.type.BeamProcessTypeCategory]) -> java.util.List['BeamProcess']: ...
    @classmethod
    @overload
    def getIntersectedBeamProcesses(cls, context: Context) -> java.util.Set['BeamProcess']: ...
    @classmethod
    @overload
    def getIntersectedBeamProcesses(cls, collection: java.util.Collection[Context]) -> java.util.Set['BeamProcess']: ...
    @classmethod
    def getIntersectedCycles(cls, collection: java.util.Collection['BeamProcess']) -> java.util.Set['Cycle']: ...
    @classmethod
    def getParticleTransfers(cls, collection: java.util.Collection['StandAloneContext']) -> java.util.Set[cern.accsoft.commons.domain.particletransfers.ParticleTransfer]: ...
    @classmethod
    def getParticleTransfersFromBeamProcesses(cls, collection: java.util.Collection['BeamProcess']) -> java.util.Set[cern.accsoft.commons.domain.particletransfers.ParticleTransfer]: ...
    @classmethod
    def getPrecedingBeamProcess(cls, beamProcess: 'BeamProcess') -> 'BeamProcess': ...
    @classmethod
    def getStandAloneContext(cls, context: Context) -> 'StandAloneContext': ...
    @classmethod
    def getStandAloneContexts(cls, collection: java.util.Collection[Context]) -> java.util.Set['StandAloneContext']: ...
    @classmethod
    def getTypeNames(cls, collection: java.util.Collection[Context]) -> java.util.Set[str]: ...
    @classmethod
    def getUsers(cls, standAloneContext: 'StandAloneContext') -> java.util.Set[str]: ...
    @classmethod
    def getUsersForContexts(cls, collection: java.util.Collection[Context]) -> java.util.List[str]: ...
    @classmethod
    def isActual(cls, beamProcess: 'BeamProcess') -> bool: ...
    @classmethod
    def isActualBeamProcess(cls, context: Context) -> bool: ...
    @classmethod
    def isCompatible(cls, beamProcess: 'BeamProcess', parameter: 'Parameter') -> bool: ...
    @classmethod
    def isLastPoint(cls, context: Context, int: int) -> bool: ...
    _sortByStartTime__T = _py_TypeVar('_sortByStartTime__T', bound='SubContext')  # <T>
    @classmethod
    def sortByStartTime(cls, list: java.util.List[_sortByStartTime__T]) -> None: ...

class CycleBeamProcessIntersection:
    def getBeamProcess(self) -> 'BeamProcess': ...
    def getCycle(self) -> 'Cycle': ...
    def getEndInBeamProcess(self) -> int: ...
    def getEndInCycle(self) -> int: ...
    def getParticleTransfer(self) -> cern.accsoft.commons.domain.particletransfers.ParticleTransfer: ...
    def getStartInBeamProcess(self) -> int: ...
    def getStartInCycle(self) -> int: ...

class DevicePropertyParameters:
    def getDeviceClassName(self) -> str: ...
    def getDeviceName(self) -> str: ...
    def getDevicePropertyName(self) -> str: ...
    @overload
    def getFieldNames(self) -> java.util.SortedSet[str]: ...
    @overload
    def getFieldNames(self, boolean: bool) -> java.util.SortedSet[str]: ...
    @overload
    def getParameters(self) -> java.util.SortedSet['Parameter']: ...
    @overload
    def getParameters(self, boolean: bool) -> java.util.SortedSet['Parameter']: ...
    def getPropertyName(self) -> str: ...
    def getSignature(self) -> 'Parameter': ...
    def isCritical(self) -> bool: ...

class ErrorsAwareContextSettings:
    @overload
    def __init__(self, contextSettings: ContextSettings): ...
    @overload
    def __init__(self, contextSettings: ContextSettings, map: java.util.Map['Parameter', java.lang.Exception]): ...
    def getContextSettings(self) -> ContextSettings: ...
    def getParameter2Exception(self) -> java.util.Map['Parameter', java.lang.Exception]: ...

class FailedParametersStatus:
    def containsFailedParameters(self) -> bool: ...
    def getFailedContexts(self) -> java.util.Set[Context]: ...
    def getFailedParameters(self, context: Context) -> java.util.Map[str, java.lang.Exception]: ...

class GenerationException(cern.lsa.domain.LsaException):
    @overload
    def __init__(self, exception: java.lang.Exception): ...
    @overload
    def __init__(self, string: str): ...
    @overload
    def __init__(self, string: str, exception: java.lang.Exception): ...

class HyperCycle(cern.accsoft.commons.util.Named, cern.lsa.domain.commons.IdentifiedEntity, java.lang.Comparable['HyperCycle']):
    def getBeamProcessByUser(self, string: str) -> 'StandAloneBeamProcess': ...
    def getBeamProcessPosition(self, string: str, standAloneBeamProcess: 'StandAloneBeamProcess') -> int: ...
    def getDescription(self) -> str: ...
    def getFirstBeamProcess(self, string: str) -> 'StandAloneBeamProcess': ...
    def getLastBeamProcess(self, string: str) -> 'StandAloneBeamProcess': ...
    def getNextBeamProcess(self, string: str) -> 'StandAloneBeamProcess': ...
    def getPreviousBeamProcess(self, string: str) -> 'StandAloneBeamProcess': ...
    def getResidentBeamProcess(self, string: str) -> 'StandAloneBeamProcess': ...
    def getResidentBeamProcesses(self) -> java.util.Set['StandAloneBeamProcess']: ...
    @overload
    def getScheduledBeamProcesses(self) -> java.util.List['StandAloneBeamProcess']: ...
    @overload
    def getScheduledBeamProcesses(self, string: str) -> java.util.List['StandAloneBeamProcess']: ...
    def getUserCategories(self) -> java.util.SortedSet[str]: ...
    def getUserCategory(self, standAloneBeamProcess: 'StandAloneBeamProcess') -> str: ...
    def getUserForBeamProcess(self, standAloneBeamProcess: 'StandAloneBeamProcess') -> str: ...
    @overload
    def getUsers(self, string: str) -> java.util.List[str]: ...
    @overload
    def getUsers(self) -> java.util.Set[str]: ...
    def isActive(self) -> bool: ...

class HyperCycleMapping:
    @classmethod
    def builder(cls) -> 'DefaultHyperCycleMapping.Builder': ...
    def getBeamProcess(self) -> 'StandAloneBeamProcess': ...
    def getUser(self) -> AcceleratorUser: ...

class IncorporationRanges:
    def __init__(self): ...
    @classmethod
    def assertRangesConsistentWithBeamProcessType(cls, list: java.util.List[cern.lsa.domain.settings.type.IncorporationRange], beamProcessType: cern.lsa.domain.settings.type.BeamProcessType) -> None: ...
    @classmethod
    def ensureConsistentRanges(cls, collection: java.util.Collection[cern.lsa.domain.settings.type.IncorporationRange]) -> None: ...

class IncorporationSetting(java.io.Serializable):
    def __init__(self, setting: 'Setting', double: float): ...
    def equals(self, object: _py_Any) -> bool: ...
    def getPointInTime(self) -> float: ...
    def getSetting(self) -> 'Setting': ...
    def hashCode(self) -> int: ...

class Intersections:
    TOLERANCE: _py_ClassVar[float] = ...
    ERROR_MESSAGE_DISCONTINUITY: _py_ClassVar[str] = ...
    @classmethod
    @overload
    def computeBeamProcessFunction(cls, standAloneContext: 'StandAloneContext', beamProcess: 'BeamProcess', immutableDiscreteFunction: cern.accsoft.commons.value.ImmutableDiscreteFunction) -> cern.accsoft.commons.value.DiscreteFunction: ...
    @classmethod
    @overload
    def computeBeamProcessFunction(cls, standAloneContext: 'StandAloneContext', beamProcess: 'BeamProcess', immutableDiscreteFunctionsArray: cern.accsoft.commons.value.ImmutableDiscreteFunctionsArray) -> cern.accsoft.commons.value.DiscreteFunctionsArray: ...
    @classmethod
    @overload
    def concatenateFunctions(cls, discreteFunction: cern.accsoft.commons.value.DiscreteFunction, discreteFunction2: cern.accsoft.commons.value.DiscreteFunction, double: float) -> None: ...
    @classmethod
    @overload
    def concatenateFunctions(cls, discreteFunctionsArray: cern.accsoft.commons.value.DiscreteFunctionsArray, discreteFunctionsArray2: cern.accsoft.commons.value.DiscreteFunctionsArray, double: float) -> None: ...
    @classmethod
    def getCycleBeamProcessIntersections(cls, standAloneContext: 'StandAloneContext') -> java.util.SortedSet[CycleBeamProcessIntersection]: ...
    @classmethod
    def getPrecedingBeamProcess(cls, standAloneContext: 'StandAloneContext', beamProcess: 'BeamProcess') -> 'BeamProcess': ...
    @classmethod
    @overload
    def insertNaN(cls, discreteFunction: cern.accsoft.commons.value.DiscreteFunction, discreteFunction2: cern.accsoft.commons.value.DiscreteFunction, int: int) -> None: ...
    @classmethod
    @overload
    def insertNaN(cls, discreteFunction: cern.accsoft.commons.value.DiscreteFunction, discreteFunction2: cern.accsoft.commons.value.DiscreteFunction, int: int, int2: int) -> None: ...
    @classmethod
    @overload
    def insertNaN(cls, discreteFunction: cern.accsoft.commons.value.DiscreteFunction, double: float, double2: float) -> None: ...
    @classmethod
    @overload
    def mergeFunctions(cls, discreteFunction: cern.accsoft.commons.value.DiscreteFunction, immutableDiscreteFunction: cern.accsoft.commons.value.ImmutableDiscreteFunction) -> None: ...
    @classmethod
    @overload
    def mergeFunctions(cls, discreteFunctionsArray: cern.accsoft.commons.value.DiscreteFunctionsArray, discreteFunctionsArray2: cern.accsoft.commons.value.DiscreteFunctionsArray) -> None: ...
    @classmethod
    def mutateSettingPart(cls, setting: 'Setting', settingPartEnum: 'SettingPartEnum') -> cern.accsoft.commons.value.DiscreteFunction: ...
    @classmethod
    def toBeamProcessFunctionsArrayMap(cls, standAloneContext: 'StandAloneContext', collection: java.util.Collection[cern.accsoft.commons.domain.particletransfers.ParticleTransfer], immutableDiscreteFunctionsArray: cern.accsoft.commons.value.ImmutableDiscreteFunctionsArray) -> java.util.Map['BeamProcess', cern.accsoft.commons.value.ImmutableDiscreteFunctionsArray]: ...
    @classmethod
    def toBeamProcessFunctionsMap(cls, standAloneContext: 'StandAloneContext', collection: java.util.Collection[cern.accsoft.commons.domain.particletransfers.ParticleTransfer], immutableDiscreteFunction: cern.accsoft.commons.value.ImmutableDiscreteFunction) -> java.util.Map['BeamProcess', cern.accsoft.commons.value.ImmutableDiscreteFunction]: ...
    @classmethod
    def updateFunctionSetting(cls, standAloneContext: 'StandAloneContext', parameterSettings: 'ParameterSettings', immutableDiscreteFunction: cern.accsoft.commons.value.ImmutableDiscreteFunction, settingPartEnum: 'SettingPartEnum') -> None: ...

class KnobFactor(java.io.Serializable):
    def __init__(self, string: str, string2: str, double: float): ...
    def equals(self, object: _py_Any) -> bool: ...
    def getComponentName(self) -> str: ...
    def getFactor(self) -> float: ...
    def getOpticName(self) -> str: ...
    def hashCode(self) -> int: ...
    def toString(self) -> str: ...

class KnobFactors:
    def containsFactor(self, string: str, string2: str) -> bool: ...
    def getComponentNames(self) -> java.util.Set[str]: ...
    def getFactor(self, string: str, string2: str) -> float: ...
    def getFactors(self) -> java.util.Set[KnobFactor]: ...
    def getFactorsForComponent(self, string: str) -> java.util.Set[KnobFactor]: ...
    def getFactorsForOptic(self, string: str) -> java.util.Set[KnobFactor]: ...
    def getOpticNames(self) -> java.util.Set[str]: ...

class LinkRuleAttribute(java.lang.Enum['LinkRuleAttribute']):
    START_VALUE: _py_ClassVar['LinkRuleAttribute'] = ...
    STOP_VALUE: _py_ClassVar['LinkRuleAttribute'] = ...
    START_DELAY: _py_ClassVar['LinkRuleAttribute'] = ...
    STOP_DELAY: _py_ClassVar['LinkRuleAttribute'] = ...
    DEGAUSS_VALUE: _py_ClassVar['LinkRuleAttribute'] = ...
    START_ROUND: _py_ClassVar['LinkRuleAttribute'] = ...
    STOP_ROUND: _py_ClassVar['LinkRuleAttribute'] = ...
    RAMP_SPEED: _py_ClassVar['LinkRuleAttribute'] = ...
    TIME_UNIT: _py_ClassVar['LinkRuleAttribute'] = ...
    POINT_DIST: _py_ClassVar['LinkRuleAttribute'] = ...
    BTOM_AS_PERCENT_IMAX: _py_ClassVar['LinkRuleAttribute'] = ...
    KEEP_SIGN: _py_ClassVar['LinkRuleAttribute'] = ...
    LEIR_ETL_BHN10_MIN_PLATEAU_LENGTH: _py_ClassVar['LinkRuleAttribute'] = ...
    LEIR_ETL_BHN10_MIN_PLATEAU_I: _py_ClassVar['LinkRuleAttribute'] = ...
    LEIR_ETL_BHN10_MIN_STABILIZATION_LENGTH: _py_ClassVar['LinkRuleAttribute'] = ...
    LEIR_ETL_BHN10_START_END_CYCLE_I: _py_ClassVar['LinkRuleAttribute'] = ...
    def getAttributeName(self) -> str: ...
    @classmethod
    @overload
    def valueOf(cls, string: str) -> 'LinkRuleAttribute': ...
    _valueOf_1__T = _py_TypeVar('_valueOf_1__T', bound=java.lang.Enum)  # <T>
    @classmethod
    @overload
    def valueOf(cls, class_: _py_Type[_valueOf_1__T], string: str) -> _valueOf_1__T: ...
    @classmethod
    def values(cls) -> _py_List['LinkRuleAttribute']: ...

class MisconfiguredParameterException(cern.lsa.domain.LsaException):
    def __init__(self, parameter: 'Parameter', drivableContext: 'DrivableContext'): ...

class NotIncorporatedParameters:
    def getNonCountinueParameters(self) -> java.util.Set[str]: ...
    def getParametersWithSettingsOnlyInFirstContext(self) -> java.util.Set[str]: ...

class Parameter(cern.accsoft.commons.util.Named, cern.lsa.domain.commons.IdentifiedEntity, java.lang.Comparable['Parameter']):
    def belongsToFunctionBeamProcess(self) -> bool: ...
    def getAccelerator(self) -> cern.accsoft.commons.domain.Accelerator: ...
    def getDefaultHierarchy(self) -> str: ...
    def getDevice(self) -> cern.lsa.domain.devices.Device: ...
    def getParameterGroups(self) -> java.util.Set[str]: ...
    def getParameterType(self) -> 'ParameterType': ...
    def getParticleTransfers(self) -> java.util.Set[cern.accsoft.commons.domain.particletransfers.ParticleTransfer]: ...
    def getPropertyField(self) -> cern.lsa.domain.devices.type.PropertyField: ...
    def getValueDescriptor(self) -> cern.accsoft.commons.value.ValueDescriptor: ...
    def getValueType(self) -> cern.accsoft.commons.value.Type: ...
    def isCritical(self) -> bool: ...
    def isCycleBound(self) -> bool: ...
    def isMonitorable(self) -> bool: ...
    def isMultiplexed(self) -> bool: ...
    def isPropertySupportingPartialSet(self) -> bool: ...
    def isReadable(self) -> bool: ...
    def isReservedForOpExperts(self) -> bool: ...
    def isTrimable(self) -> bool: ...
    def isVirtual(self) -> bool: ...
    def isWritable(self) -> bool: ...

class ParameterAttributes(cern.accsoft.commons.util.Named, java.io.Serializable):
    def getAbsoluteTolerance(self) -> float: ...
    def getDefaultHierarchy(self) -> str: ...
    def getDevice(self) -> cern.lsa.domain.devices.Device: ...
    def getMaxValue(self) -> float: ...
    def getMinValue(self) -> float: ...
    def getParameterId(self) -> int: ...
    def getParameterName(self) -> str: ...
    def getParameterType(self) -> 'ParameterType': ...
    def getPropertyField(self) -> cern.lsa.domain.devices.type.PropertyField: ...
    def getRelativeTolerance(self) -> float: ...
    def getXPrecision(self) -> int: ...
    def getYPrecision(self) -> int: ...
    def isBelongsToFunctionBProc(self) -> bool: ...
    def isReservedForOpExperts(self) -> bool: ...
    def isTrimable(self) -> bool: ...
    def setAbsoluteTolerance(self, double: float) -> None: ...
    def setBelongsToFunctionBProc(self, boolean: bool) -> None: ...
    def setDefaultHierarchy(self, string: str) -> None: ...
    def setMaxValue(self, double: float) -> None: ...
    def setMinValue(self, double: float) -> None: ...
    def setParameterId(self, long: int) -> None: ...
    def setParameterName(self, string: str) -> None: ...
    def setRelativeTolerance(self, double: float) -> None: ...
    def setReservedForOpExperts(self, boolean: bool) -> None: ...
    def setTrimable(self, boolean: bool) -> None: ...
    def setXPrecision(self, integer: int) -> None: ...
    def setYPrecision(self, integer: int) -> None: ...

class ParameterFilters: ...

class ParameterForEditing(cern.accsoft.commons.util.Named, java.io.Serializable):
    def __init__(self, parameter: Parameter, parameterAttributes: ParameterAttributes): ...
    def equals(self, object: _py_Any) -> bool: ...
    def getName(self) -> str: ...
    def getParameter(self) -> Parameter: ...
    def getParameterAttributes(self) -> ParameterAttributes: ...
    def hashCode(self) -> int: ...

class ParameterGroup(cern.accsoft.commons.util.Named, cern.lsa.domain.commons.IdentifiedEntity):
    def getAccelerator(self) -> cern.accsoft.commons.domain.Accelerator: ...
    def getCreateDate(self) -> java.util.Date: ...
    def getCreator(self) -> str: ...
    def getDescription(self) -> str: ...

class ParameterNotFoundException(java.lang.RuntimeException):
    @overload
    def __init__(self, string: str): ...
    @overload
    def __init__(self, string: str, throwable: java.lang.Throwable): ...
    @overload
    def __init__(self, throwable: java.lang.Throwable, collection: java.util.Collection[str]): ...
    @overload
    def __init__(self, collection: java.util.Collection[str]): ...
    def getParameterNames(self) -> java.util.SortedSet[str]: ...

class ParameterSettings:
    def getCurrentBeamProcesses(self) -> java.util.Set['BeamProcess']: ...
    def getCurrentSetting(self, beamProcess: 'BeamProcess') -> 'Setting': ...
    def getCurrentSettings(self) -> java.util.Set['Setting']: ...
    def getParameter(self) -> Parameter: ...
    def getParticleTransfers(self) -> java.util.Set[cern.accsoft.commons.domain.particletransfers.ParticleTransfer]: ...
    def getSetting(self, beamProcess: 'BeamProcess') -> 'Setting': ...
    def getSettings(self) -> java.util.Set['Setting']: ...
    def getUpdatedBeamProcesses(self) -> java.util.Set['BeamProcess']: ...
    def getUpdatedSetting(self, beamProcess: 'BeamProcess') -> 'Setting': ...
    def getUpdatedSettings(self) -> java.util.Set['Setting']: ...
    def getValueType(self) -> cern.accsoft.commons.value.Type: ...
    def isEmpty(self) -> bool: ...
    @overload
    def isUpdated(self) -> bool: ...
    @overload
    def isUpdated(self, beamProcess: 'BeamProcess') -> bool: ...
    def round(self) -> None: ...
    def size(self) -> int: ...
    @overload
    def updateSetting(self, beamProcess: 'BeamProcess', immutableValue: cern.accsoft.commons.value.ImmutableValue, settingPartEnum: 'SettingPartEnum') -> None: ...
    @overload
    def updateSetting(self, beamProcess: 'BeamProcess', setting: 'Setting') -> None: ...

class ParameterTreeNode(cern.accsoft.commons.util.Named):
    def findNode(self, string: str) -> 'ParameterTreeNode': ...
    def getAllChildren(self) -> java.util.List['ParameterTreeNode']: ...
    def getAllParents(self) -> java.util.List['ParameterTreeNode']: ...
    def getChildren(self) -> java.util.List['ParameterTreeNode']: ...
    @overload
    def getNodes(self) -> java.util.List['ParameterTreeNode']: ...
    @overload
    def getNodes(self, boolean: bool) -> java.util.List['ParameterTreeNode']: ...
    def getParameter(self) -> Parameter: ...
    def getParameters(self) -> java.util.List[Parameter]: ...
    def getParametersFromThisNodeAndAllChildren(self) -> java.util.List[Parameter]: ...
    def getParametersFromThisNodeAndAllParents(self) -> java.util.List[Parameter]: ...
    def getParents(self) -> java.util.List['ParameterTreeNode']: ...
    def getThisNodeAndAllChildren(self) -> java.util.List['ParameterTreeNode']: ...
    def getThisNodeAndAllParents(self) -> java.util.List['ParameterTreeNode']: ...
    def isLeaf(self) -> bool: ...
    def isRoot(self) -> bool: ...
    def isSource(self) -> bool: ...

class ParameterTreesRequest:
    @classmethod
    def builder(cls) -> cern.lsa.domain.settings.factory.ParameterTreesRequestBuilder: ...
    def getHierarchy(self) -> str: ...
    def getParameterNames(self) -> java.util.Set[str]: ...
    def getParameters(self) -> java.util.Set[Parameter]: ...
    def getTreeDirection(self) -> 'ParameterTreesRequest.TreeDirection': ...
    class TreeDirection(java.lang.Enum['ParameterTreesRequest.TreeDirection']):
        SOURCE_TREE: _py_ClassVar['ParameterTreesRequest.TreeDirection'] = ...
        DEPENDENT_TREE: _py_ClassVar['ParameterTreesRequest.TreeDirection'] = ...
        @classmethod
        @overload
        def valueOf(cls, string: str) -> 'ParameterTreesRequest.TreeDirection': ...
        _valueOf_1__T = _py_TypeVar('_valueOf_1__T', bound=java.lang.Enum)  # <T>
        @classmethod
        @overload
        def valueOf(cls, class_: _py_Type[_valueOf_1__T], string: str) -> _valueOf_1__T: ...
        @classmethod
        def values(cls) -> _py_List['ParameterTreesRequest.TreeDirection']: ...

class ParameterType(cern.accsoft.commons.util.Named, cern.lsa.domain.commons.IdentifiedEntity, java.lang.Comparable['ParameterType']):
    def getCategory(self) -> 'ParameterTypeCategory': ...
    def isLinkRuleApplicable(self) -> bool: ...

class ParameterTypeCategory(java.lang.Enum['ParameterTypeCategory']):
    PHYSICS: _py_ClassVar['ParameterTypeCategory'] = ...
    HW_MAGNITUDE: _py_ClassVar['ParameterTypeCategory'] = ...
    HW_SETTINGS: _py_ClassVar['ParameterTypeCategory'] = ...
    HW_REFERENCE: _py_ClassVar['ParameterTypeCategory'] = ...
    def getCategoryOrder(self) -> int: ...
    @classmethod
    @overload
    def valueOf(cls, string: str) -> 'ParameterTypeCategory': ...
    _valueOf_1__T = _py_TypeVar('_valueOf_1__T', bound=java.lang.Enum)  # <T>
    @classmethod
    @overload
    def valueOf(cls, class_: _py_Type[_valueOf_1__T], string: str) -> _valueOf_1__T: ...
    @classmethod
    def values(cls) -> _py_List['ParameterTypeCategory']: ...

class ParameterTypeGroup(cern.accsoft.commons.util.Named):
    def getParameterTypes(self) -> java.util.Set[ParameterType]: ...

class ParameterTypes:
    PARAMETERS_WITH_META_DATA: _py_ClassVar[cern.accsoft.commons.util.Filters.Filter] = ...
    def __init__(self): ...
    @classmethod
    def createParameterType(cls, deviceTypeVersion: cern.lsa.domain.devices.DeviceTypeVersion, string: str, collection: java.util.Collection[str], collection2: java.util.Collection[cern.lsa.domain.devices.type.PropertyVersion]) -> java.util.List[ParameterType]: ...
    @classmethod
    def generateParameterTypeName(cls, string: str, string2: str, string3: str) -> str: ...

class ParameterTypesRequest:
    @classmethod
    def builder(cls) -> cern.lsa.domain.settings.factory.ParameterTypesRequestBuilder: ...
    def getParameterTypeNames(self) -> java.util.Set[str]: ...
    def isAllParameterTypesRequested(self) -> bool: ...

class Parameters:
    DEFAULT_FIELD_NAME: _py_ClassVar[str] = ...
    DEFAULT_PARAMETER_HIERARCHY: _py_ClassVar[str] = ...
    NOT_SUPPORTING_PARTIAL_SET: _py_ClassVar[cern.accsoft.commons.util.Filters.Filter] = ...
    NON_VIRTUAL: _py_ClassVar[cern.accsoft.commons.util.Filters.Filter] = ...
    VIRTUAL: _py_ClassVar[cern.accsoft.commons.util.Filters.Filter] = ...
    SETTING: _py_ClassVar[cern.accsoft.commons.util.Filters.Filter] = ...
    CRITICAL: _py_ClassVar[cern.accsoft.commons.util.Filters.Filter] = ...
    READABLE: _py_ClassVar[cern.accsoft.commons.util.Filters.Filter] = ...
    WRITABLE: _py_ClassVar[cern.accsoft.commons.util.Filters.Filter] = ...
    MONITORABLE: _py_ClassVar[cern.accsoft.commons.util.Filters.Filter] = ...
    READABLE_AND_WRITABLE: _py_ClassVar[cern.accsoft.commons.util.Filters.Filter] = ...
    NON_MULTIPLEXED: _py_ClassVar[cern.accsoft.commons.util.Filters.Filter] = ...
    FEC_NAME: _py_ClassVar[cern.accsoft.commons.util.Mappers.Mapper] = ...
    FIELD_NAME: _py_ClassVar[cern.accsoft.commons.util.Mappers.Mapper] = ...
    @classmethod
    def assertParametersDefined(cls, collection: java.util.Collection[Parameter], collection2: java.util.Collection[str]) -> None: ...
    @classmethod
    def atLeastOneIsMultiplexed(cls, collection: java.util.Collection[Parameter]) -> bool: ...
    @classmethod
    def atLeastOneIsReadable(cls, collection: java.util.Collection[Parameter]) -> bool: ...
    @classmethod
    def atLeastOneIsWritable(cls, collection: java.util.Collection[Parameter]) -> bool: ...
    @classmethod
    def belongsToParticleTransfer(cls, parameter: Parameter, particleTransfer: cern.accsoft.commons.domain.particletransfers.ParticleTransfer) -> bool: ...
    @classmethod
    def constructParameterName(cls, string: str, string2: str, string3: str) -> str: ...
    @classmethod
    def containsField(cls, string: str) -> bool: ...
    @classmethod
    def deviceIn(cls, collection: java.util.Collection[cern.lsa.domain.devices.Device]) -> cern.accsoft.commons.util.Filters.Filter[Parameter]: ...
    @classmethod
    def deviceNameIn(cls, collection: java.util.Collection[str]) -> cern.accsoft.commons.util.Filters.Filter[Parameter]: ...
    @classmethod
    def deviceTypeNameIn(cls, collection: java.util.Collection[str]) -> cern.accsoft.commons.util.Filters.Filter[Parameter]: ...
    @classmethod
    def extractDefaultHierarchies(cls, collection: java.util.Collection[Parameter]) -> java.util.Set[str]: ...
    @classmethod
    def extractDeviceName(cls, string: str) -> str: ...
    @classmethod
    def extractDeviceNames(cls, collection: java.util.Collection[str]) -> java.util.Set[str]: ...
    @classmethod
    def extractParameterName(cls, string: str) -> str: ...
    @classmethod
    def extractParameterNames(cls, collection: java.util.Collection[str]) -> java.util.Set[str]: ...
    @classmethod
    def extractPropertyField(cls, string: str) -> str: ...
    @classmethod
    def extractPropertyName(cls, string: str) -> str: ...
    @classmethod
    def extractPropertyNames(cls, collection: java.util.Collection[str]) -> java.util.Set[str]: ...
    @classmethod
    def filterCriticalParameters(cls, collection: java.util.Collection[Parameter]) -> java.util.Set[Parameter]: ...
    @classmethod
    def filterLeafNodes(cls, collection: java.util.Collection[ParameterTreeNode]) -> java.util.Set[ParameterTreeNode]: ...
    @classmethod
    def filterMonitorableParameters(cls, collection: java.util.Collection[Parameter]) -> java.util.Set[Parameter]: ...
    @classmethod
    def filterNonSignatureParameters(cls, collection: java.util.Collection[Parameter]) -> java.util.Set[Parameter]: ...
    @classmethod
    def filterNonVirtualParameters(cls, collection: java.util.Collection[Parameter]) -> java.util.Set[Parameter]: ...
    @classmethod
    def filterParametersByAccessMode(cls, collection: java.util.Collection[Parameter], collection2: java.util.Collection['PropertyAccessMode']) -> java.util.Set[Parameter]: ...
    @classmethod
    def filterParametersByDeviceNames(cls, collection: java.util.Collection[Parameter], collection2: java.util.Collection[str]) -> java.util.Set[Parameter]: ...
    @classmethod
    def filterParametersByDeviceProperties(cls, set: java.util.Set[Parameter], set2: java.util.Set[str]) -> java.util.Set[Parameter]: ...
    @classmethod
    def filterParametersByDeviceTypeNames(cls, collection: java.util.Collection[Parameter], collection2: java.util.Collection[str]) -> java.util.Set[Parameter]: ...
    @classmethod
    def filterParametersByDevices(cls, collection: java.util.Collection[Parameter], collection2: java.util.Collection[cern.lsa.domain.devices.Device]) -> java.util.Set[Parameter]: ...
    @classmethod
    def filterParametersByImplementation(cls, collection: java.util.Collection[Parameter], collection2: java.util.Collection[cern.lsa.domain.devices.DeviceTypeImplementation]) -> java.util.Set[Parameter]: ...
    @classmethod
    def filterParametersByMultiplexingCriteria(cls, collection: java.util.Collection[Parameter], boolean: bool) -> java.util.Set[Parameter]: ...
    @classmethod
    def filterParametersByParameterGroups(cls, collection: java.util.Collection[Parameter], collection2: java.util.Collection[str]) -> java.util.Set[Parameter]: ...
    @classmethod
    def filterParametersByParticleTransfers(cls, collection: java.util.Collection[Parameter], collection2: java.util.Collection[cern.accsoft.commons.domain.particletransfers.ParticleTransfer]) -> java.util.Set[Parameter]: ...
    @classmethod
    def filterParametersByPropertyNames(cls, collection: java.util.Collection[Parameter], collection2: java.util.Collection[str]) -> java.util.Set[Parameter]: ...
    @classmethod
    def filterParametersByTrimableCriteria(cls, collection: java.util.Collection[Parameter], boolean: bool) -> java.util.Set[Parameter]: ...
    @classmethod
    def filterParametersByTypes(cls, collection: java.util.Collection[Parameter], collection2: java.util.Collection[str]) -> java.util.Set[Parameter]: ...
    @classmethod
    def filterParametersNotBelongingToDeviceProperties(cls, set: java.util.Set[Parameter], set2: java.util.Set[str]) -> java.util.Set[Parameter]: ...
    @classmethod
    def filterReadableParameters(cls, collection: java.util.Collection[Parameter]) -> java.util.Set[Parameter]: ...
    @classmethod
    def filterRootNodes(cls, collection: java.util.Collection[ParameterTreeNode]) -> java.util.Set[ParameterTreeNode]: ...
    @classmethod
    def filterSettingParameters(cls, collection: java.util.Collection[Parameter]) -> java.util.Set[Parameter]: ...
    @classmethod
    def filterVirtualParameters(cls, collection: java.util.Collection[Parameter]) -> java.util.Set[Parameter]: ...
    @classmethod
    def filterWritableParameters(cls, collection: java.util.Collection[Parameter]) -> java.util.Set[Parameter]: ...
    @classmethod
    def getAllParameters(cls, collection: java.util.Collection[ParameterTreeNode]) -> java.util.Set[Parameter]: ...
    @classmethod
    def getAncestors(cls, collection: java.util.Collection[ParameterTreeNode]) -> java.util.Set[ParameterTreeNode]: ...
    @classmethod
    def getColumnCount(cls, parameter: Parameter) -> int: ...
    @classmethod
    def getDescendants(cls, collection: java.util.Collection[ParameterTreeNode]) -> java.util.Set[ParameterTreeNode]: ...
    @classmethod
    def getDeviceNames(cls, collection: java.util.Collection[Parameter]) -> java.util.Set[str]: ...
    @classmethod
    def getDeviceProperties(cls, collection: java.util.Collection[Parameter]) -> java.util.Set[str]: ...
    @classmethod
    def getDeviceProperty(cls, parameter: Parameter) -> str: ...
    @classmethod
    def getDeviceTypeNames(cls, collection: java.util.Collection[Parameter]) -> java.util.Set[str]: ...
    @classmethod
    def getDevices(cls, collection: java.util.Collection[Parameter]) -> java.util.Set[cern.lsa.domain.devices.Device]: ...
    @classmethod
    def getFieldName(cls, parameter: Parameter) -> str: ...
    @classmethod
    def getFieldNames(cls, collection: java.util.Collection[Parameter]) -> java.util.Set[str]: ...
    @classmethod
    def getParameterByTypeName(cls, collection: java.util.Collection[Parameter], string: str) -> Parameter: ...
    @classmethod
    def getParameterGroups(cls, collection: java.util.Collection[Parameter]) -> java.util.Set[str]: ...
    @classmethod
    def getParameterGroupsOrNoGroup(cls, collection: java.util.Collection[Parameter]) -> java.util.Set[str]: ...
    @classmethod
    def getParameterTypes(cls, collection: java.util.Collection[Parameter]) -> java.util.Set[ParameterType]: ...
    @classmethod
    @overload
    def getParameters(cls, collection: java.util.Collection[ParameterTreeNode]) -> java.util.List[Parameter]: ...
    @classmethod
    @overload
    def getParameters(cls, map: java.util.Map[str, DevicePropertyParameters]) -> java.util.Set[Parameter]: ...
    @classmethod
    def getParticleTransfers(cls, collection: java.util.Collection[Parameter]) -> java.util.Set[cern.accsoft.commons.domain.particletransfers.ParticleTransfer]: ...
    @classmethod
    def getPropertyName(cls, parameter: Parameter) -> str: ...
    @classmethod
    def getPropertyNames(cls, collection: java.util.Collection[Parameter]) -> java.util.Set[str]: ...
    @classmethod
    def getRowCount(cls, parameter: Parameter) -> int: ...
    @classmethod
    def groupDevicePropertiesByDeviceType(cls, collection: java.util.Collection[Parameter]) -> java.util.Map[str, java.util.Set[str]]: ...
    @classmethod
    def groupParametersByDefaultHierarchy(cls, collection: java.util.Collection[Parameter]) -> java.util.SortedMap[str, java.util.Set[Parameter]]: ...
    @classmethod
    def groupParametersByDeviceNames(cls, set: java.util.Set[Parameter]) -> java.util.Map[str, java.util.Set[Parameter]]: ...
    @classmethod
    def groupParametersByDeviceProperty(cls, collection: java.util.Collection[Parameter]) -> java.util.Map[str, DevicePropertyParameters]: ...
    @classmethod
    def groupParametersByDevices(cls, collection: java.util.Collection[Parameter]) -> java.util.Map[cern.lsa.domain.devices.Device, java.util.Set[Parameter]]: ...
    @classmethod
    def groupParametersByParticleTransfers(cls, collection: java.util.Collection[Parameter]) -> java.util.Map[cern.accsoft.commons.domain.particletransfers.ParticleTransfer, java.util.Set[Parameter]]: ...
    @classmethod
    def groupToParameterTypeGroups(cls, collection: java.util.Collection[Parameter]) -> java.util.List[ParameterTypeGroup]: ...
    @classmethod
    def hasField(cls, parameter: Parameter) -> bool: ...
    @classmethod
    def implementationIn(cls, collection: java.util.Collection[cern.lsa.domain.devices.DeviceTypeImplementation]) -> cern.accsoft.commons.util.Filters.Filter[Parameter]: ...
    @classmethod
    def isCommandParameter(cls, parameter: Parameter) -> bool: ...
    @classmethod
    def isSettingParameter(cls, parameter: Parameter) -> bool: ...
    @classmethod
    def isSignatureParameter(cls, parameter: Parameter) -> bool: ...
    @classmethod
    def isSimpleProperty(cls, set: java.util.Set[Parameter]) -> bool: ...
    @classmethod
    @overload
    def mapByDeviceName(cls, collection: java.util.Collection[Parameter]) -> java.util.Map[str, Parameter]: ...
    @classmethod
    @overload
    def mapByDeviceName(cls, set: java.util.Set[Parameter]) -> java.util.Map[str, Parameter]: ...
    @classmethod
    def mapByParameterTypeNames(cls, set: java.util.Set[Parameter]) -> java.util.Map[str, Parameter]: ...
    @classmethod
    def parameterTypeNameIn(cls, collection: java.util.Collection[str]) -> cern.accsoft.commons.util.Filters.Filter[Parameter]: ...
    @classmethod
    def particleTransferIn(cls, collection: java.util.Collection[cern.accsoft.commons.domain.particletransfers.ParticleTransfer]) -> cern.accsoft.commons.util.Filters.Filter[Parameter]: ...
    @classmethod
    def propertyNameIn(cls, collection: java.util.Collection[str]) -> cern.accsoft.commons.util.Filters.Filter[Parameter]: ...
    @classmethod
    def toArray(cls, collection: java.util.Collection[Parameter]) -> _py_List[Parameter]: ...

class ParametersRequest:
    @classmethod
    def builder(cls) -> cern.lsa.domain.settings.factory.ParametersRequestBuilder: ...
    def getAccelerator(self) -> cern.accsoft.commons.domain.Accelerator: ...
    def getAcceleratorZones(self) -> java.util.Set[cern.accsoft.commons.domain.zones.AcceleratorZone]: ...
    def getDeviceNames(self) -> java.util.Set[str]: ...
    def getDevices(self) -> java.util.Set[cern.lsa.domain.devices.Device]: ...
    def getParameterGroups(self) -> java.util.Set[str]: ...
    def getParameterNamePattern(self) -> str: ...
    def getParameterNames(self) -> java.util.Set[str]: ...
    def getParameterTypeNames(self) -> java.util.Set[str]: ...
    def getParticleTransfers(self) -> java.util.Set[cern.accsoft.commons.domain.particletransfers.ParticleTransfer]: ...
    def getPropertyFields(self) -> java.util.Set[cern.lsa.domain.devices.type.PropertyField]: ...
    def getPropertyNames(self) -> java.util.Set[str]: ...
    def getValueTypes(self) -> java.util.Set[cern.accsoft.commons.value.Type]: ...
    def isCritical(self) -> bool: ...
    def isMultiplexed(self) -> bool: ...
    def isReadable(self) -> bool: ...
    def isVirtual(self) -> bool: ...
    def isWritable(self) -> bool: ...

class PropertyAccessMode(java.lang.Enum['PropertyAccessMode']):
    WRITABLE: _py_ClassVar['PropertyAccessMode'] = ...
    READABLE: _py_ClassVar['PropertyAccessMode'] = ...
    MONITORABLE: _py_ClassVar['PropertyAccessMode'] = ...
    MULTIPLEXED: _py_ClassVar['PropertyAccessMode'] = ...
    def hasTheSameAccessMode(self, parameter: Parameter) -> bool: ...
    @classmethod
    @overload
    def valueOf(cls, string: str) -> 'PropertyAccessMode': ...
    _valueOf_1__T = _py_TypeVar('_valueOf_1__T', bound=java.lang.Enum)  # <T>
    @classmethod
    @overload
    def valueOf(cls, class_: _py_Type[_valueOf_1__T], string: str) -> _valueOf_1__T: ...
    @classmethod
    def values(cls) -> _py_List['PropertyAccessMode']: ...

class Setting(cern.lsa.domain.commons.IdentifiedEntity):
    def clone(self) -> 'Setting': ...
    def getArray2DValue(self) -> cern.accsoft.commons.value.ImmutableScalarArray2D: ...
    def getArrayValue(self) -> cern.accsoft.commons.value.ImmutableScalarArray: ...
    def getBeamProcess(self) -> 'BeamProcess': ...
    def getCorrectionFunctionValue(self) -> cern.accsoft.commons.value.ImmutableDiscreteFunction: ...
    def getCorrectionFunctionsArrayValue(self) -> cern.accsoft.commons.value.ImmutableDiscreteFunctionsArray: ...
    def getCorrectionScalarValue(self) -> cern.accsoft.commons.value.ImmutableScalar: ...
    def getCorrectionValue(self) -> cern.accsoft.commons.value.ImmutableValue: ...
    def getCreationDate(self) -> java.util.Date: ...
    def getFunctionValue(self) -> cern.accsoft.commons.value.ImmutableDiscreteFunction: ...
    def getFunctionsArrayValue(self) -> cern.accsoft.commons.value.ImmutableDiscreteFunctionsArray: ...
    def getParameter(self) -> Parameter: ...
    def getScalarValue(self) -> cern.accsoft.commons.value.ImmutableScalar: ...
    def getTargetFunctionValue(self) -> cern.accsoft.commons.value.ImmutableDiscreteFunction: ...
    def getTargetFunctionsArrayValue(self) -> cern.accsoft.commons.value.ImmutableDiscreteFunctionsArray: ...
    def getTargetScalarValue(self) -> cern.accsoft.commons.value.ImmutableScalar: ...
    def getTargetValue(self) -> cern.accsoft.commons.value.ImmutableValue: ...
    def getTrimId(self) -> int: ...
    def getValue(self) -> cern.accsoft.commons.value.ImmutableValue: ...
    def getValueType(self) -> cern.accsoft.commons.value.Type: ...
    @overload
    def updateValue(self, immutableValue: cern.accsoft.commons.value.ImmutableValue, settingPartEnum: 'SettingPartEnum') -> None: ...
    @overload
    def updateValue(self, setting: 'Setting') -> None: ...

class SettingComparisonParameterResult:
    def getDestinationBeamProcesses(self) -> java.util.List['BeamProcess']: ...
    def getDestinationDetailedException(self, beamProcess: 'BeamProcess') -> java.lang.Exception: ...
    def getDestinationException(self) -> java.lang.Exception: ...
    def getDestinationSettings(self) -> ParameterSettings: ...
    def getDetailedResultType(self, beamProcess: 'BeamProcess', beamProcess2: 'BeamProcess') -> 'SettingComparisonResultType': ...
    def getDetailedResultTypes(self) -> java.util.Map[cern.accsoft.commons.util.value.Pair['BeamProcess', 'BeamProcess'], 'SettingComparisonResultType']: ...
    def getParameter(self) -> Parameter: ...
    def getResultType(self) -> 'SettingComparisonResultType': ...
    def getSourceBeamProcesses(self) -> java.util.List['BeamProcess']: ...
    def getSourceDetailedException(self, beamProcess: 'BeamProcess') -> java.lang.Exception: ...
    def getSourceException(self) -> java.lang.Exception: ...
    def getSourceSettings(self) -> ParameterSettings: ...

class SettingComparisonRequest:
    def compareAllParameters(self) -> bool: ...
    def getDestinationBeamProcesses(self) -> java.util.List['BeamProcess']: ...
    def getDestinationSettingsSource(self) -> 'SettingsSource': ...
    def getParameters(self) -> java.util.Set[Parameter]: ...
    def getPointInDestFunction(self) -> int: ...
    def getPointInSourceFunction(self) -> int: ...
    def getSourceBeamProcesses(self) -> java.util.List['BeamProcess']: ...
    def getSourceSettingsSource(self) -> 'SettingsSource': ...
    def ignoreFlatFunctionsLength(self) -> bool: ...

class SettingComparisonResponse:
    def getSettingComparisonRequest(self) -> SettingComparisonRequest: ...
    def getSettingComparisonResult(self) -> 'SettingComparisonResult': ...

class SettingComparisonResult:
    def getComparedParameters(self) -> java.util.Set[Parameter]: ...
    def getSettingComparisonParameterResult(self, parameter: Parameter) -> SettingComparisonParameterResult: ...
    def getSettingComparisonParameterResults(self) -> java.util.Map[Parameter, SettingComparisonParameterResult]: ...

class SettingComparisonResultType(java.lang.Enum['SettingComparisonResultType']):
    MATCH: _py_ClassVar['SettingComparisonResultType'] = ...
    MISMATCH: _py_ClassVar['SettingComparisonResultType'] = ...
    NO_SETTINGS: _py_ClassVar['SettingComparisonResultType'] = ...
    NO_SETTINGS_IN_SOURCE: _py_ClassVar['SettingComparisonResultType'] = ...
    NO_SETTINGS_IN_DEST: _py_ClassVar['SettingComparisonResultType'] = ...
    NOT_COMPARABLE: _py_ClassVar['SettingComparisonResultType'] = ...
    ERROR: _py_ClassVar['SettingComparisonResultType'] = ...
    FILTERED_OUT: _py_ClassVar['SettingComparisonResultType'] = ...
    UNDEFINED: _py_ClassVar['SettingComparisonResultType'] = ...
    @classmethod
    def mostRepresentative(cls, settingComparisonResultType: 'SettingComparisonResultType', settingComparisonResultType2: 'SettingComparisonResultType') -> 'SettingComparisonResultType': ...
    @classmethod
    @overload
    def valueOf(cls, string: str) -> 'SettingComparisonResultType': ...
    _valueOf_1__T = _py_TypeVar('_valueOf_1__T', bound=java.lang.Enum)  # <T>
    @classmethod
    @overload
    def valueOf(cls, class_: _py_Type[_valueOf_1__T], string: str) -> _valueOf_1__T: ...
    @classmethod
    def values(cls) -> _py_List['SettingComparisonResultType']: ...

class SettingFactory:
    @classmethod
    @overload
    def newInitialSetting(cls, beamProcess: 'BeamProcess', parameter: Parameter) -> Setting: ...
    @classmethod
    @overload
    def newInitialSetting(cls, beamProcess: 'BeamProcess', parameter: Parameter, type: cern.accsoft.commons.value.Type) -> Setting: ...
    @classmethod
    @overload
    def newSetting(cls, beamProcess: 'BeamProcess', parameter: Parameter) -> Setting: ...
    @classmethod
    @overload
    def newSetting(cls, beamProcess: 'BeamProcess', parameter: Parameter, immutableValue: cern.accsoft.commons.value.ImmutableValue) -> Setting: ...
    @classmethod
    @overload
    def newSetting(cls, beamProcess: 'BeamProcess', parameter: Parameter, immutableValue: cern.accsoft.commons.value.ImmutableValue, immutableValue2: cern.accsoft.commons.value.ImmutableValue) -> Setting: ...
    @classmethod
    @overload
    def newSetting(cls, beamProcess: 'BeamProcess', parameter: Parameter, type: cern.accsoft.commons.value.Type) -> Setting: ...
    @classmethod
    @overload
    def newSetting(cls, type: cern.accsoft.commons.value.Type) -> cern.lsa.domain.settings.spi.AbstractSetting: ...

class SettingPartEnum(java.lang.Enum['SettingPartEnum']):
    NONE: _py_ClassVar['SettingPartEnum'] = ...
    CORRECTION: _py_ClassVar['SettingPartEnum'] = ...
    TARGET: _py_ClassVar['SettingPartEnum'] = ...
    VALUE: _py_ClassVar['SettingPartEnum'] = ...
    UPDATE_TARGET_NO_CORRECTION: _py_ClassVar['SettingPartEnum'] = ...
    TARGET_AND_CORRECTION: _py_ClassVar['SettingPartEnum'] = ...
    UPDATE_VALUE_ON_TARGET: _py_ClassVar['SettingPartEnum'] = ...
    def getTypeName(self) -> str: ...
    def getValue(self) -> int: ...
    def toString(self) -> str: ...
    @classmethod
    @overload
    def valueOf(cls, int: int) -> 'SettingPartEnum': ...
    @classmethod
    @overload
    def valueOf(cls, string: str) -> 'SettingPartEnum': ...
    _valueOf_2__T = _py_TypeVar('_valueOf_2__T', bound=java.lang.Enum)  # <T>
    @classmethod
    @overload
    def valueOf(cls, class_: _py_Type[_valueOf_2__T], string: str) -> _valueOf_2__T: ...
    @classmethod
    def values(cls) -> _py_List['SettingPartEnum']: ...

class Settings:
    @classmethod
    def computeContextBeamInValue(cls, standAloneContext: 'StandAloneContext', parameterSettings: ParameterSettings, settingPartEnum: SettingPartEnum) -> cern.accsoft.commons.value.ImmutableValue: ...
    @classmethod
    @overload
    def computeContextValue(cls, context: Context, parameterSettings: ParameterSettings) -> cern.accsoft.commons.value.ImmutableValue: ...
    @classmethod
    @overload
    def computeContextValue(cls, context: Context, parameterSettings: ParameterSettings, settingPartEnum: SettingPartEnum) -> cern.accsoft.commons.value.ImmutableValue: ...
    @classmethod
    @overload
    def computeContextValue(cls, standAloneContext: 'StandAloneContext', collection: java.util.Collection[Context], parameterSettings: ParameterSettings, settingPartEnum: SettingPartEnum) -> cern.accsoft.commons.value.ImmutableValue: ...
    @classmethod
    @overload
    def computeContextValue(cls, collection: java.util.Collection[Context], parameterSettings: ParameterSettings, settingPartEnum: SettingPartEnum) -> cern.accsoft.commons.value.ImmutableValue: ...
    @classmethod
    def filterNonCommandSettings(cls, collection: java.util.Collection[Setting]) -> java.util.List[Setting]: ...
    @classmethod
    def filterNonSignatureSettings(cls, collection: java.util.Collection[Setting]) -> java.util.Set[Setting]: ...
    @classmethod
    def filterSignatureSettings(cls, collection: java.util.Collection[Setting]) -> java.util.Set[Setting]: ...
    @classmethod
    def getBeamProcesses(cls, collection: java.util.Collection[Setting]) -> java.util.Set['BeamProcess']: ...
    @classmethod
    def getFunction(cls, contextSettings: ContextSettings, parameter: Parameter) -> cern.accsoft.commons.value.ImmutableDiscreteFunction: ...
    @classmethod
    def getFunctionList(cls, contextSettings: ContextSettings, parameter: Parameter) -> cern.accsoft.commons.value.ImmutableDiscreteFunctionList: ...
    @classmethod
    def getFunctionValue(cls, setting: Setting, settingPartEnum: SettingPartEnum) -> cern.accsoft.commons.value.ImmutableDiscreteFunction: ...
    @classmethod
    def getFunctionsArrayValue(cls, setting: Setting, settingPartEnum: SettingPartEnum) -> cern.accsoft.commons.value.ImmutableDiscreteFunctionsArray: ...
    @classmethod
    def getPolynomialValue(cls, setting: Setting, settingPartEnum: SettingPartEnum) -> cern.accsoft.commons.value.ImmutableDiscreteFunction: ...
    @classmethod
    def getScalar(cls, contextSettings: ContextSettings, parameter: Parameter) -> cern.accsoft.commons.value.ImmutableScalar: ...
    @classmethod
    def getScalarArray(cls, contextSettings: ContextSettings, parameter: Parameter) -> cern.accsoft.commons.value.ImmutableScalarArray: ...
    @classmethod
    def getScalarArray2D(cls, contextSettings: ContextSettings, parameter: Parameter) -> cern.accsoft.commons.value.ImmutableScalarArray2D: ...
    @classmethod
    def getScalarValue(cls, setting: Setting, settingPartEnum: SettingPartEnum) -> cern.accsoft.commons.value.ImmutableScalar: ...
    @classmethod
    def getUpdatedDrivableContexts(cls, contextSettings: ContextSettings) -> java.util.Set['DrivableContext']: ...
    @classmethod
    @overload
    def getValue(cls, contextSettings: ContextSettings, parameter: Parameter) -> cern.accsoft.commons.value.ImmutableValue: ...
    @classmethod
    @overload
    def getValue(cls, setting: Setting, settingPartEnum: SettingPartEnum) -> cern.accsoft.commons.value.ImmutableValue: ...
    @classmethod
    def groupSettingsByValueType(cls, collection: java.util.Collection[Setting]) -> java.util.Map[cern.accsoft.commons.value.Type, java.util.List[Setting]]: ...
    @classmethod
    def hasCorrectLength(cls, setting: Setting) -> bool: ...
    @classmethod
    def hasUpdatedSetting(cls, contextSettings: ContextSettings, set: java.util.Set[Parameter], beamProcess: 'BeamProcess') -> bool: ...
    @classmethod
    @overload
    def isContinue(cls, immutableDiscreteFunction: cern.accsoft.commons.value.ImmutableDiscreteFunction, immutableDiscreteFunction2: cern.accsoft.commons.value.ImmutableDiscreteFunction) -> bool: ...
    @classmethod
    @overload
    def isContinue(cls, setting: Setting, setting2: Setting) -> bool: ...
    @classmethod
    def isInLimits(cls, immutableValue: cern.accsoft.commons.value.ImmutableValue) -> bool: ...
    @classmethod
    def updateScalar(cls, immutableScalar: cern.accsoft.commons.value.ImmutableScalar, immutableScalar2: cern.accsoft.commons.value.ImmutableScalar, boolean: bool) -> cern.accsoft.commons.util.value.Pair[bool, cern.accsoft.commons.value.ImmutableScalar]: ...
    @classmethod
    def valuesAreEqual(cls, immutableValue: cern.accsoft.commons.value.ImmutableValue, immutableValue2: cern.accsoft.commons.value.ImmutableValue) -> bool: ...

class SettingsSource(java.io.Serializable):
    @classmethod
    def forArchiveVersionSettings(cls, archiveVersion: ArchiveVersion) -> 'SettingsSource': ...
    @classmethod
    def forCurrentSettings(cls) -> 'SettingsSource': ...
    @classmethod
    def forHardwareSettings(cls) -> 'SettingsSource': ...
    @classmethod
    def forHistoricalSettings(cls, date: java.util.Date) -> 'SettingsSource': ...
    @classmethod
    def forReferenceSettings(cls) -> 'SettingsSource': ...
    @classmethod
    def forTrimSettings(cls, trimHeader: 'TrimHeader') -> 'SettingsSource': ...
    @classmethod
    def formatSettingsSource(cls, settingsSource: 'SettingsSource') -> str: ...
    def getArchiveVersion(self) -> ArchiveVersion: ...
    def getDate(self) -> java.util.Date: ...
    def getTrimHeader(self) -> 'TrimHeader': ...
    def getType(self) -> 'SettingsSource.SettingsSourceType': ...
    def isValid(self) -> bool: ...
    def toString(self) -> str: ...
    class SettingsSourceType(java.lang.Enum['SettingsSource.SettingsSourceType']):
        CURRENT_SETTINGS: _py_ClassVar['SettingsSource.SettingsSourceType'] = ...
        HISTORICAL_SETTINGS: _py_ClassVar['SettingsSource.SettingsSourceType'] = ...
        TRIM: _py_ClassVar['SettingsSource.SettingsSourceType'] = ...
        ARCHIVE_VERSION: _py_ClassVar['SettingsSource.SettingsSourceType'] = ...
        REFERENCE: _py_ClassVar['SettingsSource.SettingsSourceType'] = ...
        HARDWARE: _py_ClassVar['SettingsSource.SettingsSourceType'] = ...
        @classmethod
        @overload
        def valueOf(cls, string: str) -> 'SettingsSource.SettingsSourceType': ...
        _valueOf_1__T = _py_TypeVar('_valueOf_1__T', bound=java.lang.Enum)  # <T>
        @classmethod
        @overload
        def valueOf(cls, class_: _py_Type[_valueOf_1__T], string: str) -> _valueOf_1__T: ...
        @classmethod
        def values(cls) -> _py_List['SettingsSource.SettingsSourceType']: ...

class StandAloneContextCloneRequest:
    def getAttributes(self) -> java.util.Set[cern.lsa.domain.commons.Attribute]: ...
    def getCloneName(self) -> str: ...
    def getContextCategory(self) -> ContextCategory: ...
    def getDescription(self) -> str: ...
    def getHistoryCutOff(self) -> java.time.Instant: ...
    def getSource(self) -> 'StandAloneContext': ...
    def shouldCloneType(self) -> bool: ...
    def withHistory(self) -> bool: ...

class StandAloneContextCreationRequest:
    def getAttributes(self) -> java.util.Set[cern.lsa.domain.commons.Attribute]: ...
    def getContextCategory(self) -> ContextCategory: ...
    def getContextType(self) -> cern.lsa.domain.settings.type.ContextType: ...
    def getDescription(self) -> str: ...
    def getLength(self) -> int: ...
    def getName(self) -> str: ...
    def isMultiplexed(self) -> bool: ...

class StandAloneContextFilter(cern.accsoft.commons.util.Filters.Filter['StandAloneContext']):
    def __init__(self): ...
    @overload
    def accepts(self, standAloneContext: 'StandAloneContext') -> bool: ...
    @overload
    def accepts(self, object: _py_Any) -> bool: ...
    @classmethod
    def categoryIn(cls, collection: java.util.Collection[ContextCategory]) -> 'StandAloneContextFilter': ...
    def setCategories(self, collection: java.util.Collection[ContextCategory]) -> 'StandAloneContextFilter': ...

class TrimException(cern.lsa.domain.LsaException):
    @overload
    def __init__(self, exception: java.lang.Exception): ...
    @overload
    def __init__(self, string: str): ...
    @overload
    def __init__(self, string: str, exception: java.lang.Exception): ...

class TrimHeader(cern.lsa.domain.commons.IdentifiedEntity):
    def getBeamProcesses(self) -> java.util.List['BeamProcess']: ...
    def getClientInfo(self) -> str: ...
    def getCreatedDate(self) -> java.util.Date: ...
    def getDescription(self) -> str: ...

class TrimHeadersRequest(java.io.Serializable):
    @classmethod
    def builder(cls) -> 'TrimHeadersRequestBuilder': ...
    @classmethod
    def byBeamProcessesAndParameters(cls, collection: java.util.Collection['BeamProcess'], collection2: java.util.Collection[Parameter]) -> 'TrimHeadersRequest': ...
    def getBeamProcesses(self) -> java.util.Collection['BeamProcess']: ...
    def getMaxLastTrimsNumber(self) -> int: ...
    def getParameters(self) -> java.util.Collection[Parameter]: ...
    def getStartingFrom(self) -> java.time.Instant: ...
    def toString(self) -> str: ...

class TrimHeadersRequestBuilder:
    def __init__(self): ...
    def beamProcesses(self, collection: java.util.Collection['BeamProcess']) -> 'TrimHeadersRequestBuilder': ...
    def build(self) -> TrimHeadersRequest: ...
    @classmethod
    def byBeamProcessesAndParameters(cls, collection: java.util.Collection['BeamProcess'], collection2: java.util.Collection[Parameter]) -> TrimHeadersRequest: ...
    def maxLastTrimsNumber(self, integer: int) -> 'TrimHeadersRequestBuilder': ...
    def parameters(self, collection: java.util.Collection[Parameter]) -> 'TrimHeadersRequestBuilder': ...
    def startingFrom(self, instant: java.time.Instant) -> 'TrimHeadersRequestBuilder': ...

class TrimRequest:
    @classmethod
    def builder(cls) -> cern.lsa.domain.settings.factory.TrimRequestBuilder: ...
    def getAttribute(self, string: str) -> _py_Any: ...
    def getAttributes(self) -> java.util.Map[str, _py_Any]: ...
    def getChildSettingPart(self) -> SettingPartEnum: ...
    def getContext(self) -> 'StandAloneContext': ...
    def getContextSettings(self) -> ContextSettings: ...
    def getCustomSettingPart(self, parameter: Parameter) -> SettingPartEnum: ...
    def getCustomSettingPartMap(self) -> java.util.Map[Parameter, SettingPartEnum]: ...
    def getDescription(self) -> str: ...
    def getParameters(self) -> java.util.Set[Parameter]: ...
    def getSettingPart(self) -> SettingPartEnum: ...
    def isCommit(self) -> bool: ...
    def isDrive(self) -> bool: ...
    def isForceDrive(self) -> bool: ...
    def isForceProcessing(self) -> bool: ...
    def isIgnoreErrors(self) -> bool: ...
    def isLenientDrive(self) -> bool: ...
    def isPersistSettings(self) -> bool: ...
    def isPropagateToChildren(self) -> bool: ...
    def isRelative(self) -> bool: ...
    def isReturnSettings(self) -> bool: ...
    def isSkipProcessing(self) -> bool: ...
    def setAttribute(self, string: str, object: _py_Any) -> None: ...
    def setSettingPart(self, settingPartEnum: SettingPartEnum) -> None: ...

class TrimResponse:
    def getDriveResult(self) -> cern.lsa.domain.exploitation.DriveResult: ...
    def getTrimResult(self) -> 'TrimResult': ...
    def isDrivePerformed(self) -> bool: ...

class TrimResult:
    def getAttribute(self, string: str) -> java.io.Serializable: ...
    def getContext(self) -> 'StandAloneContext': ...
    def getContextSettings(self) -> ContextSettings: ...
    def getTrimHeader(self) -> TrimHeader: ...
    def getTrimRequest(self) -> TrimRequest: ...
    def getWarnings(self) -> java.util.List[cern.accsoft.commons.util.value.Pair[str, java.lang.Throwable]]: ...

class UserContextMapping:
    def equalByName(self, userContextMapping: 'UserContextMapping') -> bool: ...
    def getContextName(self) -> str: ...
    def getContextParent(self) -> str: ...
    def getMappingTimestamp(self) -> int: ...
    def getOperationType(self) -> 'UserContextMapping.OperationType': ...
    def getUser(self) -> str: ...
    def isResident(self) -> bool: ...
    class OperationType(java.lang.Enum['UserContextMapping.OperationType']):
        INSERT: _py_ClassVar['UserContextMapping.OperationType'] = ...
        DELETE: _py_ClassVar['UserContextMapping.OperationType'] = ...
        UPDATE: _py_ClassVar['UserContextMapping.OperationType'] = ...
        @classmethod
        def fromString(cls, string: str) -> 'UserContextMapping.OperationType': ...
        @classmethod
        @overload
        def valueOf(cls, string: str) -> 'UserContextMapping.OperationType': ...
        _valueOf_1__T = _py_TypeVar('_valueOf_1__T', bound=java.lang.Enum)  # <T>
        @classmethod
        @overload
        def valueOf(cls, class_: _py_Type[_valueOf_1__T], string: str) -> _valueOf_1__T: ...
        @classmethod
        def values(cls) -> _py_List['UserContextMapping.OperationType']: ...

class CopySettingsRequest(TrimRequest):
    @classmethod
    def builder(cls) -> cern.lsa.domain.settings.factory.CopySettingsRequestBuilder: ...
    def getDestinationContexts(self) -> java.util.List[Context]: ...
    def getDestinationParameters(self) -> java.util.Set[Parameter]: ...
    def getSettingsSource(self) -> SettingsSource: ...
    def getSourceContexts(self) -> java.util.List[Context]: ...

class CriticalParameterException(TrimException):
    @overload
    def __init__(self, exception: java.lang.Exception): ...
    @overload
    def __init__(self, string: str): ...
    @overload
    def __init__(self, string: str, exception: java.lang.Exception): ...

class CycleIntersections(ContextIntersections):
    def getBeamProcesses(self) -> java.util.Set['BeamProcess']: ...
    def getCycleName(self) -> str: ...
    def getFollowingBeamProcess(self, beamProcess: 'BeamProcess') -> 'BeamProcess': ...
    def getIntersectedBeamProcesses(self, particleTransfer: cern.accsoft.commons.domain.particletransfers.ParticleTransfer) -> java.util.Set['BeamProcess']: ...
    def getIntersectedFunctionBeamProcess(self, particleTransfer: cern.accsoft.commons.domain.particletransfers.ParticleTransfer, double: float) -> BeamProcessIntersection: ...
    def getIntersectedFunctionBeamProcesses(self, particleTransfer: cern.accsoft.commons.domain.particletransfers.ParticleTransfer, double: float) -> java.util.List[BeamProcessIntersection]: ...
    def getParticleTransfers(self) -> java.util.Set[cern.accsoft.commons.domain.particletransfers.ParticleTransfer]: ...
    def getPrecedingBeamProcess(self, beamProcess: 'BeamProcess') -> 'BeamProcess': ...
    def size(self) -> int: ...

class DefaultAcceleratorUser(AcceleratorUser, java.io.Serializable):
    @classmethod
    def builder(cls) -> 'DefaultAcceleratorUser.Builder': ...
    @classmethod
    def copyOf(cls, acceleratorUser: AcceleratorUser) -> 'DefaultAcceleratorUser': ...
    def equals(self, object: _py_Any) -> bool: ...
    def getAccelerator(self) -> cern.accsoft.commons.domain.Accelerator: ...
    def getAcceleratorUserGroup(self) -> AcceleratorUserGroup: ...
    def getId(self) -> int: ...
    def getName(self) -> str: ...
    def hashCode(self) -> int: ...
    def isMultiplexed(self) -> bool: ...
    def toString(self) -> str: ...
    def withAccelerator(self, accelerator: cern.accsoft.commons.domain.Accelerator) -> 'DefaultAcceleratorUser': ...
    def withAcceleratorUserGroup(self, acceleratorUserGroup: AcceleratorUserGroup) -> 'DefaultAcceleratorUser': ...
    def withId(self, long: int) -> 'DefaultAcceleratorUser': ...
    def withMultiplexed(self, boolean: bool) -> 'DefaultAcceleratorUser': ...
    def withName(self, string: str) -> 'DefaultAcceleratorUser': ...
    class Builder:
        def accelerator(self, accelerator: cern.accsoft.commons.domain.Accelerator) -> 'DefaultAcceleratorUser.Builder': ...
        def acceleratorUserGroup(self, acceleratorUserGroup: AcceleratorUserGroup) -> 'DefaultAcceleratorUser.Builder': ...
        def build(self) -> 'DefaultAcceleratorUser': ...
        def id(self, long: int) -> 'DefaultAcceleratorUser.Builder': ...
        def multiplexed(self, boolean: bool) -> 'DefaultAcceleratorUser.Builder': ...
        def name(self, string: str) -> 'DefaultAcceleratorUser.Builder': ...

class DefaultAcceleratorUserGroup(AcceleratorUserGroup, java.io.Serializable):
    @classmethod
    def builder(cls) -> 'DefaultAcceleratorUserGroup.Builder': ...
    @classmethod
    def copyOf(cls, acceleratorUserGroup: AcceleratorUserGroup) -> 'DefaultAcceleratorUserGroup': ...
    def equals(self, object: _py_Any) -> bool: ...
    def getDescription(self) -> str: ...
    def getId(self) -> int: ...
    def getName(self) -> str: ...
    def hashCode(self) -> int: ...
    def toString(self) -> str: ...
    def withDescription(self, string: str) -> 'DefaultAcceleratorUserGroup': ...
    def withId(self, long: int) -> 'DefaultAcceleratorUserGroup': ...
    def withName(self, string: str) -> 'DefaultAcceleratorUserGroup': ...
    class Builder:
        def build(self) -> 'DefaultAcceleratorUserGroup': ...
        def description(self, string: str) -> 'DefaultAcceleratorUserGroup.Builder': ...
        def id(self, long: int) -> 'DefaultAcceleratorUserGroup.Builder': ...
        def name(self, string: str) -> 'DefaultAcceleratorUserGroup.Builder': ...

class DefaultAcceleratorUsersRequest(AcceleratorUsersRequest, java.io.Serializable):
    @classmethod
    def builder(cls) -> 'DefaultAcceleratorUsersRequest.Builder': ...
    @classmethod
    def copyOf(cls, acceleratorUsersRequest: AcceleratorUsersRequest) -> 'DefaultAcceleratorUsersRequest': ...
    def equals(self, object: _py_Any) -> bool: ...
    def getAccelerator(self) -> cern.accsoft.commons.domain.Accelerator: ...
    def getAcceleratorUserGroupName(self) -> str: ...
    @overload
    def getAcceleratorUserNames(self) -> com.google.common.collect.ImmutableSet[str]: ...
    @overload
    def getAcceleratorUserNames(self) -> java.util.Set: ...
    @overload
    def getIds(self) -> com.google.common.collect.ImmutableSet[int]: ...
    @overload
    def getIds(self) -> java.util.Set: ...
    def hashCode(self) -> int: ...
    def isMultiplexed(self) -> bool: ...
    def toString(self) -> str: ...
    def withAccelerator(self, accelerator: cern.accsoft.commons.domain.Accelerator) -> 'DefaultAcceleratorUsersRequest': ...
    def withAcceleratorUserGroupName(self, string: str) -> 'DefaultAcceleratorUsersRequest': ...
    @overload
    def withAcceleratorUserNames(self, iterable: java.lang.Iterable[str]) -> 'DefaultAcceleratorUsersRequest': ...
    @overload
    def withAcceleratorUserNames(self, stringArray: _py_List[str]) -> 'DefaultAcceleratorUsersRequest': ...
    @overload
    def withIds(self, iterable: java.lang.Iterable[int]) -> 'DefaultAcceleratorUsersRequest': ...
    @overload
    def withIds(self, longArray: _py_List[int]) -> 'DefaultAcceleratorUsersRequest': ...
    def withMultiplexed(self, boolean: bool) -> 'DefaultAcceleratorUsersRequest': ...
    class Builder:
        def accelerator(self, accelerator: cern.accsoft.commons.domain.Accelerator) -> 'DefaultAcceleratorUsersRequest.Builder': ...
        def acceleratorUserGroupName(self, string: str) -> 'DefaultAcceleratorUsersRequest.Builder': ...
        def acceleratorUserNames(self, iterable: java.lang.Iterable[str]) -> 'DefaultAcceleratorUsersRequest.Builder': ...
        def addAcceleratorUserName(self, string: str) -> 'DefaultAcceleratorUsersRequest.Builder': ...
        def addAcceleratorUserNames(self, stringArray: _py_List[str]) -> 'DefaultAcceleratorUsersRequest.Builder': ...
        def addAllAcceleratorUserNames(self, iterable: java.lang.Iterable[str]) -> 'DefaultAcceleratorUsersRequest.Builder': ...
        def addAllIds(self, iterable: java.lang.Iterable[int]) -> 'DefaultAcceleratorUsersRequest.Builder': ...
        def addId(self, long: int) -> 'DefaultAcceleratorUsersRequest.Builder': ...
        def addIds(self, longArray: _py_List[int]) -> 'DefaultAcceleratorUsersRequest.Builder': ...
        def build(self) -> 'DefaultAcceleratorUsersRequest': ...
        def ids(self, iterable: java.lang.Iterable[int]) -> 'DefaultAcceleratorUsersRequest.Builder': ...
        def multiplexed(self, boolean: bool) -> 'DefaultAcceleratorUsersRequest.Builder': ...

class DefaultHyperCycleMapping(HyperCycleMapping, java.io.Serializable):
    @classmethod
    def builder(cls) -> 'DefaultHyperCycleMapping.Builder': ...
    @classmethod
    def copyOf(cls, hyperCycleMapping: HyperCycleMapping) -> 'DefaultHyperCycleMapping': ...
    def equals(self, object: _py_Any) -> bool: ...
    def getBeamProcess(self) -> 'StandAloneBeamProcess': ...
    def getUser(self) -> AcceleratorUser: ...
    def hashCode(self) -> int: ...
    def toString(self) -> str: ...
    def withBeamProcess(self, standAloneBeamProcess: 'StandAloneBeamProcess') -> 'DefaultHyperCycleMapping': ...
    def withUser(self, acceleratorUser: AcceleratorUser) -> 'DefaultHyperCycleMapping': ...
    class Builder:
        def beamProcess(self, standAloneBeamProcess: 'StandAloneBeamProcess') -> 'DefaultHyperCycleMapping.Builder': ...
        def build(self) -> 'DefaultHyperCycleMapping': ...
        def user(self, acceleratorUser: AcceleratorUser) -> 'DefaultHyperCycleMapping.Builder': ...

class DrivableContext(Context):
    def getUser(self) -> str: ...

class IncorporationRequest(TrimRequest):
    @classmethod
    def builder(cls) -> cern.lsa.domain.settings.factory.IncorporationRequestBuilder: ...
    def getIncorporationSettings(self) -> java.util.Set[IncorporationSetting]: ...
    def shouldIncorporate(self, parameter: Parameter) -> bool: ...

class Knob(Parameter):
    def getComponentNames(self) -> java.util.Set[str]: ...
    def getKnobFactors(self) -> KnobFactors: ...
    def getOpticNames(self) -> java.util.Set[str]: ...

class RevertTrimRequest(TrimRequest):
    @classmethod
    def builder(cls) -> cern.lsa.domain.settings.factory.RevertTrimRequestBuilder: ...
    def getBeamProcesses(self) -> java.util.Set['BeamProcess']: ...
    def getTrimHeader(self) -> TrimHeader: ...

class SettingsGenerationRequest(TrimRequest):
    @classmethod
    def builder(cls) -> cern.lsa.domain.settings.factory.SettingsGenerationRequestBuilder: ...
    def getSubContexts(self) -> java.util.Set['SubContext']: ...
    def isGenerateZeroSettings(self) -> bool: ...

class SettingsRestoreStatus(FailedParametersStatus):
    def getSettings(self) -> CompositeContextSettings: ...

class StandAloneBeamProcessesRequest(BaseStandAloneContextsRequest):
    @classmethod
    def builder(cls) -> 'DefaultStandAloneBeamProcessesRequest.Builder': ...
    @classmethod
    def byAccelerator(cls, accelerator: cern.accsoft.commons.domain.Accelerator) -> 'StandAloneBeamProcessesRequest': ...
    @classmethod
    def byBeamProcessName(cls, string: str) -> 'StandAloneBeamProcessesRequest': ...
    def getBeamProcessNames(self) -> java.util.Set[str]: ...

class StandAloneContext(Context, cern.lsa.domain.commons.AttributeAware):
    def getBeamProcesses(self) -> java.util.List['BeamProcess']: ...
    def getContextCategory(self) -> ContextCategory: ...
    def getParticleTransfers(self) -> java.util.Set[cern.accsoft.commons.domain.particletransfers.ParticleTransfer]: ...
    def isResident(self) -> bool: ...

class StandAloneContextsRequest(BaseStandAloneContextsRequest):
    @classmethod
    def builder(cls) -> 'DefaultStandAloneContextsRequest.Builder': ...
    @classmethod
    def byAccelerator(cls, accelerator: cern.accsoft.commons.domain.Accelerator) -> 'StandAloneContextsRequest': ...
    @classmethod
    def byContextName(cls, string: str) -> 'StandAloneContextsRequest': ...
    def getContextNames(self) -> java.util.Set[str]: ...

class StandAloneCyclesRequest(BaseStandAloneContextsRequest):
    @classmethod
    def builder(cls) -> 'DefaultStandAloneCyclesRequest.Builder': ...
    @classmethod
    def byAccelerator(cls, accelerator: cern.accsoft.commons.domain.Accelerator) -> 'StandAloneCyclesRequest': ...
    @classmethod
    def byCycleName(cls, string: str) -> 'StandAloneCyclesRequest': ...
    def getCycleNames(self) -> java.util.Set[str]: ...

class SubContext(Context):
    def getStartTime(self) -> int: ...

class BeamProcess(SubContext):
    def getCategory(self) -> cern.lsa.domain.settings.type.BeamProcessTypeCategory: ...
    def getParticleTransfer(self) -> cern.accsoft.commons.domain.particletransfers.ParticleTransfer: ...
    def getPurpose(self) -> cern.lsa.domain.settings.type.BeamProcessPurpose: ...

class BeamProductionChain(SubContext):
    def getBeamProcesses(self) -> java.util.List['DrivableBeamProcess']: ...

class Cycle(SubContext, DrivableContext): ...

class DefaultStandAloneBeamProcessesRequest(StandAloneBeamProcessesRequest, java.io.Serializable):
    @classmethod
    def builder(cls) -> 'DefaultStandAloneBeamProcessesRequest.Builder': ...
    @classmethod
    def copyOf(cls, standAloneBeamProcessesRequest: StandAloneBeamProcessesRequest) -> 'DefaultStandAloneBeamProcessesRequest': ...
    def equals(self, object: _py_Any) -> bool: ...
    def getAccelerator(self) -> cern.accsoft.commons.domain.Accelerator: ...
    @overload
    def getBeamProcessNames(self) -> com.google.common.collect.ImmutableSet[str]: ...
    @overload
    def getBeamProcessNames(self) -> java.util.Set: ...
    @overload
    def getIds(self) -> com.google.common.collect.ImmutableSet[int]: ...
    @overload
    def getIds(self) -> java.util.Set: ...
    def hashCode(self) -> int: ...
    def isMultiplexed(self) -> bool: ...
    def isResident(self) -> bool: ...
    def toString(self) -> str: ...
    def withAccelerator(self, accelerator: cern.accsoft.commons.domain.Accelerator) -> 'DefaultStandAloneBeamProcessesRequest': ...
    @overload
    def withBeamProcessNames(self, iterable: java.lang.Iterable[str]) -> 'DefaultStandAloneBeamProcessesRequest': ...
    @overload
    def withBeamProcessNames(self, stringArray: _py_List[str]) -> 'DefaultStandAloneBeamProcessesRequest': ...
    @overload
    def withIds(self, iterable: java.lang.Iterable[int]) -> 'DefaultStandAloneBeamProcessesRequest': ...
    @overload
    def withIds(self, longArray: _py_List[int]) -> 'DefaultStandAloneBeamProcessesRequest': ...
    def withMultiplexed(self, boolean: bool) -> 'DefaultStandAloneBeamProcessesRequest': ...
    def withResident(self, boolean: bool) -> 'DefaultStandAloneBeamProcessesRequest': ...
    class Builder:
        def accelerator(self, accelerator: cern.accsoft.commons.domain.Accelerator) -> 'DefaultStandAloneBeamProcessesRequest.Builder': ...
        def addAllBeamProcessNames(self, iterable: java.lang.Iterable[str]) -> 'DefaultStandAloneBeamProcessesRequest.Builder': ...
        def addAllIds(self, iterable: java.lang.Iterable[int]) -> 'DefaultStandAloneBeamProcessesRequest.Builder': ...
        def addBeamProcessName(self, string: str) -> 'DefaultStandAloneBeamProcessesRequest.Builder': ...
        def addBeamProcessNames(self, stringArray: _py_List[str]) -> 'DefaultStandAloneBeamProcessesRequest.Builder': ...
        def addId(self, long: int) -> 'DefaultStandAloneBeamProcessesRequest.Builder': ...
        def addIds(self, longArray: _py_List[int]) -> 'DefaultStandAloneBeamProcessesRequest.Builder': ...
        def beamProcessNames(self, iterable: java.lang.Iterable[str]) -> 'DefaultStandAloneBeamProcessesRequest.Builder': ...
        def build(self) -> 'DefaultStandAloneBeamProcessesRequest': ...
        def ids(self, iterable: java.lang.Iterable[int]) -> 'DefaultStandAloneBeamProcessesRequest.Builder': ...
        def multiplexed(self, boolean: bool) -> 'DefaultStandAloneBeamProcessesRequest.Builder': ...
        def resident(self, boolean: bool) -> 'DefaultStandAloneBeamProcessesRequest.Builder': ...

class DefaultStandAloneContextsRequest(StandAloneContextsRequest, java.io.Serializable):
    @classmethod
    def builder(cls) -> 'DefaultStandAloneContextsRequest.Builder': ...
    @classmethod
    def copyOf(cls, standAloneContextsRequest: StandAloneContextsRequest) -> 'DefaultStandAloneContextsRequest': ...
    def equals(self, object: _py_Any) -> bool: ...
    def getAccelerator(self) -> cern.accsoft.commons.domain.Accelerator: ...
    @overload
    def getContextNames(self) -> com.google.common.collect.ImmutableSet[str]: ...
    @overload
    def getContextNames(self) -> java.util.Set: ...
    @overload
    def getIds(self) -> com.google.common.collect.ImmutableSet[int]: ...
    @overload
    def getIds(self) -> java.util.Set: ...
    def hashCode(self) -> int: ...
    def isMultiplexed(self) -> bool: ...
    def isResident(self) -> bool: ...
    def toString(self) -> str: ...
    def withAccelerator(self, accelerator: cern.accsoft.commons.domain.Accelerator) -> 'DefaultStandAloneContextsRequest': ...
    @overload
    def withContextNames(self, iterable: java.lang.Iterable[str]) -> 'DefaultStandAloneContextsRequest': ...
    @overload
    def withContextNames(self, stringArray: _py_List[str]) -> 'DefaultStandAloneContextsRequest': ...
    @overload
    def withIds(self, iterable: java.lang.Iterable[int]) -> 'DefaultStandAloneContextsRequest': ...
    @overload
    def withIds(self, longArray: _py_List[int]) -> 'DefaultStandAloneContextsRequest': ...
    def withMultiplexed(self, boolean: bool) -> 'DefaultStandAloneContextsRequest': ...
    def withResident(self, boolean: bool) -> 'DefaultStandAloneContextsRequest': ...
    class Builder:
        def accelerator(self, accelerator: cern.accsoft.commons.domain.Accelerator) -> 'DefaultStandAloneContextsRequest.Builder': ...
        def addAllContextNames(self, iterable: java.lang.Iterable[str]) -> 'DefaultStandAloneContextsRequest.Builder': ...
        def addAllIds(self, iterable: java.lang.Iterable[int]) -> 'DefaultStandAloneContextsRequest.Builder': ...
        def addContextName(self, string: str) -> 'DefaultStandAloneContextsRequest.Builder': ...
        def addContextNames(self, stringArray: _py_List[str]) -> 'DefaultStandAloneContextsRequest.Builder': ...
        def addId(self, long: int) -> 'DefaultStandAloneContextsRequest.Builder': ...
        def addIds(self, longArray: _py_List[int]) -> 'DefaultStandAloneContextsRequest.Builder': ...
        def build(self) -> 'DefaultStandAloneContextsRequest': ...
        def contextNames(self, iterable: java.lang.Iterable[str]) -> 'DefaultStandAloneContextsRequest.Builder': ...
        def ids(self, iterable: java.lang.Iterable[int]) -> 'DefaultStandAloneContextsRequest.Builder': ...
        def multiplexed(self, boolean: bool) -> 'DefaultStandAloneContextsRequest.Builder': ...
        def resident(self, boolean: bool) -> 'DefaultStandAloneContextsRequest.Builder': ...

class DefaultStandAloneCyclesRequest(StandAloneCyclesRequest, java.io.Serializable):
    @classmethod
    def builder(cls) -> 'DefaultStandAloneCyclesRequest.Builder': ...
    @classmethod
    def copyOf(cls, standAloneCyclesRequest: StandAloneCyclesRequest) -> 'DefaultStandAloneCyclesRequest': ...
    def equals(self, object: _py_Any) -> bool: ...
    def getAccelerator(self) -> cern.accsoft.commons.domain.Accelerator: ...
    @overload
    def getCycleNames(self) -> com.google.common.collect.ImmutableSet[str]: ...
    @overload
    def getCycleNames(self) -> java.util.Set: ...
    @overload
    def getIds(self) -> com.google.common.collect.ImmutableSet[int]: ...
    @overload
    def getIds(self) -> java.util.Set: ...
    def hashCode(self) -> int: ...
    def isMultiplexed(self) -> bool: ...
    def isResident(self) -> bool: ...
    def toString(self) -> str: ...
    def withAccelerator(self, accelerator: cern.accsoft.commons.domain.Accelerator) -> 'DefaultStandAloneCyclesRequest': ...
    @overload
    def withCycleNames(self, iterable: java.lang.Iterable[str]) -> 'DefaultStandAloneCyclesRequest': ...
    @overload
    def withCycleNames(self, stringArray: _py_List[str]) -> 'DefaultStandAloneCyclesRequest': ...
    @overload
    def withIds(self, iterable: java.lang.Iterable[int]) -> 'DefaultStandAloneCyclesRequest': ...
    @overload
    def withIds(self, longArray: _py_List[int]) -> 'DefaultStandAloneCyclesRequest': ...
    def withMultiplexed(self, boolean: bool) -> 'DefaultStandAloneCyclesRequest': ...
    def withResident(self, boolean: bool) -> 'DefaultStandAloneCyclesRequest': ...
    class Builder:
        def accelerator(self, accelerator: cern.accsoft.commons.domain.Accelerator) -> 'DefaultStandAloneCyclesRequest.Builder': ...
        def addAllCycleNames(self, iterable: java.lang.Iterable[str]) -> 'DefaultStandAloneCyclesRequest.Builder': ...
        def addAllIds(self, iterable: java.lang.Iterable[int]) -> 'DefaultStandAloneCyclesRequest.Builder': ...
        def addCycleName(self, string: str) -> 'DefaultStandAloneCyclesRequest.Builder': ...
        def addCycleNames(self, stringArray: _py_List[str]) -> 'DefaultStandAloneCyclesRequest.Builder': ...
        def addId(self, long: int) -> 'DefaultStandAloneCyclesRequest.Builder': ...
        def addIds(self, longArray: _py_List[int]) -> 'DefaultStandAloneCyclesRequest.Builder': ...
        def build(self) -> 'DefaultStandAloneCyclesRequest': ...
        def cycleNames(self, iterable: java.lang.Iterable[str]) -> 'DefaultStandAloneCyclesRequest.Builder': ...
        def ids(self, iterable: java.lang.Iterable[int]) -> 'DefaultStandAloneCyclesRequest.Builder': ...
        def multiplexed(self, boolean: bool) -> 'DefaultStandAloneCyclesRequest.Builder': ...
        def resident(self, boolean: bool) -> 'DefaultStandAloneCyclesRequest.Builder': ...

class Pattern(StandAloneContext):
    def getDrivableBeamProcesses(self) -> java.util.List['DrivableBeamProcess']: ...

class DrivableBeamProcess(BeamProcess, DrivableContext): ...

class StandAloneCycle(StandAloneContext, Cycle):
    def getIntersections(self) -> CycleIntersections: ...

class StandAloneBeamProcess(StandAloneContext, DrivableBeamProcess):
    def getActualBeamProcessInfo(self) -> ActualBeamProcessInfo: ...
    def isActual(self) -> bool: ...
