from typing import Any as _py_Any
from typing import overload
import cern.accsoft.commons.util
import cern.accsoft.commons.value
import cern.japc.core
import cern.lsa.domain.devices.type
import cern.lsa.domain.exploitation
import cern.lsa.domain.exploitation.command
import cern.lsa.domain.settings
import java.io
import java.util


class HwCommandExecutionRequestImpl(cern.lsa.domain.exploitation.command.HwCommandExecutionRequest, java.io.Serializable):
    def __init__(self, hwCommand: cern.lsa.domain.exploitation.command.HwCommand): ...
    def areNonResidentContextsEnabled(self) -> bool: ...
    def getCommand(self) -> cern.lsa.domain.exploitation.command.HwCommand: ...
    def getContexts(self) -> java.util.Set[cern.lsa.domain.settings.DrivableContext]: ...
    def getDeviceNames(self) -> java.util.List[str]: ...
    def getHardwareGroups(self) -> java.util.List[str]: ...
    def getParameters(self) -> java.util.Map[str, cern.accsoft.commons.value.ImmutableScalar]: ...
    def setContexts(self, collection: java.util.Collection[cern.lsa.domain.settings.DrivableContext]) -> None: ...
    def setDeviceNames(self, collection: java.util.Collection[str]) -> None: ...
    def setHardwareGroups(self, collection: java.util.Collection[str]) -> None: ...
    def setNonResidentContextsEnabled(self, boolean: bool) -> None: ...
    @overload
    def setParameter(self, string: str, immutableScalar: cern.accsoft.commons.value.ImmutableScalar) -> None: ...
    @overload
    def setParameter(self, string: str, string2: str) -> None: ...
    def setParameters(self, map: java.util.Map[str, cern.accsoft.commons.value.ImmutableScalar]) -> None: ...
    def toString(self) -> str: ...

class HwCommandExecutionResponseImpl(java.io.Serializable, cern.lsa.domain.exploitation.command.HwCommandExecutionResponse):
    def __init__(self, hwCommandExecutionRequest: cern.lsa.domain.exploitation.command.HwCommandExecutionRequest): ...
    def getCommand(self) -> cern.lsa.domain.exploitation.command.HwCommand: ...
    def getContexts(self) -> java.util.Set[cern.lsa.domain.settings.DrivableContext]: ...
    def getDeviceNames(self) -> java.util.List[str]: ...
    def getDeviceResponses(self) -> java.util.List[cern.japc.core.FailSafeParameterValue]: ...
    def setDeviceResponses(self, collection: java.util.Collection[str], collection2: java.util.Collection[cern.japc.core.FailSafeParameterValue]) -> None: ...

class HwCommandImpl(cern.accsoft.commons.util.AbstractNamedSerializable[cern.lsa.domain.exploitation.command.HwCommand], cern.lsa.domain.exploitation.command.HwCommand):
    def __init__(self, string: str, string2: str, commandType: cern.lsa.domain.exploitation.command.CommandType, string3: str): ...
    def addHwCommandParameter(self, hwCommandParameterImpl: 'HwCommandParameterImpl') -> None: ...
    def addProperty(self, propertyVersion: cern.lsa.domain.devices.type.PropertyVersion) -> None: ...
    def createExecutionRequest(self) -> cern.lsa.domain.exploitation.command.HwCommandExecutionRequest: ...
    def createTemplateArgumentsMap(self) -> java.util.Map[str, cern.accsoft.commons.value.ImmutableScalar]: ...
    def getArgumentParameters(self) -> java.util.List[cern.lsa.domain.exploitation.command.HwCommandParameter]: ...
    def getCommandParameters(self) -> java.util.SortedSet[cern.lsa.domain.exploitation.command.HwCommandParameter]: ...
    def getDeviceType(self) -> str: ...
    def getDisplayMode(self) -> cern.lsa.domain.exploitation.DisplayMode: ...
    def getDisplayName(self) -> str: ...
    @overload
    def getParameter(self, string: str) -> cern.lsa.domain.exploitation.command.HwCommandParameter: ...
    @overload
    def getParameter(self, string: str) -> 'HwCommandParameterImpl': ...
    def getParametersCount(self) -> int: ...
    def getProperties(self) -> java.util.Set[cern.lsa.domain.devices.type.PropertyVersion]: ...
    def getProperty(self) -> cern.lsa.domain.devices.type.PropertyVersion: ...
    def getRank(self) -> int: ...
    def getReadBackCommand(self) -> cern.lsa.domain.exploitation.command.HwCommand: ...
    def getReadBackCommandName(self) -> str: ...
    def getResultParameters(self) -> java.util.List[cern.lsa.domain.exploitation.command.HwCommandParameter]: ...
    def getShortCommandName(self) -> str: ...
    def getType(self) -> cern.lsa.domain.exploitation.command.CommandType: ...
    def isContextDependent(self) -> bool: ...
    def isCustomCommand(self) -> bool: ...
    def removeHwCommandParameter(self, hwCommandParameter: cern.lsa.domain.exploitation.command.HwCommandParameter) -> None: ...
    def setCustomCommand(self, boolean: bool) -> None: ...
    def setDisplayMode(self, displayMode: cern.lsa.domain.exploitation.DisplayMode) -> None: ...
    def setDisplayName(self, string: str) -> None: ...
    def setIsContextDependent(self, boolean: bool) -> None: ...
    def setRank(self, int: int) -> None: ...
    def setReadBackCommand(self, hwCommand: cern.lsa.domain.exploitation.command.HwCommand) -> None: ...
    def setReadBackCommandName(self, string: str) -> None: ...
    def toString(self) -> str: ...
    class HwCommandParameterComparator(java.util.Comparator[cern.lsa.domain.exploitation.command.HwCommandParameter], java.io.Serializable):
        def __init__(self): ...
        @overload
        def compare(self, hwCommandParameter: cern.lsa.domain.exploitation.command.HwCommandParameter, hwCommandParameter2: cern.lsa.domain.exploitation.command.HwCommandParameter) -> int: ...
        @overload
        def compare(self, object: _py_Any, object2: _py_Any) -> int: ...

class HwCommandParameterImpl(cern.accsoft.commons.util.AbstractNamedSerializable[cern.lsa.domain.exploitation.command.HwCommandParameter], cern.lsa.domain.exploitation.command.HwCommandParameter):
    def __init__(self): ...
    def getCommandName(self) -> str: ...
    def getDefaultValue(self) -> cern.accsoft.commons.value.ImmutableScalar: ...
    def getDeviceTypeName(self) -> str: ...
    def getDisplayAttribute(self) -> str: ...
    def getDisplayName(self) -> str: ...
    def getOrder(self) -> int: ...
    def getValueDescriptor(self) -> cern.accsoft.commons.value.ValueDescriptor: ...
    def getValueType(self) -> cern.accsoft.commons.value.Type: ...
    def isArgument(self) -> bool: ...
    def isConstant(self) -> bool: ...
    def setArgument(self, boolean: bool) -> None: ...
    def setCommandName(self, string: str) -> None: ...
    def setConstant(self, boolean: bool) -> None: ...
    def setDefaultValue(self, immutableScalar: cern.accsoft.commons.value.ImmutableScalar) -> None: ...
    def setDeviceTypeName(self, string: str) -> None: ...
    def setDisplayAttribute(self, string: str) -> None: ...
    def setDisplayName(self, string: str) -> None: ...
    def setOrder(self, int: int) -> None: ...
    def setValueDescriptor(self, valueDescriptor: cern.accsoft.commons.value.ValueDescriptor) -> None: ...
    def setValueType(self, type: cern.accsoft.commons.value.Type) -> None: ...
    def toString(self) -> str: ...
