from typing import List as _py_List
from typing import TypeVar as _py_TypeVar
from typing import Type as _py_Type
from typing import ClassVar as _py_ClassVar
from typing import overload
import cern.accsoft.commons.util
import cern.accsoft.commons.value
import cern.japc.core
import cern.lsa.domain.devices.type
import cern.lsa.domain.exploitation
import cern.lsa.domain.settings
import java.io
import java.lang
import java.util


class CommandType(java.lang.Enum['CommandType']):
    READ: _py_ClassVar['CommandType'] = ...
    STATE: _py_ClassVar['CommandType'] = ...
    WRITE: _py_ClassVar['CommandType'] = ...
    LOAD: _py_ClassVar['CommandType'] = ...
    CHECK_SETTINGS: _py_ClassVar['CommandType'] = ...
    def getType(self) -> str: ...
    def isWriteType(self) -> bool: ...
    def toString(self) -> str: ...
    @classmethod
    @overload
    def valueOf(cls, string: str) -> 'CommandType': ...
    _valueOf_1__T = _py_TypeVar('_valueOf_1__T', bound=java.lang.Enum)  # <T>
    @classmethod
    @overload
    def valueOf(cls, class_: _py_Type[_valueOf_1__T], string: str) -> _valueOf_1__T: ...
    @classmethod
    def valueOfType(cls, string: str) -> 'CommandType': ...
    @classmethod
    def values(cls) -> _py_List['CommandType']: ...

class HwCommand(cern.accsoft.commons.util.Named):
    def createExecutionRequest(self) -> 'HwCommandExecutionRequest': ...
    def createTemplateArgumentsMap(self) -> java.util.Map[str, cern.accsoft.commons.value.ImmutableScalar]: ...
    def getArgumentParameters(self) -> java.util.List['HwCommandParameter']: ...
    def getDeviceType(self) -> str: ...
    def getDisplayMode(self) -> cern.lsa.domain.exploitation.DisplayMode: ...
    def getDisplayName(self) -> str: ...
    def getParameter(self, string: str) -> 'HwCommandParameter': ...
    def getProperties(self) -> java.util.Set[cern.lsa.domain.devices.type.PropertyVersion]: ...
    def getRank(self) -> int: ...
    def getReadBackCommand(self) -> 'HwCommand': ...
    def getResultParameters(self) -> java.util.List['HwCommandParameter']: ...
    def getShortCommandName(self) -> str: ...
    def getType(self) -> CommandType: ...
    def isContextDependent(self) -> bool: ...
    def isCustomCommand(self) -> bool: ...

class HwCommandExecutionRequest:
    def areNonResidentContextsEnabled(self) -> bool: ...
    def getCommand(self) -> HwCommand: ...
    def getContexts(self) -> java.util.Set[cern.lsa.domain.settings.DrivableContext]: ...
    def getDeviceNames(self) -> java.util.List[str]: ...
    def getHardwareGroups(self) -> java.util.List[str]: ...
    def getParameters(self) -> java.util.Map[str, cern.accsoft.commons.value.ImmutableScalar]: ...
    def setContexts(self, collection: java.util.Collection[cern.lsa.domain.settings.DrivableContext]) -> None: ...
    def setDeviceNames(self, collection: java.util.Collection[str]) -> None: ...
    def setHardwareGroups(self, collection: java.util.Collection[str]) -> None: ...
    def setNonResidentContextsEnabled(self, boolean: bool) -> None: ...
    @overload
    def setParameter(self, string: str, immutableScalar: cern.accsoft.commons.value.ImmutableScalar) -> None: ...
    @overload
    def setParameter(self, string: str, string2: str) -> None: ...
    def setParameters(self, map: java.util.Map[str, cern.accsoft.commons.value.ImmutableScalar]) -> None: ...

class HwCommandExecutionResponse:
    def getCommand(self) -> HwCommand: ...
    def getContexts(self) -> java.util.Set[cern.lsa.domain.settings.DrivableContext]: ...
    def getDeviceNames(self) -> java.util.List[str]: ...
    def getDeviceResponses(self) -> java.util.List[cern.japc.core.FailSafeParameterValue]: ...

class HwCommandParameter(cern.accsoft.commons.util.Named):
    def getCommandName(self) -> str: ...
    def getDefaultValue(self) -> cern.accsoft.commons.value.ImmutableScalar: ...
    def getDeviceTypeName(self) -> str: ...
    def getDisplayAttribute(self) -> str: ...
    def getDisplayName(self) -> str: ...
    def getOrder(self) -> int: ...
    def getValueDescriptor(self) -> cern.accsoft.commons.value.ValueDescriptor: ...
    def getValueType(self) -> cern.accsoft.commons.value.Type: ...
    def isArgument(self) -> bool: ...
    def isConstant(self) -> bool: ...

class HwCommandSet(java.io.Serializable):
    def __init__(self): ...
    def addReadCommand(self, hwCommand: HwCommand) -> None: ...
    def addStateCommand(self, hwCommand: HwCommand) -> None: ...
    def addWriteCommand(self, hwCommand: HwCommand) -> None: ...
    def getCommand(self, string: str) -> HwCommand: ...
    @overload
    def getReadCommands(self) -> java.util.SortedSet[HwCommand]: ...
    @overload
    def getReadCommands(self, boolean: bool) -> java.util.SortedSet[HwCommand]: ...
    @overload
    def getStateCommands(self) -> java.util.SortedSet[HwCommand]: ...
    @overload
    def getStateCommands(self, boolean: bool) -> java.util.SortedSet[HwCommand]: ...
    @overload
    def getWriteCommands(self) -> java.util.SortedSet[HwCommand]: ...
    @overload
    def getWriteCommands(self, boolean: bool) -> java.util.SortedSet[HwCommand]: ...
    @classmethod
    def valueOf(cls, hwCommandArray: _py_List[HwCommand]) -> 'HwCommandSet': ...

class HwCommands:
    SIGNATURE_CHECK_PARAMETER_NAME: _py_ClassVar[str] = ...
    HARDWARE_CHECK_PARAMETER_NAME: _py_ClassVar[str] = ...
    NAME_SEPARATOR: _py_ClassVar[str] = ...
    @classmethod
    @overload
    def buildCommandName(cls, string: str, string2: str) -> str: ...
    @classmethod
    @overload
    def buildCommandName(cls, string: str, string2: str, commandType: CommandType) -> str: ...
    @classmethod
    def getCorrespondingReadCommandName(cls, string: str) -> str: ...
