from typing import Any as _py_Any
from typing import List as _py_List
from typing import TypeVar as _py_TypeVar
from typing import Type as _py_Type
from typing import ClassVar as _py_ClassVar
from typing import overload
import cern.accsoft.commons.domain
import cern.accsoft.commons.domain.beamdestinations
import cern.accsoft.commons.domain.beams
import cern.accsoft.commons.domain.lhc
import cern.accsoft.commons.domain.modes
import cern.accsoft.commons.util.value
import cern.accsoft.commons.value
import cern.lsa.client.common
import cern.lsa.domain.cern.devices
import cern.lsa.domain.cern.exploitation
import cern.lsa.domain.cern.optics
import cern.lsa.domain.cern.optics.ofb
import cern.lsa.domain.cern.optics.spi
import cern.lsa.domain.cern.settings
import cern.lsa.domain.cern.settings.ad
import cern.lsa.domain.cern.settings.elena
import cern.lsa.domain.cern.settings.lktim
import cern.lsa.domain.cern.timing
import cern.lsa.domain.cern.timing.enums
import cern.lsa.domain.devices
import cern.lsa.domain.devices.inca
import cern.lsa.domain.optics
import cern.lsa.domain.settings
import cern.lsa.domain.settings.type
import java.lang
import java.time
import java.util


class AcceleratorService(cern.lsa.client.common.CommonAcceleratorService):
    def findActiveAcceleratorMode(self, accelerator: cern.accsoft.commons.domain.Accelerator) -> cern.accsoft.commons.domain.modes.AcceleratorMode: ...
    def findActiveBeamDestinationEndPoint(self, beamDestination: cern.accsoft.commons.domain.beamdestinations.BeamDestination) -> cern.accsoft.commons.domain.beamdestinations.BeamDestinationEndPoint: ...
    def findOpConfigs(self, accelerator: cern.accsoft.commons.domain.Accelerator) -> java.util.Set[str]: ...
    def setActiveAcceleratorMode(self, accelerator: cern.accsoft.commons.domain.Accelerator, acceleratorMode: cern.accsoft.commons.domain.modes.AcceleratorMode) -> None: ...
    def setActiveBeamDestinationEndPoint(self, beamDestination: cern.accsoft.commons.domain.beamdestinations.BeamDestination, beamDestinationEndPoint: cern.accsoft.commons.domain.beamdestinations.BeamDestinationEndPoint) -> None: ...

class AdService:
    def convertCycleTimeToKTime(self, duration: java.time.Duration) -> java.time.Duration: ...
    @overload
    def findCycleStructure(self) -> cern.lsa.domain.cern.settings.ad.AdCycleStructure: ...
    @overload
    def findCycleStructure(self, adCycleStructure: cern.lsa.domain.cern.settings.ad.AdCycleStructure, trimHeader: cern.lsa.domain.settings.TrimHeader) -> cern.lsa.domain.cern.settings.ad.AdCycleStructure: ...
    def findCycleStructureTrims(self, adCycleStructure: cern.lsa.domain.cern.settings.ad.AdCycleStructure) -> java.util.List[cern.lsa.domain.settings.TrimHeader]: ...
    def findEltagNames(self) -> java.util.Set[str]: ...
    def findFlatTopTimeByEltag(self, string: str) -> int: ...
    def findTestCycleStructure(self) -> cern.lsa.domain.cern.settings.ad.AdCycleStructure: ...
    def findTimingProcesses(self) -> java.util.Set[cern.lsa.domain.cern.timing.TimingProcess]: ...
    def saveCycleStructure(self, adCycleStructure: cern.lsa.domain.cern.settings.ad.AdCycleStructure, map: java.util.Map[cern.lsa.domain.settings.Parameter, cern.accsoft.commons.value.ImmutableDiscreteFunctionList], string: str) -> cern.lsa.domain.settings.TrimResponse: ...

class ArchiveReferenceService(cern.lsa.client.common.CommonArchiveReferenceService): ...

class CacheService(cern.lsa.client.common.CommonCacheService): ...

class ClientApplicationConfig:
    def __init__(self): ...
    def acceleratorService(self) -> AcceleratorService: ...
    def archiveReferenceService(self) -> ArchiveReferenceService: ...
    def cacheService(self) -> CacheService: ...
    def contextService(self) -> 'ContextService': ...
    def exploitationService(self) -> 'ExploitationService': ...
    def fidelService(self) -> 'FidelService': ...
    def generationService(self) -> 'GenerationService': ...
    def hyperCycleService(self) -> 'HyperCycleService': ...
    def japcService(self) -> 'JapcService': ...
    def knobService(self) -> 'KnobService': ...
    def lhcService(self) -> 'LhcService': ...
    def opticService(self) -> 'OpticService': ...
    def parameterService(self) -> 'ParameterService': ...
    def settingService(self) -> 'SettingService': ...
    def spsService(self) -> 'SpsService': ...
    def testService(self) -> 'TestService': ...
    def timingService(self) -> 'TimingService': ...
    def transactionService(self) -> cern.lsa.client.common.TransactionService: ...
    def trimService(self) -> 'TrimService': ...

class ContextService(cern.lsa.client.common.CommonContextService):
    def findActiveContexts(self, accelerator: cern.accsoft.commons.domain.Accelerator) -> java.util.Set[cern.lsa.domain.settings.StandAloneContext]: ...
    def findActiveTimingUsers(self, accelerator: cern.accsoft.commons.domain.Accelerator) -> cern.lsa.domain.cern.timing.ActiveTimingUsers: ...
    def findLoggingHistory(self, long: int, long2: int, accelerator: cern.accsoft.commons.domain.Accelerator) -> java.util.List[cern.lsa.domain.settings.UserContextMapping]: ...

class DeviceService(cern.lsa.client.common.CommonDeviceService):
    def findPowerConverterInfosByDeviceIds(self, collection: java.util.Collection[int]) -> java.util.Set[cern.lsa.domain.optics.PowerConverterInfo]: ...

class ElenaService:
    @overload
    def findCycleStructure(self, standAloneCycle: cern.lsa.domain.settings.StandAloneCycle) -> cern.lsa.domain.cern.settings.elena.ElenaCycleStructure: ...
    @overload
    def findCycleStructure(self, standAloneCycle: cern.lsa.domain.settings.StandAloneCycle, trimHeader: cern.lsa.domain.settings.TrimHeader) -> cern.lsa.domain.cern.settings.elena.ElenaCycleStructure: ...
    def findCycleStructureTrims(self, standAloneCycle: cern.lsa.domain.settings.StandAloneCycle) -> java.util.List[cern.lsa.domain.settings.TrimHeader]: ...
    def findFlatTopTimeByEltag(self, standAloneCycle: cern.lsa.domain.settings.StandAloneCycle, eLTAG: cern.lsa.domain.cern.settings.elena.ELTAG) -> java.time.Duration: ...
    def findTimingProcesses(self) -> java.util.Set[cern.lsa.domain.cern.timing.TimingProcess]: ...
    def saveCycleSettings(self, standAloneCycle: cern.lsa.domain.settings.StandAloneCycle, elenaCycleSettings: cern.lsa.domain.cern.settings.elena.ElenaCycleSettings, string: str) -> cern.lsa.domain.settings.TrimResponse: ...

class ExploitationService(cern.lsa.client.common.CommonExploitationService):
    def calculateTimeToReachNewValues(self, contextSettings: cern.lsa.domain.settings.ContextSettings) -> cern.lsa.domain.cern.exploitation.TimeToReachNewValues: ...

class FidelService:
    def calcInjPhaseError(self, string: str, list: java.util.List[str], standAloneBeamProcess: cern.lsa.domain.settings.StandAloneBeamProcess, fidelTaskResultImpl: cern.lsa.domain.cern.optics.spi.FidelTaskResultImpl) -> java.util.Map[cern.lsa.domain.settings.Parameter, cern.accsoft.commons.value.DiscreteFunction]: ...
    def calcRampPhaseError(self, string: str, standAloneBeamProcess: cern.lsa.domain.settings.StandAloneBeamProcess, string2: str, map: java.util.Map[cern.lsa.domain.settings.Parameter, float], fidelTaskResultImpl: cern.lsa.domain.cern.optics.spi.FidelTaskResultImpl) -> java.util.Map[cern.lsa.domain.settings.Parameter, cern.accsoft.commons.value.DiscreteFunction]: ...
    def findAllCalibrations(self) -> _py_List[cern.lsa.domain.optics.Calibration]: ...
    def findAllHarmonics(self) -> _py_List[cern.lsa.domain.cern.optics.FieldHarmonic]: ...
    def findCalibrationByLogicalHardware(self, string: str) -> cern.lsa.domain.optics.Calibration: ...
    @overload
    def findComponentsNames(self, string: str) -> _py_List[str]: ...
    @overload
    def findComponentsNames(self, long: int) -> _py_List[str]: ...
    def findFidelModels(self) -> _py_List[cern.lsa.domain.cern.optics.FidelModel]: ...
    def findHarmonics(self, string: str, string2: str) -> _py_List[cern.lsa.domain.cern.optics.FieldHarmonic]: ...
    @overload
    def findModel(self, string: str) -> cern.lsa.domain.cern.optics.FidelModel: ...
    @overload
    def findModel(self, long: int) -> cern.lsa.domain.cern.optics.FidelModel: ...
    def generateHarmonics(self, string: str, string2: str, string3: str) -> cern.lsa.domain.cern.optics.FieldHarmonic: ...
    def generateMainCalibration(self, string: str, string2: str, calibrationFunctionTypes: cern.lsa.domain.optics.CalibrationFunctionTypes) -> cern.lsa.domain.optics.Calibration: ...
    def getLastPowHistIFT(self, string: str) -> float: ...
    def getLastPowHistTFT(self, string: str) -> float: ...
    def getLastPowHistTPre(self, string: str) -> float: ...
    def isTune(self, string: str) -> bool: ...
    def setActiveModel(self, stringArray: _py_List[str], long: int) -> None: ...
    def updateFieldHarmonic(self, fieldHarmonic: cern.lsa.domain.cern.optics.FieldHarmonic) -> None: ...
    def updateMainCalibration(self, calibration: cern.lsa.domain.optics.Calibration) -> None: ...

class GenerationService(cern.lsa.client.common.CommonGenerationService):
    @overload
    def findIncorporationRanges(self, string: str, string2: str) -> java.util.List[cern.lsa.domain.settings.type.IncorporationRange]: ...
    @overload
    def findIncorporationRanges(self, string: str) -> java.util.List[cern.lsa.domain.settings.type.IncorporationRange]: ...
    def previewEnergy(self, beamProcessType: cern.lsa.domain.settings.type.BeamProcessType) -> cern.accsoft.commons.value.DiscreteFunction: ...

class HyperCycleService:
    def findActiveHyperCycle(self) -> cern.lsa.domain.settings.HyperCycle: ...
    def findHyperCycle(self, string: str) -> cern.lsa.domain.settings.HyperCycle: ...
    def findHyperCycles(self) -> java.util.Set[cern.lsa.domain.settings.HyperCycle]: ...
    def makeHyperCycleActive(self, string: str) -> None: ...
    def removeHyperCycle(self, hyperCycle: cern.lsa.domain.settings.HyperCycle) -> None: ...
    def saveHyperCycle(self, hyperCycle: cern.lsa.domain.settings.HyperCycle) -> None: ...

class IncaService:
    def findIncaPropertyFieldInfos(self, incaPropertyFieldInfosRequest: cern.lsa.domain.devices.inca.IncaPropertyFieldInfosRequest) -> java.util.Set[cern.lsa.domain.devices.inca.IncaPropertyFieldInfo]: ...
    def saveIncaPropertyFieldInfos(self, collection: java.util.Collection[cern.lsa.domain.devices.inca.IncaPropertyFieldInfo]) -> None: ...

class JapcService(cern.lsa.client.common.CommonJapcService): ...

class KnobService(cern.lsa.client.common.CommonKnobService): ...

class LhcService:
    def calculateKfromIREF(self, map: java.util.Map[str, float], double: float) -> java.util.Map[str, float]: ...
    def computeTuneFeedbackResponseMatrix(self, standAloneBeamProcess: cern.lsa.domain.settings.StandAloneBeamProcess, list: java.util.List[str], list2: java.util.List[cern.accsoft.commons.value.ImmutableScalar], collection: java.util.Collection[str]) -> _py_List[_py_List[float]]: ...
    def createFillDirectory(self, int: int) -> None: ...
    def deleteOrbit(self, ofbOrbit: cern.lsa.domain.cern.optics.ofb.OfbOrbit) -> None: ...
    def deleteReadingSet(self, ofbReadingSet: cern.lsa.domain.cern.optics.ofb.OfbReadingSet) -> None: ...
    def findAcceleratorModeTimingEvents(self) -> java.util.Map[cern.accsoft.commons.domain.modes.LhcAcceleratorMode, int]: ...
    def findActiveBeamMode(self) -> cern.accsoft.commons.domain.modes.LhcBeamMode: ...
    def findActiveLhcSectorMode(self, lhcSector: cern.accsoft.commons.domain.lhc.LhcSector) -> cern.accsoft.commons.domain.modes.LhcAcceleratorMode: ...
    def findActiveLhcSectorModes(self) -> java.util.Map[cern.accsoft.commons.domain.lhc.LhcSector, cern.accsoft.commons.domain.modes.LhcAcceleratorMode]: ...
    def findActiveParticleTypeRing1(self) -> cern.accsoft.commons.domain.ParticleType: ...
    def findActiveParticleTypeRing2(self) -> cern.accsoft.commons.domain.ParticleType: ...
    def findAllCalibrationsByDevices(self) -> java.util.Map[str, cern.lsa.domain.optics.RFCalibration]: ...
    def findBeamModeTimingEvents(self) -> java.util.Map[cern.accsoft.commons.domain.modes.LhcBeamMode, int]: ...
    def findBlmAppliedThresholds(self, string: str) -> java.util.Map[str, cern.lsa.domain.cern.devices.ThresholdsAwareBlmInfo]: ...
    def findBlmCrateInfos(self, collection: java.util.Collection[str]) -> java.util.Map[str, cern.lsa.domain.cern.devices.BlmCrateInfo]: ...
    def findBlmFamilies(self) -> java.util.Set[cern.lsa.domain.cern.devices.BlmFamily]: ...
    def findBlmInfos(self) -> java.util.Map[str, cern.lsa.domain.cern.devices.BlmInfo]: ...
    def findBlmInfosByCrate(self, string: str) -> java.util.Map[str, cern.lsa.domain.cern.devices.BlmInfo]: ...
    def findBlmRSTimes(self) -> _py_List[int]: ...
    def findCollimatorAlignmentHistory(self, collection: java.util.Collection[str], string: str, date: java.util.Date, date2: java.util.Date) -> java.util.Map[str, java.util.List[cern.lsa.domain.cern.devices.CollimatorAlignment]]: ...
    def findCollimatorAlignments(self, collection: java.util.Collection[str], string: str) -> java.util.Map[str, cern.lsa.domain.cern.devices.CollimatorAlignment]: ...
    def findCurrentFillNumber(self) -> int: ...
    def findCurrentLhcBeamLossMap(self) -> cern.lsa.domain.cern.devices.LhcBeamLossMap: ...
    def findLHCHandShakes(self) -> java.util.Map[str, str]: ...
    def findLhcBeamLossMapBeamModeCategories(self) -> java.util.Set[str]: ...
    def findLhcBeamLossMapConfigTypes(self) -> java.util.Set[str]: ...
    def findLhcBeamLossMapHistory(self) -> java.util.List[cern.lsa.domain.cern.devices.LhcBeamLossMap.LhcBeamLossMapEntry]: ...
    def findLhcBlmExpertNamesByType(self) -> java.util.Map[str, java.util.List[str]]: ...
    def findLhcCollimatorInfos(self, collection: java.util.Collection[str]) -> java.util.Map[str, cern.lsa.domain.cern.devices.LhcCollimatorInfo]: ...
    def findMinimalBeamProcessTime(self, collection: java.util.Collection[cern.accsoft.commons.util.value.Pair[str, float]]) -> java.util.List[cern.lsa.domain.cern.settings.BeamProcessTypeOpticTransitionInfo]: ...
    def findOfbOpticTable(self, string: str) -> java.util.List[cern.lsa.domain.cern.optics.ofb.OfbOpticsTableItem]: ...
    def findOpticIdsByOrbitIds(self, longArray: _py_List[int]) -> java.util.Map[int, java.util.Set[int]]: ...
    def findOrbitIdsByOpticIds(self, longArray: _py_List[int]) -> java.util.Map[int, int]: ...
    def findOrbits(self) -> java.util.Set[cern.lsa.domain.cern.optics.ofb.OfbOrbit]: ...
    def findParabolicFractions(self, string: str) -> cern.accsoft.commons.value.ImmutableDiscreteFunction: ...
    @overload
    def findReadingSets(self) -> java.util.Set[cern.lsa.domain.cern.optics.ofb.OfbReadingSet]: ...
    @overload
    def findReadingSets(self, ofbReadingSetType: cern.lsa.domain.cern.optics.ofb.OfbReadingSetType) -> java.util.Set[cern.lsa.domain.cern.optics.ofb.OfbReadingSet]: ...
    def findReadingSetsWithReadings(self, collection: java.util.Collection[cern.lsa.domain.cern.optics.ofb.OfbReadingSet]) -> java.util.Set[cern.lsa.domain.cern.optics.ofb.OfbReadingSet]: ...
    @overload
    def findResidentStandAloneBeamProcessesByTime(self, long: int) -> java.util.Map[str, cern.lsa.domain.settings.StandAloneBeamProcess]: ...
    @overload
    def findResidentStandAloneBeamProcessesByTime(self, long: int, long2: int) -> java.util.Map[str, java.util.Set[cern.lsa.domain.settings.StandAloneBeamProcess]]: ...
    def getRfFgcChannelMap(self) -> java.util.Map[str, cern.lsa.domain.cern.devices.RfFgcChannel]: ...
    def incrementFillNumber(self) -> int: ...
    def makeLHCUserResident(self, string: str) -> None: ...
    def saveCollimatorAlignments(self, collection: java.util.Collection[cern.lsa.domain.cern.devices.CollimatorAlignment]) -> None: ...
    def saveOfbOpticsTable(self, collection: java.util.Collection[cern.lsa.domain.cern.optics.ofb.OfbOpticsTableItem]) -> None: ...
    def saveOpticOrbitAssignment(self, map: java.util.Map[int, int]) -> None: ...
    def saveOrbit(self, ofbOrbit: cern.lsa.domain.cern.optics.ofb.OfbOrbit) -> None: ...
    def saveParabolicFractions(self, string: str, immutableDiscreteFunction: cern.accsoft.commons.value.ImmutableDiscreteFunction) -> None: ...
    def saveReadingSet(self, ofbReadingSet: cern.lsa.domain.cern.optics.ofb.OfbReadingSet) -> None: ...
    def setActiveBeamMode(self, lhcBeamMode: cern.accsoft.commons.domain.modes.LhcBeamMode) -> None: ...
    def setActiveLhcSectorMode(self, lhcSector: cern.accsoft.commons.domain.lhc.LhcSector, lhcAcceleratorMode: cern.accsoft.commons.domain.modes.LhcAcceleratorMode) -> None: ...
    def setActiveParticleTypeRing1(self, particleType: cern.accsoft.commons.domain.ParticleType) -> None: ...
    def setActiveParticleTypeRing2(self, particleType: cern.accsoft.commons.domain.ParticleType) -> None: ...
    def setHandshakeProperty(self, string: str, string2: str) -> None: ...
    def updateBeamLossMap(self, lhcBeam: cern.accsoft.commons.domain.beams.LhcBeam, string: str, string2: str, long: int, long2: int) -> None: ...

class LktimService:
    def canAddDeviceToTree(self, string: str, lktimTree: cern.lsa.domain.cern.settings.lktim.LktimTree) -> cern.lsa.domain.cern.settings.lktim.NodeAdditionCheckResult: ...
    def createNode(self, string: str) -> cern.lsa.domain.cern.settings.lktim.LktimTreeNode: ...
    def createTree(self, string: str) -> cern.lsa.domain.cern.settings.lktim.LktimTree: ...
    def deleteTree(self, lktimTree: cern.lsa.domain.cern.settings.lktim.LktimTree) -> None: ...
    def findOverlappingTreeNames(self, string: str) -> java.util.Set[str]: ...
    def findReferenceSettings(self, standAloneCycle: cern.lsa.domain.settings.StandAloneCycle, lktimTree: cern.lsa.domain.cern.settings.lktim.LktimTree) -> cern.lsa.domain.cern.settings.lktim.LktimTreeSettings: ...
    def findSettings(self, standAloneCycle: cern.lsa.domain.settings.StandAloneCycle, lktimTree: cern.lsa.domain.cern.settings.lktim.LktimTree) -> cern.lsa.domain.cern.settings.lktim.LktimTreeSettings: ...
    def findStatus(self, standAloneCycle: cern.lsa.domain.settings.StandAloneCycle, collection: java.util.Collection[str]) -> java.util.Map[str, cern.lsa.domain.cern.settings.lktim.LktimTreeStatus]: ...
    def findTimingDevices(self) -> java.util.Set[cern.lsa.domain.devices.Device]: ...
    def findTree(self, string: str) -> cern.lsa.domain.cern.settings.lktim.LktimTree: ...
    def findTreeFromHistory(self, string: str, date: java.util.Date) -> cern.lsa.domain.cern.settings.lktim.LktimTree: ...
    def findTreeNames(self) -> java.util.Set[str]: ...
    def findTreesByDeviceNames(self, collection: java.util.Collection[str], date: java.util.Date) -> java.util.Map[str, java.util.Set[str]]: ...
    def isTreeExisting(self, string: str) -> bool: ...
    def saveReferenceSettings(self, standAloneCycle: cern.lsa.domain.settings.StandAloneCycle, lktimTree: cern.lsa.domain.cern.settings.lktim.LktimTree) -> None: ...
    def saveSettings(self, lktimTreeSettings: cern.lsa.domain.cern.settings.lktim.LktimTreeSettings) -> None: ...
    def saveTree(self, lktimTree: cern.lsa.domain.cern.settings.lktim.LktimTree) -> cern.lsa.domain.cern.settings.lktim.LktimTree: ...

class LsaServiceLocator:
    @classmethod
    def builder(cls) -> 'LsaServiceLocator.LsaServiceLocatorBuilder': ...
    _get__T = _py_TypeVar('_get__T')  # <T>
    def get(self, class_: _py_Type[_get__T]) -> _get__T: ...
    def getDatabaseName(self) -> str: ...
    @classmethod
    def getLsaServiceLocator(cls) -> 'LsaServiceLocator': ...
    def getServerName(self) -> str: ...
    _getService__T = _py_TypeVar('_getService__T')  # <T>
    @classmethod
    def getService(cls, class_: _py_Type[_getService__T]) -> _getService__T: ...
    def isRbacEnabled(self) -> bool: ...
    def isTwoTier(self) -> bool: ...
    class LsaServer(java.lang.Enum['LsaServiceLocator.LsaServer']):
        AD: _py_ClassVar['LsaServiceLocator.LsaServer'] = ...
        CTF: _py_ClassVar['LsaServiceLocator.LsaServer'] = ...
        ISOLDE: _py_ClassVar['LsaServiceLocator.LsaServer'] = ...
        SPS: _py_ClassVar['LsaServiceLocator.LsaServer'] = ...
        LHC: _py_ClassVar['LsaServiceLocator.LsaServer'] = ...
        PS: _py_ClassVar['LsaServiceLocator.LsaServer'] = ...
        PSB: _py_ClassVar['LsaServiceLocator.LsaServer'] = ...
        LEIR: _py_ClassVar['LsaServiceLocator.LsaServer'] = ...
        GPN: _py_ClassVar['LsaServiceLocator.LsaServer'] = ...
        ELENA: _py_ClassVar['LsaServiceLocator.LsaServer'] = ...
        AWAKE: _py_ClassVar['LsaServiceLocator.LsaServer'] = ...
        TESTBED: _py_ClassVar['LsaServiceLocator.LsaServer'] = ...
        NEXT: _py_ClassVar['LsaServiceLocator.LsaServer'] = ...
        NEXT_INCA: _py_ClassVar['LsaServiceLocator.LsaServer'] = ...
        NEXT_INCA_PSB: _py_ClassVar['LsaServiceLocator.LsaServer'] = ...
        NEXT_INCA_PS: _py_ClassVar['LsaServiceLocator.LsaServer'] = ...
        INTEGRATION: _py_ClassVar['LsaServiceLocator.LsaServer'] = ...
        DEV: _py_ClassVar['LsaServiceLocator.LsaServer'] = ...
        LOCAL: _py_ClassVar['LsaServiceLocator.LsaServer'] = ...
        @classmethod
        @overload
        def valueOf(cls, string: str) -> 'LsaServiceLocator.LsaServer': ...
        _valueOf_1__T = _py_TypeVar('_valueOf_1__T', bound=java.lang.Enum)  # <T>
        @classmethod
        @overload
        def valueOf(cls, class_: _py_Type[_valueOf_1__T], string: str) -> _valueOf_1__T: ...
        @classmethod
        def values(cls) -> _py_List['LsaServiceLocator.LsaServer']: ...
    class LsaServiceLocatorBuilder:
        def __init__(self): ...
        def accelerator(self, accelerator: cern.accsoft.commons.domain.Accelerator) -> 'LsaServiceLocator.LsaServiceLocatorBuilder': ...
        def build(self) -> 'LsaServiceLocator': ...
        def clientCacheEnabled(self, boolean: bool) -> 'LsaServiceLocator.LsaServiceLocatorBuilder': ...
        def lsaServer(self, lsaServer: 'LsaServiceLocator.LsaServer') -> 'LsaServiceLocator.LsaServiceLocatorBuilder': ...

class OpticService(cern.lsa.client.common.CommonOpticService):
    def findConfigurationParameters(self, string: str) -> java.util.Map[str, str]: ...
    def findContextOpticsTables(self, standAloneContext: cern.lsa.domain.settings.StandAloneContext) -> java.util.Collection[cern.lsa.domain.optics.OpticsTable]: ...
    def saveOptic(self, optic: cern.lsa.domain.optics.Optic) -> None: ...
    def saveTwisses(self, collection: java.util.Collection[cern.lsa.domain.optics.Twiss]) -> None: ...
    def updateOptic(self, optic: cern.lsa.domain.optics.Optic) -> None: ...
    def updateOpticForActualBeamProcess(self, standAloneBeamProcess: cern.lsa.domain.settings.StandAloneBeamProcess, string: str) -> None: ...
    def updateTwisses(self, collection: java.util.Collection[cern.lsa.domain.optics.Twiss]) -> None: ...

class ParameterService(cern.lsa.client.common.CommonParameterService):
    def findParametersInKnobs(self, accelerator: cern.accsoft.commons.domain.Accelerator) -> java.util.Set[str]: ...
    def findParametersInWorkingSets(self, accelerator: cern.accsoft.commons.domain.Accelerator) -> java.util.Set[str]: ...

class ServiceLocator:
    JDBC_PROPERTIES: _py_ClassVar[str] = ...
    DATABASE_PROPERTY_NAME: _py_ClassVar[str] = ...
    SERVER_PROPERTIES: _py_ClassVar[str] = ...
    SERVER_PROPERTY_NAME: _py_ClassVar[str] = ...
    PROTOCOL_PROPERTY: _py_ClassVar[str] = ...
    MODE_PROPERTY_NAME: _py_ClassVar[str] = ...
    MODE_3_TIER: _py_ClassVar[str] = ...
    MODE_2_TIER: _py_ClassVar[str] = ...
    MODE_DEFAULT: _py_ClassVar[str] = ...
    _getService_0__T = _py_TypeVar('_getService_0__T')  # <T>
    @classmethod
    @overload
    def getService(cls, class_: _py_Type[_getService_0__T]) -> _getService_0__T: ...
    @classmethod
    @overload
    def getService(cls, string: str) -> _py_Any: ...
    @classmethod
    def isTwoTier(cls) -> bool: ...

class SettingService(cern.lsa.client.common.CommonSettingService):
    def compareSettings(self, settingComparisonRequest: cern.lsa.domain.settings.SettingComparisonRequest) -> cern.lsa.domain.settings.SettingComparisonResponse: ...

class SettingsComparator:
    def compare(self, settingComparisonRequest: cern.lsa.domain.settings.SettingComparisonRequest, errorsAwareContextSettings: cern.lsa.domain.settings.ErrorsAwareContextSettings, errorsAwareContextSettings2: cern.lsa.domain.settings.ErrorsAwareContextSettings, parameterArray: _py_List[cern.lsa.domain.settings.Parameter]) -> java.util.Map[cern.lsa.domain.settings.Parameter, cern.lsa.domain.settings.SettingComparisonParameterResult]: ...

class SettingsLoader:
    def loadSettings(self, standAloneContext: cern.lsa.domain.settings.StandAloneContext, settingsSource: cern.lsa.domain.settings.SettingsSource, standAloneContext2: cern.lsa.domain.settings.StandAloneContext, settingsSource2: cern.lsa.domain.settings.SettingsSource, parameterArray: _py_List[cern.lsa.domain.settings.Parameter]) -> cern.accsoft.commons.util.value.Pair[cern.lsa.domain.settings.ErrorsAwareContextSettings, cern.lsa.domain.settings.ErrorsAwareContextSettings]: ...

class SpsService:
    def findBctMarkers(self, standAloneContext: cern.lsa.domain.settings.StandAloneContext) -> java.util.Set[cern.lsa.domain.cern.exploitation.BctMarker]: ...
    def findBctMarkersForActiveContexts(self) -> java.util.Map[str, java.util.Set[cern.lsa.domain.cern.exploitation.BctMarker]]: ...
    def findBctMarkersForResidentContexts(self) -> java.util.Map[str, java.util.Set[cern.lsa.domain.cern.exploitation.BctMarker]]: ...
    def findBctMarkersForTimingUsers(self, collection: java.util.Collection[str]) -> java.util.Map[str, java.util.Set[cern.lsa.domain.cern.exploitation.BctMarker]]: ...

class TestService:
    def fakeDrive(self) -> str: ...
    @overload
    def fakeTrim(self, trimRequest: cern.lsa.domain.settings.TrimRequest) -> str: ...
    @overload
    def fakeTrim(self, trimRequestArray: _py_List[cern.lsa.domain.settings.TrimRequest]) -> str: ...
    def saveActiveBeamMode(self, string: str, string2: str) -> None: ...

class TimingService(cern.lsa.client.common.CommonTimingService):
    def abortEventTable(self, eventTable: cern.lsa.domain.cern.timing.EventTable) -> None: ...
    def clearCirculatingBunchConfig(self, lhcBeam: cern.accsoft.commons.domain.beams.LhcBeam) -> None: ...
    def clearSequencerReservation(self) -> None: ...
    def continueEventTable(self, eventTable: cern.lsa.domain.cern.timing.EventTable) -> None: ...
    def deleteEventTable(self, eventTable: cern.lsa.domain.cern.timing.EventTable) -> None: ...
    def deleteInjectionBunchConfig(self, string: str) -> None: ...
    def deleteInjectionRequest(self, string: str) -> None: ...
    def deleteInjectionScheme(self, string: str) -> None: ...
    def deleteOneBunchFromCirculatingBunchConfig(self, int: int, lhcBeam: cern.accsoft.commons.domain.beams.LhcBeam) -> None: ...
    def findActiveInjectionRequest(self) -> cern.lsa.domain.cern.timing.LhcInjection: ...
    def findActiveInjectionScheme(self) -> cern.lsa.domain.cern.timing.LhcInjectionScheme: ...
    def findAllBunchPatterns(self) -> _py_List[cern.lsa.domain.cern.timing.BunchPattern]: ...
    def findAllEventTables(self) -> java.util.List[cern.lsa.domain.cern.timing.EventTable]: ...
    def findAllEventTypes(self) -> java.util.List[cern.lsa.domain.cern.timing.EventType]: ...
    def findAllInjectionBunchConfiguration(self) -> _py_List[cern.lsa.domain.cern.timing.LhcInjectionBunchConfiguration]: ...
    def findAllInjectionSchemeOnlyHeaders(self) -> java.util.List[cern.lsa.domain.cern.timing.LhcInjectionScheme]: ...
    def findAllInjectionSchemes(self) -> java.util.List[cern.lsa.domain.cern.timing.LhcInjectionScheme]: ...
    def findAllInjections(self) -> java.util.List[cern.lsa.domain.cern.timing.LhcInjection]: ...
    def findAllSchemeGroups(self) -> java.util.List[str]: ...
    def findCirculatingBunchConfiguration(self, lhcBeam: cern.accsoft.commons.domain.beams.LhcBeam) -> cern.lsa.domain.cern.timing.LhcCirculatingBunchConfiguration: ...
    def findEventTableByName(self, string: str) -> cern.lsa.domain.cern.timing.EventTable: ...
    def findEventTypeByName(self, string: str) -> cern.lsa.domain.cern.timing.EventType: ...
    def findInjectionByName(self, string: str) -> cern.lsa.domain.cern.timing.LhcInjection: ...
    def findInjectionSchemeByName(self, string: str) -> cern.lsa.domain.cern.timing.LhcInjectionScheme: ...
    def findSequencerReservation(self) -> str: ...
    def getInjectionRequestStatusParameter(self) -> str: ...
    def getLSAMasterRequestStatusParameter(self) -> str: ...
    def getLhcCirculatingBunchConfiguration(self, lhcBeam: cern.accsoft.commons.domain.beams.LhcBeam) -> cern.lsa.domain.cern.timing.LhcCirculatingBunchConfiguration: ...
    def getLoadedEventTableList(self) -> java.util.List[str]: ...
    def getLoadedEventTables(self) -> _py_List[cern.lsa.domain.cern.timing.LoadedEventTable]: ...
    def getReservedEventNames(self) -> _py_List[str]: ...
    def getTelegramGroupValue(self, string: str) -> int: ...
    def insertNewInjectionIntoCiculatingBunchConfig(self, lhcInjection: cern.lsa.domain.cern.timing.LhcInjection) -> None: ...
    def isInjectionConfigUsed(self, string: str) -> bool: ...
    def isInjectionRequestUsed(self, string: str) -> bool: ...
    def isLSAMaster(self) -> bool: ...
    def isSchemeExisting(self, string: str) -> bool: ...
    @overload
    def loadEventTable(self, eventTable: cern.lsa.domain.cern.timing.EventTable) -> None: ...
    @overload
    def loadEventTable(self, string: str) -> None: ...
    def postInjectionRequest(self, lhcInjection: cern.lsa.domain.cern.timing.LhcInjection) -> None: ...
    def replaceBucketsIntoCirculatingBunchConfig(self, intArray: _py_List[int], lhcBeam: cern.accsoft.commons.domain.beams.LhcBeam) -> None: ...
    def reserveSequencer(self, string: str) -> None: ...
    def saveBunchPattern(self, bunchPattern: cern.lsa.domain.cern.timing.BunchPattern) -> None: ...
    def saveEventTable(self, eventTable: cern.lsa.domain.cern.timing.EventTable) -> None: ...
    def saveInjectionBunchConfiguration(self, lhcInjectionBunchConfiguration: cern.lsa.domain.cern.timing.LhcInjectionBunchConfiguration) -> None: ...
    def saveInjectionRequest(self, lhcInjection: cern.lsa.domain.cern.timing.LhcInjection) -> None: ...
    def saveInjectionScheme(self, lhcInjectionScheme: cern.lsa.domain.cern.timing.LhcInjectionScheme) -> None: ...
    def sendEvent(self, event: cern.lsa.domain.cern.timing.Event, int: int) -> None: ...
    def sendEvents(self, set: java.util.Set[cern.lsa.domain.cern.timing.Event], int: int) -> None: ...
    def setActiveInjectionRequest(self, string: str) -> None: ...
    def setActiveInjectionScheme(self, string: str) -> None: ...
    def setLSAMaster(self, boolean: bool) -> None: ...
    def setTelegramGroup(self, string: str, int: int) -> None: ...
    @overload
    def stopEventTable(self, eventTable: cern.lsa.domain.cern.timing.EventTable) -> None: ...
    @overload
    def stopEventTable(self, string: str) -> None: ...
    @overload
    def unloadEventTable(self, eventTable: cern.lsa.domain.cern.timing.EventTable) -> None: ...
    @overload
    def unloadEventTable(self, string: str) -> None: ...
    def unreserveSequencer(self, string: str) -> None: ...
    def updateEventTable(self, eventTable: cern.lsa.domain.cern.timing.EventTable) -> None: ...
    def updateInjectionBunchCongig(self, lhcInjectionBunchConfiguration: cern.lsa.domain.cern.timing.LhcInjectionBunchConfiguration) -> None: ...
    def updateInjectionRequestBeamType(self, string: str, bEAM_TYPE: cern.lsa.domain.cern.timing.enums.BEAM_TYPE) -> None: ...
    def updateStartConditionOnLoadedTable(self, string: str, string2: str, int: int, int2: int) -> None: ...

class TrimService(cern.lsa.client.common.CommonTrimService): ...
