from typing import Any as _py_Any
from typing import List as _py_List
from typing import TypeVar as _py_TypeVar
from typing import Generic as _py_Generic
from typing import overload
import cern.japc.core
import cern.japc.core.factory
import cern.japc.core.spi
import cern.japc.core.spi.cache
import cern.japc.core.spi.factory
import cern.japc.core.spi.group
import cern.japc.core.spi.subscription
import cern.japc.core.transaction
import cern.japc.value
import java.io
import java.util


_ChainOfResponsibilityBuilder__T = _py_TypeVar('_ChainOfResponsibilityBuilder__T')  # <T>
class ChainOfResponsibilityBuilder(_py_Generic[_ChainOfResponsibilityBuilder__T]):
    def build(self) -> java.util.List[_ChainOfResponsibilityBuilder__T]: ...

class CompositeParameterCreatorImpl(cern.japc.core.spi.factory.CompositeParameterCreator):
    def __init__(self, map: java.util.Map[str, 'CompositeParameterStructure']): ...
    @overload
    def createParameter(self, parameterUrl: cern.japc.core.spi.ParameterUrl, parameterDescriptor: cern.japc.core.ParameterDescriptor, valueDescriptor: cern.japc.value.ValueDescriptor, parameterFactory: cern.japc.core.factory.ParameterFactory) -> cern.japc.core.transaction.TransactionalParameter: ...
    @overload
    def createParameter(self, parameterUrl: cern.japc.core.spi.ParameterUrl, parameterDescriptor: cern.japc.core.ParameterDescriptor, valueDescriptor: cern.japc.value.ValueDescriptor, parameterFactory: cern.japc.core.factory.ParameterFactory, internalParameterCharacteristics: cern.japc.core.spi.factory.InternalParameterCharacteristics) -> cern.japc.core.transaction.TransactionalParameter: ...
    def isKnownCompositeParameter(self, parameterUrl: cern.japc.core.spi.ParameterUrl) -> bool: ...

class CompositeParameterStructure:
    @overload
    def __init__(self, stringArray: _py_List[str], object: _py_Any): ...
    @overload
    def __init__(self, stringArray: _py_List[str], object: _py_Any, groupSubscriptionStrategyFactory: cern.japc.core.spi.group.GroupSubscriptionStrategyFactory): ...
    def getAdapter(self) -> _py_Any: ...
    def getComponents(self) -> _py_List[str]: ...
    def getGroupingStrategyFactory(self) -> cern.japc.core.spi.group.GroupSubscriptionStrategyFactory: ...
    def setGroupingStrategyFactory(self, groupSubscriptionStrategyFactory: cern.japc.core.spi.group.GroupSubscriptionStrategyFactory) -> None: ...

class ParameterCreatorConfigurationManager:
    def getConfig(self, parameterCreatorId: 'ParameterCreatorId') -> java.util.Properties: ...

class ParameterCreatorId(java.io.Serializable):
    def __init__(self, string: str, string2: str): ...
    def equals(self, object: _py_Any) -> bool: ...
    def getProtocol(self) -> str: ...
    def getServiceName(self) -> str: ...
    def hashCode(self) -> int: ...
    def isProtocolDefined(self) -> bool: ...
    def toString(self) -> str: ...

class ParameterMetaFactory(cern.japc.core.factory.ParameterFactory, cern.japc.core.factory.ParameterMetaFactoryConstants):
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, serviceNameResolverArray: _py_List[cern.japc.core.factory.ServiceNameResolver], serviceConfigLookupArray: _py_List[cern.japc.core.spi.factory.ServiceConfigLookup]): ...
    @overload
    def __init__(self, serviceNameResolverArray: _py_List[cern.japc.core.factory.ServiceNameResolver], serviceConfigLookupArray: _py_List[cern.japc.core.spi.factory.ServiceConfigLookup], string: str, string2: str): ...
    def registerInParameterFactory(self) -> None: ...
    def setCompositeParameterCreator(self, compositeParameterCreator: cern.japc.core.spi.factory.CompositeParameterCreator) -> None: ...
    def setWildcardSelectorResolver(self, wildcardSelectorResolver: cern.japc.core.spi.subscription.WildcardSelectorResolver) -> None: ...

class ServiceConfigLookups: ...

class ServiceNameResolvers: ...

class ParameterCreatorConfigurationManagerImpl(ParameterCreatorConfigurationManager, cern.japc.core.spi.cache.JapcCache):
    def __init__(self, serviceConfigLookupArray: _py_List[cern.japc.core.spi.factory.ServiceConfigLookup]): ...
    def clearAll(self) -> None: ...
    def getConfig(self, parameterCreatorId: ParameterCreatorId) -> java.util.Properties: ...
    def toString(self) -> str: ...
