from typing import Any as _py_Any
from typing import List as _py_List
from typing import TypeVar as _py_TypeVar
from typing import overload
import cern.accsoft.commons.value
import cern.accsoft.commons.value.expression
import cern.accsoft.commons.value.operation
import cern.accsoft.commons.value.spi
import cern.japc.value
import java.io
import java.util


class AbstractMathFunction(cern.accsoft.commons.value.MathFunction):
    def __init__(self): ...
    def getType(self) -> cern.accsoft.commons.value.Type: ...
    def interpolate(self, double: float) -> float: ...
    def isDiscrete(self) -> bool: ...

class BoundedPolynomialIntervalComparator(java.util.Comparator[cern.accsoft.commons.value.BoundedPolynomial]):
    @overload
    def compare(self, boundedPolynomial: cern.accsoft.commons.value.BoundedPolynomial, boundedPolynomial2: cern.accsoft.commons.value.BoundedPolynomial) -> int: ...
    @overload
    def compare(self, object: _py_Any, object2: _py_Any) -> int: ...
    @classmethod
    def getInstance(cls) -> 'BoundedPolynomialIntervalComparator': ...

class BoundedPolynomialSequenceImpl(cern.accsoft.commons.value.spi.AbstractValue, cern.accsoft.commons.value.BoundedPolynomialSequence):
    @overload
    def __init__(self, boundedPolynomialArray: _py_List[cern.accsoft.commons.value.BoundedPolynomial]): ...
    @overload
    def __init__(self, collection: java.util.Collection[cern.accsoft.commons.value.BoundedPolynomial]): ...
    @classmethod
    def createOfAbsoluteBoundedPolynomials(cls, doubleArray: _py_List[_py_List[float]]) -> cern.accsoft.commons.value.BoundedPolynomialSequence: ...
    @classmethod
    def createOfRelativeBoundedPolynomials(cls, doubleArray: _py_List[_py_List[float]]) -> cern.accsoft.commons.value.BoundedPolynomialSequence: ...
    def equals(self, object: _py_Any) -> bool: ...
    @overload
    def execute(self, binaryOperation: cern.accsoft.commons.value.operation.BinaryOperation, immutableValue: cern.accsoft.commons.value.ImmutableValue) -> None: ...
    @overload
    def execute(self, unaryOperation: cern.accsoft.commons.value.operation.UnaryOperation) -> None: ...
    def getBoundedPolynomials(self) -> _py_List[cern.accsoft.commons.value.BoundedPolynomial]: ...
    def getString(self) -> str: ...
    def hashCode(self) -> int: ...
    def interpolate(self, double: float) -> float: ...
    def isDiscrete(self) -> bool: ...
    def toString(self) -> str: ...

class DiscreteFunctionImpl(cern.accsoft.commons.value.spi.AbstractValue, cern.accsoft.commons.value.DiscreteFunction, java.io.Serializable):
    def equals(self, object: _py_Any) -> bool: ...
    @overload
    def execute(self, binaryOperation: cern.accsoft.commons.value.operation.BinaryOperation, immutableValue: cern.accsoft.commons.value.ImmutableValue) -> None: ...
    @overload
    def execute(self, unaryOperation: cern.accsoft.commons.value.operation.UnaryOperation) -> None: ...
    def getBoolean(self) -> bool: ...
    def getByte(self) -> int: ...
    def getDouble(self) -> float: ...
    def getFloat(self) -> float: ...
    def getInt(self) -> int: ...
    def getLength(self) -> float: ...
    def getLong(self) -> int: ...
    def getObject(self) -> _py_Any: ...
    def getShort(self) -> int: ...
    def getString(self) -> str: ...
    def hashCode(self) -> int: ...
    def interpolate(self, double: float) -> float: ...
    def isDiscrete(self) -> bool: ...
    def setBoolean(self, boolean: bool) -> None: ...
    def setByte(self, byte: int) -> None: ...
    def setDouble(self, double: float) -> None: ...
    def setFloat(self, float: float) -> None: ...
    def setInt(self, int: int) -> None: ...
    def setLong(self, long: int) -> None: ...
    def setObject(self, object: _py_Any) -> None: ...
    def setShort(self, short: int) -> None: ...
    def setString(self, string: str) -> None: ...
    def toScalarArray2D(self) -> cern.accsoft.commons.value.ScalarArray2D: ...
    def toSimpleParameterValue(self) -> cern.japc.value.SimpleParameterValue: ...
    def toString(self) -> str: ...

class DiscreteFunctionsArrayImpl(cern.accsoft.commons.value.spi.AbstractValue, cern.accsoft.commons.value.DiscreteFunctionsArray, java.io.Serializable):
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, immutableDiscreteFunctionArray: _py_List[cern.accsoft.commons.value.ImmutableDiscreteFunction]): ...
    def clone(self) -> _py_Any: ...
    def equals(self, object: _py_Any) -> bool: ...
    @overload
    def execute(self, binaryOperation: cern.accsoft.commons.value.operation.BinaryOperation, immutableValue: cern.accsoft.commons.value.ImmutableValue) -> None: ...
    @overload
    def execute(self, unaryOperation: cern.accsoft.commons.value.operation.UnaryOperation) -> None: ...
    @overload
    def getFunction(self, int: int) -> cern.accsoft.commons.value.DiscreteFunction: ...
    @overload
    def getFunction(self, int: int) -> cern.accsoft.commons.value.ImmutableDiscreteFunction: ...
    @overload
    def getFunctions(self) -> _py_List[cern.accsoft.commons.value.DiscreteFunction]: ...
    @overload
    def getFunctions(self) -> _py_List[cern.accsoft.commons.value.ImmutableDiscreteFunction]: ...
    def getFunctionsCount(self) -> int: ...
    def getString(self) -> str: ...
    def getYs(self, double: float) -> _py_List[float]: ...
    def hashCode(self) -> int: ...
    @overload
    def insert(self, double: float) -> bool: ...
    @overload
    def insert(self, int: int, double: float) -> bool: ...
    @overload
    def insert(self, int: int, double: float, double2: float) -> bool: ...
    @overload
    def insertAll(self, doubleArray: _py_List[float]) -> int: ...
    @overload
    def insertAll(self, int: int, immutableDiscreteFunction: cern.accsoft.commons.value.ImmutableDiscreteFunction, double: float) -> int: ...
    @overload
    def insertAll(self, int: int, doubleArray: _py_List[float]) -> int: ...
    @overload
    def remove(self, double: float) -> bool: ...
    @overload
    def remove(self, int: int, double: float) -> bool: ...
    @overload
    def removeAll(self, doubleArray: _py_List[float]) -> int: ...
    @overload
    def removeAll(self, int: int, doubleArray: _py_List[float]) -> int: ...
    def retainAll(self, int: int, immutableDiscreteFunction: cern.accsoft.commons.value.ImmutableDiscreteFunction, double: float) -> int: ...
    def setY(self, int: int, int2: int, double: float) -> None: ...
    @overload
    def subView(self, int: int, double: float, double2: float) -> cern.accsoft.commons.value.DiscreteFunction: ...
    @overload
    def subView(self, double: float, double2: float) -> cern.accsoft.commons.value.DiscreteFunctionsArray: ...
    @overload
    def subView(self, double: float, double2: float) -> cern.accsoft.commons.value.ImmutableDiscreteFunctionsArray: ...
    def toXArray(self) -> _py_List[float]: ...
    @overload
    def translate(self, double: float) -> None: ...
    @overload
    def translate(self, int: int, double: float) -> None: ...

class Discretizer:
    @classmethod
    @overload
    def createArray(cls, int: int, double: float, double2: float) -> _py_List[float]: ...
    @classmethod
    @overload
    def createArray(cls, double: float, integer: int, double2: float, double3: float, integer2: int) -> _py_List[float]: ...
    @classmethod
    @overload
    def createDiscreteFunction(cls, interpolable: cern.accsoft.commons.value.Interpolable, double: float, int2: int, double2: float, double3: float) -> cern.accsoft.commons.value.DiscreteFunction: ...
    @classmethod
    @overload
    def createDiscreteFunction(cls, interpolable: cern.accsoft.commons.value.Interpolable, doubleArray: _py_List[float]) -> cern.accsoft.commons.value.DiscreteFunction: ...
    @classmethod
    @overload
    def createDiscreteFunction(cls, interpolable: cern.accsoft.commons.value.Interpolable, int2: int, double: float, double2: float) -> cern.accsoft.commons.value.DiscreteFunction: ...
    @classmethod
    @overload
    def createDiscreteFunction(cls, interpolable: cern.accsoft.commons.value.Interpolable, double: float, int2: int, double2: float, double3: float, integer: int, double4: float, double5: float) -> cern.accsoft.commons.value.DiscreteFunction: ...

class ExpressionBasedFunction(cern.accsoft.commons.value.ContinuousFunction, java.io.Serializable):
    @overload
    def __init__(self, expression: cern.accsoft.commons.value.expression.Expression): ...
    @overload
    def __init__(self, string: str): ...
    _evaluate__T = _py_TypeVar('_evaluate__T', bound=cern.accsoft.commons.value.Value)  # <T>
    def evaluate(self, valueMap: cern.accsoft.commons.value.expression.ValueMap, list: java.util.List[_evaluate__T]) -> _evaluate__T: ...
    def getFunctionExpression(self) -> cern.accsoft.commons.value.expression.Expression: ...
    def getString(self) -> str: ...
    def getType(self) -> cern.accsoft.commons.value.Type: ...
    def isDiscrete(self) -> bool: ...
    @overload
    def performOperation(self, binaryOperation: cern.accsoft.commons.value.operation.BinaryOperation, expression: cern.accsoft.commons.value.expression.Expression) -> None: ...
    @overload
    def performOperation(self, binaryOperation: cern.accsoft.commons.value.operation.BinaryOperation, expressionBasedFunction: 'ExpressionBasedFunction') -> None: ...
    @overload
    def performOperation(self, unaryOperation: cern.accsoft.commons.value.operation.UnaryOperation) -> None: ...
    def setFunctionExpression(self, expression: cern.accsoft.commons.value.expression.Expression) -> None: ...
    def toString(self) -> str: ...

class PolynomialImpl(cern.accsoft.commons.value.spi.AbstractValue, cern.accsoft.commons.value.Polynomial, cern.accsoft.commons.value.ImmutableValue):
    @overload
    def __init__(self, doubleArray: _py_List[float]): ...
    @overload
    def __init__(self, int: int, double: float): ...
    @overload
    def __init__(self, collection: java.util.Collection[float]): ...
    @overload
    def __init__(self, sortedMap: java.util.SortedMap[int, float]): ...
    def equals(self, object: _py_Any) -> bool: ...
    @overload
    def execute(self, binaryOperation: cern.accsoft.commons.value.operation.BinaryOperation, immutableValue: cern.accsoft.commons.value.ImmutableValue) -> None: ...
    @overload
    def execute(self, unaryOperation: cern.accsoft.commons.value.operation.UnaryOperation) -> None: ...
    def getCoefficients(self) -> _py_List[float]: ...
    def getDegree(self) -> int: ...
    def getString(self) -> str: ...
    def hashCode(self) -> int: ...
    def interpolate(self, double: float) -> float: ...
    def isDiscrete(self) -> bool: ...
    def toString(self) -> str: ...

class BoundedPolynomialImpl(PolynomialImpl, cern.accsoft.commons.value.BoundedPolynomial):
    @overload
    def __init__(self, polynomial: cern.accsoft.commons.value.Polynomial, interval: cern.accsoft.commons.value.Interval): ...
    @overload
    def __init__(self, polynomial: cern.accsoft.commons.value.Polynomial, double: float, double2: float): ...
    @classmethod
    def createRelativeBoundedPolynomial(cls, doubleArray: _py_List[float]) -> cern.accsoft.commons.value.BoundedPolynomial: ...
    def equals(self, object: _py_Any) -> bool: ...
    @overload
    def execute(self, binaryOperation: cern.accsoft.commons.value.operation.BinaryOperation, immutableValue: cern.accsoft.commons.value.ImmutableValue) -> None: ...
    @overload
    def execute(self, unaryOperation: cern.accsoft.commons.value.operation.UnaryOperation) -> None: ...
    def getInterval(self) -> cern.accsoft.commons.value.Interval: ...
    def getString(self) -> str: ...
    def hashCode(self) -> int: ...
    def interpolate(self, double: float) -> float: ...
    def toString(self) -> str: ...

class ConstantFunction(ExpressionBasedFunction):
    def __init__(self, double: float): ...

class CubicSplineFunctionPrototype(AbstractMathFunction):
    def __init__(self, immutableDiscreteFunction: cern.accsoft.commons.value.ImmutableDiscreteFunction): ...
    def getAcceleration(self, double: float) -> float: ...
    def getFunction(self) -> cern.accsoft.commons.value.ImmutableDiscreteFunction: ...
    def getSplineX(self, int: int) -> float: ...
    @overload
    def toDiscreteFunction(self, immutableDiscreteFunction: cern.accsoft.commons.value.ImmutableDiscreteFunction, double: float, int: int) -> cern.accsoft.commons.value.DiscreteFunction: ...
    @overload
    def toDiscreteFunction(self, double: float, double2: float, int: int) -> cern.accsoft.commons.value.DiscreteFunction: ...

class DiscreteFunctionArrayImpl(DiscreteFunctionImpl, java.io.Serializable):
    @overload
    def __init__(self, doubleArray: _py_List[float], doubleArray2: _py_List[float]): ...
    @overload
    def __init__(self, doubleArray: _py_List[float], doubleArray2: _py_List[float], boolean: bool): ...
    @overload
    def __init__(self, intArray: _py_List[int], doubleArray: _py_List[float]): ...
    def clone(self) -> _py_Any: ...
    def getX(self, int: int) -> float: ...
    def getY(self, int: int) -> float: ...
    def indexOf(self, double: float) -> int: ...
    @overload
    def insert(self, double: float) -> bool: ...
    @overload
    def insert(self, double: float, double2: float) -> bool: ...
    @overload
    def insertAll(self, immutableDiscreteFunction: cern.accsoft.commons.value.ImmutableDiscreteFunction, double: float) -> int: ...
    @overload
    def insertAll(self, doubleArray: _py_List[float]) -> int: ...
    @classmethod
    def newInstanceWithoutCoordinatesCheck(cls, doubleArray: _py_List[float], doubleArray2: _py_List[float]) -> 'DiscreteFunctionArrayImpl': ...
    def remove(self, double: float) -> bool: ...
    def removeAll(self, doubleArray: _py_List[float]) -> int: ...
    def retainAll(self, immutableDiscreteFunction: cern.accsoft.commons.value.ImmutableDiscreteFunction, double: float) -> int: ...
    def setX(self, int: int, double: float) -> None: ...
    def setY(self, int: int, double: float) -> None: ...
    def size(self) -> int: ...
    def stringValue(self) -> str: ...
    def subFunction(self, double: float, double2: float) -> cern.accsoft.commons.value.DiscreteFunction: ...
    def subView(self, double: float, double2: float) -> cern.accsoft.commons.value.DiscreteFunction: ...
    @overload
    def toPointArray(self) -> _py_List[cern.accsoft.commons.value.ImmutablePoint]: ...
    @overload
    def toPointArray(self, immutablePointArray: _py_List[cern.accsoft.commons.value.ImmutablePoint]) -> _py_List[cern.accsoft.commons.value.ImmutablePoint]: ...
    def toXArray(self) -> _py_List[float]: ...
    def toYArray(self) -> _py_List[float]: ...
    def translate(self, double: float) -> None: ...

class DiscreteFunctionListImpl(DiscreteFunctionImpl, cern.accsoft.commons.value.DiscreteFunctionList):
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, immutableDiscreteFunctionArray: _py_List[cern.accsoft.commons.value.ImmutableDiscreteFunction]): ...
    @overload
    def __init__(self, doubleArray: _py_List[float], doubleArray2: _py_List[float], intArray: _py_List[int]): ...
    def clone(self) -> _py_Any: ...
    def equals(self, object: _py_Any) -> bool: ...
    def getAbsoluteFunction(self, int: int) -> cern.accsoft.commons.value.ImmutableDiscreteFunction: ...
    def getFunction(self, int: int) -> cern.accsoft.commons.value.ImmutableDiscreteFunction: ...
    def getFunctions(self) -> _py_List[cern.accsoft.commons.value.ImmutableDiscreteFunction]: ...
    def getFunctionsCount(self) -> int: ...
    def getSizeIncludingStopPoints(self) -> int: ...
    def getStopPointsIndices(self) -> _py_List[int]: ...
    def getString(self) -> str: ...
    def getX(self, int: int) -> float: ...
    def getY(self, int: int) -> float: ...
    def hashCode(self) -> int: ...
    def indexOf(self, double: float) -> int: ...
    @overload
    def insert(self, double: float) -> bool: ...
    @overload
    def insert(self, double: float, double2: float) -> bool: ...
    @overload
    def insertAll(self, immutableDiscreteFunction: cern.accsoft.commons.value.ImmutableDiscreteFunction, double: float) -> int: ...
    @overload
    def insertAll(self, doubleArray: _py_List[float]) -> int: ...
    def merge(self, int: int) -> None: ...
    def remove(self, double: float) -> bool: ...
    def removeAll(self, doubleArray: _py_List[float]) -> int: ...
    def retainAll(self, immutableDiscreteFunction: cern.accsoft.commons.value.ImmutableDiscreteFunction, double: float) -> int: ...
    def setStopPoints(self, intArray: _py_List[int]) -> None: ...
    def setY(self, int: int, double: float) -> None: ...
    def size(self) -> int: ...
    def split(self, double: float) -> None: ...
    @overload
    def subFunction(self, double: float, double2: float) -> cern.accsoft.commons.value.DiscreteFunction: ...
    @overload
    def subFunction(self, double: float, double2: float) -> cern.accsoft.commons.value.DiscreteFunctionList: ...
    def subView(self, double: float, double2: float) -> cern.accsoft.commons.value.DiscreteFunction: ...
    @overload
    def toPointArray(self) -> _py_List[cern.accsoft.commons.value.ImmutablePoint]: ...
    @overload
    def toPointArray(self, immutablePointArray: _py_List[cern.accsoft.commons.value.ImmutablePoint]) -> _py_List[cern.accsoft.commons.value.ImmutablePoint]: ...
    def toSimpleParameterValue(self) -> cern.japc.value.SimpleParameterValue: ...
    def toXArray(self) -> _py_List[float]: ...
    def toYArray(self) -> _py_List[float]: ...
    def translate(self, double: float) -> None: ...

class DiscreteFunctionPointImpl(DiscreteFunctionImpl, cern.accsoft.commons.value.DiscreteFunction, java.io.Serializable):
    @overload
    def __init__(self, immutablePointArray: _py_List[cern.accsoft.commons.value.ImmutablePoint]): ...
    @overload
    def __init__(self, pointArray: _py_List[cern.accsoft.commons.value.Point]): ...
    def clone(self) -> _py_Any: ...
    def getX(self, int: int) -> float: ...
    def getY(self, int: int) -> float: ...
    def indexOf(self, double: float) -> int: ...
    @overload
    def insert(self, double: float) -> bool: ...
    @overload
    def insert(self, double: float, double2: float) -> bool: ...
    @overload
    def insertAll(self, immutableDiscreteFunction: cern.accsoft.commons.value.ImmutableDiscreteFunction, double: float) -> int: ...
    @overload
    def insertAll(self, doubleArray: _py_List[float]) -> int: ...
    def remove(self, double: float) -> bool: ...
    def removeAll(self, doubleArray: _py_List[float]) -> int: ...
    def retainAll(self, immutableDiscreteFunction: cern.accsoft.commons.value.ImmutableDiscreteFunction, double: float) -> int: ...
    def setX(self, int: int, double: float) -> None: ...
    def setY(self, int: int, double: float) -> None: ...
    def size(self) -> int: ...
    def stringValue(self) -> str: ...
    def subFunction(self, double: float, double2: float) -> cern.accsoft.commons.value.DiscreteFunction: ...
    def subView(self, double: float, double2: float) -> cern.accsoft.commons.value.DiscreteFunction: ...
    @overload
    def toPointArray(self) -> _py_List[cern.accsoft.commons.value.ImmutablePoint]: ...
    @overload
    def toPointArray(self, immutablePointArray: _py_List[cern.accsoft.commons.value.ImmutablePoint]) -> _py_List[cern.accsoft.commons.value.ImmutablePoint]: ...
    def toString(self) -> str: ...
    def toXArray(self) -> _py_List[float]: ...
    def toYArray(self) -> _py_List[float]: ...
    def translate(self, double: float) -> None: ...
