from typing import TypeVar as _py_TypeVar
from typing import Generic as _py_Generic
import cern.accsoft.commons.util.trigger
import java.time
import java.util
import java.util.concurrent


_AbstractTrigger__E = _py_TypeVar('_AbstractTrigger__E', bound=cern.accsoft.commons.util.trigger.TriggerEvent)  # <E>
class AbstractTrigger(cern.accsoft.commons.util.trigger.Trigger[_AbstractTrigger__E], _py_Generic[_AbstractTrigger__E]):
    def __init__(self): ...
    def addTriggerListener(self, triggerListener: cern.accsoft.commons.util.trigger.TriggerListener[_AbstractTrigger__E]) -> None: ...
    def removeTriggerListener(self, triggerListener: cern.accsoft.commons.util.trigger.TriggerListener[_AbstractTrigger__E]) -> None: ...
    def setDispatchExecutor(self, executor: java.util.concurrent.Executor) -> None: ...
    def setTriggerListeners(self, collection: java.util.Collection[cern.accsoft.commons.util.trigger.TriggerListener[_AbstractTrigger__E]]) -> None: ...

class TriggerEventImpl(cern.accsoft.commons.util.trigger.TriggerEvent):
    def __init__(self, instant: java.time.Instant): ...
    def getTimestamp(self) -> java.time.Instant: ...
    def toString(self) -> str: ...

_AbstractTimerTrigger__E = _py_TypeVar('_AbstractTimerTrigger__E', bound=cern.accsoft.commons.util.trigger.TriggerEvent)  # <E>
class AbstractTimerTrigger(AbstractTrigger[_AbstractTimerTrigger__E], _py_Generic[_AbstractTimerTrigger__E]):
    def __init__(self, duration: java.time.Duration): ...
    def init(self) -> None: ...
    def setTimerExecutorService(self, scheduledExecutorService: java.util.concurrent.ScheduledExecutorService) -> None: ...

class DefaultTimerTrigger(AbstractTimerTrigger[TriggerEventImpl]):
    def __init__(self, duration: java.time.Duration): ...
