from typing import Any as _py_Any
from typing import TypeVar as _py_TypeVar
from typing import Generic as _py_Generic
from typing import overload
import java.io
import java.util


_TreeNode__T = _py_TypeVar('_TreeNode__T')  # <T>
class TreeNode(_py_Generic[_TreeNode__T]):
    def getChildNodes(self) -> java.util.Collection['TreeNode'[_TreeNode__T]]: ...
    def getNodeValue(self) -> _TreeNode__T: ...
    def getParentNode(self) -> 'TreeNode'[_TreeNode__T]: ...

class Trees:
    def __init__(self): ...
    _newHashMapTree__T = _py_TypeVar('_newHashMapTree__T')  # <T>
    @classmethod
    def newHashMapTree(cls) -> 'EditableTreeNode'[_newHashMapTree__T]: ...
    _newLinkedHashMapTree__T = _py_TypeVar('_newLinkedHashMapTree__T')  # <T>
    @classmethod
    def newLinkedHashMapTree(cls) -> 'EditableTreeNode'[_newLinkedHashMapTree__T]: ...
    _newTreeMapTree__T = _py_TypeVar('_newTreeMapTree__T')  # <T>
    @classmethod
    def newTreeMapTree(cls, comparator: java.util.Comparator[_newTreeMapTree__T]) -> 'EditableTreeNode'[_newTreeMapTree__T]: ...

_EditableTreeNode__T = _py_TypeVar('_EditableTreeNode__T')  # <T>
class EditableTreeNode(TreeNode[_EditableTreeNode__T], _py_Generic[_EditableTreeNode__T]):
    def addChild(self, t: _EditableTreeNode__T) -> 'EditableTreeNode'[_EditableTreeNode__T]: ...
    def getChildNodes(self) -> java.util.Collection['EditableTreeNode'[_EditableTreeNode__T]]: ...
    @overload
    def getParentNode(self) -> 'EditableTreeNode'[_EditableTreeNode__T]: ...
    @overload
    def getParentNode(self) -> TreeNode: ...
    def removeChild(self, t: _EditableTreeNode__T) -> 'EditableTreeNode'[_EditableTreeNode__T]: ...
    def setNodeValue(self, t: _EditableTreeNode__T) -> None: ...

_AbstractMapTreeNode__T = _py_TypeVar('_AbstractMapTreeNode__T')  # <T>
_AbstractMapTreeNode__N = _py_TypeVar('_AbstractMapTreeNode__N', bound='AbstractMapTreeNode')  # <N>
class AbstractMapTreeNode(EditableTreeNode[_AbstractMapTreeNode__T], java.io.Serializable, _py_Generic[_AbstractMapTreeNode__T, _AbstractMapTreeNode__N]):
    @overload
    def addChild(self, t: _AbstractMapTreeNode__T) -> _AbstractMapTreeNode__N: ...
    @overload
    def addChild(self, object: _py_Any) -> EditableTreeNode: ...
    def getChildNodes(self) -> java.util.Collection[_AbstractMapTreeNode__N]: ...
    def getNodeValue(self) -> _AbstractMapTreeNode__T: ...
    @overload
    def getParentNode(self) -> _AbstractMapTreeNode__N: ...
    @overload
    def getParentNode(self) -> EditableTreeNode: ...
    @overload
    def getParentNode(self) -> TreeNode: ...
    @overload
    def removeChild(self, t: _AbstractMapTreeNode__T) -> _AbstractMapTreeNode__N: ...
    @overload
    def removeChild(self, object: _py_Any) -> EditableTreeNode: ...
    def setNodeValue(self, t: _AbstractMapTreeNode__T) -> None: ...

_HashMapTreeNode__T = _py_TypeVar('_HashMapTreeNode__T')  # <T>
class HashMapTreeNode(AbstractMapTreeNode[_HashMapTreeNode__T, 'HashMapTreeNode'[_HashMapTreeNode__T]], _py_Generic[_HashMapTreeNode__T]): ...

_LinkedHashMapTreeNode__T = _py_TypeVar('_LinkedHashMapTreeNode__T')  # <T>
class LinkedHashMapTreeNode(AbstractMapTreeNode[_LinkedHashMapTreeNode__T, 'LinkedHashMapTreeNode'[_LinkedHashMapTreeNode__T]], _py_Generic[_LinkedHashMapTreeNode__T]): ...

_TreeMapTreeNode__T = _py_TypeVar('_TreeMapTreeNode__T')  # <T>
class TreeMapTreeNode(AbstractMapTreeNode[_TreeMapTreeNode__T, 'TreeMapTreeNode'[_TreeMapTreeNode__T]], _py_Generic[_TreeMapTreeNode__T]): ...
