#!/usr/bin/env python
# -*- coding: utf8 -*-

# 系统库
from __future__ import absolute_import
from __future__ import print_function
from __future__ import unicode_literals

charunlike_emoji_list = [
    '\u2600',
    '\u2601',
    '\u2614',
    '\u26C4',
    '\u26A1',
    '\u2744',
    '\u26C5',
    '\u231A',
    '\u231B',
    '\u23F0',
    '\u23F3',
    '\u2648',
    '\u2649',
    '\u264A',
    '\u264B',
    '\u264C',
    '\u264D',
    '\u264E',
    '\u264F',
    '\u2650',
    '\u2651',
    '\u2652',
    '\u2653',
    '\u26CE',
    '\u263A',
    '\u26EA',
    '\u26F2',
    '\u2693',
    '\u2712',
    '\u270F',
    '\u2702',
    '\u26BE',
    '\u26F3',
    '\u26BD',
    '\u2708',
    '\u26F5',
    '\u26FD',
    '\u2668',
    '\u26FA',
    '\u303D',
    '\u2615',
    '\u2197',
    '\u2198',
    '\u2196',
    '\u2199',
    '\u2934',
    '\u2935',
    '\u2194',
    '\u2195',
    '\u2B06',
    '\u2B07',
    '\u27A1',
    '\u2B05',
    '\u25B6',
    '\u25C0',
    '\u23E9',
    '\u23EA',
    '\u23EB',
    '\u23EC',
    '\u2757',
    '\u2049',
    '\u203C',
    '\u2753',
    '\u2754',
    '\u2755',
    '\u3030',
    '\u27B0',
    '\u27BF',
    '\u2764',
    '\u267F',
    '\u26A0',
    '\u26D4',
    '\u267B',
    '\u2795',
    '\u2796',
    '\u2716',
    '\u2797',
    '\u2728',
    '\u2734',
    '\u2733',
    '\u26AA',
    '\u26AB',
    '\u2B50',
    '\u2B1C',
    '\u2B1B',
    '\u25AB',
    '\u25AA',
    '\u25FD',
    '\u25FE',
    '\u25FB',
    '\u25FC',
    '\u2747',
    '\u21A9',
    '\u21AA',
    '\u2611',
    '\u2705',
    '\u270A',
    '\u270B',
    '\u270C',
    '\u261D',
    '\U0001F300',
    '\U0001F301',
    '\U0001F302',
    '\U0001F303',
    '\U0001F304',
    '\U0001F305',
    '\U0001F306',
    '\U0001F307',
    '\U0001F308',
    '\U0001F309',
    '\U0001F30A',
    '\U0001F30B',
    '\U0001F30C',
    '\U0001F30F',
    '\U0001F311',
    '\U0001F314',
    '\U0001F313',
    '\U0001F319',
    '\U0001F315',
    '\U0001F31B',
    '\U0001F31F',
    '\U0001F320',
    '\U0001F550',
    '\U0001F551',
    '\U0001F552',
    '\U0001F553',
    '\U0001F554',
    '\U0001F555',
    '\U0001F556',
    '\U0001F557',
    '\U0001F558',
    '\U0001F559',
    '\U0001F55A',
    '\U0001F55B',
    '\U0001F340',
    '\U0001F337',
    '\U0001F331',
    '\U0001F341',
    '\U0001F338',
    '\U0001F339',
    '\U0001F342',
    '\U0001F343',
    '\U0001F33A',
    '\U0001F33B',
    '\U0001F334',
    '\U0001F335',
    '\U0001F33E',
    '\U0001F33D',
    '\U0001F344',
    '\U0001F330',
    '\U0001F33C',
    '\U0001F33F',
    '\U0001F352',
    '\U0001F34C',
    '\U0001F34E',
    '\U0001F34A',
    '\U0001F353',
    '\U0001F349',
    '\U0001F345',
    '\U0001F346',
    '\U0001F348',
    '\U0001F34D',
    '\U0001F347',
    '\U0001F351',
    '\U0001F34F',
    '\U0001F440',
    '\U0001F442',
    '\U0001F443',
    '\U0001F444',
    '\U0001F445',
    '\U0001F484',
    '\U0001F485',
    '\U0001F486',
    '\U0001F487',
    '\U0001F488',
    '\U0001F464',
    '\U0001F466',
    '\U0001F467',
    '\U0001F468',
    '\U0001F469',
    '\U0001F46A',
    '\U0001F46B',
    '\U0001F46E',
    '\U0001F46F',
    '\U0001F470',
    '\U0001F471',
    '\U0001F472',
    '\U0001F473',
    '\U0001F474',
    '\U0001F475',
    '\U0001F476',
    '\U0001F477',
    '\U0001F478',
    '\U0001F479',
    '\U0001F47A',
    '\U0001F47B',
    '\U0001F47C',
    '\U0001F47D',
    '\U0001F47E',
    '\U0001F47F',
    '\U0001F480',
    '\U0001F481',
    '\U0001F482',
    '\U0001F483',
    '\U0001F40C',
    '\U0001F40D',
    '\U0001F40E',
    '\U0001F414',
    '\U0001F417',
    '\U0001F42B',
    '\U0001F418',
    '\U0001F428',
    '\U0001F412',
    '\U0001F411',
    '\U0001F419',
    '\U0001F41A',
    '\U0001F41B',
    '\U0001F41C',
    '\U0001F41D',
    '\U0001F41E',
    '\U0001F420',
    '\U0001F421',
    '\U0001F422',
    '\U0001F424',
    '\U0001F425',
    '\U0001F426',
    '\U0001F423',
    '\U0001F427',
    '\U0001F429',
    '\U0001F41F',
    '\U0001F42C',
    '\U0001F42D',
    '\U0001F42F',
    '\U0001F431',
    '\U0001F433',
    '\U0001F434',
    '\U0001F435',
    '\U0001F436',
    '\U0001F437',
    '\U0001F43B',
    '\U0001F439',
    '\U0001F43A',
    '\U0001F42E',
    '\U0001F430',
    '\U0001F438',
    '\U0001F43E',
    '\U0001F432',
    '\U0001F43C',
    '\U0001F43D',
    '\U0001F620',
    '\U0001F629',
    '\U0001F632',
    '\U0001F61E',
    '\U0001F635',
    '\U0001F630',
    '\U0001F612',
    '\U0001F60D',
    '\U0001F624',
    '\U0001F61C',
    '\U0001F61D',
    '\U0001F60B',
    '\U0001F618',
    '\U0001F61A',
    '\U0001F637',
    '\U0001F633',
    '\U0001F603',
    '\U0001F605',
    '\U0001F606',
    '\U0001F601',
    '\U0001F602',
    '\U0001F60A',
    '\U0001F604',
    '\U0001F622',
    '\U0001F62D',
    '\U0001F628',
    '\U0001F623',
    '\U0001F621',
    '\U0001F60C',
    '\U0001F616',
    '\U0001F614',
    '\U0001F631',
    '\U0001F62A',
    '\U0001F60F',
    '\U0001F613',
    '\U0001F625',
    '\U0001F62B',
    '\U0001F609',
    '\U0001F63A',
    '\U0001F638',
    '\U0001F639',
    '\U0001F63D',
    '\U0001F63B',
    '\U0001F63F',
    '\U0001F63E',
    '\U0001F63C',
    '\U0001F640',
    '\U0001F645',
    '\U0001F646',
    '\U0001F647',
    '\U0001F648',
    '\U0001F64A',
    '\U0001F649',
    '\U0001F64B',
    '\U0001F64C',
    '\U0001F64D',
    '\U0001F64E',
    '\U0001F64F',
    '\U0001F3E0',
    '\U0001F3E1',
    '\U0001F3E2',
    '\U0001F3E3',
    '\U0001F3E5',
    '\U0001F3E6',
    '\U0001F3E7',
    '\U0001F3E8',
    '\U0001F3E9',
    '\U0001F3EA',
    '\U0001F3EB',
    '\U0001F3EC',
    '\U0001F3EF',
    '\U0001F3F0',
    '\U0001F3ED',
    '\U0001F3EE',
    '\U0001F5FB',
    '\U0001F5FC',
    '\U0001F5FD',
    '\U0001F5FE',
    '\U0001F5FF',
    '\U0001F45E',
    '\U0001F45F',
    '\U0001F460',
    '\U0001F461',
    '\U0001F462',
    '\U0001F463',
    '\U0001F453',
    '\U0001F455',
    '\U0001F456',
    '\U0001F451',
    '\U0001F454',
    '\U0001F452',
    '\U0001F457',
    '\U0001F458',
    '\U0001F459',
    '\U0001F45A',
    '\U0001F45B',
    '\U0001F45C',
    '\U0001F45D',
    '\U0001F4B0',
    '\U0001F4B1',
    '\U0001F4B9',
    '\U0001F4B2',
    '\U0001F4B3',
    '\U0001F4B4',
    '\U0001F4B5',
    '\U0001F4B8',
    '\U0001F525',
    '\U0001F526',
    '\U0001F527',
    '\U0001F528',
    '\U0001F529',
    '\U0001F52A',
    '\U0001F52B',
    '\U0001F52E',
    '\U0001F52F',
    '\U0001F530',
    '\U0001F531',
    '\U0001F489',
    '\U0001F48A',
    '\U0001F170',
    '\U0001F171',
    '\U0001F18E',
    '\U0001F17E',
    '\U0001F380',
    '\U0001F381',
    '\U0001F382',
    '\U0001F384',
    '\U0001F385',
    '\U0001F38C',
    '\U0001F386',
    '\U0001F388',
    '\U0001F389',
    '\U0001F38D',
    '\U0001F38E',
    '\U0001F393',
    '\U0001F392',
    '\U0001F38F',
    '\U0001F387',
    '\U0001F390',
    '\U0001F383',
    '\U0001F38A',
    '\U0001F38B',
    '\U0001F391',
    '\U0001F4DF',
    '\U0001F4F0',
    '\U0001F4E2',
    '\U0001F4E3',
    '\U0001F4E1',
    '\U0001F4E4',
    '\U0001F4E5',
    '\U0001F4E6',
    '\U0001F4E7',
    '\U0001F4BA',
    '\U0001F4BB',
    '\U0001F4CE',
    '\U0001F4BC',
    '\U0001F4BD',
    '\U0001F4BE',
    '\U0001F4BF',
    '\U0001F4C0',
    '\U0001F4CD',
    '\U0001F4C3',
    '\U0001F4C4',
    '\U0001F4C5',
    '\U0001F4C1',
    '\U0001F4C2',
    '\U0001F4D3',
    '\U0001F4D6',
    '\U0001F4D4',
    '\U0001F4D5',
    '\U0001F4D7',
    '\U0001F4D8',
    '\U0001F4D9',
    '\U0001F4DA',
    '\U0001F4DB',
    '\U0001F4DC',
    '\U0001F4CB',
    '\U0001F4C6',
    '\U0001F4CA',
    '\U0001F4C8',
    '\U0001F4C9',
    '\U0001F4C7',
    '\U0001F4CC',
    '\U0001F4D2',
    '\U0001F4CF',
    '\U0001F4D0',
    '\U0001F4D1',
    '\U0001F3BD',
    '\U0001F3BE',
    '\U0001F3BF',
    '\U0001F3C0',
    '\U0001F3C1',
    '\U0001F3C2',
    '\U0001F3C3',
    '\U0001F3C4',
    '\U0001F3C6',
    '\U0001F3C8',
    '\U0001F3CA',
    '\U0001F683',
    '\U0001F687',
    '\U0001F684',
    '\U0001F685',
    '\U0001F697',
    '\U0001F699',
    '\U0001F68C',
    '\U0001F68F',
    '\U0001F6A2',
    '\U0001F689',
    '\U0001F680',
    '\U0001F6A4',
    '\U0001F695',
    '\U0001F69A',
    '\U0001F692',
    '\U0001F691',
    '\U0001F693',
    '\U0001F6A5',
    '\U0001F6A7',
    '\U0001F6A8',
    '\U0001F3A0',
    '\U0001F3A1',
    '\U0001F3A2',
    '\U0001F3A3',
    '\U0001F3A4',
    '\U0001F3A5',
    '\U0001F3A6',
    '\U0001F3A7',
    '\U0001F3A8',
    '\U0001F3A9',
    '\U0001F3AA',
    '\U0001F3AB',
    '\U0001F3AC',
    '\U0001F3AD',
    '\U0001F3AE',
    '\U0001F004',
    '\U0001F3AF',
    '\U0001F3B0',
    '\U0001F3B1',
    '\U0001F3B2',
    '\U0001F3B3',
    '\U0001F3B4',
    '\U0001F0CF',
    '\U0001F3B5',
    '\U0001F3B6',
    '\U0001F3B7',
    '\U0001F3B8',
    '\U0001F3B9',
    '\U0001F3BA',
    '\U0001F3BB',
    '\U0001F3BC',
    '\U0001F4F7',
    '\U0001F4F9',
    '\U0001F4FA',
    '\U0001F4FB',
    '\U0001F4FC',
    '\U0001F48B',
    '\U0001F48C',
    '\U0001F48D',
    '\U0001F48E',
    '\U0001F48F',
    '\U0001F490',
    '\U0001F491',
    '\U0001F492',
    '\U0001F4F6',
    '\U0001F354',
    '\U0001F359',
    '\U0001F370',
    '\U0001F35C',
    '\U0001F35E',
    '\U0001F373',
    '\U0001F366',
    '\U0001F35F',
    '\U0001F361',
    '\U0001F358',
    '\U0001F35A',
    '\U0001F35D',
    '\U0001F35B',
    '\U0001F362',
    '\U0001F363',
    '\U0001F371',
    '\U0001F372',
    '\U0001F367',
    '\U0001F356',
    '\U0001F365',
    '\U0001F360',
    '\U0001F355',
    '\U0001F357',
    '\U0001F368',
    '\U0001F369',
    '\U0001F36A',
    '\U0001F36B',
    '\U0001F36C',
    '\U0001F36D',
    '\U0001F36E',
    '\U0001F36F',
    '\U0001F364',
    '\U0001F374',
    '\U0001F378',
    '\U0001F37A',
    '\U0001F375',
    '\U0001F376',
    '\U0001F377',
    '\U0001F37B',
    '\U0001F379',
    '\U0001F53A',
    '\U0001F53B',
    '\U0001F53C',
    '\U0001F53D',
    '\U0001F493',
    '\U0001F494',
    '\U0001F495',
    '\U0001F496',
    '\U0001F497',
    '\U0001F498',
    '\U0001F499',
    '\U0001F49A',
    '\U0001F49B',
    '\U0001F49C',
    '\U0001F49D',
    '\U0001F49E',
    '\U0001F49F',
    '\U0001F6AC',
    '\U0001F6AD',
    '\U0001F6A9',
    '\U0001F6B2',
    '\U0001F6B6',
    '\U0001F6B9',
    '\U0001F6BA',
    '\U0001F6C0',
    '\U0001F6BB',
    '\U0001F6BD',
    '\U0001F6BE',
    '\U0001F6BC',
    '\U0001F6AA',
    '\U0001F6AB',
    '\U0001F4A0',
    '\U0001F4A1',
    '\U0001F4A2',
    '\U0001F4A3',
    '\U0001F4A4',
    '\U0001F4A5',
    '\U0001F4A7',
    '\U0001F4A8',
    '\U0001F4A9',
    '\U0001F4AA',
    '\U0001F4AB',
    '\U0001F4AC',
    '\U0001F534',
    '\U0001F535',
    '\U0001F532',
    '\U0001F533',
    '\U0001F536',
    '\U0001F537',
    '\U0001F538',
    '\U0001F539',
    '\U0001F4AE',
    '\U0001F4AF',
    '\U0001F503',
    '\U0001F50A',
    '\U0001F50B',
    '\U0001F50C',
    '\U0001F50D',
    '\U0001F50E',
    '\U0001F512',
    '\U0001F513',
    '\U0001F50F',
    '\U0001F510',
    '\U0001F511',
    '\U0001F514',
    '\U0001F518',
    '\U0001F516',
    '\U0001F517',
    '\U0001F519',
    '\U0001F51A',
    '\U0001F51B',
    '\U0001F51C',
    '\U0001F51D',
    '\U0001F44A',
    '\U0001F44D',
    '\U0001F446',
    '\U0001F447',
    '\U0001F448',
    '\U0001F449',
    '\U0001F44B',
    '\U0001F44F',
    '\U0001F44C',
    '\U0001F44E',
    '\U0001F450',
]


def is_emoji(uchar):
    """判断一个unicode是否是emoji"""
    if (
        (uchar >= u'\u2600' and uchar <= u'\u26FF')
        or (uchar >= u'\u2700' and uchar <= u'\u27BF')
        or (uchar >= u'\u2440' and uchar <= u'\u245F')
        or (uchar >= u'\u2300' and uchar <= u'\u23FF')
        or (uchar >= u'\u2190' and uchar <= u'\u22FF')
        or (uchar >= u'\U0001F300' and uchar <= u'\U0001F5FF')
        or (uchar >= u'\U0001F600' and uchar <= u'\U0001F64F')
        or (uchar >= u'\U0001F680' and uchar <= u'\U0001F6FF')
        or (uchar >= u'\U0001F1E0' and uchar <= u'\U0001F1FF')
    ):
        return True
    else:
        return False


def is_charunlike_emoji(uchar):
    """判断一个unicode是否是为非字符型emoji，即不包含英文、数字等字符"""
    return uchar in charunlike_emoji_list


def is_charlike_emoji(uchar):
    """判断一个unicode是否是字符型emoji，即包含英文、数字等字符"""
    return is_emoji(uchar) and uchar not in charunlike_emoji_list
