#!/usr/bin/env python
# -*- coding: utf8 -*-
# 系统库
from __future__ import absolute_import
from __future__ import print_function
from __future__ import unicode_literals
import string

# 内部库
from ramboo_tools import global_data
from ramboo_tools import emoji_info

# 通用规范汉字表 一级字表 3500个
cn_char_lv1 = (
    '一丁七万丈三三上下不与丐丑专且世丘丙业丛东丝丢两严丧个中丰串临丸丹为主丽举乃久么义之乌乍乎乏乐乒乓乔乖乘乙九乞也习乡书买乱乳了予争事二于亏云互五井亚些亡交亥亦产'
    '亩享京亭亮亲人亿什仁仅仆仇今介仍从仑仓仔他仗付仙代令以仪们仰仲件价任份仿企伊伍伏伐休众优伙会伞伟传伤伦伪伯估伴伶伸伺似佃但位低住佑体何余佛作你佣佩佳使侄侈例侍供'
    '依侠侣侥侦侧侨侮侯侵便促俄俊俏俐俗俘保信俩俭修俯俱俺倍倒倔倘候倚借倡倦债值倾假偎偏做停健偶偷偿傀傅傍储催傲傻像僚僧僵僻儒儡儿允元兄充兆先光克免兑兔党兜兢入全八公'
    '六兰共关兴兵其具典养兼兽冀内冈册再冒冕冗写军农冠冤冬冯冰冲决况冶冷冻净凄准凉凌减凑凛凝几凡凤凫凭凯凰凳凶凸凹出击函凿刀刁刃分切刊刑划列刘则刚创初删判刨利别刮到制'
    '刷券刹刺刻刽剂剃削前剑剔剖剥剧剩剪副割剿劈力劝办功加务劣动助努劫励劲劳势勃勇勉勋勒勘募勤勺勾勿匀包匆匈匕化北匙匠匣匪匹区医匾匿十千升午半华协卑卒卓单卖南博卜占卡'
    '卢卤卦卧卫印危即却卵卷卸卿厂厅历厉压厌厕厘厚原厢厦厨去县参又叉及友双反发叔取受变叙叛叠口古句另叨只叫召叭叮可台史右叶号司叹叼叽吁吃各吆合吉吊同名后吏吐向吓吕吗君'
    '吝吞吟吠否吧吨吩含听吭吮启吱吴吵吸吹吻吼呀呆呈告呐呕员呛呜呢周味呵呻呼命咆和咏咐咒咕咖咙咧咨咪咬咱咳咸咽哀品哄哆哈响哎哑哗哟哥哨哩哪哭哮哲哺哼唁唆唇唉唐唠唤唧唬'
    '售唯唱唾啃啄商啊啡啤啥啦啰啸啼喂善喇喉喊喘喜喝喧喳喷喻嗅嗓嗜嗡嗤嗦嗽嘀嘁嘉嘱嘲嘴嘶嘹嘿器噩噪嚎嚣嚷嚼囊囚四回因团囤园困囱围固国图圃圆圈土圣在地场圾址均坊坎坏坐坑'
    '块坚坛坝坞坟坠坡坤坦坪坯坷垂垃垄型垒垛垢垦垫垮埂埃埋城域埠培基堂堆堕堡堤堪堰堵塌塑塔塘塞填境墅墓墙增墨墩壁壕壤士壮声壳壶壹处备复夏夕外多夜够大天太夫夭央夯失头夷'
    '夸夹夺奄奇奈奉奋奏契奔奕奖套奠奢奥女奴奶奸她好如妄妆妇妈妒妓妖妙妥妨妹妻姆姊始姐姑姓委姚姜姥姨姻姿威娃娄娇娘娜娩娱娶婆婉婚婴婶婿媒媚媳嫁嫂嫉嫌嫡嫩嬉子孔孕字存孙'
    '孝孟季孤学孩孵孽宁它宅宇守安宋完宏宗官宙定宛宜宝实宠审客宣室宦宪宫宰害宴宵家容宽宾宿寂寄密寇富寒寓寝寞察寡寥寨寸对寺寻导寿封射将尉尊小少尔尖尘尚尝尤就尸尺尼尽尾'
    '尿局屁层居屈屉届屋屎屏屑展属屠屡履屯山屹屿岁岂岔岖岗岛岩岭岳岸峡峦峭峰峻崇崎崔崖崩崭嵌巍川州巡巢工左巧巨巩巫差己已巴巷巾币市布帅帆师希帐帕帖帘帚帜帝带席帮常帽幅'
    '幌幔幕幢干干平年并幸幻幼幽广庄庆庇床序庐库应底店庙府庞废度座庭庵庶康庸廉廊廓延廷建开异弃弄弊式弓引弛弟张弥弦弧弯弱弹强归当录形彤彩彪彬彭彰影役彻彼往征径待很徊律'
    '徐徒徒得徘御循微德徽心必忆忌忍志忘忙忠忧快忱念忽忿怀态怎怒怔怕怖怜思怠急性怨怪怯总恃恋恍恐恒恕恢恤恨恩恬恭息恰恳恶恼悄悉悍悔悟悠患悦您悬悯悲悴悼情惊惋惑惕惜惠惦'
    '惧惨惩惫惭惯惰想惶惹愁愈愉意愕愚感愤愧愿慈慌慎慕慢慧慨慰慷憋憎憔憨憾懂懈懊懒懦戈戏成我戒或战戚截戳戴户房所扁扇手才扎扑扒打扔托扛扣执扩扫扬扭扮扯扰扳扶批扼找承技'
    '抄把抑抒抓投抖抗折抚抛抠抡抢护报披抬抱抵抹押抽拂拄担拆拇拉拌拍拐拒拓拔拖拗拘拙招拜拟拢拣拥拦拧拨择括拭拯拱拳拴拷拼拾拿持挂指按挎挑挖挚挟挠挡挣挤挥挨挪挫振挺挽捂'
    '捅捆捉捌捍捎捏捐捕捞损捡换捣捧据捶捷捺捻掀掂授掉掌掏掐排掖掘掠探接控推掩措掰掷掸掺揉揍描提插揖握揣揩揪揭援揽搀搁搂搅搏搓搔搜搞搪搬搭携摄摆摇摊摔摘摧摩摸摹撇撑撒'
    '撕撞撤撩撬播撮撰撵撼擂擅操擎擒擦攀攒攘支收改攻放政故效敌敏救教敛敞敢散敦敬数敲整敷文斋斑斗料斜斟斤斥斧斩断斯新方施旁旅旋族旗无既日旦旧旨早旬旭旱时旷旺昂昆昌明昏'
    '易昔昙星映春昧昨昭是昵昼显晃晋晌晒晓晕晚晤晦晨普景晰晴晶智晾暂暇暑暖暗暮暴曙曲更曹曼曾替最月有朋服朗望朝期朦木未末本术朱朴朵机朽杀杂权杆杈杉李杏材村杖杜束杠条来'
    '杨杭杯杰松板极构枉析枕林枚果枝枢枣枪枫枯架枷柄柏某柑柒染柔柜柠查柬柱柳柴柿栅标栈栋栏树栓栖栗校株样核根格栽桂桃桅框案桌桐桑档桥桦桨桩桶梁梅梆梗梢梦梧梨梭梯械梳检'
    '棉棋棍棒棕棘棚棠森棱棵棺椅植椎椒椭椰椿楔楚楞楣楷楼概榄榆榔榕榛榜榨榴槐槽樊樟模横樱橄橘橙橡橱檀檐檩檬欠次欢欣欧欲欺款歇歉歌止正此步武歧歪歹死歼殃殉殊残殖殴段殷殿'
    '毁毅母每毒比毕毙毛毡毫毯氏民氓气氛氢氧氨氮氯水永汁求汇汉汗汛汞江池污汤汪汰汹汽沃沈沉沐沙沛沟没沥沦沧沪沫沮河沸油治沼沽沾沿泄泉泊泌法泛泞泡波泣泥注泪泰泳泵泻泼泽'
    '洁洋洒洗洛洞津洪洲活洼洽派流浅浆浇浊测济浑浓浙浦浩浪浮浴海浸涂消涉涌涎涕涛涝涡涣涤润涧涨涩涮涯液涵淀淆淋淌淑淘淡淤淫淮深淳混淹添清渊渐渔渗渠渡渣渤温港渴游渺湃湖'
    '湘湾湿溃溅溉源溜溢溪溯溶溺滋滑滓滔滚滞满滤滥滨滩滴漂漆漏漓演漠漩漫漱漾潘潜潦潭潮澄澈澎澜澡澳激濒瀑灌火灭灯灰灵灶灸灼灾灿炉炊炎炒炕炫炬炭炮炸点炼烁烂烈烘烙烛烟烤'
    '烦烧烫热烹焊焕焙焚焦焰然煌煎煞煤照煮熄熊熏熔熙熟熬燃燎燕燥爆爪爬爱爵父爷爸爹爽片版牌牍牙牛牡牢牧物牲牵特牺犀犁犬犯状犹狂狈狐狗狞狠狡独狭狮狰狱狸狼猎猖猛猜猩猪猫'
    '猬献猴猾猿玄率玉王玖玛玩玫环现玲玷玻珊珍珠班球琅理琉琐琢琳琴琼瑞瑟瑰璃璧瓜瓢瓣瓤瓦瓮瓶瓷甘甚甜生甥用甩甫田由甲申电男甸画畅界畏畔留畜略畦番畴畸疆疏疑疗疙疚疟疤疫'
    '疮疯疲疹疼疾病症痊痒痕痘痛痢痪痰痴痹瘟瘤瘦瘩瘪瘫瘸瘾癌癞癣登白百皂的皆皇皮皱皿盅盆盈益盏盐监盒盔盖盗盘盛盟目盯盲直相盹盼盾省眉看真眠眨眯眶眷眼着睁睛睡督睦睬睹瞄'
    '瞎瞒瞧瞪瞬瞭瞳瞻矗矛矢知矩矫短矮石矾矿码砂砌砍研砖砚砰破砸砾础硅硕硝硫硬确硼碉碌碍碎碑碗碘碟碧碰碱碳碴碾磁磅磕磨磷磺礁示礼社祈祖祝神祟祠祥票祭祷祸禀禁福离禽禾秀'
    '私秃秆秉秋种科秒秕秘租秤秦秧秩秫积称秸移秽稀程稍税稚稠稳稻稼稽稿穆穗穴究穷空穿突窃窄窍窑窒窖窗窘窜窝窟窥窿立竖站竞竟章竣童竭端竹竿笆笋笑笔笙笛笤符笨第笼等筋筏筐'
    '筑筒答策筛筝筷筹签简箍箕算管箩箫箭箱篇篓篙篡篮篱篷簇簸簿籍米类籽粉粒粗粘粟粤粥粪粮粱粹精糊糕糖糙糜糟糠糯系紊素索紧紫累絮繁纠红纤约级纪纫纬纯纱纲纳纵纷纸纹纺纽线'
    '练组绅细织终绊绍绎经绑绒结绕绘给络绝绞统绢绣继绩绪续绰绳维绵绷绸综绽绿缀缅缆缎缓缔缕编缘缚缝缠缤缨缩缭缰缴缸缺罐网罕罗罚罢罩罪置署羊美羔羞羡群羹羽翁翅翎翔翘翠翩'
    '翰翻翼耀老考者而耍耐耕耕耗耙耳耸耻耽耿聂聊聋职联聘聚聪肃肄肆肉肋肌肖肘肚肛肝肠股肢肤肥肩肪肮肯育肴肺肾肿胀胁胃胆背胎胖胚胜胞胡胧胯胰胳胶胸能脂脆脉脊脏脐脑脓脖脚'
    '脯脱脸脾腊腋腌腐腔腕腥腮腰腹腺腻腾腿膀膊膏膘膛膜膝膨膳臀臂臊臣自臭至致臼舀舅舆舌舍舒舔舞舟航般舰舱舵舶舷船艇艘良艰色艳艺艾节芋芍芒芙芜芝芥芦芬芭芯花芳芹芽苇苍苏'
    '苔苗苛苞苟若苦苫英苹茁茂范茄茅茉茎茧茫茬茴茵茶茸荆草荐荒荔荚荞荠荡荣荤荧药荷荸莉莫莱莲获莹莺莽菇菊菌菜菠菩菱菲萄萌萍萎萝萤营萧萨落著葛葡董葫葬葱葵蒂蒋蒙蒜蒲蒸蒿'
    '蓄蓉蓖蓝蓬蔑蔓蔗蔚蔫蔬蔼蔽蕉蕊蕴蕾薄薇薛薪薯藏藐藕藤藻蘑蘸虎虏虐虑虚虫虱虹虽虾蚀蚁蚂蚊蚌蚓蚕蚜蚣蚤蚪蚯蛀蛆蛇蛉蛋蛔蛙蛛蛤蛮蛹蛾蜀蜂蜈蜒蜓蜕蜗蜘蜜蜡蜻蝇蝉蝌蝎蝗蝙'
    '蝠蝴蝶螃融螟螺蟀蟆蟋蟹蠕蠢血衅行衍衔街衙衡衣补表衩衫衬衰衷袁袄袋袍袒袖袜被袭袱裁裂装裆裉裕裙裤裳裸裹褂褐褒褥襟西要覆见观规觅视览觉角解触言誉誊誓警譬计订认讥讨让'
    '训议讯记讲讳讶许讹论讼讽设访诀证评诅识诈诉诊词译试诗诚话诞诡询该详诫诬语误诱诲说诵请诸诺读诽课谁调谅谆谈谊谋谍谎谐谒谓谚谜谢谣谤谦谨谬谭谱谴谷豁豆豌象豪豫豹豺貌'
    '贝贞负贡财责贤败账货货质贩贪贫贬购贮贯贰贱贴贵贸费贺贼贾贿赁赂赃资赊赋赌赎赏赐赔赖赘赚赛赞赠赡赢赤赦赫走赴赵赶起趁超越趋趟趣足趴趾跃跋跌跑跛距跟跨跪路跳践跷跺踊'
    '踏踢踩踪踱蹂蹄蹈蹋蹦蹬蹭蹲躁躏身躬躯躲躺车轧轨轩转轮软轰轴轻载轿较辅辆辈辉辐辑输辕辖辙辛辜辞辟辣辨辩辫辰辱边辽达迁迂迄迅过迈迎运近返还这进远违连迟迫述迷迹追退送'
    '适逃逆选逊透逐递途逗通逛逝逞速造逢逮逸逻逼逾遂遇遍遏道遗遣遥遭遮遵避邀邑邓邢那邦邪邮邻郁郊郎郑部郭都鄙酌配酒酗酝酣酥酪酬酱酵酷酸酿醇醉醋醒采释里重野量金鉴针钉钓'
    '钙钝钞钟钠钢钥钦钧钩钮钱钳钻钾铁铃铅铆铐铛铜铝铡铣铭铲银铸铺链销锁锄锅锈锉锋锌锐错锚锡锣锤锥锦锨锭键锯锰锹锻镀镇镊镐镜镣镰镶长门闪闭问闯闰闲间闷闸闹闺闻闽阀阁阅'
    '阎阐阔队阱防阳阴阵阶阻阿附际陆陈陋陌降限陕陡院除陨险陪陵陶陷隅隆随隐隔隘隙障隧隶难雀雁雄雅集雇雌雏雕雨雪雳零雷雹雾需震霉霍霎霜霞露霸霹青靖静非靠靡面革靴靶鞋鞍鞠'
    '鞭韧韩韭音韵页顶顷项顺须顽顾顿颁颂预颅领颇颈颊频颓颖颗题颜额颠颤风飒飘飞食餐饥饭饮饰饱饲饵饶饺饼饿馁馅馆馋馍馏馒首香马驮驯驰驱驳驴驶驹驻驼驾骂骄骆骇验骏骑骗骚骡'
    '骤骨髓高鬓鬼魁魂魄魏魔鱼鲁鲜鲤鲫鲸鳄鳍鳖鳞鸟鸠鸡鸣鸥鸦鸭鸯鸳鸵鸽鸿鹃鹅鹉鹊鹏鹤鹦鹰鹿麦麸麻黄黍黎黑黔默鼎鼓鼠鼻齐齿龄龙龟'
)

gb2132 = (
    '啊阿埃挨哎唉哀皑癌蔼矮艾碍爱隘鞍氨安俺按暗岸胺案肮昂盎凹敖熬翱袄傲奥懊澳芭捌扒叭吧笆八疤巴拔跋靶把耙坝霸罢爸白柏百摆佰败拜稗斑班搬扳般颁板版扮拌伴瓣半办绊邦帮梆'
    '榜膀绑棒磅蚌镑傍谤苞胞包褒剥薄雹保堡饱宝抱报暴豹鲍爆杯碑悲卑北辈背贝钡倍狈备惫焙被奔苯本笨崩绷甭泵蹦迸逼鼻比鄙笔彼碧蓖蔽毕毙毖币庇痹闭敝弊必辟壁臂避陛鞭边编贬扁'
    '便变卞辨辩辫遍标彪膘表鳖憋别瘪彬斌濒滨宾摈兵冰柄丙秉饼炳病并玻菠播拨钵波博勃搏铂箔伯帛舶脖膊渤泊驳捕卜哺补埠不布步簿部怖擦猜裁材才财睬踩采彩菜蔡餐参蚕残惭惨灿苍'
    '舱仓沧藏操糙槽曹草厕策侧册测层蹭插叉茬茶查碴搽察岔差诧拆柴豺搀掺蝉馋谗缠铲产阐颤昌猖场尝常长偿肠厂敞畅唱倡超抄钞朝嘲潮巢吵炒车扯撤掣彻澈郴臣辰尘晨忱沉陈趁衬撑称'
    '城橙成呈乘程惩澄诚承逞骋秤吃痴持匙池迟弛驰耻齿侈尺赤翅斥炽充冲虫崇宠抽酬畴踌稠愁筹仇绸瞅丑臭初出橱厨躇锄雏滁除楚础储矗搐触处揣川穿椽传船喘串疮窗幢床闯创吹炊捶锤'
    '垂春椿醇唇淳纯蠢戳绰疵茨磁雌辞慈瓷词此刺赐次聪葱囱匆从丛凑粗醋簇促蹿篡窜摧崔催脆瘁粹淬翠村存寸磋撮搓措挫错搭达答瘩打大呆歹傣戴带殆代贷袋待逮怠耽担丹单郸掸胆旦氮'
    '但惮淡诞弹蛋当挡党荡档刀捣蹈倒岛祷导到稻悼道盗德得的蹬灯登等瞪凳邓堤低滴迪敌笛狄涤翟嫡抵底地蒂第帝弟递缔颠掂滇碘点典靛垫电佃甸店惦奠淀殿碉叼雕凋刁掉吊钓调跌爹碟'
    '蝶迭谍叠丁盯叮钉顶鼎锭定订丢东冬董懂动栋侗恫冻洞兜抖斗陡豆逗痘都督毒犊独读堵睹赌杜镀肚度渡妒端短锻段断缎堆兑队对墩吨蹲敦顿囤钝盾遁掇哆多夺垛躲朵跺舵剁惰堕蛾峨鹅'
    '俄额讹娥恶厄扼遏鄂饿恩而儿耳尔饵洱二贰发罚筏伐乏阀法珐藩帆番翻樊矾钒繁凡烦反返范贩犯饭泛坊芳方肪房防妨仿访纺放菲非啡飞肥匪诽吠肺废沸费芬酚吩氛分纷坟焚汾粉奋份忿'
    '愤粪丰封枫蜂峰锋风疯烽逢冯缝讽奉凤佛否夫敷肤孵扶拂辐幅氟符伏俘服浮涪福袱弗甫抚辅俯釜斧脯腑府腐赴副覆赋复傅付阜父腹负富讣附妇缚咐噶嘎该改概钙盖溉干甘杆柑竿肝赶感'
    '秆敢赣冈刚钢缸肛纲岗港杠篙皋高膏羔糕搞镐稿告哥歌搁戈鸽胳疙割革葛格蛤阁隔铬个各给根跟耕更庚羹埂耿梗工攻功恭龚供躬公宫弓巩汞拱贡共钩勾沟苟狗垢构购够辜菇咕箍估沽孤'
    '姑鼓古蛊骨谷股故顾固雇刮瓜剐寡挂褂乖拐怪棺关官冠观管馆罐惯灌贯光广逛瑰规圭硅归龟闺轨鬼诡癸桂柜跪贵刽辊滚棍锅郭国果裹过哈骸孩海氦亥害骇酣憨邯韩含涵寒函喊罕翰撼捍'
    '旱憾悍焊汗汉夯杭航壕嚎豪毫郝好耗号浩呵喝荷菏核禾和何合盒貉阂河涸赫褐鹤贺嘿黑痕很狠恨哼亨横衡恒轰哄烘虹鸿洪宏弘红喉侯猴吼厚候后呼乎忽瑚壶葫胡蝴狐糊湖弧虎唬护互沪'
    '户花哗华猾滑画划化话槐徊怀淮坏欢环桓还缓换患唤痪豢焕涣宦幻荒慌黄磺蝗簧皇凰惶煌晃幌恍谎灰挥辉徽恢蛔回毁悔慧卉惠晦贿秽会烩汇讳诲绘荤昏婚魂浑混豁活伙火获或惑霍货祸'
    '击圾基机畸稽积箕肌饥迹激讥鸡姬绩缉吉极棘辑籍集及急疾汲即嫉级挤几脊己蓟技冀季伎祭剂悸济寄寂计记既忌际妓继纪嘉枷夹佳家加荚颊贾甲钾假稼价架驾嫁歼监坚尖笺间煎兼肩艰'
    '奸缄茧检柬碱硷拣捡简俭剪减荐槛鉴践贱见键箭件健舰剑饯渐溅涧建僵姜将浆江疆蒋桨奖讲匠酱降蕉椒礁焦胶交郊浇骄娇嚼搅铰矫侥脚狡角饺缴绞剿教酵轿较叫窖揭接皆秸街阶截劫节'
    '桔杰捷睫竭洁结解姐戒藉芥界借介疥诫届巾筋斤金今津襟紧锦仅谨进靳晋禁近烬浸尽劲荆兢茎睛晶鲸京惊精粳经井警景颈静境敬镜径痉靖竟竞净炯窘揪究纠玖韭久灸九酒厩救旧臼舅咎'
    '就疚鞠拘狙疽居驹菊局咀矩举沮聚拒据巨具距踞锯俱句惧炬剧捐鹃娟倦眷卷绢撅攫抉掘倔爵觉决诀绝均菌钧军君峻俊竣浚郡骏喀咖卡咯开揩楷凯慨刊堪勘坎砍看康慷糠扛抗亢炕考拷烤'
    '靠坷苛柯棵磕颗科壳咳可渴克刻客课肯啃垦恳坑吭空恐孔控抠口扣寇枯哭窟苦酷库裤夸垮挎跨胯块筷侩快宽款匡筐狂框矿眶旷况亏盔岿窥葵奎魁傀馈愧溃坤昆捆困括扩廓阔垃拉喇蜡腊'
    '辣啦莱来赖蓝婪栏拦篮阑兰澜谰揽览懒缆烂滥琅榔狼廊郎朗浪捞劳牢老佬姥酪烙涝勒乐雷镭蕾磊累儡垒擂肋类泪棱楞冷厘梨犁黎篱狸离漓理李里鲤礼莉荔吏栗丽厉励砾历利傈例俐痢立'
    '粒沥隶力璃哩俩联莲连镰廉怜涟帘敛脸链恋炼练粮凉梁粱良两辆量晾亮谅撩聊僚疗燎寥辽潦了撂镣廖料列裂烈劣猎琳林磷霖临邻鳞淋凛赁吝拎玲菱零龄铃伶羚凌灵陵岭领另令溜琉榴硫'
    '馏留刘瘤流柳六龙聋咙笼窿隆垄拢陇楼娄搂篓漏陋芦卢颅庐炉掳卤虏鲁麓碌露路赂鹿潞禄录陆戮驴吕铝侣旅履屡缕虑氯律率滤绿峦挛孪滦卵乱掠略抡轮伦仑沦纶论萝螺罗逻锣箩骡裸落'
    '洛骆络妈麻玛码蚂马骂嘛吗埋买麦卖迈脉瞒馒蛮满蔓曼慢漫谩芒茫盲氓忙莽猫茅锚毛矛铆卯茂冒帽貌贸么玫枚梅酶霉煤没眉媒镁每美昧寐妹媚门闷们萌蒙檬盟锰猛梦孟眯醚靡糜迷谜弥'
    '米秘觅泌蜜密幂棉眠绵冕免勉娩缅面苗描瞄藐秒渺庙妙蔑灭民抿皿敏悯闽明螟鸣铭名命谬摸摹蘑模膜磨摩魔抹末莫墨默沫漠寞陌谋牟某拇牡亩姆母墓暮幕募慕木目睦牧穆拿哪呐钠那娜'
    '纳氖乃奶耐奈南男难囊挠脑恼闹淖呢馁内嫩能妮霓倪泥尼拟你匿腻逆溺蔫拈年碾撵捻念娘酿鸟尿捏聂孽啮镊镍涅您柠狞凝宁拧泞牛扭钮纽脓浓农弄奴努怒女暖虐疟挪懦糯诺哦欧鸥殴藕'
    '呕偶沤啪趴爬帕怕琶拍排牌徘湃派攀潘盘磐盼畔判叛乓庞旁耪胖抛咆刨炮袍跑泡呸胚培裴赔陪配佩沛喷盆砰抨烹澎彭蓬棚硼篷膨朋鹏捧碰坯砒霹批披劈琵毗啤脾疲皮匹痞僻屁譬篇偏片'
    '骗飘漂瓢票撇瞥拼频贫品聘乒坪苹萍平凭瓶评屏坡泼颇婆破魄迫粕剖扑铺仆莆葡菩蒲埔朴圃普浦谱曝瀑期欺栖戚妻七凄漆柒沏其棋奇歧畦崎脐齐旗祈祁骑起岂乞企启契砌器气迄弃汽泣'
    '讫掐恰洽牵扦钎铅千迁签仟谦乾黔钱钳前潜遣浅谴堑嵌欠歉枪呛腔羌墙蔷强抢橇锹敲悄桥瞧乔侨巧鞘撬翘峭俏窍切茄且怯窃钦侵亲秦琴勤芹擒禽寝沁青轻氢倾卿清擎晴氰情顷请庆琼穷'
    '秋丘邱球求囚酋泅趋区蛆曲躯屈驱渠取娶龋趣去圈颧权醛泉全痊拳犬券劝缺炔瘸却鹊榷确雀裙群然燃冉染瓤壤攘嚷让饶扰绕惹热壬仁人忍韧任认刃妊纫扔仍日戎茸蓉荣融熔溶容绒冗揉'
    '柔肉茹蠕儒孺如辱乳汝入褥软阮蕊瑞锐闰润若弱撒洒萨腮鳃塞赛三叁伞散桑嗓丧搔骚扫嫂瑟色涩森僧莎砂杀刹沙纱傻啥煞筛晒珊苫杉山删煽衫闪陕擅赡膳善汕扇缮墒伤商赏晌上尚裳梢'
    '捎稍烧芍勺韶少哨邵绍奢赊蛇舌舍赦摄射慑涉社设砷申呻伸身深娠绅神沈审婶甚肾慎渗声生甥牲升绳省盛剩胜圣师失狮施湿诗尸虱十石拾时什食蚀实识史矢使屎驶始式示士世柿事拭誓'
    '逝势是嗜噬适仕侍释饰氏市恃室视试收手首守寿授售受瘦兽蔬枢梳殊抒输叔舒淑疏书赎孰熟薯暑曙署蜀黍鼠属术述树束戍竖墅庶数漱恕刷耍摔衰甩帅栓拴霜双爽谁水睡税吮瞬顺舜说硕'
    '朔烁斯撕嘶思私司丝死肆寺嗣四伺似饲巳松耸怂颂送宋讼诵搜艘擞嗽苏酥俗素速粟僳塑溯宿诉肃酸蒜算虽隋随绥髓碎岁穗遂隧祟孙损笋蓑梭唆缩琐索锁所塌他它她塔獭挞蹋踏胎苔抬台'
    '泰酞太态汰坍摊贪瘫滩坛檀痰潭谭谈坦毯袒碳探叹炭汤塘搪堂棠膛唐糖倘躺淌趟烫掏涛滔绦萄桃逃淘陶讨套特藤腾疼誊梯剔踢锑提题蹄啼体替嚏惕涕剃屉天添填田甜恬舔腆挑条迢眺跳'
    '贴铁帖厅听烃汀廷停亭庭挺艇通桐酮瞳同铜彤童桶捅筒统痛偷投头透凸秃突图徒途涂屠土吐兔湍团推颓腿蜕褪退吞屯臀拖托脱鸵陀驮驼椭妥拓唾挖哇蛙洼娃瓦袜歪外豌弯湾玩顽丸烷完'
    '碗挽晚皖惋宛婉万腕汪王亡枉网往旺望忘妄威巍微危韦违桅围唯惟为潍维苇萎委伟伪尾纬未蔚味畏胃喂魏位渭谓尉慰卫瘟温蚊文闻纹吻稳紊问嗡翁瓮挝蜗涡窝我斡卧握沃巫呜钨乌污诬'
    '屋无芜梧吾吴毋武五捂午舞伍侮坞戊雾晤物勿务悟误昔熙析西硒矽晰嘻吸锡牺稀息希悉膝夕惜熄烯溪汐犀檄袭席习媳喜铣洗系隙戏细瞎虾匣霞辖暇峡侠狭下厦夏吓掀锨先仙鲜纤咸贤衔'
    '舷闲涎弦嫌显险现献县腺馅羡宪陷限线相厢镶香箱襄湘乡翔祥详想响享项巷橡像向象萧硝霄削哮嚣销消宵淆晓小孝校肖啸笑效楔些歇蝎鞋协挟携邪斜胁谐写械卸蟹懈泄泻谢屑薪芯锌欣'
    '辛新忻心信衅星腥猩惺兴刑型形邢行醒幸杏性姓兄凶胸匈汹雄熊休修羞朽嗅锈秀袖绣墟戌需虚嘘须徐许蓄酗叙旭序畜恤絮婿绪续轩喧宣悬旋玄选癣眩绚靴薛学穴雪血勋熏循旬询寻驯巡'
    '殉汛训讯逊迅压押鸦鸭呀丫芽牙蚜崖衙涯雅哑亚讶焉咽阉烟淹盐严研蜒岩延言颜阎炎沿奄掩眼衍演艳堰燕厌砚雁唁彦焰宴谚验殃央鸯秧杨扬佯疡羊洋阳氧仰痒养样漾邀腰妖瑶摇尧遥窑'
    '谣姚咬舀药要耀椰噎耶爷野冶也页掖业叶曳腋夜液一壹医揖铱依伊衣颐夷遗移仪胰疑沂宜姨彝椅蚁倚已乙矣以艺抑易邑屹亿役臆逸肄疫亦裔意毅忆义益溢诣议谊译异翼翌绎茵荫因殷音'
    '阴姻吟银淫寅饮尹引隐印英樱婴鹰应缨莹萤营荧蝇迎赢盈影颖硬映哟拥佣臃痈庸雍踊蛹咏泳涌永恿勇用幽优悠忧尤由邮铀犹油游酉有友右佑釉诱又幼迂淤于盂榆虞愚舆余俞逾鱼愉渝渔'
    '隅予娱雨与屿禹宇语羽玉域芋郁吁遇喻峪御愈欲狱育誉浴寓裕预豫驭鸳渊冤元垣袁原援辕园员圆猿源缘远苑愿怨院曰约越跃钥岳粤月悦阅耘云郧匀陨允运蕴酝晕韵孕匝砸杂栽哉灾宰载'
    '再在咱攒暂赞赃脏葬遭糟凿藻枣早澡蚤躁噪造皂灶燥责择则泽贼怎增憎曾赠扎喳渣札轧铡闸眨栅榨咋乍炸诈摘斋宅窄债寨瞻毡詹粘沾盏斩辗崭展蘸栈占战站湛绽樟章彰漳张掌涨杖丈帐'
    '账仗胀瘴障招昭找沼赵照罩兆肇召遮折哲蛰辙者锗蔗这浙珍斟真甄砧臻贞针侦枕疹诊震振镇阵蒸挣睁征狰争怔整拯正政帧症郑证芝枝支吱蜘知肢脂汁之织职直植殖执值侄址指止趾只旨'
    '纸志挚掷至致置帜峙制智秩稚质炙痔滞治窒中盅忠钟衷终种肿重仲众舟周州洲诌粥轴肘帚咒皱宙昼骤珠株蛛朱猪诸诛逐竹烛煮拄瞩嘱主著柱助蛀贮铸筑住注祝驻抓爪拽专砖转撰赚篆桩'
    '庄装妆撞壮状椎锥追赘坠缀谆准捉拙卓桌琢茁酌啄着灼浊兹咨资姿滋淄孜紫仔籽滓子自渍字鬃棕踪宗综总纵邹走奏揍租足卒族祖诅阻组钻纂嘴醉最罪尊遵昨左佐柞做作坐座亍兀丐廿卅'
    '丕亘丞鬲孬噩丨禺丿匕乇夭爻卮氐囟胤馗毓睾鼗丶亟鼐乜乩亓芈孛啬嘏仄厍厝厣厥厮靥赝叵匦匮匾赜卦卣刈刎刭刳刿剀剌剞剡剜蒯剽劂劁劐劓罔仃仉仂仨仡仫仞伛仳伢佤仵伥伧伉伫佞'
    '佧攸佚佝佟佗伲伽佶佴侑侉侃侏佾佻侪佼侬侔俦俨俪俅俚俣俜俑俟俸倩偌俳倬倏倮倭俾倜倌倥倨偾偃偕偈偎偬偻傥傧傩傺僖儆僭僬僦僮儇儋仝氽佘佥俎龠汆籴兮巽黉馘冁夔勹匍訇匐凫'
    '夙兕兖亳衮袤亵脔裒禀嬴蠃羸冱冽冼凇冢冥讦讧讪讴讵讷诂诃诋诏诎诒诓诔诖诘诙诜诟诠诤诨诩诮诰诳诶诹诼诿谀谂谄谇谌谏谑谒谔谕谖谙谛谘谝谟谠谡谥谧谪谫谮谯谲谳谵谶卺阢阡'
    '阱阪阽阼陂陉陔陟陧陬陲陴隈隍隗隰邗邛邝邙邬邡邴邳邶邺邸邰郏郅邾郐郄郇郓郦郢郜郗郛郫郯郾鄄鄢鄞鄣鄱鄯鄹酃酆刍奂劢劬劭劾哿勐勖勰叟燮矍凼鬯厶弁畚巯坌垩垡塾墼壅壑圩圬'
    '圪圳圹圮圯坜圻坂坩垅坫垆坼坻坨坭坶坳垭垤垌垲埏垧垴垓垠埕埘埚埙埒垸埴埯埸埤埝堋堍埽埭堀堞堙塄堠塥塬墁墉墚墀馨鼙懿艽艿芏芊芨芄芎芑芗芙芫芸芾芰苈苊苣芘芷芮苋苌苁芩'
    '芴芡芪芟苄苎芤苡茉苷苤茏茇苜苴苒苘茌苻苓茑茚茆茔茕苠苕茜荑荛荜茈莒茼茴茱莛荞茯荏荇荃荟荀茗荠茭茺茳荦荥荨茛荩荬荪荭荮莰荸莳莴莠莪莓莜莅荼莶莩荽莸荻莘莞莨莺莼菁萁'
    '菥菘堇萘萋菝菽菖萜萸萑萆菔菟萏萃菸菹菪菅菀萦菰菡葜葑葚葙葳蒇蒈葺蒉葸萼葆葩葶蒌蒎萱葭蓁蓍蓐蓦蒽蓓蓊蒿蒺蓠蒡蒹蒴蒗蓥蓣蔌甍蔸蓰蔹蔟蔺蕖蔻蓿蓼蕙蕈蕨蕤蕞蕺瞢蕃蕲蕻薤'
    '薨薇薏蕹薮薜薅薹薷薰藓藁藜藿蘧蘅蘩蘖蘼弈夼奁耷奕奚奘匏尢尥尬尴扪抟抻拊拚拗拮挢拶挹捋捃掭揶捱捺掎掴捭掬掊捩掮掼揲揸揠揿揄揞揎摒揆掾摅摁搋搛搠搌搦搡摞撄摭撖摺撷撸'
    '撙撺擀擐擗擤擢攉攥攮弋忒甙弑卟叱叽叩叨叻吒吖吆呋呒m呓呔呖呃吡呗呙吣吲咂咔呷呱呤咚咛咄呶呦咝哐咭哂咴哒咧咦哓哔呲咣哕咻咿哌哙哚哜咩咪咤哝哏哞唛哧唠哽唔哳唢唣唏唑'
    '唧唪啧喏喵啉啭啁啕唿啐唼唷啖啵啶啷唳唰啜喋嗒喃喱喹喈喁喟啾嗖喑啻嗟喽喾喔喙嗪嗷嗉嘟嗑嗫嗬嗔嗦嗝嗄嗯嗥嗲嗳嗌嗍嗨嗵嗤辔嘞嘈嘌嘁嘤嘣嗾嘀嘧嘭噘嘹噗嘬噍噢噙噜噌噔嚆噤'
    '噱噫噻噼嚅嚓嚯囔囗囝囡囵囫囹囿圄圊圉圜帏帙帔帑帱帻帼帷幄幔幛幞幡岌屺岍岐岖岈岘岙岑岚岜岵岢岽岬岫岱岣峁岷峄峒峤峋峥崂崃崧崦崮崤崞崆崛嵘崾崴崽嵬嵛嵯嵝嵫嵋嵊嵩嵴嶂'
    '嶙嶝豳嶷巅彳彷徂徇徉後徕徙徜徨徭徵徼衢彡犭犰犴犷犸狃狁狎狍狒狨狯狩狲狴狷猁狳猃狺狻猗猓猡猊猞猝猕猢猹猥猬猸猱獐獍獗獠獬獯獾舛夥飧夤夂饧饨饩饪饫饬饴饷饽馀馄馇馊馍'
    '馐馑馓馔馕庀庑庋庖庥庠庹庵庾庳赓廒廑廛廨廪膺忉忖忏怃忮怄忡忤忾怅怆忪忭忸怙怵怦怛怏怍怩怫怊怿怡恸恹恻恺恂恪恽悖悚悭悝悃悒悌悛惬悻悱惝惘惆惚悴愠愦愕愣惴愀愎愫慊慵'
    '憬憔憧憷懔懵忝隳闩闫闱闳闵闶闼闾阃阄阆阈阊阋阌阍阏阒阕阖阗阙阚爿戕汔汜汊沣沅沐沔沌汨汩汴汶沆沩泐泔沭泷泸泱泗沲泠泖泺泫泮沱泓泯泾洹洧洌浃浈洇洄洙洎洫浍洮洵洚浏浒'
    '浔洳涑涞涠浞涓涔浜浠浼浣渚淇淅淞渎涿淠渑淦淝淙渖涫渌涮渫湮湎湫溲湟溆湓湔渲渥湄滟溱溘滠漭滢溥溧溽溻溷滗溴滏溏滂溟潢潆潇漤漕滹漯漶潋潴漪漉漩澉澍澌潸潲潼潺濑濉澧澹'
    '澶濂濡濮濞濠濯瀚瀣瀛瀹瀵灏灞宄宕宓宥宸甯骞搴寤寮褰寰蹇謇迓迕迥迮迤迩迦迳迨逅逄逋逦逑逍逖逡逵逶逭逯遄遑遒遐遨遘遢遛暹遴遽邂邈邃邋彗彖彘尻咫屐屙孱屣屦羼弪弩弭艴弼'
    '鬻妁妃妍妩妪妣妗姊妫妞妤姒妲妯姗妾娅娆姝娈姣姘姹娌娉娲娴娑娣娓婀婧婊婕娼婢婵胬媪媛婷婺媾嫫媲嫒嫔媸嫠嫣嫱嫖嫦嫘嫜嬉嬗嬖嬲嬷孀尕尜孚孥孳孑孓孢驵驷驸驺驿驽骀骁骅骈'
    '骊骐骒骓骖骘骛骜骝骟骠骢骣骥骧纡纣纥纨纩纭纰纾绀绁绂绉绋绌绐绔绗绛绠绡绨绫绮绯绱绲缍绶绺绻绾缁缂缃缇缈缋缌缏缑缒缗缙缜缛缟缡缢缣缤缥缦缧缪缫缬缭缯缰缱缲缳缵幺畿'
    '甾邕玎玑玮玢玟珏珂珑玷玳珀珉珈珥珙顼琊珩珧珞玺珲琏琪瑛琦琥琨琰琮琬琛琚瑁瑜瑗瑕瑙瑷瑭瑾璜璎璀璁璇璋璞璨璩璐璧瓒璺韪韫韬杌杓杞杈杩枥枇杪杳枘枧杵枨枞枭枋杷杼柰栉柘'
    '栊柩枰栌柙枵柚枳柝栀柃枸柢栎柁柽栲栳桠桡桎桢桄桤梃栝桕桦桁桧桀栾桊桉栩梵梏桴桷梓桫棂楮棼椟椠棹椤棰椋椁楗棣椐楱椹楠楂楝榄楫榀榘楸椴槌榇榈槎榉楦楣楹榛榧榻榫榭槔榱'
    '槁槊槟榕槠榍槿樯槭樗樘橥槲橄樾檠橐橛樵檎橹樽樨橘橼檑檐檩檗檫猷獒殁殂殇殄殒殓殍殚殛殡殪轫轭轱轲轳轵轶轸轷轹轺轼轾辁辂辄辇辋辍辎辏辘辚軎戋戗戛戟戢戡戥戤戬臧瓯瓴瓿'
    '甏甑甓旮旯旰昊昙杲昃昕昀炅曷昝昴昱昶昵耆晟晔晁晏晖晡晗晷暄暌暧暝暾曛曜曦曩贲贳贶贻贽赀赅赆赈赉赇赍赕赙觇觊觋觌觎觏觐觑牮犟牝牦牯牾牿犄犋犍犏犒挈挲掰搿擘耄毪毳毽'
    '毵毹氅氇氆氍氕氘氙氚氡氩氤氪氲攵敕敫牍牒牖爰虢刖肟肜肓肼朊肽肱肫肭肴肷胧胨胩胪胛胂胄胙胍胗朐胝胫胱胴胭脍脎胲胼朕脒豚脶脞脬脘脲腈腌腓腴腙腚腱腠腩腼腽腭腧塍媵膈膂'
    '膑滕膣膪臌朦臊膻臁膦欤欷欹歃歆歙飑飒飓飕飙飚殳彀毂觳斐齑斓於旆旄旃旌旎旒旖炀炜炖炝炻烀炷炫炱烨烊焐焓焖焯焱煳煜煨煅煲煊煸煺熘熳熵熨熠燠燔燧燹爝爨焘煦熹戾戽扃扈扉'
    '礻祀祆祉祛祜祓祚祢祗祠祯祧祺禅禊禚禧禳忑忐怼恝恚恧恁恙恣悫愆愍慝憩憝懋懑戆聿沓泶淼矶矸砀砉砗砘砑斫砭砜砝砹砺砻砟砼砥砬砣砩硎硭硖硗砦硐硇硌硪碛碓碚碇碜碡碣碲碹碥'
    '磔磙磉磬磲礅磴礓礤礞礴龛黹黻黼盱眄眍盹眇眈眚眢眙眭眦眵眸睐睑睇睃睚睨睢睥睿瞍睽瞀瞌瞑瞟瞠瞰瞵瞽町畀畎畋畈畛畲畹疃罘罡罟詈罨罴罱罹羁罾盍盥蠲钆钇钋钊钌钍钏钐钔钗钕'
    '钚钛钜钣钤钫钪钭钬钯钰钲钴钶钷钸钹钺钼钽钿铄铈铉铊铋铌铍铎铐铑铒铕铖铗铙铘铛铞铟铠铢铤铥铧铨铪铩铫铮铯铳铴铵铷铹铼铽铿锃锂锆锇锉锊锍锎锏锒锓锔锕锖锘锛锝锞锟锢锪'
    '锫锩锬锱锲锴锶锷锸锼锾锿镂锵镄镅镆镉镌镎镏镒镓镔镖镗镘镙镛镞镟镝镡镢镤镥镦镧镨镩镪镫镬镯镱镲镳锺矧矬雉秕秭秣秫稆嵇稃稂稞稔稹稷穑黏馥穰皈皎皓皙皤瓞瓠甬鸠鸢鸨鸩鸪'
    '鸫鸬鸲鸱鸶鸸鸷鸹鸺鸾鹁鹂鹄鹆鹇鹈鹉鹋鹌鹎鹑鹕鹗鹚鹛鹜鹞鹣鹦鹧鹨鹩鹪鹫鹬鹱鹭鹳疔疖疠疝疬疣疳疴疸痄疱疰痃痂痖痍痣痨痦痤痫痧瘃痱痼痿瘐瘀瘅瘌瘗瘊瘥瘘瘕瘙瘛瘼瘢瘠癀瘭'
    '瘰瘿瘵癃瘾瘳癍癞癔癜癖癫癯翊竦穸穹窀窆窈窕窦窠窬窨窭窳衩衲衽衿袂袢裆袷袼裉裢裎裣裥裱褚裼裨裾裰褡褙褓褛褊褴褫褶襁襦襻疋胥皲皴矜耒耔耖耜耠耢耥耦耧耩耨耱耋耵聃聆聍'
    '聒聩聱覃顸颀颃颉颌颍颏颔颚颛颞颟颡颢颥颦虔虬虮虿虺虼虻蚨蚍蚋蚬蚝蚧蚣蚪蚓蚩蚶蛄蚵蛎蚰蚺蚱蚯蛉蛏蚴蛩蛱蛲蛭蛳蛐蜓蛞蛴蛟蛘蛑蜃蜇蛸蜈蜊蜍蜉蜣蜻蜞蜥蜮蜚蜾蝈蜴蜱蜩蜷蜿'
    '螂蜢蝽蝾蝻蝠蝰蝌蝮螋蝓蝣蝼蝤蝙蝥螓螯螨蟒蟆螈螅螭螗螃螫蟥螬螵螳蟋蟓螽蟑蟀蟊蟛蟪蟠蟮蠖蠓蟾蠊蠛蠡蠹蠼缶罂罄罅舐竺竽笈笃笄笕笊笫笏筇笸笪笙笮笱笠笥笤笳笾笞筘筚筅筵筌'
    '筝筠筮筻筢筲筱箐箦箧箸箬箝箨箅箪箜箢箫箴篑篁篌篝篚篥篦篪簌篾篼簏簖簋簟簪簦簸籁籀臾舁舂舄臬衄舡舢舣舭舯舨舫舸舻舳舴舾艄艉艋艏艚艟艨衾袅袈裘裟襞羝羟羧羯羰羲籼敉粑'
    '粝粜粞粢粲粼粽糁糇糌糍糈糅糗糨艮暨羿翎翕翥翡翦翩翮翳絷綦綮繇纛麸麴赳趄趔趑趱赧赭豇豉酊酐酎酏酤酢酡酰酩酯酽酾酲酴酹醌醅醐醍醑醢醣醪醭醮醯醵醴醺豕鹾趸跫踅蹙蹩趵趿'
    '趼趺跄跖跗跚跞跎跏跛跆跬跷跸跣跹跻跤踉跽踔踝踟踬踮踣踯踺蹀踹踵踽踱蹉蹁蹂蹑蹒蹊蹰蹶蹼蹯蹴躅躏躔躐躜躞豸貂貊貅貘貔斛觖觞觚觜觥觫觯訾謦靓雩雳雯霆霁霈霏霎霪霭霰霾龀'
    '龃龅龆龇龈龉龊龌黾鼋鼍隹隼隽雎雒瞿雠銎銮鋈錾鍪鏊鎏鐾鑫鱿鲂鲅鲆鲇鲈稣鲋鲎鲐鲑鲒鲔鲕鲚鲛鲞鲟鲠鲡鲢鲣鲥鲦鲧鲨鲩鲫鲭鲮鲰鲱鲲鲳鲴鲵鲶鲷鲺鲻鲼鲽鳄鳅鳆鳇鳊鳋鳌鳍鳎鳏鳐'
    '鳓鳔鳕鳗鳘鳙鳜鳝鳟鳢靼鞅鞑鞒鞔鞯鞫鞣鞲鞴骱骰骷鹘骶骺骼髁髀髅髂髋髌髑魅魃魇魉魈魍魑飨餍餮饕饔髡髦髯髫髻髭髹鬈鬏鬓鬟鬣麽麾縻麂麇麈麋麒鏖麝麟黛黜黝黠黟黢黩黧黥黪黯'
    '鼢鼬鼯鼹鼷鼽鼾齄'
)

# 汉字字频
cn_char_frequency = (
    '的一是不了在有人这上大来和我个中地为他生要们以到国时就出说会也子学发着对作能可于成用过动主下而年分得家种里多经自现同后产方工行面那小所起去之都然理进体还定实如么'
    '物法你好性民从天化等力本长心把部义样事看业当因高十开些社前又它水其没想意三只重点与使但度由道全制明相两情外间二关活正合者形应头无量表象气文展系代加各很教新向机她'
    '内此老变原结问手日利质已最政儿见并平资比特果什建反常知第电思立提或通解身四品几位别论公给少条观回海基次被山才己期西术济认先命走真员及数话门级军统光声题入美口感战'
    '科程式指世必放打接总做东区农强造类受场五直月流决干则更色处路运任具目再治神求件管组根阶将改导眼规识革计白马金界取市设语完究党女传风信名便保育队带叫研领北较张即至'
    '许步往听调务花争线呢每边难太共交确劳据达住收候需转百南清格影书切且却志热联安极今单商料技深验增记近言整精集空连报觉车价音响办存怎病快图况例消容史非离节亲万八构族'
    '石满何广律青林克王历权素始断九际积吃态艺证众创红望须群师该复细包土持服笑德般远爱准写算火死半布随六元低称引照失养视习段字织斗团器兴乐效显斯千落示仅企似备除支标早'
    '吧周速跟七采状吗约城层专划轻拉值适英告讲维营士环古让院按型势足毛台紧片属严树画厂功注演源温某找参易飞推围列客河虽境食李尔黄黑念越选华角考致夫初装议首委底另江息密'
    '压孩村费局派房星突供曾排苦够像站校富谈米充阳破母球射批配纪未哪妈差刚率察舞依占呀微础益倒刻举血故互范木号尽请脸兵职留铁吸钱急独剧查皮激坐乎固害夜续京双拿府限草项'
    '述曲既春官坚令句助简杂材封护司省县模试绝洋谁继止喜优词陈鱼终施晚朝含仍脑甚汉修油衣击云送巴普征错均投波余友武责游敌叶船久否异块脚怕田策苏乡帝靠医测植啊括换逐娘罗'
    '戏善获待降冲父置左右沉酸亮良班著亚抗啦静渐概居跑旧防买挥负帮欢冷液停减男胜答析忙短烈映财背奇药承岁略穿牛室移饭坏假州缺愿练超雨慢竟呼散灵副歌谓虫读介培卫宗章评伤'
    '丰核预担诉惊刘景乱氧阿龙宣升爷洲判案协福货味若促希握端针屋掌检痛闻妇贵顾沙扩困哥嘴销印免烟跳香纸户板睛误探座盾灯搞祖顺婚赶季兰忽践熟矛银爸临佛犯胞讨陆补童圆归弟'
    '域索罪脱追守课顶松杀掉野训遍庭弱赛额酒绿席露卖钟旁肉央染欧怀稳伯编抓玉咱唯唱翻释控怪阵烧堂杨您诗灭夏敢退姑恶透鲜附骨审胡输宁丝姐彩睡巨迫鼓伙借耳典刺暗镜序哈菜溶'
    '笔汽礼摇迅险遗威沿弹私攻宝抽雪孙藏毒顿末摆趣救镇楼智园康永遇雄替危楚侵枪冰健播途损秀丽秋执束纳虑疑午粮架盛湖尚床份套毫奋扬赵混献择庄殖店皇购缩盐冬齐径偏盖款衡阻'
    '托喊繁纯牙殊浪招符折泽弄奶谢累亦厚朋伸筑闪枝授蛋潮登售孔街败迎肥恩尼幼惯钢肯矿岛伟粉振吴夺尤忘荣亡阴凡毕暴唐勇避麻股硬洞盘轮警闹录绍描寻妹幸壁距玩休延综甲泛哲载'
    '雷窗虚秘俗倾哭禁零触巧圈努喝彻晶丁操奴宜菌叔桥仿默航谷泪予挂壮纷粒燃诸削苗婆付迷馆灰鸡岸寒泥梅残税虎庆抱鸟拍墙缓横尾督莫械尖旅倍措剥遭懂粗奏润侧辩茶鬼梦贯篇妻宽'
    '腿刀桌浓跃蹈洗卷欲袋赏悲劲鲁赞氏汇迹竞醒裂闭森腰磁湿聚兄徐炼订川吹蒙胸召伴徒幅疗淡奖仪珠绪蒋猪剂访狗摸趋宋伏棉恐羊碳隔网猛爬缘麦库津监薄净旋贫罢穷乏挑废汗耗尊牌'
    '抢软隶宇圣港欣塞刑博揭垂姓捕荒诚炮呈辑卡伦蓝抬宫敬版忍颜竹碰启票隐抵脉浮煤剩珍奔堆扎谋貌脏逃洪旗潜鼻忆湾绩恰坦怒震豆插戴涉绘瓦龄池沟呵伍氢拥乘吉尺朱蒸舍贡糊梁漫'
    '腾症丈钻磨井艰键绕幕斤污贝冒阔胆渡碍崇愈岩玻碎宪俄障融贸耐届寄荡币俩卵弃悄偶纵陷坡勤享塑膜铜拖暖稍摩硫哩乌循妙疾肩炎偷赤灾恒孤仁腔杯乃稀恢违伊挺乙拜焦锋铺颗滑敏'
    '洁嘛凝凉杜凭勒爆递鞋迁秦桂璃摄叹峰牧恨糖骂贴紫壤辛仰腐割辈君泡郭呆番励乳亿兼昨刊擦迟拔丹彼搬眉滴朵畜遵逻患奥耕忠鉴挤滚壳厅旦炸塔频弯狂陶晓柳炉宏愤瞧箱扑暂盆瓶柱'
    '辉雅衰洛朗琴腹牲黎肃雾冠伪幻仔杰烦悟荷晨甘饱飘芳肌舒惜丧肚灌抑鸣辞宙邻昌扫赖泉肠鼠援墨啥祥储萨裁奉傅姿埋亩犹瓜咬粘芽吐昆估租碗轨稻纲役勃毁烂昏隆饰曹仙夹爹郑闲柔'
    '吓嫂巩亏帽浅详斜佳饮猫杆恋凤缝疏扶厉喷截扰拨雕码瑞讯莲邦贷丢慌寿毅漂屈涂蜂猎氯劝柴悉狠岗饲祝皆罚躺桃猴宿锅胶偿宾译袭串申捉挖窝踏邓允舌溜驻膀渔纠冻扭臣埃辐闷涨签'
    '秒贺耀辨燕慰颇债肺逼魂匆旺姻吞甜吨搭屏掩涌袁汤岭拟慧郎瘦阅辆填袖匀娃筒豪籍餐轰尘敲帐撞钠牢肿盲腊锐返骗骑扣寺沈醉纹纺泰盟辟丛拒忧魏躲纤肖悬旱晋祭誉谱箭狭饿驱冯脂'
    '斥肤椅栽仗墓舅碱兽锁喂抛苍臂溪胖伐汪刷稿绳剪唤凶邮齿尝漠怨络撤撒筹幽渗蛇诱抚磷逆牵诊惨抖庙株浑驶泼厌怜疲厘叙嫁跨惠哀胃蜜梯诺悠滩笼添陪挨拳晃寂倡催朴郁脊扇仓魔哎'
    '蓄棵胀眠劣秩塘孟媳廷铃胎抹吵肢拾聪寨翠赫尿疼览狼轴锦夸剑牺翼卧曼姆匠熊搜盈覆唇驾腺辅枯鞭翅喘肝掘歪欺疆赋婶畅葡脾哼柜兔顽藻鸭页谐侦仇睁茫拼炭锡弦滋锻脆裤卢萌骤悦'
    '氮葬棒渠诞斑浩盒遥颤扮扯颈玲丑摊桑盗柏唉戒凌羽胁捷皱堡嚷挣淋陵彭茂吊愁巡寸纱惑董勾昂阐纬逢披恼佩妥萄迈坛署姨肾仲邀莱辽阀猜弥瞪韩臭脖掏妨燥酷蚁鸿棚芦漏凯浸舰狱踪'
    '氛摘御蔡扔硝裕氨竭蚕疯坑愉矮嘉掠泄叉渴冶囊辣菊凑歇嘻雇婴泌痕亭跌夕册螺贮淀贪庞铝砖僚涛耶艳玛拆绵遮慎贾贤糟鹿霸匹挡舱咳雀赴蚀咽饥鹰询嘿函堪嗓嫩晴蹲辖豫酬剖钾尸胚'
    '悔雌哦惩漆篮链筋摔遂叠霍垄匪侯巾贞丘滞洒纽蓬浙潘娜矩闯盼叛履霞菲瞬奸砍敦浆儒拓僧棋芬俺慈萧蛮郊勉钉缠盯吾咕膨堵卜扁葛哟寡鄂驰桶晒慕栏霜谊哇畴隙孝押竖喉欠衫吕旬韵'
    '霉邪孕穆硅峡湘澳羞惧慨穴捞辱棍撑炕窄崖俱宅陕爽鹅晰０巢绒疫茎苹捧忌搏奈躯惹焰岂甫艾拦趁缚祸橡碧卑攀饼蔬譬灶赔粪颠曰媒殿蛙衬钩逝哑艇罩裸岳庸嫌窃涵砂梨泊遣熔廉傲傻'
    '畏缴钙铅乔懒萍莉挽凄刮卓档妄劫阁掀哗藤吟杏颂梢罕沸滨翔汁戈愚○秧抒弊姜拘贩框屁喻嘱垫迪契弗瑶赌堤哄旨晕凳址彪踢俊韦贼稚蝶账凹帕携茅枢溃哨枚驳歧抄弓稼颁徽杠泳蜡吻'
    '沾绣叮谨厨拐宴鸦衷戚粹碑煮蕾淑逸翁倘恳逊趟讼衍蔽胳罐裙龟奠颌驴撕蒂姚滥恭耻蕴骄煌冤瞎娇杭倦愧淮柯聊侨萝惟谅瘤蚂崔廊溉铸髓碌拢沫帅坟娱吏峻昼歉刹坝栖捐渊傍叭鸽淘轿'
    '呜宰谦玄丙愣朽跪券寓捏搅笨槽咋厦爪奎榜屠耸驼甩逮殷赚歼孢僵矣锤浴呐兹坎珊苯垦兜禅芝吁酶舆惶咐瓷陌颖帘摧赢裹瞅卸兆咧噢仆膊醇饶嗯篷膝肪寞挫俯桔蚊熙巷眨烛踩缸屯顷鼎'
    '砸乾咸沃衔俘熬喇芒钓侍禽桩灿吼泣讽凸谭敞聘哺癌浦躁卿勘窜溢舟楞虹蛛耍饵烷骚枣浇崩蹦褐嘎俭仑窟陡荫嚼倩钦弧涡潭坊缔廓佐夷眯枕捣蹄猩狐柄穗伞拚浊壶冈搁屑谬拱魁祀荧誓'
    '斋虾绸魄娟姊秃泻鹏蟹斌灼扛镁瓣艘捆膏苇厢妮蒲啸劈滤葱栗袍耽痴颊猿沪怯垒芭蔑絮咯笛嘲爵瞒冀赐酿烫惕逗挪吱淫糕剿拣琼塌渣澄赠媚荐暑鹤绅讶凿烁狮乒薛侮阎嗽朦喃埔蝇锣炒'
    '娶棕韧礁陀肆乖禄骆驯匙萎舶滔卤摹昔陋雁耿裳崭妆勋侣闸贬痰喧膛胧辫烯丫铀甸犁幢窑羡坪缀坤汹柑淹杉棺怖腻薯锈魅炳洽诵咪椎畔玫柿帜桐襟筷帆唔匈嵌梳鳞佣莎熄砌昧噪簧婉毯'
    '孵憾谎坠煞藉嗡绑妖蝴瑰揉苔拌莹昭汰拂嗅钮鄙撰盏烘谣稣竿皖锥烃犬喀-皂蔓蕊疮咒僻炯寇铭薪恍辰祈迭豁斩屡啼椒啡稽烤澡籽洼茨榴唾巫乞焊杖贱咚蜘扒隋晌暮涤茧拴闽叨伽喳腕'
    '斧怔咖啄溯踱沦锄畸脓疙炊擅粤虏豹榨棱簇莺撇绎尉柬涩乓觅茄涯狩憎蔚挚姥袄捡旷镶碘袜丸糙鲸铵倚矢锌褂牡硕憨淌禾尹荆苟聋潇庐煎勿彬醋梭秉嗦掷悼噜茵蓉矫憋翘琢挠吭兑蔗瑟'
    '痒琐酋廖璋槐闺拧彰菱呕瘩筐搂焚迄垮缕谜钥嘟蠢Ｏ蛤馈咨敷缅聂宠禧沼巍榆宛绷俞眶吩筛菩钞诈嗨葫佃酱颓渺揽躬歹焕啪溅栋沛砚霖囚侄妃氓狡瞥沁揣峭樱禹岔暇檐澜涅粥馏嗜笃麟'
    '铲寅剔尧扼赣稠屿胺帖堕亥揪梧麓瀑窍懈淤腮腥绞鹃卒蕉枫脯腑碟莽毙婷磕熏酵薇溴弛挟棘秤睹庚蚓咀绰锰炽枉俏梗祷逛茸葵蜀狄拙鞍婿掺钧蚯圃蛾嚣垃紊酚隘韬鲫笋啃叽鲤惰嘀诬哮'
    '羔毡勺狸娥郡瘫钝湍趾跋靖妒锯畲弘湛咦袱咙圾藩颅弼鲨嗬翩忿刨捂痹灸虐芙鹊簿绢戳徊澈疤棠扳诏沧蹬窥窖疟呱湃淳眷匣烙佑慷轩焉１芸琳恺嘶馒哆崎嫉冥徘辜姬捎绥窘诀龚橙诧诡'
    '峨逾裴椭嗣讳粟轧咏衙虔梵豚邢梆剃吆奢叩拎芹瑛翰邹淆厥缭髦斡羌磅郝芯卉诫驮骼蜕崽墩迦屎陨桦敛倪讥鳃氟祠晤趴瑚苛寥惭宵靶倌砾厕钳肘眺甭呗鲍盔镰拽酝怡菇搓醛涕噬蒜囱愕'
    '孚壕鸥唠濒渤撮拇琅呻撩桨佟皿嘘襄胰鞠泓蝗橱蝠伶倔酌黯秸圳绚庇窦酯睦屉窒兀樊庶妓戎岱滇侗簸迸赎沥眩雏凛旭苑撼懊庵骇骡５汝喽栅挎徙邱冉蠕瘾峪蜻茬篡绊亢猖嚎荔廿癞萤秽'
    '鳄呛汞瞄攘挛兢啤陇汲漉寝募贻黔遏邯酥蝙阜婪氦狈嗒缎刁瞻篱煽墟橘惋舵埠尴尬岚肋褶潺谕亨蜓苷裔贿悍蓦逞於迂谛邵陛嬉刃砧粱苞啰猾揩斟坷酮芜赦纶馋沐黝擒捅钛泵哉涝琶蝉缆'
    '傣缤孜彦烹怅砰雍虞嘈栓胱锭痉卦磺楠辙瓢漾钊蟆匿札霎瞩蘑跺疡螂溺疹缫臀捍皓璧汛惫嫦瑁瘪玳２膳骏伺峦疚浒睬呃肴惘搀涧糠澎囤祺涎拯殉蜒怠牟曳靳凰蔼捶踌鳍佤鬓娴窿戊躇瘀'
    '厄惚悯拭剌鲢峙哒沌抡槌彝驭晦秆钡丞瞳馨靡吠邑殴阮簌寰踞塾奕镀３攫侃琵褪漓檀哧茹褥酰毋桓栈靴删碉墅螨嗳驹碾眸乍撵雹黛炫捻沽啧痪赘唬４宦憧蜗惦噗舷悖恕渍谴腋曙忱肇荀'
    '郸拗翌睫鳖辗蚌斐幔酣隧厮锹耦蝎朔苓狞蕃邃蜿饷垛伎迢栩谍鑫瞟詹椰戌掖禀孽鞘渲篓袅垣偎唰抿揍岖矗萃竺瀚芋盎跄粕绽踉俨瘟—缦菠缉蟀晾遐岑裘汀肛搔嚓藓糯咆瓮娄攥恬岐坯莓'
    '蘸瑙搪柚蹭犀炔珑唧蟋龈屹噶懦犊臻喔珞臆鹦倏捺葆懵嗖偕衅笠侈坍腆翡叼颐楷擂舔憬筏垢肮帚曝镍骥侠嗤喏凋舜崛沮壑箔臼竣殆掐穹鹉箫鸠芥燎榻蕨夭诣惺霄磊炙蹑楂琦僮祁鞑榕荪'
    '婢踊吝矜娅祟娣跛蛹笙赃妊锢韫荤羁捋攒瞿饺腼奚帷蟾蛀抨婕哝糜杈馍粼悻槛漩兮赁炬蜷铬擎鼾髻樟蛎伢仕佧焘槟跤缰悸佼姗曦隍隅诙镑猕恃妩匾蜥迥娓锚淞琪胥痢癖芍渝骋螳阑梓螃'
    '娠瘠辘箕忏搐妾汐篆撂哽甥咄豌铮拄粽纫渭褒耙翕沓汕掰甄睿嵩憔巅驿箩悴膈忖忡霓瞌镐琉瑾钴桅萼媛吮篙篝锵踵祛奄丐臧耷浏毗磋擞纂叱淙彗钨蹙谚熵遁滕枷敝虱涮馅冗蟒盹嗔惴萦'
    '藕埂赡鳗薰嚏摒彤蘖跷腭泾钵窠伫谟蚪诅玺缨儡蝌祯蛐亘冕暨怦佯跚匡坳８诃晖楣蹂泯觑邬掸娩７锗憩匍仨傀耘镭讪殃匐啕筱颚漱瞭畦獗唏犷熠咂侥桉勐黍盅蹒幌寐囿慑筝闰貂蔷谏癫'
    '佬（噎唆袒麸蚜圩酞昵羹咿俐蹿梏潼扈咛恤蔺谤聆惬撅榄沣蜴蔫橄瞰瑜痞绛鸳唷柠撬痘掂椿镖匕嫡腌岷匝噙矾躏覃惆漪浜檬皑镊楔噘６嗐厩肽蒿羟桎睑褚赂蚴冢徨抠硼鸯粑缪垠掣掇蹋'
    '铿赳蛔铐镯涸蹼翎萘咔煦囔螅匮膺痊茁颞矶晔辄沏卅枇铂龛杷炖韶谧麂韭阈僰堰n诽醚皎圭妞揿蛟樵绮忐帛怏阂桢茉锨臌瘴舀睾鞅岌斓彷铣绯刽臃嶙俾闵螟坞酉俟啷骸嫔逍瘸倭朕掳蓟'
    '拈霹怆笆礴脐蚤狰猝逵褴飒牦忑爨邸溥沂咎渎蓿栉鬃涟锂疱俚汾嘹勰亟惮螯抉濡蹴釉淅噼啮挝讹腧馄淼臊v刍雳啬烽戟鳌苜啶喋烬谙榈堑冽缮蚱裨晏恽燧蝈荚颧轲沱毓蜚戛绫嚅翟潦戍'
    '偌饨蜍媲坂俑嗥殡娼泞漳珀懑菁噩胭铎敖濛悚纭褛滦蹊榷鹭舢敕孰蚶颏粳亵啜硒幡弩翱阱镂夔腱扉涣嗫寮竑桧毽.馁羧箍摞碴黠呓镣拷砷扦谔膘呷胫拮孑冼讷嘁篾踽铆卯笺瑕垅羚疽唢'
    '氖髭?谒裱辕泗诛遽獭麝跻诘犟燮砣诲貅裆噤赈踮髯霭榔皙谆９熹喙酗潢铨甬揖幺饽荃盂弋懋绦瘁茭阖讴恙镢掬峋暄藐沅）濮隽鸾壅侏孺疸恣缥喟睐皋狍戮琥迨噔氰瞠鳙凇嫣迩蛄谑轼'
    '泸骁澍仄眈遨萱籁雉昙缄婀舐柞锺恪蟑蛰洄恿浃犄簪赓锑桠貔偻舂呶阡釜痿醮鳅阉疝嘧挞腚痨逦胛湮嗷钽怂汩衢蜇疣滓趄熨癣禺摈汊霆霏蜢谘氩昕辍侬诋崴荠蹩荟轶豢窸蛊丕搽腈蜃坩'
    '阙涓嗵羲筵骈呸轱稞砝訇嶂痈埚蛆雯垭牍徭怵荞迤脍趔涪荼孛踹嵘俸赭滁潴徕泮剽殓钗霰阪杞枸牒懿镌铛绉芩疵孪鲑扪窣埝飕瓠壬婊铡饯猬诂祗湄濂瀛茜睽锉娑撷髅旯锷椽斫琛卞蹉璀'
    '邝裟袈垓珧铠钎铯囡橹啻蓑恻芷剁旮霾阗悒媾桕蹶奘仃嗝梿氅腴佝迳擀町莼磬绺哐宕孀柘咫鄱诿蜈弭垩恸筲姣踝蚣睨旌谲饬a鸨陲洵璜氘杳浚锟牯痂戾麒镉绀痣忪黏囵颦赊蟠癸劾胯鲟'
    '赕夥踅袤佚抻疥涔罹囫黜辊碓龋虻璞谩蹓孬訢愠馥膑砥洱菖咣栎鲮绾嗟缈骷d崮稷邕邛猷咩莠秫揄纨砻帧鹄揶漕颉嬗酪镓胄蝼顼蓓豺奁钋鏖徇窕噌钍闩榭忒塍栾巯绌疖嘭洮甙瓤鸪鹧昶'
    '飓锲盥窈靼颛浔荥呤臾颔煜鞣咤舨猥喁唑蠡搡煅淄摺兖峥呲啾掮榛硷钼荸颀磐鹑诩柩黢俪饪姘艄苕箸攸佘挲矽瓒孳，璐翦杵桀茏谵妍檄暹镕纣鲷忻醺婺潍潞吡碣郗骰鳊岫笸汴忸珲蕙怩'
    '鹞槃墒咝崑濯×褓襁峒濠腓脒耆谄馊咻鳔凫柽犸爿巳驸俵邈羿熜恫椴蠖铤澹捱唿鱇鮟嫖龊啐莞钒汶嚯偃娲煊蔻渚遛赅蛴螬茯帼鎯仞剜炷煨棣迺湟、籼畿稗鲲笞爰碲蹚舫聒龌茗葳藜哔棂'
    '忾钰埕沤桡蓖飚沔焙莘缙鹂垧癯皈锃唁栀璨q玷畈烩靛斛轭戕祐衩徜涞绔璎钚砭碛獾嗄夙闿箧铰氚嵋骊圪啉淇讣犍闾旃彧嘌糍摁橼噫鸵骧泅伧铱皴榘谡佗胤鹌佻潸鲈砺耒韪孱璠倜Ｋ葺'
    '螫飙罄帏崂铧喑嘣慵趸酐焖胝鳝肓鸶撸鲻炘镞赧謇弈嘤媵鹘鹬霁跶绶蛉鼹幂贰祜衽唦罂蓼苋徉羯胴氤霑炀晁芪骅屙箓氲逅邂觐蛳缜茴陂蜊钿鬻剐诌妁壹砒钏搧吋菟芗暧黧呣晗骠浣痫弁'
    '哞淖衮璟邳昊渥褡趿钹莴鲀蹰崃娌妯龇銮钤脲鲵肄窨痱贲─胼鲂p铌菽谗坌祇鱿葩镟幄蒴罅珙嵇酊貉谶陉淬惇卟猞邺滹翳瘙疔阚髁蓊莅傩谀蔸夯癔馀犒氙馔缢辎讧挈嗪簖嵴珂滂铷孓穑'
    '崙鳏镳殇瞑瘘琨靥圹瞽畚湫艮鹜奂姹讦屌繇屐钺噻蝮诰笤刈坨恁甾喹堞猁襞巉恹瘿茔楹蚨嵬璘篼蒺蠓噱鄯脘鱆袂聿篌泔鹫觊笈箜轳瘢仂纡胪螽叁樽菡诠袢飨苻槁蘩踟豕涿苣跖藁蠹栊歆'
    '橛獠呋侩踯逡罔聩珩糅廪佥谰檩嵊谥玮炅蹁铄驷郢岙鄠阏鹳裾綦珏苫雰饕玑魆镬罘畹镠髋肱碜莆鄞旖弑悌蒽塬鸢竽箴嗉鸷痼怄馑伛稃鬣洹龉蛭觎旎锶齁鼬畑揆鲣搦龃诨筠虢噹僳獐撺苡'
    '郓铋铍躅u锴芮薮俎钫忤纾柢琰疠逋祚掼僖枭郯昴氡鹕逶圜儆悱邋啁虬榉秕粜氪髡鹈琮芾篑缬毖舛蚰嗲胍裢哚囹擤咹圄橇跎倨莨鳕飑楫欹蠼箨腠螋澥沆羰赝锆枳媪幛哓砦鲴郧棹麋偈禳'
    '圮愎缂錾诳r鲶鸹慓荏欤洫髀蹀鳟衾磙椁岬琊戆傈僭瓯呔诤瀣吔缛槭亳暘"碚曜唳襦骛甑鲇廛吲龢刎愫岢杲遒狙酩屣捭帙餮跗褙篦呎c棰阕阆笳溧睇黩魇荨歙矍鲛劭镧潋。楝泱伉倮逖'
    't滝滟縻骶螈蝾阇滢璇痔诮娆鳜帔麇擢锏闳萋钜啭缣讫汨樨楸矬呯岿遢侪叵糁钯宸桷柈啖铙粲衄狎睥傥铢佉菘瑷疬瘰篁厝羸鬟牾郴珈艿珐碇茌鱀溟鏊犴铓骜囝怿妪颎乜耧蠲嗑慄圻辔殒'
    '瘃埙褫啵怛榧箪醴戗佞蛱鲳骞眦溏穰茕邠阒磡牖诟虿糌麯磴庖徵拊苄铳剋笱畛稔琤偬癜翮惝玕贽酽鸱醍焱茀颟唻膻畀呦辏锛蚬蟥叟劻嘞跏妣捯鯵瓴塄圊遴嫲溲垆辇菏睢狺藿搠狯觋荻铟'
    '迴鹮瘕秣盱珪牝檗袴痍遑垸蒌柁徂佰巽醪薨稹奭衲瑗灨蚧炜焯猗腘赉砬殁峁庑馗鄄蜱儁筌箐秭B汜勣sm菪莒餍粿羼姪诜薅葶鹗愆喱嘚濑狒趺芨勅苎嫱鼋氽俳玢h樯赜誊湎谌鲕F鬲牤'
    '筚柝痧墀w衖疋毂髂蕲j煲轫貘颢鴞鸻甗岘槎麾赀蘅猡捽朊墁暝瘌芟箝眊谪帑眬拤燔夼鳓苈旰匚玭伕骺颍缟爻鹚醐砜鼙廨哙岣嵝珥迓锕矇猢顸堃澧湧娭毑砀躞诒莜峤荇戡袷瘆沚湲邙醣'
    '埭钁囟蕈尅箬掴徬砉咴罡耪鄜塆豨硌嬴杌峄倥咭醌玙庒焓苒哌茑'
)
# 字频高于 x% 的汉字所在位置
cn_char_frequency_prob_pos = {}
cn_char_frequency_prob_pos[0.01] = 1250
cn_char_frequency_prob_pos[0.02] = 843
cn_char_frequency_prob_pos[0.03] = 652
cn_char_frequency_prob_pos[0.04] = 526
cn_char_frequency_prob_pos[0.05] = 440
cn_char_frequency_prob_pos[0.1] = 213
cn_char_frequency_prob_pos[0.2] = 95
cn_char_frequency_prob_pos[0.3] = 48
cn_char_frequency_prob_pos[0.4] = 27
cn_char_frequency_prob_pos[0.5] = 18
cn_char_frequency_prob_pos[0.6] = 10
cn_char_frequency_prob_pos[1] = 4

# 标点符号
# import zhon.hanzi
# cn_punc_list = zhon.hanzi.punctuation + r'￥%丨'
cn_punc_list = r'＂＃＄％＆＇（）＊＋，－／：；＜＝＞＠［＼］＾＿｀｛｜｝～｟｠｢｣､　、〃〈〉《》「」『』【】〔〕〖〗〘〙〚〛〜〝〞〟〰〾〿–—‘’‛“”„‟…‧﹏﹑﹔·！？｡。' + r'￥%丨'
en_punc_list = string.punctuation
punc_list = cn_punc_list + en_punc_list

# 括号
brackets = r'（）［］｛｝《》【】〖〗〈〉「」『』()[]{}<>'
# 引号
quotations = '\'"“”‘’'
# 冒号
colons = r'：:'
# 提示符号
alert_puncs = brackets + quotations + colons

# 分隔符扩展（可用作分隔符的特殊字符）
SEPARATOR_EXTEND = '一'  # '乀丶'


def is_chinese(uchar, extend=False, compat=False):
    """判断一个unicode字符是否是汉字"""
    if uchar >= u'\u4E00' and uchar <= u'\u9FBB':
        # CJK统一汉字 开始:4E00 结束:9FBB 字符数:20924
        return True
    if extend:
        if uchar >= u'\u3400' and uchar <= u'\u4DB5':
            # CJK统一汉字扩充A 开始:3400 结束:4DB5 字符数:6582
            return True
        if uchar >= u'\U00020000' and uchar <= u'\U0002A6D6':
            # CJK统一汉字扩充B 开始:20000 结束:2A6D6 字符数:42711
            return True
    if compat:
        if uchar >= u'\uF900' and uchar <= u'\uFA2D':
            # CJK兼容汉字 开始:F900 结束:FA2D 字符数:302
            return True
        if uchar >= u'\uFA30' and uchar <= u'\uFA6A':
            # CJK兼容汉字 开始:FA30 结束:FA6A 字符数:59
            return True
        if uchar >= u'\uFA70' and uchar <= u'\uFAD9':
            # CJK兼容汉字 开始:FA70 结束:FAD9 字符数:106
            return True
        if uchar >= u'\U0002F800' and uchar <= u'\U0002FA1D':
            # CJK兼容汉字 开始:2F800 结束:2FA1D 字符数:542
            return True
    return False


def is_number(uchar):
    """判断一个unicode字符是否是数字"""
    if uchar >= u'\u0030' and uchar <= u'\u0039':
        return True
    return False


def is_alphabet(uchar):
    """判断一个unicode字符是否是英文字母"""
    if uchar >= u'\u0041' and uchar <= u'\u005a':
        return True
    if uchar >= u'\u0061' and uchar <= u'\u007a':
        return True
    return False


def is_punctuation(uchar):
    """判断一个unicode字符是否为标点符号"""
    return uchar in punc_list


def is_ch_or_en(uchar):
    """判断一个unicode字符是否汉字或英文字符"""
    return is_chinese(uchar) or is_alphabet(uchar)


def is_ch_or_en_or_num(uchar):
    """判断一个unicode字符是否汉字、数字或英文字符"""
    return is_chinese(uchar) or is_alphabet(uchar) or is_number(uchar)


def is_other(uchar):
    """判断一个unicode字符是否非汉字，数字和英文字符"""
    return not is_ch_or_en_or_num(uchar)


def is_separator(uchar):
    """
    判断一个unicode字符是否为分隔符
    包含所有非中文、英文、数字字符 + 扩展字符
    排除emoji
    """
    return (is_other(uchar) or (uchar in SEPARATOR_EXTEND if global_data.develop_flag[6] else False)) and not emoji_info.is_emoji(uchar)


def get_cn_char_frequency_above(frequency):
    """
    获取字频高于 x% 的汉字
    """
    if frequency not in cn_char_frequency_prob_pos:
        raise Exception('no chinese char frequency data, frequency[%f]' % frequency)
    pos = cn_char_frequency_prob_pos[frequency]
    return cn_char_frequency[:pos]
