#include "iarduino_I2C_Joystick.h"																								//
																																//
//		Инициализация модуля:																									//	Возвращаемое значение: результат инициализации.
bool	iarduino_I2C_Joystick::begin			(void){																			//	Параметр: отсутствует
		//	Инициируем работу с шиной I2C:																						//
			objI2C->begin(100);																									//	Инициируем передачу данных по шине I2C на скорости 100 кГц.
		//	Если адрес не указан, то ищим модуль на шине I2C:																	//
			if(valAddrTemp==0){																									//
				for(int i=1; i<127; i++){																						//	Проходим по всем адресам на шине I2C
					if( objI2C->checkAddress(i)											){	valAddr=i; delay(2);				//	Если на шине I2C есть устройство с адресом i, то используем этот адрес для проверки найденного модуля...
					if(_readBytes(REG_MODEL,4)											){										//	Читаем 4 байта начиная с регистра «REG_MODEL» в массив «data».
					if( data[0]     == DEF_MODEL_JOY									){										//	Если у модуля с адресом i в регистре «MODEL»   (data[0]) хранится значение DEF_MODEL_JOY, то ...
					if((data[2]>>1) == i                 || data[2] == 0xFF				){										//	Если у модуля с адресом i в регистре «ADDRESS» (data[2]) хранится значение i (адрес+младший бит) или 0xFF (адрес не задавался), то ...
					if( data[3]     == DEF_CHIP_ID_FLASH || data[3] == DEF_CHIP_ID_METRO){										//	Если у модуля с адресом i в регистре «CHIP_ID» (data[3]) хранится значение DEF_CHIP_ID_FLASH (идентификатор модулей Flash), или DEF_CHIP_ID_METRO (идентификатор модулей Metro), то ...
						valAddrTemp=i; i=128;																					//	Считаем что модуль обнаружен, сохраняем значение i как найденный адрес и выходим из цикла.
					}}}}}																										//
				}																												//
			}																													//
		//	Если модуль не найден, то возвращаем ошибку инициализации:															//
			if( valAddrTemp == 0														){	valAddr=0; return false;}			//
		//	Проверяем наличие модуля на шине I2C:																				//
			if( objI2C->checkAddress(valAddrTemp) == false								){	valAddr=0; return false;}			//	Если на шине I2C нет устройств с адресом valAddrTemp, то возвращаем ошибку инициализации
			valAddr=valAddrTemp;																								//	Сохраняем адрес модуля на шине I2C.
		//	Проверяем значения регистров модуля:																				//
			if(_readBytes(REG_MODEL,4)==false											){	valAddr=0; return false;}			//	Если не удалось прочитать 4 байта в массив «data» из модуля начиная с регистра «REG_MODEL», то возвращаем ошибку инициализации.
			if( data[0]     != DEF_MODEL_JOY											){	valAddr=0; return false;}			//	Если значение  регистра «MODEL»   (data[0]) не совпадает со значением DEF_MODEL_JOY, то возвращаем ошибку инициализации.
			if((data[2]>>1) != valAddrTemp       && data[2] !=0xFF						){	valAddr=0; return false;}			//	Если значение  регистра «ADDRESS» (data[2]) не совпадает с адресом модуля и не совпадает со значением 0xFF, то возвращаем ошибку инициализации.
			if( data[3]     != DEF_CHIP_ID_FLASH && data[3] != DEF_CHIP_ID_METRO		){	valAddr=0; return false;}			//	Если значение  регистра «CHIP_ID» (data[3]) не совпадает со значением DEF_CHIP_ID_FLASH и DEF_CHIP_ID_METRO, то возвращаем ошибку инициализации.
			valVers=data[1];																									//	Сохраняем байт регистра «VERSION» (data[1]) в переменую «valVers».
		//	Перезагружаем модуль устанавливая его регистры в значение по умолчанию:												//
			reset();																											//	Выполняем программную перезагрузку.
			delay(5);																											//
			return true;																										//	Возвращаем флаг успешной инициализаии.
}																																//
																																//
//		Перезагрузка модуля:																									//	Возвращаемое значение:	результат перезагрузки.
bool	iarduino_I2C_Joystick::reset			(void){																			//	Параметр:				отсутствует.
			if(valAddr){																										//	Если модуль был инициализирован, то ...
			//	Устанавливаем бит перезагрузки:																					//
				if(_readBytes(REG_BITS_0,1)==false){return false;}																//	Читаем 1 байт регистра «BITS_0» в массив «data».
				data[0] |= 0b10000000;																							//	Устанавливаем бит «SET_RESET»
				if(_writeBytes(REG_BITS_0,1)==false){return false;}																//	Записываем 1 байт в регистр «BITS_0» из массива «data».
			//	Ждём установки флага завершения перезагрузки:																	//
				do{ if(_readBytes(REG_FLAGS_0,1)==false){return false;} }														//	Читаем 1 байт регистра «REG_FLAGS_0» в массив «data».
				while( (data[0]&0b10000000) == 0);																				//	Повторяем чтение пока не установится флаг «FLG_RESET».
				return true;																									//
			}else{																												//	Иначе, если джойстик не инициализирован, то ...
				return false;																									//	Возвращаем ошибку
			}																													//
}																																//
																																//
//		Смена адреса модуля:																									//	Возвращаемое значение:	резульат смены адреса.
bool	iarduino_I2C_Joystick::changeAddress	(uint8_t newAddr){																//	Параметр:				newAddr - новый адрес модуля (0x07 < адрес < 0x7F).
			if(valAddr){																										//	Если модуль был инициализирован, то ...
			//	Проверяем новый адрес:																							//
				if(newAddr>0x7F){newAddr>>=1;}																					//	Корректируем адрес, если он указан с учётом бита RW.
				if(newAddr==0x00 || newAddr==0x7F){return false;}																//	Запрещаем устанавливать адрес 0x00 и 0x7F.
			//	Записываем новый адрес:																							//
				if(_readBytes(REG_BITS_0,1)==false){return false;}																//	Читаем 1 байт регистра «BITS_0» в массив «data».
				data[0] |= 0b00000010;																							//	Устанавливаем бит «SAVE_ADR_EN»
				if(_writeBytes(REG_BITS_0,1)==false){return false;}																//	Записываем 1 байт в регистр «BITS_0» из массива «data».
				data[0] = (newAddr<<1)|0x01;																					//	Готовим новый адрес к записи в модуль, установив бит «SAVE_FLASH».
				if(_writeBytes(REG_ADDRESS,1)==false){return false;}															//	Записываем 1 байт в регистр «ADDRESS» из массива «data».
				delay(200);																										//	Даём более чем достаточное время для применения модулем нового адреса.
			//	Проверяем наличие модуля с новым адресом на шине I2C:															//
				if(objI2C->checkAddress(newAddr)==false){return false;}															//	Если на шине I2C нет модуля с адресом newAddr, то возвращаем ошибку.
				valAddr     = newAddr;																							//	Сохраняем новый адрес как текущий.
				valAddrTemp = newAddr;																							//	Сохраняем новый адрес как указанный.
				return true;																									//	Возвращаем флаг успеха.
			}else{																												//	Иначе, если джойстик не инициализирован, то ...
				return false;																									//	Возвращаем ошибку
			}																													//
}																																//
																																//
//		Получение флага наличия подтяжки линий шины I2C:																		//	Возвращаемое значение:	флаг наличия подтяжки линий шины I2C.
bool	iarduino_I2C_Joystick::getPullI2C		(void){																			//	Параметр:				отсутствует.
			if(valAddr){																										//	Если модуль был инициализирован, то ...
			//	Считываем первые два регистра: регистр флагов и регистр битов:													//
				if(_readBytes(REG_FLAGS_0,2)==false ){ return false; }															//	Читаем 2 байта начиная с регистра «REG_FLAGS_0» в массив «data».
			//	Проверяем поддерживает ли модуль управление подтяжкой линий шины I2C:											//
				if( (data[0] & 0b00000100) == false ){ return false; }															//	Если флаг «FLG_I2C_UP» регистра «REG_FLAGS_0» сброшен, значит модуль не поддерживает управление подтяжкой линий шины I2C.
			//	Проверяем установлена ли подтяжка линий шины I2C:																//
				if( (data[1] & 0b00000100) == false ){ return false; }															//	Если бит  «SET_I2C_UP» регистра «REG_BITS_0»  сброшен, значит подтяжка линий шины I2C не установлена.
				return true;																									//	Возвращаем флаг успеха.
			}else{																												//	Иначе, если модуль не инициализирован, то ...
				return false;																									//	Возвращаем ошибку.
			}																													//
}																																//
																																//
//		Установка подтяжки линий шины I2C:																						//	Возвращаемое значение:	результат установки подтяжки линий шины I2C.
bool	iarduino_I2C_Joystick::setPullI2C		(bool f){																		//	Параметр:				флаг подтяжки линий шины I2C.
			if(valAddr){																										//	Если модуль был инициализирован, то ...
			//	Считываем первые два регистра: регистр флагов и регистр битов:													//
				if(_readBytes(REG_FLAGS_0,2)==false ){ return false; }															//	Читаем 2 байта начиная с регистра «REG_FLAGS_0» в массив «data».
			//	Проверяем поддерживает ли модуль управление подтяжкой линий шины I2C:											//
				if( (data[0] & 0b00000100) == false ){ return false; }															//	Если флаг «FLG_I2C_UP» регистра «REG_FLAGS_0» сброшен, значит модуль не поддерживает управление подтяжкой линий шины I2C.
			//	Устанавливаем или сбрасываем бит включения подтяжки линий шины I2C:												//
				if(f){ data[0] = (data[1] |  0b00000100); }																		//	Если флаг «f» установлен, то копируем значение из 1 в 0 элемент массива «data» установив бит «SET_I2C_UP».
				else { data[0] = (data[1] & ~0b00000100); }																		//	Если флаг «f» сброшен   , то копируем значение из 1 в 0 элемент массива «data» сбросив   бит «SET_I2C_UP».
			//	Сохраняем получившееся значение в регистр «REG_BITS_0»:															//
				if(_writeBytes(REG_BITS_0,1)==false ){ return false; }															//	Записываем 1 байт в регистр «REG_BITS_0» из массива «data».
				return true;																									//	Возвращаем флаг успеха.
			}else{																												//	Иначе, если модуль не инициализирован, то ...
				return false;																									//	Возвращаем ошибку
			}																													//
}																																//
																																//
//		Получение времени удержания, состояния и события кнопки джойстика:														//	Возвращаемое значение:	время удержания, состояние или событие.
uint16_t iarduino_I2C_Joystick::getButton		(uint8_t type){																	//	Параметр:				type - тип получаемого состояния или собития.
			uint16_t f=0;																										//
			if(valAddr){																										//	Если модуль был инициализирован, то ...
			//	Дублируем состояние битов регистра «REG_JOY_KEY» в переменную «val_REG_JOY_KEY»:								//
				if( _readBytes(REG_JOY_KEY,2) ){																				//	Читаем 2 байта из регистров «REG_JOY_KEY» и «REG_JOY_KEY_TIM» в массив «data».
					val_REG_JOY_KEY	|= ( data[0] & JOY_KEY_PUSHED   );															//	Устанавливаем флаг события   кнопки - «нажимается».						Если бит JOY_KEY_PUSHED   в переменной val_REG_JOY_KEY был установлен, то он и останется установленным!
					val_REG_JOY_KEY	|= ( data[0] & JOY_KEY_RELEASED );															//	Устанавливаем флаг события   кнопки - «отпускается».					Если бит JOY_KEY_RELEASED в переменной val_REG_JOY_KEY был установлен, то он и останется установленным!
					if(data[0]&JOY_KEY_PRESSED){val_REG_JOY_KEY|=JOY_KEY_PRESSED;}else{val_REG_JOY_KEY&=~JOY_KEY_PRESSED;}		//	Определяем    флаг состояния кнопки - «нажата».
					if(data[0]&JOY_KEY_TRIGGER){val_REG_JOY_KEY|=JOY_KEY_TRIGGER;}else{val_REG_JOY_KEY&=~JOY_KEY_TRIGGER;}		//	Определяем    флаг состояния кнопки - «переключатель»					Меняет состояние с каждым новым нажатием.
					if(data[0]&JOY_KEY_HOLD_05){val_REG_JOY_KEY|=JOY_KEY_HOLD_05;}else{val_REG_JOY_KEY&=~JOY_KEY_HOLD_05;}		//	Определяем    флаг состояния кнопки - «удерживается» дольше 0,5 сек.
					if(data[0]&JOY_KEY_HOLD_10){val_REG_JOY_KEY|=JOY_KEY_HOLD_10;}else{val_REG_JOY_KEY&=~JOY_KEY_HOLD_10;}		//	Определяем    флаг состояния кнопки - «удерживается» дольше 1,0 сек.
					if(data[0]&JOY_KEY_HOLD_20){val_REG_JOY_KEY|=JOY_KEY_HOLD_20;}else{val_REG_JOY_KEY&=~JOY_KEY_HOLD_20;}		//	Определяем    флаг состояния кнопки - «удерживается» дольше 2,0 сек.
					val_REG_JOY_KEY	|= ( data[0] & JOY_KEY_CHANGED );															//	Устанавливаем флаг события   кнопки - «состояние изменилось».			Если бит JOY_KEY_CHANGED  в переменной val_REG_JOY_KEY был установлен, то он и останется установленным!
				}																												//
			//	Определяем возвращаемое значение:																				//
				switch(type){																									//
					case KEY_PUSHED		:	f=(val_REG_JOY_KEY & JOY_KEY_PUSHED  );	val_REG_JOY_KEY&=~JOY_KEY_PUSHED;	break;	//	Возвращаемым значением является флаг  события   кнопки - «нажимается».
					case KEY_RELEASED	:	f=(val_REG_JOY_KEY & JOY_KEY_RELEASED);	val_REG_JOY_KEY&=~JOY_KEY_RELEASED;	break;	//	Возвращаемым значением является флаг  события   кнопки - «отпускается».
					case KEY_PRESSED	:	f=(val_REG_JOY_KEY & JOY_KEY_PRESSED );										break;	//	Возвращаемым значением является флаг  состояния кнопки - «нажата».
					case KEY_TRIGGER	:	f=(val_REG_JOY_KEY & JOY_KEY_TRIGGER );										break;	//	Возвращаемым значением является флаг  триггера  кнопки - «переключатель».
					case KEY_HOLD_05	:	f=(val_REG_JOY_KEY & JOY_KEY_HOLD_05 );										break;	//	Возвращаемым значением является флаг  состояния кнопки - «удерживается» дольше 0,5 сек.
					case KEY_HOLD_10	:	f=(val_REG_JOY_KEY & JOY_KEY_HOLD_10 );										break;	//	Возвращаемым значением является флаг  состояния кнопки - «удерживается» дольше 1,0 сек.
					case KEY_HOLD_20	:	f=(val_REG_JOY_KEY & JOY_KEY_HOLD_20 );										break;	//	Возвращаемым значением является флаг  состояния кнопки - «удерживается» дольше 2,0 сек.
					case KEY_CHANGED	:	f=(val_REG_JOY_KEY & JOY_KEY_CHANGED );	val_REG_JOY_KEY&=~JOY_KEY_CHANGED;	break;	//	Возвращаемым значением является флаг  события   кнопки - «состояние изменилось».
					case KEY_TIME_PRESSED :	f=(val_REG_JOY_KEY & JOY_KEY_PRESSED )? (uint16_t)data[1]*100:0;			break;	//	Возвращаемым значением является время удержания кнопки в миллисекундах.
				}																												//
			//	Устранение повторных срабатываний флагов:																		//
				if((type == KEY_PUSHED)|(type == KEY_RELEASED)|(type == KEY_CHANGED)){delay(1);}								//	Флагам JOY_KEY_PUSHED, JOY_KEY_RELEASED и JOY_KEY_CHANGED может потребоваться время для сброса в регистре REG_JOY_KEY.
			}																													//
		//	Возвращаем результат:																								//
			return f;																											//
}																																//
																																//
//		Получение координаты джойстика по оси X:																				//	Возвращаемое значение:	координата джойстика по оси X от -100 (лево) до +100 (право).
int		iarduino_I2C_Joystick::getPosition_X	(void){																			//	Параметр:				отсутствует.
			int8_t f=0; if( valAddr ){ if( _readBytes(REG_JOY_AXIS_X,1) ){ f=(int8_t)data[0]; }} return (int)f;					//	Читаем 1 байт из регистра «REG_JOY_AXIS_X» в массив «data», а при успешном чтении сохраняем полученный байт в переменную f и возвращаем его.
}																																//
																																//
//		Получение координаты джойстика по оси Y:																				//	Возвращаемое значение:	координата джойстика по оси Y от -100 (низ) до +100 (верх).
int		iarduino_I2C_Joystick::getPosition_Y	(void){																			//	Параметр:				отсутствует.
			int8_t f=0; if( valAddr ){ if( _readBytes(REG_JOY_AXIS_Y,1) ){ f=(int8_t)data[0]; }} return (int)f;					//	Читаем 1 байт из регистра «REG_JOY_AXIS_Y» в массив «data», а при успешном чтении сохраняем полученный байт в переменную f и возвращаем его.
}																																//
																																//
//		Получение координат джойстика по осям X и Y:																			//	Возвращаемое значение:	отсутствует.
bool	iarduino_I2C_Joystick::_getPosition_XY	(int8_t &x, int8_t &y){ x=0; y=0;												//	Параметры:				&x, &y - ссылки на переменные в которые требуется записать координаты по осям X и Y.
			if(valAddr){																										//	Если модуль был инициализирован, то ...
				if( _readBytes(REG_JOY_AXIS_X,2)==false ){return false;}														//	Читаем 2 байта из регистров «REG_JOY_AXIS_X» и «REG_JOY_AXIS_Y» в массив «data»
				x=(int8_t)data[0];																								//	Сохраняем координату оси X по ссылке x.
				y=(int8_t)data[1];																								//	Сохраняем координату оси Y по ссылке y.
			//	Возвращаем результат:																							//
				return true;																									//
			}	return false;																									//
}																																//
																																//
//		Получение значения АЦП снятого с потенциометра установленного по оси X джойстика:										//	Возвращаемое значение:	значение АЦП от 0 (лево) до 4095 (право).
int		iarduino_I2C_Joystick::getADC_X			(void){																			//	Параметр:				отсутствует.
			int f=0; if( valAddr ){ if( _readBytes(REG_JOY_X_ADC_L,2) ){ f=((int)data[1]<<8)|(int)data[0]; }} return f;			//	Читаем 2 байта из регистров «REG_JOY_X_ADC_L» и «REG_JOY_X_ADC_H» в массив «data», а при успешном чтении сохраняем полученные данные в переменную f и возвращаем её.
}																																//
																																//
//		Получение значения АЦП снятого с потенциометра установленного по оси Y джойстика:										//	Возвращаемое значение:	значение АЦП от 0 (низ) до 4095 (верх).
int		iarduino_I2C_Joystick::getADC_Y			(void){																			//	Параметр:				отсутствует.
			int f=0; if( valAddr ){ if( _readBytes(REG_JOY_Y_ADC_L,2) ){ f=((int)data[1]<<8)|(int)data[0]; }} return f;			//	Читаем 2 байта из регистров «REG_JOY_Y_ADC_L» и «REG_JOY_Y_ADC_H» в массив «data», а при успешном чтении сохраняем полученные данные в переменную f и возвращаем её.
}																																//
																																//
//		Получение значений АЦП снятых с потенциометров установленных по осям X и Y джойстика:									//	Возвращаемое значение:	отсутствует.
bool	iarduino_I2C_Joystick::_getADC_XY		(int &x, int &y){ x=0; y=0;														//	Параметры:				&x, &y - ссылки на переменные в которые требуется записать значения АЦП по осям X и Y.
			if(valAddr){																										//	Если модуль был инициализирован, то ...
				if(_readBytes(REG_JOY_X_ADC_L,4)==false){return false;}															//	Читаем 4 байта из регистров «REG_JOY_X_ADC_LH» и «REG_JOY_Y_ADC_LH» в массив «data»
				x=((int)data[1]<<8)|(int)data[0];																				//	Сохраняем значение АЦП для оси X по ссылке x.
				y=((int)data[3]<<8)|(int)data[2];																				//	Сохраняем значение АЦП для оси Y по ссылке y.
			//	Возвращаем результат:																							//
				return true;																									//
			}	return false;																									//
}																																//
																																//
//		Калибровка координат по оси X:																							//	Возвращаемое значение:	результат калибровки.
bool	iarduino_I2C_Joystick::setCalibration_X	(int x_min, int x_cen, int x_max){												//	Параметры:				x_min - АЦП крайнего левого положения, x_cen - АЦП центрального положения, x_max - АЦП крайнего правого положения.
			if(valAddr){																										//	Если модуль был инициализирован, то ...
			//	Готовим данные для передачи:																					//
				data[0] =  x_max     & 0x00FF;																					//	Байт для записи в регистр «REG_JOY_X_RIGHT_L».
				data[1] = (x_max>>8) & 0x00FF;																					//	Байт для записи в регистр «REG_JOY_X_RIGHT_H».
				data[2] =  x_cen     & 0x00FF;																					//	Байт для записи в регистр «REG_JOY_X_CEN_L».
				data[3] = (x_cen>>8) & 0x00FF;																					//	Байт для записи в регистр «REG_JOY_X_CEN_H».
				data[4] =  x_min     & 0x00FF;																					//	Байт для записи в регистр «REG_JOY_X_LEFT_L».
				data[5] = (x_min>>8) & 0x00FF;																					//	Байт для записи в регистр «REG_JOY_X_LEFT_H».
			//	Отправляем подготовленные данные в модуль:																		//
				if(_writeBytes(REG_JOY_X_RIGHT_L, 6)==false){return false;}														//	Записываем 6 байт из массива «data» в модуль, начиная с регистра «REG_JOY_X_RIGHT_L».
			//	Ждём завершение процесса записи данных в flash память модуля:													//
				delay(200);																										//	Даём более чем достаточное время для применения модулем новых калибровочных значений.
			//	Возвращаем результат:																							//
				return true;																									//
			}	return false;																									//
}																																//
																																//
//		Калибровка координат по оси X:																							//	Возвращаемое значение:	результат калибровки.
bool	iarduino_I2C_Joystick::setCalibration_Y	(int y_min, int y_cen, int y_max){												//	Параметры:				y_min - АЦП крайнего нижнего положения, y_cen - АЦП центрального положения, y_max - АЦП крайнего верхнего положения.
			if(valAddr){																										//	Если модуль был инициализирован, то ...
			//	Готовим данные для передачи:																					//
				data[0] =  y_max     & 0x00FF;																					//	Байт для записи в регистр «REG_JOY_Y_UP_L».
				data[1] = (y_max>>8) & 0x00FF;																					//	Байт для записи в регистр «REG_JOY_Y_UP_H».
				data[2] =  y_cen     & 0x00FF;																					//	Байт для записи в регистр «REG_JOY_Y_CEN_L».
				data[3] = (y_cen>>8) & 0x00FF;																					//	Байт для записи в регистр «REG_JOY_Y_CEN_H».
				data[4] =  y_min     & 0x00FF;																					//	Байт для записи в регистр «REG_JOY_Y_DOWN_L».
				data[5] = (y_min>>8) & 0x00FF;																					//	Байт для записи в регистр «REG_JOY_Y_DOWN_H».
			//	Отправляем подготовленные данные в модуль:																		//
				if(_writeBytes(REG_JOY_Y_UP_L, 6)==false){return false;}														//	Записываем 6 байт из массива «data» в модуль, начиная с регистра «REG_JOY_Y_UP_L».
			//	Ждём завершение процесса записи данных в flash память модуля:													//
				delay(200);																										//	Даём более чем достаточное время для применения модулем новых калибровочных значений.
			//	Возвращаем результат:																							//
				return true;																									//
			}	return false;																									//
}																																//
																																//
//		Получение текущих калибровочных значений для оси X:																		//	Возвращаемое значение:	результат чтения.
bool	iarduino_I2C_Joystick::_getCal_X		(int &x_min, int &x_cen, int &x_max){											//	Параметры:				x_min - АЦП крайнего левого положения, x_cen - АЦП центрального положения, x_max - АЦП крайнего правого положения.
			if(valAddr){																										//	Если модуль был инициализирован, то ...
				if(_readBytes(REG_JOY_X_RIGHT_L, 6)==false){return false;}														//	Читаем 6 байт из модуля в массив «data», начиная с регистра «REG_JOY_X_RIGHT_L».
				x_max = data[1]<<8; x_max |= data[0];																			//	Сохраняем двухбайтное значение из регистров «REG_JOY_X_RIGHT_HL».
				x_cen = data[3]<<8; x_cen |= data[2];																			//	Сохраняем двухбайтное значение из регистров «REG_JOY_X_CEN_HL».
				x_min = data[5]<<8; x_min |= data[4];																			//	Сохраняем двухбайтное значение из регистров «REG_JOY_X_LEFT_HL».
			//	Возвращаем результат:																							//
				return true;																									//
			}	return false;																									//
}																																//
																																//
//		Получение текущих калибровочных значений для оси Y:																		//	Возвращаемое значение:	результат чтения.
bool	iarduino_I2C_Joystick::_getCal_Y		(int &y_min, int &y_cen, int &y_max){											//	Параметры:				y_min - АЦП крайнего нижнего положения, y_cen - АЦП центрального положения, y_max - АЦП крайнего верхнего положения.
			if(valAddr){																										//	Если модуль был инициализирован, то ...
				if(_readBytes(REG_JOY_Y_UP_L, 6)==false){return false;}															//	Читаем 6 байт из модуля в массив «data», начиная с регистра «REG_JOY_Y_UP_L».
				y_max = data[1]<<8; y_max |= data[0];																			//	Сохраняем двухбайтное значение из регистров «REG_JOY_Y_UP_HL».
				y_cen = data[3]<<8; y_cen |= data[2];																			//	Сохраняем двухбайтное значение из регистров «REG_JOY_Y_CEN_HL».
				y_min = data[5]<<8; y_min |= data[4];																			//	Сохраняем двухбайтное значение из регистров «REG_JOY_Y_DOWN_HL».
			//	Возвращаем результат:																							//
				return true;																									//
			}	return false;																									//
}																																//
																																//
//		Установка мертвой зоны центрального положения джойстика																	//	Возвращаемое значение:	результат установки.
bool	iarduino_I2C_Joystick::setDeadZone		(float zone){																	//	Параметр:				zone - значение от 0% до 25,5% от полоного хода джойстика из центра к любому краю.
			if(valAddr){																										//	Если модуль был инициализирован, то ...
			//	Готовим байт данных для передачи:																				//
				data[0] = (uint8_t)(zone*10);																					//	Байт для записи в регистр «REG_JOY_DEAD_ZONE».
			//	Отправляем подготовленный байт в модуль:																		//
				if(_writeBytes(REG_JOY_DEAD_ZONE, 1)==false){return false;}														//	Записываем 1 байт из массива «data» в регистр «REG_JOY_DEAD_ZONE» модуля.
			//	Ждём завершение процесса записи данных в flash память модуля:													//
				delay(200);																										//	Даём более чем достаточное время для применения модулем нового значения мёртвой зоны.
			//	Возвращаем результат:																							//
				return true;																									//
			}	return false;																									//
}																																//
																																//
//		Установка коэффициента усреднения показаний АЦП																			//
bool	iarduino_I2C_Joystick::setAveraging		(uint8_t averaging){															//	Параметр:				averaging - значение от 0 (без усреднений) до 255 (максимальное усреднение).
			if(valAddr){																										//	Если модуль был инициализирован, то ...
			//	Готовим байт данных для передачи:																				//
				data[0] = averaging;																							//	Байт для записи в регистр «REG_JOY_AVERAGING».
			//	Отправляем подготовленный байт в модуль:																		//
				if(_writeBytes(REG_JOY_AVERAGING, 1)==false){return false;}														//	Записываем 1 байт из массива «data» в регистр «REG_JOY_AVERAGING» модуля.
			//	Ждём завершение процесса записи данных в flash память модуля:													//
				delay(200);																										//	Даём более чем достаточное время для применения модулем нового значения усреднения АЦП.
			//	Возвращаем результат:																							//
				return true;																									//
			}	return false;																									//
}																																//
																																//
//		Чтение данных из регистров в массив data:																				//	Возвращаемое значение:	результат чтения (true/false).
bool	iarduino_I2C_Joystick::_readBytes		(uint8_t reg, uint8_t sum){														//	Параметры:				reg - номер первого регистра, sum - количество читаемых байт.
			bool	result=false;																								//	Определяем флаг       для хранения результата чтения.
			uint8_t	sumtry=10;																									//	Определяем переменную для подсчёта количества оставшихся попыток чтения.
			do{	result = objI2C->readBytes(valAddr, reg, data, sum);															//	Считываем из модуля valAddr, начиная с регистра reg, в массив data, sum байт.
				sumtry--;	if(!result){delay(1);}																				//	Уменьшаем количество попыток чтения и устанавливаем задержку при неудаче.
			}	while		(!result && sumtry>0);																				//	Повторяем чтение если оно завершилось неудачей, но не более sumtry попыток.
			delayMicroseconds(500);																								//	Между пакетами необходимо выдерживать паузу.
			return result;																										//	Возвращаем результат чтения (true/false).
}																																//
																																//
//		Запись данных в регистры из массива data:																				//	Возвращаемое значение:	результат записи (true/false).
bool	iarduino_I2C_Joystick::_writeBytes	(uint8_t reg, uint8_t sum, uint8_t num){											//	Параметры:				reg - номер первого регистра, sum - количество записываемых байт, num - номер первого элемента массива data.
			bool	result=false;																								//	Определяем флаг       для хранения результата записи.
			uint8_t	sumtry=10;																									//	Определяем переменную для подсчёта количества оставшихся попыток записи.
			do{	result = objI2C->writeBytes(valAddr, reg, &data[num], sum);														//	Записываем в модуль valAddr начиная с регистра reg, sum байи из массива data начиная с элемента num.
				sumtry--;	if(!result){delay(1);}																				//	Уменьшаем количество попыток записи и устанавливаем задержку при неудаче.
			}	while		(!result && sumtry>0);																				//	Повторяем запись если она завершилась неудачей, но не более sumtry попыток.
			delay(10);																											//	Ждём применения модулем записанных данных.
			return result;																										//	Возвращаем результат записи (true/false).
}																																//
																																//
bool iarduino_I2C_Joystick::updateCalX()
{
		return getCalibration_X(temp_min_x, temp_cen_x, temp_max_x);
}

bool iarduino_I2C_Joystick::updateCalY()
{
		return getCalibration_Y(temp_min_y, temp_cen_y, temp_max_y);
}

