# AUTOGENERATED! DO NOT EDIT! File to edit: ../nbs/00_repr_str.ipynb.

# %% auto 0
__all__ = ['lovely']

# %% ../nbs/00_repr_str.ipynb 3
from typing import Optional, Union
from collections import defaultdict
from fastcore.foundation import store_attr
import warnings
import numpy as np

from .utils import pretty_str, PRINT_OPTS, history_warning, sparse_join, np_to_str_common, plain_repr

# %% ../nbs/00_repr_str.ipynb 8
dtnames =   {   "float16": "f16",
                "float32": "f32",
                "float64": "", # Default dtype in numpy
                "uint8": "u8",
                "uint16": "u16",
                "uint32": "u32",
                "uint64": "u64",
                "int8": "i8",
                "int16": "i16",
                "int32": "i32",
                "int64": "i64",
            }

def short_dtype(x: Union[np.ndarray, np.generic]): return dtnames.get(x.dtype.name, str(x.dtype)[6:])

# %% ../nbs/00_repr_str.ipynb 10
def np_to_str(x: Union[np.ndarray, np.generic],
            plain: bool=False,
            verbose: bool=False,
            depth=0,
            lvl=0,
            color=None) -> str:

    if plain or not np.isrealobj(x):
        return plain_repr(x)
    
    tname = type(x).__name__.split(".")[-1] if isinstance(x, np.ndarray) else None
    shape = str(list(x.shape)) if x.ndim else None
    type_str = sparse_join([tname, shape], sep="")

    color = PRINT_OPTS.color if color is None else color
    common = np_to_str_common(x, color=color)
    dtype = short_dtype(x)
    
    vals = pretty_str(x) if x.size <= 10 else None
    res = sparse_join([type_str, dtype, common, vals])

    if verbose:
        res += "\n" + plain_repr(x)

    if depth and x.ndim > 1:
        res += "\n" + "\n".join([
            " "*PRINT_OPTS.indent*(lvl+1) +
            str(np_to_str(x[i,:], depth=depth-1, lvl=lvl+1))
            for i in range(x.shape[0])])

    return res

# %% ../nbs/00_repr_str.ipynb 12
class StrProxy():
    def __init__(self, x: np.ndarray,
                    plain=False,
                    verbose=False,
                    depth=0,
                    lvl=0,
                    color=None):
        store_attr()
        history_warning()
    
    def __repr__(self):
        return np_to_str(self.x, plain=self.plain, verbose=self.verbose,
                      depth=self.depth, lvl=self.lvl, color=self.color)

    # This is used for .deeper attribute and .deeper(depth=...).
    # The second onthe results in a __call__.
    def __call__(self, depth=1):
        return StrProxy(self.x, depth=depth)

# %% ../nbs/00_repr_str.ipynb 14
def lovely(x: np.ndarray, # Tensor of interest
            verbose=False,  # Whether to show the full tensor
            plain=False,    # Just print if exactly as before
            depth=0,        # Show stats in depth
            color=None):    # Force color (True/False) or auto.
    return StrProxy(x, verbose=verbose, plain=plain, depth=depth, color=color)
