"""
This dataset is based on:
    Kralj Novak, Petra; Smailović, Jasmina; Sluban, Borut and Mozetič, Igor, 2015,
    Emoji Sentiment Ranking 1.0, Slovenian language resource repository CLARIN.SI,
    http://hdl.handle.net/11356/1048.
"""

def rebuilt_emoji_dictionaries(filename):
    emoji2unicode_name, emoji2sentiment = {}, {}
    with open(filename) as csvin:
        for emoji in csv.DictReader(csvin):
            for key, value in emoji.items():
                if key in ('Occurrences', 'Positive', 'Neutral', 'Negative'):
                    emoji[key] = int(value)
                elif key in ('Position',):
                    emoji[key] = float(value)

            emoji['Sentiment'] = (emoji['Positive'] - emoji['Negative']) / \
                                max(100, (emoji['Positive'] + emoji['Neutral'] + emoji['Negative']))
            emoji2unicode_name[emoji['Emoji']] = emoji['Unicode name']
            emoji2sentiment[emoji['Emoji']] = emoji['Sentiment']

    return emoji2unicode_name, emoji2sentiment

emoji2unicode_name = {
    '😂': 'FACE WITH TEARS OF JOY',
    '❤': 'HEAVY BLACK HEART',
    '♥': 'BLACK HEART SUIT',
    '😍': 'SMILING FACE WITH HEART-SHAPED EYES',
    '😭': 'LOUDLY CRYING FACE',
    '😘': 'FACE THROWING A KISS',
    '😊': 'SMILING FACE WITH SMILING EYES',
    '👌': 'OK HAND SIGN',
    '💕': 'TWO HEARTS',
    '👏': 'CLAPPING HANDS SIGN',
    '😁': 'GRINNING FACE WITH SMILING EYES',
    '☺': 'WHITE SMILING FACE',
    '♡': 'WHITE HEART SUIT',
    '👍': 'THUMBS UP SIGN',
    '😩': 'WEARY FACE',
    '🙏': 'PERSON WITH FOLDED HANDS',
    '✌': 'VICTORY HAND',
    '😏': 'SMIRKING FACE',
    '😉': 'WINKING FACE',
    '🙌': 'PERSON RAISING BOTH HANDS IN CELEBRATION',
    '🙈': 'SEE-NO-EVIL MONKEY',
    '💪': 'FLEXED BICEPS',
    '😄': 'SMILING FACE WITH OPEN MOUTH AND SMILING EYES',
    '😒': 'UNAMUSED FACE',
    '💃': 'DANCER',
    '💖': 'SPARKLING HEART',
    '😃': 'SMILING FACE WITH OPEN MOUTH',
    '😔': 'PENSIVE FACE',
    '😱': 'FACE SCREAMING IN FEAR',
    '🎉': 'PARTY POPPER',
    '😜': 'FACE WITH STUCK-OUT TONGUE AND WINKING EYE',
    '☯': 'YIN YANG',
    '🌸': 'CHERRY BLOSSOM',
    '💜': 'PURPLE HEART',
    '💙': 'BLUE HEART',
    '✨': 'SPARKLES',
    '😳': 'FLUSHED FACE',
    '💗': 'GROWING HEART',
    '★': 'BLACK STAR',
    '█': 'FULL BLOCK',
    '☀': 'BLACK SUN WITH RAYS',
    '😡': 'POUTING FACE',
    '😎': 'SMILING FACE WITH SUNGLASSES',
    '😢': 'CRYING FACE',
    '💋': 'KISS MARK',
    '😋': 'FACE SAVOURING DELICIOUS FOOD',
    '🙊': 'SPEAK-NO-EVIL MONKEY',
    '😴': 'SLEEPING FACE',
    '🎶': 'MULTIPLE MUSICAL NOTES',
    '💞': 'REVOLVING HEARTS',
    '😌': 'RELIEVED FACE',
    '🔥': 'FIRE',
    '💯': 'HUNDRED POINTS SYMBOL',
    '🔫': 'PISTOL',
    '💛': 'YELLOW HEART',
    '💁': 'INFORMATION DESK PERSON',
    '💚': 'GREEN HEART',
    '♫': 'BEAMED EIGHTH NOTES',
    '😞': 'DISAPPOINTED FACE',
    '😆': 'SMILING FACE WITH OPEN MOUTH AND TIGHTLY-CLOSED EYES',
    '😝': 'FACE WITH STUCK-OUT TONGUE AND TIGHTLY-CLOSED EYES',
    '😪': 'SLEEPY FACE',
    '�': 'REPLACEMENT CHARACTER',
    '😫': 'TIRED FACE',
    '😅': 'SMILING FACE WITH OPEN MOUTH AND COLD SWEAT',
    '👊': 'FISTED HAND SIGN',
    '💀': 'SKULL',
    '😀': 'GRINNING FACE',
    '😚': 'KISSING FACE WITH CLOSED EYES',
    '😻': 'SMILING CAT FACE WITH HEART-SHAPED EYES',
    '©': 'COPYRIGHT SIGN',
    '👀': 'EYES',
    '💘': 'HEART WITH ARROW',
    '🐓': 'ROOSTER',
    '☕': 'HOT BEVERAGE',
    '👋': 'WAVING HAND SIGN',
    '✋': 'RAISED HAND',
    '🎊': 'CONFETTI BALL',
    '🍕': 'SLICE OF PIZZA',
    '❄': 'SNOWFLAKE',
    '😥': 'DISAPPOINTED BUT RELIEVED FACE',
    '😕': 'CONFUSED FACE',
    '💥': 'COLLISION SYMBOL',
    '💔': 'BROKEN HEART',
    '😤': 'FACE WITH LOOK OF TRIUMPH',
    '😈': 'SMILING FACE WITH HORNS',
    '►': 'BLACK RIGHT-POINTING POINTER',
    '✈': 'AIRPLANE',
    '🔝': 'TOP WITH UPWARDS ARROW ABOVE',
    '😰': 'FACE WITH OPEN MOUTH AND COLD SWEAT',
    '⚽': 'SOCCER BALL',
    '😑': 'EXPRESSIONLESS FACE',
    '👑': 'CROWN',
    '😹': 'CAT FACE WITH TEARS OF JOY',
    '👉': 'WHITE RIGHT POINTING BACKHAND INDEX',
    '🍃': 'LEAF FLUTTERING IN WIND',
    '🎁': 'WRAPPED PRESENT',
    '😠': 'ANGRY FACE',
    '🐧': 'PENGUIN',
    '☆': 'WHITE STAR',
    '🍀': 'FOUR LEAF CLOVER',
    '🎈': 'BALLOON',
    '🎅': 'FATHER CHRISTMAS',
    '😓': 'FACE WITH COLD SWEAT',
    '😣': 'PERSEVERING FACE',
    '😐': 'NEUTRAL FACE',
    '✊': 'RAISED FIST',
    '😨': 'FEARFUL FACE',
    '😖': 'CONFOUNDED FACE',
    '💤': 'SLEEPING SYMBOL',
    '💓': 'BEATING HEART',
    '👎': 'THUMBS DOWN SIGN',
    '💦': 'SPLASHING SWEAT SYMBOL',
    '✔': 'HEAVY CHECK MARK',
    '😷': 'FACE WITH MEDICAL MASK',
    '⚡': 'HIGH VOLTAGE SIGN',
    '🙋': 'HAPPY PERSON RAISING ONE HAND',
    '🎄': 'CHRISTMAS TREE',
    '💩': 'PILE OF POO',
    '🎵': 'MUSICAL NOTE',
    '➡': 'BLACK RIGHTWARDS ARROW',
    '😛': 'FACE WITH STUCK-OUT TONGUE',
    '😬': 'GRIMACING FACE',
    '👯': 'WOMAN WITH BUNNY EARS',
    '💎': 'GEM STONE',
    '🌿': 'HERB',
    '🎂': 'BIRTHDAY CAKE',
    '🌟': 'GLOWING STAR',
    '🔮': 'CRYSTAL BALL',
    '❗': 'HEAVY EXCLAMATION MARK SYMBOL',
    '👫': 'MAN AND WOMAN HOLDING HANDS',
    '🏆': 'TROPHY',
    '✖': 'HEAVY MULTIPLICATION X',
    '☝': 'WHITE UP POINTING INDEX',
    '😙': 'KISSING FACE WITH SMILING EYES',
    '⛄': 'SNOWMAN WITHOUT SNOW',
    '👅': 'TONGUE',
    '♪': 'EIGHTH NOTE',
    '🍂': 'FALLEN LEAF',
    '💏': 'KISS',
    '🔪': 'HOCHO',
    '🌴': 'PALM TREE',
    '👈': 'WHITE LEFT POINTING BACKHAND INDEX',
    '🌹': 'ROSE',
    '🙆': 'FACE WITH OK GESTURE',
    '➜': 'HEAVY ROUND-TIPPED RIGHTWARDS ARROW',
    '👻': 'GHOST',
    '💰': 'MONEY BAG',
    '🍻': 'CLINKING BEER MUGS',
    '🙅': 'FACE WITH NO GOOD GESTURE',
    '🌞': 'SUN WITH FACE',
    '🍁': 'MAPLE LEAF',
    '⭐': 'WHITE MEDIUM STAR',
    '▪': 'BLACK SMALL SQUARE',
    '🎀': 'RIBBON',
    '━': 'BOX DRAWINGS HEAVY HORIZONTAL',
    '☷': 'TRIGRAM FOR EARTH',
    '🐷': 'PIG FACE',
    '🙉': 'HEAR-NO-EVIL MONKEY',
    '🌺': 'HIBISCUS',
    '💅': 'NAIL POLISH',
    '🐶': 'DOG FACE',
    '🌚': 'NEW MOON WITH FACE',
    '👽': 'EXTRATERRESTRIAL ALIEN',
    '🎤': 'MICROPHONE',
    '👭': 'TWO WOMEN HOLDING HANDS',
    '🎧': 'HEADPHONE',
    '👆': 'WHITE UP POINTING BACKHAND INDEX',
    '🍸': 'COCKTAIL GLASS',
    '🍷': 'WINE GLASS',
    '®': 'REGISTERED SIGN',
    '🍉': 'WATERMELON',
    '😇': 'SMILING FACE WITH HALO',
    '☑': 'BALLOT BOX WITH CHECK',
    '🏃': 'RUNNER',
    '😿': 'CRYING CAT FACE',
    '│': 'BOX DRAWINGS LIGHT VERTICAL',
    '💣': 'BOMB',
    '🍺': 'BEER MUG',
    '▶': 'BLACK RIGHT-POINTING TRIANGLE',
    '😲': 'ASTONISHED FACE',
    '🎸': 'GUITAR',
    '🍹': 'TROPICAL DRINK',
    '💫': 'DIZZY SYMBOL',
    '📚': 'BOOKS',
    '😶': 'FACE WITHOUT MOUTH',
    '🌷': 'TULIP',
    '💝': 'HEART WITH RIBBON',
    '💨': 'DASH SYMBOL',
    '🏈': 'AMERICAN FOOTBALL',
    '💍': 'RING',
    '☔': 'UMBRELLA WITH RAIN DROPS',
    '👸': 'PRINCESS',
    '🇪': 'REGIONAL INDICATOR SYMBOL LETTER E',
    '░': 'LIGHT SHADE',
    '🍩': 'DOUGHNUT',
    '👾': 'ALIEN MONSTER',
    '☁': 'CLOUD',
    '🌻': 'SUNFLOWER',
    '😵': 'DIZZY FACE',
    '📒': 'LEDGER',
    '↿': 'UPWARDS HARPOON WITH BARB LEFTWARDS',
    '🐯': 'TIGER FACE',
    '👼': 'BABY ANGEL',
    '🍔': 'HAMBURGER',
    '😸': 'GRINNING CAT FACE WITH SMILING EYES',
    '👶': 'BABY',
    '↾': 'UPWARDS HARPOON WITH BARB RIGHTWARDS',
    '💐': 'BOUQUET',
    '🌊': 'WATER WAVE',
    '🍦': 'SOFT ICE CREAM',
    '🍓': 'STRAWBERRY',
    '👇': 'WHITE DOWN POINTING BACKHAND INDEX',
    '💆': 'FACE MASSAGE',
    '🍴': 'FORK AND KNIFE',
    '😧': 'ANGUISHED FACE',
    '🇸': 'REGIONAL INDICATOR SYMBOL LETTER S',
    '😮': 'FACE WITH OPEN MOUTH',
    '▓': 'DARK SHADE',
    '🚫': 'NO ENTRY SIGN',
    '😽': 'KISSING CAT FACE WITH CLOSED EYES',
    '🌈': 'RAINBOW',
    '🙀': 'WEARY CAT FACE',
    '⚠': 'WARNING SIGN',
    '🎮': 'VIDEO GAME',
    '╯': 'BOX DRAWINGS LIGHT ARC UP AND LEFT',
    '🍆': 'AUBERGINE',
    '🍰': 'SHORTCAKE',
    '✓': 'CHECK MARK',
    '👐': 'OPEN HANDS SIGN',
    '🙇': 'PERSON BOWING DEEPLY',
    '🍟': 'FRENCH FRIES',
    '🍌': 'BANANA',
    '💑': 'COUPLE WITH HEART',
    '👬': 'TWO MEN HOLDING HANDS',
    '🐣': 'HATCHING CHICK',
    '🎃': 'JACK-O-LANTERN',
    '▬': 'BLACK RECTANGLE',
    '￼': 'OBJECT REPLACEMENT CHARACTER',
    '😟': 'WORRIED FACE',
    '🐾': 'PAW PRINTS',
    '🎓': 'GRADUATION CAP',
    '🏊': 'SWIMMER',
    '🍫': 'CHOCOLATE BAR',
    '📷': 'CAMERA',
    '👄': 'MOUTH',
    '🌼': 'BLOSSOM',
    '🚶': 'PEDESTRIAN',
    '🐱': 'CAT FACE',
    '║': 'BOX DRAWINGS DOUBLE VERTICAL',
    '🐸': 'FROG FACE',
    '🇺': 'REGIONAL INDICATOR SYMBOL LETTER U',
    '👿': 'IMP',
    '🚬': 'SMOKING SYMBOL',
    '✿': 'BLACK FLORETTE',
    '📖': 'OPEN BOOK',
    '🐒': 'MONKEY',
    '🌍': 'EARTH GLOBE EUROPE-AFRICA',
    '┊': 'BOX DRAWINGS LIGHT QUADRUPLE DASH VERTICAL',
    '🐥': 'FRONT-FACING BABY CHICK',
    '🌀': 'CYCLONE',
    '🐼': 'PANDA FACE',
    '🎥': 'MOVIE CAMERA',
    '💄': 'LIPSTICK',
    '💸': 'MONEY WITH WINGS',
    '⛔': 'NO ENTRY',
    '●': 'BLACK CIRCLE',
    '🏀': 'BASKETBALL AND HOOP',
    '💉': 'SYRINGE',
    '💟': 'HEART DECORATION',
    '🚗': 'AUTOMOBILE',
    '😯': 'HUSHED FACE',
    '📝': 'MEMO',
    '═': 'BOX DRAWINGS DOUBLE HORIZONTAL',
    '♦': 'BLACK DIAMOND SUIT',
    '💭': 'THOUGHT BALLOON',
    '🌙': 'CRESCENT MOON',
    '🐟': 'FISH',
    '👣': 'FOOTPRINTS',
    '☞': 'WHITE RIGHT POINTING INDEX',
    '✂': 'BLACK SCISSORS',
    '🗿': 'MOYAI',
    '🍝': 'SPAGHETTI',
    '👪': 'FAMILY',
    '🍭': 'LOLLIPOP',
    '🌃': 'NIGHT WITH STARS',
    '❌': 'CROSS MARK',
    '🐰': 'RABBIT FACE',
    '💊': 'PILL',
    '🚨': 'POLICE CARS REVOLVING LIGHT',
    '😦': 'FROWNING FACE WITH OPEN MOUTH',
    '🍪': 'COOKIE',
    '🍣': 'SUSHI',
    '╭': 'BOX DRAWINGS LIGHT ARC DOWN AND RIGHT',
    '✧': 'WHITE FOUR POINTED STAR',
    '🎆': 'FIREWORKS',
    '╮': 'BOX DRAWINGS LIGHT ARC DOWN AND LEFT',
    '🎎': 'JAPANESE DOLLS',
    '🇩': 'REGIONAL INDICATOR SYMBOL LETTER D',
    '✅': 'WHITE HEAVY CHECK MARK',
    '👹': 'JAPANESE OGRE',
    '📱': 'MOBILE PHONE',
    '🙍': 'PERSON FROWNING',
    '🍑': 'PEACH',
    '🎼': 'MUSICAL SCORE',
    '🔊': 'SPEAKER WITH THREE SOUND WAVES',
    '🌌': 'MILKY WAY',
    '🍎': 'RED APPLE',
    '🐻': 'BEAR FACE',
    '─': 'BOX DRAWINGS LIGHT HORIZONTAL',
    '╰': 'BOX DRAWINGS LIGHT ARC UP AND RIGHT',
    '💇': 'HAIRCUT',
    '♬': 'BEAMED SIXTEENTH NOTES',
    '♚': 'BLACK CHESS KING',
    '🔴': 'LARGE RED CIRCLE',
    '🍱': 'BENTO BOX',
    '🍊': 'TANGERINE',
    '🍒': 'CHERRIES',
    '🐭': 'MOUSE FACE',
    '👟': 'ATHLETIC SHOE',
    '🌎': 'EARTH GLOBE AMERICAS',
    '🍍': 'PINEAPPLE',
    '🐮': 'COW FACE',
    '📲': 'MOBILE PHONE WITH RIGHTWARDS ARROW AT LEFT',
    '☼': 'WHITE SUN WITH RAYS',
    '🌅': 'SUNRISE',
    '🇷': 'REGIONAL INDICATOR SYMBOL LETTER R',
    '👠': 'HIGH-HEELED SHOE',
    '🌽': 'EAR OF MAIZE',
    '💧': 'DROPLET',
    '❓': 'BLACK QUESTION MARK ORNAMENT',
    '🍬': 'CANDY',
    '😺': 'SMILING CAT FACE WITH OPEN MOUTH',
    '🐴': 'HORSE FACE',
    '🚀': 'ROCKET',
    '¦': 'BROKEN BAR',
    '💢': 'ANGER SYMBOL',
    '🎬': 'CLAPPER BOARD',
    '🍧': 'SHAVED ICE',
    '🍜': 'STEAMING BOWL',
    '🐏': 'RAM',
    '🐘': 'ELEPHANT',
    '👧': 'GIRL',
    '⠀': 'BRAILLE PATTERN BLANK',
    '🏄': 'SURFER',
    '➤': 'BLACK RIGHTWARDS ARROWHEAD',
    '⬆': 'UPWARDS BLACK ARROW',
    '🍋': 'LEMON',
    '🆗': 'SQUARED OK',
    '⚪': 'MEDIUM WHITE CIRCLE',
    '📺': 'TELEVISION',
    '🍅': 'TOMATO',
    '⛅': 'SUN BEHIND CLOUD',
    '🐢': 'TURTLE',
    '👙': 'BIKINI',
    '🏡': 'HOUSE WITH GARDEN',
    '🌾': 'EAR OF RICE',
    '◉': 'FISHEYE',
    '✏': 'PENCIL',
    '🐬': 'DOLPHIN',
    '🍤': 'FRIED SHRIMP',
    '🇹': 'REGIONAL INDICATOR SYMBOL LETTER T',
    '♣': 'BLACK CLUB SUIT',
    '🐝': 'HONEYBEE',
    '🌝': 'FULL MOON WITH FACE',
    '🇮': 'REGIONAL INDICATOR SYMBOL LETTER I',
    '🔋': 'BATTERY',
    '🐍': 'SNAKE',
    '♔': 'WHITE CHESS KING',
    '🍳': 'COOKING',
    '🔵': 'LARGE BLUE CIRCLE',
    '😾': 'POUTING CAT FACE',
    '🌕': 'FULL MOON SYMBOL',
    '🐨': 'KOALA',
    '🔐': 'CLOSED LOCK WITH KEY',
    '💿': 'OPTICAL DISC',
    '❁': 'EIGHT PETALLED OUTLINED BLACK FLORETTE',
    '🌳': 'DECIDUOUS TREE',
    '👰': 'BRIDE WITH VEIL',
    '❀': 'WHITE FLORETTE',
    '⚓': 'ANCHOR',
    '🚴': 'BICYCLIST',
    '▀': 'UPPER HALF BLOCK',
    '👗': 'DRESS',
    '➕': 'HEAVY PLUS SIGN',
    '💬': 'SPEECH BALLOON',
    '▒': 'MEDIUM SHADE',
    '🔜': 'SOON WITH RIGHTWARDS ARROW ABOVE',
    '🍨': 'ICE CREAM',
    '💲': 'HEAVY DOLLAR SIGN',
    '⛽': 'FUEL PUMP',
    '🍙': 'RICE BALL',
    '🍗': 'POULTRY LEG',
    '🍲': 'POT OF FOOD',
    '🍥': 'FISH CAKE WITH SWIRL DESIGN',
    '▸': 'BLACK RIGHT-POINTING SMALL TRIANGLE',
    '♛': 'BLACK CHESS QUEEN',
    '😼': 'CAT FACE WITH WRY SMILE',
    '🐙': 'OCTOPUS',
    '👨': 'MAN',
    '🍚': 'COOKED RICE',
    '🍖': 'MEAT ON BONE',
    '♨': 'HOT SPRINGS',
    '🎹': 'MUSICAL KEYBOARD',
    '♕': 'WHITE CHESS QUEEN',
    '▃': 'LOWER THREE EIGHTHS BLOCK',
    '🚘': 'ONCOMING AUTOMOBILE',
    '🍏': 'GREEN APPLE',
    '👩': 'WOMAN',
    '👦': 'BOY',
    '🇬': 'REGIONAL INDICATOR SYMBOL LETTER G',
    '🇧': 'REGIONAL INDICATOR SYMBOL LETTER B',
    '☠': 'SKULL AND CROSSBONES',
    '🐠': 'TROPICAL FISH',
    '🚹': 'MENS SYMBOL',
    '💵': 'BANKNOTE WITH DOLLAR SIGN',
    '✰': 'SHADOWED WHITE STAR',
    '╠': 'BOX DRAWINGS DOUBLE VERTICAL AND RIGHT',
    '👛': 'PURSE',
    '🚙': 'RECREATIONAL VEHICLE',
    '🌱': 'SEEDLING',
    '💻': 'PERSONAL COMPUTER',
    '🌏': 'EARTH GLOBE ASIA-AUSTRALIA',
    '▄': 'LOWER HALF BLOCK',
    '👓': 'EYEGLASSES',
    '◄': 'BLACK LEFT-POINTING POINTER',
    '⚾': 'BASEBALL',
    '🌲': 'EVERGREEN TREE',
    '👴': 'OLDER MAN',
    '🏠': 'HOUSE BUILDING',
    '🍇': 'GRAPES',
    '🍘': 'RICE CRACKER',
    '🍛': 'CURRY AND RICE',
    '🐇': 'RABBIT',
    '🔞': 'NO ONE UNDER EIGHTEEN SYMBOL',
    '👵': 'OLDER WOMAN',
    '◀': 'BLACK LEFT-POINTING TRIANGLE',
    '🔙': 'BACK WITH LEFTWARDS ARROW ABOVE',
    '🌵': 'CACTUS',
    '🐽': 'PIG NOSE',
    '🍮': 'CUSTARD',
    '🎇': 'FIREWORK SPARKLER',
    '🐎': 'HORSE',
    '➔': 'HEAVY WIDE-HEADED RIGHTWARDS ARROW',
    '💶': 'BANKNOTE WITH EURO SIGN',
    '🐤': 'BABY CHICK',
    '╩': 'BOX DRAWINGS DOUBLE UP AND HORIZONTAL',
    '🛀': 'BATH',
    '🌑': 'NEW MOON SYMBOL',
    '🚲': 'BICYCLE',
    '🐑': 'SHEEP',
    '🏁': 'CHEQUERED FLAG',
    '🍞': 'BREAD',
    '🎾': 'TENNIS RACQUET AND BALL',
    '╚': 'BOX DRAWINGS DOUBLE UP AND RIGHT',
    '🈹': 'SQUARED CJK UNIFIED IDEOGRAPH-5272',
    '🐳': 'SPOUTING WHALE',
    '👮': 'POLICE OFFICER',
    '☹': 'WHITE FROWNING FACE',
    '🐵': 'MONKEY FACE',
    '✪': 'CIRCLED WHITE STAR',
    '◕': 'CIRCLE WITH ALL BUT UPPER LEFT QUADRANT BLACK',
    '🗼': 'TOKYO TOWER',
    '▐': 'RIGHT HALF BLOCK',
    '♠': 'BLACK SPADE SUIT',
    '┳': 'BOX DRAWINGS HEAVY DOWN AND HORIZONTAL',
    '👺': 'JAPANESE GOBLIN',
    '🐚': 'SPIRAL SHELL',
    '👂': 'EAR',
    '🗽': 'STATUE OF LIBERTY',
    '🍵': 'TEACUP WITHOUT HANDLE',
    '🆒': 'SQUARED COOL',
    '🍯': 'HONEY POT',
    '🐺': 'WOLF FACE',
    '⇨': 'RIGHTWARDS WHITE ARROW',
    '➨': 'HEAVY CONCAVE-POINTED BLACK RIGHTWARDS ARROW',
    '🌓': 'FIRST QUARTER MOON SYMBOL',
    '🔒': 'LOCK',
    '╬': 'BOX DRAWINGS DOUBLE VERTICAL AND HORIZONTAL',
    '👳': 'MAN WITH TURBAN',
    '🌂': 'CLOSED UMBRELLA',
    '🚌': 'BUS',
    '♩': 'QUARTER NOTE',
    '🍡': 'DANGO',
    '❥': 'ROTATED HEAVY BLACK HEART BULLET',
    '🎡': 'FERRIS WHEEL',
    '💌': 'LOVE LETTER',
    '🐩': 'POODLE',
    '🌜': 'LAST QUARTER MOON WITH FACE',
    '⌚': 'WATCH',
    '🚿': 'SHOWER',
    '🐖': 'PIG',
    '🔆': 'HIGH BRIGHTNESS SYMBOL',
    '🌛': 'FIRST QUARTER MOON WITH FACE',
    '💂': 'GUARDSMAN',
    '🐔': 'CHICKEN',
    '🙎': 'PERSON WITH POUTING FACE',
    '🏩': 'LOVE HOTEL',
    '🇫': 'REGIONAL INDICATOR SYMBOL LETTER F',
    '🔨': 'HAMMER',
    '📢': 'PUBLIC ADDRESS LOUDSPEAKER',
    '🐦': 'BIRD',
    '🐲': 'DRAGON FACE',
    '♻': 'BLACK UNIVERSAL RECYCLING SYMBOL',
    '🌘': 'WANING CRESCENT MOON SYMBOL',
    '🍐': 'PEAR',
    '🌔': 'WAXING GIBBOUS MOON SYMBOL',
    '╥': 'BOX DRAWINGS DOWN DOUBLE AND HORIZONTAL SINGLE',
    '❊': 'EIGHT TEARDROP-SPOKED PROPELLER ASTERISK',
    '👖': 'JEANS',
    '🚺': 'WOMENS SYMBOL',
    '😗': 'KISSING FACE',
    '🎭': 'PERFORMING ARTS',
    '🐄': 'COW',
    '◟': 'LOWER LEFT QUADRANT CIRCULAR ARC',
    '🍢': 'ODEN',
    '🎨': 'ARTIST PALETTE',
    '⬇': 'DOWNWARDS BLACK ARROW',
    '🚼': 'BABY SYMBOL',
    '⛲': 'FOUNTAIN',
    '▁': 'LOWER ONE EIGHTH BLOCK',
    '🇴': 'REGIONAL INDICATOR SYMBOL LETTER O',
    '🌗': 'LAST QUARTER MOON SYMBOL',
    '🌖': 'WANING GIBBOUS MOON SYMBOL',
    '🔅': 'LOW BRIGHTNESS SYMBOL',
    '👜': 'HANDBAG',
    '🐌': 'SNAIL',
    '💼': 'BRIEFCASE',
    '🚕': 'TAXI',
    '🐹': 'HAMSTER FACE',
    '🌠': 'SHOOTING STAR',
    '🐈': 'CAT',
    '⇧': 'UPWARDS WHITE ARROW',
    '☎': 'BLACK TELEPHONE',
    '🌁': 'FOGGY',
    '⚫': 'MEDIUM BLACK CIRCLE',
    '♧': 'WHITE CLUB SUIT',
    '🏰': 'EUROPEAN CASTLE',
    '🚵': 'MOUNTAIN BICYCLIST',
    '🎢': 'ROLLER COASTER',
    '🎷': 'SAXOPHONE',
    '🎐': 'WIND CHIME',
    '┈': 'BOX DRAWINGS LIGHT QUADRUPLE DASH HORIZONTAL',
    '╗': 'BOX DRAWINGS DOUBLE DOWN AND LEFT',
    '╱': 'BOX DRAWINGS LIGHT DIAGONAL UPPER RIGHT TO LOWER LEFT',
    '🌇': 'SUNSET OVER BUILDINGS',
    '⏰': 'ALARM CLOCK',
    '⇩': 'DOWNWARDS WHITE ARROW',
    '🚂': 'STEAM LOCOMOTIVE',
    '◠': 'UPPER HALF CIRCLE',
    '🎿': 'SKI AND SKI BOOT',
    '✦': 'BLACK FOUR POINTED STAR',
    '🆔': 'SQUARED ID',
    '⛪': 'CHURCH',
    '🌒': 'WAXING CRESCENT MOON SYMBOL',
    '🐪': 'DROMEDARY CAMEL',
    '╔': 'BOX DRAWINGS DOUBLE DOWN AND RIGHT',
    '╝': 'BOX DRAWINGS DOUBLE UP AND LEFT',
    '👔': 'NECKTIE',
    '🔱': 'TRIDENT EMBLEM',
    '🆓': 'SQUARED FREE',
    '🐋': 'WHALE',
    '▽': 'WHITE DOWN-POINTING TRIANGLE',
    '▂': 'LOWER ONE QUARTER BLOCK',
    '🐛': 'BUG',
    '👕': 'T-SHIRT',
    '🚋': 'TRAM CAR',
    '💳': 'CREDIT CARD',
    '🌆': 'CITYSCAPE AT DUSK',
    '🏧': 'AUTOMATED TELLER MACHINE',
    '💡': 'ELECTRIC LIGHT BULB',
    '🔹': 'SMALL BLUE DIAMOND',
    '⬅': 'LEFTWARDS BLACK ARROW',
    '🍠': 'ROASTED SWEET POTATO',
    '🐫': 'BACTRIAN CAMEL',
    '🏪': 'CONVENIENCE STORE',
    '۩': 'ARABIC PLACE OF SAJDAH',
    '🇱': 'REGIONAL INDICATOR SYMBOL LETTER L',
    '📹': 'VIDEO CAMERA',
    '👞': 'MANS SHOE',
    '🚑': 'AMBULANCE',
    '🆘': 'SQUARED SOS',
    '👚': 'WOMANS CLOTHES',
    '🚍': 'ONCOMING BUS',
    '□': 'WHITE SQUARE',
    '🐂': 'OX',
    '🚣': 'ROWBOAT',
    '✳': 'EIGHT SPOKED ASTERISK',
    '🏉': 'RUGBY FOOTBALL',
    '🗻': 'MOUNT FUJI',
    '🐀': 'RAT',
    '╦': 'BOX DRAWINGS DOUBLE DOWN AND HORIZONTAL',
    '⛺': 'TENT',
    '🐕': 'DOG',
    '🏂': 'SNOWBOARDER',
    '👡': 'WOMANS SANDAL',
    '📻': 'RADIO',
    '✒': 'BLACK NIB',
    '🌰': 'CHESTNUT',
    '🏢': 'OFFICE BUILDING',
    '🎒': 'SCHOOL SATCHEL',
    '⌒': 'ARC',
    '🏫': 'SCHOOL',
    '📴': 'MOBILE PHONE OFF',
    '🚢': 'SHIP',
    '🚚': 'DELIVERY TRUCK',
    '🐉': 'DRAGON',
    '❒': 'UPPER RIGHT SHADOWED WHITE SQUARE',
    '🐊': 'CROCODILE',
    '🔔': 'BELL',
    '◢': 'BLACK LOWER RIGHT TRIANGLE',
    '🏥': 'HOSPITAL',
    '❔': 'WHITE QUESTION MARK ORNAMENT',
    '🚖': 'ONCOMING TAXI',
    '🃏': 'PLAYING CARD BLACK JOKER',
    '▼': 'BLACK DOWN-POINTING TRIANGLE',
    '▌': 'LEFT HALF BLOCK',
    '☛': 'BLACK RIGHT POINTING INDEX',
    '✩': 'STRESS OUTLINED WHITE STAR',
    '💒': 'WEDDING',
    '🚤': 'SPEEDBOAT',
    '🐐': 'GOAT',
    '■': 'BLACK SQUARE',
    '🔚': 'END WITH LEFTWARDS ARROW ABOVE',
    '🎻': 'VIOLIN',
    '🔷': 'LARGE BLUE DIAMOND',
    '🚦': 'VERTICAL TRAFFIC LIGHT',
    '🔓': 'OPEN LOCK',
    '🎽': 'RUNNING SHIRT WITH SASH',
    '📅': 'CALENDAR',
    '🎺': 'TRUMPET',
    '✯': 'PINWHEEL STAR',
    '🍈': 'MELON',
    '✉': 'ENVELOPE',
    '╣': 'BOX DRAWINGS DOUBLE VERTICAL AND LEFT',
    '◤': 'BLACK UPPER LEFT TRIANGLE',
    '○': 'WHITE CIRCLE',
    '🍼': 'BABY BOTTLE',
    '📀': 'DVD',
    '🚛': 'ARTICULATED LORRY',
    '📓': 'NOTEBOOK',
    '☉': 'SUN',
    '💴': 'BANKNOTE WITH YEN SIGN',
    '┼': 'BOX DRAWINGS LIGHT VERTICAL AND HORIZONTAL',
    '🐃': 'WATER BUFFALO',
    '➰': 'CURLY LOOP',
    '🔌': 'ELECTRIC PLUG',
    '🍄': 'MUSHROOM',
    '📕': 'CLOSED BOOK',
    '📣': 'CHEERING MEGAPHONE',
    '🚓': 'POLICE CAR',
    '🐗': 'BOAR',
    '↪': 'RIGHTWARDS ARROW WITH HOOK',
    '⛳': 'FLAG IN HOLE',
    '┻': 'BOX DRAWINGS HEAVY UP AND HORIZONTAL',
    '┛': 'BOX DRAWINGS HEAVY UP AND LEFT',
    '┃': 'BOX DRAWINGS HEAVY VERTICAL',
    '👱': 'PERSON WITH BLOND HAIR',
    '⏳': 'HOURGLASS WITH FLOWING SAND',
    '💺': 'SEAT',
    '🏇': 'HORSE RACING',
    '☻': 'BLACK SMILING FACE',
    '📞': 'TELEPHONE RECEIVER',
    'Ⓐ': 'CIRCLED LATIN CAPITAL LETTER A',
    '🌉': 'BRIDGE AT NIGHT',
    '🚩': 'TRIANGULAR FLAG ON POST',
    '✎': 'LOWER RIGHT PENCIL',
    '📃': 'PAGE WITH CURL',
    '🏨': 'HOTEL',
    '📌': 'PUSHPIN',
    '♎': 'LIBRA',
    '💷': 'BANKNOTE WITH POUND SIGN',
    '🚄': 'HIGH-SPEED TRAIN',
    '▲': 'BLACK UP-POINTING TRIANGLE',
    '⛵': 'SAILBOAT',
    '🔸': 'SMALL ORANGE DIAMOND',
    '⌛': 'HOURGLASS',
    '🚜': 'TRACTOR',
    '🐆': 'LEOPARD',
    '👒': 'WOMANS HAT',
    '❕': 'WHITE EXCLAMATION MARK ORNAMENT',
    '🔛': 'ON WITH EXCLAMATION MARK WITH LEFT RIGHT ARROW ABOVE',
    '♢': 'WHITE DIAMOND SUIT',
    '🇲': 'REGIONAL INDICATOR SYMBOL LETTER M',
    '❅': 'TIGHT TRIFOLIATE SNOWFLAKE',
    '👝': 'POUCH',
    '✞': 'SHADOWED WHITE LATIN CROSS',
    '◡': 'LOWER HALF CIRCLE',
    '🎋': 'TANABATA TREE',
    '👥': 'BUSTS IN SILHOUETTE',
    '📵': 'NO MOBILE PHONES',
    '🐡': 'BLOWFISH',
    '◆': 'BLACK DIAMOND',
    '🏯': 'JAPANESE CASTLE',
    '☂': 'UMBRELLA',
    '🔭': 'TELESCOPE',
    '🎪': 'CIRCUS TENT',
    '🐜': 'ANT',
    '♌': 'LEO',
    '☐': 'BALLOT BOX',
    '👷': 'CONSTRUCTION WORKER',
    '↳': 'DOWNWARDS ARROW WITH TIP RIGHTWARDS',
    '🔈': 'SPEAKER',
    '📄': 'PAGE FACING UP',
    '📍': 'ROUND PUSHPIN',
    '🚐': 'MINIBUS',
    '🚔': 'ONCOMING POLICE CAR',
    '🌋': 'VOLCANO',
    '📡': 'SATELLITE ANTENNA',
    '⏩': 'BLACK RIGHT-POINTING DOUBLE TRIANGLE',
    '🚳': 'NO BICYCLES',
    '✘': 'HEAVY BALLOT X',
    '۞': 'ARABIC START OF RUB EL HIZB',
    '☾': 'LAST QUARTER MOON',
    '🅰': 'NEGATIVE SQUARED LATIN CAPITAL LETTER A',
    '📥': 'INBOX TRAY',
    '🇼': 'REGIONAL INDICATOR SYMBOL LETTER W',
    '┓': 'BOX DRAWINGS HEAVY DOWN AND LEFT',
    '┣': 'BOX DRAWINGS HEAVY VERTICAL AND RIGHT',
    'Ⓛ': 'CIRCLED LATIN CAPITAL LETTER L',
    'Ⓔ': 'CIRCLED LATIN CAPITAL LETTER E',
    '🔦': 'ELECTRIC TORCH',
    '👤': 'BUST IN SILHOUETTE',
    '🚁': 'HELICOPTER',
    '🎠': 'CAROUSEL HORSE',
    '🐁': 'MOUSE',
    '📗': 'GREEN BOOK',
    '┐': 'BOX DRAWINGS LIGHT DOWN AND LEFT',
    '☮': 'PEACE SYMBOL',
    '♂': 'MALE SIGN',
    '◞': 'LOWER RIGHT QUADRANT CIRCULAR ARC',
    '📯': 'POSTAL HORN',
    '🔩': 'NUT AND BOLT',
    '👢': 'WOMANS BOOTS',
    '◂': 'BLACK LEFT-POINTING SMALL TRIANGLE',
    '📰': 'NEWSPAPER',
    '📶': 'ANTENNA WITH BARS',
    '🚥': 'HORIZONTAL TRAFFIC LIGHT',
    '🌄': 'SUNRISE OVER MOUNTAINS',
    '🗾': 'SILHOUETTE OF JAPAN',
    '🔶': 'LARGE ORANGE DIAMOND',
    '🏤': 'EUROPEAN POST OFFICE',
    '🎩': 'TOP HAT',
    'Ⓜ': 'CIRCLED LATIN CAPITAL LETTER M',
    '🔧': 'WRENCH',
    '🐅': 'TIGER',
    '♮': 'MUSIC NATURAL SIGN',
    '🅾': 'NEGATIVE SQUARED LATIN CAPITAL LETTER O',
    '🔄': 'ANTICLOCKWISE DOWNWARDS AND UPWARDS OPEN CIRCLE ARROWS',
    '☄': 'COMET',
    '☨': 'CROSS OF LORRAINE',
    '📦': 'PACKAGE',
    '🚊': 'TRAM',
    '🔲': 'BLACK SQUARE BUTTON',
    '🔁': 'CLOCKWISE RIGHTWARDS AND LEFTWARDS OPEN CIRCLE ARROWS',
    '△': 'WHITE UP-POINTING TRIANGLE',
    '📆': 'TEAR-OFF CALENDAR',
    '❛': 'HEAVY SINGLE TURNED COMMA QUOTATION MARK ORNAMENT',
    '📉': 'CHART WITH DOWNWARDS TREND',
    '▵': 'WHITE UP-POINTING SMALL TRIANGLE',
    '🔎': 'RIGHT-POINTING MAGNIFYING GLASS',
    '☜': 'WHITE LEFT POINTING INDEX',
    '🇯': 'REGIONAL INDICATOR SYMBOL LETTER J',
    '🇵': 'REGIONAL INDICATOR SYMBOL LETTER P',
    '📘': 'BLUE BOOK',
    '✡': 'STAR OF DAVID',
    'ⓔ': 'CIRCLED LATIN SMALL LETTER E',
    '🔑': 'KEY',
    '🔃': 'CLOCKWISE DOWNWARDS AND UPWARDS OPEN CIRCLE ARROWS',
    '👃': 'NOSE',
    '⭕': 'HEAVY LARGE CIRCLE',
    '🔘': 'RADIO BUTTON',
    'ⓒ': 'CIRCLED LATIN SMALL LETTER C',
    '🚭': 'NO SMOKING SYMBOL',
    '🚉': 'STATION',
    '🚪': 'DOOR',
    '➳': 'WHITE-FEATHERED RIGHTWARDS ARROW',
    '🚃': 'RAILWAY CAR',
    '┯': 'BOX DRAWINGS DOWN LIGHT AND HORIZONTAL HEAVY',
    '🏬': 'DEPARTMENT STORE',
    '☽': 'FIRST QUARTER MOON',
    '🆙': 'SQUARED UP WITH EXCLAMATION MARK',
    '🆖': 'SQUARED NG',
    '☪': 'STAR AND CRESCENT',
    '┗': 'BOX DRAWINGS HEAVY UP AND RIGHT',
    '🚮': 'PUT LITTER IN ITS PLACE SYMBOL',
    '┫': 'BOX DRAWINGS HEAVY VERTICAL AND LEFT',
    'Ⓞ': 'CIRCLED LATIN CAPITAL LETTER O',
    '❇': 'SPARKLE',
    '✴': 'EIGHT POINTED BLACK STAR',
    '┌': 'BOX DRAWINGS LIGHT DOWN AND RIGHT',
    '☊': 'ASCENDING NODE',
    '🔕': 'BELL WITH CANCELLATION STROKE',
    '⬛': 'BLACK LARGE SQUARE',
    '❝': 'HEAVY DOUBLE TURNED COMMA QUOTATION MARK ORNAMENT',
    '❞': 'HEAVY DOUBLE COMMA QUOTATION MARK ORNAMENT',
    '🚞': 'MOUNTAIN RAILWAY',
    '🍶': 'SAKE BOTTLE AND CUP',
    '🌐': 'GLOBE WITH MERIDIANS',
    '♀': 'FEMALE SIGN',
    '🚅': 'HIGH-SPEED TRAIN WITH BULLET NOSE',
    '🚒': 'FIRE ENGINE',
    '➣': 'THREE-D BOTTOM-LIGHTED RIGHTWARDS ARROWHEAD',
    '♋': 'CANCER',
    '♍': 'VIRGO',
    '🕝': 'CLOCK FACE TWO-THIRTY',
    'ⓐ': 'CIRCLED LATIN SMALL LETTER A',
    '✗': 'BALLOT X',
    '📙': 'ORANGE BOOK',
    'Ⓢ': 'CIRCLED LATIN CAPITAL LETTER S',
    '📋': 'CLIPBOARD',
    '⇢': 'RIGHTWARDS DASHED ARROW',
    '🎱': 'BILLIARDS',
    '🐞': 'LADY BEETLE',
    '🔺': 'UP-POINTING RED TRIANGLE',
    'ⓡ': 'CIRCLED LATIN SMALL LETTER R',
    '🎍': 'PINE DECORATION',
    '♤': 'WHITE SPADE SUIT',
    '🎲': 'GAME DIE',
    '🎯': 'DIRECT HIT',
    '〠': 'POSTAL MARK FACE',
    '🔉': 'SPEAKER WITH ONE SOUND WAVE',
    '↩': 'LEFTWARDS ARROW WITH HOOK',
    '🚾': 'WATER CLOSET',
    '🎣': 'FISHING POLE AND FISH',
    '🔣': 'INPUT SYMBOL FOR SYMBOLS',
    '❎': 'NEGATIVE SQUARED CROSS MARK',
    '➥': 'HEAVY BLACK CURVED DOWNWARDS AND RIGHTWARDS ARROW',
    '🅱': 'NEGATIVE SQUARED LATIN CAPITAL LETTER B',
    '🎌': 'CROSSED FLAGS',
    '◣': 'BLACK LOWER LEFT TRIANGLE',
    '⏬': 'BLACK DOWN-POINTING DOUBLE TRIANGLE',
    '♭': 'MUSIC FLAT SIGN',
    '💠': 'DIAMOND SHAPE WITH A DOT INSIDE',
    'ⓞ': 'CIRCLED LATIN SMALL LETTER O',
    '🔳': 'WHITE SQUARE BUTTON',
    '🏭': 'FACTORY',
    '🔰': 'JAPANESE SYMBOL FOR BEGINNER',
    '🎳': 'BOWLING',
    '☚': 'BLACK LEFT POINTING INDEX',
    '➽': 'HEAVY WEDGE-TAILED RIGHTWARDS ARROW',
    '➫': 'BACK-TILTED SHADOWED WHITE RIGHTWARDS ARROW',
    '➖': 'HEAVY MINUS SIGN',
    '🏮': 'IZAKAYA LANTERN',
    '📛': 'NAME BADGE',
    '꒰': 'YI RADICAL SHY',
    '꒱': 'YI RADICAL VEP',
    '◝': 'UPPER RIGHT QUADRANT CIRCULAR ARC',
    '📑': 'BOOKMARK TABS',
    '🎦': 'CINEMA',
    'ⓧ': 'CIRCLED LATIN SMALL LETTER X',
    '🇨': 'REGIONAL INDICATOR SYMBOL LETTER C',
    '🇳': 'REGIONAL INDICATOR SYMBOL LETTER N',
    '🔟': 'KEYCAP TEN',
    '〓': 'GETA MARK',
    'ⓜ': 'CIRCLED LATIN SMALL LETTER M',
    '➠': 'HEAVY DASHED TRIANGLE-HEADED RIGHTWARDS ARROW',
    '🚆': 'TRAIN',
    '🚠': 'MOUNTAIN CABLEWAY',
    '℅': 'CARE OF',
    '☃': 'SNOWMAN',
    '🚽': 'TOILET',
    '📐': 'TRIANGULAR RULER',
    'ⓝ': 'CIRCLED LATIN SMALL LETTER N',
    '✮': 'HEAVY OUTLINED BLACK STAR',
    '⇦': 'LEFTWARDS WHITE ARROW',
    '👲': 'MAN WITH GUA PI MAO',
    '🚡': 'AERIAL TRAMWAY',
    '🎑': 'MOON VIEWING CEREMONY',
    '🔬': 'MICROSCOPE',
    '➗': 'HEAVY DIVISION SIGN',
    '📈': 'CHART WITH UPWARDS TREND',
    '⌘': 'PLACE OF INTEREST SIGN',
    '⏪': 'BLACK LEFT-POINTING DOUBLE TRIANGLE',
    '╹': 'BOX DRAWINGS HEAVY UP',
    '◎': 'BULLSEYE',
    '🔼': 'UP-POINTING SMALL RED TRIANGLE',
    '꒦': 'YI RADICAL GGUO',
    '📎': 'PAPERCLIP',
    '⑅': 'OCR BOW TIE',
    '⍝': 'APL FUNCTIONAL SYMBOL UP SHOE JOT',
    '📁': 'FILE FOLDER',
    '✭': 'OUTLINED BLACK STAR',
    '➲': 'CIRCLED HEAVY WHITE RIGHTWARDS ARROW',
    '♓': 'PISCES',
    '┏': 'BOX DRAWINGS HEAVY DOWN AND RIGHT',
    '☇': 'LIGHTNING',
    '♺': 'RECYCLING SYMBOL FOR GENERIC MATERIALS',
    '♞': 'BLACK CHESS KNIGHT',
    '࿎': 'TIBETAN SIGN RDEL NAG RDEL DKAR',
    '📠': 'FAX MACHINE',
    '👘': 'KIMONO',
    '↙': 'SOUTH WEST ARROW',
    'Ⓕ': 'CIRCLED LATIN CAPITAL LETTER F',
    'Ⓦ': 'CIRCLED LATIN CAPITAL LETTER W',
    'Ⓟ': 'CIRCLED LATIN CAPITAL LETTER P',
    '🕑': 'CLOCK FACE TWO OCLOCK',
    '💽': 'MINIDISC',
    '🕛': 'CLOCK FACE TWELVE OCLOCK',
    '🎫': 'TICKET',
    '♈': 'ARIES',
    '📟': 'PAGER',
    '℃': 'DEGREE CELSIUS',
    '↬': 'RIGHTWARDS ARROW WITH LOOP',
    '🕒': 'CLOCK FACE THREE OCLOCK',
    '🇰': 'REGIONAL INDICATOR SYMBOL LETTER K',
    '↱': 'UPWARDS ARROW WITH TIP RIGHTWARDS',
    '✍': 'WRITING HAND',
    '⇐': 'LEFTWARDS DOUBLE ARROW',
    '🏦': 'BANK',
    '🔻': 'DOWN-POINTING RED TRIANGLE',
    'ⓟ': 'CIRCLED LATIN SMALL LETTER P',
    'ⓕ': 'CIRCLED LATIN SMALL LETTER F',
    'ⓘ': 'CIRCLED LATIN SMALL LETTER I',
    '♿': 'WHEELCHAIR SYMBOL',
    '⇗': 'NORTH EAST DOUBLE ARROW',
    '⇘': 'SOUTH EAST DOUBLE ARROW',
    'ⓨ': 'CIRCLED LATIN SMALL LETTER Y',
    'ⓙ': 'CIRCLED LATIN SMALL LETTER J',
    '▫': 'WHITE SMALL SQUARE',
    '🔇': 'SPEAKER WITH CANCELLATION STROKE',
    '⌃': 'UP ARROWHEAD',
    '🔖': 'BOOKMARK',
    '📜': 'SCROLL',
    '♏': 'SCORPIUS',
    '🚝': 'MONORAIL',
    '☢': 'RADIOACTIVE SIGN',
    '🎏': 'CARP STREAMER',
    '┘': 'BOX DRAWINGS LIGHT UP AND LEFT',
    '✝': 'LATIN CROSS',
    '❖': 'BLACK DIAMOND MINUS WHITE X',
    '⍣': 'APL FUNCTIONAL SYMBOL STAR DIAERESIS',
    '📮': 'POSTBOX',
    '🕕': 'CLOCK FACE SIX OCLOCK',
    '🇭': 'REGIONAL INDICATOR SYMBOL LETTER H',
    '◜': 'UPPER LEFT QUADRANT CIRCULAR ARC',
    '🔯': 'SIX POINTED STAR WITH MIDDLE DOT',
    '➸': 'HEAVY BLACK-FEATHERED RIGHTWARDS ARROW',
    '꒵': 'YI RADICAL JJY',
    '🕥': 'CLOCK FACE TEN-THIRTY',
    '♙': 'WHITE CHESS PAWN',
    '▿': 'WHITE DOWN-POINTING SMALL TRIANGLE',
    '⚃': 'DIE FACE-4',
    '✽': 'HEAVY TEARDROP-SPOKED ASTERISK',
    '📼': 'VIDEOCASSETTE',
    '🕐': 'CLOCK FACE ONE OCLOCK',
    '🀄': 'MAHJONG TILE RED DRAGON',
    '✾': 'SIX PETALLED BLACK AND WHITE FLORETTE',
    '✬': 'BLACK CENTRE WHITE STAR',
    '🆑': 'SQUARED CL',
    '✫': 'OPEN CENTRE BLACK STAR',
    '🕔': 'CLOCK FACE FIVE OCLOCK',
    '❣': 'HEAVY HEART EXCLAMATION MARK ORNAMENT',
    '➱': 'NOTCHED UPPER RIGHT-SHADOWED WHITE RIGHTWARDS ARROW',
    '🆕': 'SQUARED NEW',
    '➢': 'THREE-D TOP-LIGHTED RIGHTWARDS ARROWHEAD',
    '↕': 'UP DOWN ARROW',
    '📫': 'CLOSED MAILBOX WITH RAISED FLAG',
    '🉐': 'CIRCLED IDEOGRAPH ADVANTAGE',
    '♊': 'GEMINI',
    '🈂': 'SQUARED KATAKANA SA',
    '🎰': 'SLOT MACHINE',
    '҂': 'CYRILLIC THOUSANDS SIGN',
    '╤': 'BOX DRAWINGS DOWN SINGLE AND HORIZONTAL DOUBLE',
    '➛': 'DRAFTING POINT RIGHTWARDS ARROW',
    '♝': 'BLACK CHESS BISHOP',
    '❋': 'HEAVY EIGHT TEARDROP-SPOKED PROPELLER ASTERISK',
    '✆': 'TELEPHONE LOCATION SIGN',
    '📔': 'NOTEBOOK WITH DECORATIVE COVER'
}

emoji2sentiment = {
    '😂': 0.22096840377513335,
    '❤': 0.7460869565217392,
    '♥': 0.6576147816349384,
    '😍': 0.6779367825129737,
    '😭': -0.09337676438653637,
    '😘': 0.7017543859649122,
    '😊': 0.6446955430006277,
    '👌': 0.5637606837606838,
    '💕': 0.6329166666666667,
    '👏': 0.5205479452054794,
    '😁': 0.4499771585198721,
    '☺': 0.6580989330746848,
    '♡': 0.669873417721519,
    '👍': 0.5221143473570659,
    '😩': -0.36836283185840707,
    '🙏': 0.41780376868096164,
    '✌': 0.4641460234680574,
    '😏': 0.3324572930354796,
    '😉': 0.4641683103221565,
    '🙌': 0.5604249667994687,
    '🙈': 0.4326923076923077,
    '💪': 0.5557132718239887,
    '😄': 0.4220314735336195,
    '😒': -0.3747292418772563,
    '💃': 0.7358630952380952,
    '💖': 0.7133808392715756,
    '😃': 0.5580431177446102,
    '😔': -0.14605809128630706,
    '😱': 0.1902654867256637,
    '🎉': 0.7395555555555555,
    '😜': 0.45603864734299515,
    '☯': 0.0010080645161290322,
    '🌸': 0.6522198731501057,
    '💜': 0.6560170394036209,
    '💙': 0.7324561403508771,
    '✨': 0.35259433962264153,
    '😳': 0.01773049645390071,
    '💗': 0.6590909090909091,
    '★': 0.28381642512077293,
    '█': -0.03258145363408521,
    '☀': 0.4669211195928753,
    '😡': -0.17328042328042328,
    '😎': 0.493368700265252,
    '😢': 0.006675567423230975,
    '💋': 0.6934604904632152,
    '😋': 0.6335149863760218,
    '🙊': 0.4606896551724138,
    '😴': -0.0807799442896936,
    '🎶': 0.5392296718972895,
    '💞': 0.74235807860262,
    '😌': 0.4842105263157895,
    '🔥': 0.13978494623655913,
    '💯': 0.12087912087912088,
    '🔫': -0.19536423841059603,
    '💛': 0.7126245847176079,
    '💁': 0.32786885245901637,
    '💚': 0.659217877094972,
    '♫': 0.28893058161350843,
    '😞': -0.11842105263157894,
    '😆': 0.4117647058823529,
    '😝': 0.4254032258064516,
    '😪': -0.08091286307053942,
    '�': 0.08686440677966102,
    '😫': -0.145610278372591,
    '😅': 0.17965367965367965,
    '👊': 0.2292576419213974,
    '💀': -0.20833333333333334,
    '😀': 0.571753986332574,
    '😚': 0.714622641509434,
    '😻': 0.6235011990407674,
    '©': 0.11778846153846154,
    '👀': 0.06341463414634146,
    '💘': 0.6886075949367089,
    '🐓': 0.028645833333333332,
    '☕': 0.24607329842931938,
    '👋': 0.4162303664921466,
    '✋': 0.12698412698412698,
    '🎊': 0.7272727272727273,
    '🍕': 0.42045454545454547,
    '❄': 0.5100286532951289,
    '😥': 0.12316715542521994,
    '😕': -0.4,
    '💥': 0.14893617021276595,
    '💔': -0.12195121951219512,
    '😤': -0.21100917431192662,
    '😈': 0.2676923076923077,
    '►': 0.16307692307692306,
    '✈': 0.4192546583850932,
    '🔝': 0.47854785478547857,
    '😰': -0.019867549668874173,
    '⚽': 0.6220735785953178,
    '😑': -0.31438127090301005,
    '👑': 0.7013422818791947,
    '😹': 0.1423728813559322,
    '👉': 0.3938356164383562,
    '🍃': 0.38144329896907214,
    '🎁': 0.7673611111111112,
    '😠': -0.3020833333333333,
    '🐧': 0.4612676056338028,
    '☆': 0.4326241134751773,
    '🍀': 0.28776978417266186,
    '🎈': 0.7256317689530686,
    '🎅': 0.32116788321167883,
    '😓': -0.08058608058608059,
    '😣': -0.2140221402214022,
    '😐': -0.3925925925925926,
    '✊': 0.43333333333333335,
    '😨': -0.1412639405204461,
    '😖': -0.15671641791044777,
    '💤': 0.37453183520599254,
    '💓': 0.6718146718146718,
    '👎': -0.18992248062015504,
    '💦': 0.47619047619047616,
    '✔': 0.27309236947791166,
    '😷': -0.17073170731707318,
    '⚡': 0.17886178861788618,
    '🙋': 0.4915254237288136,
    '🎄': 0.538135593220339,
    '💩': -0.11790393013100436,
    '🎵': 0.5067264573991032,
    '➡': 0.14864864864864866,
    '😛': 0.6090909090909091,
    '😬': 0.19626168224299065,
    '👯': 0.44549763033175355,
    '💎': 0.569377990430622,
    '🌿': 0.3894230769230769,
    '🎂': 0.6218905472636815,
    '🌟': 0.3316582914572864,
    '🔮': 0.271356783919598,
    '❗': 0.10101010101010101,
    '👫': 0.25888324873096447,
    '🏆': 0.7371134020618557,
    '✖': 0.3160621761658031,
    '☝': 0.31413612565445026,
    '😙': 0.7905759162303665,
    '⛄': 0.5287958115183246,
    '👅': 0.46842105263157896,
    '♪': 0.5421052631578948,
    '🍂': 0.5555555555555556,
    '💏': 0.3945945945945946,
    '🔪': 0.07103825136612021,
    '🌴': 0.5337078651685393,
    '👈': 0.43103448275862066,
    '🌹': 0.6104651162790697,
    '🙆': 0.5087719298245614,
    '➜': 0.16470588235294117,
    '👻': 0.23214285714285715,
    '💰': 0.25595238095238093,
    '🍻': 0.5212121212121212,
    '🙅': -0.20606060606060606,
    '🌞': 0.5679012345679012,
    '🍁': 0.4906832298136646,
    '⭐': 0.5911949685534591,
    '▪': 0.20125786163522014,
    '🎀': 0.6410256410256411,
    '━': 0.1794871794871795,
    '☷': 0.06493506493506493,
    '🐷': 0.375,
    '🙉': 0.34,
    '🌺': 0.56,
    '💅': 0.3959731543624161,
    '🐶': 0.5878378378378378,
    '🌚': 0.47297297297297297,
    '👽': 0.3219178082191781,
    '🎤': 0.4861111111111111,
    '👭': 0.4722222222222222,
    '🎧': 0.4225352112676056,
    '👆': 0.3333333333333333,
    '🍸': 0.5507246376811594,
    '🍷': 0.40145985401459855,
    '®': 0.2846715328467153,
    '🍉': 0.6102941176470589,
    '😇': 0.6,
    '☑': 0.1037037037037037,
    '🏃': 0.4148148148148148,
    '😿': -0.3805970149253731,
    '│': 0.35074626865671643,
    '💣': 0.007633587786259542,
    '🍺': 0.5038167938931297,
    '▶': 0.21374045801526717,
    '😲': -0.06976744186046512,
    '🎸': 0.528,
    '🍹': 0.6747967479674797,
    '💫': 0.512396694214876,
    '📚': 0.3445378151260504,
    '😶': -0.1452991452991453,
    '🌷': 0.5517241379310345,
    '💝': 0.6608695652173913,
    '💨': 0.391304347826087,
    '🏈': 0.543859649122807,
    '💍': 0.49107142857142855,
    '☔': 0.2972972972972973,
    '👸': 0.6216216216216216,
    '🇪': 0.6330275229357798,
    '░': -0.046296296296296294,
    '🍩': 0.3925233644859813,
    '👾': 0.37142857142857144,
    '☁': 0.3173076923076923,
    '🌻': 0.5865384615384616,
    '😵': 0.08737864077669903,
    '📒': 0.0392156862745098,
    '↿': 0.6666666666666666,
    '🐯': 0.49,
    '👼': 0.34,
    '🍔': 0.28,
    '😸': 0.41,
    '👶': 0.43,
    '↾': 0.64,
    '💐': 0.72,
    '🌊': 0.49,
    '🍦': 0.45,
    '🍓': 0.65,
    '👇': 0.24,
    '💆': 0.21,
    '🍴': 0.51,
    '😧': -0.06,
    '🇸': 0.48,
    '😮': 0.25,
    '▓': 0.01,
    '🚫': -0.4,
    '😽': 0.52,
    '🌈': 0.47,
    '🙀': 0.3,
    '⚠': -0.06,
    '🎮': 0.38,
    '╯': -0.01,
    '🍆': 0.35,
    '🍰': 0.39,
    '✓': 0.25,
    '👐': -0.02,
    '🙇': 0.12,
    '🍟': 0.26,
    '🍌': 0.37,
    '💑': 0.56,
    '👬': -0.05,
    '🐣': 0.4,
    '🎃': 0.5,
    '▬': 0.39,
    '￼': -0.4,
    '😟': 0.06,
    '🐾': 0.49,
    '🎓': 0.45,
    '🏊': 0.46,
    '🍫': 0.12,
    '📷': 0.34,
    '👄': 0.37,
    '🌼': 0.6,
    '🚶': -0.11,
    '🐱': 0.39,
    '║': 0.11,
    '🐸': -0.06,
    '🇺': 0.4,
    '👿': -0.39,
    '🚬': 0.38,
    '✿': 0.28,
    '📖': 0.12,
    '🐒': 0.37,
    '🌍': 0.42,
    '┊': 0.68,
    '🐥': 0.41,
    '🌀': 0.07,
    '🐼': 0.18,
    '🎥': 0.2,
    '💄': 0.3,
    '💸': 0.11,
    '⛔': 0.33,
    '●': 0.12,
    '🏀': 0.17,
    '💉': 0.24,
    '💟': 0.45,
    '🚗': 0.15,
    '😯': 0.08,
    '📝': 0.15,
    '═': 0.01,
    '♦': 0.29,
    '💭': 0.13,
    '🌙': 0.36,
    '🐟': 0.42,
    '👣': 0.21,
    '☞': 0.07,
    '✂': -0.28,
    '🗿': 0.27,
    '🍝': 0.07,
    '👪': -0.01,
    '🍭': 0.18,
    '🌃': 0.23,
    '❌': 0.16,
    '🐰': 0.34,
    '💊': 0.25,
    '🚨': 0.37,
    '😦': -0.21,
    '🍪': 0.18,
    '🍣': -0.13,
    '╭': 0.09,
    '✧': 0.18,
    '🎆': 0.39,
    '╮': 0.07,
    '🎎': 0.49,
    '🇩': 0.33,
    '✅': 0.22,
    '👹': 0.03,
    '📱': 0.16,
    '🙍': -0.17,
    '🍑': 0.13,
    '🎼': 0.17,
    '🔊': 0.21,
    '🌌': 0.26,
    '🍎': 0.16,
    '🐻': 0.22,
    '─': 0.07,
    '╰': -0.03,
    '💇': 0.16,
    '♬': 0.12,
    '♚': 0.02,
    '🔴': 0.19,
    '🍱': -0.15,
    '🍊': 0.2,
    '🍒': 0.15,
    '🐭': 0.33,
    '👟': 0.2,
    '🌎': 0.15,
    '🍍': 0.22,
    '🐮': 0.27,
    '📲': 0.11,
    '☼': 0.09,
    '🌅': 0.16,
    '🇷': 0.3,
    '👠': 0.16,
    '🌽': 0.2,
    '💧': -0.07,
    '❓': 0.03,
    '🍬': 0.16,
    '😺': 0.17,
    '🐴': 0.03,
    '🚀': 0.21,
    '¦': 0.25,
    '💢': 0.1,
    '🎬': 0.12,
    '🍧': 0.13,
    '🍜': 0.17,
    '🐏': 0.24,
    '🐘': 0.01,
    '👧': 0.06,
    '⠀': 0.02,
    '🏄': 0.22,
    '➤': 0.13,
    '⬆': 0.12,
    '🍋': 0.1,
    '🆗': 0.22,
    '⚪': 0.18,
    '📺': 0.15,
    '🍅': 0.14,
    '⛅': 0.18,
    '🐢': 0.08,
    '👙': 0.2,
    '🏡': 0.17,
    '🌾': 0.21,
    '◉': 0.1,
    '✏': 0.13,
    '🐬': 0.16,
    '🍤': 0.02,
    '🇹': 0.22,
    '♣': 0.13,
    '🐝': 0.08,
    '🌝': 0.07,
    '🇮': 0.22,
    '🔋': -0.18,
    '🐍': 0.13,
    '♔': 0.2,
    '🍳': 0.01,
    '🔵': 0.11,
    '😾': -0.12,
    '🌕': 0.2,
    '🐨': 0.16,
    '🔐': 0.12,
    '💿': 0.22,
    '❁': 0.02,
    '🌳': 0.17,
    '👰': 0.17,
    '❀': 0.14,
    '⚓': 0.2,
    '🚴': 0.23,
    '▀': -0.05,
    '👗': 0.08,
    '➕': 0.18,
    '💬': 0.12,
    '▒': -0.01,
    '🔜': 0.09,
    '🍨': 0.07,
    '💲': 0.08,
    '⛽': 0.05,
    '🍙': 0.09,
    '🍗': 0.02,
    '🍲': 0.04,
    '🍥': -0.19,
    '▸': 0.07,
    '♛': 0.06,
    '😼': 0.11,
    '🐙': 0.12,
    '👨': 0.16,
    '🍚': 0.14,
    '🍖': 0.04,
    '♨': 0.27,
    '🎹': 0.11,
    '♕': 0.12,
    '▃': 0.28,
    '🚘': 0.02,
    '🍏': 0.02,
    '👩': 0.02,
    '👦': 0.04,
    '🇬': 0.08,
    '🇧': 0.08,
    '☠': -0.01,
    '🐠': 0.12,
    '🚹': 0.2,
    '💵': 0.11,
    '✰': 0.23,
    '╠': 0.06,
    '👛': 0.1,
    '🚙': 0.01,
    '🌱': 0.16,
    '💻': 0.07,
    '🌏': 0.09,
    '▄': -0.02,
    '👓': 0.08,
    '◄': 0.06,
    '⚾': -0.01,
    '🌲': 0.1,
    '👴': 0.06,
    '🏠': 0.13,
    '🍇': 0.07,
    '🍘': 0.1,
    '🍛': 0.01,
    '🐇': 0.06,
    '🔞': -0.01,
    '👵': 0.11,
    '◀': 0.07,
    '🔙': 0.05,
    '🌵': 0.05,
    '🐽': 0.03,
    '🍮': -0.03,
    '🎇': 0.17,
    '🐎': 0.1,
    '➔': -0.03,
    '💶': 0.0,
    '🐤': 0.13,
    '╩': 0.05,
    '🛀': 0.03,
    '🌑': 0.11,
    '🚲': 0.09,
    '🐑': -0.04,
    '🏁': 0.12,
    '🍞': 0.01,
    '🎾': 0.13,
    '╚': 0.07,
    '🈹': 0.07,
    '🐳': 0.03,
    '👮': -0.08,
    '☹': -0.12,
    '🐵': 0.11,
    '✪': 0.07,
    '◕': 0.1,
    '🗼': 0.12,
    '▐': -0.03,
    '♠': 0.07,
    '┳': -0.08,
    '👺': -0.04,
    '🐚': 0.05,
    '👂': -0.03,
    '🗽': 0.07,
    '🍵': 0.08,
    '🆒': 0.08,
    '🍯': 0.01,
    '🐺': 0.05,
    '⇨': 0.1,
    '➨': 0.03,
    '🌓': 0.13,
    '🔒': 0.04,
    '╬': -0.03,
    '👳': 0.13,
    '🌂': 0.05,
    '🚌': 0.04,
    '♩': 0.11,
    '🍡': -0.01,
    '❥': 0.05,
    '🎡': 0.06,
    '💌': 0.1,
    '🐩': 0.07,
    '🌜': 0.1,
    '⌚': 0.04,
    '🚿': 0.12,
    '🐖': 0.03,
    '🔆': 0.11,
    '🌛': 0.11,
    '💂': -0.03,
    '🐔': 0.06,
    '🙎': -0.01,
    '🏩': 0.08,
    '🇫': 0.09,
    '🔨': -0.02,
    '📢': 0.08,
    '🐦': 0.08,
    '🐲': -0.01,
    '♻': 0.09,
    '🌘': 0.11,
    '🍐': 0.03,
    '🌔': 0.11,
    '╥': 0.02,
    '❊': 0.0,
    '👖': 0.06,
    '🚺': 0.03,
    '😗': 0.11,
    '🎭': 0.0,
    '🐄': 0.05,
    '◟': -0.01,
    '🍢': -0.02,
    '🎨': 0.03,
    '⬇': 0.07,
    '🚼': 0.1,
    '⛲': 0.01,
    '▁': 0.0,
    '🇴': 0.06,
    '🌗': 0.11,
    '🌖': 0.11,
    '🔅': 0.15,
    '👜': 0.04,
    '🐌': 0.11,
    '💼': 0.09,
    '🚕': 0.0,
    '🐹': 0.05,
    '🌠': 0.09,
    '🐈': 0.05,
    '⇧': 0.02,
    '☎': 0.0,
    '🌁': 0.03,
    '⚫': 0.04,
    '♧': 0.08,
    '🏰': 0.05,
    '🚵': 0.06,
    '🎢': 0.08,
    '🎷': 0.11,
    '🎐': 0.03,
    '┈': -0.1,
    '╗': 0.06,
    '╱': 0.0,
    '🌇': 0.08,
    '⏰': 0.07,
    '⇩': 0.0,
    '🚂': 0.04,
    '◠': 0.07,
    '🎿': 0.06,
    '✦': 0.01,
    '🆔': 0.12,
    '⛪': 0.02,
    '🌒': 0.09,
    '🐪': 0.09,
    '╔': 0.04,
    '╝': 0.07,
    '👔': 0.05,
    '🔱': 0.01,
    '🆓': 0.03,
    '🐋': 0.03,
    '▽': 0.06,
    '▂': 0.0,
    '🐛': 0.04,
    '👕': 0.06,
    '🚋': 0.01,
    '💳': 0.06,
    '🌆': 0.02,
    '🏧': 0.12,
    '💡': 0.09,
    '🔹': 0.02,
    '⬅': 0.07,
    '🍠': 0.0,
    '🐫': 0.05,
    '🏪': 0.01,
    '۩': 0.0,
    '🇱': 0.06,
    '📹': 0.06,
    '👞': 0.06,
    '🚑': 0.01,
    '🆘': 0.01,
    '👚': 0.08,
    '🚍': 0.01,
    '□': -0.03,
    '🐂': 0.02,
    '🚣': 0.08,
    '✳': 0.0,
    '🏉': 0.07,
    '🗻': 0.08,
    '🐀': 0.02,
    '╦': 0.05,
    '⛺': 0.06,
    '🐕': 0.03,
    '🏂': 0.05,
    '👡': 0.05,
    '📻': 0.04,
    '✒': 0.03,
    '🌰': 0.07,
    '🏢': 0.02,
    '🎒': 0.06,
    '⌒': 0.07,
    '🏫': -0.03,
    '📴': 0.08,
    '🚢': 0.03,
    '🚚': -0.01,
    '🐉': 0.02,
    '❒': 0.03,
    '🐊': 0.01,
    '🔔': 0.1,
    '◢': 0.08,
    '🏥': 0.03,
    '❔': 0.0,
    '🚖': -0.01,
    '🃏': 0.01,
    '▼': 0.01,
    '▌': -0.03,
    '☛': 0.04,
    '✩': 0.0,
    '💒': 0.06,
    '🚤': 0.04,
    '🐐': 0.05,
    '■': -0.03,
    '🔚': 0.04,
    '🎻': 0.04,
    '🔷': 0.02,
    '🚦': 0.01,
    '🔓': 0.01,
    '🎽': 0.05,
    '📅': 0.02,
    '🎺': 0.07,
    '✯': 0.0,
    '🍈': -0.04,
    '✉': 0.03,
    '╣': 0.0,
    '◤': 0.09,
    '○': 0.05,
    '🍼': 0.05,
    '📀': 0.01,
    '🚛': -0.02,
    '📓': 0.02,
    '☉': 0.02,
    '💴': -0.02,
    '┼': 0.0,
    '🐃': 0.0,
    '➰': -0.01,
    '🔌': -0.01,
    '🍄': 0.0,
    '📕': 0.02,
    '📣': 0.04,
    '🚓': 0.03,
    '🐗': 0.05,
    '↪': 0.01,
    '⛳': 0.07,
    '┻': -0.04,
    '┛': 0.06,
    '┃': 0.04,
    '👱': 0.01,
    '⏳': 0.0,
    '💺': 0.02,
    '🏇': -0.01,
    '☻': 0.02,
    '📞': 0.04,
    'Ⓐ': -0.01,
    '🌉': 0.05,
    '🚩': -0.02,
    '✎': 0.05,
    '📃': 0.04,
    '🏨': 0.02,
    '📌': -0.04,
    '♎': -0.01,
    '💷': 0.04,
    '🚄': 0.05,
    '▲': 0.05,
    '⛵': 0.05,
    '🔸': 0.02,
    '⌛': 0.01,
    '🚜': 0.07,
    '🐆': 0.03,
    '👒': 0.02,
    '❕': 0.02,
    '🔛': 0.04,
    '♢': 0.03,
    '🇲': 0.04,
    '❅': 0.06,
    '👝': 0.03,
    '✞': 0.03,
    '◡': 0.02,
    '🎋': 0.04,
    '👥': 0.02,
    '📵': 0.01,
    '🐡': 0.02,
    '◆': 0.05,
    '🏯': 0.01,
    '☂': 0.0,
    '🔭': 0.03,
    '🎪': 0.02,
    '🐜': 0.04,
    '♌': 0.05,
    '☐': -0.06,
    '👷': 0.02,
    '↳': 0.0,
    '🔈': 0.02,
    '📄': 0.06,
    '📍': 0.01,
    '🚐': 0.05,
    '🚔': 0.0,
    '🌋': 0.04,
    '📡': 0.02,
    '⏩': 0.01,
    '🚳': 0.06,
    '✘': 0.05,
    '۞': 0.0,
    '☾': 0.0,
    '🅰': 0.02,
    '📥': 0.0,
    '🇼': 0.03,
    '┓': 0.04,
    '┣': 0.04,
    'Ⓛ': 0.03,
    'Ⓔ': 0.03,
    '🔦': 0.0,
    '👤': 0.04,
    '🚁': 0.01,
    '🎠': 0.03,
    '🐁': -0.02,
    '📗': 0.01,
    '┐': -0.01,
    '☮': 0.0,
    '♂': 0.01,
    '◞': 0.0,
    '📯': -0.01,
    '🔩': 0.01,
    '👢': 0.04,
    '◂': 0.02,
    '📰': 0.02,
    '📶': 0.02,
    '🚥': 0.0,
    '🌄': 0.01,
    '🗾': 0.02,
    '🔶': 0.02,
    '🏤': 0.02,
    '🎩': 0.02,
    'Ⓜ': 0.02,
    '🔧': -0.03,
    '🐅': 0.01,
    '♮': 0.01,
    '🅾': -0.01,
    '🔄': 0.0,
    '☄': 0.0,
    '☨': 0.0,
    '📦': 0.01,
    '🚊': 0.01,
    '🔲': 0.03,
    '🔁': 0.0,
    '△': 0.01,
    '📆': 0.04,
    '❛': 0.02,
    '📉': 0.02,
    '▵': 0.02,
    '🔎': 0.03,
    '☜': 0.01,
    '🇯': 0.02,
    '🇵': 0.02,
    '📘': 0.01,
    '✡': 0.0,
    'ⓔ': 0.03,
    '🔑': 0.01,
    '🔃': 0.0,
    '👃': 0.0,
    '⭕': 0.02,
    '🔘': 0.01,
    'ⓒ': 0.0,
    '🚭': 0.04,
    '🚉': 0.03,
    '🚪': 0.03,
    '➳': 0.02,
    '🚃': 0.03,
    '┯': -0.02,
    '🏬': 0.0,
    '☽': 0.0,
    '🆙': 0.02,
    '🆖': 0.01,
    '☪': 0.0,
    '┗': 0.04,
    '🚮': 0.0,
    '┫': 0.0,
    'Ⓞ': 0.02,
    '❇': 0.02,
    '✴': 0.02,
    '┌': 0.0,
    '☊': 0.03,
    '🔕': -0.01,
    '⬛': -0.01,
    '❝': 0.0,
    '❞': 0.0,
    '🚞': 0.02,
    '🍶': 0.02,
    '🌐': 0.02,
    '♀': 0.01,
    '🚅': 0.02,
    '🚒': -0.01,
    '➣': 0.0,
    '♋': 0.01,
    '♍': 0.02,
    '🕝': -0.01,
    'ⓐ': 0.03,
    '✗': 0.0,
    '📙': 0.01,
    'Ⓢ': 0.01,
    '📋': 0.02,
    '⇢': 0.0,
    '🎱': 0.01,
    '🐞': 0.01,
    '🔺': 0.01,
    'ⓡ': 0.03,
    '🎍': 0.0,
    '♤': 0.02,
    '🎲': 0.0,
    '🎯': 0.02,
    '〠': 0.0,
    '🔉': 0.02,
    '↩': 0.03,
    '🚾': 0.01,
    '🎣': -0.02,
    '🔣': 0.01,
    '❎': -0.03,
    '➥': 0.01,
    '🅱': 0.0,
    '🎌': 0.03,
    '◣': 0.01,
    '⏬': 0.03,
    '♭': 0.01,
    '💠': 0.0,
    'ⓞ': 0.02,
    '🔳': 0.01,
    '🏭': 0.01,
    '🔰': 0.0,
    '🎳': -0.01,
    '☚': 0.02,
    '➽': 0.01,
    '➫': 0.01,
    '➖': -0.02,
    '🏮': 0.0,
    '📛': 0.0,
    '꒰': 0.01,
    '꒱': 0.01,
    '◝': -0.01,
    '📑': 0.02,
    '🎦': 0.0,
    'ⓧ': 0.02,
    '🇨': 0.0,
    '🇳': 0.0,
    '🔟': 0.02,
    '〓': 0.02,
    'ⓜ': 0.01,
    '➠': 0.02,
    '🚆': 0.01,
    '🚠': 0.0,
    '℅': -0.02,
    '☃': 0.01,
    '🚽': 0.02,
    '📐': 0.0,
    'ⓝ': 0.02,
    '✮': 0.0,
    '⇦': 0.02,
    '👲': 0.01,
    '🚡': -0.01,
    '🎑': 0.0,
    '🔬': 0.02,
    '➗': -0.01,
    '📈': 0.01,
    '⌘': 0.0,
    '⏪': 0.01,
    '╹': 0.0,
    '◎': 0.02,
    '🔼': 0.0,
    '꒦': -0.02,
    '📎': 0.02,
    '⑅': 0.02,
    '⍝': 0.0,
    '📁': 0.0,
    '✭': 0.02,
    '➲': 0.0,
    '♓': 0.01,
    '┏': 0.02,
    '☇': 0.02,
    '♺': 0.0,
    '♞': 0.0,
    '࿎': -0.02,
    '📠': 0.0,
    '👘': 0.02,
    '↙': 0.02,
    'Ⓕ': 0.01,
    'Ⓦ': 0.01,
    'Ⓟ': 0.01,
    '🕑': 0.01,
    '💽': 0.0,
    '🕛': 0.01,
    '🎫': 0.0,
    '♈': -0.01,
    '📟': 0.0,
    '℃': 0.0,
    '↬': 0.01,
    '🕒': 0.0,
    '🇰': 0.0,
    '↱': 0.0,
    '✍': 0.01,
    '⇐': 0.0,
    '🏦': 0.01,
    '🔻': 0.01,
    'ⓟ': 0.01,
    'ⓕ': 0.01,
    'ⓘ': 0.01,
    '♿': 0.01,
    '⇗': 0.01,
    '⇘': 0.01,
    'ⓨ': 0.01,
    'ⓙ': 0.01,
    '▫': 0.01,
    '🔇': 0.01,
    '⌃': -0.01,
    '🔖': 0.01,
    '📜': 0.01,
    '♏': 0.0,
    '🚝': 0.01,
    '☢': 0.0,
    '🎏': 0.0,
    '┘': -0.01,
    '✝': -0.01,
    '❖': 0.0,
    '⍣': -0.01,
    '📮': -0.01,
    '🕕': -0.01,
    '🇭': 0.0,
    '◜': 0.0,
    '🔯': 0.01,
    '➸': 0.01,
    '꒵': 0.01,
    '🕥': -0.01,
    '♙': 0.0,
    '▿': 0.0,
    '⚃': 0.0,
    '✽': 0.01,
    '📼': 0.01,
    '🕐': -0.01,
    '🀄': 0.01,
    '✾': 0.0,
    '✬': 0.01,
    '🆑': 0.0,
    '✫': 0.01,
    '🕔': -0.01,
    '❣': 0.01,
    '➱': 0.0,
    '🆕': 0.0,
    '➢': 0.0,
    '↕': 0.0,
    '📫': 0.01,
    '🉐': 0.01,
    '♊': 0.0,
    '🈂': -0.01,
    '🎰': -0.01,
    '҂': -0.01,
    '╤': -0.01,
    '➛': 0.0,
    '♝': 0.0,
    '❋': 0.0,
    '✆': 0.0,
    '📔': 0.01
}