# usbserial4a
[![PayPal Donate][paypal_img]][paypal_link]
[![PyPI version][pypi_img]][pypi_link]
[![Downloads][downloads_img]][downloads_link]

  [paypal_img]: https://github.com/jacklinquan/images/blob/master/paypal_donate_badge.svg
  [paypal_link]: https://www.paypal.me/jacklinquan
  [pypi_img]: https://badge.fury.io/py/usbserial4a.svg
  [pypi_link]: https://badge.fury.io/py/usbserial4a
  [downloads_img]: https://pepy.tech/badge/usbserial4a
  [downloads_link]: https://pepy.tech/project/usbserial4a

Python package for Kivy Android USB serial port.

Please try the Android App built with usbserial4a on Google Play: [PyTool USB Serial F](https://play.google.com/store/apps/details?id=com.quanlin.pytoolusbserialfree), [PyTool Modbus Free](https://play.google.com/store/apps/details?id=com.quanlin.pytoolmodbusfree).

Implemented drivers are listed below:
* FTDI serial driver - done and tested with FT230X.
* CDC ACM serial driver - done and tested with MCP2200, BBC micro:bit V1(nRF51).
* CP210x serial driver - done and tested with CP2102.
* CH34x serial driver - done and tested with CH340.
* PL2303 serial driver - done and tested with PL2303.

## How to use it:
**To make quick prototype or to test and debug the script before building an App:**

It works on Android 6.0+.

If there is any usb serial device, connect it to the Android phone/tablet through USB OTG cable (It's needed for Android USB host function). 

Get Pydroid Apps from [here](https://github.com/jacklinquan/Pydroid_Apks), or get the latest versions on [Google Play](https://play.google.com/store/apps).

In Pydroid, go to `Menu->Pip` and install `usbserial4a`.

Or go to `Menu->Terminal` and enter `pip install usbserial4a`.

Save `example.py` in the storage of the Android device. 

Open `example.py` and run it. When it runs for the first time, it might prompt you for permission to access the USB device. Accept the permission and run this script again, then it should send the data `b'Hello world!'` as expected.

Go to `Menu->Graphical program output`.

Scroll to the last line, it should list all the USB devices connected to the Android phone/tablet with vendor id, vendor name, product id and product name.

**To build dedicated Apps with buildozer:**

(*These instructions are outdated and need update.*)

It works on Android 4.0+.

In `buildozer.spec` add `termios.so` to the whitelist.

Include `usb4a` and `usbserial4a` in requirements.

Add `intent-filter.xml`.

```
# (list) python-for-android whitelist
android.p4a_whitelist = lib-dynload/termios.so

# (list) Application requirements
# comma seperated e.g. requirements = sqlite3,kivy
requirements = kivy, pyjnius, usb4a, usbserial4a

# (str) XML file to include as an intent filters in <activity> tag
android.manifest.intent_filters = intent-filter.xml 
```

Build the project for the first time and it will fail with an error as expected.

`buildozer android debug`

In the generated  `.buildozer` folder find a `res` folder like this one:

`.buildozer/android/platform/build/dists/YOU_PROJECT_NAME/src/main/res`

Create a `xml` folder in `res` folder.

Add `device_filter.xml` to this `res/xml/` folder.

Find a manifest template file like this one:

`.buildozer/android/platform/build/dists/YOUR_PROJECT_NAME/templates/AndroidManifest.tmpl.xml`

Add  `<uses-feature android:name="android.hardware.usb.host" />`  to this `AndroidManifest.tmpl.xml` at a good position.

Build the project again and it should pass.
