# jupyter-flex: Dashboards for Jupyter

[![pypi](https://badge.fury.io/py/jupyter-flex.svg)](https://pypi.org/project/jupyter-flex/)
[![build](https://github.com/danielfrg/jupyter-flex/workflows/test/badge.svg)](https://github.com/danielfrg/jupyter-flex/actions/workflows/test.yml)
[![docs](https://github.com/danielfrg/jupyter-flex/workflows/docs/badge.svg)](https://github.com/danielfrg/jupyter-flex/actions/workflows/docs.yml)
[![coverage](https://codecov.io/gh/danielfrg/jupyter-flex/branch/master/graph/badge.svg)](https://codecov.io/gh/danielfrg/jupyter-flex?branch=master)
[![license](https://img.shields.io/:license-Apache%202-blue.svg)](https://github.com/danielfrg/jupyter-flex/blob/master/LICENSE.txt)
[![binder](https://mybinder.org/badge_logo.svg)](https://mybinder.org/v2/gh/danielfrg/jupyter-flex/0.7.1?urlpath=voila%2Ftree%2Fexamples)

Build dashboard using Jupyter Notebooks.

- Use Markdown headers and Jupyter Notebook cell tags to define the dashboard layout and its components
- Flexible and easy way to specify row and column based layouts
- Use [nbconvert](https://nbconvert.readthedocs.io/en/latest/) to create static reports
- Use [Voila](https://github.com/voila-dashboards/voila) to start a live Jupyter Kernel for fully dynamic applications
- Support for [Jupyter widgets](https://ipywidgets.readthedocs.io/en/latest/)

<a href="https://mybinder.org/v2/gh/danielfrg/jupyter-flex/0.7.1?urlpath=%2Fvoila%2Frender%2Fexamples%2Fmovie-explorer.ipynb"><img src="https://jupyter-flex.danielfrg.com/assets/img/screenshots/movie-explorer.png" alt="Jupyter-flex: Movie Explorer"  width=276></a>
<a href="https://jupyter-flex.danielfrg.com/examples/nba-scoring.html"><img src="https://jupyter-flex.danielfrg.com/assets/img/screenshots/nba-scoring.png" alt="Jupyter-flex: NBA Scoring" width=276></a>
<a href="https://jupyter-flex.danielfrg.com/examples/altair.html"><img src="https://jupyter-flex.danielfrg.com/assets/img/screenshots/plots/altair.png" alt="Jupyter-flex: Bokeh plots"  width=276></a>

## Installation

```
pip install jupyter-flex
```

## Learning More

Learn more in the [jupyter-flex documentation](https://jupyter-flex.danielfrg.com).

## How to Contribute

See [CONTRIBUTING.md](https://github.com/danielfrg/jupyter-flex/blob/master/CONTRIBUTING.md).
