# coding: utf-8

"""
    Streams Api

    API that provides access to Moralis Streams  # noqa: E501

    OpenAPI spec version: 1.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class StreamsModel(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'webhook_url': 'str',
        'description': 'str',
        'tag': 'str',
        'topic0': 'list[str]',
        'all_addresses': 'bool',
        'include_native_txs': 'bool',
        'include_contract_logs': 'bool',
        'include_internal_txs': 'bool',
        'abi': 'list[AbiItem]',
        'advanced_options': 'list[AdvancedOptions]',
        'chain_ids': 'list[str]',
        'id': 'str',
        'status': 'StreamsStatus',
        'status_message': 'str'
    }

    attribute_map = {
        'webhook_url': 'webhookUrl',
        'description': 'description',
        'tag': 'tag',
        'topic0': 'topic0',
        'all_addresses': 'allAddresses',
        'include_native_txs': 'includeNativeTxs',
        'include_contract_logs': 'includeContractLogs',
        'include_internal_txs': 'includeInternalTxs',
        'abi': 'abi',
        'advanced_options': 'advancedOptions',
        'chain_ids': 'chainIds',
        'id': 'id',
        'status': 'status',
        'status_message': 'statusMessage'
    }

    def __init__(self, webhook_url=None, description=None, tag=None, topic0=None, all_addresses=None, include_native_txs=None, include_contract_logs=None, include_internal_txs=None, abi=None, advanced_options=None, chain_ids=None, id=None, status=None, status_message=None):  # noqa: E501
        """StreamsModel - a model defined in Swagger"""  # noqa: E501
        self._webhook_url = None
        self._description = None
        self._tag = None
        self._topic0 = None
        self._all_addresses = None
        self._include_native_txs = None
        self._include_contract_logs = None
        self._include_internal_txs = None
        self._abi = None
        self._advanced_options = None
        self._chain_ids = None
        self._id = None
        self._status = None
        self._status_message = None
        self.discriminator = None
        self.webhook_url = webhook_url
        self.description = description
        self.tag = tag
        if topic0 is not None:
            self.topic0 = topic0
        if all_addresses is not None:
            self.all_addresses = all_addresses
        if include_native_txs is not None:
            self.include_native_txs = include_native_txs
        if include_contract_logs is not None:
            self.include_contract_logs = include_contract_logs
        if include_internal_txs is not None:
            self.include_internal_txs = include_internal_txs
        if abi is not None:
            self.abi = abi
        if advanced_options is not None:
            self.advanced_options = advanced_options
        self.chain_ids = chain_ids
        self.id = id
        self.status = status
        self.status_message = status_message

    @property
    def webhook_url(self):
        """Gets the webhook_url of this StreamsModel.  # noqa: E501

        Webhook URL where moralis will send the POST request.  # noqa: E501

        :return: The webhook_url of this StreamsModel.  # noqa: E501
        :rtype: str
        """
        return self._webhook_url

    @webhook_url.setter
    def webhook_url(self, webhook_url):
        """Sets the webhook_url of this StreamsModel.

        Webhook URL where moralis will send the POST request.  # noqa: E501

        :param webhook_url: The webhook_url of this StreamsModel.  # noqa: E501
        :type: str
        """
        if webhook_url is None:
            raise ValueError("Invalid value for `webhook_url`, must not be `None`")  # noqa: E501

        self._webhook_url = webhook_url

    @property
    def description(self):
        """Gets the description of this StreamsModel.  # noqa: E501

        A description for this stream  # noqa: E501

        :return: The description of this StreamsModel.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this StreamsModel.

        A description for this stream  # noqa: E501

        :param description: The description of this StreamsModel.  # noqa: E501
        :type: str
        """
        if description is None:
            raise ValueError("Invalid value for `description`, must not be `None`")  # noqa: E501

        self._description = description

    @property
    def tag(self):
        """Gets the tag of this StreamsModel.  # noqa: E501

        A user-provided tag that will be send along the webhook, the user can use this tag to identify the specific stream if multiple streams are present  # noqa: E501

        :return: The tag of this StreamsModel.  # noqa: E501
        :rtype: str
        """
        return self._tag

    @tag.setter
    def tag(self, tag):
        """Sets the tag of this StreamsModel.

        A user-provided tag that will be send along the webhook, the user can use this tag to identify the specific stream if multiple streams are present  # noqa: E501

        :param tag: The tag of this StreamsModel.  # noqa: E501
        :type: str
        """
        if tag is None:
            raise ValueError("Invalid value for `tag`, must not be `None`")  # noqa: E501

        self._tag = tag

    @property
    def topic0(self):
        """Gets the topic0 of this StreamsModel.  # noqa: E501

        An Array of topic0's in hex, required if the type : log  # noqa: E501

        :return: The topic0 of this StreamsModel.  # noqa: E501
        :rtype: list[str]
        """
        return self._topic0

    @topic0.setter
    def topic0(self, topic0):
        """Sets the topic0 of this StreamsModel.

        An Array of topic0's in hex, required if the type : log  # noqa: E501

        :param topic0: The topic0 of this StreamsModel.  # noqa: E501
        :type: list[str]
        """

        self._topic0 = topic0

    @property
    def all_addresses(self):
        """Gets the all_addresses of this StreamsModel.  # noqa: E501

        Include events for all addresses (only applied when abi and topic0 is provided)  # noqa: E501

        :return: The all_addresses of this StreamsModel.  # noqa: E501
        :rtype: bool
        """
        return self._all_addresses

    @all_addresses.setter
    def all_addresses(self, all_addresses):
        """Sets the all_addresses of this StreamsModel.

        Include events for all addresses (only applied when abi and topic0 is provided)  # noqa: E501

        :param all_addresses: The all_addresses of this StreamsModel.  # noqa: E501
        :type: bool
        """

        self._all_addresses = all_addresses

    @property
    def include_native_txs(self):
        """Gets the include_native_txs of this StreamsModel.  # noqa: E501

        Include or not native transactions defaults to false (only applied when type:contract)  # noqa: E501

        :return: The include_native_txs of this StreamsModel.  # noqa: E501
        :rtype: bool
        """
        return self._include_native_txs

    @include_native_txs.setter
    def include_native_txs(self, include_native_txs):
        """Sets the include_native_txs of this StreamsModel.

        Include or not native transactions defaults to false (only applied when type:contract)  # noqa: E501

        :param include_native_txs: The include_native_txs of this StreamsModel.  # noqa: E501
        :type: bool
        """

        self._include_native_txs = include_native_txs

    @property
    def include_contract_logs(self):
        """Gets the include_contract_logs of this StreamsModel.  # noqa: E501

        Include or not logs of contract interactions defaults to false  # noqa: E501

        :return: The include_contract_logs of this StreamsModel.  # noqa: E501
        :rtype: bool
        """
        return self._include_contract_logs

    @include_contract_logs.setter
    def include_contract_logs(self, include_contract_logs):
        """Sets the include_contract_logs of this StreamsModel.

        Include or not logs of contract interactions defaults to false  # noqa: E501

        :param include_contract_logs: The include_contract_logs of this StreamsModel.  # noqa: E501
        :type: bool
        """

        self._include_contract_logs = include_contract_logs

    @property
    def include_internal_txs(self):
        """Gets the include_internal_txs of this StreamsModel.  # noqa: E501

        Include or not include internal transactions defaults to false  # noqa: E501

        :return: The include_internal_txs of this StreamsModel.  # noqa: E501
        :rtype: bool
        """
        return self._include_internal_txs

    @include_internal_txs.setter
    def include_internal_txs(self, include_internal_txs):
        """Sets the include_internal_txs of this StreamsModel.

        Include or not include internal transactions defaults to false  # noqa: E501

        :param include_internal_txs: The include_internal_txs of this StreamsModel.  # noqa: E501
        :type: bool
        """

        self._include_internal_txs = include_internal_txs

    @property
    def abi(self):
        """Gets the abi of this StreamsModel.  # noqa: E501


        :return: The abi of this StreamsModel.  # noqa: E501
        :rtype: list[AbiItem]
        """
        return self._abi

    @abi.setter
    def abi(self, abi):
        """Sets the abi of this StreamsModel.


        :param abi: The abi of this StreamsModel.  # noqa: E501
        :type: list[AbiItem]
        """

        self._abi = abi

    @property
    def advanced_options(self):
        """Gets the advanced_options of this StreamsModel.  # noqa: E501


        :return: The advanced_options of this StreamsModel.  # noqa: E501
        :rtype: list[AdvancedOptions]
        """
        return self._advanced_options

    @advanced_options.setter
    def advanced_options(self, advanced_options):
        """Sets the advanced_options of this StreamsModel.


        :param advanced_options: The advanced_options of this StreamsModel.  # noqa: E501
        :type: list[AdvancedOptions]
        """

        self._advanced_options = advanced_options

    @property
    def chain_ids(self):
        """Gets the chain_ids of this StreamsModel.  # noqa: E501

        The ids of the chains for this stream in hex Ex: [\"0x1\",\"0x38\"]  # noqa: E501

        :return: The chain_ids of this StreamsModel.  # noqa: E501
        :rtype: list[str]
        """
        return self._chain_ids

    @chain_ids.setter
    def chain_ids(self, chain_ids):
        """Sets the chain_ids of this StreamsModel.

        The ids of the chains for this stream in hex Ex: [\"0x1\",\"0x38\"]  # noqa: E501

        :param chain_ids: The chain_ids of this StreamsModel.  # noqa: E501
        :type: list[str]
        """
        if chain_ids is None:
            raise ValueError("Invalid value for `chain_ids`, must not be `None`")  # noqa: E501

        self._chain_ids = chain_ids

    @property
    def id(self):
        """Gets the id of this StreamsModel.  # noqa: E501


        :return: The id of this StreamsModel.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this StreamsModel.


        :param id: The id of this StreamsModel.  # noqa: E501
        :type: str
        """
        if id is None:
            raise ValueError("Invalid value for `id`, must not be `None`")  # noqa: E501

        self._id = id

    @property
    def status(self):
        """Gets the status of this StreamsModel.  # noqa: E501


        :return: The status of this StreamsModel.  # noqa: E501
        :rtype: StreamsStatus
        """
        return self._status

    @status.setter
    def status(self, status):
        """Sets the status of this StreamsModel.


        :param status: The status of this StreamsModel.  # noqa: E501
        :type: StreamsStatus
        """
        if status is None:
            raise ValueError("Invalid value for `status`, must not be `None`")  # noqa: E501

        self._status = status

    @property
    def status_message(self):
        """Gets the status_message of this StreamsModel.  # noqa: E501

        Description of current status of stream.  # noqa: E501

        :return: The status_message of this StreamsModel.  # noqa: E501
        :rtype: str
        """
        return self._status_message

    @status_message.setter
    def status_message(self, status_message):
        """Sets the status_message of this StreamsModel.

        Description of current status of stream.  # noqa: E501

        :param status_message: The status_message of this StreamsModel.  # noqa: E501
        :type: str
        """
        if status_message is None:
            raise ValueError("Invalid value for `status_message`, must not be `None`")  # noqa: E501

        self._status_message = status_message

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(StreamsModel, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, StreamsModel):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
