// Generated by [Toolkit-Py](https://github.com/fujiawei-dev/toolkit-py) Generator
// Created at 2022-02-24 22:39:29.995640, Version 0.7.0

package command

import (
	"os"
	"syscall"

	"github.com/sevlyar/go-daemon"

	"{{ main_module }}/internal/config"
	"{{ main_module }}/internal/event"
	"{{ main_module }}/pkg/fs"
)

var (
	log  = event.Logger()
	conf = config.Conf()
)

// childAlreadyRunning tests if a .pid file at filePath is a running process.
// it returns the pid value and the running status (true or false).
func childAlreadyRunning(filePath string) (pid int, running bool) {
	if !fs.Exists(filePath) {
		return pid, false
	}

	pid, err := daemon.ReadPidFile(filePath)
	if err != nil {
		return pid, false
	}

	process, err := os.FindProcess(pid)
	if err != nil {
		return pid, false
	}

	return pid, process.Signal(syscall.Signal(0)) == nil
}
