# AUTOGENERATED! DO NOT EDIT! File to edit: nbs/01_widgets.ipynb (unless otherwise specified).

__all__ = ['Widget', 'Output', 'IntSlider', 'FloatSlider', 'IntProgress', 'BoundedIntText', 'BoundedFloatText',
           'IntText', 'FloatText', 'ToggleButtons', 'Checkbox', 'Dropdown', 'RadioButtons', 'Select', 'Text',
           'Textarea', 'Label', 'HTML', 'HTMLMath', 'Image', 'Button', 'ColorPicker', 'Layout', 'HBox', 'AlignedLabel',
           'IntLabel', 'Grid']

# Cell
from fastcore.test import test_eq
from collections import namedtuple
import traitlets
from traitlets import Type, Unicode, observe, validate, Any, HasTraits, directional_link, link, Tuple, List, Int
from IPython.display import display, HTML

# Cell
from .items import ItemList, ItemArray, Item

# Cell
import ipywidgets as ipyw

# Cell
class Widget(ipyw.Widget, Item):
    def __init__(self, name=None, **kwargs):
        if name:
            self.name = name
            self.add_class(name)
        super().__init__(**kwargs)

    def visible(self):
        self.layout.visibility = 'visible'

    def invisible(self):
        self.layout.visibility = 'hidden'

    def hide(self):
        self.layout.display = 'inline'

    def show(self):
        self.layout.display = 'none'

# Cell
class Output(Widget, ipyw.Output):
    pass

class IntSlider(Widget, ipyw.IntSlider):
    pass

class FloatSlider(Widget, ipyw.FloatSlider):
    pass

class IntProgress(Widget, ipyw.IntProgress):
    pass

class BoundedIntText(Widget, ipyw.BoundedIntText):
    pass

class BoundedFloatText(Widget, ipyw.BoundedFloatText):
    pass

class IntText(Widget, ipyw.IntText):
    pass

class FloatText(Widget, ipyw.FloatText):
    pass

class ToggleButtons(Widget, ipyw.ToggleButtons):
    pass

class Checkbox(Widget, ipyw.Checkbox):
    pass

class Dropdown(Widget, ipyw.Dropdown):
    pass

class RadioButtons(Widget, ipyw.RadioButtons):
    pass

class Select(Widget, ipyw.Select):
    pass

class Text(Widget, ipyw.Text):
    pass

class Textarea(Widget, ipyw.Textarea):
    pass

class Label(Widget, ipyw.Label):
    pass

class HTML(Widget, ipyw.HTML):
    pass

class HTMLMath(Widget, ipyw.HTMLMath):
    pass

class Image(Widget, ipyw.Image):
    pass

class Button(Widget, ipyw.Button):
    pass

class ColorPicker(Widget, ipyw.ColorPicker):
    pass

class Layout(Widget, ipyw.Layout):
    pass

class HBox(Widget, ipyw.HBox):
    pass

# Cell
class AlignedLabel(Widget, ipyw.VBox):

    value = Unicode()

    def __init__(self, value=None, alignment='center', **kwargs):
        super().__init__(**kwargs)
        if value:
            self.value = value
        if alignment == 'left':
            justify_content = 'flex-start'
        elif alignment == 'right':
            justify_content = 'flex-end'
        else:
            justify_content = 'center'

        # create and add label
        self.label = Label(str(value), layout=ipyw.Layout(display='flex', justify_content=justify_content))
        self.children = (self.label, )

        self.link_to_label()

    def link_to_label(self):
        traitlets.link((self, 'value'), (self.label, 'value'))

# Cell
class IntLabel(AlignedLabel):

    value = Int(0)
    string = Unicode('0')

    @observe('value')
    def _observe_value(self, change):
        self.string = str(change['new'])
        return change['new']

    def link_to_label(self):
        traitlets.link((self, 'string'), (self.label, 'value'))

# Cell
class Grid(ipyw.GridspecLayout, Widget):

    def __init__(self, n_rows, n_columns, **kwargs):
        super().__init__(n_rows, n_columns, **kwargs)
        self._collections = {}

    def __getitem__(self, key):
        if isinstance(key, str):
            return self._collections[key]
        else:
            return super().__getitem__(key)

    def add_widget_array(self, widget_array, i=0, j=0, name=None):
        if name:
            widget_list.name = name
        for l in range(widget_array.n_rows):
            for m in range(widget_array.n_columns):
                self[i+l, j+m] = widget_array[l, m]

    def add_widget_list(self, widget_list, i=0, j=0, direction='row', name=None):
        if name:
            widget_list.name = name
        if hasattr(widget_list, '_size'):
            size = widget_list._size
        else:
            size = len(widget_list)
        for l in range(size):
            if direction == 'col':
                self[i+l, j] = widget_list[l]
            elif direction == 'row':
                self[i, j+l] = widget_list[l]