# AUTOGENERATED! DO NOT EDIT! File to edit: nbs/settings.ipynb (unless otherwise specified).

__all__ = ['SettingsModel', 'SettingsView', 'Settings']

# Cell
from .mvc import Model, Controller
from .traits import Float
from .widget_containers import Box
from .widgets import Dropdown, FloatText

# Cell
from traitlets import Unicode, Float
import traitlets
import ipywidgets as ipyw

# Cell
class SettingsModel(Model):

    tail = Unicode()
    alpha = Float()

    def setLanding(self):
        self.tail = 'two'
        self.alpha = 0.05

# Cell
class SettingsView(Box):

    def __init__(self, **kwargs):
        super().__init__(**kwargs)

        self.layout = ipyw.Layout(width='100%', flex_flow='wrap')

        tailOptions = [('2-tailed', 'two'), ('1-tailed, less', 'less'), ('1-tailed, greater', 'greater')]
        self.tail = Dropdown(options=tailOptions, description = 'Tail:')
        self.alpha = FloatText(description='α: ', step=0.01, min = 0.0, max = 1.0)
        self.children += (self.tail, self.alpha)

# Cell
class Settings(SettingsView):

    def __init__(self, model, **kwargs):
        super().__init__(**kwargs)
        self.model = model

        traitlets.link((self.model, 'tail'), (self.tail, 'value'))
        traitlets.link((self.model, 'alpha'), (self.alpha, 'value'))