# AUTOGENERATED! DO NOT EDIT! File to edit: nbs/models.chisq.ipynb (unless otherwise specified).

__all__ = ['ChiSqLandingModel', 'ChiSqModel']

# Cell
from ..superpower.chisq import ChiSqCon, ChiSqInd
from .corr import CramerVModel, CramerVLandingModel
from ..rpy import RMixins

# Cell
class ChiSqLandingModel(CramerVLandingModel):
    pass

# Cell
class ChiSqModel(CramerVModel, RMixins):

    def __init__(self, **kwargs):
        super().__init__(**kwargs)
        self.ind = ChiSqInd()
        self.con = ChiSqCon()

    def run(self):
        if self.hasColors:
            res = self.runEffectSize()
            w = res['df'].power[0]
            kwargs = self.getTraits(['mata', 'matb', 'rcomp', 'pVal'])
            nrow = self.matrix.shape[0]
            kwargs['mata'] = self.matrix_func(kwargs['mata'], nrow=nrow)
            kwargs['matb'] = self.matrix_func(kwargs['matb'], nrow=nrow)
            return self.con.run(**kwargs)
        else:
            kwargs = self.getTraits(['ns_cells', 'pVal', 'n_col', 'n_row', 'w'])
            kwargs['n_row'], kwargs['n_col'] = kwargs['ns_cells'].shape
            kwargs['ns_cells'] = kwargs['ns_cells'].flatten()
            return self.ind.run(**kwargs)