# AUTOGENERATED! DO NOT EDIT! File to edit: nbs/03_config.ipynb (unless otherwise specified).

__all__ = ['APP_DIR', 'CONFIG', 'USER_DIR']

# Cell
import os, pathlib, urllib, configparser
import pprint

# Cell
APP_DIR = os.path.abspath(os.path.join(os.path.dirname(os.path.realpath(__file__)), os.pardir))

# Cell
CONFIG = configparser.ConfigParser(allow_no_value=True)
CONFIG.read(os.path.join(APP_DIR, 'default.ini'))

# Cell
USER_DIR = os.path.join(os.path.expanduser("~"),'.superpower_gui')
if not os.path.exists(USER_DIR):
    os.makedirs(USER_DIR)
    with open(os.path.join(USER_DIR, 'config.ini'), 'w') as configfile:
        configfile.write('# This config file was created to match default app settings. You may want to change them.\n')
        CONFIG.write(configfile)

# Cell
if os.path.isfile(os.path.join(USER_DIR, 'config.ini')):
    CONFIG.read(os.path.join(USER_DIR, 'config.ini'))

if CONFIG['LOG']['filename']:
    CONFIG['LOG']['filename'] = os.path.expanduser(CONFIG['LOG']['filename'])
    if not os.path.isabs(CONFIG['LOG']['filename']):
        CONFIG['LOG']['filename'] = os.path.join(USER_DIR, CONFIG['LOG']['filename'])
    assert os.path.isdir(os.path.dirname(CONFIG['LOG']['filename'])), 'Directory %s doesn\'t exist' % CONFIG['LOG']['filename']