"""Add initial tables

Revision ID: cc7054b42c18
Revises:
Create Date: 2021-08-22 19:15:00.686815

"""
from alembic import op
import sqlalchemy as sa
import sqlalchemy_utils

# revision identifiers, used by Alembic.
revision = "cc7054b42c18"
down_revision = None
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "project",
        sa.Column("created", sa.DateTime(), nullable=False),
        sa.Column("updated", sa.DateTime(), nullable=False),
        sa.Column("id", sa.BigInteger(), nullable=False),
        sa.Column("name", sa.String(), nullable=True, max_length=255),
        sa.Column("description", sa.String(), nullable=True),
        sa.Column("url", sqlalchemy_utils.types.url.URLType(), nullable=True),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_index(op.f("ix_project_name"), "project", ["name"], unique=True)
    op.create_table(
        "run",
        sa.Column("created", sa.DateTime(), nullable=False),
        sa.Column("updated", sa.DateTime(), nullable=False),
        sa.Column("id", sa.BigInteger(), nullable=False),
        sa.Column("project_id", sa.Integer(), nullable=True),
        sa.Column("artifact_url", sqlalchemy_utils.types.url.URLType(), nullable=False),
        sa.Column("run_info", sa.JSON(), nullable=True),
        sa.ForeignKeyConstraint(
            ["project_id"],
            ["project.id"],
        ),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_table(
        "mypyrunlineitem",
        sa.Column("created", sa.DateTime(), nullable=False),
        sa.Column("updated", sa.DateTime(), nullable=False),
        sa.Column("id", sa.BigInteger(), nullable=False),
        sa.Column("project_id", sa.Integer(), nullable=True),
        sa.Column("run_id", sa.Integer(), nullable=True),
        sa.Column("path", sa.Unicode(), nullable=True),
        sa.Column("loc", sa.Integer(), nullable=True),
        sa.Column("imprecision", sa.Float(), nullable=True),
        sa.ForeignKeyConstraint(
            ["project_id"],
            ["project.id"],
        ),
        sa.ForeignKeyConstraint(
            ["run_id"],
            ["run.id"],
        ),
        sa.PrimaryKeyConstraint("id"),
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table("mypyrunlineitem")
    op.drop_table("run")
    op.drop_index(op.f("ix_project_name"), table_name="project")
    op.drop_table("project")
    # ### end Alembic commands ###
