# QDYN Python Package

QDYN-pylib is a Python package `qdyn` for interacting with the [Fortran QDYN library and tools](https://www.qdyn-library.net/). Its purpose is to:

- generate config files and input data for QDYN
- read data generated by QDYN routines
- provide tools for debugging, testing, and documenting QDYN
- wrap QDYN's "utility" programs like `qdyn_prop_traj` and `qdyn_optimize`
- provide interoperability of QDYN with other optimal control and quantum packages like [`scipy.optimize`](https://docs.scipy.org/doc/scipy/reference/optimize.html), [QuTiP](http://qutip.org) and the [Krotov Python Package](https://qucontrol.github.io/krotov).

The package is *not* a direct wrapper around QDYN that would allow to call QDYN Fortran routines from Python.

## Installation

To install the latest released version of QDYN-pylib, run this command in your terminal:

```
pip install qdyn
```

This is the preferred method to install QDYN-pylib, as it will always install the most recent stable release.

If you are a QDYN developer, you can install the latest development version of QDYN-pylib with the following command:

```
pip install git+git@gitlabph.physik.fu-berlin.de:ag-koch/qdyn.git@master#egg=qdyn&subdirectory=qdynpylib
```
