# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['scistag',
 'scistag.addons',
 'scistag.cli',
 'scistag.common',
 'scistag.common.mt',
 'scistag.data',
 'scistag.datastag',
 'scistag.datastag4flask',
 'scistag.emojistag',
 'scistag.examples',
 'scistag.examples.imagestag',
 'scistag.examples.mediastag',
 'scistag.examples.plotstag',
 'scistag.examples.vislog',
 'scistag.filestag',
 'scistag.filestag.azure',
 'scistag.filestag.bundlers',
 'scistag.gitstag',
 'scistag.imagestag',
 'scistag.imagestag.filters',
 'scistag.jupystag',
 'scistag.logstag',
 'scistag.mediastag',
 'scistag.netstag',
 'scistag.optional',
 'scistag.plotstag',
 'scistag.plotstag.layers',
 'scistag.remotestag',
 'scistag.shapestag',
 'scistag.tests',
 'scistag.tests.common',
 'scistag.tests.datastag',
 'scistag.tests.datastag4flask',
 'scistag.tests.emojistag',
 'scistag.tests.filestag',
 'scistag.tests.filestag4azure',
 'scistag.tests.gitstag',
 'scistag.tests.imagestag',
 'scistag.tests.jupystag',
 'scistag.tests.logstag',
 'scistag.tests.plotstag',
 'scistag.tests.remotestag',
 'scistag.tests.shapestag',
 'scistag.tests.webstag',
 'scistag.third_party',
 'scistag.third_party.imgkit_fix',
 'scistag.vislog',
 'scistag.vislog.widgets',
 'scistag.webstag',
 'scistag.webstag.server',
 'scistag.webstag.server.flask_server']

package_data = \
{'': ['*'], 'scistag.vislog': ['css/*', 'templates/*', 'templates/staticLog/*']}

install_requires = \
['matplotlib>=3.5.2,<4.0.0',
 'pandas>=1.4.2,<2.0.0',
 'pillow>=9.2.0,<10.0.0',
 'pydantic>=1.10.2,<2.0.0',
 'requests>=2.27.1,<3.0.0']

extras_require = \
{'azure': ['azure-storage-blob>=12.13.1,<13.0.0'],
 'datastag': ['pyarrow>=9.0.0,<10.0.0'],
 'flask': ['gunicorn>=20.1.0,<21.0.0', 'Flask>=2.1.2,<3.0.0'],
 'full': ['pretty-html-table>=0.9.16,<0.10.0',
          'Markdown>=3.4.1,<4.0.0',
          'tabulate>=0.9.0,<0.10.0',
          'filetype>=1.1.0,<2.0.0',
          'pyarrow>=9.0.0,<10.0.0',
          'pyarrow>=9.0.0,<10.0.0',
          'Jinja2>=3.1.2,<4.0.0',
          'CairoSVG>=2.5.2,<3.0.0',
          'opencv-contrib-python>=4.5.4.60,<5.0.0.0',
          'azure-storage-blob>=12.13.1,<13.0.0',
          'gunicorn>=20.1.0,<21.0.0',
          'Flask>=2.1.2,<3.0.0',
          'kivy>=2.1.0,<3.0.0',
          'moviepy>=1.0.3,<2.0.0',
          'imgkit==1.2.2',
          'jupyterlab>=3.4.7,<4.0.0',
          'jupyter>=1.0.0,<2.0.0'],
 'jupyter': ['jupyterlab>=3.4.7,<4.0.0', 'jupyter>=1.0.0,<2.0.0'],
 'kivy': ['kivy>=2.1.0,<3.0.0'],
 'logstag': ['pretty-html-table>=0.9.16,<0.10.0',
             'Markdown>=3.4.1,<4.0.0',
             'tabulate>=0.9.0,<0.10.0',
             'filetype>=1.1.0,<2.0.0',
             'pyarrow>=9.0.0,<10.0.0',
             'Jinja2>=3.1.2,<4.0.0'],
 'moviepy': ['moviepy>=1.0.3,<2.0.0', 'imgkit==1.2.2'],
 'opencv': ['opencv-contrib-python>=4.5.4.60,<5.0.0.0'],
 'svg': ['CairoSVG>=2.5.2,<3.0.0']}

setup_kwargs = {
    'name': 'scistag',
    'version': '0.0.3',
    'description': 'A stack of helpful libraries & applications for the rapid development of data driven solutions.',
    'long_description': "# SciStag\n\n### A stack of helpful libraries & applications for the rapid development of data driven solutions.\n\n```\n                                      (  (  )   (  )   )\n                                       `(  `(     )'  )'\n                                         `--(_   _)--'\n                                              \\-/\n                                             /oO \\\n                                            /..   \\\n                                            `--'.  \\              .             \n                                                 \\   `.__________/)\n```\n\n---\n\nBuild Status\n------------\n\n[![PyPi Version](https://img.shields.io/pypi/v/SciStag.svg)](https://pypi.python.org/pypi/SciStag)\n[![Documentation Status](https://readthedocs.org/projects/scistag/badge/?version=latest)](https://scistag.readthedocs.io/en/latest/?badge=latest)\n[![Coverage](https://coveralls.io/repos/github/SciStag/SciStag/badge.svg?branch=main)](https://coveralls.io/github/SciStag/SciStag)\n[![Pylint](https://raw.githubusercontent.com/SciStag/SciStag/v0.0.3/docs/source/generated/pylint.svg)](https://coveralls.io/github/SciStag/SciStag)\n\n[![Ubuntu Unittests Status](https://github.com/scistag/scistag/workflows/Ubuntu%20Unittests/badge.svg)](https://github.com/scistag/scistag/actions?query=workflow%3A%22Ubuntu+Unittests%22)\n\n* SciStag is available on pypi: https://pypi.python.org/pypi/SciStag\n* The source is hosted on GitHub: https://github.com/SciStag/SciStag\n* The documentation is available on ReadTheDocs: https://scistag.readthedocs.io/\n\n---\n\nThis project is still under heavy development and in a very early stage -\nfeel free to experiment with the modules and examples which are already\nprovided.\n\nThe goal of **SciStag** is to bundle the strengths of the many small, awesome\nPython technologies from OpenCV via Flask to Pandas and enable users to combine\nthese libraries and build awesome data driven solutions with a minimum amount of\ncode.\n\nSciStag currently consists of the following so called **stags**:\n\n<table>\n<tr><td><b>VisualLog</b></td>\n<td>Allows the dynamic creation of documentation in HTML, Markdown and text format\nand the fast data evaluation through its built-in in-place reload of Python\nmodules so you can quickly and efficiently dive into and browse through your \ndata, evaluate different parameters quickly etc.\n</td></tr>\n<tr><td><b>ImageStag</b></td>\n<td>Image analysis and modification made easy by combining the strengths of PILLOW, OpenCV and SKImage.\n</td>\n</tr>\n<tr><td><b>MediaStag</b></td>\n<td>Easy integration of streaming media data such as videos into your solution.</td>\n</tr>\n<tr><td><b>DataStag</b></td>\n<td>Low-latency inter-container and -process exchange of image and other binary data for Computer Vision and other data\n  intensive microservice architectures.</td></tr>\n<tr><td><b>RemoteStag</b></td>\n<td>Remote and asynchronous task execution - such as a neural network inference</td>\n</tr>\n<tr><td><b>WebStag</b></td>\n<td>Helpful tools for accessing, processing web data and the easy provision\nof Python components as local microservices.</td></tr>\n<tr><td><b>FileStag</b>\n</td>\n<td>\nTools for handling for large amount of files in a data engineering process \nsuch as easy scanning and handling data in an Azure Storage.\n</td></tr>\n</table>\n\n---\n\n## Setup\n\nSciStag comes completely bundled with all required standard components.\n\n`pip install scistag[full]` or when using poetry `poetry add scistag[full]` and\nyou are ready to go! :)\n\nIf you do not want to install advanced components such as Kivy you are also fine\nwith a more light-weighted\n\n`pip install scistag[logstag,flask]`\n\n## Getting started\n\nYou can already find several cool\ndemos [here](https://github.com/SciStag/SciStag/tree/main/scistag/examples) on\nGitHub.\n\nThe most advanced and central component of SciStag is currently definitely **\nVisualLog** which\nlets you create log data and documentation very efficiently with a Jupyter-like\nfeeling but without loosing all the awesome code editing features of your\nIDEs such as Visual Studio Code or PyCharm.\n\nYou can find the demos for **VisualLog** in the [\nvislog](https://github.com/SciStag/SciStag/tree/main/scistag/examples/vislog)\nexamples folder.\n\n## License\n\nCopyright (c) 2022-present Michael Ikemann.\n\nReleased under the terms of the **MIT License**.\n\n### Third-party data\n\nThe SciStag module on PyPi is bundled with the following data:\n\n* The [Roboto](https://fonts.google.com/specimen/Roboto) font - licensed and\n  distributed under the terms of\n  the [Apache License, Version 2.0](https://www.apache.org/licenses/LICENSE-2.0)\n  .\n* The [Roboto Flex](https://github.com/googlefonts/roboto-flex) font - licensed\n  under\n  the [SIL Open Font License 1.1](http://scripts.sil.org/cms/scripts/page.php?item_id=OFL_web)\n* The [JetBrains Mono](https://www.jetbrains.com/lp/mono/) font - licensed under\n  the [SIL Open Font License 1.1](http://scripts.sil.org/cms/scripts/page.php?item_id=OFL_web)\n  .\n* [Iconic font](https://github.com/Templarian/MaterialDesign-Webfont) by the\n  Material Design Icons community covered\n  by [SIL Open Font License 1.1](http://scripts.sil.org/cms/scripts/page.php?item_id=OFL_web)\n* Emojis and country flags from\n  the [Noto Emoji](https://github.com/googlefonts/noto-emoji) project. Tools and\n  most\n  image resources are under\n  the [Apache License, Version 2.0](https://www.apache.org/licenses/LICENSE-2.0)\n  .\n    * Flag images under the public domain or otherwise exempt from copyright.\n* The emoji unicode character name mappings and details are based upon the\n  unicode data files, Copyright © 1991-2022\n  Unicode, Inc, licensed under the terms of\n  the [UNICODE, INC. LICENSE AGREEMENT](https://www.unicode.org/license.txt)\n\n### Third-party source code\n\n* Contains portions of code from [imkgit](https://github.com/jarrekk/imgkit),\n  Copyright (C) 2016 Cory Dolphin, Olin\n  College, released under the terms of the **MIT License**.\n\n## Contributors\n\nSciStag is developed by Michael Ikemann / [@Alyxion](https://github.com/Alyxion)\n. - Feel free to reach out to me\nvia [LinkedIn](https://www.linkedin.com/in/michael-ikemann/).\n\n",
    'author': 'Michael Ikemann',
    'author_email': 'None',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'https://github.com/scistag/scistag',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'python_requires': '>=3.9,<4.0',
}


setup(**setup_kwargs)
