# Generated by Django 3.0.2 on 2021-01-15 17:39

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('groups', '0014_auto_20210112_1332'),
    ]

    operations = [
        migrations.CreateModel(
            name='SignedPreKey',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('keyId', models.IntegerField()),
                ('public', models.CharField(max_length=44)),
                ('signature', models.CharField(max_length=88)),
                ('cipher', models.CharField(max_length=88)),
                ('salt', models.CharField(max_length=44)),
                ('user', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, related_name='signedPreKey', to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='PreKey',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('keyId', models.IntegerField()),
                ('public', models.CharField(max_length=44)),
                ('used', models.BooleanField(default=False)),
                ('cipher', models.CharField(max_length=88)),
                ('salt', models.CharField(max_length=44)),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='preKeys', to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='Party',
            fields=[
                ('id', models.CharField(max_length=1000, primary_key=True, serialize=False, unique=True)),
                ('connections', models.ManyToManyField(blank=True, related_name='party_connections', to=settings.AUTH_USER_MODEL)),
                ('groups', models.ManyToManyField(blank=True, to='groups.Group')),
                ('user', models.OneToOneField(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='party', to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='IdentityKey',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('public', models.CharField(max_length=44)),
                ('deviceId', models.IntegerField(default=0)),
                ('localId', models.IntegerField()),
                ('cipher', models.CharField(max_length=88)),
                ('salt', models.CharField(max_length=44)),
                ('user', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, related_name='identityKey', to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='EncryptingSenderKey',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('keyId', models.IntegerField()),
                ('partyId', models.CharField(max_length=100)),
                ('chainId', models.CharField(max_length=10)),
                ('step', models.IntegerField(default=0)),
                ('chainKey', models.CharField(max_length=44)),
                ('public', models.CharField(max_length=44)),
                ('cipher', models.CharField(max_length=500)),
                ('preKey', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, related_name='encryptingSenderKey', to='keys.PreKey')),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='encryptingSenderKeys', to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='DecryptingSenderKey',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('key', models.CharField(max_length=500)),
                ('stickId', models.CharField(max_length=100)),
                ('partyId', models.CharField(blank=True, max_length=100, null=True)),
                ('ofOneTimeId', models.CharField(blank=True, max_length=100, null=True)),
                ('forOneTimeId', models.CharField(blank=True, max_length=100, null=True)),
                ('forUser', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='receivedSenderKeys', to=settings.AUTH_USER_MODEL)),
                ('ofUser', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='decryptingSenderKeys', to=settings.AUTH_USER_MODEL)),
                ('preKey', models.OneToOneField(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='decryptingSenderKey', to='keys.PreKey')),
            ],
        ),
        migrations.AddConstraint(
            model_name='signedprekey',
            constraint=models.UniqueConstraint(fields=('keyId', 'user'), name='unique_signed_prekey'),
        ),
        migrations.AddConstraint(
            model_name='prekey',
            constraint=models.UniqueConstraint(fields=('keyId', 'user'), name='unique_prekey'),
        ),
        migrations.AddConstraint(
            model_name='encryptingsenderkey',
            constraint=models.UniqueConstraint(fields=('partyId', 'chainId', 'user'), name='unique_esk'),
        ),
    ]
