/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.core.util;

import java.util.Enumeration;
import java.util.Vector;
import org.javarosa.core.util.OrderedMap;

public class Map<K, V>
extends OrderedMap<K, V> {
    Vector<K> keys;
    Vector<V> elements;
    boolean sealed = false;
    K[] keysSealed;
    V[] elementsSealed;

    public Map() {
        this.keys = new Vector();
        this.elements = new Vector();
    }

    public Map(int sizeHint) {
        this.keys = new Vector(sizeHint);
        this.elements = new Vector(sizeHint);
    }

    public Map(K[] keysSealed, V[] elementsSealed) {
        this.keys = null;
        this.elements = null;
        this.sealed = true;
        this.keysSealed = keysSealed;
        this.elementsSealed = elementsSealed;
    }

    @Override
    public V put(K key, V value) {
        if (this.sealed) {
            throw new IllegalStateException("Trying to add element to sealed map");
        }
        if (this.containsKey(key)) {
            this.remove(key);
        }
        this.keys.addElement(key);
        this.elements.addElement(value);
        return value;
    }

    @Override
    public int size() {
        if (!this.sealed) {
            return this.keys.size();
        }
        return this.keysSealed.length;
    }

    @Override
    public V get(Object key) {
        int index = this.getIndex(key);
        if (index == -1) {
            return null;
        }
        if (!this.sealed) {
            return this.elements.elementAt(index);
        }
        return this.elementsSealed[index];
    }

    @Override
    public V remove(Object key) {
        if (this.sealed) {
            throw new IllegalStateException("Trying to remove element from sealed map");
        }
        int index = this.getIndex(key);
        if (index == -1) {
            return null;
        }
        V v = this.elementAt(index);
        this.keys.removeElementAt(index);
        this.elements.removeElementAt(index);
        if (this.keys.size() != this.elements.size()) {
            throw new RuntimeException("Map in bad state!");
        }
        return v;
    }

    public void reset() {
        if (!this.sealed) {
            this.keys.removeAllElements();
            this.elements.removeAllElements();
        } else {
            this.keysSealed = null;
            this.elementsSealed = null;
            this.keys = new Vector();
            this.elements = new Vector();
        }
    }

    @Override
    public boolean containsKey(Object key) {
        return this.getIndex(key) != -1;
    }

    private int getIndex(K key) {
        if (!this.sealed) {
            for (int i = 0; i < this.keys.size(); ++i) {
                if (!this.keys.elementAt(i).equals(key)) continue;
                return i;
            }
        } else {
            for (int i = 0; i < this.keysSealed.length; ++i) {
                if (!this.keysSealed[i].equals(key)) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public void clear() {
        this.reset();
    }

    public V elementAt(int index) {
        if (!this.sealed) {
            return this.elements.elementAt(index);
        }
        return this.elementsSealed[index];
    }

    public Enumeration elements() {
        if (!this.sealed) {
            return this.elements.elements();
        }
        return new Enumeration(){
            int id = 0;

            @Override
            public boolean hasMoreElements() {
                return this.id < Map.this.size();
            }

            public Object nextElement() {
                int val = this.id++;
                return Map.this.elementAt(val);
            }
        };
    }

    public int indexOfKey(K key) {
        return this.getIndex(key);
    }

    public Object keyAt(int index) {
        if (!this.sealed) {
            return this.keys.elementAt(index);
        }
        return this.keysSealed[index];
    }

    public Enumeration keys() {
        if (!this.sealed) {
            return this.keys.elements();
        }
        return new Enumeration(){
            int id = 0;

            @Override
            public boolean hasMoreElements() {
                return this.id < Map.this.size();
            }

            public Object nextElement() {
                int val = this.id++;
                return Map.this.keyAt(val);
            }
        };
    }

    public void removeAt(int i) {
        this.remove(this.keyAt(i));
    }

    @Override
    public String toString() {
        return "MAP!";
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.size() > 0;
    }

    public synchronized boolean contains(Object value) {
        if (!this.sealed) {
            return this.elements.contains(value);
        }
        for (int i = 0; i < this.elementsSealed.length; ++i) {
            if (!this.elementsSealed[i].equals(value)) continue;
            return true;
        }
        return false;
    }

    public void seal() {
    }
}

