/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.core.services.storage;

import java.util.List;
import org.javarosa.core.services.storage.EntityFilter;
import org.javarosa.core.services.storage.IStorageIterator;
import org.javarosa.core.services.storage.Persistable;
import org.javarosa.core.services.storage.StorageFullException;
import org.javarosa.core.util.externalizable.Externalizable;

public interface IStorageUtility<E extends Externalizable> {
    public E read(int var1);

    public byte[] readBytes(int var1);

    public void write(Persistable var1) throws StorageFullException;

    public int add(E var1) throws StorageFullException;

    public void update(int var1, E var2) throws StorageFullException;

    public void remove(int var1);

    public void remove(Persistable var1);

    public void removeAll();

    public List<Integer> removeAll(EntityFilter var1);

    public int getNumRecords();

    public boolean isEmpty();

    public boolean exists(int var1);

    public int getTotalSize();

    public int getRecordSize(int var1);

    public IStorageIterator<E> iterate();

    public void close();

    public void destroy();

    public void repack();

    public void repair();

    public Object getAccessLock();

    public void setReadOnly();
}

