(window["webpackJsonp"] = window["webpackJsonp"] || []).push([[10],{

/***/ 1224:
/***/ (function(module, exports, __webpack_require__) {

/* WEBPACK VAR INJECTION */(function(global) {(function (global, factory) {
   true ? factory(exports) :
  undefined;
}(this, (function (exports) { 'use strict';

  /**
   * @module ol/util
   */

  /**
   * @return {?} Any return.
   */
  function abstract() {
    return /** @type {?} */ ((function() {
      throw new Error('Unimplemented abstract method.');
    })());
  }

  /**
   * Counter for getUid.
   * @type {number}
   * @private
   */
  var uidCounter_ = 0;

  /**
   * Gets a unique ID for an object. This mutates the object so that further calls
   * with the same object as a parameter returns the same value. Unique IDs are generated
   * as a strictly increasing sequence. Adapted from goog.getUid.
   *
   * @param {Object} obj The object to get the unique ID for.
   * @return {string} The unique ID for the object.
   * @function module:ol.getUid
   * @api
   */
  function getUid(obj) {
    return obj.ol_uid || (obj.ol_uid = String(++uidCounter_));
  }

  /**
   * OpenLayers version.
   * @type {string}
   */
  var VERSION = '5.3.0';

  /**
   * @module ol/AssertionError
   */

  /**
   * Error object thrown when an assertion failed. This is an ECMA-262 Error,
   * extended with a `code` property.
   * See https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Error.
   */
  var AssertionError = /*@__PURE__*/(function (Error) {
    function AssertionError(code) {
      var path = 'v' + VERSION.split('-')[0];
      var message = 'Assertion failed. See https://openlayers.org/en/' + path +
      '/doc/errors/#' + code + ' for details.';

      Error.call(this, message);

      /**
       * Error code. The meaning of the code can be found on
       * https://openlayers.org/en/latest/doc/errors/ (replace `latest` with
       * the version found in the OpenLayers script's header comment if a version
       * other than the latest is used).
       * @type {number}
       * @api
       */
      this.code = code;

      /**
       * @type {string}
       */
      this.name = 'AssertionError';

      // Re-assign message, see https://github.com/Rich-Harris/buble/issues/40
      this.message = message;
    }

    if ( Error ) AssertionError.__proto__ = Error;
    AssertionError.prototype = Object.create( Error && Error.prototype );
    AssertionError.prototype.constructor = AssertionError;

    return AssertionError;
  }(Error));

  /**
   * @module ol/CollectionEventType
   */

  /**
   * @enum {string}
   */
  var CollectionEventType = {
    /**
     * Triggered when an item is added to the collection.
     * @event module:ol/Collection.CollectionEvent#add
     * @api
     */
    ADD: 'add',
    /**
     * Triggered when an item is removed from the collection.
     * @event module:ol/Collection.CollectionEvent#remove
     * @api
     */
    REMOVE: 'remove'
  };

  /**
   * @module ol/ObjectEventType
   */

  /**
   * @enum {string}
   */
  var ObjectEventType = {
    /**
     * Triggered when a property is changed.
     * @event module:ol/Object.ObjectEvent#propertychange
     * @api
     */
    PROPERTYCHANGE: 'propertychange'
  };

  /**
   * @module ol/obj
   */


  /**
   * Polyfill for Object.assign().  Assigns enumerable and own properties from
   * one or more source objects to a target object.
   * See https://developer.mozilla.org/en/docs/Web/JavaScript/Reference/Global_Objects/Object/assign.
   *
   * @param {!Object} target The target object.
   * @param {...Object} var_sources The source object(s).
   * @return {!Object} The modified target object.
   */
  var assign = (typeof Object.assign === 'function') ? Object.assign : function(target, var_sources) {
    var arguments$1 = arguments;

    if (target === undefined || target === null) {
      throw new TypeError('Cannot convert undefined or null to object');
    }

    var output = Object(target);
    for (var i = 1, ii = arguments.length; i < ii; ++i) {
      var source = arguments$1[i];
      if (source !== undefined && source !== null) {
        for (var key in source) {
          if (source.hasOwnProperty(key)) {
            output[key] = source[key];
          }
        }
      }
    }
    return output;
  };


  /**
   * Removes all properties from an object.
   * @param {Object} object The object to clear.
   */
  function clear(object) {
    for (var property in object) {
      delete object[property];
    }
  }


  /**
   * Get an array of property values from an object.
   * @param {Object<K,V>} object The object from which to get the values.
   * @return {!Array<V>} The property values.
   * @template K,V
   */
  function getValues(object) {
    var values = [];
    for (var property in object) {
      values.push(object[property]);
    }
    return values;
  }


  /**
   * Determine if an object has any properties.
   * @param {Object} object The object to check.
   * @return {boolean} The object is empty.
   */
  function isEmpty(object) {
    var property;
    for (property in object) {
      return false;
    }
    return !property;
  }

  /**
   * @module ol/events
   */


  /**
   * Key to use with {@link module:ol/Observable~Observable#unByKey}.
   * @typedef {Object} EventsKey
   * @property {Object} [bindTo]
   * @property {ListenerFunction} [boundListener]
   * @property {boolean} callOnce
   * @property {number} [deleteIndex]
   * @property {ListenerFunction} listener
   * @property {import("./events/Target.js").EventTargetLike} target
   * @property {string} type
   * @api
   */


  /**
   * Listener function. This function is called with an event object as argument.
   * When the function returns `false`, event propagation will stop.
   *
   * @typedef {function((Event|import("./events/Event.js").default)): (void|boolean)} ListenerFunction
   * @api
   */


  /**
   * @param {EventsKey} listenerObj Listener object.
   * @return {ListenerFunction} Bound listener.
   */
  function bindListener(listenerObj) {
    var boundListener = function(evt) {
      var listener = listenerObj.listener;
      var bindTo = listenerObj.bindTo || listenerObj.target;
      if (listenerObj.callOnce) {
        unlistenByKey(listenerObj);
      }
      return listener.call(bindTo, evt);
    };
    listenerObj.boundListener = boundListener;
    return boundListener;
  }


  /**
   * Finds the matching {@link module:ol/events~EventsKey} in the given listener
   * array.
   *
   * @param {!Array<!EventsKey>} listeners Array of listeners.
   * @param {!Function} listener The listener function.
   * @param {Object=} opt_this The `this` value inside the listener.
   * @param {boolean=} opt_setDeleteIndex Set the deleteIndex on the matching
   *     listener, for {@link module:ol/events~unlistenByKey}.
   * @return {EventsKey|undefined} The matching listener object.
   */
  function findListener(listeners, listener, opt_this, opt_setDeleteIndex) {
    var listenerObj;
    for (var i = 0, ii = listeners.length; i < ii; ++i) {
      listenerObj = listeners[i];
      if (listenerObj.listener === listener &&
          listenerObj.bindTo === opt_this) {
        if (opt_setDeleteIndex) {
          listenerObj.deleteIndex = i;
        }
        return listenerObj;
      }
    }
    return undefined;
  }


  /**
   * @param {import("./events/Target.js").EventTargetLike} target Target.
   * @param {string} type Type.
   * @return {Array<EventsKey>|undefined} Listeners.
   */
  function getListeners(target, type) {
    var listenerMap = getListenerMap(target);
    return listenerMap ? listenerMap[type] : undefined;
  }


  /**
   * Get the lookup of listeners.
   * @param {Object} target Target.
   * @param {boolean=} opt_create If a map should be created if it doesn't exist.
   * @return {!Object<string, Array<EventsKey>>} Map of
   *     listeners by event type.
   */
  function getListenerMap(target, opt_create) {
    var listenerMap = target.ol_lm;
    if (!listenerMap && opt_create) {
      listenerMap = target.ol_lm = {};
    }
    return listenerMap;
  }


  /**
   * Remove the listener map from a target.
   * @param {Object} target Target.
   */
  function removeListenerMap(target) {
    delete target.ol_lm;
  }


  /**
   * Clean up all listener objects of the given type.  All properties on the
   * listener objects will be removed, and if no listeners remain in the listener
   * map, it will be removed from the target.
   * @param {import("./events/Target.js").EventTargetLike} target Target.
   * @param {string} type Type.
   */
  function removeListeners(target, type) {
    var listeners = getListeners(target, type);
    if (listeners) {
      for (var i = 0, ii = listeners.length; i < ii; ++i) {
        /** @type {import("./events/Target.js").default} */ (target).
          removeEventListener(type, listeners[i].boundListener);
        clear(listeners[i]);
      }
      listeners.length = 0;
      var listenerMap = getListenerMap(target);
      if (listenerMap) {
        delete listenerMap[type];
        if (Object.keys(listenerMap).length === 0) {
          removeListenerMap(target);
        }
      }
    }
  }


  /**
   * Registers an event listener on an event target. Inspired by
   * https://google.github.io/closure-library/api/source/closure/goog/events/events.js.src.html
   *
   * This function efficiently binds a `listener` to a `this` object, and returns
   * a key for use with {@link module:ol/events~unlistenByKey}.
   *
   * @param {import("./events/Target.js").EventTargetLike} target Event target.
   * @param {string} type Event type.
   * @param {ListenerFunction} listener Listener.
   * @param {Object=} opt_this Object referenced by the `this` keyword in the
   *     listener. Default is the `target`.
   * @param {boolean=} opt_once If true, add the listener as one-off listener.
   * @return {EventsKey} Unique key for the listener.
   */
  function listen(target, type, listener, opt_this, opt_once) {
    var listenerMap = getListenerMap(target, true);
    var listeners = listenerMap[type];
    if (!listeners) {
      listeners = listenerMap[type] = [];
    }
    var listenerObj = findListener(listeners, listener, opt_this, false);
    if (listenerObj) {
      if (!opt_once) {
        // Turn one-off listener into a permanent one.
        listenerObj.callOnce = false;
      }
    } else {
      listenerObj = /** @type {EventsKey} */ ({
        bindTo: opt_this,
        callOnce: !!opt_once,
        listener: listener,
        target: target,
        type: type
      });
      /** @type {import("./events/Target.js").default} */ (target).
        addEventListener(type, bindListener(listenerObj));
      listeners.push(listenerObj);
    }

    return listenerObj;
  }


  /**
   * Registers a one-off event listener on an event target. Inspired by
   * https://google.github.io/closure-library/api/source/closure/goog/events/events.js.src.html
   *
   * This function efficiently binds a `listener` as self-unregistering listener
   * to a `this` object, and returns a key for use with
   * {@link module:ol/events~unlistenByKey} in case the listener needs to be
   * unregistered before it is called.
   *
   * When {@link module:ol/events~listen} is called with the same arguments after this
   * function, the self-unregistering listener will be turned into a permanent
   * listener.
   *
   * @param {import("./events/Target.js").EventTargetLike} target Event target.
   * @param {string} type Event type.
   * @param {ListenerFunction} listener Listener.
   * @param {Object=} opt_this Object referenced by the `this` keyword in the
   *     listener. Default is the `target`.
   * @return {EventsKey} Key for unlistenByKey.
   */
  function listenOnce(target, type, listener, opt_this) {
    return listen(target, type, listener, opt_this, true);
  }


  /**
   * Unregisters an event listener on an event target. Inspired by
   * https://google.github.io/closure-library/api/source/closure/goog/events/events.js.src.html
   *
   * To return a listener, this function needs to be called with the exact same
   * arguments that were used for a previous {@link module:ol/events~listen} call.
   *
   * @param {import("./events/Target.js").EventTargetLike} target Event target.
   * @param {string} type Event type.
   * @param {ListenerFunction} listener Listener.
   * @param {Object=} opt_this Object referenced by the `this` keyword in the
   *     listener. Default is the `target`.
   */
  function unlisten(target, type, listener, opt_this) {
    var listeners = getListeners(target, type);
    if (listeners) {
      var listenerObj = findListener(listeners, listener, opt_this, true);
      if (listenerObj) {
        unlistenByKey(listenerObj);
      }
    }
  }


  /**
   * Unregisters event listeners on an event target. Inspired by
   * https://google.github.io/closure-library/api/source/closure/goog/events/events.js.src.html
   *
   * The argument passed to this function is the key returned from
   * {@link module:ol/events~listen} or {@link module:ol/events~listenOnce}.
   *
   * @param {EventsKey} key The key.
   */
  function unlistenByKey(key) {
    if (key && key.target) {
      /** @type {import("./events/Target.js").default} */ (key.target).
        removeEventListener(key.type, key.boundListener);
      var listeners = getListeners(key.target, key.type);
      if (listeners) {
        var i = 'deleteIndex' in key ? key.deleteIndex : listeners.indexOf(key);
        if (i !== -1) {
          listeners.splice(i, 1);
        }
        if (listeners.length === 0) {
          removeListeners(key.target, key.type);
        }
      }
      clear(key);
    }
  }


  /**
   * Unregisters all event listeners on an event target. Inspired by
   * https://google.github.io/closure-library/api/source/closure/goog/events/events.js.src.html
   *
   * @param {import("./events/Target.js").EventTargetLike} target Target.
   */
  function unlistenAll(target) {
    var listenerMap = getListenerMap(target);
    if (listenerMap) {
      for (var type in listenerMap) {
        removeListeners(target, type);
      }
    }
  }

  /**
   * @module ol/Disposable
   */

  /**
   * @classdesc
   * Objects that need to clean up after themselves.
   */
  var Disposable = function Disposable() {
    /**
     * The object has already been disposed.
     * @type {boolean}
     * @private
     */
    this.disposed_ = false;
  };

  /**
   * Clean up.
   */
  Disposable.prototype.dispose = function dispose () {
    if (!this.disposed_) {
      this.disposed_ = true;
      this.disposeInternal();
    }
  };

  /**
   * Extension point for disposable objects.
   * @protected
   */
  Disposable.prototype.disposeInternal = function disposeInternal () {};

  /**
   * @module ol/functions
   */

  /**
   * Always returns true.
   * @returns {boolean} true.
   */
  function TRUE() {
    return true;
  }

  /**
   * Always returns false.
   * @returns {boolean} false.
   */
  function FALSE() {
    return false;
  }

  /**
   * A reusable function, used e.g. as a default for callbacks.
   *
   * @return {void} Nothing.
   */
  function VOID() {}

  /**
   * @module ol/events/Event
   */

  /**
   * @classdesc
   * Stripped down implementation of the W3C DOM Level 2 Event interface.
   * See https://www.w3.org/TR/DOM-Level-2-Events/events.html#Events-interface.
   *
   * This implementation only provides `type` and `target` properties, and
   * `stopPropagation` and `preventDefault` methods. It is meant as base class
   * for higher level events defined in the library, and works with
   * {@link module:ol/events/Target~Target}.
   */
  var Event = function Event(type) {

    /**
     * @type {boolean}
     */
    this.propagationStopped;

    /**
     * The event type.
     * @type {string}
     * @api
     */
    this.type = type;

    /**
     * The event target.
     * @type {Object}
     * @api
     */
    this.target = null;
  };

  /**
   * Stop event propagation.
   * @api
   */
  Event.prototype.preventDefault = function preventDefault () {
    this.propagationStopped = true;
  };

  /**
   * Stop event propagation.
   * @api
   */
  Event.prototype.stopPropagation = function stopPropagation () {
    this.propagationStopped = true;
  };


  /**
   * @param {Event|import("./Event.js").default} evt Event
   */
  function stopPropagation(evt) {
    evt.stopPropagation();
  }

  /**
   * @module ol/events/Target
   */


  /**
   * @typedef {EventTarget|Target} EventTargetLike
   */


  /**
   * @classdesc
   * A simplified implementation of the W3C DOM Level 2 EventTarget interface.
   * See https://www.w3.org/TR/2000/REC-DOM-Level-2-Events-20001113/events.html#Events-EventTarget.
   *
   * There are two important simplifications compared to the specification:
   *
   * 1. The handling of `useCapture` in `addEventListener` and
   *    `removeEventListener`. There is no real capture model.
   * 2. The handling of `stopPropagation` and `preventDefault` on `dispatchEvent`.
   *    There is no event target hierarchy. When a listener calls
   *    `stopPropagation` or `preventDefault` on an event object, it means that no
   *    more listeners after this one will be called. Same as when the listener
   *    returns false.
   */
  var Target = /*@__PURE__*/(function (Disposable$$1) {
    function Target() {

      Disposable$$1.call(this);

      /**
       * @private
       * @type {!Object<string, number>}
       */
      this.pendingRemovals_ = {};

      /**
       * @private
       * @type {!Object<string, number>}
       */
      this.dispatching_ = {};

      /**
       * @private
       * @type {!Object<string, Array<import("../events.js").ListenerFunction>>}
       */
      this.listeners_ = {};

    }

    if ( Disposable$$1 ) Target.__proto__ = Disposable$$1;
    Target.prototype = Object.create( Disposable$$1 && Disposable$$1.prototype );
    Target.prototype.constructor = Target;

    /**
     * @param {string} type Type.
     * @param {import("../events.js").ListenerFunction} listener Listener.
     */
    Target.prototype.addEventListener = function addEventListener (type, listener) {
      var listeners = this.listeners_[type];
      if (!listeners) {
        listeners = this.listeners_[type] = [];
      }
      if (listeners.indexOf(listener) === -1) {
        listeners.push(listener);
      }
    };

    /**
     * Dispatches an event and calls all listeners listening for events
     * of this type. The event parameter can either be a string or an
     * Object with a `type` property.
     *
     * @param {{type: string,
     *     target: (EventTargetLike|undefined),
     *     propagationStopped: (boolean|undefined)}|
     *     import("./Event.js").default|string} event Event object.
     * @return {boolean|undefined} `false` if anyone called preventDefault on the
     *     event object or if any of the listeners returned false.
     * @api
     */
    Target.prototype.dispatchEvent = function dispatchEvent (event) {
      var evt = typeof event === 'string' ? new Event(event) : event;
      var type = evt.type;
      evt.target = this;
      var listeners = this.listeners_[type];
      var propagate;
      if (listeners) {
        if (!(type in this.dispatching_)) {
          this.dispatching_[type] = 0;
          this.pendingRemovals_[type] = 0;
        }
        ++this.dispatching_[type];
        for (var i = 0, ii = listeners.length; i < ii; ++i) {
          if (listeners[i].call(this, evt) === false || evt.propagationStopped) {
            propagate = false;
            break;
          }
        }
        --this.dispatching_[type];
        if (this.dispatching_[type] === 0) {
          var pendingRemovals = this.pendingRemovals_[type];
          delete this.pendingRemovals_[type];
          while (pendingRemovals--) {
            this.removeEventListener(type, VOID);
          }
          delete this.dispatching_[type];
        }
        return propagate;
      }
    };

    /**
     * @inheritDoc
     */
    Target.prototype.disposeInternal = function disposeInternal () {
      unlistenAll(this);
    };

    /**
     * Get the listeners for a specified event type. Listeners are returned in the
     * order that they will be called in.
     *
     * @param {string} type Type.
     * @return {Array<import("../events.js").ListenerFunction>} Listeners.
     */
    Target.prototype.getListeners = function getListeners$$1 (type) {
      return this.listeners_[type];
    };

    /**
     * @param {string=} opt_type Type. If not provided,
     *     `true` will be returned if this event target has any listeners.
     * @return {boolean} Has listeners.
     */
    Target.prototype.hasListener = function hasListener (opt_type) {
      return opt_type ?
        opt_type in this.listeners_ :
        Object.keys(this.listeners_).length > 0;
    };

    /**
     * @param {string} type Type.
     * @param {import("../events.js").ListenerFunction} listener Listener.
     */
    Target.prototype.removeEventListener = function removeEventListener (type, listener) {
      var listeners = this.listeners_[type];
      if (listeners) {
        var index = listeners.indexOf(listener);
        if (type in this.pendingRemovals_) {
          // make listener a no-op, and remove later in #dispatchEvent()
          listeners[index] = VOID;
          ++this.pendingRemovals_[type];
        } else {
          listeners.splice(index, 1);
          if (listeners.length === 0) {
            delete this.listeners_[type];
          }
        }
      }
    };

    return Target;
  }(Disposable));

  /**
   * @module ol/events/EventType
   */

  /**
   * @enum {string}
   * @const
   */
  var EventType = {
    /**
     * Generic change event. Triggered when the revision counter is increased.
     * @event module:ol/events/Event~Event#change
     * @api
     */
    CHANGE: 'change',

    CLEAR: 'clear',
    CONTEXTMENU: 'contextmenu',
    CLICK: 'click',
    DBLCLICK: 'dblclick',
    DRAGENTER: 'dragenter',
    DRAGOVER: 'dragover',
    DROP: 'drop',
    ERROR: 'error',
    KEYDOWN: 'keydown',
    KEYPRESS: 'keypress',
    LOAD: 'load',
    MOUSEDOWN: 'mousedown',
    MOUSEMOVE: 'mousemove',
    MOUSEOUT: 'mouseout',
    MOUSEUP: 'mouseup',
    MOUSEWHEEL: 'mousewheel',
    MSPOINTERDOWN: 'MSPointerDown',
    RESIZE: 'resize',
    TOUCHSTART: 'touchstart',
    TOUCHMOVE: 'touchmove',
    TOUCHEND: 'touchend',
    WHEEL: 'wheel'
  };

  /**
   * @module ol/Observable
   */

  /**
   * @classdesc
   * Abstract base class; normally only used for creating subclasses and not
   * instantiated in apps.
   * An event target providing convenient methods for listener registration
   * and unregistration. A generic `change` event is always available through
   * {@link module:ol/Observable~Observable#changed}.
   *
   * @fires import("./events/Event.js").Event
   * @api
   */
  var Observable = /*@__PURE__*/(function (EventTarget) {
    function Observable() {

      EventTarget.call(this);

      /**
       * @private
       * @type {number}
       */
      this.revision_ = 0;

    }

    if ( EventTarget ) Observable.__proto__ = EventTarget;
    Observable.prototype = Object.create( EventTarget && EventTarget.prototype );
    Observable.prototype.constructor = Observable;

    /**
     * Increases the revision counter and dispatches a 'change' event.
     * @api
     */
    Observable.prototype.changed = function changed () {
      ++this.revision_;
      this.dispatchEvent(EventType.CHANGE);
    };

    /**
     * Get the version number for this object.  Each time the object is modified,
     * its version number will be incremented.
     * @return {number} Revision.
     * @api
     */
    Observable.prototype.getRevision = function getRevision () {
      return this.revision_;
    };

    /**
     * Listen for a certain type of event.
     * @param {string|Array<string>} type The event type or array of event types.
     * @param {function(?): ?} listener The listener function.
     * @return {import("./events.js").EventsKey|Array<import("./events.js").EventsKey>} Unique key for the listener. If
     *     called with an array of event types as the first argument, the return
     *     will be an array of keys.
     * @api
     */
    Observable.prototype.on = function on (type, listener) {
      if (Array.isArray(type)) {
        var len = type.length;
        var keys = new Array(len);
        for (var i = 0; i < len; ++i) {
          keys[i] = listen(this, type[i], listener);
        }
        return keys;
      } else {
        return listen(this, /** @type {string} */ (type), listener);
      }
    };

    /**
     * Listen once for a certain type of event.
     * @param {string|Array<string>} type The event type or array of event types.
     * @param {function(?): ?} listener The listener function.
     * @return {import("./events.js").EventsKey|Array<import("./events.js").EventsKey>} Unique key for the listener. If
     *     called with an array of event types as the first argument, the return
     *     will be an array of keys.
     * @api
     */
    Observable.prototype.once = function once (type, listener) {
      if (Array.isArray(type)) {
        var len = type.length;
        var keys = new Array(len);
        for (var i = 0; i < len; ++i) {
          keys[i] = listenOnce(this, type[i], listener);
        }
        return keys;
      } else {
        return listenOnce(this, /** @type {string} */ (type), listener);
      }
    };

    /**
     * Unlisten for a certain type of event.
     * @param {string|Array<string>} type The event type or array of event types.
     * @param {function(?): ?} listener The listener function.
     * @api
     */
    Observable.prototype.un = function un (type, listener) {
      if (Array.isArray(type)) {
        for (var i = 0, ii = type.length; i < ii; ++i) {
          unlisten(this, type[i], listener);
        }
        return;
      } else {
        unlisten(this, /** @type {string} */ (type), listener);
      }
    };

    return Observable;
  }(Target));

  /**
   * @module ol/Object
   */


  /**
   * @classdesc
   * Events emitted by {@link module:ol/Object~BaseObject} instances are instances of this type.
   */
  var ObjectEvent = /*@__PURE__*/(function (Event$$1) {
    function ObjectEvent(type, key, oldValue) {
      Event$$1.call(this, type);

      /**
       * The name of the property whose value is changing.
       * @type {string}
       * @api
       */
      this.key = key;

      /**
       * The old value. To get the new value use `e.target.get(e.key)` where
       * `e` is the event object.
       * @type {*}
       * @api
       */
      this.oldValue = oldValue;

    }

    if ( Event$$1 ) ObjectEvent.__proto__ = Event$$1;
    ObjectEvent.prototype = Object.create( Event$$1 && Event$$1.prototype );
    ObjectEvent.prototype.constructor = ObjectEvent;

    return ObjectEvent;
  }(Event));


  /**
   * @classdesc
   * Abstract base class; normally only used for creating subclasses and not
   * instantiated in apps.
   * Most non-trivial classes inherit from this.
   *
   * This extends {@link module:ol/Observable} with observable
   * properties, where each property is observable as well as the object as a
   * whole.
   *
   * Classes that inherit from this have pre-defined properties, to which you can
   * add your owns. The pre-defined properties are listed in this documentation as
   * 'Observable Properties', and have their own accessors; for example,
   * {@link module:ol/Map~Map} has a `target` property, accessed with
   * `getTarget()` and changed with `setTarget()`. Not all properties are however
   * settable. There are also general-purpose accessors `get()` and `set()`. For
   * example, `get('target')` is equivalent to `getTarget()`.
   *
   * The `set` accessors trigger a change event, and you can monitor this by
   * registering a listener. For example, {@link module:ol/View~View} has a
   * `center` property, so `view.on('change:center', function(evt) {...});` would
   * call the function whenever the value of the center property changes. Within
   * the function, `evt.target` would be the view, so `evt.target.getCenter()`
   * would return the new center.
   *
   * You can add your own observable properties with
   * `object.set('prop', 'value')`, and retrieve that with `object.get('prop')`.
   * You can listen for changes on that property value with
   * `object.on('change:prop', listener)`. You can get a list of all
   * properties with {@link module:ol/Object~BaseObject#getProperties}.
   *
   * Note that the observable properties are separate from standard JS properties.
   * You can, for example, give your map object a title with
   * `map.title='New title'` and with `map.set('title', 'Another title')`. The
   * first will be a `hasOwnProperty`; the second will appear in
   * `getProperties()`. Only the second is observable.
   *
   * Properties can be deleted by using the unset method. E.g.
   * object.unset('foo').
   *
   * @fires ObjectEvent
   * @api
   */
  var BaseObject = /*@__PURE__*/(function (Observable$$1) {
    function BaseObject(opt_values) {
      Observable$$1.call(this);

      // Call {@link module:ol/util~getUid} to ensure that the order of objects' ids is
      // the same as the order in which they were created.  This also helps to
      // ensure that object properties are always added in the same order, which
      // helps many JavaScript engines generate faster code.
      getUid(this);

      /**
       * @private
       * @type {!Object<string, *>}
       */
      this.values_ = {};

      if (opt_values !== undefined) {
        this.setProperties(opt_values);
      }
    }

    if ( Observable$$1 ) BaseObject.__proto__ = Observable$$1;
    BaseObject.prototype = Object.create( Observable$$1 && Observable$$1.prototype );
    BaseObject.prototype.constructor = BaseObject;

    /**
     * Gets a value.
     * @param {string} key Key name.
     * @return {*} Value.
     * @api
     */
    BaseObject.prototype.get = function get (key) {
      var value;
      if (this.values_.hasOwnProperty(key)) {
        value = this.values_[key];
      }
      return value;
    };

    /**
     * Get a list of object property names.
     * @return {Array<string>} List of property names.
     * @api
     */
    BaseObject.prototype.getKeys = function getKeys () {
      return Object.keys(this.values_);
    };

    /**
     * Get an object of all property names and values.
     * @return {Object<string, *>} Object.
     * @api
     */
    BaseObject.prototype.getProperties = function getProperties () {
      return assign({}, this.values_);
    };

    /**
     * @param {string} key Key name.
     * @param {*} oldValue Old value.
     */
    BaseObject.prototype.notify = function notify (key, oldValue) {
      var eventType;
      eventType = getChangeEventType(key);
      this.dispatchEvent(new ObjectEvent(eventType, key, oldValue));
      eventType = ObjectEventType.PROPERTYCHANGE;
      this.dispatchEvent(new ObjectEvent(eventType, key, oldValue));
    };

    /**
     * Sets a value.
     * @param {string} key Key name.
     * @param {*} value Value.
     * @param {boolean=} opt_silent Update without triggering an event.
     * @api
     */
    BaseObject.prototype.set = function set (key, value, opt_silent) {
      if (opt_silent) {
        this.values_[key] = value;
      } else {
        var oldValue = this.values_[key];
        this.values_[key] = value;
        if (oldValue !== value) {
          this.notify(key, oldValue);
        }
      }
    };

    /**
     * Sets a collection of key-value pairs.  Note that this changes any existing
     * properties and adds new ones (it does not remove any existing properties).
     * @param {Object<string, *>} values Values.
     * @param {boolean=} opt_silent Update without triggering an event.
     * @api
     */
    BaseObject.prototype.setProperties = function setProperties (values, opt_silent) {
      for (var key in values) {
        this.set(key, values[key], opt_silent);
      }
    };

    /**
     * Unsets a property.
     * @param {string} key Key name.
     * @param {boolean=} opt_silent Unset without triggering an event.
     * @api
     */
    BaseObject.prototype.unset = function unset (key, opt_silent) {
      if (key in this.values_) {
        var oldValue = this.values_[key];
        delete this.values_[key];
        if (!opt_silent) {
          this.notify(key, oldValue);
        }
      }
    };

    return BaseObject;
  }(Observable));


  /**
   * @type {Object<string, string>}
   */
  var changeEventTypeCache = {};


  /**
   * @param {string} key Key name.
   * @return {string} Change name.
   */
  function getChangeEventType(key) {
    return changeEventTypeCache.hasOwnProperty(key) ?
      changeEventTypeCache[key] :
      (changeEventTypeCache[key] = 'change:' + key);
  }

  /**
   * @module ol/Collection
   */


  /**
   * @enum {string}
   * @private
   */
  var Property = {
    LENGTH: 'length'
  };


  /**
   * @classdesc
   * Events emitted by {@link module:ol/Collection~Collection} instances are instances of this
   * type.
   */
  var CollectionEvent = /*@__PURE__*/(function (Event$$1) {
    function CollectionEvent(type, opt_element) {
      Event$$1.call(this, type);

      /**
       * The element that is added to or removed from the collection.
       * @type {*}
       * @api
       */
      this.element = opt_element;

    }

    if ( Event$$1 ) CollectionEvent.__proto__ = Event$$1;
    CollectionEvent.prototype = Object.create( Event$$1 && Event$$1.prototype );
    CollectionEvent.prototype.constructor = CollectionEvent;

    return CollectionEvent;
  }(Event));


  /**
   * @typedef {Object} Options
   * @property {boolean} [unique=false] Disallow the same item from being added to
   * the collection twice.
   */

  /**
   * @classdesc
   * An expanded version of standard JS Array, adding convenience methods for
   * manipulation. Add and remove changes to the Collection trigger a Collection
   * event. Note that this does not cover changes to the objects _within_ the
   * Collection; they trigger events on the appropriate object, not on the
   * Collection as a whole.
   *
   * @fires CollectionEvent
   *
   * @template T
   * @api
   */
  var Collection = /*@__PURE__*/(function (BaseObject$$1) {
    function Collection(opt_array, opt_options) {

      BaseObject$$1.call(this);

      var options = opt_options || {};

      /**
       * @private
       * @type {boolean}
       */
      this.unique_ = !!options.unique;

      /**
       * @private
       * @type {!Array<T>}
       */
      this.array_ = opt_array ? opt_array : [];

      if (this.unique_) {
        for (var i = 0, ii = this.array_.length; i < ii; ++i) {
          this.assertUnique_(this.array_[i], i);
        }
      }

      this.updateLength_();

    }

    if ( BaseObject$$1 ) Collection.__proto__ = BaseObject$$1;
    Collection.prototype = Object.create( BaseObject$$1 && BaseObject$$1.prototype );
    Collection.prototype.constructor = Collection;

    /**
     * Remove all elements from the collection.
     * @api
     */
    Collection.prototype.clear = function clear () {
      while (this.getLength() > 0) {
        this.pop();
      }
    };

    /**
     * Add elements to the collection.  This pushes each item in the provided array
     * to the end of the collection.
     * @param {!Array<T>} arr Array.
     * @return {Collection<T>} This collection.
     * @api
     */
    Collection.prototype.extend = function extend (arr) {
      for (var i = 0, ii = arr.length; i < ii; ++i) {
        this.push(arr[i]);
      }
      return this;
    };

    /**
     * Iterate over each element, calling the provided callback.
     * @param {function(T, number, Array<T>): *} f The function to call
     *     for every element. This function takes 3 arguments (the element, the
     *     index and the array). The return value is ignored.
     * @api
     */
    Collection.prototype.forEach = function forEach (f) {
      var array = this.array_;
      for (var i = 0, ii = array.length; i < ii; ++i) {
        f(array[i], i, array);
      }
    };

    /**
     * Get a reference to the underlying Array object. Warning: if the array
     * is mutated, no events will be dispatched by the collection, and the
     * collection's "length" property won't be in sync with the actual length
     * of the array.
     * @return {!Array<T>} Array.
     * @api
     */
    Collection.prototype.getArray = function getArray () {
      return this.array_;
    };

    /**
     * Get the element at the provided index.
     * @param {number} index Index.
     * @return {T} Element.
     * @api
     */
    Collection.prototype.item = function item (index) {
      return this.array_[index];
    };

    /**
     * Get the length of this collection.
     * @return {number} The length of the array.
     * @observable
     * @api
     */
    Collection.prototype.getLength = function getLength () {
      return this.get(Property.LENGTH);
    };

    /**
     * Insert an element at the provided index.
     * @param {number} index Index.
     * @param {T} elem Element.
     * @api
     */
    Collection.prototype.insertAt = function insertAt (index, elem) {
      if (this.unique_) {
        this.assertUnique_(elem);
      }
      this.array_.splice(index, 0, elem);
      this.updateLength_();
      this.dispatchEvent(
        new CollectionEvent(CollectionEventType.ADD, elem));
    };

    /**
     * Remove the last element of the collection and return it.
     * Return `undefined` if the collection is empty.
     * @return {T|undefined} Element.
     * @api
     */
    Collection.prototype.pop = function pop () {
      return this.removeAt(this.getLength() - 1);
    };

    /**
     * Insert the provided element at the end of the collection.
     * @param {T} elem Element.
     * @return {number} New length of the collection.
     * @api
     */
    Collection.prototype.push = function push (elem) {
      if (this.unique_) {
        this.assertUnique_(elem);
      }
      var n = this.getLength();
      this.insertAt(n, elem);
      return this.getLength();
    };

    /**
     * Remove the first occurrence of an element from the collection.
     * @param {T} elem Element.
     * @return {T|undefined} The removed element or undefined if none found.
     * @api
     */
    Collection.prototype.remove = function remove (elem) {
      var arr = this.array_;
      for (var i = 0, ii = arr.length; i < ii; ++i) {
        if (arr[i] === elem) {
          return this.removeAt(i);
        }
      }
      return undefined;
    };

    /**
     * Remove the element at the provided index and return it.
     * Return `undefined` if the collection does not contain this index.
     * @param {number} index Index.
     * @return {T|undefined} Value.
     * @api
     */
    Collection.prototype.removeAt = function removeAt (index) {
      var prev = this.array_[index];
      this.array_.splice(index, 1);
      this.updateLength_();
      this.dispatchEvent(new CollectionEvent(CollectionEventType.REMOVE, prev));
      return prev;
    };

    /**
     * Set the element at the provided index.
     * @param {number} index Index.
     * @param {T} elem Element.
     * @api
     */
    Collection.prototype.setAt = function setAt (index, elem) {
      var n = this.getLength();
      if (index < n) {
        if (this.unique_) {
          this.assertUnique_(elem, index);
        }
        var prev = this.array_[index];
        this.array_[index] = elem;
        this.dispatchEvent(
          new CollectionEvent(CollectionEventType.REMOVE, prev));
        this.dispatchEvent(
          new CollectionEvent(CollectionEventType.ADD, elem));
      } else {
        for (var j = n; j < index; ++j) {
          this.insertAt(j, undefined);
        }
        this.insertAt(index, elem);
      }
    };

    /**
     * @private
     */
    Collection.prototype.updateLength_ = function updateLength_ () {
      this.set(Property.LENGTH, this.array_.length);
    };

    /**
     * @private
     * @param {T} elem Element.
     * @param {number=} opt_except Optional index to ignore.
     */
    Collection.prototype.assertUnique_ = function assertUnique_ (elem, opt_except) {
      for (var i = 0, ii = this.array_.length; i < ii; ++i) {
        if (this.array_[i] === elem && i !== opt_except) {
          throw new AssertionError(58);
        }
      }
    };

    return Collection;
  }(BaseObject));

  /**
   * @module ol/MapEvent
   */

  /**
   * @classdesc
   * Events emitted as map events are instances of this type.
   * See {@link module:ol/PluggableMap~PluggableMap} for which events trigger a map event.
   */
  var MapEvent = /*@__PURE__*/(function (Event$$1) {
    function MapEvent(type, map, opt_frameState) {

      Event$$1.call(this, type);

      /**
       * The map where the event occurred.
       * @type {import("./PluggableMap.js").default}
       * @api
       */
      this.map = map;

      /**
       * The frame state at the time of the event.
       * @type {?import("./PluggableMap.js").FrameState}
       * @api
       */
      this.frameState = opt_frameState !== undefined ? opt_frameState : null;

    }

    if ( Event$$1 ) MapEvent.__proto__ = Event$$1;
    MapEvent.prototype = Object.create( Event$$1 && Event$$1.prototype );
    MapEvent.prototype.constructor = MapEvent;

    return MapEvent;
  }(Event));

  /**
   * @module ol/MapBrowserEvent
   */

  /**
   * @classdesc
   * Events emitted as map browser events are instances of this type.
   * See {@link module:ol/PluggableMap~PluggableMap} for which events trigger a map browser event.
   */
  var MapBrowserEvent = /*@__PURE__*/(function (MapEvent$$1) {
    function MapBrowserEvent(type, map, browserEvent, opt_dragging, opt_frameState) {

      MapEvent$$1.call(this, type, map, opt_frameState);

      /**
       * The original browser event.
       * @const
       * @type {Event}
       * @api
       */
      this.originalEvent = browserEvent;

      /**
       * The map pixel relative to the viewport corresponding to the original browser event.
       * @type {import("./pixel.js").Pixel}
       * @api
       */
      this.pixel = map.getEventPixel(browserEvent);

      /**
       * The coordinate in view projection corresponding to the original browser event.
       * @type {import("./coordinate.js").Coordinate}
       * @api
       */
      this.coordinate = map.getCoordinateFromPixel(this.pixel);

      /**
       * Indicates if the map is currently being dragged. Only set for
       * `POINTERDRAG` and `POINTERMOVE` events. Default is `false`.
       *
       * @type {boolean}
       * @api
       */
      this.dragging = opt_dragging !== undefined ? opt_dragging : false;

    }

    if ( MapEvent$$1 ) MapBrowserEvent.__proto__ = MapEvent$$1;
    MapBrowserEvent.prototype = Object.create( MapEvent$$1 && MapEvent$$1.prototype );
    MapBrowserEvent.prototype.constructor = MapBrowserEvent;

    /**
     * Prevents the default browser action.
     * See https://developer.mozilla.org/en-US/docs/Web/API/event.preventDefault.
     * @override
     * @api
     */
    MapBrowserEvent.prototype.preventDefault = function preventDefault () {
      MapEvent$$1.prototype.preventDefault.call(this);
      this.originalEvent.preventDefault();
    };

    /**
     * Prevents further propagation of the current event.
     * See https://developer.mozilla.org/en-US/docs/Web/API/event.stopPropagation.
     * @override
     * @api
     */
    MapBrowserEvent.prototype.stopPropagation = function stopPropagation () {
      MapEvent$$1.prototype.stopPropagation.call(this);
      this.originalEvent.stopPropagation();
    };

    return MapBrowserEvent;
  }(MapEvent));

  /**
   * @module ol/webgl
   */


  /**
   * Constants taken from goog.webgl
   */


  /**
   * @const
   * @type {number}
   */
  var ONE = 1;


  /**
   * @const
   * @type {number}
   */
  var SRC_ALPHA = 0x0302;


  /**
   * @const
   * @type {number}
   */
  var COLOR_ATTACHMENT0 = 0x8CE0;


  /**
   * @const
   * @type {number}
   */
  var COLOR_BUFFER_BIT = 0x00004000;


  /**
   * @const
   * @type {number}
   */
  var TRIANGLES = 0x0004;


  /**
   * @const
   * @type {number}
   */
  var TRIANGLE_STRIP = 0x0005;


  /**
   * @const
   * @type {number}
   */
  var ONE_MINUS_SRC_ALPHA = 0x0303;


  /**
   * @const
   * @type {number}
   */
  var ARRAY_BUFFER = 0x8892;


  /**
   * @const
   * @type {number}
   */
  var ELEMENT_ARRAY_BUFFER = 0x8893;


  /**
   * @const
   * @type {number}
   */
  var STREAM_DRAW = 0x88E0;


  /**
   * @const
   * @type {number}
   */
  var STATIC_DRAW = 0x88E4;


  /**
   * @const
   * @type {number}
   */
  var DYNAMIC_DRAW = 0x88E8;


  /**
   * @const
   * @type {number}
   */
  var CULL_FACE = 0x0B44;


  /**
   * @const
   * @type {number}
   */
  var BLEND = 0x0BE2;


  /**
   * @const
   * @type {number}
   */
  var STENCIL_TEST = 0x0B90;


  /**
   * @const
   * @type {number}
   */
  var DEPTH_TEST = 0x0B71;


  /**
   * @const
   * @type {number}
   */
  var SCISSOR_TEST = 0x0C11;


  /**
   * @const
   * @type {number}
   */
  var UNSIGNED_BYTE = 0x1401;


  /**
   * @const
   * @type {number}
   */
  var UNSIGNED_SHORT = 0x1403;


  /**
   * @const
   * @type {number}
   */
  var UNSIGNED_INT = 0x1405;


  /**
   * @const
   * @type {number}
   */
  var FLOAT = 0x1406;


  /**
   * @const
   * @type {number}
   */
  var RGBA = 0x1908;


  /**
   * @const
   * @type {number}
   */
  var FRAGMENT_SHADER = 0x8B30;


  /**
   * @const
   * @type {number}
   */
  var VERTEX_SHADER = 0x8B31;


  /**
   * @const
   * @type {number}
   */
  var LINEAR = 0x2601;


  /**
   * @const
   * @type {number}
   */
  var TEXTURE_MAG_FILTER = 0x2800;


  /**
   * @const
   * @type {number}
   */
  var TEXTURE_MIN_FILTER = 0x2801;


  /**
   * @const
   * @type {number}
   */
  var TEXTURE_WRAP_S = 0x2802;


  /**
   * @const
   * @type {number}
   */
  var TEXTURE_WRAP_T = 0x2803;


  /**
   * @const
   * @type {number}
   */
  var TEXTURE_2D = 0x0DE1;


  /**
   * @const
   * @type {number}
   */
  var TEXTURE0 = 0x84C0;


  /**
   * @const
   * @type {number}
   */
  var CLAMP_TO_EDGE = 0x812F;


  /**
   * @const
   * @type {number}
   */
  var FRAMEBUFFER = 0x8D40;


  /** end of goog.webgl constants
   */


  /**
   * @const
   * @type {Array<string>}
   */
  var CONTEXT_IDS = [
    'experimental-webgl',
    'webgl',
    'webkit-3d',
    'moz-webgl'
  ];


  /**
   * @param {HTMLCanvasElement} canvas Canvas.
   * @param {Object=} opt_attributes Attributes.
   * @return {WebGLRenderingContext} WebGL rendering context.
   */
  function getContext(canvas, opt_attributes) {
    var ii = CONTEXT_IDS.length;
    for (var i = 0; i < ii; ++i) {
      try {
        var context = canvas.getContext(CONTEXT_IDS[i], opt_attributes);
        if (context) {
          return /** @type {!WebGLRenderingContext} */ (context);
        }
      } catch (e) {
        // pass
      }
    }
    return null;
  }


  /**
   * The maximum supported WebGL texture size in pixels. If WebGL is not
   * supported, the value is set to `undefined`.
   * @type {number|undefined}
   */
  var MAX_TEXTURE_SIZE; // value is set below


  /**
   * List of supported WebGL extensions.
   * @type {Array<string>}
   */
  var EXTENSIONS; // value is set below

  //TODO Remove side effects
  if (typeof window !== 'undefined' && 'WebGLRenderingContext' in window) {
    try {
      var canvas = /** @type {HTMLCanvasElement} */ (document.createElement('canvas'));
      var gl = getContext(canvas, {failIfMajorPerformanceCaveat: true});
      if (gl) {
        MAX_TEXTURE_SIZE = /** @type {number} */ (gl.getParameter(gl.MAX_TEXTURE_SIZE));
        EXTENSIONS = gl.getSupportedExtensions();
      }
    } catch (e) {
      // pass
    }
  }

  /**
   * @module ol/has
   */

  var ua = typeof navigator !== 'undefined' ?
    navigator.userAgent.toLowerCase() : '';

  /**
   * User agent string says we are dealing with Firefox as browser.
   * @type {boolean}
   */
  var FIREFOX = ua.indexOf('firefox') !== -1;

  /**
   * User agent string says we are dealing with Safari as browser.
   * @type {boolean}
   */
  var SAFARI = ua.indexOf('safari') !== -1 && ua.indexOf('chrom') == -1;

  /**
   * User agent string says we are dealing with a WebKit engine.
   * @type {boolean}
   */
  var WEBKIT = ua.indexOf('webkit') !== -1 && ua.indexOf('edge') == -1;

  /**
   * User agent string says we are dealing with a Mac as platform.
   * @type {boolean}
   */
  var MAC = ua.indexOf('macintosh') !== -1;


  /**
   * The ratio between physical pixels and device-independent pixels
   * (dips) on the device (`window.devicePixelRatio`).
   * @const
   * @type {number}
   * @api
   */
  var DEVICE_PIXEL_RATIO = window.devicePixelRatio || 1;


  /**
   * True if the browser's Canvas implementation implements {get,set}LineDash.
   * @type {boolean}
   */
  var CANVAS_LINE_DASH = function() {
    var has = false;
    try {
      has = !!document.createElement('canvas').getContext('2d').setLineDash;
    } catch (e) {
      // pass
    }
    return has;
  }();


  /**
   * True if browser supports touch events.
   * @const
   * @type {boolean}
   * @api
   */
  var TOUCH = 'ontouchstart' in window;


  /**
   * True if browser supports pointer events.
   * @const
   * @type {boolean}
   */
  var POINTER = 'PointerEvent' in window;


  /**
   * True if browser supports ms pointer events (IE 10).
   * @const
   * @type {boolean}
   */
  var MSPOINTER = !!(navigator.msPointerEnabled);

  /**
   * @module ol/MapBrowserEventType
   */

  /**
   * Constants for event names.
   * @enum {string}
   */
  var MapBrowserEventType = {

    /**
     * A true single click with no dragging and no double click. Note that this
     * event is delayed by 250 ms to ensure that it is not a double click.
     * @event module:ol/MapBrowserEvent~MapBrowserEvent#singleclick
     * @api
     */
    SINGLECLICK: 'singleclick',

    /**
     * A click with no dragging. A double click will fire two of this.
     * @event module:ol/MapBrowserEvent~MapBrowserEvent#click
     * @api
     */
    CLICK: EventType.CLICK,

    /**
     * A true double click, with no dragging.
     * @event module:ol/MapBrowserEvent~MapBrowserEvent#dblclick
     * @api
     */
    DBLCLICK: EventType.DBLCLICK,

    /**
     * Triggered when a pointer is dragged.
     * @event module:ol/MapBrowserEvent~MapBrowserEvent#pointerdrag
     * @api
     */
    POINTERDRAG: 'pointerdrag',

    /**
     * Triggered when a pointer is moved. Note that on touch devices this is
     * triggered when the map is panned, so is not the same as mousemove.
     * @event module:ol/MapBrowserEvent~MapBrowserEvent#pointermove
     * @api
     */
    POINTERMOVE: 'pointermove',

    POINTERDOWN: 'pointerdown',
    POINTERUP: 'pointerup',
    POINTEROVER: 'pointerover',
    POINTEROUT: 'pointerout',
    POINTERENTER: 'pointerenter',
    POINTERLEAVE: 'pointerleave',
    POINTERCANCEL: 'pointercancel'
  };

  /**
   * @module ol/MapBrowserPointerEvent
   */

  var MapBrowserPointerEvent = /*@__PURE__*/(function (MapBrowserEvent$$1) {
    function MapBrowserPointerEvent(type, map, pointerEvent, opt_dragging, opt_frameState) {

      MapBrowserEvent$$1.call(this, type, map, pointerEvent.originalEvent, opt_dragging, opt_frameState);

      /**
       * @const
       * @type {import("./pointer/PointerEvent.js").default}
       */
      this.pointerEvent = pointerEvent;

    }

    if ( MapBrowserEvent$$1 ) MapBrowserPointerEvent.__proto__ = MapBrowserEvent$$1;
    MapBrowserPointerEvent.prototype = Object.create( MapBrowserEvent$$1 && MapBrowserEvent$$1.prototype );
    MapBrowserPointerEvent.prototype.constructor = MapBrowserPointerEvent;

    return MapBrowserPointerEvent;
  }(MapBrowserEvent));

  /**
   * @module ol/pointer/EventType
   */

  /**
   * Constants for event names.
   * @enum {string}
   */
  var PointerEventType = {
    POINTERMOVE: 'pointermove',
    POINTERDOWN: 'pointerdown',
    POINTERUP: 'pointerup',
    POINTEROVER: 'pointerover',
    POINTEROUT: 'pointerout',
    POINTERENTER: 'pointerenter',
    POINTERLEAVE: 'pointerleave',
    POINTERCANCEL: 'pointercancel'
  };

  /**
   * @module ol/pointer/EventSource
   */

  var EventSource = function EventSource(dispatcher, mapping) {

    /**
     * @type {import("./PointerEventHandler.js").default}
     */
    this.dispatcher = dispatcher;

    /**
     * @private
     * @const
     * @type {!Object<string, function(Event)>}
     */
    this.mapping_ = mapping;
  };

  /**
   * List of events supported by this source.
   * @return {Array<string>} Event names
   */
  EventSource.prototype.getEvents = function getEvents () {
    return Object.keys(this.mapping_);
  };

  /**
   * Returns the handler that should handle a given event type.
   * @param {string} eventType The event type.
   * @return {function(Event)} Handler
   */
  EventSource.prototype.getHandlerForEvent = function getHandlerForEvent (eventType) {
    return this.mapping_[eventType];
  };

  /**
   * @module ol/pointer/MouseSource
   */


  /**
   * @type {number}
   */
  var POINTER_ID = 1;


  /**
   * @type {string}
   */
  var POINTER_TYPE = 'mouse';


  /**
   * Radius around touchend that swallows mouse events.
   *
   * @type {number}
   */
  var DEDUP_DIST = 25;

  /**
   * Handler for `mousedown`.
   *
   * @this {MouseSource}
   * @param {MouseEvent} inEvent The in event.
   */
  function mousedown(inEvent) {
    if (!this.isEventSimulatedFromTouch_(inEvent)) {
      // TODO(dfreedman) workaround for some elements not sending mouseup
      // http://crbug/149091
      if (POINTER_ID.toString() in this.pointerMap) {
        this.cancel(inEvent);
      }
      var e = prepareEvent(inEvent, this.dispatcher);
      this.pointerMap[POINTER_ID.toString()] = inEvent;
      this.dispatcher.down(e, inEvent);
    }
  }

  /**
   * Handler for `mousemove`.
   *
   * @this {MouseSource}
   * @param {MouseEvent} inEvent The in event.
   */
  function mousemove(inEvent) {
    if (!this.isEventSimulatedFromTouch_(inEvent)) {
      var e = prepareEvent(inEvent, this.dispatcher);
      this.dispatcher.move(e, inEvent);
    }
  }

  /**
   * Handler for `mouseup`.
   *
   * @this {MouseSource}
   * @param {MouseEvent} inEvent The in event.
   */
  function mouseup(inEvent) {
    if (!this.isEventSimulatedFromTouch_(inEvent)) {
      var p = this.pointerMap[POINTER_ID.toString()];

      if (p && p.button === inEvent.button) {
        var e = prepareEvent(inEvent, this.dispatcher);
        this.dispatcher.up(e, inEvent);
        this.cleanupMouse();
      }
    }
  }

  /**
   * Handler for `mouseover`.
   *
   * @this {MouseSource}
   * @param {MouseEvent} inEvent The in event.
   */
  function mouseover(inEvent) {
    if (!this.isEventSimulatedFromTouch_(inEvent)) {
      var e = prepareEvent(inEvent, this.dispatcher);
      this.dispatcher.enterOver(e, inEvent);
    }
  }

  /**
   * Handler for `mouseout`.
   *
   * @this {MouseSource}
   * @param {MouseEvent} inEvent The in event.
   */
  function mouseout(inEvent) {
    if (!this.isEventSimulatedFromTouch_(inEvent)) {
      var e = prepareEvent(inEvent, this.dispatcher);
      this.dispatcher.leaveOut(e, inEvent);
    }
  }


  var MouseSource = /*@__PURE__*/(function (EventSource$$1) {
    function MouseSource(dispatcher) {
      var mapping = {
        'mousedown': mousedown,
        'mousemove': mousemove,
        'mouseup': mouseup,
        'mouseover': mouseover,
        'mouseout': mouseout
      };
      EventSource$$1.call(this, dispatcher, mapping);

      /**
       * @const
       * @type {!Object<string, Event|Object>}
       */
      this.pointerMap = dispatcher.pointerMap;

      /**
       * @const
       * @type {Array<import("../pixel.js").Pixel>}
       */
      this.lastTouches = [];
    }

    if ( EventSource$$1 ) MouseSource.__proto__ = EventSource$$1;
    MouseSource.prototype = Object.create( EventSource$$1 && EventSource$$1.prototype );
    MouseSource.prototype.constructor = MouseSource;

    /**
     * Detect if a mouse event was simulated from a touch by
     * checking if previously there was a touch event at the
     * same position.
     *
     * FIXME - Known problem with the native Android browser on
     * Samsung GT-I9100 (Android 4.1.2):
     * In case the page is scrolled, this function does not work
     * correctly when a canvas is used (WebGL or canvas renderer).
     * Mouse listeners on canvas elements (for this browser), create
     * two mouse events: One 'good' and one 'bad' one (on other browsers or
     * when a div is used, there is only one event). For the 'bad' one,
     * clientX/clientY and also pageX/pageY are wrong when the page
     * is scrolled. Because of that, this function can not detect if
     * the events were simulated from a touch event. As result, a
     * pointer event at a wrong position is dispatched, which confuses
     * the map interactions.
     * It is unclear, how one can get the correct position for the event
     * or detect that the positions are invalid.
     *
     * @private
     * @param {MouseEvent} inEvent The in event.
     * @return {boolean} True, if the event was generated by a touch.
     */
    MouseSource.prototype.isEventSimulatedFromTouch_ = function isEventSimulatedFromTouch_ (inEvent) {
      var lts = this.lastTouches;
      var x = inEvent.clientX;
      var y = inEvent.clientY;
      for (var i = 0, l = lts.length, t = (void 0); i < l && (t = lts[i]); i++) {
        // simulated mouse events will be swallowed near a primary touchend
        var dx = Math.abs(x - t[0]);
        var dy = Math.abs(y - t[1]);
        if (dx <= DEDUP_DIST && dy <= DEDUP_DIST) {
          return true;
        }
      }
      return false;
    };

    /**
     * Dispatches a `pointercancel` event.
     *
     * @param {Event} inEvent The in event.
     */
    MouseSource.prototype.cancel = function cancel (inEvent) {
      var e = prepareEvent(inEvent, this.dispatcher);
      this.dispatcher.cancel(e, inEvent);
      this.cleanupMouse();
    };

    /**
     * Remove the mouse from the list of active pointers.
     */
    MouseSource.prototype.cleanupMouse = function cleanupMouse () {
      delete this.pointerMap[POINTER_ID.toString()];
    };

    return MouseSource;
  }(EventSource));


  /**
   * Creates a copy of the original event that will be used
   * for the fake pointer event.
   *
   * @param {Event} inEvent The in event.
   * @param {import("./PointerEventHandler.js").default} dispatcher Event handler.
   * @return {Object} The copied event.
   */
  function prepareEvent(inEvent, dispatcher) {
    var e = dispatcher.cloneEvent(inEvent, inEvent);

    // forward mouse preventDefault
    var pd = e.preventDefault;
    e.preventDefault = function() {
      inEvent.preventDefault();
      pd();
    };

    e.pointerId = POINTER_ID;
    e.isPrimary = true;
    e.pointerType = POINTER_TYPE;

    return e;
  }

  /**
   * @module ol/pointer/MsSource
   */


  /**
   * @const
   * @type {Array<string>}
   */
  var POINTER_TYPES = [
    '',
    'unavailable',
    'touch',
    'pen',
    'mouse'
  ];

  /**
   * Handler for `msPointerDown`.
   *
   * @this {MsSource}
   * @param {MSPointerEvent} inEvent The in event.
   */
  function msPointerDown(inEvent) {
    this.pointerMap[inEvent.pointerId.toString()] = inEvent;
    var e = this.prepareEvent_(inEvent);
    this.dispatcher.down(e, inEvent);
  }

  /**
   * Handler for `msPointerMove`.
   *
   * @this {MsSource}
   * @param {MSPointerEvent} inEvent The in event.
   */
  function msPointerMove(inEvent) {
    var e = this.prepareEvent_(inEvent);
    this.dispatcher.move(e, inEvent);
  }

  /**
   * Handler for `msPointerUp`.
   *
   * @this {MsSource}
   * @param {MSPointerEvent} inEvent The in event.
   */
  function msPointerUp(inEvent) {
    var e = this.prepareEvent_(inEvent);
    this.dispatcher.up(e, inEvent);
    this.cleanup(inEvent.pointerId);
  }

  /**
   * Handler for `msPointerOut`.
   *
   * @this {MsSource}
   * @param {MSPointerEvent} inEvent The in event.
   */
  function msPointerOut(inEvent) {
    var e = this.prepareEvent_(inEvent);
    this.dispatcher.leaveOut(e, inEvent);
  }

  /**
   * Handler for `msPointerOver`.
   *
   * @this {MsSource}
   * @param {MSPointerEvent} inEvent The in event.
   */
  function msPointerOver(inEvent) {
    var e = this.prepareEvent_(inEvent);
    this.dispatcher.enterOver(e, inEvent);
  }

  /**
   * Handler for `msPointerCancel`.
   *
   * @this {MsSource}
   * @param {MSPointerEvent} inEvent The in event.
   */
  function msPointerCancel(inEvent) {
    var e = this.prepareEvent_(inEvent);
    this.dispatcher.cancel(e, inEvent);
    this.cleanup(inEvent.pointerId);
  }

  /**
   * Handler for `msLostPointerCapture`.
   *
   * @this {MsSource}
   * @param {MSPointerEvent} inEvent The in event.
   */
  function msLostPointerCapture(inEvent) {
    var e = this.dispatcher.makeEvent('lostpointercapture', inEvent, inEvent);
    this.dispatcher.dispatchEvent(e);
  }

  /**
   * Handler for `msGotPointerCapture`.
   *
   * @this {MsSource}
   * @param {MSPointerEvent} inEvent The in event.
   */
  function msGotPointerCapture(inEvent) {
    var e = this.dispatcher.makeEvent('gotpointercapture', inEvent, inEvent);
    this.dispatcher.dispatchEvent(e);
  }

  var MsSource = /*@__PURE__*/(function (EventSource$$1) {
    function MsSource(dispatcher) {
      var mapping = {
        'MSPointerDown': msPointerDown,
        'MSPointerMove': msPointerMove,
        'MSPointerUp': msPointerUp,
        'MSPointerOut': msPointerOut,
        'MSPointerOver': msPointerOver,
        'MSPointerCancel': msPointerCancel,
        'MSGotPointerCapture': msGotPointerCapture,
        'MSLostPointerCapture': msLostPointerCapture
      };
      EventSource$$1.call(this, dispatcher, mapping);

      /**
       * @const
       * @type {!Object<string, MSPointerEvent|Object>}
       */
      this.pointerMap = dispatcher.pointerMap;
    }

    if ( EventSource$$1 ) MsSource.__proto__ = EventSource$$1;
    MsSource.prototype = Object.create( EventSource$$1 && EventSource$$1.prototype );
    MsSource.prototype.constructor = MsSource;

    /**
     * Creates a copy of the original event that will be used
     * for the fake pointer event.
     *
     * @private
     * @param {MSPointerEvent} inEvent The in event.
     * @return {Object} The copied event.
     */
    MsSource.prototype.prepareEvent_ = function prepareEvent_ (inEvent) {
      /** @type {MSPointerEvent|Object} */
      var e = inEvent;
      if (typeof inEvent.pointerType === 'number') {
        e = this.dispatcher.cloneEvent(inEvent, inEvent);
        e.pointerType = POINTER_TYPES[inEvent.pointerType];
      }

      return e;
    };

    /**
     * Remove this pointer from the list of active pointers.
     * @param {number} pointerId Pointer identifier.
     */
    MsSource.prototype.cleanup = function cleanup (pointerId) {
      delete this.pointerMap[pointerId.toString()];
    };

    return MsSource;
  }(EventSource));

  /**
   * @module ol/pointer/NativeSource
   */

  /**
   * Handler for `pointerdown`.
   *
   * @this {NativeSource}
   * @param {Event} inEvent The in event.
   */
  function pointerDown(inEvent) {
    this.dispatcher.fireNativeEvent(inEvent);
  }

  /**
   * Handler for `pointermove`.
   *
   * @this {NativeSource}
   * @param {Event} inEvent The in event.
   */
  function pointerMove(inEvent) {
    this.dispatcher.fireNativeEvent(inEvent);
  }

  /**
   * Handler for `pointerup`.
   *
   * @this {NativeSource}
   * @param {Event} inEvent The in event.
   */
  function pointerUp(inEvent) {
    this.dispatcher.fireNativeEvent(inEvent);
  }

  /**
   * Handler for `pointerout`.
   *
   * @this {NativeSource}
   * @param {Event} inEvent The in event.
   */
  function pointerOut(inEvent) {
    this.dispatcher.fireNativeEvent(inEvent);
  }

  /**
   * Handler for `pointerover`.
   *
   * @this {NativeSource}
   * @param {Event} inEvent The in event.
   */
  function pointerOver(inEvent) {
    this.dispatcher.fireNativeEvent(inEvent);
  }

  /**
   * Handler for `pointercancel`.
   *
   * @this {NativeSource}
   * @param {Event} inEvent The in event.
   */
  function pointerCancel(inEvent) {
    this.dispatcher.fireNativeEvent(inEvent);
  }

  /**
   * Handler for `lostpointercapture`.
   *
   * @this {NativeSource}
   * @param {Event} inEvent The in event.
   */
  function lostPointerCapture(inEvent) {
    this.dispatcher.fireNativeEvent(inEvent);
  }

  /**
   * Handler for `gotpointercapture`.
   *
   * @this {NativeSource}
   * @param {Event} inEvent The in event.
   */
  function gotPointerCapture(inEvent) {
    this.dispatcher.fireNativeEvent(inEvent);
  }

  var NativeSource = /*@__PURE__*/(function (EventSource$$1) {
    function NativeSource(dispatcher) {
      var mapping = {
        'pointerdown': pointerDown,
        'pointermove': pointerMove,
        'pointerup': pointerUp,
        'pointerout': pointerOut,
        'pointerover': pointerOver,
        'pointercancel': pointerCancel,
        'gotpointercapture': gotPointerCapture,
        'lostpointercapture': lostPointerCapture
      };
      EventSource$$1.call(this, dispatcher, mapping);
    }

    if ( EventSource$$1 ) NativeSource.__proto__ = EventSource$$1;
    NativeSource.prototype = Object.create( EventSource$$1 && EventSource$$1.prototype );
    NativeSource.prototype.constructor = NativeSource;

    return NativeSource;
  }(EventSource));

  /**
   * @module ol/pointer/PointerEvent
   */


  /**
   * Is the `buttons` property supported?
   * @type {boolean}
   */
  var HAS_BUTTONS = false;


  var PointerEvent = /*@__PURE__*/(function (_Event) {
    function PointerEvent(type, originalEvent, opt_eventDict) {
      _Event.call(this, type);

      /**
       * @const
       * @type {Event}
       */
      this.originalEvent = originalEvent;

      var eventDict = opt_eventDict ? opt_eventDict : {};

      /**
       * @type {number}
       */
      this.buttons = getButtons(eventDict);

      /**
       * @type {number}
       */
      this.pressure = getPressure(eventDict, this.buttons);

      // MouseEvent related properties

      /**
       * @type {boolean}
       */
      this.bubbles = 'bubbles' in eventDict ? eventDict['bubbles'] : false;

      /**
       * @type {boolean}
       */
      this.cancelable = 'cancelable' in eventDict ? eventDict['cancelable'] : false;

      /**
       * @type {Object}
       */
      this.view = 'view' in eventDict ? eventDict['view'] : null;

      /**
       * @type {number}
       */
      this.detail = 'detail' in eventDict ? eventDict['detail'] : null;

      /**
       * @type {number}
       */
      this.screenX = 'screenX' in eventDict ? eventDict['screenX'] : 0;

      /**
       * @type {number}
       */
      this.screenY = 'screenY' in eventDict ? eventDict['screenY'] : 0;

      /**
       * @type {number}
       */
      this.clientX = 'clientX' in eventDict ? eventDict['clientX'] : 0;

      /**
       * @type {number}
       */
      this.clientY = 'clientY' in eventDict ? eventDict['clientY'] : 0;

      /**
       * @type {boolean}
       */
      this.ctrlKey = 'ctrlKey' in eventDict ? eventDict['ctrlKey'] : false;

      /**
       * @type {boolean}
       */
      this.altKey = 'altKey' in eventDict ? eventDict['altKey'] : false;

      /**
       * @type {boolean}
       */
      this.shiftKey = 'shiftKey' in eventDict ? eventDict['shiftKey'] : false;

      /**
       * @type {boolean}
       */
      this.metaKey = 'metaKey' in eventDict ? eventDict['metaKey'] : false;

      /**
       * @type {number}
       */
      this.button = 'button' in eventDict ? eventDict['button'] : 0;

      /**
       * @type {Node}
       */
      this.relatedTarget = 'relatedTarget' in eventDict ?
        eventDict['relatedTarget'] : null;

      // PointerEvent related properties

      /**
       * @const
       * @type {number}
       */
      this.pointerId = 'pointerId' in eventDict ? eventDict['pointerId'] : 0;

      /**
       * @type {number}
       */
      this.width = 'width' in eventDict ? eventDict['width'] : 0;

      /**
       * @type {number}
       */
      this.height = 'height' in eventDict ? eventDict['height'] : 0;

      /**
       * @type {number}
       */
      this.tiltX = 'tiltX' in eventDict ? eventDict['tiltX'] : 0;

      /**
       * @type {number}
       */
      this.tiltY = 'tiltY' in eventDict ? eventDict['tiltY'] : 0;

      /**
       * @type {string}
       */
      this.pointerType = 'pointerType' in eventDict ? eventDict['pointerType'] : '';

      /**
       * @type {number}
       */
      this.hwTimestamp = 'hwTimestamp' in eventDict ? eventDict['hwTimestamp'] : 0;

      /**
       * @type {boolean}
       */
      this.isPrimary = 'isPrimary' in eventDict ? eventDict['isPrimary'] : false;

      // keep the semantics of preventDefault
      if (originalEvent.preventDefault) {
        this.preventDefault = function() {
          originalEvent.preventDefault();
        };
      }
    }

    if ( _Event ) PointerEvent.__proto__ = _Event;
    PointerEvent.prototype = Object.create( _Event && _Event.prototype );
    PointerEvent.prototype.constructor = PointerEvent;

    return PointerEvent;
  }(Event));


  /**
   * @param {Object<string, ?>} eventDict The event dictionary.
   * @return {number} Button indicator.
   */
  function getButtons(eventDict) {
    // According to the w3c spec,
    // http://www.w3.org/TR/DOM-Level-3-Events/#events-MouseEvent-button
    // MouseEvent.button == 0 can mean either no mouse button depressed, or the
    // left mouse button depressed.
    //
    // As of now, the only way to distinguish between the two states of
    // MouseEvent.button is by using the deprecated MouseEvent.which property, as
    // this maps mouse buttons to positive integers > 0, and uses 0 to mean that
    // no mouse button is held.
    //
    // MouseEvent.which is derived from MouseEvent.button at MouseEvent creation,
    // but initMouseEvent does not expose an argument with which to set
    // MouseEvent.which. Calling initMouseEvent with a buttonArg of 0 will set
    // MouseEvent.button == 0 and MouseEvent.which == 1, breaking the expectations
    // of app developers.
    //
    // The only way to propagate the correct state of MouseEvent.which and
    // MouseEvent.button to a new MouseEvent.button == 0 and MouseEvent.which == 0
    // is to call initMouseEvent with a buttonArg value of -1.
    //
    // This is fixed with DOM Level 4's use of buttons
    var buttons;
    if (eventDict.buttons || HAS_BUTTONS) {
      buttons = eventDict.buttons;
    } else {
      switch (eventDict.which) {
        case 1: buttons = 1; break;
        case 2: buttons = 4; break;
        case 3: buttons = 2; break;
        default: buttons = 0;
      }
    }
    return buttons;
  }


  /**
   * @param {Object<string, ?>} eventDict The event dictionary.
   * @param {number} buttons Button indicator.
   * @return {number} The pressure.
   */
  function getPressure(eventDict, buttons) {
    // Spec requires that pointers without pressure specified use 0.5 for down
    // state and 0 for up state.
    var pressure = 0;
    if (eventDict.pressure) {
      pressure = eventDict.pressure;
    } else {
      pressure = buttons ? 0.5 : 0;
    }
    return pressure;
  }


  /**
   * Checks if the `buttons` property is supported.
   */
  (function() {
    try {
      var ev = new MouseEvent('click', {buttons: 1});
      HAS_BUTTONS = ev.buttons === 1;
    } catch (e) {
      // pass
    }
  })();

  /**
   * @module ol/array
   */


  /**
   * Performs a binary search on the provided sorted list and returns the index of the item if found. If it can't be found it'll return -1.
   * https://github.com/darkskyapp/binary-search
   *
   * @param {Array<*>} haystack Items to search through.
   * @param {*} needle The item to look for.
   * @param {Function=} opt_comparator Comparator function.
   * @return {number} The index of the item if found, -1 if not.
   */
  function binarySearch(haystack, needle, opt_comparator) {
    var mid, cmp;
    var comparator = opt_comparator || numberSafeCompareFunction;
    var low = 0;
    var high = haystack.length;
    var found = false;

    while (low < high) {
      /* Note that "(low + high) >>> 1" may overflow, and results in a typecast
       * to double (which gives the wrong results). */
      mid = low + (high - low >> 1);
      cmp = +comparator(haystack[mid], needle);

      if (cmp < 0.0) { /* Too low. */
        low = mid + 1;

      } else { /* Key found or too high */
        high = mid;
        found = !cmp;
      }
    }

    /* Key not found. */
    return found ? low : ~low;
  }


  /**
   * Compare function for array sort that is safe for numbers.
   * @param {*} a The first object to be compared.
   * @param {*} b The second object to be compared.
   * @return {number} A negative number, zero, or a positive number as the first
   *     argument is less than, equal to, or greater than the second.
   */
  function numberSafeCompareFunction(a, b) {
    return a > b ? 1 : a < b ? -1 : 0;
  }


  /**
   * Whether the array contains the given object.
   * @param {Array<*>} arr The array to test for the presence of the element.
   * @param {*} obj The object for which to test.
   * @return {boolean} The object is in the array.
   */
  function includes(arr, obj) {
    return arr.indexOf(obj) >= 0;
  }


  /**
   * @param {Array<number>} arr Array.
   * @param {number} target Target.
   * @param {number} direction 0 means return the nearest, > 0
   *    means return the largest nearest, < 0 means return the
   *    smallest nearest.
   * @return {number} Index.
   */
  function linearFindNearest(arr, target, direction) {
    var n = arr.length;
    if (arr[0] <= target) {
      return 0;
    } else if (target <= arr[n - 1]) {
      return n - 1;
    } else {
      var i;
      if (direction > 0) {
        for (i = 1; i < n; ++i) {
          if (arr[i] < target) {
            return i - 1;
          }
        }
      } else if (direction < 0) {
        for (i = 1; i < n; ++i) {
          if (arr[i] <= target) {
            return i;
          }
        }
      } else {
        for (i = 1; i < n; ++i) {
          if (arr[i] == target) {
            return i;
          } else if (arr[i] < target) {
            if (arr[i - 1] - target < target - arr[i]) {
              return i - 1;
            } else {
              return i;
            }
          }
        }
      }
      return n - 1;
    }
  }


  /**
   * @param {Array<*>} arr Array.
   * @param {number} begin Begin index.
   * @param {number} end End index.
   */
  function reverseSubArray(arr, begin, end) {
    while (begin < end) {
      var tmp = arr[begin];
      arr[begin] = arr[end];
      arr[end] = tmp;
      ++begin;
      --end;
    }
  }


  /**
   * @param {Array<VALUE>} arr The array to modify.
   * @param {!Array<VALUE>|VALUE} data The elements or arrays of elements to add to arr.
   * @template VALUE
   */
  function extend(arr, data) {
    var extension = Array.isArray(data) ? data : [data];
    var length = extension.length;
    for (var i = 0; i < length; i++) {
      arr[arr.length] = extension[i];
    }
  }


  /**
   * @param {Array<VALUE>} arr The array to modify.
   * @param {VALUE} obj The element to remove.
   * @template VALUE
   * @return {boolean} If the element was removed.
   */
  function remove(arr, obj) {
    var i = arr.indexOf(obj);
    var found = i > -1;
    if (found) {
      arr.splice(i, 1);
    }
    return found;
  }


  /**
   * @param {Array|Uint8ClampedArray} arr1 The first array to compare.
   * @param {Array|Uint8ClampedArray} arr2 The second array to compare.
   * @return {boolean} Whether the two arrays are equal.
   */
  function equals(arr1, arr2) {
    var len1 = arr1.length;
    if (len1 !== arr2.length) {
      return false;
    }
    for (var i = 0; i < len1; i++) {
      if (arr1[i] !== arr2[i]) {
        return false;
      }
    }
    return true;
  }


  /**
   * Sort the passed array such that the relative order of equal elements is preverved.
   * See https://en.wikipedia.org/wiki/Sorting_algorithm#Stability for details.
   * @param {Array<*>} arr The array to sort (modifies original).
   * @param {!function(*, *): number} compareFnc Comparison function.
   * @api
   */
  function stableSort(arr, compareFnc) {
    var length = arr.length;
    var tmp = Array(arr.length);
    var i;
    for (i = 0; i < length; i++) {
      tmp[i] = {index: i, value: arr[i]};
    }
    tmp.sort(function(a, b) {
      return compareFnc(a.value, b.value) || a.index - b.index;
    });
    for (i = 0; i < arr.length; i++) {
      arr[i] = tmp[i].value;
    }
  }


  /**
   * @param {Array<*>} arr The array to test.
   * @param {Function=} opt_func Comparison function.
   * @param {boolean=} opt_strict Strictly sorted (default false).
   * @return {boolean} Return index.
   */
  function isSorted(arr, opt_func, opt_strict) {
    var compare = opt_func || numberSafeCompareFunction;
    return arr.every(function(currentVal, index) {
      if (index === 0) {
        return true;
      }
      var res = compare(arr[index - 1], currentVal);
      return !(res > 0 || opt_strict && res === 0);
    });
  }

  /**
   * @module ol/pointer/TouchSource
   */


  /**
   * @type {number}
   */
  var CLICK_COUNT_TIMEOUT = 200;

  /**
   * @type {string}
   */
  var POINTER_TYPE$1 = 'touch';

  /**
   * Handler for `touchstart`, triggers `pointerover`,
   * `pointerenter` and `pointerdown` events.
   *
   * @this {TouchSource}
   * @param {TouchEvent} inEvent The in event.
   */
  function touchstart(inEvent) {
    this.vacuumTouches_(inEvent);
    this.setPrimaryTouch_(inEvent.changedTouches[0]);
    this.dedupSynthMouse_(inEvent);
    this.clickCount_++;
    this.processTouches_(inEvent, this.overDown_);
  }

  /**
   * Handler for `touchmove`.
   *
   * @this {TouchSource}
   * @param {TouchEvent} inEvent The in event.
   */
  function touchmove(inEvent) {
    this.processTouches_(inEvent, this.moveOverOut_);
  }

  /**
   * Handler for `touchend`, triggers `pointerup`,
   * `pointerout` and `pointerleave` events.
   *
   * @this {TouchSource}
   * @param {TouchEvent} inEvent The event.
   */
  function touchend(inEvent) {
    this.dedupSynthMouse_(inEvent);
    this.processTouches_(inEvent, this.upOut_);
  }

  /**
   * Handler for `touchcancel`, triggers `pointercancel`,
   * `pointerout` and `pointerleave` events.
   *
   * @this {TouchSource}
   * @param {TouchEvent} inEvent The in event.
   */
  function touchcancel(inEvent) {
    this.processTouches_(inEvent, this.cancelOut_);
  }


  var TouchSource = /*@__PURE__*/(function (EventSource$$1) {
    function TouchSource(dispatcher, mouseSource) {
      var mapping = {
        'touchstart': touchstart,
        'touchmove': touchmove,
        'touchend': touchend,
        'touchcancel': touchcancel
      };
      EventSource$$1.call(this, dispatcher, mapping);

      /**
       * @const
       * @type {!Object<string, Event|Object>}
       */
      this.pointerMap = dispatcher.pointerMap;

      /**
       * @const
       * @type {import("./MouseSource.js").default}
       */
      this.mouseSource = mouseSource;

      /**
       * @private
       * @type {number|undefined}
       */
      this.firstTouchId_ = undefined;

      /**
       * @private
       * @type {number}
       */
      this.clickCount_ = 0;

      /**
       * @private
       * @type {?}
       */
      this.resetId_;

      /**
       * Mouse event timeout: This should be long enough to
       * ignore compat mouse events made by touch.
       * @private
       * @type {number}
       */
      this.dedupTimeout_ = 2500;
    }

    if ( EventSource$$1 ) TouchSource.__proto__ = EventSource$$1;
    TouchSource.prototype = Object.create( EventSource$$1 && EventSource$$1.prototype );
    TouchSource.prototype.constructor = TouchSource;

    /**
     * @private
     * @param {Touch} inTouch The in touch.
     * @return {boolean} True, if this is the primary touch.
     */
    TouchSource.prototype.isPrimaryTouch_ = function isPrimaryTouch_ (inTouch) {
      return this.firstTouchId_ === inTouch.identifier;
    };

    /**
     * Set primary touch if there are no pointers, or the only pointer is the mouse.
     * @param {Touch} inTouch The in touch.
     * @private
     */
    TouchSource.prototype.setPrimaryTouch_ = function setPrimaryTouch_ (inTouch) {
      var count = Object.keys(this.pointerMap).length;
      if (count === 0 || (count === 1 && POINTER_ID.toString() in this.pointerMap)) {
        this.firstTouchId_ = inTouch.identifier;
        this.cancelResetClickCount_();
      }
    };

    /**
     * @private
     * @param {PointerEvent} inPointer The in pointer object.
     */
    TouchSource.prototype.removePrimaryPointer_ = function removePrimaryPointer_ (inPointer) {
      if (inPointer.isPrimary) {
        this.firstTouchId_ = undefined;
        this.resetClickCount_();
      }
    };

    /**
     * @private
     */
    TouchSource.prototype.resetClickCount_ = function resetClickCount_ () {
      this.resetId_ = setTimeout(
        this.resetClickCountHandler_.bind(this),
        CLICK_COUNT_TIMEOUT);
    };

    /**
     * @private
     */
    TouchSource.prototype.resetClickCountHandler_ = function resetClickCountHandler_ () {
      this.clickCount_ = 0;
      this.resetId_ = undefined;
    };

    /**
     * @private
     */
    TouchSource.prototype.cancelResetClickCount_ = function cancelResetClickCount_ () {
      if (this.resetId_ !== undefined) {
        clearTimeout(this.resetId_);
      }
    };

    /**
     * @private
     * @param {TouchEvent} browserEvent Browser event
     * @param {Touch} inTouch Touch event
     * @return {PointerEvent} A pointer object.
     */
    TouchSource.prototype.touchToPointer_ = function touchToPointer_ (browserEvent, inTouch) {
      var e = this.dispatcher.cloneEvent(browserEvent, inTouch);
      // Spec specifies that pointerId 1 is reserved for Mouse.
      // Touch identifiers can start at 0.
      // Add 2 to the touch identifier for compatibility.
      e.pointerId = inTouch.identifier + 2;
      // TODO: check if this is necessary?
      //e.target = findTarget(e);
      e.bubbles = true;
      e.cancelable = true;
      e.detail = this.clickCount_;
      e.button = 0;
      e.buttons = 1;
      e.width = inTouch.radiusX || 0;
      e.height = inTouch.radiusY || 0;
      e.pressure = inTouch.force || 0.5;
      e.isPrimary = this.isPrimaryTouch_(inTouch);
      e.pointerType = POINTER_TYPE$1;

      // make sure that the properties that are different for
      // each `Touch` object are not copied from the BrowserEvent object
      e.clientX = inTouch.clientX;
      e.clientY = inTouch.clientY;
      e.screenX = inTouch.screenX;
      e.screenY = inTouch.screenY;

      return e;
    };

    /**
     * @private
     * @param {TouchEvent} inEvent Touch event
     * @param {function(TouchEvent, PointerEvent)} inFunction In function.
     */
    TouchSource.prototype.processTouches_ = function processTouches_ (inEvent, inFunction) {
      var touches = Array.prototype.slice.call(inEvent.changedTouches);
      var count = touches.length;
      function preventDefault() {
        inEvent.preventDefault();
      }
      for (var i = 0; i < count; ++i) {
        var pointer = this.touchToPointer_(inEvent, touches[i]);
        // forward touch preventDefaults
        pointer.preventDefault = preventDefault;
        inFunction.call(this, inEvent, pointer);
      }
    };

    /**
     * @private
     * @param {TouchList} touchList The touch list.
     * @param {number} searchId Search identifier.
     * @return {boolean} True, if the `Touch` with the given id is in the list.
     */
    TouchSource.prototype.findTouch_ = function findTouch_ (touchList, searchId) {
      var l = touchList.length;
      for (var i = 0; i < l; i++) {
        var touch = touchList[i];
        if (touch.identifier === searchId) {
          return true;
        }
      }
      return false;
    };

    /**
     * In some instances, a touchstart can happen without a touchend. This
     * leaves the pointermap in a broken state.
     * Therefore, on every touchstart, we remove the touches that did not fire a
     * touchend event.
     * To keep state globally consistent, we fire a pointercancel for
     * this "abandoned" touch
     *
     * @private
     * @param {TouchEvent} inEvent The in event.
     */
    TouchSource.prototype.vacuumTouches_ = function vacuumTouches_ (inEvent) {
      var touchList = inEvent.touches;
      // pointerMap.getCount() should be < touchList.length here,
      // as the touchstart has not been processed yet.
      var keys = Object.keys(this.pointerMap);
      var count = keys.length;
      if (count >= touchList.length) {
        var d = [];
        for (var i = 0; i < count; ++i) {
          var key = Number(keys[i]);
          var value = this.pointerMap[key];
          // Never remove pointerId == 1, which is mouse.
          // Touch identifiers are 2 smaller than their pointerId, which is the
          // index in pointermap.
          if (key != POINTER_ID && !this.findTouch_(touchList, key - 2)) {
            d.push(value.out);
          }
        }
        for (var i$1 = 0; i$1 < d.length; ++i$1) {
          this.cancelOut_(inEvent, d[i$1]);
        }
      }
    };

    /**
     * @private
     * @param {TouchEvent} browserEvent The event.
     * @param {PointerEvent} inPointer The in pointer object.
     */
    TouchSource.prototype.overDown_ = function overDown_ (browserEvent, inPointer) {
      this.pointerMap[inPointer.pointerId] = {
        target: inPointer.target,
        out: inPointer,
        outTarget: inPointer.target
      };
      this.dispatcher.over(inPointer, browserEvent);
      this.dispatcher.enter(inPointer, browserEvent);
      this.dispatcher.down(inPointer, browserEvent);
    };

    /**
     * @private
     * @param {TouchEvent} browserEvent The event.
     * @param {PointerEvent} inPointer The in pointer.
     */
    TouchSource.prototype.moveOverOut_ = function moveOverOut_ (browserEvent, inPointer) {
      var event = inPointer;
      var pointer = this.pointerMap[event.pointerId];
      // a finger drifted off the screen, ignore it
      if (!pointer) {
        return;
      }
      var outEvent = pointer.out;
      var outTarget = pointer.outTarget;
      this.dispatcher.move(event, browserEvent);
      if (outEvent && outTarget !== event.target) {
        outEvent.relatedTarget = event.target;
        /** @type {Object} */ (event).relatedTarget = outTarget;
        // recover from retargeting by shadow
        outEvent.target = outTarget;
        if (event.target) {
          this.dispatcher.leaveOut(outEvent, browserEvent);
          this.dispatcher.enterOver(event, browserEvent);
        } else {
          // clean up case when finger leaves the screen
          /** @type {Object} */ (event).target = outTarget;
          /** @type {Object} */ (event).relatedTarget = null;
          this.cancelOut_(browserEvent, event);
        }
      }
      pointer.out = event;
      pointer.outTarget = event.target;
    };

    /**
     * @private
     * @param {TouchEvent} browserEvent An event.
     * @param {PointerEvent} inPointer The inPointer object.
     */
    TouchSource.prototype.upOut_ = function upOut_ (browserEvent, inPointer) {
      this.dispatcher.up(inPointer, browserEvent);
      this.dispatcher.out(inPointer, browserEvent);
      this.dispatcher.leave(inPointer, browserEvent);
      this.cleanUpPointer_(inPointer);
    };

    /**
     * @private
     * @param {TouchEvent} browserEvent The event.
     * @param {PointerEvent} inPointer The in pointer.
     */
    TouchSource.prototype.cancelOut_ = function cancelOut_ (browserEvent, inPointer) {
      this.dispatcher.cancel(inPointer, browserEvent);
      this.dispatcher.out(inPointer, browserEvent);
      this.dispatcher.leave(inPointer, browserEvent);
      this.cleanUpPointer_(inPointer);
    };

    /**
     * @private
     * @param {PointerEvent} inPointer The inPointer object.
     */
    TouchSource.prototype.cleanUpPointer_ = function cleanUpPointer_ (inPointer) {
      delete this.pointerMap[inPointer.pointerId];
      this.removePrimaryPointer_(inPointer);
    };

    /**
     * Prevent synth mouse events from creating pointer events.
     *
     * @private
     * @param {TouchEvent} inEvent The in event.
     */
    TouchSource.prototype.dedupSynthMouse_ = function dedupSynthMouse_ (inEvent) {
      var lts = this.mouseSource.lastTouches;
      var t = inEvent.changedTouches[0];
      // only the primary finger will synth mouse events
      if (this.isPrimaryTouch_(t)) {
        // remember x/y of last touch
        var lt = [t.clientX, t.clientY];
        lts.push(lt);

        setTimeout(function() {
          // remove touch after timeout
          remove(lts, lt);
        }, this.dedupTimeout_);
      }
    };

    return TouchSource;
  }(EventSource));

  /**
   * @module ol/pointer/PointerEventHandler
   */


  /**
   * Properties to copy when cloning an event, with default values.
   * @type {Array<Array>}
   */
  var CLONE_PROPS = [
    // MouseEvent
    ['bubbles', false],
    ['cancelable', false],
    ['view', null],
    ['detail', null],
    ['screenX', 0],
    ['screenY', 0],
    ['clientX', 0],
    ['clientY', 0],
    ['ctrlKey', false],
    ['altKey', false],
    ['shiftKey', false],
    ['metaKey', false],
    ['button', 0],
    ['relatedTarget', null],
    // DOM Level 3
    ['buttons', 0],
    // PointerEvent
    ['pointerId', 0],
    ['width', 0],
    ['height', 0],
    ['pressure', 0],
    ['tiltX', 0],
    ['tiltY', 0],
    ['pointerType', ''],
    ['hwTimestamp', 0],
    ['isPrimary', false],
    // event instance
    ['type', ''],
    ['target', null],
    ['currentTarget', null],
    ['which', 0]
  ];


  var PointerEventHandler = /*@__PURE__*/(function (EventTarget) {
    function PointerEventHandler(element) {
      EventTarget.call(this);

      /**
       * @const
       * @private
       * @type {Element|HTMLDocument}
       */
      this.element_ = element;

      /**
       * @const
       * @type {!Object<string, Event|Object>}
       */
      this.pointerMap = {};

      /**
       * @type {Object<string, function(Event)>}
       * @private
       */
      this.eventMap_ = {};

      /**
       * @type {Array<import("./EventSource.js").default>}
       * @private
       */
      this.eventSourceList_ = [];

      this.registerSources();
    }

    if ( EventTarget ) PointerEventHandler.__proto__ = EventTarget;
    PointerEventHandler.prototype = Object.create( EventTarget && EventTarget.prototype );
    PointerEventHandler.prototype.constructor = PointerEventHandler;

    /**
     * Set up the event sources (mouse, touch and native pointers)
     * that generate pointer events.
     */
    PointerEventHandler.prototype.registerSources = function registerSources () {
      if (POINTER) {
        this.registerSource('native', new NativeSource(this));
      } else if (MSPOINTER) {
        this.registerSource('ms', new MsSource(this));
      } else {
        var mouseSource = new MouseSource(this);
        this.registerSource('mouse', mouseSource);

        if (TOUCH) {
          this.registerSource('touch', new TouchSource(this, mouseSource));
        }
      }

      // register events on the viewport element
      this.register_();
    };

    /**
     * Add a new event source that will generate pointer events.
     *
     * @param {string} name A name for the event source
     * @param {import("./EventSource.js").default} source The source event.
     */
    PointerEventHandler.prototype.registerSource = function registerSource (name, source) {
      var s = source;
      var newEvents = s.getEvents();

      if (newEvents) {
        newEvents.forEach(function(e) {
          var handler = s.getHandlerForEvent(e);

          if (handler) {
            this.eventMap_[e] = handler.bind(s);
          }
        }.bind(this));
        this.eventSourceList_.push(s);
      }
    };

    /**
     * Set up the events for all registered event sources.
     * @private
     */
    PointerEventHandler.prototype.register_ = function register_ () {
      var l = this.eventSourceList_.length;
      for (var i = 0; i < l; i++) {
        var eventSource = this.eventSourceList_[i];
        this.addEvents_(eventSource.getEvents());
      }
    };

    /**
     * Remove all registered events.
     * @private
     */
    PointerEventHandler.prototype.unregister_ = function unregister_ () {
      var l = this.eventSourceList_.length;
      for (var i = 0; i < l; i++) {
        var eventSource = this.eventSourceList_[i];
        this.removeEvents_(eventSource.getEvents());
      }
    };

    /**
     * Calls the right handler for a new event.
     * @private
     * @param {Event} inEvent Browser event.
     */
    PointerEventHandler.prototype.eventHandler_ = function eventHandler_ (inEvent) {
      var type = inEvent.type;
      var handler = this.eventMap_[type];
      if (handler) {
        handler(inEvent);
      }
    };

    /**
     * Setup listeners for the given events.
     * @private
     * @param {Array<string>} events List of events.
     */
    PointerEventHandler.prototype.addEvents_ = function addEvents_ (events) {
      events.forEach(function(eventName) {
        listen(this.element_, eventName, this.eventHandler_, this);
      }.bind(this));
    };

    /**
     * Unregister listeners for the given events.
     * @private
     * @param {Array<string>} events List of events.
     */
    PointerEventHandler.prototype.removeEvents_ = function removeEvents_ (events) {
      events.forEach(function(e) {
        unlisten(this.element_, e, this.eventHandler_, this);
      }.bind(this));
    };

    /**
     * Returns a snapshot of inEvent, with writable properties.
     *
     * @param {Event} event Browser event.
     * @param {Event|Touch} inEvent An event that contains
     *    properties to copy.
     * @return {Object} An object containing shallow copies of
     *    `inEvent`'s properties.
     */
    PointerEventHandler.prototype.cloneEvent = function cloneEvent (event, inEvent) {
      var eventCopy = {};
      for (var i = 0, ii = CLONE_PROPS.length; i < ii; i++) {
        var p = CLONE_PROPS[i][0];
        eventCopy[p] = event[p] || inEvent[p] || CLONE_PROPS[i][1];
      }

      return eventCopy;
    };

    // EVENTS


    /**
     * Triggers a 'pointerdown' event.
     * @param {Object} data Pointer event data.
     * @param {Event} event The event.
     */
    PointerEventHandler.prototype.down = function down (data, event) {
      this.fireEvent(PointerEventType.POINTERDOWN, data, event);
    };

    /**
     * Triggers a 'pointermove' event.
     * @param {Object} data Pointer event data.
     * @param {Event} event The event.
     */
    PointerEventHandler.prototype.move = function move (data, event) {
      this.fireEvent(PointerEventType.POINTERMOVE, data, event);
    };

    /**
     * Triggers a 'pointerup' event.
     * @param {Object} data Pointer event data.
     * @param {Event} event The event.
     */
    PointerEventHandler.prototype.up = function up (data, event) {
      this.fireEvent(PointerEventType.POINTERUP, data, event);
    };

    /**
     * Triggers a 'pointerenter' event.
     * @param {Object} data Pointer event data.
     * @param {Event} event The event.
     */
    PointerEventHandler.prototype.enter = function enter (data, event) {
      data.bubbles = false;
      this.fireEvent(PointerEventType.POINTERENTER, data, event);
    };

    /**
     * Triggers a 'pointerleave' event.
     * @param {Object} data Pointer event data.
     * @param {Event} event The event.
     */
    PointerEventHandler.prototype.leave = function leave (data, event) {
      data.bubbles = false;
      this.fireEvent(PointerEventType.POINTERLEAVE, data, event);
    };

    /**
     * Triggers a 'pointerover' event.
     * @param {Object} data Pointer event data.
     * @param {Event} event The event.
     */
    PointerEventHandler.prototype.over = function over (data, event) {
      data.bubbles = true;
      this.fireEvent(PointerEventType.POINTEROVER, data, event);
    };

    /**
     * Triggers a 'pointerout' event.
     * @param {Object} data Pointer event data.
     * @param {Event} event The event.
     */
    PointerEventHandler.prototype.out = function out (data, event) {
      data.bubbles = true;
      this.fireEvent(PointerEventType.POINTEROUT, data, event);
    };

    /**
     * Triggers a 'pointercancel' event.
     * @param {Object} data Pointer event data.
     * @param {Event} event The event.
     */
    PointerEventHandler.prototype.cancel = function cancel (data, event) {
      this.fireEvent(PointerEventType.POINTERCANCEL, data, event);
    };

    /**
     * Triggers a combination of 'pointerout' and 'pointerleave' events.
     * @param {Object} data Pointer event data.
     * @param {Event} event The event.
     */
    PointerEventHandler.prototype.leaveOut = function leaveOut (data, event) {
      this.out(data, event);
      if (!this.contains_(data.target, data.relatedTarget)) {
        this.leave(data, event);
      }
    };

    /**
     * Triggers a combination of 'pointerover' and 'pointerevents' events.
     * @param {Object} data Pointer event data.
     * @param {Event} event The event.
     */
    PointerEventHandler.prototype.enterOver = function enterOver (data, event) {
      this.over(data, event);
      if (!this.contains_(data.target, data.relatedTarget)) {
        this.enter(data, event);
      }
    };

    /**
     * @private
     * @param {Element} container The container element.
     * @param {Element} contained The contained element.
     * @return {boolean} Returns true if the container element
     *   contains the other element.
     */
    PointerEventHandler.prototype.contains_ = function contains_ (container, contained) {
      if (!container || !contained) {
        return false;
      }
      return container.contains(contained);
    };

    // EVENT CREATION AND TRACKING
    /**
     * Creates a new Event of type `inType`, based on the information in
     * `data`.
     *
     * @param {string} inType A string representing the type of event to create.
     * @param {Object} data Pointer event data.
     * @param {Event} event The event.
     * @return {PointerEvent} A PointerEvent of type `inType`.
     */
    PointerEventHandler.prototype.makeEvent = function makeEvent (inType, data, event) {
      return new PointerEvent(inType, event, data);
    };

    /**
     * Make and dispatch an event in one call.
     * @param {string} inType A string representing the type of event.
     * @param {Object} data Pointer event data.
     * @param {Event} event The event.
     */
    PointerEventHandler.prototype.fireEvent = function fireEvent (inType, data, event) {
      var e = this.makeEvent(inType, data, event);
      this.dispatchEvent(e);
    };

    /**
     * Creates a pointer event from a native pointer event
     * and dispatches this event.
     * @param {Event} event A platform event with a target.
     */
    PointerEventHandler.prototype.fireNativeEvent = function fireNativeEvent (event) {
      var e = this.makeEvent(event.type, event, event);
      this.dispatchEvent(e);
    };

    /**
     * Wrap a native mouse event into a pointer event.
     * This proxy method is required for the legacy IE support.
     * @param {string} eventType The pointer event type.
     * @param {Event} event The event.
     * @return {PointerEvent} The wrapped event.
     */
    PointerEventHandler.prototype.wrapMouseEvent = function wrapMouseEvent (eventType, event) {
      var pointerEvent = this.makeEvent(
        eventType, prepareEvent(event, this), event);
      return pointerEvent;
    };

    /**
     * @inheritDoc
     */
    PointerEventHandler.prototype.disposeInternal = function disposeInternal () {
      this.unregister_();
      EventTarget.prototype.disposeInternal.call(this);
    };

    return PointerEventHandler;
  }(Target));

  /**
   * @module ol/MapBrowserEventHandler
   */

  var MapBrowserEventHandler = /*@__PURE__*/(function (EventTarget) {
    function MapBrowserEventHandler(map, moveTolerance) {

      EventTarget.call(this);

      /**
       * This is the element that we will listen to the real events on.
       * @type {import("./PluggableMap.js").default}
       * @private
       */
      this.map_ = map;

      /**
       * @type {any}
       * @private
       */
      this.clickTimeoutId_;

      /**
       * @type {boolean}
       * @private
       */
      this.dragging_ = false;

      /**
       * @type {!Array<import("./events.js").EventsKey>}
       * @private
       */
      this.dragListenerKeys_ = [];

      /**
       * @type {number}
       * @private
       */
      this.moveTolerance_ = moveTolerance ?
        moveTolerance * DEVICE_PIXEL_RATIO : DEVICE_PIXEL_RATIO;

      /**
       * The most recent "down" type event (or null if none have occurred).
       * Set on pointerdown.
       * @type {import("./pointer/PointerEvent.js").default}
       * @private
       */
      this.down_ = null;

      var element = this.map_.getViewport();

      /**
       * @type {number}
       * @private
       */
      this.activePointers_ = 0;

      /**
       * @type {!Object<number, boolean>}
       * @private
       */
      this.trackedTouches_ = {};

      /**
       * Event handler which generates pointer events for
       * the viewport element.
       *
       * @type {PointerEventHandler}
       * @private
       */
      this.pointerEventHandler_ = new PointerEventHandler(element);

      /**
       * Event handler which generates pointer events for
       * the document (used when dragging).
       *
       * @type {PointerEventHandler}
       * @private
       */
      this.documentPointerEventHandler_ = null;

      /**
       * @type {?import("./events.js").EventsKey}
       * @private
       */
      this.pointerdownListenerKey_ = listen(this.pointerEventHandler_,
        PointerEventType.POINTERDOWN,
        this.handlePointerDown_, this);

      /**
       * @type {?import("./events.js").EventsKey}
       * @private
       */
      this.relayedListenerKey_ = listen(this.pointerEventHandler_,
        PointerEventType.POINTERMOVE,
        this.relayEvent_, this);

    }

    if ( EventTarget ) MapBrowserEventHandler.__proto__ = EventTarget;
    MapBrowserEventHandler.prototype = Object.create( EventTarget && EventTarget.prototype );
    MapBrowserEventHandler.prototype.constructor = MapBrowserEventHandler;

    /**
     * @param {import("./pointer/PointerEvent.js").default} pointerEvent Pointer
     * event.
     * @private
     */
    MapBrowserEventHandler.prototype.emulateClick_ = function emulateClick_ (pointerEvent) {
      var newEvent = new MapBrowserPointerEvent(
        MapBrowserEventType.CLICK, this.map_, pointerEvent);
      this.dispatchEvent(newEvent);
      if (this.clickTimeoutId_ !== undefined) {
        // double-click
        clearTimeout(this.clickTimeoutId_);
        this.clickTimeoutId_ = undefined;
        newEvent = new MapBrowserPointerEvent(
          MapBrowserEventType.DBLCLICK, this.map_, pointerEvent);
        this.dispatchEvent(newEvent);
      } else {
        // click
        this.clickTimeoutId_ = setTimeout(function() {
          this.clickTimeoutId_ = undefined;
          var newEvent = new MapBrowserPointerEvent(
            MapBrowserEventType.SINGLECLICK, this.map_, pointerEvent);
          this.dispatchEvent(newEvent);
        }.bind(this), 250);
      }
    };

    /**
     * Keeps track on how many pointers are currently active.
     *
     * @param {import("./pointer/PointerEvent.js").default} pointerEvent Pointer
     * event.
     * @private
     */
    MapBrowserEventHandler.prototype.updateActivePointers_ = function updateActivePointers_ (pointerEvent) {
      var event = pointerEvent;

      if (event.type == MapBrowserEventType.POINTERUP ||
          event.type == MapBrowserEventType.POINTERCANCEL) {
        delete this.trackedTouches_[event.pointerId];
      } else if (event.type == MapBrowserEventType.POINTERDOWN) {
        this.trackedTouches_[event.pointerId] = true;
      }
      this.activePointers_ = Object.keys(this.trackedTouches_).length;
    };

    /**
     * @param {import("./pointer/PointerEvent.js").default} pointerEvent Pointer
     * event.
     * @private
     */
    MapBrowserEventHandler.prototype.handlePointerUp_ = function handlePointerUp_ (pointerEvent) {
      this.updateActivePointers_(pointerEvent);
      var newEvent = new MapBrowserPointerEvent(
        MapBrowserEventType.POINTERUP, this.map_, pointerEvent);
      this.dispatchEvent(newEvent);

      // We emulate click events on left mouse button click, touch contact, and pen
      // contact. isMouseActionButton returns true in these cases (evt.button is set
      // to 0).
      // See http://www.w3.org/TR/pointerevents/#button-states
      // We only fire click, singleclick, and doubleclick if nobody has called
      // event.stopPropagation() or event.preventDefault().
      if (!newEvent.propagationStopped && !this.dragging_ && this.isMouseActionButton_(pointerEvent)) {
        this.emulateClick_(this.down_);
      }

      if (this.activePointers_ === 0) {
        this.dragListenerKeys_.forEach(unlistenByKey);
        this.dragListenerKeys_.length = 0;
        this.dragging_ = false;
        this.down_ = null;
        this.documentPointerEventHandler_.dispose();
        this.documentPointerEventHandler_ = null;
      }
    };

    /**
     * @param {import("./pointer/PointerEvent.js").default} pointerEvent Pointer
     * event.
     * @return {boolean} If the left mouse button was pressed.
     * @private
     */
    MapBrowserEventHandler.prototype.isMouseActionButton_ = function isMouseActionButton_ (pointerEvent) {
      return pointerEvent.button === 0;
    };

    /**
     * @param {import("./pointer/PointerEvent.js").default} pointerEvent Pointer
     * event.
     * @private
     */
    MapBrowserEventHandler.prototype.handlePointerDown_ = function handlePointerDown_ (pointerEvent) {
      this.updateActivePointers_(pointerEvent);
      var newEvent = new MapBrowserPointerEvent(
        MapBrowserEventType.POINTERDOWN, this.map_, pointerEvent);
      this.dispatchEvent(newEvent);

      this.down_ = pointerEvent;

      if (this.dragListenerKeys_.length === 0) {
        /* Set up a pointer event handler on the `document`,
         * which is required when the pointer is moved outside
         * the viewport when dragging.
         */
        this.documentPointerEventHandler_ =
            new PointerEventHandler(document);

        this.dragListenerKeys_.push(
          listen(this.documentPointerEventHandler_,
            MapBrowserEventType.POINTERMOVE,
            this.handlePointerMove_, this),
          listen(this.documentPointerEventHandler_,
            MapBrowserEventType.POINTERUP,
            this.handlePointerUp_, this),
          /* Note that the listener for `pointercancel is set up on
           * `pointerEventHandler_` and not `documentPointerEventHandler_` like
           * the `pointerup` and `pointermove` listeners.
           *
           * The reason for this is the following: `TouchSource.vacuumTouches_()`
           * issues `pointercancel` events, when there was no `touchend` for a
           * `touchstart`. Now, let's say a first `touchstart` is registered on
           * `pointerEventHandler_`. The `documentPointerEventHandler_` is set up.
           * But `documentPointerEventHandler_` doesn't know about the first
           * `touchstart`. If there is no `touchend` for the `touchstart`, we can
           * only receive a `touchcancel` from `pointerEventHandler_`, because it is
           * only registered there.
           */
          listen(this.pointerEventHandler_,
            MapBrowserEventType.POINTERCANCEL,
            this.handlePointerUp_, this)
        );
      }
    };

    /**
     * @param {import("./pointer/PointerEvent.js").default} pointerEvent Pointer
     * event.
     * @private
     */
    MapBrowserEventHandler.prototype.handlePointerMove_ = function handlePointerMove_ (pointerEvent) {
      // Between pointerdown and pointerup, pointermove events are triggered.
      // To avoid a 'false' touchmove event to be dispatched, we test if the pointer
      // moved a significant distance.
      if (this.isMoving_(pointerEvent)) {
        this.dragging_ = true;
        var newEvent = new MapBrowserPointerEvent(
          MapBrowserEventType.POINTERDRAG, this.map_, pointerEvent,
          this.dragging_);
        this.dispatchEvent(newEvent);
      }

      // Some native android browser triggers mousemove events during small period
      // of time. See: https://code.google.com/p/android/issues/detail?id=5491 or
      // https://code.google.com/p/android/issues/detail?id=19827
      // ex: Galaxy Tab P3110 + Android 4.1.1
      pointerEvent.preventDefault();
    };

    /**
     * Wrap and relay a pointer event.  Note that this requires that the type
     * string for the MapBrowserPointerEvent matches the PointerEvent type.
     * @param {import("./pointer/PointerEvent.js").default} pointerEvent Pointer
     * event.
     * @private
     */
    MapBrowserEventHandler.prototype.relayEvent_ = function relayEvent_ (pointerEvent) {
      var dragging = !!(this.down_ && this.isMoving_(pointerEvent));
      this.dispatchEvent(new MapBrowserPointerEvent(
        pointerEvent.type, this.map_, pointerEvent, dragging));
    };

    /**
     * @param {import("./pointer/PointerEvent.js").default} pointerEvent Pointer
     * event.
     * @return {boolean} Is moving.
     * @private
     */
    MapBrowserEventHandler.prototype.isMoving_ = function isMoving_ (pointerEvent) {
      return this.dragging_ ||
          Math.abs(pointerEvent.clientX - this.down_.clientX) > this.moveTolerance_ ||
          Math.abs(pointerEvent.clientY - this.down_.clientY) > this.moveTolerance_;
    };

    /**
     * @inheritDoc
     */
    MapBrowserEventHandler.prototype.disposeInternal = function disposeInternal () {
      if (this.relayedListenerKey_) {
        unlistenByKey(this.relayedListenerKey_);
        this.relayedListenerKey_ = null;
      }
      if (this.pointerdownListenerKey_) {
        unlistenByKey(this.pointerdownListenerKey_);
        this.pointerdownListenerKey_ = null;
      }

      this.dragListenerKeys_.forEach(unlistenByKey);
      this.dragListenerKeys_.length = 0;

      if (this.documentPointerEventHandler_) {
        this.documentPointerEventHandler_.dispose();
        this.documentPointerEventHandler_ = null;
      }
      if (this.pointerEventHandler_) {
        this.pointerEventHandler_.dispose();
        this.pointerEventHandler_ = null;
      }
      EventTarget.prototype.disposeInternal.call(this);
    };

    return MapBrowserEventHandler;
  }(Target));

  /**
   * @module ol/MapEventType
   */

  /**
   * @enum {string}
   */
  var MapEventType = {

    /**
     * Triggered after a map frame is rendered.
     * @event module:ol/MapEvent~MapEvent#postrender
     * @api
     */
    POSTRENDER: 'postrender',

    /**
     * Triggered when the map starts moving.
     * @event module:ol/MapEvent~MapEvent#movestart
     * @api
     */
    MOVESTART: 'movestart',

    /**
     * Triggered after the map is moved.
     * @event module:ol/MapEvent~MapEvent#moveend
     * @api
     */
    MOVEEND: 'moveend'

  };

  /**
   * @module ol/MapProperty
   */

  /**
   * @enum {string}
   */
  var MapProperty = {
    LAYERGROUP: 'layergroup',
    SIZE: 'size',
    TARGET: 'target',
    VIEW: 'view'
  };

  /**
   * @module ol/render/EventType
   */

  /**
   * @enum {string}
   */
  var RenderEventType = {
    /**
     * @event module:ol/render/Event~RenderEvent#postcompose
     * @api
     */
    POSTCOMPOSE: 'postcompose',
    /**
     * @event module:ol/render/Event~RenderEvent#precompose
     * @api
     */
    PRECOMPOSE: 'precompose',
    /**
     * @event module:ol/render/Event~RenderEvent#render
     * @api
     */
    RENDER: 'render',
    /**
     * Triggered when rendering is complete, i.e. all sources and tiles have
     * finished loading for the current viewport, and all tiles are faded in.
     * @event module:ol/render/Event~RenderEvent#rendercomplete
     * @api
     */
    RENDERCOMPLETE: 'rendercomplete'
  };

  /**
   * @module ol/TileState
   */

  /**
   * @enum {number}
   */
  var TileState = {
    IDLE: 0,
    LOADING: 1,
    LOADED: 2,
    /**
     * Indicates that tile loading failed
     * @type {number}
     */
    ERROR: 3,
    EMPTY: 4,
    ABORT: 5
  };

  /**
   * @module ol/asserts
   */

  /**
   * @param {*} assertion Assertion we expected to be truthy.
   * @param {number} errorCode Error code.
   */
  function assert(assertion, errorCode) {
    if (!assertion) {
      throw new AssertionError(errorCode);
    }
  }

  /**
   * @module ol/structs/PriorityQueue
   */


  /**
   * @type {number}
   */
  var DROP = Infinity;


  /**
   * @classdesc
   * Priority queue.
   *
   * The implementation is inspired from the Closure Library's Heap class and
   * Python's heapq module.
   *
   * See http://closure-library.googlecode.com/svn/docs/closure_goog_structs_heap.js.source.html
   * and http://hg.python.org/cpython/file/2.7/Lib/heapq.py.
   *
   * @template T
   */
  var PriorityQueue = function PriorityQueue(priorityFunction, keyFunction) {

    /**
     * @type {function(T): number}
     * @private
     */
    this.priorityFunction_ = priorityFunction;

    /**
     * @type {function(T): string}
     * @private
     */
    this.keyFunction_ = keyFunction;

    /**
     * @type {Array<T>}
     * @private
     */
    this.elements_ = [];

    /**
     * @type {Array<number>}
     * @private
     */
    this.priorities_ = [];

    /**
     * @type {!Object<string, boolean>}
     * @private
     */
    this.queuedElements_ = {};

  };

  /**
   * FIXME empty description for jsdoc
   */
  PriorityQueue.prototype.clear = function clear$1 () {
    this.elements_.length = 0;
    this.priorities_.length = 0;
    clear(this.queuedElements_);
  };


  /**
   * Remove and return the highest-priority element. O(log N).
   * @return {T} Element.
   */
  PriorityQueue.prototype.dequeue = function dequeue () {
    var elements = this.elements_;
    var priorities = this.priorities_;
    var element = elements[0];
    if (elements.length == 1) {
      elements.length = 0;
      priorities.length = 0;
    } else {
      elements[0] = elements.pop();
      priorities[0] = priorities.pop();
      this.siftUp_(0);
    }
    var elementKey = this.keyFunction_(element);
    delete this.queuedElements_[elementKey];
    return element;
  };


  /**
   * Enqueue an element. O(log N).
   * @param {T} element Element.
   * @return {boolean} The element was added to the queue.
   */
  PriorityQueue.prototype.enqueue = function enqueue (element) {
    assert(!(this.keyFunction_(element) in this.queuedElements_),
      31); // Tried to enqueue an `element` that was already added to the queue
    var priority = this.priorityFunction_(element);
    if (priority != DROP) {
      this.elements_.push(element);
      this.priorities_.push(priority);
      this.queuedElements_[this.keyFunction_(element)] = true;
      this.siftDown_(0, this.elements_.length - 1);
      return true;
    }
    return false;
  };


  /**
   * @return {number} Count.
   */
  PriorityQueue.prototype.getCount = function getCount () {
    return this.elements_.length;
  };


  /**
   * Gets the index of the left child of the node at the given index.
   * @param {number} index The index of the node to get the left child for.
   * @return {number} The index of the left child.
   * @private
   */
  PriorityQueue.prototype.getLeftChildIndex_ = function getLeftChildIndex_ (index) {
    return index * 2 + 1;
  };


  /**
   * Gets the index of the right child of the node at the given index.
   * @param {number} index The index of the node to get the right child for.
   * @return {number} The index of the right child.
   * @private
   */
  PriorityQueue.prototype.getRightChildIndex_ = function getRightChildIndex_ (index) {
    return index * 2 + 2;
  };


  /**
   * Gets the index of the parent of the node at the given index.
   * @param {number} index The index of the node to get the parent for.
   * @return {number} The index of the parent.
   * @private
   */
  PriorityQueue.prototype.getParentIndex_ = function getParentIndex_ (index) {
    return (index - 1) >> 1;
  };


  /**
   * Make this a heap. O(N).
   * @private
   */
  PriorityQueue.prototype.heapify_ = function heapify_ () {
    var i;
    for (i = (this.elements_.length >> 1) - 1; i >= 0; i--) {
      this.siftUp_(i);
    }
  };


  /**
   * @return {boolean} Is empty.
   */
  PriorityQueue.prototype.isEmpty = function isEmpty$$1 () {
    return this.elements_.length === 0;
  };


  /**
   * @param {string} key Key.
   * @return {boolean} Is key queued.
   */
  PriorityQueue.prototype.isKeyQueued = function isKeyQueued (key) {
    return key in this.queuedElements_;
  };


  /**
   * @param {T} element Element.
   * @return {boolean} Is queued.
   */
  PriorityQueue.prototype.isQueued = function isQueued (element) {
    return this.isKeyQueued(this.keyFunction_(element));
  };


  /**
   * @param {number} index The index of the node to move down.
   * @private
   */
  PriorityQueue.prototype.siftUp_ = function siftUp_ (index) {
    var elements = this.elements_;
    var priorities = this.priorities_;
    var count = elements.length;
    var element = elements[index];
    var priority = priorities[index];
    var startIndex = index;

    while (index < (count >> 1)) {
      var lIndex = this.getLeftChildIndex_(index);
      var rIndex = this.getRightChildIndex_(index);

      var smallerChildIndex = rIndex < count &&
          priorities[rIndex] < priorities[lIndex] ?
        rIndex : lIndex;

      elements[index] = elements[smallerChildIndex];
      priorities[index] = priorities[smallerChildIndex];
      index = smallerChildIndex;
    }

    elements[index] = element;
    priorities[index] = priority;
    this.siftDown_(startIndex, index);
  };


  /**
   * @param {number} startIndex The index of the root.
   * @param {number} index The index of the node to move up.
   * @private
   */
  PriorityQueue.prototype.siftDown_ = function siftDown_ (startIndex, index) {
    var elements = this.elements_;
    var priorities = this.priorities_;
    var element = elements[index];
    var priority = priorities[index];

    while (index > startIndex) {
      var parentIndex = this.getParentIndex_(index);
      if (priorities[parentIndex] > priority) {
        elements[index] = elements[parentIndex];
        priorities[index] = priorities[parentIndex];
        index = parentIndex;
      } else {
        break;
      }
    }
    elements[index] = element;
    priorities[index] = priority;
  };


  /**
   * FIXME empty description for jsdoc
   */
  PriorityQueue.prototype.reprioritize = function reprioritize () {
    var priorityFunction = this.priorityFunction_;
    var elements = this.elements_;
    var priorities = this.priorities_;
    var index = 0;
    var n = elements.length;
    var element, i, priority;
    for (i = 0; i < n; ++i) {
      element = elements[i];
      priority = priorityFunction(element);
      if (priority == DROP) {
        delete this.queuedElements_[this.keyFunction_(element)];
      } else {
        priorities[index] = priority;
        elements[index++] = element;
      }
    }
    elements.length = index;
    priorities.length = index;
    this.heapify_();
  };

  /**
   * @module ol/TileQueue
   */


  /**
   * @typedef {function(import("./Tile.js").default, string, import("./coordinate.js").Coordinate, number): number} PriorityFunction
   */


  var TileQueue = /*@__PURE__*/(function (PriorityQueue$$1) {
    function TileQueue(tilePriorityFunction, tileChangeCallback) {

      PriorityQueue$$1.call(
        /**
         * @param {Array} element Element.
         * @return {number} Priority.
         */
        this, function(element) {
          return tilePriorityFunction.apply(null, element);
        },
        /**
         * @param {Array} element Element.
         * @return {string} Key.
         */
        function(element) {
          return (/** @type {import("./Tile.js").default} */ (element[0]).getKey());
        });

      /**
       * @private
       * @type {function(): ?}
       */
      this.tileChangeCallback_ = tileChangeCallback;

      /**
       * @private
       * @type {number}
       */
      this.tilesLoading_ = 0;

      /**
       * @private
       * @type {!Object<string,boolean>}
       */
      this.tilesLoadingKeys_ = {};

    }

    if ( PriorityQueue$$1 ) TileQueue.__proto__ = PriorityQueue$$1;
    TileQueue.prototype = Object.create( PriorityQueue$$1 && PriorityQueue$$1.prototype );
    TileQueue.prototype.constructor = TileQueue;

    /**
     * @inheritDoc
     */
    TileQueue.prototype.enqueue = function enqueue (element) {
      var added = PriorityQueue$$1.prototype.enqueue.call(this, element);
      if (added) {
        var tile = element[0];
        listen(tile, EventType.CHANGE, this.handleTileChange, this);
      }
      return added;
    };

    /**
     * @return {number} Number of tiles loading.
     */
    TileQueue.prototype.getTilesLoading = function getTilesLoading () {
      return this.tilesLoading_;
    };

    /**
     * @param {import("./events/Event.js").default} event Event.
     * @protected
     */
    TileQueue.prototype.handleTileChange = function handleTileChange (event) {
      var tile = /** @type {import("./Tile.js").default} */ (event.target);
      var state = tile.getState();
      if (state === TileState.LOADED || state === TileState.ERROR ||
          state === TileState.EMPTY || state === TileState.ABORT) {
        unlisten(tile, EventType.CHANGE, this.handleTileChange, this);
        var tileKey = tile.getKey();
        if (tileKey in this.tilesLoadingKeys_) {
          delete this.tilesLoadingKeys_[tileKey];
          --this.tilesLoading_;
        }
        this.tileChangeCallback_();
      }
    };

    /**
     * @param {number} maxTotalLoading Maximum number tiles to load simultaneously.
     * @param {number} maxNewLoads Maximum number of new tiles to load.
     */
    TileQueue.prototype.loadMoreTiles = function loadMoreTiles (maxTotalLoading, maxNewLoads) {
      var newLoads = 0;
      var abortedTiles = false;
      var state, tile, tileKey;
      while (this.tilesLoading_ < maxTotalLoading && newLoads < maxNewLoads &&
             this.getCount() > 0) {
        tile = /** @type {import("./Tile.js").default} */ (this.dequeue()[0]);
        tileKey = tile.getKey();
        state = tile.getState();
        if (state === TileState.ABORT) {
          abortedTiles = true;
        } else if (state === TileState.IDLE && !(tileKey in this.tilesLoadingKeys_)) {
          this.tilesLoadingKeys_[tileKey] = true;
          ++this.tilesLoading_;
          ++newLoads;
          tile.load();
        }
      }
      if (newLoads === 0 && abortedTiles) {
        // Do not stop the render loop when all wanted tiles were aborted due to
        // a small, saturated tile cache.
        this.tileChangeCallback_();
      }
    };

    return TileQueue;
  }(PriorityQueue));

  /**
   * @module ol/tilegrid/common
   */

  /**
   * Default maximum zoom for default tile grids.
   * @type {number}
   */
  var DEFAULT_MAX_ZOOM = 42;

  /**
   * Default tile size.
   * @type {number}
   */
  var DEFAULT_TILE_SIZE = 256;

  /**
   * @module ol/math
   */

  /**
   * Takes a number and clamps it to within the provided bounds.
   * @param {number} value The input number.
   * @param {number} min The minimum value to return.
   * @param {number} max The maximum value to return.
   * @return {number} The input number if it is within bounds, or the nearest
   *     number within the bounds.
   */
  function clamp(value, min, max) {
    return Math.min(Math.max(value, min), max);
  }


  /**
   * Return the hyperbolic cosine of a given number. The method will use the
   * native `Math.cosh` function if it is available, otherwise the hyperbolic
   * cosine will be calculated via the reference implementation of the Mozilla
   * developer network.
   *
   * @param {number} x X.
   * @return {number} Hyperbolic cosine of x.
   */
  var cosh = (function() {
    // Wrapped in a iife, to save the overhead of checking for the native
    // implementation on every invocation.
    var cosh;
    if ('cosh' in Math) {
      // The environment supports the native Math.cosh function, use it…
      cosh = Math.cosh;
    } else {
      // … else, use the reference implementation of MDN:
      cosh = function(x) {
        var y = /** @type {Math} */ (Math).exp(x);
        return (y + 1 / y) / 2;
      };
    }
    return cosh;
  }());


  /**
   * @param {number} x X.
   * @return {number} The smallest power of two greater than or equal to x.
   */
  function roundUpToPowerOfTwo(x) {
    assert(0 < x, 29); // `x` must be greater than `0`
    return Math.pow(2, Math.ceil(Math.log(x) / Math.LN2));
  }


  /**
   * Returns the square of the closest distance between the point (x, y) and the
   * line segment (x1, y1) to (x2, y2).
   * @param {number} x X.
   * @param {number} y Y.
   * @param {number} x1 X1.
   * @param {number} y1 Y1.
   * @param {number} x2 X2.
   * @param {number} y2 Y2.
   * @return {number} Squared distance.
   */
  function squaredSegmentDistance(x, y, x1, y1, x2, y2) {
    var dx = x2 - x1;
    var dy = y2 - y1;
    if (dx !== 0 || dy !== 0) {
      var t = ((x - x1) * dx + (y - y1) * dy) / (dx * dx + dy * dy);
      if (t > 1) {
        x1 = x2;
        y1 = y2;
      } else if (t > 0) {
        x1 += dx * t;
        y1 += dy * t;
      }
    }
    return squaredDistance(x, y, x1, y1);
  }


  /**
   * Returns the square of the distance between the points (x1, y1) and (x2, y2).
   * @param {number} x1 X1.
   * @param {number} y1 Y1.
   * @param {number} x2 X2.
   * @param {number} y2 Y2.
   * @return {number} Squared distance.
   */
  function squaredDistance(x1, y1, x2, y2) {
    var dx = x2 - x1;
    var dy = y2 - y1;
    return dx * dx + dy * dy;
  }


  /**
   * Solves system of linear equations using Gaussian elimination method.
   *
   * @param {Array<Array<number>>} mat Augmented matrix (n x n + 1 column)
   *                                     in row-major order.
   * @return {Array<number>} The resulting vector.
   */
  function solveLinearSystem(mat) {
    var n = mat.length;

    for (var i = 0; i < n; i++) {
      // Find max in the i-th column (ignoring i - 1 first rows)
      var maxRow = i;
      var maxEl = Math.abs(mat[i][i]);
      for (var r = i + 1; r < n; r++) {
        var absValue = Math.abs(mat[r][i]);
        if (absValue > maxEl) {
          maxEl = absValue;
          maxRow = r;
        }
      }

      if (maxEl === 0) {
        return null; // matrix is singular
      }

      // Swap max row with i-th (current) row
      var tmp = mat[maxRow];
      mat[maxRow] = mat[i];
      mat[i] = tmp;

      // Subtract the i-th row to make all the remaining rows 0 in the i-th column
      for (var j = i + 1; j < n; j++) {
        var coef = -mat[j][i] / mat[i][i];
        for (var k = i; k < n + 1; k++) {
          if (i == k) {
            mat[j][k] = 0;
          } else {
            mat[j][k] += coef * mat[i][k];
          }
        }
      }
    }

    // Solve Ax=b for upper triangular matrix A (mat)
    var x = new Array(n);
    for (var l = n - 1; l >= 0; l--) {
      x[l] = mat[l][n] / mat[l][l];
      for (var m = l - 1; m >= 0; m--) {
        mat[m][n] -= mat[m][l] * x[l];
      }
    }
    return x;
  }


  /**
   * Converts degrees to radians.
   *
   * @param {number} angleInDegrees Angle in degrees.
   * @return {number} Angle in radians.
   */
  function toRadians(angleInDegrees) {
    return angleInDegrees * Math.PI / 180;
  }

  /**
   * Returns the modulo of a / b, depending on the sign of b.
   *
   * @param {number} a Dividend.
   * @param {number} b Divisor.
   * @return {number} Modulo.
   */
  function modulo(a, b) {
    var r = a % b;
    return r * b < 0 ? r + b : r;
  }

  /**
   * Calculates the linearly interpolated value of x between a and b.
   *
   * @param {number} a Number
   * @param {number} b Number
   * @param {number} x Value to be interpolated.
   * @return {number} Interpolated value.
   */
  function lerp(a, b, x) {
    return a + x * (b - a);
  }

  /**
   * @module ol/centerconstraint
   */


  /**
   * @typedef {function((import("./coordinate.js").Coordinate|undefined)): (import("./coordinate.js").Coordinate|undefined)} Type
   */


  /**
   * @param {import("./extent.js").Extent} extent Extent.
   * @return {Type} The constraint.
   */
  function createExtent(extent) {
    return (
      /**
       * @param {import("./coordinate.js").Coordinate=} center Center.
       * @return {import("./coordinate.js").Coordinate|undefined} Center.
       */
      function(center) {
        if (center) {
          return [
            clamp(center[0], extent[0], extent[2]),
            clamp(center[1], extent[1], extent[3])
          ];
        } else {
          return undefined;
        }
      }
    );
  }


  /**
   * @param {import("./coordinate.js").Coordinate=} center Center.
   * @return {import("./coordinate.js").Coordinate|undefined} Center.
   */
  function none(center) {
    return center;
  }

  /**
   * @module ol/resolutionconstraint
   */


  /**
   * @typedef {function((number|undefined), number, number): (number|undefined)} Type
   */


  /**
   * @param {Array<number>} resolutions Resolutions.
   * @return {Type} Zoom function.
   */
  function createSnapToResolutions(resolutions) {
    return (
      /**
       * @param {number|undefined} resolution Resolution.
       * @param {number} delta Delta.
       * @param {number} direction Direction.
       * @return {number|undefined} Resolution.
       */
      function(resolution, delta, direction) {
        if (resolution !== undefined) {
          var z = linearFindNearest(resolutions, resolution, direction);
          z = clamp(z + delta, 0, resolutions.length - 1);
          var index = Math.floor(z);
          if (z != index && index < resolutions.length - 1) {
            var power = resolutions[index] / resolutions[index + 1];
            return resolutions[index] / Math.pow(power, z - index);
          } else {
            return resolutions[index];
          }
        } else {
          return undefined;
        }
      }
    );
  }


  /**
   * @param {number} power Power.
   * @param {number} maxResolution Maximum resolution.
   * @param {number=} opt_maxLevel Maximum level.
   * @return {Type} Zoom function.
   */
  function createSnapToPower(power, maxResolution, opt_maxLevel) {
    return (
      /**
       * @param {number|undefined} resolution Resolution.
       * @param {number} delta Delta.
       * @param {number} direction Direction.
       * @return {number|undefined} Resolution.
       */
      function(resolution, delta, direction) {
        if (resolution !== undefined) {
          var offset = -direction / 2 + 0.5;
          var oldLevel = Math.floor(
            Math.log(maxResolution / resolution) / Math.log(power) + offset);
          var newLevel = Math.max(oldLevel + delta, 0);
          if (opt_maxLevel !== undefined) {
            newLevel = Math.min(newLevel, opt_maxLevel);
          }
          return maxResolution / Math.pow(power, newLevel);
        } else {
          return undefined;
        }
      });
  }

  /**
   * @module ol/rotationconstraint
   */


  /**
   * @typedef {function((number|undefined), number): (number|undefined)} Type
   */


  /**
   * @param {number|undefined} rotation Rotation.
   * @param {number} delta Delta.
   * @return {number|undefined} Rotation.
   */
  function disable(rotation, delta) {
    if (rotation !== undefined) {
      return 0;
    } else {
      return undefined;
    }
  }


  /**
   * @param {number|undefined} rotation Rotation.
   * @param {number} delta Delta.
   * @return {number|undefined} Rotation.
   */
  function none$1(rotation, delta) {
    if (rotation !== undefined) {
      return rotation + delta;
    } else {
      return undefined;
    }
  }


  /**
   * @param {number} n N.
   * @return {Type} Rotation constraint.
   */
  function createSnapToN(n) {
    var theta = 2 * Math.PI / n;
    return (
      /**
       * @param {number|undefined} rotation Rotation.
       * @param {number} delta Delta.
       * @return {number|undefined} Rotation.
       */
      function(rotation, delta) {
        if (rotation !== undefined) {
          rotation = Math.floor((rotation + delta) / theta + 0.5) * theta;
          return rotation;
        } else {
          return undefined;
        }
      });
  }


  /**
   * @param {number=} opt_tolerance Tolerance.
   * @return {Type} Rotation constraint.
   */
  function createSnapToZero(opt_tolerance) {
    var tolerance = opt_tolerance || toRadians(5);
    return (
      /**
       * @param {number|undefined} rotation Rotation.
       * @param {number} delta Delta.
       * @return {number|undefined} Rotation.
       */
      function(rotation, delta) {
        if (rotation !== undefined) {
          if (Math.abs(rotation + delta) <= tolerance) {
            return 0;
          } else {
            return rotation + delta;
          }
        } else {
          return undefined;
        }
      });
  }

  /**
   * @module ol/ViewHint
   */

  /**
   * @enum {number}
   */
  var ViewHint = {
    ANIMATING: 0,
    INTERACTING: 1
  };

  /**
   * @module ol/ViewProperty
   */

  /**
   * @enum {string}
   */
  var ViewProperty = {
    CENTER: 'center',
    RESOLUTION: 'resolution',
    ROTATION: 'rotation'
  };

  /**
   * @module ol/string
   */

  /**
   * @module ol/coordinate
   */


  /**
   * An array of numbers representing an xy coordinate. Example: `[16, 48]`.
   * @typedef {Array<number>} Coordinate
   * @api
   */


  /**
   * A function that takes a {@link module:ol/coordinate~Coordinate} and
   * transforms it into a `{string}`.
   *
   * @typedef {function((Coordinate|undefined)): string} CoordinateFormat
   * @api
   */


  /**
   * Add `delta` to `coordinate`. `coordinate` is modified in place and returned
   * by the function.
   *
   * Example:
   *
   *     import {add} from 'ol/coordinate';
   *
   *     var coord = [7.85, 47.983333];
   *     add(coord, [-2, 4]);
   *     // coord is now [5.85, 51.983333]
   *
   * @param {Coordinate} coordinate Coordinate.
   * @param {Coordinate} delta Delta.
   * @return {Coordinate} The input coordinate adjusted by
   * the given delta.
   * @api
   */
  function add(coordinate, delta) {
    coordinate[0] += delta[0];
    coordinate[1] += delta[1];
    return coordinate;
  }


  /**
   * Calculates the point closest to the passed coordinate on the passed circle.
   *
   * @param {Coordinate} coordinate The coordinate.
   * @param {import("./geom/Circle.js").default} circle The circle.
   * @return {Coordinate} Closest point on the circumference.
   */
  function closestOnCircle(coordinate, circle) {
    var r = circle.getRadius();
    var center = circle.getCenter();
    var x0 = center[0];
    var y0 = center[1];
    var x1 = coordinate[0];
    var y1 = coordinate[1];

    var dx = x1 - x0;
    var dy = y1 - y0;
    if (dx === 0 && dy === 0) {
      dx = 1;
    }
    var d = Math.sqrt(dx * dx + dy * dy);

    var x = x0 + r * dx / d;
    var y = y0 + r * dy / d;

    return [x, y];
  }


  /**
   * Calculates the point closest to the passed coordinate on the passed segment.
   * This is the foot of the perpendicular of the coordinate to the segment when
   * the foot is on the segment, or the closest segment coordinate when the foot
   * is outside the segment.
   *
   * @param {Coordinate} coordinate The coordinate.
   * @param {Array<Coordinate>} segment The two coordinates
   * of the segment.
   * @return {Coordinate} The foot of the perpendicular of
   * the coordinate to the segment.
   */
  function closestOnSegment(coordinate, segment) {
    var x0 = coordinate[0];
    var y0 = coordinate[1];
    var start = segment[0];
    var end = segment[1];
    var x1 = start[0];
    var y1 = start[1];
    var x2 = end[0];
    var y2 = end[1];
    var dx = x2 - x1;
    var dy = y2 - y1;
    var along = (dx === 0 && dy === 0) ? 0 :
      ((dx * (x0 - x1)) + (dy * (y0 - y1))) / ((dx * dx + dy * dy) || 0);
    var x, y;
    if (along <= 0) {
      x = x1;
      y = y1;
    } else if (along >= 1) {
      x = x2;
      y = y2;
    } else {
      x = x1 + along * dx;
      y = y1 + along * dy;
    }
    return [x, y];
  }


  /**
   * @param {Coordinate} coordinate1 First coordinate.
   * @param {Coordinate} coordinate2 Second coordinate.
   * @return {boolean} The two coordinates are equal.
   */
  function equals$1(coordinate1, coordinate2) {
    var equals = true;
    for (var i = coordinate1.length - 1; i >= 0; --i) {
      if (coordinate1[i] != coordinate2[i]) {
        equals = false;
        break;
      }
    }
    return equals;
  }


  /**
   * Rotate `coordinate` by `angle`. `coordinate` is modified in place and
   * returned by the function.
   *
   * Example:
   *
   *     import {rotate} from 'ol/coordinate';
   *
   *     var coord = [7.85, 47.983333];
   *     var rotateRadians = Math.PI / 2; // 90 degrees
   *     rotate(coord, rotateRadians);
   *     // coord is now [-47.983333, 7.85]
   *
   * @param {Coordinate} coordinate Coordinate.
   * @param {number} angle Angle in radian.
   * @return {Coordinate} Coordinate.
   * @api
   */
  function rotate(coordinate, angle) {
    var cosAngle = Math.cos(angle);
    var sinAngle = Math.sin(angle);
    var x = coordinate[0] * cosAngle - coordinate[1] * sinAngle;
    var y = coordinate[1] * cosAngle + coordinate[0] * sinAngle;
    coordinate[0] = x;
    coordinate[1] = y;
    return coordinate;
  }


  /**
   * Scale `coordinate` by `scale`. `coordinate` is modified in place and returned
   * by the function.
   *
   * Example:
   *
   *     import {scale as scaleCoordinate} from 'ol/coordinate';
   *
   *     var coord = [7.85, 47.983333];
   *     var scale = 1.2;
   *     scaleCoordinate(coord, scale);
   *     // coord is now [9.42, 57.5799996]
   *
   * @param {Coordinate} coordinate Coordinate.
   * @param {number} scale Scale factor.
   * @return {Coordinate} Coordinate.
   */
  function scale(coordinate, scale) {
    coordinate[0] *= scale;
    coordinate[1] *= scale;
    return coordinate;
  }


  /**
   * @param {Coordinate} coord1 First coordinate.
   * @param {Coordinate} coord2 Second coordinate.
   * @return {number} Squared distance between coord1 and coord2.
   */
  function squaredDistance$1(coord1, coord2) {
    var dx = coord1[0] - coord2[0];
    var dy = coord1[1] - coord2[1];
    return dx * dx + dy * dy;
  }


  /**
   * @param {Coordinate} coord1 First coordinate.
   * @param {Coordinate} coord2 Second coordinate.
   * @return {number} Distance between coord1 and coord2.
   */
  function distance(coord1, coord2) {
    return Math.sqrt(squaredDistance$1(coord1, coord2));
  }


  /**
   * Calculate the squared distance from a coordinate to a line segment.
   *
   * @param {Coordinate} coordinate Coordinate of the point.
   * @param {Array<Coordinate>} segment Line segment (2
   * coordinates).
   * @return {number} Squared distance from the point to the line segment.
   */
  function squaredDistanceToSegment(coordinate, segment) {
    return squaredDistance$1(coordinate,
      closestOnSegment(coordinate, segment));
  }

  /**
   * @module ol/easing
   */


  /**
   * Start slow and speed up.
   * @param {number} t Input between 0 and 1.
   * @return {number} Output between 0 and 1.
   * @api
   */
  function easeIn(t) {
    return Math.pow(t, 3);
  }


  /**
   * Start fast and slow down.
   * @param {number} t Input between 0 and 1.
   * @return {number} Output between 0 and 1.
   * @api
   */
  function easeOut(t) {
    return 1 - easeIn(1 - t);
  }


  /**
   * Start slow, speed up, and then slow down again.
   * @param {number} t Input between 0 and 1.
   * @return {number} Output between 0 and 1.
   * @api
   */
  function inAndOut(t) {
    return 3 * t * t - 2 * t * t * t;
  }


  /**
   * Maintain a constant speed over time.
   * @param {number} t Input between 0 and 1.
   * @return {number} Output between 0 and 1.
   * @api
   */
  function linear(t) {
    return t;
  }

  /**
   * @module ol/extent/Corner
   */

  /**
   * Extent corner.
   * @enum {string}
   */
  var Corner = {
    BOTTOM_LEFT: 'bottom-left',
    BOTTOM_RIGHT: 'bottom-right',
    TOP_LEFT: 'top-left',
    TOP_RIGHT: 'top-right'
  };

  /**
   * @module ol/extent/Relationship
   */

  /**
   * Relationship to an extent.
   * @enum {number}
   */
  var Relationship = {
    UNKNOWN: 0,
    INTERSECTING: 1,
    ABOVE: 2,
    RIGHT: 4,
    BELOW: 8,
    LEFT: 16
  };

  /**
   * @module ol/extent
   */


  /**
   * An array of numbers representing an extent: `[minx, miny, maxx, maxy]`.
   * @typedef {Array<number>} Extent
   * @api
   */

  /**
   * Build an extent that includes all given coordinates.
   *
   * @param {Array<import("./coordinate.js").Coordinate>} coordinates Coordinates.
   * @return {Extent} Bounding extent.
   * @api
   */
  function boundingExtent(coordinates) {
    var extent = createEmpty();
    for (var i = 0, ii = coordinates.length; i < ii; ++i) {
      extendCoordinate(extent, coordinates[i]);
    }
    return extent;
  }


  /**
   * Return extent increased by the provided value.
   * @param {Extent} extent Extent.
   * @param {number} value The amount by which the extent should be buffered.
   * @param {Extent=} opt_extent Extent.
   * @return {Extent} Extent.
   * @api
   */
  function buffer(extent, value, opt_extent) {
    if (opt_extent) {
      opt_extent[0] = extent[0] - value;
      opt_extent[1] = extent[1] - value;
      opt_extent[2] = extent[2] + value;
      opt_extent[3] = extent[3] + value;
      return opt_extent;
    } else {
      return [
        extent[0] - value,
        extent[1] - value,
        extent[2] + value,
        extent[3] + value
      ];
    }
  }


  /**
   * Creates a clone of an extent.
   *
   * @param {Extent} extent Extent to clone.
   * @param {Extent=} opt_extent Extent.
   * @return {Extent} The clone.
   */
  function clone(extent, opt_extent) {
    if (opt_extent) {
      opt_extent[0] = extent[0];
      opt_extent[1] = extent[1];
      opt_extent[2] = extent[2];
      opt_extent[3] = extent[3];
      return opt_extent;
    } else {
      return extent.slice();
    }
  }


  /**
   * @param {Extent} extent Extent.
   * @param {number} x X.
   * @param {number} y Y.
   * @return {number} Closest squared distance.
   */
  function closestSquaredDistanceXY(extent, x, y) {
    var dx, dy;
    if (x < extent[0]) {
      dx = extent[0] - x;
    } else if (extent[2] < x) {
      dx = x - extent[2];
    } else {
      dx = 0;
    }
    if (y < extent[1]) {
      dy = extent[1] - y;
    } else if (extent[3] < y) {
      dy = y - extent[3];
    } else {
      dy = 0;
    }
    return dx * dx + dy * dy;
  }


  /**
   * Check if the passed coordinate is contained or on the edge of the extent.
   *
   * @param {Extent} extent Extent.
   * @param {import("./coordinate.js").Coordinate} coordinate Coordinate.
   * @return {boolean} The coordinate is contained in the extent.
   * @api
   */
  function containsCoordinate(extent, coordinate) {
    return containsXY(extent, coordinate[0], coordinate[1]);
  }


  /**
   * Check if one extent contains another.
   *
   * An extent is deemed contained if it lies completely within the other extent,
   * including if they share one or more edges.
   *
   * @param {Extent} extent1 Extent 1.
   * @param {Extent} extent2 Extent 2.
   * @return {boolean} The second extent is contained by or on the edge of the
   *     first.
   * @api
   */
  function containsExtent(extent1, extent2) {
    return extent1[0] <= extent2[0] && extent2[2] <= extent1[2] &&
        extent1[1] <= extent2[1] && extent2[3] <= extent1[3];
  }


  /**
   * Check if the passed coordinate is contained or on the edge of the extent.
   *
   * @param {Extent} extent Extent.
   * @param {number} x X coordinate.
   * @param {number} y Y coordinate.
   * @return {boolean} The x, y values are contained in the extent.
   * @api
   */
  function containsXY(extent, x, y) {
    return extent[0] <= x && x <= extent[2] && extent[1] <= y && y <= extent[3];
  }


  /**
   * Get the relationship between a coordinate and extent.
   * @param {Extent} extent The extent.
   * @param {import("./coordinate.js").Coordinate} coordinate The coordinate.
   * @return {Relationship} The relationship (bitwise compare with
   *     import("./extent/Relationship.js").Relationship).
   */
  function coordinateRelationship(extent, coordinate) {
    var minX = extent[0];
    var minY = extent[1];
    var maxX = extent[2];
    var maxY = extent[3];
    var x = coordinate[0];
    var y = coordinate[1];
    var relationship = Relationship.UNKNOWN;
    if (x < minX) {
      relationship = relationship | Relationship.LEFT;
    } else if (x > maxX) {
      relationship = relationship | Relationship.RIGHT;
    }
    if (y < minY) {
      relationship = relationship | Relationship.BELOW;
    } else if (y > maxY) {
      relationship = relationship | Relationship.ABOVE;
    }
    if (relationship === Relationship.UNKNOWN) {
      relationship = Relationship.INTERSECTING;
    }
    return relationship;
  }


  /**
   * Create an empty extent.
   * @return {Extent} Empty extent.
   * @api
   */
  function createEmpty() {
    return [Infinity, Infinity, -Infinity, -Infinity];
  }


  /**
   * Create a new extent or update the provided extent.
   * @param {number} minX Minimum X.
   * @param {number} minY Minimum Y.
   * @param {number} maxX Maximum X.
   * @param {number} maxY Maximum Y.
   * @param {Extent=} opt_extent Destination extent.
   * @return {Extent} Extent.
   */
  function createOrUpdate(minX, minY, maxX, maxY, opt_extent) {
    if (opt_extent) {
      opt_extent[0] = minX;
      opt_extent[1] = minY;
      opt_extent[2] = maxX;
      opt_extent[3] = maxY;
      return opt_extent;
    } else {
      return [minX, minY, maxX, maxY];
    }
  }


  /**
   * Create a new empty extent or make the provided one empty.
   * @param {Extent=} opt_extent Extent.
   * @return {Extent} Extent.
   */
  function createOrUpdateEmpty(opt_extent) {
    return createOrUpdate(
      Infinity, Infinity, -Infinity, -Infinity, opt_extent);
  }


  /**
   * @param {import("./coordinate.js").Coordinate} coordinate Coordinate.
   * @param {Extent=} opt_extent Extent.
   * @return {Extent} Extent.
   */
  function createOrUpdateFromCoordinate(coordinate, opt_extent) {
    var x = coordinate[0];
    var y = coordinate[1];
    return createOrUpdate(x, y, x, y, opt_extent);
  }


  /**
   * @param {Array<import("./coordinate.js").Coordinate>} coordinates Coordinates.
   * @param {Extent=} opt_extent Extent.
   * @return {Extent} Extent.
   */
  function createOrUpdateFromCoordinates(coordinates, opt_extent) {
    var extent = createOrUpdateEmpty(opt_extent);
    return extendCoordinates(extent, coordinates);
  }


  /**
   * @param {Array<number>} flatCoordinates Flat coordinates.
   * @param {number} offset Offset.
   * @param {number} end End.
   * @param {number} stride Stride.
   * @param {Extent=} opt_extent Extent.
   * @return {Extent} Extent.
   */
  function createOrUpdateFromFlatCoordinates(flatCoordinates, offset, end, stride, opt_extent) {
    var extent = createOrUpdateEmpty(opt_extent);
    return extendFlatCoordinates(extent, flatCoordinates, offset, end, stride);
  }


  /**
   * Determine if two extents are equivalent.
   * @param {Extent} extent1 Extent 1.
   * @param {Extent} extent2 Extent 2.
   * @return {boolean} The two extents are equivalent.
   * @api
   */
  function equals$2(extent1, extent2) {
    return extent1[0] == extent2[0] && extent1[2] == extent2[2] &&
        extent1[1] == extent2[1] && extent1[3] == extent2[3];
  }


  /**
   * Modify an extent to include another extent.
   * @param {Extent} extent1 The extent to be modified.
   * @param {Extent} extent2 The extent that will be included in the first.
   * @return {Extent} A reference to the first (extended) extent.
   * @api
   */
  function extend$1(extent1, extent2) {
    if (extent2[0] < extent1[0]) {
      extent1[0] = extent2[0];
    }
    if (extent2[2] > extent1[2]) {
      extent1[2] = extent2[2];
    }
    if (extent2[1] < extent1[1]) {
      extent1[1] = extent2[1];
    }
    if (extent2[3] > extent1[3]) {
      extent1[3] = extent2[3];
    }
    return extent1;
  }


  /**
   * @param {Extent} extent Extent.
   * @param {import("./coordinate.js").Coordinate} coordinate Coordinate.
   */
  function extendCoordinate(extent, coordinate) {
    if (coordinate[0] < extent[0]) {
      extent[0] = coordinate[0];
    }
    if (coordinate[0] > extent[2]) {
      extent[2] = coordinate[0];
    }
    if (coordinate[1] < extent[1]) {
      extent[1] = coordinate[1];
    }
    if (coordinate[1] > extent[3]) {
      extent[3] = coordinate[1];
    }
  }


  /**
   * @param {Extent} extent Extent.
   * @param {Array<import("./coordinate.js").Coordinate>} coordinates Coordinates.
   * @return {Extent} Extent.
   */
  function extendCoordinates(extent, coordinates) {
    for (var i = 0, ii = coordinates.length; i < ii; ++i) {
      extendCoordinate(extent, coordinates[i]);
    }
    return extent;
  }


  /**
   * @param {Extent} extent Extent.
   * @param {Array<number>} flatCoordinates Flat coordinates.
   * @param {number} offset Offset.
   * @param {number} end End.
   * @param {number} stride Stride.
   * @return {Extent} Extent.
   */
  function extendFlatCoordinates(extent, flatCoordinates, offset, end, stride) {
    for (; offset < end; offset += stride) {
      extendXY(extent, flatCoordinates[offset], flatCoordinates[offset + 1]);
    }
    return extent;
  }


  /**
   * @param {Extent} extent Extent.
   * @param {number} x X.
   * @param {number} y Y.
   */
  function extendXY(extent, x, y) {
    extent[0] = Math.min(extent[0], x);
    extent[1] = Math.min(extent[1], y);
    extent[2] = Math.max(extent[2], x);
    extent[3] = Math.max(extent[3], y);
  }


  /**
   * This function calls `callback` for each corner of the extent. If the
   * callback returns a truthy value the function returns that value
   * immediately. Otherwise the function returns `false`.
   * @param {Extent} extent Extent.
   * @param {function(this:T, import("./coordinate.js").Coordinate): S} callback Callback.
   * @param {T=} opt_this Value to use as `this` when executing `callback`.
   * @return {S|boolean} Value.
   * @template S, T
   */
  function forEachCorner(extent, callback, opt_this) {
    var val;
    val = callback.call(opt_this, getBottomLeft(extent));
    if (val) {
      return val;
    }
    val = callback.call(opt_this, getBottomRight(extent));
    if (val) {
      return val;
    }
    val = callback.call(opt_this, getTopRight(extent));
    if (val) {
      return val;
    }
    val = callback.call(opt_this, getTopLeft(extent));
    if (val) {
      return val;
    }
    return false;
  }


  /**
   * Get the size of an extent.
   * @param {Extent} extent Extent.
   * @return {number} Area.
   * @api
   */
  function getArea(extent) {
    var area = 0;
    if (!isEmpty$1(extent)) {
      area = getWidth(extent) * getHeight(extent);
    }
    return area;
  }


  /**
   * Get the bottom left coordinate of an extent.
   * @param {Extent} extent Extent.
   * @return {import("./coordinate.js").Coordinate} Bottom left coordinate.
   * @api
   */
  function getBottomLeft(extent) {
    return [extent[0], extent[1]];
  }


  /**
   * Get the bottom right coordinate of an extent.
   * @param {Extent} extent Extent.
   * @return {import("./coordinate.js").Coordinate} Bottom right coordinate.
   * @api
   */
  function getBottomRight(extent) {
    return [extent[2], extent[1]];
  }


  /**
   * Get the center coordinate of an extent.
   * @param {Extent} extent Extent.
   * @return {import("./coordinate.js").Coordinate} Center.
   * @api
   */
  function getCenter(extent) {
    return [(extent[0] + extent[2]) / 2, (extent[1] + extent[3]) / 2];
  }


  /**
   * Get a corner coordinate of an extent.
   * @param {Extent} extent Extent.
   * @param {Corner} corner Corner.
   * @return {import("./coordinate.js").Coordinate} Corner coordinate.
   */
  function getCorner(extent, corner) {
    var coordinate;
    if (corner === Corner.BOTTOM_LEFT) {
      coordinate = getBottomLeft(extent);
    } else if (corner === Corner.BOTTOM_RIGHT) {
      coordinate = getBottomRight(extent);
    } else if (corner === Corner.TOP_LEFT) {
      coordinate = getTopLeft(extent);
    } else if (corner === Corner.TOP_RIGHT) {
      coordinate = getTopRight(extent);
    } else {
      assert(false, 13); // Invalid corner
    }
    return coordinate;
  }


  /**
   * @param {import("./coordinate.js").Coordinate} center Center.
   * @param {number} resolution Resolution.
   * @param {number} rotation Rotation.
   * @param {import("./size.js").Size} size Size.
   * @param {Extent=} opt_extent Destination extent.
   * @return {Extent} Extent.
   */
  function getForViewAndSize(center, resolution, rotation, size, opt_extent) {
    var dx = resolution * size[0] / 2;
    var dy = resolution * size[1] / 2;
    var cosRotation = Math.cos(rotation);
    var sinRotation = Math.sin(rotation);
    var xCos = dx * cosRotation;
    var xSin = dx * sinRotation;
    var yCos = dy * cosRotation;
    var ySin = dy * sinRotation;
    var x = center[0];
    var y = center[1];
    var x0 = x - xCos + ySin;
    var x1 = x - xCos - ySin;
    var x2 = x + xCos - ySin;
    var x3 = x + xCos + ySin;
    var y0 = y - xSin - yCos;
    var y1 = y - xSin + yCos;
    var y2 = y + xSin + yCos;
    var y3 = y + xSin - yCos;
    return createOrUpdate(
      Math.min(x0, x1, x2, x3), Math.min(y0, y1, y2, y3),
      Math.max(x0, x1, x2, x3), Math.max(y0, y1, y2, y3),
      opt_extent);
  }


  /**
   * Get the height of an extent.
   * @param {Extent} extent Extent.
   * @return {number} Height.
   * @api
   */
  function getHeight(extent) {
    return extent[3] - extent[1];
  }


  /**
   * Get the intersection of two extents.
   * @param {Extent} extent1 Extent 1.
   * @param {Extent} extent2 Extent 2.
   * @param {Extent=} opt_extent Optional extent to populate with intersection.
   * @return {Extent} Intersecting extent.
   * @api
   */
  function getIntersection(extent1, extent2, opt_extent) {
    var intersection = opt_extent ? opt_extent : createEmpty();
    if (intersects(extent1, extent2)) {
      if (extent1[0] > extent2[0]) {
        intersection[0] = extent1[0];
      } else {
        intersection[0] = extent2[0];
      }
      if (extent1[1] > extent2[1]) {
        intersection[1] = extent1[1];
      } else {
        intersection[1] = extent2[1];
      }
      if (extent1[2] < extent2[2]) {
        intersection[2] = extent1[2];
      } else {
        intersection[2] = extent2[2];
      }
      if (extent1[3] < extent2[3]) {
        intersection[3] = extent1[3];
      } else {
        intersection[3] = extent2[3];
      }
    } else {
      createOrUpdateEmpty(intersection);
    }
    return intersection;
  }


  /**
   * Get the top left coordinate of an extent.
   * @param {Extent} extent Extent.
   * @return {import("./coordinate.js").Coordinate} Top left coordinate.
   * @api
   */
  function getTopLeft(extent) {
    return [extent[0], extent[3]];
  }


  /**
   * Get the top right coordinate of an extent.
   * @param {Extent} extent Extent.
   * @return {import("./coordinate.js").Coordinate} Top right coordinate.
   * @api
   */
  function getTopRight(extent) {
    return [extent[2], extent[3]];
  }


  /**
   * Get the width of an extent.
   * @param {Extent} extent Extent.
   * @return {number} Width.
   * @api
   */
  function getWidth(extent) {
    return extent[2] - extent[0];
  }


  /**
   * Determine if one extent intersects another.
   * @param {Extent} extent1 Extent 1.
   * @param {Extent} extent2 Extent.
   * @return {boolean} The two extents intersect.
   * @api
   */
  function intersects(extent1, extent2) {
    return extent1[0] <= extent2[2] &&
        extent1[2] >= extent2[0] &&
        extent1[1] <= extent2[3] &&
        extent1[3] >= extent2[1];
  }


  /**
   * Determine if an extent is empty.
   * @param {Extent} extent Extent.
   * @return {boolean} Is empty.
   * @api
   */
  function isEmpty$1(extent) {
    return extent[2] < extent[0] || extent[3] < extent[1];
  }


  /**
   * @param {Extent} extent Extent.
   * @param {Extent=} opt_extent Extent.
   * @return {Extent} Extent.
   */
  function returnOrUpdate(extent, opt_extent) {
    if (opt_extent) {
      opt_extent[0] = extent[0];
      opt_extent[1] = extent[1];
      opt_extent[2] = extent[2];
      opt_extent[3] = extent[3];
      return opt_extent;
    } else {
      return extent;
    }
  }


  /**
   * @param {Extent} extent Extent.
   * @param {number} value Value.
   */
  function scaleFromCenter(extent, value) {
    var deltaX = ((extent[2] - extent[0]) / 2) * (value - 1);
    var deltaY = ((extent[3] - extent[1]) / 2) * (value - 1);
    extent[0] -= deltaX;
    extent[2] += deltaX;
    extent[1] -= deltaY;
    extent[3] += deltaY;
  }


  /**
   * Determine if the segment between two coordinates intersects (crosses,
   * touches, or is contained by) the provided extent.
   * @param {Extent} extent The extent.
   * @param {import("./coordinate.js").Coordinate} start Segment start coordinate.
   * @param {import("./coordinate.js").Coordinate} end Segment end coordinate.
   * @return {boolean} The segment intersects the extent.
   */
  function intersectsSegment(extent, start, end) {
    var intersects = false;
    var startRel = coordinateRelationship(extent, start);
    var endRel = coordinateRelationship(extent, end);
    if (startRel === Relationship.INTERSECTING ||
        endRel === Relationship.INTERSECTING) {
      intersects = true;
    } else {
      var minX = extent[0];
      var minY = extent[1];
      var maxX = extent[2];
      var maxY = extent[3];
      var startX = start[0];
      var startY = start[1];
      var endX = end[0];
      var endY = end[1];
      var slope = (endY - startY) / (endX - startX);
      var x, y;
      if (!!(endRel & Relationship.ABOVE) &&
          !(startRel & Relationship.ABOVE)) {
        // potentially intersects top
        x = endX - ((endY - maxY) / slope);
        intersects = x >= minX && x <= maxX;
      }
      if (!intersects && !!(endRel & Relationship.RIGHT) &&
          !(startRel & Relationship.RIGHT)) {
        // potentially intersects right
        y = endY - ((endX - maxX) * slope);
        intersects = y >= minY && y <= maxY;
      }
      if (!intersects && !!(endRel & Relationship.BELOW) &&
          !(startRel & Relationship.BELOW)) {
        // potentially intersects bottom
        x = endX - ((endY - minY) / slope);
        intersects = x >= minX && x <= maxX;
      }
      if (!intersects && !!(endRel & Relationship.LEFT) &&
          !(startRel & Relationship.LEFT)) {
        // potentially intersects left
        y = endY - ((endX - minX) * slope);
        intersects = y >= minY && y <= maxY;
      }

    }
    return intersects;
  }

  /**
   * @module ol/geom/GeometryType
   */

  /**
   * The geometry type. One of `'Point'`, `'LineString'`, `'LinearRing'`,
   * `'Polygon'`, `'MultiPoint'`, `'MultiLineString'`, `'MultiPolygon'`,
   * `'GeometryCollection'`, `'Circle'`.
   * @enum {string}
   */
  var GeometryType = {
    POINT: 'Point',
    LINE_STRING: 'LineString',
    LINEAR_RING: 'LinearRing',
    POLYGON: 'Polygon',
    MULTI_POINT: 'MultiPoint',
    MULTI_LINE_STRING: 'MultiLineString',
    MULTI_POLYGON: 'MultiPolygon',
    GEOMETRY_COLLECTION: 'GeometryCollection',
    CIRCLE: 'Circle'
  };

  /**
   * @module ol/geom/GeometryLayout
   */

  /**
   * The coordinate layout for geometries, indicating whether a 3rd or 4th z ('Z')
   * or measure ('M') coordinate is available. Supported values are `'XY'`,
   * `'XYZ'`, `'XYM'`, `'XYZM'`.
   * @enum {string}
   */
  var GeometryLayout = {
    XY: 'XY',
    XYZ: 'XYZ',
    XYM: 'XYM',
    XYZM: 'XYZM'
  };

  /**
   * @module ol/geom/flat/transform
   */


  /**
   * @param {Array<number>} flatCoordinates Flat coordinates.
   * @param {number} offset Offset.
   * @param {number} end End.
   * @param {number} stride Stride.
   * @param {import("../../transform.js").Transform} transform Transform.
   * @param {Array<number>=} opt_dest Destination.
   * @return {Array<number>} Transformed coordinates.
   */
  function transform2D(flatCoordinates, offset, end, stride, transform, opt_dest) {
    var dest = opt_dest ? opt_dest : [];
    var i = 0;
    for (var j = offset; j < end; j += stride) {
      var x = flatCoordinates[j];
      var y = flatCoordinates[j + 1];
      dest[i++] = transform[0] * x + transform[2] * y + transform[4];
      dest[i++] = transform[1] * x + transform[3] * y + transform[5];
    }
    if (opt_dest && dest.length != i) {
      dest.length = i;
    }
    return dest;
  }


  /**
   * @param {Array<number>} flatCoordinates Flat coordinates.
   * @param {number} offset Offset.
   * @param {number} end End.
   * @param {number} stride Stride.
   * @param {number} angle Angle.
   * @param {Array<number>} anchor Rotation anchor point.
   * @param {Array<number>=} opt_dest Destination.
   * @return {Array<number>} Transformed coordinates.
   */
  function rotate$1(flatCoordinates, offset, end, stride, angle, anchor, opt_dest) {
    var dest = opt_dest ? opt_dest : [];
    var cos = Math.cos(angle);
    var sin = Math.sin(angle);
    var anchorX = anchor[0];
    var anchorY = anchor[1];
    var i = 0;
    for (var j = offset; j < end; j += stride) {
      var deltaX = flatCoordinates[j] - anchorX;
      var deltaY = flatCoordinates[j + 1] - anchorY;
      dest[i++] = anchorX + deltaX * cos - deltaY * sin;
      dest[i++] = anchorY + deltaX * sin + deltaY * cos;
      for (var k = j + 2; k < j + stride; ++k) {
        dest[i++] = flatCoordinates[k];
      }
    }
    if (opt_dest && dest.length != i) {
      dest.length = i;
    }
    return dest;
  }


  /**
   * Scale the coordinates.
   * @param {Array<number>} flatCoordinates Flat coordinates.
   * @param {number} offset Offset.
   * @param {number} end End.
   * @param {number} stride Stride.
   * @param {number} sx Scale factor in the x-direction.
   * @param {number} sy Scale factor in the y-direction.
   * @param {Array<number>} anchor Scale anchor point.
   * @param {Array<number>=} opt_dest Destination.
   * @return {Array<number>} Transformed coordinates.
   */
  function scale$1(flatCoordinates, offset, end, stride, sx, sy, anchor, opt_dest) {
    var dest = opt_dest ? opt_dest : [];
    var anchorX = anchor[0];
    var anchorY = anchor[1];
    var i = 0;
    for (var j = offset; j < end; j += stride) {
      var deltaX = flatCoordinates[j] - anchorX;
      var deltaY = flatCoordinates[j + 1] - anchorY;
      dest[i++] = anchorX + sx * deltaX;
      dest[i++] = anchorY + sy * deltaY;
      for (var k = j + 2; k < j + stride; ++k) {
        dest[i++] = flatCoordinates[k];
      }
    }
    if (opt_dest && dest.length != i) {
      dest.length = i;
    }
    return dest;
  }


  /**
   * @param {Array<number>} flatCoordinates Flat coordinates.
   * @param {number} offset Offset.
   * @param {number} end End.
   * @param {number} stride Stride.
   * @param {number} deltaX Delta X.
   * @param {number} deltaY Delta Y.
   * @param {Array<number>=} opt_dest Destination.
   * @return {Array<number>} Transformed coordinates.
   */
  function translate(flatCoordinates, offset, end, stride, deltaX, deltaY, opt_dest) {
    var dest = opt_dest ? opt_dest : [];
    var i = 0;
    for (var j = offset; j < end; j += stride) {
      dest[i++] = flatCoordinates[j] + deltaX;
      dest[i++] = flatCoordinates[j + 1] + deltaY;
      for (var k = j + 2; k < j + stride; ++k) {
        dest[i++] = flatCoordinates[k];
      }
    }
    if (opt_dest && dest.length != i) {
      dest.length = i;
    }
    return dest;
  }

  /**
   * @license
   * Latitude/longitude spherical geodesy formulae taken from
   * http://www.movable-type.co.uk/scripts/latlong.html
   * Licensed under CC-BY-3.0.
   */


  /**
   * Object literal with options for the {@link getLength} or {@link getArea}
   * functions.
   * @typedef {Object} SphereMetricOptions
   * @property {import("./proj.js").ProjectionLike} [projection='EPSG:3857']
   * Projection of the  geometry.  By default, the geometry is assumed to be in
   * Web Mercator.
   * @property {number} [radius=6371008.8] Sphere radius.  By default, the radius of the
   * earth is used (Clarke 1866 Authalic Sphere).
   */


  /**
   * The mean Earth radius (1/3 * (2a + b)) for the WGS84 ellipsoid.
   * https://en.wikipedia.org/wiki/Earth_radius#Mean_radius
   * @type {number}
   */
  var DEFAULT_RADIUS = 6371008.8;


  /**
   * Get the great circle distance (in meters) between two geographic coordinates.
   * @param {Array} c1 Starting coordinate.
   * @param {Array} c2 Ending coordinate.
   * @param {number=} opt_radius The sphere radius to use.  Defaults to the Earth's
   *     mean radius using the WGS84 ellipsoid.
   * @return {number} The great circle distance between the points (in meters).
   * @api
   */
  function getDistance(c1, c2, opt_radius) {
    var radius = opt_radius || DEFAULT_RADIUS;
    var lat1 = toRadians(c1[1]);
    var lat2 = toRadians(c2[1]);
    var deltaLatBy2 = (lat2 - lat1) / 2;
    var deltaLonBy2 = toRadians(c2[0] - c1[0]) / 2;
    var a = Math.sin(deltaLatBy2) * Math.sin(deltaLatBy2) +
        Math.sin(deltaLonBy2) * Math.sin(deltaLonBy2) *
        Math.cos(lat1) * Math.cos(lat2);
    return 2 * radius * Math.atan2(Math.sqrt(a), Math.sqrt(1 - a));
  }

  /**
   * @module ol/proj/Units
   */

  /**
   * Projection units: `'degrees'`, `'ft'`, `'m'`, `'pixels'`, `'tile-pixels'` or
   * `'us-ft'`.
   * @enum {string}
   */
  var Units = {
    DEGREES: 'degrees',
    FEET: 'ft',
    METERS: 'm',
    PIXELS: 'pixels',
    TILE_PIXELS: 'tile-pixels',
    USFEET: 'us-ft'
  };


  /**
   * Meters per unit lookup table.
   * @const
   * @type {Object<Units, number>}
   * @api
   */
  var METERS_PER_UNIT = {};
  // use the radius of the Normal sphere
  METERS_PER_UNIT[Units.DEGREES] = 2 * Math.PI * 6370997 / 360;
  METERS_PER_UNIT[Units.FEET] = 0.3048;
  METERS_PER_UNIT[Units.METERS] = 1;
  METERS_PER_UNIT[Units.USFEET] = 1200 / 3937;

  /**
   * @module ol/proj/Projection
   */


  /**
   * @typedef {Object} Options
   * @property {string} code The SRS identifier code, e.g. `EPSG:4326`.
   * @property {import("./Units.js").default|string} [units] Units. Required unless a
   * proj4 projection is defined for `code`.
   * @property {import("../extent.js").Extent} [extent] The validity extent for the SRS.
   * @property {string} [axisOrientation='enu'] The axis orientation as specified in Proj4.
   * @property {boolean} [global=false] Whether the projection is valid for the whole globe.
   * @property {number} [metersPerUnit] The meters per unit for the SRS.
   * If not provided, the `units` are used to get the meters per unit from the {@link module:ol/proj/Units~METERS_PER_UNIT}
   * lookup table.
   * @property {import("../extent.js").Extent} [worldExtent] The world extent for the SRS.
   * @property {function(number, import("../coordinate.js").Coordinate):number} [getPointResolution]
   * Function to determine resolution at a point. The function is called with a
   * `{number}` view resolution and an `{import("../coordinate.js").Coordinate}` as arguments, and returns
   * the `{number}` resolution at the passed coordinate. If this is `undefined`,
   * the default {@link module:ol/proj#getPointResolution} function will be used.
   */


  /**
   * @classdesc
   * Projection definition class. One of these is created for each projection
   * supported in the application and stored in the {@link module:ol/proj} namespace.
   * You can use these in applications, but this is not required, as API params
   * and options use {@link module:ol/proj~ProjectionLike} which means the simple string
   * code will suffice.
   *
   * You can use {@link module:ol/proj~get} to retrieve the object for a particular
   * projection.
   *
   * The library includes definitions for `EPSG:4326` and `EPSG:3857`, together
   * with the following aliases:
   * * `EPSG:4326`: CRS:84, urn:ogc:def:crs:EPSG:6.6:4326,
   *     urn:ogc:def:crs:OGC:1.3:CRS84, urn:ogc:def:crs:OGC:2:84,
   *     http://www.opengis.net/gml/srs/epsg.xml#4326,
   *     urn:x-ogc:def:crs:EPSG:4326
   * * `EPSG:3857`: EPSG:102100, EPSG:102113, EPSG:900913,
   *     urn:ogc:def:crs:EPSG:6.18:3:3857,
   *     http://www.opengis.net/gml/srs/epsg.xml#3857
   *
   * If you use [proj4js](https://github.com/proj4js/proj4js), aliases can
   * be added using `proj4.defs()`. After all required projection definitions are
   * added, call the {@link module:ol/proj/proj4~register} function.
   *
   * @api
   */
  var Projection = function Projection(options) {
    /**
     * @private
     * @type {string}
     */
    this.code_ = options.code;

    /**
     * Units of projected coordinates. When set to `TILE_PIXELS`, a
     * `this.extent_` and `this.worldExtent_` must be configured properly for each
     * tile.
     * @private
     * @type {import("./Units.js").default}
     */
    this.units_ = /** @type {import("./Units.js").default} */ (options.units);

    /**
     * Validity extent of the projection in projected coordinates. For projections
     * with `TILE_PIXELS` units, this is the extent of the tile in
     * tile pixel space.
     * @private
     * @type {import("../extent.js").Extent}
     */
    this.extent_ = options.extent !== undefined ? options.extent : null;

    /**
     * Extent of the world in EPSG:4326. For projections with
     * `TILE_PIXELS` units, this is the extent of the tile in
     * projected coordinate space.
     * @private
     * @type {import("../extent.js").Extent}
     */
    this.worldExtent_ = options.worldExtent !== undefined ?
      options.worldExtent : null;

    /**
     * @private
     * @type {string}
     */
    this.axisOrientation_ = options.axisOrientation !== undefined ?
      options.axisOrientation : 'enu';

    /**
     * @private
     * @type {boolean}
     */
    this.global_ = options.global !== undefined ? options.global : false;

    /**
     * @private
     * @type {boolean}
     */
    this.canWrapX_ = !!(this.global_ && this.extent_);

    /**
     * @private
     * @type {function(number, import("../coordinate.js").Coordinate):number|undefined}
     */
    this.getPointResolutionFunc_ = options.getPointResolution;

    /**
     * @private
     * @type {import("../tilegrid/TileGrid.js").default}
     */
    this.defaultTileGrid_ = null;

    /**
     * @private
     * @type {number|undefined}
     */
    this.metersPerUnit_ = options.metersPerUnit;
  };

  /**
   * @return {boolean} The projection is suitable for wrapping the x-axis
   */
  Projection.prototype.canWrapX = function canWrapX () {
    return this.canWrapX_;
  };

  /**
   * Get the code for this projection, e.g. 'EPSG:4326'.
   * @return {string} Code.
   * @api
   */
  Projection.prototype.getCode = function getCode () {
    return this.code_;
  };

  /**
   * Get the validity extent for this projection.
   * @return {import("../extent.js").Extent} Extent.
   * @api
   */
  Projection.prototype.getExtent = function getExtent () {
    return this.extent_;
  };

  /**
   * Get the units of this projection.
   * @return {import("./Units.js").default} Units.
   * @api
   */
  Projection.prototype.getUnits = function getUnits () {
    return this.units_;
  };

  /**
   * Get the amount of meters per unit of this projection.If the projection is
   * not configured with `metersPerUnit` or a units identifier, the return is
   * `undefined`.
   * @return {number|undefined} Meters.
   * @api
   */
  Projection.prototype.getMetersPerUnit = function getMetersPerUnit () {
    return this.metersPerUnit_ || METERS_PER_UNIT[this.units_];
  };

  /**
   * Get the world extent for this projection.
   * @return {import("../extent.js").Extent} Extent.
   * @api
   */
  Projection.prototype.getWorldExtent = function getWorldExtent () {
    return this.worldExtent_;
  };

  /**
   * Get the axis orientation of this projection.
   * Example values are:
   * enu - the default easting, northing, elevation.
   * neu - northing, easting, up - useful for "lat/long" geographic coordinates,
   *   or south orientated transverse mercator.
   * wnu - westing, northing, up - some planetary coordinate systems have
   *   "west positive" coordinate systems
   * @return {string} Axis orientation.
   * @api
   */
  Projection.prototype.getAxisOrientation = function getAxisOrientation () {
    return this.axisOrientation_;
  };

  /**
   * Is this projection a global projection which spans the whole world?
   * @return {boolean} Whether the projection is global.
   * @api
   */
  Projection.prototype.isGlobal = function isGlobal () {
    return this.global_;
  };

  /**
   * Set if the projection is a global projection which spans the whole world
   * @param {boolean} global Whether the projection is global.
   * @api
   */
  Projection.prototype.setGlobal = function setGlobal (global) {
    this.global_ = global;
    this.canWrapX_ = !!(global && this.extent_);
  };

  /**
   * @return {import("../tilegrid/TileGrid.js").default} The default tile grid.
   */
  Projection.prototype.getDefaultTileGrid = function getDefaultTileGrid () {
    return this.defaultTileGrid_;
  };

  /**
   * @param {import("../tilegrid/TileGrid.js").default} tileGrid The default tile grid.
   */
  Projection.prototype.setDefaultTileGrid = function setDefaultTileGrid (tileGrid) {
    this.defaultTileGrid_ = tileGrid;
  };

  /**
   * Set the validity extent for this projection.
   * @param {import("../extent.js").Extent} extent Extent.
   * @api
   */
  Projection.prototype.setExtent = function setExtent (extent) {
    this.extent_ = extent;
    this.canWrapX_ = !!(this.global_ && extent);
  };

  /**
   * Set the world extent for this projection.
   * @param {import("../extent.js").Extent} worldExtent World extent
   *   [minlon, minlat, maxlon, maxlat].
   * @api
   */
  Projection.prototype.setWorldExtent = function setWorldExtent (worldExtent) {
    this.worldExtent_ = worldExtent;
  };

  /**
   * Set the getPointResolution function (see {@link module:ol/proj~getPointResolution}
   * for this projection.
   * @param {function(number, import("../coordinate.js").Coordinate):number} func Function
   * @api
   */
  Projection.prototype.setGetPointResolution = function setGetPointResolution (func) {
    this.getPointResolutionFunc_ = func;
  };

  /**
   * Get the custom point resolution function for this projection (if set).
   * @return {function(number, import("../coordinate.js").Coordinate):number|undefined} The custom point
   * resolution function (if set).
   */
  Projection.prototype.getPointResolutionFunc = function getPointResolutionFunc () {
    return this.getPointResolutionFunc_;
  };

  /**
   * @module ol/proj/epsg3857
   */


  /**
   * Radius of WGS84 sphere
   *
   * @const
   * @type {number}
   */
  var RADIUS = 6378137;


  /**
   * @const
   * @type {number}
   */
  var HALF_SIZE = Math.PI * RADIUS;


  /**
   * @const
   * @type {import("../extent.js").Extent}
   */
  var EXTENT = [
    -HALF_SIZE, -HALF_SIZE,
    HALF_SIZE, HALF_SIZE
  ];


  /**
   * @const
   * @type {import("../extent.js").Extent}
   */
  var WORLD_EXTENT = [-180, -85, 180, 85];


  /**
   * @classdesc
   * Projection object for web/spherical Mercator (EPSG:3857).
   */
  var EPSG3857Projection = /*@__PURE__*/(function (Projection$$1) {
    function EPSG3857Projection(code) {
      Projection$$1.call(this, {
        code: code,
        units: Units.METERS,
        extent: EXTENT,
        global: true,
        worldExtent: WORLD_EXTENT,
        getPointResolution: function(resolution, point) {
          return resolution / cosh(point[1] / RADIUS);
        }
      });

    }

    if ( Projection$$1 ) EPSG3857Projection.__proto__ = Projection$$1;
    EPSG3857Projection.prototype = Object.create( Projection$$1 && Projection$$1.prototype );
    EPSG3857Projection.prototype.constructor = EPSG3857Projection;

    return EPSG3857Projection;
  }(Projection));


  /**
   * Projections equal to EPSG:3857.
   *
   * @const
   * @type {Array<import("./Projection.js").default>}
   */
  var PROJECTIONS = [
    new EPSG3857Projection('EPSG:3857'),
    new EPSG3857Projection('EPSG:102100'),
    new EPSG3857Projection('EPSG:102113'),
    new EPSG3857Projection('EPSG:900913'),
    new EPSG3857Projection('urn:ogc:def:crs:EPSG:6.18:3:3857'),
    new EPSG3857Projection('urn:ogc:def:crs:EPSG::3857'),
    new EPSG3857Projection('http://www.opengis.net/gml/srs/epsg.xml#3857')
  ];


  /**
   * Transformation from EPSG:4326 to EPSG:3857.
   *
   * @param {Array<number>} input Input array of coordinate values.
   * @param {Array<number>=} opt_output Output array of coordinate values.
   * @param {number=} opt_dimension Dimension (default is `2`).
   * @return {Array<number>} Output array of coordinate values.
   */
  function fromEPSG4326(input, opt_output, opt_dimension) {
    var length = input.length;
    var dimension = opt_dimension > 1 ? opt_dimension : 2;
    var output = opt_output;
    if (output === undefined) {
      if (dimension > 2) {
        // preserve values beyond second dimension
        output = input.slice();
      } else {
        output = new Array(length);
      }
    }
    var halfSize = HALF_SIZE;
    for (var i = 0; i < length; i += dimension) {
      output[i] = halfSize * input[i] / 180;
      var y = RADIUS *
          Math.log(Math.tan(Math.PI * (input[i + 1] + 90) / 360));
      if (y > halfSize) {
        y = halfSize;
      } else if (y < -halfSize) {
        y = -halfSize;
      }
      output[i + 1] = y;
    }
    return output;
  }


  /**
   * Transformation from EPSG:3857 to EPSG:4326.
   *
   * @param {Array<number>} input Input array of coordinate values.
   * @param {Array<number>=} opt_output Output array of coordinate values.
   * @param {number=} opt_dimension Dimension (default is `2`).
   * @return {Array<number>} Output array of coordinate values.
   */
  function toEPSG4326(input, opt_output, opt_dimension) {
    var length = input.length;
    var dimension = opt_dimension > 1 ? opt_dimension : 2;
    var output = opt_output;
    if (output === undefined) {
      if (dimension > 2) {
        // preserve values beyond second dimension
        output = input.slice();
      } else {
        output = new Array(length);
      }
    }
    for (var i = 0; i < length; i += dimension) {
      output[i] = 180 * input[i] / HALF_SIZE;
      output[i + 1] = 360 * Math.atan(
        Math.exp(input[i + 1] / RADIUS)) / Math.PI - 90;
    }
    return output;
  }

  /**
   * @module ol/proj/epsg4326
   */


  /**
   * Semi-major radius of the WGS84 ellipsoid.
   *
   * @const
   * @type {number}
   */
  var RADIUS$1 = 6378137;


  /**
   * Extent of the EPSG:4326 projection which is the whole world.
   *
   * @const
   * @type {import("../extent.js").Extent}
   */
  var EXTENT$1 = [-180, -90, 180, 90];


  /**
   * @const
   * @type {number}
   */
  var METERS_PER_UNIT$1 = Math.PI * RADIUS$1 / 180;


  /**
   * @classdesc
   * Projection object for WGS84 geographic coordinates (EPSG:4326).
   *
   * Note that OpenLayers does not strictly comply with the EPSG definition.
   * The EPSG registry defines 4326 as a CRS for Latitude,Longitude (y,x).
   * OpenLayers treats EPSG:4326 as a pseudo-projection, with x,y coordinates.
   */
  var EPSG4326Projection = /*@__PURE__*/(function (Projection$$1) {
    function EPSG4326Projection(code, opt_axisOrientation) {
      Projection$$1.call(this, {
        code: code,
        units: Units.DEGREES,
        extent: EXTENT$1,
        axisOrientation: opt_axisOrientation,
        global: true,
        metersPerUnit: METERS_PER_UNIT$1,
        worldExtent: EXTENT$1
      });

    }

    if ( Projection$$1 ) EPSG4326Projection.__proto__ = Projection$$1;
    EPSG4326Projection.prototype = Object.create( Projection$$1 && Projection$$1.prototype );
    EPSG4326Projection.prototype.constructor = EPSG4326Projection;

    return EPSG4326Projection;
  }(Projection));


  /**
   * Projections equal to EPSG:4326.
   *
   * @const
   * @type {Array<import("./Projection.js").default>}
   */
  var PROJECTIONS$1 = [
    new EPSG4326Projection('CRS:84'),
    new EPSG4326Projection('EPSG:4326', 'neu'),
    new EPSG4326Projection('urn:ogc:def:crs:EPSG::4326', 'neu'),
    new EPSG4326Projection('urn:ogc:def:crs:EPSG:6.6:4326', 'neu'),
    new EPSG4326Projection('urn:ogc:def:crs:OGC:1.3:CRS84'),
    new EPSG4326Projection('urn:ogc:def:crs:OGC:2:84'),
    new EPSG4326Projection('http://www.opengis.net/gml/srs/epsg.xml#4326', 'neu'),
    new EPSG4326Projection('urn:x-ogc:def:crs:EPSG:4326', 'neu')
  ];

  /**
   * @module ol/proj/projections
   */


  /**
   * @type {Object<string, import("./Projection.js").default>}
   */
  var cache = {};


  /**
   * Get a cached projection by code.
   * @param {string} code The code for the projection.
   * @return {import("./Projection.js").default} The projection (if cached).
   */
  function get(code) {
    return cache[code] || null;
  }


  /**
   * Add a projection to the cache.
   * @param {string} code The projection code.
   * @param {import("./Projection.js").default} projection The projection to cache.
   */
  function add$1(code, projection) {
    cache[code] = projection;
  }

  /**
   * @module ol/proj/transforms
   */


  /**
   * @private
   * @type {!Object<string, Object<string, import("../proj.js").TransformFunction>>}
   */
  var transforms = {};


  /**
   * Registers a conversion function to convert coordinates from the source
   * projection to the destination projection.
   *
   * @param {import("./Projection.js").default} source Source.
   * @param {import("./Projection.js").default} destination Destination.
   * @param {import("../proj.js").TransformFunction} transformFn Transform.
   */
  function add$2(source, destination, transformFn) {
    var sourceCode = source.getCode();
    var destinationCode = destination.getCode();
    if (!(sourceCode in transforms)) {
      transforms[sourceCode] = {};
    }
    transforms[sourceCode][destinationCode] = transformFn;
  }


  /**
   * Get a transform given a source code and a destination code.
   * @param {string} sourceCode The code for the source projection.
   * @param {string} destinationCode The code for the destination projection.
   * @return {import("../proj.js").TransformFunction|undefined} The transform function (if found).
   */
  function get$1(sourceCode, destinationCode) {
    var transform;
    if (sourceCode in transforms && destinationCode in transforms[sourceCode]) {
      transform = transforms[sourceCode][destinationCode];
    }
    return transform;
  }

  /**
   * @module ol/proj
   */

  /**
   * @param {Array<number>} input Input coordinate array.
   * @param {Array<number>=} opt_output Output array of coordinate values.
   * @param {number=} opt_dimension Dimension.
   * @return {Array<number>} Output coordinate array (new array, same coordinate
   *     values).
   */
  function cloneTransform(input, opt_output, opt_dimension) {
    var output;
    if (opt_output !== undefined) {
      for (var i = 0, ii = input.length; i < ii; ++i) {
        opt_output[i] = input[i];
      }
      output = opt_output;
    } else {
      output = input.slice();
    }
    return output;
  }


  /**
   * @param {Array<number>} input Input coordinate array.
   * @param {Array<number>=} opt_output Output array of coordinate values.
   * @param {number=} opt_dimension Dimension.
   * @return {Array<number>} Input coordinate array (same array as input).
   */
  function identityTransform(input, opt_output, opt_dimension) {
    if (opt_output !== undefined && input !== opt_output) {
      for (var i = 0, ii = input.length; i < ii; ++i) {
        opt_output[i] = input[i];
      }
      input = opt_output;
    }
    return input;
  }


  /**
   * Add a Projection object to the list of supported projections that can be
   * looked up by their code.
   *
   * @param {Projection} projection Projection instance.
   * @api
   */
  function addProjection(projection) {
    add$1(projection.getCode(), projection);
    add$2(projection, projection, cloneTransform);
  }


  /**
   * @param {Array<Projection>} projections Projections.
   */
  function addProjections(projections) {
    projections.forEach(addProjection);
  }


  /**
   * Fetches a Projection object for the code specified.
   *
   * @param {ProjectionLike} projectionLike Either a code string which is
   *     a combination of authority and identifier such as "EPSG:4326", or an
   *     existing projection object, or undefined.
   * @return {Projection} Projection object, or null if not in list.
   * @api
   */
  function get$2(projectionLike) {
    return typeof projectionLike === 'string' ?
      get(/** @type {string} */ (projectionLike)) :
      (/** @type {Projection} */ (projectionLike) || null);
  }


  /**
   * Get the resolution of the point in degrees or distance units.
   * For projections with degrees as the unit this will simply return the
   * provided resolution. For other projections the point resolution is
   * by default estimated by transforming the 'point' pixel to EPSG:4326,
   * measuring its width and height on the normal sphere,
   * and taking the average of the width and height.
   * A custom function can be provided for a specific projection, either
   * by setting the `getPointResolution` option in the
   * {@link module:ol/proj/Projection~Projection} constructor or by using
   * {@link module:ol/proj/Projection~Projection#setGetPointResolution} to change an existing
   * projection object.
   * @param {ProjectionLike} projection The projection.
   * @param {number} resolution Nominal resolution in projection units.
   * @param {import("./coordinate.js").Coordinate} point Point to find adjusted resolution at.
   * @param {Units=} opt_units Units to get the point resolution in.
   * Default is the projection's units.
   * @return {number} Point resolution.
   * @api
   */
  function getPointResolution(projection, resolution, point, opt_units) {
    projection = get$2(projection);
    var pointResolution;
    var getter = projection.getPointResolutionFunc();
    if (getter) {
      pointResolution = getter(resolution, point);
    } else {
      var units = projection.getUnits();
      if (units == Units.DEGREES && !opt_units || opt_units == Units.DEGREES) {
        pointResolution = resolution;
      } else {
        // Estimate point resolution by transforming the center pixel to EPSG:4326,
        // measuring its width and height on the normal sphere, and taking the
        // average of the width and height.
        var toEPSG4326$$1 = getTransformFromProjections(projection, get$2('EPSG:4326'));
        var vertices = [
          point[0] - resolution / 2, point[1],
          point[0] + resolution / 2, point[1],
          point[0], point[1] - resolution / 2,
          point[0], point[1] + resolution / 2
        ];
        vertices = toEPSG4326$$1(vertices, vertices, 2);
        var width = getDistance(vertices.slice(0, 2), vertices.slice(2, 4));
        var height = getDistance(vertices.slice(4, 6), vertices.slice(6, 8));
        pointResolution = (width + height) / 2;
        var metersPerUnit = opt_units ?
          METERS_PER_UNIT[opt_units] :
          projection.getMetersPerUnit();
        if (metersPerUnit !== undefined) {
          pointResolution /= metersPerUnit;
        }
      }
    }
    return pointResolution;
  }


  /**
   * Registers transformation functions that don't alter coordinates. Those allow
   * to transform between projections with equal meaning.
   *
   * @param {Array<Projection>} projections Projections.
   * @api
   */
  function addEquivalentProjections(projections) {
    addProjections(projections);
    projections.forEach(function(source) {
      projections.forEach(function(destination) {
        if (source !== destination) {
          add$2(source, destination, cloneTransform);
        }
      });
    });
  }


  /**
   * Registers transformation functions to convert coordinates in any projection
   * in projection1 to any projection in projection2.
   *
   * @param {Array<Projection>} projections1 Projections with equal
   *     meaning.
   * @param {Array<Projection>} projections2 Projections with equal
   *     meaning.
   * @param {TransformFunction} forwardTransform Transformation from any
   *   projection in projection1 to any projection in projection2.
   * @param {TransformFunction} inverseTransform Transform from any projection
   *   in projection2 to any projection in projection1..
   */
  function addEquivalentTransforms(projections1, projections2, forwardTransform, inverseTransform) {
    projections1.forEach(function(projection1) {
      projections2.forEach(function(projection2) {
        add$2(projection1, projection2, forwardTransform);
        add$2(projection2, projection1, inverseTransform);
      });
    });
  }


  /**
   * @param {Projection|string|undefined} projection Projection.
   * @param {string} defaultCode Default code.
   * @return {Projection} Projection.
   */
  function createProjection(projection, defaultCode) {
    if (!projection) {
      return get$2(defaultCode);
    } else if (typeof projection === 'string') {
      return get$2(projection);
    } else {
      return (
        /** @type {Projection} */ (projection)
      );
    }
  }


  /**
   * Checks if two projections are the same, that is every coordinate in one
   * projection does represent the same geographic point as the same coordinate in
   * the other projection.
   *
   * @param {Projection} projection1 Projection 1.
   * @param {Projection} projection2 Projection 2.
   * @return {boolean} Equivalent.
   * @api
   */
  function equivalent(projection1, projection2) {
    if (projection1 === projection2) {
      return true;
    }
    var equalUnits = projection1.getUnits() === projection2.getUnits();
    if (projection1.getCode() === projection2.getCode()) {
      return equalUnits;
    } else {
      var transformFunc = getTransformFromProjections(projection1, projection2);
      return transformFunc === cloneTransform && equalUnits;
    }
  }


  /**
   * Searches in the list of transform functions for the function for converting
   * coordinates from the source projection to the destination projection.
   *
   * @param {Projection} sourceProjection Source Projection object.
   * @param {Projection} destinationProjection Destination Projection
   *     object.
   * @return {TransformFunction} Transform function.
   */
  function getTransformFromProjections(sourceProjection, destinationProjection) {
    var sourceCode = sourceProjection.getCode();
    var destinationCode = destinationProjection.getCode();
    var transformFunc = get$1(sourceCode, destinationCode);
    if (!transformFunc) {
      transformFunc = identityTransform;
    }
    return transformFunc;
  }


  /**
   * Given the projection-like objects, searches for a transformation
   * function to convert a coordinates array from the source projection to the
   * destination projection.
   *
   * @param {ProjectionLike} source Source.
   * @param {ProjectionLike} destination Destination.
   * @return {TransformFunction} Transform function.
   * @api
   */
  function getTransform(source, destination) {
    var sourceProjection = get$2(source);
    var destinationProjection = get$2(destination);
    return getTransformFromProjections(sourceProjection, destinationProjection);
  }


  /**
   * Transforms a coordinate from source projection to destination projection.
   * This returns a new coordinate (and does not modify the original).
   *
   * See {@link module:ol/proj~transformExtent} for extent transformation.
   * See the transform method of {@link module:ol/geom/Geometry~Geometry} and its
   * subclasses for geometry transforms.
   *
   * @param {import("./coordinate.js").Coordinate} coordinate Coordinate.
   * @param {ProjectionLike} source Source projection-like.
   * @param {ProjectionLike} destination Destination projection-like.
   * @return {import("./coordinate.js").Coordinate} Coordinate.
   * @api
   */
  function transform(coordinate, source, destination) {
    var transformFunc = getTransform(source, destination);
    return transformFunc(coordinate, undefined, coordinate.length);
  }

  /**
   * Add transforms to and from EPSG:4326 and EPSG:3857.  This function is called
   * by when this module is executed and should only need to be called again after
   * `clearAllProjections()` is called (e.g. in tests).
   */
  function addCommon() {
    // Add transformations that don't alter coordinates to convert within set of
    // projections with equal meaning.
    addEquivalentProjections(PROJECTIONS);
    addEquivalentProjections(PROJECTIONS$1);
    // Add transformations to convert EPSG:4326 like coordinates to EPSG:3857 like
    // coordinates and back.
    addEquivalentTransforms(PROJECTIONS$1, PROJECTIONS, fromEPSG4326, toEPSG4326);
  }

  addCommon();

  /**
   * @module ol/transform
   */


  /**
   * An array representing an affine 2d transformation for use with
   * {@link module:ol/transform} functions. The array has 6 elements.
   * @typedef {!Array<number>} Transform
   */


  /**
   * Collection of affine 2d transformation functions. The functions work on an
   * array of 6 elements. The element order is compatible with the [SVGMatrix
   * interface](https://developer.mozilla.org/en-US/docs/Web/API/SVGMatrix) and is
   * a subset (elements a to f) of a 3×3 matrix:
   * ```
   * [ a c e ]
   * [ b d f ]
   * [ 0 0 1 ]
   * ```
   */


  /**
   * @private
   * @type {Transform}
   */
  var tmp_ = new Array(6);


  /**
   * Create an identity transform.
   * @return {!Transform} Identity transform.
   */
  function create() {
    return [1, 0, 0, 1, 0, 0];
  }


  /**
   * Resets the given transform to an identity transform.
   * @param {!Transform} transform Transform.
   * @return {!Transform} Transform.
   */
  function reset(transform) {
    return set(transform, 1, 0, 0, 1, 0, 0);
  }


  /**
   * Multiply the underlying matrices of two transforms and return the result in
   * the first transform.
   * @param {!Transform} transform1 Transform parameters of matrix 1.
   * @param {!Transform} transform2 Transform parameters of matrix 2.
   * @return {!Transform} transform1 multiplied with transform2.
   */
  function multiply(transform1, transform2) {
    var a1 = transform1[0];
    var b1 = transform1[1];
    var c1 = transform1[2];
    var d1 = transform1[3];
    var e1 = transform1[4];
    var f1 = transform1[5];
    var a2 = transform2[0];
    var b2 = transform2[1];
    var c2 = transform2[2];
    var d2 = transform2[3];
    var e2 = transform2[4];
    var f2 = transform2[5];

    transform1[0] = a1 * a2 + c1 * b2;
    transform1[1] = b1 * a2 + d1 * b2;
    transform1[2] = a1 * c2 + c1 * d2;
    transform1[3] = b1 * c2 + d1 * d2;
    transform1[4] = a1 * e2 + c1 * f2 + e1;
    transform1[5] = b1 * e2 + d1 * f2 + f1;

    return transform1;
  }

  /**
   * Set the transform components a-f on a given transform.
   * @param {!Transform} transform Transform.
   * @param {number} a The a component of the transform.
   * @param {number} b The b component of the transform.
   * @param {number} c The c component of the transform.
   * @param {number} d The d component of the transform.
   * @param {number} e The e component of the transform.
   * @param {number} f The f component of the transform.
   * @return {!Transform} Matrix with transform applied.
   */
  function set(transform, a, b, c, d, e, f) {
    transform[0] = a;
    transform[1] = b;
    transform[2] = c;
    transform[3] = d;
    transform[4] = e;
    transform[5] = f;
    return transform;
  }


  /**
   * Set transform on one matrix from another matrix.
   * @param {!Transform} transform1 Matrix to set transform to.
   * @param {!Transform} transform2 Matrix to set transform from.
   * @return {!Transform} transform1 with transform from transform2 applied.
   */
  function setFromArray(transform1, transform2) {
    transform1[0] = transform2[0];
    transform1[1] = transform2[1];
    transform1[2] = transform2[2];
    transform1[3] = transform2[3];
    transform1[4] = transform2[4];
    transform1[5] = transform2[5];
    return transform1;
  }


  /**
   * Transforms the given coordinate with the given transform returning the
   * resulting, transformed coordinate. The coordinate will be modified in-place.
   *
   * @param {Transform} transform The transformation.
   * @param {import("./coordinate.js").Coordinate|import("./pixel.js").Pixel} coordinate The coordinate to transform.
   * @return {import("./coordinate.js").Coordinate|import("./pixel.js").Pixel} return coordinate so that operations can be
   *     chained together.
   */
  function apply(transform, coordinate) {
    var x = coordinate[0];
    var y = coordinate[1];
    coordinate[0] = transform[0] * x + transform[2] * y + transform[4];
    coordinate[1] = transform[1] * x + transform[3] * y + transform[5];
    return coordinate;
  }


  /**
   * Applies rotation to the given transform.
   * @param {!Transform} transform Transform.
   * @param {number} angle Angle in radians.
   * @return {!Transform} The rotated transform.
   */
  function rotate$2(transform, angle) {
    var cos = Math.cos(angle);
    var sin = Math.sin(angle);
    return multiply(transform, set(tmp_, cos, sin, -sin, cos, 0, 0));
  }


  /**
   * Applies scale to a given transform.
   * @param {!Transform} transform Transform.
   * @param {number} x Scale factor x.
   * @param {number} y Scale factor y.
   * @return {!Transform} The scaled transform.
   */
  function scale$2(transform, x, y) {
    return multiply(transform, set(tmp_, x, 0, 0, y, 0, 0));
  }


  /**
   * Applies translation to the given transform.
   * @param {!Transform} transform Transform.
   * @param {number} dx Translation x.
   * @param {number} dy Translation y.
   * @return {!Transform} The translated transform.
   */
  function translate$1(transform, dx, dy) {
    return multiply(transform, set(tmp_, 1, 0, 0, 1, dx, dy));
  }


  /**
   * Creates a composite transform given an initial translation, scale, rotation, and
   * final translation (in that order only, not commutative).
   * @param {!Transform} transform The transform (will be modified in place).
   * @param {number} dx1 Initial translation x.
   * @param {number} dy1 Initial translation y.
   * @param {number} sx Scale factor x.
   * @param {number} sy Scale factor y.
   * @param {number} angle Rotation (in counter-clockwise radians).
   * @param {number} dx2 Final translation x.
   * @param {number} dy2 Final translation y.
   * @return {!Transform} The composite transform.
   */
  function compose(transform, dx1, dy1, sx, sy, angle, dx2, dy2) {
    var sin = Math.sin(angle);
    var cos = Math.cos(angle);
    transform[0] = sx * cos;
    transform[1] = sy * sin;
    transform[2] = -sx * sin;
    transform[3] = sy * cos;
    transform[4] = dx2 * sx * cos - dy2 * sx * sin + dx1;
    transform[5] = dx2 * sy * sin + dy2 * sy * cos + dy1;
    return transform;
  }


  /**
   * Invert the given transform.
   * @param {!Transform} transform Transform.
   * @return {!Transform} Inverse of the transform.
   */
  function invert(transform) {
    var det = determinant(transform);
    assert(det !== 0, 32); // Transformation matrix cannot be inverted

    var a = transform[0];
    var b = transform[1];
    var c = transform[2];
    var d = transform[3];
    var e = transform[4];
    var f = transform[5];

    transform[0] = d / det;
    transform[1] = -b / det;
    transform[2] = -c / det;
    transform[3] = a / det;
    transform[4] = (c * f - d * e) / det;
    transform[5] = -(a * f - b * e) / det;

    return transform;
  }


  /**
   * Returns the determinant of the given matrix.
   * @param {!Transform} mat Matrix.
   * @return {number} Determinant.
   */
  function determinant(mat) {
    return mat[0] * mat[3] - mat[1] * mat[2];
  }

  /**
   * @module ol/geom/Geometry
   */


  /**
   * @type {import("../transform.js").Transform}
   */
  var tmpTransform = create();


  /**
   * @classdesc
   * Abstract base class; normally only used for creating subclasses and not
   * instantiated in apps.
   * Base class for vector geometries.
   *
   * To get notified of changes to the geometry, register a listener for the
   * generic `change` event on your geometry instance.
   *
   * @abstract
   * @api
   */
  var Geometry = /*@__PURE__*/(function (BaseObject$$1) {
    function Geometry() {

      BaseObject$$1.call(this);

      /**
       * @private
       * @type {import("../extent.js").Extent}
       */
      this.extent_ = createEmpty();

      /**
       * @private
       * @type {number}
       */
      this.extentRevision_ = -1;

      /**
       * @protected
       * @type {Object<string, Geometry>}
       */
      this.simplifiedGeometryCache = {};

      /**
       * @protected
       * @type {number}
       */
      this.simplifiedGeometryMaxMinSquaredTolerance = 0;

      /**
       * @protected
       * @type {number}
       */
      this.simplifiedGeometryRevision = 0;

    }

    if ( BaseObject$$1 ) Geometry.__proto__ = BaseObject$$1;
    Geometry.prototype = Object.create( BaseObject$$1 && BaseObject$$1.prototype );
    Geometry.prototype.constructor = Geometry;

    /**
     * Make a complete copy of the geometry.
     * @abstract
     * @return {!Geometry} Clone.
     */
    Geometry.prototype.clone = function clone$$1 () {
      return abstract();
    };

    /**
     * @abstract
     * @param {number} x X.
     * @param {number} y Y.
     * @param {import("../coordinate.js").Coordinate} closestPoint Closest point.
     * @param {number} minSquaredDistance Minimum squared distance.
     * @return {number} Minimum squared distance.
     */
    Geometry.prototype.closestPointXY = function closestPointXY (x, y, closestPoint, minSquaredDistance) {
      return abstract();
    };

    /**
     * @param {number} x X.
     * @param {number} y Y.
     * @return {boolean} Contains (x, y).
     */
    Geometry.prototype.containsXY = function containsXY$$1 (x, y) {
      return false;
    };

    /**
     * Return the closest point of the geometry to the passed point as
     * {@link module:ol/coordinate~Coordinate coordinate}.
     * @param {import("../coordinate.js").Coordinate} point Point.
     * @param {import("../coordinate.js").Coordinate=} opt_closestPoint Closest point.
     * @return {import("../coordinate.js").Coordinate} Closest point.
     * @api
     */
    Geometry.prototype.getClosestPoint = function getClosestPoint (point, opt_closestPoint) {
      var closestPoint = opt_closestPoint ? opt_closestPoint : [NaN, NaN];
      this.closestPointXY(point[0], point[1], closestPoint, Infinity);
      return closestPoint;
    };

    /**
     * Returns true if this geometry includes the specified coordinate. If the
     * coordinate is on the boundary of the geometry, returns false.
     * @param {import("../coordinate.js").Coordinate} coordinate Coordinate.
     * @return {boolean} Contains coordinate.
     * @api
     */
    Geometry.prototype.intersectsCoordinate = function intersectsCoordinate (coordinate) {
      return this.containsXY(coordinate[0], coordinate[1]);
    };

    /**
     * @abstract
     * @param {import("../extent.js").Extent} extent Extent.
     * @protected
     * @return {import("../extent.js").Extent} extent Extent.
     */
    Geometry.prototype.computeExtent = function computeExtent (extent) {
      return abstract();
    };

    /**
     * Get the extent of the geometry.
     * @param {import("../extent.js").Extent=} opt_extent Extent.
     * @return {import("../extent.js").Extent} extent Extent.
     * @api
     */
    Geometry.prototype.getExtent = function getExtent (opt_extent) {
      if (this.extentRevision_ != this.getRevision()) {
        this.extent_ = this.computeExtent(this.extent_);
        this.extentRevision_ = this.getRevision();
      }
      return returnOrUpdate(this.extent_, opt_extent);
    };

    /**
     * Rotate the geometry around a given coordinate. This modifies the geometry
     * coordinates in place.
     * @abstract
     * @param {number} angle Rotation angle in radians.
     * @param {import("../coordinate.js").Coordinate} anchor The rotation center.
     * @api
     */
    Geometry.prototype.rotate = function rotate (angle, anchor) {
      abstract();
    };

    /**
     * Scale the geometry (with an optional origin).  This modifies the geometry
     * coordinates in place.
     * @abstract
     * @param {number} sx The scaling factor in the x-direction.
     * @param {number=} opt_sy The scaling factor in the y-direction (defaults to
     *     sx).
     * @param {import("../coordinate.js").Coordinate=} opt_anchor The scale origin (defaults to the center
     *     of the geometry extent).
     * @api
     */
    Geometry.prototype.scale = function scale (sx, opt_sy, opt_anchor) {
      abstract();
    };

    /**
     * Create a simplified version of this geometry.  For linestrings, this uses
     * the the {@link
     * https://en.wikipedia.org/wiki/Ramer-Douglas-Peucker_algorithm
     * Douglas Peucker} algorithm.  For polygons, a quantization-based
     * simplification is used to preserve topology.
     * @param {number} tolerance The tolerance distance for simplification.
     * @return {Geometry} A new, simplified version of the original geometry.
     * @api
     */
    Geometry.prototype.simplify = function simplify (tolerance) {
      return this.getSimplifiedGeometry(tolerance * tolerance);
    };

    /**
     * Create a simplified version of this geometry using the Douglas Peucker
     * algorithm.
     * See https://en.wikipedia.org/wiki/Ramer-Douglas-Peucker_algorithm.
     * @abstract
     * @param {number} squaredTolerance Squared tolerance.
     * @return {Geometry} Simplified geometry.
     */
    Geometry.prototype.getSimplifiedGeometry = function getSimplifiedGeometry (squaredTolerance) {
      return abstract();
    };

    /**
     * Get the type of this geometry.
     * @abstract
     * @return {import("./GeometryType.js").default} Geometry type.
     */
    Geometry.prototype.getType = function getType () {
      return abstract();
    };

    /**
     * Apply a transform function to each coordinate of the geometry.
     * The geometry is modified in place.
     * If you do not want the geometry modified in place, first `clone()` it and
     * then use this function on the clone.
     * @abstract
     * @param {import("../proj.js").TransformFunction} transformFn Transform.
     */
    Geometry.prototype.applyTransform = function applyTransform$$1 (transformFn) {
      abstract();
    };

    /**
     * Test if the geometry and the passed extent intersect.
     * @abstract
     * @param {import("../extent.js").Extent} extent Extent.
     * @return {boolean} `true` if the geometry and the extent intersect.
     */
    Geometry.prototype.intersectsExtent = function intersectsExtent (extent) {
      return abstract();
    };

    /**
     * Translate the geometry.  This modifies the geometry coordinates in place.  If
     * instead you want a new geometry, first `clone()` this geometry.
     * @abstract
     * @param {number} deltaX Delta X.
     * @param {number} deltaY Delta Y.
     * @api
     */
    Geometry.prototype.translate = function translate$$1 (deltaX, deltaY) {
      abstract();
    };

    /**
     * Transform each coordinate of the geometry from one coordinate reference
     * system to another. The geometry is modified in place.
     * For example, a line will be transformed to a line and a circle to a circle.
     * If you do not want the geometry modified in place, first `clone()` it and
     * then use this function on the clone.
     *
     * @param {import("../proj.js").ProjectionLike} source The current projection.  Can be a
     *     string identifier or a {@link module:ol/proj/Projection~Projection} object.
     * @param {import("../proj.js").ProjectionLike} destination The desired projection.  Can be a
     *     string identifier or a {@link module:ol/proj/Projection~Projection} object.
     * @return {Geometry} This geometry.  Note that original geometry is
     *     modified in place.
     * @api
     */
    Geometry.prototype.transform = function transform$$1 (source, destination) {
      /** @type {import("../proj/Projection.js").default} */
      var sourceProj = get$2(source);
      var transformFn = sourceProj.getUnits() == Units.TILE_PIXELS ?
        function(inCoordinates, outCoordinates, stride) {
          var pixelExtent = sourceProj.getExtent();
          var projectedExtent = sourceProj.getWorldExtent();
          var scale = getHeight(projectedExtent) / getHeight(pixelExtent);
          compose(tmpTransform,
            projectedExtent[0], projectedExtent[3],
            scale, -scale, 0,
            0, 0);
          transform2D(inCoordinates, 0, inCoordinates.length, stride,
            tmpTransform, outCoordinates);
          return getTransform(sourceProj, destination)(inCoordinates, outCoordinates, stride);
        } :
        getTransform(sourceProj, destination);
      this.applyTransform(transformFn);
      return this;
    };

    return Geometry;
  }(BaseObject));

  /**
   * @module ol/geom/SimpleGeometry
   */

  /**
   * @classdesc
   * Abstract base class; only used for creating subclasses; do not instantiate
   * in apps, as cannot be rendered.
   *
   * @abstract
   * @api
   */
  var SimpleGeometry = /*@__PURE__*/(function (Geometry$$1) {
    function SimpleGeometry() {

      Geometry$$1.call(this);

      /**
       * @protected
       * @type {GeometryLayout}
       */
      this.layout = GeometryLayout.XY;

      /**
       * @protected
       * @type {number}
       */
      this.stride = 2;

      /**
       * @protected
       * @type {Array<number>}
       */
      this.flatCoordinates = null;

    }

    if ( Geometry$$1 ) SimpleGeometry.__proto__ = Geometry$$1;
    SimpleGeometry.prototype = Object.create( Geometry$$1 && Geometry$$1.prototype );
    SimpleGeometry.prototype.constructor = SimpleGeometry;

    /**
     * @inheritDoc
     */
    SimpleGeometry.prototype.computeExtent = function computeExtent (extent) {
      return createOrUpdateFromFlatCoordinates(this.flatCoordinates,
        0, this.flatCoordinates.length, this.stride, extent);
    };

    /**
     * @abstract
     * @return {Array} Coordinates.
     */
    SimpleGeometry.prototype.getCoordinates = function getCoordinates () {
      return abstract();
    };

    /**
     * Return the first coordinate of the geometry.
     * @return {import("../coordinate.js").Coordinate} First coordinate.
     * @api
     */
    SimpleGeometry.prototype.getFirstCoordinate = function getFirstCoordinate () {
      return this.flatCoordinates.slice(0, this.stride);
    };

    /**
     * @return {Array<number>} Flat coordinates.
     */
    SimpleGeometry.prototype.getFlatCoordinates = function getFlatCoordinates () {
      return this.flatCoordinates;
    };

    /**
     * Return the last coordinate of the geometry.
     * @return {import("../coordinate.js").Coordinate} Last point.
     * @api
     */
    SimpleGeometry.prototype.getLastCoordinate = function getLastCoordinate () {
      return this.flatCoordinates.slice(this.flatCoordinates.length - this.stride);
    };

    /**
     * Return the {@link module:ol/geom/GeometryLayout layout} of the geometry.
     * @return {GeometryLayout} Layout.
     * @api
     */
    SimpleGeometry.prototype.getLayout = function getLayout () {
      return this.layout;
    };

    /**
     * @inheritDoc
     */
    SimpleGeometry.prototype.getSimplifiedGeometry = function getSimplifiedGeometry (squaredTolerance) {
      if (this.simplifiedGeometryRevision != this.getRevision()) {
        clear(this.simplifiedGeometryCache);
        this.simplifiedGeometryMaxMinSquaredTolerance = 0;
        this.simplifiedGeometryRevision = this.getRevision();
      }
      // If squaredTolerance is negative or if we know that simplification will not
      // have any effect then just return this.
      if (squaredTolerance < 0 ||
          (this.simplifiedGeometryMaxMinSquaredTolerance !== 0 &&
           squaredTolerance <= this.simplifiedGeometryMaxMinSquaredTolerance)) {
        return this;
      }
      var key = squaredTolerance.toString();
      if (this.simplifiedGeometryCache.hasOwnProperty(key)) {
        return this.simplifiedGeometryCache[key];
      } else {
        var simplifiedGeometry =
            this.getSimplifiedGeometryInternal(squaredTolerance);
        var simplifiedFlatCoordinates = simplifiedGeometry.getFlatCoordinates();
        if (simplifiedFlatCoordinates.length < this.flatCoordinates.length) {
          this.simplifiedGeometryCache[key] = simplifiedGeometry;
          return simplifiedGeometry;
        } else {
          // Simplification did not actually remove any coordinates.  We now know
          // that any calls to getSimplifiedGeometry with a squaredTolerance less
          // than or equal to the current squaredTolerance will also not have any
          // effect.  This allows us to short circuit simplification (saving CPU
          // cycles) and prevents the cache of simplified geometries from filling
          // up with useless identical copies of this geometry (saving memory).
          this.simplifiedGeometryMaxMinSquaredTolerance = squaredTolerance;
          return this;
        }
      }
    };

    /**
     * @param {number} squaredTolerance Squared tolerance.
     * @return {SimpleGeometry} Simplified geometry.
     * @protected
     */
    SimpleGeometry.prototype.getSimplifiedGeometryInternal = function getSimplifiedGeometryInternal (squaredTolerance) {
      return this;
    };

    /**
     * @return {number} Stride.
     */
    SimpleGeometry.prototype.getStride = function getStride () {
      return this.stride;
    };

    /**
     * @param {GeometryLayout} layout Layout.
     * @param {Array<number>} flatCoordinates Flat coordinates.
     */
    SimpleGeometry.prototype.setFlatCoordinates = function setFlatCoordinates (layout, flatCoordinates) {
      this.stride = getStrideForLayout(layout);
      this.layout = layout;
      this.flatCoordinates = flatCoordinates;
    };

    /**
     * @abstract
     * @param {!Array} coordinates Coordinates.
     * @param {GeometryLayout=} opt_layout Layout.
     */
    SimpleGeometry.prototype.setCoordinates = function setCoordinates (coordinates, opt_layout) {
      abstract();
    };

    /**
     * @param {GeometryLayout|undefined} layout Layout.
     * @param {Array} coordinates Coordinates.
     * @param {number} nesting Nesting.
     * @protected
     */
    SimpleGeometry.prototype.setLayout = function setLayout (layout, coordinates, nesting) {
      /** @type {number} */
      var stride;
      if (layout) {
        stride = getStrideForLayout(layout);
      } else {
        for (var i = 0; i < nesting; ++i) {
          if (coordinates.length === 0) {
            this.layout = GeometryLayout.XY;
            this.stride = 2;
            return;
          } else {
            coordinates = /** @type {Array} */ (coordinates[0]);
          }
        }
        stride = coordinates.length;
        layout = getLayoutForStride(stride);
      }
      this.layout = layout;
      this.stride = stride;
    };

    /**
     * @inheritDoc
     * @api
     */
    SimpleGeometry.prototype.applyTransform = function applyTransform$$1 (transformFn) {
      if (this.flatCoordinates) {
        transformFn(this.flatCoordinates, this.flatCoordinates, this.stride);
        this.changed();
      }
    };

    /**
     * @inheritDoc
     * @api
     */
    SimpleGeometry.prototype.rotate = function rotate$1$$1 (angle, anchor) {
      var flatCoordinates = this.getFlatCoordinates();
      if (flatCoordinates) {
        var stride = this.getStride();
        rotate$1(
          flatCoordinates, 0, flatCoordinates.length,
          stride, angle, anchor, flatCoordinates);
        this.changed();
      }
    };

    /**
     * @inheritDoc
     * @api
     */
    SimpleGeometry.prototype.scale = function scale$1$$1 (sx, opt_sy, opt_anchor) {
      var sy = opt_sy;
      if (sy === undefined) {
        sy = sx;
      }
      var anchor = opt_anchor;
      if (!anchor) {
        anchor = getCenter(this.getExtent());
      }
      var flatCoordinates = this.getFlatCoordinates();
      if (flatCoordinates) {
        var stride = this.getStride();
        scale$1(
          flatCoordinates, 0, flatCoordinates.length,
          stride, sx, sy, anchor, flatCoordinates);
        this.changed();
      }
    };

    /**
     * @inheritDoc
     * @api
     */
    SimpleGeometry.prototype.translate = function translate$1 (deltaX, deltaY) {
      var flatCoordinates = this.getFlatCoordinates();
      if (flatCoordinates) {
        var stride = this.getStride();
        translate(
          flatCoordinates, 0, flatCoordinates.length, stride,
          deltaX, deltaY, flatCoordinates);
        this.changed();
      }
    };

    return SimpleGeometry;
  }(Geometry));


  /**
   * @param {number} stride Stride.
   * @return {GeometryLayout} layout Layout.
   */
  function getLayoutForStride(stride) {
    var layout;
    if (stride == 2) {
      layout = GeometryLayout.XY;
    } else if (stride == 3) {
      layout = GeometryLayout.XYZ;
    } else if (stride == 4) {
      layout = GeometryLayout.XYZM;
    }
    return (
      /** @type {GeometryLayout} */ (layout)
    );
  }


  /**
   * @param {GeometryLayout} layout Layout.
   * @return {number} Stride.
   */
  function getStrideForLayout(layout) {
    var stride;
    if (layout == GeometryLayout.XY) {
      stride = 2;
    } else if (layout == GeometryLayout.XYZ || layout == GeometryLayout.XYM) {
      stride = 3;
    } else if (layout == GeometryLayout.XYZM) {
      stride = 4;
    }
    return /** @type {number} */ (stride);
  }


  /**
   * @param {SimpleGeometry} simpleGeometry Simple geometry.
   * @param {import("../transform.js").Transform} transform Transform.
   * @param {Array<number>=} opt_dest Destination.
   * @return {Array<number>} Transformed flat coordinates.
   */
  function transformGeom2D(simpleGeometry, transform, opt_dest) {
    var flatCoordinates = simpleGeometry.getFlatCoordinates();
    if (!flatCoordinates) {
      return null;
    } else {
      var stride = simpleGeometry.getStride();
      return transform2D(
        flatCoordinates, 0, flatCoordinates.length, stride,
        transform, opt_dest);
    }
  }

  /**
   * @module ol/geom/flat/area
   */


  /**
   * @param {Array<number>} flatCoordinates Flat coordinates.
   * @param {number} offset Offset.
   * @param {number} end End.
   * @param {number} stride Stride.
   * @return {number} Area.
   */
  function linearRing(flatCoordinates, offset, end, stride) {
    var twiceArea = 0;
    var x1 = flatCoordinates[end - stride];
    var y1 = flatCoordinates[end - stride + 1];
    for (; offset < end; offset += stride) {
      var x2 = flatCoordinates[offset];
      var y2 = flatCoordinates[offset + 1];
      twiceArea += y1 * x2 - x1 * y2;
      x1 = x2;
      y1 = y2;
    }
    return twiceArea / 2;
  }


  /**
   * @param {Array<number>} flatCoordinates Flat coordinates.
   * @param {number} offset Offset.
   * @param {Array<number>} ends Ends.
   * @param {number} stride Stride.
   * @return {number} Area.
   */
  function linearRings(flatCoordinates, offset, ends, stride) {
    var area = 0;
    for (var i = 0, ii = ends.length; i < ii; ++i) {
      var end = ends[i];
      area += linearRing(flatCoordinates, offset, end, stride);
      offset = end;
    }
    return area;
  }


  /**
   * @param {Array<number>} flatCoordinates Flat coordinates.
   * @param {number} offset Offset.
   * @param {Array<Array<number>>} endss Endss.
   * @param {number} stride Stride.
   * @return {number} Area.
   */
  function linearRingss(flatCoordinates, offset, endss, stride) {
    var area = 0;
    for (var i = 0, ii = endss.length; i < ii; ++i) {
      var ends = endss[i];
      area += linearRings(flatCoordinates, offset, ends, stride);
      offset = ends[ends.length - 1];
    }
    return area;
  }

  /**
   * @module ol/geom/flat/closest
   */


  /**
   * Returns the point on the 2D line segment flatCoordinates[offset1] to
   * flatCoordinates[offset2] that is closest to the point (x, y).  Extra
   * dimensions are linearly interpolated.
   * @param {Array<number>} flatCoordinates Flat coordinates.
   * @param {number} offset1 Offset 1.
   * @param {number} offset2 Offset 2.
   * @param {number} stride Stride.
   * @param {number} x X.
   * @param {number} y Y.
   * @param {Array<number>} closestPoint Closest point.
   */
  function assignClosest(flatCoordinates, offset1, offset2, stride, x, y, closestPoint) {
    var x1 = flatCoordinates[offset1];
    var y1 = flatCoordinates[offset1 + 1];
    var dx = flatCoordinates[offset2] - x1;
    var dy = flatCoordinates[offset2 + 1] - y1;
    var offset;
    if (dx === 0 && dy === 0) {
      offset = offset1;
    } else {
      var t = ((x - x1) * dx + (y - y1) * dy) / (dx * dx + dy * dy);
      if (t > 1) {
        offset = offset2;
      } else if (t > 0) {
        for (var i = 0; i < stride; ++i) {
          closestPoint[i] = lerp(flatCoordinates[offset1 + i],
            flatCoordinates[offset2 + i], t);
        }
        closestPoint.length = stride;
        return;
      } else {
        offset = offset1;
      }
    }
    for (var i$1 = 0; i$1 < stride; ++i$1) {
      closestPoint[i$1] = flatCoordinates[offset + i$1];
    }
    closestPoint.length = stride;
  }


  /**
   * Return the squared of the largest distance between any pair of consecutive
   * coordinates.
   * @param {Array<number>} flatCoordinates Flat coordinates.
   * @param {number} offset Offset.
   * @param {number} end End.
   * @param {number} stride Stride.
   * @param {number} max Max squared delta.
   * @return {number} Max squared delta.
   */
  function maxSquaredDelta(flatCoordinates, offset, end, stride, max) {
    var x1 = flatCoordinates[offset];
    var y1 = flatCoordinates[offset + 1];
    for (offset += stride; offset < end; offset += stride) {
      var x2 = flatCoordinates[offset];
      var y2 = flatCoordinates[offset + 1];
      var squaredDelta = squaredDistance(x1, y1, x2, y2);
      if (squaredDelta > max) {
        max = squaredDelta;
      }
      x1 = x2;
      y1 = y2;
    }
    return max;
  }


  /**
   * @param {Array<number>} flatCoordinates Flat coordinates.
   * @param {number} offset Offset.
   * @param {Array<number>} ends Ends.
   * @param {number} stride Stride.
   * @param {number} max Max squared delta.
   * @return {number} Max squared delta.
   */
  function arrayMaxSquaredDelta(flatCoordinates, offset, ends, stride, max) {
    for (var i = 0, ii = ends.length; i < ii; ++i) {
      var end = ends[i];
      max = maxSquaredDelta(
        flatCoordinates, offset, end, stride, max);
      offset = end;
    }
    return max;
  }


  /**
   * @param {Array<number>} flatCoordinates Flat coordinates.
   * @param {number} offset Offset.
   * @param {Array<Array<number>>} endss Endss.
   * @param {number} stride Stride.
   * @param {number} max Max squared delta.
   * @return {number} Max squared delta.
   */
  function multiArrayMaxSquaredDelta(flatCoordinates, offset, endss, stride, max) {
    for (var i = 0, ii = endss.length; i < ii; ++i) {
      var ends = endss[i];
      max = arrayMaxSquaredDelta(
        flatCoordinates, offset, ends, stride, max);
      offset = ends[ends.length - 1];
    }
    return max;
  }


  /**
   * @param {Array<number>} flatCoordinates Flat coordinates.
   * @param {number} offset Offset.
   * @param {number} end End.
   * @param {number} stride Stride.
   * @param {number} maxDelta Max delta.
   * @param {boolean} isRing Is ring.
   * @param {number} x X.
   * @param {number} y Y.
   * @param {Array<number>} closestPoint Closest point.
   * @param {number} minSquaredDistance Minimum squared distance.
   * @param {Array<number>=} opt_tmpPoint Temporary point object.
   * @return {number} Minimum squared distance.
   */
  function assignClosestPoint(flatCoordinates, offset, end,
    stride, maxDelta, isRing, x, y, closestPoint, minSquaredDistance,
    opt_tmpPoint) {
    if (offset == end) {
      return minSquaredDistance;
    }
    var i, squaredDistance$$1;
    if (maxDelta === 0) {
      // All points are identical, so just test the first point.
      squaredDistance$$1 = squaredDistance(
        x, y, flatCoordinates[offset], flatCoordinates[offset + 1]);
      if (squaredDistance$$1 < minSquaredDistance) {
        for (i = 0; i < stride; ++i) {
          closestPoint[i] = flatCoordinates[offset + i];
        }
        closestPoint.length = stride;
        return squaredDistance$$1;
      } else {
        return minSquaredDistance;
      }
    }
    var tmpPoint = opt_tmpPoint ? opt_tmpPoint : [NaN, NaN];
    var index = offset + stride;
    while (index < end) {
      assignClosest(
        flatCoordinates, index - stride, index, stride, x, y, tmpPoint);
      squaredDistance$$1 = squaredDistance(x, y, tmpPoint[0], tmpPoint[1]);
      if (squaredDistance$$1 < minSquaredDistance) {
        minSquaredDistance = squaredDistance$$1;
        for (i = 0; i < stride; ++i) {
          closestPoint[i] = tmpPoint[i];
        }
        closestPoint.length = stride;
        index += stride;
      } else {
        // Skip ahead multiple points, because we know that all the skipped
        // points cannot be any closer than the closest point we have found so
        // far.  We know this because we know how close the current point is, how
        // close the closest point we have found so far is, and the maximum
        // distance between consecutive points.  For example, if we're currently
        // at distance 10, the best we've found so far is 3, and that the maximum
        // distance between consecutive points is 2, then we'll need to skip at
        // least (10 - 3) / 2 == 3 (rounded down) points to have any chance of
        // finding a closer point.  We use Math.max(..., 1) to ensure that we
        // always advance at least one point, to avoid an infinite loop.
        index += stride * Math.max(
          ((Math.sqrt(squaredDistance$$1) -
              Math.sqrt(minSquaredDistance)) / maxDelta) | 0, 1);
      }
    }
    if (isRing) {
      // Check the closing segment.
      assignClosest(
        flatCoordinates, end - stride, offset, stride, x, y, tmpPoint);
      squaredDistance$$1 = squaredDistance(x, y, tmpPoint[0], tmpPoint[1]);
      if (squaredDistance$$1 < minSquaredDistance) {
        minSquaredDistance = squaredDistance$$1;
        for (i = 0; i < stride; ++i) {
          closestPoint[i] = tmpPoint[i];
        }
        closestPoint.length = stride;
      }
    }
    return minSquaredDistance;
  }


  /**
   * @param {Array<number>} flatCoordinates Flat coordinates.
   * @param {number} offset Offset.
   * @param {Array<number>} ends Ends.
   * @param {number} stride Stride.
   * @param {number} maxDelta Max delta.
   * @param {boolean} isRing Is ring.
   * @param {number} x X.
   * @param {number} y Y.
   * @param {Array<number>} closestPoint Closest point.
   * @param {number} minSquaredDistance Minimum squared distance.
   * @param {Array<number>=} opt_tmpPoint Temporary point object.
   * @return {number} Minimum squared distance.
   */
  function assignClosestArrayPoint(flatCoordinates, offset, ends,
    stride, maxDelta, isRing, x, y, closestPoint, minSquaredDistance,
    opt_tmpPoint) {
    var tmpPoint = opt_tmpPoint ? opt_tmpPoint : [NaN, NaN];
    for (var i = 0, ii = ends.length; i < ii; ++i) {
      var end = ends[i];
      minSquaredDistance = assignClosestPoint(
        flatCoordinates, offset, end, stride,
        maxDelta, isRing, x, y, closestPoint, minSquaredDistance, tmpPoint);
      offset = end;
    }
    return minSquaredDistance;
  }


  /**
   * @param {Array<number>} flatCoordinates Flat coordinates.
   * @param {number} offset Offset.
   * @param {Array<Array<number>>} endss Endss.
   * @param {number} stride Stride.
   * @param {number} maxDelta Max delta.
   * @param {boolean} isRing Is ring.
   * @param {number} x X.
   * @param {number} y Y.
   * @param {Array<number>} closestPoint Closest point.
   * @param {number} minSquaredDistance Minimum squared distance.
   * @param {Array<number>=} opt_tmpPoint Temporary point object.
   * @return {number} Minimum squared distance.
   */
  function assignClosestMultiArrayPoint(flatCoordinates, offset,
    endss, stride, maxDelta, isRing, x, y, closestPoint, minSquaredDistance,
    opt_tmpPoint) {
    var tmpPoint = opt_tmpPoint ? opt_tmpPoint : [NaN, NaN];
    for (var i = 0, ii = endss.length; i < ii; ++i) {
      var ends = endss[i];
      minSquaredDistance = assignClosestArrayPoint(
        flatCoordinates, offset, ends, stride,
        maxDelta, isRing, x, y, closestPoint, minSquaredDistance, tmpPoint);
      offset = ends[ends.length - 1];
    }
    return minSquaredDistance;
  }

  /**
   * @module ol/geom/flat/deflate
   */


  /**
   * @param {Array<number>} flatCoordinates Flat coordinates.
   * @param {number} offset Offset.
   * @param {import("../../coordinate.js").Coordinate} coordinate Coordinate.
   * @param {number} stride Stride.
   * @return {number} offset Offset.
   */
  function deflateCoordinate(flatCoordinates, offset, coordinate, stride) {
    for (var i = 0, ii = coordinate.length; i < ii; ++i) {
      flatCoordinates[offset++] = coordinate[i];
    }
    return offset;
  }


  /**
   * @param {Array<number>} flatCoordinates Flat coordinates.
   * @param {number} offset Offset.
   * @param {Array<import("../../coordinate.js").Coordinate>} coordinates Coordinates.
   * @param {number} stride Stride.
   * @return {number} offset Offset.
   */
  function deflateCoordinates(flatCoordinates, offset, coordinates, stride) {
    for (var i = 0, ii = coordinates.length; i < ii; ++i) {
      var coordinate = coordinates[i];
      for (var j = 0; j < stride; ++j) {
        flatCoordinates[offset++] = coordinate[j];
      }
    }
    return offset;
  }


  /**
   * @param {Array<number>} flatCoordinates Flat coordinates.
   * @param {number} offset Offset.
   * @param {Array<Array<import("../../coordinate.js").Coordinate>>} coordinatess Coordinatess.
   * @param {number} stride Stride.
   * @param {Array<number>=} opt_ends Ends.
   * @return {Array<number>} Ends.
   */
  function deflateCoordinatesArray(flatCoordinates, offset, coordinatess, stride, opt_ends) {
    var ends = opt_ends ? opt_ends : [];
    var i = 0;
    for (var j = 0, jj = coordinatess.length; j < jj; ++j) {
      var end = deflateCoordinates(
        flatCoordinates, offset, coordinatess[j], stride);
      ends[i++] = end;
      offset = end;
    }
    ends.length = i;
    return ends;
  }


  /**
   * @param {Array<number>} flatCoordinates Flat coordinates.
   * @param {number} offset Offset.
   * @param {Array<Array<Array<import("../../coordinate.js").Coordinate>>>} coordinatesss Coordinatesss.
   * @param {number} stride Stride.
   * @param {Array<Array<number>>=} opt_endss Endss.
   * @return {Array<Array<number>>} Endss.
   */
  function deflateMultiCoordinatesArray(flatCoordinates, offset, coordinatesss, stride, opt_endss) {
    var endss = opt_endss ? opt_endss : [];
    var i = 0;
    for (var j = 0, jj = coordinatesss.length; j < jj; ++j) {
      var ends = deflateCoordinatesArray(
        flatCoordinates, offset, coordinatesss[j], stride, endss[i]);
      endss[i++] = ends;
      offset = ends[ends.length - 1];
    }
    endss.length = i;
    return endss;
  }

  /**
   * @module ol/geom/flat/inflate
   */


  /**
   * @param {Array<number>} flatCoordinates Flat coordinates.
   * @param {number} offset Offset.
   * @param {number} end End.
   * @param {number} stride Stride.
   * @param {Array<import("../../coordinate.js").Coordinate>=} opt_coordinates Coordinates.
   * @return {Array<import("../../coordinate.js").Coordinate>} Coordinates.
   */
  function inflateCoordinates(flatCoordinates, offset, end, stride, opt_coordinates) {
    var coordinates = opt_coordinates !== undefined ? opt_coordinates : [];
    var i = 0;
    for (var j = offset; j < end; j += stride) {
      coordinates[i++] = flatCoordinates.slice(j, j + stride);
    }
    coordinates.length = i;
    return coordinates;
  }


  /**
   * @param {Array<number>} flatCoordinates Flat coordinates.
   * @param {number} offset Offset.
   * @param {Array<number>} ends Ends.
   * @param {number} stride Stride.
   * @param {Array<Array<import("../../coordinate.js").Coordinate>>=} opt_coordinatess Coordinatess.
   * @return {Array<Array<import("../../coordinate.js").Coordinate>>} Coordinatess.
   */
  function inflateCoordinatesArray(flatCoordinates, offset, ends, stride, opt_coordinatess) {
    var coordinatess = opt_coordinatess !== undefined ? opt_coordinatess : [];
    var i = 0;
    for (var j = 0, jj = ends.length; j < jj; ++j) {
      var end = ends[j];
      coordinatess[i++] = inflateCoordinates(
        flatCoordinates, offset, end, stride, coordinatess[i]);
      offset = end;
    }
    coordinatess.length = i;
    return coordinatess;
  }


  /**
   * @param {Array<number>} flatCoordinates Flat coordinates.
   * @param {number} offset Offset.
   * @param {Array<Array<number>>} endss Endss.
   * @param {number} stride Stride.
   * @param {Array<Array<Array<import("../../coordinate.js").Coordinate>>>=} opt_coordinatesss
   *     Coordinatesss.
   * @return {Array<Array<Array<import("../../coordinate.js").Coordinate>>>} Coordinatesss.
   */
  function inflateMultiCoordinatesArray(flatCoordinates, offset, endss, stride, opt_coordinatesss) {
    var coordinatesss = opt_coordinatesss !== undefined ? opt_coordinatesss : [];
    var i = 0;
    for (var j = 0, jj = endss.length; j < jj; ++j) {
      var ends = endss[j];
      coordinatesss[i++] = inflateCoordinatesArray(
        flatCoordinates, offset, ends, stride, coordinatesss[i]);
      offset = ends[ends.length - 1];
    }
    coordinatesss.length = i;
    return coordinatesss;
  }

  /**
   * @module ol/geom/flat/simplify
   */


  /**
   * @param {Array<number>} flatCoordinates Flat coordinates.
   * @param {number} offset Offset.
   * @param {number} end End.
   * @param {number} stride Stride.
   * @param {number} squaredTolerance Squared tolerance.
   * @param {Array<number>} simplifiedFlatCoordinates Simplified flat
   *     coordinates.
   * @param {number} simplifiedOffset Simplified offset.
   * @return {number} Simplified offset.
   */
  function douglasPeucker(flatCoordinates, offset, end,
    stride, squaredTolerance, simplifiedFlatCoordinates, simplifiedOffset) {
    var n = (end - offset) / stride;
    if (n < 3) {
      for (; offset < end; offset += stride) {
        simplifiedFlatCoordinates[simplifiedOffset++] =
            flatCoordinates[offset];
        simplifiedFlatCoordinates[simplifiedOffset++] =
            flatCoordinates[offset + 1];
      }
      return simplifiedOffset;
    }
    /** @type {Array<number>} */
    var markers = new Array(n);
    markers[0] = 1;
    markers[n - 1] = 1;
    /** @type {Array<number>} */
    var stack = [offset, end - stride];
    var index = 0;
    while (stack.length > 0) {
      var last = stack.pop();
      var first = stack.pop();
      var maxSquaredDistance = 0;
      var x1 = flatCoordinates[first];
      var y1 = flatCoordinates[first + 1];
      var x2 = flatCoordinates[last];
      var y2 = flatCoordinates[last + 1];
      for (var i = first + stride; i < last; i += stride) {
        var x = flatCoordinates[i];
        var y = flatCoordinates[i + 1];
        var squaredDistance$$1 = squaredSegmentDistance(
          x, y, x1, y1, x2, y2);
        if (squaredDistance$$1 > maxSquaredDistance) {
          index = i;
          maxSquaredDistance = squaredDistance$$1;
        }
      }
      if (maxSquaredDistance > squaredTolerance) {
        markers[(index - offset) / stride] = 1;
        if (first + stride < index) {
          stack.push(first, index);
        }
        if (index + stride < last) {
          stack.push(index, last);
        }
      }
    }
    for (var i$1 = 0; i$1 < n; ++i$1) {
      if (markers[i$1]) {
        simplifiedFlatCoordinates[simplifiedOffset++] =
            flatCoordinates[offset + i$1 * stride];
        simplifiedFlatCoordinates[simplifiedOffset++] =
            flatCoordinates[offset + i$1 * stride + 1];
      }
    }
    return simplifiedOffset;
  }


  /**
   * @param {Array<number>} flatCoordinates Flat coordinates.
   * @param {number} offset Offset.
   * @param {Array<number>} ends Ends.
   * @param {number} stride Stride.
   * @param {number} squaredTolerance Squared tolerance.
   * @param {Array<number>} simplifiedFlatCoordinates Simplified flat
   *     coordinates.
   * @param {number} simplifiedOffset Simplified offset.
   * @param {Array<number>} simplifiedEnds Simplified ends.
   * @return {number} Simplified offset.
   */
  function douglasPeuckerArray(flatCoordinates, offset,
    ends, stride, squaredTolerance, simplifiedFlatCoordinates,
    simplifiedOffset, simplifiedEnds) {
    for (var i = 0, ii = ends.length; i < ii; ++i) {
      var end = ends[i];
      simplifiedOffset = douglasPeucker(
        flatCoordinates, offset, end, stride, squaredTolerance,
        simplifiedFlatCoordinates, simplifiedOffset);
      simplifiedEnds.push(simplifiedOffset);
      offset = end;
    }
    return simplifiedOffset;
  }


  /**
   * @param {number} value Value.
   * @param {number} tolerance Tolerance.
   * @return {number} Rounded value.
   */
  function snap(value, tolerance) {
    return tolerance * Math.round(value / tolerance);
  }


  /**
   * Simplifies a line string using an algorithm designed by Tim Schaub.
   * Coordinates are snapped to the nearest value in a virtual grid and
   * consecutive duplicate coordinates are discarded.  This effectively preserves
   * topology as the simplification of any subsection of a line string is
   * independent of the rest of the line string.  This means that, for examples,
   * the common edge between two polygons will be simplified to the same line
   * string independently in both polygons.  This implementation uses a single
   * pass over the coordinates and eliminates intermediate collinear points.
   * @param {Array<number>} flatCoordinates Flat coordinates.
   * @param {number} offset Offset.
   * @param {number} end End.
   * @param {number} stride Stride.
   * @param {number} tolerance Tolerance.
   * @param {Array<number>} simplifiedFlatCoordinates Simplified flat
   *     coordinates.
   * @param {number} simplifiedOffset Simplified offset.
   * @return {number} Simplified offset.
   */
  function quantize(flatCoordinates, offset, end, stride,
    tolerance, simplifiedFlatCoordinates, simplifiedOffset) {
    // do nothing if the line is empty
    if (offset == end) {
      return simplifiedOffset;
    }
    // snap the first coordinate (P1)
    var x1 = snap(flatCoordinates[offset], tolerance);
    var y1 = snap(flatCoordinates[offset + 1], tolerance);
    offset += stride;
    // add the first coordinate to the output
    simplifiedFlatCoordinates[simplifiedOffset++] = x1;
    simplifiedFlatCoordinates[simplifiedOffset++] = y1;
    // find the next coordinate that does not snap to the same value as the first
    // coordinate (P2)
    var x2, y2;
    do {
      x2 = snap(flatCoordinates[offset], tolerance);
      y2 = snap(flatCoordinates[offset + 1], tolerance);
      offset += stride;
      if (offset == end) {
        // all coordinates snap to the same value, the line collapses to a point
        // push the last snapped value anyway to ensure that the output contains
        // at least two points
        // FIXME should we really return at least two points anyway?
        simplifiedFlatCoordinates[simplifiedOffset++] = x2;
        simplifiedFlatCoordinates[simplifiedOffset++] = y2;
        return simplifiedOffset;
      }
    } while (x2 == x1 && y2 == y1);
    while (offset < end) {
      // snap the next coordinate (P3)
      var x3 = snap(flatCoordinates[offset], tolerance);
      var y3 = snap(flatCoordinates[offset + 1], tolerance);
      offset += stride;
      // skip P3 if it is equal to P2
      if (x3 == x2 && y3 == y2) {
        continue;
      }
      // calculate the delta between P1 and P2
      var dx1 = x2 - x1;
      var dy1 = y2 - y1;
      // calculate the delta between P3 and P1
      var dx2 = x3 - x1;
      var dy2 = y3 - y1;
      // if P1, P2, and P3 are colinear and P3 is further from P1 than P2 is from
      // P1 in the same direction then P2 is on the straight line between P1 and
      // P3
      if ((dx1 * dy2 == dy1 * dx2) &&
          ((dx1 < 0 && dx2 < dx1) || dx1 == dx2 || (dx1 > 0 && dx2 > dx1)) &&
          ((dy1 < 0 && dy2 < dy1) || dy1 == dy2 || (dy1 > 0 && dy2 > dy1))) {
        // discard P2 and set P2 = P3
        x2 = x3;
        y2 = y3;
        continue;
      }
      // either P1, P2, and P3 are not colinear, or they are colinear but P3 is
      // between P3 and P1 or on the opposite half of the line to P2.  add P2,
      // and continue with P1 = P2 and P2 = P3
      simplifiedFlatCoordinates[simplifiedOffset++] = x2;
      simplifiedFlatCoordinates[simplifiedOffset++] = y2;
      x1 = x2;
      y1 = y2;
      x2 = x3;
      y2 = y3;
    }
    // add the last point (P2)
    simplifiedFlatCoordinates[simplifiedOffset++] = x2;
    simplifiedFlatCoordinates[simplifiedOffset++] = y2;
    return simplifiedOffset;
  }


  /**
   * @param {Array<number>} flatCoordinates Flat coordinates.
   * @param {number} offset Offset.
   * @param {Array<number>} ends Ends.
   * @param {number} stride Stride.
   * @param {number} tolerance Tolerance.
   * @param {Array<number>} simplifiedFlatCoordinates Simplified flat
   *     coordinates.
   * @param {number} simplifiedOffset Simplified offset.
   * @param {Array<number>} simplifiedEnds Simplified ends.
   * @return {number} Simplified offset.
   */
  function quantizeArray(
    flatCoordinates, offset, ends, stride,
    tolerance,
    simplifiedFlatCoordinates, simplifiedOffset, simplifiedEnds) {
    for (var i = 0, ii = ends.length; i < ii; ++i) {
      var end = ends[i];
      simplifiedOffset = quantize(
        flatCoordinates, offset, end, stride,
        tolerance,
        simplifiedFlatCoordinates, simplifiedOffset);
      simplifiedEnds.push(simplifiedOffset);
      offset = end;
    }
    return simplifiedOffset;
  }


  /**
   * @param {Array<number>} flatCoordinates Flat coordinates.
   * @param {number} offset Offset.
   * @param {Array<Array<number>>} endss Endss.
   * @param {number} stride Stride.
   * @param {number} tolerance Tolerance.
   * @param {Array<number>} simplifiedFlatCoordinates Simplified flat
   *     coordinates.
   * @param {number} simplifiedOffset Simplified offset.
   * @param {Array<Array<number>>} simplifiedEndss Simplified endss.
   * @return {number} Simplified offset.
   */
  function quantizeMultiArray(
    flatCoordinates, offset, endss, stride,
    tolerance,
    simplifiedFlatCoordinates, simplifiedOffset, simplifiedEndss) {
    for (var i = 0, ii = endss.length; i < ii; ++i) {
      var ends = endss[i];
      var simplifiedEnds = [];
      simplifiedOffset = quantizeArray(
        flatCoordinates, offset, ends, stride,
        tolerance,
        simplifiedFlatCoordinates, simplifiedOffset, simplifiedEnds);
      simplifiedEndss.push(simplifiedEnds);
      offset = ends[ends.length - 1];
    }
    return simplifiedOffset;
  }

  /**
   * @module ol/geom/LinearRing
   */

  /**
   * @classdesc
   * Linear ring geometry. Only used as part of polygon; cannot be rendered
   * on its own.
   *
   * @api
   */
  var LinearRing = /*@__PURE__*/(function (SimpleGeometry$$1) {
    function LinearRing(coordinates, opt_layout) {

      SimpleGeometry$$1.call(this);

      /**
       * @private
       * @type {number}
       */
      this.maxDelta_ = -1;

      /**
       * @private
       * @type {number}
       */
      this.maxDeltaRevision_ = -1;

      if (opt_layout !== undefined && !Array.isArray(coordinates[0])) {
        this.setFlatCoordinates(opt_layout, /** @type {Array<number>} */ (coordinates));
      } else {
        this.setCoordinates(/** @type {Array<import("../coordinate.js").Coordinate>} */ (coordinates), opt_layout);
      }

    }

    if ( SimpleGeometry$$1 ) LinearRing.__proto__ = SimpleGeometry$$1;
    LinearRing.prototype = Object.create( SimpleGeometry$$1 && SimpleGeometry$$1.prototype );
    LinearRing.prototype.constructor = LinearRing;

    /**
     * Make a complete copy of the geometry.
     * @return {!LinearRing} Clone.
     * @override
     * @api
     */
    LinearRing.prototype.clone = function clone$$1 () {
      return new LinearRing(this.flatCoordinates.slice(), this.layout);
    };

    /**
     * @inheritDoc
     */
    LinearRing.prototype.closestPointXY = function closestPointXY (x, y, closestPoint, minSquaredDistance) {
      if (minSquaredDistance < closestSquaredDistanceXY(this.getExtent(), x, y)) {
        return minSquaredDistance;
      }
      if (this.maxDeltaRevision_ != this.getRevision()) {
        this.maxDelta_ = Math.sqrt(maxSquaredDelta(
          this.flatCoordinates, 0, this.flatCoordinates.length, this.stride, 0));
        this.maxDeltaRevision_ = this.getRevision();
      }
      return assignClosestPoint(
        this.flatCoordinates, 0, this.flatCoordinates.length, this.stride,
        this.maxDelta_, true, x, y, closestPoint, minSquaredDistance);
    };

    /**
     * Return the area of the linear ring on projected plane.
     * @return {number} Area (on projected plane).
     * @api
     */
    LinearRing.prototype.getArea = function getArea$$1 () {
      return linearRing(this.flatCoordinates, 0, this.flatCoordinates.length, this.stride);
    };

    /**
     * Return the coordinates of the linear ring.
     * @return {Array<import("../coordinate.js").Coordinate>} Coordinates.
     * @override
     * @api
     */
    LinearRing.prototype.getCoordinates = function getCoordinates () {
      return inflateCoordinates(
        this.flatCoordinates, 0, this.flatCoordinates.length, this.stride);
    };

    /**
     * @inheritDoc
     */
    LinearRing.prototype.getSimplifiedGeometryInternal = function getSimplifiedGeometryInternal (squaredTolerance) {
      var simplifiedFlatCoordinates = [];
      simplifiedFlatCoordinates.length = douglasPeucker(
        this.flatCoordinates, 0, this.flatCoordinates.length, this.stride,
        squaredTolerance, simplifiedFlatCoordinates, 0);
      return new LinearRing(simplifiedFlatCoordinates, GeometryLayout.XY);
    };

    /**
     * @inheritDoc
     * @api
     */
    LinearRing.prototype.getType = function getType () {
      return GeometryType.LINEAR_RING;
    };

    /**
     * @inheritDoc
     */
    LinearRing.prototype.intersectsExtent = function intersectsExtent (extent) {
      return false;
    };

    /**
     * Set the coordinates of the linear ring.
     * @param {!Array<import("../coordinate.js").Coordinate>} coordinates Coordinates.
     * @param {GeometryLayout=} opt_layout Layout.
     * @override
     * @api
     */
    LinearRing.prototype.setCoordinates = function setCoordinates (coordinates, opt_layout) {
      this.setLayout(opt_layout, coordinates, 1);
      if (!this.flatCoordinates) {
        this.flatCoordinates = [];
      }
      this.flatCoordinates.length = deflateCoordinates(
        this.flatCoordinates, 0, coordinates, this.stride);
      this.changed();
    };

    return LinearRing;
  }(SimpleGeometry));

  /**
   * @module ol/geom/Point
   */

  /**
   * @classdesc
   * Point geometry.
   *
   * @api
   */
  var Point = /*@__PURE__*/(function (SimpleGeometry$$1) {
    function Point(coordinates, opt_layout) {
      SimpleGeometry$$1.call(this);
      this.setCoordinates(coordinates, opt_layout);
    }

    if ( SimpleGeometry$$1 ) Point.__proto__ = SimpleGeometry$$1;
    Point.prototype = Object.create( SimpleGeometry$$1 && SimpleGeometry$$1.prototype );
    Point.prototype.constructor = Point;

    /**
     * Make a complete copy of the geometry.
     * @return {!Point} Clone.
     * @override
     * @api
     */
    Point.prototype.clone = function clone$$1 () {
      var point = new Point(this.flatCoordinates.slice(), this.layout);
      return point;
    };

    /**
     * @inheritDoc
     */
    Point.prototype.closestPointXY = function closestPointXY (x, y, closestPoint, minSquaredDistance) {
      var flatCoordinates = this.flatCoordinates;
      var squaredDistance$$1 = squaredDistance(x, y, flatCoordinates[0], flatCoordinates[1]);
      if (squaredDistance$$1 < minSquaredDistance) {
        var stride = this.stride;
        for (var i = 0; i < stride; ++i) {
          closestPoint[i] = flatCoordinates[i];
        }
        closestPoint.length = stride;
        return squaredDistance$$1;
      } else {
        return minSquaredDistance;
      }
    };

    /**
     * Return the coordinate of the point.
     * @return {import("../coordinate.js").Coordinate} Coordinates.
     * @override
     * @api
     */
    Point.prototype.getCoordinates = function getCoordinates () {
      return !this.flatCoordinates ? [] : this.flatCoordinates.slice();
    };

    /**
     * @inheritDoc
     */
    Point.prototype.computeExtent = function computeExtent (extent) {
      return createOrUpdateFromCoordinate(this.flatCoordinates, extent);
    };

    /**
     * @inheritDoc
     * @api
     */
    Point.prototype.getType = function getType () {
      return GeometryType.POINT;
    };

    /**
     * @inheritDoc
     * @api
     */
    Point.prototype.intersectsExtent = function intersectsExtent (extent) {
      return containsXY(extent, this.flatCoordinates[0], this.flatCoordinates[1]);
    };

    /**
     * @inheritDoc
     * @api
     */
    Point.prototype.setCoordinates = function setCoordinates (coordinates, opt_layout) {
      this.setLayout(opt_layout, coordinates, 0);
      if (!this.flatCoordinates) {
        this.flatCoordinates = [];
      }
      this.flatCoordinates.length = deflateCoordinate(
        this.flatCoordinates, 0, coordinates, this.stride);
      this.changed();
    };

    return Point;
  }(SimpleGeometry));

  /**
   * @module ol/geom/flat/contains
   */


  /**
   * @param {Array<number>} flatCoordinates Flat coordinates.
   * @param {number} offset Offset.
   * @param {number} end End.
   * @param {number} stride Stride.
   * @param {import("../../extent.js").Extent} extent Extent.
   * @return {boolean} Contains extent.
   */
  function linearRingContainsExtent(flatCoordinates, offset, end, stride, extent) {
    var outside = forEachCorner(extent,
      /**
       * @param {import("../../coordinate.js").Coordinate} coordinate Coordinate.
       * @return {boolean} Contains (x, y).
       */
      function(coordinate) {
        return !linearRingContainsXY(flatCoordinates, offset, end, stride, coordinate[0], coordinate[1]);
      });
    return !outside;
  }


  /**
   * @param {Array<number>} flatCoordinates Flat coordinates.
   * @param {number} offset Offset.
   * @param {number} end End.
   * @param {number} stride Stride.
   * @param {number} x X.
   * @param {number} y Y.
   * @return {boolean} Contains (x, y).
   */
  function linearRingContainsXY(flatCoordinates, offset, end, stride, x, y) {
    // http://geomalgorithms.com/a03-_inclusion.html
    // Copyright 2000 softSurfer, 2012 Dan Sunday
    // This code may be freely used and modified for any purpose
    // providing that this copyright notice is included with it.
    // SoftSurfer makes no warranty for this code, and cannot be held
    // liable for any real or imagined damage resulting from its use.
    // Users of this code must verify correctness for their application.
    var wn = 0;
    var x1 = flatCoordinates[end - stride];
    var y1 = flatCoordinates[end - stride + 1];
    for (; offset < end; offset += stride) {
      var x2 = flatCoordinates[offset];
      var y2 = flatCoordinates[offset + 1];
      if (y1 <= y) {
        if (y2 > y && ((x2 - x1) * (y - y1)) - ((x - x1) * (y2 - y1)) > 0) {
          wn++;
        }
      } else if (y2 <= y && ((x2 - x1) * (y - y1)) - ((x - x1) * (y2 - y1)) < 0) {
        wn--;
      }
      x1 = x2;
      y1 = y2;
    }
    return wn !== 0;
  }


  /**
   * @param {Array<number>} flatCoordinates Flat coordinates.
   * @param {number} offset Offset.
   * @param {Array<number>} ends Ends.
   * @param {number} stride Stride.
   * @param {number} x X.
   * @param {number} y Y.
   * @return {boolean} Contains (x, y).
   */
  function linearRingsContainsXY(flatCoordinates, offset, ends, stride, x, y) {
    if (ends.length === 0) {
      return false;
    }
    if (!linearRingContainsXY(flatCoordinates, offset, ends[0], stride, x, y)) {
      return false;
    }
    for (var i = 1, ii = ends.length; i < ii; ++i) {
      if (linearRingContainsXY(flatCoordinates, ends[i - 1], ends[i], stride, x, y)) {
        return false;
      }
    }
    return true;
  }


  /**
   * @param {Array<number>} flatCoordinates Flat coordinates.
   * @param {number} offset Offset.
   * @param {Array<Array<number>>} endss Endss.
   * @param {number} stride Stride.
   * @param {number} x X.
   * @param {number} y Y.
   * @return {boolean} Contains (x, y).
   */
  function linearRingssContainsXY(flatCoordinates, offset, endss, stride, x, y) {
    if (endss.length === 0) {
      return false;
    }
    for (var i = 0, ii = endss.length; i < ii; ++i) {
      var ends = endss[i];
      if (linearRingsContainsXY(flatCoordinates, offset, ends, stride, x, y)) {
        return true;
      }
      offset = ends[ends.length - 1];
    }
    return false;
  }

  /**
   * @module ol/geom/flat/interiorpoint
   */


  /**
   * Calculates a point that is likely to lie in the interior of the linear rings.
   * Inspired by JTS's com.vividsolutions.jts.geom.Geometry#getInteriorPoint.
   * @param {Array<number>} flatCoordinates Flat coordinates.
   * @param {number} offset Offset.
   * @param {Array<number>} ends Ends.
   * @param {number} stride Stride.
   * @param {Array<number>} flatCenters Flat centers.
   * @param {number} flatCentersOffset Flat center offset.
   * @param {Array<number>=} opt_dest Destination.
   * @return {Array<number>} Destination point as XYM coordinate, where M is the
   * length of the horizontal intersection that the point belongs to.
   */
  function getInteriorPointOfArray(flatCoordinates, offset,
    ends, stride, flatCenters, flatCentersOffset, opt_dest) {
    var i, ii, x, x1, x2, y1, y2;
    var y = flatCenters[flatCentersOffset + 1];
    /** @type {Array<number>} */
    var intersections = [];
    // Calculate intersections with the horizontal line
    for (var r = 0, rr = ends.length; r < rr; ++r) {
      var end = ends[r];
      x1 = flatCoordinates[end - stride];
      y1 = flatCoordinates[end - stride + 1];
      for (i = offset; i < end; i += stride) {
        x2 = flatCoordinates[i];
        y2 = flatCoordinates[i + 1];
        if ((y <= y1 && y2 <= y) || (y1 <= y && y <= y2)) {
          x = (y - y1) / (y2 - y1) * (x2 - x1) + x1;
          intersections.push(x);
        }
        x1 = x2;
        y1 = y2;
      }
    }
    // Find the longest segment of the horizontal line that has its center point
    // inside the linear ring.
    var pointX = NaN;
    var maxSegmentLength = -Infinity;
    intersections.sort(numberSafeCompareFunction);
    x1 = intersections[0];
    for (i = 1, ii = intersections.length; i < ii; ++i) {
      x2 = intersections[i];
      var segmentLength = Math.abs(x2 - x1);
      if (segmentLength > maxSegmentLength) {
        x = (x1 + x2) / 2;
        if (linearRingsContainsXY(flatCoordinates, offset, ends, stride, x, y)) {
          pointX = x;
          maxSegmentLength = segmentLength;
        }
      }
      x1 = x2;
    }
    if (isNaN(pointX)) {
      // There is no horizontal line that has its center point inside the linear
      // ring.  Use the center of the the linear ring's extent.
      pointX = flatCenters[flatCentersOffset];
    }
    if (opt_dest) {
      opt_dest.push(pointX, y, maxSegmentLength);
      return opt_dest;
    } else {
      return [pointX, y, maxSegmentLength];
    }
  }


  /**
   * @param {Array<number>} flatCoordinates Flat coordinates.
   * @param {number} offset Offset.
   * @param {Array<Array<number>>} endss Endss.
   * @param {number} stride Stride.
   * @param {Array<number>} flatCenters Flat centers.
   * @return {Array<number>} Interior points as XYM coordinates, where M is the
   * length of the horizontal intersection that the point belongs to.
   */
  function getInteriorPointsOfMultiArray(flatCoordinates, offset, endss, stride, flatCenters) {
    var interiorPoints = [];
    for (var i = 0, ii = endss.length; i < ii; ++i) {
      var ends = endss[i];
      interiorPoints = getInteriorPointOfArray(flatCoordinates,
        offset, ends, stride, flatCenters, 2 * i, interiorPoints);
      offset = ends[ends.length - 1];
    }
    return interiorPoints;
  }

  /**
   * @module ol/geom/flat/segments
   */


  /**
   * This function calls `callback` for each segment of the flat coordinates
   * array. If the callback returns a truthy value the function returns that
   * value immediately. Otherwise the function returns `false`.
   * @param {Array<number>} flatCoordinates Flat coordinates.
   * @param {number} offset Offset.
   * @param {number} end End.
   * @param {number} stride Stride.
   * @param {function(this: S, import("../../coordinate.js").Coordinate, import("../../coordinate.js").Coordinate): T} callback Function
   *     called for each segment.
   * @param {S=} opt_this The object to be used as the value of 'this'
   *     within callback.
   * @return {T|boolean} Value.
   * @template T,S
   */
  function forEach(flatCoordinates, offset, end, stride, callback, opt_this) {
    var point1 = [flatCoordinates[offset], flatCoordinates[offset + 1]];
    var point2 = [];
    var ret;
    for (; (offset + stride) < end; offset += stride) {
      point2[0] = flatCoordinates[offset + stride];
      point2[1] = flatCoordinates[offset + stride + 1];
      ret = callback.call(opt_this, point1, point2);
      if (ret) {
        return ret;
      }
      point1[0] = point2[0];
      point1[1] = point2[1];
    }
    return false;
  }

  /**
   * @module ol/geom/flat/intersectsextent
   */


  /**
   * @param {Array<number>} flatCoordinates Flat coordinates.
   * @param {number} offset Offset.
   * @param {number} end End.
   * @param {number} stride Stride.
   * @param {import("../../extent.js").Extent} extent Extent.
   * @return {boolean} True if the geometry and the extent intersect.
   */
  function intersectsLineString(flatCoordinates, offset, end, stride, extent) {
    var coordinatesExtent = extendFlatCoordinates(
      createEmpty(), flatCoordinates, offset, end, stride);
    if (!intersects(extent, coordinatesExtent)) {
      return false;
    }
    if (containsExtent(extent, coordinatesExtent)) {
      return true;
    }
    if (coordinatesExtent[0] >= extent[0] &&
        coordinatesExtent[2] <= extent[2]) {
      return true;
    }
    if (coordinatesExtent[1] >= extent[1] &&
        coordinatesExtent[3] <= extent[3]) {
      return true;
    }
    return forEach(flatCoordinates, offset, end, stride,
      /**
       * @param {import("../../coordinate.js").Coordinate} point1 Start point.
       * @param {import("../../coordinate.js").Coordinate} point2 End point.
       * @return {boolean} `true` if the segment and the extent intersect,
       *     `false` otherwise.
       */
      function(point1, point2) {
        return intersectsSegment(extent, point1, point2);
      });
  }


  /**
   * @param {Array<number>} flatCoordinates Flat coordinates.
   * @param {number} offset Offset.
   * @param {Array<number>} ends Ends.
   * @param {number} stride Stride.
   * @param {import("../../extent.js").Extent} extent Extent.
   * @return {boolean} True if the geometry and the extent intersect.
   */
  function intersectsLineStringArray(flatCoordinates, offset, ends, stride, extent) {
    for (var i = 0, ii = ends.length; i < ii; ++i) {
      if (intersectsLineString(
        flatCoordinates, offset, ends[i], stride, extent)) {
        return true;
      }
      offset = ends[i];
    }
    return false;
  }


  /**
   * @param {Array<number>} flatCoordinates Flat coordinates.
   * @param {number} offset Offset.
   * @param {number} end End.
   * @param {number} stride Stride.
   * @param {import("../../extent.js").Extent} extent Extent.
   * @return {boolean} True if the geometry and the extent intersect.
   */
  function intersectsLinearRing(flatCoordinates, offset, end, stride, extent) {
    if (intersectsLineString(
      flatCoordinates, offset, end, stride, extent)) {
      return true;
    }
    if (linearRingContainsXY(flatCoordinates, offset, end, stride, extent[0], extent[1])) {
      return true;
    }
    if (linearRingContainsXY(flatCoordinates, offset, end, stride, extent[0], extent[3])) {
      return true;
    }
    if (linearRingContainsXY(flatCoordinates, offset, end, stride, extent[2], extent[1])) {
      return true;
    }
    if (linearRingContainsXY(flatCoordinates, offset, end, stride, extent[2], extent[3])) {
      return true;
    }
    return false;
  }


  /**
   * @param {Array<number>} flatCoordinates Flat coordinates.
   * @param {number} offset Offset.
   * @param {Array<number>} ends Ends.
   * @param {number} stride Stride.
   * @param {import("../../extent.js").Extent} extent Extent.
   * @return {boolean} True if the geometry and the extent intersect.
   */
  function intersectsLinearRingArray(flatCoordinates, offset, ends, stride, extent) {
    if (!intersectsLinearRing(
      flatCoordinates, offset, ends[0], stride, extent)) {
      return false;
    }
    if (ends.length === 1) {
      return true;
    }
    for (var i = 1, ii = ends.length; i < ii; ++i) {
      if (linearRingContainsExtent(flatCoordinates, ends[i - 1], ends[i], stride, extent)) {
        if (!intersectsLineString(flatCoordinates, ends[i - 1], ends[i], stride, extent)) {
          return false;
        }
      }
    }
    return true;
  }


  /**
   * @param {Array<number>} flatCoordinates Flat coordinates.
   * @param {number} offset Offset.
   * @param {Array<Array<number>>} endss Endss.
   * @param {number} stride Stride.
   * @param {import("../../extent.js").Extent} extent Extent.
   * @return {boolean} True if the geometry and the extent intersect.
   */
  function intersectsLinearRingMultiArray(flatCoordinates, offset, endss, stride, extent) {
    for (var i = 0, ii = endss.length; i < ii; ++i) {
      var ends = endss[i];
      if (intersectsLinearRingArray(
        flatCoordinates, offset, ends, stride, extent)) {
        return true;
      }
      offset = ends[ends.length - 1];
    }
    return false;
  }

  /**
   * @module ol/geom/flat/reverse
   */


  /**
   * @param {Array<number>} flatCoordinates Flat coordinates.
   * @param {number} offset Offset.
   * @param {number} end End.
   * @param {number} stride Stride.
   */
  function coordinates(flatCoordinates, offset, end, stride) {
    while (offset < end - stride) {
      for (var i = 0; i < stride; ++i) {
        var tmp = flatCoordinates[offset + i];
        flatCoordinates[offset + i] = flatCoordinates[end - stride + i];
        flatCoordinates[end - stride + i] = tmp;
      }
      offset += stride;
      end -= stride;
    }
  }

  /**
   * @module ol/geom/flat/orient
   */


  /**
   * @param {Array<number>} flatCoordinates Flat coordinates.
   * @param {number} offset Offset.
   * @param {number} end End.
   * @param {number} stride Stride.
   * @return {boolean} Is clockwise.
   */
  function linearRingIsClockwise(flatCoordinates, offset, end, stride) {
    // http://tinyurl.com/clockwise-method
    // https://github.com/OSGeo/gdal/blob/trunk/gdal/ogr/ogrlinearring.cpp
    var edge = 0;
    var x1 = flatCoordinates[end - stride];
    var y1 = flatCoordinates[end - stride + 1];
    for (; offset < end; offset += stride) {
      var x2 = flatCoordinates[offset];
      var y2 = flatCoordinates[offset + 1];
      edge += (x2 - x1) * (y2 + y1);
      x1 = x2;
      y1 = y2;
    }
    return edge > 0;
  }


  /**
   * Determines if linear rings are oriented.  By default, left-hand orientation
   * is tested (first ring must be clockwise, remaining rings counter-clockwise).
   * To test for right-hand orientation, use the `opt_right` argument.
   *
   * @param {Array<number>} flatCoordinates Flat coordinates.
   * @param {number} offset Offset.
   * @param {Array<number>} ends Array of end indexes.
   * @param {number} stride Stride.
   * @param {boolean=} opt_right Test for right-hand orientation
   *     (counter-clockwise exterior ring and clockwise interior rings).
   * @return {boolean} Rings are correctly oriented.
   */
  function linearRingIsOriented(flatCoordinates, offset, ends, stride, opt_right) {
    var right = opt_right !== undefined ? opt_right : false;
    for (var i = 0, ii = ends.length; i < ii; ++i) {
      var end = ends[i];
      var isClockwise = linearRingIsClockwise(
        flatCoordinates, offset, end, stride);
      if (i === 0) {
        if ((right && isClockwise) || (!right && !isClockwise)) {
          return false;
        }
      } else {
        if ((right && !isClockwise) || (!right && isClockwise)) {
          return false;
        }
      }
      offset = end;
    }
    return true;
  }


  /**
   * Determines if linear rings are oriented.  By default, left-hand orientation
   * is tested (first ring must be clockwise, remaining rings counter-clockwise).
   * To test for right-hand orientation, use the `opt_right` argument.
   *
   * @param {Array<number>} flatCoordinates Flat coordinates.
   * @param {number} offset Offset.
   * @param {Array<Array<number>>} endss Array of array of end indexes.
   * @param {number} stride Stride.
   * @param {boolean=} opt_right Test for right-hand orientation
   *     (counter-clockwise exterior ring and clockwise interior rings).
   * @return {boolean} Rings are correctly oriented.
   */
  function linearRingsAreOriented(flatCoordinates, offset, endss, stride, opt_right) {
    for (var i = 0, ii = endss.length; i < ii; ++i) {
      if (!linearRingIsOriented(
        flatCoordinates, offset, endss[i], stride, opt_right)) {
        return false;
      }
    }
    return true;
  }


  /**
   * Orient coordinates in a flat array of linear rings.  By default, rings
   * are oriented following the left-hand rule (clockwise for exterior and
   * counter-clockwise for interior rings).  To orient according to the
   * right-hand rule, use the `opt_right` argument.
   *
   * @param {Array<number>} flatCoordinates Flat coordinates.
   * @param {number} offset Offset.
   * @param {Array<number>} ends Ends.
   * @param {number} stride Stride.
   * @param {boolean=} opt_right Follow the right-hand rule for orientation.
   * @return {number} End.
   */
  function orientLinearRings(flatCoordinates, offset, ends, stride, opt_right) {
    var right = opt_right !== undefined ? opt_right : false;
    for (var i = 0, ii = ends.length; i < ii; ++i) {
      var end = ends[i];
      var isClockwise = linearRingIsClockwise(
        flatCoordinates, offset, end, stride);
      var reverse = i === 0 ?
        (right && isClockwise) || (!right && !isClockwise) :
        (right && !isClockwise) || (!right && isClockwise);
      if (reverse) {
        coordinates(flatCoordinates, offset, end, stride);
      }
      offset = end;
    }
    return offset;
  }


  /**
   * Orient coordinates in a flat array of linear rings.  By default, rings
   * are oriented following the left-hand rule (clockwise for exterior and
   * counter-clockwise for interior rings).  To orient according to the
   * right-hand rule, use the `opt_right` argument.
   *
   * @param {Array<number>} flatCoordinates Flat coordinates.
   * @param {number} offset Offset.
   * @param {Array<Array<number>>} endss Array of array of end indexes.
   * @param {number} stride Stride.
   * @param {boolean=} opt_right Follow the right-hand rule for orientation.
   * @return {number} End.
   */
  function orientLinearRingsArray(flatCoordinates, offset, endss, stride, opt_right) {
    for (var i = 0, ii = endss.length; i < ii; ++i) {
      offset = orientLinearRings(
        flatCoordinates, offset, endss[i], stride, opt_right);
    }
    return offset;
  }

  /**
   * @module ol/geom/Polygon
   */

  /**
   * @classdesc
   * Polygon geometry.
   *
   * @api
   */
  var Polygon = /*@__PURE__*/(function (SimpleGeometry$$1) {
    function Polygon(coordinates, opt_layout, opt_ends) {

      SimpleGeometry$$1.call(this);

      /**
       * @type {Array<number>}
       * @private
       */
      this.ends_ = [];

      /**
       * @private
       * @type {number}
       */
      this.flatInteriorPointRevision_ = -1;

      /**
       * @private
       * @type {import("../coordinate.js").Coordinate}
       */
      this.flatInteriorPoint_ = null;

      /**
       * @private
       * @type {number}
       */
      this.maxDelta_ = -1;

      /**
       * @private
       * @type {number}
       */
      this.maxDeltaRevision_ = -1;

      /**
       * @private
       * @type {number}
       */
      this.orientedRevision_ = -1;

      /**
       * @private
       * @type {Array<number>}
       */
      this.orientedFlatCoordinates_ = null;

      if (opt_layout !== undefined && opt_ends) {
        this.setFlatCoordinates(opt_layout, /** @type {Array<number>} */ (coordinates));
        this.ends_ = opt_ends;
      } else {
        this.setCoordinates(/** @type {Array<Array<import("../coordinate.js").Coordinate>>} */ (coordinates), opt_layout);
      }

    }

    if ( SimpleGeometry$$1 ) Polygon.__proto__ = SimpleGeometry$$1;
    Polygon.prototype = Object.create( SimpleGeometry$$1 && SimpleGeometry$$1.prototype );
    Polygon.prototype.constructor = Polygon;

    /**
     * Append the passed linear ring to this polygon.
     * @param {LinearRing} linearRing Linear ring.
     * @api
     */
    Polygon.prototype.appendLinearRing = function appendLinearRing (linearRing$$1) {
      if (!this.flatCoordinates) {
        this.flatCoordinates = linearRing$$1.getFlatCoordinates().slice();
      } else {
        extend(this.flatCoordinates, linearRing$$1.getFlatCoordinates());
      }
      this.ends_.push(this.flatCoordinates.length);
      this.changed();
    };

    /**
     * Make a complete copy of the geometry.
     * @return {!Polygon} Clone.
     * @override
     * @api
     */
    Polygon.prototype.clone = function clone$$1 () {
      return new Polygon(this.flatCoordinates.slice(), this.layout, this.ends_.slice());
    };

    /**
     * @inheritDoc
     */
    Polygon.prototype.closestPointXY = function closestPointXY (x, y, closestPoint, minSquaredDistance) {
      if (minSquaredDistance < closestSquaredDistanceXY(this.getExtent(), x, y)) {
        return minSquaredDistance;
      }
      if (this.maxDeltaRevision_ != this.getRevision()) {
        this.maxDelta_ = Math.sqrt(arrayMaxSquaredDelta(
          this.flatCoordinates, 0, this.ends_, this.stride, 0));
        this.maxDeltaRevision_ = this.getRevision();
      }
      return assignClosestArrayPoint(
        this.flatCoordinates, 0, this.ends_, this.stride,
        this.maxDelta_, true, x, y, closestPoint, minSquaredDistance);
    };

    /**
     * @inheritDoc
     */
    Polygon.prototype.containsXY = function containsXY$$1 (x, y) {
      return linearRingsContainsXY(this.getOrientedFlatCoordinates(), 0, this.ends_, this.stride, x, y);
    };

    /**
     * Return the area of the polygon on projected plane.
     * @return {number} Area (on projected plane).
     * @api
     */
    Polygon.prototype.getArea = function getArea$$1 () {
      return linearRings(this.getOrientedFlatCoordinates(), 0, this.ends_, this.stride);
    };

    /**
     * Get the coordinate array for this geometry.  This array has the structure
     * of a GeoJSON coordinate array for polygons.
     *
     * @param {boolean=} opt_right Orient coordinates according to the right-hand
     *     rule (counter-clockwise for exterior and clockwise for interior rings).
     *     If `false`, coordinates will be oriented according to the left-hand rule
     *     (clockwise for exterior and counter-clockwise for interior rings).
     *     By default, coordinate orientation will depend on how the geometry was
     *     constructed.
     * @return {Array<Array<import("../coordinate.js").Coordinate>>} Coordinates.
     * @override
     * @api
     */
    Polygon.prototype.getCoordinates = function getCoordinates (opt_right) {
      var flatCoordinates;
      if (opt_right !== undefined) {
        flatCoordinates = this.getOrientedFlatCoordinates().slice();
        orientLinearRings(
          flatCoordinates, 0, this.ends_, this.stride, opt_right);
      } else {
        flatCoordinates = this.flatCoordinates;
      }

      return inflateCoordinatesArray(
        flatCoordinates, 0, this.ends_, this.stride);
    };

    /**
     * @return {Array<number>} Ends.
     */
    Polygon.prototype.getEnds = function getEnds () {
      return this.ends_;
    };

    /**
     * @return {Array<number>} Interior point.
     */
    Polygon.prototype.getFlatInteriorPoint = function getFlatInteriorPoint () {
      if (this.flatInteriorPointRevision_ != this.getRevision()) {
        var flatCenter = getCenter(this.getExtent());
        this.flatInteriorPoint_ = getInteriorPointOfArray(
          this.getOrientedFlatCoordinates(), 0, this.ends_, this.stride,
          flatCenter, 0);
        this.flatInteriorPointRevision_ = this.getRevision();
      }
      return this.flatInteriorPoint_;
    };

    /**
     * Return an interior point of the polygon.
     * @return {Point} Interior point as XYM coordinate, where M is the
     * length of the horizontal intersection that the point belongs to.
     * @api
     */
    Polygon.prototype.getInteriorPoint = function getInteriorPoint () {
      return new Point(this.getFlatInteriorPoint(), GeometryLayout.XYM);
    };

    /**
     * Return the number of rings of the polygon,  this includes the exterior
     * ring and any interior rings.
     *
     * @return {number} Number of rings.
     * @api
     */
    Polygon.prototype.getLinearRingCount = function getLinearRingCount () {
      return this.ends_.length;
    };

    /**
     * Return the Nth linear ring of the polygon geometry. Return `null` if the
     * given index is out of range.
     * The exterior linear ring is available at index `0` and the interior rings
     * at index `1` and beyond.
     *
     * @param {number} index Index.
     * @return {LinearRing} Linear ring.
     * @api
     */
    Polygon.prototype.getLinearRing = function getLinearRing (index) {
      if (index < 0 || this.ends_.length <= index) {
        return null;
      }
      return new LinearRing(this.flatCoordinates.slice(
        index === 0 ? 0 : this.ends_[index - 1], this.ends_[index]), this.layout);
    };

    /**
     * Return the linear rings of the polygon.
     * @return {Array<LinearRing>} Linear rings.
     * @api
     */
    Polygon.prototype.getLinearRings = function getLinearRings () {
      var layout = this.layout;
      var flatCoordinates = this.flatCoordinates;
      var ends = this.ends_;
      var linearRings$$1 = [];
      var offset$$1 = 0;
      for (var i = 0, ii = ends.length; i < ii; ++i) {
        var end = ends[i];
        var linearRing$$1 = new LinearRing(flatCoordinates.slice(offset$$1, end), layout);
        linearRings$$1.push(linearRing$$1);
        offset$$1 = end;
      }
      return linearRings$$1;
    };

    /**
     * @return {Array<number>} Oriented flat coordinates.
     */
    Polygon.prototype.getOrientedFlatCoordinates = function getOrientedFlatCoordinates () {
      if (this.orientedRevision_ != this.getRevision()) {
        var flatCoordinates = this.flatCoordinates;
        if (linearRingIsOriented(
          flatCoordinates, 0, this.ends_, this.stride)) {
          this.orientedFlatCoordinates_ = flatCoordinates;
        } else {
          this.orientedFlatCoordinates_ = flatCoordinates.slice();
          this.orientedFlatCoordinates_.length =
              orientLinearRings(
                this.orientedFlatCoordinates_, 0, this.ends_, this.stride);
        }
        this.orientedRevision_ = this.getRevision();
      }
      return this.orientedFlatCoordinates_;
    };

    /**
     * @inheritDoc
     */
    Polygon.prototype.getSimplifiedGeometryInternal = function getSimplifiedGeometryInternal (squaredTolerance) {
      var simplifiedFlatCoordinates = [];
      var simplifiedEnds = [];
      simplifiedFlatCoordinates.length = quantizeArray(
        this.flatCoordinates, 0, this.ends_, this.stride,
        Math.sqrt(squaredTolerance),
        simplifiedFlatCoordinates, 0, simplifiedEnds);
      return new Polygon(simplifiedFlatCoordinates, GeometryLayout.XY, simplifiedEnds);
    };

    /**
     * @inheritDoc
     * @api
     */
    Polygon.prototype.getType = function getType () {
      return GeometryType.POLYGON;
    };

    /**
     * @inheritDoc
     * @api
     */
    Polygon.prototype.intersectsExtent = function intersectsExtent (extent) {
      return intersectsLinearRingArray(
        this.getOrientedFlatCoordinates(), 0, this.ends_, this.stride, extent);
    };

    /**
     * Set the coordinates of the polygon.
     * @param {!Array<Array<import("../coordinate.js").Coordinate>>} coordinates Coordinates.
     * @param {GeometryLayout=} opt_layout Layout.
     * @override
     * @api
     */
    Polygon.prototype.setCoordinates = function setCoordinates (coordinates, opt_layout) {
      this.setLayout(opt_layout, coordinates, 2);
      if (!this.flatCoordinates) {
        this.flatCoordinates = [];
      }
      var ends = deflateCoordinatesArray(
        this.flatCoordinates, 0, coordinates, this.stride, this.ends_);
      this.flatCoordinates.length = ends.length === 0 ? 0 : ends[ends.length - 1];
      this.changed();
    };

    return Polygon;
  }(SimpleGeometry));


  /**
   * Create a polygon from an extent. The layout used is `XY`.
   * @param {import("../extent.js").Extent} extent The extent.
   * @return {Polygon} The polygon.
   * @api
   */
  function fromExtent(extent) {
    var minX = extent[0];
    var minY = extent[1];
    var maxX = extent[2];
    var maxY = extent[3];
    var flatCoordinates =
        [minX, minY, minX, maxY, maxX, maxY, maxX, minY, minX, minY];
    return new Polygon(flatCoordinates, GeometryLayout.XY, [flatCoordinates.length]);
  }


  /**
   * Create a regular polygon from a circle.
   * @param {import("./Circle.js").default} circle Circle geometry.
   * @param {number=} opt_sides Number of sides of the polygon. Default is 32.
   * @param {number=} opt_angle Start angle for the first vertex of the polygon in
   *     radians. Default is 0.
   * @return {Polygon} Polygon geometry.
   * @api
   */
  function fromCircle(circle, opt_sides, opt_angle) {
    var sides = opt_sides ? opt_sides : 32;
    var stride = circle.getStride();
    var layout = circle.getLayout();
    var center = circle.getCenter();
    var arrayLength = stride * (sides + 1);
    var flatCoordinates = new Array(arrayLength);
    for (var i = 0; i < arrayLength; i += stride) {
      flatCoordinates[i] = 0;
      flatCoordinates[i + 1] = 0;
      for (var j = 2; j < stride; j++) {
        flatCoordinates[i + j] = center[j];
      }
    }
    var ends = [flatCoordinates.length];
    var polygon = new Polygon(flatCoordinates, layout, ends);
    makeRegular(polygon, center, circle.getRadius(), opt_angle);
    return polygon;
  }


  /**
   * Modify the coordinates of a polygon to make it a regular polygon.
   * @param {Polygon} polygon Polygon geometry.
   * @param {import("../coordinate.js").Coordinate} center Center of the regular polygon.
   * @param {number} radius Radius of the regular polygon.
   * @param {number=} opt_angle Start angle for the first vertex of the polygon in
   *     radians. Default is 0.
   */
  function makeRegular(polygon, center, radius, opt_angle) {
    var flatCoordinates = polygon.getFlatCoordinates();
    var stride = polygon.getStride();
    var sides = flatCoordinates.length / stride - 1;
    var startAngle = opt_angle ? opt_angle : 0;
    for (var i = 0; i <= sides; ++i) {
      var offset$$1 = i * stride;
      var angle = startAngle + (modulo(i, sides) * 2 * Math.PI / sides);
      flatCoordinates[offset$$1] = center[0] + (radius * Math.cos(angle));
      flatCoordinates[offset$$1 + 1] = center[1] + (radius * Math.sin(angle));
    }
    polygon.changed();
  }

  /**
   * @module ol/View
   */


  /**
   * An animation configuration
   *
   * @typedef {Object} Animation
   * @property {import("./coordinate.js").Coordinate} [sourceCenter]
   * @property {import("./coordinate.js").Coordinate} [targetCenter]
   * @property {number} [sourceResolution]
   * @property {number} [targetResolution]
   * @property {number} [sourceRotation]
   * @property {number} [targetRotation]
   * @property {import("./coordinate.js").Coordinate} [anchor]
   * @property {number} start
   * @property {number} duration
   * @property {boolean} complete
   * @property {function(number):number} easing
   * @property {function(boolean)} callback
   */


  /**
   * @typedef {Object} Constraints
   * @property {import("./centerconstraint.js").Type} center
   * @property {import("./resolutionconstraint.js").Type} resolution
   * @property {import("./rotationconstraint.js").Type} rotation
   */


  /**
   * @typedef {Object} FitOptions
   * @property {import("./size.js").Size} [size] The size in pixels of the box to fit
   * the extent into. Default is the current size of the first map in the DOM that
   * uses this view, or `[100, 100]` if no such map is found.
   * @property {!Array<number>} [padding=[0, 0, 0, 0]] Padding (in pixels) to be
   * cleared inside the view. Values in the array are top, right, bottom and left
   * padding.
   * @property {boolean} [constrainResolution=true] Constrain the resolution.
   * @property {boolean} [nearest=false] If `constrainResolution` is `true`, get
   * the nearest extent instead of the closest that actually fits the view.
   * @property {number} [minResolution=0] Minimum resolution that we zoom to.
   * @property {number} [maxZoom] Maximum zoom level that we zoom to. If
   * `minResolution` is given, this property is ignored.
   * @property {number} [duration] The duration of the animation in milliseconds.
   * By default, there is no animation to the target extent.
   * @property {function(number):number} [easing] The easing function used during
   * the animation (defaults to {@link module:ol/easing~inAndOut}).
   * The function will be called for each frame with a number representing a
   * fraction of the animation's duration.  The function should return a number
   * between 0 and 1 representing the progress toward the destination state.
   * @property {function(boolean)} [callback] Function called when the view is in
   * its final position. The callback will be called with `true` if the animation
   * series completed on its own or `false` if it was cancelled.
   */


  /**
   * @typedef {Object} ViewOptions
   * @property {import("./coordinate.js").Coordinate} [center] The initial center for
   * the view. The coordinate system for the center is specified with the
   * `projection` option. Layer sources will not be fetched if this is not set,
   * but the center can be set later with {@link #setCenter}.
   * @property {boolean|number} [constrainRotation=true] Rotation constraint.
   * `false` means no constraint. `true` means no constraint, but snap to zero
   * near zero. A number constrains the rotation to that number of values. For
   * example, `4` will constrain the rotation to 0, 90, 180, and 270 degrees.
   * @property {boolean} [enableRotation=true] Enable rotation.
   * If `false`, a rotation constraint that always sets the rotation to zero is
   * used. The `constrainRotation` option has no effect if `enableRotation` is
   * `false`.
   * @property {import("./extent.js").Extent} [extent] The extent that constrains the
   * center, in other words, center cannot be set outside this extent.
   * @property {number} [maxResolution] The maximum resolution used to determine
   * the resolution constraint. It is used together with `minResolution` (or
   * `maxZoom`) and `zoomFactor`. If unspecified it is calculated in such a way
   * that the projection's validity extent fits in a 256x256 px tile. If the
   * projection is Spherical Mercator (the default) then `maxResolution` defaults
   * to `40075016.68557849 / 256 = 156543.03392804097`.
   * @property {number} [minResolution] The minimum resolution used to determine
   * the resolution constraint.  It is used together with `maxResolution` (or
   * `minZoom`) and `zoomFactor`.  If unspecified it is calculated assuming 29
   * zoom levels (with a factor of 2). If the projection is Spherical Mercator
   * (the default) then `minResolution` defaults to
   * `40075016.68557849 / 256 / Math.pow(2, 28) = 0.0005831682455839253`.
   * @property {number} [maxZoom=28] The maximum zoom level used to determine the
   * resolution constraint. It is used together with `minZoom` (or
   * `maxResolution`) and `zoomFactor`.  Note that if `minResolution` is also
   * provided, it is given precedence over `maxZoom`.
   * @property {number} [minZoom=0] The minimum zoom level used to determine the
   * resolution constraint. It is used together with `maxZoom` (or
   * `minResolution`) and `zoomFactor`.  Note that if `maxResolution` is also
   * provided, it is given precedence over `minZoom`.
   * @property {import("./proj.js").ProjectionLike} [projection='EPSG:3857'] The
   * projection. The default is Spherical Mercator.
   * @property {number} [resolution] The initial resolution for the view. The
   * units are `projection` units per pixel (e.g. meters per pixel). An
   * alternative to setting this is to set `zoom`. Layer sources will not be
   * fetched if neither this nor `zoom` are defined, but they can be set later
   * with {@link #setZoom} or {@link #setResolution}.
   * @property {Array<number>} [resolutions] Resolutions to determine the
   * resolution constraint. If set the `maxResolution`, `minResolution`,
   * `minZoom`, `maxZoom`, and `zoomFactor` options are ignored.
   * @property {number} [rotation=0] The initial rotation for the view in radians
   * (positive rotation clockwise, 0 means North).
   * @property {number} [zoom] Only used if `resolution` is not defined. Zoom
   * level used to calculate the initial resolution for the view. The initial
   * resolution is determined using the {@link #constrainResolution} method.
   * @property {number} [zoomFactor=2] The zoom factor used to determine the
   * resolution constraint.
   */


  /**
   * @typedef {Object} AnimationOptions
   * @property {import("./coordinate.js").Coordinate} [center] The center of the view at the end of
   * the animation.
   * @property {number} [zoom] The zoom level of the view at the end of the
   * animation. This takes precedence over `resolution`.
   * @property {number} [resolution] The resolution of the view at the end
   * of the animation.  If `zoom` is also provided, this option will be ignored.
   * @property {number} [rotation] The rotation of the view at the end of
   * the animation.
   * @property {import("./coordinate.js").Coordinate} [anchor] Optional anchor to remained fixed
   * during a rotation or resolution animation.
   * @property {number} [duration=1000] The duration of the animation in milliseconds.
   * @property {function(number):number} [easing] The easing function used
   * during the animation (defaults to {@link module:ol/easing~inAndOut}).
   * The function will be called for each frame with a number representing a
   * fraction of the animation's duration.  The function should return a number
   * between 0 and 1 representing the progress toward the destination state.
   */


  /**
   * @typedef {Object} State
   * @property {import("./coordinate.js").Coordinate} center
   * @property {import("./proj/Projection.js").default} projection
   * @property {number} resolution
   * @property {number} rotation
   * @property {number} zoom
   */


  /**
   * Default min zoom level for the map view.
   * @type {number}
   */
  var DEFAULT_MIN_ZOOM = 0;


  /**
   * @classdesc
   * A View object represents a simple 2D view of the map.
   *
   * This is the object to act upon to change the center, resolution,
   * and rotation of the map.
   *
   * ### The view states
   *
   * An View is determined by three states: `center`, `resolution`,
   * and `rotation`. Each state has a corresponding getter and setter, e.g.
   * `getCenter` and `setCenter` for the `center` state.
   *
   * An View has a `projection`. The projection determines the
   * coordinate system of the center, and its units determine the units of the
   * resolution (projection units per pixel). The default projection is
   * Spherical Mercator (EPSG:3857).
   *
   * ### The constraints
   *
   * `setCenter`, `setResolution` and `setRotation` can be used to change the
   * states of the view. Any value can be passed to the setters. And the value
   * that is passed to a setter will effectively be the value set in the view,
   * and returned by the corresponding getter.
   *
   * But a View object also has a *resolution constraint*, a
   * *rotation constraint* and a *center constraint*.
   *
   * As said above, no constraints are applied when the setters are used to set
   * new states for the view. Applying constraints is done explicitly through
   * the use of the `constrain*` functions (`constrainResolution` and
   * `constrainRotation` and `constrainCenter`).
   *
   * The main users of the constraints are the interactions and the
   * controls. For example, double-clicking on the map changes the view to
   * the "next" resolution. And releasing the fingers after pinch-zooming
   * snaps to the closest resolution (with an animation).
   *
   * The *resolution constraint* snaps to specific resolutions. It is
   * determined by the following options: `resolutions`, `maxResolution`,
   * `maxZoom`, and `zoomFactor`. If `resolutions` is set, the other three
   * options are ignored. See documentation for each option for more
   * information.
   *
   * The *rotation constraint* snaps to specific angles. It is determined
   * by the following options: `enableRotation` and `constrainRotation`.
   * By default the rotation value is snapped to zero when approaching the
   * horizontal.
   *
   * The *center constraint* is determined by the `extent` option. By
   * default the center is not constrained at all.
   *
    * @api
   */
  var View = /*@__PURE__*/(function (BaseObject$$1) {
    function View(opt_options) {
      BaseObject$$1.call(this);

      var options = assign({}, opt_options);

      /**
       * @private
       * @type {Array<number>}
       */
      this.hints_ = [0, 0];

      /**
       * @private
       * @type {Array<Array<Animation>>}
       */
      this.animations_ = [];

      /**
       * @private
       * @type {number|undefined}
       */
      this.updateAnimationKey_;

      this.updateAnimations_ = this.updateAnimations_.bind(this);

      /**
       * @private
       * @const
       * @type {import("./proj/Projection.js").default}
       */
      this.projection_ = createProjection(options.projection, 'EPSG:3857');

      this.applyOptions_(options);
    }

    if ( BaseObject$$1 ) View.__proto__ = BaseObject$$1;
    View.prototype = Object.create( BaseObject$$1 && BaseObject$$1.prototype );
    View.prototype.constructor = View;

    /**
     * Set up the view with the given options.
     * @param {ViewOptions} options View options.
     */
    View.prototype.applyOptions_ = function applyOptions_ (options) {

      /**
       * @type {Object<string, *>}
       */
      var properties = {};
      properties[ViewProperty.CENTER] = options.center !== undefined ?
        options.center : null;

      var resolutionConstraintInfo = createResolutionConstraint(options);

      /**
       * @private
       * @type {number}
       */
      this.maxResolution_ = resolutionConstraintInfo.maxResolution;

      /**
       * @private
       * @type {number}
       */
      this.minResolution_ = resolutionConstraintInfo.minResolution;

      /**
       * @private
       * @type {number}
       */
      this.zoomFactor_ = resolutionConstraintInfo.zoomFactor;

      /**
       * @private
       * @type {Array<number>|undefined}
       */
      this.resolutions_ = options.resolutions;

      /**
       * @private
       * @type {number}
       */
      this.minZoom_ = resolutionConstraintInfo.minZoom;

      var centerConstraint = createCenterConstraint(options);
      var resolutionConstraint = resolutionConstraintInfo.constraint;
      var rotationConstraint = createRotationConstraint(options);

      /**
       * @private
       * @type {Constraints}
       */
      this.constraints_ = {
        center: centerConstraint,
        resolution: resolutionConstraint,
        rotation: rotationConstraint
      };

      if (options.resolution !== undefined) {
        properties[ViewProperty.RESOLUTION] = options.resolution;
      } else if (options.zoom !== undefined) {
        properties[ViewProperty.RESOLUTION] = this.constrainResolution(
          this.maxResolution_, options.zoom - this.minZoom_);

        if (this.resolutions_) { // in case map zoom is out of min/max zoom range
          properties[ViewProperty.RESOLUTION] = clamp(
            Number(this.getResolution() || properties[ViewProperty.RESOLUTION]),
            this.minResolution_, this.maxResolution_);
        }
      }
      properties[ViewProperty.ROTATION] = options.rotation !== undefined ? options.rotation : 0;
      this.setProperties(properties);

      /**
       * @private
       * @type {ViewOptions}
       */
      this.options_ = options;

    };

    /**
     * Get an updated version of the view options used to construct the view.  The
     * current resolution (or zoom), center, and rotation are applied to any stored
     * options.  The provided options can be used to apply new min/max zoom or
     * resolution limits.
     * @param {ViewOptions} newOptions New options to be applied.
     * @return {ViewOptions} New options updated with the current view state.
     */
    View.prototype.getUpdatedOptions_ = function getUpdatedOptions_ (newOptions) {
      var options = assign({}, this.options_);

      // preserve resolution (or zoom)
      if (options.resolution !== undefined) {
        options.resolution = this.getResolution();
      } else {
        options.zoom = this.getZoom();
      }

      // preserve center
      options.center = this.getCenter();

      // preserve rotation
      options.rotation = this.getRotation();

      return assign({}, options, newOptions);
    };

    /**
     * Animate the view.  The view's center, zoom (or resolution), and rotation
     * can be animated for smooth transitions between view states.  For example,
     * to animate the view to a new zoom level:
     *
     *     view.animate({zoom: view.getZoom() + 1});
     *
     * By default, the animation lasts one second and uses in-and-out easing.  You
     * can customize this behavior by including `duration` (in milliseconds) and
     * `easing` options (see {@link module:ol/easing}).
     *
     * To chain together multiple animations, call the method with multiple
     * animation objects.  For example, to first zoom and then pan:
     *
     *     view.animate({zoom: 10}, {center: [0, 0]});
     *
     * If you provide a function as the last argument to the animate method, it
     * will get called at the end of an animation series.  The callback will be
     * called with `true` if the animation series completed on its own or `false`
     * if it was cancelled.
     *
     * Animations are cancelled by user interactions (e.g. dragging the map) or by
     * calling `view.setCenter()`, `view.setResolution()`, or `view.setRotation()`
     * (or another method that calls one of these).
     *
     * @param {...(AnimationOptions|function(boolean))} var_args Animation
     *     options.  Multiple animations can be run in series by passing multiple
     *     options objects.  To run multiple animations in parallel, call the method
     *     multiple times.  An optional callback can be provided as a final
     *     argument.  The callback will be called with a boolean indicating whether
     *     the animation completed without being cancelled.
     * @api
     */
    View.prototype.animate = function animate (var_args) {
      var arguments$1 = arguments;

      var animationCount = arguments.length;
      var callback;
      if (animationCount > 1 && typeof arguments[animationCount - 1] === 'function') {
        callback = arguments[animationCount - 1];
        --animationCount;
      }
      if (!this.isDef()) {
        // if view properties are not yet set, shortcut to the final state
        var state = arguments[animationCount - 1];
        if (state.center) {
          this.setCenter(state.center);
        }
        if (state.zoom !== undefined) {
          this.setZoom(state.zoom);
        }
        if (state.rotation !== undefined) {
          this.setRotation(state.rotation);
        }
        if (callback) {
          animationCallback(callback, true);
        }
        return;
      }
      var start = Date.now();
      var center = this.getCenter().slice();
      var resolution = this.getResolution();
      var rotation = this.getRotation();
      var series = [];
      for (var i = 0; i < animationCount; ++i) {
        var options = /** @type {AnimationOptions} */ (arguments$1[i]);

        var animation = /** @type {Animation} */ ({
          start: start,
          complete: false,
          anchor: options.anchor,
          duration: options.duration !== undefined ? options.duration : 1000,
          easing: options.easing || inAndOut
        });

        if (options.center) {
          animation.sourceCenter = center;
          animation.targetCenter = options.center;
          center = animation.targetCenter;
        }

        if (options.zoom !== undefined) {
          animation.sourceResolution = resolution;
          animation.targetResolution = this.constrainResolution(
            this.maxResolution_, options.zoom - this.minZoom_, 0);
          resolution = animation.targetResolution;
        } else if (options.resolution) {
          animation.sourceResolution = resolution;
          animation.targetResolution = options.resolution;
          resolution = animation.targetResolution;
        }

        if (options.rotation !== undefined) {
          animation.sourceRotation = rotation;
          var delta = modulo(options.rotation - rotation + Math.PI, 2 * Math.PI) - Math.PI;
          animation.targetRotation = rotation + delta;
          rotation = animation.targetRotation;
        }

        animation.callback = callback;

        // check if animation is a no-op
        if (isNoopAnimation(animation)) {
          animation.complete = true;
          // we still push it onto the series for callback handling
        } else {
          start += animation.duration;
        }
        series.push(animation);
      }
      this.animations_.push(series);
      this.setHint(ViewHint.ANIMATING, 1);
      this.updateAnimations_();
    };

    /**
     * Determine if the view is being animated.
     * @return {boolean} The view is being animated.
     * @api
     */
    View.prototype.getAnimating = function getAnimating () {
      return this.hints_[ViewHint.ANIMATING] > 0;
    };

    /**
     * Determine if the user is interacting with the view, such as panning or zooming.
     * @return {boolean} The view is being interacted with.
     * @api
     */
    View.prototype.getInteracting = function getInteracting () {
      return this.hints_[ViewHint.INTERACTING] > 0;
    };

    /**
     * Cancel any ongoing animations.
     * @api
     */
    View.prototype.cancelAnimations = function cancelAnimations () {
      this.setHint(ViewHint.ANIMATING, -this.hints_[ViewHint.ANIMATING]);
      for (var i = 0, ii = this.animations_.length; i < ii; ++i) {
        var series = this.animations_[i];
        if (series[0].callback) {
          animationCallback(series[0].callback, false);
        }
      }
      this.animations_.length = 0;
    };

    /**
     * Update all animations.
     */
    View.prototype.updateAnimations_ = function updateAnimations_ () {
      if (this.updateAnimationKey_ !== undefined) {
        cancelAnimationFrame(this.updateAnimationKey_);
        this.updateAnimationKey_ = undefined;
      }
      if (!this.getAnimating()) {
        return;
      }
      var now = Date.now();
      var more = false;
      for (var i = this.animations_.length - 1; i >= 0; --i) {
        var series = this.animations_[i];
        var seriesComplete = true;
        for (var j = 0, jj = series.length; j < jj; ++j) {
          var animation = series[j];
          if (animation.complete) {
            continue;
          }
          var elapsed = now - animation.start;
          var fraction = animation.duration > 0 ? elapsed / animation.duration : 1;
          if (fraction >= 1) {
            animation.complete = true;
            fraction = 1;
          } else {
            seriesComplete = false;
          }
          var progress = animation.easing(fraction);
          if (animation.sourceCenter) {
            var x0 = animation.sourceCenter[0];
            var y0 = animation.sourceCenter[1];
            var x1 = animation.targetCenter[0];
            var y1 = animation.targetCenter[1];
            var x = x0 + progress * (x1 - x0);
            var y = y0 + progress * (y1 - y0);
            this.set(ViewProperty.CENTER, [x, y]);
          }
          if (animation.sourceResolution && animation.targetResolution) {
            var resolution = progress === 1 ?
              animation.targetResolution :
              animation.sourceResolution + progress * (animation.targetResolution - animation.sourceResolution);
            if (animation.anchor) {
              this.set(ViewProperty.CENTER,
                this.calculateCenterZoom(resolution, animation.anchor));
            }
            this.set(ViewProperty.RESOLUTION, resolution);
          }
          if (animation.sourceRotation !== undefined && animation.targetRotation !== undefined) {
            var rotation = progress === 1 ?
              modulo(animation.targetRotation + Math.PI, 2 * Math.PI) - Math.PI :
              animation.sourceRotation + progress * (animation.targetRotation - animation.sourceRotation);
            if (animation.anchor) {
              this.set(ViewProperty.CENTER,
                this.calculateCenterRotate(rotation, animation.anchor));
            }
            this.set(ViewProperty.ROTATION, rotation);
          }
          more = true;
          if (!animation.complete) {
            break;
          }
        }
        if (seriesComplete) {
          this.animations_[i] = null;
          this.setHint(ViewHint.ANIMATING, -1);
          var callback = series[0].callback;
          if (callback) {
            animationCallback(callback, true);
          }
        }
      }
      // prune completed series
      this.animations_ = this.animations_.filter(Boolean);
      if (more && this.updateAnimationKey_ === undefined) {
        this.updateAnimationKey_ = requestAnimationFrame(this.updateAnimations_);
      }
    };

    /**
     * @param {number} rotation Target rotation.
     * @param {import("./coordinate.js").Coordinate} anchor Rotation anchor.
     * @return {import("./coordinate.js").Coordinate|undefined} Center for rotation and anchor.
     */
    View.prototype.calculateCenterRotate = function calculateCenterRotate (rotation, anchor) {
      var center;
      var currentCenter = this.getCenter();
      if (currentCenter !== undefined) {
        center = [currentCenter[0] - anchor[0], currentCenter[1] - anchor[1]];
        rotate(center, rotation - this.getRotation());
        add(center, anchor);
      }
      return center;
    };

    /**
     * @param {number} resolution Target resolution.
     * @param {import("./coordinate.js").Coordinate} anchor Zoom anchor.
     * @return {import("./coordinate.js").Coordinate|undefined} Center for resolution and anchor.
     */
    View.prototype.calculateCenterZoom = function calculateCenterZoom (resolution, anchor) {
      var center;
      var currentCenter = this.getCenter();
      var currentResolution = this.getResolution();
      if (currentCenter !== undefined && currentResolution !== undefined) {
        var x = anchor[0] - resolution * (anchor[0] - currentCenter[0]) / currentResolution;
        var y = anchor[1] - resolution * (anchor[1] - currentCenter[1]) / currentResolution;
        center = [x, y];
      }
      return center;
    };

    /**
     * @private
     * @return {import("./size.js").Size} Viewport size or `[100, 100]` when no viewport is found.
     */
    View.prototype.getSizeFromViewport_ = function getSizeFromViewport_ () {
      var size = [100, 100];
      var selector = '.ol-viewport[data-view="' + getUid(this) + '"]';
      var element = document.querySelector(selector);
      if (element) {
        var metrics = getComputedStyle(element);
        size[0] = parseInt(metrics.width, 10);
        size[1] = parseInt(metrics.height, 10);
      }
      return size;
    };

    /**
     * Get the constrained center of this view.
     * @param {import("./coordinate.js").Coordinate|undefined} center Center.
     * @return {import("./coordinate.js").Coordinate|undefined} Constrained center.
     * @api
     */
    View.prototype.constrainCenter = function constrainCenter (center) {
      return this.constraints_.center(center);
    };

    /**
     * Get the constrained resolution of this view.
     * @param {number|undefined} resolution Resolution.
     * @param {number=} opt_delta Delta. Default is `0`.
     * @param {number=} opt_direction Direction. Default is `0`.
     * @return {number|undefined} Constrained resolution.
     * @api
     */
    View.prototype.constrainResolution = function constrainResolution (resolution, opt_delta, opt_direction) {
      var delta = opt_delta || 0;
      var direction = opt_direction || 0;
      return this.constraints_.resolution(resolution, delta, direction);
    };

    /**
     * Get the constrained rotation of this view.
     * @param {number|undefined} rotation Rotation.
     * @param {number=} opt_delta Delta. Default is `0`.
     * @return {number|undefined} Constrained rotation.
     * @api
     */
    View.prototype.constrainRotation = function constrainRotation (rotation, opt_delta) {
      var delta = opt_delta || 0;
      return this.constraints_.rotation(rotation, delta);
    };

    /**
     * Get the view center.
     * @return {import("./coordinate.js").Coordinate|undefined} The center of the view.
     * @observable
     * @api
     */
    View.prototype.getCenter = function getCenter$$1 () {
      return (
        /** @type {import("./coordinate.js").Coordinate|undefined} */ (this.get(ViewProperty.CENTER))
      );
    };

    /**
     * @return {Constraints} Constraints.
     */
    View.prototype.getConstraints = function getConstraints () {
      return this.constraints_;
    };

    /**
     * @param {Array<number>=} opt_hints Destination array.
     * @return {Array<number>} Hint.
     */
    View.prototype.getHints = function getHints (opt_hints) {
      if (opt_hints !== undefined) {
        opt_hints[0] = this.hints_[0];
        opt_hints[1] = this.hints_[1];
        return opt_hints;
      } else {
        return this.hints_.slice();
      }
    };

    /**
     * Calculate the extent for the current view state and the passed size.
     * The size is the pixel dimensions of the box into which the calculated extent
     * should fit. In most cases you want to get the extent of the entire map,
     * that is `map.getSize()`.
     * @param {import("./size.js").Size=} opt_size Box pixel size. If not provided, the size of the
     * first map that uses this view will be used.
     * @return {import("./extent.js").Extent} Extent.
     * @api
     */
    View.prototype.calculateExtent = function calculateExtent (opt_size) {
      var size = opt_size || this.getSizeFromViewport_();
      var center = /** @type {!import("./coordinate.js").Coordinate} */ (this.getCenter());
      assert(center, 1); // The view center is not defined
      var resolution = /** @type {!number} */ (this.getResolution());
      assert(resolution !== undefined, 2); // The view resolution is not defined
      var rotation = /** @type {!number} */ (this.getRotation());
      assert(rotation !== undefined, 3); // The view rotation is not defined

      return getForViewAndSize(center, resolution, rotation, size);
    };

    /**
     * Get the maximum resolution of the view.
     * @return {number} The maximum resolution of the view.
     * @api
     */
    View.prototype.getMaxResolution = function getMaxResolution () {
      return this.maxResolution_;
    };

    /**
     * Get the minimum resolution of the view.
     * @return {number} The minimum resolution of the view.
     * @api
     */
    View.prototype.getMinResolution = function getMinResolution () {
      return this.minResolution_;
    };

    /**
     * Get the maximum zoom level for the view.
     * @return {number} The maximum zoom level.
     * @api
     */
    View.prototype.getMaxZoom = function getMaxZoom () {
      return /** @type {number} */ (this.getZoomForResolution(this.minResolution_));
    };

    /**
     * Set a new maximum zoom level for the view.
     * @param {number} zoom The maximum zoom level.
     * @api
     */
    View.prototype.setMaxZoom = function setMaxZoom (zoom) {
      this.applyOptions_(this.getUpdatedOptions_({maxZoom: zoom}));
    };

    /**
     * Get the minimum zoom level for the view.
     * @return {number} The minimum zoom level.
     * @api
     */
    View.prototype.getMinZoom = function getMinZoom () {
      return /** @type {number} */ (this.getZoomForResolution(this.maxResolution_));
    };

    /**
     * Set a new minimum zoom level for the view.
     * @param {number} zoom The minimum zoom level.
     * @api
     */
    View.prototype.setMinZoom = function setMinZoom (zoom) {
      this.applyOptions_(this.getUpdatedOptions_({minZoom: zoom}));
    };

    /**
     * Get the view projection.
     * @return {import("./proj/Projection.js").default} The projection of the view.
     * @api
     */
    View.prototype.getProjection = function getProjection () {
      return this.projection_;
    };

    /**
     * Get the view resolution.
     * @return {number|undefined} The resolution of the view.
     * @observable
     * @api
     */
    View.prototype.getResolution = function getResolution () {
      return /** @type {number|undefined} */ (this.get(ViewProperty.RESOLUTION));
    };

    /**
     * Get the resolutions for the view. This returns the array of resolutions
     * passed to the constructor of the View, or undefined if none were given.
     * @return {Array<number>|undefined} The resolutions of the view.
     * @api
     */
    View.prototype.getResolutions = function getResolutions () {
      return this.resolutions_;
    };

    /**
     * Get the resolution for a provided extent (in map units) and size (in pixels).
     * @param {import("./extent.js").Extent} extent Extent.
     * @param {import("./size.js").Size=} opt_size Box pixel size.
     * @return {number} The resolution at which the provided extent will render at
     *     the given size.
     * @api
     */
    View.prototype.getResolutionForExtent = function getResolutionForExtent (extent, opt_size) {
      var size = opt_size || this.getSizeFromViewport_();
      var xResolution = getWidth(extent) / size[0];
      var yResolution = getHeight(extent) / size[1];
      return Math.max(xResolution, yResolution);
    };

    /**
     * Return a function that returns a value between 0 and 1 for a
     * resolution. Exponential scaling is assumed.
     * @param {number=} opt_power Power.
     * @return {function(number): number} Resolution for value function.
     */
    View.prototype.getResolutionForValueFunction = function getResolutionForValueFunction (opt_power) {
      var power = opt_power || 2;
      var maxResolution = this.maxResolution_;
      var minResolution = this.minResolution_;
      var max = Math.log(maxResolution / minResolution) / Math.log(power);
      return (
        /**
         * @param {number} value Value.
         * @return {number} Resolution.
         */
        function(value) {
          var resolution = maxResolution / Math.pow(power, value * max);
          return resolution;
        });
    };

    /**
     * Get the view rotation.
     * @return {number} The rotation of the view in radians.
     * @observable
     * @api
     */
    View.prototype.getRotation = function getRotation () {
      return /** @type {number} */ (this.get(ViewProperty.ROTATION));
    };

    /**
     * Return a function that returns a resolution for a value between
     * 0 and 1. Exponential scaling is assumed.
     * @param {number=} opt_power Power.
     * @return {function(number): number} Value for resolution function.
     */
    View.prototype.getValueForResolutionFunction = function getValueForResolutionFunction (opt_power) {
      var power = opt_power || 2;
      var maxResolution = this.maxResolution_;
      var minResolution = this.minResolution_;
      var max = Math.log(maxResolution / minResolution) / Math.log(power);
      return (
        /**
         * @param {number} resolution Resolution.
         * @return {number} Value.
         */
        function(resolution) {
          var value = (Math.log(maxResolution / resolution) / Math.log(power)) / max;
          return value;
        });
    };

    /**
     * @param {number} pixelRatio Pixel ratio for center rounding.
     * @return {State} View state.
     */
    View.prototype.getState = function getState (pixelRatio) {
      var center = /** @type {import("./coordinate.js").Coordinate} */ (this.getCenter());
      var projection = this.getProjection();
      var resolution = /** @type {number} */ (this.getResolution());
      var pixelResolution = resolution / pixelRatio;
      var rotation = this.getRotation();
      return (
        /** @type {State} */ ({
          center: [
            Math.round(center[0] / pixelResolution) * pixelResolution,
            Math.round(center[1] / pixelResolution) * pixelResolution
          ],
          projection: projection !== undefined ? projection : null,
          resolution: resolution,
          rotation: rotation,
          zoom: this.getZoom()
        })
      );
    };

    /**
     * Get the current zoom level.  If you configured your view with a resolutions
     * array (this is rare), this method may return non-integer zoom levels (so
     * the zoom level is not safe to use as an index into a resolutions array).
     * @return {number|undefined} Zoom.
     * @api
     */
    View.prototype.getZoom = function getZoom () {
      var zoom;
      var resolution = this.getResolution();
      if (resolution !== undefined) {
        zoom = this.getZoomForResolution(resolution);
      }
      return zoom;
    };

    /**
     * Get the zoom level for a resolution.
     * @param {number} resolution The resolution.
     * @return {number|undefined} The zoom level for the provided resolution.
     * @api
     */
    View.prototype.getZoomForResolution = function getZoomForResolution (resolution) {
      var offset = this.minZoom_ || 0;
      var max, zoomFactor;
      if (this.resolutions_) {
        var nearest = linearFindNearest(this.resolutions_, resolution, 1);
        offset = nearest;
        max = this.resolutions_[nearest];
        if (nearest == this.resolutions_.length - 1) {
          zoomFactor = 2;
        } else {
          zoomFactor = max / this.resolutions_[nearest + 1];
        }
      } else {
        max = this.maxResolution_;
        zoomFactor = this.zoomFactor_;
      }
      return offset + Math.log(max / resolution) / Math.log(zoomFactor);
    };

    /**
     * Get the resolution for a zoom level.
     * @param {number} zoom Zoom level.
     * @return {number} The view resolution for the provided zoom level.
     * @api
     */
    View.prototype.getResolutionForZoom = function getResolutionForZoom (zoom) {
      return /** @type {number} */ (this.constrainResolution(
        this.maxResolution_, zoom - this.minZoom_, 0));
    };

    /**
     * Fit the given geometry or extent based on the given map size and border.
     * The size is pixel dimensions of the box to fit the extent into.
     * In most cases you will want to use the map size, that is `map.getSize()`.
     * Takes care of the map angle.
     * @param {import("./geom/SimpleGeometry.js").default|import("./extent.js").Extent} geometryOrExtent The geometry or
     *     extent to fit the view to.
     * @param {FitOptions=} opt_options Options.
     * @api
     */
    View.prototype.fit = function fit (geometryOrExtent, opt_options) {
      var options = opt_options || {};
      var size = options.size;
      if (!size) {
        size = this.getSizeFromViewport_();
      }
      /** @type {import("./geom/SimpleGeometry.js").default} */
      var geometry;
      assert(Array.isArray(geometryOrExtent) || typeof /** @type {?} */ (geometryOrExtent).getSimplifiedGeometry === 'function',
        24); // Invalid extent or geometry provided as `geometry`
      if (Array.isArray(geometryOrExtent)) {
        assert(!isEmpty$1(geometryOrExtent),
          25); // Cannot fit empty extent provided as `geometry`
        geometry = fromExtent(geometryOrExtent);
      } else if (geometryOrExtent.getType() === GeometryType.CIRCLE) {
        geometryOrExtent = geometryOrExtent.getExtent();
        geometry = fromExtent(geometryOrExtent);
        geometry.rotate(this.getRotation(), getCenter(geometryOrExtent));
      } else {
        geometry = geometryOrExtent;
      }

      var padding = options.padding !== undefined ? options.padding : [0, 0, 0, 0];
      var constrainResolution = options.constrainResolution !== undefined ?
        options.constrainResolution : true;
      var nearest = options.nearest !== undefined ? options.nearest : false;
      var minResolution;
      if (options.minResolution !== undefined) {
        minResolution = options.minResolution;
      } else if (options.maxZoom !== undefined) {
        minResolution = this.constrainResolution(
          this.maxResolution_, options.maxZoom - this.minZoom_, 0);
      } else {
        minResolution = 0;
      }
      var coords = geometry.getFlatCoordinates();

      // calculate rotated extent
      var rotation = this.getRotation();
      var cosAngle = Math.cos(-rotation);
      var sinAngle = Math.sin(-rotation);
      var minRotX = +Infinity;
      var minRotY = +Infinity;
      var maxRotX = -Infinity;
      var maxRotY = -Infinity;
      var stride = geometry.getStride();
      for (var i = 0, ii = coords.length; i < ii; i += stride) {
        var rotX = coords[i] * cosAngle - coords[i + 1] * sinAngle;
        var rotY = coords[i] * sinAngle + coords[i + 1] * cosAngle;
        minRotX = Math.min(minRotX, rotX);
        minRotY = Math.min(minRotY, rotY);
        maxRotX = Math.max(maxRotX, rotX);
        maxRotY = Math.max(maxRotY, rotY);
      }

      // calculate resolution
      var resolution = this.getResolutionForExtent(
        [minRotX, minRotY, maxRotX, maxRotY],
        [size[0] - padding[1] - padding[3], size[1] - padding[0] - padding[2]]);
      resolution = isNaN(resolution) ? minResolution :
        Math.max(resolution, minResolution);
      if (constrainResolution) {
        var constrainedResolution = this.constrainResolution(resolution, 0, 0);
        if (!nearest && constrainedResolution < resolution) {
          constrainedResolution = this.constrainResolution(
            constrainedResolution, -1, 0);
        }
        resolution = constrainedResolution;
      }

      // calculate center
      sinAngle = -sinAngle; // go back to original rotation
      var centerRotX = (minRotX + maxRotX) / 2;
      var centerRotY = (minRotY + maxRotY) / 2;
      centerRotX += (padding[1] - padding[3]) / 2 * resolution;
      centerRotY += (padding[0] - padding[2]) / 2 * resolution;
      var centerX = centerRotX * cosAngle - centerRotY * sinAngle;
      var centerY = centerRotY * cosAngle + centerRotX * sinAngle;
      var center = [centerX, centerY];
      var callback = options.callback ? options.callback : VOID;

      if (options.duration !== undefined) {
        this.animate({
          resolution: resolution,
          center: center,
          duration: options.duration,
          easing: options.easing
        }, callback);
      } else {
        this.setResolution(resolution);
        this.setCenter(center);
        animationCallback(callback, true);
      }
    };

    /**
     * Center on coordinate and view position.
     * @param {import("./coordinate.js").Coordinate} coordinate Coordinate.
     * @param {import("./size.js").Size} size Box pixel size.
     * @param {import("./pixel.js").Pixel} position Position on the view to center on.
     * @api
     */
    View.prototype.centerOn = function centerOn (coordinate, size, position) {
      // calculate rotated position
      var rotation = this.getRotation();
      var cosAngle = Math.cos(-rotation);
      var sinAngle = Math.sin(-rotation);
      var rotX = coordinate[0] * cosAngle - coordinate[1] * sinAngle;
      var rotY = coordinate[1] * cosAngle + coordinate[0] * sinAngle;
      var resolution = this.getResolution();
      rotX += (size[0] / 2 - position[0]) * resolution;
      rotY += (position[1] - size[1] / 2) * resolution;

      // go back to original angle
      sinAngle = -sinAngle; // go back to original rotation
      var centerX = rotX * cosAngle - rotY * sinAngle;
      var centerY = rotY * cosAngle + rotX * sinAngle;

      this.setCenter([centerX, centerY]);
    };

    /**
     * @return {boolean} Is defined.
     */
    View.prototype.isDef = function isDef () {
      return !!this.getCenter() && this.getResolution() !== undefined;
    };

    /**
     * Rotate the view around a given coordinate.
     * @param {number} rotation New rotation value for the view.
     * @param {import("./coordinate.js").Coordinate=} opt_anchor The rotation center.
     * @api
     */
    View.prototype.rotate = function rotate$$1 (rotation, opt_anchor) {
      if (opt_anchor !== undefined) {
        var center = this.calculateCenterRotate(rotation, opt_anchor);
        this.setCenter(center);
      }
      this.setRotation(rotation);
    };

    /**
     * Set the center of the current view.
     * @param {import("./coordinate.js").Coordinate|undefined} center The center of the view.
     * @observable
     * @api
     */
    View.prototype.setCenter = function setCenter (center) {
      this.set(ViewProperty.CENTER, center);
      if (this.getAnimating()) {
        this.cancelAnimations();
      }
    };

    /**
     * @param {ViewHint} hint Hint.
     * @param {number} delta Delta.
     * @return {number} New value.
     */
    View.prototype.setHint = function setHint (hint, delta) {
      this.hints_[hint] += delta;
      this.changed();
      return this.hints_[hint];
    };

    /**
     * Set the resolution for this view.
     * @param {number|undefined} resolution The resolution of the view.
     * @observable
     * @api
     */
    View.prototype.setResolution = function setResolution (resolution) {
      this.set(ViewProperty.RESOLUTION, resolution);
      if (this.getAnimating()) {
        this.cancelAnimations();
      }
    };

    /**
     * Set the rotation for this view.
     * @param {number} rotation The rotation of the view in radians.
     * @observable
     * @api
     */
    View.prototype.setRotation = function setRotation (rotation) {
      this.set(ViewProperty.ROTATION, rotation);
      if (this.getAnimating()) {
        this.cancelAnimations();
      }
    };

    /**
     * Zoom to a specific zoom level.
     * @param {number} zoom Zoom level.
     * @api
     */
    View.prototype.setZoom = function setZoom (zoom) {
      this.setResolution(this.getResolutionForZoom(zoom));
    };

    return View;
  }(BaseObject));


  /**
   * @param {Function} callback Callback.
   * @param {*} returnValue Return value.
   */
  function animationCallback(callback, returnValue) {
    setTimeout(function() {
      callback(returnValue);
    }, 0);
  }


  /**
   * @param {ViewOptions} options View options.
   * @return {import("./centerconstraint.js").Type} The constraint.
   */
  function createCenterConstraint(options) {
    if (options.extent !== undefined) {
      return createExtent(options.extent);
    } else {
      return none;
    }
  }


  /**
   * @param {ViewOptions} options View options.
   * @return {{constraint: import("./resolutionconstraint.js").Type, maxResolution: number,
   *     minResolution: number, minZoom: number, zoomFactor: number}} The constraint.
   */
  function createResolutionConstraint(options) {
    var resolutionConstraint;
    var maxResolution;
    var minResolution;

    // TODO: move these to be ol constants
    // see https://github.com/openlayers/openlayers/issues/2076
    var defaultMaxZoom = 28;
    var defaultZoomFactor = 2;

    var minZoom = options.minZoom !== undefined ?
      options.minZoom : DEFAULT_MIN_ZOOM;

    var maxZoom = options.maxZoom !== undefined ?
      options.maxZoom : defaultMaxZoom;

    var zoomFactor = options.zoomFactor !== undefined ?
      options.zoomFactor : defaultZoomFactor;

    if (options.resolutions !== undefined) {
      var resolutions = options.resolutions;
      maxResolution = resolutions[minZoom];
      minResolution = resolutions[maxZoom] !== undefined ?
        resolutions[maxZoom] : resolutions[resolutions.length - 1];
      resolutionConstraint = createSnapToResolutions(
        resolutions);
    } else {
      // calculate the default min and max resolution
      var projection = createProjection(options.projection, 'EPSG:3857');
      var extent = projection.getExtent();
      var size = !extent ?
        // use an extent that can fit the whole world if need be
        360 * METERS_PER_UNIT[Units.DEGREES] /
              projection.getMetersPerUnit() :
        Math.max(getWidth(extent), getHeight(extent));

      var defaultMaxResolution = size / DEFAULT_TILE_SIZE / Math.pow(
        defaultZoomFactor, DEFAULT_MIN_ZOOM);

      var defaultMinResolution = defaultMaxResolution / Math.pow(
        defaultZoomFactor, defaultMaxZoom - DEFAULT_MIN_ZOOM);

      // user provided maxResolution takes precedence
      maxResolution = options.maxResolution;
      if (maxResolution !== undefined) {
        minZoom = 0;
      } else {
        maxResolution = defaultMaxResolution / Math.pow(zoomFactor, minZoom);
      }

      // user provided minResolution takes precedence
      minResolution = options.minResolution;
      if (minResolution === undefined) {
        if (options.maxZoom !== undefined) {
          if (options.maxResolution !== undefined) {
            minResolution = maxResolution / Math.pow(zoomFactor, maxZoom);
          } else {
            minResolution = defaultMaxResolution / Math.pow(zoomFactor, maxZoom);
          }
        } else {
          minResolution = defaultMinResolution;
        }
      }

      // given discrete zoom levels, minResolution may be different than provided
      maxZoom = minZoom + Math.floor(
        Math.log(maxResolution / minResolution) / Math.log(zoomFactor));
      minResolution = maxResolution / Math.pow(zoomFactor, maxZoom - minZoom);

      resolutionConstraint = createSnapToPower(
        zoomFactor, maxResolution, maxZoom - minZoom);
    }
    return {constraint: resolutionConstraint, maxResolution: maxResolution,
      minResolution: minResolution, minZoom: minZoom, zoomFactor: zoomFactor};
  }


  /**
   * @param {ViewOptions} options View options.
   * @return {import("./rotationconstraint.js").Type} Rotation constraint.
   */
  function createRotationConstraint(options) {
    var enableRotation = options.enableRotation !== undefined ?
      options.enableRotation : true;
    if (enableRotation) {
      var constrainRotation = options.constrainRotation;
      if (constrainRotation === undefined || constrainRotation === true) {
        return createSnapToZero();
      } else if (constrainRotation === false) {
        return none$1;
      } else if (typeof constrainRotation === 'number') {
        return createSnapToN(constrainRotation);
      } else {
        return none$1;
      }
    } else {
      return disable;
    }
  }


  /**
   * Determine if an animation involves no view change.
   * @param {Animation} animation The animation.
   * @return {boolean} The animation involves no view change.
   */
  function isNoopAnimation(animation) {
    if (animation.sourceCenter && animation.targetCenter) {
      if (!equals$1(animation.sourceCenter, animation.targetCenter)) {
        return false;
      }
    }
    if (animation.sourceResolution !== animation.targetResolution) {
      return false;
    }
    if (animation.sourceRotation !== animation.targetRotation) {
      return false;
    }
    return true;
  }

  /**
   * @module ol/dom
   */


  /**
   * Create an html canvas element and returns its 2d context.
   * @param {number=} opt_width Canvas width.
   * @param {number=} opt_height Canvas height.
   * @return {CanvasRenderingContext2D} The context.
   */
  function createCanvasContext2D(opt_width, opt_height) {
    var canvas = /** @type {HTMLCanvasElement} */ (document.createElement('canvas'));
    if (opt_width) {
      canvas.width = opt_width;
    }
    if (opt_height) {
      canvas.height = opt_height;
    }
    return /** @type {CanvasRenderingContext2D} */ (canvas.getContext('2d'));
  }


  /**
   * Get the current computed width for the given element including margin,
   * padding and border.
   * Equivalent to jQuery's `$(el).outerWidth(true)`.
   * @param {!HTMLElement} element Element.
   * @return {number} The width.
   */
  function outerWidth(element) {
    var width = element.offsetWidth;
    var style = getComputedStyle(element);
    width += parseInt(style.marginLeft, 10) + parseInt(style.marginRight, 10);

    return width;
  }


  /**
   * Get the current computed height for the given element including margin,
   * padding and border.
   * Equivalent to jQuery's `$(el).outerHeight(true)`.
   * @param {!HTMLElement} element Element.
   * @return {number} The height.
   */
  function outerHeight(element) {
    var height = element.offsetHeight;
    var style = getComputedStyle(element);
    height += parseInt(style.marginTop, 10) + parseInt(style.marginBottom, 10);

    return height;
  }

  /**
   * @param {Node} newNode Node to replace old node
   * @param {Node} oldNode The node to be replaced
   */
  function replaceNode(newNode, oldNode) {
    var parent = oldNode.parentNode;
    if (parent) {
      parent.replaceChild(newNode, oldNode);
    }
  }

  /**
   * @param {Node} node The node to remove.
   * @returns {Node} The node that was removed or null.
   */
  function removeNode(node) {
    return node && node.parentNode ? node.parentNode.removeChild(node) : null;
  }

  /**
   * @param {Node} node The node to remove the children from.
   */
  function removeChildren(node) {
    while (node.lastChild) {
      node.removeChild(node.lastChild);
    }
  }

  /**
   * @module ol/layer/Property
   */

  /**
   * @enum {string}
   */
  var LayerProperty = {
    OPACITY: 'opacity',
    VISIBLE: 'visible',
    EXTENT: 'extent',
    Z_INDEX: 'zIndex',
    MAX_RESOLUTION: 'maxResolution',
    MIN_RESOLUTION: 'minResolution',
    SOURCE: 'source'
  };

  /**
   * @module ol/layer/Base
   */


  /**
   * @typedef {Object} Options
   * @property {number} [opacity=1] Opacity (0, 1).
   * @property {boolean} [visible=true] Visibility.
   * @property {import("../extent.js").Extent} [extent] The bounding extent for layer rendering.  The layer will not be
   * rendered outside of this extent.
   * @property {number} [zIndex] The z-index for layer rendering.  At rendering time, the layers
   * will be ordered, first by Z-index and then by position. When `undefined`, a `zIndex` of 0 is assumed
   * for layers that are added to the map's `layers` collection, or `Infinity` when the layer's `setMap()`
   * method was used.
   * @property {number} [minResolution] The minimum resolution (inclusive) at which this layer will be
   * visible.
   * @property {number} [maxResolution] The maximum resolution (exclusive) below which this layer will
   * be visible.
   */


  /**
   * @classdesc
   * Abstract base class; normally only used for creating subclasses and not
   * instantiated in apps.
   * Note that with {@link module:ol/layer/Base} and all its subclasses, any property set in
   * the options is set as a {@link module:ol/Object} property on the layer object, so
   * is observable, and has get/set accessors.
   *
   * @api
   */
  var BaseLayer = /*@__PURE__*/(function (BaseObject$$1) {
    function BaseLayer(options) {

      BaseObject$$1.call(this);

      /**
       * @type {Object<string, *>}
       */
      var properties = assign({}, options);
      properties[LayerProperty.OPACITY] =
         options.opacity !== undefined ? options.opacity : 1;
      properties[LayerProperty.VISIBLE] =
         options.visible !== undefined ? options.visible : true;
      properties[LayerProperty.Z_INDEX] = options.zIndex;
      properties[LayerProperty.MAX_RESOLUTION] =
         options.maxResolution !== undefined ? options.maxResolution : Infinity;
      properties[LayerProperty.MIN_RESOLUTION] =
         options.minResolution !== undefined ? options.minResolution : 0;

      this.setProperties(properties);

      /**
       * @type {import("./Layer.js").State}
       * @private
       */
      this.state_ = null;

      /**
       * The layer type.
       * @type {import("../LayerType.js").default}
       * @protected;
       */
      this.type;

    }

    if ( BaseObject$$1 ) BaseLayer.__proto__ = BaseObject$$1;
    BaseLayer.prototype = Object.create( BaseObject$$1 && BaseObject$$1.prototype );
    BaseLayer.prototype.constructor = BaseLayer;

    /**
     * Get the layer type (used when creating a layer renderer).
     * @return {import("../LayerType.js").default} The layer type.
     */
    BaseLayer.prototype.getType = function getType () {
      return this.type;
    };

    /**
     * @return {import("./Layer.js").State} Layer state.
     */
    BaseLayer.prototype.getLayerState = function getLayerState () {
      /** @type {import("./Layer.js").State} */
      var state = this.state_ || /** @type {?} */ ({
        layer: this,
        managed: true
      });
      state.opacity = clamp(this.getOpacity(), 0, 1);
      state.sourceState = this.getSourceState();
      state.visible = this.getVisible();
      state.extent = this.getExtent();
      state.zIndex = this.getZIndex() || 0;
      state.maxResolution = this.getMaxResolution();
      state.minResolution = Math.max(this.getMinResolution(), 0);
      this.state_ = state;

      return state;
    };

    /**
     * @abstract
     * @param {Array<import("./Layer.js").default>=} opt_array Array of layers (to be
     *     modified in place).
     * @return {Array<import("./Layer.js").default>} Array of layers.
     */
    BaseLayer.prototype.getLayersArray = function getLayersArray (opt_array) {
      return abstract();
    };

    /**
     * @abstract
     * @param {Array<import("./Layer.js").State>=} opt_states Optional list of layer
     *     states (to be modified in place).
     * @return {Array<import("./Layer.js").State>} List of layer states.
     */
    BaseLayer.prototype.getLayerStatesArray = function getLayerStatesArray (opt_states) {
      return abstract();
    };

    /**
     * Return the {@link module:ol/extent~Extent extent} of the layer or `undefined` if it
     * will be visible regardless of extent.
     * @return {import("../extent.js").Extent|undefined} The layer extent.
     * @observable
     * @api
     */
    BaseLayer.prototype.getExtent = function getExtent () {
      return (
        /** @type {import("../extent.js").Extent|undefined} */ (this.get(LayerProperty.EXTENT))
      );
    };

    /**
     * Return the maximum resolution of the layer.
     * @return {number} The maximum resolution of the layer.
     * @observable
     * @api
     */
    BaseLayer.prototype.getMaxResolution = function getMaxResolution () {
      return /** @type {number} */ (this.get(LayerProperty.MAX_RESOLUTION));
    };

    /**
     * Return the minimum resolution of the layer.
     * @return {number} The minimum resolution of the layer.
     * @observable
     * @api
     */
    BaseLayer.prototype.getMinResolution = function getMinResolution () {
      return /** @type {number} */ (this.get(LayerProperty.MIN_RESOLUTION));
    };

    /**
     * Return the opacity of the layer (between 0 and 1).
     * @return {number} The opacity of the layer.
     * @observable
     * @api
     */
    BaseLayer.prototype.getOpacity = function getOpacity () {
      return /** @type {number} */ (this.get(LayerProperty.OPACITY));
    };

    /**
     * @abstract
     * @return {import("../source/State.js").default} Source state.
     */
    BaseLayer.prototype.getSourceState = function getSourceState () {
      return abstract();
    };

    /**
     * Return the visibility of the layer (`true` or `false`).
     * @return {boolean} The visibility of the layer.
     * @observable
     * @api
     */
    BaseLayer.prototype.getVisible = function getVisible () {
      return /** @type {boolean} */ (this.get(LayerProperty.VISIBLE));
    };

    /**
     * Return the Z-index of the layer, which is used to order layers before
     * rendering. The default Z-index is 0.
     * @return {number} The Z-index of the layer.
     * @observable
     * @api
     */
    BaseLayer.prototype.getZIndex = function getZIndex () {
      return /** @type {number} */ (this.get(LayerProperty.Z_INDEX));
    };

    /**
     * Set the extent at which the layer is visible.  If `undefined`, the layer
     * will be visible at all extents.
     * @param {import("../extent.js").Extent|undefined} extent The extent of the layer.
     * @observable
     * @api
     */
    BaseLayer.prototype.setExtent = function setExtent (extent) {
      this.set(LayerProperty.EXTENT, extent);
    };

    /**
     * Set the maximum resolution at which the layer is visible.
     * @param {number} maxResolution The maximum resolution of the layer.
     * @observable
     * @api
     */
    BaseLayer.prototype.setMaxResolution = function setMaxResolution (maxResolution) {
      this.set(LayerProperty.MAX_RESOLUTION, maxResolution);
    };

    /**
     * Set the minimum resolution at which the layer is visible.
     * @param {number} minResolution The minimum resolution of the layer.
     * @observable
     * @api
     */
    BaseLayer.prototype.setMinResolution = function setMinResolution (minResolution) {
      this.set(LayerProperty.MIN_RESOLUTION, minResolution);
    };

    /**
     * Set the opacity of the layer, allowed values range from 0 to 1.
     * @param {number} opacity The opacity of the layer.
     * @observable
     * @api
     */
    BaseLayer.prototype.setOpacity = function setOpacity (opacity) {
      this.set(LayerProperty.OPACITY, opacity);
    };

    /**
     * Set the visibility of the layer (`true` or `false`).
     * @param {boolean} visible The visibility of the layer.
     * @observable
     * @api
     */
    BaseLayer.prototype.setVisible = function setVisible (visible) {
      this.set(LayerProperty.VISIBLE, visible);
    };

    /**
     * Set Z-index of the layer, which is used to order layers before rendering.
     * The default Z-index is 0.
     * @param {number} zindex The z-index of the layer.
     * @observable
     * @api
     */
    BaseLayer.prototype.setZIndex = function setZIndex (zindex) {
      this.set(LayerProperty.Z_INDEX, zindex);
    };

    return BaseLayer;
  }(BaseObject));

  /**
   * @module ol/source/State
   */

  /**
   * @enum {string}
   * State of the source, one of 'undefined', 'loading', 'ready' or 'error'.
   */
  var SourceState = {
    UNDEFINED: 'undefined',
    LOADING: 'loading',
    READY: 'ready',
    ERROR: 'error'
  };

  /**
   * @module ol/layer/Group
   */


  /**
   * @typedef {Object} Options
   * @property {number} [opacity=1] Opacity (0, 1).
   * @property {boolean} [visible=true] Visibility.
   * @property {import("../extent.js").Extent} [extent] The bounding extent for layer rendering.  The layer will not be
   * rendered outside of this extent.
   * @property {number} [zIndex] The z-index for layer rendering.  At rendering time, the layers
   * will be ordered, first by Z-index and then by position. When `undefined`, a `zIndex` of 0 is assumed
   * for layers that are added to the map's `layers` collection, or `Infinity` when the layer's `setMap()`
   * method was used.
   * @property {number} [minResolution] The minimum resolution (inclusive) at which this layer will be
   * visible.
   * @property {number} [maxResolution] The maximum resolution (exclusive) below which this layer will
   * be visible.
   * @property {Array<import("./Base.js").default>|import("../Collection.js").default<import("./Base.js").default>} [layers] Child layers.
   */


  /**
   * @enum {string}
   * @private
   */
  var Property$1 = {
    LAYERS: 'layers'
  };


  /**
   * @classdesc
   * A {@link module:ol/Collection~Collection} of layers that are handled together.
   *
   * A generic `change` event is triggered when the group/Collection changes.
   *
   * @api
   */
  var LayerGroup = /*@__PURE__*/(function (BaseLayer$$1) {
    function LayerGroup(opt_options) {

      var options = opt_options || {};
      var baseOptions = /** @type {Options} */ (assign({}, options));
      delete baseOptions.layers;

      var layers = options.layers;

      BaseLayer$$1.call(this, baseOptions);

      /**
       * @private
       * @type {Array<import("../events.js").EventsKey>}
       */
      this.layersListenerKeys_ = [];

      /**
       * @private
       * @type {Object<string, Array<import("../events.js").EventsKey>>}
       */
      this.listenerKeys_ = {};

      listen(this,
        getChangeEventType(Property$1.LAYERS),
        this.handleLayersChanged_, this);

      if (layers) {
        if (Array.isArray(layers)) {
          layers = new Collection(layers.slice(), {unique: true});
        } else {
          assert(typeof /** @type {?} */ (layers).getArray === 'function',
            43); // Expected `layers` to be an array or a `Collection`
        }
      } else {
        layers = new Collection(undefined, {unique: true});
      }

      this.setLayers(layers);

    }

    if ( BaseLayer$$1 ) LayerGroup.__proto__ = BaseLayer$$1;
    LayerGroup.prototype = Object.create( BaseLayer$$1 && BaseLayer$$1.prototype );
    LayerGroup.prototype.constructor = LayerGroup;

    /**
     * @private
     */
    LayerGroup.prototype.handleLayerChange_ = function handleLayerChange_ () {
      this.changed();
    };

    /**
     * @private
     */
    LayerGroup.prototype.handleLayersChanged_ = function handleLayersChanged_ () {
      this.layersListenerKeys_.forEach(unlistenByKey);
      this.layersListenerKeys_.length = 0;

      var layers = this.getLayers();
      this.layersListenerKeys_.push(
        listen(layers, CollectionEventType.ADD, this.handleLayersAdd_, this),
        listen(layers, CollectionEventType.REMOVE, this.handleLayersRemove_, this)
      );

      for (var id in this.listenerKeys_) {
        this.listenerKeys_[id].forEach(unlistenByKey);
      }
      clear(this.listenerKeys_);

      var layersArray = layers.getArray();
      for (var i = 0, ii = layersArray.length; i < ii; i++) {
        var layer = layersArray[i];
        this.listenerKeys_[getUid(layer)] = [
          listen(layer, ObjectEventType.PROPERTYCHANGE, this.handleLayerChange_, this),
          listen(layer, EventType.CHANGE, this.handleLayerChange_, this)
        ];
      }

      this.changed();
    };

    /**
     * @param {import("../Collection.js").CollectionEvent} collectionEvent CollectionEvent.
     * @private
     */
    LayerGroup.prototype.handleLayersAdd_ = function handleLayersAdd_ (collectionEvent) {
      var layer = /** @type {import("./Base.js").default} */ (collectionEvent.element);
      this.listenerKeys_[getUid(layer)] = [
        listen(layer, ObjectEventType.PROPERTYCHANGE, this.handleLayerChange_, this),
        listen(layer, EventType.CHANGE, this.handleLayerChange_, this)
      ];
      this.changed();
    };

    /**
     * @param {import("../Collection.js").CollectionEvent} collectionEvent CollectionEvent.
     * @private
     */
    LayerGroup.prototype.handleLayersRemove_ = function handleLayersRemove_ (collectionEvent) {
      var layer = /** @type {import("./Base.js").default} */ (collectionEvent.element);
      var key = getUid(layer);
      this.listenerKeys_[key].forEach(unlistenByKey);
      delete this.listenerKeys_[key];
      this.changed();
    };

    /**
     * Returns the {@link module:ol/Collection collection} of {@link module:ol/layer/Layer~Layer layers}
     * in this group.
     * @return {!import("../Collection.js").default<import("./Base.js").default>} Collection of
     *   {@link module:ol/layer/Base layers} that are part of this group.
     * @observable
     * @api
     */
    LayerGroup.prototype.getLayers = function getLayers () {
      return (
        /** @type {!import("../Collection.js").default<import("./Base.js").default>} */ (this.get(Property$1.LAYERS))
      );
    };

    /**
     * Set the {@link module:ol/Collection collection} of {@link module:ol/layer/Layer~Layer layers}
     * in this group.
     * @param {!import("../Collection.js").default<import("./Base.js").default>} layers Collection of
     *   {@link module:ol/layer/Base layers} that are part of this group.
     * @observable
     * @api
     */
    LayerGroup.prototype.setLayers = function setLayers (layers) {
      this.set(Property$1.LAYERS, layers);
    };

    /**
     * @inheritDoc
     */
    LayerGroup.prototype.getLayersArray = function getLayersArray (opt_array) {
      var array = opt_array !== undefined ? opt_array : [];
      this.getLayers().forEach(function(layer) {
        layer.getLayersArray(array);
      });
      return array;
    };

    /**
     * @inheritDoc
     */
    LayerGroup.prototype.getLayerStatesArray = function getLayerStatesArray (opt_states) {
      var states = opt_states !== undefined ? opt_states : [];

      var pos = states.length;

      this.getLayers().forEach(function(layer) {
        layer.getLayerStatesArray(states);
      });

      var ownLayerState = this.getLayerState();
      for (var i = pos, ii = states.length; i < ii; i++) {
        var layerState = states[i];
        layerState.opacity *= ownLayerState.opacity;
        layerState.visible = layerState.visible && ownLayerState.visible;
        layerState.maxResolution = Math.min(
          layerState.maxResolution, ownLayerState.maxResolution);
        layerState.minResolution = Math.max(
          layerState.minResolution, ownLayerState.minResolution);
        if (ownLayerState.extent !== undefined) {
          if (layerState.extent !== undefined) {
            layerState.extent = getIntersection(layerState.extent, ownLayerState.extent);
          } else {
            layerState.extent = ownLayerState.extent;
          }
        }
      }

      return states;
    };

    /**
     * @inheritDoc
     */
    LayerGroup.prototype.getSourceState = function getSourceState () {
      return SourceState.READY;
    };

    return LayerGroup;
  }(BaseLayer));

  /**
   * @module ol/size
   */


  /**
   * Determines if a size has a positive area.
   * @param {Size} size The size to test.
   * @return {boolean} The size has a positive area.
   */
  function hasArea(size) {
    return size[0] > 0 && size[1] > 0;
  }


  /**
   * Returns a size scaled by a ratio. The result will be an array of integers.
   * @param {Size} size Size.
   * @param {number} ratio Ratio.
   * @param {Size=} opt_size Optional reusable size array.
   * @return {Size} The scaled size.
   */
  function scale$3(size, ratio, opt_size) {
    if (opt_size === undefined) {
      opt_size = [0, 0];
    }
    opt_size[0] = (size[0] * ratio + 0.5) | 0;
    opt_size[1] = (size[1] * ratio + 0.5) | 0;
    return opt_size;
  }


  /**
   * Returns an `Size` array for the passed in number (meaning: square) or
   * `Size` array.
   * (meaning: non-square),
   * @param {number|Size} size Width and height.
   * @param {Size=} opt_size Optional reusable size array.
   * @return {Size} Size.
   * @api
   */
  function toSize(size, opt_size) {
    if (Array.isArray(size)) {
      return size;
    } else {
      if (opt_size === undefined) {
        opt_size = [size, size];
      } else {
        opt_size[0] = opt_size[1] = /** @type {number} */ (size);
      }
      return opt_size;
    }
  }

  /**
   * @module ol/PluggableMap
   */


  /**
   * State of the current frame. Only `pixelRatio`, `time` and `viewState` should
   * be used in applications.
   * @typedef {Object} FrameState
   * @property {number} pixelRatio The pixel ratio of the frame.
   * @property {number} time The time when rendering of the frame was requested.
   * @property {import("./View.js").State} viewState The state of the current view.
   * @property {boolean} animate
   * @property {import("./transform.js").Transform} coordinateToPixelTransform
   * @property {null|import("./extent.js").Extent} extent
   * @property {import("./coordinate.js").Coordinate} focus
   * @property {number} index
   * @property {Object<string, import("./layer/Layer.js").State>} layerStates
   * @property {Array<import("./layer/Layer.js").State>} layerStatesArray
   * @property {import("./transform.js").Transform} pixelToCoordinateTransform
   * @property {Array<PostRenderFunction>} postRenderFunctions
   * @property {import("./size.js").Size} size
   * @property {!Object<string, boolean>} skippedFeatureUids
   * @property {TileQueue} tileQueue
   * @property {Object<string, Object<string, import("./TileRange.js").default>>} usedTiles
   * @property {Array<number>} viewHints
   * @property {!Object<string, Object<string, boolean>>} wantedTiles
   */


  /**
   * @typedef {function(PluggableMap, ?FrameState): boolean} PostRenderFunction
   */


  /**
   * @typedef {Object} AtPixelOptions
   * @property {undefined|function(import("./layer/Layer.js").default): boolean} layerFilter Layer filter
   * function. The filter function will receive one argument, the
   * {@link module:ol/layer/Layer layer-candidate} and it should return a boolean value.
   * Only layers which are visible and for which this function returns `true`
   * will be tested for features. By default, all visible layers will be tested.
   * @property {number} [hitTolerance=0] Hit-detection tolerance in pixels. Pixels
   * inside the radius around the given position will be checked for features. This only
   * works for the canvas renderer and not for WebGL.
   */


  /**
   * @typedef {Object} MapOptionsInternal
   * @property {Collection<import("./control/Control.js").default>} [controls]
   * @property {Collection<import("./interaction/Interaction.js").default>} [interactions]
   * @property {HTMLElement|Document} keyboardEventTarget
   * @property {Collection<import("./Overlay.js").default>} overlays
   * @property {Object<string, *>} values
   */


  /**
   * Object literal with config options for the map.
   * @typedef {Object} MapOptions
   * @property {Collection<import("./control/Control.js").default>|Array<import("./control/Control.js").default>} [controls]
   * Controls initially added to the map. If not specified,
   * {@link module:ol/control~defaults} is used.
   * @property {number} [pixelRatio=window.devicePixelRatio] The ratio between
   * physical pixels and device-independent pixels (dips) on the device.
   * @property {Collection<import("./interaction/Interaction.js").default>|Array<import("./interaction/Interaction.js").default>} [interactions]
   * Interactions that are initially added to the map. If not specified,
   * {@link module:ol/interaction~defaults} is used.
   * @property {HTMLElement|Document|string} [keyboardEventTarget] The element to
   * listen to keyboard events on. This determines when the `KeyboardPan` and
   * `KeyboardZoom` interactions trigger. For example, if this option is set to
   * `document` the keyboard interactions will always trigger. If this option is
   * not specified, the element the library listens to keyboard events on is the
   * map target (i.e. the user-provided div for the map). If this is not
   * `document`, the target element needs to be focused for key events to be
   * emitted, requiring that the target element has a `tabindex` attribute.
   * @property {Array<import("./layer/Base.js").default>|Collection<import("./layer/Base.js").default>|LayerGroup} [layers]
   * Layers. If this is not defined, a map with no layers will be rendered. Note
   * that layers are rendered in the order supplied, so if you want, for example,
   * a vector layer to appear on top of a tile layer, it must come after the tile
   * layer.
   * @property {number} [maxTilesLoading=16] Maximum number tiles to load
   * simultaneously.
   * @property {boolean} [loadTilesWhileAnimating=false] When set to `true`, tiles
   * will be loaded during animations. This may improve the user experience, but
   * can also make animations stutter on devices with slow memory.
   * @property {boolean} [loadTilesWhileInteracting=false] When set to `true`,
   * tiles will be loaded while interacting with the map. This may improve the
   * user experience, but can also make map panning and zooming choppy on devices
   * with slow memory.
   * @property {number} [moveTolerance=1] The minimum distance in pixels the
   * cursor must move to be detected as a map move event instead of a click.
   * Increasing this value can make it easier to click on the map.
   * @property {Collection<import("./Overlay.js").default>|Array<import("./Overlay.js").default>} [overlays]
   * Overlays initially added to the map. By default, no overlays are added.
   * @property {HTMLElement|string} [target] The container for the map, either the
   * element itself or the `id` of the element. If not specified at construction
   * time, {@link module:ol/Map~Map#setTarget} must be called for the map to be
   * rendered.
   * @property {View} [view] The map's view.  No layer sources will be
   * fetched unless this is specified at construction time or through
   * {@link module:ol/Map~Map#setView}.
   */


  /**
   * @fires import("./MapBrowserEvent.js").MapBrowserEvent
   * @fires import("./MapEvent.js").MapEvent
   * @fires module:ol/render/Event~RenderEvent#postcompose
   * @fires module:ol/render/Event~RenderEvent#precompose
   * @fires module:ol/render/Event~RenderEvent#rendercomplete
   * @api
   */
  var PluggableMap = /*@__PURE__*/(function (BaseObject$$1) {
    function PluggableMap(options) {

      BaseObject$$1.call(this);

      var optionsInternal = createOptionsInternal(options);

      /**
       * @type {number}
       * @private
       */
      this.maxTilesLoading_ = options.maxTilesLoading !== undefined ? options.maxTilesLoading : 16;

      /**
       * @type {boolean}
       * @private
       */
      this.loadTilesWhileAnimating_ =
          options.loadTilesWhileAnimating !== undefined ?
            options.loadTilesWhileAnimating : false;

      /**
       * @type {boolean}
       * @private
       */
      this.loadTilesWhileInteracting_ =
          options.loadTilesWhileInteracting !== undefined ?
            options.loadTilesWhileInteracting : false;

      /**
       * @private
       * @type {number}
       */
      this.pixelRatio_ = options.pixelRatio !== undefined ?
        options.pixelRatio : DEVICE_PIXEL_RATIO;

      /**
       * @private
       * @type {number|undefined}
       */
      this.animationDelayKey_;

      /**
       * @private
       */
      this.animationDelay_ = function() {
        this.animationDelayKey_ = undefined;
        this.renderFrame_.call(this, Date.now());
      }.bind(this);

      /**
       * @private
       * @type {import("./transform.js").Transform}
       */
      this.coordinateToPixelTransform_ = create();

      /**
       * @private
       * @type {import("./transform.js").Transform}
       */
      this.pixelToCoordinateTransform_ = create();

      /**
       * @private
       * @type {number}
       */
      this.frameIndex_ = 0;

      /**
       * @private
       * @type {?FrameState}
       */
      this.frameState_ = null;

      /**
       * The extent at the previous 'moveend' event.
       * @private
       * @type {import("./extent.js").Extent}
       */
      this.previousExtent_ = null;

      /**
       * @private
       * @type {?import("./events.js").EventsKey}
       */
      this.viewPropertyListenerKey_ = null;

      /**
       * @private
       * @type {?import("./events.js").EventsKey}
       */
      this.viewChangeListenerKey_ = null;

      /**
       * @private
       * @type {Array<import("./events.js").EventsKey>}
       */
      this.layerGroupPropertyListenerKeys_ = null;

      /**
       * @private
       * @type {!HTMLElement}
       */
      this.viewport_ = document.createElement('div');
      this.viewport_.className = 'ol-viewport' + (TOUCH ? ' ol-touch' : '');
      this.viewport_.style.position = 'relative';
      this.viewport_.style.overflow = 'hidden';
      this.viewport_.style.width = '100%';
      this.viewport_.style.height = '100%';
      // prevent page zoom on IE >= 10 browsers
      this.viewport_.style.msTouchAction = 'none';
      this.viewport_.style.touchAction = 'none';

      /**
       * @private
       * @type {!HTMLElement}
       */
      this.overlayContainer_ = document.createElement('div');
      this.overlayContainer_.className = 'ol-overlaycontainer';
      this.viewport_.appendChild(this.overlayContainer_);

      /**
       * @private
       * @type {!HTMLElement}
       */
      this.overlayContainerStopEvent_ = document.createElement('div');
      this.overlayContainerStopEvent_.className = 'ol-overlaycontainer-stopevent';
      var overlayEvents = [
        EventType.CLICK,
        EventType.DBLCLICK,
        EventType.MOUSEDOWN,
        EventType.TOUCHSTART,
        EventType.MSPOINTERDOWN,
        MapBrowserEventType.POINTERDOWN,
        EventType.MOUSEWHEEL,
        EventType.WHEEL
      ];
      for (var i = 0, ii = overlayEvents.length; i < ii; ++i) {
        listen(this.overlayContainerStopEvent_, overlayEvents[i], stopPropagation);
      }
      this.viewport_.appendChild(this.overlayContainerStopEvent_);

      /**
       * @private
       * @type {MapBrowserEventHandler}
       */
      this.mapBrowserEventHandler_ = new MapBrowserEventHandler(this, options.moveTolerance);
      for (var key in MapBrowserEventType) {
        listen(this.mapBrowserEventHandler_, MapBrowserEventType[key],
          this.handleMapBrowserEvent, this);
      }

      /**
       * @private
       * @type {HTMLElement|Document}
       */
      this.keyboardEventTarget_ = optionsInternal.keyboardEventTarget;

      /**
       * @private
       * @type {Array<import("./events.js").EventsKey>}
       */
      this.keyHandlerKeys_ = null;

      listen(this.viewport_, EventType.CONTEXTMENU, this.handleBrowserEvent, this);
      listen(this.viewport_, EventType.WHEEL, this.handleBrowserEvent, this);
      listen(this.viewport_, EventType.MOUSEWHEEL, this.handleBrowserEvent, this);

      /**
       * @type {Collection<import("./control/Control.js").default>}
       * @protected
       */
      this.controls = optionsInternal.controls || new Collection();

      /**
       * @type {Collection<import("./interaction/Interaction.js").default>}
       * @protected
       */
      this.interactions = optionsInternal.interactions || new Collection();

      /**
       * @type {Collection<import("./Overlay.js").default>}
       * @private
       */
      this.overlays_ = optionsInternal.overlays;

      /**
       * A lookup of overlays by id.
       * @private
       * @type {Object<string, import("./Overlay.js").default>}
       */
      this.overlayIdIndex_ = {};

      /**
       * @type {import("./renderer/Map.js").default}
       * @private
       */
      this.renderer_ = this.createRenderer();

      /**
       * @type {function(Event)|undefined}
       * @private
       */
      this.handleResize_;

      /**
       * @private
       * @type {import("./coordinate.js").Coordinate}
       */
      this.focus_ = null;

      /**
       * @private
       * @type {!Array<PostRenderFunction>}
       */
      this.postRenderFunctions_ = [];

      /**
       * @private
       * @type {TileQueue}
       */
      this.tileQueue_ = new TileQueue(
        this.getTilePriority.bind(this),
        this.handleTileChange_.bind(this));

      /**
       * Uids of features to skip at rendering time.
       * @type {Object<string, boolean>}
       * @private
       */
      this.skippedFeatureUids_ = {};

      listen(
        this, getChangeEventType(MapProperty.LAYERGROUP),
        this.handleLayerGroupChanged_, this);
      listen(this, getChangeEventType(MapProperty.VIEW),
        this.handleViewChanged_, this);
      listen(this, getChangeEventType(MapProperty.SIZE),
        this.handleSizeChanged_, this);
      listen(this, getChangeEventType(MapProperty.TARGET),
        this.handleTargetChanged_, this);

      // setProperties will trigger the rendering of the map if the map
      // is "defined" already.
      this.setProperties(optionsInternal.values);

      this.controls.forEach(
        /**
         * @param {import("./control/Control.js").default} control Control.
         * @this {PluggableMap}
         */
        (function(control) {
          control.setMap(this);
        }).bind(this));

      listen(this.controls, CollectionEventType.ADD,
        /**
         * @param {import("./Collection.js").CollectionEvent} event CollectionEvent.
         */
        function(event) {
          event.element.setMap(this);
        }, this);

      listen(this.controls, CollectionEventType.REMOVE,
        /**
         * @param {import("./Collection.js").CollectionEvent} event CollectionEvent.
         */
        function(event) {
          event.element.setMap(null);
        }, this);

      this.interactions.forEach(
        /**
         * @param {import("./interaction/Interaction.js").default} interaction Interaction.
         * @this {PluggableMap}
         */
        (function(interaction) {
          interaction.setMap(this);
        }).bind(this));

      listen(this.interactions, CollectionEventType.ADD,
        /**
         * @param {import("./Collection.js").CollectionEvent} event CollectionEvent.
         */
        function(event) {
          event.element.setMap(this);
        }, this);

      listen(this.interactions, CollectionEventType.REMOVE,
        /**
         * @param {import("./Collection.js").CollectionEvent} event CollectionEvent.
         */
        function(event) {
          event.element.setMap(null);
        }, this);

      this.overlays_.forEach(this.addOverlayInternal_.bind(this));

      listen(this.overlays_, CollectionEventType.ADD,
        /**
         * @param {import("./Collection.js").CollectionEvent} event CollectionEvent.
         */
        function(event) {
          this.addOverlayInternal_(/** @type {import("./Overlay.js").default} */ (event.element));
        }, this);

      listen(this.overlays_, CollectionEventType.REMOVE,
        /**
         * @param {import("./Collection.js").CollectionEvent} event CollectionEvent.
         */
        function(event) {
          var overlay = /** @type {import("./Overlay.js").default} */ (event.element);
          var id = overlay.getId();
          if (id !== undefined) {
            delete this.overlayIdIndex_[id.toString()];
          }
          event.element.setMap(null);
        }, this);

    }

    if ( BaseObject$$1 ) PluggableMap.__proto__ = BaseObject$$1;
    PluggableMap.prototype = Object.create( BaseObject$$1 && BaseObject$$1.prototype );
    PluggableMap.prototype.constructor = PluggableMap;

    /**
     * @abstract
     * @return {import("./renderer/Map.js").default} The map renderer
     */
    PluggableMap.prototype.createRenderer = function createRenderer () {
      throw new Error('Use a map type that has a createRenderer method');
    };

    /**
     * Add the given control to the map.
     * @param {import("./control/Control.js").default} control Control.
     * @api
     */
    PluggableMap.prototype.addControl = function addControl (control) {
      this.getControls().push(control);
    };

    /**
     * Add the given interaction to the map.
     * @param {import("./interaction/Interaction.js").default} interaction Interaction to add.
     * @api
     */
    PluggableMap.prototype.addInteraction = function addInteraction (interaction) {
      this.getInteractions().push(interaction);
    };

    /**
     * Adds the given layer to the top of this map. If you want to add a layer
     * elsewhere in the stack, use `getLayers()` and the methods available on
     * {@link module:ol/Collection~Collection}.
     * @param {import("./layer/Base.js").default} layer Layer.
     * @api
     */
    PluggableMap.prototype.addLayer = function addLayer (layer) {
      var layers = this.getLayerGroup().getLayers();
      layers.push(layer);
    };

    /**
     * Add the given overlay to the map.
     * @param {import("./Overlay.js").default} overlay Overlay.
     * @api
     */
    PluggableMap.prototype.addOverlay = function addOverlay (overlay) {
      this.getOverlays().push(overlay);
    };

    /**
     * This deals with map's overlay collection changes.
     * @param {import("./Overlay.js").default} overlay Overlay.
     * @private
     */
    PluggableMap.prototype.addOverlayInternal_ = function addOverlayInternal_ (overlay) {
      var id = overlay.getId();
      if (id !== undefined) {
        this.overlayIdIndex_[id.toString()] = overlay;
      }
      overlay.setMap(this);
    };

    /**
     *
     * @inheritDoc
     */
    PluggableMap.prototype.disposeInternal = function disposeInternal () {
      this.mapBrowserEventHandler_.dispose();
      unlisten(this.viewport_, EventType.CONTEXTMENU, this.handleBrowserEvent, this);
      unlisten(this.viewport_, EventType.WHEEL, this.handleBrowserEvent, this);
      unlisten(this.viewport_, EventType.MOUSEWHEEL, this.handleBrowserEvent, this);
      if (this.handleResize_ !== undefined) {
        removeEventListener(EventType.RESIZE, this.handleResize_, false);
        this.handleResize_ = undefined;
      }
      if (this.animationDelayKey_) {
        cancelAnimationFrame(this.animationDelayKey_);
        this.animationDelayKey_ = undefined;
      }
      this.setTarget(null);
      BaseObject$$1.prototype.disposeInternal.call(this);
    };

    /**
     * Detect features that intersect a pixel on the viewport, and execute a
     * callback with each intersecting feature. Layers included in the detection can
     * be configured through the `layerFilter` option in `opt_options`.
     * @param {import("./pixel.js").Pixel} pixel Pixel.
     * @param {function(this: S, import("./Feature.js").FeatureLike,
     *     import("./layer/Layer.js").default): T} callback Feature callback. The callback will be
     *     called with two arguments. The first argument is one
     *     {@link module:ol/Feature feature} or
     *     {@link module:ol/render/Feature render feature} at the pixel, the second is
     *     the {@link module:ol/layer/Layer layer} of the feature and will be null for
     *     unmanaged layers. To stop detection, callback functions can return a
     *     truthy value.
     * @param {AtPixelOptions=} opt_options Optional options.
     * @return {T|undefined} Callback result, i.e. the return value of last
     * callback execution, or the first truthy callback return value.
     * @template S,T
     * @api
     */
    PluggableMap.prototype.forEachFeatureAtPixel = function forEachFeatureAtPixel (pixel, callback, opt_options) {
      if (!this.frameState_) {
        return;
      }
      var coordinate = this.getCoordinateFromPixel(pixel);
      opt_options = opt_options !== undefined ? opt_options :
        /** @type {AtPixelOptions} */ ({});
      var hitTolerance = opt_options.hitTolerance !== undefined ?
        opt_options.hitTolerance * this.frameState_.pixelRatio : 0;
      var layerFilter = opt_options.layerFilter !== undefined ?
        opt_options.layerFilter : TRUE;
      return this.renderer_.forEachFeatureAtCoordinate(
        coordinate, this.frameState_, hitTolerance, callback, null,
        layerFilter, null);
    };

    /**
     * Get all features that intersect a pixel on the viewport.
     * @param {import("./pixel.js").Pixel} pixel Pixel.
     * @param {AtPixelOptions=} opt_options Optional options.
     * @return {Array<import("./Feature.js").FeatureLike>} The detected features or
     * `null` if none were found.
     * @api
     */
    PluggableMap.prototype.getFeaturesAtPixel = function getFeaturesAtPixel (pixel, opt_options) {
      var features = null;
      this.forEachFeatureAtPixel(pixel, function(feature) {
        if (!features) {
          features = [];
        }
        features.push(feature);
      }, opt_options);
      return features;
    };

    /**
     * Detect layers that have a color value at a pixel on the viewport, and
     * execute a callback with each matching layer. Layers included in the
     * detection can be configured through `opt_layerFilter`.
     * @param {import("./pixel.js").Pixel} pixel Pixel.
     * @param {function(this: S, import("./layer/Layer.js").default, (Uint8ClampedArray|Uint8Array)): T} callback
     *     Layer callback. This callback will receive two arguments: first is the
     *     {@link module:ol/layer/Layer layer}, second argument is an array representing
     *     [R, G, B, A] pixel values (0 - 255) and will be `null` for layer types
     *     that do not currently support this argument. To stop detection, callback
     *     functions can return a truthy value.
     * @param {AtPixelOptions=} opt_options Configuration options.
     * @return {T|undefined} Callback result, i.e. the return value of last
     * callback execution, or the first truthy callback return value.
     * @template S,T
     * @api
     */
    PluggableMap.prototype.forEachLayerAtPixel = function forEachLayerAtPixel (pixel, callback, opt_options) {
      if (!this.frameState_) {
        return;
      }
      var options = opt_options || /** @type {AtPixelOptions} */ ({});
      var hitTolerance = options.hitTolerance !== undefined ?
        opt_options.hitTolerance * this.frameState_.pixelRatio : 0;
      var layerFilter = options.layerFilter || TRUE;
      return this.renderer_.forEachLayerAtPixel(
        pixel, this.frameState_, hitTolerance, callback, null, layerFilter, null);
    };

    /**
     * Detect if features intersect a pixel on the viewport. Layers included in the
     * detection can be configured through `opt_layerFilter`.
     * @param {import("./pixel.js").Pixel} pixel Pixel.
     * @param {AtPixelOptions=} opt_options Optional options.
     * @return {boolean} Is there a feature at the given pixel?
     * @template U
     * @api
     */
    PluggableMap.prototype.hasFeatureAtPixel = function hasFeatureAtPixel (pixel, opt_options) {
      if (!this.frameState_) {
        return false;
      }
      var coordinate = this.getCoordinateFromPixel(pixel);
      opt_options = opt_options !== undefined ? opt_options :
        /** @type {AtPixelOptions} */ ({});
      var layerFilter = opt_options.layerFilter !== undefined ? opt_options.layerFilter : TRUE;
      var hitTolerance = opt_options.hitTolerance !== undefined ?
        opt_options.hitTolerance * this.frameState_.pixelRatio : 0;
      return this.renderer_.hasFeatureAtCoordinate(
        coordinate, this.frameState_, hitTolerance, layerFilter, null);
    };

    /**
     * Returns the coordinate in view projection for a browser event.
     * @param {Event} event Event.
     * @return {import("./coordinate.js").Coordinate} Coordinate.
     * @api
     */
    PluggableMap.prototype.getEventCoordinate = function getEventCoordinate (event) {
      return this.getCoordinateFromPixel(this.getEventPixel(event));
    };

    /**
     * Returns the map pixel position for a browser event relative to the viewport.
     * @param {Event|TouchEvent} event Event.
     * @return {import("./pixel.js").Pixel} Pixel.
     * @api
     */
    PluggableMap.prototype.getEventPixel = function getEventPixel (event) {
      var viewportPosition = this.viewport_.getBoundingClientRect();
      var eventPosition = 'changedTouches' in event ?
        /** @type {TouchEvent} */ (event).changedTouches[0] :
        /** @type {MouseEvent} */ (event);

      return [
        eventPosition.clientX - viewportPosition.left,
        eventPosition.clientY - viewportPosition.top
      ];
    };

    /**
     * Get the target in which this map is rendered.
     * Note that this returns what is entered as an option or in setTarget:
     * if that was an element, it returns an element; if a string, it returns that.
     * @return {HTMLElement|string|undefined} The Element or id of the Element that the
     *     map is rendered in.
     * @observable
     * @api
     */
    PluggableMap.prototype.getTarget = function getTarget () {
      return /** @type {HTMLElement|string|undefined} */ (this.get(MapProperty.TARGET));
    };

    /**
     * Get the DOM element into which this map is rendered. In contrast to
     * `getTarget` this method always return an `Element`, or `null` if the
     * map has no target.
     * @return {HTMLElement} The element that the map is rendered in.
     * @api
     */
    PluggableMap.prototype.getTargetElement = function getTargetElement () {
      var target = this.getTarget();
      if (target !== undefined) {
        return typeof target === 'string' ? document.getElementById(target) : target;
      } else {
        return null;
      }
    };

    /**
     * Get the coordinate for a given pixel.  This returns a coordinate in the
     * map view projection.
     * @param {import("./pixel.js").Pixel} pixel Pixel position in the map viewport.
     * @return {import("./coordinate.js").Coordinate} The coordinate for the pixel position.
     * @api
     */
    PluggableMap.prototype.getCoordinateFromPixel = function getCoordinateFromPixel (pixel) {
      var frameState = this.frameState_;
      if (!frameState) {
        return null;
      } else {
        return apply(frameState.pixelToCoordinateTransform, pixel.slice());
      }
    };

    /**
     * Get the map controls. Modifying this collection changes the controls
     * associated with the map.
     * @return {Collection<import("./control/Control.js").default>} Controls.
     * @api
     */
    PluggableMap.prototype.getControls = function getControls () {
      return this.controls;
    };

    /**
     * Get the map overlays. Modifying this collection changes the overlays
     * associated with the map.
     * @return {Collection<import("./Overlay.js").default>} Overlays.
     * @api
     */
    PluggableMap.prototype.getOverlays = function getOverlays () {
      return this.overlays_;
    };

    /**
     * Get an overlay by its identifier (the value returned by overlay.getId()).
     * Note that the index treats string and numeric identifiers as the same. So
     * `map.getOverlayById(2)` will return an overlay with id `'2'` or `2`.
     * @param {string|number} id Overlay identifier.
     * @return {import("./Overlay.js").default} Overlay.
     * @api
     */
    PluggableMap.prototype.getOverlayById = function getOverlayById (id) {
      var overlay = this.overlayIdIndex_[id.toString()];
      return overlay !== undefined ? overlay : null;
    };

    /**
     * Get the map interactions. Modifying this collection changes the interactions
     * associated with the map.
     *
     * Interactions are used for e.g. pan, zoom and rotate.
     * @return {Collection<import("./interaction/Interaction.js").default>} Interactions.
     * @api
     */
    PluggableMap.prototype.getInteractions = function getInteractions () {
      return this.interactions;
    };

    /**
     * Get the layergroup associated with this map.
     * @return {LayerGroup} A layer group containing the layers in this map.
     * @observable
     * @api
     */
    PluggableMap.prototype.getLayerGroup = function getLayerGroup () {
      return (
        /** @type {LayerGroup} */ (this.get(MapProperty.LAYERGROUP))
      );
    };

    /**
     * Get the collection of layers associated with this map.
     * @return {!Collection<import("./layer/Base.js").default>} Layers.
     * @api
     */
    PluggableMap.prototype.getLayers = function getLayers () {
      var layers = this.getLayerGroup().getLayers();
      return layers;
    };

    /**
     * Get the pixel for a coordinate.  This takes a coordinate in the map view
     * projection and returns the corresponding pixel.
     * @param {import("./coordinate.js").Coordinate} coordinate A map coordinate.
     * @return {import("./pixel.js").Pixel} A pixel position in the map viewport.
     * @api
     */
    PluggableMap.prototype.getPixelFromCoordinate = function getPixelFromCoordinate (coordinate) {
      var frameState = this.frameState_;
      if (!frameState) {
        return null;
      } else {
        return apply(frameState.coordinateToPixelTransform, coordinate.slice(0, 2));
      }
    };

    /**
     * Get the map renderer.
     * @return {import("./renderer/Map.js").default} Renderer
     */
    PluggableMap.prototype.getRenderer = function getRenderer () {
      return this.renderer_;
    };

    /**
     * Get the size of this map.
     * @return {import("./size.js").Size|undefined} The size in pixels of the map in the DOM.
     * @observable
     * @api
     */
    PluggableMap.prototype.getSize = function getSize$$1 () {
      return (
        /** @type {import("./size.js").Size|undefined} */ (this.get(MapProperty.SIZE))
      );
    };

    /**
     * Get the view associated with this map. A view manages properties such as
     * center and resolution.
     * @return {View} The view that controls this map.
     * @observable
     * @api
     */
    PluggableMap.prototype.getView = function getView () {
      return (
        /** @type {View} */ (this.get(MapProperty.VIEW))
      );
    };

    /**
     * Get the element that serves as the map viewport.
     * @return {HTMLElement} Viewport.
     * @api
     */
    PluggableMap.prototype.getViewport = function getViewport () {
      return this.viewport_;
    };

    /**
     * Get the element that serves as the container for overlays.  Elements added to
     * this container will let mousedown and touchstart events through to the map,
     * so clicks and gestures on an overlay will trigger {@link module:ol/MapBrowserEvent~MapBrowserEvent}
     * events.
     * @return {!HTMLElement} The map's overlay container.
     */
    PluggableMap.prototype.getOverlayContainer = function getOverlayContainer () {
      return this.overlayContainer_;
    };

    /**
     * Get the element that serves as a container for overlays that don't allow
     * event propagation. Elements added to this container won't let mousedown and
     * touchstart events through to the map, so clicks and gestures on an overlay
     * don't trigger any {@link module:ol/MapBrowserEvent~MapBrowserEvent}.
     * @return {!HTMLElement} The map's overlay container that stops events.
     */
    PluggableMap.prototype.getOverlayContainerStopEvent = function getOverlayContainerStopEvent () {
      return this.overlayContainerStopEvent_;
    };

    /**
     * @param {import("./Tile.js").default} tile Tile.
     * @param {string} tileSourceKey Tile source key.
     * @param {import("./coordinate.js").Coordinate} tileCenter Tile center.
     * @param {number} tileResolution Tile resolution.
     * @return {number} Tile priority.
     */
    PluggableMap.prototype.getTilePriority = function getTilePriority (tile, tileSourceKey, tileCenter, tileResolution) {
      // Filter out tiles at higher zoom levels than the current zoom level, or that
      // are outside the visible extent.
      var frameState = this.frameState_;
      if (!frameState || !(tileSourceKey in frameState.wantedTiles)) {
        return DROP;
      }
      if (!frameState.wantedTiles[tileSourceKey][tile.getKey()]) {
        return DROP;
      }
      // Prioritize the highest zoom level tiles closest to the focus.
      // Tiles at higher zoom levels are prioritized using Math.log(tileResolution).
      // Within a zoom level, tiles are prioritized by the distance in pixels
      // between the center of the tile and the focus.  The factor of 65536 means
      // that the prioritization should behave as desired for tiles up to
      // 65536 * Math.log(2) = 45426 pixels from the focus.
      var deltaX = tileCenter[0] - frameState.focus[0];
      var deltaY = tileCenter[1] - frameState.focus[1];
      return 65536 * Math.log(tileResolution) +
          Math.sqrt(deltaX * deltaX + deltaY * deltaY) / tileResolution;
    };

    /**
     * @param {Event} browserEvent Browser event.
     * @param {string=} opt_type Type.
     */
    PluggableMap.prototype.handleBrowserEvent = function handleBrowserEvent (browserEvent, opt_type) {
      var type = opt_type || browserEvent.type;
      var mapBrowserEvent = new MapBrowserEvent(type, this, browserEvent);
      this.handleMapBrowserEvent(mapBrowserEvent);
    };

    /**
     * @param {MapBrowserEvent} mapBrowserEvent The event to handle.
     */
    PluggableMap.prototype.handleMapBrowserEvent = function handleMapBrowserEvent (mapBrowserEvent) {
      if (!this.frameState_) {
        // With no view defined, we cannot translate pixels into geographical
        // coordinates so interactions cannot be used.
        return;
      }
      this.focus_ = mapBrowserEvent.coordinate;
      mapBrowserEvent.frameState = this.frameState_;
      var interactionsArray = this.getInteractions().getArray();
      if (this.dispatchEvent(mapBrowserEvent) !== false) {
        for (var i = interactionsArray.length - 1; i >= 0; i--) {
          var interaction = interactionsArray[i];
          if (!interaction.getActive()) {
            continue;
          }
          var cont = interaction.handleEvent(mapBrowserEvent);
          if (!cont) {
            break;
          }
        }
      }
    };

    /**
     * @protected
     */
    PluggableMap.prototype.handlePostRender = function handlePostRender () {

      var frameState = this.frameState_;

      // Manage the tile queue
      // Image loads are expensive and a limited resource, so try to use them
      // efficiently:
      // * When the view is static we allow a large number of parallel tile loads
      //   to complete the frame as quickly as possible.
      // * When animating or interacting, image loads can cause janks, so we reduce
      //   the maximum number of loads per frame and limit the number of parallel
      //   tile loads to remain reactive to view changes and to reduce the chance of
      //   loading tiles that will quickly disappear from view.
      var tileQueue = this.tileQueue_;
      if (!tileQueue.isEmpty()) {
        var maxTotalLoading = this.maxTilesLoading_;
        var maxNewLoads = maxTotalLoading;
        if (frameState) {
          var hints = frameState.viewHints;
          if (hints[ViewHint.ANIMATING]) {
            maxTotalLoading = this.loadTilesWhileAnimating_ ? 8 : 0;
            maxNewLoads = 2;
          }
          if (hints[ViewHint.INTERACTING]) {
            maxTotalLoading = this.loadTilesWhileInteracting_ ? 8 : 0;
            maxNewLoads = 2;
          }
        }
        if (tileQueue.getTilesLoading() < maxTotalLoading) {
          tileQueue.reprioritize(); // FIXME only call if view has changed
          tileQueue.loadMoreTiles(maxTotalLoading, maxNewLoads);
        }
      }
      if (frameState && this.hasListener(RenderEventType.RENDERCOMPLETE) && !frameState.animate &&
          !this.tileQueue_.getTilesLoading() && !getLoading(this.getLayers().getArray())) {
        this.renderer_.dispatchRenderEvent(RenderEventType.RENDERCOMPLETE, frameState);
      }

      var postRenderFunctions = this.postRenderFunctions_;
      for (var i = 0, ii = postRenderFunctions.length; i < ii; ++i) {
        postRenderFunctions[i](this, frameState);
      }
      postRenderFunctions.length = 0;
    };

    /**
     * @private
     */
    PluggableMap.prototype.handleSizeChanged_ = function handleSizeChanged_ () {
      this.render();
    };

    /**
     * @private
     */
    PluggableMap.prototype.handleTargetChanged_ = function handleTargetChanged_ () {
      // target may be undefined, null, a string or an Element.
      // If it's a string we convert it to an Element before proceeding.
      // If it's not now an Element we remove the viewport from the DOM.
      // If it's an Element we append the viewport element to it.

      var targetElement;
      if (this.getTarget()) {
        targetElement = this.getTargetElement();
      }

      if (this.keyHandlerKeys_) {
        for (var i = 0, ii = this.keyHandlerKeys_.length; i < ii; ++i) {
          unlistenByKey(this.keyHandlerKeys_[i]);
        }
        this.keyHandlerKeys_ = null;
      }

      if (!targetElement) {
        this.renderer_.removeLayerRenderers();
        removeNode(this.viewport_);
        if (this.handleResize_ !== undefined) {
          removeEventListener(EventType.RESIZE, this.handleResize_, false);
          this.handleResize_ = undefined;
        }
      } else {
        targetElement.appendChild(this.viewport_);

        var keyboardEventTarget = !this.keyboardEventTarget_ ?
          targetElement : this.keyboardEventTarget_;
        this.keyHandlerKeys_ = [
          listen(keyboardEventTarget, EventType.KEYDOWN, this.handleBrowserEvent, this),
          listen(keyboardEventTarget, EventType.KEYPRESS, this.handleBrowserEvent, this)
        ];

        if (!this.handleResize_) {
          this.handleResize_ = this.updateSize.bind(this);
          addEventListener(EventType.RESIZE, this.handleResize_, false);
        }
      }

      this.updateSize();
      // updateSize calls setSize, so no need to call this.render
      // ourselves here.
    };

    /**
     * @private
     */
    PluggableMap.prototype.handleTileChange_ = function handleTileChange_ () {
      this.render();
    };

    /**
     * @private
     */
    PluggableMap.prototype.handleViewPropertyChanged_ = function handleViewPropertyChanged_ () {
      this.render();
    };

    /**
     * @private
     */
    PluggableMap.prototype.handleViewChanged_ = function handleViewChanged_ () {
      if (this.viewPropertyListenerKey_) {
        unlistenByKey(this.viewPropertyListenerKey_);
        this.viewPropertyListenerKey_ = null;
      }
      if (this.viewChangeListenerKey_) {
        unlistenByKey(this.viewChangeListenerKey_);
        this.viewChangeListenerKey_ = null;
      }
      var view = this.getView();
      if (view) {
        this.viewport_.setAttribute('data-view', getUid(view));
        this.viewPropertyListenerKey_ = listen(
          view, ObjectEventType.PROPERTYCHANGE,
          this.handleViewPropertyChanged_, this);
        this.viewChangeListenerKey_ = listen(
          view, EventType.CHANGE,
          this.handleViewPropertyChanged_, this);
      }
      this.render();
    };

    /**
     * @private
     */
    PluggableMap.prototype.handleLayerGroupChanged_ = function handleLayerGroupChanged_ () {
      if (this.layerGroupPropertyListenerKeys_) {
        this.layerGroupPropertyListenerKeys_.forEach(unlistenByKey);
        this.layerGroupPropertyListenerKeys_ = null;
      }
      var layerGroup = this.getLayerGroup();
      if (layerGroup) {
        this.layerGroupPropertyListenerKeys_ = [
          listen(
            layerGroup, ObjectEventType.PROPERTYCHANGE,
            this.render, this),
          listen(
            layerGroup, EventType.CHANGE,
            this.render, this)
        ];
      }
      this.render();
    };

    /**
     * @return {boolean} Is rendered.
     */
    PluggableMap.prototype.isRendered = function isRendered () {
      return !!this.frameState_;
    };

    /**
     * Requests an immediate render in a synchronous manner.
     * @api
     */
    PluggableMap.prototype.renderSync = function renderSync () {
      if (this.animationDelayKey_) {
        cancelAnimationFrame(this.animationDelayKey_);
      }
      this.animationDelay_();
    };

    /**
     * Request a map rendering (at the next animation frame).
     * @api
     */
    PluggableMap.prototype.render = function render () {
      if (this.animationDelayKey_ === undefined) {
        this.animationDelayKey_ = requestAnimationFrame(this.animationDelay_);
      }
    };

    /**
     * Remove the given control from the map.
     * @param {import("./control/Control.js").default} control Control.
     * @return {import("./control/Control.js").default|undefined} The removed control (or undefined
     *     if the control was not found).
     * @api
     */
    PluggableMap.prototype.removeControl = function removeControl (control) {
      return this.getControls().remove(control);
    };

    /**
     * Remove the given interaction from the map.
     * @param {import("./interaction/Interaction.js").default} interaction Interaction to remove.
     * @return {import("./interaction/Interaction.js").default|undefined} The removed interaction (or
     *     undefined if the interaction was not found).
     * @api
     */
    PluggableMap.prototype.removeInteraction = function removeInteraction (interaction) {
      return this.getInteractions().remove(interaction);
    };

    /**
     * Removes the given layer from the map.
     * @param {import("./layer/Base.js").default} layer Layer.
     * @return {import("./layer/Base.js").default|undefined} The removed layer (or undefined if the
     *     layer was not found).
     * @api
     */
    PluggableMap.prototype.removeLayer = function removeLayer (layer) {
      var layers = this.getLayerGroup().getLayers();
      return layers.remove(layer);
    };

    /**
     * Remove the given overlay from the map.
     * @param {import("./Overlay.js").default} overlay Overlay.
     * @return {import("./Overlay.js").default|undefined} The removed overlay (or undefined
     *     if the overlay was not found).
     * @api
     */
    PluggableMap.prototype.removeOverlay = function removeOverlay (overlay) {
      return this.getOverlays().remove(overlay);
    };

    /**
     * @param {number} time Time.
     * @private
     */
    PluggableMap.prototype.renderFrame_ = function renderFrame_ (time) {
      var viewState;

      var size = this.getSize();
      var view = this.getView();
      var extent = createEmpty();
      var previousFrameState = this.frameState_;
      /** @type {?FrameState} */
      var frameState = null;
      if (size !== undefined && hasArea(size) && view && view.isDef()) {
        var viewHints = view.getHints(this.frameState_ ? this.frameState_.viewHints : undefined);
        var layerStatesArray = this.getLayerGroup().getLayerStatesArray();
        var layerStates = {};
        for (var i = 0, ii = layerStatesArray.length; i < ii; ++i) {
          layerStates[getUid(layerStatesArray[i].layer)] = layerStatesArray[i];
        }
        viewState = view.getState(this.pixelRatio_);
        frameState = /** @type {FrameState} */ ({
          animate: false,
          coordinateToPixelTransform: this.coordinateToPixelTransform_,
          extent: extent,
          focus: this.focus_ ? this.focus_ : viewState.center,
          index: this.frameIndex_++,
          layerStates: layerStates,
          layerStatesArray: layerStatesArray,
          pixelRatio: this.pixelRatio_,
          pixelToCoordinateTransform: this.pixelToCoordinateTransform_,
          postRenderFunctions: [],
          size: size,
          skippedFeatureUids: this.skippedFeatureUids_,
          tileQueue: this.tileQueue_,
          time: time,
          usedTiles: {},
          viewState: viewState,
          viewHints: viewHints,
          wantedTiles: {}
        });
      }

      if (frameState) {
        frameState.extent = getForViewAndSize(viewState.center,
          viewState.resolution, viewState.rotation, frameState.size, extent);
      }

      this.frameState_ = frameState;
      this.renderer_.renderFrame(frameState);

      if (frameState) {
        if (frameState.animate) {
          this.render();
        }
        Array.prototype.push.apply(this.postRenderFunctions_, frameState.postRenderFunctions);

        if (previousFrameState) {
          var moveStart = !this.previousExtent_ ||
                      (!isEmpty$1(this.previousExtent_) &&
                      !equals$2(frameState.extent, this.previousExtent_));
          if (moveStart) {
            this.dispatchEvent(
              new MapEvent(MapEventType.MOVESTART, this, previousFrameState));
            this.previousExtent_ = createOrUpdateEmpty(this.previousExtent_);
          }
        }

        var idle = this.previousExtent_ &&
            !frameState.viewHints[ViewHint.ANIMATING] &&
            !frameState.viewHints[ViewHint.INTERACTING] &&
            !equals$2(frameState.extent, this.previousExtent_);

        if (idle) {
          this.dispatchEvent(new MapEvent(MapEventType.MOVEEND, this, frameState));
          clone(frameState.extent, this.previousExtent_);
        }
      }

      this.dispatchEvent(new MapEvent(MapEventType.POSTRENDER, this, frameState));

      setTimeout(this.handlePostRender.bind(this), 0);

    };

    /**
     * Sets the layergroup of this map.
     * @param {LayerGroup} layerGroup A layer group containing the layers in this map.
     * @observable
     * @api
     */
    PluggableMap.prototype.setLayerGroup = function setLayerGroup (layerGroup) {
      this.set(MapProperty.LAYERGROUP, layerGroup);
    };

    /**
     * Set the size of this map.
     * @param {import("./size.js").Size|undefined} size The size in pixels of the map in the DOM.
     * @observable
     * @api
     */
    PluggableMap.prototype.setSize = function setSize (size) {
      this.set(MapProperty.SIZE, size);
    };

    /**
     * Set the target element to render this map into.
     * @param {HTMLElement|string|undefined} target The Element or id of the Element
     *     that the map is rendered in.
     * @observable
     * @api
     */
    PluggableMap.prototype.setTarget = function setTarget (target) {
      this.set(MapProperty.TARGET, target);
    };

    /**
     * Set the view for this map.
     * @param {View} view The view that controls this map.
     * @observable
     * @api
     */
    PluggableMap.prototype.setView = function setView (view) {
      this.set(MapProperty.VIEW, view);
    };

    /**
     * @param {import("./Feature.js").default} feature Feature.
     */
    PluggableMap.prototype.skipFeature = function skipFeature (feature) {
      this.skippedFeatureUids_[getUid(feature)] = true;
      this.render();
    };

    /**
     * Force a recalculation of the map viewport size.  This should be called when
     * third-party code changes the size of the map viewport.
     * @api
     */
    PluggableMap.prototype.updateSize = function updateSize () {
      var targetElement = this.getTargetElement();

      if (!targetElement) {
        this.setSize(undefined);
      } else {
        var computedStyle = getComputedStyle(targetElement);
        this.setSize([
          targetElement.offsetWidth -
              parseFloat(computedStyle['borderLeftWidth']) -
              parseFloat(computedStyle['paddingLeft']) -
              parseFloat(computedStyle['paddingRight']) -
              parseFloat(computedStyle['borderRightWidth']),
          targetElement.offsetHeight -
              parseFloat(computedStyle['borderTopWidth']) -
              parseFloat(computedStyle['paddingTop']) -
              parseFloat(computedStyle['paddingBottom']) -
              parseFloat(computedStyle['borderBottomWidth'])
        ]);
      }
    };

    /**
     * @param {import("./Feature.js").default} feature Feature.
     */
    PluggableMap.prototype.unskipFeature = function unskipFeature (feature) {
      delete this.skippedFeatureUids_[getUid(feature)];
      this.render();
    };

    return PluggableMap;
  }(BaseObject));


  /**
   * @param {MapOptions} options Map options.
   * @return {MapOptionsInternal} Internal map options.
   */
  function createOptionsInternal(options) {

    /**
     * @type {HTMLElement|Document}
     */
    var keyboardEventTarget = null;
    if (options.keyboardEventTarget !== undefined) {
      keyboardEventTarget = typeof options.keyboardEventTarget === 'string' ?
        document.getElementById(options.keyboardEventTarget) :
        options.keyboardEventTarget;
    }

    /**
     * @type {Object<string, *>}
     */
    var values = {};

    var layerGroup = options.layers && typeof /** @type {?} */ (options.layers).getLayers === 'function' ?
      /** @type {LayerGroup} */ (options.layers) : new LayerGroup({layers: /** @type {Collection} */ (options.layers)});
    values[MapProperty.LAYERGROUP] = layerGroup;

    values[MapProperty.TARGET] = options.target;

    values[MapProperty.VIEW] = options.view !== undefined ?
      options.view : new View();

    var controls;
    if (options.controls !== undefined) {
      if (Array.isArray(options.controls)) {
        controls = new Collection(options.controls.slice());
      } else {
        assert(typeof /** @type {?} */ (options.controls).getArray === 'function',
          47); // Expected `controls` to be an array or an `import("./Collection.js").Collection`
        controls = /** @type {Collection} */ (options.controls);
      }
    }

    var interactions;
    if (options.interactions !== undefined) {
      if (Array.isArray(options.interactions)) {
        interactions = new Collection(options.interactions.slice());
      } else {
        assert(typeof /** @type {?} */ (options.interactions).getArray === 'function',
          48); // Expected `interactions` to be an array or an `import("./Collection.js").Collection`
        interactions = /** @type {Collection} */ (options.interactions);
      }
    }

    var overlays;
    if (options.overlays !== undefined) {
      if (Array.isArray(options.overlays)) {
        overlays = new Collection(options.overlays.slice());
      } else {
        assert(typeof /** @type {?} */ (options.overlays).getArray === 'function',
          49); // Expected `overlays` to be an array or an `import("./Collection.js").Collection`
        overlays = options.overlays;
      }
    } else {
      overlays = new Collection();
    }

    return {
      controls: controls,
      interactions: interactions,
      keyboardEventTarget: keyboardEventTarget,
      overlays: overlays,
      values: values
    };

  }

  /**
   * @param  {Array<import("./layer/Base.js").default>} layers Layers.
   * @return {boolean} Layers have sources that are still loading.
   */
  function getLoading(layers) {
    for (var i = 0, ii = layers.length; i < ii; ++i) {
      var layer = layers[i];
      if (typeof /** @type {?} */ (layer).getLayers === 'function') {
        return getLoading(/** @type {LayerGroup} */ (layer).getLayers().getArray());
      } else {
        var source = /** @type {import("./layer/Layer.js").default} */ (
          layer).getSource();
        if (source && source.loading) {
          return true;
        }
      }
    }
    return false;
  }

  /**
   * @module ol/control/Control
   */


  /**
   * @typedef {Object} Options
   * @property {HTMLElement} [element] The element is the control's
   * container element. This only needs to be specified if you're developing
   * a custom control.
   * @property {function(import("../MapEvent.js").default)} [render] Function called when
   * the control should be re-rendered. This is called in a `requestAnimationFrame`
   * callback.
   * @property {HTMLElement|string} [target] Specify a target if you want
   * the control to be rendered outside of the map's viewport.
   */


  /**
   * @classdesc
   * A control is a visible widget with a DOM element in a fixed position on the
   * screen. They can involve user input (buttons), or be informational only;
   * the position is determined using CSS. By default these are placed in the
   * container with CSS class name `ol-overlaycontainer-stopevent`, but can use
   * any outside DOM element.
   *
   * This is the base class for controls. You can use it for simple custom
   * controls by creating the element with listeners, creating an instance:
   * ```js
   * var myControl = new Control({element: myElement});
   * ```
   * and then adding this to the map.
   *
   * The main advantage of having this as a control rather than a simple separate
   * DOM element is that preventing propagation is handled for you. Controls
   * will also be objects in a {@link module:ol/Collection~Collection}, so you can use their methods.
   *
   * You can also extend this base for your own control class. See
   * examples/custom-controls for an example of how to do this.
   *
   * @api
   */
  var Control = /*@__PURE__*/(function (BaseObject$$1) {
    function Control(options) {

      BaseObject$$1.call(this);

      /**
       * @protected
       * @type {HTMLElement}
       */
      this.element = options.element ? options.element : null;

      /**
       * @private
       * @type {HTMLElement}
       */
      this.target_ = null;

      /**
       * @private
       * @type {import("../PluggableMap.js").default}
       */
      this.map_ = null;

      /**
       * @protected
       * @type {!Array<import("../events.js").EventsKey>}
       */
      this.listenerKeys = [];

      /**
       * @type {function(import("../MapEvent.js").default)}
       */
      this.render = options.render ? options.render : VOID;

      if (options.target) {
        this.setTarget(options.target);
      }

    }

    if ( BaseObject$$1 ) Control.__proto__ = BaseObject$$1;
    Control.prototype = Object.create( BaseObject$$1 && BaseObject$$1.prototype );
    Control.prototype.constructor = Control;

    /**
     * @inheritDoc
     */
    Control.prototype.disposeInternal = function disposeInternal () {
      removeNode(this.element);
      BaseObject$$1.prototype.disposeInternal.call(this);
    };

    /**
     * Get the map associated with this control.
     * @return {import("../PluggableMap.js").default} Map.
     * @api
     */
    Control.prototype.getMap = function getMap () {
      return this.map_;
    };

    /**
     * Remove the control from its current map and attach it to the new map.
     * Subclasses may set up event handlers to get notified about changes to
     * the map here.
     * @param {import("../PluggableMap.js").default} map Map.
     * @api
     */
    Control.prototype.setMap = function setMap (map) {
      if (this.map_) {
        removeNode(this.element);
      }
      for (var i = 0, ii = this.listenerKeys.length; i < ii; ++i) {
        unlistenByKey(this.listenerKeys[i]);
      }
      this.listenerKeys.length = 0;
      this.map_ = map;
      if (this.map_) {
        var target = this.target_ ?
          this.target_ : map.getOverlayContainerStopEvent();
        target.appendChild(this.element);
        if (this.render !== VOID) {
          this.listenerKeys.push(listen(map,
            MapEventType.POSTRENDER, this.render, this));
        }
        map.render();
      }
    };

    /**
     * This function is used to set a target element for the control. It has no
     * effect if it is called after the control has been added to the map (i.e.
     * after `setMap` is called on the control). If no `target` is set in the
     * options passed to the control constructor and if `setTarget` is not called
     * then the control is added to the map's overlay container.
     * @param {HTMLElement|string} target Target.
     * @api
     */
    Control.prototype.setTarget = function setTarget (target) {
      this.target_ = typeof target === 'string' ?
        document.getElementById(target) :
        target;
    };

    return Control;
  }(BaseObject));

  /**
   * @module ol/css
   */


  /**
   * The CSS class for hidden feature.
   *
   * @const
   * @type {string}
   */
  var CLASS_HIDDEN = 'ol-hidden';


  /**
   * The CSS class that we'll give the DOM elements to have them selectable.
   *
   * @const
   * @type {string}
   */
  var CLASS_SELECTABLE = 'ol-selectable';


  /**
   * The CSS class that we'll give the DOM elements to have them unselectable.
   *
   * @const
   * @type {string}
   */
  var CLASS_UNSELECTABLE = 'ol-unselectable';


  /**
   * The CSS class for unsupported feature.
   *
   * @const
   * @type {string}
   */
  var CLASS_UNSUPPORTED = 'ol-unsupported';


  /**
   * The CSS class for controls.
   *
   * @const
   * @type {string}
   */
  var CLASS_CONTROL = 'ol-control';


  /**
   * The CSS class that we'll give the DOM elements that are collapsed, i.e.
   * to those elements which usually can be expanded.
   *
   * @const
   * @type {string}
   */
  var CLASS_COLLAPSED = 'ol-collapsed';


  /**
   * Get the list of font families from a font spec.  Note that this doesn't work
   * for font families that have commas in them.
   * @param {string} The CSS font property.
   * @return {Object<string>} The font families (or null if the input spec is invalid).
   */
  var getFontFamilies = (function() {
    var style;
    var cache = {};
    return function(font) {
      if (!style) {
        style = document.createElement('div').style;
      }
      if (!(font in cache)) {
        style.font = font;
        var family = style.fontFamily;
        style.font = '';
        if (!family) {
          return null;
        }
        cache[font] = family.split(/,\s?/);
      }
      return cache[font];
    };
  })();

  /**
   * @module ol/layer/Layer
   */


  /**
   * @typedef {Object} Options
   * @property {number} [opacity=1] Opacity (0, 1).
   * @property {boolean} [visible=true] Visibility.
   * @property {import("../extent.js").Extent} [extent] The bounding extent for layer rendering.  The layer will not be
   * rendered outside of this extent.
   * @property {number} [zIndex] The z-index for layer rendering.  At rendering time, the layers
   * will be ordered, first by Z-index and then by position. When `undefined`, a `zIndex` of 0 is assumed
   * for layers that are added to the map's `layers` collection, or `Infinity` when the layer's `setMap()`
   * method was used.
   * @property {number} [minResolution] The minimum resolution (inclusive) at which this layer will be
   * visible.
   * @property {number} [maxResolution] The maximum resolution (exclusive) below which this layer will
   * be visible.
   * @property {import("../source/Source.js").default} [source] Source for this layer.  If not provided to the constructor,
   * the source can be set by calling {@link module:ol/layer/Layer#setSource layer.setSource(source)} after
   * construction.
   * @property {import("../PluggableMap.js").default} [map] Map.
   */


  /**
   * @typedef {Object} State
   * @property {import("./Base.js").default} layer
   * @property {number} opacity
   * @property {SourceState} sourceState
   * @property {boolean} visible
   * @property {boolean} managed
   * @property {import("../extent.js").Extent} [extent]
   * @property {number} zIndex
   * @property {number} maxResolution
   * @property {number} minResolution
   */

  /**
   * @classdesc
   * Abstract base class; normally only used for creating subclasses and not
   * instantiated in apps.
   * A visual representation of raster or vector map data.
   * Layers group together those properties that pertain to how the data is to be
   * displayed, irrespective of the source of that data.
   *
   * Layers are usually added to a map with {@link module:ol/Map#addLayer}. Components
   * like {@link module:ol/interaction/Select~Select} use unmanaged layers
   * internally. These unmanaged layers are associated with the map using
   * {@link module:ol/layer/Layer~Layer#setMap} instead.
   *
   * A generic `change` event is fired when the state of the source changes.
   *
   * @fires import("../render/Event.js").RenderEvent
   */
  var Layer = /*@__PURE__*/(function (BaseLayer$$1) {
    function Layer(options) {

      var baseOptions = assign({}, options);
      delete baseOptions.source;

      BaseLayer$$1.call(this, baseOptions);

      /**
       * @private
       * @type {?import("../events.js").EventsKey}
       */
      this.mapPrecomposeKey_ = null;

      /**
       * @private
       * @type {?import("../events.js").EventsKey}
       */
      this.mapRenderKey_ = null;

      /**
       * @private
       * @type {?import("../events.js").EventsKey}
       */
      this.sourceChangeKey_ = null;

      if (options.map) {
        this.setMap(options.map);
      }

      listen(this,
        getChangeEventType(LayerProperty.SOURCE),
        this.handleSourcePropertyChange_, this);

      var source = options.source ? options.source : null;
      this.setSource(source);
    }

    if ( BaseLayer$$1 ) Layer.__proto__ = BaseLayer$$1;
    Layer.prototype = Object.create( BaseLayer$$1 && BaseLayer$$1.prototype );
    Layer.prototype.constructor = Layer;

    /**
     * @inheritDoc
     */
    Layer.prototype.getLayersArray = function getLayersArray (opt_array) {
      var array = opt_array ? opt_array : [];
      array.push(this);
      return array;
    };

    /**
     * @inheritDoc
     */
    Layer.prototype.getLayerStatesArray = function getLayerStatesArray (opt_states) {
      var states = opt_states ? opt_states : [];
      states.push(this.getLayerState());
      return states;
    };

    /**
     * Get the layer source.
     * @return {import("../source/Source.js").default} The layer source (or `null` if not yet set).
     * @observable
     * @api
     */
    Layer.prototype.getSource = function getSource () {
      var source = this.get(LayerProperty.SOURCE);
      return (
        /** @type {import("../source/Source.js").default} */ (source) || null
      );
    };

    /**
      * @inheritDoc
      */
    Layer.prototype.getSourceState = function getSourceState () {
      var source = this.getSource();
      return !source ? SourceState.UNDEFINED : source.getState();
    };

    /**
     * @private
     */
    Layer.prototype.handleSourceChange_ = function handleSourceChange_ () {
      this.changed();
    };

    /**
     * @private
     */
    Layer.prototype.handleSourcePropertyChange_ = function handleSourcePropertyChange_ () {
      if (this.sourceChangeKey_) {
        unlistenByKey(this.sourceChangeKey_);
        this.sourceChangeKey_ = null;
      }
      var source = this.getSource();
      if (source) {
        this.sourceChangeKey_ = listen(source,
          EventType.CHANGE, this.handleSourceChange_, this);
      }
      this.changed();
    };

    /**
     * Sets the layer to be rendered on top of other layers on a map. The map will
     * not manage this layer in its layers collection, and the callback in
     * {@link module:ol/Map#forEachLayerAtPixel} will receive `null` as layer. This
     * is useful for temporary layers. To remove an unmanaged layer from the map,
     * use `#setMap(null)`.
     *
     * To add the layer to a map and have it managed by the map, use
     * {@link module:ol/Map#addLayer} instead.
     * @param {import("../PluggableMap.js").default} map Map.
     * @api
     */
    Layer.prototype.setMap = function setMap (map) {
      if (this.mapPrecomposeKey_) {
        unlistenByKey(this.mapPrecomposeKey_);
        this.mapPrecomposeKey_ = null;
      }
      if (!map) {
        this.changed();
      }
      if (this.mapRenderKey_) {
        unlistenByKey(this.mapRenderKey_);
        this.mapRenderKey_ = null;
      }
      if (map) {
        this.mapPrecomposeKey_ = listen(map, RenderEventType.PRECOMPOSE, function(evt) {
          var renderEvent = /** @type {import("../render/Event.js").default} */ (evt);
          var layerState = this.getLayerState();
          layerState.managed = false;
          if (this.getZIndex() === undefined) {
            layerState.zIndex = Infinity;
          }
          renderEvent.frameState.layerStatesArray.push(layerState);
          renderEvent.frameState.layerStates[getUid(this)] = layerState;
        }, this);
        this.mapRenderKey_ = listen(this, EventType.CHANGE, map.render, map);
        this.changed();
      }
    };

    /**
     * Set the layer source.
     * @param {import("../source/Source.js").default} source The layer source.
     * @observable
     * @api
     */
    Layer.prototype.setSource = function setSource (source) {
      this.set(LayerProperty.SOURCE, source);
    };

    return Layer;
  }(BaseLayer));


  /**
   * Return `true` if the layer is visible, and if the passed resolution is
   * between the layer's minResolution and maxResolution. The comparison is
   * inclusive for `minResolution` and exclusive for `maxResolution`.
   * @param {State} layerState Layer state.
   * @param {number} resolution Resolution.
   * @return {boolean} The layer is visible at the given resolution.
   */
  function visibleAtResolution(layerState, resolution) {
    return layerState.visible && resolution >= layerState.minResolution &&
        resolution < layerState.maxResolution;
  }

  /**
   * @module ol/control/Attribution
   */


  /**
   * @typedef {Object} Options
   * @property {string} [className='ol-attribution'] CSS class name.
   * @property {HTMLElement|string} [target] Specify a target if you
   * want the control to be rendered outside of the map's
   * viewport.
   * @property {boolean} [collapsible] Specify if attributions can
   * be collapsed. If not specified, sources control this behavior with their
   * `attributionsCollapsible` setting.
   * @property {boolean} [collapsed=true] Specify if attributions should
   * be collapsed at startup.
   * @property {string} [tipLabel='Attributions'] Text label to use for the button tip.
   * @property {string} [label='i'] Text label to use for the
   * collapsed attributions button.
   * Instead of text, also an element (e.g. a `span` element) can be used.
   * @property {string|HTMLElement} [collapseLabel='»'] Text label to use
   * for the expanded attributions button.
   * Instead of text, also an element (e.g. a `span` element) can be used.
   * @property {function(import("../MapEvent.js").default)} [render] Function called when
   * the control should be re-rendered. This is called in a `requestAnimationFrame`
   * callback.
   */


  /**
   * @classdesc
   * Control to show all the attributions associated with the layer sources
   * in the map. This control is one of the default controls included in maps.
   * By default it will show in the bottom right portion of the map, but this can
   * be changed by using a css selector for `.ol-attribution`.
   *
   * @api
   */
  var Attribution = /*@__PURE__*/(function (Control$$1) {
    function Attribution(opt_options) {

      var options = opt_options ? opt_options : {};

      Control$$1.call(this, {
        element: document.createElement('div'),
        render: options.render || render,
        target: options.target
      });

      /**
       * @private
       * @type {HTMLElement}
       */
      this.ulElement_ = document.createElement('ul');

      /**
       * @private
       * @type {boolean}
       */
      this.collapsed_ = options.collapsed !== undefined ? options.collapsed : true;

      /**
       * @private
       * @type {boolean}
       */
      this.overrideCollapsible_ = options.collapsible !== undefined;

      /**
       * @private
       * @type {boolean}
       */
      this.collapsible_ = options.collapsible !== undefined ?
        options.collapsible : true;

      if (!this.collapsible_) {
        this.collapsed_ = false;
      }

      var className = options.className !== undefined ? options.className : 'ol-attribution';

      var tipLabel = options.tipLabel !== undefined ? options.tipLabel : 'Attributions';

      var collapseLabel = options.collapseLabel !== undefined ? options.collapseLabel : '\u00BB';

      if (typeof collapseLabel === 'string') {
        /**
         * @private
         * @type {HTMLElement}
         */
        this.collapseLabel_ = document.createElement('span');
        this.collapseLabel_.textContent = collapseLabel;
      } else {
        this.collapseLabel_ = collapseLabel;
      }

      var label = options.label !== undefined ? options.label : 'i';

      if (typeof label === 'string') {
        /**
         * @private
         * @type {HTMLElement}
         */
        this.label_ = document.createElement('span');
        this.label_.textContent = label;
      } else {
        this.label_ = label;
      }


      var activeLabel = (this.collapsible_ && !this.collapsed_) ?
        this.collapseLabel_ : this.label_;
      var button = document.createElement('button');
      button.setAttribute('type', 'button');
      button.title = tipLabel;
      button.appendChild(activeLabel);

      listen(button, EventType.CLICK, this.handleClick_, this);

      var cssClasses = className + ' ' + CLASS_UNSELECTABLE + ' ' + CLASS_CONTROL +
          (this.collapsed_ && this.collapsible_ ? ' ' + CLASS_COLLAPSED : '') +
          (this.collapsible_ ? '' : ' ol-uncollapsible');
      var element = this.element;
      element.className = cssClasses;
      element.appendChild(this.ulElement_);
      element.appendChild(button);

      /**
       * A list of currently rendered resolutions.
       * @type {Array<string>}
       * @private
       */
      this.renderedAttributions_ = [];

      /**
       * @private
       * @type {boolean}
       */
      this.renderedVisible_ = true;

    }

    if ( Control$$1 ) Attribution.__proto__ = Control$$1;
    Attribution.prototype = Object.create( Control$$1 && Control$$1.prototype );
    Attribution.prototype.constructor = Attribution;

    /**
     * Collect a list of visible attributions and set the collapsible state.
     * @param {import("../PluggableMap.js").FrameState} frameState Frame state.
     * @return {Array<string>} Attributions.
     * @private
     */
    Attribution.prototype.collectSourceAttributions_ = function collectSourceAttributions_ (frameState) {
      /**
       * Used to determine if an attribution already exists.
       * @type {!Object<string, boolean>}
       */
      var lookup = {};

      /**
       * A list of visible attributions.
       * @type {Array<string>}
       */
      var visibleAttributions = [];

      var layerStatesArray = frameState.layerStatesArray;
      var resolution = frameState.viewState.resolution;
      for (var i = 0, ii = layerStatesArray.length; i < ii; ++i) {
        var layerState = layerStatesArray[i];
        if (!visibleAtResolution(layerState, resolution)) {
          continue;
        }

        var source = /** @type {import("../layer/Layer.js").default} */ (layerState.layer).getSource();
        if (!source) {
          continue;
        }

        var attributionGetter = source.getAttributions();
        if (!attributionGetter) {
          continue;
        }

        var attributions = attributionGetter(frameState);
        if (!attributions) {
          continue;
        }

        if (!this.overrideCollapsible_ && source.getAttributionsCollapsible() === false) {
          this.setCollapsible(false);
        }

        if (Array.isArray(attributions)) {
          for (var j = 0, jj = attributions.length; j < jj; ++j) {
            if (!(attributions[j] in lookup)) {
              visibleAttributions.push(attributions[j]);
              lookup[attributions[j]] = true;
            }
          }
        } else {
          if (!(attributions in lookup)) {
            visibleAttributions.push(attributions);
            lookup[attributions] = true;
          }
        }
      }
      return visibleAttributions;
    };

    /**
     * @private
     * @param {?import("../PluggableMap.js").FrameState} frameState Frame state.
     */
    Attribution.prototype.updateElement_ = function updateElement_ (frameState) {
      if (!frameState) {
        if (this.renderedVisible_) {
          this.element.style.display = 'none';
          this.renderedVisible_ = false;
        }
        return;
      }

      var attributions = this.collectSourceAttributions_(frameState);

      var visible = attributions.length > 0;
      if (this.renderedVisible_ != visible) {
        this.element.style.display = visible ? '' : 'none';
        this.renderedVisible_ = visible;
      }

      if (equals(attributions, this.renderedAttributions_)) {
        return;
      }

      removeChildren(this.ulElement_);

      // append the attributions
      for (var i = 0, ii = attributions.length; i < ii; ++i) {
        var element = document.createElement('li');
        element.innerHTML = attributions[i];
        this.ulElement_.appendChild(element);
      }

      this.renderedAttributions_ = attributions;
    };

    /**
     * @param {MouseEvent} event The event to handle
     * @private
     */
    Attribution.prototype.handleClick_ = function handleClick_ (event) {
      event.preventDefault();
      this.handleToggle_();
    };

    /**
     * @private
     */
    Attribution.prototype.handleToggle_ = function handleToggle_ () {
      this.element.classList.toggle(CLASS_COLLAPSED);
      if (this.collapsed_) {
        replaceNode(this.collapseLabel_, this.label_);
      } else {
        replaceNode(this.label_, this.collapseLabel_);
      }
      this.collapsed_ = !this.collapsed_;
    };

    /**
     * Return `true` if the attribution is collapsible, `false` otherwise.
     * @return {boolean} True if the widget is collapsible.
     * @api
     */
    Attribution.prototype.getCollapsible = function getCollapsible () {
      return this.collapsible_;
    };

    /**
     * Set whether the attribution should be collapsible.
     * @param {boolean} collapsible True if the widget is collapsible.
     * @api
     */
    Attribution.prototype.setCollapsible = function setCollapsible (collapsible) {
      if (this.collapsible_ === collapsible) {
        return;
      }
      this.collapsible_ = collapsible;
      this.element.classList.toggle('ol-uncollapsible');
      if (!collapsible && this.collapsed_) {
        this.handleToggle_();
      }
    };

    /**
     * Collapse or expand the attribution according to the passed parameter. Will
     * not do anything if the attribution isn't collapsible or if the current
     * collapsed state is already the one requested.
     * @param {boolean} collapsed True if the widget is collapsed.
     * @api
     */
    Attribution.prototype.setCollapsed = function setCollapsed (collapsed) {
      if (!this.collapsible_ || this.collapsed_ === collapsed) {
        return;
      }
      this.handleToggle_();
    };

    /**
     * Return `true` when the attribution is currently collapsed or `false`
     * otherwise.
     * @return {boolean} True if the widget is collapsed.
     * @api
     */
    Attribution.prototype.getCollapsed = function getCollapsed () {
      return this.collapsed_;
    };

    return Attribution;
  }(Control));


  /**
   * Update the attribution element.
   * @param {import("../MapEvent.js").default} mapEvent Map event.
   * @this {Attribution}
   * @api
   */
  function render(mapEvent) {
    this.updateElement_(mapEvent.frameState);
  }

  /**
   * @module ol/control/FullScreen
   */


  /**
   * @return {string} Change type.
   */
  var getChangeType = (function() {
    var changeType;
    return function() {
      if (!changeType) {
        var body = document.body;
        if (body.webkitRequestFullscreen) {
          changeType = 'webkitfullscreenchange';
        } else if (body.mozRequestFullScreen) {
          changeType = 'mozfullscreenchange';
        } else if (body.msRequestFullscreen) {
          changeType = 'MSFullscreenChange';
        } else if (body.requestFullscreen) {
          changeType = 'fullscreenchange';
        }
      }
      return changeType;
    };
  })();


  /**
   * @typedef {Object} Options
   * @property {string} [className='ol-full-screen'] CSS class name.
   * @property {string|Text} [label='\u2922'] Text label to use for the button.
   * Instead of text, also an element (e.g. a `span` element) can be used.
   * @property {string|Text} [labelActive='\u00d7'] Text label to use for the
   * button when full-screen is active.
   * Instead of text, also an element (e.g. a `span` element) can be used.
   * @property {string} [tipLabel='Toggle full-screen'] Text label to use for the button tip.
   * @property {boolean} [keys=false] Full keyboard access.
   * @property {HTMLElement|string} [target] Specify a target if you want the
   * control to be rendered outside of the map's viewport.
   * @property {HTMLElement|string} [source] The element to be displayed
   * fullscreen. When not provided, the element containing the map viewport will
   * be displayed fullscreen.
   */


  /**
   * @classdesc
   * Provides a button that when clicked fills up the full screen with the map.
   * The full screen source element is by default the element containing the map viewport unless
   * overridden by providing the `source` option. In which case, the dom
   * element introduced using this parameter will be displayed in full screen.
   *
   * When in full screen mode, a close button is shown to exit full screen mode.
   * The [Fullscreen API](http://www.w3.org/TR/fullscreen/) is used to
   * toggle the map in full screen mode.
   *
   * @api
   */
  var FullScreen = /*@__PURE__*/(function (Control$$1) {
    function FullScreen(opt_options) {

      var options = opt_options ? opt_options : {};

      Control$$1.call(this, {
        element: document.createElement('div'),
        target: options.target
      });

      /**
       * @private
       * @type {string}
       */
      this.cssClassName_ = options.className !== undefined ? options.className :
        'ol-full-screen';

      var label = options.label !== undefined ? options.label : '\u2922';

      /**
       * @private
       * @type {Text}
       */
      this.labelNode_ = typeof label === 'string' ?
        document.createTextNode(label) : label;

      var labelActive = options.labelActive !== undefined ? options.labelActive : '\u00d7';

      /**
       * @private
       * @type {Text}
       */
      this.labelActiveNode_ = typeof labelActive === 'string' ?
        document.createTextNode(labelActive) : labelActive;

      /**
       * @private
       * @type {HTMLElement}
       */
      this.button_ = document.createElement('button');

      var tipLabel = options.tipLabel ? options.tipLabel : 'Toggle full-screen';
      this.setClassName_(this.button_, isFullScreen());
      this.button_.setAttribute('type', 'button');
      this.button_.title = tipLabel;
      this.button_.appendChild(this.labelNode_);

      listen(this.button_, EventType.CLICK,
        this.handleClick_, this);

      var cssClasses = this.cssClassName_ + ' ' + CLASS_UNSELECTABLE +
          ' ' + CLASS_CONTROL + ' ' +
          (!isFullScreenSupported() ? CLASS_UNSUPPORTED : '');
      var element = this.element;
      element.className = cssClasses;
      element.appendChild(this.button_);

      /**
       * @private
       * @type {boolean}
       */
      this.keys_ = options.keys !== undefined ? options.keys : false;

      /**
       * @private
       * @type {HTMLElement|string|undefined}
       */
      this.source_ = options.source;

    }

    if ( Control$$1 ) FullScreen.__proto__ = Control$$1;
    FullScreen.prototype = Object.create( Control$$1 && Control$$1.prototype );
    FullScreen.prototype.constructor = FullScreen;

    /**
     * @param {MouseEvent} event The event to handle
     * @private
     */
    FullScreen.prototype.handleClick_ = function handleClick_ (event) {
      event.preventDefault();
      this.handleFullScreen_();
    };

    /**
     * @private
     */
    FullScreen.prototype.handleFullScreen_ = function handleFullScreen_ () {
      if (!isFullScreenSupported()) {
        return;
      }
      var map = this.getMap();
      if (!map) {
        return;
      }
      if (isFullScreen()) {
        exitFullScreen();
      } else {
        var element;
        if (this.source_) {
          element = typeof this.source_ === 'string' ?
            document.getElementById(this.source_) :
            this.source_;
        } else {
          element = map.getTargetElement();
        }
        if (this.keys_) {
          requestFullScreenWithKeys(element);

        } else {
          requestFullScreen(element);
        }
      }
    };

    /**
     * @private
     */
    FullScreen.prototype.handleFullScreenChange_ = function handleFullScreenChange_ () {
      var map = this.getMap();
      if (isFullScreen()) {
        this.setClassName_(this.button_, true);
        replaceNode(this.labelActiveNode_, this.labelNode_);
      } else {
        this.setClassName_(this.button_, false);
        replaceNode(this.labelNode_, this.labelActiveNode_);
      }
      if (map) {
        map.updateSize();
      }
    };

    /**
     * @param {HTMLElement} element Target element
     * @param {boolean} fullscreen True if fullscreen class name should be active
     * @private
     */
    FullScreen.prototype.setClassName_ = function setClassName_ (element, fullscreen) {
      var activeClassName = this.cssClassName_ + '-true';
      var inactiveClassName = this.cssClassName_ + '-false';
      var nextClassName = fullscreen ? activeClassName : inactiveClassName;
      element.classList.remove(activeClassName);
      element.classList.remove(inactiveClassName);
      element.classList.add(nextClassName);
    };

    /**
     * @inheritDoc
     * @api
     */
    FullScreen.prototype.setMap = function setMap (map) {
      Control$$1.prototype.setMap.call(this, map);
      if (map) {
        this.listenerKeys.push(listen(document,
          getChangeType(),
          this.handleFullScreenChange_, this)
        );
      }
    };

    return FullScreen;
  }(Control));


  /**
   * @return {boolean} Fullscreen is supported by the current platform.
   */
  function isFullScreenSupported() {
    var body = document.body;
    return !!(
      body.webkitRequestFullscreen ||
      (body.mozRequestFullScreen && document.mozFullScreenEnabled) ||
      (body.msRequestFullscreen && document.msFullscreenEnabled) ||
      (body.requestFullscreen && document.fullscreenEnabled)
    );
  }

  /**
   * @return {boolean} Element is currently in fullscreen.
   */
  function isFullScreen() {
    return !!(
      document.webkitIsFullScreen || document.mozFullScreen ||
      document.msFullscreenElement || document.fullscreenElement
    );
  }

  /**
   * Request to fullscreen an element.
   * @param {HTMLElement} element Element to request fullscreen
   */
  function requestFullScreen(element) {
    if (element.requestFullscreen) {
      element.requestFullscreen();
    } else if (element.msRequestFullscreen) {
      element.msRequestFullscreen();
    } else if (element.mozRequestFullScreen) {
      element.mozRequestFullScreen();
    } else if (element.webkitRequestFullscreen) {
      element.webkitRequestFullscreen();
    }
  }

  /**
   * Request to fullscreen an element with keyboard input.
   * @param {HTMLElement} element Element to request fullscreen
   */
  function requestFullScreenWithKeys(element) {
    if (element.mozRequestFullScreenWithKeys) {
      element.mozRequestFullScreenWithKeys();
    } else if (element.webkitRequestFullscreen) {
      element.webkitRequestFullscreen();
    } else {
      requestFullScreen(element);
    }
  }

  /**
   * Exit fullscreen.
   */
  function exitFullScreen() {
    if (document.exitFullscreen) {
      document.exitFullscreen();
    } else if (document.msExitFullscreen) {
      document.msExitFullscreen();
    } else if (document.mozCancelFullScreen) {
      document.mozCancelFullScreen();
    } else if (document.webkitExitFullscreen) {
      document.webkitExitFullscreen();
    }
  }

  /**
   * @module ol/control/MousePosition
   */


  /**
   * @type {string}
   */
  var PROJECTION = 'projection';

  /**
   * @type {string}
   */
  var COORDINATE_FORMAT = 'coordinateFormat';


  /**
   * @typedef {Object} Options
   * @property {string} [className='ol-mouse-position'] CSS class name.
   * @property {import("../coordinate.js").CoordinateFormat} [coordinateFormat] Coordinate format.
   * @property {import("../proj.js").ProjectionLike} [projection] Projection. Default is the view projection.
   * @property {function(import("../MapEvent.js").default)} [render] Function called when the
   * control should be re-rendered. This is called in a `requestAnimationFrame`
   * callback.
   * @property {HTMLElement|string} [target] Specify a target if you want the
   * control to be rendered outside of the map's viewport.
   * @property {string} [undefinedHTML='&#160;'] Markup to show when coordinates are not
   * available (e.g. when the pointer leaves the map viewport).  By default, the last position
   * will be replaced with `'&#160;'` (`&nbsp;`) when the pointer leaves the viewport.  To
   * retain the last rendered position, set this option to something falsey (like an empty
   * string `''`).
   */


  /**
   * @classdesc
   * A control to show the 2D coordinates of the mouse cursor. By default, these
   * are in the view projection, but can be in any supported projection.
   * By default the control is shown in the top right corner of the map, but this
   * can be changed by using the css selector `.ol-mouse-position`.
   *
   * On touch devices, which usually do not have a mouse cursor, the coordinates
   * of the currently touched position are shown.
   *
   * @api
   */
  var MousePosition = /*@__PURE__*/(function (Control$$1) {
    function MousePosition(opt_options) {

      var options = opt_options ? opt_options : {};

      var element = document.createElement('div');
      element.className = options.className !== undefined ? options.className : 'ol-mouse-position';

      Control$$1.call(this, {
        element: element,
        render: options.render || render$1,
        target: options.target
      });

      listen(this,
        getChangeEventType(PROJECTION),
        this.handleProjectionChanged_, this);

      if (options.coordinateFormat) {
        this.setCoordinateFormat(options.coordinateFormat);
      }
      if (options.projection) {
        this.setProjection(options.projection);
      }

      /**
       * @private
       * @type {string}
       */
      this.undefinedHTML_ = options.undefinedHTML !== undefined ? options.undefinedHTML : '&#160;';

      /**
       * @private
       * @type {boolean}
       */
      this.renderOnMouseOut_ = !!this.undefinedHTML_;

      /**
       * @private
       * @type {string}
       */
      this.renderedHTML_ = element.innerHTML;

      /**
       * @private
       * @type {import("../proj/Projection.js").default}
       */
      this.mapProjection_ = null;

      /**
       * @private
       * @type {?import("../proj.js").TransformFunction}
       */
      this.transform_ = null;

      /**
       * @private
       * @type {import("../pixel.js").Pixel}
       */
      this.lastMouseMovePixel_ = null;

    }

    if ( Control$$1 ) MousePosition.__proto__ = Control$$1;
    MousePosition.prototype = Object.create( Control$$1 && Control$$1.prototype );
    MousePosition.prototype.constructor = MousePosition;

    /**
     * @private
     */
    MousePosition.prototype.handleProjectionChanged_ = function handleProjectionChanged_ () {
      this.transform_ = null;
    };

    /**
     * Return the coordinate format type used to render the current position or
     * undefined.
     * @return {import("../coordinate.js").CoordinateFormat|undefined} The format to render the current
     *     position in.
     * @observable
     * @api
     */
    MousePosition.prototype.getCoordinateFormat = function getCoordinateFormat () {
      return (
        /** @type {import("../coordinate.js").CoordinateFormat|undefined} */ (this.get(COORDINATE_FORMAT))
      );
    };

    /**
     * Return the projection that is used to report the mouse position.
     * @return {import("../proj/Projection.js").default|undefined} The projection to report mouse
     *     position in.
     * @observable
     * @api
     */
    MousePosition.prototype.getProjection = function getProjection () {
      return (
        /** @type {import("../proj/Projection.js").default|undefined} */ (this.get(PROJECTION))
      );
    };

    /**
     * @param {Event} event Browser event.
     * @protected
     */
    MousePosition.prototype.handleMouseMove = function handleMouseMove (event) {
      var map = this.getMap();
      this.lastMouseMovePixel_ = map.getEventPixel(event);
      this.updateHTML_(this.lastMouseMovePixel_);
    };

    /**
     * @param {Event} event Browser event.
     * @protected
     */
    MousePosition.prototype.handleMouseOut = function handleMouseOut (event) {
      this.updateHTML_(null);
      this.lastMouseMovePixel_ = null;
    };

    /**
     * @inheritDoc
     * @api
     */
    MousePosition.prototype.setMap = function setMap (map) {
      Control$$1.prototype.setMap.call(this, map);
      if (map) {
        var viewport = map.getViewport();
        this.listenerKeys.push(
          listen(viewport, EventType.MOUSEMOVE, this.handleMouseMove, this),
          listen(viewport, EventType.TOUCHSTART, this.handleMouseMove, this)
        );
        if (this.renderOnMouseOut_) {
          this.listenerKeys.push(
            listen(viewport, EventType.MOUSEOUT, this.handleMouseOut, this),
            listen(viewport, EventType.TOUCHEND, this.handleMouseOut, this)
          );
        }
      }
    };

    /**
     * Set the coordinate format type used to render the current position.
     * @param {import("../coordinate.js").CoordinateFormat} format The format to render the current
     *     position in.
     * @observable
     * @api
     */
    MousePosition.prototype.setCoordinateFormat = function setCoordinateFormat (format) {
      this.set(COORDINATE_FORMAT, format);
    };

    /**
     * Set the projection that is used to report the mouse position.
     * @param {import("../proj.js").ProjectionLike} projection The projection to report mouse
     *     position in.
     * @observable
     * @api
     */
    MousePosition.prototype.setProjection = function setProjection (projection) {
      this.set(PROJECTION, get$2(projection));
    };

    /**
     * @param {?import("../pixel.js").Pixel} pixel Pixel.
     * @private
     */
    MousePosition.prototype.updateHTML_ = function updateHTML_ (pixel) {
      var html = this.undefinedHTML_;
      if (pixel && this.mapProjection_) {
        if (!this.transform_) {
          var projection = this.getProjection();
          if (projection) {
            this.transform_ = getTransformFromProjections(
              this.mapProjection_, projection);
          } else {
            this.transform_ = identityTransform;
          }
        }
        var map = this.getMap();
        var coordinate = map.getCoordinateFromPixel(pixel);
        if (coordinate) {
          this.transform_(coordinate, coordinate);
          var coordinateFormat = this.getCoordinateFormat();
          if (coordinateFormat) {
            html = coordinateFormat(coordinate);
          } else {
            html = coordinate.toString();
          }
        }
      }
      if (!this.renderedHTML_ || html !== this.renderedHTML_) {
        this.element.innerHTML = html;
        this.renderedHTML_ = html;
      }
    };

    return MousePosition;
  }(Control));


  /**
   * Update the projection. Rendering of the coordinates is done in
   * `handleMouseMove` and `handleMouseUp`.
   * @param {import("../MapEvent.js").default} mapEvent Map event.
   * @this {MousePosition}
   * @api
   */
  function render$1(mapEvent) {
    var frameState = mapEvent.frameState;
    if (!frameState) {
      this.mapProjection_ = null;
    } else {
      if (this.mapProjection_ != frameState.viewState.projection) {
        this.mapProjection_ = frameState.viewState.projection;
        this.transform_ = null;
      }
    }
  }

  /**
   * @module ol/control/Rotate
   */


  /**
   * @typedef {Object} Options
   * @property {string} [className='ol-rotate'] CSS class name.
   * @property {string|HTMLElement} [label='⇧'] Text label to use for the rotate button.
   * Instead of text, also an element (e.g. a `span` element) can be used.
   * @property {string} [tipLabel='Reset rotation'] Text label to use for the rotate tip.
   * @property {number} [duration=250] Animation duration in milliseconds.
   * @property {boolean} [autoHide=true] Hide the control when rotation is 0.
   * @property {function(import("../MapEvent.js").default)} [render] Function called when the control should
   * be re-rendered. This is called in a `requestAnimationFrame` callback.
   * @property {function()} [resetNorth] Function called when the control is clicked.
   * This will override the default `resetNorth`.
   * @property {HTMLElement|string} [target] Specify a target if you want the control to be
   * rendered outside of the map's viewport.
   */


  /**
   * @classdesc
   * A button control to reset rotation to 0.
   * To style this control use css selector `.ol-rotate`. A `.ol-hidden` css
   * selector is added to the button when the rotation is 0.
   *
   * @api
   */
  var Rotate = /*@__PURE__*/(function (Control$$1) {
    function Rotate(opt_options) {

      var options = opt_options ? opt_options : {};

      Control$$1.call(this, {
        element: document.createElement('div'),
        render: options.render || render$2,
        target: options.target
      });

      var className = options.className !== undefined ? options.className : 'ol-rotate';

      var label = options.label !== undefined ? options.label : '\u21E7';

      /**
       * @type {HTMLElement}
       * @private
       */
      this.label_ = null;

      if (typeof label === 'string') {
        this.label_ = document.createElement('span');
        this.label_.className = 'ol-compass';
        this.label_.textContent = label;
      } else {
        this.label_ = label;
        this.label_.classList.add('ol-compass');
      }

      var tipLabel = options.tipLabel ? options.tipLabel : 'Reset rotation';

      var button = document.createElement('button');
      button.className = className + '-reset';
      button.setAttribute('type', 'button');
      button.title = tipLabel;
      button.appendChild(this.label_);

      listen(button, EventType.CLICK, this.handleClick_, this);

      var cssClasses = className + ' ' + CLASS_UNSELECTABLE + ' ' + CLASS_CONTROL;
      var element = this.element;
      element.className = cssClasses;
      element.appendChild(button);

      this.callResetNorth_ = options.resetNorth ? options.resetNorth : undefined;

      /**
       * @type {number}
       * @private
       */
      this.duration_ = options.duration !== undefined ? options.duration : 250;

      /**
       * @type {boolean}
       * @private
       */
      this.autoHide_ = options.autoHide !== undefined ? options.autoHide : true;

      /**
       * @private
       * @type {number|undefined}
       */
      this.rotation_ = undefined;

      if (this.autoHide_) {
        this.element.classList.add(CLASS_HIDDEN);
      }

    }

    if ( Control$$1 ) Rotate.__proto__ = Control$$1;
    Rotate.prototype = Object.create( Control$$1 && Control$$1.prototype );
    Rotate.prototype.constructor = Rotate;

    /**
     * @param {MouseEvent} event The event to handle
     * @private
     */
    Rotate.prototype.handleClick_ = function handleClick_ (event) {
      event.preventDefault();
      if (this.callResetNorth_ !== undefined) {
        this.callResetNorth_();
      } else {
        this.resetNorth_();
      }
    };

    /**
     * @private
     */
    Rotate.prototype.resetNorth_ = function resetNorth_ () {
      var map = this.getMap();
      var view = map.getView();
      if (!view) {
        // the map does not have a view, so we can't act
        // upon it
        return;
      }
      if (view.getRotation() !== undefined) {
        if (this.duration_ > 0) {
          view.animate({
            rotation: 0,
            duration: this.duration_,
            easing: easeOut
          });
        } else {
          view.setRotation(0);
        }
      }
    };

    return Rotate;
  }(Control));


  /**
   * Update the rotate control element.
   * @param {import("../MapEvent.js").default} mapEvent Map event.
   * @this {Rotate}
   * @api
   */
  function render$2(mapEvent) {
    var frameState = mapEvent.frameState;
    if (!frameState) {
      return;
    }
    var rotation = frameState.viewState.rotation;
    if (rotation != this.rotation_) {
      var transform = 'rotate(' + rotation + 'rad)';
      if (this.autoHide_) {
        var contains = this.element.classList.contains(CLASS_HIDDEN);
        if (!contains && rotation === 0) {
          this.element.classList.add(CLASS_HIDDEN);
        } else if (contains && rotation !== 0) {
          this.element.classList.remove(CLASS_HIDDEN);
        }
      }
      this.label_.style.msTransform = transform;
      this.label_.style.webkitTransform = transform;
      this.label_.style.transform = transform;
    }
    this.rotation_ = rotation;
  }

  /**
   * @module ol/control/Zoom
   */


  /**
   * @typedef {Object} Options
   * @property {number} [duration=250] Animation duration in milliseconds.
   * @property {string} [className='ol-zoom'] CSS class name.
   * @property {string|HTMLElement} [zoomInLabel='+'] Text label to use for the zoom-in
   * button. Instead of text, also an element (e.g. a `span` element) can be used.
   * @property {string|HTMLElement} [zoomOutLabel='-'] Text label to use for the zoom-out button.
   * Instead of text, also an element (e.g. a `span` element) can be used.
   * @property {string} [zoomInTipLabel='Zoom in'] Text label to use for the button tip.
   * @property {string} [zoomOutTipLabel='Zoom out'] Text label to use for the button tip.
   * @property {number} [delta=1] The zoom delta applied on each click.
   * @property {HTMLElement|string} [target] Specify a target if you want the control to be
   * rendered outside of the map's viewport.
   */


  /**
   * @classdesc
   * A control with 2 buttons, one for zoom in and one for zoom out.
   * This control is one of the default controls of a map. To style this control
   * use css selectors `.ol-zoom-in` and `.ol-zoom-out`.
   *
   * @api
   */
  var Zoom = /*@__PURE__*/(function (Control$$1) {
    function Zoom(opt_options) {

      var options = opt_options ? opt_options : {};

      Control$$1.call(this, {
        element: document.createElement('div'),
        target: options.target
      });

      var className = options.className !== undefined ? options.className : 'ol-zoom';

      var delta = options.delta !== undefined ? options.delta : 1;

      var zoomInLabel = options.zoomInLabel !== undefined ? options.zoomInLabel : '+';
      var zoomOutLabel = options.zoomOutLabel !== undefined ? options.zoomOutLabel : '\u2212';

      var zoomInTipLabel = options.zoomInTipLabel !== undefined ?
        options.zoomInTipLabel : 'Zoom in';
      var zoomOutTipLabel = options.zoomOutTipLabel !== undefined ?
        options.zoomOutTipLabel : 'Zoom out';

      var inElement = document.createElement('button');
      inElement.className = className + '-in';
      inElement.setAttribute('type', 'button');
      inElement.title = zoomInTipLabel;
      inElement.appendChild(
        typeof zoomInLabel === 'string' ? document.createTextNode(zoomInLabel) : zoomInLabel
      );

      listen(inElement, EventType.CLICK, this.handleClick_.bind(this, delta));

      var outElement = document.createElement('button');
      outElement.className = className + '-out';
      outElement.setAttribute('type', 'button');
      outElement.title = zoomOutTipLabel;
      outElement.appendChild(
        typeof zoomOutLabel === 'string' ? document.createTextNode(zoomOutLabel) : zoomOutLabel
      );

      listen(outElement, EventType.CLICK, this.handleClick_.bind(this, -delta));

      var cssClasses = className + ' ' + CLASS_UNSELECTABLE + ' ' + CLASS_CONTROL;
      var element = this.element;
      element.className = cssClasses;
      element.appendChild(inElement);
      element.appendChild(outElement);

      /**
       * @type {number}
       * @private
       */
      this.duration_ = options.duration !== undefined ? options.duration : 250;

    }

    if ( Control$$1 ) Zoom.__proto__ = Control$$1;
    Zoom.prototype = Object.create( Control$$1 && Control$$1.prototype );
    Zoom.prototype.constructor = Zoom;

    /**
     * @param {number} delta Zoom delta.
     * @param {MouseEvent} event The event to handle
     * @private
     */
    Zoom.prototype.handleClick_ = function handleClick_ (delta, event) {
      event.preventDefault();
      this.zoomByDelta_(delta);
    };

    /**
     * @param {number} delta Zoom delta.
     * @private
     */
    Zoom.prototype.zoomByDelta_ = function zoomByDelta_ (delta) {
      var map = this.getMap();
      var view = map.getView();
      if (!view) {
        // the map does not have a view, so we can't act
        // upon it
        return;
      }
      var currentResolution = view.getResolution();
      if (currentResolution) {
        var newResolution = view.constrainResolution(currentResolution, delta);
        if (this.duration_ > 0) {
          if (view.getAnimating()) {
            view.cancelAnimations();
          }
          view.animate({
            resolution: newResolution,
            duration: this.duration_,
            easing: easeOut
          });
        } else {
          view.setResolution(newResolution);
        }
      }
    };

    return Zoom;
  }(Control));

  /**
   * @module ol/control/util
   */


  /**
   * @typedef {Object} DefaultsOptions
   * @property {boolean} [attribution=true] Include
   * {@link module:ol/control/Attribution~Attribution}.
   * @property {import("./Attribution.js").Options} [attributionOptions]
   * Options for {@link module:ol/control/Attribution~Attribution}.
   * @property {boolean} [rotate=true] Include
   * {@link module:ol/control/Rotate~Rotate}.
   * @property {import("./Rotate.js").Options} [rotateOptions] Options
   * for {@link module:ol/control/Rotate~Rotate}.
   * @property {boolean} [zoom] Include {@link module:ol/control/Zoom~Zoom}.
   * @property {import("./Zoom.js").Options} [zoomOptions] Options for
   * {@link module:ol/control/Zoom~Zoom}.
   * @api
   */


  /**
   * Set of controls included in maps by default. Unless configured otherwise,
   * this returns a collection containing an instance of each of the following
   * controls:
   * * {@link module:ol/control/Zoom~Zoom}
   * * {@link module:ol/control/Rotate~Rotate}
   * * {@link module:ol/control/Attribution~Attribution}
   *
   * @param {DefaultsOptions=} opt_options
   * Defaults options.
   * @return {Collection<import("./Control.js").default>}
   * Controls.
   * @function module:ol/control.defaults
   * @api
   */
  function defaults(opt_options) {

    var options = opt_options ? opt_options : {};

    var controls = new Collection();

    var zoomControl = options.zoom !== undefined ? options.zoom : true;
    if (zoomControl) {
      controls.push(new Zoom(options.zoomOptions));
    }

    var rotateControl = options.rotate !== undefined ? options.rotate : true;
    if (rotateControl) {
      controls.push(new Rotate(options.rotateOptions));
    }

    var attributionControl = options.attribution !== undefined ?
      options.attribution : true;
    if (attributionControl) {
      controls.push(new Attribution(options.attributionOptions));
    }

    return controls;
  }

  /**
   * @module ol/Kinetic
   */

  /**
   * @classdesc
   * Implementation of inertial deceleration for map movement.
   *
   * @api
   */
  var Kinetic = function Kinetic(decay, minVelocity, delay) {

    /**
     * @private
     * @type {number}
     */
    this.decay_ = decay;

    /**
     * @private
     * @type {number}
     */
    this.minVelocity_ = minVelocity;

    /**
     * @private
     * @type {number}
     */
    this.delay_ = delay;

    /**
     * @private
     * @type {Array<number>}
     */
    this.points_ = [];

    /**
     * @private
     * @type {number}
     */
    this.angle_ = 0;

    /**
     * @private
     * @type {number}
     */
    this.initialVelocity_ = 0;
  };

  /**
   * FIXME empty description for jsdoc
   */
  Kinetic.prototype.begin = function begin () {
    this.points_.length = 0;
    this.angle_ = 0;
    this.initialVelocity_ = 0;
  };

  /**
   * @param {number} x X.
   * @param {number} y Y.
   */
  Kinetic.prototype.update = function update (x, y) {
    this.points_.push(x, y, Date.now());
  };

  /**
   * @return {boolean} Whether we should do kinetic animation.
   */
  Kinetic.prototype.end = function end () {
    if (this.points_.length < 6) {
      // at least 2 points are required (i.e. there must be at least 6 elements
      // in the array)
      return false;
    }
    var delay = Date.now() - this.delay_;
    var lastIndex = this.points_.length - 3;
    if (this.points_[lastIndex + 2] < delay) {
      // the last tracked point is too old, which means that the user stopped
      // panning before releasing the map
      return false;
    }

    // get the first point which still falls into the delay time
    var firstIndex = lastIndex - 3;
    while (firstIndex > 0 && this.points_[firstIndex + 2] > delay) {
      firstIndex -= 3;
    }

    var duration = this.points_[lastIndex + 2] - this.points_[firstIndex + 2];
    // we don't want a duration of 0 (divide by zero)
    // we also make sure the user panned for a duration of at least one frame
    // (1/60s) to compute sane displacement values
    if (duration < 1000 / 60) {
      return false;
    }

    var dx = this.points_[lastIndex] - this.points_[firstIndex];
    var dy = this.points_[lastIndex + 1] - this.points_[firstIndex + 1];
    this.angle_ = Math.atan2(dy, dx);
    this.initialVelocity_ = Math.sqrt(dx * dx + dy * dy) / duration;
    return this.initialVelocity_ > this.minVelocity_;
  };

  /**
   * @return {number} Total distance travelled (pixels).
   */
  Kinetic.prototype.getDistance = function getDistance () {
    return (this.minVelocity_ - this.initialVelocity_) / this.decay_;
  };

  /**
   * @return {number} Angle of the kinetic panning animation (radians).
   */
  Kinetic.prototype.getAngle = function getAngle () {
    return this.angle_;
  };

  /**
   * @module ol/interaction/Property
   */

  /**
   * @enum {string}
   */
  var InteractionProperty = {
    ACTIVE: 'active'
  };

  /**
   * @module ol/interaction/Interaction
   */


  /**
   * Object literal with config options for interactions.
   * @typedef {Object} InteractionOptions
   * @property {function(import("../MapBrowserEvent.js").default):boolean} handleEvent
   * Method called by the map to notify the interaction that a browser event was
   * dispatched to the map. If the function returns a falsy value, propagation of
   * the event to other interactions in the map's interactions chain will be
   * prevented (this includes functions with no explicit return).
   */


  /**
   * @classdesc
   * Abstract base class; normally only used for creating subclasses and not
   * instantiated in apps.
   * User actions that change the state of the map. Some are similar to controls,
   * but are not associated with a DOM element.
   * For example, {@link module:ol/interaction/KeyboardZoom~KeyboardZoom} is
   * functionally the same as {@link module:ol/control/Zoom~Zoom}, but triggered
   * by a keyboard event not a button element event.
   * Although interactions do not have a DOM element, some of them do render
   * vectors and so are visible on the screen.
   * @api
   */
  var Interaction = /*@__PURE__*/(function (BaseObject$$1) {
    function Interaction(options) {
      BaseObject$$1.call(this);

      if (options.handleEvent) {
        this.handleEvent = options.handleEvent;
      }

      /**
       * @private
       * @type {import("../PluggableMap.js").default}
       */
      this.map_ = null;

      this.setActive(true);
    }

    if ( BaseObject$$1 ) Interaction.__proto__ = BaseObject$$1;
    Interaction.prototype = Object.create( BaseObject$$1 && BaseObject$$1.prototype );
    Interaction.prototype.constructor = Interaction;

    /**
     * Return whether the interaction is currently active.
     * @return {boolean} `true` if the interaction is active, `false` otherwise.
     * @observable
     * @api
     */
    Interaction.prototype.getActive = function getActive () {
      return /** @type {boolean} */ (this.get(InteractionProperty.ACTIVE));
    };

    /**
     * Get the map associated with this interaction.
     * @return {import("../PluggableMap.js").default} Map.
     * @api
     */
    Interaction.prototype.getMap = function getMap () {
      return this.map_;
    };

    /**
     * Handles the {@link module:ol/MapBrowserEvent map browser event}.
     * @param {import("../MapBrowserEvent.js").default} mapBrowserEvent Map browser event.
     * @return {boolean} `false` to stop event propagation.
     * @api
     */
    Interaction.prototype.handleEvent = function handleEvent (mapBrowserEvent) {
      return true;
    };

    /**
     * Activate or deactivate the interaction.
     * @param {boolean} active Active.
     * @observable
     * @api
     */
    Interaction.prototype.setActive = function setActive (active) {
      this.set(InteractionProperty.ACTIVE, active);
    };

    /**
     * Remove the interaction from its current map and attach it to the new map.
     * Subclasses may set up event handlers to get notified about changes to
     * the map here.
     * @param {import("../PluggableMap.js").default} map Map.
     */
    Interaction.prototype.setMap = function setMap (map) {
      this.map_ = map;
    };

    return Interaction;
  }(BaseObject));


  /**
   * @param {import("../View.js").default} view View.
   * @param {import("../coordinate.js").Coordinate} delta Delta.
   * @param {number=} opt_duration Duration.
   */
  function pan(view, delta, opt_duration) {
    var currentCenter = view.getCenter();
    if (currentCenter) {
      var center = view.constrainCenter(
        [currentCenter[0] + delta[0], currentCenter[1] + delta[1]]);
      if (opt_duration) {
        view.animate({
          duration: opt_duration,
          easing: linear,
          center: center
        });
      } else {
        view.setCenter(center);
      }
    }
  }


  /**
   * @param {import("../View.js").default} view View.
   * @param {number|undefined} rotation Rotation.
   * @param {import("../coordinate.js").Coordinate=} opt_anchor Anchor coordinate.
   * @param {number=} opt_duration Duration.
   */
  function rotate$3(view, rotation, opt_anchor, opt_duration) {
    rotation = view.constrainRotation(rotation, 0);
    rotateWithoutConstraints(view, rotation, opt_anchor, opt_duration);
  }


  /**
   * @param {import("../View.js").default} view View.
   * @param {number|undefined} rotation Rotation.
   * @param {import("../coordinate.js").Coordinate=} opt_anchor Anchor coordinate.
   * @param {number=} opt_duration Duration.
   */
  function rotateWithoutConstraints(view, rotation, opt_anchor, opt_duration) {
    if (rotation !== undefined) {
      var currentRotation = view.getRotation();
      var currentCenter = view.getCenter();
      if (currentRotation !== undefined && currentCenter && opt_duration > 0) {
        view.animate({
          rotation: rotation,
          anchor: opt_anchor,
          duration: opt_duration,
          easing: easeOut
        });
      } else {
        view.rotate(rotation, opt_anchor);
      }
    }
  }


  /**
   * @param {import("../View.js").default} view View.
   * @param {number|undefined} resolution Resolution to go to.
   * @param {import("../coordinate.js").Coordinate=} opt_anchor Anchor coordinate.
   * @param {number=} opt_duration Duration.
   * @param {number=} opt_direction Zooming direction; > 0 indicates
   *     zooming out, in which case the constraints system will select
   *     the largest nearest resolution; < 0 indicates zooming in, in
   *     which case the constraints system will select the smallest
   *     nearest resolution; == 0 indicates that the zooming direction
   *     is unknown/not relevant, in which case the constraints system
   *     will select the nearest resolution. If not defined 0 is
   *     assumed.
   */
  function zoom(view, resolution, opt_anchor, opt_duration, opt_direction) {
    resolution = view.constrainResolution(resolution, 0, opt_direction);
    zoomWithoutConstraints(view, resolution, opt_anchor, opt_duration);
  }


  /**
   * @param {import("../View.js").default} view View.
   * @param {number} delta Delta from previous zoom level.
   * @param {import("../coordinate.js").Coordinate=} opt_anchor Anchor coordinate.
   * @param {number=} opt_duration Duration.
   */
  function zoomByDelta(view, delta, opt_anchor, opt_duration) {
    var currentResolution = view.getResolution();
    var resolution = view.constrainResolution(currentResolution, delta, 0);

    if (resolution !== undefined) {
      var resolutions = view.getResolutions();
      resolution = clamp(
        resolution,
        view.getMinResolution() || resolutions[resolutions.length - 1],
        view.getMaxResolution() || resolutions[0]);
    }

    // If we have a constraint on center, we need to change the anchor so that the
    // new center is within the extent. We first calculate the new center, apply
    // the constraint to it, and then calculate back the anchor
    if (opt_anchor && resolution !== undefined && resolution !== currentResolution) {
      var currentCenter = view.getCenter();
      var center = view.calculateCenterZoom(resolution, opt_anchor);
      center = view.constrainCenter(center);

      opt_anchor = [
        (resolution * currentCenter[0] - currentResolution * center[0]) /
            (resolution - currentResolution),
        (resolution * currentCenter[1] - currentResolution * center[1]) /
            (resolution - currentResolution)
      ];
    }

    zoomWithoutConstraints(view, resolution, opt_anchor, opt_duration);
  }


  /**
   * @param {import("../View.js").default} view View.
   * @param {number|undefined} resolution Resolution to go to.
   * @param {import("../coordinate.js").Coordinate=} opt_anchor Anchor coordinate.
   * @param {number=} opt_duration Duration.
   */
  function zoomWithoutConstraints(view, resolution, opt_anchor, opt_duration) {
    if (resolution) {
      var currentResolution = view.getResolution();
      var currentCenter = view.getCenter();
      if (currentResolution !== undefined && currentCenter &&
          resolution !== currentResolution && opt_duration) {
        view.animate({
          resolution: resolution,
          anchor: opt_anchor,
          duration: opt_duration,
          easing: easeOut
        });
      } else {
        if (opt_anchor) {
          var center = view.calculateCenterZoom(resolution, opt_anchor);
          view.setCenter(center);
        }
        view.setResolution(resolution);
      }
    }
  }

  /**
   * @module ol/interaction/DoubleClickZoom
   */


  /**
   * @typedef {Object} Options
   * @property {number} [duration=250] Animation duration in milliseconds.
   * @property {number} [delta=1] The zoom delta applied on each double click.
   */


  /**
   * @classdesc
   * Allows the user to zoom by double-clicking on the map.
   * @api
   */
  var DoubleClickZoom = /*@__PURE__*/(function (Interaction$$1) {
    function DoubleClickZoom(opt_options) {
      Interaction$$1.call(this, {
        handleEvent: handleEvent
      });

      var options = opt_options ? opt_options : {};

      /**
       * @private
       * @type {number}
       */
      this.delta_ = options.delta ? options.delta : 1;

      /**
       * @private
       * @type {number}
       */
      this.duration_ = options.duration !== undefined ? options.duration : 250;

    }

    if ( Interaction$$1 ) DoubleClickZoom.__proto__ = Interaction$$1;
    DoubleClickZoom.prototype = Object.create( Interaction$$1 && Interaction$$1.prototype );
    DoubleClickZoom.prototype.constructor = DoubleClickZoom;

    return DoubleClickZoom;
  }(Interaction));


  /**
   * Handles the {@link module:ol/MapBrowserEvent map browser event} (if it was a
   * doubleclick) and eventually zooms the map.
   * @param {import("../MapBrowserEvent.js").default} mapBrowserEvent Map browser event.
   * @return {boolean} `false` to stop event propagation.
   * @this {DoubleClickZoom}
   */
  function handleEvent(mapBrowserEvent) {
    var stopEvent = false;
    if (mapBrowserEvent.type == MapBrowserEventType.DBLCLICK) {
      var browserEvent = /** @type {MouseEvent} */ (mapBrowserEvent.originalEvent);
      var map = mapBrowserEvent.map;
      var anchor = mapBrowserEvent.coordinate;
      var delta = browserEvent.shiftKey ? -this.delta_ : this.delta_;
      var view = map.getView();
      zoomByDelta(view, delta, anchor, this.duration_);
      mapBrowserEvent.preventDefault();
      stopEvent = true;
    }
    return !stopEvent;
  }

  /**
   * @module ol/events/condition
   */


  /**
   * A function that takes an {@link module:ol/MapBrowserEvent} and returns a
   * `{boolean}`. If the condition is met, true should be returned.
   *
   * @typedef {function(this: ?, import("../MapBrowserEvent.js").default): boolean} Condition
   */


  /**
   * Return `true` if only the alt-key is pressed, `false` otherwise (e.g. when
   * additionally the shift-key is pressed).
   *
   * @param {import("../MapBrowserEvent.js").default} mapBrowserEvent Map browser event.
   * @return {boolean} True if only the alt key is pressed.
   * @api
   */
  var altKeyOnly = function(mapBrowserEvent) {
    var originalEvent = /** @type {KeyboardEvent|MouseEvent|TouchEvent} */ (mapBrowserEvent.originalEvent);
    return (
      originalEvent.altKey &&
        !(originalEvent.metaKey || originalEvent.ctrlKey) &&
        !originalEvent.shiftKey);
  };


  /**
   * Return `true` if only the alt-key and shift-key is pressed, `false` otherwise
   * (e.g. when additionally the platform-modifier-key is pressed).
   *
   * @param {import("../MapBrowserEvent.js").default} mapBrowserEvent Map browser event.
   * @return {boolean} True if only the alt and shift keys are pressed.
   * @api
   */
  var altShiftKeysOnly = function(mapBrowserEvent) {
    var originalEvent = /** @type {KeyboardEvent|MouseEvent|TouchEvent} */ (mapBrowserEvent.originalEvent);
    return (
      originalEvent.altKey &&
        !(originalEvent.metaKey || originalEvent.ctrlKey) &&
        originalEvent.shiftKey);
  };


  /**
   * Return `true` if the map has the focus. This condition requires a map target
   * element with a `tabindex` attribute, e.g. `<div id="map" tabindex="1">`.
   *
   * @param {import("../MapBrowserEvent.js").default} event Map browser event.
   * @return {boolean} The map has the focus.
   * @api
   */
  var focus = function(event) {
    return event.target.getTargetElement() === document.activeElement;
  };


  /**
   * Return always true.
   *
   * @param {import("../MapBrowserEvent.js").default} mapBrowserEvent Map browser event.
   * @return {boolean} True.
   * @api
   */
  var always = TRUE;


  /**
   * Return `true` if the event has an "action"-producing mouse button.
   *
   * By definition, this includes left-click on windows/linux, and left-click
   * without the ctrl key on Macs.
   *
   * @param {import("../MapBrowserEvent.js").default} mapBrowserEvent Map browser event.
   * @return {boolean} The result.
   */
  var mouseActionButton = function(mapBrowserEvent) {
    var originalEvent = /** @type {MouseEvent} */ (mapBrowserEvent.originalEvent);
    return originalEvent.button == 0 &&
        !(WEBKIT && MAC && originalEvent.ctrlKey);
  };


  /**
   * Return always false.
   *
   * @param {import("../MapBrowserEvent.js").default} mapBrowserEvent Map browser event.
   * @return {boolean} False.
   * @api
   */
  var never = FALSE;


  /**
   * Return `true` if the browser event is a `pointermove` event, `false`
   * otherwise.
   *
   * @param {import("../MapBrowserEvent.js").default} mapBrowserEvent Map browser event.
   * @return {boolean} True if the browser event is a `pointermove` event.
   * @api
   */
  var pointerMove$1 = function(mapBrowserEvent) {
    return mapBrowserEvent.type == 'pointermove';
  };


  /**
   * Return `true` if the event is a map `singleclick` event, `false` otherwise.
   *
   * @param {import("../MapBrowserEvent.js").default} mapBrowserEvent Map browser event.
   * @return {boolean} True if the event is a map `singleclick` event.
   * @api
   */
  var singleClick = function(mapBrowserEvent) {
    return mapBrowserEvent.type == MapBrowserEventType.SINGLECLICK;
  };


  /**
   * Return `true` if no modifier key (alt-, shift- or platform-modifier-key) is
   * pressed.
   *
   * @param {import("../MapBrowserEvent.js").default} mapBrowserEvent Map browser event.
   * @return {boolean} True only if there no modifier keys are pressed.
   * @api
   */
  var noModifierKeys = function(mapBrowserEvent) {
    var originalEvent = /** @type {KeyboardEvent|MouseEvent|TouchEvent} */ (mapBrowserEvent.originalEvent);
    return (
      !originalEvent.altKey &&
        !(originalEvent.metaKey || originalEvent.ctrlKey) &&
        !originalEvent.shiftKey);
  };


  /**
   * Return `true` if only the shift-key is pressed, `false` otherwise (e.g. when
   * additionally the alt-key is pressed).
   *
   * @param {import("../MapBrowserEvent.js").default} mapBrowserEvent Map browser event.
   * @return {boolean} True if only the shift key is pressed.
   * @api
   */
  var shiftKeyOnly = function(mapBrowserEvent) {
    var originalEvent = /** @type {KeyboardEvent|MouseEvent|TouchEvent} */ (mapBrowserEvent.originalEvent);
    return (
      !originalEvent.altKey &&
        !(originalEvent.metaKey || originalEvent.ctrlKey) &&
        originalEvent.shiftKey);
  };


  /**
   * Return `true` if the target element is not editable, i.e. not a `<input>`-,
   * `<select>`- or `<textarea>`-element, `false` otherwise.
   *
   * @param {import("../MapBrowserEvent.js").default} mapBrowserEvent Map browser event.
   * @return {boolean} True only if the target element is not editable.
   * @api
   */
  var targetNotEditable = function(mapBrowserEvent) {
    var target = mapBrowserEvent.originalEvent.target;
    var tagName = /** @type {Element} */ (target).tagName;
    return (
      tagName !== 'INPUT' &&
        tagName !== 'SELECT' &&
        tagName !== 'TEXTAREA');
  };


  /**
   * Return `true` if the event originates from a mouse device.
   *
   * @param {import("../MapBrowserEvent.js").default} mapBrowserEvent Map browser event.
   * @return {boolean} True if the event originates from a mouse device.
   * @api
   */
  var mouseOnly = function(mapBrowserEvent) {
    var pointerEvent = /** @type {import("../MapBrowserPointerEvent").default} */ (mapBrowserEvent).pointerEvent;
    assert(pointerEvent !== undefined, 56); // mapBrowserEvent must originate from a pointer event
    // see http://www.w3.org/TR/pointerevents/#widl-PointerEvent-pointerType
    return pointerEvent.pointerType == 'mouse';
  };


  /**
   * Return `true` if the event originates from a primary pointer in
   * contact with the surface or if the left mouse button is pressed.
   * See http://www.w3.org/TR/pointerevents/#button-states.
   *
   * @param {import("../MapBrowserEvent.js").default} mapBrowserEvent Map browser event.
   * @return {boolean} True if the event originates from a primary pointer.
   * @api
   */
  var primaryAction = function(mapBrowserEvent) {
    var pointerEvent = /** @type {import("../MapBrowserPointerEvent").default} */ (mapBrowserEvent).pointerEvent;
    assert(pointerEvent !== undefined, 56); // mapBrowserEvent must originate from a pointer event
    return pointerEvent.isPrimary && pointerEvent.button === 0;
  };

  /**
   * @module ol/interaction/Pointer
   */


  /**
   * @typedef {Object} Options
   * @property {function(import("../MapBrowserPointerEvent.js").default):boolean} [handleDownEvent]
   * Function handling "down" events. If the function returns `true` then a drag
   * sequence is started.
   * @property {function(import("../MapBrowserPointerEvent.js").default)} [handleDragEvent]
   * Function handling "drag" events. This function is called on "move" events
   * during a drag sequence.
   * @property {function(import("../MapBrowserEvent.js").default):boolean} [handleEvent]
   * Method called by the map to notify the interaction that a browser event was
   * dispatched to the map. The function may return `false` to prevent the
   * propagation of the event to other interactions in the map's interactions
   * chain.
   * @property {function(import("../MapBrowserPointerEvent.js").default)} [handleMoveEvent]
   * Function handling "move" events. This function is called on "move" events,
   * also during a drag sequence (so during a drag sequence both the
   * `handleDragEvent` function and this function are called).
   * @property {function(import("../MapBrowserPointerEvent.js").default):boolean} [handleUpEvent]
   *  Function handling "up" events. If the function returns `false` then the
   * current drag sequence is stopped.
   * @property {function(boolean):boolean} [stopDown]
   * Should the down event be propagated to other interactions, or should be
   * stopped?
   */


  /**
   * @classdesc
   * Base class that calls user-defined functions on `down`, `move` and `up`
   * events. This class also manages "drag sequences".
   *
   * When the `handleDownEvent` user function returns `true` a drag sequence is
   * started. During a drag sequence the `handleDragEvent` user function is
   * called on `move` events. The drag sequence ends when the `handleUpEvent`
   * user function is called and returns `false`.
   * @api
   */
  var PointerInteraction = /*@__PURE__*/(function (Interaction$$1) {
    function PointerInteraction(opt_options) {

      var options = opt_options ? opt_options : {};

      Interaction$$1.call(/** @type {import("./Interaction.js").InteractionOptions} */ this, (options));

      if (options.handleDownEvent) {
        this.handleDownEvent = options.handleDownEvent;
      }

      if (options.handleDragEvent) {
        this.handleDragEvent = options.handleDragEvent;
      }

      if (options.handleMoveEvent) {
        this.handleMoveEvent = options.handleMoveEvent;
      }

      if (options.handleUpEvent) {
        this.handleUpEvent = options.handleUpEvent;
      }

      if (options.stopDown) {
        this.stopDown = options.stopDown;
      }

      /**
       * @type {boolean}
       * @protected
       */
      this.handlingDownUpSequence = false;

      /**
       * @type {!Object<string, import("../pointer/PointerEvent.js").default>}
       * @private
       */
      this.trackedPointers_ = {};

      /**
       * @type {Array<import("../pointer/PointerEvent.js").default>}
       * @protected
       */
      this.targetPointers = [];

    }

    if ( Interaction$$1 ) PointerInteraction.__proto__ = Interaction$$1;
    PointerInteraction.prototype = Object.create( Interaction$$1 && Interaction$$1.prototype );
    PointerInteraction.prototype.constructor = PointerInteraction;

    /**
     * Handle pointer down events.
     * @param {import("../MapBrowserPointerEvent.js").default} mapBrowserEvent Event.
     * @return {boolean} If the event was consumed.
     * @protected
     */
    PointerInteraction.prototype.handleDownEvent = function handleDownEvent (mapBrowserEvent) {
      return false;
    };

    /**
     * Handle pointer drag events.
     * @param {import("../MapBrowserPointerEvent.js").default} mapBrowserEvent Event.
     * @protected
     */
    PointerInteraction.prototype.handleDragEvent = function handleDragEvent (mapBrowserEvent) {};

    /**
     * Handles the {@link module:ol/MapBrowserEvent map browser event} and may call into
     * other functions, if event sequences like e.g. 'drag' or 'down-up' etc. are
     * detected.
     * @override
     * @api
     */
    PointerInteraction.prototype.handleEvent = function handleEvent (mapBrowserEvent) {
      if (!(/** @type {import("../MapBrowserPointerEvent.js").default} */ (mapBrowserEvent).pointerEvent)) {
        return true;
      }

      var stopEvent = false;
      this.updateTrackedPointers_(mapBrowserEvent);
      if (this.handlingDownUpSequence) {
        if (mapBrowserEvent.type == MapBrowserEventType.POINTERDRAG) {
          this.handleDragEvent(mapBrowserEvent);
        } else if (mapBrowserEvent.type == MapBrowserEventType.POINTERUP) {
          var handledUp = this.handleUpEvent(mapBrowserEvent);
          this.handlingDownUpSequence = handledUp && this.targetPointers.length > 0;
        }
      } else {
        if (mapBrowserEvent.type == MapBrowserEventType.POINTERDOWN) {
          var handled = this.handleDownEvent(mapBrowserEvent);
          if (handled) {
            mapBrowserEvent.preventDefault();
          }
          this.handlingDownUpSequence = handled;
          stopEvent = this.stopDown(handled);
        } else if (mapBrowserEvent.type == MapBrowserEventType.POINTERMOVE) {
          this.handleMoveEvent(mapBrowserEvent);
        }
      }
      return !stopEvent;
    };

    /**
     * Handle pointer move events.
     * @param {import("../MapBrowserPointerEvent.js").default} mapBrowserEvent Event.
     * @protected
     */
    PointerInteraction.prototype.handleMoveEvent = function handleMoveEvent (mapBrowserEvent) {};

    /**
     * Handle pointer up events.
     * @param {import("../MapBrowserPointerEvent.js").default} mapBrowserEvent Event.
     * @return {boolean} If the event was consumed.
     * @protected
     */
    PointerInteraction.prototype.handleUpEvent = function handleUpEvent (mapBrowserEvent) {
      return false;
    };

    /**
     * This function is used to determine if "down" events should be propagated
     * to other interactions or should be stopped.
     * @param {boolean} handled Was the event handled by the interaction?
     * @return {boolean} Should the `down` event be stopped?
     */
    PointerInteraction.prototype.stopDown = function stopDown (handled) {
      return handled;
    };

    /**
     * @param {import("../MapBrowserPointerEvent.js").default} mapBrowserEvent Event.
     * @private
     */
    PointerInteraction.prototype.updateTrackedPointers_ = function updateTrackedPointers_ (mapBrowserEvent) {
      if (isPointerDraggingEvent(mapBrowserEvent)) {
        var event = mapBrowserEvent.pointerEvent;

        var id = event.pointerId.toString();
        if (mapBrowserEvent.type == MapBrowserEventType.POINTERUP) {
          delete this.trackedPointers_[id];
        } else if (mapBrowserEvent.type ==
            MapBrowserEventType.POINTERDOWN) {
          this.trackedPointers_[id] = event;
        } else if (id in this.trackedPointers_) {
          // update only when there was a pointerdown event for this pointer
          this.trackedPointers_[id] = event;
        }
        this.targetPointers = getValues(this.trackedPointers_);
      }
    };

    return PointerInteraction;
  }(Interaction));


  /**
   * @param {Array<import("../pointer/PointerEvent.js").default>} pointerEvents List of events.
   * @return {import("../pixel.js").Pixel} Centroid pixel.
   */
  function centroid(pointerEvents) {
    var length = pointerEvents.length;
    var clientX = 0;
    var clientY = 0;
    for (var i = 0; i < length; i++) {
      clientX += pointerEvents[i].clientX;
      clientY += pointerEvents[i].clientY;
    }
    return [clientX / length, clientY / length];
  }


  /**
   * @param {import("../MapBrowserPointerEvent.js").default} mapBrowserEvent Event.
   * @return {boolean} Whether the event is a pointerdown, pointerdrag
   *     or pointerup event.
   */
  function isPointerDraggingEvent(mapBrowserEvent) {
    var type = mapBrowserEvent.type;
    return type === MapBrowserEventType.POINTERDOWN ||
      type === MapBrowserEventType.POINTERDRAG ||
      type === MapBrowserEventType.POINTERUP;
  }

  /**
   * @module ol/interaction/DragPan
   */


  /**
   * @typedef {Object} Options
   * @property {import("../events/condition.js").Condition} [condition] A function that takes an {@link module:ol/MapBrowserEvent~MapBrowserEvent} and returns a boolean
   * to indicate whether that event should be handled.
   * Default is {@link module:ol/events/condition~noModifierKeys}.
   * @property {import("../Kinetic.js").default} [kinetic] Kinetic inertia to apply to the pan.
   */


  /**
   * @classdesc
   * Allows the user to pan the map by dragging the map.
   * @api
   */
  var DragPan = /*@__PURE__*/(function (PointerInteraction$$1) {
    function DragPan(opt_options) {

      PointerInteraction$$1.call(this, {
        stopDown: FALSE
      });

      var options = opt_options ? opt_options : {};

      /**
       * @private
       * @type {import("../Kinetic.js").default|undefined}
       */
      this.kinetic_ = options.kinetic;

      /**
       * @type {import("../pixel.js").Pixel}
       */
      this.lastCentroid = null;

      /**
       * @type {number}
       */
      this.lastPointersCount_;

      /**
       * @type {boolean}
       */
      this.panning_ = false;

      /**
       * @private
       * @type {import("../events/condition.js").Condition}
       */
      this.condition_ = options.condition ? options.condition : noModifierKeys;

      /**
       * @private
       * @type {boolean}
       */
      this.noKinetic_ = false;

    }

    if ( PointerInteraction$$1 ) DragPan.__proto__ = PointerInteraction$$1;
    DragPan.prototype = Object.create( PointerInteraction$$1 && PointerInteraction$$1.prototype );
    DragPan.prototype.constructor = DragPan;

    /**
     * @inheritDoc
     */
    DragPan.prototype.handleDragEvent = function handleDragEvent (mapBrowserEvent) {
      if (!this.panning_) {
        this.panning_ = true;
        this.getMap().getView().setHint(ViewHint.INTERACTING, 1);
      }
      var targetPointers = this.targetPointers;
      var centroid$$1 = centroid(targetPointers);
      if (targetPointers.length == this.lastPointersCount_) {
        if (this.kinetic_) {
          this.kinetic_.update(centroid$$1[0], centroid$$1[1]);
        }
        if (this.lastCentroid) {
          var deltaX = this.lastCentroid[0] - centroid$$1[0];
          var deltaY = centroid$$1[1] - this.lastCentroid[1];
          var map = mapBrowserEvent.map;
          var view = map.getView();
          var center = [deltaX, deltaY];
          scale(center, view.getResolution());
          rotate(center, view.getRotation());
          add(center, view.getCenter());
          center = view.constrainCenter(center);
          view.setCenter(center);
        }
      } else if (this.kinetic_) {
        // reset so we don't overestimate the kinetic energy after
        // after one finger down, tiny drag, second finger down
        this.kinetic_.begin();
      }
      this.lastCentroid = centroid$$1;
      this.lastPointersCount_ = targetPointers.length;
    };

    /**
     * @inheritDoc
     */
    DragPan.prototype.handleUpEvent = function handleUpEvent (mapBrowserEvent) {
      var map = mapBrowserEvent.map;
      var view = map.getView();
      if (this.targetPointers.length === 0) {
        if (!this.noKinetic_ && this.kinetic_ && this.kinetic_.end()) {
          var distance$$1 = this.kinetic_.getDistance();
          var angle = this.kinetic_.getAngle();
          var center = /** @type {!import("../coordinate.js").Coordinate} */ (view.getCenter());
          var centerpx = map.getPixelFromCoordinate(center);
          var dest = map.getCoordinateFromPixel([
            centerpx[0] - distance$$1 * Math.cos(angle),
            centerpx[1] - distance$$1 * Math.sin(angle)
          ]);
          view.animate({
            center: view.constrainCenter(dest),
            duration: 500,
            easing: easeOut
          });
        }
        if (this.panning_) {
          this.panning_ = false;
          view.setHint(ViewHint.INTERACTING, -1);
        }
        return false;
      } else {
        if (this.kinetic_) {
          // reset so we don't overestimate the kinetic energy after
          // after one finger up, tiny drag, second finger up
          this.kinetic_.begin();
        }
        this.lastCentroid = null;
        return true;
      }
    };

    /**
     * @inheritDoc
     */
    DragPan.prototype.handleDownEvent = function handleDownEvent (mapBrowserEvent) {
      if (this.targetPointers.length > 0 && this.condition_(mapBrowserEvent)) {
        var map = mapBrowserEvent.map;
        var view = map.getView();
        this.lastCentroid = null;
        // stop any current animation
        if (view.getAnimating()) {
          view.setCenter(mapBrowserEvent.frameState.viewState.center);
        }
        if (this.kinetic_) {
          this.kinetic_.begin();
        }
        // No kinetic as soon as more than one pointer on the screen is
        // detected. This is to prevent nasty pans after pinch.
        this.noKinetic_ = this.targetPointers.length > 1;
        return true;
      } else {
        return false;
      }
    };

    return DragPan;
  }(PointerInteraction));

  /**
   * @module ol/interaction/DragRotate
   */


  /**
   * @typedef {Object} Options
   * @property {import("../events/condition.js").Condition} [condition] A function that takes an
   * {@link module:ol/MapBrowserEvent~MapBrowserEvent} and returns a boolean
   * to indicate whether that event should be handled.
   * Default is {@link module:ol/events/condition~altShiftKeysOnly}.
   * @property {number} [duration=250] Animation duration in milliseconds.
   */


  /**
   * @classdesc
   * Allows the user to rotate the map by clicking and dragging on the map,
   * normally combined with an {@link module:ol/events/condition} that limits
   * it to when the alt and shift keys are held down.
   *
   * This interaction is only supported for mouse devices.
   * @api
   */
  var DragRotate = /*@__PURE__*/(function (PointerInteraction$$1) {
    function DragRotate(opt_options) {

      var options = opt_options ? opt_options : {};

      PointerInteraction$$1.call(this, {
        stopDown: FALSE
      });

      /**
       * @private
       * @type {import("../events/condition.js").Condition}
       */
      this.condition_ = options.condition ? options.condition : altShiftKeysOnly;

      /**
       * @private
       * @type {number|undefined}
       */
      this.lastAngle_ = undefined;

      /**
       * @private
       * @type {number}
       */
      this.duration_ = options.duration !== undefined ? options.duration : 250;

    }

    if ( PointerInteraction$$1 ) DragRotate.__proto__ = PointerInteraction$$1;
    DragRotate.prototype = Object.create( PointerInteraction$$1 && PointerInteraction$$1.prototype );
    DragRotate.prototype.constructor = DragRotate;

    /**
     * @inheritDoc
     */
    DragRotate.prototype.handleDragEvent = function handleDragEvent (mapBrowserEvent) {
      if (!mouseOnly(mapBrowserEvent)) {
        return;
      }

      var map = mapBrowserEvent.map;
      var view = map.getView();
      if (view.getConstraints().rotation === disable) {
        return;
      }
      var size = map.getSize();
      var offset = mapBrowserEvent.pixel;
      var theta =
          Math.atan2(size[1] / 2 - offset[1], offset[0] - size[0] / 2);
      if (this.lastAngle_ !== undefined) {
        var delta = theta - this.lastAngle_;
        var rotation = view.getRotation();
        rotateWithoutConstraints(view, rotation - delta);
      }
      this.lastAngle_ = theta;
    };


    /**
     * @inheritDoc
     */
    DragRotate.prototype.handleUpEvent = function handleUpEvent (mapBrowserEvent) {
      if (!mouseOnly(mapBrowserEvent)) {
        return true;
      }

      var map = mapBrowserEvent.map;
      var view = map.getView();
      view.setHint(ViewHint.INTERACTING, -1);
      var rotation = view.getRotation();
      rotate$3(view, rotation, undefined, this.duration_);
      return false;
    };


    /**
     * @inheritDoc
     */
    DragRotate.prototype.handleDownEvent = function handleDownEvent (mapBrowserEvent) {
      if (!mouseOnly(mapBrowserEvent)) {
        return false;
      }

      if (mouseActionButton(mapBrowserEvent) && this.condition_(mapBrowserEvent)) {
        var map = mapBrowserEvent.map;
        map.getView().setHint(ViewHint.INTERACTING, 1);
        this.lastAngle_ = undefined;
        return true;
      } else {
        return false;
      }
    };

    return DragRotate;
  }(PointerInteraction));

  /**
   * @module ol/render/Box
   */

  var RenderBox = /*@__PURE__*/(function (Disposable$$1) {
    function RenderBox(className) {
      Disposable$$1.call(this);

      /**
       * @type {import("../geom/Polygon.js").default}
       * @private
       */
      this.geometry_ = null;

      /**
       * @type {HTMLDivElement}
       * @private
       */
      this.element_ = /** @type {HTMLDivElement} */ (document.createElement('div'));
      this.element_.style.position = 'absolute';
      this.element_.className = 'ol-box ' + className;

      /**
       * @private
       * @type {import("../PluggableMap.js").default}
       */
      this.map_ = null;

      /**
       * @private
       * @type {import("../pixel.js").Pixel}
       */
      this.startPixel_ = null;

      /**
       * @private
       * @type {import("../pixel.js").Pixel}
       */
      this.endPixel_ = null;

    }

    if ( Disposable$$1 ) RenderBox.__proto__ = Disposable$$1;
    RenderBox.prototype = Object.create( Disposable$$1 && Disposable$$1.prototype );
    RenderBox.prototype.constructor = RenderBox;

    /**
     * @inheritDoc
     */
    RenderBox.prototype.disposeInternal = function disposeInternal () {
      this.setMap(null);
    };

    /**
     * @private
     */
    RenderBox.prototype.render_ = function render_ () {
      var startPixel = this.startPixel_;
      var endPixel = this.endPixel_;
      var px = 'px';
      var style = this.element_.style;
      style.left = Math.min(startPixel[0], endPixel[0]) + px;
      style.top = Math.min(startPixel[1], endPixel[1]) + px;
      style.width = Math.abs(endPixel[0] - startPixel[0]) + px;
      style.height = Math.abs(endPixel[1] - startPixel[1]) + px;
    };

    /**
     * @param {import("../PluggableMap.js").default} map Map.
     */
    RenderBox.prototype.setMap = function setMap (map) {
      if (this.map_) {
        this.map_.getOverlayContainer().removeChild(this.element_);
        var style = this.element_.style;
        style.left = style.top = style.width = style.height = 'inherit';
      }
      this.map_ = map;
      if (this.map_) {
        this.map_.getOverlayContainer().appendChild(this.element_);
      }
    };

    /**
     * @param {import("../pixel.js").Pixel} startPixel Start pixel.
     * @param {import("../pixel.js").Pixel} endPixel End pixel.
     */
    RenderBox.prototype.setPixels = function setPixels (startPixel, endPixel) {
      this.startPixel_ = startPixel;
      this.endPixel_ = endPixel;
      this.createOrUpdateGeometry();
      this.render_();
    };

    /**
     * Creates or updates the cached geometry.
     */
    RenderBox.prototype.createOrUpdateGeometry = function createOrUpdateGeometry () {
      var startPixel = this.startPixel_;
      var endPixel = this.endPixel_;
      var pixels = [
        startPixel,
        [startPixel[0], endPixel[1]],
        endPixel,
        [endPixel[0], startPixel[1]]
      ];
      var coordinates = pixels.map(this.map_.getCoordinateFromPixel, this.map_);
      // close the polygon
      coordinates[4] = coordinates[0].slice();
      if (!this.geometry_) {
        this.geometry_ = new Polygon([coordinates]);
      } else {
        this.geometry_.setCoordinates([coordinates]);
      }
    };

    /**
     * @return {import("../geom/Polygon.js").default} Geometry.
     */
    RenderBox.prototype.getGeometry = function getGeometry () {
      return this.geometry_;
    };

    return RenderBox;
  }(Disposable));

  /**
   * @module ol/interaction/DragBox
   */


  /**
   * A function that takes a {@link module:ol/MapBrowserEvent} and two
   * {@link module:ol/pixel~Pixel}s and returns a `{boolean}`. If the condition is met,
   * true should be returned.
   * @typedef {function(this: ?, import("../MapBrowserEvent.js").default, import("../pixel.js").Pixel, import("../pixel.js").Pixel):boolean} EndCondition
   */


  /**
   * @typedef {Object} Options
   * @property {string} [className='ol-dragbox'] CSS class name for styling the box.
   * @property {import("../events/condition.js").Condition} [condition] A function that takes an {@link module:ol/MapBrowserEvent~MapBrowserEvent} and returns a boolean
   * to indicate whether that event should be handled.
   * Default is {@link ol/events/condition~always}.
   * @property {number} [minArea=64] The minimum area of the box in pixel, this value is used by the default
   * `boxEndCondition` function.
   * @property {EndCondition} [boxEndCondition] A function that takes a {@link module:ol/MapBrowserEvent~MapBrowserEvent} and two
   * {@link module:ol/pixel~Pixel}s to indicate whether a `boxend` event should be fired.
   * Default is `true` if the area of the box is bigger than the `minArea` option.
   * @property {function(this:DragBox, import("../MapBrowserEvent.js").default)} onBoxEnd Code to execute just
   * before `boxend` is fired.
   */


  /**
   * @enum {string}
   */
  var DragBoxEventType = {
    /**
     * Triggered upon drag box start.
     * @event DragBoxEvent#boxstart
     * @api
     */
    BOXSTART: 'boxstart',

    /**
     * Triggered on drag when box is active.
     * @event DragBoxEvent#boxdrag
     * @api
     */
    BOXDRAG: 'boxdrag',

    /**
     * Triggered upon drag box end.
     * @event DragBoxEvent#boxend
     * @api
     */
    BOXEND: 'boxend'
  };


  /**
   * @classdesc
   * Events emitted by {@link module:ol/interaction/DragBox~DragBox} instances are instances of
   * this type.
   */
  var DragBoxEvent = /*@__PURE__*/(function (Event$$1) {
    function DragBoxEvent(type, coordinate, mapBrowserEvent) {
      Event$$1.call(this, type);

      /**
       * The coordinate of the drag event.
       * @const
       * @type {import("../coordinate.js").Coordinate}
       * @api
       */
      this.coordinate = coordinate;

      /**
       * @const
       * @type {import("../MapBrowserEvent.js").default}
       * @api
       */
      this.mapBrowserEvent = mapBrowserEvent;

    }

    if ( Event$$1 ) DragBoxEvent.__proto__ = Event$$1;
    DragBoxEvent.prototype = Object.create( Event$$1 && Event$$1.prototype );
    DragBoxEvent.prototype.constructor = DragBoxEvent;

    return DragBoxEvent;
  }(Event));


  /**
   * @classdesc
   * Allows the user to draw a vector box by clicking and dragging on the map,
   * normally combined with an {@link module:ol/events/condition} that limits
   * it to when the shift or other key is held down. This is used, for example,
   * for zooming to a specific area of the map
   * (see {@link module:ol/interaction/DragZoom~DragZoom} and
   * {@link module:ol/interaction/DragRotateAndZoom}).
   *
   * This interaction is only supported for mouse devices.
   *
   * @fires DragBoxEvent
   * @api
   */
  var DragBox = /*@__PURE__*/(function (PointerInteraction$$1) {
    function DragBox(opt_options) {

      PointerInteraction$$1.call(this);

      var options = opt_options ? opt_options : {};

      /**
      * @type {import("../render/Box.js").default}
      * @private
      */
      this.box_ = new RenderBox(options.className || 'ol-dragbox');

      /**
      * @type {number}
      * @private
      */
      this.minArea_ = options.minArea !== undefined ? options.minArea : 64;

      /**
       * Function to execute just before `onboxend` is fired
       * @type {function(this:DragBox, import("../MapBrowserEvent.js").default)}
       * @private
       */
      this.onBoxEnd_ = options.onBoxEnd ? options.onBoxEnd : VOID;

      /**
      * @type {import("../pixel.js").Pixel}
      * @private
      */
      this.startPixel_ = null;

      /**
      * @private
      * @type {import("../events/condition.js").Condition}
      */
      this.condition_ = options.condition ? options.condition : always;

      /**
      * @private
      * @type {EndCondition}
      */
      this.boxEndCondition_ = options.boxEndCondition ?
        options.boxEndCondition : this.defaultBoxEndCondition;
    }

    if ( PointerInteraction$$1 ) DragBox.__proto__ = PointerInteraction$$1;
    DragBox.prototype = Object.create( PointerInteraction$$1 && PointerInteraction$$1.prototype );
    DragBox.prototype.constructor = DragBox;

    /**
     * The default condition for determining whether the boxend event
     * should fire.
     * @param {import("../MapBrowserEvent.js").default} mapBrowserEvent The originating MapBrowserEvent
     *     leading to the box end.
     * @param {import("../pixel.js").Pixel} startPixel The starting pixel of the box.
     * @param {import("../pixel.js").Pixel} endPixel The end pixel of the box.
     * @return {boolean} Whether or not the boxend condition should be fired.
     */
    DragBox.prototype.defaultBoxEndCondition = function defaultBoxEndCondition (mapBrowserEvent, startPixel, endPixel) {
      var width = endPixel[0] - startPixel[0];
      var height = endPixel[1] - startPixel[1];
      return width * width + height * height >= this.minArea_;
    };

    /**
    * Returns geometry of last drawn box.
    * @return {import("../geom/Polygon.js").default} Geometry.
    * @api
    */
    DragBox.prototype.getGeometry = function getGeometry () {
      return this.box_.getGeometry();
    };

    /**
     * @inheritDoc
     */
    DragBox.prototype.handleDragEvent = function handleDragEvent (mapBrowserEvent) {
      if (!mouseOnly(mapBrowserEvent)) {
        return;
      }

      this.box_.setPixels(this.startPixel_, mapBrowserEvent.pixel);

      this.dispatchEvent(new DragBoxEvent(DragBoxEventType.BOXDRAG,
        mapBrowserEvent.coordinate, mapBrowserEvent));
    };

    /**
     * @inheritDoc
     */
    DragBox.prototype.handleUpEvent = function handleUpEvent (mapBrowserEvent) {
      if (!mouseOnly(mapBrowserEvent)) {
        return true;
      }

      this.box_.setMap(null);

      if (this.boxEndCondition_(mapBrowserEvent, this.startPixel_, mapBrowserEvent.pixel)) {
        this.onBoxEnd_(mapBrowserEvent);
        this.dispatchEvent(new DragBoxEvent(DragBoxEventType.BOXEND,
          mapBrowserEvent.coordinate, mapBrowserEvent));
      }
      return false;
    };

    /**
     * @inheritDoc
     */
    DragBox.prototype.handleDownEvent = function handleDownEvent (mapBrowserEvent) {
      if (!mouseOnly(mapBrowserEvent)) {
        return false;
      }

      if (mouseActionButton(mapBrowserEvent) &&
          this.condition_(mapBrowserEvent)) {
        this.startPixel_ = mapBrowserEvent.pixel;
        this.box_.setMap(mapBrowserEvent.map);
        this.box_.setPixels(this.startPixel_, this.startPixel_);
        this.dispatchEvent(new DragBoxEvent(DragBoxEventType.BOXSTART,
          mapBrowserEvent.coordinate, mapBrowserEvent));
        return true;
      } else {
        return false;
      }
    };

    return DragBox;
  }(PointerInteraction));

  /**
   * @module ol/interaction/DragZoom
   */


  /**
   * @typedef {Object} Options
   * @property {string} [className='ol-dragzoom'] CSS class name for styling the
   * box.
   * @property {import("../events/condition.js").Condition} [condition] A function that
   * takes an {@link module:ol/MapBrowserEvent~MapBrowserEvent} and returns a
   * boolean to indicate whether that event should be handled.
   * Default is {@link module:ol/events/condition~shiftKeyOnly}.
   * @property {number} [duration=200] Animation duration in milliseconds.
   * @property {boolean} [out=false] Use interaction for zooming out.
   */


  /**
   * @classdesc
   * Allows the user to zoom the map by clicking and dragging on the map,
   * normally combined with an {@link module:ol/events/condition} that limits
   * it to when a key, shift by default, is held down.
   *
   * To change the style of the box, use CSS and the `.ol-dragzoom` selector, or
   * your custom one configured with `className`.
   * @api
   */
  var DragZoom = /*@__PURE__*/(function (DragBox$$1) {
    function DragZoom(opt_options) {
      var options = opt_options ? opt_options : {};

      var condition = options.condition ? options.condition : shiftKeyOnly;

      DragBox$$1.call(this, {
        condition: condition,
        className: options.className || 'ol-dragzoom',
        onBoxEnd: onBoxEnd
      });

      /**
       * @private
       * @type {number}
       */
      this.duration_ = options.duration !== undefined ? options.duration : 200;

      /**
       * @private
       * @type {boolean}
       */
      this.out_ = options.out !== undefined ? options.out : false;
    }

    if ( DragBox$$1 ) DragZoom.__proto__ = DragBox$$1;
    DragZoom.prototype = Object.create( DragBox$$1 && DragBox$$1.prototype );
    DragZoom.prototype.constructor = DragZoom;

    return DragZoom;
  }(DragBox));


  /**
   * @this {DragZoom}
   */
  function onBoxEnd() {
    var map = this.getMap();
    var view = /** @type {!import("../View.js").default} */ (map.getView());
    var size = /** @type {!import("../size.js").Size} */ (map.getSize());
    var extent = this.getGeometry().getExtent();

    if (this.out_) {
      var mapExtent = view.calculateExtent(size);
      var boxPixelExtent = createOrUpdateFromCoordinates([
        map.getPixelFromCoordinate(getBottomLeft(extent)),
        map.getPixelFromCoordinate(getTopRight(extent))]);
      var factor = view.getResolutionForExtent(boxPixelExtent, size);

      scaleFromCenter(mapExtent, 1 / factor);
      extent = mapExtent;
    }

    var resolution = view.constrainResolution(
      view.getResolutionForExtent(extent, size));

    var center = getCenter(extent);
    center = view.constrainCenter(center);

    view.animate({
      resolution: resolution,
      center: center,
      duration: this.duration_,
      easing: easeOut
    });
  }

  /**
   * @module ol/events/KeyCode
   */

  /**
   * @enum {number}
   * @const
   */
  var KeyCode = {
    LEFT: 37,
    UP: 38,
    RIGHT: 39,
    DOWN: 40
  };

  /**
   * @module ol/interaction/KeyboardPan
   */


  /**
   * @typedef {Object} Options
   * @property {import("../events/condition.js").Condition} [condition] A function that
   * takes an {@link module:ol/MapBrowserEvent~MapBrowserEvent} and returns a
   * boolean to indicate whether that event should be handled. Default is
   * {@link module:ol/events/condition~noModifierKeys} and
   * {@link module:ol/events/condition~targetNotEditable}.
   * @property {number} [duration=100] Animation duration in milliseconds.
   * @property {number} [pixelDelta=128] The amount of pixels to pan on each key
   * press.
   */


  /**
   * @classdesc
   * Allows the user to pan the map using keyboard arrows.
   * Note that, although this interaction is by default included in maps,
   * the keys can only be used when browser focus is on the element to which
   * the keyboard events are attached. By default, this is the map div,
   * though you can change this with the `keyboardEventTarget` in
   * {@link module:ol/Map~Map}. `document` never loses focus but, for any other
   * element, focus will have to be on, and returned to, this element if the keys
   * are to function.
   * See also {@link module:ol/interaction/KeyboardZoom~KeyboardZoom}.
   * @api
   */
  var KeyboardPan = /*@__PURE__*/(function (Interaction$$1) {
    function KeyboardPan(opt_options) {

      Interaction$$1.call(this, {
        handleEvent: handleEvent$1
      });

      var options = opt_options || {};

      /**
       * @private
       * @param {import("../MapBrowserEvent.js").default} mapBrowserEvent Browser event.
       * @return {boolean} Combined condition result.
       */
      this.defaultCondition_ = function(mapBrowserEvent) {
        return noModifierKeys(mapBrowserEvent) &&
          targetNotEditable(mapBrowserEvent);
      };

      /**
       * @private
       * @type {import("../events/condition.js").Condition}
       */
      this.condition_ = options.condition !== undefined ?
        options.condition : this.defaultCondition_;

      /**
       * @private
       * @type {number}
       */
      this.duration_ = options.duration !== undefined ? options.duration : 100;

      /**
       * @private
       * @type {number}
       */
      this.pixelDelta_ = options.pixelDelta !== undefined ?
        options.pixelDelta : 128;

    }

    if ( Interaction$$1 ) KeyboardPan.__proto__ = Interaction$$1;
    KeyboardPan.prototype = Object.create( Interaction$$1 && Interaction$$1.prototype );
    KeyboardPan.prototype.constructor = KeyboardPan;

    return KeyboardPan;
  }(Interaction));


  /**
   * Handles the {@link module:ol/MapBrowserEvent map browser event} if it was a
   * `KeyEvent`, and decides the direction to pan to (if an arrow key was
   * pressed).
   * @param {import("../MapBrowserEvent.js").default} mapBrowserEvent Map browser event.
   * @return {boolean} `false` to stop event propagation.
   * @this {KeyboardPan}
   */
  function handleEvent$1(mapBrowserEvent) {
    var stopEvent = false;
    if (mapBrowserEvent.type == EventType.KEYDOWN) {
      var keyEvent = /** @type {KeyboardEvent} */ (mapBrowserEvent.originalEvent);
      var keyCode = keyEvent.keyCode;
      if (this.condition_(mapBrowserEvent) &&
          (keyCode == KeyCode.DOWN ||
          keyCode == KeyCode.LEFT ||
          keyCode == KeyCode.RIGHT ||
          keyCode == KeyCode.UP)) {
        var map = mapBrowserEvent.map;
        var view = map.getView();
        var mapUnitsDelta = view.getResolution() * this.pixelDelta_;
        var deltaX = 0, deltaY = 0;
        if (keyCode == KeyCode.DOWN) {
          deltaY = -mapUnitsDelta;
        } else if (keyCode == KeyCode.LEFT) {
          deltaX = -mapUnitsDelta;
        } else if (keyCode == KeyCode.RIGHT) {
          deltaX = mapUnitsDelta;
        } else {
          deltaY = mapUnitsDelta;
        }
        var delta = [deltaX, deltaY];
        rotate(delta, view.getRotation());
        pan(view, delta, this.duration_);
        mapBrowserEvent.preventDefault();
        stopEvent = true;
      }
    }
    return !stopEvent;
  }

  /**
   * @module ol/interaction/KeyboardZoom
   */


  /**
   * @typedef {Object} Options
   * @property {number} [duration=100] Animation duration in milliseconds.
   * @property {import("../events/condition.js").Condition} [condition] A function that
   * takes an {@link module:ol/MapBrowserEvent~MapBrowserEvent} and returns a
   * boolean to indicate whether that event should be handled. Default is
   * {@link module:ol/events/condition~targetNotEditable}.
   * @property {number} [delta=1] The zoom level delta on each key press.
   */


  /**
   * @classdesc
   * Allows the user to zoom the map using keyboard + and -.
   * Note that, although this interaction is by default included in maps,
   * the keys can only be used when browser focus is on the element to which
   * the keyboard events are attached. By default, this is the map div,
   * though you can change this with the `keyboardEventTarget` in
   * {@link module:ol/Map~Map}. `document` never loses focus but, for any other
   * element, focus will have to be on, and returned to, this element if the keys
   * are to function.
   * See also {@link module:ol/interaction/KeyboardPan~KeyboardPan}.
   * @api
   */
  var KeyboardZoom = /*@__PURE__*/(function (Interaction$$1) {
    function KeyboardZoom(opt_options) {

      Interaction$$1.call(this, {
        handleEvent: handleEvent$2
      });

      var options = opt_options ? opt_options : {};

      /**
       * @private
       * @type {import("../events/condition.js").Condition}
       */
      this.condition_ = options.condition ? options.condition : targetNotEditable;

      /**
       * @private
       * @type {number}
       */
      this.delta_ = options.delta ? options.delta : 1;

      /**
       * @private
       * @type {number}
       */
      this.duration_ = options.duration !== undefined ? options.duration : 100;

    }

    if ( Interaction$$1 ) KeyboardZoom.__proto__ = Interaction$$1;
    KeyboardZoom.prototype = Object.create( Interaction$$1 && Interaction$$1.prototype );
    KeyboardZoom.prototype.constructor = KeyboardZoom;

    return KeyboardZoom;
  }(Interaction));


  /**
   * Handles the {@link module:ol/MapBrowserEvent map browser event} if it was a
   * `KeyEvent`, and decides whether to zoom in or out (depending on whether the
   * key pressed was '+' or '-').
   * @param {import("../MapBrowserEvent.js").default} mapBrowserEvent Map browser event.
   * @return {boolean} `false` to stop event propagation.
   * @this {KeyboardZoom}
   */
  function handleEvent$2(mapBrowserEvent) {
    var stopEvent = false;
    if (mapBrowserEvent.type == EventType.KEYDOWN ||
        mapBrowserEvent.type == EventType.KEYPRESS) {
      var keyEvent = /** @type {KeyboardEvent} */ (mapBrowserEvent.originalEvent);
      var charCode = keyEvent.charCode;
      if (this.condition_(mapBrowserEvent) &&
          (charCode == '+'.charCodeAt(0) || charCode == '-'.charCodeAt(0))) {
        var map = mapBrowserEvent.map;
        var delta = (charCode == '+'.charCodeAt(0)) ? this.delta_ : -this.delta_;
        var view = map.getView();
        zoomByDelta(view, delta, undefined, this.duration_);
        mapBrowserEvent.preventDefault();
        stopEvent = true;
      }
    }
    return !stopEvent;
  }

  /**
   * @module ol/interaction/MouseWheelZoom
   */


  /**
   * Maximum mouse wheel delta.
   * @type {number}
   */
  var MAX_DELTA = 1;


  /**
   * @enum {string}
   */
  var Mode = {
    TRACKPAD: 'trackpad',
    WHEEL: 'wheel'
  };


  /**
   * @typedef {Object} Options
   * @property {import("../events/condition.js").Condition} [condition] A function that
   * takes an {@link module:ol/MapBrowserEvent~MapBrowserEvent} and returns a
   * boolean to indicate whether that event should be handled. Default is
   * {@link module:ol/events/condition~always}.
   * @property {number} [duration=250] Animation duration in milliseconds.
   * @property {number} [timeout=80] Mouse wheel timeout duration in milliseconds.
   * @property {boolean} [constrainResolution=false] When using a trackpad or
   * magic mouse, zoom to the closest integer zoom level after the scroll gesture
   * ends.
   * @property {boolean} [useAnchor=true] Enable zooming using the mouse's
   * location as the anchor. When set to `false`, zooming in and out will zoom to
   * the center of the screen instead of zooming on the mouse's location.
   */


  /**
   * @classdesc
   * Allows the user to zoom the map by scrolling the mouse wheel.
   * @api
   */
  var MouseWheelZoom = /*@__PURE__*/(function (Interaction$$1) {
    function MouseWheelZoom(opt_options) {

      var options = opt_options ? opt_options : {};

      Interaction$$1.call(/** @type {import("./Interaction.js").InteractionOptions} */ this, (options));

      /**
       * @private
       * @type {number}
       */
      this.delta_ = 0;

      /**
       * @private
       * @type {number}
       */
      this.duration_ = options.duration !== undefined ? options.duration : 250;

      /**
       * @private
       * @type {number}
       */
      this.timeout_ = options.timeout !== undefined ? options.timeout : 80;

      /**
       * @private
       * @type {boolean}
       */
      this.useAnchor_ = options.useAnchor !== undefined ? options.useAnchor : true;

      /**
       * @private
       * @type {boolean}
       */
      this.constrainResolution_ = options.constrainResolution || false;

      /**
       * @private
       * @type {import("../events/condition.js").Condition}
       */
      this.condition_ = options.condition ? options.condition : always;

      /**
       * @private
       * @type {?import("../coordinate.js").Coordinate}
       */
      this.lastAnchor_ = null;

      /**
       * @private
       * @type {number|undefined}
       */
      this.startTime_ = undefined;

      /**
       * @private
       * @type {?}
       */
      this.timeoutId_;

      /**
       * @private
       * @type {Mode|undefined}
       */
      this.mode_ = undefined;

      /**
       * Trackpad events separated by this delay will be considered separate
       * interactions.
       * @type {number}
       */
      this.trackpadEventGap_ = 400;

      /**
       * @type {?}
       */
      this.trackpadTimeoutId_;

      /**
       * The number of delta values per zoom level
       * @private
       * @type {number}
       */
      this.trackpadDeltaPerZoom_ = 300;

      /**
       * The zoom factor by which scroll zooming is allowed to exceed the limits.
       * @private
       * @type {number}
       */
      this.trackpadZoomBuffer_ = 1.5;

    }

    if ( Interaction$$1 ) MouseWheelZoom.__proto__ = Interaction$$1;
    MouseWheelZoom.prototype = Object.create( Interaction$$1 && Interaction$$1.prototype );
    MouseWheelZoom.prototype.constructor = MouseWheelZoom;

    /**
     * @private
     */
    MouseWheelZoom.prototype.decrementInteractingHint_ = function decrementInteractingHint_ () {
      this.trackpadTimeoutId_ = undefined;
      var view = this.getMap().getView();
      view.setHint(ViewHint.INTERACTING, -1);
    };

    /**
     * Handles the {@link module:ol/MapBrowserEvent map browser event} (if it was a mousewheel-event) and eventually
     * zooms the map.
     * @override
     */
    MouseWheelZoom.prototype.handleEvent = function handleEvent (mapBrowserEvent) {
      if (!this.condition_(mapBrowserEvent)) {
        return true;
      }
      var type = mapBrowserEvent.type;
      if (type !== EventType.WHEEL && type !== EventType.MOUSEWHEEL) {
        return true;
      }

      mapBrowserEvent.preventDefault();

      var map = mapBrowserEvent.map;
      var wheelEvent = /** @type {WheelEvent} */ (mapBrowserEvent.originalEvent);

      if (this.useAnchor_) {
        this.lastAnchor_ = mapBrowserEvent.coordinate;
      }

      // Delta normalisation inspired by
      // https://github.com/mapbox/mapbox-gl-js/blob/001c7b9/js/ui/handler/scroll_zoom.js
      var delta;
      if (mapBrowserEvent.type == EventType.WHEEL) {
        delta = wheelEvent.deltaY;
        if (FIREFOX &&
            wheelEvent.deltaMode === WheelEvent.DOM_DELTA_PIXEL) {
          delta /= DEVICE_PIXEL_RATIO;
        }
        if (wheelEvent.deltaMode === WheelEvent.DOM_DELTA_LINE) {
          delta *= 40;
        }
      } else if (mapBrowserEvent.type == EventType.MOUSEWHEEL) {
        delta = -wheelEvent.wheelDeltaY;
        if (SAFARI) {
          delta /= 3;
        }
      }

      if (delta === 0) {
        return false;
      }

      var now = Date.now();

      if (this.startTime_ === undefined) {
        this.startTime_ = now;
      }

      if (!this.mode_ || now - this.startTime_ > this.trackpadEventGap_) {
        this.mode_ = Math.abs(delta) < 4 ?
          Mode.TRACKPAD :
          Mode.WHEEL;
      }

      if (this.mode_ === Mode.TRACKPAD) {
        var view = map.getView();
        if (this.trackpadTimeoutId_) {
          clearTimeout(this.trackpadTimeoutId_);
        } else {
          view.setHint(ViewHint.INTERACTING, 1);
        }
        this.trackpadTimeoutId_ = setTimeout(this.decrementInteractingHint_.bind(this), this.trackpadEventGap_);
        var resolution = view.getResolution() * Math.pow(2, delta / this.trackpadDeltaPerZoom_);
        var minResolution = view.getMinResolution();
        var maxResolution = view.getMaxResolution();
        var rebound = 0;
        if (resolution < minResolution) {
          resolution = Math.max(resolution, minResolution / this.trackpadZoomBuffer_);
          rebound = 1;
        } else if (resolution > maxResolution) {
          resolution = Math.min(resolution, maxResolution * this.trackpadZoomBuffer_);
          rebound = -1;
        }
        if (this.lastAnchor_) {
          var center = view.calculateCenterZoom(resolution, this.lastAnchor_);
          view.setCenter(view.constrainCenter(center));
        }
        view.setResolution(resolution);

        if (rebound === 0 && this.constrainResolution_) {
          view.animate({
            resolution: view.constrainResolution(resolution, delta > 0 ? -1 : 1),
            easing: easeOut,
            anchor: this.lastAnchor_,
            duration: this.duration_
          });
        }

        if (rebound > 0) {
          view.animate({
            resolution: minResolution,
            easing: easeOut,
            anchor: this.lastAnchor_,
            duration: 500
          });
        } else if (rebound < 0) {
          view.animate({
            resolution: maxResolution,
            easing: easeOut,
            anchor: this.lastAnchor_,
            duration: 500
          });
        }
        this.startTime_ = now;
        return false;
      }

      this.delta_ += delta;

      var timeLeft = Math.max(this.timeout_ - (now - this.startTime_), 0);

      clearTimeout(this.timeoutId_);
      this.timeoutId_ = setTimeout(this.handleWheelZoom_.bind(this, map), timeLeft);

      return false;
    };

    /**
     * @private
     * @param {import("../PluggableMap.js").default} map Map.
     */
    MouseWheelZoom.prototype.handleWheelZoom_ = function handleWheelZoom_ (map) {
      var view = map.getView();
      if (view.getAnimating()) {
        view.cancelAnimations();
      }
      var maxDelta = MAX_DELTA;
      var delta = clamp(this.delta_, -maxDelta, maxDelta);
      zoomByDelta(view, -delta, this.lastAnchor_, this.duration_);
      this.mode_ = undefined;
      this.delta_ = 0;
      this.lastAnchor_ = null;
      this.startTime_ = undefined;
      this.timeoutId_ = undefined;
    };

    /**
     * Enable or disable using the mouse's location as an anchor when zooming
     * @param {boolean} useAnchor true to zoom to the mouse's location, false
     * to zoom to the center of the map
     * @api
     */
    MouseWheelZoom.prototype.setMouseAnchor = function setMouseAnchor (useAnchor) {
      this.useAnchor_ = useAnchor;
      if (!useAnchor) {
        this.lastAnchor_ = null;
      }
    };

    return MouseWheelZoom;
  }(Interaction));

  /**
   * @module ol/interaction/PinchRotate
   */


  /**
   * @typedef {Object} Options
   * @property {number} [duration=250] The duration of the animation in
   * milliseconds.
   * @property {number} [threshold=0.3] Minimal angle in radians to start a rotation.
   */


  /**
   * @classdesc
   * Allows the user to rotate the map by twisting with two fingers
   * on a touch screen.
   * @api
   */
  var PinchRotate = /*@__PURE__*/(function (PointerInteraction$$1) {
    function PinchRotate(opt_options) {

      var options = opt_options ? opt_options : {};

      var pointerOptions = /** @type {import("./Pointer.js").Options} */ (options);

      if (!pointerOptions.stopDown) {
        pointerOptions.stopDown = FALSE;
      }

      PointerInteraction$$1.call(this, pointerOptions);

      /**
       * @private
       * @type {import("../coordinate.js").Coordinate}
       */
      this.anchor_ = null;

      /**
       * @private
       * @type {number|undefined}
       */
      this.lastAngle_ = undefined;

      /**
       * @private
       * @type {boolean}
       */
      this.rotating_ = false;

      /**
       * @private
       * @type {number}
       */
      this.rotationDelta_ = 0.0;

      /**
       * @private
       * @type {number}
       */
      this.threshold_ = options.threshold !== undefined ? options.threshold : 0.3;

      /**
       * @private
       * @type {number}
       */
      this.duration_ = options.duration !== undefined ? options.duration : 250;

    }

    if ( PointerInteraction$$1 ) PinchRotate.__proto__ = PointerInteraction$$1;
    PinchRotate.prototype = Object.create( PointerInteraction$$1 && PointerInteraction$$1.prototype );
    PinchRotate.prototype.constructor = PinchRotate;

    /**
     * @inheritDoc
     */
    PinchRotate.prototype.handleDragEvent = function handleDragEvent (mapBrowserEvent) {
      var rotationDelta = 0.0;

      var touch0 = this.targetPointers[0];
      var touch1 = this.targetPointers[1];

      // angle between touches
      var angle = Math.atan2(
        touch1.clientY - touch0.clientY,
        touch1.clientX - touch0.clientX);

      if (this.lastAngle_ !== undefined) {
        var delta = angle - this.lastAngle_;
        this.rotationDelta_ += delta;
        if (!this.rotating_ &&
            Math.abs(this.rotationDelta_) > this.threshold_) {
          this.rotating_ = true;
        }
        rotationDelta = delta;
      }
      this.lastAngle_ = angle;

      var map = mapBrowserEvent.map;
      var view = map.getView();
      if (view.getConstraints().rotation === disable) {
        return;
      }

      // rotate anchor point.
      // FIXME: should be the intersection point between the lines:
      //     touch0,touch1 and previousTouch0,previousTouch1
      var viewportPosition = map.getViewport().getBoundingClientRect();
      var centroid$$1 = centroid(this.targetPointers);
      centroid$$1[0] -= viewportPosition.left;
      centroid$$1[1] -= viewportPosition.top;
      this.anchor_ = map.getCoordinateFromPixel(centroid$$1);

      // rotate
      if (this.rotating_) {
        var rotation = view.getRotation();
        map.render();
        rotateWithoutConstraints(view, rotation + rotationDelta, this.anchor_);
      }
    };

    /**
     * @inheritDoc
     */
    PinchRotate.prototype.handleUpEvent = function handleUpEvent (mapBrowserEvent) {
      if (this.targetPointers.length < 2) {
        var map = mapBrowserEvent.map;
        var view = map.getView();
        view.setHint(ViewHint.INTERACTING, -1);
        if (this.rotating_) {
          var rotation = view.getRotation();
          rotate$3(view, rotation, this.anchor_, this.duration_);
        }
        return false;
      } else {
        return true;
      }
    };

    /**
     * @inheritDoc
     */
    PinchRotate.prototype.handleDownEvent = function handleDownEvent (mapBrowserEvent) {
      if (this.targetPointers.length >= 2) {
        var map = mapBrowserEvent.map;
        this.anchor_ = null;
        this.lastAngle_ = undefined;
        this.rotating_ = false;
        this.rotationDelta_ = 0.0;
        if (!this.handlingDownUpSequence) {
          map.getView().setHint(ViewHint.INTERACTING, 1);
        }
        return true;
      } else {
        return false;
      }
    };

    return PinchRotate;
  }(PointerInteraction));

  /**
   * @module ol/interaction/PinchZoom
   */


  /**
   * @typedef {Object} Options
   * @property {number} [duration=400] Animation duration in milliseconds.
   * @property {boolean} [constrainResolution=false] Zoom to the closest integer
   * zoom level after the pinch gesture ends.
   */


  /**
   * @classdesc
   * Allows the user to zoom the map by pinching with two fingers
   * on a touch screen.
   * @api
   */
  var PinchZoom = /*@__PURE__*/(function (PointerInteraction$$1) {
    function PinchZoom(opt_options) {

      var options = opt_options ? opt_options : {};

      var pointerOptions = /** @type {import("./Pointer.js").Options} */ (options);

      if (!pointerOptions.stopDown) {
        pointerOptions.stopDown = FALSE;
      }

      PointerInteraction$$1.call(this, pointerOptions);

      /**
       * @private
       * @type {boolean}
       */
      this.constrainResolution_ = options.constrainResolution || false;

      /**
       * @private
       * @type {import("../coordinate.js").Coordinate}
       */
      this.anchor_ = null;

      /**
       * @private
       * @type {number}
       */
      this.duration_ = options.duration !== undefined ? options.duration : 400;

      /**
       * @private
       * @type {number|undefined}
       */
      this.lastDistance_ = undefined;

      /**
       * @private
       * @type {number}
       */
      this.lastScaleDelta_ = 1;

    }

    if ( PointerInteraction$$1 ) PinchZoom.__proto__ = PointerInteraction$$1;
    PinchZoom.prototype = Object.create( PointerInteraction$$1 && PointerInteraction$$1.prototype );
    PinchZoom.prototype.constructor = PinchZoom;

    /**
     * @inheritDoc
     */
    PinchZoom.prototype.handleDragEvent = function handleDragEvent (mapBrowserEvent) {
      var scaleDelta = 1.0;

      var touch0 = this.targetPointers[0];
      var touch1 = this.targetPointers[1];
      var dx = touch0.clientX - touch1.clientX;
      var dy = touch0.clientY - touch1.clientY;

      // distance between touches
      var distance = Math.sqrt(dx * dx + dy * dy);

      if (this.lastDistance_ !== undefined) {
        scaleDelta = this.lastDistance_ / distance;
      }
      this.lastDistance_ = distance;


      var map = mapBrowserEvent.map;
      var view = map.getView();
      var resolution = view.getResolution();
      var maxResolution = view.getMaxResolution();
      var minResolution = view.getMinResolution();
      var newResolution = resolution * scaleDelta;
      if (newResolution > maxResolution) {
        scaleDelta = maxResolution / resolution;
        newResolution = maxResolution;
      } else if (newResolution < minResolution) {
        scaleDelta = minResolution / resolution;
        newResolution = minResolution;
      }

      if (scaleDelta != 1.0) {
        this.lastScaleDelta_ = scaleDelta;
      }

      // scale anchor point.
      var viewportPosition = map.getViewport().getBoundingClientRect();
      var centroid$$1 = centroid(this.targetPointers);
      centroid$$1[0] -= viewportPosition.left;
      centroid$$1[1] -= viewportPosition.top;
      this.anchor_ = map.getCoordinateFromPixel(centroid$$1);

      // scale, bypass the resolution constraint
      map.render();
      zoomWithoutConstraints(view, newResolution, this.anchor_);
    };

    /**
     * @inheritDoc
     */
    PinchZoom.prototype.handleUpEvent = function handleUpEvent (mapBrowserEvent) {
      if (this.targetPointers.length < 2) {
        var map = mapBrowserEvent.map;
        var view = map.getView();
        view.setHint(ViewHint.INTERACTING, -1);
        var resolution = view.getResolution();
        if (this.constrainResolution_ ||
            resolution < view.getMinResolution() ||
            resolution > view.getMaxResolution()) {
          // Zoom to final resolution, with an animation, and provide a
          // direction not to zoom out/in if user was pinching in/out.
          // Direction is > 0 if pinching out, and < 0 if pinching in.
          var direction = this.lastScaleDelta_ - 1;
          zoom(view, resolution, this.anchor_, this.duration_, direction);
        }
        return false;
      } else {
        return true;
      }
    };

    /**
     * @inheritDoc
     */
    PinchZoom.prototype.handleDownEvent = function handleDownEvent (mapBrowserEvent) {
      if (this.targetPointers.length >= 2) {
        var map = mapBrowserEvent.map;
        this.anchor_ = null;
        this.lastDistance_ = undefined;
        this.lastScaleDelta_ = 1;
        if (!this.handlingDownUpSequence) {
          map.getView().setHint(ViewHint.INTERACTING, 1);
        }
        return true;
      } else {
        return false;
      }
    };

    return PinchZoom;
  }(PointerInteraction));

  /**
   * @module ol/interaction/DragAndDrop
   */


  /**
   * @typedef {Object} Options
   * @property {Array<typeof import("../format/Feature.js").default>} [formatConstructors] Format constructors.
   * @property {import("../source/Vector.js").default} [source] Optional vector source where features will be added.  If a source is provided
   * all existing features will be removed and new features will be added when
   * they are dropped on the target.  If you want to add features to a vector
   * source without removing the existing features (append only), instead of
   * providing the source option listen for the "addfeatures" event.
   * @property {import("../proj.js").ProjectionLike} [projection] Target projection. By default, the map's view's projection is used.
   * @property {HTMLElement} [target] The element that is used as the drop target, default is the viewport element.
   */


  /**
   * @enum {string}
   */
  var DragAndDropEventType = {
    /**
     * Triggered when features are added
     * @event DragAndDropEvent#addfeatures
     * @api
     */
    ADD_FEATURES: 'addfeatures'
  };


  /**
   * @classdesc
   * Events emitted by {@link module:ol/interaction/DragAndDrop~DragAndDrop} instances are instances
   * of this type.
   */
  var DragAndDropEvent = /*@__PURE__*/(function (Event$$1) {
    function DragAndDropEvent(type, file, opt_features, opt_projection) {

      Event$$1.call(this, type);

      /**
       * The features parsed from dropped data.
       * @type {Array<import("../Feature.js").FeatureLike>|undefined}
       * @api
       */
      this.features = opt_features;

      /**
       * The dropped file.
       * @type {File}
       * @api
       */
      this.file = file;

      /**
       * The feature projection.
       * @type {import("../proj/Projection.js").default|undefined}
       * @api
       */
      this.projection = opt_projection;

    }

    if ( Event$$1 ) DragAndDropEvent.__proto__ = Event$$1;
    DragAndDropEvent.prototype = Object.create( Event$$1 && Event$$1.prototype );
    DragAndDropEvent.prototype.constructor = DragAndDropEvent;

    return DragAndDropEvent;
  }(Event));


  /**
   * @classdesc
   * Handles input of vector data by drag and drop.
   * @api
   *
   * @fires DragAndDropEvent
   */
  var DragAndDrop = /*@__PURE__*/(function (Interaction$$1) {
    function DragAndDrop(opt_options) {

      var options = opt_options ? opt_options : {};

      Interaction$$1.call(this, {
        handleEvent: TRUE
      });

      /**
       * @private
       * @type {Array<typeof import("../format/Feature.js").default>}
       */
      this.formatConstructors_ = options.formatConstructors ?
        options.formatConstructors : [];

      /**
       * @private
       * @type {import("../proj/Projection.js").default}
       */
      this.projection_ = options.projection ?
        get$2(options.projection) : null;

      /**
       * @private
       * @type {Array<import("../events.js").EventsKey>}
       */
      this.dropListenKeys_ = null;

      /**
       * @private
       * @type {import("../source/Vector.js").default}
       */
      this.source_ = options.source || null;

      /**
       * @private
       * @type {HTMLElement}
       */
      this.target = options.target ? options.target : null;

    }

    if ( Interaction$$1 ) DragAndDrop.__proto__ = Interaction$$1;
    DragAndDrop.prototype = Object.create( Interaction$$1 && Interaction$$1.prototype );
    DragAndDrop.prototype.constructor = DragAndDrop;

    /**
     * @param {File} file File.
     * @param {Event} event Load event.
     * @private
     */
    DragAndDrop.prototype.handleResult_ = function handleResult_ (file, event) {
      var result = event.target.result;
      var map = this.getMap();
      var projection = this.projection_;
      if (!projection) {
        var view = map.getView();
        projection = view.getProjection();
      }

      var formatConstructors = this.formatConstructors_;
      var features = [];
      for (var i = 0, ii = formatConstructors.length; i < ii; ++i) {
        var format = new formatConstructors[i]();
        features = this.tryReadFeatures_(format, result, {
          featureProjection: projection
        });
        if (features && features.length > 0) {
          break;
        }
      }
      if (this.source_) {
        this.source_.clear();
        this.source_.addFeatures(features);
      }
      this.dispatchEvent(
        new DragAndDropEvent(
          DragAndDropEventType.ADD_FEATURES, file,
          features, projection));
    };

    /**
     * @private
     */
    DragAndDrop.prototype.registerListeners_ = function registerListeners_ () {
      var map = this.getMap();
      if (map) {
        var dropArea = this.target ? this.target : map.getViewport();
        this.dropListenKeys_ = [
          listen(dropArea, EventType.DROP, handleDrop, this),
          listen(dropArea, EventType.DRAGENTER, handleStop, this),
          listen(dropArea, EventType.DRAGOVER, handleStop, this),
          listen(dropArea, EventType.DROP, handleStop, this)
        ];
      }
    };

    /**
     * @inheritDoc
     */
    DragAndDrop.prototype.setActive = function setActive (active) {
      Interaction$$1.prototype.setActive.call(this, active);
      if (active) {
        this.registerListeners_();
      } else {
        this.unregisterListeners_();
      }
    };

    /**
     * @inheritDoc
     */
    DragAndDrop.prototype.setMap = function setMap (map) {
      this.unregisterListeners_();
      Interaction$$1.prototype.setMap.call(this, map);
      if (this.getActive()) {
        this.registerListeners_();
      }
    };

    /**
     * @param {import("../format/Feature.js").default} format Format.
     * @param {string} text Text.
     * @param {import("../format/Feature.js").ReadOptions} options Read options.
     * @private
     * @return {Array<import("../Feature.js").FeatureLike>} Features.
     */
    DragAndDrop.prototype.tryReadFeatures_ = function tryReadFeatures_ (format, text, options) {
      try {
        return format.readFeatures(text, options);
      } catch (e) {
        return null;
      }
    };

    /**
     * @private
     */
    DragAndDrop.prototype.unregisterListeners_ = function unregisterListeners_ () {
      if (this.dropListenKeys_) {
        this.dropListenKeys_.forEach(unlistenByKey);
        this.dropListenKeys_ = null;
      }
    };

    return DragAndDrop;
  }(Interaction));


  /**
   * @param {DragEvent} event Event.
   * @this {DragAndDrop}
   */
  function handleDrop(event) {
    var files = event.dataTransfer.files;
    for (var i = 0, ii = files.length; i < ii; ++i) {
      var file = files.item(i);
      var reader = new FileReader();
      reader.addEventListener(EventType.LOAD, this.handleResult_.bind(this, file));
      reader.readAsText(file);
    }
  }


  /**
   * @param {DragEvent} event Event.
   */
  function handleStop(event) {
    event.stopPropagation();
    event.preventDefault();
    event.dataTransfer.dropEffect = 'copy';
  }

  /**
   * @module ol/interaction/DragRotateAndZoom
   */


  /**
   * @typedef {Object} Options
   * @property {import("../events/condition.js").Condition} [condition] A function that
   * takes an {@link module:ol/MapBrowserEvent~MapBrowserEvent} and returns a
   * boolean to indicate whether that event should be handled.
   * Default is {@link module:ol/events/condition~shiftKeyOnly}.
   * @property {number} [duration=400] Animation duration in milliseconds.
   */


  /**
   * @classdesc
   * Allows the user to zoom and rotate the map by clicking and dragging
   * on the map.  By default, this interaction is limited to when the shift
   * key is held down.
   *
   * This interaction is only supported for mouse devices.
   *
   * And this interaction is not included in the default interactions.
   * @api
   */
  var DragRotateAndZoom = /*@__PURE__*/(function (PointerInteraction$$1) {
    function DragRotateAndZoom(opt_options) {

      var options = opt_options ? opt_options : {};

      PointerInteraction$$1.call(/** @type {import("./Pointer.js").Options} */ this, (options));

      /**
       * @private
       * @type {import("../events/condition.js").Condition}
       */
      this.condition_ = options.condition ? options.condition : shiftKeyOnly;

      /**
       * @private
       * @type {number|undefined}
       */
      this.lastAngle_ = undefined;

      /**
       * @private
       * @type {number|undefined}
       */
      this.lastMagnitude_ = undefined;

      /**
       * @private
       * @type {number}
       */
      this.lastScaleDelta_ = 0;

      /**
       * @private
       * @type {number}
       */
      this.duration_ = options.duration !== undefined ? options.duration : 400;

    }

    if ( PointerInteraction$$1 ) DragRotateAndZoom.__proto__ = PointerInteraction$$1;
    DragRotateAndZoom.prototype = Object.create( PointerInteraction$$1 && PointerInteraction$$1.prototype );
    DragRotateAndZoom.prototype.constructor = DragRotateAndZoom;

    /**
     * @inheritDoc
     */
    DragRotateAndZoom.prototype.handleDragEvent = function handleDragEvent (mapBrowserEvent) {
      if (!mouseOnly(mapBrowserEvent)) {
        return;
      }

      var map = mapBrowserEvent.map;
      var size = map.getSize();
      var offset = mapBrowserEvent.pixel;
      var deltaX = offset[0] - size[0] / 2;
      var deltaY = size[1] / 2 - offset[1];
      var theta = Math.atan2(deltaY, deltaX);
      var magnitude = Math.sqrt(deltaX * deltaX + deltaY * deltaY);
      var view = map.getView();
      if (view.getConstraints().rotation !== disable && this.lastAngle_ !== undefined) {
        var angleDelta = theta - this.lastAngle_;
        rotateWithoutConstraints(view, view.getRotation() - angleDelta);
      }
      this.lastAngle_ = theta;
      if (this.lastMagnitude_ !== undefined) {
        var resolution = this.lastMagnitude_ * (view.getResolution() / magnitude);
        zoomWithoutConstraints(view, resolution);
      }
      if (this.lastMagnitude_ !== undefined) {
        this.lastScaleDelta_ = this.lastMagnitude_ / magnitude;
      }
      this.lastMagnitude_ = magnitude;
    };

    /**
     * @inheritDoc
     */
    DragRotateAndZoom.prototype.handleUpEvent = function handleUpEvent (mapBrowserEvent) {
      if (!mouseOnly(mapBrowserEvent)) {
        return true;
      }

      var map = mapBrowserEvent.map;
      var view = map.getView();
      view.setHint(ViewHint.INTERACTING, -1);
      var direction = this.lastScaleDelta_ - 1;
      rotate$3(view, view.getRotation());
      zoom(view, view.getResolution(), undefined, this.duration_, direction);
      this.lastScaleDelta_ = 0;
      return false;
    };

    /**
     * @inheritDoc
     */
    DragRotateAndZoom.prototype.handleDownEvent = function handleDownEvent (mapBrowserEvent) {
      if (!mouseOnly(mapBrowserEvent)) {
        return false;
      }

      if (this.condition_(mapBrowserEvent)) {
        mapBrowserEvent.map.getView().setHint(ViewHint.INTERACTING, 1);
        this.lastAngle_ = undefined;
        this.lastMagnitude_ = undefined;
        return true;
      } else {
        return false;
      }
    };

    return DragRotateAndZoom;
  }(PointerInteraction));

  /**
   * @module ol/Feature
   */

  /**
   * @typedef {typeof Feature|typeof import("./render/Feature.js").default} FeatureClass
   */

  /**
   * @typedef {Feature|import("./render/Feature.js").default} FeatureLike
   */

  /**
   * @classdesc
   * A vector object for geographic features with a geometry and other
   * attribute properties, similar to the features in vector file formats like
   * GeoJSON.
   *
   * Features can be styled individually with `setStyle`; otherwise they use the
   * style of their vector layer.
   *
   * Note that attribute properties are set as {@link module:ol/Object} properties on
   * the feature object, so they are observable, and have get/set accessors.
   *
   * Typically, a feature has a single geometry property. You can set the
   * geometry using the `setGeometry` method and get it with `getGeometry`.
   * It is possible to store more than one geometry on a feature using attribute
   * properties. By default, the geometry used for rendering is identified by
   * the property name `geometry`. If you want to use another geometry property
   * for rendering, use the `setGeometryName` method to change the attribute
   * property associated with the geometry for the feature.  For example:
   *
   * ```js
   *
   * import Feature from 'ol/Feature';
   * import Polygon from 'ol/geom/Polygon';
   * import Point from 'ol/geom/Point';
   *
   * var feature = new Feature({
   *   geometry: new Polygon(polyCoords),
   *   labelPoint: new Point(labelCoords),
   *   name: 'My Polygon'
   * });
   *
   * // get the polygon geometry
   * var poly = feature.getGeometry();
   *
   * // Render the feature as a point using the coordinates from labelPoint
   * feature.setGeometryName('labelPoint');
   *
   * // get the point geometry
   * var point = feature.getGeometry();
   * ```
   *
   * @api
   */
  var Feature = /*@__PURE__*/(function (BaseObject$$1) {
    function Feature(opt_geometryOrProperties) {

      BaseObject$$1.call(this);

      /**
       * @private
       * @type {number|string|undefined}
       */
      this.id_ = undefined;

      /**
       * @type {string}
       * @private
       */
      this.geometryName_ = 'geometry';

      /**
       * User provided style.
       * @private
       * @type {import("./style/Style.js").StyleLike}
       */
      this.style_ = null;

      /**
       * @private
       * @type {import("./style/Style.js").StyleFunction|undefined}
       */
      this.styleFunction_ = undefined;

      /**
       * @private
       * @type {?import("./events.js").EventsKey}
       */
      this.geometryChangeKey_ = null;

      listen(
        this, getChangeEventType(this.geometryName_),
        this.handleGeometryChanged_, this);

      if (opt_geometryOrProperties) {
        if (typeof /** @type {?} */ (opt_geometryOrProperties).getSimplifiedGeometry === 'function') {
          var geometry = /** @type {import("./geom/Geometry.js").default} */ (opt_geometryOrProperties);
          this.setGeometry(geometry);
        } else {
          /** @type {Object<string, *>} */
          var properties = opt_geometryOrProperties;
          this.setProperties(properties);
        }
      }
    }

    if ( BaseObject$$1 ) Feature.__proto__ = BaseObject$$1;
    Feature.prototype = Object.create( BaseObject$$1 && BaseObject$$1.prototype );
    Feature.prototype.constructor = Feature;

    /**
     * Clone this feature. If the original feature has a geometry it
     * is also cloned. The feature id is not set in the clone.
     * @return {Feature} The clone.
     * @api
     */
    Feature.prototype.clone = function clone () {
      var clone = new Feature(this.getProperties());
      clone.setGeometryName(this.getGeometryName());
      var geometry = this.getGeometry();
      if (geometry) {
        clone.setGeometry(geometry.clone());
      }
      var style = this.getStyle();
      if (style) {
        clone.setStyle(style);
      }
      return clone;
    };

    /**
     * Get the feature's default geometry.  A feature may have any number of named
     * geometries.  The "default" geometry (the one that is rendered by default) is
     * set when calling {@link module:ol/Feature~Feature#setGeometry}.
     * @return {import("./geom/Geometry.js").default|undefined} The default geometry for the feature.
     * @api
     * @observable
     */
    Feature.prototype.getGeometry = function getGeometry () {
      return (
        /** @type {import("./geom/Geometry.js").default|undefined} */ (this.get(this.geometryName_))
      );
    };

    /**
     * Get the feature identifier.  This is a stable identifier for the feature and
     * is either set when reading data from a remote source or set explicitly by
     * calling {@link module:ol/Feature~Feature#setId}.
     * @return {number|string|undefined} Id.
     * @api
     */
    Feature.prototype.getId = function getId () {
      return this.id_;
    };

    /**
     * Get the name of the feature's default geometry.  By default, the default
     * geometry is named `geometry`.
     * @return {string} Get the property name associated with the default geometry
     *     for this feature.
     * @api
     */
    Feature.prototype.getGeometryName = function getGeometryName () {
      return this.geometryName_;
    };

    /**
     * Get the feature's style. Will return what was provided to the
     * {@link module:ol/Feature~Feature#setStyle} method.
     * @return {import("./style/Style.js").StyleLike} The feature style.
     * @api
     */
    Feature.prototype.getStyle = function getStyle () {
      return this.style_;
    };

    /**
     * Get the feature's style function.
     * @return {import("./style/Style.js").StyleFunction|undefined} Return a function
     * representing the current style of this feature.
     * @api
     */
    Feature.prototype.getStyleFunction = function getStyleFunction () {
      return this.styleFunction_;
    };

    /**
     * @private
     */
    Feature.prototype.handleGeometryChange_ = function handleGeometryChange_ () {
      this.changed();
    };

    /**
     * @private
     */
    Feature.prototype.handleGeometryChanged_ = function handleGeometryChanged_ () {
      if (this.geometryChangeKey_) {
        unlistenByKey(this.geometryChangeKey_);
        this.geometryChangeKey_ = null;
      }
      var geometry = this.getGeometry();
      if (geometry) {
        this.geometryChangeKey_ = listen(geometry,
          EventType.CHANGE, this.handleGeometryChange_, this);
      }
      this.changed();
    };

    /**
     * Set the default geometry for the feature.  This will update the property
     * with the name returned by {@link module:ol/Feature~Feature#getGeometryName}.
     * @param {import("./geom/Geometry.js").default|undefined} geometry The new geometry.
     * @api
     * @observable
     */
    Feature.prototype.setGeometry = function setGeometry (geometry) {
      this.set(this.geometryName_, geometry);
    };

    /**
     * Set the style for the feature.  This can be a single style object, an array
     * of styles, or a function that takes a resolution and returns an array of
     * styles. If it is `null` the feature has no style (a `null` style).
     * @param {import("./style/Style.js").StyleLike} style Style for this feature.
     * @api
     * @fires module:ol/events/Event~Event#event:change
     */
    Feature.prototype.setStyle = function setStyle (style) {
      this.style_ = style;
      this.styleFunction_ = !style ? undefined : createStyleFunction(style);
      this.changed();
    };

    /**
     * Set the feature id.  The feature id is considered stable and may be used when
     * requesting features or comparing identifiers returned from a remote source.
     * The feature id can be used with the
     * {@link module:ol/source/Vector~VectorSource#getFeatureById} method.
     * @param {number|string|undefined} id The feature id.
     * @api
     * @fires module:ol/events/Event~Event#event:change
     */
    Feature.prototype.setId = function setId (id) {
      this.id_ = id;
      this.changed();
    };

    /**
     * Set the property name to be used when getting the feature's default geometry.
     * When calling {@link module:ol/Feature~Feature#getGeometry}, the value of the property with
     * this name will be returned.
     * @param {string} name The property name of the default geometry.
     * @api
     */
    Feature.prototype.setGeometryName = function setGeometryName (name) {
      unlisten(
        this, getChangeEventType(this.geometryName_),
        this.handleGeometryChanged_, this);
      this.geometryName_ = name;
      listen(
        this, getChangeEventType(this.geometryName_),
        this.handleGeometryChanged_, this);
      this.handleGeometryChanged_();
    };

    return Feature;
  }(BaseObject));


  /**
   * Convert the provided object into a feature style function.  Functions passed
   * through unchanged.  Arrays of Style or single style objects wrapped
   * in a new feature style function.
   * @param {!import("./style/Style.js").StyleFunction|!Array<import("./style/Style.js").default>|!import("./style/Style.js").default} obj
   *     A feature style function, a single style, or an array of styles.
   * @return {import("./style/Style.js").StyleFunction} A style function.
   */
  function createStyleFunction(obj) {
    if (typeof obj === 'function') {
      return obj;
    } else {
      /**
       * @type {Array<import("./style/Style.js").default>}
       */
      var styles;
      if (Array.isArray(obj)) {
        styles = obj;
      } else {
        assert(typeof /** @type {?} */ (obj).getZIndex === 'function',
          41); // Expected an `import("./style/Style.js").Style` or an array of `import("./style/Style.js").Style`
        var style = /** @type {import("./style/Style.js").default} */ (obj);
        styles = [style];
      }
      return function() {
        return styles;
      };
    }
  }

  /**
   * @module ol/geom/Circle
   */

  /**
   * @classdesc
   * Circle geometry.
   *
   * @api
   */
  var Circle = /*@__PURE__*/(function (SimpleGeometry$$1) {
    function Circle(center, opt_radius, opt_layout) {
      SimpleGeometry$$1.call(this);
      if (opt_layout !== undefined && opt_radius === undefined) {
        this.setFlatCoordinates(opt_layout, center);
      } else {
        var radius = opt_radius ? opt_radius : 0;
        this.setCenterAndRadius(center, radius, opt_layout);
      }
    }

    if ( SimpleGeometry$$1 ) Circle.__proto__ = SimpleGeometry$$1;
    Circle.prototype = Object.create( SimpleGeometry$$1 && SimpleGeometry$$1.prototype );
    Circle.prototype.constructor = Circle;

    /**
     * Make a complete copy of the geometry.
     * @return {!Circle} Clone.
     * @override
     * @api
     */
    Circle.prototype.clone = function clone$$1 () {
      return new Circle(this.flatCoordinates.slice(), undefined, this.layout);
    };

    /**
     * @inheritDoc
     */
    Circle.prototype.closestPointXY = function closestPointXY (x, y, closestPoint, minSquaredDistance) {
      var flatCoordinates = this.flatCoordinates;
      var dx = x - flatCoordinates[0];
      var dy = y - flatCoordinates[1];
      var squaredDistance = dx * dx + dy * dy;
      if (squaredDistance < minSquaredDistance) {
        if (squaredDistance === 0) {
          for (var i = 0; i < this.stride; ++i) {
            closestPoint[i] = flatCoordinates[i];
          }
        } else {
          var delta = this.getRadius() / Math.sqrt(squaredDistance);
          closestPoint[0] = flatCoordinates[0] + delta * dx;
          closestPoint[1] = flatCoordinates[1] + delta * dy;
          for (var i$1 = 2; i$1 < this.stride; ++i$1) {
            closestPoint[i$1] = flatCoordinates[i$1];
          }
        }
        closestPoint.length = this.stride;
        return squaredDistance;
      } else {
        return minSquaredDistance;
      }
    };

    /**
     * @inheritDoc
     */
    Circle.prototype.containsXY = function containsXY$$1 (x, y) {
      var flatCoordinates = this.flatCoordinates;
      var dx = x - flatCoordinates[0];
      var dy = y - flatCoordinates[1];
      return dx * dx + dy * dy <= this.getRadiusSquared_();
    };

    /**
     * Return the center of the circle as {@link module:ol/coordinate~Coordinate coordinate}.
     * @return {import("../coordinate.js").Coordinate} Center.
     * @api
     */
    Circle.prototype.getCenter = function getCenter$$1 () {
      return this.flatCoordinates.slice(0, this.stride);
    };

    /**
     * @inheritDoc
     */
    Circle.prototype.computeExtent = function computeExtent (extent) {
      var flatCoordinates = this.flatCoordinates;
      var radius = flatCoordinates[this.stride] - flatCoordinates[0];
      return createOrUpdate(
        flatCoordinates[0] - radius, flatCoordinates[1] - radius,
        flatCoordinates[0] + radius, flatCoordinates[1] + radius,
        extent);
    };

    /**
     * Return the radius of the circle.
     * @return {number} Radius.
     * @api
     */
    Circle.prototype.getRadius = function getRadius () {
      return Math.sqrt(this.getRadiusSquared_());
    };

    /**
     * @private
     * @return {number} Radius squared.
     */
    Circle.prototype.getRadiusSquared_ = function getRadiusSquared_ () {
      var dx = this.flatCoordinates[this.stride] - this.flatCoordinates[0];
      var dy = this.flatCoordinates[this.stride + 1] - this.flatCoordinates[1];
      return dx * dx + dy * dy;
    };

    /**
     * @inheritDoc
     * @api
     */
    Circle.prototype.getType = function getType () {
      return GeometryType.CIRCLE;
    };

    /**
     * @inheritDoc
     * @api
     */
    Circle.prototype.intersectsExtent = function intersectsExtent (extent) {
      var circleExtent = this.getExtent();
      if (intersects(extent, circleExtent)) {
        var center = this.getCenter();

        if (extent[0] <= center[0] && extent[2] >= center[0]) {
          return true;
        }
        if (extent[1] <= center[1] && extent[3] >= center[1]) {
          return true;
        }

        return forEachCorner(extent, this.intersectsCoordinate, this);
      }
      return false;

    };

    /**
     * Set the center of the circle as {@link module:ol/coordinate~Coordinate coordinate}.
     * @param {import("../coordinate.js").Coordinate} center Center.
     * @api
     */
    Circle.prototype.setCenter = function setCenter (center) {
      var stride = this.stride;
      var radius = this.flatCoordinates[stride] - this.flatCoordinates[0];
      var flatCoordinates = center.slice();
      flatCoordinates[stride] = flatCoordinates[0] + radius;
      for (var i = 1; i < stride; ++i) {
        flatCoordinates[stride + i] = center[i];
      }
      this.setFlatCoordinates(this.layout, flatCoordinates);
      this.changed();
    };

    /**
     * Set the center (as {@link module:ol/coordinate~Coordinate coordinate}) and the radius (as
     * number) of the circle.
     * @param {!import("../coordinate.js").Coordinate} center Center.
     * @param {number} radius Radius.
     * @param {import("./GeometryLayout.js").default=} opt_layout Layout.
     * @api
     */
    Circle.prototype.setCenterAndRadius = function setCenterAndRadius (center, radius, opt_layout) {
      this.setLayout(opt_layout, center, 0);
      if (!this.flatCoordinates) {
        this.flatCoordinates = [];
      }
      /** @type {Array<number>} */
      var flatCoordinates = this.flatCoordinates;
      var offset = deflateCoordinate(
        flatCoordinates, 0, center, this.stride);
      flatCoordinates[offset++] = flatCoordinates[0] + radius;
      for (var i = 1, ii = this.stride; i < ii; ++i) {
        flatCoordinates[offset++] = flatCoordinates[i];
      }
      flatCoordinates.length = offset;
      this.changed();
    };

    /**
     * @inheritDoc
     */
    Circle.prototype.getCoordinates = function getCoordinates () {
      return null;
    };

    /**
     * @inheritDoc
     */
    Circle.prototype.setCoordinates = function setCoordinates (coordinates, opt_layout) {};

    /**
     * Set the radius of the circle. The radius is in the units of the projection.
     * @param {number} radius Radius.
     * @api
     */
    Circle.prototype.setRadius = function setRadius (radius) {
      this.flatCoordinates[this.stride] = this.flatCoordinates[0] + radius;
      this.changed();
    };

    return Circle;
  }(SimpleGeometry));


  /**
   * Transform each coordinate of the circle from one coordinate reference system
   * to another. The geometry is modified in place.
   * If you do not want the geometry modified in place, first clone() it and
   * then use this function on the clone.
   *
   * Internally a circle is currently represented by two points: the center of
   * the circle `[cx, cy]`, and the point to the right of the circle
   * `[cx + r, cy]`. This `transform` function just transforms these two points.
   * So the resulting geometry is also a circle, and that circle does not
   * correspond to the shape that would be obtained by transforming every point
   * of the original circle.
   *
   * @param {import("../proj.js").ProjectionLike} source The current projection.  Can be a
   *     string identifier or a {@link module:ol/proj/Projection~Projection} object.
   * @param {import("../proj.js").ProjectionLike} destination The desired projection.  Can be a
   *     string identifier or a {@link module:ol/proj/Projection~Projection} object.
   * @return {Circle} This geometry.  Note that original geometry is
   *     modified in place.
   * @function
   * @api
   */
  Circle.prototype.transform;

  /**
   * @module ol/geom/flat/interpolate
   */


  /**
   * @param {Array<number>} flatCoordinates Flat coordinates.
   * @param {number} offset Offset.
   * @param {number} end End.
   * @param {number} stride Stride.
   * @param {number} fraction Fraction.
   * @param {Array<number>=} opt_dest Destination.
   * @return {Array<number>} Destination.
   */
  function interpolatePoint(flatCoordinates, offset, end, stride, fraction, opt_dest) {
    var pointX = NaN;
    var pointY = NaN;
    var n = (end - offset) / stride;
    if (n === 1) {
      pointX = flatCoordinates[offset];
      pointY = flatCoordinates[offset + 1];
    } else if (n == 2) {
      pointX = (1 - fraction) * flatCoordinates[offset] +
          fraction * flatCoordinates[offset + stride];
      pointY = (1 - fraction) * flatCoordinates[offset + 1] +
          fraction * flatCoordinates[offset + stride + 1];
    } else if (n !== 0) {
      var x1 = flatCoordinates[offset];
      var y1 = flatCoordinates[offset + 1];
      var length = 0;
      var cumulativeLengths = [0];
      for (var i = offset + stride; i < end; i += stride) {
        var x2 = flatCoordinates[i];
        var y2 = flatCoordinates[i + 1];
        length += Math.sqrt((x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1));
        cumulativeLengths.push(length);
        x1 = x2;
        y1 = y2;
      }
      var target = fraction * length;
      var index = binarySearch(cumulativeLengths, target);
      if (index < 0) {
        var t = (target - cumulativeLengths[-index - 2]) /
            (cumulativeLengths[-index - 1] - cumulativeLengths[-index - 2]);
        var o = offset + (-index - 2) * stride;
        pointX = lerp(
          flatCoordinates[o], flatCoordinates[o + stride], t);
        pointY = lerp(
          flatCoordinates[o + 1], flatCoordinates[o + stride + 1], t);
      } else {
        pointX = flatCoordinates[offset + index * stride];
        pointY = flatCoordinates[offset + index * stride + 1];
      }
    }
    if (opt_dest) {
      opt_dest[0] = pointX;
      opt_dest[1] = pointY;
      return opt_dest;
    } else {
      return [pointX, pointY];
    }
  }


  /**
   * @param {Array<number>} flatCoordinates Flat coordinates.
   * @param {number} offset Offset.
   * @param {number} end End.
   * @param {number} stride Stride.
   * @param {number} m M.
   * @param {boolean} extrapolate Extrapolate.
   * @return {import("../../coordinate.js").Coordinate} Coordinate.
   */
  function lineStringCoordinateAtM(flatCoordinates, offset, end, stride, m, extrapolate) {
    if (end == offset) {
      return null;
    }
    var coordinate;
    if (m < flatCoordinates[offset + stride - 1]) {
      if (extrapolate) {
        coordinate = flatCoordinates.slice(offset, offset + stride);
        coordinate[stride - 1] = m;
        return coordinate;
      } else {
        return null;
      }
    } else if (flatCoordinates[end - 1] < m) {
      if (extrapolate) {
        coordinate = flatCoordinates.slice(end - stride, end);
        coordinate[stride - 1] = m;
        return coordinate;
      } else {
        return null;
      }
    }
    // FIXME use O(1) search
    if (m == flatCoordinates[offset + stride - 1]) {
      return flatCoordinates.slice(offset, offset + stride);
    }
    var lo = offset / stride;
    var hi = end / stride;
    while (lo < hi) {
      var mid = (lo + hi) >> 1;
      if (m < flatCoordinates[(mid + 1) * stride - 1]) {
        hi = mid;
      } else {
        lo = mid + 1;
      }
    }
    var m0 = flatCoordinates[lo * stride - 1];
    if (m == m0) {
      return flatCoordinates.slice((lo - 1) * stride, (lo - 1) * stride + stride);
    }
    var m1 = flatCoordinates[(lo + 1) * stride - 1];
    var t = (m - m0) / (m1 - m0);
    coordinate = [];
    for (var i = 0; i < stride - 1; ++i) {
      coordinate.push(lerp(flatCoordinates[(lo - 1) * stride + i],
        flatCoordinates[lo * stride + i], t));
    }
    coordinate.push(m);
    return coordinate;
  }


  /**
   * @param {Array<number>} flatCoordinates Flat coordinates.
   * @param {number} offset Offset.
   * @param {Array<number>} ends Ends.
   * @param {number} stride Stride.
   * @param {number} m M.
   * @param {boolean} extrapolate Extrapolate.
   * @param {boolean} interpolate Interpolate.
   * @return {import("../../coordinate.js").Coordinate} Coordinate.
   */
  function lineStringsCoordinateAtM(
    flatCoordinates, offset, ends, stride, m, extrapolate, interpolate) {
    if (interpolate) {
      return lineStringCoordinateAtM(
        flatCoordinates, offset, ends[ends.length - 1], stride, m, extrapolate);
    }
    var coordinate;
    if (m < flatCoordinates[stride - 1]) {
      if (extrapolate) {
        coordinate = flatCoordinates.slice(0, stride);
        coordinate[stride - 1] = m;
        return coordinate;
      } else {
        return null;
      }
    }
    if (flatCoordinates[flatCoordinates.length - 1] < m) {
      if (extrapolate) {
        coordinate = flatCoordinates.slice(flatCoordinates.length - stride);
        coordinate[stride - 1] = m;
        return coordinate;
      } else {
        return null;
      }
    }
    for (var i = 0, ii = ends.length; i < ii; ++i) {
      var end = ends[i];
      if (offset == end) {
        continue;
      }
      if (m < flatCoordinates[offset + stride - 1]) {
        return null;
      } else if (m <= flatCoordinates[end - 1]) {
        return lineStringCoordinateAtM(
          flatCoordinates, offset, end, stride, m, false);
      }
      offset = end;
    }
    return null;
  }

  /**
   * @module ol/geom/flat/length
   */


  /**
   * @param {Array<number>} flatCoordinates Flat coordinates.
   * @param {number} offset Offset.
   * @param {number} end End.
   * @param {number} stride Stride.
   * @return {number} Length.
   */
  function lineStringLength(flatCoordinates, offset, end, stride) {
    var x1 = flatCoordinates[offset];
    var y1 = flatCoordinates[offset + 1];
    var length = 0;
    for (var i = offset + stride; i < end; i += stride) {
      var x2 = flatCoordinates[i];
      var y2 = flatCoordinates[i + 1];
      length += Math.sqrt((x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1));
      x1 = x2;
      y1 = y2;
    }
    return length;
  }

  /**
   * @module ol/geom/LineString
   */

  /**
   * @classdesc
   * Linestring geometry.
   *
   * @api
   */
  var LineString = /*@__PURE__*/(function (SimpleGeometry$$1) {
    function LineString(coordinates, opt_layout) {

      SimpleGeometry$$1.call(this);

      /**
       * @private
       * @type {import("../coordinate.js").Coordinate}
       */
      this.flatMidpoint_ = null;

      /**
       * @private
       * @type {number}
       */
      this.flatMidpointRevision_ = -1;

      /**
       * @private
       * @type {number}
       */
      this.maxDelta_ = -1;

      /**
       * @private
       * @type {number}
       */
      this.maxDeltaRevision_ = -1;

      if (opt_layout !== undefined && !Array.isArray(coordinates[0])) {
        this.setFlatCoordinates(opt_layout, /** @type {Array<number>} */ (coordinates));
      } else {
        this.setCoordinates(/** @type {Array<import("../coordinate.js").Coordinate>} */ (coordinates), opt_layout);
      }

    }

    if ( SimpleGeometry$$1 ) LineString.__proto__ = SimpleGeometry$$1;
    LineString.prototype = Object.create( SimpleGeometry$$1 && SimpleGeometry$$1.prototype );
    LineString.prototype.constructor = LineString;

    /**
     * Append the passed coordinate to the coordinates of the linestring.
     * @param {import("../coordinate.js").Coordinate} coordinate Coordinate.
     * @api
     */
    LineString.prototype.appendCoordinate = function appendCoordinate (coordinate) {
      if (!this.flatCoordinates) {
        this.flatCoordinates = coordinate.slice();
      } else {
        extend(this.flatCoordinates, coordinate);
      }
      this.changed();
    };

    /**
     * Make a complete copy of the geometry.
     * @return {!LineString} Clone.
     * @override
     * @api
     */
    LineString.prototype.clone = function clone$$1 () {
      return new LineString(this.flatCoordinates.slice(), this.layout);
    };

    /**
     * @inheritDoc
     */
    LineString.prototype.closestPointXY = function closestPointXY (x, y, closestPoint, minSquaredDistance) {
      if (minSquaredDistance < closestSquaredDistanceXY(this.getExtent(), x, y)) {
        return minSquaredDistance;
      }
      if (this.maxDeltaRevision_ != this.getRevision()) {
        this.maxDelta_ = Math.sqrt(maxSquaredDelta(
          this.flatCoordinates, 0, this.flatCoordinates.length, this.stride, 0));
        this.maxDeltaRevision_ = this.getRevision();
      }
      return assignClosestPoint(
        this.flatCoordinates, 0, this.flatCoordinates.length, this.stride,
        this.maxDelta_, false, x, y, closestPoint, minSquaredDistance);
    };

    /**
     * Iterate over each segment, calling the provided callback.
     * If the callback returns a truthy value the function returns that
     * value immediately. Otherwise the function returns `false`.
     *
     * @param {function(this: S, import("../coordinate.js").Coordinate, import("../coordinate.js").Coordinate): T} callback Function
     *     called for each segment.
     * @return {T|boolean} Value.
     * @template T,S
     * @api
     */
    LineString.prototype.forEachSegment = function forEachSegment$1 (callback) {
      return forEach(this.flatCoordinates, 0, this.flatCoordinates.length, this.stride, callback);
    };

    /**
     * Returns the coordinate at `m` using linear interpolation, or `null` if no
     * such coordinate exists.
     *
     * `opt_extrapolate` controls extrapolation beyond the range of Ms in the
     * MultiLineString. If `opt_extrapolate` is `true` then Ms less than the first
     * M will return the first coordinate and Ms greater than the last M will
     * return the last coordinate.
     *
     * @param {number} m M.
     * @param {boolean=} opt_extrapolate Extrapolate. Default is `false`.
     * @return {import("../coordinate.js").Coordinate} Coordinate.
     * @api
     */
    LineString.prototype.getCoordinateAtM = function getCoordinateAtM (m, opt_extrapolate) {
      if (this.layout != GeometryLayout.XYM &&
          this.layout != GeometryLayout.XYZM) {
        return null;
      }
      var extrapolate = opt_extrapolate !== undefined ? opt_extrapolate : false;
      return lineStringCoordinateAtM(this.flatCoordinates, 0,
        this.flatCoordinates.length, this.stride, m, extrapolate);
    };

    /**
     * Return the coordinates of the linestring.
     * @return {Array<import("../coordinate.js").Coordinate>} Coordinates.
     * @override
     * @api
     */
    LineString.prototype.getCoordinates = function getCoordinates () {
      return inflateCoordinates(
        this.flatCoordinates, 0, this.flatCoordinates.length, this.stride);
    };

    /**
     * Return the coordinate at the provided fraction along the linestring.
     * The `fraction` is a number between 0 and 1, where 0 is the start of the
     * linestring and 1 is the end.
     * @param {number} fraction Fraction.
     * @param {import("../coordinate.js").Coordinate=} opt_dest Optional coordinate whose values will
     *     be modified. If not provided, a new coordinate will be returned.
     * @return {import("../coordinate.js").Coordinate} Coordinate of the interpolated point.
     * @api
     */
    LineString.prototype.getCoordinateAt = function getCoordinateAt (fraction, opt_dest) {
      return interpolatePoint(
        this.flatCoordinates, 0, this.flatCoordinates.length, this.stride,
        fraction, opt_dest);
    };

    /**
     * Return the length of the linestring on projected plane.
     * @return {number} Length (on projected plane).
     * @api
     */
    LineString.prototype.getLength = function getLength () {
      return lineStringLength(
        this.flatCoordinates, 0, this.flatCoordinates.length, this.stride);
    };

    /**
     * @return {Array<number>} Flat midpoint.
     */
    LineString.prototype.getFlatMidpoint = function getFlatMidpoint () {
      if (this.flatMidpointRevision_ != this.getRevision()) {
        this.flatMidpoint_ = this.getCoordinateAt(0.5, this.flatMidpoint_);
        this.flatMidpointRevision_ = this.getRevision();
      }
      return this.flatMidpoint_;
    };

    /**
     * @inheritDoc
     */
    LineString.prototype.getSimplifiedGeometryInternal = function getSimplifiedGeometryInternal (squaredTolerance) {
      var simplifiedFlatCoordinates = [];
      simplifiedFlatCoordinates.length = douglasPeucker(
        this.flatCoordinates, 0, this.flatCoordinates.length, this.stride,
        squaredTolerance, simplifiedFlatCoordinates, 0);
      return new LineString(simplifiedFlatCoordinates, GeometryLayout.XY);
    };

    /**
     * @inheritDoc
     * @api
     */
    LineString.prototype.getType = function getType () {
      return GeometryType.LINE_STRING;
    };

    /**
     * @inheritDoc
     * @api
     */
    LineString.prototype.intersectsExtent = function intersectsExtent (extent) {
      return intersectsLineString(
        this.flatCoordinates, 0, this.flatCoordinates.length, this.stride,
        extent);
    };

    /**
     * Set the coordinates of the linestring.
     * @param {!Array<import("../coordinate.js").Coordinate>} coordinates Coordinates.
     * @param {GeometryLayout=} opt_layout Layout.
     * @override
     * @api
     */
    LineString.prototype.setCoordinates = function setCoordinates (coordinates, opt_layout) {
      this.setLayout(opt_layout, coordinates, 1);
      if (!this.flatCoordinates) {
        this.flatCoordinates = [];
      }
      this.flatCoordinates.length = deflateCoordinates(
        this.flatCoordinates, 0, coordinates, this.stride);
      this.changed();
    };

    return LineString;
  }(SimpleGeometry));

  /**
   * @module ol/geom/MultiLineString
   */

  /**
   * @classdesc
   * Multi-linestring geometry.
   *
   * @api
   */
  var MultiLineString = /*@__PURE__*/(function (SimpleGeometry$$1) {
    function MultiLineString(coordinates, opt_layout, opt_ends) {

      SimpleGeometry$$1.call(this);

      /**
       * @type {Array<number>}
       * @private
       */
      this.ends_ = [];

      /**
       * @private
       * @type {number}
       */
      this.maxDelta_ = -1;

      /**
       * @private
       * @type {number}
       */
      this.maxDeltaRevision_ = -1;

      if (Array.isArray(coordinates[0])) {
        this.setCoordinates(/** @type {Array<Array<import("../coordinate.js").Coordinate>>} */ (coordinates), opt_layout);
      } else if (opt_layout !== undefined && opt_ends) {
        this.setFlatCoordinates(opt_layout, /** @type {Array<number>} */ (coordinates));
        this.ends_ = opt_ends;
      } else {
        var layout = this.getLayout();
        var lineStrings = /** @type {Array<LineString>} */ (coordinates);
        var flatCoordinates = [];
        var ends = [];
        for (var i = 0, ii = lineStrings.length; i < ii; ++i) {
          var lineString = lineStrings[i];
          if (i === 0) {
            layout = lineString.getLayout();
          }
          extend(flatCoordinates, lineString.getFlatCoordinates());
          ends.push(flatCoordinates.length);
        }
        this.setFlatCoordinates(layout, flatCoordinates);
        this.ends_ = ends;
      }

    }

    if ( SimpleGeometry$$1 ) MultiLineString.__proto__ = SimpleGeometry$$1;
    MultiLineString.prototype = Object.create( SimpleGeometry$$1 && SimpleGeometry$$1.prototype );
    MultiLineString.prototype.constructor = MultiLineString;

    /**
     * Append the passed linestring to the multilinestring.
     * @param {LineString} lineString LineString.
     * @api
     */
    MultiLineString.prototype.appendLineString = function appendLineString (lineString) {
      if (!this.flatCoordinates) {
        this.flatCoordinates = lineString.getFlatCoordinates().slice();
      } else {
        extend(this.flatCoordinates, lineString.getFlatCoordinates().slice());
      }
      this.ends_.push(this.flatCoordinates.length);
      this.changed();
    };

    /**
     * Make a complete copy of the geometry.
     * @return {!MultiLineString} Clone.
     * @override
     * @api
     */
    MultiLineString.prototype.clone = function clone$$1 () {
      return new MultiLineString(this.flatCoordinates.slice(), this.layout, this.ends_.slice());
    };

    /**
     * @inheritDoc
     */
    MultiLineString.prototype.closestPointXY = function closestPointXY (x, y, closestPoint, minSquaredDistance) {
      if (minSquaredDistance < closestSquaredDistanceXY(this.getExtent(), x, y)) {
        return minSquaredDistance;
      }
      if (this.maxDeltaRevision_ != this.getRevision()) {
        this.maxDelta_ = Math.sqrt(arrayMaxSquaredDelta(
          this.flatCoordinates, 0, this.ends_, this.stride, 0));
        this.maxDeltaRevision_ = this.getRevision();
      }
      return assignClosestArrayPoint(
        this.flatCoordinates, 0, this.ends_, this.stride,
        this.maxDelta_, false, x, y, closestPoint, minSquaredDistance);
    };

    /**
     * Returns the coordinate at `m` using linear interpolation, or `null` if no
     * such coordinate exists.
     *
     * `opt_extrapolate` controls extrapolation beyond the range of Ms in the
     * MultiLineString. If `opt_extrapolate` is `true` then Ms less than the first
     * M will return the first coordinate and Ms greater than the last M will
     * return the last coordinate.
     *
     * `opt_interpolate` controls interpolation between consecutive LineStrings
     * within the MultiLineString. If `opt_interpolate` is `true` the coordinates
     * will be linearly interpolated between the last coordinate of one LineString
     * and the first coordinate of the next LineString.  If `opt_interpolate` is
     * `false` then the function will return `null` for Ms falling between
     * LineStrings.
     *
     * @param {number} m M.
     * @param {boolean=} opt_extrapolate Extrapolate. Default is `false`.
     * @param {boolean=} opt_interpolate Interpolate. Default is `false`.
     * @return {import("../coordinate.js").Coordinate} Coordinate.
     * @api
     */
    MultiLineString.prototype.getCoordinateAtM = function getCoordinateAtM (m, opt_extrapolate, opt_interpolate) {
      if ((this.layout != GeometryLayout.XYM &&
           this.layout != GeometryLayout.XYZM) ||
          this.flatCoordinates.length === 0) {
        return null;
      }
      var extrapolate = opt_extrapolate !== undefined ? opt_extrapolate : false;
      var interpolate = opt_interpolate !== undefined ? opt_interpolate : false;
      return lineStringsCoordinateAtM(this.flatCoordinates, 0,
        this.ends_, this.stride, m, extrapolate, interpolate);
    };

    /**
     * Return the coordinates of the multilinestring.
     * @return {Array<Array<import("../coordinate.js").Coordinate>>} Coordinates.
     * @override
     * @api
     */
    MultiLineString.prototype.getCoordinates = function getCoordinates () {
      return inflateCoordinatesArray(
        this.flatCoordinates, 0, this.ends_, this.stride);
    };

    /**
     * @return {Array<number>} Ends.
     */
    MultiLineString.prototype.getEnds = function getEnds () {
      return this.ends_;
    };

    /**
     * Return the linestring at the specified index.
     * @param {number} index Index.
     * @return {LineString} LineString.
     * @api
     */
    MultiLineString.prototype.getLineString = function getLineString (index) {
      if (index < 0 || this.ends_.length <= index) {
        return null;
      }
      return new LineString(this.flatCoordinates.slice(
        index === 0 ? 0 : this.ends_[index - 1], this.ends_[index]), this.layout);
    };

    /**
     * Return the linestrings of this multilinestring.
     * @return {Array<LineString>} LineStrings.
     * @api
     */
    MultiLineString.prototype.getLineStrings = function getLineStrings () {
      var flatCoordinates = this.flatCoordinates;
      var ends = this.ends_;
      var layout = this.layout;
      /** @type {Array<LineString>} */
      var lineStrings = [];
      var offset = 0;
      for (var i = 0, ii = ends.length; i < ii; ++i) {
        var end = ends[i];
        var lineString = new LineString(flatCoordinates.slice(offset, end), layout);
        lineStrings.push(lineString);
        offset = end;
      }
      return lineStrings;
    };

    /**
     * @return {Array<number>} Flat midpoints.
     */
    MultiLineString.prototype.getFlatMidpoints = function getFlatMidpoints () {
      var midpoints = [];
      var flatCoordinates = this.flatCoordinates;
      var offset = 0;
      var ends = this.ends_;
      var stride = this.stride;
      for (var i = 0, ii = ends.length; i < ii; ++i) {
        var end = ends[i];
        var midpoint = interpolatePoint(
          flatCoordinates, offset, end, stride, 0.5);
        extend(midpoints, midpoint);
        offset = end;
      }
      return midpoints;
    };

    /**
     * @inheritDoc
     */
    MultiLineString.prototype.getSimplifiedGeometryInternal = function getSimplifiedGeometryInternal (squaredTolerance) {
      var simplifiedFlatCoordinates = [];
      var simplifiedEnds = [];
      simplifiedFlatCoordinates.length = douglasPeuckerArray(
        this.flatCoordinates, 0, this.ends_, this.stride, squaredTolerance,
        simplifiedFlatCoordinates, 0, simplifiedEnds);
      return new MultiLineString(simplifiedFlatCoordinates, GeometryLayout.XY, simplifiedEnds);
    };

    /**
     * @inheritDoc
     * @api
     */
    MultiLineString.prototype.getType = function getType () {
      return GeometryType.MULTI_LINE_STRING;
    };

    /**
     * @inheritDoc
     * @api
     */
    MultiLineString.prototype.intersectsExtent = function intersectsExtent (extent) {
      return intersectsLineStringArray(
        this.flatCoordinates, 0, this.ends_, this.stride, extent);
    };

    /**
     * Set the coordinates of the multilinestring.
     * @param {!Array<Array<import("../coordinate.js").Coordinate>>} coordinates Coordinates.
     * @param {GeometryLayout=} opt_layout Layout.
     * @override
     * @api
     */
    MultiLineString.prototype.setCoordinates = function setCoordinates (coordinates, opt_layout) {
      this.setLayout(opt_layout, coordinates, 2);
      if (!this.flatCoordinates) {
        this.flatCoordinates = [];
      }
      var ends = deflateCoordinatesArray(
        this.flatCoordinates, 0, coordinates, this.stride, this.ends_);
      this.flatCoordinates.length = ends.length === 0 ? 0 : ends[ends.length - 1];
      this.changed();
    };

    return MultiLineString;
  }(SimpleGeometry));

  /**
   * @module ol/geom/MultiPoint
   */

  /**
   * @classdesc
   * Multi-point geometry.
   *
   * @api
   */
  var MultiPoint = /*@__PURE__*/(function (SimpleGeometry$$1) {
    function MultiPoint(coordinates, opt_layout) {
      SimpleGeometry$$1.call(this);
      if (opt_layout && !Array.isArray(coordinates[0])) {
        this.setFlatCoordinates(opt_layout, /** @type {Array<number>} */ (coordinates));
      } else {
        this.setCoordinates(/** @type {Array<import("../coordinate.js").Coordinate>} */ (coordinates), opt_layout);
      }
    }

    if ( SimpleGeometry$$1 ) MultiPoint.__proto__ = SimpleGeometry$$1;
    MultiPoint.prototype = Object.create( SimpleGeometry$$1 && SimpleGeometry$$1.prototype );
    MultiPoint.prototype.constructor = MultiPoint;

    /**
     * Append the passed point to this multipoint.
     * @param {Point} point Point.
     * @api
     */
    MultiPoint.prototype.appendPoint = function appendPoint (point) {
      if (!this.flatCoordinates) {
        this.flatCoordinates = point.getFlatCoordinates().slice();
      } else {
        extend(this.flatCoordinates, point.getFlatCoordinates());
      }
      this.changed();
    };

    /**
     * Make a complete copy of the geometry.
     * @return {!MultiPoint} Clone.
     * @override
     * @api
     */
    MultiPoint.prototype.clone = function clone$$1 () {
      var multiPoint = new MultiPoint(this.flatCoordinates.slice(), this.layout);
      return multiPoint;
    };

    /**
     * @inheritDoc
     */
    MultiPoint.prototype.closestPointXY = function closestPointXY (x, y, closestPoint, minSquaredDistance) {
      if (minSquaredDistance < closestSquaredDistanceXY(this.getExtent(), x, y)) {
        return minSquaredDistance;
      }
      var flatCoordinates = this.flatCoordinates;
      var stride = this.stride;
      for (var i = 0, ii = flatCoordinates.length; i < ii; i += stride) {
        var squaredDistance$$1 = squaredDistance(
          x, y, flatCoordinates[i], flatCoordinates[i + 1]);
        if (squaredDistance$$1 < minSquaredDistance) {
          minSquaredDistance = squaredDistance$$1;
          for (var j = 0; j < stride; ++j) {
            closestPoint[j] = flatCoordinates[i + j];
          }
          closestPoint.length = stride;
        }
      }
      return minSquaredDistance;
    };

    /**
     * Return the coordinates of the multipoint.
     * @return {Array<import("../coordinate.js").Coordinate>} Coordinates.
     * @override
     * @api
     */
    MultiPoint.prototype.getCoordinates = function getCoordinates () {
      return inflateCoordinates(
        this.flatCoordinates, 0, this.flatCoordinates.length, this.stride);
    };

    /**
     * Return the point at the specified index.
     * @param {number} index Index.
     * @return {Point} Point.
     * @api
     */
    MultiPoint.prototype.getPoint = function getPoint (index) {
      var n = !this.flatCoordinates ? 0 : this.flatCoordinates.length / this.stride;
      if (index < 0 || n <= index) {
        return null;
      }
      return new Point(this.flatCoordinates.slice(
        index * this.stride, (index + 1) * this.stride), this.layout);
    };

    /**
     * Return the points of this multipoint.
     * @return {Array<Point>} Points.
     * @api
     */
    MultiPoint.prototype.getPoints = function getPoints () {
      var flatCoordinates = this.flatCoordinates;
      var layout = this.layout;
      var stride = this.stride;
      /** @type {Array<Point>} */
      var points = [];
      for (var i = 0, ii = flatCoordinates.length; i < ii; i += stride) {
        var point = new Point(flatCoordinates.slice(i, i + stride), layout);
        points.push(point);
      }
      return points;
    };

    /**
     * @inheritDoc
     * @api
     */
    MultiPoint.prototype.getType = function getType () {
      return GeometryType.MULTI_POINT;
    };

    /**
     * @inheritDoc
     * @api
     */
    MultiPoint.prototype.intersectsExtent = function intersectsExtent (extent) {
      var flatCoordinates = this.flatCoordinates;
      var stride = this.stride;
      for (var i = 0, ii = flatCoordinates.length; i < ii; i += stride) {
        var x = flatCoordinates[i];
        var y = flatCoordinates[i + 1];
        if (containsXY(extent, x, y)) {
          return true;
        }
      }
      return false;
    };

    /**
     * Set the coordinates of the multipoint.
     * @param {!Array<import("../coordinate.js").Coordinate>} coordinates Coordinates.
     * @param {import("./GeometryLayout.js").default=} opt_layout Layout.
     * @override
     * @api
     */
    MultiPoint.prototype.setCoordinates = function setCoordinates (coordinates, opt_layout) {
      this.setLayout(opt_layout, coordinates, 1);
      if (!this.flatCoordinates) {
        this.flatCoordinates = [];
      }
      this.flatCoordinates.length = deflateCoordinates(
        this.flatCoordinates, 0, coordinates, this.stride);
      this.changed();
    };

    return MultiPoint;
  }(SimpleGeometry));

  /**
   * @module ol/geom/flat/center
   */


  /**
   * @param {Array<number>} flatCoordinates Flat coordinates.
   * @param {number} offset Offset.
   * @param {Array<Array<number>>} endss Endss.
   * @param {number} stride Stride.
   * @return {Array<number>} Flat centers.
   */
  function linearRingss$1(flatCoordinates, offset, endss, stride) {
    var flatCenters = [];
    var extent = createEmpty();
    for (var i = 0, ii = endss.length; i < ii; ++i) {
      var ends = endss[i];
      extent = createOrUpdateFromFlatCoordinates(flatCoordinates, offset, ends[0], stride);
      flatCenters.push((extent[0] + extent[2]) / 2, (extent[1] + extent[3]) / 2);
      offset = ends[ends.length - 1];
    }
    return flatCenters;
  }

  /**
   * @module ol/geom/MultiPolygon
   */

  /**
   * @classdesc
   * Multi-polygon geometry.
   *
   * @api
   */
  var MultiPolygon = /*@__PURE__*/(function (SimpleGeometry$$1) {
    function MultiPolygon(coordinates, opt_layout, opt_endss) {

      SimpleGeometry$$1.call(this);

      /**
       * @type {Array<Array<number>>}
       * @private
       */
      this.endss_ = [];

      /**
       * @private
       * @type {number}
       */
      this.flatInteriorPointsRevision_ = -1;

      /**
       * @private
       * @type {Array<number>}
       */
      this.flatInteriorPoints_ = null;

      /**
       * @private
       * @type {number}
       */
      this.maxDelta_ = -1;

      /**
       * @private
       * @type {number}
       */
      this.maxDeltaRevision_ = -1;

      /**
       * @private
       * @type {number}
       */
      this.orientedRevision_ = -1;

      /**
       * @private
       * @type {Array<number>}
       */
      this.orientedFlatCoordinates_ = null;

      if (!opt_endss && !Array.isArray(coordinates[0])) {
        var layout = this.getLayout();
        var polygons = /** @type {Array<Polygon>} */ (coordinates);
        var flatCoordinates = [];
        var endss = [];
        for (var i = 0, ii = polygons.length; i < ii; ++i) {
          var polygon = polygons[i];
          if (i === 0) {
            layout = polygon.getLayout();
          }
          var offset = flatCoordinates.length;
          var ends = polygon.getEnds();
          for (var j = 0, jj = ends.length; j < jj; ++j) {
            ends[j] += offset;
          }
          extend(flatCoordinates, polygon.getFlatCoordinates());
          endss.push(ends);
        }
        opt_layout = layout;
        coordinates = flatCoordinates;
        opt_endss = endss;
      }
      if (opt_layout !== undefined && opt_endss) {
        this.setFlatCoordinates(opt_layout, /** @type {Array<number>} */ (coordinates));
        this.endss_ = opt_endss;
      } else {
        this.setCoordinates(/** @type {Array<Array<Array<import("../coordinate.js").Coordinate>>>} */ (coordinates),
          opt_layout);
      }

    }

    if ( SimpleGeometry$$1 ) MultiPolygon.__proto__ = SimpleGeometry$$1;
    MultiPolygon.prototype = Object.create( SimpleGeometry$$1 && SimpleGeometry$$1.prototype );
    MultiPolygon.prototype.constructor = MultiPolygon;

    /**
     * Append the passed polygon to this multipolygon.
     * @param {Polygon} polygon Polygon.
     * @api
     */
    MultiPolygon.prototype.appendPolygon = function appendPolygon (polygon) {
      /** @type {Array<number>} */
      var ends;
      if (!this.flatCoordinates) {
        this.flatCoordinates = polygon.getFlatCoordinates().slice();
        ends = polygon.getEnds().slice();
        this.endss_.push();
      } else {
        var offset = this.flatCoordinates.length;
        extend(this.flatCoordinates, polygon.getFlatCoordinates());
        ends = polygon.getEnds().slice();
        for (var i = 0, ii = ends.length; i < ii; ++i) {
          ends[i] += offset;
        }
      }
      this.endss_.push(ends);
      this.changed();
    };

    /**
     * Make a complete copy of the geometry.
     * @return {!MultiPolygon} Clone.
     * @override
     * @api
     */
    MultiPolygon.prototype.clone = function clone$$1 () {
      var len = this.endss_.length;
      var newEndss = new Array(len);
      for (var i = 0; i < len; ++i) {
        newEndss[i] = this.endss_[i].slice();
      }

      return new MultiPolygon(
        this.flatCoordinates.slice(), this.layout, newEndss);
    };

    /**
     * @inheritDoc
     */
    MultiPolygon.prototype.closestPointXY = function closestPointXY (x, y, closestPoint, minSquaredDistance) {
      if (minSquaredDistance < closestSquaredDistanceXY(this.getExtent(), x, y)) {
        return minSquaredDistance;
      }
      if (this.maxDeltaRevision_ != this.getRevision()) {
        this.maxDelta_ = Math.sqrt(multiArrayMaxSquaredDelta(
          this.flatCoordinates, 0, this.endss_, this.stride, 0));
        this.maxDeltaRevision_ = this.getRevision();
      }
      return assignClosestMultiArrayPoint(
        this.getOrientedFlatCoordinates(), 0, this.endss_, this.stride,
        this.maxDelta_, true, x, y, closestPoint, minSquaredDistance);
    };

    /**
     * @inheritDoc
     */
    MultiPolygon.prototype.containsXY = function containsXY$$1 (x, y) {
      return linearRingssContainsXY(this.getOrientedFlatCoordinates(), 0, this.endss_, this.stride, x, y);
    };

    /**
     * Return the area of the multipolygon on projected plane.
     * @return {number} Area (on projected plane).
     * @api
     */
    MultiPolygon.prototype.getArea = function getArea$$1 () {
      return linearRingss(this.getOrientedFlatCoordinates(), 0, this.endss_, this.stride);
    };

    /**
     * Get the coordinate array for this geometry.  This array has the structure
     * of a GeoJSON coordinate array for multi-polygons.
     *
     * @param {boolean=} opt_right Orient coordinates according to the right-hand
     *     rule (counter-clockwise for exterior and clockwise for interior rings).
     *     If `false`, coordinates will be oriented according to the left-hand rule
     *     (clockwise for exterior and counter-clockwise for interior rings).
     *     By default, coordinate orientation will depend on how the geometry was
     *     constructed.
     * @return {Array<Array<Array<import("../coordinate.js").Coordinate>>>} Coordinates.
     * @override
     * @api
     */
    MultiPolygon.prototype.getCoordinates = function getCoordinates (opt_right) {
      var flatCoordinates;
      if (opt_right !== undefined) {
        flatCoordinates = this.getOrientedFlatCoordinates().slice();
        orientLinearRingsArray(
          flatCoordinates, 0, this.endss_, this.stride, opt_right);
      } else {
        flatCoordinates = this.flatCoordinates;
      }

      return inflateMultiCoordinatesArray(
        flatCoordinates, 0, this.endss_, this.stride);
    };

    /**
     * @return {Array<Array<number>>} Endss.
     */
    MultiPolygon.prototype.getEndss = function getEndss () {
      return this.endss_;
    };

    /**
     * @return {Array<number>} Flat interior points.
     */
    MultiPolygon.prototype.getFlatInteriorPoints = function getFlatInteriorPoints () {
      if (this.flatInteriorPointsRevision_ != this.getRevision()) {
        var flatCenters = linearRingss$1(
          this.flatCoordinates, 0, this.endss_, this.stride);
        this.flatInteriorPoints_ = getInteriorPointsOfMultiArray(
          this.getOrientedFlatCoordinates(), 0, this.endss_, this.stride,
          flatCenters);
        this.flatInteriorPointsRevision_ = this.getRevision();
      }
      return this.flatInteriorPoints_;
    };

    /**
     * Return the interior points as {@link module:ol/geom/MultiPoint multipoint}.
     * @return {MultiPoint} Interior points as XYM coordinates, where M is
     * the length of the horizontal intersection that the point belongs to.
     * @api
     */
    MultiPolygon.prototype.getInteriorPoints = function getInteriorPoints () {
      return new MultiPoint(this.getFlatInteriorPoints().slice(), GeometryLayout.XYM);
    };

    /**
     * @return {Array<number>} Oriented flat coordinates.
     */
    MultiPolygon.prototype.getOrientedFlatCoordinates = function getOrientedFlatCoordinates () {
      if (this.orientedRevision_ != this.getRevision()) {
        var flatCoordinates = this.flatCoordinates;
        if (linearRingsAreOriented(
          flatCoordinates, 0, this.endss_, this.stride)) {
          this.orientedFlatCoordinates_ = flatCoordinates;
        } else {
          this.orientedFlatCoordinates_ = flatCoordinates.slice();
          this.orientedFlatCoordinates_.length =
              orientLinearRingsArray(
                this.orientedFlatCoordinates_, 0, this.endss_, this.stride);
        }
        this.orientedRevision_ = this.getRevision();
      }
      return this.orientedFlatCoordinates_;
    };

    /**
     * @inheritDoc
     */
    MultiPolygon.prototype.getSimplifiedGeometryInternal = function getSimplifiedGeometryInternal (squaredTolerance) {
      var simplifiedFlatCoordinates = [];
      var simplifiedEndss = [];
      simplifiedFlatCoordinates.length = quantizeMultiArray(
        this.flatCoordinates, 0, this.endss_, this.stride,
        Math.sqrt(squaredTolerance),
        simplifiedFlatCoordinates, 0, simplifiedEndss);
      return new MultiPolygon(simplifiedFlatCoordinates, GeometryLayout.XY, simplifiedEndss);
    };

    /**
     * Return the polygon at the specified index.
     * @param {number} index Index.
     * @return {Polygon} Polygon.
     * @api
     */
    MultiPolygon.prototype.getPolygon = function getPolygon (index) {
      if (index < 0 || this.endss_.length <= index) {
        return null;
      }
      var offset;
      if (index === 0) {
        offset = 0;
      } else {
        var prevEnds = this.endss_[index - 1];
        offset = prevEnds[prevEnds.length - 1];
      }
      var ends = this.endss_[index].slice();
      var end = ends[ends.length - 1];
      if (offset !== 0) {
        for (var i = 0, ii = ends.length; i < ii; ++i) {
          ends[i] -= offset;
        }
      }
      return new Polygon(this.flatCoordinates.slice(offset, end), this.layout, ends);
    };

    /**
     * Return the polygons of this multipolygon.
     * @return {Array<Polygon>} Polygons.
     * @api
     */
    MultiPolygon.prototype.getPolygons = function getPolygons () {
      var layout = this.layout;
      var flatCoordinates = this.flatCoordinates;
      var endss = this.endss_;
      var polygons = [];
      var offset = 0;
      for (var i = 0, ii = endss.length; i < ii; ++i) {
        var ends = endss[i].slice();
        var end = ends[ends.length - 1];
        if (offset !== 0) {
          for (var j = 0, jj = ends.length; j < jj; ++j) {
            ends[j] -= offset;
          }
        }
        var polygon = new Polygon(flatCoordinates.slice(offset, end), layout, ends);
        polygons.push(polygon);
        offset = end;
      }
      return polygons;
    };

    /**
     * @inheritDoc
     * @api
     */
    MultiPolygon.prototype.getType = function getType () {
      return GeometryType.MULTI_POLYGON;
    };

    /**
     * @inheritDoc
     * @api
     */
    MultiPolygon.prototype.intersectsExtent = function intersectsExtent (extent) {
      return intersectsLinearRingMultiArray(
        this.getOrientedFlatCoordinates(), 0, this.endss_, this.stride, extent);
    };

    /**
     * Set the coordinates of the multipolygon.
     * @param {!Array<Array<Array<import("../coordinate.js").Coordinate>>>} coordinates Coordinates.
     * @param {GeometryLayout=} opt_layout Layout.
     * @override
     * @api
     */
    MultiPolygon.prototype.setCoordinates = function setCoordinates (coordinates, opt_layout) {
      this.setLayout(opt_layout, coordinates, 3);
      if (!this.flatCoordinates) {
        this.flatCoordinates = [];
      }
      var endss = deflateMultiCoordinatesArray(
        this.flatCoordinates, 0, coordinates, this.stride, this.endss_);
      if (endss.length === 0) {
        this.flatCoordinates.length = 0;
      } else {
        var lastEnds = endss[endss.length - 1];
        this.flatCoordinates.length = lastEnds.length === 0 ?
          0 : lastEnds[lastEnds.length - 1];
      }
      this.changed();
    };

    return MultiPolygon;
  }(SimpleGeometry));

  /**
   * @module ol/LayerType
   */

  /**
   * A layer type used when creating layer renderers.
   * @enum {string}
   */
  var LayerType = {
    IMAGE: 'IMAGE',
    TILE: 'TILE',
    VECTOR_TILE: 'VECTOR_TILE',
    VECTOR: 'VECTOR'
  };

  /**
   * @module ol/layer/VectorRenderType
   */

  /**
   * @enum {string}
   * Render mode for vector layers:
   *  * `'image'`: Vector layers are rendered as images. Great performance, but
   *    point symbols and texts are always rotated with the view and pixels are
   *    scaled during zoom animations.
   *  * `'vector'`: Vector layers are rendered as vectors. Most accurate rendering
   *    even during animations, but slower performance.
   * @api
   */
  var VectorRenderType = {
    IMAGE: 'image',
    VECTOR: 'vector'
  };

  /**
   * @module ol/color
   */


  /**
   * A color represented as a short array [red, green, blue, alpha].
   * red, green, and blue should be integers in the range 0..255 inclusive.
   * alpha should be a float in the range 0..1 inclusive. If no alpha value is
   * given then `1` will be used.
   * @typedef {Array<number>} Color
   * @api
   */


  /**
   * This RegExp matches # followed by 3, 4, 6, or 8 hex digits.
   * @const
   * @type {RegExp}
   * @private
   */
  var HEX_COLOR_RE_ = /^#([a-f0-9]{3}|[a-f0-9]{4}(?:[a-f0-9]{2}){0,2})$/i;


  /**
   * Regular expression for matching potential named color style strings.
   * @const
   * @type {RegExp}
   * @private
   */
  var NAMED_COLOR_RE_ = /^([a-z]*)$/i;


  /**
   * Return the color as an rgba string.
   * @param {Color|string} color Color.
   * @return {string} Rgba string.
   * @api
   */
  function asString(color) {
    if (typeof color === 'string') {
      return color;
    } else {
      return toString(color);
    }
  }

  /**
   * Return named color as an rgba string.
   * @param {string} color Named color.
   * @return {string} Rgb string.
   */
  function fromNamed(color) {
    var el = document.createElement('div');
    el.style.color = color;
    if (el.style.color !== '') {
      document.body.appendChild(el);
      var rgb = getComputedStyle(el).color;
      document.body.removeChild(el);
      return rgb;
    } else {
      return '';
    }
  }


  /**
   * @param {string} s String.
   * @return {Color} Color.
   */
  var fromString = (
    function() {

      // We maintain a small cache of parsed strings.  To provide cheap LRU-like
      // semantics, whenever the cache grows too large we simply delete an
      // arbitrary 25% of the entries.

      /**
       * @const
       * @type {number}
       */
      var MAX_CACHE_SIZE = 1024;

      /**
       * @type {Object<string, Color>}
       */
      var cache = {};

      /**
       * @type {number}
       */
      var cacheSize = 0;

      return (
        /**
         * @param {string} s String.
         * @return {Color} Color.
         */
        function(s) {
          var color;
          if (cache.hasOwnProperty(s)) {
            color = cache[s];
          } else {
            if (cacheSize >= MAX_CACHE_SIZE) {
              var i = 0;
              for (var key in cache) {
                if ((i++ & 3) === 0) {
                  delete cache[key];
                  --cacheSize;
                }
              }
            }
            color = fromStringInternal_(s);
            cache[s] = color;
            ++cacheSize;
          }
          return color;
        }
      );

    })();

  /**
   * Return the color as an array. This function maintains a cache of calculated
   * arrays which means the result should not be modified.
   * @param {Color|string} color Color.
   * @return {Color} Color.
   * @api
   */
  function asArray(color) {
    if (Array.isArray(color)) {
      return color;
    } else {
      return fromString(color);
    }
  }

  /**
   * @param {string} s String.
   * @private
   * @return {Color} Color.
   */
  function fromStringInternal_(s) {
    var r, g, b, a, color;

    if (NAMED_COLOR_RE_.exec(s)) {
      s = fromNamed(s);
    }

    if (HEX_COLOR_RE_.exec(s)) { // hex
      var n = s.length - 1; // number of hex digits
      var d; // number of digits per channel
      if (n <= 4) {
        d = 1;
      } else {
        d = 2;
      }
      var hasAlpha = n === 4 || n === 8;
      r = parseInt(s.substr(1 + 0 * d, d), 16);
      g = parseInt(s.substr(1 + 1 * d, d), 16);
      b = parseInt(s.substr(1 + 2 * d, d), 16);
      if (hasAlpha) {
        a = parseInt(s.substr(1 + 3 * d, d), 16);
      } else {
        a = 255;
      }
      if (d == 1) {
        r = (r << 4) + r;
        g = (g << 4) + g;
        b = (b << 4) + b;
        if (hasAlpha) {
          a = (a << 4) + a;
        }
      }
      color = [r, g, b, a / 255];
    } else if (s.indexOf('rgba(') == 0) { // rgba()
      color = s.slice(5, -1).split(',').map(Number);
      normalize(color);
    } else if (s.indexOf('rgb(') == 0) { // rgb()
      color = s.slice(4, -1).split(',').map(Number);
      color.push(1);
      normalize(color);
    } else {
      assert(false, 14); // Invalid color
    }
    return color;
  }


  /**
   * TODO this function is only used in the test, we probably shouldn't export it
   * @param {Color} color Color.
   * @return {Color} Clamped color.
   */
  function normalize(color) {
    color[0] = clamp((color[0] + 0.5) | 0, 0, 255);
    color[1] = clamp((color[1] + 0.5) | 0, 0, 255);
    color[2] = clamp((color[2] + 0.5) | 0, 0, 255);
    color[3] = clamp(color[3], 0, 1);
    return color;
  }


  /**
   * @param {Color} color Color.
   * @return {string} String.
   */
  function toString(color) {
    var r = color[0];
    if (r != (r | 0)) {
      r = (r + 0.5) | 0;
    }
    var g = color[1];
    if (g != (g | 0)) {
      g = (g + 0.5) | 0;
    }
    var b = color[2];
    if (b != (b | 0)) {
      b = (b + 0.5) | 0;
    }
    var a = color[3] === undefined ? 1 : color[3];
    return 'rgba(' + r + ',' + g + ',' + b + ',' + a + ')';
  }

  /**
   * @module ol/colorlike
   */


  /**
   * A type accepted by CanvasRenderingContext2D.fillStyle
   * or CanvasRenderingContext2D.strokeStyle.
   * Represents a color, pattern, or gradient. The origin for patterns and
   * gradients as fill style is an increment of 512 css pixels from map coordinate
   * `[0, 0]`. For seamless repeat patterns, width and height of the pattern image
   * must be a factor of two (2, 4, 8, ..., 512).
   *
   * @typedef {string|CanvasPattern|CanvasGradient} ColorLike
   * @api
   */


  /**
   * @param {import("./color.js").Color|ColorLike} color Color.
   * @return {ColorLike} The color as an {@link ol/colorlike~ColorLike}.
   * @api
   */
  function asColorLike(color) {
    if (Array.isArray(color)) {
      return toString(color);
    } else {
      return color;
    }
  }

  /**
   * @module ol/ImageState
   */

  /**
   * @enum {number}
   */
  var ImageState = {
    IDLE: 0,
    LOADING: 1,
    LOADED: 2,
    ERROR: 3
  };

  /**
   * @module ol/structs/LRUCache
   */


  /**
   * @typedef {Object} Entry
   * @property {string} key_
   * @property {Object} newer
   * @property {Object} older
   * @property {*} value_
   */


  /**
   * @classdesc
   * Implements a Least-Recently-Used cache where the keys do not conflict with
   * Object's properties (e.g. 'hasOwnProperty' is not allowed as a key). Expiring
   * items from the cache is the responsibility of the user.
   *
   * @fires import("../events/Event.js").Event
   * @template T
   */
  var LRUCache = /*@__PURE__*/(function (EventTarget) {
    function LRUCache(opt_highWaterMark) {

      EventTarget.call(this);

      /**
       * @type {number}
       */
      this.highWaterMark = opt_highWaterMark !== undefined ? opt_highWaterMark : 2048;

      /**
       * @private
       * @type {number}
       */
      this.count_ = 0;

      /**
       * @private
       * @type {!Object<string, Entry>}
       */
      this.entries_ = {};

      /**
       * @private
       * @type {?Entry}
       */
      this.oldest_ = null;

      /**
       * @private
       * @type {?Entry}
       */
      this.newest_ = null;

    }

    if ( EventTarget ) LRUCache.__proto__ = EventTarget;
    LRUCache.prototype = Object.create( EventTarget && EventTarget.prototype );
    LRUCache.prototype.constructor = LRUCache;


    /**
     * @return {boolean} Can expire cache.
     */
    LRUCache.prototype.canExpireCache = function canExpireCache () {
      return this.getCount() > this.highWaterMark;
    };


    /**
     * FIXME empty description for jsdoc
     */
    LRUCache.prototype.clear = function clear () {
      this.count_ = 0;
      this.entries_ = {};
      this.oldest_ = null;
      this.newest_ = null;
      this.dispatchEvent(EventType.CLEAR);
    };


    /**
     * @param {string} key Key.
     * @return {boolean} Contains key.
     */
    LRUCache.prototype.containsKey = function containsKey (key) {
      return this.entries_.hasOwnProperty(key);
    };


    /**
     * @param {function(this: S, T, string, LRUCache): ?} f The function
     *     to call for every entry from the oldest to the newer. This function takes
     *     3 arguments (the entry value, the entry key and the LRUCache object).
     *     The return value is ignored.
     * @param {S=} opt_this The object to use as `this` in `f`.
     * @template S
     */
    LRUCache.prototype.forEach = function forEach (f, opt_this) {
      var entry = this.oldest_;
      while (entry) {
        f.call(opt_this, entry.value_, entry.key_, this);
        entry = entry.newer;
      }
    };


    /**
     * @param {string} key Key.
     * @return {T} Value.
     */
    LRUCache.prototype.get = function get (key) {
      var entry = this.entries_[key];
      assert(entry !== undefined,
        15); // Tried to get a value for a key that does not exist in the cache
      if (entry === this.newest_) {
        return entry.value_;
      } else if (entry === this.oldest_) {
        this.oldest_ = /** @type {Entry} */ (this.oldest_.newer);
        this.oldest_.older = null;
      } else {
        entry.newer.older = entry.older;
        entry.older.newer = entry.newer;
      }
      entry.newer = null;
      entry.older = this.newest_;
      this.newest_.newer = entry;
      this.newest_ = entry;
      return entry.value_;
    };


    /**
     * Remove an entry from the cache.
     * @param {string} key The entry key.
     * @return {T} The removed entry.
     */
    LRUCache.prototype.remove = function remove (key) {
      var entry = this.entries_[key];
      assert(entry !== undefined, 15); // Tried to get a value for a key that does not exist in the cache
      if (entry === this.newest_) {
        this.newest_ = /** @type {Entry} */ (entry.older);
        if (this.newest_) {
          this.newest_.newer = null;
        }
      } else if (entry === this.oldest_) {
        this.oldest_ = /** @type {Entry} */ (entry.newer);
        if (this.oldest_) {
          this.oldest_.older = null;
        }
      } else {
        entry.newer.older = entry.older;
        entry.older.newer = entry.newer;
      }
      delete this.entries_[key];
      --this.count_;
      return entry.value_;
    };


    /**
     * @return {number} Count.
     */
    LRUCache.prototype.getCount = function getCount () {
      return this.count_;
    };


    /**
     * @return {Array<string>} Keys.
     */
    LRUCache.prototype.getKeys = function getKeys () {
      var keys = new Array(this.count_);
      var i = 0;
      var entry;
      for (entry = this.newest_; entry; entry = entry.older) {
        keys[i++] = entry.key_;
      }
      return keys;
    };


    /**
     * @return {Array<T>} Values.
     */
    LRUCache.prototype.getValues = function getValues () {
      var values = new Array(this.count_);
      var i = 0;
      var entry;
      for (entry = this.newest_; entry; entry = entry.older) {
        values[i++] = entry.value_;
      }
      return values;
    };


    /**
     * @return {T} Last value.
     */
    LRUCache.prototype.peekLast = function peekLast () {
      return this.oldest_.value_;
    };


    /**
     * @return {string} Last key.
     */
    LRUCache.prototype.peekLastKey = function peekLastKey () {
      return this.oldest_.key_;
    };


    /**
     * Get the key of the newest item in the cache.  Throws if the cache is empty.
     * @return {string} The newest key.
     */
    LRUCache.prototype.peekFirstKey = function peekFirstKey () {
      return this.newest_.key_;
    };


    /**
     * @return {T} value Value.
     */
    LRUCache.prototype.pop = function pop () {
      var entry = this.oldest_;
      delete this.entries_[entry.key_];
      if (entry.newer) {
        entry.newer.older = null;
      }
      this.oldest_ = /** @type {Entry} */ (entry.newer);
      if (!this.oldest_) {
        this.newest_ = null;
      }
      --this.count_;
      return entry.value_;
    };


    /**
     * @param {string} key Key.
     * @param {T} value Value.
     */
    LRUCache.prototype.replace = function replace (key, value) {
      this.get(key); // update `newest_`
      this.entries_[key].value_ = value;
    };


    /**
     * @param {string} key Key.
     * @param {T} value Value.
     */
    LRUCache.prototype.set = function set (key, value) {
      assert(!(key in this.entries_),
        16); // Tried to set a value for a key that is used already
      var entry = /** @type {Entry} */ ({
        key_: key,
        newer: null,
        older: this.newest_,
        value_: value
      });
      if (!this.newest_) {
        this.oldest_ = entry;
      } else {
        this.newest_.newer = entry;
      }
      this.newest_ = entry;
      this.entries_[key] = entry;
      ++this.count_;
    };


    /**
     * Set a maximum number of entries for the cache.
     * @param {number} size Cache size.
     * @api
     */
    LRUCache.prototype.setSize = function setSize (size) {
      this.highWaterMark = size;
    };


    /**
     * Prune the cache.
     */
    LRUCache.prototype.prune = function prune () {
      while (this.canExpireCache()) {
        this.pop();
      }
    };

    return LRUCache;
  }(Target));

  /**
   * @module ol/render/canvas
   */


  /**
   * @typedef {Object} FillState
   * @property {import("../colorlike.js").ColorLike} fillStyle
   */


  /**
   * @typedef {Object} FillStrokeState
   * @property {import("../colorlike.js").ColorLike} [currentFillStyle]
   * @property {import("../colorlike.js").ColorLike} [currentStrokeStyle]
   * @property {string} [currentLineCap]
   * @property {Array<number>} currentLineDash
   * @property {number} [currentLineDashOffset]
   * @property {string} [currentLineJoin]
   * @property {number} [currentLineWidth]
   * @property {number} [currentMiterLimit]
   * @property {number} [lastStroke]
   * @property {import("../colorlike.js").ColorLike} [fillStyle]
   * @property {import("../colorlike.js").ColorLike} [strokeStyle]
   * @property {string} [lineCap]
   * @property {Array<number>} lineDash
   * @property {number} [lineDashOffset]
   * @property {string} [lineJoin]
   * @property {number} [lineWidth]
   * @property {number} [miterLimit]
   */


  /**
   * @typedef {Object} StrokeState
   * @property {string} lineCap
   * @property {Array<number>} lineDash
   * @property {number} lineDashOffset
   * @property {string} lineJoin
   * @property {number} lineWidth
   * @property {number} miterLimit
   * @property {import("../colorlike.js").ColorLike} strokeStyle
   */


  /**
   * @typedef {Object} TextState
   * @property {string} font
   * @property {string} [textAlign]
   * @property {string} textBaseline
   * @property {string} [placement]
   * @property {number} [maxAngle]
   * @property {boolean} [overflow]
   * @property {import("../style/Fill.js").default} [backgroundFill]
   * @property {import("../style/Stroke.js").default} [backgroundStroke]
   * @property {number} [scale]
   * @property {Array<number>} [padding]
   */


  /**
   * Container for decluttered replay instructions that need to be rendered or
   * omitted together, i.e. when styles render both an image and text, or for the
   * characters that form text along lines. The basic elements of this array are
   * `[minX, minY, maxX, maxY, count]`, where the first four entries are the
   * rendered extent of the group in pixel space. `count` is the number of styles
   * in the group, i.e. 2 when an image and a text are grouped, or 1 otherwise.
   * In addition to these four elements, declutter instruction arrays (i.e. the
   * arguments to {@link module:ol/render/canvas~drawImage} are appended to the array.
   * @typedef {Array<*>} DeclutterGroup
   */


  /**
   * @const
   * @type {string}
   */
  var defaultFont = '10px sans-serif';


  /**
   * @const
   * @type {import("../color.js").Color}
   */
  var defaultFillStyle = [0, 0, 0, 1];


  /**
   * @const
   * @type {string}
   */
  var defaultLineCap = 'round';


  /**
   * @const
   * @type {Array<number>}
   */
  var defaultLineDash = [];


  /**
   * @const
   * @type {number}
   */
  var defaultLineDashOffset = 0;


  /**
   * @const
   * @type {string}
   */
  var defaultLineJoin = 'round';


  /**
   * @const
   * @type {number}
   */
  var defaultMiterLimit = 10;


  /**
   * @const
   * @type {import("../color.js").Color}
   */
  var defaultStrokeStyle = [0, 0, 0, 1];


  /**
   * @const
   * @type {string}
   */
  var defaultTextAlign = 'center';


  /**
   * @const
   * @type {string}
   */
  var defaultTextBaseline = 'middle';


  /**
   * @const
   * @type {Array<number>}
   */
  var defaultPadding = [0, 0, 0, 0];


  /**
   * @const
   * @type {number}
   */
  var defaultLineWidth = 1;


  /**
   * The label cache for text rendering. To change the default cache size of 2048
   * entries, use {@link module:ol/structs/LRUCache#setSize}.
   * @type {LRUCache<HTMLCanvasElement>}
   * @api
   */
  var labelCache = new LRUCache();


  /**
   * @type {!Object<string, number>}
   */
  var checkedFonts = {};


  /**
   * @type {CanvasRenderingContext2D}
   */
  var measureContext = null;


  /**
   * @type {!Object<string, number>}
   */
  var textHeights = {};


  /**
   * Clears the label cache when a font becomes available.
   * @param {string} fontSpec CSS font spec.
   */
  var checkFont = (function() {
    var retries = 60;
    var checked = checkedFonts;
    var size = '32px ';
    var referenceFonts = ['monospace', 'serif'];
    var len = referenceFonts.length;
    var text = 'wmytzilWMYTZIL@#/&?$%10\uF013';
    var interval, referenceWidth;

    function isAvailable(font) {
      var context = getMeasureContext();
      // Check weight ranges according to
      // https://developer.mozilla.org/en-US/docs/Web/CSS/font-weight#Fallback_weights
      for (var weight = 100; weight <= 700; weight += 300) {
        var fontWeight = weight + ' ';
        var available = true;
        for (var i = 0; i < len; ++i) {
          var referenceFont = referenceFonts[i];
          context.font = fontWeight + size + referenceFont;
          referenceWidth = context.measureText(text).width;
          if (font != referenceFont) {
            context.font = fontWeight + size + font + ',' + referenceFont;
            var width = context.measureText(text).width;
            // If width and referenceWidth are the same, then the fallback was used
            // instead of the font we wanted, so the font is not available.
            available = available && width != referenceWidth;
          }
        }
        if (available) {
          // Consider font available when it is available in one weight range.
          //FIXME With this we miss rare corner cases, so we should consider
          //FIXME checking availability for each requested weight range.
          return true;
        }
      }
      return false;
    }

    function check() {
      var done = true;
      for (var font in checked) {
        if (checked[font] < retries) {
          if (isAvailable(font)) {
            checked[font] = retries;
            clear(textHeights);
            // Make sure that loaded fonts are picked up by Safari
            measureContext = null;
            labelCache.clear();
          } else {
            ++checked[font];
            done = false;
          }
        }
      }
      if (done) {
        clearInterval(interval);
        interval = undefined;
      }
    }

    return function(fontSpec) {
      var fontFamilies = getFontFamilies(fontSpec);
      if (!fontFamilies) {
        return;
      }
      for (var i = 0, ii = fontFamilies.length; i < ii; ++i) {
        var fontFamily = fontFamilies[i];
        if (!(fontFamily in checked)) {
          checked[fontFamily] = retries;
          if (!isAvailable(fontFamily)) {
            checked[fontFamily] = 0;
            if (interval === undefined) {
              interval = setInterval(check, 32);
            }
          }
        }
      }
    };
  })();


  /**
   * @return {CanvasRenderingContext2D} Measure context.
   */
  function getMeasureContext() {
    if (!measureContext) {
      measureContext = createCanvasContext2D(1, 1);
    }
    return measureContext;
  }


  /**
   * @param {string} font Font to use for measuring.
   * @return {import("../size.js").Size} Measurement.
   */
  var measureTextHeight = (function() {
    var span;
    var heights = textHeights;
    return function(font) {
      var height = heights[font];
      if (height == undefined) {
        if (!span) {
          span = document.createElement('span');
          span.textContent = 'M';
          span.style.margin = span.style.padding = '0 !important';
          span.style.position = 'absolute !important';
          span.style.left = '-99999px !important';
        }
        span.style.font = font;
        document.body.appendChild(span);
        height = heights[font] = span.offsetHeight;
        document.body.removeChild(span);
      }
      return height;
    };
  })();


  /**
   * @param {string} font Font.
   * @param {string} text Text.
   * @return {number} Width.
   */
  function measureTextWidth(font, text) {
    var measureContext = getMeasureContext();
    if (font != measureContext.font) {
      measureContext.font = font;
    }
    return measureContext.measureText(text).width;
  }


  /**
   * @param {CanvasRenderingContext2D} context Context.
   * @param {number} rotation Rotation.
   * @param {number} offsetX X offset.
   * @param {number} offsetY Y offset.
   */
  function rotateAtOffset(context, rotation, offsetX, offsetY) {
    if (rotation !== 0) {
      context.translate(offsetX, offsetY);
      context.rotate(rotation);
      context.translate(-offsetX, -offsetY);
    }
  }


  var resetTransform = create();


  /**
   * @param {CanvasRenderingContext2D} context Context.
   * @param {import("../transform.js").Transform|null} transform Transform.
   * @param {number} opacity Opacity.
   * @param {HTMLImageElement|HTMLCanvasElement|HTMLVideoElement} image Image.
   * @param {number} originX Origin X.
   * @param {number} originY Origin Y.
   * @param {number} w Width.
   * @param {number} h Height.
   * @param {number} x X.
   * @param {number} y Y.
   * @param {number} scale Scale.
   */
  function drawImage(context,
    transform, opacity, image, originX, originY, w, h, x, y, scale) {
    var alpha;
    if (opacity != 1) {
      alpha = context.globalAlpha;
      context.globalAlpha = alpha * opacity;
    }
    if (transform) {
      context.setTransform.apply(context, transform);
    }

    context.drawImage(image, originX, originY, w, h, x, y, w * scale, h * scale);

    if (alpha) {
      context.globalAlpha = alpha;
    }
    if (transform) {
      context.setTransform.apply(context, resetTransform);
    }
  }

  /**
   * @module ol/style/Image
   */


  /**
   * @typedef {Object} Options
   * @property {number} opacity
   * @property {boolean} rotateWithView
   * @property {number} rotation
   * @property {number} scale
   */


  /**
   * @classdesc
   * A base class used for creating subclasses and not instantiated in
   * apps. Base class for {@link module:ol/style/Icon~Icon}, {@link module:ol/style/Circle~CircleStyle} and
   * {@link module:ol/style/RegularShape~RegularShape}.
   * @abstract
   * @api
   */
  var ImageStyle = function ImageStyle(options) {

    /**
     * @private
     * @type {number}
     */
    this.opacity_ = options.opacity;

    /**
     * @private
     * @type {boolean}
     */
    this.rotateWithView_ = options.rotateWithView;

    /**
     * @private
     * @type {number}
     */
    this.rotation_ = options.rotation;

    /**
     * @private
     * @type {number}
     */
    this.scale_ = options.scale;

  };

  /**
   * Clones the style.
   * @return {ImageStyle} The cloned style.
   * @api
   */
  ImageStyle.prototype.clone = function clone () {
    return new ImageStyle({
      opacity: this.getOpacity(),
      scale: this.getScale(),
      rotation: this.getRotation(),
      rotateWithView: this.getRotateWithView()
    });
  };

  /**
   * Get the symbolizer opacity.
   * @return {number} Opacity.
   * @api
   */
  ImageStyle.prototype.getOpacity = function getOpacity () {
    return this.opacity_;
  };

  /**
   * Determine whether the symbolizer rotates with the map.
   * @return {boolean} Rotate with map.
   * @api
   */
  ImageStyle.prototype.getRotateWithView = function getRotateWithView () {
    return this.rotateWithView_;
  };

  /**
   * Get the symoblizer rotation.
   * @return {number} Rotation.
   * @api
   */
  ImageStyle.prototype.getRotation = function getRotation () {
    return this.rotation_;
  };

  /**
   * Get the symbolizer scale.
   * @return {number} Scale.
   * @api
   */
  ImageStyle.prototype.getScale = function getScale () {
    return this.scale_;
  };

  /**
   * This method is deprecated and always returns false.
   * @return {boolean} false.
   * @deprecated
   * @api
   */
  ImageStyle.prototype.getSnapToPixel = function getSnapToPixel () {
    return false;
  };

  /**
   * Get the anchor point in pixels. The anchor determines the center point for the
   * symbolizer.
   * @abstract
   * @return {Array<number>} Anchor.
   */
  ImageStyle.prototype.getAnchor = function getAnchor () {
    return abstract();
  };

  /**
   * Get the image element for the symbolizer.
   * @abstract
   * @param {number} pixelRatio Pixel ratio.
   * @return {HTMLCanvasElement|HTMLVideoElement|HTMLImageElement} Image element.
   */
  ImageStyle.prototype.getImage = function getImage (pixelRatio) {
    return abstract();
  };

  /**
   * @abstract
   * @param {number} pixelRatio Pixel ratio.
   * @return {HTMLCanvasElement|HTMLVideoElement|HTMLImageElement} Image element.
   */
  ImageStyle.prototype.getHitDetectionImage = function getHitDetectionImage (pixelRatio) {
    return abstract();
  };

  /**
   * @abstract
   * @return {import("../ImageState.js").default} Image state.
   */
  ImageStyle.prototype.getImageState = function getImageState () {
    return abstract();
  };

  /**
   * @abstract
   * @return {import("../size.js").Size} Image size.
   */
  ImageStyle.prototype.getImageSize = function getImageSize () {
    return abstract();
  };

  /**
   * @abstract
   * @return {import("../size.js").Size} Size of the hit-detection image.
   */
  ImageStyle.prototype.getHitDetectionImageSize = function getHitDetectionImageSize () {
    return abstract();
  };

  /**
   * Get the origin of the symbolizer.
   * @abstract
   * @return {Array<number>} Origin.
   */
  ImageStyle.prototype.getOrigin = function getOrigin () {
    return abstract();
  };

  /**
   * Get the size of the symbolizer (in pixels).
   * @abstract
   * @return {import("../size.js").Size} Size.
   */
  ImageStyle.prototype.getSize = function getSize () {
    return abstract();
  };

  /**
   * Set the opacity.
   *
   * @param {number} opacity Opacity.
   * @api
   */
  ImageStyle.prototype.setOpacity = function setOpacity (opacity) {
    this.opacity_ = opacity;
  };

  /**
   * Set whether to rotate the style with the view.
   *
   * @param {boolean} rotateWithView Rotate with map.
   * @api
   */
  ImageStyle.prototype.setRotateWithView = function setRotateWithView (rotateWithView) {
    this.rotateWithView_ = rotateWithView;
  };

  /**
   * Set the rotation.
   *
   * @param {number} rotation Rotation.
   * @api
   */
  ImageStyle.prototype.setRotation = function setRotation (rotation) {
    this.rotation_ = rotation;
  };
  /**
   * Set the scale.
   *
   * @param {number} scale Scale.
   * @api
   */
  ImageStyle.prototype.setScale = function setScale (scale) {
    this.scale_ = scale;
  };

  /**
   * This method is deprecated and does nothing.
   * @param {boolean} snapToPixel Snap to pixel?
   * @deprecated
   * @api
   */
  ImageStyle.prototype.setSnapToPixel = function setSnapToPixel (snapToPixel) {};

  /**
   * @abstract
   * @param {function(this: T, import("../events/Event.js").default)} listener Listener function.
   * @param {T} thisArg Value to use as `this` when executing `listener`.
   * @return {import("../events.js").EventsKey|undefined} Listener key.
   * @template T
   */
  ImageStyle.prototype.listenImageChange = function listenImageChange (listener, thisArg) {
    return abstract();
  };

  /**
   * Load not yet loaded URI.
   * @abstract
   */
  ImageStyle.prototype.load = function load () {
    abstract();
  };

  /**
   * @abstract
   * @param {function(this: T, import("../events/Event.js").default)} listener Listener function.
   * @param {T} thisArg Value to use as `this` when executing `listener`.
   * @template T
   */
  ImageStyle.prototype.unlistenImageChange = function unlistenImageChange (listener, thisArg) {
    abstract();
  };

  /**
   * @module ol/style/RegularShape
   */


  /**
   * Specify radius for regular polygons, or radius1 and radius2 for stars.
   * @typedef {Object} Options
   * @property {import("./Fill.js").default} [fill] Fill style.
   * @property {number} points Number of points for stars and regular polygons. In case of a polygon, the number of points
   * is the number of sides.
   * @property {number} [radius] Radius of a regular polygon.
   * @property {number} [radius1] Outer radius of a star.
   * @property {number} [radius2] Inner radius of a star.
   * @property {number} [angle=0] Shape's angle in radians. A value of 0 will have one of the shape's point facing up.
   * @property {import("./Stroke.js").default} [stroke] Stroke style.
   * @property {number} [rotation=0] Rotation in radians (positive rotation clockwise).
   * @property {boolean} [rotateWithView=false] Whether to rotate the shape with the view.
   * @property {import("./AtlasManager.js").default} [atlasManager] The atlas manager to use for this symbol. When
   * using WebGL it is recommended to use an atlas manager to avoid texture switching. If an atlas manager is given, the
   * symbol is added to an atlas. By default no atlas manager is used.
   */


  /**
   * @typedef {Object} RenderOptions
   * @property {import("../colorlike.js").ColorLike} [strokeStyle]
   * @property {number} strokeWidth
   * @property {number} size
   * @property {string} lineCap
   * @property {Array<number>} lineDash
   * @property {number} lineDashOffset
   * @property {string} lineJoin
   * @property {number} miterLimit
   */


  /**
   * @classdesc
   * Set regular shape style for vector features. The resulting shape will be
   * a regular polygon when `radius` is provided, or a star when `radius1` and
   * `radius2` are provided.
   * @api
   */
  var RegularShape = /*@__PURE__*/(function (ImageStyle$$1) {
    function RegularShape(options) {
      /**
       * @type {boolean}
       */
      var rotateWithView = options.rotateWithView !== undefined ?
        options.rotateWithView : false;

      ImageStyle$$1.call(this, {
        opacity: 1,
        rotateWithView: rotateWithView,
        rotation: options.rotation !== undefined ? options.rotation : 0,
        scale: 1
      });

      /**
       * @private
       * @type {Array<string|number>}
       */
      this.checksums_ = null;

      /**
       * @private
       * @type {HTMLCanvasElement}
       */
      this.canvas_ = null;

      /**
       * @private
       * @type {HTMLCanvasElement}
       */
      this.hitDetectionCanvas_ = null;

      /**
       * @private
       * @type {import("./Fill.js").default}
       */
      this.fill_ = options.fill !== undefined ? options.fill : null;

      /**
       * @private
       * @type {Array<number>}
       */
      this.origin_ = [0, 0];

      /**
       * @private
       * @type {number}
       */
      this.points_ = options.points;

      /**
       * @protected
       * @type {number}
       */
      this.radius_ = /** @type {number} */ (options.radius !== undefined ?
        options.radius : options.radius1);

      /**
       * @private
       * @type {number|undefined}
       */
      this.radius2_ = options.radius2;

      /**
       * @private
       * @type {number}
       */
      this.angle_ = options.angle !== undefined ? options.angle : 0;

      /**
       * @private
       * @type {import("./Stroke.js").default}
       */
      this.stroke_ = options.stroke !== undefined ? options.stroke : null;

      /**
       * @private
       * @type {Array<number>}
       */
      this.anchor_ = null;

      /**
       * @private
       * @type {import("../size.js").Size}
       */
      this.size_ = null;

      /**
       * @private
       * @type {import("../size.js").Size}
       */
      this.imageSize_ = null;

      /**
       * @private
       * @type {import("../size.js").Size}
       */
      this.hitDetectionImageSize_ = null;

      /**
       * @protected
       * @type {import("./AtlasManager.js").default|undefined}
       */
      this.atlasManager_ = options.atlasManager;

      this.render_(this.atlasManager_);

    }

    if ( ImageStyle$$1 ) RegularShape.__proto__ = ImageStyle$$1;
    RegularShape.prototype = Object.create( ImageStyle$$1 && ImageStyle$$1.prototype );
    RegularShape.prototype.constructor = RegularShape;

    /**
     * Clones the style. If an atlasmanager was provided to the original style it will be used in the cloned style, too.
     * @return {RegularShape} The cloned style.
     * @api
     */
    RegularShape.prototype.clone = function clone () {
      var style = new RegularShape({
        fill: this.getFill() ? this.getFill().clone() : undefined,
        points: this.getPoints(),
        radius: this.getRadius(),
        radius2: this.getRadius2(),
        angle: this.getAngle(),
        stroke: this.getStroke() ? this.getStroke().clone() : undefined,
        rotation: this.getRotation(),
        rotateWithView: this.getRotateWithView(),
        atlasManager: this.atlasManager_
      });
      style.setOpacity(this.getOpacity());
      style.setScale(this.getScale());
      return style;
    };

    /**
     * @inheritDoc
     * @api
     */
    RegularShape.prototype.getAnchor = function getAnchor () {
      return this.anchor_;
    };

    /**
     * Get the angle used in generating the shape.
     * @return {number} Shape's rotation in radians.
     * @api
     */
    RegularShape.prototype.getAngle = function getAngle () {
      return this.angle_;
    };

    /**
     * Get the fill style for the shape.
     * @return {import("./Fill.js").default} Fill style.
     * @api
     */
    RegularShape.prototype.getFill = function getFill () {
      return this.fill_;
    };

    /**
     * @inheritDoc
     */
    RegularShape.prototype.getHitDetectionImage = function getHitDetectionImage (pixelRatio) {
      return this.hitDetectionCanvas_;
    };

    /**
     * @inheritDoc
     * @api
     */
    RegularShape.prototype.getImage = function getImage (pixelRatio) {
      return this.canvas_;
    };

    /**
     * @inheritDoc
     */
    RegularShape.prototype.getImageSize = function getImageSize () {
      return this.imageSize_;
    };

    /**
     * @inheritDoc
     */
    RegularShape.prototype.getHitDetectionImageSize = function getHitDetectionImageSize () {
      return this.hitDetectionImageSize_;
    };

    /**
     * @inheritDoc
     */
    RegularShape.prototype.getImageState = function getImageState () {
      return ImageState.LOADED;
    };

    /**
     * @inheritDoc
     * @api
     */
    RegularShape.prototype.getOrigin = function getOrigin () {
      return this.origin_;
    };

    /**
     * Get the number of points for generating the shape.
     * @return {number} Number of points for stars and regular polygons.
     * @api
     */
    RegularShape.prototype.getPoints = function getPoints () {
      return this.points_;
    };

    /**
     * Get the (primary) radius for the shape.
     * @return {number} Radius.
     * @api
     */
    RegularShape.prototype.getRadius = function getRadius () {
      return this.radius_;
    };

    /**
     * Get the secondary radius for the shape.
     * @return {number|undefined} Radius2.
     * @api
     */
    RegularShape.prototype.getRadius2 = function getRadius2 () {
      return this.radius2_;
    };

    /**
     * @inheritDoc
     * @api
     */
    RegularShape.prototype.getSize = function getSize () {
      return this.size_;
    };

    /**
     * Get the stroke style for the shape.
     * @return {import("./Stroke.js").default} Stroke style.
     * @api
     */
    RegularShape.prototype.getStroke = function getStroke () {
      return this.stroke_;
    };

    /**
     * @inheritDoc
     */
    RegularShape.prototype.listenImageChange = function listenImageChange (listener, thisArg) {
      return undefined;
    };

    /**
     * @inheritDoc
     */
    RegularShape.prototype.load = function load () {};

    /**
     * @inheritDoc
     */
    RegularShape.prototype.unlistenImageChange = function unlistenImageChange (listener, thisArg) {};

    /**
     * @protected
     * @param {import("./AtlasManager.js").default|undefined} atlasManager An atlas manager.
     */
    RegularShape.prototype.render_ = function render_ (atlasManager) {
      var imageSize;
      var lineCap = '';
      var lineJoin = '';
      var miterLimit = 0;
      var lineDash = null;
      var lineDashOffset = 0;
      var strokeStyle;
      var strokeWidth = 0;

      if (this.stroke_) {
        strokeStyle = this.stroke_.getColor();
        if (strokeStyle === null) {
          strokeStyle = defaultStrokeStyle;
        }
        strokeStyle = asColorLike(strokeStyle);
        strokeWidth = this.stroke_.getWidth();
        if (strokeWidth === undefined) {
          strokeWidth = defaultLineWidth;
        }
        lineDash = this.stroke_.getLineDash();
        lineDashOffset = this.stroke_.getLineDashOffset();
        if (!CANVAS_LINE_DASH) {
          lineDash = null;
          lineDashOffset = 0;
        }
        lineJoin = this.stroke_.getLineJoin();
        if (lineJoin === undefined) {
          lineJoin = defaultLineJoin;
        }
        lineCap = this.stroke_.getLineCap();
        if (lineCap === undefined) {
          lineCap = defaultLineCap;
        }
        miterLimit = this.stroke_.getMiterLimit();
        if (miterLimit === undefined) {
          miterLimit = defaultMiterLimit;
        }
      }

      var size = 2 * (this.radius_ + strokeWidth) + 1;

      /** @type {RenderOptions} */
      var renderOptions = {
        strokeStyle: strokeStyle,
        strokeWidth: strokeWidth,
        size: size,
        lineCap: lineCap,
        lineDash: lineDash,
        lineDashOffset: lineDashOffset,
        lineJoin: lineJoin,
        miterLimit: miterLimit
      };

      if (atlasManager === undefined) {
        // no atlas manager is used, create a new canvas
        var context = createCanvasContext2D(size, size);
        this.canvas_ = context.canvas;

        // canvas.width and height are rounded to the closest integer
        size = this.canvas_.width;
        imageSize = size;

        this.draw_(renderOptions, context, 0, 0);

        this.createHitDetectionCanvas_(renderOptions);
      } else {
        // an atlas manager is used, add the symbol to an atlas
        size = Math.round(size);

        var hasCustomHitDetectionImage = !this.fill_;
        var renderHitDetectionCallback;
        if (hasCustomHitDetectionImage) {
          // render the hit-detection image into a separate atlas image
          renderHitDetectionCallback =
              this.drawHitDetectionCanvas_.bind(this, renderOptions);
        }

        var id = this.getChecksum();
        var info = atlasManager.add(
          id, size, size, this.draw_.bind(this, renderOptions),
          renderHitDetectionCallback);

        this.canvas_ = info.image;
        this.origin_ = [info.offsetX, info.offsetY];
        imageSize = info.image.width;

        if (hasCustomHitDetectionImage) {
          this.hitDetectionCanvas_ = info.hitImage;
          this.hitDetectionImageSize_ =
              [info.hitImage.width, info.hitImage.height];
        } else {
          this.hitDetectionCanvas_ = this.canvas_;
          this.hitDetectionImageSize_ = [imageSize, imageSize];
        }
      }

      this.anchor_ = [size / 2, size / 2];
      this.size_ = [size, size];
      this.imageSize_ = [imageSize, imageSize];
    };

    /**
     * @private
     * @param {RenderOptions} renderOptions Render options.
     * @param {CanvasRenderingContext2D} context The rendering context.
     * @param {number} x The origin for the symbol (x).
     * @param {number} y The origin for the symbol (y).
     */
    RegularShape.prototype.draw_ = function draw_ (renderOptions, context, x, y) {
      var i, angle0, radiusC;
      // reset transform
      context.setTransform(1, 0, 0, 1, 0, 0);

      // then move to (x, y)
      context.translate(x, y);

      context.beginPath();

      var points = this.points_;
      if (points === Infinity) {
        context.arc(
          renderOptions.size / 2, renderOptions.size / 2,
          this.radius_, 0, 2 * Math.PI, true);
      } else {
        var radius2 = (this.radius2_ !== undefined) ? this.radius2_
          : this.radius_;
        if (radius2 !== this.radius_) {
          points = 2 * points;
        }
        for (i = 0; i <= points; i++) {
          angle0 = i * 2 * Math.PI / points - Math.PI / 2 + this.angle_;
          radiusC = i % 2 === 0 ? this.radius_ : radius2;
          context.lineTo(renderOptions.size / 2 + radiusC * Math.cos(angle0),
            renderOptions.size / 2 + radiusC * Math.sin(angle0));
        }
      }


      if (this.fill_) {
        var color = this.fill_.getColor();
        if (color === null) {
          color = defaultFillStyle;
        }
        context.fillStyle = asColorLike(color);
        context.fill();
      }
      if (this.stroke_) {
        context.strokeStyle = renderOptions.strokeStyle;
        context.lineWidth = renderOptions.strokeWidth;
        if (renderOptions.lineDash) {
          context.setLineDash(renderOptions.lineDash);
          context.lineDashOffset = renderOptions.lineDashOffset;
        }
        context.lineCap = /** @type {CanvasLineCap} */ (renderOptions.lineCap);
        context.lineJoin = /** @type {CanvasLineJoin} */ (renderOptions.lineJoin);
        context.miterLimit = renderOptions.miterLimit;
        context.stroke();
      }
      context.closePath();
    };

    /**
     * @private
     * @param {RenderOptions} renderOptions Render options.
     */
    RegularShape.prototype.createHitDetectionCanvas_ = function createHitDetectionCanvas_ (renderOptions) {
      this.hitDetectionImageSize_ = [renderOptions.size, renderOptions.size];
      if (this.fill_) {
        this.hitDetectionCanvas_ = this.canvas_;
        return;
      }

      // if no fill style is set, create an extra hit-detection image with a
      // default fill style
      var context = createCanvasContext2D(renderOptions.size, renderOptions.size);
      this.hitDetectionCanvas_ = context.canvas;

      this.drawHitDetectionCanvas_(renderOptions, context, 0, 0);
    };

    /**
     * @private
     * @param {RenderOptions} renderOptions Render options.
     * @param {CanvasRenderingContext2D} context The context.
     * @param {number} x The origin for the symbol (x).
     * @param {number} y The origin for the symbol (y).
     */
    RegularShape.prototype.drawHitDetectionCanvas_ = function drawHitDetectionCanvas_ (renderOptions, context, x, y) {
      // reset transform
      context.setTransform(1, 0, 0, 1, 0, 0);

      // then move to (x, y)
      context.translate(x, y);

      context.beginPath();

      var points = this.points_;
      if (points === Infinity) {
        context.arc(
          renderOptions.size / 2, renderOptions.size / 2,
          this.radius_, 0, 2 * Math.PI, true);
      } else {
        var radius2 = (this.radius2_ !== undefined) ? this.radius2_
          : this.radius_;
        if (radius2 !== this.radius_) {
          points = 2 * points;
        }
        var i, radiusC, angle0;
        for (i = 0; i <= points; i++) {
          angle0 = i * 2 * Math.PI / points - Math.PI / 2 + this.angle_;
          radiusC = i % 2 === 0 ? this.radius_ : radius2;
          context.lineTo(renderOptions.size / 2 + radiusC * Math.cos(angle0),
            renderOptions.size / 2 + radiusC * Math.sin(angle0));
        }
      }

      context.fillStyle = asString(defaultFillStyle);
      context.fill();
      if (this.stroke_) {
        context.strokeStyle = renderOptions.strokeStyle;
        context.lineWidth = renderOptions.strokeWidth;
        if (renderOptions.lineDash) {
          context.setLineDash(renderOptions.lineDash);
          context.lineDashOffset = renderOptions.lineDashOffset;
        }
        context.stroke();
      }
      context.closePath();
    };

    /**
     * @return {string} The checksum.
     */
    RegularShape.prototype.getChecksum = function getChecksum () {
      var strokeChecksum = this.stroke_ ?
        this.stroke_.getChecksum() : '-';
      var fillChecksum = this.fill_ ?
        this.fill_.getChecksum() : '-';

      var recalculate = !this.checksums_ ||
          (strokeChecksum != this.checksums_[1] ||
          fillChecksum != this.checksums_[2] ||
          this.radius_ != this.checksums_[3] ||
          this.radius2_ != this.checksums_[4] ||
          this.angle_ != this.checksums_[5] ||
          this.points_ != this.checksums_[6]);

      if (recalculate) {
        var checksum = 'r' + strokeChecksum + fillChecksum +
            (this.radius_ !== undefined ? this.radius_.toString() : '-') +
            (this.radius2_ !== undefined ? this.radius2_.toString() : '-') +
            (this.angle_ !== undefined ? this.angle_.toString() : '-') +
            (this.points_ !== undefined ? this.points_.toString() : '-');
        this.checksums_ = [checksum, strokeChecksum, fillChecksum,
          this.radius_, this.radius2_, this.angle_, this.points_];
      }

      return /** @type {string} */ (this.checksums_[0]);
    };

    return RegularShape;
  }(ImageStyle));

  /**
   * @module ol/style/Circle
   */


  /**
   * @typedef {Object} Options
   * @property {import("./Fill.js").default} [fill] Fill style.
   * @property {number} radius Circle radius.
   * @property {import("./Stroke.js").default} [stroke] Stroke style.
   * @property {import("./AtlasManager.js").default} [atlasManager] The atlas manager to use for this circle.
   * When using WebGL it is recommended to use an atlas manager to avoid texture switching. If an atlas manager is given,
   * the circle is added to an atlas. By default no atlas manager is used.
   */


  /**
   * @classdesc
   * Set circle style for vector features.
   * @api
   */
  var CircleStyle = /*@__PURE__*/(function (RegularShape$$1) {
    function CircleStyle(opt_options) {

      var options = opt_options || /** @type {Options} */ ({});

      RegularShape$$1.call(this, {
        points: Infinity,
        fill: options.fill,
        radius: options.radius,
        stroke: options.stroke,
        atlasManager: options.atlasManager
      });

    }

    if ( RegularShape$$1 ) CircleStyle.__proto__ = RegularShape$$1;
    CircleStyle.prototype = Object.create( RegularShape$$1 && RegularShape$$1.prototype );
    CircleStyle.prototype.constructor = CircleStyle;

    /**
    * Clones the style.  If an atlasmanager was provided to the original style it will be used in the cloned style, too.
    * @return {CircleStyle} The cloned style.
    * @override
    * @api
    */
    CircleStyle.prototype.clone = function clone () {
      var style = new CircleStyle({
        fill: this.getFill() ? this.getFill().clone() : undefined,
        stroke: this.getStroke() ? this.getStroke().clone() : undefined,
        radius: this.getRadius(),
        atlasManager: this.atlasManager_
      });
      style.setOpacity(this.getOpacity());
      style.setScale(this.getScale());
      return style;
    };

    /**
    * Set the circle radius.
    *
    * @param {number} radius Circle radius.
    * @api
    */
    CircleStyle.prototype.setRadius = function setRadius (radius) {
      this.radius_ = radius;
      this.render_(this.atlasManager_);
    };

    return CircleStyle;
  }(RegularShape));

  /**
   * @module ol/style/Fill
   */


  /**
   * @typedef {Object} Options
   * @property {import("../color.js").Color|import("../colorlike.js").ColorLike} [color] A color, gradient or pattern.
   * See {@link module:ol/color~Color} and {@link module:ol/colorlike~ColorLike} for possible formats.
   * Default null; if null, the Canvas/renderer default black will be used.
   */


  /**
   * @classdesc
   * Set fill style for vector features.
   * @api
   */
  var Fill = function Fill(opt_options) {

    var options = opt_options || {};

    /**
     * @private
     * @type {import("../color.js").Color|import("../colorlike.js").ColorLike}
     */
    this.color_ = options.color !== undefined ? options.color : null;

    /**
     * @private
     * @type {string|undefined}
     */
    this.checksum_ = undefined;
  };

  /**
   * Clones the style. The color is not cloned if it is an {@link module:ol/colorlike~ColorLike}.
   * @return {Fill} The cloned style.
   * @api
   */
  Fill.prototype.clone = function clone () {
    var color = this.getColor();
    return new Fill({
      color: Array.isArray(color) ? color.slice() : color || undefined
    });
  };

  /**
   * Get the fill color.
   * @return {import("../color.js").Color|import("../colorlike.js").ColorLike} Color.
   * @api
   */
  Fill.prototype.getColor = function getColor () {
    return this.color_;
  };

  /**
   * Set the color.
   *
   * @param {import("../color.js").Color|import("../colorlike.js").ColorLike} color Color.
   * @api
   */
  Fill.prototype.setColor = function setColor (color) {
    this.color_ = color;
    this.checksum_ = undefined;
  };

  /**
   * @return {string} The checksum.
   */
  Fill.prototype.getChecksum = function getChecksum () {
    if (this.checksum_ === undefined) {
      var color = this.color_;
      if (color) {
        if (Array.isArray(color) || typeof color == 'string') {
          this.checksum_ = 'f' + asString(/** @type {import("../color.js").Color|string} */ (color));
        } else {
          this.checksum_ = getUid(this.color_);
        }
      } else {
        this.checksum_ = 'f-';
      }
    }

    return this.checksum_;
  };

  /**
   * @module ol/style/Stroke
   */


  /**
   * @typedef {Object} Options
   * @property {import("../color.js").Color|import("../colorlike.js").ColorLike} [color] A color, gradient or pattern.
   * See {@link module:ol/color~Color} and {@link module:ol/colorlike~ColorLike} for possible formats.
   * Default null; if null, the Canvas/renderer default black will be used.
   * @property {string} [lineCap='round'] Line cap style: `butt`, `round`, or `square`.
   * @property {string} [lineJoin='round'] Line join style: `bevel`, `round`, or `miter`.
   * @property {Array<number>} [lineDash] Line dash pattern. Default is `undefined` (no dash).
   * Please note that Internet Explorer 10 and lower do not support the `setLineDash` method on
   * the `CanvasRenderingContext2D` and therefore this option will have no visual effect in these browsers.
   * @property {number} [lineDashOffset=0] Line dash offset.
   * @property {number} [miterLimit=10] Miter limit.
   * @property {number} [width] Width.
   */


  /**
   * @classdesc
   * Set stroke style for vector features.
   * Note that the defaults given are the Canvas defaults, which will be used if
   * option is not defined. The `get` functions return whatever was entered in
   * the options; they will not return the default.
   * @api
   */
  var Stroke = function Stroke(opt_options) {

    var options = opt_options || {};

    /**
     * @private
     * @type {import("../color.js").Color|import("../colorlike.js").ColorLike}
     */
    this.color_ = options.color !== undefined ? options.color : null;

    /**
     * @private
     * @type {string|undefined}
     */
    this.lineCap_ = options.lineCap;

    /**
     * @private
     * @type {Array<number>}
     */
    this.lineDash_ = options.lineDash !== undefined ? options.lineDash : null;

    /**
     * @private
     * @type {number|undefined}
     */
    this.lineDashOffset_ = options.lineDashOffset;

    /**
     * @private
     * @type {string|undefined}
     */
    this.lineJoin_ = options.lineJoin;

    /**
     * @private
     * @type {number|undefined}
     */
    this.miterLimit_ = options.miterLimit;

    /**
     * @private
     * @type {number|undefined}
     */
    this.width_ = options.width;

    /**
     * @private
     * @type {string|undefined}
     */
    this.checksum_ = undefined;
  };

  /**
   * Clones the style.
   * @return {Stroke} The cloned style.
   * @api
   */
  Stroke.prototype.clone = function clone () {
    var color = this.getColor();
    return new Stroke({
      color: Array.isArray(color) ? color.slice() : color || undefined,
      lineCap: this.getLineCap(),
      lineDash: this.getLineDash() ? this.getLineDash().slice() : undefined,
      lineDashOffset: this.getLineDashOffset(),
      lineJoin: this.getLineJoin(),
      miterLimit: this.getMiterLimit(),
      width: this.getWidth()
    });
  };

  /**
   * Get the stroke color.
   * @return {import("../color.js").Color|import("../colorlike.js").ColorLike} Color.
   * @api
   */
  Stroke.prototype.getColor = function getColor () {
    return this.color_;
  };

  /**
   * Get the line cap type for the stroke.
   * @return {string|undefined} Line cap.
   * @api
   */
  Stroke.prototype.getLineCap = function getLineCap () {
    return this.lineCap_;
  };

  /**
   * Get the line dash style for the stroke.
   * @return {Array<number>} Line dash.
   * @api
   */
  Stroke.prototype.getLineDash = function getLineDash () {
    return this.lineDash_;
  };

  /**
   * Get the line dash offset for the stroke.
   * @return {number|undefined} Line dash offset.
   * @api
   */
  Stroke.prototype.getLineDashOffset = function getLineDashOffset () {
    return this.lineDashOffset_;
  };

  /**
   * Get the line join type for the stroke.
   * @return {string|undefined} Line join.
   * @api
   */
  Stroke.prototype.getLineJoin = function getLineJoin () {
    return this.lineJoin_;
  };

  /**
   * Get the miter limit for the stroke.
   * @return {number|undefined} Miter limit.
   * @api
   */
  Stroke.prototype.getMiterLimit = function getMiterLimit () {
    return this.miterLimit_;
  };

  /**
   * Get the stroke width.
   * @return {number|undefined} Width.
   * @api
   */
  Stroke.prototype.getWidth = function getWidth () {
    return this.width_;
  };

  /**
   * Set the color.
   *
   * @param {import("../color.js").Color|import("../colorlike.js").ColorLike} color Color.
   * @api
   */
  Stroke.prototype.setColor = function setColor (color) {
    this.color_ = color;
    this.checksum_ = undefined;
  };

  /**
   * Set the line cap.
   *
   * @param {string|undefined} lineCap Line cap.
   * @api
   */
  Stroke.prototype.setLineCap = function setLineCap (lineCap) {
    this.lineCap_ = lineCap;
    this.checksum_ = undefined;
  };

  /**
   * Set the line dash.
   *
   * Please note that Internet Explorer 10 and lower [do not support][mdn] the
   * `setLineDash` method on the `CanvasRenderingContext2D` and therefore this
   * property will have no visual effect in these browsers.
   *
   * [mdn]: https://developer.mozilla.org/en-US/docs/Web/API/CanvasRenderingContext2D/setLineDash#Browser_compatibility
   *
   * @param {Array<number>} lineDash Line dash.
   * @api
   */
  Stroke.prototype.setLineDash = function setLineDash (lineDash) {
    this.lineDash_ = lineDash;
    this.checksum_ = undefined;
  };

  /**
   * Set the line dash offset.
   *
   * @param {number|undefined} lineDashOffset Line dash offset.
   * @api
   */
  Stroke.prototype.setLineDashOffset = function setLineDashOffset (lineDashOffset) {
    this.lineDashOffset_ = lineDashOffset;
    this.checksum_ = undefined;
  };

  /**
   * Set the line join.
   *
   * @param {string|undefined} lineJoin Line join.
   * @api
   */
  Stroke.prototype.setLineJoin = function setLineJoin (lineJoin) {
    this.lineJoin_ = lineJoin;
    this.checksum_ = undefined;
  };

  /**
   * Set the miter limit.
   *
   * @param {number|undefined} miterLimit Miter limit.
   * @api
   */
  Stroke.prototype.setMiterLimit = function setMiterLimit (miterLimit) {
    this.miterLimit_ = miterLimit;
    this.checksum_ = undefined;
  };

  /**
   * Set the width.
   *
   * @param {number|undefined} width Width.
   * @api
   */
  Stroke.prototype.setWidth = function setWidth (width) {
    this.width_ = width;
    this.checksum_ = undefined;
  };

  /**
   * @return {string} The checksum.
   */
  Stroke.prototype.getChecksum = function getChecksum () {
    if (this.checksum_ === undefined) {
      this.checksum_ = 's';
      if (this.color_) {
        if (typeof this.color_ === 'string') {
          this.checksum_ += this.color_;
        } else {
          this.checksum_ += getUid(this.color_);
        }
      } else {
        this.checksum_ += '-';
      }
      this.checksum_ += ',' +
          (this.lineCap_ !== undefined ?
            this.lineCap_.toString() : '-') + ',' +
          (this.lineDash_ ?
            this.lineDash_.toString() : '-') + ',' +
          (this.lineDashOffset_ !== undefined ?
            this.lineDashOffset_ : '-') + ',' +
          (this.lineJoin_ !== undefined ?
            this.lineJoin_ : '-') + ',' +
          (this.miterLimit_ !== undefined ?
            this.miterLimit_.toString() : '-') + ',' +
          (this.width_ !== undefined ?
            this.width_.toString() : '-');
    }

    return this.checksum_;
  };

  /**
   * @module ol/style/Style
   */


  /**
   * A function that takes an {@link module:ol/Feature} and a `{number}`
   * representing the view's resolution. The function should return a
   * {@link module:ol/style/Style} or an array of them. This way e.g. a
   * vector layer can be styled.
   *
   * @typedef {function(import("../Feature.js").FeatureLike, number):(Style|Array<Style>)} StyleFunction
   */

  /**
   * A {@link Style}, an array of {@link Style}, or a {@link StyleFunction}.
   * @typedef {Style|Array<Style>|StyleFunction} StyleLike
   */

  /**
   * A function that takes an {@link module:ol/Feature} as argument and returns an
   * {@link module:ol/geom/Geometry} that will be rendered and styled for the feature.
   *
   * @typedef {function(import("../Feature.js").FeatureLike):
   *     (import("../geom/Geometry.js").default|import("../render/Feature.js").default|undefined)} GeometryFunction
   */


  /**
   * Custom renderer function. Takes two arguments:
   *
   * 1. The pixel coordinates of the geometry in GeoJSON notation.
   * 2. The {@link module:ol/render~State} of the layer renderer.
   *
   * @typedef {function((import("../coordinate.js").Coordinate|Array<import("../coordinate.js").Coordinate>|Array<Array<import("../coordinate.js").Coordinate>>),import("../render.js").State)}
   * RenderFunction
   */


  /**
   * @typedef {Object} Options
   * @property {string|import("../geom/Geometry.js").default|GeometryFunction} [geometry] Feature property or geometry
   * or function returning a geometry to render for this style.
   * @property {import("./Fill.js").default} [fill] Fill style.
   * @property {import("./Image.js").default} [image] Image style.
   * @property {RenderFunction} [renderer] Custom renderer. When configured, `fill`, `stroke` and `image` will be
   * ignored, and the provided function will be called with each render frame for each geometry.
   * @property {import("./Stroke.js").default} [stroke] Stroke style.
   * @property {import("./Text.js").default} [text] Text style.
   * @property {number} [zIndex] Z index.
   */

  /**
   * @classdesc
   * Container for vector feature rendering styles. Any changes made to the style
   * or its children through `set*()` methods will not take effect until the
   * feature or layer that uses the style is re-rendered.
   * @api
   */
  var Style = function Style(opt_options) {

    var options = opt_options || {};

    /**
     * @private
     * @type {string|import("../geom/Geometry.js").default|GeometryFunction}
     */
    this.geometry_ = null;

    /**
     * @private
     * @type {!GeometryFunction}
     */
    this.geometryFunction_ = defaultGeometryFunction;

    if (options.geometry !== undefined) {
      this.setGeometry(options.geometry);
    }

    /**
     * @private
     * @type {import("./Fill.js").default}
     */
    this.fill_ = options.fill !== undefined ? options.fill : null;

    /**
       * @private
       * @type {import("./Image.js").default}
       */
    this.image_ = options.image !== undefined ? options.image : null;

    /**
     * @private
     * @type {RenderFunction|null}
     */
    this.renderer_ = options.renderer !== undefined ? options.renderer : null;

    /**
     * @private
     * @type {import("./Stroke.js").default}
     */
    this.stroke_ = options.stroke !== undefined ? options.stroke : null;

    /**
     * @private
     * @type {import("./Text.js").default}
     */
    this.text_ = options.text !== undefined ? options.text : null;

    /**
     * @private
     * @type {number|undefined}
     */
    this.zIndex_ = options.zIndex;

  };

  /**
   * Clones the style.
   * @return {Style} The cloned style.
   * @api
   */
  Style.prototype.clone = function clone () {
    var geometry = this.getGeometry();
    if (geometry && typeof geometry === 'object') {
      geometry = /** @type {import("../geom/Geometry.js").default} */ (geometry).clone();
    }
    return new Style({
      geometry: geometry,
      fill: this.getFill() ? this.getFill().clone() : undefined,
      image: this.getImage() ? this.getImage().clone() : undefined,
      stroke: this.getStroke() ? this.getStroke().clone() : undefined,
      text: this.getText() ? this.getText().clone() : undefined,
      zIndex: this.getZIndex()
    });
  };

  /**
   * Get the custom renderer function that was configured with
   * {@link #setRenderer} or the `renderer` constructor option.
   * @return {RenderFunction|null} Custom renderer function.
   * @api
   */
  Style.prototype.getRenderer = function getRenderer () {
    return this.renderer_;
  };

  /**
   * Sets a custom renderer function for this style. When set, `fill`, `stroke`
   * and `image` options of the style will be ignored.
   * @param {RenderFunction|null} renderer Custom renderer function.
   * @api
   */
  Style.prototype.setRenderer = function setRenderer (renderer) {
    this.renderer_ = renderer;
  };

  /**
   * Get the geometry to be rendered.
   * @return {string|import("../geom/Geometry.js").default|GeometryFunction}
   * Feature property or geometry or function that returns the geometry that will
   * be rendered with this style.
   * @api
   */
  Style.prototype.getGeometry = function getGeometry () {
    return this.geometry_;
  };

  /**
   * Get the function used to generate a geometry for rendering.
   * @return {!GeometryFunction} Function that is called with a feature
   * and returns the geometry to render instead of the feature's geometry.
   * @api
   */
  Style.prototype.getGeometryFunction = function getGeometryFunction () {
    return this.geometryFunction_;
  };

  /**
   * Get the fill style.
   * @return {import("./Fill.js").default} Fill style.
   * @api
   */
  Style.prototype.getFill = function getFill () {
    return this.fill_;
  };

  /**
   * Set the fill style.
   * @param {import("./Fill.js").default} fill Fill style.
   * @api
   */
  Style.prototype.setFill = function setFill (fill) {
    this.fill_ = fill;
  };

  /**
   * Get the image style.
   * @return {import("./Image.js").default} Image style.
   * @api
   */
  Style.prototype.getImage = function getImage () {
    return this.image_;
  };

  /**
   * Set the image style.
   * @param {import("./Image.js").default} image Image style.
   * @api
   */
  Style.prototype.setImage = function setImage (image) {
    this.image_ = image;
  };

  /**
   * Get the stroke style.
   * @return {import("./Stroke.js").default} Stroke style.
   * @api
   */
  Style.prototype.getStroke = function getStroke () {
    return this.stroke_;
  };

  /**
   * Set the stroke style.
   * @param {import("./Stroke.js").default} stroke Stroke style.
   * @api
   */
  Style.prototype.setStroke = function setStroke (stroke) {
    this.stroke_ = stroke;
  };

  /**
   * Get the text style.
   * @return {import("./Text.js").default} Text style.
   * @api
   */
  Style.prototype.getText = function getText () {
    return this.text_;
  };

  /**
   * Set the text style.
   * @param {import("./Text.js").default} text Text style.
   * @api
   */
  Style.prototype.setText = function setText (text) {
    this.text_ = text;
  };

  /**
   * Get the z-index for the style.
   * @return {number|undefined} ZIndex.
   * @api
   */
  Style.prototype.getZIndex = function getZIndex () {
    return this.zIndex_;
  };

  /**
   * Set a geometry that is rendered instead of the feature's geometry.
   *
   * @param {string|import("../geom/Geometry.js").default|GeometryFunction} geometry
   *   Feature property or geometry or function returning a geometry to render
   *   for this style.
   * @api
   */
  Style.prototype.setGeometry = function setGeometry (geometry) {
    if (typeof geometry === 'function') {
      this.geometryFunction_ = geometry;
    } else if (typeof geometry === 'string') {
      this.geometryFunction_ = function(feature) {
        return (
          /** @type {import("../geom/Geometry.js").default} */ (feature.get(geometry))
        );
      };
    } else if (!geometry) {
      this.geometryFunction_ = defaultGeometryFunction;
    } else if (geometry !== undefined) {
      this.geometryFunction_ = function() {
        return (
          /** @type {import("../geom/Geometry.js").default} */ (geometry)
        );
      };
    }
    this.geometry_ = geometry;
  };

  /**
   * Set the z-index.
   *
   * @param {number|undefined} zIndex ZIndex.
   * @api
   */
  Style.prototype.setZIndex = function setZIndex (zIndex) {
    this.zIndex_ = zIndex;
  };


  /**
   * Convert the provided object into a style function.  Functions passed through
   * unchanged.  Arrays of Style or single style objects wrapped in a
   * new style function.
   * @param {StyleFunction|Array<Style>|Style} obj
   *     A style function, a single style, or an array of styles.
   * @return {StyleFunction} A style function.
   */
  function toFunction(obj) {
    var styleFunction;

    if (typeof obj === 'function') {
      styleFunction = obj;
    } else {
      /**
       * @type {Array<Style>}
       */
      var styles;
      if (Array.isArray(obj)) {
        styles = obj;
      } else {
        assert(typeof /** @type {?} */ (obj).getZIndex === 'function',
          41); // Expected an `Style` or an array of `Style`
        var style = /** @type {Style} */ (obj);
        styles = [style];
      }
      styleFunction = function() {
        return styles;
      };
    }
    return styleFunction;
  }


  /**
   * @type {Array<Style>}
   */
  var defaultStyles = null;


  /**
   * @param {import("../Feature.js").FeatureLike} feature Feature.
   * @param {number} resolution Resolution.
   * @return {Array<Style>} Style.
   */
  function createDefaultStyle(feature, resolution) {
    // We don't use an immediately-invoked function
    // and a closure so we don't get an error at script evaluation time in
    // browsers that do not support Canvas. (import("./Circle.js").CircleStyle does
    // canvas.getContext('2d') at construction time, which will cause an.error
    // in such browsers.)
    if (!defaultStyles) {
      var fill = new Fill({
        color: 'rgba(255,255,255,0.4)'
      });
      var stroke = new Stroke({
        color: '#3399CC',
        width: 1.25
      });
      defaultStyles = [
        new Style({
          image: new CircleStyle({
            fill: fill,
            stroke: stroke,
            radius: 5
          }),
          fill: fill,
          stroke: stroke
        })
      ];
    }
    return defaultStyles;
  }


  /**
   * Default styles for editing features.
   * @return {Object<import("../geom/GeometryType.js").default, Array<Style>>} Styles
   */
  function createEditingStyle() {
    /** @type {Object<import("../geom/GeometryType.js").default, Array<Style>>} */
    var styles = {};
    var white = [255, 255, 255, 1];
    var blue = [0, 153, 255, 1];
    var width = 3;
    styles[GeometryType.POLYGON] = [
      new Style({
        fill: new Fill({
          color: [255, 255, 255, 0.5]
        })
      })
    ];
    styles[GeometryType.MULTI_POLYGON] =
        styles[GeometryType.POLYGON];

    styles[GeometryType.LINE_STRING] = [
      new Style({
        stroke: new Stroke({
          color: white,
          width: width + 2
        })
      }),
      new Style({
        stroke: new Stroke({
          color: blue,
          width: width
        })
      })
    ];
    styles[GeometryType.MULTI_LINE_STRING] =
        styles[GeometryType.LINE_STRING];

    styles[GeometryType.CIRCLE] =
        styles[GeometryType.POLYGON].concat(
          styles[GeometryType.LINE_STRING]
        );


    styles[GeometryType.POINT] = [
      new Style({
        image: new CircleStyle({
          radius: width * 2,
          fill: new Fill({
            color: blue
          }),
          stroke: new Stroke({
            color: white,
            width: width / 2
          })
        }),
        zIndex: Infinity
      })
    ];
    styles[GeometryType.MULTI_POINT] =
        styles[GeometryType.POINT];

    styles[GeometryType.GEOMETRY_COLLECTION] =
        styles[GeometryType.POLYGON].concat(
          styles[GeometryType.LINE_STRING],
          styles[GeometryType.POINT]
        );

    return styles;
  }


  /**
   * Function that is called with a feature and returns its default geometry.
   * @param {import("../Feature.js").FeatureLike} feature Feature to get the geometry for.
   * @return {import("../geom/Geometry.js").default|import("../render/Feature.js").default|undefined} Geometry to render.
   */
  function defaultGeometryFunction(feature) {
    return feature.getGeometry();
  }

  /**
   * @module ol/layer/Vector
   */


  /**
   * @typedef {Object} Options
   * @property {number} [opacity=1] Opacity (0, 1).
   * @property {boolean} [visible=true] Visibility.
   * @property {import("../extent.js").Extent} [extent] The bounding extent for layer rendering.  The layer will not be
   * rendered outside of this extent.
   * @property {number} [zIndex] The z-index for layer rendering.  At rendering time, the layers
   * will be ordered, first by Z-index and then by position. When `undefined`, a `zIndex` of 0 is assumed
   * for layers that are added to the map's `layers` collection, or `Infinity` when the layer's `setMap()`
   * method was used.
   * @property {number} [minResolution] The minimum resolution (inclusive) at which this layer will be
   * visible.
   * @property {number} [maxResolution] The maximum resolution (exclusive) below which this layer will
   * be visible.
   * @property {import("../render.js").OrderFunction} [renderOrder] Render order. Function to be used when sorting
   * features before rendering. By default features are drawn in the order that they are created. Use
   * `null` to avoid the sort, but get an undefined draw order.
   * @property {number} [renderBuffer=100] The buffer in pixels around the viewport extent used by the
   * renderer when getting features from the vector source for the rendering or hit-detection.
   * Recommended value: the size of the largest symbol, line width or label.
   * @property {import("./VectorRenderType.js").default|string} [renderMode='vector'] Render mode for vector layers:
   *  * `'image'`: Vector layers are rendered as images. Great performance, but point symbols and
   *    texts are always rotated with the view and pixels are scaled during zoom animations.
   *  * `'vector'`: Vector layers are rendered as vectors. Most accurate rendering even during
   *    animations, but slower performance.
   * @property {import("../source/Vector.js").default} [source] Source.
   * @property {import("../PluggableMap.js").default} [map] Sets the layer as overlay on a map. The map will not manage
   * this layer in its layers collection, and the layer will be rendered on top. This is useful for
   * temporary layers. The standard way to add a layer to a map and have it managed by the map is to
   * use {@link module:ol/Map#addLayer}.
   * @property {boolean} [declutter=false] Declutter images and text. Decluttering is applied to all
   * image and text styles, and the priority is defined by the z-index of the style. Lower z-index
   * means higher priority.
   * @property {import("../style/Style.js").StyleLike} [style] Layer style. See
   * {@link module:ol/style} for default style which will be used if this is not defined.
   * @property {boolean} [updateWhileAnimating=false] When set to `true` and `renderMode`
   * is `vector`, feature batches will be recreated during animations. This means that no
   * vectors will be shown clipped, but the setting will have a performance impact for large
   * amounts of vector data. When set to `false`, batches will be recreated when no animation
   * is active.
   * @property {boolean} [updateWhileInteracting=false] When set to `true` and `renderMode`
   * is `vector`, feature batches will be recreated during interactions. See also
   * `updateWhileAnimating`.
   */


  /**
   * @enum {string}
   * @private
   */
  var Property$2 = {
    RENDER_ORDER: 'renderOrder'
  };


  /**
   * @classdesc
   * Vector data that is rendered client-side.
   * Note that any property set in the options is set as a {@link module:ol/Object~BaseObject}
   * property on the layer object; for example, setting `title: 'My Title'` in the
   * options means that `title` is observable, and has get/set accessors.
   *
   * @api
   */
  var VectorLayer = /*@__PURE__*/(function (Layer$$1) {
    function VectorLayer(opt_options) {
      var options = opt_options ?
        opt_options : /** @type {Options} */ ({});

      var baseOptions = assign({}, options);

      delete baseOptions.style;
      delete baseOptions.renderBuffer;
      delete baseOptions.updateWhileAnimating;
      delete baseOptions.updateWhileInteracting;
      Layer$$1.call(this, baseOptions);

      /**
      * @private
      * @type {boolean}
      */
      this.declutter_ = options.declutter !== undefined ? options.declutter : false;

      /**
      * @type {number}
      * @private
      */
      this.renderBuffer_ = options.renderBuffer !== undefined ?
        options.renderBuffer : 100;

      /**
      * User provided style.
      * @type {import("../style/Style.js").StyleLike}
      * @private
      */
      this.style_ = null;

      /**
      * Style function for use within the library.
      * @type {import("../style/Style.js").StyleFunction|undefined}
      * @private
      */
      this.styleFunction_ = undefined;

      this.setStyle(options.style);

      /**
      * @type {boolean}
      * @private
      */
      this.updateWhileAnimating_ = options.updateWhileAnimating !== undefined ?
        options.updateWhileAnimating : false;

      /**
      * @type {boolean}
      * @private
      */
      this.updateWhileInteracting_ = options.updateWhileInteracting !== undefined ?
        options.updateWhileInteracting : false;

      /**
      * @private
      * @type {import("./VectorTileRenderType.js").default|string}
      */
      this.renderMode_ = options.renderMode || VectorRenderType.VECTOR;

      /**
      * The layer type.
      * @protected
      * @type {import("../LayerType.js").default}
      */
      this.type = LayerType.VECTOR;

    }

    if ( Layer$$1 ) VectorLayer.__proto__ = Layer$$1;
    VectorLayer.prototype = Object.create( Layer$$1 && Layer$$1.prototype );
    VectorLayer.prototype.constructor = VectorLayer;

    /**
    * @return {boolean} Declutter.
    */
    VectorLayer.prototype.getDeclutter = function getDeclutter () {
      return this.declutter_;
    };

    /**
    * @param {boolean} declutter Declutter.
    */
    VectorLayer.prototype.setDeclutter = function setDeclutter (declutter) {
      this.declutter_ = declutter;
    };

    /**
    * @return {number|undefined} Render buffer.
    */
    VectorLayer.prototype.getRenderBuffer = function getRenderBuffer () {
      return this.renderBuffer_;
    };

    /**
    * @return {function(import("../Feature.js").default, import("../Feature.js").default): number|null|undefined} Render
    *     order.
    */
    VectorLayer.prototype.getRenderOrder = function getRenderOrder () {
      return (
      /** @type {import("../render.js").OrderFunction|null|undefined} */ (this.get(Property$2.RENDER_ORDER))
      );
    };

    /**
    * Get the style for features.  This returns whatever was passed to the `style`
    * option at construction or to the `setStyle` method.
    * @return {import("../style/Style.js").StyleLike}
    *     Layer style.
    * @api
    */
    VectorLayer.prototype.getStyle = function getStyle () {
      return this.style_;
    };

    /**
    * Get the style function.
    * @return {import("../style/Style.js").StyleFunction|undefined} Layer style function.
    * @api
    */
    VectorLayer.prototype.getStyleFunction = function getStyleFunction () {
      return this.styleFunction_;
    };

    /**
    * @return {boolean} Whether the rendered layer should be updated while
    *     animating.
    */
    VectorLayer.prototype.getUpdateWhileAnimating = function getUpdateWhileAnimating () {
      return this.updateWhileAnimating_;
    };

    /**
    * @return {boolean} Whether the rendered layer should be updated while
    *     interacting.
    */
    VectorLayer.prototype.getUpdateWhileInteracting = function getUpdateWhileInteracting () {
      return this.updateWhileInteracting_;
    };

    /**
    * @param {import("../render.js").OrderFunction|null|undefined} renderOrder
    *     Render order.
    */
    VectorLayer.prototype.setRenderOrder = function setRenderOrder (renderOrder) {
      this.set(Property$2.RENDER_ORDER, renderOrder);
    };

    /**
    * Set the style for features.  This can be a single style object, an array
    * of styles, or a function that takes a feature and resolution and returns
    * an array of styles. If it is `undefined` the default style is used. If
    * it is `null` the layer has no style (a `null` style), so only features
    * that have their own styles will be rendered in the layer. See
    * {@link module:ol/style} for information on the default style.
    * @param {import("../style/Style.js").default|Array<import("../style/Style.js").default>|import("../style/Style.js").StyleFunction|null|undefined} style Layer style.
    * @api
    */
    VectorLayer.prototype.setStyle = function setStyle (style) {
      this.style_ = style !== undefined ? style : createDefaultStyle;
      this.styleFunction_ = style === null ?
        undefined : toFunction(this.style_);
      this.changed();
    };

    /**
    * @return {import("./VectorRenderType.js").default|string} The render mode.
    */
    VectorLayer.prototype.getRenderMode = function getRenderMode () {
      return this.renderMode_;
    };

    return VectorLayer;
  }(Layer));


  /**
   * Return the associated {@link module:ol/source/Vector vectorsource} of the layer.
   * @function
   * @return {import("../source/Vector.js").default} Source.
   * @api
   */
  VectorLayer.prototype.getSource;

  /**
   * @module ol/format/FormatType
   */

  /**
   * @enum {string}
   */
  var FormatType = {
    ARRAY_BUFFER: 'arraybuffer',
    JSON: 'json',
    TEXT: 'text',
    XML: 'xml'
  };

  /**
   * @module ol/featureloader
   */

  /**
   * {@link module:ol/source/Vector} sources use a function of this type to
   * load features.
   *
   * This function takes an {@link module:ol/extent~Extent} representing the area to be loaded,
   * a `{number}` representing the resolution (map units per pixel) and an
   * {@link module:ol/proj/Projection} for the projection  as
   * arguments. `this` within the function is bound to the
   * {@link module:ol/source/Vector} it's called from.
   *
   * The function is responsible for loading the features and adding them to the
   * source.
   * @typedef {function(this:(import("./source/Vector").default|import("./VectorTile.js").default), import("./extent.js").Extent, number,
   *                    import("./proj/Projection.js").default)} FeatureLoader
   * @api
   */


  /**
   * {@link module:ol/source/Vector} sources use a function of this type to
   * get the url to load features from.
   *
   * This function takes an {@link module:ol/extent~Extent} representing the area
   * to be loaded, a `{number}` representing the resolution (map units per pixel)
   * and an {@link module:ol/proj/Projection} for the projection  as
   * arguments and returns a `{string}` representing the URL.
   * @typedef {function(import("./extent.js").Extent, number, import("./proj/Projection.js").default): string} FeatureUrlFunction
   * @api
   */


  /**
   * @param {string|FeatureUrlFunction} url Feature URL service.
   * @param {import("./format/Feature.js").default} format Feature format.
   * @param {function(this:import("./VectorTile.js").default, Array<import("./Feature.js").default>, import("./proj/Projection.js").default, import("./extent.js").Extent)|function(this:import("./source/Vector").default, Array<import("./Feature.js").default>)} success
   *     Function called with the loaded features and optionally with the data
   *     projection. Called with the vector tile or source as `this`.
   * @param {function(this:import("./VectorTile.js").default)|function(this:import("./source/Vector").default)} failure
   *     Function called when loading failed. Called with the vector tile or
   *     source as `this`.
   * @return {FeatureLoader} The feature loader.
   */
  function loadFeaturesXhr(url, format, success, failure) {
    return (
      /**
       * @param {import("./extent.js").Extent} extent Extent.
       * @param {number} resolution Resolution.
       * @param {import("./proj/Projection.js").default} projection Projection.
       * @this {import("./source/Vector").default|import("./VectorTile.js").default}
       */
      function(extent, resolution, projection) {
        var xhr = new XMLHttpRequest();
        xhr.open('GET',
          typeof url === 'function' ? url(extent, resolution, projection) : url,
          true);
        if (format.getType() == FormatType.ARRAY_BUFFER) {
          xhr.responseType = 'arraybuffer';
        }
        /**
         * @param {Event} event Event.
         * @private
         */
        xhr.onload = function(event) {
          // status will be 0 for file:// urls
          if (!xhr.status || xhr.status >= 200 && xhr.status < 300) {
            var type = format.getType();
            /** @type {Document|Node|Object|string|undefined} */
            var source;
            if (type == FormatType.JSON || type == FormatType.TEXT) {
              source = xhr.responseText;
            } else if (type == FormatType.XML) {
              source = xhr.responseXML;
              if (!source) {
                source = new DOMParser().parseFromString(xhr.responseText, 'application/xml');
              }
            } else if (type == FormatType.ARRAY_BUFFER) {
              source = /** @type {ArrayBuffer} */ (xhr.response);
            }
            if (source) {
              success.call(this, format.readFeatures(source,
                {featureProjection: projection}),
              format.readProjection(source), format.getLastExtent());
            } else {
              failure.call(this);
            }
          } else {
            failure.call(this);
          }
        }.bind(this);
        /**
         * @private
         */
        xhr.onerror = function() {
          failure.call(this);
        }.bind(this);
        xhr.send();
      }
    );
  }


  /**
   * Create an XHR feature loader for a `url` and `format`. The feature loader
   * loads features (with XHR), parses the features, and adds them to the
   * vector source.
   * @param {string|FeatureUrlFunction} url Feature URL service.
   * @param {import("./format/Feature.js").default} format Feature format.
   * @return {FeatureLoader} The feature loader.
   * @api
   */
  function xhr(url, format) {
    return loadFeaturesXhr(url, format,
      /**
       * @param {Array<import("./Feature.js").default>} features The loaded features.
       * @param {import("./proj/Projection.js").default} dataProjection Data
       * projection.
       * @this {import("./source/Vector").default|import("./VectorTile.js").default}
       */
      function(features, dataProjection) {
        var sourceOrTile = /** @type {?} */ (this);
        if (typeof sourceOrTile.addFeatures === 'function') {
          /** @type {import("./source/Vector").default} */ (sourceOrTile).addFeatures(features);
        }
      }, /* FIXME handle error */ VOID);
  }

  /**
   * @module ol/loadingstrategy
   */


  /**
   * Strategy function for loading all features with a single request.
   * @param {import("./extent.js").Extent} extent Extent.
   * @param {number} resolution Resolution.
   * @return {Array<import("./extent.js").Extent>} Extents.
   * @api
   */
  function all(extent, resolution) {
    return [[-Infinity, -Infinity, Infinity, Infinity]];
  }

  /**
   * @module ol/source/Source
   */


  /**
   * A function that returns a string or an array of strings representing source
   * attributions.
   *
   * @typedef {function(import("../PluggableMap.js").FrameState): (string|Array<string>)} Attribution
   */


  /**
   * A type that can be used to provide attribution information for data sources.
   *
   * It represents either
   * * a simple string (e.g. `'© Acme Inc.'`)
   * * an array of simple strings (e.g. `['© Acme Inc.', '© Bacme Inc.']`)
   * * a function that returns a string or array of strings (`{@link module:ol/source/Source~Attribution}`)
   *
   * @typedef {string|Array<string>|Attribution} AttributionLike
   */


  /**
   * @typedef {Object} Options
   * @property {AttributionLike} [attributions]
   * @property {boolean} [attributionsCollapsible=true] Attributions are collapsible.
   * @property {import("../proj.js").ProjectionLike} projection
   * @property {SourceState} [state='ready']
   * @property {boolean} [wrapX=false]
   */


  /**
   * @classdesc
   * Abstract base class; normally only used for creating subclasses and not
   * instantiated in apps.
   * Base class for {@link module:ol/layer/Layer~Layer} sources.
   *
   * A generic `change` event is triggered when the state of the source changes.
   * @abstract
   * @api
   */
  var Source = /*@__PURE__*/(function (BaseObject$$1) {
    function Source(options) {

      BaseObject$$1.call(this);

      /**
       * @private
       * @type {import("../proj/Projection.js").default}
       */
      this.projection_ = get$2(options.projection);

      /**
       * @private
       * @type {?Attribution}
       */
      this.attributions_ = adaptAttributions(options.attributions);

      /**
       * @private
       * @type {boolean}
       */
      this.attributionsCollapsible_ = options.attributionsCollapsible !== undefined ?
        options.attributionsCollapsible : true;

      /**
       * This source is currently loading data. Sources that defer loading to the
       * map's tile queue never set this to `true`.
       * @type {boolean}
       */
      this.loading = false;

      /**
       * @private
       * @type {SourceState}
       */
      this.state_ = options.state !== undefined ?
        options.state : SourceState.READY;

      /**
       * @private
       * @type {boolean}
       */
      this.wrapX_ = options.wrapX !== undefined ? options.wrapX : false;

    }

    if ( BaseObject$$1 ) Source.__proto__ = BaseObject$$1;
    Source.prototype = Object.create( BaseObject$$1 && BaseObject$$1.prototype );
    Source.prototype.constructor = Source;

    /**
     * Get the attribution function for the source.
     * @return {?Attribution} Attribution function.
     */
    Source.prototype.getAttributions = function getAttributions () {
      return this.attributions_;
    };

    /**
     * @return {boolean} Aattributions are collapsible.
     */
    Source.prototype.getAttributionsCollapsible = function getAttributionsCollapsible () {
      return this.attributionsCollapsible_;
    };

    /**
     * Get the projection of the source.
     * @return {import("../proj/Projection.js").default} Projection.
     * @api
     */
    Source.prototype.getProjection = function getProjection () {
      return this.projection_;
    };

    /**
     * @abstract
     * @return {Array<number>|undefined} Resolutions.
     */
    Source.prototype.getResolutions = function getResolutions () {
      return abstract();
    };

    /**
     * Get the state of the source, see {@link module:ol/source/State~State} for possible states.
     * @return {SourceState} State.
     * @api
     */
    Source.prototype.getState = function getState () {
      return this.state_;
    };

    /**
     * @return {boolean|undefined} Wrap X.
     */
    Source.prototype.getWrapX = function getWrapX () {
      return this.wrapX_;
    };

    /**
     * Refreshes the source and finally dispatches a 'change' event.
     * @api
     */
    Source.prototype.refresh = function refresh () {
      this.changed();
    };

    /**
     * Set the attributions of the source.
     * @param {AttributionLike|undefined} attributions Attributions.
     *     Can be passed as `string`, `Array<string>`, `{@link module:ol/source/Source~Attribution}`,
     *     or `undefined`.
     * @api
     */
    Source.prototype.setAttributions = function setAttributions (attributions) {
      this.attributions_ = adaptAttributions(attributions);
      this.changed();
    };

    /**
     * Set the state of the source.
     * @param {SourceState} state State.
     * @protected
     */
    Source.prototype.setState = function setState (state) {
      this.state_ = state;
      this.changed();
    };

    return Source;
  }(BaseObject));


  /**
   * Turns the attributions option into an attributions function.
   * @param {AttributionLike|undefined} attributionLike The attribution option.
   * @return {?Attribution} An attribution function (or null).
   */
  function adaptAttributions(attributionLike) {
    if (!attributionLike) {
      return null;
    }
    if (Array.isArray(attributionLike)) {
      return function(frameState) {
        return attributionLike;
      };
    }

    if (typeof attributionLike === 'function') {
      return attributionLike;
    }

    return function(frameState) {
      return [attributionLike];
    };
  }

  /**
   * @module ol/source/VectorEventType
   */

  /**
   * @enum {string}
   */
  var VectorEventType = {
    /**
     * Triggered when a feature is added to the source.
     * @event ol/source/Vector.VectorSourceEvent#addfeature
     * @api
     */
    ADDFEATURE: 'addfeature',

    /**
     * Triggered when a feature is updated.
     * @event ol/source/Vector.VectorSourceEvent#changefeature
     * @api
     */
    CHANGEFEATURE: 'changefeature',

    /**
     * Triggered when the clear method is called on the source.
     * @event ol/source/Vector.VectorSourceEvent#clear
     * @api
     */
    CLEAR: 'clear',

    /**
     * Triggered when a feature is removed from the source.
     * See {@link module:ol/source/Vector#clear source.clear()} for exceptions.
     * @event ol/source/Vector.VectorSourceEvent#removefeature
     * @api
     */
    REMOVEFEATURE: 'removefeature'
  };

  var commonjsGlobal = typeof window !== 'undefined' ? window : typeof global !== 'undefined' ? global : typeof self !== 'undefined' ? self : {};

  function unwrapExports (x) {
  	return x && x.__esModule && Object.prototype.hasOwnProperty.call(x, 'default') ? x['default'] : x;
  }

  function createCommonjsModule(fn, module) {
  	return module = { exports: {} }, fn(module, module.exports), module.exports;
  }

  var quickselect = createCommonjsModule(function (module, exports) {
  (function (global, factory) {
  	module.exports = factory();
  }(commonjsGlobal, (function () {
  function quickselect(arr, k, left, right, compare) {
      quickselectStep(arr, k, left || 0, right || (arr.length - 1), compare || defaultCompare);
  }

  function quickselectStep(arr, k, left, right, compare) {

      while (right > left) {
          if (right - left > 600) {
              var n = right - left + 1;
              var m = k - left + 1;
              var z = Math.log(n);
              var s = 0.5 * Math.exp(2 * z / 3);
              var sd = 0.5 * Math.sqrt(z * s * (n - s) / n) * (m - n / 2 < 0 ? -1 : 1);
              var newLeft = Math.max(left, Math.floor(k - m * s / n + sd));
              var newRight = Math.min(right, Math.floor(k + (n - m) * s / n + sd));
              quickselectStep(arr, k, newLeft, newRight, compare);
          }

          var t = arr[k];
          var i = left;
          var j = right;

          swap(arr, left, k);
          if (compare(arr[right], t) > 0) swap(arr, left, right);

          while (i < j) {
              swap(arr, i, j);
              i++;
              j--;
              while (compare(arr[i], t) < 0) i++;
              while (compare(arr[j], t) > 0) j--;
          }

          if (compare(arr[left], t) === 0) swap(arr, left, j);
          else {
              j++;
              swap(arr, j, right);
          }

          if (j <= k) left = j + 1;
          if (k <= j) right = j - 1;
      }
  }

  function swap(arr, i, j) {
      var tmp = arr[i];
      arr[i] = arr[j];
      arr[j] = tmp;
  }

  function defaultCompare(a, b) {
      return a < b ? -1 : a > b ? 1 : 0;
  }

  return quickselect;

  })));
  });

  var quickselect$1 = /*#__PURE__*/Object.freeze({
    default: quickselect,
    __moduleExports: quickselect
  });

  var quickselect$2 = ( quickselect$1 && quickselect ) || quickselect$1;

  var rbush_1 = rbush;
  var default_1 = rbush;



  function rbush(maxEntries, format) {
      if (!(this instanceof rbush)) return new rbush(maxEntries, format);

      // max entries in a node is 9 by default; min node fill is 40% for best performance
      this._maxEntries = Math.max(4, maxEntries || 9);
      this._minEntries = Math.max(2, Math.ceil(this._maxEntries * 0.4));

      if (format) {
          this._initFormat(format);
      }

      this.clear();
  }

  rbush.prototype = {

      all: function () {
          return this._all(this.data, []);
      },

      search: function (bbox) {

          var node = this.data,
              result = [],
              toBBox = this.toBBox;

          if (!intersects$1(bbox, node)) return result;

          var nodesToSearch = [],
              i, len, child, childBBox;

          while (node) {
              for (i = 0, len = node.children.length; i < len; i++) {

                  child = node.children[i];
                  childBBox = node.leaf ? toBBox(child) : child;

                  if (intersects$1(bbox, childBBox)) {
                      if (node.leaf) result.push(child);
                      else if (contains(bbox, childBBox)) this._all(child, result);
                      else nodesToSearch.push(child);
                  }
              }
              node = nodesToSearch.pop();
          }

          return result;
      },

      collides: function (bbox) {

          var node = this.data,
              toBBox = this.toBBox;

          if (!intersects$1(bbox, node)) return false;

          var nodesToSearch = [],
              i, len, child, childBBox;

          while (node) {
              for (i = 0, len = node.children.length; i < len; i++) {

                  child = node.children[i];
                  childBBox = node.leaf ? toBBox(child) : child;

                  if (intersects$1(bbox, childBBox)) {
                      if (node.leaf || contains(bbox, childBBox)) return true;
                      nodesToSearch.push(child);
                  }
              }
              node = nodesToSearch.pop();
          }

          return false;
      },

      load: function (data) {
          if (!(data && data.length)) return this;

          if (data.length < this._minEntries) {
              for (var i = 0, len = data.length; i < len; i++) {
                  this.insert(data[i]);
              }
              return this;
          }

          // recursively build the tree with the given data from scratch using OMT algorithm
          var node = this._build(data.slice(), 0, data.length - 1, 0);

          if (!this.data.children.length) {
              // save as is if tree is empty
              this.data = node;

          } else if (this.data.height === node.height) {
              // split root if trees have the same height
              this._splitRoot(this.data, node);

          } else {
              if (this.data.height < node.height) {
                  // swap trees if inserted one is bigger
                  var tmpNode = this.data;
                  this.data = node;
                  node = tmpNode;
              }

              // insert the small tree into the large tree at appropriate level
              this._insert(node, this.data.height - node.height - 1, true);
          }

          return this;
      },

      insert: function (item) {
          if (item) this._insert(item, this.data.height - 1);
          return this;
      },

      clear: function () {
          this.data = createNode([]);
          return this;
      },

      remove: function (item, equalsFn) {
          if (!item) return this;

          var node = this.data,
              bbox = this.toBBox(item),
              path = [],
              indexes = [],
              i, parent, index, goingUp;

          // depth-first iterative tree traversal
          while (node || path.length) {

              if (!node) { // go up
                  node = path.pop();
                  parent = path[path.length - 1];
                  i = indexes.pop();
                  goingUp = true;
              }

              if (node.leaf) { // check current node
                  index = findItem(item, node.children, equalsFn);

                  if (index !== -1) {
                      // item found, remove the item and condense tree upwards
                      node.children.splice(index, 1);
                      path.push(node);
                      this._condense(path);
                      return this;
                  }
              }

              if (!goingUp && !node.leaf && contains(node, bbox)) { // go down
                  path.push(node);
                  indexes.push(i);
                  i = 0;
                  parent = node;
                  node = node.children[0];

              } else if (parent) { // go right
                  i++;
                  node = parent.children[i];
                  goingUp = false;

              } else node = null; // nothing found
          }

          return this;
      },

      toBBox: function (item) { return item; },

      compareMinX: compareNodeMinX,
      compareMinY: compareNodeMinY,

      toJSON: function () { return this.data; },

      fromJSON: function (data) {
          this.data = data;
          return this;
      },

      _all: function (node, result) {
          var nodesToSearch = [];
          while (node) {
              if (node.leaf) result.push.apply(result, node.children);
              else nodesToSearch.push.apply(nodesToSearch, node.children);

              node = nodesToSearch.pop();
          }
          return result;
      },

      _build: function (items, left, right, height) {

          var N = right - left + 1,
              M = this._maxEntries,
              node;

          if (N <= M) {
              // reached leaf level; return leaf
              node = createNode(items.slice(left, right + 1));
              calcBBox(node, this.toBBox);
              return node;
          }

          if (!height) {
              // target height of the bulk-loaded tree
              height = Math.ceil(Math.log(N) / Math.log(M));

              // target number of root entries to maximize storage utilization
              M = Math.ceil(N / Math.pow(M, height - 1));
          }

          node = createNode([]);
          node.leaf = false;
          node.height = height;

          // split the items into M mostly square tiles

          var N2 = Math.ceil(N / M),
              N1 = N2 * Math.ceil(Math.sqrt(M)),
              i, j, right2, right3;

          multiSelect(items, left, right, N1, this.compareMinX);

          for (i = left; i <= right; i += N1) {

              right2 = Math.min(i + N1 - 1, right);

              multiSelect(items, i, right2, N2, this.compareMinY);

              for (j = i; j <= right2; j += N2) {

                  right3 = Math.min(j + N2 - 1, right2);

                  // pack each entry recursively
                  node.children.push(this._build(items, j, right3, height - 1));
              }
          }

          calcBBox(node, this.toBBox);

          return node;
      },

      _chooseSubtree: function (bbox, node, level, path) {

          var i, len, child, targetNode, area, enlargement, minArea, minEnlargement;

          while (true) {
              path.push(node);

              if (node.leaf || path.length - 1 === level) break;

              minArea = minEnlargement = Infinity;

              for (i = 0, len = node.children.length; i < len; i++) {
                  child = node.children[i];
                  area = bboxArea(child);
                  enlargement = enlargedArea(bbox, child) - area;

                  // choose entry with the least area enlargement
                  if (enlargement < minEnlargement) {
                      minEnlargement = enlargement;
                      minArea = area < minArea ? area : minArea;
                      targetNode = child;

                  } else if (enlargement === minEnlargement) {
                      // otherwise choose one with the smallest area
                      if (area < minArea) {
                          minArea = area;
                          targetNode = child;
                      }
                  }
              }

              node = targetNode || node.children[0];
          }

          return node;
      },

      _insert: function (item, level, isNode) {

          var toBBox = this.toBBox,
              bbox = isNode ? item : toBBox(item),
              insertPath = [];

          // find the best node for accommodating the item, saving all nodes along the path too
          var node = this._chooseSubtree(bbox, this.data, level, insertPath);

          // put the item into the node
          node.children.push(item);
          extend$2(node, bbox);

          // split on node overflow; propagate upwards if necessary
          while (level >= 0) {
              if (insertPath[level].children.length > this._maxEntries) {
                  this._split(insertPath, level);
                  level--;
              } else break;
          }

          // adjust bboxes along the insertion path
          this._adjustParentBBoxes(bbox, insertPath, level);
      },

      // split overflowed node into two
      _split: function (insertPath, level) {

          var node = insertPath[level],
              M = node.children.length,
              m = this._minEntries;

          this._chooseSplitAxis(node, m, M);

          var splitIndex = this._chooseSplitIndex(node, m, M);

          var newNode = createNode(node.children.splice(splitIndex, node.children.length - splitIndex));
          newNode.height = node.height;
          newNode.leaf = node.leaf;

          calcBBox(node, this.toBBox);
          calcBBox(newNode, this.toBBox);

          if (level) insertPath[level - 1].children.push(newNode);
          else this._splitRoot(node, newNode);
      },

      _splitRoot: function (node, newNode) {
          // split root node
          this.data = createNode([node, newNode]);
          this.data.height = node.height + 1;
          this.data.leaf = false;
          calcBBox(this.data, this.toBBox);
      },

      _chooseSplitIndex: function (node, m, M) {

          var i, bbox1, bbox2, overlap, area, minOverlap, minArea, index;

          minOverlap = minArea = Infinity;

          for (i = m; i <= M - m; i++) {
              bbox1 = distBBox(node, 0, i, this.toBBox);
              bbox2 = distBBox(node, i, M, this.toBBox);

              overlap = intersectionArea(bbox1, bbox2);
              area = bboxArea(bbox1) + bboxArea(bbox2);

              // choose distribution with minimum overlap
              if (overlap < minOverlap) {
                  minOverlap = overlap;
                  index = i;

                  minArea = area < minArea ? area : minArea;

              } else if (overlap === minOverlap) {
                  // otherwise choose distribution with minimum area
                  if (area < minArea) {
                      minArea = area;
                      index = i;
                  }
              }
          }

          return index;
      },

      // sorts node children by the best axis for split
      _chooseSplitAxis: function (node, m, M) {

          var compareMinX = node.leaf ? this.compareMinX : compareNodeMinX,
              compareMinY = node.leaf ? this.compareMinY : compareNodeMinY,
              xMargin = this._allDistMargin(node, m, M, compareMinX),
              yMargin = this._allDistMargin(node, m, M, compareMinY);

          // if total distributions margin value is minimal for x, sort by minX,
          // otherwise it's already sorted by minY
          if (xMargin < yMargin) node.children.sort(compareMinX);
      },

      // total margin of all possible split distributions where each node is at least m full
      _allDistMargin: function (node, m, M, compare) {

          node.children.sort(compare);

          var toBBox = this.toBBox,
              leftBBox = distBBox(node, 0, m, toBBox),
              rightBBox = distBBox(node, M - m, M, toBBox),
              margin = bboxMargin(leftBBox) + bboxMargin(rightBBox),
              i, child;

          for (i = m; i < M - m; i++) {
              child = node.children[i];
              extend$2(leftBBox, node.leaf ? toBBox(child) : child);
              margin += bboxMargin(leftBBox);
          }

          for (i = M - m - 1; i >= m; i--) {
              child = node.children[i];
              extend$2(rightBBox, node.leaf ? toBBox(child) : child);
              margin += bboxMargin(rightBBox);
          }

          return margin;
      },

      _adjustParentBBoxes: function (bbox, path, level) {
          // adjust bboxes along the given tree path
          for (var i = level; i >= 0; i--) {
              extend$2(path[i], bbox);
          }
      },

      _condense: function (path) {
          // go through the path, removing empty nodes and updating bboxes
          for (var i = path.length - 1, siblings; i >= 0; i--) {
              if (path[i].children.length === 0) {
                  if (i > 0) {
                      siblings = path[i - 1].children;
                      siblings.splice(siblings.indexOf(path[i]), 1);

                  } else this.clear();

              } else calcBBox(path[i], this.toBBox);
          }
      },

      _initFormat: function (format) {
          // data format (minX, minY, maxX, maxY accessors)

          // uses eval-type function compilation instead of just accepting a toBBox function
          // because the algorithms are very sensitive to sorting functions performance,
          // so they should be dead simple and without inner calls

          var compareArr = ['return a', ' - b', ';'];

          this.compareMinX = new Function('a', 'b', compareArr.join(format[0]));
          this.compareMinY = new Function('a', 'b', compareArr.join(format[1]));

          this.toBBox = new Function('a',
              'return {minX: a' + format[0] +
              ', minY: a' + format[1] +
              ', maxX: a' + format[2] +
              ', maxY: a' + format[3] + '};');
      }
  };

  function findItem(item, items, equalsFn) {
      if (!equalsFn) return items.indexOf(item);

      for (var i = 0; i < items.length; i++) {
          if (equalsFn(item, items[i])) return i;
      }
      return -1;
  }

  // calculate node's bbox from bboxes of its children
  function calcBBox(node, toBBox) {
      distBBox(node, 0, node.children.length, toBBox, node);
  }

  // min bounding rectangle of node children from k to p-1
  function distBBox(node, k, p, toBBox, destNode) {
      if (!destNode) destNode = createNode(null);
      destNode.minX = Infinity;
      destNode.minY = Infinity;
      destNode.maxX = -Infinity;
      destNode.maxY = -Infinity;

      for (var i = k, child; i < p; i++) {
          child = node.children[i];
          extend$2(destNode, node.leaf ? toBBox(child) : child);
      }

      return destNode;
  }

  function extend$2(a, b) {
      a.minX = Math.min(a.minX, b.minX);
      a.minY = Math.min(a.minY, b.minY);
      a.maxX = Math.max(a.maxX, b.maxX);
      a.maxY = Math.max(a.maxY, b.maxY);
      return a;
  }

  function compareNodeMinX(a, b) { return a.minX - b.minX; }
  function compareNodeMinY(a, b) { return a.minY - b.minY; }

  function bboxArea(a)   { return (a.maxX - a.minX) * (a.maxY - a.minY); }
  function bboxMargin(a) { return (a.maxX - a.minX) + (a.maxY - a.minY); }

  function enlargedArea(a, b) {
      return (Math.max(b.maxX, a.maxX) - Math.min(b.minX, a.minX)) *
             (Math.max(b.maxY, a.maxY) - Math.min(b.minY, a.minY));
  }

  function intersectionArea(a, b) {
      var minX = Math.max(a.minX, b.minX),
          minY = Math.max(a.minY, b.minY),
          maxX = Math.min(a.maxX, b.maxX),
          maxY = Math.min(a.maxY, b.maxY);

      return Math.max(0, maxX - minX) *
             Math.max(0, maxY - minY);
  }

  function contains(a, b) {
      return a.minX <= b.minX &&
             a.minY <= b.minY &&
             b.maxX <= a.maxX &&
             b.maxY <= a.maxY;
  }

  function intersects$1(a, b) {
      return b.minX <= a.maxX &&
             b.minY <= a.maxY &&
             b.maxX >= a.minX &&
             b.maxY >= a.minY;
  }

  function createNode(children) {
      return {
          children: children,
          height: 1,
          leaf: true,
          minX: Infinity,
          minY: Infinity,
          maxX: -Infinity,
          maxY: -Infinity
      };
  }

  // sort an array so that items come in groups of n unsorted items, with groups sorted between each other;
  // combines selection algorithm with binary divide & conquer approach

  function multiSelect(arr, left, right, n, compare) {
      var stack = [left, right],
          mid;

      while (stack.length) {
          right = stack.pop();
          left = stack.pop();

          if (right - left <= n) continue;

          mid = left + Math.ceil((right - left) / n / 2) * n;
          quickselect$2(arr, mid, left, right, compare);

          stack.push(left, mid, mid, right);
      }
  }
  rbush_1.default = default_1;

  /**
   * @module ol/structs/RBush
   */

  /**
   * @typedef {Object} Entry
   * @property {number} minX
   * @property {number} minY
   * @property {number} maxX
   * @property {number} maxY
   * @property {Object} [value]
   */

  /**
   * @classdesc
   * Wrapper around the RBush by Vladimir Agafonkin.
   * See https://github.com/mourner/rbush.
   *
   * @template T
   */
  var RBush = function RBush(opt_maxEntries) {

    /**
     * @private
     */
    this.rbush_ = rbush_1(opt_maxEntries, undefined);

    /**
     * A mapping between the objects added to this rbush wrapper
     * and the objects that are actually added to the internal rbush.
     * @private
     * @type {Object<string, Entry>}
     */
    this.items_ = {};

  };

  /**
   * Insert a value into the RBush.
   * @param {import("../extent.js").Extent} extent Extent.
   * @param {T} value Value.
   */
  RBush.prototype.insert = function insert (extent, value) {
    /** @type {Entry} */
    var item = {
      minX: extent[0],
      minY: extent[1],
      maxX: extent[2],
      maxY: extent[3],
      value: value
    };

    this.rbush_.insert(item);
    this.items_[getUid(value)] = item;
  };


  /**
   * Bulk-insert values into the RBush.
   * @param {Array<import("../extent.js").Extent>} extents Extents.
   * @param {Array<T>} values Values.
   */
  RBush.prototype.load = function load (extents, values) {
    var items = new Array(values.length);
    for (var i = 0, l = values.length; i < l; i++) {
      var extent = extents[i];
      var value = values[i];

      /** @type {Entry} */
      var item = {
        minX: extent[0],
        minY: extent[1],
        maxX: extent[2],
        maxY: extent[3],
        value: value
      };
      items[i] = item;
      this.items_[getUid(value)] = item;
    }
    this.rbush_.load(items);
  };


  /**
   * Remove a value from the RBush.
   * @param {T} value Value.
   * @return {boolean} Removed.
   */
  RBush.prototype.remove = function remove (value) {
    var uid = getUid(value);

    // get the object in which the value was wrapped when adding to the
    // internal rbush. then use that object to do the removal.
    var item = this.items_[uid];
    delete this.items_[uid];
    return this.rbush_.remove(item) !== null;
  };


  /**
   * Update the extent of a value in the RBush.
   * @param {import("../extent.js").Extent} extent Extent.
   * @param {T} value Value.
   */
  RBush.prototype.update = function update (extent, value) {
    var item = this.items_[getUid(value)];
    var bbox = [item.minX, item.minY, item.maxX, item.maxY];
    if (!equals$2(bbox, extent)) {
      this.remove(value);
      this.insert(extent, value);
    }
  };


  /**
   * Return all values in the RBush.
   * @return {Array<T>} All.
   */
  RBush.prototype.getAll = function getAll () {
    var items = this.rbush_.all();
    return items.map(function(item) {
      return item.value;
    });
  };


  /**
   * Return all values in the given extent.
   * @param {import("../extent.js").Extent} extent Extent.
   * @return {Array<T>} All in extent.
   */
  RBush.prototype.getInExtent = function getInExtent (extent) {
    /** @type {Entry} */
    var bbox = {
      minX: extent[0],
      minY: extent[1],
      maxX: extent[2],
      maxY: extent[3]
    };
    var items = this.rbush_.search(bbox);
    return items.map(function(item) {
      return item.value;
    });
  };


  /**
   * Calls a callback function with each value in the tree.
   * If the callback returns a truthy value, this value is returned without
   * checking the rest of the tree.
   * @param {function(this: S, T): *} callback Callback.
   * @param {S=} opt_this The object to use as `this` in `callback`.
   * @return {*} Callback return value.
   * @template S
   */
  RBush.prototype.forEach = function forEach (callback, opt_this) {
    return this.forEach_(this.getAll(), callback, opt_this);
  };


  /**
   * Calls a callback function with each value in the provided extent.
   * @param {import("../extent.js").Extent} extent Extent.
   * @param {function(this: S, T): *} callback Callback.
   * @param {S=} opt_this The object to use as `this` in `callback`.
   * @return {*} Callback return value.
   * @template S
   */
  RBush.prototype.forEachInExtent = function forEachInExtent (extent, callback, opt_this) {
    return this.forEach_(this.getInExtent(extent), callback, opt_this);
  };


  /**
   * @param {Array<T>} values Values.
   * @param {function(this: S, T): *} callback Callback.
   * @param {S=} opt_this The object to use as `this` in `callback`.
   * @private
   * @return {*} Callback return value.
   * @template S
   */
  RBush.prototype.forEach_ = function forEach_ (values, callback, opt_this) {
    var result;
    for (var i = 0, l = values.length; i < l; i++) {
      result = callback.call(opt_this, values[i]);
      if (result) {
        return result;
      }
    }
    return result;
  };


  /**
   * @return {boolean} Is empty.
   */
  RBush.prototype.isEmpty = function isEmpty$1$$1 () {
    return isEmpty(this.items_);
  };


  /**
   * Remove all values from the RBush.
   */
  RBush.prototype.clear = function clear$$1 () {
    this.rbush_.clear();
    this.items_ = {};
  };


  /**
   * @param {import("../extent.js").Extent=} opt_extent Extent.
   * @return {import("../extent.js").Extent} Extent.
   */
  RBush.prototype.getExtent = function getExtent (opt_extent) {
    var data = this.rbush_.toJSON();
    return createOrUpdate(data.minX, data.minY, data.maxX, data.maxY, opt_extent);
  };


  /**
   * @param {RBush} rbush R-Tree.
   */
  RBush.prototype.concat = function concat (rbush) {
    this.rbush_.load(rbush.rbush_.all());
    for (var i in rbush.items_) {
      this.items_[i] = rbush.items_[i];
    }
  };

  /**
   * @module ol/source/Vector
   */

  /**
   * A function that takes an {@link module:ol/extent~Extent} and a resolution as arguments, and
   * returns an array of {@link module:ol/extent~Extent} with the extents to load. Usually this
   * is one of the standard {@link module:ol/loadingstrategy} strategies.
   *
   * @typedef {function(import("../extent.js").Extent, number): Array<import("../extent.js").Extent>} LoadingStrategy
   * @api
   */


  /**
   * @classdesc
   * Events emitted by {@link module:ol/source/Vector} instances are instances of this
   * type.
   */
  var VectorSourceEvent = /*@__PURE__*/(function (Event$$1) {
    function VectorSourceEvent(type, opt_feature) {

      Event$$1.call(this, type);

      /**
       * The feature being added or removed.
       * @type {import("../Feature.js").default|undefined}
       * @api
       */
      this.feature = opt_feature;

    }

    if ( Event$$1 ) VectorSourceEvent.__proto__ = Event$$1;
    VectorSourceEvent.prototype = Object.create( Event$$1 && Event$$1.prototype );
    VectorSourceEvent.prototype.constructor = VectorSourceEvent;

    return VectorSourceEvent;
  }(Event));


  /**
   * @typedef {Object} Options
   * @property {import("./Source.js").AttributionLike} [attributions] Attributions.
   * @property {Array<import("../Feature.js").default>|Collection<import("../Feature.js").default>} [features]
   * Features. If provided as {@link module:ol/Collection}, the features in the source
   * and the collection will stay in sync.
   * @property {import("../format/Feature.js").default} [format] The feature format used by the XHR
   * feature loader when `url` is set. Required if `url` is set, otherwise ignored.
   * @property {import("../featureloader.js").FeatureLoader} [loader]
   * The loader function used to load features, from a remote source for example.
   * If this is not set and `url` is set, the source will create and use an XHR
   * feature loader.
   *
   * Example:
   *
   * ```js
   * import {Vector} from 'ol/source';
   * import {GeoJSON} from 'ol/format';
   * import {bbox} from 'ol/loadingstrategy';
   *
   * var vectorSource = new Vector({
   *   format: new GeoJSON(),
   *   loader: function(extent, resolution, projection) {
   *      var proj = projection.getCode();
   *      var url = 'https://ahocevar.com/geoserver/wfs?service=WFS&' +
   *          'version=1.1.0&request=GetFeature&typename=osm:water_areas&' +
   *          'outputFormat=application/json&srsname=' + proj + '&' +
   *          'bbox=' + extent.join(',') + ',' + proj;
   *      var xhr = new XMLHttpRequest();
   *      xhr.open('GET', url);
   *      var onError = function() {
   *        vectorSource.removeLoadedExtent(extent);
   *      }
   *      xhr.onerror = onError;
   *      xhr.onload = function() {
   *        if (xhr.status == 200) {
   *          vectorSource.addFeatures(
   *              vectorSource.getFormat().readFeatures(xhr.responseText));
   *        } else {
   *          onError();
   *        }
   *      }
   *      xhr.send();
   *    },
   *    strategy: bbox
   *  });
   * ```
   * @property {boolean} [overlaps=true] This source may have overlapping geometries.
   * Setting this to `false` (e.g. for sources with polygons that represent administrative
   * boundaries or TopoJSON sources) allows the renderer to optimise fill and
   * stroke operations.
   * @property {LoadingStrategy} [strategy] The loading strategy to use.
   * By default an {@link module:ol/loadingstrategy~all}
   * strategy is used, a one-off strategy which loads all features at once.
   * @property {string|import("../featureloader.js").FeatureUrlFunction} [url]
   * Setting this option instructs the source to load features using an XHR loader
   * (see {@link module:ol/featureloader~xhr}). Use a `string` and an
   * {@link module:ol/loadingstrategy~all} for a one-off download of all features from
   * the given URL. Use a {@link module:ol/featureloader~FeatureUrlFunction} to generate the url with
   * other loading strategies.
   * Requires `format` to be set as well.
   * When default XHR feature loader is provided, the features will
   * be transformed from the data projection to the view projection
   * during parsing. If your remote data source does not advertise its projection
   * properly, this transformation will be incorrect. For some formats, the
   * default projection (usually EPSG:4326) can be overridden by setting the
   * dataProjection constructor option on the format.
   * Note that if a source contains non-feature data, such as a GeoJSON geometry
   * or a KML NetworkLink, these will be ignored. Use a custom loader to load these.
   * @property {boolean} [useSpatialIndex=true]
   * By default, an RTree is used as spatial index. When features are removed and
   * added frequently, and the total number of features is low, setting this to
   * `false` may improve performance.
   *
   * Note that
   * {@link module:ol/source/Vector~VectorSource#getFeaturesInExtent},
   * {@link module:ol/source/Vector~VectorSource#getClosestFeatureToCoordinate} and
   * {@link module:ol/source/Vector~VectorSource#getExtent} cannot be used when `useSpatialIndex` is
   * set to `false`, and {@link module:ol/source/Vector~VectorSource#forEachFeatureInExtent} will loop
   * through all features.
   *
   * When set to `false`, the features will be maintained in an
   * {@link module:ol/Collection}, which can be retrieved through
   * {@link module:ol/source/Vector~VectorSource#getFeaturesCollection}.
   * @property {boolean} [wrapX=true] Wrap the world horizontally. For vector editing across the
   * -180° and 180° meridians to work properly, this should be set to `false`. The
   * resulting geometry coordinates will then exceed the world bounds.
   */


  /**
   * @classdesc
   * Provides a source of features for vector layers. Vector features provided
   * by this source are suitable for editing. See {@link module:ol/source/VectorTile~VectorTile} for
   * vector data that is optimized for rendering.
   *
   * @fires ol/source/Vector.VectorSourceEvent
   * @api
   */
  var VectorSource = /*@__PURE__*/(function (Source$$1) {
    function VectorSource(opt_options) {

      var options = opt_options || {};

      Source$$1.call(this, {
        attributions: options.attributions,
        projection: undefined,
        state: SourceState.READY,
        wrapX: options.wrapX !== undefined ? options.wrapX : true
      });

      /**
       * @private
       * @type {import("../featureloader.js").FeatureLoader}
       */
      this.loader_ = VOID;

      /**
       * @private
       * @type {import("../format/Feature.js").default|undefined}
       */
      this.format_ = options.format;

      /**
       * @private
       * @type {boolean}
       */
      this.overlaps_ = options.overlaps == undefined ? true : options.overlaps;

      /**
       * @private
       * @type {string|import("../featureloader.js").FeatureUrlFunction|undefined}
       */
      this.url_ = options.url;

      if (options.loader !== undefined) {
        this.loader_ = options.loader;
      } else if (this.url_ !== undefined) {
        assert(this.format_, 7); // `format` must be set when `url` is set
        // create a XHR feature loader for "url" and "format"
        this.loader_ = xhr(this.url_, /** @type {import("../format/Feature.js").default} */ (this.format_));
      }

      /**
       * @private
       * @type {LoadingStrategy}
       */
      this.strategy_ = options.strategy !== undefined ? options.strategy : all;

      var useSpatialIndex =
          options.useSpatialIndex !== undefined ? options.useSpatialIndex : true;

      /**
       * @private
       * @type {RBush<import("../Feature.js").default>}
       */
      this.featuresRtree_ = useSpatialIndex ? new RBush() : null;

      /**
       * @private
       * @type {RBush<{extent: import("../extent.js").Extent}>}
       */
      this.loadedExtentsRtree_ = new RBush();

      /**
       * @private
       * @type {!Object<string, import("../Feature.js").default>}
       */
      this.nullGeometryFeatures_ = {};

      /**
       * A lookup of features by id (the return from feature.getId()).
       * @private
       * @type {!Object<string, import("../Feature.js").default>}
       */
      this.idIndex_ = {};

      /**
       * A lookup of features without id (keyed by getUid(feature)).
       * @private
       * @type {!Object<string, import("../Feature.js").default>}
       */
      this.undefIdIndex_ = {};

      /**
       * @private
       * @type {Object<string, Array<import("../events.js").EventsKey>>}
       */
      this.featureChangeKeys_ = {};

      /**
       * @private
       * @type {Collection<import("../Feature.js").default>}
       */
      this.featuresCollection_ = null;

      var collection, features;
      if (Array.isArray(options.features)) {
        features = options.features;
      } else if (options.features) {
        collection = options.features;
        features = collection.getArray();
      }
      if (!useSpatialIndex && collection === undefined) {
        collection = new Collection(features);
      }
      if (features !== undefined) {
        this.addFeaturesInternal(features);
      }
      if (collection !== undefined) {
        this.bindFeaturesCollection_(collection);
      }

    }

    if ( Source$$1 ) VectorSource.__proto__ = Source$$1;
    VectorSource.prototype = Object.create( Source$$1 && Source$$1.prototype );
    VectorSource.prototype.constructor = VectorSource;

    /**
     * Add a single feature to the source.  If you want to add a batch of features
     * at once, call {@link module:ol/source/Vector~VectorSource#addFeatures #addFeatures()}
     * instead. A feature will not be added to the source if feature with
     * the same id is already there. The reason for this behavior is to avoid
     * feature duplication when using bbox or tile loading strategies.
     * @param {import("../Feature.js").default} feature Feature to add.
     * @api
     */
    VectorSource.prototype.addFeature = function addFeature (feature) {
      this.addFeatureInternal(feature);
      this.changed();
    };


    /**
     * Add a feature without firing a `change` event.
     * @param {import("../Feature.js").default} feature Feature.
     * @protected
     */
    VectorSource.prototype.addFeatureInternal = function addFeatureInternal (feature) {
      var featureKey = getUid(feature);

      if (!this.addToIndex_(featureKey, feature)) {
        return;
      }

      this.setupChangeEvents_(featureKey, feature);

      var geometry = feature.getGeometry();
      if (geometry) {
        var extent = geometry.getExtent();
        if (this.featuresRtree_) {
          this.featuresRtree_.insert(extent, feature);
        }
      } else {
        this.nullGeometryFeatures_[featureKey] = feature;
      }

      this.dispatchEvent(
        new VectorSourceEvent(VectorEventType.ADDFEATURE, feature));
    };


    /**
     * @param {string} featureKey Unique identifier for the feature.
     * @param {import("../Feature.js").default} feature The feature.
     * @private
     */
    VectorSource.prototype.setupChangeEvents_ = function setupChangeEvents_ (featureKey, feature) {
      this.featureChangeKeys_[featureKey] = [
        listen(feature, EventType.CHANGE,
          this.handleFeatureChange_, this),
        listen(feature, ObjectEventType.PROPERTYCHANGE,
          this.handleFeatureChange_, this)
      ];
    };


    /**
     * @param {string} featureKey Unique identifier for the feature.
     * @param {import("../Feature.js").default} feature The feature.
     * @return {boolean} The feature is "valid", in the sense that it is also a
     *     candidate for insertion into the Rtree.
     * @private
     */
    VectorSource.prototype.addToIndex_ = function addToIndex_ (featureKey, feature) {
      var valid = true;
      var id = feature.getId();
      if (id !== undefined) {
        if (!(id.toString() in this.idIndex_)) {
          this.idIndex_[id.toString()] = feature;
        } else {
          valid = false;
        }
      } else {
        assert(!(featureKey in this.undefIdIndex_),
          30); // The passed `feature` was already added to the source
        this.undefIdIndex_[featureKey] = feature;
      }
      return valid;
    };


    /**
     * Add a batch of features to the source.
     * @param {Array<import("../Feature.js").default>} features Features to add.
     * @api
     */
    VectorSource.prototype.addFeatures = function addFeatures (features) {
      this.addFeaturesInternal(features);
      this.changed();
    };


    /**
     * Add features without firing a `change` event.
     * @param {Array<import("../Feature.js").default>} features Features.
     * @protected
     */
    VectorSource.prototype.addFeaturesInternal = function addFeaturesInternal (features) {
      var extents = [];
      var newFeatures = [];
      var geometryFeatures = [];

      for (var i = 0, length = features.length; i < length; i++) {
        var feature = features[i];
        var featureKey = getUid(feature);
        if (this.addToIndex_(featureKey, feature)) {
          newFeatures.push(feature);
        }
      }

      for (var i$1 = 0, length$1 = newFeatures.length; i$1 < length$1; i$1++) {
        var feature$1 = newFeatures[i$1];
        var featureKey$1 = getUid(feature$1);
        this.setupChangeEvents_(featureKey$1, feature$1);

        var geometry = feature$1.getGeometry();
        if (geometry) {
          var extent = geometry.getExtent();
          extents.push(extent);
          geometryFeatures.push(feature$1);
        } else {
          this.nullGeometryFeatures_[featureKey$1] = feature$1;
        }
      }
      if (this.featuresRtree_) {
        this.featuresRtree_.load(extents, geometryFeatures);
      }

      for (var i$2 = 0, length$2 = newFeatures.length; i$2 < length$2; i$2++) {
        this.dispatchEvent(new VectorSourceEvent(VectorEventType.ADDFEATURE, newFeatures[i$2]));
      }
    };


    /**
     * @param {!Collection<import("../Feature.js").default>} collection Collection.
     * @private
     */
    VectorSource.prototype.bindFeaturesCollection_ = function bindFeaturesCollection_ (collection) {
      var modifyingCollection = false;
      listen(this, VectorEventType.ADDFEATURE,
        /**
         * @param {VectorSourceEvent} evt The vector source event
         */
        function(evt) {
          if (!modifyingCollection) {
            modifyingCollection = true;
            collection.push(evt.feature);
            modifyingCollection = false;
          }
        });
      listen(this, VectorEventType.REMOVEFEATURE,
        /**
         * @param {VectorSourceEvent} evt The vector source event
         */
        function(evt) {
          if (!modifyingCollection) {
            modifyingCollection = true;
            collection.remove(evt.feature);
            modifyingCollection = false;
          }
        });
      listen(collection, CollectionEventType.ADD,
        /**
         * @param {import("../Collection.js").CollectionEvent} evt The collection event
         */
        function(evt) {
          if (!modifyingCollection) {
            modifyingCollection = true;
            this.addFeature(/** @type {import("../Feature.js").default} */ (evt.element));
            modifyingCollection = false;
          }
        }, this);
      listen(collection, CollectionEventType.REMOVE,
        /**
         * @param {import("../Collection.js").CollectionEvent} evt The collection event
         */
        function(evt) {
          if (!modifyingCollection) {
            modifyingCollection = true;
            this.removeFeature(/** @type {import("../Feature.js").default} */ (evt.element));
            modifyingCollection = false;
          }
        }, this);
      this.featuresCollection_ = collection;
    };


    /**
     * Remove all features from the source.
     * @param {boolean=} opt_fast Skip dispatching of {@link module:ol/source/Vector.VectorSourceEvent#removefeature} events.
     * @api
     */
    VectorSource.prototype.clear = function clear$$1 (opt_fast) {
      if (opt_fast) {
        for (var featureId in this.featureChangeKeys_) {
          var keys = this.featureChangeKeys_[featureId];
          keys.forEach(unlistenByKey);
        }
        if (!this.featuresCollection_) {
          this.featureChangeKeys_ = {};
          this.idIndex_ = {};
          this.undefIdIndex_ = {};
        }
      } else {
        if (this.featuresRtree_) {
          this.featuresRtree_.forEach(this.removeFeatureInternal, this);
          for (var id in this.nullGeometryFeatures_) {
            this.removeFeatureInternal(this.nullGeometryFeatures_[id]);
          }
        }
      }
      if (this.featuresCollection_) {
        this.featuresCollection_.clear();
      }

      if (this.featuresRtree_) {
        this.featuresRtree_.clear();
      }
      this.loadedExtentsRtree_.clear();
      this.nullGeometryFeatures_ = {};

      var clearEvent = new VectorSourceEvent(VectorEventType.CLEAR);
      this.dispatchEvent(clearEvent);
      this.changed();
    };


    /**
     * Iterate through all features on the source, calling the provided callback
     * with each one.  If the callback returns any "truthy" value, iteration will
     * stop and the function will return the same value.
     * Note: this function only iterate through the feature that have a defined geometry.
     *
     * @param {function(import("../Feature.js").default): T} callback Called with each feature
     *     on the source.  Return a truthy value to stop iteration.
     * @return {T|undefined} The return value from the last call to the callback.
     * @template T
     * @api
     */
    VectorSource.prototype.forEachFeature = function forEachFeature (callback) {
      if (this.featuresRtree_) {
        return this.featuresRtree_.forEach(callback);
      } else if (this.featuresCollection_) {
        this.featuresCollection_.forEach(callback);
      }
    };


    /**
     * Iterate through all features whose geometries contain the provided
     * coordinate, calling the callback with each feature.  If the callback returns
     * a "truthy" value, iteration will stop and the function will return the same
     * value.
     *
     * @param {import("../coordinate.js").Coordinate} coordinate Coordinate.
     * @param {function(import("../Feature.js").default): T} callback Called with each feature
     *     whose goemetry contains the provided coordinate.
     * @return {T|undefined} The return value from the last call to the callback.
     * @template T
     */
    VectorSource.prototype.forEachFeatureAtCoordinateDirect = function forEachFeatureAtCoordinateDirect (coordinate, callback) {
      var extent = [coordinate[0], coordinate[1], coordinate[0], coordinate[1]];
      return this.forEachFeatureInExtent(extent, function(feature) {
        var geometry = feature.getGeometry();
        if (geometry.intersectsCoordinate(coordinate)) {
          return callback(feature);
        } else {
          return undefined;
        }
      });
    };


    /**
     * Iterate through all features whose bounding box intersects the provided
     * extent (note that the feature's geometry may not intersect the extent),
     * calling the callback with each feature.  If the callback returns a "truthy"
     * value, iteration will stop and the function will return the same value.
     *
     * If you are interested in features whose geometry intersects an extent, call
     * the {@link module:ol/source/Vector~VectorSource#forEachFeatureIntersectingExtent #forEachFeatureIntersectingExtent()} method instead.
     *
     * When `useSpatialIndex` is set to false, this method will loop through all
     * features, equivalent to {@link module:ol/source/Vector~VectorSource#forEachFeature #forEachFeature()}.
     *
     * @param {import("../extent.js").Extent} extent Extent.
     * @param {function(import("../Feature.js").default): T} callback Called with each feature
     *     whose bounding box intersects the provided extent.
     * @return {T|undefined} The return value from the last call to the callback.
     * @template T
     * @api
     */
    VectorSource.prototype.forEachFeatureInExtent = function forEachFeatureInExtent (extent, callback) {
      if (this.featuresRtree_) {
        return this.featuresRtree_.forEachInExtent(extent, callback);
      } else if (this.featuresCollection_) {
        this.featuresCollection_.forEach(callback);
      }
    };


    /**
     * Iterate through all features whose geometry intersects the provided extent,
     * calling the callback with each feature.  If the callback returns a "truthy"
     * value, iteration will stop and the function will return the same value.
     *
     * If you only want to test for bounding box intersection, call the
     * {@link module:ol/source/Vector~VectorSource#forEachFeatureInExtent #forEachFeatureInExtent()} method instead.
     *
     * @param {import("../extent.js").Extent} extent Extent.
     * @param {function(import("../Feature.js").default): T} callback Called with each feature
     *     whose geometry intersects the provided extent.
     * @return {T|undefined} The return value from the last call to the callback.
     * @template T
     * @api
     */
    VectorSource.prototype.forEachFeatureIntersectingExtent = function forEachFeatureIntersectingExtent (extent, callback) {
      return this.forEachFeatureInExtent(extent,
        /**
         * @param {import("../Feature.js").default} feature Feature.
         * @return {T|undefined} The return value from the last call to the callback.
         */
        function(feature) {
          var geometry = feature.getGeometry();
          if (geometry.intersectsExtent(extent)) {
            var result = callback(feature);
            if (result) {
              return result;
            }
          }
        });
    };


    /**
     * Get the features collection associated with this source. Will be `null`
     * unless the source was configured with `useSpatialIndex` set to `false`, or
     * with an {@link module:ol/Collection} as `features`.
     * @return {Collection<import("../Feature.js").default>} The collection of features.
     * @api
     */
    VectorSource.prototype.getFeaturesCollection = function getFeaturesCollection () {
      return this.featuresCollection_;
    };


    /**
     * Get all features on the source in random order.
     * @return {Array<import("../Feature.js").default>} Features.
     * @api
     */
    VectorSource.prototype.getFeatures = function getFeatures () {
      var features;
      if (this.featuresCollection_) {
        features = this.featuresCollection_.getArray();
      } else if (this.featuresRtree_) {
        features = this.featuresRtree_.getAll();
        if (!isEmpty(this.nullGeometryFeatures_)) {
          extend(features, getValues(this.nullGeometryFeatures_));
        }
      }
      return (
        /** @type {Array<import("../Feature.js").default>} */ (features)
      );
    };


    /**
     * Get all features whose geometry intersects the provided coordinate.
     * @param {import("../coordinate.js").Coordinate} coordinate Coordinate.
     * @return {Array<import("../Feature.js").default>} Features.
     * @api
     */
    VectorSource.prototype.getFeaturesAtCoordinate = function getFeaturesAtCoordinate (coordinate) {
      var features = [];
      this.forEachFeatureAtCoordinateDirect(coordinate, function(feature) {
        features.push(feature);
      });
      return features;
    };


    /**
     * Get all features in the provided extent.  Note that this returns an array of
     * all features intersecting the given extent in random order (so it may include
     * features whose geometries do not intersect the extent).
     *
     * This method is not available when the source is configured with
     * `useSpatialIndex` set to `false`.
     * @param {import("../extent.js").Extent} extent Extent.
     * @return {Array<import("../Feature.js").default>} Features.
     * @api
     */
    VectorSource.prototype.getFeaturesInExtent = function getFeaturesInExtent (extent) {
      return this.featuresRtree_.getInExtent(extent);
    };


    /**
     * Get the closest feature to the provided coordinate.
     *
     * This method is not available when the source is configured with
     * `useSpatialIndex` set to `false`.
     * @param {import("../coordinate.js").Coordinate} coordinate Coordinate.
     * @param {function(import("../Feature.js").default):boolean=} opt_filter Feature filter function.
     *     The filter function will receive one argument, the {@link module:ol/Feature feature}
     *     and it should return a boolean value. By default, no filtering is made.
     * @return {import("../Feature.js").default} Closest feature.
     * @api
     */
    VectorSource.prototype.getClosestFeatureToCoordinate = function getClosestFeatureToCoordinate (coordinate, opt_filter) {
      // Find the closest feature using branch and bound.  We start searching an
      // infinite extent, and find the distance from the first feature found.  This
      // becomes the closest feature.  We then compute a smaller extent which any
      // closer feature must intersect.  We continue searching with this smaller
      // extent, trying to find a closer feature.  Every time we find a closer
      // feature, we update the extent being searched so that any even closer
      // feature must intersect it.  We continue until we run out of features.
      var x = coordinate[0];
      var y = coordinate[1];
      var closestFeature = null;
      var closestPoint = [NaN, NaN];
      var minSquaredDistance = Infinity;
      var extent = [-Infinity, -Infinity, Infinity, Infinity];
      var filter = opt_filter ? opt_filter : TRUE;
      this.featuresRtree_.forEachInExtent(extent,
        /**
         * @param {import("../Feature.js").default} feature Feature.
         */
        function(feature) {
          if (filter(feature)) {
            var geometry = feature.getGeometry();
            var previousMinSquaredDistance = minSquaredDistance;
            minSquaredDistance = geometry.closestPointXY(
              x, y, closestPoint, minSquaredDistance);
            if (minSquaredDistance < previousMinSquaredDistance) {
              closestFeature = feature;
              // This is sneaky.  Reduce the extent that it is currently being
              // searched while the R-Tree traversal using this same extent object
              // is still in progress.  This is safe because the new extent is
              // strictly contained by the old extent.
              var minDistance = Math.sqrt(minSquaredDistance);
              extent[0] = x - minDistance;
              extent[1] = y - minDistance;
              extent[2] = x + minDistance;
              extent[3] = y + minDistance;
            }
          }
        });
      return closestFeature;
    };


    /**
     * Get the extent of the features currently in the source.
     *
     * This method is not available when the source is configured with
     * `useSpatialIndex` set to `false`.
     * @param {import("../extent.js").Extent=} opt_extent Destination extent. If provided, no new extent
     *     will be created. Instead, that extent's coordinates will be overwritten.
     * @return {import("../extent.js").Extent} Extent.
     * @api
     */
    VectorSource.prototype.getExtent = function getExtent (opt_extent) {
      return this.featuresRtree_.getExtent(opt_extent);
    };


    /**
     * Get a feature by its identifier (the value returned by feature.getId()).
     * Note that the index treats string and numeric identifiers as the same.  So
     * `source.getFeatureById(2)` will return a feature with id `'2'` or `2`.
     *
     * @param {string|number} id Feature identifier.
     * @return {import("../Feature.js").default} The feature (or `null` if not found).
     * @api
     */
    VectorSource.prototype.getFeatureById = function getFeatureById (id) {
      var feature = this.idIndex_[id.toString()];
      return feature !== undefined ? feature : null;
    };


    /**
     * Get the format associated with this source.
     *
     * @return {import("../format/Feature.js").default|undefined} The feature format.
     * @api
     */
    VectorSource.prototype.getFormat = function getFormat () {
      return this.format_;
    };


    /**
     * @return {boolean} The source can have overlapping geometries.
     */
    VectorSource.prototype.getOverlaps = function getOverlaps () {
      return this.overlaps_;
    };


    /**
     * Get the url associated with this source.
     *
     * @return {string|import("../featureloader.js").FeatureUrlFunction|undefined} The url.
     * @api
     */
    VectorSource.prototype.getUrl = function getUrl () {
      return this.url_;
    };


    /**
     * @param {Event} event Event.
     * @private
     */
    VectorSource.prototype.handleFeatureChange_ = function handleFeatureChange_ (event) {
      var feature = /** @type {import("../Feature.js").default} */ (event.target);
      var featureKey = getUid(feature);
      var geometry = feature.getGeometry();
      if (!geometry) {
        if (!(featureKey in this.nullGeometryFeatures_)) {
          if (this.featuresRtree_) {
            this.featuresRtree_.remove(feature);
          }
          this.nullGeometryFeatures_[featureKey] = feature;
        }
      } else {
        var extent = geometry.getExtent();
        if (featureKey in this.nullGeometryFeatures_) {
          delete this.nullGeometryFeatures_[featureKey];
          if (this.featuresRtree_) {
            this.featuresRtree_.insert(extent, feature);
          }
        } else {
          if (this.featuresRtree_) {
            this.featuresRtree_.update(extent, feature);
          }
        }
      }
      var id = feature.getId();
      if (id !== undefined) {
        var sid = id.toString();
        if (featureKey in this.undefIdIndex_) {
          delete this.undefIdIndex_[featureKey];
          this.idIndex_[sid] = feature;
        } else {
          if (this.idIndex_[sid] !== feature) {
            this.removeFromIdIndex_(feature);
            this.idIndex_[sid] = feature;
          }
        }
      } else {
        if (!(featureKey in this.undefIdIndex_)) {
          this.removeFromIdIndex_(feature);
          this.undefIdIndex_[featureKey] = feature;
        }
      }
      this.changed();
      this.dispatchEvent(new VectorSourceEvent(
        VectorEventType.CHANGEFEATURE, feature));
    };

    /**
     * Returns true if the feature is contained within the source.
     * @param {import("../Feature.js").default} feature Feature.
     * @return {boolean} Has feature.
     * @api
     */
    VectorSource.prototype.hasFeature = function hasFeature (feature) {
      var id = feature.getId();
      if (id !== undefined) {
        return id in this.idIndex_;
      } else {
        return getUid(feature) in this.undefIdIndex_;
      }
    };

    /**
     * @return {boolean} Is empty.
     */
    VectorSource.prototype.isEmpty = function isEmpty$1$$1 () {
      return this.featuresRtree_.isEmpty() && isEmpty(this.nullGeometryFeatures_);
    };


    /**
     * @param {import("../extent.js").Extent} extent Extent.
     * @param {number} resolution Resolution.
     * @param {import("../proj/Projection.js").default} projection Projection.
     */
    VectorSource.prototype.loadFeatures = function loadFeatures (extent, resolution, projection) {
      var this$1 = this;

      var loadedExtentsRtree = this.loadedExtentsRtree_;
      var extentsToLoad = this.strategy_(extent, resolution);
      this.loading = false;
      var loop = function ( i, ii ) {
        var extentToLoad = extentsToLoad[i];
        var alreadyLoaded = loadedExtentsRtree.forEachInExtent(extentToLoad,
          /**
           * @param {{extent: import("../extent.js").Extent}} object Object.
           * @return {boolean} Contains.
           */
          function(object) {
            return containsExtent(object.extent, extentToLoad);
          });
        if (!alreadyLoaded) {
          this$1.loader_.call(this$1, extentToLoad, resolution, projection);
          loadedExtentsRtree.insert(extentToLoad, {extent: extentToLoad.slice()});
          this$1.loading = this$1.loader_ !== VOID;
        }
      };

      for (var i = 0, ii = extentsToLoad.length; i < ii; ++i) loop( i, ii );
    };


    /**
     * Remove an extent from the list of loaded extents.
     * @param {import("../extent.js").Extent} extent Extent.
     * @api
     */
    VectorSource.prototype.removeLoadedExtent = function removeLoadedExtent (extent) {
      var loadedExtentsRtree = this.loadedExtentsRtree_;
      var obj;
      loadedExtentsRtree.forEachInExtent(extent, function(object) {
        if (equals$2(object.extent, extent)) {
          obj = object;
          return true;
        }
      });
      if (obj) {
        loadedExtentsRtree.remove(obj);
      }
    };


    /**
     * Remove a single feature from the source.  If you want to remove all features
     * at once, use the {@link module:ol/source/Vector~VectorSource#clear #clear()} method
     * instead.
     * @param {import("../Feature.js").default} feature Feature to remove.
     * @api
     */
    VectorSource.prototype.removeFeature = function removeFeature (feature) {
      var featureKey = getUid(feature);
      if (featureKey in this.nullGeometryFeatures_) {
        delete this.nullGeometryFeatures_[featureKey];
      } else {
        if (this.featuresRtree_) {
          this.featuresRtree_.remove(feature);
        }
      }
      this.removeFeatureInternal(feature);
      this.changed();
    };


    /**
     * Remove feature without firing a `change` event.
     * @param {import("../Feature.js").default} feature Feature.
     * @protected
     */
    VectorSource.prototype.removeFeatureInternal = function removeFeatureInternal (feature) {
      var featureKey = getUid(feature);
      this.featureChangeKeys_[featureKey].forEach(unlistenByKey);
      delete this.featureChangeKeys_[featureKey];
      var id = feature.getId();
      if (id !== undefined) {
        delete this.idIndex_[id.toString()];
      } else {
        delete this.undefIdIndex_[featureKey];
      }
      this.dispatchEvent(new VectorSourceEvent(
        VectorEventType.REMOVEFEATURE, feature));
    };


    /**
     * Remove a feature from the id index.  Called internally when the feature id
     * may have changed.
     * @param {import("../Feature.js").default} feature The feature.
     * @return {boolean} Removed the feature from the index.
     * @private
     */
    VectorSource.prototype.removeFromIdIndex_ = function removeFromIdIndex_ (feature) {
      var removed = false;
      for (var id in this.idIndex_) {
        if (this.idIndex_[id] === feature) {
          delete this.idIndex_[id];
          removed = true;
          break;
        }
      }
      return removed;
    };


    /**
     * Set the new loader of the source. The next loadFeatures call will use the
     * new loader.
     * @param {import("../featureloader.js").FeatureLoader} loader The loader to set.
     * @api
     */
    VectorSource.prototype.setLoader = function setLoader (loader) {
      this.loader_ = loader;
    };

    return VectorSource;
  }(Source));

  /**
   * @module ol/interaction/Draw
   */


  /**
   * @typedef {Object} Options
   * @property {GeometryType} type Geometry type of
   * the geometries being drawn with this instance.
   * @property {number} [clickTolerance=6] The maximum distance in pixels between
   * "down" and "up" for a "up" event to be considered a "click" event and
   * actually add a point/vertex to the geometry being drawn.  The default of `6`
   * was chosen for the draw interaction to behave correctly on mouse as well as
   * on touch devices.
   * @property {import("../Collection.js").default<Feature>} [features]
   * Destination collection for the drawn features.
   * @property {VectorSource} [source] Destination source for
   * the drawn features.
   * @property {number} [dragVertexDelay=500] Delay in milliseconds after pointerdown
   * before the current vertex can be dragged to its exact position.
   * @property {number} [snapTolerance=12] Pixel distance for snapping to the
   * drawing finish.
   * @property {boolean} [stopClick=false] Stop click, singleclick, and
   * doubleclick events from firing during drawing.
   * @property {number} [maxPoints] The number of points that can be drawn before
   * a polygon ring or line string is finished. By default there is no
   * restriction.
   * @property {number} [minPoints] The number of points that must be drawn
   * before a polygon ring or line string can be finished. Default is `3` for
   * polygon rings and `2` for line strings.
   * @property {import("../events/condition.js").Condition} [finishCondition] A function
   * that takes an {@link module:ol/MapBrowserEvent~MapBrowserEvent} and returns a
   * boolean to indicate whether the drawing can be finished.
   * @property {import("../style/Style.js").StyleLike} [style]
   * Style for sketch features.
   * @property {GeometryFunction} [geometryFunction]
   * Function that is called when a geometry's coordinates are updated.
   * @property {string} [geometryName] Geometry name to use for features created
   * by the draw interaction.
   * @property {import("../events/condition.js").Condition} [condition] A function that
   * takes an {@link module:ol/MapBrowserEvent~MapBrowserEvent} and returns a
   * boolean to indicate whether that event should be handled.
   * By default {@link module:ol/events/condition~noModifierKeys}, i.e. a click,
   * adds a vertex or deactivates freehand drawing.
   * @property {boolean} [freehand=false] Operate in freehand mode for lines,
   * polygons, and circles.  This makes the interaction always operate in freehand
   * mode and takes precedence over any `freehandCondition` option.
   * @property {import("../events/condition.js").Condition} [freehandCondition]
   * Condition that activates freehand drawing for lines and polygons. This
   * function takes an {@link module:ol/MapBrowserEvent~MapBrowserEvent} and
   * returns a boolean to indicate whether that event should be handled. The
   * default is {@link module:ol/events/condition~shiftKeyOnly}, meaning that the
   * Shift key activates freehand drawing.
   * @property {boolean} [wrapX=false] Wrap the world horizontally on the sketch
   * overlay.
   */


  /**
   * Coordinate type when drawing points.
   * @typedef {import("../coordinate.js").Coordinate} PointCoordType
   */


  /**
   * Coordinate type when drawing lines.
   * @typedef {Array<import("../coordinate.js").Coordinate>} LineCoordType
   */


  /**
   * Coordinate type when drawing polygons.
   * @typedef {Array<Array<import("../coordinate.js").Coordinate>>} PolyCoordType
   */


  /**
   * Types used for drawing coordinates.
   * @typedef {PointCoordType|LineCoordType|PolyCoordType} SketchCoordType
   */


  /**
   * Function that takes an array of coordinates and an optional existing geometry as
   * arguments, and returns a geometry. The optional existing geometry is the
   * geometry that is returned when the function is called without a second
   * argument.
   * @typedef {function(!SketchCoordType, import("../geom/SimpleGeometry.js").default=):
   *     import("../geom/SimpleGeometry.js").default} GeometryFunction
   */


  /**
   * Draw mode.  This collapses multi-part geometry types with their single-part
   * cousins.
   * @enum {string}
   */
  var Mode$1 = {
    POINT: 'Point',
    LINE_STRING: 'LineString',
    POLYGON: 'Polygon',
    CIRCLE: 'Circle'
  };


  /**
   * @enum {string}
   */
  var DrawEventType = {
    /**
     * Triggered upon feature draw start
     * @event DrawEvent#drawstart
     * @api
     */
    DRAWSTART: 'drawstart',
    /**
     * Triggered upon feature draw end
     * @event DrawEvent#drawend
     * @api
     */
    DRAWEND: 'drawend'
  };


  /**
   * @classdesc
   * Events emitted by {@link module:ol/interaction/Draw~Draw} instances are
   * instances of this type.
   */
  var DrawEvent = /*@__PURE__*/(function (Event$$1) {
    function DrawEvent(type, feature) {

      Event$$1.call(this, type);

      /**
       * The feature being drawn.
       * @type {Feature}
       * @api
       */
      this.feature = feature;

    }

    if ( Event$$1 ) DrawEvent.__proto__ = Event$$1;
    DrawEvent.prototype = Object.create( Event$$1 && Event$$1.prototype );
    DrawEvent.prototype.constructor = DrawEvent;

    return DrawEvent;
  }(Event));


  /**
   * @classdesc
   * Interaction for drawing feature geometries.
   *
   * @fires DrawEvent
   * @api
   */
  var Draw = /*@__PURE__*/(function (PointerInteraction$$1) {
    function Draw(options) {

      var pointerOptions = /** @type {import("./Pointer.js").Options} */ (options);
      if (!pointerOptions.stopDown) {
        pointerOptions.stopDown = FALSE;
      }

      PointerInteraction$$1.call(this, pointerOptions);

      /**
       * @type {boolean}
       * @private
       */
      this.shouldHandle_ = false;

      /**
       * @type {import("../pixel.js").Pixel}
       * @private
       */
      this.downPx_ = null;

      /**
       * @type {?}
       * @private
       */
      this.downTimeout_;

      /**
       * @type {number|undefined}
       * @private
       */
      this.lastDragTime_;

      /**
       * @type {boolean}
       * @private
       */
      this.freehand_ = false;

      /**
       * Target source for drawn features.
       * @type {VectorSource}
       * @private
       */
      this.source_ = options.source ? options.source : null;

      /**
       * Target collection for drawn features.
       * @type {import("../Collection.js").default<Feature>}
       * @private
       */
      this.features_ = options.features ? options.features : null;

      /**
       * Pixel distance for snapping.
       * @type {number}
       * @private
       */
      this.snapTolerance_ = options.snapTolerance ? options.snapTolerance : 12;

      /**
       * Geometry type.
       * @type {GeometryType}
       * @private
       */
      this.type_ = /** @type {GeometryType} */ (options.type);

      /**
       * Drawing mode (derived from geometry type.
       * @type {Mode}
       * @private
       */
      this.mode_ = getMode(this.type_);

      /**
       * Stop click, singleclick, and doubleclick events from firing during drawing.
       * Default is `false`.
       * @type {boolean}
       * @private
       */
      this.stopClick_ = !!options.stopClick;

      /**
       * The number of points that must be drawn before a polygon ring or line
       * string can be finished.  The default is 3 for polygon rings and 2 for
       * line strings.
       * @type {number}
       * @private
       */
      this.minPoints_ = options.minPoints ?
        options.minPoints :
        (this.mode_ === Mode$1.POLYGON ? 3 : 2);

      /**
       * The number of points that can be drawn before a polygon ring or line string
       * is finished. The default is no restriction.
       * @type {number}
       * @private
       */
      this.maxPoints_ = options.maxPoints ? options.maxPoints : Infinity;

      /**
       * A function to decide if a potential finish coordinate is permissible
       * @private
       * @type {import("../events/condition.js").Condition}
       */
      this.finishCondition_ = options.finishCondition ? options.finishCondition : TRUE;

      var geometryFunction = options.geometryFunction;
      if (!geometryFunction) {
        if (this.type_ === GeometryType.CIRCLE) {
          /**
           * @param {!LineCoordType} coordinates The coordinates.
           * @param {import("../geom/SimpleGeometry.js").default=} opt_geometry Optional geometry.
           * @return {import("../geom/SimpleGeometry.js").default} A geometry.
           */
          geometryFunction = function(coordinates, opt_geometry) {
            var circle = opt_geometry ? /** @type {Circle} */ (opt_geometry) :
              new Circle([NaN, NaN]);
            var squaredLength = squaredDistance$1(
              coordinates[0], coordinates[1]);
            circle.setCenterAndRadius(coordinates[0], Math.sqrt(squaredLength));
            return circle;
          };
        } else {
          var Constructor;
          var mode = this.mode_;
          if (mode === Mode$1.POINT) {
            Constructor = Point;
          } else if (mode === Mode$1.LINE_STRING) {
            Constructor = LineString;
          } else if (mode === Mode$1.POLYGON) {
            Constructor = Polygon;
          }
          /**
           * @param {!LineCoordType} coordinates The coordinates.
           * @param {import("../geom/SimpleGeometry.js").default=} opt_geometry Optional geometry.
           * @return {import("../geom/SimpleGeometry.js").default} A geometry.
           */
          geometryFunction = function(coordinates, opt_geometry) {
            var geometry = opt_geometry;
            if (geometry) {
              if (mode === Mode$1.POLYGON) {
                if (coordinates[0].length) {
                  // Add a closing coordinate to match the first
                  geometry.setCoordinates([coordinates[0].concat([coordinates[0][0]])]);
                } else {
                  geometry.setCoordinates([]);
                }
              } else {
                geometry.setCoordinates(coordinates);
              }
            } else {
              geometry = new Constructor(coordinates);
            }
            return geometry;
          };
        }
      }

      /**
       * @type {GeometryFunction}
       * @private
       */
      this.geometryFunction_ = geometryFunction;

      /**
       * @type {number}
       * @private
       */
      this.dragVertexDelay_ = options.dragVertexDelay !== undefined ? options.dragVertexDelay : 500;

      /**
       * Finish coordinate for the feature (first point for polygons, last point for
       * linestrings).
       * @type {import("../coordinate.js").Coordinate}
       * @private
       */
      this.finishCoordinate_ = null;

      /**
       * Sketch feature.
       * @type {Feature}
       * @private
       */
      this.sketchFeature_ = null;

      /**
       * Sketch point.
       * @type {Feature}
       * @private
       */
      this.sketchPoint_ = null;

      /**
       * Sketch coordinates. Used when drawing a line or polygon.
       * @type {SketchCoordType}
       * @private
       */
      this.sketchCoords_ = null;

      /**
       * Sketch line. Used when drawing polygon.
       * @type {Feature}
       * @private
       */
      this.sketchLine_ = null;

      /**
       * Sketch line coordinates. Used when drawing a polygon or circle.
       * @type {LineCoordType}
       * @private
       */
      this.sketchLineCoords_ = null;

      /**
       * Squared tolerance for handling up events.  If the squared distance
       * between a down and up event is greater than this tolerance, up events
       * will not be handled.
       * @type {number}
       * @private
       */
      this.squaredClickTolerance_ = options.clickTolerance ?
        options.clickTolerance * options.clickTolerance : 36;

      /**
       * Draw overlay where our sketch features are drawn.
       * @type {VectorLayer}
       * @private
       */
      this.overlay_ = new VectorLayer({
        source: new VectorSource({
          useSpatialIndex: false,
          wrapX: options.wrapX ? options.wrapX : false
        }),
        style: options.style ? options.style :
          getDefaultStyleFunction(),
        updateWhileInteracting: true
      });

      /**
       * Name of the geometry attribute for newly created features.
       * @type {string|undefined}
       * @private
       */
      this.geometryName_ = options.geometryName;

      /**
       * @private
       * @type {import("../events/condition.js").Condition}
       */
      this.condition_ = options.condition ? options.condition : noModifierKeys;

      /**
       * @private
       * @type {import("../events/condition.js").Condition}
       */
      this.freehandCondition_;
      if (options.freehand) {
        this.freehandCondition_ = always;
      } else {
        this.freehandCondition_ = options.freehandCondition ?
          options.freehandCondition : shiftKeyOnly;
      }

      listen(this,
        getChangeEventType(InteractionProperty.ACTIVE),
        this.updateState_, this);

    }

    if ( PointerInteraction$$1 ) Draw.__proto__ = PointerInteraction$$1;
    Draw.prototype = Object.create( PointerInteraction$$1 && PointerInteraction$$1.prototype );
    Draw.prototype.constructor = Draw;

    /**
     * @inheritDoc
     */
    Draw.prototype.setMap = function setMap (map) {
      PointerInteraction$$1.prototype.setMap.call(this, map);
      this.updateState_();
    };

    /**
     * Get the overlay layer that this interaction renders sketch features to.
     * @return {VectorLayer} Overlay layer.
     * @api
     */
    Draw.prototype.getOverlay = function getOverlay () {
      return this.overlay_;
    };

    /**
     * Handles the {@link module:ol/MapBrowserEvent map browser event} and may actually draw or finish the drawing.
     * @override
     * @api
     */
    Draw.prototype.handleEvent = function handleEvent (event) {
      if (event.originalEvent.type === EventType.CONTEXTMENU) {
        // Avoid context menu for long taps when drawing on mobile
        event.preventDefault();
      }
      this.freehand_ = this.mode_ !== Mode$1.POINT && this.freehandCondition_(event);
      var move = event.type === MapBrowserEventType.POINTERMOVE;
      var pass = true;
      if (!this.freehand_ && this.lastDragTime_ && event.type === MapBrowserEventType.POINTERDRAG) {
        var now = Date.now();
        if (now - this.lastDragTime_ >= this.dragVertexDelay_) {
          this.downPx_ = event.pixel;
          this.shouldHandle_ = !this.freehand_;
          move = true;
        } else {
          this.lastDragTime_ = undefined;
        }
        if (this.shouldHandle_ && this.downTimeout_ !== undefined) {
          clearTimeout(this.downTimeout_);
          this.downTimeout_ = undefined;
        }
      }
      if (this.freehand_ &&
          event.type === MapBrowserEventType.POINTERDRAG &&
          this.sketchFeature_ !== null) {
        this.addToDrawing_(event);
        pass = false;
      } else if (this.freehand_ &&
          event.type === MapBrowserEventType.POINTERDOWN) {
        pass = false;
      } else if (move) {
        pass = event.type === MapBrowserEventType.POINTERMOVE;
        if (pass && this.freehand_) {
          pass = this.handlePointerMove_(event);
        } else if (/** @type {MapBrowserPointerEvent} */ (event).pointerEvent.pointerType == POINTER_TYPE ||
            (event.type === MapBrowserEventType.POINTERDRAG && this.downTimeout_ === undefined)) {
          this.handlePointerMove_(event);
        }
      } else if (event.type === MapBrowserEventType.DBLCLICK) {
        pass = false;
      }

      return PointerInteraction$$1.prototype.handleEvent.call(this, event) && pass;
    };

    /**
     * @inheritDoc
     */
    Draw.prototype.handleDownEvent = function handleDownEvent (event) {
      this.shouldHandle_ = !this.freehand_;

      if (this.freehand_) {
        this.downPx_ = event.pixel;
        if (!this.finishCoordinate_) {
          this.startDrawing_(event);
        }
        return true;
      } else if (this.condition_(event)) {
        this.lastDragTime_ = Date.now();
        this.downTimeout_ = setTimeout(function() {
          this.handlePointerMove_(new MapBrowserPointerEvent(
            MapBrowserEventType.POINTERMOVE, event.map, event.pointerEvent, false, event.frameState));
        }.bind(this), this.dragVertexDelay_);
        this.downPx_ = event.pixel;
        return true;
      } else {
        return false;
      }
    };


    /**
     * @inheritDoc
     */
    Draw.prototype.handleUpEvent = function handleUpEvent (event) {
      var pass = true;

      if (this.downTimeout_) {
        clearTimeout(this.downTimeout_);
        this.downTimeout_ = undefined;
      }

      this.handlePointerMove_(event);

      var circleMode = this.mode_ === Mode$1.CIRCLE;

      if (this.shouldHandle_) {
        if (!this.finishCoordinate_) {
          this.startDrawing_(event);
          if (this.mode_ === Mode$1.POINT) {
            this.finishDrawing();
          }
        } else if (this.freehand_ || circleMode) {
          this.finishDrawing();
        } else if (this.atFinish_(event)) {
          if (this.finishCondition_(event)) {
            this.finishDrawing();
          }
        } else {
          this.addToDrawing_(event);
        }
        pass = false;
      } else if (this.freehand_) {
        this.finishCoordinate_ = null;
        this.abortDrawing_();
      }
      if (!pass && this.stopClick_) {
        event.stopPropagation();
      }
      return pass;
    };

    /**
     * Handle move events.
     * @param {import("../MapBrowserEvent.js").default} event A move event.
     * @return {boolean} Pass the event to other interactions.
     * @private
     */
    Draw.prototype.handlePointerMove_ = function handlePointerMove_ (event) {
      if (this.downPx_ &&
          ((!this.freehand_ && this.shouldHandle_) ||
          (this.freehand_ && !this.shouldHandle_))) {
        var downPx = this.downPx_;
        var clickPx = event.pixel;
        var dx = downPx[0] - clickPx[0];
        var dy = downPx[1] - clickPx[1];
        var squaredDistance$$1 = dx * dx + dy * dy;
        this.shouldHandle_ = this.freehand_ ?
          squaredDistance$$1 > this.squaredClickTolerance_ :
          squaredDistance$$1 <= this.squaredClickTolerance_;
        if (!this.shouldHandle_) {
          return true;
        }
      }

      if (this.finishCoordinate_) {
        this.modifyDrawing_(event);
      } else {
        this.createOrUpdateSketchPoint_(event);
      }
      return true;
    };

    /**
     * Determine if an event is within the snapping tolerance of the start coord.
     * @param {import("../MapBrowserEvent.js").default} event Event.
     * @return {boolean} The event is within the snapping tolerance of the start.
     * @private
     */
    Draw.prototype.atFinish_ = function atFinish_ (event) {
      var at = false;
      if (this.sketchFeature_) {
        var potentiallyDone = false;
        var potentiallyFinishCoordinates = [this.finishCoordinate_];
        if (this.mode_ === Mode$1.LINE_STRING) {
          potentiallyDone = this.sketchCoords_.length > this.minPoints_;
        } else if (this.mode_ === Mode$1.POLYGON) {
          var sketchCoords = /** @type {PolyCoordType} */ (this.sketchCoords_);
          potentiallyDone = sketchCoords[0].length > this.minPoints_;
          potentiallyFinishCoordinates = [sketchCoords[0][0], sketchCoords[0][sketchCoords[0].length - 2]];
        }
        if (potentiallyDone) {
          var map = event.map;
          for (var i = 0, ii = potentiallyFinishCoordinates.length; i < ii; i++) {
            var finishCoordinate = potentiallyFinishCoordinates[i];
            var finishPixel = map.getPixelFromCoordinate(finishCoordinate);
            var pixel = event.pixel;
            var dx = pixel[0] - finishPixel[0];
            var dy = pixel[1] - finishPixel[1];
            var snapTolerance = this.freehand_ ? 1 : this.snapTolerance_;
            at = Math.sqrt(dx * dx + dy * dy) <= snapTolerance;
            if (at) {
              this.finishCoordinate_ = finishCoordinate;
              break;
            }
          }
        }
      }
      return at;
    };

    /**
     * @param {import("../MapBrowserEvent.js").default} event Event.
     * @private
     */
    Draw.prototype.createOrUpdateSketchPoint_ = function createOrUpdateSketchPoint_ (event) {
      var coordinates = event.coordinate.slice();
      if (!this.sketchPoint_) {
        this.sketchPoint_ = new Feature(new Point(coordinates));
        this.updateSketchFeatures_();
      } else {
        var sketchPointGeom = /** @type {Point} */ (this.sketchPoint_.getGeometry());
        sketchPointGeom.setCoordinates(coordinates);
      }
    };

    /**
     * Start the drawing.
     * @param {import("../MapBrowserEvent.js").default} event Event.
     * @private
     */
    Draw.prototype.startDrawing_ = function startDrawing_ (event) {
      var start = event.coordinate;
      this.finishCoordinate_ = start;
      if (this.mode_ === Mode$1.POINT) {
        this.sketchCoords_ = start.slice();
      } else if (this.mode_ === Mode$1.POLYGON) {
        this.sketchCoords_ = [[start.slice(), start.slice()]];
        this.sketchLineCoords_ = this.sketchCoords_[0];
      } else {
        this.sketchCoords_ = [start.slice(), start.slice()];
      }
      if (this.sketchLineCoords_) {
        this.sketchLine_ = new Feature(
          new LineString(this.sketchLineCoords_));
      }
      var geometry = this.geometryFunction_(this.sketchCoords_);
      this.sketchFeature_ = new Feature();
      if (this.geometryName_) {
        this.sketchFeature_.setGeometryName(this.geometryName_);
      }
      this.sketchFeature_.setGeometry(geometry);
      this.updateSketchFeatures_();
      this.dispatchEvent(new DrawEvent(DrawEventType.DRAWSTART, this.sketchFeature_));
    };

    /**
     * Modify the drawing.
     * @param {import("../MapBrowserEvent.js").default} event Event.
     * @private
     */
    Draw.prototype.modifyDrawing_ = function modifyDrawing_ (event) {
      var coordinate = event.coordinate;
      var geometry = /** @type {import("../geom/SimpleGeometry.js").default} */ (this.sketchFeature_.getGeometry());
      var coordinates, last;
      if (this.mode_ === Mode$1.POINT) {
        last = this.sketchCoords_;
      } else if (this.mode_ === Mode$1.POLYGON) {
        coordinates = /** @type {PolyCoordType} */ (this.sketchCoords_)[0];
        last = coordinates[coordinates.length - 1];
        if (this.atFinish_(event)) {
          // snap to finish
          coordinate = this.finishCoordinate_.slice();
        }
      } else {
        coordinates = this.sketchCoords_;
        last = coordinates[coordinates.length - 1];
      }
      last[0] = coordinate[0];
      last[1] = coordinate[1];
      this.geometryFunction_(/** @type {!LineCoordType} */ (this.sketchCoords_), geometry);
      if (this.sketchPoint_) {
        var sketchPointGeom = /** @type {Point} */ (this.sketchPoint_.getGeometry());
        sketchPointGeom.setCoordinates(coordinate);
      }
      /** @type {LineString} */
      var sketchLineGeom;
      if (geometry.getType() == GeometryType.POLYGON &&
          this.mode_ !== Mode$1.POLYGON) {
        if (!this.sketchLine_) {
          this.sketchLine_ = new Feature();
        }
        var ring = /** @type {Polygon} */ (geometry).getLinearRing(0);
        sketchLineGeom = /** @type {LineString} */ (this.sketchLine_.getGeometry());
        if (!sketchLineGeom) {
          sketchLineGeom = new LineString(ring.getFlatCoordinates(), ring.getLayout());
          this.sketchLine_.setGeometry(sketchLineGeom);
        } else {
          sketchLineGeom.setFlatCoordinates(
            ring.getLayout(), ring.getFlatCoordinates());
          sketchLineGeom.changed();
        }
      } else if (this.sketchLineCoords_) {
        sketchLineGeom = /** @type {LineString} */ (this.sketchLine_.getGeometry());
        sketchLineGeom.setCoordinates(this.sketchLineCoords_);
      }
      this.updateSketchFeatures_();
    };

    /**
     * Add a new coordinate to the drawing.
     * @param {import("../MapBrowserEvent.js").default} event Event.
     * @private
     */
    Draw.prototype.addToDrawing_ = function addToDrawing_ (event) {
      var coordinate = event.coordinate;
      var geometry = /** @type {import("../geom/SimpleGeometry.js").default} */ (this.sketchFeature_.getGeometry());
      var done;
      var coordinates;
      if (this.mode_ === Mode$1.LINE_STRING) {
        this.finishCoordinate_ = coordinate.slice();
        coordinates = /** @type {LineCoordType} */ (this.sketchCoords_);
        if (coordinates.length >= this.maxPoints_) {
          if (this.freehand_) {
            coordinates.pop();
          } else {
            done = true;
          }
        }
        coordinates.push(coordinate.slice());
        this.geometryFunction_(coordinates, geometry);
      } else if (this.mode_ === Mode$1.POLYGON) {
        coordinates = /** @type {PolyCoordType} */ (this.sketchCoords_)[0];
        if (coordinates.length >= this.maxPoints_) {
          if (this.freehand_) {
            coordinates.pop();
          } else {
            done = true;
          }
        }
        coordinates.push(coordinate.slice());
        if (done) {
          this.finishCoordinate_ = coordinates[0];
        }
        this.geometryFunction_(this.sketchCoords_, geometry);
      }
      this.updateSketchFeatures_();
      if (done) {
        this.finishDrawing();
      }
    };

    /**
     * Remove last point of the feature currently being drawn.
     * @api
     */
    Draw.prototype.removeLastPoint = function removeLastPoint () {
      if (!this.sketchFeature_) {
        return;
      }
      var geometry = /** @type {import("../geom/SimpleGeometry.js").default} */ (this.sketchFeature_.getGeometry());
      var coordinates;
      /** @type {LineString} */
      var sketchLineGeom;
      if (this.mode_ === Mode$1.LINE_STRING) {
        coordinates = /** @type {LineCoordType} */ (this.sketchCoords_);
        coordinates.splice(-2, 1);
        this.geometryFunction_(coordinates, geometry);
        if (coordinates.length >= 2) {
          this.finishCoordinate_ = coordinates[coordinates.length - 2].slice();
        }
      } else if (this.mode_ === Mode$1.POLYGON) {
        coordinates = /** @type {PolyCoordType} */ (this.sketchCoords_)[0];
        coordinates.splice(-2, 1);
        sketchLineGeom = /** @type {LineString} */ (this.sketchLine_.getGeometry());
        sketchLineGeom.setCoordinates(coordinates);
        this.geometryFunction_(this.sketchCoords_, geometry);
      }

      if (coordinates.length === 0) {
        this.finishCoordinate_ = null;
      }

      this.updateSketchFeatures_();
    };

    /**
     * Stop drawing and add the sketch feature to the target layer.
     * The {@link module:ol/interaction/Draw~DrawEventType.DRAWEND} event is
     * dispatched before inserting the feature.
     * @api
     */
    Draw.prototype.finishDrawing = function finishDrawing () {
      var sketchFeature = this.abortDrawing_();
      if (!sketchFeature) {
        return;
      }
      var coordinates = this.sketchCoords_;
      var geometry = /** @type {import("../geom/SimpleGeometry.js").default} */ (sketchFeature.getGeometry());
      if (this.mode_ === Mode$1.LINE_STRING) {
        // remove the redundant last point
        coordinates.pop();
        this.geometryFunction_(coordinates, geometry);
      } else if (this.mode_ === Mode$1.POLYGON) {
        // remove the redundant last point in ring
        /** @type {PolyCoordType} */ (coordinates)[0].pop();
        this.geometryFunction_(coordinates, geometry);
        coordinates = geometry.getCoordinates();
      }

      // cast multi-part geometries
      if (this.type_ === GeometryType.MULTI_POINT) {
        sketchFeature.setGeometry(new MultiPoint([/** @type {PointCoordType} */(coordinates)]));
      } else if (this.type_ === GeometryType.MULTI_LINE_STRING) {
        sketchFeature.setGeometry(new MultiLineString([/** @type {LineCoordType} */(coordinates)]));
      } else if (this.type_ === GeometryType.MULTI_POLYGON) {
        sketchFeature.setGeometry(new MultiPolygon([/** @type {PolyCoordType} */(coordinates)]));
      }

      // First dispatch event to allow full set up of feature
      this.dispatchEvent(new DrawEvent(DrawEventType.DRAWEND, sketchFeature));

      // Then insert feature
      if (this.features_) {
        this.features_.push(sketchFeature);
      }
      if (this.source_) {
        this.source_.addFeature(sketchFeature);
      }
    };

    /**
     * Stop drawing without adding the sketch feature to the target layer.
     * @return {Feature} The sketch feature (or null if none).
     * @private
     */
    Draw.prototype.abortDrawing_ = function abortDrawing_ () {
      this.finishCoordinate_ = null;
      var sketchFeature = this.sketchFeature_;
      if (sketchFeature) {
        this.sketchFeature_ = null;
        this.sketchPoint_ = null;
        this.sketchLine_ = null;
        /** @type {VectorSource} */ (this.overlay_.getSource()).clear(true);
      }
      return sketchFeature;
    };

    /**
     * Extend an existing geometry by adding additional points. This only works
     * on features with `LineString` geometries, where the interaction will
     * extend lines by adding points to the end of the coordinates array.
     * @param {!Feature} feature Feature to be extended.
     * @api
     */
    Draw.prototype.extend = function extend (feature) {
      var geometry = feature.getGeometry();
      var lineString = /** @type {LineString} */ (geometry);
      this.sketchFeature_ = feature;
      this.sketchCoords_ = lineString.getCoordinates();
      var last = this.sketchCoords_[this.sketchCoords_.length - 1];
      this.finishCoordinate_ = last.slice();
      this.sketchCoords_.push(last.slice());
      this.updateSketchFeatures_();
      this.dispatchEvent(new DrawEvent(DrawEventType.DRAWSTART, this.sketchFeature_));
    };

    /**
     * Redraw the sketch features.
     * @private
     */
    Draw.prototype.updateSketchFeatures_ = function updateSketchFeatures_ () {
      var sketchFeatures = [];
      if (this.sketchFeature_) {
        sketchFeatures.push(this.sketchFeature_);
      }
      if (this.sketchLine_) {
        sketchFeatures.push(this.sketchLine_);
      }
      if (this.sketchPoint_) {
        sketchFeatures.push(this.sketchPoint_);
      }
      var overlaySource = /** @type {VectorSource} */ (this.overlay_.getSource());
      overlaySource.clear(true);
      overlaySource.addFeatures(sketchFeatures);
    };

    /**
     * @private
     */
    Draw.prototype.updateState_ = function updateState_ () {
      var map = this.getMap();
      var active = this.getActive();
      if (!map || !active) {
        this.abortDrawing_();
      }
      this.overlay_.setMap(active ? map : null);
    };

    return Draw;
  }(PointerInteraction));


  /**
   * @return {import("../style/Style.js").StyleFunction} Styles.
   */
  function getDefaultStyleFunction() {
    var styles = createEditingStyle();
    return function(feature, resolution) {
      return styles[feature.getGeometry().getType()];
    };
  }


  /**
   * Create a `geometryFunction` for `type: 'Circle'` that will create a regular
   * polygon with a user specified number of sides and start angle instead of an
   * `import("../geom/Circle.js").Circle` geometry.
   * @param {number=} opt_sides Number of sides of the regular polygon. Default is
   *     32.
   * @param {number=} opt_angle Angle of the first point in radians. 0 means East.
   *     Default is the angle defined by the heading from the center of the
   *     regular polygon to the current pointer position.
   * @return {GeometryFunction} Function that draws a
   *     polygon.
   * @api
   */
  function createRegularPolygon(opt_sides, opt_angle) {
    return function(coordinates, opt_geometry) {
      var center = /** @type {LineCoordType} */ (coordinates)[0];
      var end = /** @type {LineCoordType} */ (coordinates)[1];
      var radius = Math.sqrt(
        squaredDistance$1(center, end));
      var geometry = opt_geometry ? /** @type {Polygon} */ (opt_geometry) :
        fromCircle(new Circle(center), opt_sides);
      var angle = opt_angle;
      if (!opt_angle) {
        var x = end[0] - center[0];
        var y = end[1] - center[1];
        angle = Math.atan(y / x) - (x < 0 ? Math.PI : 0);
      }
      makeRegular(geometry, center, radius, angle);
      return geometry;
    };
  }


  /**
   * Get the drawing mode.  The mode for mult-part geometries is the same as for
   * their single-part cousins.
   * @param {GeometryType} type Geometry type.
   * @return {Mode} Drawing mode.
   */
  function getMode(type) {
    var mode;
    if (type === GeometryType.POINT ||
        type === GeometryType.MULTI_POINT) {
      mode = Mode$1.POINT;
    } else if (type === GeometryType.LINE_STRING ||
        type === GeometryType.MULTI_LINE_STRING) {
      mode = Mode$1.LINE_STRING;
    } else if (type === GeometryType.POLYGON ||
        type === GeometryType.MULTI_POLYGON) {
      mode = Mode$1.POLYGON;
    } else if (type === GeometryType.CIRCLE) {
      mode = Mode$1.CIRCLE;
    }
    return (
      /** @type {!Mode} */ (mode)
    );
  }

  /**
   * @module ol/interaction/Extent
   */


  /**
   * @typedef {Object} Options
   * @property {import("../extent.js").Extent} [extent] Initial extent. Defaults to no
   * initial extent.
   * @property {import("../style/Style.js").StyleLike} [boxStyle]
   * Style for the drawn extent box. Defaults to
   * {@link module:ol/style/Style~createEditing()['Polygon']}
   * @property {number} [pixelTolerance=10] Pixel tolerance for considering the
   * pointer close enough to a segment or vertex for editing.
   * @property {import("../style/Style.js").StyleLike} [pointerStyle]
   * Style for the cursor used to draw the extent. Defaults to
   * {@link module:ol/style/Style~createEditing()['Point']}
   * @property {boolean} [wrapX=false] Wrap the drawn extent across multiple maps
   * in the X direction? Only affects visuals, not functionality.
   */


  /**
   * @enum {string}
   */
  var ExtentEventType = {
    /**
     * Triggered after the extent is changed
     * @event ExtentEventType#extentchanged
     * @api
     */
    EXTENTCHANGED: 'extentchanged'
  };


  /**
   * @classdesc
   * Events emitted by {@link module:ol/interaction/Extent~ExtentInteraction} instances are
   * instances of this type.
   */
  var ExtentInteractionEvent = /*@__PURE__*/(function (Event$$1) {
    function ExtentInteractionEvent(extent) {
      Event$$1.call(this, ExtentEventType.EXTENTCHANGED);

      /**
       * The current extent.
       * @type {import("../extent.js").Extent}
       * @api
       */
      this.extent = extent;
    }

    if ( Event$$1 ) ExtentInteractionEvent.__proto__ = Event$$1;
    ExtentInteractionEvent.prototype = Object.create( Event$$1 && Event$$1.prototype );
    ExtentInteractionEvent.prototype.constructor = ExtentInteractionEvent;

    return ExtentInteractionEvent;
  }(Event));


  /**
   * @classdesc
   * Allows the user to draw a vector box by clicking and dragging on the map.
   * Once drawn, the vector box can be modified by dragging its vertices or edges.
   * This interaction is only supported for mouse devices.
   *
   * @fires Event
   * @api
   */
  var ExtentInteraction = /*@__PURE__*/(function (PointerInteraction$$1) {
    function ExtentInteraction(opt_options) {

      var options = opt_options || {};

      PointerInteraction$$1.call(/** @type {import("./Pointer.js").Options} */ this, (options));

      /**
       * Extent of the drawn box
       * @type {import("../extent.js").Extent}
       * @private
       */
      this.extent_ = null;

      /**
       * Handler for pointer move events
       * @type {function (import("../coordinate.js").Coordinate): import("../extent.js").Extent|null}
       * @private
       */
      this.pointerHandler_ = null;

      /**
       * Pixel threshold to snap to extent
       * @type {number}
       * @private
       */
      this.pixelTolerance_ = options.pixelTolerance !== undefined ?
        options.pixelTolerance : 10;

      /**
       * Is the pointer snapped to an extent vertex
       * @type {boolean}
       * @private
       */
      this.snappedToVertex_ = false;

      /**
       * Feature for displaying the visible extent
       * @type {Feature}
       * @private
       */
      this.extentFeature_ = null;

      /**
       * Feature for displaying the visible pointer
       * @type {Feature}
       * @private
       */
      this.vertexFeature_ = null;

      if (!opt_options) {
        opt_options = {};
      }

      /**
       * Layer for the extentFeature
       * @type {VectorLayer}
       * @private
       */
      this.extentOverlay_ = new VectorLayer({
        source: new VectorSource({
          useSpatialIndex: false,
          wrapX: !!opt_options.wrapX
        }),
        style: opt_options.boxStyle ? opt_options.boxStyle : getDefaultExtentStyleFunction(),
        updateWhileAnimating: true,
        updateWhileInteracting: true
      });

      /**
       * Layer for the vertexFeature
       * @type {VectorLayer}
       * @private
       */
      this.vertexOverlay_ = new VectorLayer({
        source: new VectorSource({
          useSpatialIndex: false,
          wrapX: !!opt_options.wrapX
        }),
        style: opt_options.pointerStyle ? opt_options.pointerStyle : getDefaultPointerStyleFunction(),
        updateWhileAnimating: true,
        updateWhileInteracting: true
      });

      if (opt_options.extent) {
        this.setExtent(opt_options.extent);
      }
    }

    if ( PointerInteraction$$1 ) ExtentInteraction.__proto__ = PointerInteraction$$1;
    ExtentInteraction.prototype = Object.create( PointerInteraction$$1 && PointerInteraction$$1.prototype );
    ExtentInteraction.prototype.constructor = ExtentInteraction;

    /**
     * @param {import("../pixel.js").Pixel} pixel cursor location
     * @param {import("../PluggableMap.js").default} map map
     * @returns {import("../coordinate.js").Coordinate|null} snapped vertex on extent
     * @private
     */
    ExtentInteraction.prototype.snapToVertex_ = function snapToVertex_ (pixel, map) {
      var pixelCoordinate = map.getCoordinateFromPixel(pixel);
      var sortByDistance = function(a, b) {
        return squaredDistanceToSegment(pixelCoordinate, a) -
            squaredDistanceToSegment(pixelCoordinate, b);
      };
      var extent = this.getExtent();
      if (extent) {
        //convert extents to line segments and find the segment closest to pixelCoordinate
        var segments = getSegments(extent);
        segments.sort(sortByDistance);
        var closestSegment = segments[0];

        var vertex = (closestOnSegment(pixelCoordinate,
          closestSegment));
        var vertexPixel = map.getPixelFromCoordinate(vertex);

        //if the distance is within tolerance, snap to the segment
        if (distance(pixel, vertexPixel) <= this.pixelTolerance_) {
          //test if we should further snap to a vertex
          var pixel1 = map.getPixelFromCoordinate(closestSegment[0]);
          var pixel2 = map.getPixelFromCoordinate(closestSegment[1]);
          var squaredDist1 = squaredDistance$1(vertexPixel, pixel1);
          var squaredDist2 = squaredDistance$1(vertexPixel, pixel2);
          var dist = Math.sqrt(Math.min(squaredDist1, squaredDist2));
          this.snappedToVertex_ = dist <= this.pixelTolerance_;
          if (this.snappedToVertex_) {
            vertex = squaredDist1 > squaredDist2 ?
              closestSegment[1] : closestSegment[0];
          }
          return vertex;
        }
      }
      return null;
    };

    /**
     * @param {import("../MapBrowserEvent.js").default} mapBrowserEvent pointer move event
     * @private
     */
    ExtentInteraction.prototype.handlePointerMove_ = function handlePointerMove_ (mapBrowserEvent) {
      var pixel = mapBrowserEvent.pixel;
      var map = mapBrowserEvent.map;

      var vertex = this.snapToVertex_(pixel, map);
      if (!vertex) {
        vertex = map.getCoordinateFromPixel(pixel);
      }
      this.createOrUpdatePointerFeature_(vertex);
    };

    /**
     * @param {import("../extent.js").Extent} extent extent
     * @returns {Feature} extent as featrue
     * @private
     */
    ExtentInteraction.prototype.createOrUpdateExtentFeature_ = function createOrUpdateExtentFeature_ (extent) {
      var extentFeature = this.extentFeature_;

      if (!extentFeature) {
        if (!extent) {
          extentFeature = new Feature({});
        } else {
          extentFeature = new Feature(fromExtent(extent));
        }
        this.extentFeature_ = extentFeature;
        /** @type {VectorSource} */ (this.extentOverlay_.getSource()).addFeature(extentFeature);
      } else {
        if (!extent) {
          extentFeature.setGeometry(undefined);
        } else {
          extentFeature.setGeometry(fromExtent(extent));
        }
      }
      return extentFeature;
    };

    /**
     * @param {import("../coordinate.js").Coordinate} vertex location of feature
     * @returns {Feature} vertex as feature
     * @private
     */
    ExtentInteraction.prototype.createOrUpdatePointerFeature_ = function createOrUpdatePointerFeature_ (vertex) {
      var vertexFeature = this.vertexFeature_;
      if (!vertexFeature) {
        vertexFeature = new Feature(new Point(vertex));
        this.vertexFeature_ = vertexFeature;
        /** @type {VectorSource} */ (this.vertexOverlay_.getSource()).addFeature(vertexFeature);
      } else {
        var geometry = /** @type {Point} */ (vertexFeature.getGeometry());
        geometry.setCoordinates(vertex);
      }
      return vertexFeature;
    };

    /**
     * @inheritDoc
     */
    ExtentInteraction.prototype.handleEvent = function handleEvent (mapBrowserEvent) {
      if (!(/** @type {import("../MapBrowserPointerEvent.js").default} */ (mapBrowserEvent).pointerEvent)) {
        return true;
      }
      //display pointer (if not dragging)
      if (mapBrowserEvent.type == MapBrowserEventType.POINTERMOVE && !this.handlingDownUpSequence) {
        this.handlePointerMove_(mapBrowserEvent);
      }
      //call pointer to determine up/down/drag
      PointerInteraction$$1.prototype.handleEvent.call(this, mapBrowserEvent);
      //return false to stop propagation
      return false;
    };

    /**
     * @inheritDoc
     */
    ExtentInteraction.prototype.handleDownEvent = function handleDownEvent (mapBrowserEvent) {
      var pixel = mapBrowserEvent.pixel;
      var map = mapBrowserEvent.map;

      var extent = this.getExtent();
      var vertex = this.snapToVertex_(pixel, map);

      //find the extent corner opposite the passed corner
      var getOpposingPoint = function(point) {
        var x_ = null;
        var y_ = null;
        if (point[0] == extent[0]) {
          x_ = extent[2];
        } else if (point[0] == extent[2]) {
          x_ = extent[0];
        }
        if (point[1] == extent[1]) {
          y_ = extent[3];
        } else if (point[1] == extent[3]) {
          y_ = extent[1];
        }
        if (x_ !== null && y_ !== null) {
          return [x_, y_];
        }
        return null;
      };
      if (vertex && extent) {
        var x = (vertex[0] == extent[0] || vertex[0] == extent[2]) ? vertex[0] : null;
        var y = (vertex[1] == extent[1] || vertex[1] == extent[3]) ? vertex[1] : null;

        //snap to point
        if (x !== null && y !== null) {
          this.pointerHandler_ = getPointHandler(getOpposingPoint(vertex));
        //snap to edge
        } else if (x !== null) {
          this.pointerHandler_ = getEdgeHandler(
            getOpposingPoint([x, extent[1]]),
            getOpposingPoint([x, extent[3]])
          );
        } else if (y !== null) {
          this.pointerHandler_ = getEdgeHandler(
            getOpposingPoint([extent[0], y]),
            getOpposingPoint([extent[2], y])
          );
        }
      //no snap - new bbox
      } else {
        vertex = map.getCoordinateFromPixel(pixel);
        this.setExtent([vertex[0], vertex[1], vertex[0], vertex[1]]);
        this.pointerHandler_ = getPointHandler(vertex);
      }
      return true; //event handled; start downup sequence
    };

    /**
     * @inheritDoc
     */
    ExtentInteraction.prototype.handleDragEvent = function handleDragEvent (mapBrowserEvent) {
      if (this.pointerHandler_) {
        var pixelCoordinate = mapBrowserEvent.coordinate;
        this.setExtent(this.pointerHandler_(pixelCoordinate));
        this.createOrUpdatePointerFeature_(pixelCoordinate);
      }
      return true;
    };

    /**
     * @inheritDoc
     */
    ExtentInteraction.prototype.handleUpEvent = function handleUpEvent (mapBrowserEvent) {
      this.pointerHandler_ = null;
      //If bbox is zero area, set to null;
      var extent = this.getExtent();
      if (!extent || getArea(extent) === 0) {
        this.setExtent(null);
      }
      return false; //Stop handling downup sequence
    };

    /**
     * @inheritDoc
     */
    ExtentInteraction.prototype.setMap = function setMap (map) {
      this.extentOverlay_.setMap(map);
      this.vertexOverlay_.setMap(map);
      PointerInteraction$$1.prototype.setMap.call(this, map);
    };

    /**
     * Returns the current drawn extent in the view projection
     *
     * @return {import("../extent.js").Extent} Drawn extent in the view projection.
     * @api
     */
    ExtentInteraction.prototype.getExtent = function getExtent () {
      return this.extent_;
    };

    /**
     * Manually sets the drawn extent, using the view projection.
     *
     * @param {import("../extent.js").Extent} extent Extent
     * @api
     */
    ExtentInteraction.prototype.setExtent = function setExtent (extent) {
      //Null extent means no bbox
      this.extent_ = extent ? extent : null;
      this.createOrUpdateExtentFeature_(extent);
      this.dispatchEvent(new ExtentInteractionEvent(this.extent_));
    };

    return ExtentInteraction;
  }(PointerInteraction));

  /**
   * Returns the default style for the drawn bbox
   *
   * @return {import("../style/Style.js").StyleFunction} Default Extent style
   */
  function getDefaultExtentStyleFunction() {
    var style = createEditingStyle();
    return function(feature, resolution) {
      return style[GeometryType.POLYGON];
    };
  }

  /**
   * Returns the default style for the pointer
   *
   * @return {import("../style/Style.js").StyleFunction} Default pointer style
   */
  function getDefaultPointerStyleFunction() {
    var style = createEditingStyle();
    return function(feature, resolution) {
      return style[GeometryType.POINT];
    };
  }

  /**
   * @param {import("../coordinate.js").Coordinate} fixedPoint corner that will be unchanged in the new extent
   * @returns {function (import("../coordinate.js").Coordinate): import("../extent.js").Extent} event handler
   */
  function getPointHandler(fixedPoint) {
    return function(point) {
      return boundingExtent([fixedPoint, point]);
    };
  }

  /**
   * @param {import("../coordinate.js").Coordinate} fixedP1 first corner that will be unchanged in the new extent
   * @param {import("../coordinate.js").Coordinate} fixedP2 second corner that will be unchanged in the new extent
   * @returns {function (import("../coordinate.js").Coordinate): import("../extent.js").Extent|null} event handler
   */
  function getEdgeHandler(fixedP1, fixedP2) {
    if (fixedP1[0] == fixedP2[0]) {
      return function(point) {
        return boundingExtent([fixedP1, [point[0], fixedP2[1]]]);
      };
    } else if (fixedP1[1] == fixedP2[1]) {
      return function(point) {
        return boundingExtent([fixedP1, [fixedP2[0], point[1]]]);
      };
    } else {
      return null;
    }
  }

  /**
   * @param {import("../extent.js").Extent} extent extent
   * @returns {Array<Array<import("../coordinate.js").Coordinate>>} extent line segments
   */
  function getSegments(extent) {
    return [
      [[extent[0], extent[1]], [extent[0], extent[3]]],
      [[extent[0], extent[3]], [extent[2], extent[3]]],
      [[extent[2], extent[3]], [extent[2], extent[1]]],
      [[extent[2], extent[1]], [extent[0], extent[1]]]
    ];
  }

  /**
   * @module ol/interaction/Modify
   */


  /**
   * The segment index assigned to a circle's center when
   * breaking up a circle into ModifySegmentDataType segments.
   * @type {number}
   */
  var CIRCLE_CENTER_INDEX = 0;

  /**
   * The segment index assigned to a circle's circumference when
   * breaking up a circle into ModifySegmentDataType segments.
   * @type {number}
   */
  var CIRCLE_CIRCUMFERENCE_INDEX = 1;


  /**
   * @enum {string}
   */
  var ModifyEventType = {
    /**
     * Triggered upon feature modification start
     * @event ModifyEvent#modifystart
     * @api
     */
    MODIFYSTART: 'modifystart',
    /**
     * Triggered upon feature modification end
     * @event ModifyEvent#modifyend
     * @api
     */
    MODIFYEND: 'modifyend'
  };


  /**
   * @typedef {Object} SegmentData
   * @property {Array<number>} [depth]
   * @property {Feature} feature
   * @property {import("../geom/SimpleGeometry.js").default} geometry
   * @property {number} [index]
   * @property {Array<import("../extent.js").Extent>} segment
   * @property {Array<SegmentData>} [featureSegments]
   */


  /**
   * @typedef {Object} Options
   * @property {import("../events/condition.js").Condition} [condition] A function that
   * takes an {@link module:ol/MapBrowserEvent~MapBrowserEvent} and returns a
   * boolean to indicate whether that event will be considered to add or move a
   * vertex to the sketch. Default is
   * {@link module:ol/events/condition~primaryAction}.
   * @property {import("../events/condition.js").Condition} [deleteCondition] A function
   * that takes an {@link module:ol/MapBrowserEvent~MapBrowserEvent} and returns a
   * boolean to indicate whether that event should be handled. By default,
   * {@link module:ol/events/condition~singleClick} with
   * {@link module:ol/events/condition~altKeyOnly} results in a vertex deletion.
   * @property {import("../events/condition.js").Condition} [insertVertexCondition] A
   * function that takes an {@link module:ol/MapBrowserEvent~MapBrowserEvent} and
   * returns a boolean to indicate whether a new vertex can be added to the sketch
   * features. Default is {@link module:ol/events/condition~always}.
   * @property {number} [pixelTolerance=10] Pixel tolerance for considering the
   * pointer close enough to a segment or vertex for editing.
   * @property {import("../style/Style.js").StyleLike} [style]
   * Style used for the features being modified. By default the default edit
   * style is used (see {@link module:ol/style}).
   * @property {VectorSource} [source] The vector source with
   * features to modify.  If a vector source is not provided, a feature collection
   * must be provided with the features option.
   * @property {Collection<Feature>} [features]
   * The features the interaction works on.  If a feature collection is not
   * provided, a vector source must be provided with the source option.
   * @property {boolean} [wrapX=false] Wrap the world horizontally on the sketch
   * overlay.
   */


  /**
   * @classdesc
   * Events emitted by {@link module:ol/interaction/Modify~Modify} instances are
   * instances of this type.
   */
  var ModifyEvent = /*@__PURE__*/(function (Event$$1) {
    function ModifyEvent(type, features, mapBrowserPointerEvent) {
      Event$$1.call(this, type);

      /**
       * The features being modified.
       * @type {Collection<Feature>}
       * @api
       */
      this.features = features;

      /**
       * Associated {@link module:ol/MapBrowserEvent}.
       * @type {import("../MapBrowserEvent.js").default}
       * @api
       */
      this.mapBrowserEvent = mapBrowserPointerEvent;

    }

    if ( Event$$1 ) ModifyEvent.__proto__ = Event$$1;
    ModifyEvent.prototype = Object.create( Event$$1 && Event$$1.prototype );
    ModifyEvent.prototype.constructor = ModifyEvent;

    return ModifyEvent;
  }(Event));


  /**
   * @classdesc
   * Interaction for modifying feature geometries.  To modify features that have
   * been added to an existing source, construct the modify interaction with the
   * `source` option.  If you want to modify features in a collection (for example,
   * the collection used by a select interaction), construct the interaction with
   * the `features` option.  The interaction must be constructed with either a
   * `source` or `features` option.
   *
   * By default, the interaction will allow deletion of vertices when the `alt`
   * key is pressed.  To configure the interaction with a different condition
   * for deletion, use the `deleteCondition` option.
   * @fires ModifyEvent
   * @api
   */
  var Modify = /*@__PURE__*/(function (PointerInteraction$$1) {
    function Modify(options) {

      PointerInteraction$$1.call(/** @type {import("./Pointer.js").Options} */ this, (options));

      /**
       * @private
       * @type {import("../events/condition.js").Condition}
       */
      this.condition_ = options.condition ? options.condition : primaryAction;

      /**
       * @private
       * @param {import("../MapBrowserEvent.js").default} mapBrowserEvent Browser event.
       * @return {boolean} Combined condition result.
       */
      this.defaultDeleteCondition_ = function(mapBrowserEvent) {
        return altKeyOnly(mapBrowserEvent) && singleClick(mapBrowserEvent);
      };

      /**
       * @type {import("../events/condition.js").Condition}
       * @private
       */
      this.deleteCondition_ = options.deleteCondition ?
        options.deleteCondition : this.defaultDeleteCondition_;

      /**
       * @type {import("../events/condition.js").Condition}
       * @private
       */
      this.insertVertexCondition_ = options.insertVertexCondition ?
        options.insertVertexCondition : always;

      /**
       * Editing vertex.
       * @type {Feature}
       * @private
       */
      this.vertexFeature_ = null;

      /**
       * Segments intersecting {@link this.vertexFeature_} by segment uid.
       * @type {Object<string, boolean>}
       * @private
       */
      this.vertexSegments_ = null;

      /**
       * @type {import("../pixel.js").Pixel}
       * @private
       */
      this.lastPixel_ = [0, 0];

      /**
       * Tracks if the next `singleclick` event should be ignored to prevent
       * accidental deletion right after vertex creation.
       * @type {boolean}
       * @private
       */
      this.ignoreNextSingleClick_ = false;

      /**
       * @type {boolean}
       * @private
       */
      this.modified_ = false;

      /**
       * Segment RTree for each layer
       * @type {RBush<SegmentData>}
       * @private
       */
      this.rBush_ = new RBush();

      /**
       * @type {number}
       * @private
       */
      this.pixelTolerance_ = options.pixelTolerance !== undefined ?
        options.pixelTolerance : 10;

      /**
       * @type {boolean}
       * @private
       */
      this.snappedToVertex_ = false;

      /**
       * Indicate whether the interaction is currently changing a feature's
       * coordinates.
       * @type {boolean}
       * @private
       */
      this.changingFeature_ = false;

      /**
       * @type {Array}
       * @private
       */
      this.dragSegments_ = [];

      /**
       * Draw overlay where sketch features are drawn.
       * @type {VectorLayer}
       * @private
       */
      this.overlay_ = new VectorLayer({
        source: new VectorSource({
          useSpatialIndex: false,
          wrapX: !!options.wrapX
        }),
        style: options.style ? options.style :
          getDefaultStyleFunction$1(),
        updateWhileAnimating: true,
        updateWhileInteracting: true
      });

      /**
       * @const
       * @private
       * @type {!Object<string, function(Feature, import("../geom/Geometry.js").default)>}
       */
      this.SEGMENT_WRITERS_ = {
        'Point': this.writePointGeometry_,
        'LineString': this.writeLineStringGeometry_,
        'LinearRing': this.writeLineStringGeometry_,
        'Polygon': this.writePolygonGeometry_,
        'MultiPoint': this.writeMultiPointGeometry_,
        'MultiLineString': this.writeMultiLineStringGeometry_,
        'MultiPolygon': this.writeMultiPolygonGeometry_,
        'Circle': this.writeCircleGeometry_,
        'GeometryCollection': this.writeGeometryCollectionGeometry_
      };


      /**
       * @type {VectorSource}
       * @private
       */
      this.source_ = null;

      var features;
      if (options.source) {
        this.source_ = options.source;
        features = new Collection(this.source_.getFeatures());
        listen(this.source_, VectorEventType.ADDFEATURE,
          this.handleSourceAdd_, this);
        listen(this.source_, VectorEventType.REMOVEFEATURE,
          this.handleSourceRemove_, this);
      } else {
        features = options.features;
      }
      if (!features) {
        throw new Error('The modify interaction requires features or a source');
      }

      /**
       * @type {Collection<Feature>}
       * @private
       */
      this.features_ = features;

      this.features_.forEach(this.addFeature_.bind(this));
      listen(this.features_, CollectionEventType.ADD,
        this.handleFeatureAdd_, this);
      listen(this.features_, CollectionEventType.REMOVE,
        this.handleFeatureRemove_, this);

      /**
       * @type {import("../MapBrowserPointerEvent.js").default}
       * @private
       */
      this.lastPointerEvent_ = null;

    }

    if ( PointerInteraction$$1 ) Modify.__proto__ = PointerInteraction$$1;
    Modify.prototype = Object.create( PointerInteraction$$1 && PointerInteraction$$1.prototype );
    Modify.prototype.constructor = Modify;

    /**
     * @param {Feature} feature Feature.
     * @private
     */
    Modify.prototype.addFeature_ = function addFeature_ (feature) {
      var geometry = feature.getGeometry();
      if (geometry && geometry.getType() in this.SEGMENT_WRITERS_) {
        this.SEGMENT_WRITERS_[geometry.getType()].call(this, feature, geometry);
      }
      var map = this.getMap();
      if (map && map.isRendered() && this.getActive()) {
        this.handlePointerAtPixel_(this.lastPixel_, map);
      }
      listen(feature, EventType.CHANGE,
        this.handleFeatureChange_, this);
    };

    /**
     * @param {import("../MapBrowserPointerEvent.js").default} evt Map browser event
     * @private
     */
    Modify.prototype.willModifyFeatures_ = function willModifyFeatures_ (evt) {
      if (!this.modified_) {
        this.modified_ = true;
        this.dispatchEvent(new ModifyEvent(
          ModifyEventType.MODIFYSTART, this.features_, evt));
      }
    };

    /**
     * @param {Feature} feature Feature.
     * @private
     */
    Modify.prototype.removeFeature_ = function removeFeature_ (feature) {
      this.removeFeatureSegmentData_(feature);
      // Remove the vertex feature if the collection of canditate features
      // is empty.
      if (this.vertexFeature_ && this.features_.getLength() === 0) {
        /** @type {VectorSource} */ (this.overlay_.getSource()).removeFeature(this.vertexFeature_);
        this.vertexFeature_ = null;
      }
      unlisten(feature, EventType.CHANGE,
        this.handleFeatureChange_, this);
    };

    /**
     * @param {Feature} feature Feature.
     * @private
     */
    Modify.prototype.removeFeatureSegmentData_ = function removeFeatureSegmentData_ (feature) {
      var rBush = this.rBush_;
      var /** @type {Array<SegmentData>} */ nodesToRemove = [];
      rBush.forEach(
        /**
         * @param {SegmentData} node RTree node.
         */
        function(node) {
          if (feature === node.feature) {
            nodesToRemove.push(node);
          }
        });
      for (var i = nodesToRemove.length - 1; i >= 0; --i) {
        rBush.remove(nodesToRemove[i]);
      }
    };

    /**
     * @inheritDoc
     */
    Modify.prototype.setActive = function setActive (active) {
      if (this.vertexFeature_ && !active) {
        /** @type {VectorSource} */ (this.overlay_.getSource()).removeFeature(this.vertexFeature_);
        this.vertexFeature_ = null;
      }
      PointerInteraction$$1.prototype.setActive.call(this, active);
    };

    /**
     * @inheritDoc
     */
    Modify.prototype.setMap = function setMap (map) {
      this.overlay_.setMap(map);
      PointerInteraction$$1.prototype.setMap.call(this, map);
    };

    /**
     * Get the overlay layer that this interaction renders sketch features to.
     * @return {VectorLayer} Overlay layer.
     * @api
     */
    Modify.prototype.getOverlay = function getOverlay () {
      return this.overlay_;
    };

    /**
     * @param {import("../source/Vector.js").VectorSourceEvent} event Event.
     * @private
     */
    Modify.prototype.handleSourceAdd_ = function handleSourceAdd_ (event) {
      if (event.feature) {
        this.features_.push(event.feature);
      }
    };

    /**
     * @param {import("../source/Vector.js").VectorSourceEvent} event Event.
     * @private
     */
    Modify.prototype.handleSourceRemove_ = function handleSourceRemove_ (event) {
      if (event.feature) {
        this.features_.remove(event.feature);
      }
    };

    /**
     * @param {import("../Collection.js").CollectionEvent} evt Event.
     * @private
     */
    Modify.prototype.handleFeatureAdd_ = function handleFeatureAdd_ (evt) {
      this.addFeature_(/** @type {Feature} */ (evt.element));
    };

    /**
     * @param {import("../events/Event.js").default} evt Event.
     * @private
     */
    Modify.prototype.handleFeatureChange_ = function handleFeatureChange_ (evt) {
      if (!this.changingFeature_) {
        var feature = /** @type {Feature} */ (evt.target);
        this.removeFeature_(feature);
        this.addFeature_(feature);
      }
    };

    /**
     * @param {import("../Collection.js").CollectionEvent} evt Event.
     * @private
     */
    Modify.prototype.handleFeatureRemove_ = function handleFeatureRemove_ (evt) {
      var feature = /** @type {Feature} */ (evt.element);
      this.removeFeature_(feature);
    };

    /**
     * @param {Feature} feature Feature
     * @param {Point} geometry Geometry.
     * @private
     */
    Modify.prototype.writePointGeometry_ = function writePointGeometry_ (feature, geometry) {
      var coordinates = geometry.getCoordinates();
      var segmentData = /** @type {SegmentData} */ ({
        feature: feature,
        geometry: geometry,
        segment: [coordinates, coordinates]
      });
      this.rBush_.insert(geometry.getExtent(), segmentData);
    };

    /**
     * @param {Feature} feature Feature
     * @param {import("../geom/MultiPoint.js").default} geometry Geometry.
     * @private
     */
    Modify.prototype.writeMultiPointGeometry_ = function writeMultiPointGeometry_ (feature, geometry) {
      var points = geometry.getCoordinates();
      for (var i = 0, ii = points.length; i < ii; ++i) {
        var coordinates = points[i];
        var segmentData = /** @type {SegmentData} */ ({
          feature: feature,
          geometry: geometry,
          depth: [i],
          index: i,
          segment: [coordinates, coordinates]
        });
        this.rBush_.insert(geometry.getExtent(), segmentData);
      }
    };

    /**
     * @param {Feature} feature Feature
     * @param {import("../geom/LineString.js").default} geometry Geometry.
     * @private
     */
    Modify.prototype.writeLineStringGeometry_ = function writeLineStringGeometry_ (feature, geometry) {
      var coordinates = geometry.getCoordinates();
      for (var i = 0, ii = coordinates.length - 1; i < ii; ++i) {
        var segment = coordinates.slice(i, i + 2);
        var segmentData = /** @type {SegmentData} */ ({
          feature: feature,
          geometry: geometry,
          index: i,
          segment: segment
        });
        this.rBush_.insert(boundingExtent(segment), segmentData);
      }
    };

    /**
     * @param {Feature} feature Feature
     * @param {import("../geom/MultiLineString.js").default} geometry Geometry.
     * @private
     */
    Modify.prototype.writeMultiLineStringGeometry_ = function writeMultiLineStringGeometry_ (feature, geometry) {
      var lines = geometry.getCoordinates();
      for (var j = 0, jj = lines.length; j < jj; ++j) {
        var coordinates = lines[j];
        for (var i = 0, ii = coordinates.length - 1; i < ii; ++i) {
          var segment = coordinates.slice(i, i + 2);
          var segmentData = /** @type {SegmentData} */ ({
            feature: feature,
            geometry: geometry,
            depth: [j],
            index: i,
            segment: segment
          });
          this.rBush_.insert(boundingExtent(segment), segmentData);
        }
      }
    };

    /**
     * @param {Feature} feature Feature
     * @param {import("../geom/Polygon.js").default} geometry Geometry.
     * @private
     */
    Modify.prototype.writePolygonGeometry_ = function writePolygonGeometry_ (feature, geometry) {
      var rings = geometry.getCoordinates();
      for (var j = 0, jj = rings.length; j < jj; ++j) {
        var coordinates = rings[j];
        for (var i = 0, ii = coordinates.length - 1; i < ii; ++i) {
          var segment = coordinates.slice(i, i + 2);
          var segmentData = /** @type {SegmentData} */ ({
            feature: feature,
            geometry: geometry,
            depth: [j],
            index: i,
            segment: segment
          });
          this.rBush_.insert(boundingExtent(segment), segmentData);
        }
      }
    };

    /**
     * @param {Feature} feature Feature
     * @param {import("../geom/MultiPolygon.js").default} geometry Geometry.
     * @private
     */
    Modify.prototype.writeMultiPolygonGeometry_ = function writeMultiPolygonGeometry_ (feature, geometry) {
      var polygons = geometry.getCoordinates();
      for (var k = 0, kk = polygons.length; k < kk; ++k) {
        var rings = polygons[k];
        for (var j = 0, jj = rings.length; j < jj; ++j) {
          var coordinates = rings[j];
          for (var i = 0, ii = coordinates.length - 1; i < ii; ++i) {
            var segment = coordinates.slice(i, i + 2);
            var segmentData = /** @type {SegmentData} */ ({
              feature: feature,
              geometry: geometry,
              depth: [j, k],
              index: i,
              segment: segment
            });
            this.rBush_.insert(boundingExtent(segment), segmentData);
          }
        }
      }
    };

    /**
     * We convert a circle into two segments.  The segment at index
     * {@link CIRCLE_CENTER_INDEX} is the
     * circle's center (a point).  The segment at index
     * {@link CIRCLE_CIRCUMFERENCE_INDEX} is
     * the circumference, and is not a line segment.
     *
     * @param {Feature} feature Feature.
     * @param {import("../geom/Circle.js").default} geometry Geometry.
     * @private
     */
    Modify.prototype.writeCircleGeometry_ = function writeCircleGeometry_ (feature, geometry) {
      var coordinates = geometry.getCenter();
      var centerSegmentData = /** @type {SegmentData} */ ({
        feature: feature,
        geometry: geometry,
        index: CIRCLE_CENTER_INDEX,
        segment: [coordinates, coordinates]
      });
      var circumferenceSegmentData = /** @type {SegmentData} */ ({
        feature: feature,
        geometry: geometry,
        index: CIRCLE_CIRCUMFERENCE_INDEX,
        segment: [coordinates, coordinates]
      });
      var featureSegments = [centerSegmentData, circumferenceSegmentData];
      centerSegmentData.featureSegments = circumferenceSegmentData.featureSegments = featureSegments;
      this.rBush_.insert(createOrUpdateFromCoordinate(coordinates), centerSegmentData);
      this.rBush_.insert(geometry.getExtent(), circumferenceSegmentData);
    };

    /**
     * @param {Feature} feature Feature
     * @param {import("../geom/GeometryCollection.js").default} geometry Geometry.
     * @private
     */
    Modify.prototype.writeGeometryCollectionGeometry_ = function writeGeometryCollectionGeometry_ (feature, geometry) {
      var geometries = geometry.getGeometriesArray();
      for (var i = 0; i < geometries.length; ++i) {
        this.SEGMENT_WRITERS_[geometries[i].getType()].call(this, feature, geometries[i]);
      }
    };

    /**
     * @param {import("../coordinate.js").Coordinate} coordinates Coordinates.
     * @return {Feature} Vertex feature.
     * @private
     */
    Modify.prototype.createOrUpdateVertexFeature_ = function createOrUpdateVertexFeature_ (coordinates) {
      var vertexFeature = this.vertexFeature_;
      if (!vertexFeature) {
        vertexFeature = new Feature(new Point(coordinates));
        this.vertexFeature_ = vertexFeature;
        /** @type {VectorSource} */ (this.overlay_.getSource()).addFeature(vertexFeature);
      } else {
        var geometry = /** @type {Point} */ (vertexFeature.getGeometry());
        geometry.setCoordinates(coordinates);
      }
      return vertexFeature;
    };

    /**
     * Handles the {@link module:ol/MapBrowserEvent map browser event} and may modify the geometry.
     * @override
     */
    Modify.prototype.handleEvent = function handleEvent (mapBrowserEvent) {
      if (!(/** @type {import("../MapBrowserPointerEvent.js").default} */ (mapBrowserEvent).pointerEvent)) {
        return true;
      }
      this.lastPointerEvent_ = mapBrowserEvent;

      var handled;
      if (!mapBrowserEvent.map.getView().getInteracting() &&
          mapBrowserEvent.type == MapBrowserEventType.POINTERMOVE &&
          !this.handlingDownUpSequence) {
        this.handlePointerMove_(mapBrowserEvent);
      }
      if (this.vertexFeature_ && this.deleteCondition_(mapBrowserEvent)) {
        if (mapBrowserEvent.type != MapBrowserEventType.SINGLECLICK || !this.ignoreNextSingleClick_) {
          handled = this.removePoint();
        } else {
          handled = true;
        }
      }

      if (mapBrowserEvent.type == MapBrowserEventType.SINGLECLICK) {
        this.ignoreNextSingleClick_ = false;
      }

      return PointerInteraction$$1.prototype.handleEvent.call(this, mapBrowserEvent) && !handled;
    };

    /**
     * @inheritDoc
     */
    Modify.prototype.handleDragEvent = function handleDragEvent (evt) {
      this.ignoreNextSingleClick_ = false;
      this.willModifyFeatures_(evt);

      var vertex = evt.coordinate;
      for (var i = 0, ii = this.dragSegments_.length; i < ii; ++i) {
        var dragSegment = this.dragSegments_[i];
        var segmentData = dragSegment[0];
        var depth = segmentData.depth;
        var geometry = segmentData.geometry;
        var coordinates = (void 0);
        var segment = segmentData.segment;
        var index = dragSegment[1];

        while (vertex.length < geometry.getStride()) {
          vertex.push(segment[index][vertex.length]);
        }

        switch (geometry.getType()) {
          case GeometryType.POINT:
            coordinates = vertex;
            segment[0] = segment[1] = vertex;
            break;
          case GeometryType.MULTI_POINT:
            coordinates = geometry.getCoordinates();
            coordinates[segmentData.index] = vertex;
            segment[0] = segment[1] = vertex;
            break;
          case GeometryType.LINE_STRING:
            coordinates = geometry.getCoordinates();
            coordinates[segmentData.index + index] = vertex;
            segment[index] = vertex;
            break;
          case GeometryType.MULTI_LINE_STRING:
            coordinates = geometry.getCoordinates();
            coordinates[depth[0]][segmentData.index + index] = vertex;
            segment[index] = vertex;
            break;
          case GeometryType.POLYGON:
            coordinates = geometry.getCoordinates();
            coordinates[depth[0]][segmentData.index + index] = vertex;
            segment[index] = vertex;
            break;
          case GeometryType.MULTI_POLYGON:
            coordinates = geometry.getCoordinates();
            coordinates[depth[1]][depth[0]][segmentData.index + index] = vertex;
            segment[index] = vertex;
            break;
          case GeometryType.CIRCLE:
            segment[0] = segment[1] = vertex;
            if (segmentData.index === CIRCLE_CENTER_INDEX) {
              this.changingFeature_ = true;
              geometry.setCenter(vertex);
              this.changingFeature_ = false;
            } else { // We're dragging the circle's circumference:
              this.changingFeature_ = true;
              geometry.setRadius(distance(geometry.getCenter(), vertex));
              this.changingFeature_ = false;
            }
            break;
          default:
            // pass
        }

        if (coordinates) {
          this.setGeometryCoordinates_(geometry, coordinates);
        }
      }
      this.createOrUpdateVertexFeature_(vertex);
    };

    /**
     * @inheritDoc
     */
    Modify.prototype.handleDownEvent = function handleDownEvent (evt) {
      if (!this.condition_(evt)) {
        return false;
      }
      this.handlePointerAtPixel_(evt.pixel, evt.map);
      var pixelCoordinate = evt.map.getCoordinateFromPixel(evt.pixel);
      this.dragSegments_.length = 0;
      this.modified_ = false;
      var vertexFeature = this.vertexFeature_;
      if (vertexFeature) {
        var insertVertices = [];
        var geometry = /** @type {Point} */ (vertexFeature.getGeometry());
        var vertex = geometry.getCoordinates();
        var vertexExtent = boundingExtent([vertex]);
        var segmentDataMatches = this.rBush_.getInExtent(vertexExtent);
        var componentSegments = {};
        segmentDataMatches.sort(compareIndexes);
        for (var i = 0, ii = segmentDataMatches.length; i < ii; ++i) {
          var segmentDataMatch = segmentDataMatches[i];
          var segment = segmentDataMatch.segment;
          var uid = getUid(segmentDataMatch.feature);
          var depth = segmentDataMatch.depth;
          if (depth) {
            uid += '-' + depth.join('-'); // separate feature components
          }
          if (!componentSegments[uid]) {
            componentSegments[uid] = new Array(2);
          }
          if (segmentDataMatch.geometry.getType() === GeometryType.CIRCLE &&
          segmentDataMatch.index === CIRCLE_CIRCUMFERENCE_INDEX) {

            var closestVertex = closestOnSegmentData(pixelCoordinate, segmentDataMatch);
            if (equals$1(closestVertex, vertex) && !componentSegments[uid][0]) {
              this.dragSegments_.push([segmentDataMatch, 0]);
              componentSegments[uid][0] = segmentDataMatch;
            }
          } else if (equals$1(segment[0], vertex) &&
              !componentSegments[uid][0]) {
            this.dragSegments_.push([segmentDataMatch, 0]);
            componentSegments[uid][0] = segmentDataMatch;
          } else if (equals$1(segment[1], vertex) &&
              !componentSegments[uid][1]) {

            // prevent dragging closed linestrings by the connecting node
            if ((segmentDataMatch.geometry.getType() ===
                GeometryType.LINE_STRING ||
                segmentDataMatch.geometry.getType() ===
                GeometryType.MULTI_LINE_STRING) &&
                componentSegments[uid][0] &&
                componentSegments[uid][0].index === 0) {
              continue;
            }

            this.dragSegments_.push([segmentDataMatch, 1]);
            componentSegments[uid][1] = segmentDataMatch;
          } else if (this.insertVertexCondition_(evt) && getUid(segment) in this.vertexSegments_ &&
              (!componentSegments[uid][0] && !componentSegments[uid][1])) {
            insertVertices.push([segmentDataMatch, vertex]);
          }
        }
        if (insertVertices.length) {
          this.willModifyFeatures_(evt);
        }
        for (var j = insertVertices.length - 1; j >= 0; --j) {
          this.insertVertex_.apply(this, insertVertices[j]);
        }
      }
      return !!this.vertexFeature_;
    };

    /**
     * @inheritDoc
     */
    Modify.prototype.handleUpEvent = function handleUpEvent (evt) {
      for (var i = this.dragSegments_.length - 1; i >= 0; --i) {
        var segmentData = this.dragSegments_[i][0];
        var geometry = segmentData.geometry;
        if (geometry.getType() === GeometryType.CIRCLE) {
          // Update a circle object in the R* bush:
          var coordinates = geometry.getCenter();
          var centerSegmentData = segmentData.featureSegments[0];
          var circumferenceSegmentData = segmentData.featureSegments[1];
          centerSegmentData.segment[0] = centerSegmentData.segment[1] = coordinates;
          circumferenceSegmentData.segment[0] = circumferenceSegmentData.segment[1] = coordinates;
          this.rBush_.update(createOrUpdateFromCoordinate(coordinates), centerSegmentData);
          this.rBush_.update(geometry.getExtent(), circumferenceSegmentData);
        } else {
          this.rBush_.update(boundingExtent(segmentData.segment), segmentData);
        }
      }
      if (this.modified_) {
        this.dispatchEvent(new ModifyEvent(ModifyEventType.MODIFYEND, this.features_, evt));
        this.modified_ = false;
      }
      return false;
    };

    /**
     * @param {import("../MapBrowserEvent.js").default} evt Event.
     * @private
     */
    Modify.prototype.handlePointerMove_ = function handlePointerMove_ (evt) {
      this.lastPixel_ = evt.pixel;
      this.handlePointerAtPixel_(evt.pixel, evt.map);
    };

    /**
     * @param {import("../pixel.js").Pixel} pixel Pixel
     * @param {import("../PluggableMap.js").default} map Map.
     * @private
     */
    Modify.prototype.handlePointerAtPixel_ = function handlePointerAtPixel_ (pixel, map) {
      var pixelCoordinate = map.getCoordinateFromPixel(pixel);
      var sortByDistance = function(a, b) {
        return pointDistanceToSegmentDataSquared(pixelCoordinate, a) -
            pointDistanceToSegmentDataSquared(pixelCoordinate, b);
      };

      var box = buffer(createOrUpdateFromCoordinate(pixelCoordinate),
        map.getView().getResolution() * this.pixelTolerance_);

      var rBush = this.rBush_;
      var nodes = rBush.getInExtent(box);
      if (nodes.length > 0) {
        nodes.sort(sortByDistance);
        var node = nodes[0];
        var closestSegment = node.segment;
        var vertex = closestOnSegmentData(pixelCoordinate, node);
        var vertexPixel = map.getPixelFromCoordinate(vertex);
        var dist = distance(pixel, vertexPixel);
        if (dist <= this.pixelTolerance_) {
          /** @type {Object<string, boolean>} */
          var vertexSegments = {};

          if (node.geometry.getType() === GeometryType.CIRCLE &&
          node.index === CIRCLE_CIRCUMFERENCE_INDEX) {

            this.snappedToVertex_ = true;
            this.createOrUpdateVertexFeature_(vertex);
          } else {
            var pixel1 = map.getPixelFromCoordinate(closestSegment[0]);
            var pixel2 = map.getPixelFromCoordinate(closestSegment[1]);
            var squaredDist1 = squaredDistance$1(vertexPixel, pixel1);
            var squaredDist2 = squaredDistance$1(vertexPixel, pixel2);
            dist = Math.sqrt(Math.min(squaredDist1, squaredDist2));
            this.snappedToVertex_ = dist <= this.pixelTolerance_;
            if (this.snappedToVertex_) {
              vertex = squaredDist1 > squaredDist2 ? closestSegment[1] : closestSegment[0];
            }
            this.createOrUpdateVertexFeature_(vertex);
            for (var i = 1, ii = nodes.length; i < ii; ++i) {
              var segment = nodes[i].segment;
              if ((equals$1(closestSegment[0], segment[0]) &&
                  equals$1(closestSegment[1], segment[1]) ||
                  (equals$1(closestSegment[0], segment[1]) &&
                  equals$1(closestSegment[1], segment[0])))) {
                vertexSegments[getUid(segment)] = true;
              } else {
                break;
              }
            }
          }

          vertexSegments[getUid(closestSegment)] = true;
          this.vertexSegments_ = vertexSegments;
          return;
        }
      }
      if (this.vertexFeature_) {
        /** @type {VectorSource} */ (this.overlay_.getSource()).removeFeature(this.vertexFeature_);
        this.vertexFeature_ = null;
      }
    };

    /**
     * @param {SegmentData} segmentData Segment data.
     * @param {import("../coordinate.js").Coordinate} vertex Vertex.
     * @private
     */
    Modify.prototype.insertVertex_ = function insertVertex_ (segmentData, vertex) {
      var segment = segmentData.segment;
      var feature = segmentData.feature;
      var geometry = segmentData.geometry;
      var depth = segmentData.depth;
      var index = /** @type {number} */ (segmentData.index);
      var coordinates;

      while (vertex.length < geometry.getStride()) {
        vertex.push(0);
      }

      switch (geometry.getType()) {
        case GeometryType.MULTI_LINE_STRING:
          coordinates = geometry.getCoordinates();
          coordinates[depth[0]].splice(index + 1, 0, vertex);
          break;
        case GeometryType.POLYGON:
          coordinates = geometry.getCoordinates();
          coordinates[depth[0]].splice(index + 1, 0, vertex);
          break;
        case GeometryType.MULTI_POLYGON:
          coordinates = geometry.getCoordinates();
          coordinates[depth[1]][depth[0]].splice(index + 1, 0, vertex);
          break;
        case GeometryType.LINE_STRING:
          coordinates = geometry.getCoordinates();
          coordinates.splice(index + 1, 0, vertex);
          break;
        default:
          return;
      }

      this.setGeometryCoordinates_(geometry, coordinates);
      var rTree = this.rBush_;
      rTree.remove(segmentData);
      this.updateSegmentIndices_(geometry, index, depth, 1);
      var newSegmentData = /** @type {SegmentData} */ ({
        segment: [segment[0], vertex],
        feature: feature,
        geometry: geometry,
        depth: depth,
        index: index
      });
      rTree.insert(boundingExtent(newSegmentData.segment),
        newSegmentData);
      this.dragSegments_.push([newSegmentData, 1]);

      var newSegmentData2 = /** @type {SegmentData} */ ({
        segment: [vertex, segment[1]],
        feature: feature,
        geometry: geometry,
        depth: depth,
        index: index + 1
      });
      rTree.insert(boundingExtent(newSegmentData2.segment), newSegmentData2);
      this.dragSegments_.push([newSegmentData2, 0]);
      this.ignoreNextSingleClick_ = true;
    };

    /**
     * Removes the vertex currently being pointed.
     * @return {boolean} True when a vertex was removed.
     * @api
     */
    Modify.prototype.removePoint = function removePoint () {
      if (this.lastPointerEvent_ && this.lastPointerEvent_.type != MapBrowserEventType.POINTERDRAG) {
        var evt = this.lastPointerEvent_;
        this.willModifyFeatures_(evt);
        this.removeVertex_();
        this.dispatchEvent(new ModifyEvent(ModifyEventType.MODIFYEND, this.features_, evt));
        this.modified_ = false;
        return true;
      }
      return false;
    };

    /**
     * Removes a vertex from all matching features.
     * @return {boolean} True when a vertex was removed.
     * @private
     */
    Modify.prototype.removeVertex_ = function removeVertex_ () {
      var dragSegments = this.dragSegments_;
      var segmentsByFeature = {};
      var deleted = false;
      var component, coordinates, dragSegment, geometry, i, index, left;
      var newIndex, right, segmentData, uid;
      for (i = dragSegments.length - 1; i >= 0; --i) {
        dragSegment = dragSegments[i];
        segmentData = dragSegment[0];
        uid = getUid(segmentData.feature);
        if (segmentData.depth) {
          // separate feature components
          uid += '-' + segmentData.depth.join('-');
        }
        if (!(uid in segmentsByFeature)) {
          segmentsByFeature[uid] = {};
        }
        if (dragSegment[1] === 0) {
          segmentsByFeature[uid].right = segmentData;
          segmentsByFeature[uid].index = segmentData.index;
        } else if (dragSegment[1] == 1) {
          segmentsByFeature[uid].left = segmentData;
          segmentsByFeature[uid].index = segmentData.index + 1;
        }

      }
      for (uid in segmentsByFeature) {
        right = segmentsByFeature[uid].right;
        left = segmentsByFeature[uid].left;
        index = segmentsByFeature[uid].index;
        newIndex = index - 1;
        if (left !== undefined) {
          segmentData = left;
        } else {
          segmentData = right;
        }
        if (newIndex < 0) {
          newIndex = 0;
        }
        geometry = segmentData.geometry;
        coordinates = geometry.getCoordinates();
        component = coordinates;
        deleted = false;
        switch (geometry.getType()) {
          case GeometryType.MULTI_LINE_STRING:
            if (coordinates[segmentData.depth[0]].length > 2) {
              coordinates[segmentData.depth[0]].splice(index, 1);
              deleted = true;
            }
            break;
          case GeometryType.LINE_STRING:
            if (coordinates.length > 2) {
              coordinates.splice(index, 1);
              deleted = true;
            }
            break;
          case GeometryType.MULTI_POLYGON:
            component = component[segmentData.depth[1]];
            /* falls through */
          case GeometryType.POLYGON:
            component = component[segmentData.depth[0]];
            if (component.length > 4) {
              if (index == component.length - 1) {
                index = 0;
              }
              component.splice(index, 1);
              deleted = true;
              if (index === 0) {
                // close the ring again
                component.pop();
                component.push(component[0]);
                newIndex = component.length - 1;
              }
            }
            break;
          default:
            // pass
        }

        if (deleted) {
          this.setGeometryCoordinates_(geometry, coordinates);
          var segments = [];
          if (left !== undefined) {
            this.rBush_.remove(left);
            segments.push(left.segment[0]);
          }
          if (right !== undefined) {
            this.rBush_.remove(right);
            segments.push(right.segment[1]);
          }
          if (left !== undefined && right !== undefined) {
            var newSegmentData = /** @type {SegmentData} */ ({
              depth: segmentData.depth,
              feature: segmentData.feature,
              geometry: segmentData.geometry,
              index: newIndex,
              segment: segments
            });
            this.rBush_.insert(boundingExtent(newSegmentData.segment),
              newSegmentData);
          }
          this.updateSegmentIndices_(geometry, index, segmentData.depth, -1);
          if (this.vertexFeature_) {
            /** @type {VectorSource} */ (this.overlay_.getSource()).removeFeature(this.vertexFeature_);
            this.vertexFeature_ = null;
          }
          dragSegments.length = 0;
        }

      }
      return deleted;
    };

    /**
     * @param {import("../geom/SimpleGeometry.js").default} geometry Geometry.
     * @param {Array} coordinates Coordinates.
     * @private
     */
    Modify.prototype.setGeometryCoordinates_ = function setGeometryCoordinates_ (geometry, coordinates) {
      this.changingFeature_ = true;
      geometry.setCoordinates(coordinates);
      this.changingFeature_ = false;
    };

    /**
     * @param {import("../geom/SimpleGeometry.js").default} geometry Geometry.
     * @param {number} index Index.
     * @param {Array<number>|undefined} depth Depth.
     * @param {number} delta Delta (1 or -1).
     * @private
     */
    Modify.prototype.updateSegmentIndices_ = function updateSegmentIndices_ (geometry, index, depth, delta) {
      this.rBush_.forEachInExtent(geometry.getExtent(), function(segmentDataMatch) {
        if (segmentDataMatch.geometry === geometry &&
            (depth === undefined || segmentDataMatch.depth === undefined ||
            equals(segmentDataMatch.depth, depth)) &&
            segmentDataMatch.index > index) {
          segmentDataMatch.index += delta;
        }
      });
    };

    return Modify;
  }(PointerInteraction));


  /**
   * @param {SegmentData} a The first segment data.
   * @param {SegmentData} b The second segment data.
   * @return {number} The difference in indexes.
   */
  function compareIndexes(a, b) {
    return a.index - b.index;
  }


  /**
   * Returns the distance from a point to a line segment.
   *
   * @param {import("../coordinate.js").Coordinate} pointCoordinates The coordinates of the point from
   *        which to calculate the distance.
   * @param {SegmentData} segmentData The object describing the line
   *        segment we are calculating the distance to.
   * @return {number} The square of the distance between a point and a line segment.
   */
  function pointDistanceToSegmentDataSquared(pointCoordinates, segmentData) {
    var geometry = segmentData.geometry;

    if (geometry.getType() === GeometryType.CIRCLE) {
      var circleGeometry = /** @type {import("../geom/Circle.js").default} */ (geometry);

      if (segmentData.index === CIRCLE_CIRCUMFERENCE_INDEX) {
        var distanceToCenterSquared =
              squaredDistance$1(circleGeometry.getCenter(), pointCoordinates);
        var distanceToCircumference =
              Math.sqrt(distanceToCenterSquared) - circleGeometry.getRadius();
        return distanceToCircumference * distanceToCircumference;
      }
    }
    return squaredDistanceToSegment(pointCoordinates, segmentData.segment);
  }

  /**
   * Returns the point closest to a given line segment.
   *
   * @param {import("../coordinate.js").Coordinate} pointCoordinates The point to which a closest point
   *        should be found.
   * @param {SegmentData} segmentData The object describing the line
   *        segment which should contain the closest point.
   * @return {import("../coordinate.js").Coordinate} The point closest to the specified line segment.
   */
  function closestOnSegmentData(pointCoordinates, segmentData) {
    var geometry = segmentData.geometry;

    if (geometry.getType() === GeometryType.CIRCLE &&
    segmentData.index === CIRCLE_CIRCUMFERENCE_INDEX) {
      return geometry.getClosestPoint(pointCoordinates);
    }
    return closestOnSegment(pointCoordinates, segmentData.segment);
  }


  /**
   * @return {import("../style/Style.js").StyleFunction} Styles.
   */
  function getDefaultStyleFunction$1() {
    var style = createEditingStyle();
    return function(feature, resolution) {
      return style[GeometryType.POINT];
    };
  }

  /**
   * @module ol/interaction/Select
   */


  /**
   * @enum {string}
   */
  var SelectEventType = {
    /**
     * Triggered when feature(s) has been (de)selected.
     * @event SelectEvent#select
     * @api
     */
    SELECT: 'select'
  };


  /**
   * A function that takes an {@link module:ol/Feature} or
   * {@link module:ol/render/Feature} and an
   * {@link module:ol/layer/Layer} and returns `true` if the feature may be
   * selected or `false` otherwise.
   * @typedef {function(import("../Feature.js").FeatureLike, import("../layer/Layer.js").default):boolean} FilterFunction
   */


  /**
   * @typedef {Object} Options
   * @property {import("../events/condition.js").Condition} [addCondition] A function
   * that takes an {@link module:ol/MapBrowserEvent~MapBrowserEvent} and returns a
   * boolean to indicate whether that event should be handled.
   * By default, this is {@link module:ol/events/condition~never}. Use this if you
   * want to use different events for add and remove instead of `toggle`.
   * @property {import("../events/condition.js").Condition} [condition] A function that
   * takes an {@link module:ol/MapBrowserEvent~MapBrowserEvent} and returns a
   * boolean to indicate whether that event should be handled. This is the event
   * for the selected features as a whole. By default, this is
   * {@link module:ol/events/condition~singleClick}. Clicking on a feature selects that
   * feature and removes any that were in the selection. Clicking outside any
   * feature removes all from the selection.
   * See `toggle`, `add`, `remove` options for adding/removing extra features to/
   * from the selection.
   * @property {Array<import("../layer/Layer.js").default>|function(import("../layer/Layer.js").default): boolean} [layers]
   * A list of layers from which features should be selected. Alternatively, a
   * filter function can be provided. The function will be called for each layer
   * in the map and should return `true` for layers that you want to be
   * selectable. If the option is absent, all visible layers will be considered
   * selectable.
   * @property {import("../style/Style.js").StyleLike} [style]
   * Style for the selected features. By default the default edit style is used
   * (see {@link module:ol/style}).
   * @property {import("../events/condition.js").Condition} [removeCondition] A function
   * that takes an {@link module:ol/MapBrowserEvent~MapBrowserEvent} and returns a
   * boolean to indicate whether that event should be handled.
   * By default, this is {@link module:ol/events/condition~never}. Use this if you
   * want to use different events for add and remove instead of `toggle`.
   * @property {import("../events/condition.js").Condition} [toggleCondition] A function
   * that takes an {@link module:ol/MapBrowserEvent~MapBrowserEvent} and returns a
   * boolean to indicate whether that event should be handled. This is in addition
   * to the `condition` event. By default,
   * {@link module:ol/events/condition~shiftKeyOnly}, i.e. pressing `shift` as
   * well as the `condition` event, adds that feature to the current selection if
   * it is not currently selected, and removes it if it is. See `add` and `remove`
   * if you want to use different events instead of a toggle.
   * @property {boolean} [multi=false] A boolean that determines if the default
   * behaviour should select only single features or all (overlapping) features at
   * the clicked map position. The default of `false` means single select.
   * @property {import("../Collection.js").default<import("../Feature.js").default>} [features]
   * Collection where the interaction will place selected features. Optional. If
   * not set the interaction will create a collection. In any case the collection
   * used by the interaction is returned by
   * {@link module:ol/interaction/Select~Select#getFeatures}.
   * @property {FilterFunction} [filter] A function
   * that takes an {@link module:ol/Feature} and an
   * {@link module:ol/layer/Layer} and returns `true` if the feature may be
   * selected or `false` otherwise.
   * @property {boolean} [wrapX=true] Wrap the world horizontally on the selection
   * overlay.
   * @property {number} [hitTolerance=0] Hit-detection tolerance. Pixels inside
   * the radius around the given position will be checked for features. This only
   * works for the canvas renderer and not for WebGL.
   */


  /**
   * @classdesc
   * Events emitted by {@link module:ol/interaction/Select~Select} instances are instances of
   * this type.
   */
  var SelectEvent = /*@__PURE__*/(function (Event$$1) {
    function SelectEvent(type, selected, deselected, mapBrowserEvent) {
      Event$$1.call(this, type);

      /**
       * Selected features array.
       * @type {Array<import("../Feature.js").default>}
       * @api
       */
      this.selected = selected;

      /**
       * Deselected features array.
       * @type {Array<import("../Feature.js").default>}
       * @api
       */
      this.deselected = deselected;

      /**
       * Associated {@link module:ol/MapBrowserEvent}.
       * @type {import("../MapBrowserEvent.js").default}
       * @api
       */
      this.mapBrowserEvent = mapBrowserEvent;

    }

    if ( Event$$1 ) SelectEvent.__proto__ = Event$$1;
    SelectEvent.prototype = Object.create( Event$$1 && Event$$1.prototype );
    SelectEvent.prototype.constructor = SelectEvent;

    return SelectEvent;
  }(Event));


  /**
   * @classdesc
   * Interaction for selecting vector features. By default, selected features are
   * styled differently, so this interaction can be used for visual highlighting,
   * as well as selecting features for other actions, such as modification or
   * output. There are three ways of controlling which features are selected:
   * using the browser event as defined by the `condition` and optionally the
   * `toggle`, `add`/`remove`, and `multi` options; a `layers` filter; and a
   * further feature filter using the `filter` option.
   *
   * Selected features are added to an internal unmanaged layer.
   *
   * @fires SelectEvent
   * @api
   */
  var Select = /*@__PURE__*/(function (Interaction$$1) {
    function Select(opt_options) {

      Interaction$$1.call(this, {
        handleEvent: handleEvent$3
      });

      var options = opt_options ? opt_options : {};

      /**
       * @private
       * @type {import("../events/condition.js").Condition}
       */
      this.condition_ = options.condition ? options.condition : singleClick;

      /**
       * @private
       * @type {import("../events/condition.js").Condition}
       */
      this.addCondition_ = options.addCondition ? options.addCondition : never;

      /**
       * @private
       * @type {import("../events/condition.js").Condition}
       */
      this.removeCondition_ = options.removeCondition ? options.removeCondition : never;

      /**
       * @private
       * @type {import("../events/condition.js").Condition}
       */
      this.toggleCondition_ = options.toggleCondition ? options.toggleCondition : shiftKeyOnly;

      /**
       * @private
       * @type {boolean}
       */
      this.multi_ = options.multi ? options.multi : false;

      /**
       * @private
       * @type {FilterFunction}
       */
      this.filter_ = options.filter ? options.filter : TRUE;

      /**
       * @private
       * @type {number}
       */
      this.hitTolerance_ = options.hitTolerance ? options.hitTolerance : 0;

      var featureOverlay = new VectorLayer({
        source: new VectorSource({
          useSpatialIndex: false,
          features: options.features,
          wrapX: options.wrapX
        }),
        style: options.style ? options.style :
          getDefaultStyleFunction$2(),
        updateWhileAnimating: true,
        updateWhileInteracting: true
      });

      /**
       * @private
       * @type {VectorLayer}
       */
      this.featureOverlay_ = featureOverlay;

      /** @type {function(import("../layer/Layer.js").default): boolean} */
      var layerFilter;
      if (options.layers) {
        if (typeof options.layers === 'function') {
          layerFilter = options.layers;
        } else {
          var layers = options.layers;
          layerFilter = function(layer) {
            return includes(layers, layer);
          };
        }
      } else {
        layerFilter = TRUE;
      }

      /**
       * @private
       * @type {function(import("../layer/Layer.js").default): boolean}
       */
      this.layerFilter_ = layerFilter;

      /**
       * An association between selected feature (key)
       * and layer (value)
       * @private
       * @type {Object<string, import("../layer/Layer.js").default>}
       */
      this.featureLayerAssociation_ = {};

      var features = this.getFeatures();
      listen(features, CollectionEventType.ADD,
        this.addFeature_, this);
      listen(features, CollectionEventType.REMOVE,
        this.removeFeature_, this);
    }

    if ( Interaction$$1 ) Select.__proto__ = Interaction$$1;
    Select.prototype = Object.create( Interaction$$1 && Interaction$$1.prototype );
    Select.prototype.constructor = Select;

    /**
     * @param {import("../Feature.js").FeatureLike} feature Feature.
     * @param {import("../layer/Layer.js").default} layer Layer.
     * @private
     */
    Select.prototype.addFeatureLayerAssociation_ = function addFeatureLayerAssociation_ (feature, layer) {
      this.featureLayerAssociation_[getUid(feature)] = layer;
    };

    /**
     * Get the selected features.
     * @return {import("../Collection.js").default<import("../Feature.js").default>} Features collection.
     * @api
     */
    Select.prototype.getFeatures = function getFeatures () {
      return /** @type {VectorSource} */ (this.featureOverlay_.getSource()).getFeaturesCollection();
    };

    /**
     * Returns the Hit-detection tolerance.
     * @returns {number} Hit tolerance in pixels.
     * @api
     */
    Select.prototype.getHitTolerance = function getHitTolerance () {
      return this.hitTolerance_;
    };

    /**
     * Returns the associated {@link module:ol/layer/Vector~Vector vectorlayer} of
     * the (last) selected feature. Note that this will not work with any
     * programmatic method like pushing features to
     * {@link module:ol/interaction/Select~Select#getFeatures collection}.
     * @param {import("../Feature.js").FeatureLike} feature Feature
     * @return {VectorLayer} Layer.
     * @api
     */
    Select.prototype.getLayer = function getLayer (feature) {
      return (
        /** @type {VectorLayer} */ (this.featureLayerAssociation_[getUid(feature)])
      );
    };

    /**
     * Get the overlay layer that this interaction renders selected features to.
     * @return {VectorLayer} Overlay layer.
     * @api
     */
    Select.prototype.getOverlay = function getOverlay () {
      return this.featureOverlay_;
    };

    /**
     * Hit-detection tolerance. Pixels inside the radius around the given position
     * will be checked for features. This only works for the canvas renderer and
     * not for WebGL.
     * @param {number} hitTolerance Hit tolerance in pixels.
     * @api
     */
    Select.prototype.setHitTolerance = function setHitTolerance (hitTolerance) {
      this.hitTolerance_ = hitTolerance;
    };

    /**
     * Remove the interaction from its current map, if any,  and attach it to a new
     * map, if any. Pass `null` to just remove the interaction from the current map.
     * @param {import("../PluggableMap.js").default} map Map.
     * @override
     * @api
     */
    Select.prototype.setMap = function setMap (map) {
      var currentMap = this.getMap();
      var selectedFeatures = this.getFeatures();
      if (currentMap) {
        selectedFeatures.forEach(currentMap.unskipFeature.bind(currentMap));
      }
      Interaction$$1.prototype.setMap.call(this, map);
      this.featureOverlay_.setMap(map);
      if (map) {
        selectedFeatures.forEach(map.skipFeature.bind(map));
      }
    };

    /**
     * @param {import("../Collection.js").CollectionEvent} evt Event.
     * @private
     */
    Select.prototype.addFeature_ = function addFeature_ (evt) {
      var map = this.getMap();
      if (map) {
        map.skipFeature(/** @type {import("../Feature.js").default} */ (evt.element));
      }
    };

    /**
     * @param {import("../Collection.js").CollectionEvent} evt Event.
     * @private
     */
    Select.prototype.removeFeature_ = function removeFeature_ (evt) {
      var map = this.getMap();
      if (map) {
        map.unskipFeature(/** @type {import("../Feature.js").default} */ (evt.element));
      }
    };

    /**
     * @param {import("../Feature.js").FeatureLike} feature Feature.
     * @private
     */
    Select.prototype.removeFeatureLayerAssociation_ = function removeFeatureLayerAssociation_ (feature) {
      delete this.featureLayerAssociation_[getUid(feature)];
    };

    return Select;
  }(Interaction));


  /**
   * Handles the {@link module:ol/MapBrowserEvent map browser event} and may change the
   * selected state of features.
   * @param {import("../MapBrowserEvent.js").default} mapBrowserEvent Map browser event.
   * @return {boolean} `false` to stop event propagation.
   * @this {Select}
   */
  function handleEvent$3(mapBrowserEvent) {
    if (!this.condition_(mapBrowserEvent)) {
      return true;
    }
    var add = this.addCondition_(mapBrowserEvent);
    var remove$$1 = this.removeCondition_(mapBrowserEvent);
    var toggle = this.toggleCondition_(mapBrowserEvent);
    var set = !add && !remove$$1 && !toggle;
    var map = mapBrowserEvent.map;
    var features = this.getFeatures();
    var deselected = [];
    var selected = [];
    if (set) {
      // Replace the currently selected feature(s) with the feature(s) at the
      // pixel, or clear the selected feature(s) if there is no feature at
      // the pixel.
      clear(this.featureLayerAssociation_);
      map.forEachFeatureAtPixel(mapBrowserEvent.pixel,
        (
          /**
           * @param {import("../Feature.js").FeatureLike} feature Feature.
           * @param {import("../layer/Layer.js").default} layer Layer.
           * @return {boolean|undefined} Continue to iterate over the features.
           */
          function(feature, layer) {
            if (this.filter_(feature, layer)) {
              selected.push(feature);
              this.addFeatureLayerAssociation_(feature, layer);
              return !this.multi_;
            }
          }).bind(this), {
          layerFilter: this.layerFilter_,
          hitTolerance: this.hitTolerance_
        });
      for (var i = features.getLength() - 1; i >= 0; --i) {
        var feature = features.item(i);
        var index = selected.indexOf(feature);
        if (index > -1) {
          // feature is already selected
          selected.splice(index, 1);
        } else {
          features.remove(feature);
          deselected.push(feature);
        }
      }
      if (selected.length !== 0) {
        features.extend(selected);
      }
    } else {
      // Modify the currently selected feature(s).
      map.forEachFeatureAtPixel(mapBrowserEvent.pixel,
        (
          /**
           * @param {import("../Feature.js").FeatureLike} feature Feature.
           * @param {import("../layer/Layer.js").default} layer Layer.
           * @return {boolean|undefined} Continue to iterate over the features.
           */
          function(feature, layer) {
            if (this.filter_(feature, layer)) {
              if ((add || toggle) && !includes(features.getArray(), feature)) {
                selected.push(feature);
                this.addFeatureLayerAssociation_(feature, layer);
              } else if ((remove$$1 || toggle) && includes(features.getArray(), feature)) {
                deselected.push(feature);
                this.removeFeatureLayerAssociation_(feature);
              }
              return !this.multi_;
            }
          }).bind(this), {
          layerFilter: this.layerFilter_,
          hitTolerance: this.hitTolerance_
        });
      for (var j = deselected.length - 1; j >= 0; --j) {
        features.remove(deselected[j]);
      }
      features.extend(selected);
    }
    if (selected.length > 0 || deselected.length > 0) {
      this.dispatchEvent(
        new SelectEvent(SelectEventType.SELECT,
          selected, deselected, mapBrowserEvent));
    }
    return pointerMove$1(mapBrowserEvent);
  }


  /**
   * @return {import("../style/Style.js").StyleFunction} Styles.
   */
  function getDefaultStyleFunction$2() {
    var styles = createEditingStyle();
    extend(styles[GeometryType.POLYGON], styles[GeometryType.LINE_STRING]);
    extend(styles[GeometryType.GEOMETRY_COLLECTION], styles[GeometryType.LINE_STRING]);

    return function(feature, resolution) {
      if (!feature.getGeometry()) {
        return null;
      }
      return styles[feature.getGeometry().getType()];
    };
  }

  /**
   * @module ol/interaction/Snap
   */


  /**
   * @typedef {Object} Result
   * @property {boolean} snapped
   * @property {import("../coordinate.js").Coordinate|null} vertex
   * @property {import("../pixel.js").Pixel|null} vertexPixel
   */


  /**
   * @typedef {Object} SegmentData
   * @property {import("../Feature.js").default} feature
   * @property {Array<import("../coordinate.js").Coordinate>} segment
   */


  /**
   * @typedef {Object} Options
   * @property {import("../Collection.js").default<import("../Feature.js").default>} [features] Snap to these features. Either this option or source should be provided.
   * @property {boolean} [edge=true] Snap to edges.
   * @property {boolean} [vertex=true] Snap to vertices.
   * @property {number} [pixelTolerance=10] Pixel tolerance for considering the pointer close enough to a segment or
   * vertex for snapping.
   * @property {import("../source/Vector.js").default} [source] Snap to features from this source. Either this option or features should be provided
   */


  /**
   * @param  {import("../source/Vector.js").VectorSourceEvent|import("../Collection.js").CollectionEvent} evt Event.
   * @return {import("../Feature.js").default} Feature.
   */
  function getFeatureFromEvent(evt) {
    if (/** @type {import("../source/Vector.js").VectorSourceEvent} */ (evt).feature) {
      return /** @type {import("../source/Vector.js").VectorSourceEvent} */ (evt).feature;
    } else if (/** @type {import("../Collection.js").CollectionEvent} */ (evt).element) {
      return /** @type {import("../Feature.js").default} */ (/** @type {import("../Collection.js").CollectionEvent} */ (evt).element);
    }

  }

  /**
   * @classdesc
   * Handles snapping of vector features while modifying or drawing them.  The
   * features can come from a {@link module:ol/source/Vector} or {@link module:ol/Collection~Collection}
   * Any interaction object that allows the user to interact
   * with the features using the mouse can benefit from the snapping, as long
   * as it is added before.
   *
   * The snap interaction modifies map browser event `coordinate` and `pixel`
   * properties to force the snap to occur to any interaction that them.
   *
   * Example:
   *
   *     import Snap from 'ol/interaction/Snap';
   *
   *     var snap = new Snap({
   *       source: source
   *     });
   *
   * @api
   */
  var Snap = /*@__PURE__*/(function (PointerInteraction$$1) {
    function Snap(opt_options) {

      var options = opt_options ? opt_options : {};

      var pointerOptions = /** @type {import("./Pointer.js").Options} */ (options);

      if (!pointerOptions.handleDownEvent) {
        pointerOptions.handleDownEvent = TRUE;
      }

      if (!pointerOptions.stopDown) {
        pointerOptions.stopDown = FALSE;
      }

      PointerInteraction$$1.call(this, pointerOptions);

      /**
       * @type {import("../source/Vector.js").default}
       * @private
       */
      this.source_ = options.source ? options.source : null;

      /**
       * @private
       * @type {boolean}
       */
      this.vertex_ = options.vertex !== undefined ? options.vertex : true;

      /**
       * @private
       * @type {boolean}
       */
      this.edge_ = options.edge !== undefined ? options.edge : true;

      /**
       * @type {import("../Collection.js").default<import("../Feature.js").default>}
       * @private
       */
      this.features_ = options.features ? options.features : null;

      /**
       * @type {Array<import("../events.js").EventsKey>}
       * @private
       */
      this.featuresListenerKeys_ = [];

      /**
       * @type {Object<string, import("../events.js").EventsKey>}
       * @private
       */
      this.featureChangeListenerKeys_ = {};

      /**
       * Extents are preserved so indexed segment can be quickly removed
       * when its feature geometry changes
       * @type {Object<string, import("../extent.js").Extent>}
       * @private
       */
      this.indexedFeaturesExtents_ = {};

      /**
       * If a feature geometry changes while a pointer drag|move event occurs, the
       * feature doesn't get updated right away.  It will be at the next 'pointerup'
       * event fired.
       * @type {!Object<string, import("../Feature.js").default>}
       * @private
       */
      this.pendingFeatures_ = {};

      /**
       * Used for distance sorting in sortByDistance_
       * @type {import("../coordinate.js").Coordinate}
       * @private
       */
      this.pixelCoordinate_ = null;

      /**
       * @type {number}
       * @private
       */
      this.pixelTolerance_ = options.pixelTolerance !== undefined ?
        options.pixelTolerance : 10;

      /**
       * @type {function(SegmentData, SegmentData): number}
       * @private
       */
      this.sortByDistance_ = sortByDistance.bind(this);


      /**
      * Segment RTree for each layer
      * @type {import("../structs/RBush.js").default<SegmentData>}
      * @private
      */
      this.rBush_ = new RBush();


      /**
      * @const
      * @private
      * @type {Object<string, function(import("../Feature.js").default, import("../geom/Geometry.js").default)>}
      */
      this.SEGMENT_WRITERS_ = {
        'Point': this.writePointGeometry_,
        'LineString': this.writeLineStringGeometry_,
        'LinearRing': this.writeLineStringGeometry_,
        'Polygon': this.writePolygonGeometry_,
        'MultiPoint': this.writeMultiPointGeometry_,
        'MultiLineString': this.writeMultiLineStringGeometry_,
        'MultiPolygon': this.writeMultiPolygonGeometry_,
        'GeometryCollection': this.writeGeometryCollectionGeometry_,
        'Circle': this.writeCircleGeometry_
      };
    }

    if ( PointerInteraction$$1 ) Snap.__proto__ = PointerInteraction$$1;
    Snap.prototype = Object.create( PointerInteraction$$1 && PointerInteraction$$1.prototype );
    Snap.prototype.constructor = Snap;

    /**
     * Add a feature to the collection of features that we may snap to.
     * @param {import("../Feature.js").default} feature Feature.
     * @param {boolean=} opt_listen Whether to listen to the feature change or not
     *     Defaults to `true`.
     * @api
     */
    Snap.prototype.addFeature = function addFeature (feature, opt_listen) {
      var register = opt_listen !== undefined ? opt_listen : true;
      var feature_uid = getUid(feature);
      var geometry = feature.getGeometry();
      if (geometry) {
        var segmentWriter = this.SEGMENT_WRITERS_[geometry.getType()];
        if (segmentWriter) {
          this.indexedFeaturesExtents_[feature_uid] = geometry.getExtent(createEmpty());
          segmentWriter.call(this, feature, geometry);
        }
      }

      if (register) {
        this.featureChangeListenerKeys_[feature_uid] = listen(
          feature,
          EventType.CHANGE,
          this.handleFeatureChange_, this);
      }
    };

    /**
     * @param {import("../Feature.js").default} feature Feature.
     * @private
     */
    Snap.prototype.forEachFeatureAdd_ = function forEachFeatureAdd_ (feature) {
      this.addFeature(feature);
    };

    /**
     * @param {import("../Feature.js").default} feature Feature.
     * @private
     */
    Snap.prototype.forEachFeatureRemove_ = function forEachFeatureRemove_ (feature) {
      this.removeFeature(feature);
    };

    /**
     * @return {import("../Collection.js").default<import("../Feature.js").default>|Array<import("../Feature.js").default>} Features.
     * @private
     */
    Snap.prototype.getFeatures_ = function getFeatures_ () {
      var features;
      if (this.features_) {
        features = this.features_;
      } else if (this.source_) {
        features = this.source_.getFeatures();
      }
      return features;
    };

    /**
     * @inheritDoc
     */
    Snap.prototype.handleEvent = function handleEvent (evt) {
      var result = this.snapTo(evt.pixel, evt.coordinate, evt.map);
      if (result.snapped) {
        evt.coordinate = result.vertex.slice(0, 2);
        evt.pixel = result.vertexPixel;
      }
      return PointerInteraction$$1.prototype.handleEvent.call(this, evt);
    };

    /**
     * @param {import("../source/Vector.js").VectorSourceEvent|import("../Collection.js").CollectionEvent} evt Event.
     * @private
     */
    Snap.prototype.handleFeatureAdd_ = function handleFeatureAdd_ (evt) {
      var feature = getFeatureFromEvent(evt);
      this.addFeature(feature);
    };

    /**
     * @param {import("../source/Vector.js").VectorSourceEvent|import("../Collection.js").CollectionEvent} evt Event.
     * @private
     */
    Snap.prototype.handleFeatureRemove_ = function handleFeatureRemove_ (evt) {
      var feature = getFeatureFromEvent(evt);
      this.removeFeature(feature);
    };

    /**
     * @param {import("../events/Event.js").default} evt Event.
     * @private
     */
    Snap.prototype.handleFeatureChange_ = function handleFeatureChange_ (evt) {
      var feature = /** @type {import("../Feature.js").default} */ (evt.target);
      if (this.handlingDownUpSequence) {
        var uid = getUid(feature);
        if (!(uid in this.pendingFeatures_)) {
          this.pendingFeatures_[uid] = feature;
        }
      } else {
        this.updateFeature_(feature);
      }
    };

    /**
     * @inheritDoc
     */
    Snap.prototype.handleUpEvent = function handleUpEvent (evt) {
      var featuresToUpdate = getValues(this.pendingFeatures_);
      if (featuresToUpdate.length) {
        featuresToUpdate.forEach(this.updateFeature_.bind(this));
        this.pendingFeatures_ = {};
      }
      return false;
    };

    /**
     * Remove a feature from the collection of features that we may snap to.
     * @param {import("../Feature.js").default} feature Feature
     * @param {boolean=} opt_unlisten Whether to unlisten to the feature change
     *     or not. Defaults to `true`.
     * @api
     */
    Snap.prototype.removeFeature = function removeFeature (feature, opt_unlisten) {
      var unregister = opt_unlisten !== undefined ? opt_unlisten : true;
      var feature_uid = getUid(feature);
      var extent = this.indexedFeaturesExtents_[feature_uid];
      if (extent) {
        var rBush = this.rBush_;
        var nodesToRemove = [];
        rBush.forEachInExtent(extent, function(node) {
          if (feature === node.feature) {
            nodesToRemove.push(node);
          }
        });
        for (var i = nodesToRemove.length - 1; i >= 0; --i) {
          rBush.remove(nodesToRemove[i]);
        }
      }

      if (unregister) {
        unlistenByKey(this.featureChangeListenerKeys_[feature_uid]);
        delete this.featureChangeListenerKeys_[feature_uid];
      }
    };

    /**
     * @inheritDoc
     */
    Snap.prototype.setMap = function setMap (map) {
      var currentMap = this.getMap();
      var keys = this.featuresListenerKeys_;
      var features = /** @type {Array<import("../Feature.js").default>} */ (this.getFeatures_());

      if (currentMap) {
        keys.forEach(unlistenByKey);
        keys.length = 0;
        features.forEach(this.forEachFeatureRemove_.bind(this));
      }
      PointerInteraction$$1.prototype.setMap.call(this, map);

      if (map) {
        if (this.features_) {
          keys.push(
            listen(this.features_, CollectionEventType.ADD,
              this.handleFeatureAdd_, this),
            listen(this.features_, CollectionEventType.REMOVE,
              this.handleFeatureRemove_, this)
          );
        } else if (this.source_) {
          keys.push(
            listen(this.source_, VectorEventType.ADDFEATURE,
              this.handleFeatureAdd_, this),
            listen(this.source_, VectorEventType.REMOVEFEATURE,
              this.handleFeatureRemove_, this)
          );
        }
        features.forEach(this.forEachFeatureAdd_.bind(this));
      }
    };

    /**
     * @param {import("../pixel.js").Pixel} pixel Pixel
     * @param {import("../coordinate.js").Coordinate} pixelCoordinate Coordinate
     * @param {import("../PluggableMap.js").default} map Map.
     * @return {Result} Snap result
     */
    Snap.prototype.snapTo = function snapTo (pixel, pixelCoordinate, map) {

      var lowerLeft = map.getCoordinateFromPixel(
        [pixel[0] - this.pixelTolerance_, pixel[1] + this.pixelTolerance_]);
      var upperRight = map.getCoordinateFromPixel(
        [pixel[0] + this.pixelTolerance_, pixel[1] - this.pixelTolerance_]);
      var box = boundingExtent([lowerLeft, upperRight]);

      var segments = this.rBush_.getInExtent(box);

      // If snapping on vertices only, don't consider circles
      if (this.vertex_ && !this.edge_) {
        segments = segments.filter(function(segment) {
          return segment.feature.getGeometry().getType() !==
              GeometryType.CIRCLE;
        });
      }

      var snappedToVertex = false;
      var snapped = false;
      var vertex = null;
      var vertexPixel = null;
      var dist, pixel1, pixel2, squaredDist1, squaredDist2;
      if (segments.length > 0) {
        this.pixelCoordinate_ = pixelCoordinate;
        segments.sort(this.sortByDistance_);
        var closestSegment = segments[0].segment;
        var isCircle = segments[0].feature.getGeometry().getType() ===
            GeometryType.CIRCLE;
        if (this.vertex_ && !this.edge_) {
          pixel1 = map.getPixelFromCoordinate(closestSegment[0]);
          pixel2 = map.getPixelFromCoordinate(closestSegment[1]);
          squaredDist1 = squaredDistance$1(pixel, pixel1);
          squaredDist2 = squaredDistance$1(pixel, pixel2);
          dist = Math.sqrt(Math.min(squaredDist1, squaredDist2));
          snappedToVertex = dist <= this.pixelTolerance_;
          if (snappedToVertex) {
            snapped = true;
            vertex = squaredDist1 > squaredDist2 ? closestSegment[1] : closestSegment[0];
            vertexPixel = map.getPixelFromCoordinate(vertex);
          }
        } else if (this.edge_) {
          if (isCircle) {
            vertex = closestOnCircle(pixelCoordinate,
              /** @type {import("../geom/Circle.js").default} */ (segments[0].feature.getGeometry()));
          } else {
            vertex = closestOnSegment(pixelCoordinate, closestSegment);
          }
          vertexPixel = map.getPixelFromCoordinate(vertex);
          if (distance(pixel, vertexPixel) <= this.pixelTolerance_) {
            snapped = true;
            if (this.vertex_ && !isCircle) {
              pixel1 = map.getPixelFromCoordinate(closestSegment[0]);
              pixel2 = map.getPixelFromCoordinate(closestSegment[1]);
              squaredDist1 = squaredDistance$1(vertexPixel, pixel1);
              squaredDist2 = squaredDistance$1(vertexPixel, pixel2);
              dist = Math.sqrt(Math.min(squaredDist1, squaredDist2));
              snappedToVertex = dist <= this.pixelTolerance_;
              if (snappedToVertex) {
                vertex = squaredDist1 > squaredDist2 ? closestSegment[1] : closestSegment[0];
                vertexPixel = map.getPixelFromCoordinate(vertex);
              }
            }
          }
        }
        if (snapped) {
          vertexPixel = [Math.round(vertexPixel[0]), Math.round(vertexPixel[1])];
        }
      }
      return (
        /** @type {Result} */ ({
          snapped: snapped,
          vertex: vertex,
          vertexPixel: vertexPixel
        })
      );
    };

    /**
     * @param {import("../Feature.js").default} feature Feature
     * @private
     */
    Snap.prototype.updateFeature_ = function updateFeature_ (feature) {
      this.removeFeature(feature, false);
      this.addFeature(feature, false);
    };

    /**
     * @param {import("../Feature.js").default} feature Feature
     * @param {import("../geom/Circle.js").default} geometry Geometry.
     * @private
     */
    Snap.prototype.writeCircleGeometry_ = function writeCircleGeometry_ (feature, geometry) {
      var polygon = fromCircle(geometry);
      var coordinates = polygon.getCoordinates()[0];
      for (var i = 0, ii = coordinates.length - 1; i < ii; ++i) {
        var segment = coordinates.slice(i, i + 2);
        var segmentData = /** @type {SegmentData} */ ({
          feature: feature,
          segment: segment
        });
        this.rBush_.insert(boundingExtent(segment), segmentData);
      }
    };

    /**
     * @param {import("../Feature.js").default} feature Feature
     * @param {import("../geom/GeometryCollection.js").default} geometry Geometry.
     * @private
     */
    Snap.prototype.writeGeometryCollectionGeometry_ = function writeGeometryCollectionGeometry_ (feature, geometry) {
      var geometries = geometry.getGeometriesArray();
      for (var i = 0; i < geometries.length; ++i) {
        var segmentWriter = this.SEGMENT_WRITERS_[geometries[i].getType()];
        if (segmentWriter) {
          segmentWriter.call(this, feature, geometries[i]);
        }
      }
    };

    /**
     * @param {import("../Feature.js").default} feature Feature
     * @param {import("../geom/LineString.js").default} geometry Geometry.
     * @private
     */
    Snap.prototype.writeLineStringGeometry_ = function writeLineStringGeometry_ (feature, geometry) {
      var coordinates = geometry.getCoordinates();
      for (var i = 0, ii = coordinates.length - 1; i < ii; ++i) {
        var segment = coordinates.slice(i, i + 2);
        var segmentData = /** @type {SegmentData} */ ({
          feature: feature,
          segment: segment
        });
        this.rBush_.insert(boundingExtent(segment), segmentData);
      }
    };

    /**
     * @param {import("../Feature.js").default} feature Feature
     * @param {import("../geom/MultiLineString.js").default} geometry Geometry.
     * @private
     */
    Snap.prototype.writeMultiLineStringGeometry_ = function writeMultiLineStringGeometry_ (feature, geometry) {
      var lines = geometry.getCoordinates();
      for (var j = 0, jj = lines.length; j < jj; ++j) {
        var coordinates = lines[j];
        for (var i = 0, ii = coordinates.length - 1; i < ii; ++i) {
          var segment = coordinates.slice(i, i + 2);
          var segmentData = /** @type {SegmentData} */ ({
            feature: feature,
            segment: segment
          });
          this.rBush_.insert(boundingExtent(segment), segmentData);
        }
      }
    };

    /**
     * @param {import("../Feature.js").default} feature Feature
     * @param {import("../geom/MultiPoint.js").default} geometry Geometry.
     * @private
     */
    Snap.prototype.writeMultiPointGeometry_ = function writeMultiPointGeometry_ (feature, geometry) {
      var points = geometry.getCoordinates();
      for (var i = 0, ii = points.length; i < ii; ++i) {
        var coordinates = points[i];
        var segmentData = /** @type {SegmentData} */ ({
          feature: feature,
          segment: [coordinates, coordinates]
        });
        this.rBush_.insert(geometry.getExtent(), segmentData);
      }
    };

    /**
     * @param {import("../Feature.js").default} feature Feature
     * @param {import("../geom/MultiPolygon.js").default} geometry Geometry.
     * @private
     */
    Snap.prototype.writeMultiPolygonGeometry_ = function writeMultiPolygonGeometry_ (feature, geometry) {
      var polygons = geometry.getCoordinates();
      for (var k = 0, kk = polygons.length; k < kk; ++k) {
        var rings = polygons[k];
        for (var j = 0, jj = rings.length; j < jj; ++j) {
          var coordinates = rings[j];
          for (var i = 0, ii = coordinates.length - 1; i < ii; ++i) {
            var segment = coordinates.slice(i, i + 2);
            var segmentData = /** @type {SegmentData} */ ({
              feature: feature,
              segment: segment
            });
            this.rBush_.insert(boundingExtent(segment), segmentData);
          }
        }
      }
    };

    /**
     * @param {import("../Feature.js").default} feature Feature
     * @param {import("../geom/Point.js").default} geometry Geometry.
     * @private
     */
    Snap.prototype.writePointGeometry_ = function writePointGeometry_ (feature, geometry) {
      var coordinates = geometry.getCoordinates();
      var segmentData = /** @type {SegmentData} */ ({
        feature: feature,
        segment: [coordinates, coordinates]
      });
      this.rBush_.insert(geometry.getExtent(), segmentData);
    };

    /**
     * @param {import("../Feature.js").default} feature Feature
     * @param {import("../geom/Polygon.js").default} geometry Geometry.
     * @private
     */
    Snap.prototype.writePolygonGeometry_ = function writePolygonGeometry_ (feature, geometry) {
      var rings = geometry.getCoordinates();
      for (var j = 0, jj = rings.length; j < jj; ++j) {
        var coordinates = rings[j];
        for (var i = 0, ii = coordinates.length - 1; i < ii; ++i) {
          var segment = coordinates.slice(i, i + 2);
          var segmentData = /** @type {SegmentData} */ ({
            feature: feature,
            segment: segment
          });
          this.rBush_.insert(boundingExtent(segment), segmentData);
        }
      }
    };

    return Snap;
  }(PointerInteraction));


  /**
   * Sort segments by distance, helper function
   * @param {SegmentData} a The first segment data.
   * @param {SegmentData} b The second segment data.
   * @return {number} The difference in distance.
   * @this {Snap}
   */
  function sortByDistance(a, b) {
    var deltaA = squaredDistanceToSegment(this.pixelCoordinate_, a.segment);
    var deltaB = squaredDistanceToSegment(this.pixelCoordinate_, b.segment);
    return deltaA - deltaB;
  }

  /**
   * @module ol/interaction/Translate
   */


  /**
   * @enum {string}
   */
  var TranslateEventType = {
    /**
     * Triggered upon feature translation start.
     * @event TranslateEvent#translatestart
     * @api
     */
    TRANSLATESTART: 'translatestart',
    /**
     * Triggered upon feature translation.
     * @event TranslateEvent#translating
     * @api
     */
    TRANSLATING: 'translating',
    /**
     * Triggered upon feature translation end.
     * @event TranslateEvent#translateend
     * @api
     */
    TRANSLATEEND: 'translateend'
  };


  /**
   * @typedef {Object} Options
   * @property {Collection<import("../Feature.js").default>} [features] Only features contained in this collection will be able to be translated. If
   * not specified, all features on the map will be able to be translated.
   * @property {Array<import("../layer/Layer.js").default>|function(import("../layer/Layer.js").default): boolean} [layers] A list of layers from which features should be
   * translated. Alternatively, a filter function can be provided. The
   * function will be called for each layer in the map and should return
   * `true` for layers that you want to be translatable. If the option is
   * absent, all visible layers will be considered translatable.
   * @property {number} [hitTolerance=0] Hit-detection tolerance. Pixels inside the radius around the given position
   * will be checked for features. This only works for the canvas renderer and
   * not for WebGL.
   */


  /**
   * @classdesc
   * Events emitted by {@link module:ol/interaction/Translate~Translate} instances
   * are instances of this type.
   */
  var TranslateEvent = /*@__PURE__*/(function (Event$$1) {
    function TranslateEvent(type, features, coordinate) {

      Event$$1.call(this, type);

      /**
       * The features being translated.
       * @type {Collection<import("../Feature.js").default>}
       * @api
       */
      this.features = features;

      /**
       * The coordinate of the drag event.
       * @const
       * @type {import("../coordinate.js").Coordinate}
       * @api
       */
      this.coordinate = coordinate;

    }

    if ( Event$$1 ) TranslateEvent.__proto__ = Event$$1;
    TranslateEvent.prototype = Object.create( Event$$1 && Event$$1.prototype );
    TranslateEvent.prototype.constructor = TranslateEvent;

    return TranslateEvent;
  }(Event));


  /**
   * @classdesc
   * Interaction for translating (moving) features.
   *
   * @fires TranslateEvent
   * @api
   */
  var Translate = /*@__PURE__*/(function (PointerInteraction$$1) {
    function Translate(opt_options) {
      var options = opt_options ? opt_options : {};

      PointerInteraction$$1.call(/** @type {import("./Pointer.js").Options} */ this, (options));

      /**
       * The last position we translated to.
       * @type {import("../coordinate.js").Coordinate}
       * @private
       */
      this.lastCoordinate_ = null;


      /**
       * @type {Collection<import("../Feature.js").default>}
       * @private
       */
      this.features_ = options.features !== undefined ? options.features : null;

      /** @type {function(import("../layer/Layer.js").default): boolean} */
      var layerFilter;
      if (options.layers) {
        if (typeof options.layers === 'function') {
          layerFilter = options.layers;
        } else {
          var layers = options.layers;
          layerFilter = function(layer) {
            return includes(layers, layer);
          };
        }
      } else {
        layerFilter = TRUE;
      }

      /**
       * @private
       * @type {function(import("../layer/Layer.js").default): boolean}
       */
      this.layerFilter_ = layerFilter;

      /**
       * @private
       * @type {number}
       */
      this.hitTolerance_ = options.hitTolerance ? options.hitTolerance : 0;

      /**
       * @type {import("../Feature.js").default}
       * @private
       */
      this.lastFeature_ = null;

      listen(this,
        getChangeEventType(InteractionProperty.ACTIVE),
        this.handleActiveChanged_, this);

    }

    if ( PointerInteraction$$1 ) Translate.__proto__ = PointerInteraction$$1;
    Translate.prototype = Object.create( PointerInteraction$$1 && PointerInteraction$$1.prototype );
    Translate.prototype.constructor = Translate;

    /**
     * @inheritDoc
     */
    Translate.prototype.handleDownEvent = function handleDownEvent (event) {
      this.lastFeature_ = this.featuresAtPixel_(event.pixel, event.map);
      if (!this.lastCoordinate_ && this.lastFeature_) {
        this.lastCoordinate_ = event.coordinate;
        this.handleMoveEvent(event);

        var features = this.features_ || new Collection([this.lastFeature_]);

        this.dispatchEvent(
          new TranslateEvent(
            TranslateEventType.TRANSLATESTART, features,
            event.coordinate));
        return true;
      }
      return false;
    };

    /**
     * @inheritDoc
     */
    Translate.prototype.handleUpEvent = function handleUpEvent (event) {
      if (this.lastCoordinate_) {
        this.lastCoordinate_ = null;
        this.handleMoveEvent(event);

        var features = this.features_ || new Collection([this.lastFeature_]);

        this.dispatchEvent(
          new TranslateEvent(
            TranslateEventType.TRANSLATEEND, features,
            event.coordinate));
        return true;
      }
      return false;
    };

    /**
     * @inheritDoc
     */
    Translate.prototype.handleDragEvent = function handleDragEvent (event) {
      if (this.lastCoordinate_) {
        var newCoordinate = event.coordinate;
        var deltaX = newCoordinate[0] - this.lastCoordinate_[0];
        var deltaY = newCoordinate[1] - this.lastCoordinate_[1];

        var features = this.features_ || new Collection([this.lastFeature_]);

        features.forEach(function(feature) {
          var geom = feature.getGeometry();
          geom.translate(deltaX, deltaY);
          feature.setGeometry(geom);
        });

        this.lastCoordinate_ = newCoordinate;
        this.dispatchEvent(
          new TranslateEvent(
            TranslateEventType.TRANSLATING, features,
            newCoordinate));
      }
    };

    /**
     * @inheritDoc
     */
    Translate.prototype.handleMoveEvent = function handleMoveEvent (event) {
      var elem = event.map.getViewport();

      // Change the cursor to grab/grabbing if hovering any of the features managed
      // by the interaction
      if (this.featuresAtPixel_(event.pixel, event.map)) {
        elem.classList.remove(this.lastCoordinate_ ? 'ol-grab' : 'ol-grabbing');
        elem.classList.add(this.lastCoordinate_ ? 'ol-grabbing' : 'ol-grab');
      } else {
        elem.classList.remove('ol-grab', 'ol-grabbing');
      }
    };

    /**
     * Tests to see if the given coordinates intersects any of our selected
     * features.
     * @param {import("../pixel.js").Pixel} pixel Pixel coordinate to test for intersection.
     * @param {import("../PluggableMap.js").default} map Map to test the intersection on.
     * @return {import("../Feature.js").default} Returns the feature found at the specified pixel
     * coordinates.
     * @private
     */
    Translate.prototype.featuresAtPixel_ = function featuresAtPixel_ (pixel, map) {
      return map.forEachFeatureAtPixel(pixel,
        function(feature) {
          if (!this.features_ || includes(this.features_.getArray(), feature)) {
            return feature;
          }
        }.bind(this), {
          layerFilter: this.layerFilter_,
          hitTolerance: this.hitTolerance_
        });
    };

    /**
     * Returns the Hit-detection tolerance.
     * @returns {number} Hit tolerance in pixels.
     * @api
     */
    Translate.prototype.getHitTolerance = function getHitTolerance () {
      return this.hitTolerance_;
    };

    /**
     * Hit-detection tolerance. Pixels inside the radius around the given position
     * will be checked for features. This only works for the canvas renderer and
     * not for WebGL.
     * @param {number} hitTolerance Hit tolerance in pixels.
     * @api
     */
    Translate.prototype.setHitTolerance = function setHitTolerance (hitTolerance) {
      this.hitTolerance_ = hitTolerance;
    };

    /**
     * @inheritDoc
     */
    Translate.prototype.setMap = function setMap (map) {
      var oldMap = this.getMap();
      PointerInteraction$$1.prototype.setMap.call(this, map);
      this.updateState_(oldMap);
    };

    /**
     * @private
     */
    Translate.prototype.handleActiveChanged_ = function handleActiveChanged_ () {
      this.updateState_(null);
    };

    /**
     * @param {import("../PluggableMap.js").default} oldMap Old map.
     * @private
     */
    Translate.prototype.updateState_ = function updateState_ (oldMap) {
      var map = this.getMap();
      var active = this.getActive();
      if (!map || !active) {
        map = map || oldMap;
        if (map) {
          var elem = map.getViewport();
          elem.classList.remove('ol-grab', 'ol-grabbing');
        }
      }
    };

    return Translate;
  }(PointerInteraction));

  /**
   * @module ol/interaction
   */


  /**
   * @typedef {Object} DefaultsOptions
   * @property {boolean} [altShiftDragRotate=true] Whether Alt-Shift-drag rotate is
   * desired.
   * @property {boolean} [onFocusOnly=false] Interact only when the map has the
   * focus. This affects the `MouseWheelZoom` and `DragPan` interactions and is
   * useful when page scroll is desired for maps that do not have the browser's
   * focus.
   * @property {boolean} [constrainResolution=false] Zoom to the closest integer
   * zoom level after the wheel/trackpad or pinch gesture ends.
   * @property {boolean} [doubleClickZoom=true] Whether double click zoom is
   * desired.
   * @property {boolean} [keyboard=true] Whether keyboard interaction is desired.
   * @property {boolean} [mouseWheelZoom=true] Whether mousewheel zoom is desired.
   * @property {boolean} [shiftDragZoom=true] Whether Shift-drag zoom is desired.
   * @property {boolean} [dragPan=true] Whether drag pan is desired.
   * @property {boolean} [pinchRotate=true] Whether pinch rotate is desired.
   * @property {boolean} [pinchZoom=true] Whether pinch zoom is desired.
   * @property {number} [zoomDelta] Zoom level delta when using keyboard or
   * mousewheel zoom.
   * @property {number} [zoomDuration] Duration of the zoom animation in
   * milliseconds.
   */


  /**
   * Set of interactions included in maps by default. Specific interactions can be
   * excluded by setting the appropriate option to false in the constructor
   * options, but the order of the interactions is fixed.  If you want to specify
   * a different order for interactions, you will need to create your own
   * {@link module:ol/interaction/Interaction} instances and insert
   * them into a {@link module:ol/Collection} in the order you want
   * before creating your {@link module:ol/Map~Map} instance. The default set of
   * interactions, in sequence, is:
   * * {@link module:ol/interaction/DragRotate~DragRotate}
   * * {@link module:ol/interaction/DoubleClickZoom~DoubleClickZoom}
   * * {@link module:ol/interaction/DragPan~DragPan}
   * * {@link module:ol/interaction/PinchRotate~PinchRotate}
   * * {@link module:ol/interaction/PinchZoom~PinchZoom}
   * * {@link module:ol/interaction/KeyboardPan~KeyboardPan}
   * * {@link module:ol/interaction/KeyboardZoom~KeyboardZoom}
   * * {@link module:ol/interaction/MouseWheelZoom~MouseWheelZoom}
   * * {@link module:ol/interaction/DragZoom~DragZoom}
   *
   * @param {DefaultsOptions=} opt_options Defaults options.
   * @return {import("./Collection.js").default<import("./interaction/Interaction.js").default>}
   * A collection of interactions to be used with the {@link module:ol/Map~Map}
   * constructor's `interactions` option.
   * @api
   */
  function defaults$1(opt_options) {

    var options = opt_options ? opt_options : {};

    var interactions = new Collection();

    var kinetic = new Kinetic(-0.005, 0.05, 100);

    var altShiftDragRotate = options.altShiftDragRotate !== undefined ?
      options.altShiftDragRotate : true;
    if (altShiftDragRotate) {
      interactions.push(new DragRotate());
    }

    var doubleClickZoom = options.doubleClickZoom !== undefined ?
      options.doubleClickZoom : true;
    if (doubleClickZoom) {
      interactions.push(new DoubleClickZoom({
        delta: options.zoomDelta,
        duration: options.zoomDuration
      }));
    }

    var dragPan = options.dragPan !== undefined ? options.dragPan : true;
    if (dragPan) {
      interactions.push(new DragPan({
        condition: options.onFocusOnly ? focus : undefined,
        kinetic: kinetic
      }));
    }

    var pinchRotate = options.pinchRotate !== undefined ? options.pinchRotate :
      true;
    if (pinchRotate) {
      interactions.push(new PinchRotate());
    }

    var pinchZoom = options.pinchZoom !== undefined ? options.pinchZoom : true;
    if (pinchZoom) {
      interactions.push(new PinchZoom({
        constrainResolution: options.constrainResolution,
        duration: options.zoomDuration
      }));
    }

    var keyboard = options.keyboard !== undefined ? options.keyboard : true;
    if (keyboard) {
      interactions.push(new KeyboardPan());
      interactions.push(new KeyboardZoom({
        delta: options.zoomDelta,
        duration: options.zoomDuration
      }));
    }

    var mouseWheelZoom = options.mouseWheelZoom !== undefined ?
      options.mouseWheelZoom : true;
    if (mouseWheelZoom) {
      interactions.push(new MouseWheelZoom({
        condition: options.onFocusOnly ? focus : undefined,
        constrainResolution: options.constrainResolution,
        duration: options.zoomDuration
      }));
    }

    var shiftDragZoom = options.shiftDragZoom !== undefined ?
      options.shiftDragZoom : true;
    if (shiftDragZoom) {
      interactions.push(new DragZoom({
        duration: options.zoomDuration
      }));
    }

    return interactions;

  }

  /**
   * @module ol/reproj/common
   */

  /**
   * Default maximum allowed threshold  (in pixels) for reprojection
   * triangulation.
   * @type {number}
   */
  var ERROR_THRESHOLD = 0.5;

  /**
   * @module ol/ImageBase
   */

  /**
   * @abstract
   */
  var ImageBase = /*@__PURE__*/(function (EventTarget) {
    function ImageBase(extent, resolution, pixelRatio, state) {

      EventTarget.call(this);

      /**
       * @protected
       * @type {import("./extent.js").Extent}
       */
      this.extent = extent;

      /**
       * @private
       * @type {number}
       */
      this.pixelRatio_ = pixelRatio;

      /**
       * @protected
       * @type {number|undefined}
       */
      this.resolution = resolution;

      /**
       * @protected
       * @type {import("./ImageState.js").default}
       */
      this.state = state;

    }

    if ( EventTarget ) ImageBase.__proto__ = EventTarget;
    ImageBase.prototype = Object.create( EventTarget && EventTarget.prototype );
    ImageBase.prototype.constructor = ImageBase;

    /**
     * @protected
     */
    ImageBase.prototype.changed = function changed () {
      this.dispatchEvent(EventType.CHANGE);
    };

    /**
     * @return {import("./extent.js").Extent} Extent.
     */
    ImageBase.prototype.getExtent = function getExtent () {
      return this.extent;
    };

    /**
     * @abstract
     * @return {HTMLCanvasElement|HTMLImageElement|HTMLVideoElement} Image.
     */
    ImageBase.prototype.getImage = function getImage () {
      return abstract();
    };

    /**
     * @return {number} PixelRatio.
     */
    ImageBase.prototype.getPixelRatio = function getPixelRatio () {
      return this.pixelRatio_;
    };

    /**
     * @return {number} Resolution.
     */
    ImageBase.prototype.getResolution = function getResolution () {
      return /** @type {number} */ (this.resolution);
    };

    /**
     * @return {import("./ImageState.js").default} State.
     */
    ImageBase.prototype.getState = function getState () {
      return this.state;
    };

    /**
     * Load not yet loaded URI.
     * @abstract
     */
    ImageBase.prototype.load = function load () {
      abstract();
    };

    return ImageBase;
  }(Target));

  /**
   * @module ol/ImageCanvas
   */


  /**
   * A function that is called to trigger asynchronous canvas drawing.  It is
   * called with a "done" callback that should be called when drawing is done.
   * If any error occurs during drawing, the "done" callback should be called with
   * that error.
   *
   * @typedef {function(function(Error=))} Loader
   */


  var ImageCanvas = /*@__PURE__*/(function (ImageBase$$1) {
    function ImageCanvas(extent, resolution, pixelRatio, canvas, opt_loader) {

      var state = opt_loader !== undefined ? ImageState.IDLE : ImageState.LOADED;

      ImageBase$$1.call(this, extent, resolution, pixelRatio, state);

      /**
       * Optional canvas loader function.
       * @type {?Loader}
       * @private
       */
      this.loader_ = opt_loader !== undefined ? opt_loader : null;

      /**
       * @private
       * @type {HTMLCanvasElement}
       */
      this.canvas_ = canvas;

      /**
       * @private
       * @type {Error}
       */
      this.error_ = null;

    }

    if ( ImageBase$$1 ) ImageCanvas.__proto__ = ImageBase$$1;
    ImageCanvas.prototype = Object.create( ImageBase$$1 && ImageBase$$1.prototype );
    ImageCanvas.prototype.constructor = ImageCanvas;

    /**
     * Get any error associated with asynchronous rendering.
     * @return {Error} Any error that occurred during rendering.
     */
    ImageCanvas.prototype.getError = function getError () {
      return this.error_;
    };

    /**
     * Handle async drawing complete.
     * @param {Error=} err Any error during drawing.
     * @private
     */
    ImageCanvas.prototype.handleLoad_ = function handleLoad_ (err) {
      if (err) {
        this.error_ = err;
        this.state = ImageState.ERROR;
      } else {
        this.state = ImageState.LOADED;
      }
      this.changed();
    };

    /**
     * @inheritDoc
     */
    ImageCanvas.prototype.load = function load () {
      if (this.state == ImageState.IDLE) {
        this.state = ImageState.LOADING;
        this.changed();
        this.loader_(this.handleLoad_.bind(this));
      }
    };

    /**
     * @return {HTMLCanvasElement} Canvas element.
     */
    ImageCanvas.prototype.getImage = function getImage () {
      return this.canvas_;
    };

    return ImageCanvas;
  }(ImageBase));

  /**
   * @module ol/render/Event
   */

  var RenderEvent = /*@__PURE__*/(function (Event$$1) {
    function RenderEvent(type, opt_vectorContext, opt_frameState, opt_context, opt_glContext) {

      Event$$1.call(this, type);

      /**
       * For canvas, this is an instance of {@link module:ol/render/canvas/Immediate}.
       * @type {import("./VectorContext.js").default|undefined}
       * @api
       */
      this.vectorContext = opt_vectorContext;

      /**
       * An object representing the current render frame state.
       * @type {import("../PluggableMap.js").FrameState|undefined}
       * @api
       */
      this.frameState = opt_frameState;

      /**
       * Canvas context. Only available when a Canvas renderer is used, null
       * otherwise.
       * @type {CanvasRenderingContext2D|null|undefined}
       * @api
       */
      this.context = opt_context;

      /**
       * WebGL context. Only available when a WebGL renderer is used, null
       * otherwise.
       * @type {import("../webgl/Context.js").default|null|undefined}
       * @api
       */
      this.glContext = opt_glContext;

    }

    if ( Event$$1 ) RenderEvent.__proto__ = Event$$1;
    RenderEvent.prototype = Object.create( Event$$1 && Event$$1.prototype );
    RenderEvent.prototype.constructor = RenderEvent;

    return RenderEvent;
  }(Event));

  /**
   * @module ol/render/VectorContext
   */

  /**
   * @classdesc
   * Context for drawing geometries.  A vector context is available on render
   * events and does not need to be constructed directly.
   * @api
   */
  var VectorContext = function VectorContext () {};

  VectorContext.prototype.drawCustom = function drawCustom (geometry, feature, renderer) {};

  /**
   * Render a geometry.
   *
   * @param {import("../geom/Geometry.js").default} geometry The geometry to render.
   */
  VectorContext.prototype.drawGeometry = function drawGeometry (geometry) {};

  /**
   * Set the rendering style.
   *
   * @param {import("../style/Style.js").default} style The rendering style.
   */
  VectorContext.prototype.setStyle = function setStyle (style) {};

  /**
   * @param {import("../geom/Circle.js").default} circleGeometry Circle geometry.
   * @param {import("../Feature.js").default} feature Feature.
   */
  VectorContext.prototype.drawCircle = function drawCircle (circleGeometry, feature) {};

  /**
   * @param {import("../Feature.js").default} feature Feature.
   * @param {import("../style/Style.js").default} style Style.
   */
  VectorContext.prototype.drawFeature = function drawFeature (feature, style) {};

  /**
   * @param {import("../geom/GeometryCollection.js").default} geometryCollectionGeometry Geometry collection.
   * @param {import("../Feature.js").default} feature Feature.
   */
  VectorContext.prototype.drawGeometryCollection = function drawGeometryCollection (geometryCollectionGeometry, feature) {};

  /**
   * @param {import("../geom/LineString.js").default|import("./Feature.js").default} lineStringGeometry Line string geometry.
   * @param {import("../Feature.js").default|import("./Feature.js").default} feature Feature.
   */
  VectorContext.prototype.drawLineString = function drawLineString (lineStringGeometry, feature) {};

  /**
   * @param {import("../geom/MultiLineString.js").default|import("./Feature.js").default} multiLineStringGeometry MultiLineString geometry.
   * @param {import("../Feature.js").default|import("./Feature.js").default} feature Feature.
   */
  VectorContext.prototype.drawMultiLineString = function drawMultiLineString (multiLineStringGeometry, feature) {};

  /**
   * @param {import("../geom/MultiPoint.js").default|import("./Feature.js").default} multiPointGeometry MultiPoint geometry.
   * @param {import("../Feature.js").default|import("./Feature.js").default} feature Feature.
   */
  VectorContext.prototype.drawMultiPoint = function drawMultiPoint (multiPointGeometry, feature) {};

  /**
   * @param {import("../geom/MultiPolygon.js").default} multiPolygonGeometry MultiPolygon geometry.
   * @param {import("../Feature.js").default|import("./Feature.js").default} feature Feature.
   */
  VectorContext.prototype.drawMultiPolygon = function drawMultiPolygon (multiPolygonGeometry, feature) {};

  /**
   * @param {import("../geom/Point.js").default|import("./Feature.js").default} pointGeometry Point geometry.
   * @param {import("../Feature.js").default|import("./Feature.js").default} feature Feature.
   */
  VectorContext.prototype.drawPoint = function drawPoint (pointGeometry, feature) {};

  /**
   * @param {import("../geom/Polygon.js").default|import("./Feature.js").default} polygonGeometry Polygon geometry.
   * @param {import("../Feature.js").default|import("./Feature.js").default} feature Feature.
   */
  VectorContext.prototype.drawPolygon = function drawPolygon (polygonGeometry, feature) {};

  /**
   * @param {import("../geom/Geometry.js").default|import("./Feature.js").default} geometry Geometry.
   * @param {import("../Feature.js").default|import("./Feature.js").default} feature Feature.
   */
  VectorContext.prototype.drawText = function drawText (geometry, feature) {};

  /**
   * @param {import("../style/Fill.js").default} fillStyle Fill style.
   * @param {import("../style/Stroke.js").default} strokeStyle Stroke style.
   */
  VectorContext.prototype.setFillStrokeStyle = function setFillStrokeStyle (fillStyle, strokeStyle) {};

  /**
   * @param {import("../style/Image.js").default} imageStyle Image style.
   * @param {import("./canvas.js").DeclutterGroup=} opt_declutterGroup Declutter.
   */
  VectorContext.prototype.setImageStyle = function setImageStyle (imageStyle, opt_declutterGroup) {};

  /**
   * @param {import("../style/Text.js").default} textStyle Text style.
   * @param {import("./canvas.js").DeclutterGroup=} opt_declutterGroup Declutter.
   */
  VectorContext.prototype.setTextStyle = function setTextStyle (textStyle, opt_declutterGroup) {};

  /**
   * @module ol/render/canvas/Immediate
   */

  /**
   * @classdesc
   * A concrete subclass of {@link module:ol/render/VectorContext} that implements
   * direct rendering of features and geometries to an HTML5 Canvas context.
   * Instances of this class are created internally by the library and
   * provided to application code as vectorContext member of the
   * {@link module:ol/render/Event~RenderEvent} object associated with postcompose, precompose and
   * render events emitted by layers and maps.
   */
  var CanvasImmediateRenderer = /*@__PURE__*/(function (VectorContext$$1) {
    function CanvasImmediateRenderer(context, pixelRatio, extent, transform, viewRotation) {
      VectorContext$$1.call(this);

      /**
       * @private
       * @type {CanvasRenderingContext2D}
       */
      this.context_ = context;

      /**
       * @private
       * @type {number}
       */
      this.pixelRatio_ = pixelRatio;

      /**
       * @private
       * @type {import("../../extent.js").Extent}
       */
      this.extent_ = extent;

      /**
       * @private
       * @type {import("../../transform.js").Transform}
       */
      this.transform_ = transform;

      /**
       * @private
       * @type {number}
       */
      this.viewRotation_ = viewRotation;

      /**
       * @private
       * @type {?import("../canvas.js").FillState}
       */
      this.contextFillState_ = null;

      /**
       * @private
       * @type {?import("../canvas.js").StrokeState}
       */
      this.contextStrokeState_ = null;

      /**
       * @private
       * @type {?import("../canvas.js").TextState}
       */
      this.contextTextState_ = null;

      /**
       * @private
       * @type {?import("../canvas.js").FillState}
       */
      this.fillState_ = null;

      /**
       * @private
       * @type {?import("../canvas.js").StrokeState}
       */
      this.strokeState_ = null;

      /**
       * @private
       * @type {HTMLCanvasElement|HTMLVideoElement|HTMLImageElement}
       */
      this.image_ = null;

      /**
       * @private
       * @type {number}
       */
      this.imageAnchorX_ = 0;

      /**
       * @private
       * @type {number}
       */
      this.imageAnchorY_ = 0;

      /**
       * @private
       * @type {number}
       */
      this.imageHeight_ = 0;

      /**
       * @private
       * @type {number}
       */
      this.imageOpacity_ = 0;

      /**
       * @private
       * @type {number}
       */
      this.imageOriginX_ = 0;

      /**
       * @private
       * @type {number}
       */
      this.imageOriginY_ = 0;

      /**
       * @private
       * @type {boolean}
       */
      this.imageRotateWithView_ = false;

      /**
       * @private
       * @type {number}
       */
      this.imageRotation_ = 0;

      /**
       * @private
       * @type {number}
       */
      this.imageScale_ = 0;

      /**
       * @private
       * @type {number}
       */
      this.imageWidth_ = 0;

      /**
       * @private
       * @type {string}
       */
      this.text_ = '';

      /**
       * @private
       * @type {number}
       */
      this.textOffsetX_ = 0;

      /**
       * @private
       * @type {number}
       */
      this.textOffsetY_ = 0;

      /**
       * @private
       * @type {boolean}
       */
      this.textRotateWithView_ = false;

      /**
       * @private
       * @type {number}
       */
      this.textRotation_ = 0;

      /**
       * @private
       * @type {number}
       */
      this.textScale_ = 0;

      /**
       * @private
       * @type {?import("../canvas.js").FillState}
       */
      this.textFillState_ = null;

      /**
       * @private
       * @type {?import("../canvas.js").StrokeState}
       */
      this.textStrokeState_ = null;

      /**
       * @private
       * @type {?import("../canvas.js").TextState}
       */
      this.textState_ = null;

      /**
       * @private
       * @type {Array<number>}
       */
      this.pixelCoordinates_ = [];

      /**
       * @private
       * @type {import("../../transform.js").Transform}
       */
      this.tmpLocalTransform_ = create();

    }

    if ( VectorContext$$1 ) CanvasImmediateRenderer.__proto__ = VectorContext$$1;
    CanvasImmediateRenderer.prototype = Object.create( VectorContext$$1 && VectorContext$$1.prototype );
    CanvasImmediateRenderer.prototype.constructor = CanvasImmediateRenderer;

    /**
     * @param {Array<number>} flatCoordinates Flat coordinates.
     * @param {number} offset Offset.
     * @param {number} end End.
     * @param {number} stride Stride.
     * @private
     */
    CanvasImmediateRenderer.prototype.drawImages_ = function drawImages_ (flatCoordinates, offset, end, stride) {
      if (!this.image_) {
        return;
      }
      var pixelCoordinates = transform2D(
        flatCoordinates, offset, end, 2, this.transform_,
        this.pixelCoordinates_);
      var context = this.context_;
      var localTransform = this.tmpLocalTransform_;
      var alpha = context.globalAlpha;
      if (this.imageOpacity_ != 1) {
        context.globalAlpha = alpha * this.imageOpacity_;
      }
      var rotation = this.imageRotation_;
      if (this.imageRotateWithView_) {
        rotation += this.viewRotation_;
      }
      for (var i = 0, ii = pixelCoordinates.length; i < ii; i += 2) {
        var x = pixelCoordinates[i] - this.imageAnchorX_;
        var y = pixelCoordinates[i + 1] - this.imageAnchorY_;
        if (rotation !== 0 || this.imageScale_ != 1) {
          var centerX = x + this.imageAnchorX_;
          var centerY = y + this.imageAnchorY_;
          compose(localTransform,
            centerX, centerY,
            this.imageScale_, this.imageScale_,
            rotation,
            -centerX, -centerY);
          context.setTransform.apply(context, localTransform);
        }
        context.drawImage(this.image_, this.imageOriginX_, this.imageOriginY_,
          this.imageWidth_, this.imageHeight_, x, y,
          this.imageWidth_, this.imageHeight_);
      }
      if (rotation !== 0 || this.imageScale_ != 1) {
        context.setTransform(1, 0, 0, 1, 0, 0);
      }
      if (this.imageOpacity_ != 1) {
        context.globalAlpha = alpha;
      }
    };

    /**
     * @param {Array<number>} flatCoordinates Flat coordinates.
     * @param {number} offset Offset.
     * @param {number} end End.
     * @param {number} stride Stride.
     * @private
     */
    CanvasImmediateRenderer.prototype.drawText_ = function drawText_ (flatCoordinates, offset, end, stride) {
      if (!this.textState_ || this.text_ === '') {
        return;
      }
      if (this.textFillState_) {
        this.setContextFillState_(this.textFillState_);
      }
      if (this.textStrokeState_) {
        this.setContextStrokeState_(this.textStrokeState_);
      }
      this.setContextTextState_(this.textState_);
      var pixelCoordinates = transform2D(
        flatCoordinates, offset, end, stride, this.transform_,
        this.pixelCoordinates_);
      var context = this.context_;
      var rotation = this.textRotation_;
      if (this.textRotateWithView_) {
        rotation += this.viewRotation_;
      }
      for (; offset < end; offset += stride) {
        var x = pixelCoordinates[offset] + this.textOffsetX_;
        var y = pixelCoordinates[offset + 1] + this.textOffsetY_;
        if (rotation !== 0 || this.textScale_ != 1) {
          var localTransform = compose(this.tmpLocalTransform_,
            x, y,
            this.textScale_, this.textScale_,
            rotation,
            -x, -y);
          context.setTransform.apply(context, localTransform);
        }
        if (this.textStrokeState_) {
          context.strokeText(this.text_, x, y);
        }
        if (this.textFillState_) {
          context.fillText(this.text_, x, y);
        }
      }
      if (rotation !== 0 || this.textScale_ != 1) {
        context.setTransform(1, 0, 0, 1, 0, 0);
      }
    };

    /**
     * @param {Array<number>} flatCoordinates Flat coordinates.
     * @param {number} offset Offset.
     * @param {number} end End.
     * @param {number} stride Stride.
     * @param {boolean} close Close.
     * @private
     * @return {number} end End.
     */
    CanvasImmediateRenderer.prototype.moveToLineTo_ = function moveToLineTo_ (flatCoordinates, offset, end, stride, close) {
      var context = this.context_;
      var pixelCoordinates = transform2D(
        flatCoordinates, offset, end, stride, this.transform_,
        this.pixelCoordinates_);
      context.moveTo(pixelCoordinates[0], pixelCoordinates[1]);
      var length = pixelCoordinates.length;
      if (close) {
        length -= 2;
      }
      for (var i = 2; i < length; i += 2) {
        context.lineTo(pixelCoordinates[i], pixelCoordinates[i + 1]);
      }
      if (close) {
        context.closePath();
      }
      return end;
    };

    /**
     * @param {Array<number>} flatCoordinates Flat coordinates.
     * @param {number} offset Offset.
     * @param {Array<number>} ends Ends.
     * @param {number} stride Stride.
     * @private
     * @return {number} End.
     */
    CanvasImmediateRenderer.prototype.drawRings_ = function drawRings_ (flatCoordinates, offset, ends, stride) {
      for (var i = 0, ii = ends.length; i < ii; ++i) {
        offset = this.moveToLineTo_(flatCoordinates, offset, ends[i], stride, true);
      }
      return offset;
    };

    /**
     * Render a circle geometry into the canvas.  Rendering is immediate and uses
     * the current fill and stroke styles.
     *
     * @param {import("../../geom/Circle.js").default} geometry Circle geometry.
     * @override
     * @api
     */
    CanvasImmediateRenderer.prototype.drawCircle = function drawCircle (geometry) {
      if (!intersects(this.extent_, geometry.getExtent())) {
        return;
      }
      if (this.fillState_ || this.strokeState_) {
        if (this.fillState_) {
          this.setContextFillState_(this.fillState_);
        }
        if (this.strokeState_) {
          this.setContextStrokeState_(this.strokeState_);
        }
        var pixelCoordinates = transformGeom2D(
          geometry, this.transform_, this.pixelCoordinates_);
        var dx = pixelCoordinates[2] - pixelCoordinates[0];
        var dy = pixelCoordinates[3] - pixelCoordinates[1];
        var radius = Math.sqrt(dx * dx + dy * dy);
        var context = this.context_;
        context.beginPath();
        context.arc(
          pixelCoordinates[0], pixelCoordinates[1], radius, 0, 2 * Math.PI);
        if (this.fillState_) {
          context.fill();
        }
        if (this.strokeState_) {
          context.stroke();
        }
      }
      if (this.text_ !== '') {
        this.drawText_(geometry.getCenter(), 0, 2, 2);
      }
    };

    /**
     * Set the rendering style.  Note that since this is an immediate rendering API,
     * any `zIndex` on the provided style will be ignored.
     *
     * @param {import("../../style/Style.js").default} style The rendering style.
     * @override
     * @api
     */
    CanvasImmediateRenderer.prototype.setStyle = function setStyle (style) {
      this.setFillStrokeStyle(style.getFill(), style.getStroke());
      this.setImageStyle(style.getImage());
      this.setTextStyle(style.getText());
    };

    /**
     * Render a geometry into the canvas.  Call
     * {@link module:ol/render/canvas/Immediate#setStyle} first to set the rendering style.
     *
     * @param {import("../../geom/Geometry.js").default|import("../Feature.js").default} geometry The geometry to render.
     * @override
     * @api
     */
    CanvasImmediateRenderer.prototype.drawGeometry = function drawGeometry (geometry) {
      var type = geometry.getType();
      switch (type) {
        case GeometryType.POINT:
          this.drawPoint(/** @type {import("../../geom/Point.js").default} */ (geometry));
          break;
        case GeometryType.LINE_STRING:
          this.drawLineString(/** @type {import("../../geom/LineString.js").default} */ (geometry));
          break;
        case GeometryType.POLYGON:
          this.drawPolygon(/** @type {import("../../geom/Polygon.js").default} */ (geometry));
          break;
        case GeometryType.MULTI_POINT:
          this.drawMultiPoint(/** @type {import("../../geom/MultiPoint.js").default} */ (geometry));
          break;
        case GeometryType.MULTI_LINE_STRING:
          this.drawMultiLineString(/** @type {import("../../geom/MultiLineString.js").default} */ (geometry));
          break;
        case GeometryType.MULTI_POLYGON:
          this.drawMultiPolygon(/** @type {import("../../geom/MultiPolygon.js").default} */ (geometry));
          break;
        case GeometryType.GEOMETRY_COLLECTION:
          this.drawGeometryCollection(/** @type {import("../../geom/GeometryCollection.js").default} */ (geometry));
          break;
        case GeometryType.CIRCLE:
          this.drawCircle(/** @type {import("../../geom/Circle.js").default} */ (geometry));
          break;
        default:
      }
    };

    /**
     * Render a feature into the canvas.  Note that any `zIndex` on the provided
     * style will be ignored - features are rendered immediately in the order that
     * this method is called.  If you need `zIndex` support, you should be using an
     * {@link module:ol/layer/Vector~VectorLayer} instead.
     *
     * @param {import("../../Feature.js").default} feature Feature.
     * @param {import("../../style/Style.js").default} style Style.
     * @override
     * @api
     */
    CanvasImmediateRenderer.prototype.drawFeature = function drawFeature (feature, style) {
      var geometry = style.getGeometryFunction()(feature);
      if (!geometry || !intersects(this.extent_, geometry.getExtent())) {
        return;
      }
      this.setStyle(style);
      this.drawGeometry(geometry);
    };

    /**
     * Render a GeometryCollection to the canvas.  Rendering is immediate and
     * uses the current styles appropriate for each geometry in the collection.
     *
     * @param {import("../../geom/GeometryCollection.js").default} geometry Geometry collection.
     * @override
     */
    CanvasImmediateRenderer.prototype.drawGeometryCollection = function drawGeometryCollection (geometry) {
      var geometries = geometry.getGeometriesArray();
      for (var i = 0, ii = geometries.length; i < ii; ++i) {
        this.drawGeometry(geometries[i]);
      }
    };

    /**
     * Render a Point geometry into the canvas.  Rendering is immediate and uses
     * the current style.
     *
     * @param {import("../../geom/Point.js").default|import("../Feature.js").default} geometry Point geometry.
     * @override
     */
    CanvasImmediateRenderer.prototype.drawPoint = function drawPoint (geometry) {
      var flatCoordinates = geometry.getFlatCoordinates();
      var stride = geometry.getStride();
      if (this.image_) {
        this.drawImages_(flatCoordinates, 0, flatCoordinates.length, stride);
      }
      if (this.text_ !== '') {
        this.drawText_(flatCoordinates, 0, flatCoordinates.length, stride);
      }
    };

    /**
     * Render a MultiPoint geometry  into the canvas.  Rendering is immediate and
     * uses the current style.
     *
     * @param {import("../../geom/MultiPoint.js").default|import("../Feature.js").default} geometry MultiPoint geometry.
     * @override
     */
    CanvasImmediateRenderer.prototype.drawMultiPoint = function drawMultiPoint (geometry) {
      var flatCoordinates = geometry.getFlatCoordinates();
      var stride = geometry.getStride();
      if (this.image_) {
        this.drawImages_(flatCoordinates, 0, flatCoordinates.length, stride);
      }
      if (this.text_ !== '') {
        this.drawText_(flatCoordinates, 0, flatCoordinates.length, stride);
      }
    };

    /**
     * Render a LineString into the canvas.  Rendering is immediate and uses
     * the current style.
     *
     * @param {import("../../geom/LineString.js").default|import("../Feature.js").default} geometry LineString geometry.
     * @override
     */
    CanvasImmediateRenderer.prototype.drawLineString = function drawLineString (geometry) {
      if (!intersects(this.extent_, geometry.getExtent())) {
        return;
      }
      if (this.strokeState_) {
        this.setContextStrokeState_(this.strokeState_);
        var context = this.context_;
        var flatCoordinates = geometry.getFlatCoordinates();
        context.beginPath();
        this.moveToLineTo_(flatCoordinates, 0, flatCoordinates.length,
          geometry.getStride(), false);
        context.stroke();
      }
      if (this.text_ !== '') {
        var flatMidpoint = geometry.getFlatMidpoint();
        this.drawText_(flatMidpoint, 0, 2, 2);
      }
    };

    /**
     * Render a MultiLineString geometry into the canvas.  Rendering is immediate
     * and uses the current style.
     *
     * @param {import("../../geom/MultiLineString.js").default|import("../Feature.js").default} geometry MultiLineString geometry.
     * @override
     */
    CanvasImmediateRenderer.prototype.drawMultiLineString = function drawMultiLineString (geometry) {
      var geometryExtent = geometry.getExtent();
      if (!intersects(this.extent_, geometryExtent)) {
        return;
      }
      if (this.strokeState_) {
        this.setContextStrokeState_(this.strokeState_);
        var context = this.context_;
        var flatCoordinates = geometry.getFlatCoordinates();
        var offset = 0;
        var ends = /** @type {Array<number>} */ (geometry.getEnds());
        var stride = geometry.getStride();
        context.beginPath();
        for (var i = 0, ii = ends.length; i < ii; ++i) {
          offset = this.moveToLineTo_(flatCoordinates, offset, ends[i], stride, false);
        }
        context.stroke();
      }
      if (this.text_ !== '') {
        var flatMidpoints = geometry.getFlatMidpoints();
        this.drawText_(flatMidpoints, 0, flatMidpoints.length, 2);
      }
    };

    /**
     * Render a Polygon geometry into the canvas.  Rendering is immediate and uses
     * the current style.
     *
     * @param {import("../../geom/Polygon.js").default|import("../Feature.js").default} geometry Polygon geometry.
     * @override
     */
    CanvasImmediateRenderer.prototype.drawPolygon = function drawPolygon (geometry) {
      if (!intersects(this.extent_, geometry.getExtent())) {
        return;
      }
      if (this.strokeState_ || this.fillState_) {
        if (this.fillState_) {
          this.setContextFillState_(this.fillState_);
        }
        if (this.strokeState_) {
          this.setContextStrokeState_(this.strokeState_);
        }
        var context = this.context_;
        context.beginPath();
        this.drawRings_(geometry.getOrientedFlatCoordinates(),
          0, /** @type {Array<number>} */ (geometry.getEnds()), geometry.getStride());
        if (this.fillState_) {
          context.fill();
        }
        if (this.strokeState_) {
          context.stroke();
        }
      }
      if (this.text_ !== '') {
        var flatInteriorPoint = geometry.getFlatInteriorPoint();
        this.drawText_(flatInteriorPoint, 0, 2, 2);
      }
    };

    /**
     * Render MultiPolygon geometry into the canvas.  Rendering is immediate and
     * uses the current style.
     * @param {import("../../geom/MultiPolygon.js").default} geometry MultiPolygon geometry.
     * @override
     */
    CanvasImmediateRenderer.prototype.drawMultiPolygon = function drawMultiPolygon (geometry) {
      if (!intersects(this.extent_, geometry.getExtent())) {
        return;
      }
      if (this.strokeState_ || this.fillState_) {
        if (this.fillState_) {
          this.setContextFillState_(this.fillState_);
        }
        if (this.strokeState_) {
          this.setContextStrokeState_(this.strokeState_);
        }
        var context = this.context_;
        var flatCoordinates = geometry.getOrientedFlatCoordinates();
        var offset = 0;
        var endss = geometry.getEndss();
        var stride = geometry.getStride();
        context.beginPath();
        for (var i = 0, ii = endss.length; i < ii; ++i) {
          var ends = endss[i];
          offset = this.drawRings_(flatCoordinates, offset, ends, stride);
        }
        if (this.fillState_) {
          context.fill();
        }
        if (this.strokeState_) {
          context.stroke();
        }
      }
      if (this.text_ !== '') {
        var flatInteriorPoints = geometry.getFlatInteriorPoints();
        this.drawText_(flatInteriorPoints, 0, flatInteriorPoints.length, 2);
      }
    };

    /**
     * @param {import("../canvas.js").FillState} fillState Fill state.
     * @private
     */
    CanvasImmediateRenderer.prototype.setContextFillState_ = function setContextFillState_ (fillState) {
      var context = this.context_;
      var contextFillState = this.contextFillState_;
      if (!contextFillState) {
        context.fillStyle = fillState.fillStyle;
        this.contextFillState_ = {
          fillStyle: fillState.fillStyle
        };
      } else {
        if (contextFillState.fillStyle != fillState.fillStyle) {
          contextFillState.fillStyle = context.fillStyle = fillState.fillStyle;
        }
      }
    };

    /**
     * @param {import("../canvas.js").StrokeState} strokeState Stroke state.
     * @private
     */
    CanvasImmediateRenderer.prototype.setContextStrokeState_ = function setContextStrokeState_ (strokeState) {
      var context = this.context_;
      var contextStrokeState = this.contextStrokeState_;
      if (!contextStrokeState) {
        context.lineCap = /** @type {CanvasLineCap} */ (strokeState.lineCap);
        if (CANVAS_LINE_DASH) {
          context.setLineDash(strokeState.lineDash);
          context.lineDashOffset = strokeState.lineDashOffset;
        }
        context.lineJoin = /** @type {CanvasLineJoin} */ (strokeState.lineJoin);
        context.lineWidth = strokeState.lineWidth;
        context.miterLimit = strokeState.miterLimit;
        context.strokeStyle = strokeState.strokeStyle;
        this.contextStrokeState_ = {
          lineCap: strokeState.lineCap,
          lineDash: strokeState.lineDash,
          lineDashOffset: strokeState.lineDashOffset,
          lineJoin: strokeState.lineJoin,
          lineWidth: strokeState.lineWidth,
          miterLimit: strokeState.miterLimit,
          strokeStyle: strokeState.strokeStyle
        };
      } else {
        if (contextStrokeState.lineCap != strokeState.lineCap) {
          contextStrokeState.lineCap = context.lineCap = /** @type {CanvasLineCap} */ (strokeState.lineCap);
        }
        if (CANVAS_LINE_DASH) {
          if (!equals(contextStrokeState.lineDash, strokeState.lineDash)) {
            context.setLineDash(contextStrokeState.lineDash = strokeState.lineDash);
          }
          if (contextStrokeState.lineDashOffset != strokeState.lineDashOffset) {
            contextStrokeState.lineDashOffset = context.lineDashOffset =
                strokeState.lineDashOffset;
          }
        }
        if (contextStrokeState.lineJoin != strokeState.lineJoin) {
          contextStrokeState.lineJoin = context.lineJoin = /** @type {CanvasLineJoin} */ (strokeState.lineJoin);
        }
        if (contextStrokeState.lineWidth != strokeState.lineWidth) {
          contextStrokeState.lineWidth = context.lineWidth = strokeState.lineWidth;
        }
        if (contextStrokeState.miterLimit != strokeState.miterLimit) {
          contextStrokeState.miterLimit = context.miterLimit =
              strokeState.miterLimit;
        }
        if (contextStrokeState.strokeStyle != strokeState.strokeStyle) {
          contextStrokeState.strokeStyle = context.strokeStyle =
              strokeState.strokeStyle;
        }
      }
    };

    /**
     * @param {import("../canvas.js").TextState} textState Text state.
     * @private
     */
    CanvasImmediateRenderer.prototype.setContextTextState_ = function setContextTextState_ (textState) {
      var context = this.context_;
      var contextTextState = this.contextTextState_;
      var textAlign = textState.textAlign ?
        textState.textAlign : defaultTextAlign;
      if (!contextTextState) {
        context.font = textState.font;
        context.textAlign = /** @type {CanvasTextAlign} */ (textAlign);
        context.textBaseline = /** @type {CanvasTextBaseline} */ (textState.textBaseline);
        this.contextTextState_ = {
          font: textState.font,
          textAlign: textAlign,
          textBaseline: textState.textBaseline
        };
      } else {
        if (contextTextState.font != textState.font) {
          contextTextState.font = context.font = textState.font;
        }
        if (contextTextState.textAlign != textAlign) {
          contextTextState.textAlign = context.textAlign = /** @type {CanvasTextAlign} */ (textAlign);
        }
        if (contextTextState.textBaseline != textState.textBaseline) {
          contextTextState.textBaseline = context.textBaseline =
            /** @type {CanvasTextBaseline} */ (textState.textBaseline);
        }
      }
    };

    /**
     * Set the fill and stroke style for subsequent draw operations.  To clear
     * either fill or stroke styles, pass null for the appropriate parameter.
     *
     * @param {import("../../style/Fill.js").default} fillStyle Fill style.
     * @param {import("../../style/Stroke.js").default} strokeStyle Stroke style.
     * @override
     */
    CanvasImmediateRenderer.prototype.setFillStrokeStyle = function setFillStrokeStyle (fillStyle, strokeStyle) {
      if (!fillStyle) {
        this.fillState_ = null;
      } else {
        var fillStyleColor = fillStyle.getColor();
        this.fillState_ = {
          fillStyle: asColorLike(fillStyleColor ?
            fillStyleColor : defaultFillStyle)
        };
      }
      if (!strokeStyle) {
        this.strokeState_ = null;
      } else {
        var strokeStyleColor = strokeStyle.getColor();
        var strokeStyleLineCap = strokeStyle.getLineCap();
        var strokeStyleLineDash = strokeStyle.getLineDash();
        var strokeStyleLineDashOffset = strokeStyle.getLineDashOffset();
        var strokeStyleLineJoin = strokeStyle.getLineJoin();
        var strokeStyleWidth = strokeStyle.getWidth();
        var strokeStyleMiterLimit = strokeStyle.getMiterLimit();
        this.strokeState_ = {
          lineCap: strokeStyleLineCap !== undefined ?
            strokeStyleLineCap : defaultLineCap,
          lineDash: strokeStyleLineDash ?
            strokeStyleLineDash : defaultLineDash,
          lineDashOffset: strokeStyleLineDashOffset ?
            strokeStyleLineDashOffset : defaultLineDashOffset,
          lineJoin: strokeStyleLineJoin !== undefined ?
            strokeStyleLineJoin : defaultLineJoin,
          lineWidth: this.pixelRatio_ * (strokeStyleWidth !== undefined ?
            strokeStyleWidth : defaultLineWidth),
          miterLimit: strokeStyleMiterLimit !== undefined ?
            strokeStyleMiterLimit : defaultMiterLimit,
          strokeStyle: asColorLike(strokeStyleColor ?
            strokeStyleColor : defaultStrokeStyle)
        };
      }
    };

    /**
     * Set the image style for subsequent draw operations.  Pass null to remove
     * the image style.
     *
     * @param {import("../../style/Image.js").default} imageStyle Image style.
     * @override
     */
    CanvasImmediateRenderer.prototype.setImageStyle = function setImageStyle (imageStyle) {
      if (!imageStyle) {
        this.image_ = null;
      } else {
        var imageAnchor = imageStyle.getAnchor();
        // FIXME pixel ratio
        var imageImage = imageStyle.getImage(1);
        var imageOrigin = imageStyle.getOrigin();
        var imageSize = imageStyle.getSize();
        this.imageAnchorX_ = imageAnchor[0];
        this.imageAnchorY_ = imageAnchor[1];
        this.imageHeight_ = imageSize[1];
        this.image_ = imageImage;
        this.imageOpacity_ = imageStyle.getOpacity();
        this.imageOriginX_ = imageOrigin[0];
        this.imageOriginY_ = imageOrigin[1];
        this.imageRotateWithView_ = imageStyle.getRotateWithView();
        this.imageRotation_ = imageStyle.getRotation();
        this.imageScale_ = imageStyle.getScale() * this.pixelRatio_;
        this.imageWidth_ = imageSize[0];
      }
    };

    /**
     * Set the text style for subsequent draw operations.  Pass null to
     * remove the text style.
     *
     * @param {import("../../style/Text.js").default} textStyle Text style.
     * @override
     */
    CanvasImmediateRenderer.prototype.setTextStyle = function setTextStyle (textStyle) {
      if (!textStyle) {
        this.text_ = '';
      } else {
        var textFillStyle = textStyle.getFill();
        if (!textFillStyle) {
          this.textFillState_ = null;
        } else {
          var textFillStyleColor = textFillStyle.getColor();
          this.textFillState_ = {
            fillStyle: asColorLike(textFillStyleColor ?
              textFillStyleColor : defaultFillStyle)
          };
        }
        var textStrokeStyle = textStyle.getStroke();
        if (!textStrokeStyle) {
          this.textStrokeState_ = null;
        } else {
          var textStrokeStyleColor = textStrokeStyle.getColor();
          var textStrokeStyleLineCap = textStrokeStyle.getLineCap();
          var textStrokeStyleLineDash = textStrokeStyle.getLineDash();
          var textStrokeStyleLineDashOffset = textStrokeStyle.getLineDashOffset();
          var textStrokeStyleLineJoin = textStrokeStyle.getLineJoin();
          var textStrokeStyleWidth = textStrokeStyle.getWidth();
          var textStrokeStyleMiterLimit = textStrokeStyle.getMiterLimit();
          this.textStrokeState_ = {
            lineCap: textStrokeStyleLineCap !== undefined ?
              textStrokeStyleLineCap : defaultLineCap,
            lineDash: textStrokeStyleLineDash ?
              textStrokeStyleLineDash : defaultLineDash,
            lineDashOffset: textStrokeStyleLineDashOffset ?
              textStrokeStyleLineDashOffset : defaultLineDashOffset,
            lineJoin: textStrokeStyleLineJoin !== undefined ?
              textStrokeStyleLineJoin : defaultLineJoin,
            lineWidth: textStrokeStyleWidth !== undefined ?
              textStrokeStyleWidth : defaultLineWidth,
            miterLimit: textStrokeStyleMiterLimit !== undefined ?
              textStrokeStyleMiterLimit : defaultMiterLimit,
            strokeStyle: asColorLike(textStrokeStyleColor ?
              textStrokeStyleColor : defaultStrokeStyle)
          };
        }
        var textFont = textStyle.getFont();
        var textOffsetX = textStyle.getOffsetX();
        var textOffsetY = textStyle.getOffsetY();
        var textRotateWithView = textStyle.getRotateWithView();
        var textRotation = textStyle.getRotation();
        var textScale = textStyle.getScale();
        var textText = textStyle.getText();
        var textTextAlign = textStyle.getTextAlign();
        var textTextBaseline = textStyle.getTextBaseline();
        this.textState_ = {
          font: textFont !== undefined ?
            textFont : defaultFont,
          textAlign: textTextAlign !== undefined ?
            textTextAlign : defaultTextAlign,
          textBaseline: textTextBaseline !== undefined ?
            textTextBaseline : defaultTextBaseline
        };
        this.text_ = textText !== undefined ? textText : '';
        this.textOffsetX_ =
            textOffsetX !== undefined ? (this.pixelRatio_ * textOffsetX) : 0;
        this.textOffsetY_ =
            textOffsetY !== undefined ? (this.pixelRatio_ * textOffsetY) : 0;
        this.textRotateWithView_ = textRotateWithView !== undefined ? textRotateWithView : false;
        this.textRotation_ = textRotation !== undefined ? textRotation : 0;
        this.textScale_ = this.pixelRatio_ * (textScale !== undefined ?
          textScale : 1);
      }
    };

    return CanvasImmediateRenderer;
  }(VectorContext));

  /**
   * @module ol/style/IconImageCache
   */

  /**
   * @classdesc
   * Singleton class. Available through {@link module:ol/style/IconImageCache~shared}.
   */
  var IconImageCache = function IconImageCache() {

    /**
    * @type {!Object<string, import("./IconImage.js").default>}
    * @private
    */
    this.cache_ = {};

    /**
    * @type {number}
    * @private
    */
    this.cacheSize_ = 0;

    /**
    * @type {number}
    * @private
    */
    this.maxCacheSize_ = 32;
  };

  /**
  * FIXME empty description for jsdoc
  */
  IconImageCache.prototype.clear = function clear () {
    this.cache_ = {};
    this.cacheSize_ = 0;
  };

  /**
  * FIXME empty description for jsdoc
  */
  IconImageCache.prototype.expire = function expire () {
    if (this.cacheSize_ > this.maxCacheSize_) {
      var i = 0;
      for (var key in this.cache_) {
        var iconImage = this.cache_[key];
        if ((i++ & 3) === 0 && !iconImage.hasListener()) {
          delete this.cache_[key];
          --this.cacheSize_;
        }
      }
    }
  };

  /**
  * @param {string} src Src.
  * @param {?string} crossOrigin Cross origin.
  * @param {import("../color.js").Color} color Color.
  * @return {import("./IconImage.js").default} Icon image.
  */
  IconImageCache.prototype.get = function get (src, crossOrigin, color) {
    var key = getKey(src, crossOrigin, color);
    return key in this.cache_ ? this.cache_[key] : null;
  };

  /**
  * @param {string} src Src.
  * @param {?string} crossOrigin Cross origin.
  * @param {import("../color.js").Color} color Color.
  * @param {import("./IconImage.js").default} iconImage Icon image.
  */
  IconImageCache.prototype.set = function set (src, crossOrigin, color, iconImage) {
    var key = getKey(src, crossOrigin, color);
    this.cache_[key] = iconImage;
    ++this.cacheSize_;
  };

  /**
  * Set the cache size of the icon cache. Default is `32`. Change this value when
  * your map uses more than 32 different icon images and you are not caching icon
  * styles on the application level.
  * @param {number} maxCacheSize Cache max size.
  * @api
  */
  IconImageCache.prototype.setSize = function setSize (maxCacheSize) {
    this.maxCacheSize_ = maxCacheSize;
    this.expire();
  };


  /**
   * @param {string} src Src.
   * @param {?string} crossOrigin Cross origin.
   * @param {import("../color.js").Color} color Color.
   * @return {string} Cache key.
   */
  function getKey(src, crossOrigin, color) {
    var colorString = color ? asString(color) : 'null';
    return crossOrigin + ':' + src + ':' + colorString;
  }


  /**
   * The {@link module:ol/style/IconImageCache~IconImageCache} for
   * {@link module:ol/style/Icon~Icon} images.
   * @api
   */
  var shared = new IconImageCache();

  /**
   * @module ol/renderer/Map
   */

  /**
   * @abstract
   */
  var MapRenderer = /*@__PURE__*/(function (Disposable$$1) {
    function MapRenderer(map) {
      Disposable$$1.call(this);

      /**
       * @private
       * @type {import("../PluggableMap.js").default}
       */
      this.map_ = map;

      /**
       * @private
       * @type {!Object<string, import("./Layer.js").default>}
       */
      this.layerRenderers_ = {};

      /**
       * @private
       * @type {Object<string, import("../events.js").EventsKey>}
       */
      this.layerRendererListeners_ = {};

      /**
       * @private
       * @type {Array<typeof import("./Layer.js").default>}
       */
      this.layerRendererConstructors_ = [];

    }

    if ( Disposable$$1 ) MapRenderer.__proto__ = Disposable$$1;
    MapRenderer.prototype = Object.create( Disposable$$1 && Disposable$$1.prototype );
    MapRenderer.prototype.constructor = MapRenderer;

    /**
     * @abstract
     * @param {import("../render/EventType.js").default} type Event type.
     * @param {import("../PluggableMap.js").FrameState} frameState Frame state.
     */
    MapRenderer.prototype.dispatchRenderEvent = function dispatchRenderEvent (type, frameState) {
      abstract();
    };

    /**
     * Register layer renderer constructors.
     * @param {Array<typeof import("./Layer.js").default>} constructors Layer renderers.
     */
    MapRenderer.prototype.registerLayerRenderers = function registerLayerRenderers (constructors) {
      this.layerRendererConstructors_.push.apply(this.layerRendererConstructors_, constructors);
    };

    /**
     * @param {import("../PluggableMap.js").FrameState} frameState FrameState.
     * @protected
     */
    MapRenderer.prototype.calculateMatrices2D = function calculateMatrices2D (frameState) {
      var viewState = frameState.viewState;
      var coordinateToPixelTransform = frameState.coordinateToPixelTransform;
      var pixelToCoordinateTransform = frameState.pixelToCoordinateTransform;

      compose(coordinateToPixelTransform,
        frameState.size[0] / 2, frameState.size[1] / 2,
        1 / viewState.resolution, -1 / viewState.resolution,
        -viewState.rotation,
        -viewState.center[0], -viewState.center[1]);

      invert(
        setFromArray(pixelToCoordinateTransform, coordinateToPixelTransform));
    };

    /**
     * Removes all layer renderers.
     */
    MapRenderer.prototype.removeLayerRenderers = function removeLayerRenderers () {
      for (var key in this.layerRenderers_) {
        this.removeLayerRendererByKey_(key).dispose();
      }
    };

    /**
     * @param {import("../coordinate.js").Coordinate} coordinate Coordinate.
     * @param {import("../PluggableMap.js").FrameState} frameState FrameState.
     * @param {number} hitTolerance Hit tolerance in pixels.
     * @param {function(this: S, import("../Feature.js").FeatureLike,
     *     import("../layer/Layer.js").default): T} callback Feature callback.
     * @param {S} thisArg Value to use as `this` when executing `callback`.
     * @param {function(this: U, import("../layer/Layer.js").default): boolean} layerFilter Layer filter
     *     function, only layers which are visible and for which this function
     *     returns `true` will be tested for features.  By default, all visible
     *     layers will be tested.
     * @param {U} thisArg2 Value to use as `this` when executing `layerFilter`.
     * @return {T|undefined} Callback result.
     * @template S,T,U
     */
    MapRenderer.prototype.forEachFeatureAtCoordinate = function forEachFeatureAtCoordinate (
      coordinate,
      frameState,
      hitTolerance,
      callback,
      thisArg,
      layerFilter,
      thisArg2
    ) {
      var result;
      var viewState = frameState.viewState;
      var viewResolution = viewState.resolution;

      /**
       * @param {import("../Feature.js").FeatureLike} feature Feature.
       * @param {import("../layer/Layer.js").default} layer Layer.
       * @return {?} Callback result.
       */
      function forEachFeatureAtCoordinate(feature, layer) {
        var managed = frameState.layerStates[getUid(layer)].managed;
        if (!(getUid(feature) in frameState.skippedFeatureUids && !managed)) {
          return callback.call(thisArg, feature, managed ? layer : null);
        }
      }

      var projection = viewState.projection;

      var translatedCoordinate = coordinate;
      if (projection.canWrapX()) {
        var projectionExtent = projection.getExtent();
        var worldWidth = getWidth(projectionExtent);
        var x = coordinate[0];
        if (x < projectionExtent[0] || x > projectionExtent[2]) {
          var worldsAway = Math.ceil((projectionExtent[0] - x) / worldWidth);
          translatedCoordinate = [x + worldWidth * worldsAway, coordinate[1]];
        }
      }

      var layerStates = frameState.layerStatesArray;
      var numLayers = layerStates.length;
      var i;
      for (i = numLayers - 1; i >= 0; --i) {
        var layerState = layerStates[i];
        var layer = layerState.layer;
        if (visibleAtResolution(layerState, viewResolution) && layerFilter.call(thisArg2, layer)) {
          var layerRenderer = this.getLayerRenderer(layer);
          var source = /** @type {import("../layer/Layer.js").default} */ (layer).getSource();
          if (source) {
            result = layerRenderer.forEachFeatureAtCoordinate(
              source.getWrapX() ? translatedCoordinate : coordinate,
              frameState, hitTolerance, forEachFeatureAtCoordinate);
          }
          if (result) {
            return result;
          }
        }
      }
      return undefined;
    };

    /**
     * @abstract
     * @param {import("../pixel.js").Pixel} pixel Pixel.
     * @param {import("../PluggableMap.js").FrameState} frameState FrameState.
     * @param {number} hitTolerance Hit tolerance in pixels.
     * @param {function(this: S, import("../layer/Layer.js").default, (Uint8ClampedArray|Uint8Array)): T} callback Layer
     *     callback.
     * @param {S} thisArg Value to use as `this` when executing `callback`.
     * @param {function(this: U, import("../layer/Layer.js").default): boolean} layerFilter Layer filter
     *     function, only layers which are visible and for which this function
     *     returns `true` will be tested for features.  By default, all visible
     *     layers will be tested.
     * @param {U} thisArg2 Value to use as `this` when executing `layerFilter`.
     * @return {T|undefined} Callback result.
     * @template S,T,U
     */
    MapRenderer.prototype.forEachLayerAtPixel = function forEachLayerAtPixel (pixel, frameState, hitTolerance, callback, thisArg, layerFilter, thisArg2) {
      return abstract();
    };

    /**
     * @param {import("../coordinate.js").Coordinate} coordinate Coordinate.
     * @param {import("../PluggableMap.js").FrameState} frameState FrameState.
     * @param {number} hitTolerance Hit tolerance in pixels.
     * @param {function(this: U, import("../layer/Layer.js").default): boolean} layerFilter Layer filter
     *     function, only layers which are visible and for which this function
     *     returns `true` will be tested for features.  By default, all visible
     *     layers will be tested.
     * @param {U} thisArg Value to use as `this` when executing `layerFilter`.
     * @return {boolean} Is there a feature at the given coordinate?
     * @template U
     */
    MapRenderer.prototype.hasFeatureAtCoordinate = function hasFeatureAtCoordinate (coordinate, frameState, hitTolerance, layerFilter, thisArg) {
      var hasFeature = this.forEachFeatureAtCoordinate(
        coordinate, frameState, hitTolerance, TRUE, this, layerFilter, thisArg);

      return hasFeature !== undefined;
    };

    /**
     * @param {import("../layer/Base.js").default} layer Layer.
     * @protected
     * @return {import("./Layer.js").default} Layer renderer.
     */
    MapRenderer.prototype.getLayerRenderer = function getLayerRenderer (layer) {
      var layerKey = getUid(layer);
      if (layerKey in this.layerRenderers_) {
        return this.layerRenderers_[layerKey];
      } else {
        var renderer;
        for (var i = 0, ii = this.layerRendererConstructors_.length; i < ii; ++i) {
          var candidate = this.layerRendererConstructors_[i];
          if (candidate['handles'](layer)) {
            renderer = candidate['create'](this, layer);
            break;
          }
        }
        if (renderer) {
          this.layerRenderers_[layerKey] = renderer;
          this.layerRendererListeners_[layerKey] = listen(renderer,
            EventType.CHANGE, this.handleLayerRendererChange_, this);
        } else {
          throw new Error('Unable to create renderer for layer: ' + layer.getType());
        }
        return renderer;
      }
    };

    /**
     * @param {string} layerKey Layer key.
     * @protected
     * @return {import("./Layer.js").default} Layer renderer.
     */
    MapRenderer.prototype.getLayerRendererByKey = function getLayerRendererByKey (layerKey) {
      return this.layerRenderers_[layerKey];
    };

    /**
     * @protected
     * @return {Object<string, import("./Layer.js").default>} Layer renderers.
     */
    MapRenderer.prototype.getLayerRenderers = function getLayerRenderers () {
      return this.layerRenderers_;
    };

    /**
     * @return {import("../PluggableMap.js").default} Map.
     */
    MapRenderer.prototype.getMap = function getMap () {
      return this.map_;
    };

    /**
     * Handle changes in a layer renderer.
     * @private
     */
    MapRenderer.prototype.handleLayerRendererChange_ = function handleLayerRendererChange_ () {
      this.map_.render();
    };

    /**
     * @param {string} layerKey Layer key.
     * @return {import("./Layer.js").default} Layer renderer.
     * @private
     */
    MapRenderer.prototype.removeLayerRendererByKey_ = function removeLayerRendererByKey_ (layerKey) {
      var layerRenderer = this.layerRenderers_[layerKey];
      delete this.layerRenderers_[layerKey];

      unlistenByKey(this.layerRendererListeners_[layerKey]);
      delete this.layerRendererListeners_[layerKey];

      return layerRenderer;
    };

    /**
     * @param {import("../PluggableMap.js").default} map Map.
     * @param {import("../PluggableMap.js").FrameState} frameState Frame state.
     * @private
     */
    MapRenderer.prototype.removeUnusedLayerRenderers_ = function removeUnusedLayerRenderers_ (map, frameState) {
      for (var layerKey in this.layerRenderers_) {
        if (!frameState || !(layerKey in frameState.layerStates)) {
          this.removeLayerRendererByKey_(layerKey).dispose();
        }
      }
    };

    /**
     * Render.
     * @abstract
     * @param {?import("../PluggableMap.js").FrameState} frameState Frame state.
     */
    MapRenderer.prototype.renderFrame = function renderFrame (frameState) {
      abstract();
    };

    /**
     * @param {import("../PluggableMap.js").FrameState} frameState Frame state.
     * @protected
     */
    MapRenderer.prototype.scheduleExpireIconCache = function scheduleExpireIconCache (frameState) {
      frameState.postRenderFunctions.push(/** @type {import("../PluggableMap.js").PostRenderFunction} */ (expireIconCache));
    };

    /**
     * @param {!import("../PluggableMap.js").FrameState} frameState Frame state.
     * @protected
     */
    MapRenderer.prototype.scheduleRemoveUnusedLayerRenderers = function scheduleRemoveUnusedLayerRenderers (frameState) {
      for (var layerKey in this.layerRenderers_) {
        if (!(layerKey in frameState.layerStates)) {
          frameState.postRenderFunctions.push(
            /** @type {import("../PluggableMap.js").PostRenderFunction} */ (this.removeUnusedLayerRenderers_.bind(this))
          );
          return;
        }
      }
    };

    return MapRenderer;
  }(Disposable));


  /**
   * @param {import("../PluggableMap.js").default} map Map.
   * @param {import("../PluggableMap.js").FrameState} frameState Frame state.
   */
  function expireIconCache(map, frameState) {
    shared.expire();
  }


  /**
   * @param {import("../layer/Layer.js").State} state1 First layer state.
   * @param {import("../layer/Layer.js").State} state2 Second layer state.
   * @return {number} The zIndex difference.
   */
  function sortByZIndex(state1, state2) {
    return state1.zIndex - state2.zIndex;
  }

  /**
   * @module ol/renderer/canvas/Map
   */


  /**
   * @type {Array<typeof import("../Layer.js").default>}
   */
  var layerRendererConstructors = [];

  /**
   * @classdesc
   * Canvas map renderer.
   * @api
   */
  var CanvasMapRenderer = /*@__PURE__*/(function (MapRenderer$$1) {
    function CanvasMapRenderer(map) {
      MapRenderer$$1.call(this, map);

      var container = map.getViewport();

      /**
       * @private
       * @type {CanvasRenderingContext2D}
       */
      this.context_ = createCanvasContext2D();

      /**
       * @private
       * @type {HTMLCanvasElement}
       */
      this.canvas_ = this.context_.canvas;

      this.canvas_.style.width = '100%';
      this.canvas_.style.height = '100%';
      this.canvas_.style.display = 'block';
      this.canvas_.className = CLASS_UNSELECTABLE;
      container.insertBefore(this.canvas_, container.childNodes[0] || null);

      /**
       * @private
       * @type {boolean}
       */
      this.renderedVisible_ = true;

      /**
       * @private
       * @type {import("../../transform.js").Transform}
       */
      this.transform_ = create();

    }

    if ( MapRenderer$$1 ) CanvasMapRenderer.__proto__ = MapRenderer$$1;
    CanvasMapRenderer.prototype = Object.create( MapRenderer$$1 && MapRenderer$$1.prototype );
    CanvasMapRenderer.prototype.constructor = CanvasMapRenderer;

    /**
     * @param {import("../../render/EventType.js").default} type Event type.
     * @param {import("../../PluggableMap.js").FrameState} frameState Frame state.
     */
    CanvasMapRenderer.prototype.dispatchRenderEvent = function dispatchRenderEvent (type, frameState) {
      var map = this.getMap();
      var context = this.context_;
      if (map.hasListener(type)) {
        var extent = frameState.extent;
        var pixelRatio = frameState.pixelRatio;
        var viewState = frameState.viewState;
        var rotation = viewState.rotation;

        var transform = this.getTransform(frameState);

        var vectorContext = new CanvasImmediateRenderer(context, pixelRatio,
          extent, transform, rotation);
        var composeEvent = new RenderEvent(type, vectorContext,
          frameState, context, null);
        map.dispatchEvent(composeEvent);
      }
    };

    /**
     * @param {import("../../PluggableMap.js").FrameState} frameState Frame state.
     * @protected
     * @return {!import("../../transform.js").Transform} Transform.
     */
    CanvasMapRenderer.prototype.getTransform = function getTransform (frameState) {
      var viewState = frameState.viewState;
      var dx1 = this.canvas_.width / 2;
      var dy1 = this.canvas_.height / 2;
      var sx = frameState.pixelRatio / viewState.resolution;
      var sy = -sx;
      var angle = -viewState.rotation;
      var dx2 = -viewState.center[0];
      var dy2 = -viewState.center[1];
      return compose(this.transform_, dx1, dy1, sx, sy, angle, dx2, dy2);
    };

    /**
     * @inheritDoc
     */
    CanvasMapRenderer.prototype.renderFrame = function renderFrame (frameState) {

      if (!frameState) {
        if (this.renderedVisible_) {
          this.canvas_.style.display = 'none';
          this.renderedVisible_ = false;
        }
        return;
      }

      var context = this.context_;
      var pixelRatio = frameState.pixelRatio;
      var width = Math.round(frameState.size[0] * pixelRatio);
      var height = Math.round(frameState.size[1] * pixelRatio);
      if (this.canvas_.width != width || this.canvas_.height != height) {
        this.canvas_.width = width;
        this.canvas_.height = height;
      } else {
        context.clearRect(0, 0, width, height);
      }

      var rotation = frameState.viewState.rotation;

      this.calculateMatrices2D(frameState);

      this.dispatchRenderEvent(RenderEventType.PRECOMPOSE, frameState);

      var layerStatesArray = frameState.layerStatesArray;
      stableSort(layerStatesArray, sortByZIndex);

      if (rotation) {
        context.save();
        rotateAtOffset(context, rotation, width / 2, height / 2);
      }

      var viewResolution = frameState.viewState.resolution;
      var i, ii;
      for (i = 0, ii = layerStatesArray.length; i < ii; ++i) {
        var layerState = layerStatesArray[i];
        var layer = layerState.layer;
        var layerRenderer = /** @type {import("./Layer.js").default} */ (this.getLayerRenderer(layer));
        if (!visibleAtResolution(layerState, viewResolution) ||
            layerState.sourceState != SourceState.READY) {
          continue;
        }
        if (layerRenderer.prepareFrame(frameState, layerState)) {
          layerRenderer.composeFrame(frameState, layerState, context);
        }
      }

      if (rotation) {
        context.restore();
      }

      this.dispatchRenderEvent(RenderEventType.POSTCOMPOSE, frameState);

      if (!this.renderedVisible_) {
        this.canvas_.style.display = '';
        this.renderedVisible_ = true;
      }

      this.scheduleRemoveUnusedLayerRenderers(frameState);
      this.scheduleExpireIconCache(frameState);
    };

    /**
     * @inheritDoc
     */
    CanvasMapRenderer.prototype.forEachLayerAtPixel = function forEachLayerAtPixel (pixel, frameState, hitTolerance, callback, thisArg, layerFilter, thisArg2) {
      var result;
      var viewState = frameState.viewState;
      var viewResolution = viewState.resolution;

      var layerStates = frameState.layerStatesArray;
      var numLayers = layerStates.length;

      var coordinate = apply(
        frameState.pixelToCoordinateTransform, pixel.slice());

      var i;
      for (i = numLayers - 1; i >= 0; --i) {
        var layerState = layerStates[i];
        var layer = layerState.layer;
        if (visibleAtResolution(layerState, viewResolution) && layerFilter.call(thisArg2, layer)) {
          var layerRenderer = /** @type {import("./Layer.js").default} */ (this.getLayerRenderer(layer));
          result = layerRenderer.forEachLayerAtCoordinate(
            coordinate, frameState, hitTolerance, callback, thisArg);
          if (result) {
            return result;
          }
        }
      }
      return undefined;
    };

    /**
     * @inheritDoc
     */
    CanvasMapRenderer.prototype.registerLayerRenderers = function registerLayerRenderers (constructors) {
      MapRenderer$$1.prototype.registerLayerRenderers.call(this, constructors);
      for (var i = 0, ii = constructors.length; i < ii; ++i) {
        var ctor = constructors[i];
        if (!includes(layerRendererConstructors, ctor)) {
          layerRendererConstructors.push(ctor);
        }
      }
    };

    return CanvasMapRenderer;
  }(MapRenderer));

  /**
   * @module ol/renderer/Layer
   */

  var LayerRenderer = /*@__PURE__*/(function (Observable$$1) {
    function LayerRenderer(layer) {

      Observable$$1.call(this);

      /**
       * @private
       * @type {import("../layer/Layer.js").default}
       */
      this.layer_ = layer;

    }

    if ( Observable$$1 ) LayerRenderer.__proto__ = Observable$$1;
    LayerRenderer.prototype = Object.create( Observable$$1 && Observable$$1.prototype );
    LayerRenderer.prototype.constructor = LayerRenderer;

    /**
     * Create a function that adds loaded tiles to the tile lookup.
     * @param {import("../source/Tile.js").default} source Tile source.
     * @param {import("../proj/Projection.js").default} projection Projection of the tiles.
     * @param {Object<number, Object<string, import("../Tile.js").default>>} tiles Lookup of loaded tiles by zoom level.
     * @return {function(number, import("../TileRange.js").default):boolean} A function that can be
     *     called with a zoom level and a tile range to add loaded tiles to the lookup.
     * @protected
     */
    LayerRenderer.prototype.createLoadedTileFinder = function createLoadedTileFinder (source, projection, tiles) {
      return (
        /**
         * @param {number} zoom Zoom level.
         * @param {import("../TileRange.js").default} tileRange Tile range.
         * @return {boolean} The tile range is fully loaded.
         */
        function(zoom, tileRange) {
          /**
           * @param {import("../Tile.js").default} tile Tile.
           */
          function callback(tile) {
            if (!tiles[zoom]) {
              tiles[zoom] = {};
            }
            tiles[zoom][tile.tileCoord.toString()] = tile;
          }
          return source.forEachLoadedTile(projection, zoom, tileRange, callback);
        }
      );
    };

    /**
     * @abstract
     * @param {import("../coordinate.js").Coordinate} coordinate Coordinate.
     * @param {import("../PluggableMap.js").FrameState} frameState Frame state.
     * @param {number} hitTolerance Hit tolerance in pixels.
     * @param {function(import("../Feature.js").FeatureLike, import("../layer/Layer.js").default): T} callback Feature callback.
     * @return {T|void} Callback result.
     * @template T
     */
    LayerRenderer.prototype.forEachFeatureAtCoordinate = function forEachFeatureAtCoordinate (coordinate, frameState, hitTolerance, callback) {};

    /**
     * @return {import("../layer/Layer.js").default} Layer.
     */
    LayerRenderer.prototype.getLayer = function getLayer () {
      return this.layer_;
    };

    /**
     * Handle changes in image state.
     * @param {import("../events/Event.js").default} event Image change event.
     * @private
     */
    LayerRenderer.prototype.handleImageChange_ = function handleImageChange_ (event) {
      var image = /** @type {import("../Image.js").default} */ (event.target);
      if (image.getState() === ImageState.LOADED) {
        this.renderIfReadyAndVisible();
      }
    };

    /**
     * @param {import("../coordinate.js").Coordinate} coordinate Coordinate.
     * @param {import("../PluggableMap.js").FrameState} frameState Frame state.
     * @return {boolean} Is there a feature at the given coordinate?
     */
    LayerRenderer.prototype.hasFeatureAtCoordinate = function hasFeatureAtCoordinate (coordinate, frameState) {
      return false;
    };

    /**
     * Load the image if not already loaded, and register the image change
     * listener if needed.
     * @param {import("../ImageBase.js").default} image Image.
     * @return {boolean} `true` if the image is already loaded, `false` otherwise.
     * @protected
     */
    LayerRenderer.prototype.loadImage = function loadImage (image) {
      var imageState = image.getState();
      if (imageState != ImageState.LOADED && imageState != ImageState.ERROR) {
        listen(image, EventType.CHANGE, this.handleImageChange_, this);
      }
      if (imageState == ImageState.IDLE) {
        image.load();
        imageState = image.getState();
      }
      return imageState == ImageState.LOADED;
    };

    /**
     * @protected
     */
    LayerRenderer.prototype.renderIfReadyAndVisible = function renderIfReadyAndVisible () {
      var layer = this.getLayer();
      if (layer.getVisible() && layer.getSourceState() == SourceState.READY) {
        this.changed();
      }
    };

    /**
     * @param {import("../PluggableMap.js").FrameState} frameState Frame state.
     * @param {import("../source/Tile.js").default} tileSource Tile source.
     * @protected
     */
    LayerRenderer.prototype.scheduleExpireCache = function scheduleExpireCache (frameState, tileSource) {
      if (tileSource.canExpireCache()) {
        /**
         * @param {import("../source/Tile.js").default} tileSource Tile source.
         * @param {import("../PluggableMap.js").default} map Map.
         * @param {import("../PluggableMap.js").FrameState} frameState Frame state.
         */
        var postRenderFunction = function(tileSource, map, frameState) {
          var tileSourceKey = getUid(tileSource);
          if (tileSourceKey in frameState.usedTiles) {
            tileSource.expireCache(frameState.viewState.projection,
              frameState.usedTiles[tileSourceKey]);
          }
        }.bind(null, tileSource);

        frameState.postRenderFunctions.push(
          /** @type {import("../PluggableMap.js").PostRenderFunction} */ (postRenderFunction)
        );
      }
    };

    /**
     * @param {!Object<string, !Object<string, import("../TileRange.js").default>>} usedTiles Used tiles.
     * @param {import("../source/Tile.js").default} tileSource Tile source.
     * @param {number} z Z.
     * @param {import("../TileRange.js").default} tileRange Tile range.
     * @protected
     */
    LayerRenderer.prototype.updateUsedTiles = function updateUsedTiles (usedTiles, tileSource, z, tileRange) {
      // FIXME should we use tilesToDrawByZ instead?
      var tileSourceKey = getUid(tileSource);
      var zKey = z.toString();
      if (tileSourceKey in usedTiles) {
        if (zKey in usedTiles[tileSourceKey]) {
          usedTiles[tileSourceKey][zKey].extend(tileRange);
        } else {
          usedTiles[tileSourceKey][zKey] = tileRange;
        }
      } else {
        usedTiles[tileSourceKey] = {};
        usedTiles[tileSourceKey][zKey] = tileRange;
      }
    };

    /**
     * Manage tile pyramid.
     * This function performs a number of functions related to the tiles at the
     * current zoom and lower zoom levels:
     * - registers idle tiles in frameState.wantedTiles so that they are not
     *   discarded by the tile queue
     * - enqueues missing tiles
     * @param {import("../PluggableMap.js").FrameState} frameState Frame state.
     * @param {import("../source/Tile.js").default} tileSource Tile source.
     * @param {import("../tilegrid/TileGrid.js").default} tileGrid Tile grid.
     * @param {number} pixelRatio Pixel ratio.
     * @param {import("../proj/Projection.js").default} projection Projection.
     * @param {import("../extent.js").Extent} extent Extent.
     * @param {number} currentZ Current Z.
     * @param {number} preload Load low resolution tiles up to 'preload' levels.
     * @param {function(this: T, import("../Tile.js").default)=} opt_tileCallback Tile callback.
     * @param {T=} opt_this Object to use as `this` in `opt_tileCallback`.
     * @protected
     * @template T
     */
    LayerRenderer.prototype.manageTilePyramid = function manageTilePyramid (
      frameState,
      tileSource,
      tileGrid,
      pixelRatio,
      projection,
      extent,
      currentZ,
      preload,
      opt_tileCallback,
      opt_this
    ) {
      var tileSourceKey = getUid(tileSource);
      if (!(tileSourceKey in frameState.wantedTiles)) {
        frameState.wantedTiles[tileSourceKey] = {};
      }
      var wantedTiles = frameState.wantedTiles[tileSourceKey];
      var tileQueue = frameState.tileQueue;
      var minZoom = tileGrid.getMinZoom();
      var tile, tileRange, tileResolution, x, y, z;
      for (z = minZoom; z <= currentZ; ++z) {
        tileRange = tileGrid.getTileRangeForExtentAndZ(extent, z, tileRange);
        tileResolution = tileGrid.getResolution(z);
        for (x = tileRange.minX; x <= tileRange.maxX; ++x) {
          for (y = tileRange.minY; y <= tileRange.maxY; ++y) {
            if (currentZ - z <= preload) {
              tile = tileSource.getTile(z, x, y, pixelRatio, projection);
              if (tile.getState() == TileState.IDLE) {
                wantedTiles[tile.getKey()] = true;
                if (!tileQueue.isKeyQueued(tile.getKey())) {
                  tileQueue.enqueue([tile, tileSourceKey,
                    tileGrid.getTileCoordCenter(tile.tileCoord), tileResolution]);
                }
              }
              if (opt_tileCallback !== undefined) {
                opt_tileCallback.call(opt_this, tile);
              }
            } else {
              tileSource.useTile(z, x, y, projection);
            }
          }
        }
      }
    };

    return LayerRenderer;
  }(Observable));

  /**
   * @module ol/renderer/canvas/Layer
   */

  /**
   * @abstract
   */
  var CanvasLayerRenderer = /*@__PURE__*/(function (LayerRenderer$$1) {
    function CanvasLayerRenderer(layer) {

      LayerRenderer$$1.call(this, layer);

      /**
       * @protected
       * @type {number}
       */
      this.renderedResolution;

      /**
       * @private
       * @type {import("../../transform.js").Transform}
       */
      this.transform_ = create();

    }

    if ( LayerRenderer$$1 ) CanvasLayerRenderer.__proto__ = LayerRenderer$$1;
    CanvasLayerRenderer.prototype = Object.create( LayerRenderer$$1 && LayerRenderer$$1.prototype );
    CanvasLayerRenderer.prototype.constructor = CanvasLayerRenderer;

    /**
     * @param {CanvasRenderingContext2D} context Context.
     * @param {import("../../PluggableMap.js").FrameState} frameState Frame state.
     * @param {import("../../extent.js").Extent} extent Clip extent.
     * @protected
     */
    CanvasLayerRenderer.prototype.clip = function clip (context, frameState, extent) {
      var pixelRatio = frameState.pixelRatio;
      var width = frameState.size[0] * pixelRatio;
      var height = frameState.size[1] * pixelRatio;
      var rotation = frameState.viewState.rotation;
      var topLeft = getTopLeft(extent);
      var topRight = getTopRight(extent);
      var bottomRight = getBottomRight(extent);
      var bottomLeft = getBottomLeft(extent);

      apply(frameState.coordinateToPixelTransform, topLeft);
      apply(frameState.coordinateToPixelTransform, topRight);
      apply(frameState.coordinateToPixelTransform, bottomRight);
      apply(frameState.coordinateToPixelTransform, bottomLeft);

      context.save();
      rotateAtOffset(context, -rotation, width / 2, height / 2);
      context.beginPath();
      context.moveTo(topLeft[0] * pixelRatio, topLeft[1] * pixelRatio);
      context.lineTo(topRight[0] * pixelRatio, topRight[1] * pixelRatio);
      context.lineTo(bottomRight[0] * pixelRatio, bottomRight[1] * pixelRatio);
      context.lineTo(bottomLeft[0] * pixelRatio, bottomLeft[1] * pixelRatio);
      context.clip();
      rotateAtOffset(context, rotation, width / 2, height / 2);
    };

    /**
     * @param {import("../../render/EventType.js").default} type Event type.
     * @param {CanvasRenderingContext2D} context Context.
     * @param {import("../../PluggableMap.js").FrameState} frameState Frame state.
     * @param {import("../../transform.js").Transform=} opt_transform Transform.
     * @private
     */
    CanvasLayerRenderer.prototype.dispatchComposeEvent_ = function dispatchComposeEvent_ (type, context, frameState, opt_transform) {
      var layer = this.getLayer();
      if (layer.hasListener(type)) {
        var width = frameState.size[0] * frameState.pixelRatio;
        var height = frameState.size[1] * frameState.pixelRatio;
        var rotation = frameState.viewState.rotation;
        rotateAtOffset(context, -rotation, width / 2, height / 2);
        var transform = opt_transform !== undefined ?
          opt_transform : this.getTransform(frameState, 0);
        var render = new CanvasImmediateRenderer(
          context, frameState.pixelRatio, frameState.extent, transform,
          frameState.viewState.rotation);
        var composeEvent = new RenderEvent(type, render, frameState,
          context, null);
        layer.dispatchEvent(composeEvent);
        rotateAtOffset(context, rotation, width / 2, height / 2);
      }
    };

    /**
     * @param {import("../../coordinate.js").Coordinate} coordinate Coordinate.
     * @param {import("../../PluggableMap.js").FrameState} frameState FrameState.
     * @param {number} hitTolerance Hit tolerance in pixels.
     * @param {function(this: S, import("../../layer/Layer.js").default, (Uint8ClampedArray|Uint8Array)): T} callback Layer
     *     callback.
     * @param {S} thisArg Value to use as `this` when executing `callback`.
     * @return {T|undefined} Callback result.
     * @template S,T,U
     */
    CanvasLayerRenderer.prototype.forEachLayerAtCoordinate = function forEachLayerAtCoordinate (coordinate, frameState, hitTolerance, callback, thisArg) {
      var hasFeature = this.forEachFeatureAtCoordinate(coordinate, frameState, hitTolerance, TRUE);

      if (hasFeature) {
        return callback.call(thisArg, this.getLayer(), null);
      } else {
        return undefined;
      }
    };

    /**
     * @param {CanvasRenderingContext2D} context Context.
     * @param {import("../../PluggableMap.js").FrameState} frameState Frame state.
     * @param {import("../../layer/Layer.js").State} layerState Layer state.
     * @param {import("../../transform.js").Transform=} opt_transform Transform.
     * @protected
     */
    CanvasLayerRenderer.prototype.postCompose = function postCompose (context, frameState, layerState, opt_transform) {
      this.dispatchComposeEvent_(RenderEventType.POSTCOMPOSE, context, frameState, opt_transform);
    };

    /**
     * @param {CanvasRenderingContext2D} context Context.
     * @param {import("../../PluggableMap.js").FrameState} frameState Frame state.
     * @param {import("../../transform.js").Transform=} opt_transform Transform.
     * @protected
     */
    CanvasLayerRenderer.prototype.preCompose = function preCompose (context, frameState, opt_transform) {
      this.dispatchComposeEvent_(RenderEventType.PRECOMPOSE, context, frameState, opt_transform);
    };

    /**
     * @param {CanvasRenderingContext2D} context Context.
     * @param {import("../../PluggableMap.js").FrameState} frameState Frame state.
     * @param {import("../../transform.js").Transform=} opt_transform Transform.
     * @protected
     */
    CanvasLayerRenderer.prototype.dispatchRenderEvent = function dispatchRenderEvent (context, frameState, opt_transform) {
      this.dispatchComposeEvent_(RenderEventType.RENDER, context, frameState, opt_transform);
    };

    /**
     * @param {import("../../PluggableMap.js").FrameState} frameState Frame state.
     * @param {number} offsetX Offset on the x-axis in view coordinates.
     * @protected
     * @return {!import("../../transform.js").Transform} Transform.
     */
    CanvasLayerRenderer.prototype.getTransform = function getTransform (frameState, offsetX) {
      var viewState = frameState.viewState;
      var pixelRatio = frameState.pixelRatio;
      var dx1 = pixelRatio * frameState.size[0] / 2;
      var dy1 = pixelRatio * frameState.size[1] / 2;
      var sx = pixelRatio / viewState.resolution;
      var sy = -sx;
      var angle = -viewState.rotation;
      var dx2 = -viewState.center[0] + offsetX;
      var dy2 = -viewState.center[1];
      return compose(this.transform_, dx1, dy1, sx, sy, angle, dx2, dy2);
    };

    /**
     * @abstract
     * @param {import("../../PluggableMap.js").FrameState} frameState Frame state.
     * @param {import("../../layer/Layer.js").State} layerState Layer state.
     * @param {CanvasRenderingContext2D} context Context.
     */
    CanvasLayerRenderer.prototype.composeFrame = function composeFrame (frameState, layerState, context) {
      abstract();
    };

    /**
     * @abstract
     * @param {import("../../PluggableMap.js").FrameState} frameState Frame state.
     * @param {import("../../layer/Layer.js").State} layerState Layer state.
     * @return {boolean} whether composeFrame should be called.
     */
    CanvasLayerRenderer.prototype.prepareFrame = function prepareFrame (frameState, layerState) {
      return abstract();
    };

    return CanvasLayerRenderer;
  }(LayerRenderer));

  /**
   * @module ol/renderer/canvas/IntermediateCanvas
   */

  /**
   * @abstract
   */
  var IntermediateCanvasRenderer = /*@__PURE__*/(function (CanvasLayerRenderer$$1) {
    function IntermediateCanvasRenderer(layer) {

      CanvasLayerRenderer$$1.call(this, layer);

      /**
       * @protected
       * @type {import("../../transform.js").Transform}
       */
      this.coordinateToCanvasPixelTransform = create();

      /**
       * @private
       * @type {CanvasRenderingContext2D}
       */
      this.hitCanvasContext_ = null;

    }

    if ( CanvasLayerRenderer$$1 ) IntermediateCanvasRenderer.__proto__ = CanvasLayerRenderer$$1;
    IntermediateCanvasRenderer.prototype = Object.create( CanvasLayerRenderer$$1 && CanvasLayerRenderer$$1.prototype );
    IntermediateCanvasRenderer.prototype.constructor = IntermediateCanvasRenderer;

    /**
     * @inheritDoc
     */
    IntermediateCanvasRenderer.prototype.composeFrame = function composeFrame (frameState, layerState, context) {

      this.preCompose(context, frameState);

      var image = this.getImage();
      if (image) {

        // clipped rendering if layer extent is set
        var extent = layerState.extent;
        var clipped = extent !== undefined &&
            !containsExtent(extent, frameState.extent) &&
            intersects(extent, frameState.extent);
        if (clipped) {
          this.clip(context, frameState, /** @type {import("../../extent.js").Extent} */ (extent));
        }

        var imageTransform = this.getImageTransform();
        // for performance reasons, context.save / context.restore is not used
        // to save and restore the transformation matrix and the opacity.
        // see http://jsperf.com/context-save-restore-versus-variable
        var alpha = context.globalAlpha;
        context.globalAlpha = layerState.opacity;

        // for performance reasons, context.setTransform is only used
        // when the view is rotated. see http://jsperf.com/canvas-transform
        var dx = imageTransform[4];
        var dy = imageTransform[5];
        var dw = image.width * imageTransform[0];
        var dh = image.height * imageTransform[3];
        if (dw >= 0.5 && dh >= 0.5) {
          context.drawImage(image, 0, 0, +image.width, +image.height,
            Math.round(dx), Math.round(dy), Math.round(dw), Math.round(dh));
        }
        context.globalAlpha = alpha;

        if (clipped) {
          context.restore();
        }
      }

      this.postCompose(context, frameState, layerState);
    };

    /**
     * @abstract
     * @return {HTMLCanvasElement|HTMLVideoElement|HTMLImageElement} Canvas.
     */
    IntermediateCanvasRenderer.prototype.getImage = function getImage () {
      return abstract();
    };

    /**
     * @abstract
     * @return {!import("../../transform.js").Transform} Image transform.
     */
    IntermediateCanvasRenderer.prototype.getImageTransform = function getImageTransform () {
      return abstract();
    };

    /**
     * @inheritDoc
     */
    IntermediateCanvasRenderer.prototype.forEachLayerAtCoordinate = function forEachLayerAtCoordinate (coordinate, frameState, hitTolerance, callback, thisArg) {
      if (!this.getImage()) {
        return undefined;
      }

      var pixel = apply(this.coordinateToCanvasPixelTransform, coordinate.slice());
      scale(pixel, frameState.viewState.resolution / this.renderedResolution);

      if (!this.hitCanvasContext_) {
        this.hitCanvasContext_ = createCanvasContext2D(1, 1);
      }

      this.hitCanvasContext_.clearRect(0, 0, 1, 1);
      this.hitCanvasContext_.drawImage(this.getImage(), pixel[0], pixel[1], 1, 1, 0, 0, 1, 1);

      var imageData = this.hitCanvasContext_.getImageData(0, 0, 1, 1).data;
      if (imageData[3] > 0) {
        return callback.call(thisArg, this.getLayer(), imageData);
      } else {
        return undefined;
      }
    };

    return IntermediateCanvasRenderer;
  }(CanvasLayerRenderer));

  /**
   * @module ol/renderer/canvas/ImageLayer
   */

  /**
   * @classdesc
   * Canvas renderer for image layers.
   * @api
   */
  var CanvasImageLayerRenderer = /*@__PURE__*/(function (IntermediateCanvasRenderer$$1) {
    function CanvasImageLayerRenderer(imageLayer) {

      IntermediateCanvasRenderer$$1.call(this, imageLayer);

      /**
       * @private
       * @type {?import("../../ImageBase.js").default}
       */
      this.image_ = null;

      /**
       * @private
       * @type {import("../../transform.js").Transform}
       */
      this.imageTransform_ = create();

      /**
       * @type {!Array<string>}
       */
      this.skippedFeatures_ = [];

      /**
       * @private
       * @type {import("./VectorLayer.js").default}
       */
      this.vectorRenderer_ = null;

      if (imageLayer.getType() === LayerType.VECTOR) {
        for (var i = 0, ii = layerRendererConstructors.length; i < ii; ++i) {
          var ctor = layerRendererConstructors[i];
          if (ctor !== CanvasImageLayerRenderer && ctor['handles'](imageLayer)) {
            this.vectorRenderer_ = /** @type {import("./VectorLayer.js").default} */ (new ctor(imageLayer));
            break;
          }
        }
      }

    }

    if ( IntermediateCanvasRenderer$$1 ) CanvasImageLayerRenderer.__proto__ = IntermediateCanvasRenderer$$1;
    CanvasImageLayerRenderer.prototype = Object.create( IntermediateCanvasRenderer$$1 && IntermediateCanvasRenderer$$1.prototype );
    CanvasImageLayerRenderer.prototype.constructor = CanvasImageLayerRenderer;

    /**
     * @inheritDoc
     */
    CanvasImageLayerRenderer.prototype.disposeInternal = function disposeInternal () {
      if (this.vectorRenderer_) {
        this.vectorRenderer_.dispose();
      }
      IntermediateCanvasRenderer$$1.prototype.disposeInternal.call(this);
    };

    /**
     * @inheritDoc
     */
    CanvasImageLayerRenderer.prototype.getImage = function getImage () {
      return !this.image_ ? null : this.image_.getImage();
    };

    /**
     * @inheritDoc
     */
    CanvasImageLayerRenderer.prototype.getImageTransform = function getImageTransform () {
      return this.imageTransform_;
    };

    /**
     * @inheritDoc
     */
    CanvasImageLayerRenderer.prototype.prepareFrame = function prepareFrame (frameState, layerState) {

      var pixelRatio = frameState.pixelRatio;
      var size = frameState.size;
      var viewState = frameState.viewState;
      var viewCenter = viewState.center;
      var viewResolution = viewState.resolution;

      var image;
      var imageLayer = /** @type {import("../../layer/Image.js").default} */ (this.getLayer());
      var imageSource = /** @type {import("../../source/Image.js").default} */ (imageLayer.getSource());

      var hints = frameState.viewHints;

      var vectorRenderer = this.vectorRenderer_;
      var renderedExtent = frameState.extent;
      if (!vectorRenderer && layerState.extent !== undefined) {
        renderedExtent = getIntersection(renderedExtent, layerState.extent);
      }

      if (!hints[ViewHint.ANIMATING] && !hints[ViewHint.INTERACTING] &&
          !isEmpty$1(renderedExtent)) {
        var projection = viewState.projection;
        var skippedFeatures = this.skippedFeatures_;
        if (vectorRenderer) {
          var context = vectorRenderer.context;
          var imageFrameState = /** @type {import("../../PluggableMap.js").FrameState} */ (assign({}, frameState, {
            size: [
              getWidth(renderedExtent) / viewResolution,
              getHeight(renderedExtent) / viewResolution
            ],
            viewState: /** @type {import("../../View.js").State} */ (assign({}, frameState.viewState, {
              rotation: 0
            }))
          }));
          var newSkippedFeatures = Object.keys(imageFrameState.skippedFeatureUids).sort();
          image = new ImageCanvas(renderedExtent, viewResolution, pixelRatio, context.canvas, function(callback) {
            if (vectorRenderer.prepareFrame(imageFrameState, layerState) &&
                (vectorRenderer.replayGroupChanged ||
                !equals(skippedFeatures, newSkippedFeatures))) {
              context.canvas.width = imageFrameState.size[0] * pixelRatio;
              context.canvas.height = imageFrameState.size[1] * pixelRatio;
              vectorRenderer.compose(context, imageFrameState, layerState);
              skippedFeatures = newSkippedFeatures;
              callback();
            }
          });
        } else {
          image = imageSource.getImage(
            renderedExtent, viewResolution, pixelRatio, projection);
        }
        if (image && this.loadImage(image)) {
          this.image_ = image;
          this.skippedFeatures_ = skippedFeatures;
        }
      }

      if (this.image_) {
        image = this.image_;
        var imageExtent = image.getExtent();
        var imageResolution = image.getResolution();
        var imagePixelRatio = image.getPixelRatio();
        var scale = pixelRatio * imageResolution /
            (viewResolution * imagePixelRatio);
        var transform = compose(this.imageTransform_,
          pixelRatio * size[0] / 2, pixelRatio * size[1] / 2,
          scale, scale,
          0,
          imagePixelRatio * (imageExtent[0] - viewCenter[0]) / imageResolution,
          imagePixelRatio * (viewCenter[1] - imageExtent[3]) / imageResolution);
        compose(this.coordinateToCanvasPixelTransform,
          pixelRatio * size[0] / 2 - transform[4], pixelRatio * size[1] / 2 - transform[5],
          pixelRatio / viewResolution, -pixelRatio / viewResolution,
          0,
          -viewCenter[0], -viewCenter[1]);

        this.renderedResolution = imageResolution * pixelRatio / imagePixelRatio;
      }

      return !!this.image_;
    };

    /**
     * @inheritDoc
     */
    CanvasImageLayerRenderer.prototype.forEachFeatureAtCoordinate = function forEachFeatureAtCoordinate (coordinate, frameState, hitTolerance, callback) {
      if (this.vectorRenderer_) {
        return this.vectorRenderer_.forEachFeatureAtCoordinate(coordinate, frameState, hitTolerance, callback);
      } else {
        return IntermediateCanvasRenderer$$1.prototype.forEachFeatureAtCoordinate.call(this, coordinate, frameState, hitTolerance, callback);
      }
    };

    return CanvasImageLayerRenderer;
  }(IntermediateCanvasRenderer));


  /**
   * Determine if this renderer handles the provided layer.
   * @param {import("../../layer/Layer.js").default} layer The candidate layer.
   * @return {boolean} The renderer can render the layer.
   */
  CanvasImageLayerRenderer['handles'] = function(layer) {
    return layer.getType() === LayerType.IMAGE ||
      layer.getType() === LayerType.VECTOR &&
      /** @type {import("../../layer/Vector.js").default} */ (layer).getRenderMode() === VectorRenderType.IMAGE;
  };


  /**
   * Create a layer renderer.
   * @param {import("../Map.js").default} mapRenderer The map renderer.
   * @param {import("../../layer/Layer.js").default} layer The layer to be rendererd.
   * @return {CanvasImageLayerRenderer} The layer renderer.
   */
  CanvasImageLayerRenderer['create'] = function(mapRenderer, layer) {
    return new CanvasImageLayerRenderer(/** @type {import("../../layer/Image.js").default} */ (layer));
  };

  /**
   * @module ol/TileRange
   */

  /**
   * A representation of a contiguous block of tiles.  A tile range is specified
   * by its min/max tile coordinates and is inclusive of coordinates.
   */
  var TileRange = function TileRange(minX, maxX, minY, maxY) {

    /**
     * @type {number}
     */
    this.minX = minX;

    /**
     * @type {number}
     */
    this.maxX = maxX;

    /**
     * @type {number}
     */
    this.minY = minY;

    /**
     * @type {number}
     */
    this.maxY = maxY;

  };

  /**
   * @param {import("./tilecoord.js").TileCoord} tileCoord Tile coordinate.
   * @return {boolean} Contains tile coordinate.
   */
  TileRange.prototype.contains = function contains (tileCoord) {
    return this.containsXY(tileCoord[1], tileCoord[2]);
  };

  /**
   * @param {TileRange} tileRange Tile range.
   * @return {boolean} Contains.
   */
  TileRange.prototype.containsTileRange = function containsTileRange (tileRange) {
    return this.minX <= tileRange.minX && tileRange.maxX <= this.maxX &&
       this.minY <= tileRange.minY && tileRange.maxY <= this.maxY;
  };

  /**
   * @param {number} x Tile coordinate x.
   * @param {number} y Tile coordinate y.
   * @return {boolean} Contains coordinate.
   */
  TileRange.prototype.containsXY = function containsXY (x, y) {
    return this.minX <= x && x <= this.maxX && this.minY <= y && y <= this.maxY;
  };

  /**
   * @param {TileRange} tileRange Tile range.
   * @return {boolean} Equals.
   */
  TileRange.prototype.equals = function equals (tileRange) {
    return this.minX == tileRange.minX && this.minY == tileRange.minY &&
       this.maxX == tileRange.maxX && this.maxY == tileRange.maxY;
  };

  /**
   * @param {TileRange} tileRange Tile range.
   */
  TileRange.prototype.extend = function extend (tileRange) {
    if (tileRange.minX < this.minX) {
      this.minX = tileRange.minX;
    }
    if (tileRange.maxX > this.maxX) {
      this.maxX = tileRange.maxX;
    }
    if (tileRange.minY < this.minY) {
      this.minY = tileRange.minY;
    }
    if (tileRange.maxY > this.maxY) {
      this.maxY = tileRange.maxY;
    }
  };

  /**
   * @return {number} Height.
   */
  TileRange.prototype.getHeight = function getHeight () {
    return this.maxY - this.minY + 1;
  };

  /**
   * @return {import("./size.js").Size} Size.
   */
  TileRange.prototype.getSize = function getSize () {
    return [this.getWidth(), this.getHeight()];
  };

  /**
   * @return {number} Width.
   */
  TileRange.prototype.getWidth = function getWidth () {
    return this.maxX - this.minX + 1;
  };

  /**
   * @param {TileRange} tileRange Tile range.
   * @return {boolean} Intersects.
   */
  TileRange.prototype.intersects = function intersects (tileRange) {
    return this.minX <= tileRange.maxX &&
       this.maxX >= tileRange.minX &&
       this.minY <= tileRange.maxY &&
       this.maxY >= tileRange.minY;
  };


  /**
   * @param {number} minX Minimum X.
   * @param {number} maxX Maximum X.
   * @param {number} minY Minimum Y.
   * @param {number} maxY Maximum Y.
   * @param {TileRange=} tileRange TileRange.
   * @return {TileRange} Tile range.
   */
  function createOrUpdate$1(minX, maxX, minY, maxY, tileRange) {
    if (tileRange !== undefined) {
      tileRange.minX = minX;
      tileRange.maxX = maxX;
      tileRange.minY = minY;
      tileRange.maxY = maxY;
      return tileRange;
    } else {
      return new TileRange(minX, maxX, minY, maxY);
    }
  }

  /**
   * @module ol/renderer/canvas/TileLayer
   */

  /**
   * @classdesc
   * Canvas renderer for tile layers.
   * @api
   */
  var CanvasTileLayerRenderer = /*@__PURE__*/(function (IntermediateCanvasRenderer$$1) {
    function CanvasTileLayerRenderer(tileLayer, opt_noContext) {

      IntermediateCanvasRenderer$$1.call(this, tileLayer);

      /**
       * @protected
       * @type {CanvasRenderingContext2D}
       */
      this.context = opt_noContext ? null : createCanvasContext2D();

      /**
       * @private
       * @type {number}
       */
      this.oversampling_;

      /**
       * @private
       * @type {import("../../extent.js").Extent}
       */
      this.renderedExtent_ = null;

      /**
       * @protected
       * @type {number}
       */
      this.renderedRevision;

      /**
       * @protected
       * @type {!Array<import("../../Tile.js").default>}
       */
      this.renderedTiles = [];

      /**
       * @private
       * @type {boolean}
       */
      this.newTiles_ = false;

      /**
       * @protected
       * @type {import("../../extent.js").Extent}
       */
      this.tmpExtent = createEmpty();

      /**
       * @private
       * @type {import("../../TileRange.js").default}
       */
      this.tmpTileRange_ = new TileRange(0, 0, 0, 0);

      /**
       * @private
       * @type {import("../../transform.js").Transform}
       */
      this.imageTransform_ = create();

      /**
       * @protected
       * @type {number}
       */
      this.zDirection = 0;

    }

    if ( IntermediateCanvasRenderer$$1 ) CanvasTileLayerRenderer.__proto__ = IntermediateCanvasRenderer$$1;
    CanvasTileLayerRenderer.prototype = Object.create( IntermediateCanvasRenderer$$1 && IntermediateCanvasRenderer$$1.prototype );
    CanvasTileLayerRenderer.prototype.constructor = CanvasTileLayerRenderer;

    /**
     * @private
     * @param {import("../../Tile.js").default} tile Tile.
     * @return {boolean} Tile is drawable.
     */
    CanvasTileLayerRenderer.prototype.isDrawableTile_ = function isDrawableTile_ (tile) {
      var tileLayer = /** @type {import("../../layer/Tile.js").default} */ (this.getLayer());
      var tileState = tile.getState();
      var useInterimTilesOnError = tileLayer.getUseInterimTilesOnError();
      return tileState == TileState.LOADED ||
          tileState == TileState.EMPTY ||
          tileState == TileState.ERROR && !useInterimTilesOnError;
    };

    /**
     * @param {number} z Tile coordinate z.
     * @param {number} x Tile coordinate x.
     * @param {number} y Tile coordinate y.
     * @param {number} pixelRatio Pixel ratio.
     * @param {import("../../proj/Projection.js").default} projection Projection.
     * @return {!import("../../Tile.js").default} Tile.
     */
    CanvasTileLayerRenderer.prototype.getTile = function getTile (z, x, y, pixelRatio, projection) {
      var tileLayer = /** @type {import("../../layer/Tile.js").default} */ (this.getLayer());
      var tileSource = /** @type {import("../../source/Tile.js").default} */ (tileLayer.getSource());
      var tile = tileSource.getTile(z, x, y, pixelRatio, projection);
      if (tile.getState() == TileState.ERROR) {
        if (!tileLayer.getUseInterimTilesOnError()) {
          // When useInterimTilesOnError is false, we consider the error tile as loaded.
          tile.setState(TileState.LOADED);
        } else if (tileLayer.getPreload() > 0) {
          // Preloaded tiles for lower resolutions might have finished loading.
          this.newTiles_ = true;
        }
  