# Generated by Django 3.2.9 on 2021-11-17 09:34

from django.db import migrations, models


def get_public_children(obj):
    for child in obj.children.all():
        if child.public_guest_access:
            return True
        ret = get_public_children(child)
        if ret:
            return True
    return False


def populate_public_children(apps, schema_editor):
    """Populate the new has_public_children field in the Project model"""
    Project = apps.get_model('projectroles', 'Project')
    for project in Project.objects.all():
        project.has_public_children = get_public_children(project)
        project.save()


class Migration(migrations.Migration):

    dependencies = [
        ('projectroles', '0019_project_public_guest_access'),
    ]

    operations = [
        migrations.AddField(
            model_name='project',
            name='has_public_children',
            field=models.BooleanField(default=False, help_text='Whether project has children with public access (auto-generated)'),
        ),
        migrations.RunPython(
            populate_public_children,
            reverse_code=migrations.RunPython.noop
        ),
    ]
