# -*- coding: utf-8 -*-
# Generated by Django 1.11.29 on 2021-01-29 08:16
from __future__ import unicode_literals

from django.db import migrations, models


def get_project_parents(obj):
    if not obj.parent:
        return None
    ret = []
    parent = obj.parent
    while parent:
        ret.append(parent)
        parent = parent.parent
    return reversed(ret)


def get_project_full_title(obj):
    parents = get_project_parents(obj)
    ret = ' / '.join([p.title for p in parents]) + ' / ' if parents else ''
    ret += obj.title
    return ret


def populate_full_title(apps, schema_editor):
    """Populate the new full_title field in the Project model"""
    Project = apps.get_model('projectroles', 'Project')
    for project in Project.objects.all():
        project.full_title = get_project_full_title(project)
        project.save()


class Migration(migrations.Migration):

    dependencies = [
        ('projectroles', '0016_app_plugin_field_none'),
    ]

    operations = [
        migrations.AddField(
            model_name='project',
            name='full_title',
            field=models.CharField(help_text='Full project title with parent path (auto-generated)', max_length=4096, null=True),
        ),
        migrations.RunPython(
            populate_full_title,
            reverse_code=migrations.RunPython.noop
        ),
    ]
