# -*- coding: utf-8 -*-
# Generated by Django 1.11.15 on 2018-10-10 15:34
from __future__ import unicode_literals

from django.db import migrations, models
import django.db.models.deletion
import uuid


class Migration(migrations.Migration):

    dependencies = [
        ('projectroles', '0005_update_uuid'),
    ]

    operations = [
        migrations.CreateModel(
            name='RemoteProject',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('project_uuid', models.UUIDField(default=None, help_text='Project UUID')),
                ('level', models.CharField(default='NONE', help_text='Project access level', max_length=255)),
                ('date_access', models.DateTimeField(help_text='DateTime of last access from/to remote site', null=True)),
                ('sodar_uuid', models.UUIDField(default=uuid.uuid4, help_text='RemoteProject relation UUID (local)', unique=True)),
            ],
            options={
                'ordering': ['site__name', 'project_uuid'],
            },
        ),
        migrations.CreateModel(
            name='RemoteSite',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(help_text='Site name', max_length=255, unique=True)),
                ('url', models.URLField(help_text='Site URL', max_length=2000)),
                ('mode', models.CharField(default='TARGET', help_text='Site mode', max_length=64)),
                ('description', models.TextField(help_text='Site description')),
                ('secret', models.CharField(help_text='Secret token for connecting to the source site', max_length=255)),
                ('sodar_uuid', models.UUIDField(default=uuid.uuid4, help_text='RemoteSite relation UUID (local)', unique=True)),
            ],
            options={
                'ordering': ['name'],
            },
        ),
        migrations.AlterField(
            model_name='project',
            name='description',
            field=models.CharField(blank=True, help_text='Short project description', max_length=512, null=True),
        ),
        migrations.AlterUniqueTogether(
            name='remotesite',
            unique_together=set([('url', 'mode', 'secret')]),
        ),
        migrations.AddField(
            model_name='remoteproject',
            name='project',
            field=models.ForeignKey(blank=True, help_text='Related project object (if created locally)', null=True, on_delete=django.db.models.deletion.CASCADE, related_name='remotes', to='projectroles.Project'),
        ),
        migrations.AddField(
            model_name='remoteproject',
            name='site',
            field=models.ForeignKey(help_text='Remote SODAR site', on_delete=django.db.models.deletion.CASCADE, related_name='projects', to='projectroles.RemoteSite'),
        ),
    ]
