# -*- coding: utf-8 -*-
# Generated by Django 1.11.11 on 2018-04-11 15:58
from __future__ import unicode_literals

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('djangoplugins', '0001_initial'),
        ('projectroles', '0001_initial'),
    ]

    operations = [
        migrations.AddField(
            model_name='roleassignment',
            name='user',
            field=models.ForeignKey(help_text='User for whom role is assigned', on_delete=django.db.models.deletion.CASCADE, related_name='roles', to=settings.AUTH_USER_MODEL),
        ),
        migrations.AddField(
            model_name='projectusertag',
            name='project',
            field=models.ForeignKey(help_text='Project in which the tag is assigned', on_delete=django.db.models.deletion.CASCADE, related_name='tags', to='projectroles.Project'),
        ),
        migrations.AddField(
            model_name='projectusertag',
            name='user',
            field=models.ForeignKey(help_text='User for whom the tag is assigned', on_delete=django.db.models.deletion.CASCADE, related_name='project_tags', to=settings.AUTH_USER_MODEL),
        ),
        migrations.AddField(
            model_name='projectsetting',
            name='app_plugin',
            field=models.ForeignKey(help_text='App to which the setting belongs', on_delete=django.db.models.deletion.CASCADE, related_name='settings', to='djangoplugins.Plugin'),
        ),
        migrations.AddField(
            model_name='projectsetting',
            name='project',
            field=models.ForeignKey(help_text='Project to which the setting belongs', on_delete=django.db.models.deletion.CASCADE, related_name='settings', to='projectroles.Project'),
        ),
        migrations.AddField(
            model_name='projectinvite',
            name='issuer',
            field=models.ForeignKey(help_text='User who issued the invite', on_delete=django.db.models.deletion.CASCADE, related_name='issued_invites', to=settings.AUTH_USER_MODEL),
        ),
        migrations.AddField(
            model_name='projectinvite',
            name='project',
            field=models.ForeignKey(help_text='Project to which the person is invited', on_delete=django.db.models.deletion.CASCADE, related_name='invites', to='projectroles.Project'),
        ),
        migrations.AddField(
            model_name='projectinvite',
            name='role',
            field=models.ForeignKey(help_text='Role assigned to the person', on_delete=django.db.models.deletion.CASCADE, to='projectroles.Role'),
        ),
        migrations.AddField(
            model_name='project',
            name='parent',
            field=models.ForeignKey(blank=True, help_text='Parent category if nested', null=True, on_delete=django.db.models.deletion.CASCADE, related_name='children', to='projectroles.Project'),
        ),
        migrations.AddIndex(
            model_name='roleassignment',
            index=models.Index(fields=['project'], name='projectrole_project_b13795_idx'),
        ),
        migrations.AddIndex(
            model_name='roleassignment',
            index=models.Index(fields=['user'], name='projectrole_user_id_0e46f7_idx'),
        ),
        migrations.AlterUniqueTogether(
            name='projectsetting',
            unique_together=set([('project', 'app_plugin', 'name')]),
        ),
        migrations.AlterUniqueTogether(
            name='project',
            unique_together=set([('title', 'parent')]),
        ),
    ]
