# -*- coding: utf-8 -*-
# Generated by Django 1.11.16 on 2018-10-26 12:16
from __future__ import unicode_literals

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    dependencies = [("bgjobs", "0001_initial")]

    operations = [
        migrations.CreateModel(
            name="BackgroundJobLogEntry",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True, primary_key=True, serialize=False, verbose_name="ID"
                    ),
                ),
                (
                    "date_created",
                    models.DateTimeField(auto_now_add=True, help_text="DateTime of creation"),
                ),
                (
                    "level",
                    models.CharField(
                        choices=[
                            ("debug", "debug"),
                            ("info", "info"),
                            ("warning", "warning"),
                            ("error", "error"),
                        ],
                        help_text="Level of log entry",
                        max_length=50,
                    ),
                ),
                ("message", models.TextField(help_text="Log level's message")),
                (
                    "job",
                    models.ForeignKey(
                        help_text="Owning background job",
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="log_entries",
                        to="bgjobs.BackgroundJob",
                    ),
                ),
            ],
            options={"ordering": ["date_created"]},
        )
    ]
