# MIT LICENSE
#
# Copyright 1997 - 2019 by IXIA Keysight
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"),
# to deal in the Software without restriction, including without limitation
# the rights to use, copy, modify, merge, publish, distribute, sublicense,
# and/or sell copies of the Software, and to permit persons to whom the
# Software is furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE. 
from ixnetwork_restpy.base import Base
from ixnetwork_restpy.files import Files


class TableStatLearnedInformation(Base):
    """This object allows to configure the table statistics trigger parameters.
    The TableStatLearnedInformation class encapsulates a list of tableStatLearnedInformation resources that is managed by the system.
    A list of resources can be retrieved from the server using the TableStatLearnedInformation.find() method.
    """

    __slots__ = ()
    _SDM_NAME = 'tableStatLearnedInformation'

    def __init__(self, parent):
        super(TableStatLearnedInformation, self).__init__(parent)

    @property
    def ActiveCount(self):
        """Indicates the number of active entries.

        Returns:
            number
        """
        return self._get_attribute('activeCount')

    @property
    def DataPathId(self):
        """Indicates the Datapath ID of the switch.

        Returns:
            str
        """
        return self._get_attribute('dataPathId')

    @property
    def DataPathIdAsHex(self):
        """Indicates the Datapath ID, in hexadecimal format, of the switch.

        Returns:
            str
        """
        return self._get_attribute('dataPathIdAsHex')

    @property
    def ErrorCode(self):
        """Signifies the error code of the error received

        Returns:
            str
        """
        return self._get_attribute('errorCode')

    @property
    def ErrorType(self):
        """Signifies the type of the error received.

        Returns:
            str
        """
        return self._get_attribute('errorType')

    @property
    def Latency(self):
        """Indicates the duration elapsed (in microsecond) between the learned info request and response.

        Returns:
            number
        """
        return self._get_attribute('latency')

    @property
    def LocalIp(self):
        """Indicates the local IP of the Controller.

        Returns:
            str
        """
        return self._get_attribute('localIp')

    @property
    def LookupCount(self):
        """Indicates the number of packets looked up in table.

        Returns:
            str
        """
        return self._get_attribute('lookupCount')

    @property
    def MatchedCount(self):
        """Indicates the number of packets that hit table.

        Returns:
            str
        """
        return self._get_attribute('matchedCount')

    @property
    def MaxEntries(self):
        """Indicates the maximum number of entries supported.

        Returns:
            number
        """
        return self._get_attribute('maxEntries')

    @property
    def NegotiatedVersion(self):
        """Version of the protocol that has been negotiated between OpenFLow Controller and Switch.

        Returns:
            str
        """
        return self._get_attribute('negotiatedVersion')

    @property
    def RemoteIp(self):
        """Indicates the IP of the remote end of the OF Channel.

        Returns:
            str
        """
        return self._get_attribute('remoteIp')

    @property
    def ReplyState(self):
        """Indicates the reply state of the switch.

        Returns:
            str
        """
        return self._get_attribute('replyState')

    @property
    def TableId(self):
        """Indicates the Identifier of table.

        Returns:
            str
        """
        return self._get_attribute('tableId')

    @property
    def TableName(self):
        """Indicates a name of the table.

        Returns:
            str
        """
        return self._get_attribute('tableName')

    @property
    def Wildcards(self):
        """Indicates the Wildcards that are supported by the table.

        Returns:
            str
        """
        return self._get_attribute('wildcards')

    def find(self, ActiveCount=None, DataPathId=None, DataPathIdAsHex=None, ErrorCode=None, ErrorType=None, Latency=None, LocalIp=None, LookupCount=None, MatchedCount=None, MaxEntries=None, NegotiatedVersion=None, RemoteIp=None, ReplyState=None, TableId=None, TableName=None, Wildcards=None):
        """Finds and retrieves tableStatLearnedInformation data from the server.

        All named parameters support regex and can be used to selectively retrieve tableStatLearnedInformation data from the server.
        By default the find method takes no parameters and will retrieve all tableStatLearnedInformation data from the server.

        Args:
            ActiveCount (number): Indicates the number of active entries.
            DataPathId (str): Indicates the Datapath ID of the switch.
            DataPathIdAsHex (str): Indicates the Datapath ID, in hexadecimal format, of the switch.
            ErrorCode (str): Signifies the error code of the error received
            ErrorType (str): Signifies the type of the error received.
            Latency (number): Indicates the duration elapsed (in microsecond) between the learned info request and response.
            LocalIp (str): Indicates the local IP of the Controller.
            LookupCount (str): Indicates the number of packets looked up in table.
            MatchedCount (str): Indicates the number of packets that hit table.
            MaxEntries (number): Indicates the maximum number of entries supported.
            NegotiatedVersion (str): Version of the protocol that has been negotiated between OpenFLow Controller and Switch.
            RemoteIp (str): Indicates the IP of the remote end of the OF Channel.
            ReplyState (str): Indicates the reply state of the switch.
            TableId (str): Indicates the Identifier of table.
            TableName (str): Indicates a name of the table.
            Wildcards (str): Indicates the Wildcards that are supported by the table.

        Returns:
            self: This instance with matching tableStatLearnedInformation data retrieved from the server available through an iterator or index

        Raises:
            ServerError: The server has encountered an uncategorized error condition
        """
        return self._select(locals())

    def read(self, href):
        """Retrieves a single instance of tableStatLearnedInformation data from the server.

        Args:
            href (str): An href to the instance to be retrieved

        Returns:
            self: This instance with the tableStatLearnedInformation data from the server available through an iterator or index

        Raises:
            NotFoundError: The requested resource does not exist on the server
            ServerError: The server has encountered an uncategorized error condition
        """
        return self._read(href)
