# MIT LICENSE
#
# Copyright 1997 - 2019 by IXIA Keysight
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"),
# to deal in the Software without restriction, including without limitation
# the rights to use, copy, modify, merge, publish, distribute, sublicense,
# and/or sell copies of the Software, and to permit persons to whom the
# Software is furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE. 
from ixnetwork_restpy.base import Base
from ixnetwork_restpy.files import Files


class MplsOam(Base):
    """
    The MplsOam class encapsulates a list of mplsOam resources that is be managed by the user.
    A list of resources can be retrieved from the server using the MplsOam.find() method.
    The list can be managed by the user by using the MplsOam.add() and MplsOam.remove() methods.
    """

    __slots__ = ()
    _SDM_NAME = 'mplsOam'

    def __init__(self, parent):
        super(MplsOam, self).__init__(parent)

    @property
    def LearnedInfo(self):
        """An instance of the LearnedInfo class.

        Returns:
            obj(ixnetwork_restpy.testplatform.sessions.ixnetwork.topology.learnedinfo.learnedinfo.LearnedInfo)

        Raises:
            NotFoundError: The requested resource does not exist on the server
            ServerError: The server has encountered an uncategorized error condition
        """
        from ixnetwork_restpy.testplatform.sessions.ixnetwork.topology.learnedinfo.learnedinfo import LearnedInfo
        return LearnedInfo(self)

    @property
    def SbfdInitiator(self):
        """An instance of the SbfdInitiator class.

        Returns:
            obj(ixnetwork_restpy.testplatform.sessions.ixnetwork.topology.sbfdinitiator.SbfdInitiator)

        Raises:
            NotFoundError: The requested resource does not exist on the server
            ServerError: The server has encountered an uncategorized error condition
        """
        from ixnetwork_restpy.testplatform.sessions.ixnetwork.topology.sbfdinitiator import SbfdInitiator
        return SbfdInitiator(self)._select()

    @property
    def SbfdResponder(self):
        """An instance of the SbfdResponder class.

        Returns:
            obj(ixnetwork_restpy.testplatform.sessions.ixnetwork.topology.sbfdresponder.SbfdResponder)

        Raises:
            NotFoundError: The requested resource does not exist on the server
            ServerError: The server has encountered an uncategorized error condition
        """
        from ixnetwork_restpy.testplatform.sessions.ixnetwork.topology.sbfdresponder import SbfdResponder
        return SbfdResponder(self)._select()

    @property
    def Active(self):
        """Activate/Deactivate Configuration

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('active')

    @property
    def BfdCvType(self):
        """This signifies the BFD Connectivity Verification type

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('bfdCvType')

    @property
    def BfdDiscriminatorEnd(self):
        """This signifies the last BFD Discriminator value. This value should be greater than the BFD Discriminator Start value

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('bfdDiscriminatorEnd')

    @property
    def BfdDiscriminatorStart(self):
        """This signifies the first BFD Discriminator value

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('bfdDiscriminatorStart')

    @property
    def ConnectedVia(self):
        """DEPRECATED List of layers this layer used to connect to the wire

        Returns:
            list(str[None|/api/v1/sessions/1/ixnetwork/topology?deepchild=*])
        """
        return self._get_attribute('connectedVia')
    @ConnectedVia.setter
    def ConnectedVia(self, value):
        self._set_attribute('connectedVia', value)

    @property
    def ControlChannel(self):
        """This signifies the communication control channel

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('controlChannel')

    @property
    def Count(self):
        """Number of elements inside associated multiplier-scaled container object, e.g. number of devices inside a Device Group.

        Returns:
            number
        """
        return self._get_attribute('count')

    @property
    def DescriptiveName(self):
        """Longer, more descriptive name for element. It's not guaranteed to be unique like -name-, but may offers more context

        Returns:
            str
        """
        return self._get_attribute('descriptiveName')

    @property
    def DestinationAddressIpv4(self):
        """The destination IPv4 Address

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('destinationAddressIpv4')

    @property
    def DownstreamAddressType(self):
        """This signifies the address Type of the downstream traffic

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('downstreamAddressType')

    @property
    def DownstreamInterfaceAddressNumbered(self):
        """This signifies the interface address of the downstream traffic in IPv4 format

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('downstreamInterfaceAddressNumbered')

    @property
    def DownstreamInterfaceAddressUnnumbered(self):
        """This signifies the interface address of the downstream traffic

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('downstreamInterfaceAddressUnnumbered')

    @property
    def DownstreamIpAddress(self):
        """This signifies the IPv4/IPv6 address of the downstream traffic

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('downstreamIpAddress')

    @property
    def EchoRequestInterval(self):
        """This signifies the minimum interval, in milliseconds, between received Echo packets that this interface is capable of supporting

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('echoRequestInterval')

    @property
    def EchoResponseTimeout(self):
        """This signifies the minimum timeout interval, in milliseconds, between received Echo packets

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('echoResponseTimeout')

    @property
    def EnableDSIflag(self):
        """This signifies the activation of the DS I Flag

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('enableDSIflag')

    @property
    def EnableDownstreamMappingTlv(self):
        """This signifies the enable of the downstream mapping TLV

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('enableDownstreamMappingTlv')

    @property
    def EnableDsNflag(self):
        """This signifies the activation of the DS N Flag

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('enableDsNflag')

    @property
    def EnableFecValidation(self):
        """Selection of the check box enables FEC validation

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('enableFecValidation')

    @property
    def EnablePeriodicPing(self):
        """If true, the router is pinged at regular intervals

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('enablePeriodicPing')

    @property
    def EnableSBfdResponder(self):
        """Enables S-BFD Responder

        Returns:
            bool
        """
        return self._get_attribute('enableSBfdResponder')
    @EnableSBfdResponder.setter
    def EnableSBfdResponder(self, value):
        self._set_attribute('enableSBfdResponder', value)

    @property
    def Errors(self):
        """A list of errors that have occurred

        Returns:
            list(dict(arg1:str[None|/api/v1/sessions/1/ixnetwork/?deepchild=*],arg2:list[str]))
        """
        return self._get_attribute('errors')

    @property
    def FlapTxIntervals(self):
        """This signifies the number of seconds between route flaps for BFD. A value of zero means no flapping

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('flapTxIntervals')

    @property
    def IncludePadTlv(self):
        """If true, includes Pad TLV in triggered ping

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('includePadTlv')

    @property
    def IncludeVendorEnterpriseNumbeTlv(self):
        """If true, include the TLV number of the vendor, in triggered ping

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('includeVendorEnterpriseNumbeTlv')

    @property
    def InitiatorSBFDSessionCount(self):
        """Number of configured S-BFD Initiator sessions with static MPLS labels per MPLS-OAM Interface. Labels should be configured as the actual label values (not SIDs) for SR-LSPs and should include list of labels learned by Ixia port and not the ones configured on the Tx Port itself.

        Returns:
            number
        """
        return self._get_attribute('initiatorSBFDSessionCount')
    @InitiatorSBFDSessionCount.setter
    def InitiatorSBFDSessionCount(self, value):
        self._set_attribute('initiatorSBFDSessionCount', value)

    @property
    def LocalRouterId(self):
        """The MPLOAM Router ID value, in IPv4 format.

        Returns:
            list(str)
        """
        return self._get_attribute('localRouterId')

    @property
    def MinRxInterval(self):
        """This signifies the minimum interval, in milliseconds, between received BFD Control packets that this interface is capable of supporting

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('minRxInterval')

    @property
    def Multiplier(self):
        """Number of layer instances per parent instance (multiplier)

        Returns:
            number
        """
        return self._get_attribute('multiplier')
    @Multiplier.setter
    def Multiplier(self, value):
        self._set_attribute('multiplier', value)

    @property
    def Name(self):
        """Name of NGPF element, guaranteed to be unique in Scenario

        Returns:
            str
        """
        return self._get_attribute('name')
    @Name.setter
    def Name(self, value):
        self._set_attribute('name', value)

    @property
    def PadTlvFirstOctet(self):
        """This signifies the selection of the first octet of the Pad TLV

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('padTlvFirstOctet')

    @property
    def PadTlvLength(self):
        """This signifies the specification of the length of the Pad TLV

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('padTlvLength')

    @property
    def ReplyMode(self):
        """This signifies the selection of the mode of reply

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('replyMode')

    @property
    def SessionStatus(self):
        """Current state of protocol session: Not Started - session negotiation not started, the session is not active yet. Down - actively trying to bring up a protocol session, but negotiation is didn't successfully complete (yet). Up - session came up successfully.

        Returns:
            list(str[down|notStarted|up])
        """
        return self._get_attribute('sessionStatus')

    @property
    def StackedLayers(self):
        """List of secondary (many to one) child layer protocols

        Returns:
            list(str[None|/api/v1/sessions/1/ixnetwork/topology?deepchild=*])
        """
        return self._get_attribute('stackedLayers')
    @StackedLayers.setter
    def StackedLayers(self, value):
        self._set_attribute('stackedLayers', value)

    @property
    def StateCounts(self):
        """A list of values that indicates the total number of sessions, the number of sessions not started, the number of sessions down and the number of sessions that are up

        Returns:
            dict(total:number,notStarted:number,down:number,up:number)
        """
        return self._get_attribute('stateCounts')

    @property
    def Status(self):
        """Running status of associated network element. Once in Started state, protocol sessions will begin to negotiate.

        Returns:
            str(configured|error|mixed|notStarted|started|starting|stopping)
        """
        return self._get_attribute('status')

    @property
    def TimeoutMultiplier(self):
        """This signifies the negotiated transmit interval, multiplied by this value, provides the detection time for the interface

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('timeoutMultiplier')

    @property
    def TxInterval(self):
        """This signifies the minimum interval, in milliseconds, that the interface would like to use when transmitting BFD Control packets

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('txInterval')

    @property
    def VendorEnterpriseNumber(self):
        """This signifies the specification of the enterprise number of the vendor

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('vendorEnterpriseNumber')

    def update(self, ConnectedVia=None, EnableSBfdResponder=None, InitiatorSBFDSessionCount=None, Multiplier=None, Name=None, StackedLayers=None):
        """Updates a child instance of mplsOam on the server.

        This method has some named parameters with a type: obj (Multivalue).
        The Multivalue class has documentation that details the possible values for those named parameters.

        Args:
            ConnectedVia (list(str[None|/api/v1/sessions/1/ixnetwork/topology?deepchild=*])): List of layers this layer used to connect to the wire
            EnableSBfdResponder (bool): Enables S-BFD Responder
            InitiatorSBFDSessionCount (number): Number of configured S-BFD Initiator sessions with static MPLS labels per MPLS-OAM Interface. Labels should be configured as the actual label values (not SIDs) for SR-LSPs and should include list of labels learned by Ixia port and not the ones configured on the Tx Port itself.
            Multiplier (number): Number of layer instances per parent instance (multiplier)
            Name (str): Name of NGPF element, guaranteed to be unique in Scenario
            StackedLayers (list(str[None|/api/v1/sessions/1/ixnetwork/topology?deepchild=*])): List of secondary (many to one) child layer protocols

        Raises:
            ServerError: The server has encountered an uncategorized error condition
        """
        self._update(locals())

    def add(self, ConnectedVia=None, EnableSBfdResponder=None, InitiatorSBFDSessionCount=None, Multiplier=None, Name=None, StackedLayers=None):
        """Adds a new mplsOam node on the server and retrieves it in this instance.

        Args:
            ConnectedVia (list(str[None|/api/v1/sessions/1/ixnetwork/topology?deepchild=*])): List of layers this layer used to connect to the wire
            EnableSBfdResponder (bool): Enables S-BFD Responder
            InitiatorSBFDSessionCount (number): Number of configured S-BFD Initiator sessions with static MPLS labels per MPLS-OAM Interface. Labels should be configured as the actual label values (not SIDs) for SR-LSPs and should include list of labels learned by Ixia port and not the ones configured on the Tx Port itself.
            Multiplier (number): Number of layer instances per parent instance (multiplier)
            Name (str): Name of NGPF element, guaranteed to be unique in Scenario
            StackedLayers (list(str[None|/api/v1/sessions/1/ixnetwork/topology?deepchild=*])): List of secondary (many to one) child layer protocols

        Returns:
            self: This instance with all currently retrieved mplsOam data using find and the newly added mplsOam data available through an iterator or index

        Raises:
            ServerError: The server has encountered an uncategorized error condition
        """
        return self._create(locals())

    def remove(self):
        """Deletes all the mplsOam data in this instance from server.

        Raises:
            NotFoundError: The requested resource does not exist on the server
            ServerError: The server has encountered an uncategorized error condition
        """
        self._delete()

    def find(self, ConnectedVia=None, Count=None, DescriptiveName=None, EnableSBfdResponder=None, Errors=None, InitiatorSBFDSessionCount=None, LocalRouterId=None, Multiplier=None, Name=None, SessionStatus=None, StackedLayers=None, StateCounts=None, Status=None):
        """Finds and retrieves mplsOam data from the server.

        All named parameters support regex and can be used to selectively retrieve mplsOam data from the server.
        By default the find method takes no parameters and will retrieve all mplsOam data from the server.

        Args:
            ConnectedVia (list(str[None|/api/v1/sessions/1/ixnetwork/topology?deepchild=*])): List of layers this layer used to connect to the wire
            Count (number): Number of elements inside associated multiplier-scaled container object, e.g. number of devices inside a Device Group.
            DescriptiveName (str): Longer, more descriptive name for element. It's not guaranteed to be unique like -name-, but may offers more context
            EnableSBfdResponder (bool): Enables S-BFD Responder
            Errors (list(dict(arg1:str[None|/api/v1/sessions/1/ixnetwork/?deepchild=*],arg2:list[str]))): A list of errors that have occurred
            InitiatorSBFDSessionCount (number): Number of configured S-BFD Initiator sessions with static MPLS labels per MPLS-OAM Interface. Labels should be configured as the actual label values (not SIDs) for SR-LSPs and should include list of labels learned by Ixia port and not the ones configured on the Tx Port itself.
            LocalRouterId (list(str)): The MPLOAM Router ID value, in IPv4 format.
            Multiplier (number): Number of layer instances per parent instance (multiplier)
            Name (str): Name of NGPF element, guaranteed to be unique in Scenario
            SessionStatus (list(str[down|notStarted|up])): Current state of protocol session: Not Started - session negotiation not started, the session is not active yet. Down - actively trying to bring up a protocol session, but negotiation is didn't successfully complete (yet). Up - session came up successfully.
            StackedLayers (list(str[None|/api/v1/sessions/1/ixnetwork/topology?deepchild=*])): List of secondary (many to one) child layer protocols
            StateCounts (dict(total:number,notStarted:number,down:number,up:number)): A list of values that indicates the total number of sessions, the number of sessions not started, the number of sessions down and the number of sessions that are up
            Status (str(configured|error|mixed|notStarted|started|starting|stopping)): Running status of associated network element. Once in Started state, protocol sessions will begin to negotiate.

        Returns:
            self: This instance with matching mplsOam data retrieved from the server available through an iterator or index

        Raises:
            ServerError: The server has encountered an uncategorized error condition
        """
        return self._select(locals())

    def read(self, href):
        """Retrieves a single instance of mplsOam data from the server.

        Args:
            href (str): An href to the instance to be retrieved

        Returns:
            self: This instance with the mplsOam data from the server available through an iterator or index

        Raises:
            NotFoundError: The requested resource does not exist on the server
            ServerError: The server has encountered an uncategorized error condition
        """
        return self._read(href)

    def get_device_ids(self, PortNames=None, Active=None, BfdCvType=None, BfdDiscriminatorEnd=None, BfdDiscriminatorStart=None, ControlChannel=None, DestinationAddressIpv4=None, DownstreamAddressType=None, DownstreamInterfaceAddressNumbered=None, DownstreamInterfaceAddressUnnumbered=None, DownstreamIpAddress=None, EchoRequestInterval=None, EchoResponseTimeout=None, EnableDSIflag=None, EnableDownstreamMappingTlv=None, EnableDsNflag=None, EnableFecValidation=None, EnablePeriodicPing=None, FlapTxIntervals=None, IncludePadTlv=None, IncludeVendorEnterpriseNumbeTlv=None, MinRxInterval=None, PadTlvFirstOctet=None, PadTlvLength=None, ReplyMode=None, TimeoutMultiplier=None, TxInterval=None, VendorEnterpriseNumber=None):
        """Base class infrastructure that gets a list of mplsOam device ids encapsulated by this object.

        Use the optional regex parameters in the method to refine the list of device ids encapsulated by this object.

        Args:
            PortNames (str): optional regex of port names
            Active (str): optional regex of active
            BfdCvType (str): optional regex of bfdCvType
            BfdDiscriminatorEnd (str): optional regex of bfdDiscriminatorEnd
            BfdDiscriminatorStart (str): optional regex of bfdDiscriminatorStart
            ControlChannel (str): optional regex of controlChannel
            DestinationAddressIpv4 (str): optional regex of destinationAddressIpv4
            DownstreamAddressType (str): optional regex of downstreamAddressType
            DownstreamInterfaceAddressNumbered (str): optional regex of downstreamInterfaceAddressNumbered
            DownstreamInterfaceAddressUnnumbered (str): optional regex of downstreamInterfaceAddressUnnumbered
            DownstreamIpAddress (str): optional regex of downstreamIpAddress
            EchoRequestInterval (str): optional regex of echoRequestInterval
            EchoResponseTimeout (str): optional regex of echoResponseTimeout
            EnableDSIflag (str): optional regex of enableDSIflag
            EnableDownstreamMappingTlv (str): optional regex of enableDownstreamMappingTlv
            EnableDsNflag (str): optional regex of enableDsNflag
            EnableFecValidation (str): optional regex of enableFecValidation
            EnablePeriodicPing (str): optional regex of enablePeriodicPing
            FlapTxIntervals (str): optional regex of flapTxIntervals
            IncludePadTlv (str): optional regex of includePadTlv
            IncludeVendorEnterpriseNumbeTlv (str): optional regex of includeVendorEnterpriseNumbeTlv
            MinRxInterval (str): optional regex of minRxInterval
            PadTlvFirstOctet (str): optional regex of padTlvFirstOctet
            PadTlvLength (str): optional regex of padTlvLength
            ReplyMode (str): optional regex of replyMode
            TimeoutMultiplier (str): optional regex of timeoutMultiplier
            TxInterval (str): optional regex of txInterval
            VendorEnterpriseNumber (str): optional regex of vendorEnterpriseNumber

        Returns:
            list(int): A list of device ids that meets the regex criteria provided in the method parameters

        Raises:
            ServerError: The server has encountered an uncategorized error condition
        """
        return self._get_ngpf_device_ids(locals())

    def ClearAllLearnedInfo(self, *args, **kwargs):
        """Executes the clearAllLearnedInfo operation on the server.

        Clears ALL Learned LSP Information By PCC Device.

        clearAllLearnedInfo(Arg2:list)list
            Args:
                args[0] is Arg2 (list(number)): List of indices into the protocol plugin.An empty list indicates all instances in the plugin.

            Returns:
                list(str): ID to associate each async action invocation

        Raises:
            NotFoundError: The requested resource does not exist on the server
            ServerError: The server has encountered an uncategorized error condition
        """
        payload = { "Arg1": self.href }
        for i in range(len(args)): payload['Arg%s' % (i + 2)] = args[i]
        for item in kwargs.items(): payload[item[0]] = item[1]
        return self._execute('clearAllLearnedInfo', payload=payload, response_object=None)

    def GetAllLearnedInfo(self, *args, **kwargs):
        """Executes the getAllLearnedInfo operation on the server.

        MPLSOAM learned Info

        getAllLearnedInfo(Arg2:list)list
            Args:
                args[0] is Arg2 (list(number)): List of indices into the protocol plugin.An empty list indicates all instances in the plugin.

            Returns:
                list(str): ID to associate each async action invocation

        Raises:
            NotFoundError: The requested resource does not exist on the server
            ServerError: The server has encountered an uncategorized error condition
        """
        payload = { "Arg1": self.href }
        for i in range(len(args)): payload['Arg%s' % (i + 2)] = args[i]
        for item in kwargs.items(): payload[item[0]] = item[1]
        return self._execute('getAllLearnedInfo', payload=payload, response_object=None)

    def RestartDown(self, *args, **kwargs):
        """Executes the restartDown operation on the server.

        Stop and start interfaces and sessions that are in Down state.

        The IxNetwork modeling infrastructure allows for multiple method Signatures with the same name while python does not.
        The following correlates the modeling Signatures to the python *args variable length list:

        restartDown()

        restartDown(SessionIndices:list)
            Args:
                args[0] is SessionIndices (list(number)): This parameter requires an array of session numbers 0 1 2 3

        restartDown(SessionIndices:string)
            Args:
                args[0] is SessionIndices (str): This parameter requires a string of session numbers 1-4;6;7-12

        Raises:
            NotFoundError: The requested resource does not exist on the server
            ServerError: The server has encountered an uncategorized error condition
        """
        payload = { "Arg1": self }
        for i in range(len(args)): payload['Arg%s' % (i + 2)] = args[i]
        for item in kwargs.items(): payload[item[0]] = item[1]
        return self._execute('restartDown', payload=payload, response_object=None)

    def Start(self, *args, **kwargs):
        """Executes the start operation on the server.

        Activate Interface

        The IxNetwork modeling infrastructure allows for multiple method Signatures with the same name while python does not.
        The following correlates the modeling Signatures to the python *args variable length list:

        start()

        start(SessionIndices:list)
            Args:
                args[0] is SessionIndices (list(number)): This parameter requires an array of session numbers 0 1 2 3

        start(SessionIndices:string)
            Args:
                args[0] is SessionIndices (str): This parameter requires a string of session numbers 1-4;6;7-12

        Raises:
            NotFoundError: The requested resource does not exist on the server
            ServerError: The server has encountered an uncategorized error condition
        """
        payload = { "Arg1": self }
        for i in range(len(args)): payload['Arg%s' % (i + 2)] = args[i]
        for item in kwargs.items(): payload[item[0]] = item[1]
        return self._execute('start', payload=payload, response_object=None)

    def Stop(self, *args, **kwargs):
        """Executes the stop operation on the server.

        Deactivate Interface

        The IxNetwork modeling infrastructure allows for multiple method Signatures with the same name while python does not.
        The following correlates the modeling Signatures to the python *args variable length list:

        stop()

        stop(SessionIndices:list)
            Args:
                args[0] is SessionIndices (list(number)): This parameter requires an array of session numbers 0 1 2 3

        stop(SessionIndices:string)
            Args:
                args[0] is SessionIndices (str): This parameter requires a string of session numbers 1-4;6;7-12

        Raises:
            NotFoundError: The requested resource does not exist on the server
            ServerError: The server has encountered an uncategorized error condition
        """
        payload = { "Arg1": self }
        for i in range(len(args)): payload['Arg%s' % (i + 2)] = args[i]
        for item in kwargs.items(): payload[item[0]] = item[1]
        return self._execute('stop', payload=payload, response_object=None)
