# MIT LICENSE
#
# Copyright 1997 - 2019 by IXIA Keysight
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"),
# to deal in the Software without restriction, including without limitation
# the rights to use, copy, modify, merge, publish, distribute, sublicense,
# and/or sell copies of the Software, and to permit persons to whom the
# Software is furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE. 
from ixnetwork_restpy.base import Base
from ixnetwork_restpy.files import Files


class EvpnIPv6PrefixRange(Base):
    """BGP EVPN IPv6 Prefix Range
    The EvpnIPv6PrefixRange class encapsulates a list of evpnIPv6PrefixRange resources that is be managed by the user.
    A list of resources can be retrieved from the server using the EvpnIPv6PrefixRange.find() method.
    The list can be managed by the user by using the EvpnIPv6PrefixRange.add() and EvpnIPv6PrefixRange.remove() methods.
    """

    __slots__ = ()
    _SDM_NAME = 'evpnIPv6PrefixRange'

    def __init__(self, parent):
        super(EvpnIPv6PrefixRange, self).__init__(parent)

    @property
    def BgpAsPathSegmentList(self):
        """An instance of the BgpAsPathSegmentList class.

        Returns:
            obj(ixnetwork_restpy.testplatform.sessions.ixnetwork.topology.bgpaspathsegmentlist.BgpAsPathSegmentList)

        Raises:
            NotFoundError: The requested resource does not exist on the server
            ServerError: The server has encountered an uncategorized error condition
        """
        from ixnetwork_restpy.testplatform.sessions.ixnetwork.topology.bgpaspathsegmentlist import BgpAsPathSegmentList
        return BgpAsPathSegmentList(self)

    @property
    def BgpClusterIdList(self):
        """An instance of the BgpClusterIdList class.

        Returns:
            obj(ixnetwork_restpy.testplatform.sessions.ixnetwork.topology.bgpclusteridlist.BgpClusterIdList)

        Raises:
            NotFoundError: The requested resource does not exist on the server
            ServerError: The server has encountered an uncategorized error condition
        """
        from ixnetwork_restpy.testplatform.sessions.ixnetwork.topology.bgpclusteridlist import BgpClusterIdList
        return BgpClusterIdList(self)

    @property
    def BgpCommunitiesList(self):
        """An instance of the BgpCommunitiesList class.

        Returns:
            obj(ixnetwork_restpy.testplatform.sessions.ixnetwork.topology.bgpcommunitieslist.BgpCommunitiesList)

        Raises:
            NotFoundError: The requested resource does not exist on the server
            ServerError: The server has encountered an uncategorized error condition
        """
        from ixnetwork_restpy.testplatform.sessions.ixnetwork.topology.bgpcommunitieslist import BgpCommunitiesList
        return BgpCommunitiesList(self)

    @property
    def BgpExtendedCommunitiesList(self):
        """An instance of the BgpExtendedCommunitiesList class.

        Returns:
            obj(ixnetwork_restpy.testplatform.sessions.ixnetwork.topology.bgpextendedcommunitieslist.BgpExtendedCommunitiesList)

        Raises:
            NotFoundError: The requested resource does not exist on the server
            ServerError: The server has encountered an uncategorized error condition
        """
        from ixnetwork_restpy.testplatform.sessions.ixnetwork.topology.bgpextendedcommunitieslist import BgpExtendedCommunitiesList
        return BgpExtendedCommunitiesList(self)

    @property
    def CMacProperties(self):
        """An instance of the CMacProperties class.

        Returns:
            obj(ixnetwork_restpy.testplatform.sessions.ixnetwork.topology.cmacproperties.CMacProperties)

        Raises:
            NotFoundError: The requested resource does not exist on the server
            ServerError: The server has encountered an uncategorized error condition
        """
        from ixnetwork_restpy.testplatform.sessions.ixnetwork.topology.cmacproperties import CMacProperties
        return CMacProperties(self)

    @property
    def EvpnIPv4PrefixRange(self):
        """An instance of the EvpnIPv4PrefixRange class.

        Returns:
            obj(ixnetwork_restpy.testplatform.sessions.ixnetwork.topology.evpnipv4prefixrange.EvpnIPv4PrefixRange)

        Raises:
            NotFoundError: The requested resource does not exist on the server
            ServerError: The server has encountered an uncategorized error condition
        """
        from ixnetwork_restpy.testplatform.sessions.ixnetwork.topology.evpnipv4prefixrange import EvpnIPv4PrefixRange
        return EvpnIPv4PrefixRange(self)

    @property
    def EvpnIPv6PrefixRange(self):
        """An instance of the EvpnIPv6PrefixRange class.

        Returns:
            obj(ixnetwork_restpy.testplatform.sessions.ixnetwork.topology.evpnipv6prefixrange.EvpnIPv6PrefixRange)

        Raises:
            NotFoundError: The requested resource does not exist on the server
            ServerError: The server has encountered an uncategorized error condition
        """
        from ixnetwork_restpy.testplatform.sessions.ixnetwork.topology.evpnipv6prefixrange import EvpnIPv6PrefixRange
        return EvpnIPv6PrefixRange(self)

    @property
    def Active(self):
        """Activate/Deactivate Configuration

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('active')

    @property
    def AdvSrv6SidInIgp(self):
        """Advertise SRv6 SID in IGP

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('advSrv6SidInIgp')

    @property
    def AdvertiseSRv6SID(self):
        """Advertise SRv6 SID

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('advertiseSRv6SID')

    @property
    def AggregatorAs(self):
        """Aggregator AS

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('aggregatorAs')

    @property
    def AggregatorId(self):
        """Aggregator ID

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('aggregatorId')

    @property
    def AsSetMode(self):
        """AS# Set Mode

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('asSetMode')

    @property
    def Count(self):
        """Number of elements inside associated multiplier-scaled container object, e.g. number of devices inside a Device Group.

        Returns:
            number
        """
        return self._get_attribute('count')

    @property
    def DescriptiveName(self):
        """Longer, more descriptive name for element. It's not guaranteed to be unique like -name-, but may offers more context

        Returns:
            str
        """
        return self._get_attribute('descriptiveName')

    @property
    def EnableAggregatorId(self):
        """Enable Aggregator ID

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('enableAggregatorId')

    @property
    def EnableAsPathSegments(self):
        """Enable AS Path Segments

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('enableAsPathSegments')

    @property
    def EnableAtomicAggregate(self):
        """Enable Atomic Aggregate

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('enableAtomicAggregate')

    @property
    def EnableCluster(self):
        """Enable Cluster

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('enableCluster')

    @property
    def EnableCommunity(self):
        """Enable Community

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('enableCommunity')

    @property
    def EnableExtendedCommunity(self):
        """Enable Extended Community

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('enableExtendedCommunity')

    @property
    def EnableLocalPreference(self):
        """Enable Local Preference

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('enableLocalPreference')

    @property
    def EnableMultiExitDiscriminator(self):
        """Enable Multi Exit

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('enableMultiExitDiscriminator')

    @property
    def EnableNextHop(self):
        """Enable Next Hop

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('enableNextHop')

    @property
    def EnableOrigin(self):
        """Enable Origin

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('enableOrigin')

    @property
    def EnableOriginatorId(self):
        """Enable Originator ID

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('enableOriginatorId')

    @property
    def Ipv4NextHop(self):
        """IPv4 Next Hop

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('ipv4NextHop')

    @property
    def Ipv6Address(self):
        """IPv6 Address

        Returns:
            list(str)
        """
        return self._get_attribute('ipv6Address')

    @property
    def Ipv6NextHop(self):
        """IPv6 Next Hop

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('ipv6NextHop')

    @property
    def LabelMode(self):
        """Label Mode

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('labelMode')

    @property
    def LabelStart(self):
        """Label Start

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('labelStart')

    @property
    def LabelStep(self):
        """Label Step

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('labelStep')

    @property
    def LocalPreference(self):
        """Local Preference

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('localPreference')

    @property
    def MultiExitDiscriminator(self):
        """Multi Exit

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('multiExitDiscriminator')

    @property
    def Name(self):
        """Name of NGPF element, guaranteed to be unique in Scenario

        Returns:
            str
        """
        return self._get_attribute('name')
    @Name.setter
    def Name(self, value):
        self._set_attribute('name', value)

    @property
    def NoOfASPathSegmentsPerRouteRange(self):
        """Number Of AS Path Segments Per Route Range

        Returns:
            number
        """
        return self._get_attribute('noOfASPathSegmentsPerRouteRange')
    @NoOfASPathSegmentsPerRouteRange.setter
    def NoOfASPathSegmentsPerRouteRange(self, value):
        self._set_attribute('noOfASPathSegmentsPerRouteRange', value)

    @property
    def NoOfClusters(self):
        """Number of Clusters

        Returns:
            number
        """
        return self._get_attribute('noOfClusters')
    @NoOfClusters.setter
    def NoOfClusters(self, value):
        self._set_attribute('noOfClusters', value)

    @property
    def NoOfCommunities(self):
        """Number of Communities

        Returns:
            number
        """
        return self._get_attribute('noOfCommunities')
    @NoOfCommunities.setter
    def NoOfCommunities(self, value):
        self._set_attribute('noOfCommunities', value)

    @property
    def NoOfExtendedCommunity(self):
        """Number of Extended Communities

        Returns:
            number
        """
        return self._get_attribute('noOfExtendedCommunity')
    @NoOfExtendedCommunity.setter
    def NoOfExtendedCommunity(self, value):
        self._set_attribute('noOfExtendedCommunity', value)

    @property
    def Origin(self):
        """Origin

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('origin')

    @property
    def OriginatorId(self):
        """Originator ID

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('originatorId')

    @property
    def OverridePeerAsSetMode(self):
        """Override Peer AS# Set Mode

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('overridePeerAsSetMode')

    @property
    def SetNextHop(self):
        """Set Next Hop

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('setNextHop')

    @property
    def SetNextHopIpType(self):
        """Set Next Hop IP Type

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('setNextHopIpType')

    @property
    def Srv6SidFlags(self):
        """SRv6 SID Flags Value

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('srv6SidFlags')

    @property
    def Srv6SidLoc(self):
        """SRv6 SID. It consists of Locator, Func and Args

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('srv6SidLoc')

    @property
    def Srv6SidLocLen(self):
        """SRv6 SID Locator Length

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('srv6SidLocLen')

    @property
    def Srv6SidLocMetric(self):
        """SRv6 SID Locator Metric

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('srv6SidLocMetric')

    @property
    def Srv6SidReserved(self):
        """SRv6 SID Reserved Value

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('srv6SidReserved')

    @property
    def Srv6SidStep(self):
        """Route Range SRv6 SID Step

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('srv6SidStep')

    def update(self, Name=None, NoOfASPathSegmentsPerRouteRange=None, NoOfClusters=None, NoOfCommunities=None, NoOfExtendedCommunity=None):
        """Updates a child instance of evpnIPv6PrefixRange on the server.

        This method has some named parameters with a type: obj (Multivalue).
        The Multivalue class has documentation that details the possible values for those named parameters.

        Args:
            Name (str): Name of NGPF element, guaranteed to be unique in Scenario
            NoOfASPathSegmentsPerRouteRange (number): Number Of AS Path Segments Per Route Range
            NoOfClusters (number): Number of Clusters
            NoOfCommunities (number): Number of Communities
            NoOfExtendedCommunity (number): Number of Extended Communities

        Raises:
            ServerError: The server has encountered an uncategorized error condition
        """
        self._update(locals())

    def add(self, Name=None, NoOfASPathSegmentsPerRouteRange=None, NoOfClusters=None, NoOfCommunities=None, NoOfExtendedCommunity=None):
        """Adds a new evpnIPv6PrefixRange node on the server and retrieves it in this instance.

        Args:
            Name (str): Name of NGPF element, guaranteed to be unique in Scenario
            NoOfASPathSegmentsPerRouteRange (number): Number Of AS Path Segments Per Route Range
            NoOfClusters (number): Number of Clusters
            NoOfCommunities (number): Number of Communities
            NoOfExtendedCommunity (number): Number of Extended Communities

        Returns:
            self: This instance with all currently retrieved evpnIPv6PrefixRange data using find and the newly added evpnIPv6PrefixRange data available through an iterator or index

        Raises:
            ServerError: The server has encountered an uncategorized error condition
        """
        return self._create(locals())

    def remove(self):
        """Deletes all the evpnIPv6PrefixRange data in this instance from server.

        Raises:
            NotFoundError: The requested resource does not exist on the server
            ServerError: The server has encountered an uncategorized error condition
        """
        self._delete()

    def find(self, Count=None, DescriptiveName=None, Ipv6Address=None, Name=None, NoOfASPathSegmentsPerRouteRange=None, NoOfClusters=None, NoOfCommunities=None, NoOfExtendedCommunity=None):
        """Finds and retrieves evpnIPv6PrefixRange data from the server.

        All named parameters support regex and can be used to selectively retrieve evpnIPv6PrefixRange data from the server.
        By default the find method takes no parameters and will retrieve all evpnIPv6PrefixRange data from the server.

        Args:
            Count (number): Number of elements inside associated multiplier-scaled container object, e.g. number of devices inside a Device Group.
            DescriptiveName (str): Longer, more descriptive name for element. It's not guaranteed to be unique like -name-, but may offers more context
            Ipv6Address (list(str)): IPv6 Address
            Name (str): Name of NGPF element, guaranteed to be unique in Scenario
            NoOfASPathSegmentsPerRouteRange (number): Number Of AS Path Segments Per Route Range
            NoOfClusters (number): Number of Clusters
            NoOfCommunities (number): Number of Communities
            NoOfExtendedCommunity (number): Number of Extended Communities

        Returns:
            self: This instance with matching evpnIPv6PrefixRange data retrieved from the server available through an iterator or index

        Raises:
            ServerError: The server has encountered an uncategorized error condition
        """
        return self._select(locals())

    def read(self, href):
        """Retrieves a single instance of evpnIPv6PrefixRange data from the server.

        Args:
            href (str): An href to the instance to be retrieved

        Returns:
            self: This instance with the evpnIPv6PrefixRange data from the server available through an iterator or index

        Raises:
            NotFoundError: The requested resource does not exist on the server
            ServerError: The server has encountered an uncategorized error condition
        """
        return self._read(href)

    def get_device_ids(self, PortNames=None, Active=None, AdvSrv6SidInIgp=None, AdvertiseSRv6SID=None, AggregatorAs=None, AggregatorId=None, AsSetMode=None, EnableAggregatorId=None, EnableAsPathSegments=None, EnableAtomicAggregate=None, EnableCluster=None, EnableCommunity=None, EnableExtendedCommunity=None, EnableLocalPreference=None, EnableMultiExitDiscriminator=None, EnableNextHop=None, EnableOrigin=None, EnableOriginatorId=None, Ipv4NextHop=None, Ipv6NextHop=None, LabelMode=None, LabelStart=None, LabelStep=None, LocalPreference=None, MultiExitDiscriminator=None, Origin=None, OriginatorId=None, OverridePeerAsSetMode=None, SetNextHop=None, SetNextHopIpType=None, Srv6SidFlags=None, Srv6SidLoc=None, Srv6SidLocLen=None, Srv6SidLocMetric=None, Srv6SidReserved=None, Srv6SidStep=None):
        """Base class infrastructure that gets a list of evpnIPv6PrefixRange device ids encapsulated by this object.

        Use the optional regex parameters in the method to refine the list of device ids encapsulated by this object.

        Args:
            PortNames (str): optional regex of port names
            Active (str): optional regex of active
            AdvSrv6SidInIgp (str): optional regex of advSrv6SidInIgp
            AdvertiseSRv6SID (str): optional regex of advertiseSRv6SID
            AggregatorAs (str): optional regex of aggregatorAs
            AggregatorId (str): optional regex of aggregatorId
            AsSetMode (str): optional regex of asSetMode
            EnableAggregatorId (str): optional regex of enableAggregatorId
            EnableAsPathSegments (str): optional regex of enableAsPathSegments
            EnableAtomicAggregate (str): optional regex of enableAtomicAggregate
            EnableCluster (str): optional regex of enableCluster
            EnableCommunity (str): optional regex of enableCommunity
            EnableExtendedCommunity (str): optional regex of enableExtendedCommunity
            EnableLocalPreference (str): optional regex of enableLocalPreference
            EnableMultiExitDiscriminator (str): optional regex of enableMultiExitDiscriminator
            EnableNextHop (str): optional regex of enableNextHop
            EnableOrigin (str): optional regex of enableOrigin
            EnableOriginatorId (str): optional regex of enableOriginatorId
            Ipv4NextHop (str): optional regex of ipv4NextHop
            Ipv6NextHop (str): optional regex of ipv6NextHop
            LabelMode (str): optional regex of labelMode
            LabelStart (str): optional regex of labelStart
            LabelStep (str): optional regex of labelStep
            LocalPreference (str): optional regex of localPreference
            MultiExitDiscriminator (str): optional regex of multiExitDiscriminator
            Origin (str): optional regex of origin
            OriginatorId (str): optional regex of originatorId
            OverridePeerAsSetMode (str): optional regex of overridePeerAsSetMode
            SetNextHop (str): optional regex of setNextHop
            SetNextHopIpType (str): optional regex of setNextHopIpType
            Srv6SidFlags (str): optional regex of srv6SidFlags
            Srv6SidLoc (str): optional regex of srv6SidLoc
            Srv6SidLocLen (str): optional regex of srv6SidLocLen
            Srv6SidLocMetric (str): optional regex of srv6SidLocMetric
            Srv6SidReserved (str): optional regex of srv6SidReserved
            Srv6SidStep (str): optional regex of srv6SidStep

        Returns:
            list(int): A list of device ids that meets the regex criteria provided in the method parameters

        Raises:
            ServerError: The server has encountered an uncategorized error condition
        """
        return self._get_ngpf_device_ids(locals())

    def Start(self, *args, **kwargs):
        """Executes the start operation on the server.

        Start selected protocols.

        The IxNetwork modeling infrastructure allows for multiple method Signatures with the same name while python does not.
        The following correlates the modeling Signatures to the python *args variable length list:

        start()

        start(SessionIndices:list)
            Args:
                args[0] is SessionIndices (list(number)): This parameter requires an array of session numbers 0 1 2 3

        start(SessionIndices:string)
            Args:
                args[0] is SessionIndices (str): This parameter requires a string of session numbers 1-4;6;7-12

        Raises:
            NotFoundError: The requested resource does not exist on the server
            ServerError: The server has encountered an uncategorized error condition
        """
        payload = { "Arg1": self }
        for i in range(len(args)): payload['Arg%s' % (i + 2)] = args[i]
        for item in kwargs.items(): payload[item[0]] = item[1]
        return self._execute('start', payload=payload, response_object=None)

    def Stop(self, *args, **kwargs):
        """Executes the stop operation on the server.

        Stop selected protocols.

        The IxNetwork modeling infrastructure allows for multiple method Signatures with the same name while python does not.
        The following correlates the modeling Signatures to the python *args variable length list:

        stop()

        stop(SessionIndices:list)
            Args:
                args[0] is SessionIndices (list(number)): This parameter requires an array of session numbers 0 1 2 3

        stop(SessionIndices:string)
            Args:
                args[0] is SessionIndices (str): This parameter requires a string of session numbers 1-4;6;7-12

        Raises:
            NotFoundError: The requested resource does not exist on the server
            ServerError: The server has encountered an uncategorized error condition
        """
        payload = { "Arg1": self }
        for i in range(len(args)): payload['Arg%s' % (i + 2)] = args[i]
        for item in kwargs.items(): payload[item[0]] = item[1]
        return self._execute('stop', payload=payload, response_object=None)
