# MIT LICENSE
#
# Copyright 1997 - 2019 by IXIA Keysight
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"),
# to deal in the Software without restriction, including without limitation
# the rights to use, copy, modify, merge, publish, distribute, sublicense,
# and/or sell copies of the Software, and to permit persons to whom the
# Software is furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE. 
from ixnetwork_restpy.base import Base
from ixnetwork_restpy.files import Files


class Field(Base):
    """Tlv field
    The Field class encapsulates a list of field resources that is be managed by the user.
    A list of resources can be retrieved from the server using the Field.find() method.
    The list can be managed by the user by using the Field.add() and Field.remove() methods.
    """

    __slots__ = ()
    _SDM_NAME = 'field'

    def __init__(self, parent):
        super(Field, self).__init__(parent)

    @property
    def Restriction(self):
        """An instance of the Restriction class.

        Returns:
            obj(ixnetwork_restpy.testplatform.sessions.ixnetwork.globals.topology.tlveditor.restriction.Restriction)

        Raises:
            NotFoundError: The requested resource does not exist on the server
            ServerError: The server has encountered an uncategorized error condition
        """
        from ixnetwork_restpy.testplatform.sessions.ixnetwork.globals.topology.tlveditor.restriction import Restriction
        return Restriction(self)

    @property
    def Description(self):
        """Description of the tlv

        Returns:
            str
        """
        return self._get_attribute('description')
    @Description.setter
    def Description(self, value):
        self._set_attribute('description', value)

    @property
    def Encoding(self):
        """Encoding of the tlv value, any change will result in the value being reset

        Returns:
            str(bool|decimal|fcid|float|hex|ipv4|ipv6|mac|string|varLenHex)
        """
        return self._get_attribute('encoding')
    @Encoding.setter
    def Encoding(self, value):
        self._set_attribute('encoding', value)

    @property
    def IsEditable(self):
        """Indicates whether this is editable or not

        Returns:
            bool
        """
        return self._get_attribute('isEditable')
    @IsEditable.setter
    def IsEditable(self, value):
        self._set_attribute('isEditable', value)

    @property
    def IsRepeatable(self):
        """Flag indicating whether this is repeatable or not

        Returns:
            bool
        """
        return self._get_attribute('isRepeatable')
    @IsRepeatable.setter
    def IsRepeatable(self, value):
        self._set_attribute('isRepeatable', value)

    @property
    def IsRequired(self):
        """Flag indicating whether this is required or not

        Returns:
            bool
        """
        return self._get_attribute('isRequired')
    @IsRequired.setter
    def IsRequired(self, value):
        self._set_attribute('isRequired', value)

    @property
    def Name(self):
        """Name of the tlv

        Returns:
            str
        """
        return self._get_attribute('name')
    @Name.setter
    def Name(self, value):
        self._set_attribute('name', value)

    @property
    def Size(self):
        """Size of the tlv value in bits/bytes based on sizeType, any change will result in the value being reset

        Returns:
            number
        """
        return self._get_attribute('size')
    @Size.setter
    def Size(self, value):
        self._set_attribute('size', value)

    @property
    def SizeType(self):
        """Size type of the tlv value, any change will result in the value being reset

        Returns:
            str(bit|byte)
        """
        return self._get_attribute('sizeType')
    @SizeType.setter
    def SizeType(self, value):
        self._set_attribute('sizeType', value)

    @property
    def Value(self):
        """Value represented as a multivalue object

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('value')

    def update(self, Description=None, Encoding=None, IsEditable=None, IsRepeatable=None, IsRequired=None, Name=None, Size=None, SizeType=None):
        """Updates a child instance of field on the server.

        This method has some named parameters with a type: obj (Multivalue).
        The Multivalue class has documentation that details the possible values for those named parameters.

        Args:
            Description (str): Description of the tlv
            Encoding (str(bool|decimal|fcid|float|hex|ipv4|ipv6|mac|string|varLenHex)): Encoding of the tlv value, any change will result in the value being reset
            IsEditable (bool): Indicates whether this is editable or not
            IsRepeatable (bool): Flag indicating whether this is repeatable or not
            IsRequired (bool): Flag indicating whether this is required or not
            Name (str): Name of the tlv
            Size (number): Size of the tlv value in bits/bytes based on sizeType, any change will result in the value being reset
            SizeType (str(bit|byte)): Size type of the tlv value, any change will result in the value being reset

        Raises:
            ServerError: The server has encountered an uncategorized error condition
        """
        self._update(locals())

    def add(self, Description=None, Encoding=None, IsEditable=None, IsRepeatable=None, IsRequired=None, Name=None, Size=None, SizeType=None):
        """Adds a new field node on the server and retrieves it in this instance.

        Args:
            Description (str): Description of the tlv
            Encoding (str(bool|decimal|fcid|float|hex|ipv4|ipv6|mac|string|varLenHex)): Encoding of the tlv value, any change will result in the value being reset
            IsEditable (bool): Indicates whether this is editable or not
            IsRepeatable (bool): Flag indicating whether this is repeatable or not
            IsRequired (bool): Flag indicating whether this is required or not
            Name (str): Name of the tlv
            Size (number): Size of the tlv value in bits/bytes based on sizeType, any change will result in the value being reset
            SizeType (str(bit|byte)): Size type of the tlv value, any change will result in the value being reset

        Returns:
            self: This instance with all currently retrieved field data using find and the newly added field data available through an iterator or index

        Raises:
            ServerError: The server has encountered an uncategorized error condition
        """
        return self._create(locals())

    def remove(self):
        """Deletes all the field data in this instance from server.

        Raises:
            NotFoundError: The requested resource does not exist on the server
            ServerError: The server has encountered an uncategorized error condition
        """
        self._delete()

    def find(self, Description=None, Encoding=None, IsEditable=None, IsRepeatable=None, IsRequired=None, Name=None, Size=None, SizeType=None):
        """Finds and retrieves field data from the server.

        All named parameters support regex and can be used to selectively retrieve field data from the server.
        By default the find method takes no parameters and will retrieve all field data from the server.

        Args:
            Description (str): Description of the tlv
            Encoding (str(bool|decimal|fcid|float|hex|ipv4|ipv6|mac|string|varLenHex)): Encoding of the tlv value, any change will result in the value being reset
            IsEditable (bool): Indicates whether this is editable or not
            IsRepeatable (bool): Flag indicating whether this is repeatable or not
            IsRequired (bool): Flag indicating whether this is required or not
            Name (str): Name of the tlv
            Size (number): Size of the tlv value in bits/bytes based on sizeType, any change will result in the value being reset
            SizeType (str(bit|byte)): Size type of the tlv value, any change will result in the value being reset

        Returns:
            self: This instance with matching field data retrieved from the server available through an iterator or index

        Raises:
            ServerError: The server has encountered an uncategorized error condition
        """
        return self._select(locals())

    def read(self, href):
        """Retrieves a single instance of field data from the server.

        Args:
            href (str): An href to the instance to be retrieved

        Returns:
            self: This instance with the field data from the server available through an iterator or index

        Raises:
            NotFoundError: The requested resource does not exist on the server
            ServerError: The server has encountered an uncategorized error condition
        """
        return self._read(href)

    def get_device_ids(self, PortNames=None, Value=None):
        """Base class infrastructure that gets a list of field device ids encapsulated by this object.

        Use the optional regex parameters in the method to refine the list of device ids encapsulated by this object.

        Args:
            PortNames (str): optional regex of port names
            Value (str): optional regex of value

        Returns:
            list(int): A list of device ids that meets the regex criteria provided in the method parameters

        Raises:
            ServerError: The server has encountered an uncategorized error condition
        """
        return self._get_ngpf_device_ids(locals())
