# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.delete_user_response import DeleteUserResponse
from ..types.get_all_users_response import GetAllUsersResponse
from ..types.get_user_auth_response import GetUserAuthResponse
from ..types.get_user_integrations_response import GetUserIntegrationsResponse
from ..types.get_user_response import GetUserResponse
from ..types.mcp_server_name import McpServerName
from ..types.status_response import StatusResponse
from .raw_client import AsyncRawUserClient, RawUserClient
from .types.set_user_auth_request_auth_data import SetUserAuthRequestAuthData

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class UserClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawUserClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawUserClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawUserClient
        """
        return self._raw_client

    def get_user_integrations(
        self, user_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> GetUserIntegrationsResponse:
        """
        Get all available integrations (MCP server names) by user ID.
        Returns a list of integration names as McpServerName types.

        Parameters
        ----------
        user_id : str
            The external user ID

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetUserIntegrationsResponse
            Successful Response

        Examples
        --------
        from klavis import Klavis

        client = Klavis(
            api_key="YOUR_API_KEY",
        )
        client.user.get_user_integrations(
            user_id="userId",
        )
        """
        _response = self._raw_client.get_user_integrations(user_id, request_options=request_options)
        return _response.data

    def get_user_by_user_id(
        self, user_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> GetUserResponse:
        """
        Get user information by user_id.

        Parameters
        ----------
        user_id : str
            The identifier for the user to fetch.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetUserResponse
            Successful Response

        Examples
        --------
        from klavis import Klavis

        client = Klavis(
            api_key="YOUR_API_KEY",
        )
        client.user.get_user_by_user_id(
            user_id="userId",
        )
        """
        _response = self._raw_client.get_user_by_user_id(user_id, request_options=request_options)
        return _response.data

    def delete_user_by_user_id(
        self, user_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> DeleteUserResponse:
        """
        Delete a user and all associated data by user_id.
        Users cannot delete their own accounts.
        This operation will permanently remove all user data.

        Parameters
        ----------
        user_id : str
            The identifier for the user to delete.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DeleteUserResponse
            Successful Response

        Examples
        --------
        from klavis import Klavis

        client = Klavis(
            api_key="YOUR_API_KEY",
        )
        client.user.delete_user_by_user_id(
            user_id="userId",
        )
        """
        _response = self._raw_client.delete_user_by_user_id(user_id, request_options=request_options)
        return _response.data

    def get_all_users(
        self,
        *,
        page_size: typing.Optional[int] = None,
        page_number: typing.Optional[int] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GetAllUsersResponse:
        """
        Retrieve all users that have been created under your account, with support for pagination.

        Parameters
        ----------
        page_size : typing.Optional[int]
            Number of results per page (max 1000)

        page_number : typing.Optional[int]
            Page number to retrieve (starting from 1)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetAllUsersResponse
            Successful Response

        Examples
        --------
        from klavis import Klavis

        client = Klavis(
            api_key="YOUR_API_KEY",
        )
        client.user.get_all_users(
            page_size=1,
            page_number=1,
        )
        """
        _response = self._raw_client.get_all_users(
            page_size=page_size, page_number=page_number, request_options=request_options
        )
        return _response.data

    def set_user_auth(
        self,
        *,
        user_id: str,
        server_name: McpServerName,
        auth_data: SetUserAuthRequestAuthData,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> StatusResponse:
        """
        Sets authentication data for a specific integration for a user.

        Accepts either API key authentication or general authentication data.
        This updates the auth_metadata for the specified user's integration instance.

        Parameters
        ----------
        user_id : str
            The unique identifier for the user

        server_name : McpServerName
            The name of the MCP server to set authentication for (e.g., 'GitHub', 'Jira')

        auth_data : SetUserAuthRequestAuthData
            Authentication data

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        StatusResponse
            Successful Response

        Examples
        --------
        from klavis import ApiKeyAuth, Klavis, McpServerName

        client = Klavis(
            api_key="YOUR_API_KEY",
        )
        client.user.set_user_auth(
            user_id="userId",
            server_name=McpServerName.AFFINITY,
            auth_data=ApiKeyAuth(),
        )
        """
        _response = self._raw_client.set_user_auth(
            user_id=user_id, server_name=server_name, auth_data=auth_data, request_options=request_options
        )
        return _response.data

    def get_user_auth(
        self, user_id: str, server_name: McpServerName, *, request_options: typing.Optional[RequestOptions] = None
    ) -> GetUserAuthResponse:
        """
        Retrieves authentication data for a specific integration for a user.

        Returns the authentication data if available, along with authentication status.
        Includes token refresh handling if needed.

        Parameters
        ----------
        user_id : str
            The identifier for the user

        server_name : McpServerName
            The name of the MCP server (e.g., 'GitHub', 'Jira')

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetUserAuthResponse
            Successful Response

        Examples
        --------
        from klavis import Klavis, McpServerName

        client = Klavis(
            api_key="YOUR_API_KEY",
        )
        client.user.get_user_auth(
            user_id="userId",
            server_name=McpServerName.AFFINITY,
        )
        """
        _response = self._raw_client.get_user_auth(user_id, server_name, request_options=request_options)
        return _response.data

    def delete_user_auth(
        self, user_id: str, server_name: McpServerName, *, request_options: typing.Optional[RequestOptions] = None
    ) -> StatusResponse:
        """
        Deletes authentication data for a specific integration for a user.

        This will clear the stored authentication credentials, effectively unauthenticating the integration.

        Parameters
        ----------
        user_id : str
            The unique identifier for the user

        server_name : McpServerName
            The name of the MCP server to delete authentication for (e.g., 'github', 'jira')

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        StatusResponse
            Successful Response

        Examples
        --------
        from klavis import Klavis, McpServerName

        client = Klavis(
            api_key="YOUR_API_KEY",
        )
        client.user.delete_user_auth(
            user_id="userId",
            server_name=McpServerName.AFFINITY,
        )
        """
        _response = self._raw_client.delete_user_auth(user_id, server_name, request_options=request_options)
        return _response.data


class AsyncUserClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawUserClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawUserClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawUserClient
        """
        return self._raw_client

    async def get_user_integrations(
        self, user_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> GetUserIntegrationsResponse:
        """
        Get all available integrations (MCP server names) by user ID.
        Returns a list of integration names as McpServerName types.

        Parameters
        ----------
        user_id : str
            The external user ID

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetUserIntegrationsResponse
            Successful Response

        Examples
        --------
        import asyncio

        from klavis import AsyncKlavis

        client = AsyncKlavis(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.user.get_user_integrations(
                user_id="userId",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get_user_integrations(user_id, request_options=request_options)
        return _response.data

    async def get_user_by_user_id(
        self, user_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> GetUserResponse:
        """
        Get user information by user_id.

        Parameters
        ----------
        user_id : str
            The identifier for the user to fetch.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetUserResponse
            Successful Response

        Examples
        --------
        import asyncio

        from klavis import AsyncKlavis

        client = AsyncKlavis(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.user.get_user_by_user_id(
                user_id="userId",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get_user_by_user_id(user_id, request_options=request_options)
        return _response.data

    async def delete_user_by_user_id(
        self, user_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> DeleteUserResponse:
        """
        Delete a user and all associated data by user_id.
        Users cannot delete their own accounts.
        This operation will permanently remove all user data.

        Parameters
        ----------
        user_id : str
            The identifier for the user to delete.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DeleteUserResponse
            Successful Response

        Examples
        --------
        import asyncio

        from klavis import AsyncKlavis

        client = AsyncKlavis(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.user.delete_user_by_user_id(
                user_id="userId",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete_user_by_user_id(user_id, request_options=request_options)
        return _response.data

    async def get_all_users(
        self,
        *,
        page_size: typing.Optional[int] = None,
        page_number: typing.Optional[int] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GetAllUsersResponse:
        """
        Retrieve all users that have been created under your account, with support for pagination.

        Parameters
        ----------
        page_size : typing.Optional[int]
            Number of results per page (max 1000)

        page_number : typing.Optional[int]
            Page number to retrieve (starting from 1)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetAllUsersResponse
            Successful Response

        Examples
        --------
        import asyncio

        from klavis import AsyncKlavis

        client = AsyncKlavis(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.user.get_all_users(
                page_size=1,
                page_number=1,
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get_all_users(
            page_size=page_size, page_number=page_number, request_options=request_options
        )
        return _response.data

    async def set_user_auth(
        self,
        *,
        user_id: str,
        server_name: McpServerName,
        auth_data: SetUserAuthRequestAuthData,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> StatusResponse:
        """
        Sets authentication data for a specific integration for a user.

        Accepts either API key authentication or general authentication data.
        This updates the auth_metadata for the specified user's integration instance.

        Parameters
        ----------
        user_id : str
            The unique identifier for the user

        server_name : McpServerName
            The name of the MCP server to set authentication for (e.g., 'GitHub', 'Jira')

        auth_data : SetUserAuthRequestAuthData
            Authentication data

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        StatusResponse
            Successful Response

        Examples
        --------
        import asyncio

        from klavis import ApiKeyAuth, AsyncKlavis, McpServerName

        client = AsyncKlavis(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.user.set_user_auth(
                user_id="userId",
                server_name=McpServerName.AFFINITY,
                auth_data=ApiKeyAuth(),
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.set_user_auth(
            user_id=user_id, server_name=server_name, auth_data=auth_data, request_options=request_options
        )
        return _response.data

    async def get_user_auth(
        self, user_id: str, server_name: McpServerName, *, request_options: typing.Optional[RequestOptions] = None
    ) -> GetUserAuthResponse:
        """
        Retrieves authentication data for a specific integration for a user.

        Returns the authentication data if available, along with authentication status.
        Includes token refresh handling if needed.

        Parameters
        ----------
        user_id : str
            The identifier for the user

        server_name : McpServerName
            The name of the MCP server (e.g., 'GitHub', 'Jira')

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetUserAuthResponse
            Successful Response

        Examples
        --------
        import asyncio

        from klavis import AsyncKlavis, McpServerName

        client = AsyncKlavis(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.user.get_user_auth(
                user_id="userId",
                server_name=McpServerName.AFFINITY,
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get_user_auth(user_id, server_name, request_options=request_options)
        return _response.data

    async def delete_user_auth(
        self, user_id: str, server_name: McpServerName, *, request_options: typing.Optional[RequestOptions] = None
    ) -> StatusResponse:
        """
        Deletes authentication data for a specific integration for a user.

        This will clear the stored authentication credentials, effectively unauthenticating the integration.

        Parameters
        ----------
        user_id : str
            The unique identifier for the user

        server_name : McpServerName
            The name of the MCP server to delete authentication for (e.g., 'github', 'jira')

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        StatusResponse
            Successful Response

        Examples
        --------
        import asyncio

        from klavis import AsyncKlavis, McpServerName

        client = AsyncKlavis(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.user.delete_user_auth(
                user_id="userId",
                server_name=McpServerName.AFFINITY,
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete_user_auth(user_id, server_name, request_options=request_options)
        return _response.data
