# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class WordPressPost(UniversalBaseModel):
    """
    WordPress post data for creation/update

    Attributes:
        title: Post title
        content: Post content (HTML or plain text)
        status: Post status (draft, publish, private, pending)
        excerpt: Post excerpt/summary (optional)
        categories: List of category names (optional, created if not exist)
        tags: List of tag names (optional, created if not exist)
        featured_image: URL to featured image (optional)
        date: Post publish date in ISO format (optional)
        format: Post format (standard, aside, gallery, etc.) (optional)
    """

    title: str = pydantic.Field()
    """
    Post title
    """

    content: str = pydantic.Field()
    """
    Post content (HTML or plain text)
    """

    status: typing.Optional[str] = pydantic.Field(default=None)
    """
    Post status: draft, publish, private, pending, trash
    """

    excerpt: typing.Optional[str] = pydantic.Field(default=None)
    """
    Post excerpt/summary
    """

    categories: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    List of category names
    """

    tags: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    List of tag names
    """

    featured_image: typing.Optional[str] = pydantic.Field(default=None)
    """
    URL to featured image
    """

    date: typing.Optional[str] = pydantic.Field(default=None)
    """
    Post publish date in ISO format (e.g., 2025-01-15T10:00:00)
    """

    format: typing.Optional[str] = pydantic.Field(default=None)
    """
    Post format: standard, aside, gallery, link, image, quote, status, video, audio, chat
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
