# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata


class TimeSlot(UniversalBaseModel):
    """
    Represents a recurring time slot in a schedule.

    Attributes:
        days: List of weekday names (Monday, Tuesday, etc.)
        startTime: Start time in HH:MM format (24-hour)
        endTime: End time in HH:MM format (24-hour)
    """

    days: typing.List[str]
    start_time: typing_extensions.Annotated[str, FieldMetadata(alias="startTime")]
    end_time: typing_extensions.Annotated[str, FieldMetadata(alias="endTime")]

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
