# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata


class TeamsChatMember(UniversalBaseModel):
    """
    Teams Chat Member object
    """

    id: typing.Optional[str] = pydantic.Field(default=None)
    """
    Member ID (read-only, set by Teams)
    """

    display_name: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="displayName")] = (
        pydantic.Field(default=None)
    )
    """
    Member display name
    """

    email: typing.Optional[str] = pydantic.Field(default=None)
    """
    User email for creating chats
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
