# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .teams_chat_member import TeamsChatMember
from .teams_message import TeamsMessage


class TeamsChat(UniversalBaseModel):
    """
    Teams Chat object
    """

    id: typing.Optional[str] = pydantic.Field(default=None)
    """
    Chat ID (read-only, set by Teams)
    """

    members: typing.Optional[typing.List[TeamsChatMember]] = pydantic.Field(default=None)
    """
    List of chat members
    """

    messages: typing.Optional[typing.List[TeamsMessage]] = pydantic.Field(default=None)
    """
    List of messages in the chat
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
