# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata
from .teams_message import TeamsMessage


class TeamsChannel(UniversalBaseModel):
    """
    Teams Channel object
    """

    id: typing.Optional[str] = pydantic.Field(default=None)
    """
    Channel ID (read-only, set by Teams)
    """

    display_name: typing_extensions.Annotated[str, FieldMetadata(alias="displayName")] = pydantic.Field()
    """
    Channel display name
    """

    description: typing.Optional[str] = pydantic.Field(default=None)
    """
    Channel description
    """

    messages: typing.Optional[typing.List[TeamsMessage]] = pydantic.Field(default=None)
    """
    List of messages in the channel
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
